import { PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

export async function companyDetailsSeeder(company_id: number) {
  try {
    // Data for seeding
    const companyDetails = {
      code: 'ZAIN-WH-001',
      name: 'Zain Warehouse',
      registration_number: '123456789',
      tax_idenitification_number: 'TAX-123456',
      address: '1234 Warehouse Street, City, Country',
      phone: '+1234567890',
      email: 'info@zainwarehouse.com',
    };

    // Find the super admin user for the given company
    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    // Check if a super admin exists for the company
    if (!user) {
      console.log(
        `Seeder failed: No admin user found for company id ${company_id}`,
      );
      return false;
    }

    const createdBy = user.id;

    // Check if the company details already exist by code
    const existingCompanyDetails = await prisma.companyDetails.findFirst({
      where: { code: companyDetails.code },
    });

    if (existingCompanyDetails) {
      // Update existing company details
      await prisma.companyDetails.update({
        where: { id: existingCompanyDetails.id },
        data: {
          name: companyDetails.name,
          registration_number: companyDetails.registration_number,
          tax_idenitification_number: companyDetails.tax_idenitification_number,
          address: companyDetails.address,
          phone: companyDetails.phone,
          email: companyDetails.email,
          updated_by: createdBy,
        },
      });
      console.log(`Updated companyDetails with name: ${companyDetails.name}`);
    } else {
      // Create new company details
      await prisma.companyDetails.create({
        data: {
          code: companyDetails.code,
          name: companyDetails.name,
          registration_number: companyDetails.registration_number,
          tax_idenitification_number: companyDetails.tax_idenitification_number,
          address: companyDetails.address,
          phone: companyDetails.phone,
          email: companyDetails.email,
          created_by: createdBy,
        },
      });
      console.log(`Created companyDetails with name: ${companyDetails.name}`);
    }
  } catch (error) {
    console.error(`Error in companyDetailsSeeder: ${error}`);
    throw error;
  } finally {
    // Disconnect Prisma Client to close the connection
    // await prisma.$disconnect();
  }
}
