
-- Ensure the table uses citext and stores in uppercase
CREATE OR REPLACE FUNCTION enforce_uppercase()
RETURNS TRIGGER AS $$
BEGIN
    NEW.name := UPPER(NEW.name);  -- Convert to uppercase before storing
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

-- Attach the trigger to item_actions table
CREATE TRIGGER item_actions_uppercase_trigger
BEFORE INSERT OR UPDATE ON item_actions
FOR EACH ROW
EXECUTE FUNCTION enforce_uppercase();


-- Function to convert name to uppercase before storing
CREATE OR REPLACE FUNCTION enforce_uppercase_item_condition()
RETURNS TRIGGER AS $$
BEGIN
    NEW.name := UPPER(NEW.name);
    RETURN NEW;
END;
$$ LANGUAGE plpgsql;

-- Attach the trigger to item_conditions table
CREATE TRIGGER item_conditions_uppercase_trigger
BEFORE INSERT OR UPDATE ON item_conditions
FOR EACH ROW
EXECUTE FUNCTION enforce_uppercase_item_condition();


+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

CREATE OR REPLACE FUNCTION set_storage_age_to_zero()
RETURNS TRIGGER AS $$
BEGIN
  IF NEW.storage_age IS NULL THEN
    NEW.storage_age := 0;
  END IF;
  RETURN NEW;
END;
$$ LANGUAGE plpgsql;



-- Trigger for mtr_line_items
CREATE TRIGGER trg_set_storage_age_to_zero_mtr
BEFORE INSERT ON mtr_line_items
FOR EACH ROW
EXECUTE FUNCTION set_storage_age_to_zero();

-- Trigger for mrn_line_items
CREATE TRIGGER trg_set_storage_age_to_zero_mrn
BEFORE INSERT ON mrn_line_items
FOR EACH ROW
EXECUTE FUNCTION set_storage_age_to_zero();
