import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function VendorSeeder(company_id: number) {
  try {
    const rows = JSON.parse(
      fs.readFileSync(__dirname + '/json/vendor-seeds.json', 'utf-8'),
    );

    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    if (!user?.id) {
      throw new Error('Super admin user not found!');
    }

    for (const row of rows) {
      // Check if the ItemType already exists by its name and company_id
      const existingvendors = await prisma.vendors.findUnique({
        where: { company_id_name: { company_id, name: row.name } }, // Assuming 'name' as code for vendors
      });

      if (existingvendors) {
        // Update the vendors if it already exists
        await prisma.vendors.update({
          where: { id: existingvendors.id },
          data: {
            name: row.name,
            status_id: row.status_id || 1, // Default to active status if not provided
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Updated vendors with name ${row.name}`);
      } else {
        // Create a new vendors if it doesn't exist
        await prisma.vendors.create({
          data: {
            name: row.name,
            company_id,
            status_id: row.status_id || 1, // Default to active status if not provided
            created_by: user.id, // Ensure created_by is assigned
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Created vendors with name ${row.name}`);
      }
    }
  } catch (error) {
    console.error(`Error in VendorSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
