"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,t,i,r){void 0===r&&(r=i);var n=Object.getOwnPropertyDescriptor(t,i);n&&!("get"in n?!t.__esModule:n.writable||n.configurable)||(n={enumerable:!0,get:function(){return t[i]}}),Object.defineProperty(e,r,n)}:function(e,t,i,r){void 0===r&&(r=i),e[r]=t[i]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,t){Object.defineProperty(e,"default",{enumerable:!0,value:t})}:function(e,t){e.default=t}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var t={};if(null!=e)for(var i in e)"default"!==i&&Object.prototype.hasOwnProperty.call(e,i)&&__createBinding(t,e,i);return __setModuleDefault(t,e),t},__awaiter=this&&this.__awaiter||function(e,t,i,r){return new(i||(i=Promise))((function(n,o){function a(e){try{c(r.next(e))}catch(e){o(e)}}function s(e){try{c(r.throw(e))}catch(e){o(e)}}function c(e){var t;e.done?n(e.value):(t=e.value,t instanceof i?t:new i((function(e){e(t)}))).then(a,s)}c((r=r.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.DataSyncService=void 0;const prisma_service_1=__importDefault(require("./prisma.service")),client_1=require("@prisma/sqlite/client"),config_1=require("../../config"),fs=__importStar(require("fs")),path=__importStar(require("path")),archiver_1=__importDefault(require("archiver")),unzipper_1=__importDefault(require("unzipper")),isDev="development"==process.env.NODE_ENV;class DataSyncService{constructor(){this.sqliteDBPath=isDev?path.join(__dirname,"../../../prisma/sqlite/","lcp.db"):path.join(__dirname,"../../prisma/sqlite/","lcp.db"),this.publicPaths={push:path.join(__dirname,"../../public/mobile_db/push/"),uploads:path.join(__dirname,"../../public/mobile_db/uploads/"),pull:path.join(__dirname,"../../public/mobile_db/pull/"),temp:path.join(__dirname,"../../public/mobile_db/temp/")},this.ensureDirectoriesExist()}ensureDirectoriesExist(){Object.values(this.publicPaths).forEach((e=>{fs.existsSync(e)||fs.mkdirSync(e,{recursive:!0})}))}pushDataToSQLite(e,t){return __awaiter(this,void 0,void 0,(function*(){let i,r;try{const n=yield prisma_service_1.default.deviceRegistration.findFirst({where:{device_unique_id:t},select:{user_id:!0}});if(!(null==n?void 0:n.user_id))throw new Error(`Device with ID ${t} not found.`);const o=yield prisma_service_1.default.userDetail.findFirst({where:{user_id:n.user_id},select:{code:!0}});if(!(null==o?void 0:o.code))throw new Error(`User with ID ${n.user_id} not found.`);const a=(new Date).toISOString().replace(/[:T.-]/g,"_"),s=`${config_1.dbDetails.mobile_db_name}__${o.code}__${a}`,c=`${s}.db`;r=path.join(this.publicPaths.push,c),fs.copyFileSync(this.sqliteDBPath,r),console.log("SQLite DB file copied to:",r),i=new client_1.PrismaClient({datasources:{db:{url:`file:${r}`}}}),yield i.$connect();const l=yield prisma_service_1.default.dataTransferQueries.findMany({where:{transfer_type:"Push"},orderBy:{execution_order:"asc"}});yield i.$transaction((e=>__awaiter(this,void 0,void 0,(function*(){for(const t of l){console.log(`Exporting ${t.job_name}...`);const i=t.select_query.replace("$userid",n.user_id.toString()),r=yield prisma_service_1.default.$queryRawUnsafe(i);if(r.length>0){t.clear_destination_table&&(yield e.$executeRawUnsafe(`DELETE FROM ${t.destination_table}`));for(const i of r){const r=Object.fromEntries(Object.entries(i).map((([e,t])=>[e,Array.isArray(t)?t.join(","):t])));yield e.$executeRawUnsafe(t.insert_query,...Object.values(r))}console.log(`${r.length} ${t.job_name}(s) Exported.`)}else console.log(`No data found to export for ${t.job_name}.`)}}))));yield this.zipFile(r,s);return`${e}mobile_db/push/${s}.zip`}catch(e){throw console.error("Failed to push data to SQLite:",e),e}}))}zipFile(e,t){return __awaiter(this,void 0,void 0,(function*(){const i=`${t}.zip`,r=path.join(this.publicPaths.push,i);return new Promise(((i,n)=>{const o=fs.createWriteStream(r),a=(0,archiver_1.default)("zip",{zlib:{level:9}});o.on("close",(()=>i(r))),a.on("error",n),a.pipe(o),a.file(e,{name:`${t}.db`}),a.finalize()}))}))}generateUniqueFileName(e){return`lcp_${e}_${(new Date).toISOString().replace(/[:T.-]/g,"_")}.db`}extractZipFile(e,t){return __awaiter(this,void 0,void 0,(function*(){return new Promise(((i,r)=>{const n=path.join(this.publicPaths.temp,"extract");fs.existsSync(n)&&fs.rmSync(n,{recursive:!0}),fs.mkdirSync(n,{recursive:!0});const o=this.generateUniqueFileName(t),a=path.join(this.publicPaths.pull,o);fs.createReadStream(e).pipe(unzipper_1.default.Extract({path:n})).on("close",(()=>{try{const e=fs.readdirSync(n).find((e=>e.endsWith(".db")));if(!e)return void r(new Error("No database file found in the zip."));fs.copyFileSync(path.join(n,e),a),fs.rmSync(n,{recursive:!0}),i(a)}catch(e){r(e)}})).on("error",(e=>{r(e)}))}))}))}pullDataToPostgres(e){return __awaiter(this,void 0,void 0,(function*(){let t,i;try{const r=e.name.split("__")[1];if(!r)throw new Error("Invalid file name format. Expected user code in filename.");if(t=path.join(this.publicPaths.temp,`temp_${Date.now()}${path.extname(e.name)}`),yield e.mv(t),"application/zip"===e.mimetype||e.name.endsWith(".zip"))i=yield this.extractZipFile(t,r);else{const e=this.generateUniqueFileName(r);i=path.join(this.publicPaths.pull,e),fs.copyFileSync(t,i)}if(!i||!fs.existsSync(i))throw new Error("Failed to process database file");let n=new client_1.PrismaClient({datasources:{db:{url:`file:${i}`}}});const o=yield prisma_service_1.default.userDetail.findFirst({where:{code:r},select:{user_id:!0}});if(!o)throw new Error(`User with code ${r} not found.`);yield n.$connect(),console.log("SQLite connection established");const a=yield prisma_service_1.default.dataTransferQueries.findMany({where:{transfer_type:"Pull"},orderBy:{execution_order:"asc"}});return yield prisma_service_1.default.$transaction((e=>__awaiter(this,void 0,void 0,(function*(){for(const t of a){let i=t.select_query.replace("$userid",o.user_id.toString());const r=yield n.$queryRawUnsafe(i);if(r.length>0){t.clear_destination_table&&(yield e.$executeRawUnsafe(`DELETE FROM ${t.destination_table}`));for(const i of r){const r=Object.fromEntries(Object.entries(i).map((([e,t])=>[e,Array.isArray(t)?t.join(","):t]))),n=Object.keys(r),o=Object.values(r);if(t.insert_query.includes("ON CONFLICT"))yield e.$executeRawUnsafe(t.insert_query,...o);else{if(n.includes("uuid")){const i=n.map(((e,t)=>"uuid"===e?`CAST($${t+1} AS uuid)`:`$${t+1}`)).join(", "),r=n.indexOf("uuid");if(!(yield e.$executeRawUnsafe(`SELECT uuid FROM ${t.destination_table} WHERE uuid = CAST($1 AS uuid)`,o[r]))){const r=`INSERT INTO ${t.destination_table} (${n.join(", ")}) VALUES (${i})`;yield e.$executeRawUnsafe(r,...o)}}else{const i=n.map(((e,t)=>`$${t+1}`)).join(", "),r=`INSERT INTO ${t.destination_table} (${n.join(", ")}) VALUES (${i})`;yield e.$executeRawUnsafe(r,...o)}}}console.log(`${r.length} ${t.job_name}(s) Imported.`)}}})))),!0}catch(e){throw console.error("Failed to pull data from SQLite:",e),e}finally{try{t&&fs.existsSync(t)&&(fs.unlinkSync(t),console.log("Temporary file cleaned up:",t));const e=path.join(this.publicPaths.temp,"extract");fs.existsSync(e)&&(fs.rmSync(e,{recursive:!0}),console.log("Temporary extract directory cleaned up:",e))}catch(e){console.error("Error during cleanup:",e)}}}))}}exports.DataSyncService=DataSyncService;