DROP TRIGGER IF EXISTS execute_approval_process_job_trigger ON public.approval_process_job_workflows;

CREATE TRIGGER execute_approval_process_job_trigger
AFTER UPDATE OF review_status
ON public.approval_process_job_workflows
FOR EACH ROW
WHEN (
  OLD.review_status IS DISTINCT FROM NEW.review_status
  AND NEW.review_status IN (
    'approval_completed'::public."ApprovalStatus",
    'approval_rejected'::public."ApprovalStatus"
  )
)
EXECUTE FUNCTION public.execute_approval_process_job();