import { PrismaClient } from '@prisma/sql/client'

const prisma = new PrismaClient();

const wizardTypes = [
  { id: 1, name: 'static', description: 'Static' },
  { id: 2, name: 'chart', description: 'Chart' },
];

export async function wizardTypeSeeder(company_id: number) {
  try {
    console.log("🚀 Starting WizardType Seeder...");

    await prisma.$transaction(async (tx) => {
      for (const wizardType of wizardTypes) {
        const existingWizardType = await tx.wizardType.findUnique({
          where: { id: wizardType.id },
        });

        if (!existingWizardType) {
          // ✅ Use raw SQL for inserting records
          await tx.$executeRawUnsafe(`
            SET IDENTITY_INSERT wizard_types ON;
            INSERT INTO wizard_types (id, name, description, company_id) 
            VALUES (${wizardType.id}, '${wizardType.name}', '${wizardType.description}', ${company_id});
            SET IDENTITY_INSERT wizard_types OFF;
          `);
          console.log(`✅ Created WizardType with id ${wizardType.id}: ${wizardType.name}`);
        } else {
          console.log(`🔄 WizardType with id ${wizardType.id} already exists.`);
        }
      }
    });

    console.log("✅ WizardType seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in wizardTypeSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
