import { PrismaClient } from '@prisma/sql/client';
import bcrypt from 'bcryptjs';

const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

const SUPER_ADMIN_SECRET = process.env.JWT_SECRET || 'secret';

async function initPassword(plainPassword: string, role: string): Promise<string> {
  if (role === 'super_admin') {
    const combinedPassword = `${plainPassword}:${SUPER_ADMIN_SECRET}`;
    const salt = await bcrypt.genSalt(12);
    return await bcrypt.hash(combinedPassword, salt);
  } else {
    return await bcrypt.hash(plainPassword, 10);
  }
}

const sAdmins = [
  { email: 'karthickn@techcedence.com', username: 'sadmin', password: 'SAdmin@123#', role: 'super_admin', code: '1000', first_name: 'Karthick', last_name: 'SA' },
  { email: 'praveenk@techcedence.com', username: 'praveen', password: 'Test@123', role: 'company_admin', code: '1001', first_name: 'Praveen', last_name: 'CA' },
  { email: 'mukeshm@techcedence.com', username: 'mukesh', password: 'Test@123', role: 'admin', code: '1002', first_name: 'Mukesh', last_name: 'Manager' },
  { email: 'rajkumars@techcedence.com', username: 'raj', password: 'Test@123', role: 'admin', code: '1003', first_name: 'Raj', last_name: 'Supervisor' },
  { email: 'saravanak@techcedence.com', username: 'saravanak', password: 'Test@123', role: 'super_admin', code: '1004', first_name: 'Saravana', last_name: 'SA' },
  { email: 'venkatesha@techcedence.com', username: 'venkat', password: 'Test@123', role: 'company_admin', code: '1005', first_name: 'Venkat', last_name: 'CA' },
  { email: 'mukeshmtechcedence@gmail.com', username: 'mukeshmtechcedence', password: 'Test@123', role: 'admin', code: '1006', first_name: 'Mukesh', last_name: 'SupportAgent' },
];

export async function usersSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Users Seeder...");
    const utcNow = getCurrentUtcTime();

    await prisma.$transaction(async (tx) => {

      for (const admin of sAdmins) {
        let user = await tx.user.findUnique({
          where: {
            company_id_username: { company_id, username: admin.username },
          },
        });

        if (user) {
          user = await tx.user.update({
            where: { id: user.id },
            data: {
              email: admin.email,
              username: admin.username,
              password: await initPassword(admin.password, admin.role),
              role: admin.role, // Stored as String (SQL Server does not support Enums)
              updated_by: user.id,
              updated_at: utcNow,
            },
          });
          console.log(`🔄 User updated successfully: ${user.username}`);
        } else {
          // ✅ Use raw SQL for inserting records
          await tx.$executeRawUnsafe(`
            INSERT INTO users (uuid, email, username, password, role, company_id, created_at, updated_at) 
            VALUES (NEWID(), '${admin.email}', '${admin.username}', '${await initPassword(admin.password, admin.role)}', '${admin.role}', ${company_id}, '${utcNow}', '${utcNow}');
          `);

          let newUser = await tx.user.findUnique({
            where: { company_id_username: { company_id, username: admin.username } },
          });

          if (newUser) {
            await tx.$executeRawUnsafe(`
              INSERT INTO user_details (user_id, code, first_name, last_name, company_id, created_by, updated_by, created_at, updated_at) 
              VALUES (${newUser.id}, '${admin.code}', '${admin.first_name}', '${admin.last_name}', ${company_id}, ${newUser.id}, ${newUser.id}, '${utcNow}', '${utcNow}');
            `);
          }

          console.log(`✅ User created successfully: ${admin.username}`);
        }
      }
    });

    console.log("✅ Users seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in usersSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
