import { PrismaClient } from '@prisma/sql/client'
import fs from 'fs';
import path from 'path';
const prisma = new PrismaClient();

export async function documentSequenceSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Document Sequence Seeder...");

    const rows = JSON.parse(
        fs.readFileSync(path.join(__dirname, 'json/document-sequence-seeds.json'), 'utf-8')
    );

    const user = await prisma.user.findFirst({
        where: { company_id: company_id, role: 'super_admin' },
    });

    await prisma.$transaction(async (tx) => {
      for (const row of rows) {
        const financialYear = await tx.financialYear.findFirst({
          where: { company_id: company_id, code: row.financial_year },
        });

        if (financialYear) {
          delete row.financial_year;

          const existingRecord = await tx.documentSequence.findFirst({
            where: { company_id: company_id, financial_year_id: financialYear.id, module_name: row.module_name },
          });

          if (existingRecord) {
            // ✅ Update existing record
            await tx.$executeRawUnsafe(`
              UPDATE document_sequences 
              SET code_format = '${row.code_format}',
                  updated_by = ${user?.id}
              WHERE company_id = ${company_id} 
                AND financial_year_id = ${financialYear.id} 
                AND module_name = '${row.module_name}';
            `);
            console.log(`🔄 Updated Document Sequence: ${row.module_name}`);
          } else {
            // ✅ Insert new record
            await tx.$executeRawUnsafe(`
              INSERT INTO document_sequences (code_format, module_name, financial_year_id, company_id, created_by, updated_by) 
              VALUES (
                '${row.code_format}', 
                '${row.module_name}', 
                ${financialYear.id}, 
                ${company_id}, 
                ${user?.id}, 
                ${user?.id}
              );
            `);
            console.log(`✅ Created Document Sequence: ${row.module_name}`);
          }
        }
      }
    });

    console.log("✅ Document Sequence Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ Error in documentSequenceSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
