BEGIN TRY

BEGIN TRAN;

-- CreateTable
CREATE TABLE [dbo].[users] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [users_uuid_df] DEFAULT uuid_generate_v4(),
    [username] VARCHAR(100) NOT NULL,
    [email] VARCHAR(100) NOT NULL,
    [email_verified] VARCHAR(50) NOT NULL,
    [password] VARCHAR(255),
    [status_id] INT NOT NULL,
    [role] VARCHAR(50) NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [users_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [users_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    [last_login] DATETIME2,
    [last_login_device] VARCHAR(100),
    CONSTRAINT [users_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [users_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [users_company_id_email_role_key] UNIQUE NONCLUSTERED ([company_id],[email],[role]),
    CONSTRAINT [users_company_id_username_key] UNIQUE NONCLUSTERED ([company_id],[username]),
    CONSTRAINT [users_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[user_details] (
    [id] INT NOT NULL IDENTITY(1,1),
    [user_id] INT NOT NULL,
    [code] VARCHAR(100) NOT NULL,
    [first_name] VARCHAR(100) NOT NULL,
    [last_name] VARCHAR(100),
    [designation_id] INT,
    [department_id] INT,
    [profile_pic] VARCHAR(255),
    [dob] DATE,
    [country_code] VARCHAR(100),
    [phone_number] VARCHAR(100),
    [gender] VARCHAR(50) NOT NULL,
    [user_time_zone] VARCHAR(100),
    [address] VARCHAR(255),
    [culture] VARCHAR(100),
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [user_details_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [user_details_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [user_details_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [user_details_company_id_user_id_key] UNIQUE NONCLUSTERED ([company_id],[user_id]),
    CONSTRAINT [user_details_company_id_code_key] UNIQUE NONCLUSTERED ([company_id],[code])
);

-- CreateTable
CREATE TABLE [dbo].[designations] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [designations_uuid_df] DEFAULT uuid_generate_v4(),
    [code] VARCHAR(100) NOT NULL,
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(max),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [designations_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [designations_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [designations_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [designations_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [designations_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [designations_company_id_code_key] UNIQUE NONCLUSTERED ([company_id],[code])
);

-- CreateTable
CREATE TABLE [dbo].[departments] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [departments_uuid_df] DEFAULT uuid_generate_v4(),
    [code] VARCHAR(100) NOT NULL,
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(max),
    [status_id] INT NOT NULL,
    [department_head_id] INT,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [departments_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [departments_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [departments_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [departments_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [departments_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [departments_company_id_code_key] UNIQUE NONCLUSTERED ([company_id],[code])
);

-- CreateTable
CREATE TABLE [dbo].[request_logs] (
    [id] BIGINT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [request_logs_uuid_df] DEFAULT uuid_generate_v4(),
    [user_id] INT,
    [req_method] VARCHAR(100),
    [req_url] VARCHAR(255),
    [req_body] VARCHAR(max),
    [res_status] VARCHAR(50) NOT NULL,
    [res_code] VARCHAR(50) NOT NULL,
    [res_message] VARCHAR(max),
    [req_response] VARCHAR(max),
    [req_headers] VARCHAR(max),
    [req_ip] VARCHAR(255),
    [req_device] VARCHAR(255),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [request_logs_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [request_logs_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [request_logs_pkey] PRIMARY KEY CLUSTERED ([id])
);

-- CreateTable
CREATE TABLE [dbo].[financial_years] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [financial_years_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [code] VARCHAR(100) NOT NULL,
    [is_freezed] VARCHAR(50) NOT NULL,
    [start_date] DATETIME2 NOT NULL,
    [end_date] DATETIME2 NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [financial_years_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [financial_years_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [financial_years_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [financial_years_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [financial_years_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [financial_years_company_id_code_key] UNIQUE NONCLUSTERED ([company_id],[code])
);

-- CreateTable
CREATE TABLE [dbo].[document_sequences] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [document_sequences_uuid_df] DEFAULT uuid_generate_v4(),
    [module_name] VARCHAR(100) NOT NULL,
    [financial_year_id] INT,
    [current_sequence_no] VARCHAR(50) NOT NULL,
    [start_sequence_no] VARCHAR(50) NOT NULL,
    [end_sequence_no] VARCHAR(50) NOT NULL,
    [sequence_length] VARCHAR(50) NOT NULL,
    [status_id] INT NOT NULL,
    [code_format] VARCHAR(100),
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [document_sequences_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [document_sequences_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [document_sequences_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [document_sequences_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [document_sequences_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [document_sequences_company_id_financial_year_id_module_name_key] UNIQUE NONCLUSTERED ([company_id],[financial_year_id],[module_name])
);

-- CreateTable
CREATE TABLE [dbo].[audit_logs] (
    [id] INT NOT NULL IDENTITY(1,1),
    [operation_type] VARCHAR(10) NOT NULL,
    [table_name] VARCHAR(100) NOT NULL,
    [field_name] VARCHAR(100) NOT NULL,
    [old_value] VARCHAR(max),
    [new_value] VARCHAR(max),
    [entity_id] INT NOT NULL,
    [user_id] INT,
    [status_id] INT NOT NULL,
    [company_id] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [audit_logs_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [audit_logs_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [audit_logs_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[permissions] (
    [id] INT NOT NULL IDENTITY(1,1),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100) NOT NULL,
    [entity_id] INT,
    [order_no] DECIMAL(4,2) NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [permissions_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [permissions_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [permissions_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug]),
    CONSTRAINT [permissions_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[roles] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [roles_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(max),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [roles_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [roles_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [roles_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [roles_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [roles_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [roles_company_id_name_key] UNIQUE NONCLUSTERED ([company_id],[name])
);

-- CreateTable
CREATE TABLE [dbo].[role_permissions] (
    [role_id] INT NOT NULL,
    [permission_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [role_permissions_pkey] PRIMARY KEY CLUSTERED ([company_id],[role_id],[permission_id])
);

-- CreateTable
CREATE TABLE [dbo].[user_roles] (
    [user_id] INT NOT NULL,
    [role_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [user_roles_pkey] PRIMARY KEY CLUSTERED ([company_id],[user_id],[role_id])
);

-- CreateTable
CREATE TABLE [dbo].[user_permissions] (
    [user_id] INT NOT NULL,
    [permission_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [user_permissions_pkey] PRIMARY KEY CLUSTERED ([company_id],[user_id],[permission_id])
);

-- CreateTable
CREATE TABLE [dbo].[otps] (
    [id] INT NOT NULL IDENTITY(1,1),
    [user_id] INT NOT NULL,
    [otp] VARCHAR(8) NOT NULL,
    [purpose] VARCHAR(50) NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [otps_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [otps_pkey] PRIMARY KEY CLUSTERED ([id])
);

-- CreateTable
CREATE TABLE [dbo].[languages] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [languages_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [name_in_english] VARCHAR(100),
    [flag] VARCHAR(10),
    [code] VARCHAR(10),
    [rtl] VARCHAR(50) NOT NULL,
    [description] VARCHAR(max) NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [languages_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [languages_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [languages_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [languages_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [languages_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid]),
    CONSTRAINT [languages_company_id_code_key] UNIQUE NONCLUSTERED ([company_id],[code])
);

-- CreateTable
CREATE TABLE [dbo].[language_contents] (
    [id] INT NOT NULL IDENTITY(1,1),
    [language_id] INT NOT NULL,
    [key_content] VARCHAR(100) NOT NULL,
    [values] VARCHAR(100) NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [language_contents_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [language_contents_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [language_contents_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[menu] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [menu_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(255),
    [description] VARCHAR(100),
    [menu_type] INT NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [menu_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [menu_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [menu_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [menu_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [menu_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid])
);

-- CreateTable
CREATE TABLE [dbo].[menu_items] (
    [id] INT NOT NULL IDENTITY(1,1),
    [menu_id] INT NOT NULL,
    [name] VARCHAR(100) NOT NULL,
    [target] VARCHAR(255),
    [parent_id] INT,
    [permission_id] INT,
    [entity_id] INT,
    [link_type] INT,
    [order_no] DECIMAL(4,2) NOT NULL,
    [menu_img] VARCHAR(255),
    [short_cut_keys] VARCHAR(255),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [menu_items_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [menu_items_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [menu_items_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [menu_items_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [menu_items_company_id_menu_id_name_key] UNIQUE NONCLUSTERED ([company_id],[menu_id],[name])
);

-- CreateTable
CREATE TABLE [dbo].[action_types] (
    [id] INT NOT NULL IDENTITY(1,1),
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(255) NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [action_types_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [action_types_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[entity_types] (
    [id] INT NOT NULL IDENTITY(1,1),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100) NOT NULL,
    [description] VARCHAR(255) NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [entity_types_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [entity_types_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[wizard_group] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [wizard_group_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100),
    [description] VARCHAR(100),
    [status_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [wizard_group_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [company_id] INT NOT NULL,
    CONSTRAINT [wizard_group_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [wizard_group_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [wizard_group_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug])
);

-- CreateTable
CREATE TABLE [dbo].[wizard_types] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [wizard_types_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(100),
    [company_id] INT NOT NULL,
    CONSTRAINT [wizard_types_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [wizard_types_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [wizard_types_company_id_name_key] UNIQUE NONCLUSTERED ([company_id],[name])
);

-- CreateTable
CREATE TABLE [dbo].[master_entities] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [master_entities_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [entity_name] VARCHAR(100) NOT NULL,
    [entity_type] VARCHAR(100) NOT NULL,
    [primary_table] VARCHAR(100),
    [is_admin_module] VARCHAR(50) NOT NULL,
    [associated_tables] VARCHAR(max),
    [query_information] VARCHAR(max),
    [form_information] VARCHAR(max),
    [add_query_information] VARCHAR(max),
    [edit_query_information] VARCHAR(max),
    [preset_query_information] VARCHAR(max),
    [static_page_content] VARCHAR(max),
    [export_template_id] INT,
    [dashboard_wizard_group_id] INT,
    [dashboard_wizard_type] VARCHAR(100),
    [dashboard_wizard_rows] INT,
    [dashboard_wizard_columns] INT,
    [dashboard_wizard_order_no] DECIMAL(4,2) CONSTRAINT [master_entities_dashboard_wizard_order_no_df] DEFAULT 0,
    [dashboard_wizard_options] VARCHAR(max),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [master_entities_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [master_entities_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [master_entities_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [master_entities_company_id_entity_name_key] UNIQUE NONCLUSTERED ([company_id],[entity_name])
);

-- CreateTable
CREATE TABLE [dbo].[master_entity_line_items] (
    [id] INT NOT NULL IDENTITY(1,1),
    [master_grid_id] INT NOT NULL,
    [field_name] VARCHAR(255) NOT NULL,
    [display_name] VARCHAR(100) NOT NULL,
    [order_no] DECIMAL(4,2) NOT NULL,
    [is_grid_column] VARCHAR(50) NOT NULL,
    [is_searchable] VARCHAR(50) NOT NULL,
    [clause_type] VARCHAR(50) NOT NULL,
    [is_sortable] VARCHAR(50) NOT NULL,
    [field_type_id] INT NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [master_entity_line_items_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [master_entity_line_items_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [master_entity_line_items_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [master_entity_line_items_company_id_master_grid_id_field_name_display_name_key] UNIQUE NONCLUSTERED ([company_id],[master_grid_id],[field_name],[display_name])
);

-- CreateTable
CREATE TABLE [dbo].[field_types] (
    [id] INT NOT NULL IDENTITY(1,1),
    [field_type] VARCHAR(100) NOT NULL,
    [company_id] INT NOT NULL,
    [status_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [field_types_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [field_types_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [field_types_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[menu_types] (
    [id] INT NOT NULL IDENTITY(1,1),
    [name] VARCHAR(100),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [menu_types_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [menu_types_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [menu_types_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[email_template_process] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [email_template_process_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100) NOT NULL,
    [query_information] VARCHAR(max),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [email_template_process_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [email_template_process_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [email_template_process_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug]),
    CONSTRAINT [email_template_process_id_company_id_key] UNIQUE NONCLUSTERED ([id],[company_id])
);

-- CreateTable
CREATE TABLE [dbo].[email_template_tags] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [email_template_tags_uuid_df] DEFAULT uuid_generate_v4(),
    [slug] VARCHAR(100) NOT NULL,
    [name] VARCHAR(100),
    [description] VARCHAR(max),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [email_template_tags_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [email_template_tags_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [email_template_tags_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug])
);

-- CreateTable
CREATE TABLE [dbo].[email_template_recipient_tags] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [email_template_recipient_tags_uuid_df] DEFAULT uuid_generate_v4(),
    [slug] VARCHAR(100) NOT NULL,
    [name] VARCHAR(100),
    [description] VARCHAR(max),
    [query_information] VARCHAR(max),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [email_template_recipient_tags_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [email_template_recipient_tags_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [email_template_recipient_tags_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug])
);

-- CreateTable
CREATE TABLE [dbo].[email_template_process_tags_mapping] (
    [email_template_process_id] INT NOT NULL,
    [email_template_tag_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    CONSTRAINT [email_template_process_tags_mapping_pkey] PRIMARY KEY CLUSTERED ([email_template_process_id],[email_template_tag_id],[company_id])
);

-- CreateTable
CREATE TABLE [dbo].[email_templates] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [email_templates_uuid_df] DEFAULT uuid_generate_v4(),
    [slug] VARCHAR(100) NOT NULL,
    [name] VARCHAR(100) NOT NULL,
    [subject] VARCHAR(255) NOT NULL,
    [template_body] VARCHAR(max) NOT NULL,
    [email_template_process_id] INT NOT NULL,
    [status_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [email_templates_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [created_by] INT,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [email_templates_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_by] INT,
    [deleted_at] DATETIME2,
    [deleted_by] INT,
    [company_id] INT NOT NULL,
    CONSTRAINT [email_templates_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [email_templates_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [email_templates_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug])
);

-- CreateTable
CREATE TABLE [dbo].[email_template_assignments] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [email_template_assignments_uuid_df] DEFAULT uuid_generate_v4(),
    [email_template_process_id] INT NOT NULL,
    [template_id] INT NOT NULL,
    [recipient_type] VARCHAR(50) NOT NULL,
    [email_to] VARCHAR(100),
    [mail_cc] VARCHAR(max),
    [mail_bcc] VARCHAR(max),
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [email_template_assignments_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [created_by] INT NOT NULL,
    CONSTRAINT [email_template_assignments_pkey] PRIMARY KEY CLUSTERED ([id])
);

-- CreateTable
CREATE TABLE [dbo].[email_process_jobs] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [email_process_jobs_uuid_df] DEFAULT uuid_generate_v4(),
    [email_template_process_slug] VARCHAR(100) NOT NULL,
    [unique_id] VARCHAR(100) NOT NULL,
    [user_id] INT NOT NULL,
    [prefill_data] VARCHAR(max),
    [company_id] INT NOT NULL,
    [status_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [email_process_jobs_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [created_by] INT,
    CONSTRAINT [email_process_jobs_pkey] PRIMARY KEY CLUSTERED ([id])
);

-- CreateTable
CREATE TABLE [dbo].[notification_jobs] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [notification_jobs_uuid_df] DEFAULT uuid_generate_v4(),
    [process_slug] VARCHAR(100) NOT NULL,
    [notification_to] VARCHAR(max),
    [notification_subject] VARCHAR(100),
    [notification_content] VARCHAR(max),
    [notification_cc] VARCHAR(100),
    [notification_bcc] VARCHAR(100),
    [notification_type_id] VARCHAR(10) NOT NULL,
    [notification_status_id] VARCHAR(10) NOT NULL,
    [company_id] INT NOT NULL,
    [status_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [notification_jobs_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [created_by] INT,
    [sent_at] DATETIME2,
    [read_at] DATETIME2,
    CONSTRAINT [notification_jobs_pkey] PRIMARY KEY CLUSTERED ([id])
);

-- CreateTable
CREATE TABLE [dbo].[import_templates] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [import_templates_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100) NOT NULL,
    [description] VARCHAR(100),
    [max_row_count] VARCHAR(50) NOT NULL,
    [header_row] VARCHAR(50) NOT NULL,
    [data_start_row] VARCHAR(50) NOT NULL,
    [data_end_row] VARCHAR(50) NOT NULL,
    [ignore_error_rows] VARCHAR(50) NOT NULL,
    [is_admin_module] VARCHAR(50) NOT NULL,
    [job_type] NVARCHAR(1000) CONSTRAINT [import_templates_job_type_df] DEFAULT 'direct',
    [batch_process_count] INT CONSTRAINT [import_templates_batch_process_count_df] DEFAULT 50,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [import_templates_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_by] INT,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [import_templates_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_by] INT,
    [deleted_at] DATETIME2,
    CONSTRAINT [import_templates_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [import_templates_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [import_templates_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug])
);

-- CreateTable
CREATE TABLE [dbo].[import_template_line_items] (
    [id] INT NOT NULL IDENTITY(1,1),
    [import_template_id] INT NOT NULL,
    [field_name] VARCHAR(255) NOT NULL,
    [display_name] VARCHAR(100) NOT NULL,
    [field_table] VARCHAR(100) NOT NULL,
    [order_no] DECIMAL(4,2) NOT NULL,
    [width] INT CONSTRAINT [import_template_line_items_width_df] DEFAULT 0,
    [default_value] VARCHAR(100),
    [check_reg_exp] VARCHAR(255),
    [is_nullable] VARCHAR(50) NOT NULL,
    [is_unique] VARCHAR(50) NOT NULL,
    [is_foreign] VARCHAR(50) NOT NULL,
    [unique_query] VARCHAR(max),
    [foreign_query] VARCHAR(max),
    [is_enum] VARCHAR(50) NOT NULL,
    [is_multiple] VARCHAR(50) NOT NULL,
    [enum_values] VARCHAR(100),
    [foreign_table] VARCHAR(100),
    [foreign_column] VARCHAR(100),
    [foreign_can_create] VARCHAR(50) NOT NULL,
    [is_individual] VARCHAR(50) NOT NULL,
    [individual_column] VARCHAR(20),
    [field_type_id] INT,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [import_template_line_items_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [import_template_line_items_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [import_template_line_items_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [import_template_line_items_company_id_import_template_id_field_table_field_name_key] UNIQUE NONCLUSTERED ([company_id],[import_template_id],[field_table],[field_name]),
    CONSTRAINT [import_template_line_items_company_id_import_template_id_display_name_key] UNIQUE NONCLUSTERED ([company_id],[import_template_id],[display_name])
);

-- CreateTable
CREATE TABLE [dbo].[import_template_queries] (
    [id] INT NOT NULL IDENTITY(1,1),
    [import_template_id] INT NOT NULL,
    [query_string] VARCHAR(max),
    [query_name] VARCHAR(255) NOT NULL,
    [allow_multiple] VARCHAR(50) NOT NULL,
    [is_individual] VARCHAR(50) NOT NULL,
    [before_lineitems] VARCHAR(50) NOT NULL,
    [order_no] DECIMAL(4,2) NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [import_template_queries_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [import_template_queries_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [import_template_queries_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[import_jobs] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [import_jobs_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(100),
    [sequence_number] VARCHAR(255),
    [header_details] VARCHAR(max),
    [table_config] VARCHAR(max),
    [total_rows] VARCHAR(50) NOT NULL,
    [completed_rows] VARCHAR(50) NOT NULL,
    [error_rows] VARCHAR(50) NOT NULL,
    [batch_process_count] INT CONSTRAINT [import_jobs_batch_process_count_df] DEFAULT 50,
    [job_status] NVARCHAR(1000) CONSTRAINT [import_jobs_job_status_df] DEFAULT 'created',
    [last_processed_row_id] INT CONSTRAINT [import_jobs_last_processed_row_id_df] DEFAULT 0,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [import_jobs_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_by] INT,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [import_jobs_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_by] INT,
    [deleted_at] DATETIME2,
    CONSTRAINT [import_jobs_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [import_jobs_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[import_job_line_items] (
    [id] INT NOT NULL IDENTITY(1,1),
    [import_job_id] INT NOT NULL,
    [row_object] VARCHAR(max),
    [job_status] NVARCHAR(1000) CONSTRAINT [import_job_line_items_job_status_df] DEFAULT 'created',
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [import_job_line_items_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [import_job_line_items_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [import_job_line_items_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[export_templates] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [export_templates_uuid_df] DEFAULT uuid_generate_v4(),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100) NOT NULL,
    [description] VARCHAR(100),
    [max_row_count] VARCHAR(50) NOT NULL,
    [header_row] VARCHAR(50) NOT NULL,
    [data_start_row] VARCHAR(50) NOT NULL,
    [data_end_row] VARCHAR(50) NOT NULL,
    [data_filepath] VARCHAR(max) NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [export_templates_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_by] INT,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [export_templates_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_by] INT,
    [deleted_at] DATETIME2,
    CONSTRAINT [export_templates_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [export_templates_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [export_templates_company_id_slug_key] UNIQUE NONCLUSTERED ([company_id],[slug])
);

-- CreateTable
CREATE TABLE [dbo].[export_template_line_items] (
    [id] INT NOT NULL IDENTITY(1,1),
    [export_template_id] INT NOT NULL,
    [field_name] VARCHAR(255) NOT NULL,
    [display_name] VARCHAR(100) NOT NULL,
    [field_table] VARCHAR(100) NOT NULL,
    [order_no] DECIMAL(4,2) NOT NULL,
    [default_value] VARCHAR(100),
    [column_name] VARCHAR(255),
    [is_individual] VARCHAR(50) NOT NULL,
    [individual_column] VARCHAR(20),
    [field_type_id] INT,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [export_template_line_items_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [export_template_line_items_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [export_template_line_items_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [export_template_line_items_company_id_export_template_id_field_table_field_name_key] UNIQUE NONCLUSTERED ([company_id],[export_template_id],[field_table],[field_name]),
    CONSTRAINT [export_template_line_items_company_id_export_template_id_display_name_key] UNIQUE NONCLUSTERED ([company_id],[export_template_id],[display_name])
);

-- CreateTable
CREATE TABLE [dbo].[export_template_queries] (
    [id] INT NOT NULL IDENTITY(1,1),
    [export_template_id] INT NOT NULL,
    [query_string] VARCHAR(max),
    [query_name] VARCHAR(255) NOT NULL,
    [query_procedure] NVARCHAR(1000) NOT NULL CONSTRAINT [export_template_queries_query_procedure_df] DEFAULT 'procedure',
    [is_individual] VARCHAR(50) NOT NULL,
    [order_no] DECIMAL(4,2) NOT NULL,
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [export_template_queries_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [export_template_queries_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [export_template_queries_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[statuses] (
    [id] INT NOT NULL IDENTITY(1,1),
    [name] VARCHAR(100) NOT NULL,
    [slug] VARCHAR(100) NOT NULL,
    [description] VARCHAR(max),
    [status_id] INT CONSTRAINT [statuses_status_id_df] DEFAULT 1,
    CONSTRAINT [statuses_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [statuses_id_key] UNIQUE NONCLUSTERED ([id]),
    CONSTRAINT [statuses_slug_key] UNIQUE NONCLUSTERED ([slug])
);

-- CreateTable
CREATE TABLE [dbo].[app_category_types] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [app_category_types_uuid_df] DEFAULT uuid_generate_v4(),
    [category_type_id] VARCHAR(10) NOT NULL,
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(255),
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [app_category_types_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [app_category_types_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [app_category_types_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [app_category_types_category_type_id_key] UNIQUE NONCLUSTERED ([category_type_id]),
    CONSTRAINT [app_category_types_company_id_category_type_id_key] UNIQUE NONCLUSTERED ([company_id],[category_type_id]),
    CONSTRAINT [app_category_types_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [app_category_types_company_id_name_key] UNIQUE NONCLUSTERED ([company_id],[name])
);

-- CreateTable
CREATE TABLE [dbo].[app_categories] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [app_categories_uuid_df] DEFAULT uuid_generate_v4(),
    [category_type_id] INT NOT NULL,
    [category_id] VARCHAR(10) NOT NULL,
    [parent_id] VARCHAR(10),
    [name] VARCHAR(100) NOT NULL,
    [description] VARCHAR(255),
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [app_categories_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [app_categories_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [app_categories_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [app_categories_category_id_key] UNIQUE NONCLUSTERED ([category_id]),
    CONSTRAINT [app_categories_company_id_category_id_key] UNIQUE NONCLUSTERED ([company_id],[category_id]),
    CONSTRAINT [app_categories_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [app_categories_company_id_name_key] UNIQUE NONCLUSTERED ([company_id],[name])
);

-- CreateTable
CREATE TABLE [dbo].[app_configurations] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [app_configurations_uuid_df] DEFAULT uuid_generate_v4(),
    [order_no] DECIMAL(4,2) NOT NULL,
    [config_key] VARCHAR(100) NOT NULL,
    [category_id] INT NOT NULL,
    [config_value] VARCHAR(255),
    [config_file_value] VARCHAR(max),
    [config_value_type] VARCHAR(100) NOT NULL,
    [config_field_type] VARCHAR(100) NOT NULL,
    [display_config] VARCHAR(50) NOT NULL,
    [company_id] INT NOT NULL,
    [created_by] INT,
    [updated_by] INT,
    [deleted_by] INT,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [app_configurations_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_at] DATETIME2 CONSTRAINT [app_configurations_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_at] DATETIME2,
    CONSTRAINT [app_configurations_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [app_configurations_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [app_configurations_company_id_config_key_key] UNIQUE NONCLUSTERED ([company_id],[config_key])
);

-- CreateTable
CREATE TABLE [dbo].[file_upload_logs] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [file_upload_logs_uuid_df] DEFAULT uuid_generate_v4(),
    [doc_name] VARCHAR(255),
    [org_name] VARCHAR(255),
    [extension] VARCHAR(100),
    [description] VARCHAR(100),
    [status_id] INT NOT NULL,
    [company_id] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [file_upload_logs_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    CONSTRAINT [file_upload_logs_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [file_upload_logs_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[data_transfer_queries] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [data_transfer_queries_uuid_df] DEFAULT uuid_generate_v4(),
    [select_query] NVARCHAR(1000) NOT NULL,
    [insert_query] NVARCHAR(1000) NOT NULL,
    [transfer_type] NVARCHAR(1000) NOT NULL,
    [job_name] NVARCHAR(1000) NOT NULL,
    [destination_table] NVARCHAR(1000) NOT NULL,
    [clear_destination_table] VARCHAR(50) NOT NULL,
    [execution_order] INT NOT NULL,
    [command_type] NVARCHAR(1000) NOT NULL,
    [status_id] INT NOT NULL,
    [created_by] INT,
    [created_at] DATETIME2 CONSTRAINT [data_transfer_queries_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [company_id] INT NOT NULL,
    CONSTRAINT [data_transfer_queries_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [data_transfer_queries_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id])
);

-- CreateTable
CREATE TABLE [dbo].[device_registration] (
    [id] INT NOT NULL IDENTITY(1,1),
    [uuid] UNIQUEIDENTIFIER NOT NULL CONSTRAINT [device_registration_uuid_df] DEFAULT uuid_generate_v4(),
    [company_id] INT NOT NULL,
    [device_name] VARCHAR(255) NOT NULL,
    [device_unique_id] VARCHAR(255) NOT NULL,
    [user_id] INT NOT NULL,
    [status_id] INT NOT NULL,
    [created_by] INT NOT NULL,
    [created_at] DATETIME2 NOT NULL CONSTRAINT [device_registration_created_at_df] DEFAULT CURRENT_TIMESTAMP,
    [updated_by] INT,
    [updated_at] DATETIME2 NOT NULL CONSTRAINT [device_registration_updated_at_df] DEFAULT CURRENT_TIMESTAMP,
    [deleted_by] INT,
    [deleted_at] DATETIME2,
    CONSTRAINT [device_registration_pkey] PRIMARY KEY CLUSTERED ([id]),
    CONSTRAINT [device_registration_company_id_id_key] UNIQUE NONCLUSTERED ([company_id],[id]),
    CONSTRAINT [device_registration_company_id_uuid_key] UNIQUE NONCLUSTERED ([company_id],[uuid])
);

-- CreateIndex
CREATE NONCLUSTERED INDEX [request_logs_company_id_idx] ON [dbo].[request_logs]([company_id]);

-- CreateIndex
CREATE NONCLUSTERED INDEX [permissions_company_id_order_no_idx] ON [dbo].[permissions]([company_id], [order_no]);

-- CreateIndex
CREATE NONCLUSTERED INDEX [otps_company_id_user_id_purpose_idx] ON [dbo].[otps]([company_id], [user_id], [purpose]);

-- AddForeignKey
ALTER TABLE [dbo].[users] ADD CONSTRAINT [users_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[users] ADD CONSTRAINT [users_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[users] ADD CONSTRAINT [users_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[users] ADD CONSTRAINT [users_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_details] ADD CONSTRAINT [user_details_company_id_designation_id_fkey] FOREIGN KEY ([company_id], [designation_id]) REFERENCES [dbo].[designations]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_details] ADD CONSTRAINT [user_details_company_id_department_id_fkey] FOREIGN KEY ([company_id], [department_id]) REFERENCES [dbo].[departments]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_details] ADD CONSTRAINT [user_details_company_id_user_id_fkey] FOREIGN KEY ([company_id], [user_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_details] ADD CONSTRAINT [user_details_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_details] ADD CONSTRAINT [user_details_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_details] ADD CONSTRAINT [user_details_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[designations] ADD CONSTRAINT [designations_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[designations] ADD CONSTRAINT [designations_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[designations] ADD CONSTRAINT [designations_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[designations] ADD CONSTRAINT [designations_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[departments] ADD CONSTRAINT [departments_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[departments] ADD CONSTRAINT [departments_company_id_department_head_id_fkey] FOREIGN KEY ([company_id], [department_head_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[departments] ADD CONSTRAINT [departments_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[departments] ADD CONSTRAINT [departments_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[departments] ADD CONSTRAINT [departments_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[request_logs] ADD CONSTRAINT [request_logs_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[request_logs] ADD CONSTRAINT [request_logs_company_id_user_id_fkey] FOREIGN KEY ([company_id], [user_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[financial_years] ADD CONSTRAINT [financial_years_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[financial_years] ADD CONSTRAINT [financial_years_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[financial_years] ADD CONSTRAINT [financial_years_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[financial_years] ADD CONSTRAINT [financial_years_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[document_sequences] ADD CONSTRAINT [document_sequences_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[document_sequences] ADD CONSTRAINT [document_sequences_company_id_financial_year_id_fkey] FOREIGN KEY ([company_id], [financial_year_id]) REFERENCES [dbo].[financial_years]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[document_sequences] ADD CONSTRAINT [document_sequences_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[document_sequences] ADD CONSTRAINT [document_sequences_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[document_sequences] ADD CONSTRAINT [document_sequences_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[audit_logs] ADD CONSTRAINT [audit_logs_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[audit_logs] ADD CONSTRAINT [audit_logs_user_id_fkey] FOREIGN KEY ([user_id]) REFERENCES [dbo].[users]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[permissions] ADD CONSTRAINT [permissions_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[permissions] ADD CONSTRAINT [permissions_company_id_entity_id_fkey] FOREIGN KEY ([company_id], [entity_id]) REFERENCES [dbo].[master_entities]([company_id],[id]) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE [dbo].[roles] ADD CONSTRAINT [roles_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[roles] ADD CONSTRAINT [roles_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[roles] ADD CONSTRAINT [roles_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[roles] ADD CONSTRAINT [roles_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[role_permissions] ADD CONSTRAINT [role_permissions_company_id_role_id_fkey] FOREIGN KEY ([company_id], [role_id]) REFERENCES [dbo].[roles]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[role_permissions] ADD CONSTRAINT [role_permissions_company_id_permission_id_fkey] FOREIGN KEY ([company_id], [permission_id]) REFERENCES [dbo].[permissions]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_roles] ADD CONSTRAINT [user_roles_company_id_user_id_fkey] FOREIGN KEY ([company_id], [user_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_roles] ADD CONSTRAINT [user_roles_company_id_role_id_fkey] FOREIGN KEY ([company_id], [role_id]) REFERENCES [dbo].[roles]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_permissions] ADD CONSTRAINT [user_permissions_company_id_user_id_fkey] FOREIGN KEY ([company_id], [user_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[user_permissions] ADD CONSTRAINT [user_permissions_company_id_permission_id_fkey] FOREIGN KEY ([company_id], [permission_id]) REFERENCES [dbo].[permissions]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[otps] ADD CONSTRAINT [otps_company_id_user_id_fkey] FOREIGN KEY ([company_id], [user_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[languages] ADD CONSTRAINT [languages_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[languages] ADD CONSTRAINT [languages_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[languages] ADD CONSTRAINT [languages_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[languages] ADD CONSTRAINT [languages_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[language_contents] ADD CONSTRAINT [language_contents_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[language_contents] ADD CONSTRAINT [language_contents_company_id_language_id_fkey] FOREIGN KEY ([company_id], [language_id]) REFERENCES [dbo].[languages]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu] ADD CONSTRAINT [menu_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu] ADD CONSTRAINT [menu_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu] ADD CONSTRAINT [menu_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu] ADD CONSTRAINT [menu_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_menu_id_fkey] FOREIGN KEY ([company_id], [menu_id]) REFERENCES [dbo].[menu]([company_id],[id]) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_entity_id_fkey] FOREIGN KEY ([company_id], [entity_id]) REFERENCES [dbo].[master_entities]([company_id],[id]) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_permission_id_fkey] FOREIGN KEY ([company_id], [permission_id]) REFERENCES [dbo].[permissions]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_parent_id_fkey] FOREIGN KEY ([company_id], [parent_id]) REFERENCES [dbo].[menu_items]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_items] ADD CONSTRAINT [menu_items_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[master_entities] ADD CONSTRAINT [master_entities_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[master_entity_line_items] ADD CONSTRAINT [master_entity_line_items_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[master_entity_line_items] ADD CONSTRAINT [master_entity_line_items_company_id_master_grid_id_fkey] FOREIGN KEY ([company_id], [master_grid_id]) REFERENCES [dbo].[master_entities]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[master_entity_line_items] ADD CONSTRAINT [master_entity_line_items_company_id_field_type_id_fkey] FOREIGN KEY ([company_id], [field_type_id]) REFERENCES [dbo].[field_types]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[field_types] ADD CONSTRAINT [field_types_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[menu_types] ADD CONSTRAINT [menu_types_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_process] ADD CONSTRAINT [email_template_process_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_tags] ADD CONSTRAINT [email_template_tags_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_recipient_tags] ADD CONSTRAINT [email_template_recipient_tags_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_process_tags_mapping] ADD CONSTRAINT [email_template_process_tags_mapping_email_template_process_id_company_id_fkey] FOREIGN KEY ([email_template_process_id], [company_id]) REFERENCES [dbo].[email_template_process]([id],[company_id]) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_process_tags_mapping] ADD CONSTRAINT [email_template_process_tags_mapping_company_id_email_template_tag_id_fkey] FOREIGN KEY ([company_id], [email_template_tag_id]) REFERENCES [dbo].[email_template_tags]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_templates] ADD CONSTRAINT [email_templates_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_templates] ADD CONSTRAINT [email_templates_email_template_process_id_company_id_fkey] FOREIGN KEY ([email_template_process_id], [company_id]) REFERENCES [dbo].[email_template_process]([id],[company_id]) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE [dbo].[email_templates] ADD CONSTRAINT [email_templates_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_templates] ADD CONSTRAINT [email_templates_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_templates] ADD CONSTRAINT [email_templates_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_assignments] ADD CONSTRAINT [email_template_assignments_company_id_email_template_process_id_fkey] FOREIGN KEY ([company_id], [email_template_process_id]) REFERENCES [dbo].[email_template_process]([company_id],[id]) ON DELETE NO ACTION ON UPDATE CASCADE;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_assignments] ADD CONSTRAINT [email_template_assignments_company_id_template_id_fkey] FOREIGN KEY ([company_id], [template_id]) REFERENCES [dbo].[email_templates]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_template_assignments] ADD CONSTRAINT [email_template_assignments_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_process_jobs] ADD CONSTRAINT [email_process_jobs_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[email_process_jobs] ADD CONSTRAINT [email_process_jobs_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[notification_jobs] ADD CONSTRAINT [notification_jobs_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[notification_jobs] ADD CONSTRAINT [notification_jobs_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_templates] ADD CONSTRAINT [import_templates_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_templates] ADD CONSTRAINT [import_templates_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_templates] ADD CONSTRAINT [import_templates_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_templates] ADD CONSTRAINT [import_templates_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_template_line_items] ADD CONSTRAINT [import_template_line_items_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_template_line_items] ADD CONSTRAINT [import_template_line_items_company_id_import_template_id_fkey] FOREIGN KEY ([company_id], [import_template_id]) REFERENCES [dbo].[import_templates]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_template_line_items] ADD CONSTRAINT [import_template_line_items_company_id_field_type_id_fkey] FOREIGN KEY ([company_id], [field_type_id]) REFERENCES [dbo].[field_types]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_template_queries] ADD CONSTRAINT [import_template_queries_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_template_queries] ADD CONSTRAINT [import_template_queries_company_id_import_template_id_fkey] FOREIGN KEY ([company_id], [import_template_id]) REFERENCES [dbo].[import_templates]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_jobs] ADD CONSTRAINT [import_jobs_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_jobs] ADD CONSTRAINT [import_jobs_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_jobs] ADD CONSTRAINT [import_jobs_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_jobs] ADD CONSTRAINT [import_jobs_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_job_line_items] ADD CONSTRAINT [import_job_line_items_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[import_job_line_items] ADD CONSTRAINT [import_job_line_items_company_id_import_job_id_fkey] FOREIGN KEY ([company_id], [import_job_id]) REFERENCES [dbo].[import_jobs]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_templates] ADD CONSTRAINT [export_templates_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_templates] ADD CONSTRAINT [export_templates_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_templates] ADD CONSTRAINT [export_templates_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_templates] ADD CONSTRAINT [export_templates_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_template_line_items] ADD CONSTRAINT [export_template_line_items_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_template_line_items] ADD CONSTRAINT [export_template_line_items_company_id_export_template_id_fkey] FOREIGN KEY ([company_id], [export_template_id]) REFERENCES [dbo].[export_templates]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_template_line_items] ADD CONSTRAINT [export_template_line_items_company_id_field_type_id_fkey] FOREIGN KEY ([company_id], [field_type_id]) REFERENCES [dbo].[field_types]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_template_queries] ADD CONSTRAINT [export_template_queries_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[export_template_queries] ADD CONSTRAINT [export_template_queries_company_id_export_template_id_fkey] FOREIGN KEY ([company_id], [export_template_id]) REFERENCES [dbo].[export_templates]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[statuses] ADD CONSTRAINT [statuses_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_category_types] ADD CONSTRAINT [app_category_types_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_category_types] ADD CONSTRAINT [app_category_types_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_category_types] ADD CONSTRAINT [app_category_types_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_categories] ADD CONSTRAINT [app_categories_parent_id_fkey] FOREIGN KEY ([parent_id]) REFERENCES [dbo].[app_categories]([category_id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_categories] ADD CONSTRAINT [app_categories_company_id_category_type_id_fkey] FOREIGN KEY ([company_id], [category_type_id]) REFERENCES [dbo].[app_category_types]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_categories] ADD CONSTRAINT [app_categories_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_categories] ADD CONSTRAINT [app_categories_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_categories] ADD CONSTRAINT [app_categories_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_configurations] ADD CONSTRAINT [app_configurations_company_id_category_id_fkey] FOREIGN KEY ([company_id], [category_id]) REFERENCES [dbo].[app_categories]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_configurations] ADD CONSTRAINT [app_configurations_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_configurations] ADD CONSTRAINT [app_configurations_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[app_configurations] ADD CONSTRAINT [app_configurations_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[file_upload_logs] ADD CONSTRAINT [file_upload_logs_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[device_registration] ADD CONSTRAINT [device_registration_status_id_fkey] FOREIGN KEY ([status_id]) REFERENCES [dbo].[statuses]([id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[device_registration] ADD CONSTRAINT [device_registration_company_id_created_by_fkey] FOREIGN KEY ([company_id], [created_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[device_registration] ADD CONSTRAINT [device_registration_company_id_updated_by_fkey] FOREIGN KEY ([company_id], [updated_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[device_registration] ADD CONSTRAINT [device_registration_company_id_deleted_by_fkey] FOREIGN KEY ([company_id], [deleted_by]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

-- AddForeignKey
ALTER TABLE [dbo].[device_registration] ADD CONSTRAINT [device_registration_company_id_user_id_fkey] FOREIGN KEY ([company_id], [user_id]) REFERENCES [dbo].[users]([company_id],[id]) ON DELETE NO ACTION ON UPDATE NO ACTION;

COMMIT TRAN;

END TRY
BEGIN CATCH

IF @@TRANCOUNT > 0
BEGIN
    ROLLBACK TRAN;
END;
THROW

END CATCH
