import { statusSeeder } from './pg/seeds/status-seeds';
import { usersSeeder } from './pg/seeds/user-seeds';
import { permissionsSeeder } from './pg/seeds/permission-seeds';
import { menuItemsSeeder } from './pg/seeds/menuItems-seeds';
import { fieldTypesSeeder } from './pg/seeds/field-types-seeds';
import { gridSeeder } from './pg/seeds/master-grid-seeds';
import { importTemplatesSeeder } from './pg/seeds/import-template-seeds';
import { entityTypeSeeder } from './pg/seeds/entity-type-seeds';
import { actionTypeSeeder } from './pg/seeds/action-type-seeds';
import { languageSeeds } from './pg/seeds/language-seeds';
import { formEntitiesSeeder } from './pg/seeds/form-entity-seeds';
import { languageContentSeeds } from './pg/seeds/languageContent-seeds';
import { wizardTypeSeeder } from './pg/seeds/wizard-type-seeds';
import { wizardGroupSeeder } from './pg/seeds/dashboard-wizard-seeds';
import { menusSeeder } from './pg/seeds/menus-seeds';
import { mobileMenuItemsSeeder } from './pg/seeds/mobileMenuItems-seeds';
import { menuTypesSeeds } from './pg/seeds/menuTypes-seeds';
import { roleSeeds } from './pg/seeds/role-seeds';
import { userRolesSeeds } from './pg/seeds/userRoles-seeds';
import { emailTemplatesProcessSeeder } from './pg/seeds/email-template-process-seeds';
import { emailTemplatesSeeder } from './pg/seeds/email-template-seeds';
import { configurationsSeeder } from './pg/seeds/configuration-seeds';
import { emailTemplateAssignmentsSeeder } from './pg/seeds/email-template-assignment-seeds';
import { financialYearSeeder } from './pg/seeds/program-year-seeds';
import { documentSequenceSeeder } from './pg/seeds/document-sequence-seeds';
import { productStatusesSeeder } from './pg/seeds/productStatus-seeds';
import { companyDetailsSeeder } from './pg/seeds/companyDetails-seeds';

const company_id = 1;

async function applicationSeeders() {
  try {
    await statusSeeder();
    await entityTypeSeeder(company_id);
    await actionTypeSeeder(company_id);
    await wizardTypeSeeder(company_id);

    await usersSeeder(company_id);
    await financialYearSeeder(company_id);
    await documentSequenceSeeder(company_id);
    await fieldTypesSeeder(company_id);
    await gridSeeder(company_id);
    await wizardGroupSeeder(company_id);
    await formEntitiesSeeder(company_id);
    await permissionsSeeder(company_id);
    await menusSeeder(company_id);
    await menuItemsSeeder(company_id);
    await mobileMenuItemsSeeder(company_id);
    await importTemplatesSeeder(company_id);
    await menuTypesSeeds(company_id);
    await languageSeeds(company_id);
    await languageContentSeeds(company_id);
    await roleSeeds(company_id);
    await userRolesSeeds(company_id);
    await emailTemplatesProcessSeeder(company_id);
    await emailTemplatesSeeder(company_id);
    await configurationsSeeder(company_id);
    await emailTemplateAssignmentsSeeder(company_id);

    await productStatusesSeeder(company_id);
    await companyDetailsSeeder(company_id);
    
  } catch (error) {
    console.log(`Application seeder error: `, error);
  }
}

applicationSeeders();
