import { Status, PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

export async function statusSeeder() {
  try {
    const statusArr = [
      { id: 1, name: 'Active', slug: 'active' },
      { id: 2, name: 'InActive', slug: 'inactive' },
      { id: 3, name: 'Delete', slug: 'delete' },
      { id: 4, name: 'Reserved', slug: 'reserved' },
      { id: 5, name: 'UnReserved', slug: 'unreserved' },
    ];

    for (const status of statusArr) {
      await findOrCreateStatus(status);
    }

    console.log('Status creation completed.');
  } catch (error) {
    throw error;
  }
}

async function findOrCreateStatus(status: any) {
  try {
    let resData: Status | undefined | null;

    resData = await prisma.status.findUnique({ where: { id: status.id } });

    if (!resData) {
      let data = {
        ...status,
      };

      resData = await prisma.status.create({
        data,
      });
      console.log(`Status created successfully: ${status.name}`);
    } else {
      let data = {
        ...status,
      };

      resData = await prisma.status.update({
        where: { id: resData.id },
        data,
      });
      console.log(`Status updated successfully: ${resData.name}`);
    }

    return resData;
  } catch (error) {
    console.log(`Status seeder failed: ${status.name}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
