import { PrismaClient} from '@prisma/pg/client'
import fs from 'fs';
const prisma = new PrismaClient();

export async function formEntitiesSeeder(company_id:number) {
    try {  
        const formEntities = JSON.parse(fs.readFileSync(__dirname+'/json/form-entities.json', 'utf-8'));
        const jobBuilder = JSON.parse(fs.readFileSync(__dirname+'/json/job-builder.json', 'utf-8'));
        const allEntities = [ ...formEntities, ...jobBuilder ];

        for (const formEntity of allEntities) {
            const { ...formEntityData } = formEntity;
        
            // Upsert
            const mg = await prisma.masterEntity.upsert({
              where: {
                company_id_entity_name: {
                  company_id, entity_name: formEntityData.entity_name
                }
              },
              update: {...formEntityData },
              create: {...formEntityData, company_id}
            });
        
          }
      console.log('Form entity creation completed.');
    } catch (error) {
      console.log(`Form entity seeder failed.`);
      throw error;
    }
}
