import { PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

const entityTypes = [
  {
    id: 1,
    name: 'MasterListComponent',
    slug: 'grid_builder_module',
    description: 'Grid Builder Module',
  },
  {
    id: 2,
    name: 'FormBuilderComponent',
    slug: 'form_builder_module',
    description: 'Form Builder Module',
  },
  {
    id: 3,
    name: 'StaticPageComponent',
    slug: 'static_page_builder_module',
    description: 'Static Page Builder Module',
  },
  {
    id: 4,
    name: 'EntityUserRoleMappingComponent',
    slug: 'entity_user_role_map_module',
    description: 'Entity User/Role Map Module',
  },
  {
    id: 5,
    name: 'MenuMappingComponent',
    slug: 'menu_module',
    description: 'Menu Module',
  },
  {
    id: 6,
    name: 'ImportMasterComponent',
    slug: 'import_module',
    description: 'Import Module',
  },
  {
    id: 7,
    name: 'MasterEntityComponent',
    slug: 'entity_form_module',
    description: 'Entity Add / Edit Form Module',
  },
  {
    id: 8,
    name: 'AboutlcpComponent',
    slug: 'about_lcp_form_module',
    description: 'About LCP Add / Edit Form Module',
  },
];

export async function entityTypeSeeder(company_id: number) {
  try {
    for (const entityType of entityTypes) {
      const existingEntity = await prisma.entityType.findUnique({
        where: { id: entityType.id },
      });

      if (!existingEntity) {
        await prisma.entityType.create({
          data: {
            id: entityType.id,
            name: entityType.name,
            slug: entityType.slug,
            description: entityType.description,
            company_id: company_id,
          },
        });
        console.log(
          `Created EntityType with id ${entityType.id}: ${entityType.name}`,
        );
      } else {
        console.log(`EntityType with id ${entityType.id} already exists.`);
      }
    }
  } catch (error) {
    console.error(`Error in entityTypeSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
