import { PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

function getCurrentUtcTime() {
  return new Date().toISOString();
}

export async function deviceRegistrationSeeder(company_id: number) {
  try {
    // Fetch the user with super_admin role
    let user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    if (!user) {
      console.log(
        `Role seeder failed: admin user not available for company id ${company_id}`,
      );
      return false;
    }

    const createdBy = user.id;
    const utcNow = getCurrentUtcTime();

    // Sample data for the device registration
    const sampleDeviceRegistration = {
      id: 1, // Ensure this ID does not conflict with existing IDs

      company_id: company_id, // Use the passed company_id
      device_name: 'Sample Device',
      device_unique_id: 'unique-id-5678',
      user_id: 1, // Replace with an actual user ID that exists in your database
      status_id: 1, // Assuming this corresponds to a valid status ID
      created_by: createdBy,
      created_at: utcNow,
      updated_by: null, // Initially, this can be null
      updated_at: null, // Initially, this can be null
      deleted_by: null, // Initially, this can be null
      deleted_at: null, // Initially, this can be null
    };

    // Use upsert to insert or update the device registration based on id
    const deviceRegistration = await prisma.deviceRegistration.upsert({
      where: {
        id: sampleDeviceRegistration.id, // Identify existing record by ID
      },
      update: {
        // Fields to update if a matching record is found

        device_name: sampleDeviceRegistration.device_name,
        device_unique_id: sampleDeviceRegistration.device_unique_id,
        user_id: sampleDeviceRegistration.user_id,
        status_id: sampleDeviceRegistration.status_id,
        updated_by: createdBy,
        updated_at: utcNow,
      },
      create: {
        // Fields to create if no matching record is found
        ...sampleDeviceRegistration,
        updated_at: utcNow, // Set updated_at to current time during creation
        updated_by: createdBy, // Set updated_by to the creator
        deleted_by: null, // Can stay null
        deleted_at: null, // Can stay null
      },
    });

    console.log('Device Registration Created or Updated:', deviceRegistration);
    return true;
  } catch (error) {
    console.error(`Error in deviceRegistrationSeeder: ${error}`);
    throw error;
  }
}
