import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function carouselTemplatesSeeder(company_id: number) {
  try {
    const carouselTemplates = JSON.parse(
      fs.readFileSync(__dirname + '/json/carousel-templates.json', 'utf-8'),
    );

    for (const carouselTemplate of carouselTemplates) {
      const { lineitems, queries, ...carouselTemplateData } = carouselTemplate;

      let user = await prisma.user.findFirst({
        where: { company_id, role: 'super_admin' },
      });
      if (!user) {
        console.log(
          `Carousel template seeder failed: admin user not available for company id ${company_id}`,
        );
        return false;
      }

      // Upsert Carousel Template
      const mg = await prisma.carouselTemplate.upsert({
        where: {
          company_id_slug: {
            company_id,
            slug: carouselTemplateData.slug,
          },
        },
        update: {
          ...carouselTemplateData,
          updated_by: user.id,
          updated_at: new Date(),
        },
        create: {
          ...carouselTemplateData,
          company_id,
          created_by: user.id,
        },
      });

      // Upsert LineItems
      for (const lineitem of lineitems) {
        let field_type = await prisma.fieldType.findFirst({
          where: {
            company_id,
            field_type: {
              equals: lineitem.field_type_id,
              mode: 'insensitive', // Case-insensitive comparison
            },
          },
        });
        if (!field_type) {
          console.log(
            `Carousel template seeder failed: ${lineitem.field_type_id} field_type not available for company id ${company_id}`,
          );
          return false;
        }

        await prisma.carouselTemplateLineItem.upsert({
          where: {
            company_id_carousel_template_id_slug: {
              company_id,
              carousel_template_id: mg.id,
              slug: lineitem.name,
            },
          },
          update: {
            ...lineitem,
            carousel_template_id: mg.id,
            company_id,
          },
          create: {
            ...lineitem,
            carousel_template_id: mg.id,
            company_id,
          },
        });
      }
    }

    console.log('Carousel template creation completed.');
  } catch (error) {
    console.log(`Carousel template seeder failed.`);
    throw error;
  }
}
