import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function UnitsOfMeasureSeeder(company_id: number) {
  try {
    const rows = JSON.parse(
      fs.readFileSync(__dirname + '/json/uom-seeds.json', 'utf-8'),
    );

    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    if (!user?.id) {
      throw new Error('Super admin user not found!');
    }

    for (const row of rows) {
      // Check if the UnitsOfMeasure already exists by its code and company_id
      const existingUOM = await prisma.unitsOfMeasure.findUnique({
        where: { company_id_code: { company_id, code: row.code } },
      });

      if (existingUOM) {
        // Update the UnitsOfMeasure if it already exists
        await prisma.unitsOfMeasure.update({
          where: { id: existingUOM.id },
          data: {
            name: row.name,
            status_id: row.status_id || 1, // Default to active status if not provided
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Updated UnitsOfMeasure with code ${row.code}`);
      } else {
        // Create a new UnitsOfMeasure if it doesn't exist
        await prisma.unitsOfMeasure.create({
          data: {
            code: row.code,
            name: row.name,
            company_id,
            status_id: row.status_id || 1, // Default to active status if not provided
            created_by: user.id, // Ensure created_by is assigned
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Created UnitsOfMeasure with code ${row.code}`);
      }
    }
  } catch (error) {
    console.error(`Error in UnitsOfMeasureSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
