import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function ItemTypeSeeder(company_id: number) {
  try {
    const rows = JSON.parse(
      fs.readFileSync(__dirname + '/json/item-type-seeds.json', 'utf-8'),
    );

    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });

    if (!user?.id) {
      throw new Error('Super admin user not found!');
    }

    for (const row of rows) {
      // Check if the ItemType already exists by its name and company_id
      const existingItemType = await prisma.itemType.findUnique({
        where: { company_id_code: { company_id, code: row.name } }, // Assuming 'name' as code for ItemType
      });

      if (existingItemType) {
        // Update the ItemType if it already exists
        await prisma.itemType.update({
          where: { id: existingItemType.id },
          data: {
            name: row.name,
            status_id: row.status_id || 1, // Default to active status if not provided
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Updated ItemType with name ${row.name}`);
      } else {
        // Create a new ItemType if it doesn't exist
        await prisma.itemType.create({
          data: {
            code: row.name, // Assuming the 'name' is also the 'code'
            name: row.name,
            company_id,
            status_id: row.status_id || 1, // Default to active status if not provided
            created_by: user.id, // Ensure created_by is assigned
            updated_by: user.id, // Ensure updated_by is assigned
          },
        });
        console.log(`Created ItemType with name ${row.name}`);
      }
    }
  } catch (error) {
    console.error(`Error in ItemTypeSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
