import { PrismaClient } from '@prisma/pg/client';
import fs from 'fs';
const prisma = new PrismaClient();

export async function AppDocumentSequenceSeeder(company_id: number) {
  try {
    const rows = JSON.parse(
      fs.readFileSync(
        __dirname + '/json/document-sequence-seeds.json',
        'utf-8',
      ),
    );
    const user = await prisma.user.findFirst({
      where: { company_id: company_id, role: 'super_admin' },
    });
    for (const row of rows) {
      const finanicial_year = await prisma.financialYear.findUnique({
        where: { company_id_code: { company_id, code: row.finanicial_year } },
      });
      if (finanicial_year) {
        delete row.finanicial_year;
        await prisma.documentSequence.upsert({
          where: {
            company_id_financial_year_id_module_name: {
              company_id,
              financial_year_id: finanicial_year.id,
              module_name: row.module_name,
            },
          },
          update: { ...row, updated_by: user?.id },
          create: {
            ...row,
            financial_year_id: finanicial_year.id,
            company_id,
            updated_by: user?.id,
            created_by: user?.id,
          },
        });
        console.log(
          `Updated documentSequence with code ${row.code}: ${row.name}`,
        );
      }
    }
  } catch (error) {
    console.error(`Error in documentSequenceSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
