"use strict";var __awaiter=this&&this.__awaiter||function(e,t,a,o){return new(a||(a=Promise))((function(n,i){function r(e){try{s(o.next(e))}catch(e){i(e)}}function c(e){try{s(o.throw(e))}catch(e){i(e)}}function s(e){var t;e.done?n(e.value):(t=e.value,t instanceof a?t:new a((function(e){e(t)}))).then(r,c)}s((o=o.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.openAiSchemaService=void 0;const prisma_service_1=__importDefault(require("./prisma.service")),openai_1=__importDefault(require("openai"));class openAiSchemaService{static initailizeAiConfig(){return __awaiter(this,void 0,void 0,(function*(){const e=yield prisma_service_1.default.configurations.findFirst({where:{config_key:"openai_api_key"}});openAiSchemaService.openai=new openai_1.default({apiKey:null==e?void 0:e.config_value})}))}static getTables(){return __awaiter(this,void 0,void 0,(function*(){return(yield prisma_service_1.default.$queryRaw`
          SELECT table_name
          FROM information_schema.tables
          WHERE table_schema = 'public' AND table_type = 'BASE TABLE'
        `).map((e=>e.table_name))}))}static getTableSchema(e){return __awaiter(this,void 0,void 0,(function*(){try{const t=(yield prisma_service_1.default.$queryRaw`
                SELECT column_name, data_type, is_nullable
            FROM information_schema.columns
            WHERE table_name = ${e}
        `).map((e=>`- ${e.column_name}: ${e.data_type}${"NO"===e.is_nullable?" (required)":""}`)).join("\n");return`Table: ${e}\nColumns:\n${t}`}catch(e){throw console.error("Project Sync - Failed:",e),e}}))}static embedAndStore(e,t,a){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield this.openai.embeddings.create({model:"text-embedding-3-small",input:t}),n=o.data[0].embedding,i=o.usage.total_tokens/1e3*2e-5,r=parseFloat(i.toFixed(6)),c=1;yield prisma_service_1.default.$executeRaw`
              INSERT INTO schema_chunks (table_name, chunk, embedding, company_id, created_by)
              VALUES (${e}, ${t}, ${n}::vector, ${c}, ${a})
              ON CONFLICT (table_name) DO UPDATE
              SET chunk = ${t},
                  embedding = ${n}::vector,
                  updated_at = NOW(),
                  updated_by = ${a}
          `,yield prisma_service_1.default.embeddingVectorLogs.create({data:{table_name:e,cost:r,company_id:c,created_by:a,user_id:a}})}catch(e){throw console.error("Project Sync - Failed:",e),e}}))}static generateSchemaChunks(e){return __awaiter(this,void 0,void 0,(function*(){try{console.log("Project Sync - Starting"),yield prisma_service_1.default.schemaChunk.deleteMany();const t=yield this.getTables();console.log(`Found ${t.length} tables to process`);const a=1;for(const o of t)try{console.log(`Processing table: ${o}`);const t=yield this.getTableSchema(o);yield prisma_service_1.default.schemaChunk.create({data:{table_name:o,chunk:t,created_by:e,company_id:a}}),console.log(`✅ ${o} chunk created`)}catch(e){console.error(`Error processing table ${o}:`,e)}console.log("Project Sync - Completed successfully")}catch(e){throw console.error("Project Sync - Failed:",e),e}}))}static generateVector(e){return __awaiter(this,void 0,void 0,(function*(){try{const t=yield prisma_service_1.default.schemaChunk.findMany({select:{table_name:!0,chunk:!0}});console.log(`Found ${t.length} tables to process`);for(const a of t)try{console.log(`Processing table: ${a}`),yield this.embedAndStore(a.table_name,a.chunk,e),console.log(`✅ ${a} embedded and stored`)}catch(e){throw console.error(`Error processing table ${a}:`,e),e}}catch(e){throw console.error("Project Sync - Failed:",e),e}}))}static generateVectorForTable(e,t){return __awaiter(this,void 0,void 0,(function*(){try{const a=yield prisma_service_1.default.schemaChunk.findFirst({where:{uuid:e}});if(!(null==a?void 0:a.table_name))throw new Error("Table not found");yield this.embedAndStore(a.table_name,a.chunk,t),console.log(`✅ ${a.table_name} embedded and stored`)}catch(e){throw console.error("Project Sync - Failed:",e),e}}))}}exports.openAiSchemaService=openAiSchemaService;