"use strict";
/**
 * @openapi
 * /common/grid-data:
 *   post:
 *     tags:
 *       - Common
 *     summary: Grid Data.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/GridData'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/list-data:
 *   post:
 *     tags:
 *       - Common
 *     summary: List Data.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/MultipleRecordsParam'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/create-data:
 *   post:
 *     tags:
 *       - Common
 *     summary: Create Data.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/CreateRecordsParam'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/update-data:
 *   post:
 *     tags:
 *       - Common
 *     summary: Update Data.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/UpdateRecordsParam'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/execute-transaction:
 *   post:
 *     tags:
 *       - Common
 *     summary: Execute transactions.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/ExecuteTransactionRequest'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/tables:
 *   get:
 *     tags:
 *       - Common
 *     summary: Get table names from db.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/procedure/{procedure}:
 *   post:
 *     tags:
 *       - Common
 *     summary: Calling any procedure.
 *     parameters:
 *       - in: path
 *         name: procedure
 *         required: true
 *         description: procedure name of the procedure that you are requesting
 *         schema:
 *           type: string
 *           example: "get_multiple_records"
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/UpdateRecordsParam'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/file-upload/image:
 *   post:
 *     tags:
 *       - Common
 *     summary: Update Image and get File Name.
 *     requestBody:
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/definitions/UpdateImage'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/file-delete/image:
 *   post:
 *     tags:
 *       - Common
 *     summary: Delete Image by File Name.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/DeleteImages'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * definitions:
 *   GridData:
 *     type: object
 *     properties:
 *       company_id:
 *         type: integer
 *         example: 1
 *       print_query:
 *         type: boolean
 *         example: false
 *       entity_name:
 *         type: string
 *         example: "user-grid"
 *       start_index:
 *         type: integer
 *         example: 0
 *       limit_range:
 *         type: integer
 *         example: 15
 *       sort_columns:
 *         type: array
 *         items:
 *           $ref: '#/definitions/SortColumn'
 *       search_all:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *       search_any:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *     required:
 *       - entity_name
 *       - start_index
 *       - limit_range
 *       - sort_columns
 *       - company_id
 *
 *   MultipleRecordsParam:
 *     type: object
 *     properties:
 *       company_id:
 *         type: integer
 *         example: 1
 *       print_query:
 *         type: boolean
 *         example: false
 *       primary_table:
 *         type: string
 *         example: "users"
 *       start_index:
 *         type: integer
 *         example: 0
 *       limit_range:
 *         type: integer
 *         example: 15
 *       sort_columns:
 *         type: array
 *         items:
 *           $ref: '#/definitions/SortColumn'
 *       search_all:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *       search_any:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *       select_columns:
 *         type: array
 *         items:
 *           type: array
 *           items:
 *             type: string
 *         example:
 *           - - "users.id"
 *           - - "users.email"
 *             - "user_mail"
 *           - - "concat(user_details.first_name, ' ', user_details.last_name)"
 *             - "full_name"
 *       includes:
 *         type: array
 *         items:
 *           $ref: '#/definitions/IncludeJson'
 *       group_by:
 *         type: array
 *         items:
 *           type: string
 *         example:
 *           - "users.id"
 *       having_conditions:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *     required:
 *       - primary_table
 *       - sort_columns
 *       - select_columns
 *       - company_id
 *
 *   SortColumn:
 *     type: object
 *     properties:
 *       0:
 *         type: string
 *       1:
 *         type: string
 *         enum:
 *           - asc
 *           - desc
 *     example:
 *       - "users.id"
 *       - "desc"
 *
 *   WhereClause:
 *     type: object
 *     properties:
 *       column_name:
 *         type: string
 *         example: "users.deleted_at"
 *       value:
 *         type: string
 *         example: null
 *         description: "for LIKE, NOT LIKE, ILIKE & NOT ILIKE use %search%, for IN , NOT IN & BETWEEN use array like ['1','5']"
 *       operator:
 *         type: string
 *         example: "IS"
 *         description: "can be '=', '<', '>', '<=', '>=', 'IS', 'IS NOT', 'IN', 'NOT IN', 'LIKE', 'NOT LIKE', 'ILIKE', 'NOT ILIKE', 'BETWEEN'"
 *     required:
 *       - column_name
 *       - value
 *       - operator
 *
 *   IncludeJson:
 *     type: object
 *     properties:
 *       table_name:
 *         type: string
 *         example: "user_details"
 *       join_type:
 *         type: string
 *         example: "INNER"
 *         description: "can be INNER, LEFT, RIGHT"
 *       join_condition:
 *         type: string
 *         example: "users.id = user_details.user_id"
 *     required:
 *       - table_name
 *       - join_type
 *       - join_condition
 *
 *
 *   CreateRecordsParam:
 *     type: object
 *     properties:
 *       table_name:
 *         type: string
 *         example: "roles"
 *       insert_values:
 *         type: array
 *         items:
 *           type: object
 *           additionalProperties: true
 *         example:
 *           - uuid: "0664b4aa-2463-4e3a-b61c-432c0dd31000"
 *             name: "Test 1"
 *           - uuid: "0664b4aa-2463-4e3a-b61c-432c0dd31001"
 *             name: "Test 2"
 *       company_id:
 *         type: integer
 *         example: 1
 *       updated_by:
 *         type: integer
 *         example: 1
 *       created_by:
 *         type: integer
 *         example: 1
 *       updated_at:
 *         type: string
 *         example: "now()"
 *       print_query:
 *         type: boolean
 *         example: false
 *     required:
 *       - table_name
 *       - insert_values
 *       - company_id
 *
 *   UpdateRecordsParam:
 *     type: object
 *     properties:
 *       table_name:
 *         type: string
 *         example: "roles"
 *       update_values:
 *         type: object
 *         additionalProperties: true
 *         example:
 *           name: "Test2"
 *           status_id: 1
 *       where_all:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *         example:
 *           - column_name: "deleted_at"
 *             value: null
 *             operator: "IS"
 *           - column_name: "id"
 *             value: "1"
 *             operator: "="
 *       where_any:
 *         type: array
 *         items:
 *           $ref: '#/definitions/WhereClause'
 *         example:
 *           - column_name: "deleted_at"
 *             value: null
 *             operator: "IS"
 *           - column_name: "id"
 *             value: "1"
 *             operator: "="
 *       company_id:
 *         type: integer
 *         example: 1
 *       deleted_by:
 *         type: integer
 *         example: 1
 *       deleted_at:
 *         type: string
 *         example: "now()"
 *       updated_by:
 *         type: integer
 *         example: 1
 *       updated_at:
 *         type: string
 *         example: "now()"
 *       print_query:
 *         type: boolean
 *         example: false
 *     required:
 *       - table_name
 *       - update_values
 *       - company_id
 *
 *   UpdateImage:
 *     type: object
 *     properties:
 *       image:
 *         type: file
 *         format: binary
 *
 *   DeleteImages:
 *     type: object
 *     properties:
 *       images:
 *         type: array
 *         items:
 *           type: string
 *           example: "images/form-builder/1723035141819_934551925.png"
 *
 *   LanguageContent:
 *     type: object
 *     properties:
 *       company_id:
 *         type: integer
 *         example: 1
 *       language_id:
 *         type: integer
 *         example: 1
 *
 *
 *   ExecuteTransactionRequest:
 *     type: object
 *     properties:
 *       data:
 *         type: object
 *         properties:
 *           table1:
 *             type: array
 *             items:
 *               type: object
 *               properties:
 *                 email:
 *                   type: string
 *                   example: "$users.email"
 *                 username:
 *                   type: string
 *                   example: "$users.username"
 *                 status_id:
 *                   type: string
 *                   example: "$users.status_id"
 *                 updated_at:
 *                   type: boolean
 *                   example: true
 *                 updated_by:
 *                   type: boolean
 *                   example: true
 *           table2:
 *             type: array
 *             items:
 *               type: object
 *               properties:
 *                 dob:
 *                   type: string
 *                   example: "$user_details.dob"
 *                 code:
 *                   type: string
 *                   example: "$user_details.code"
 *                 gender:
 *                   type: string
 *                   example: "$user_details.gender"
 *                 address:
 *                   type: string
 *                   example: "$user_details.address"
 *                 culture:
 *                   type: string
 *                   example: "$user_details.culture"
 *                 last_name:
 *                   type: string
 *                   example: "$user_details.last_name"
 *                 first_name:
 *                   type: string
 *                   example: "$user_details.first_name"
 *                 updated_at:
 *                   type: boolean
 *                   example: true
 *                 updated_by:
 *                   type: boolean
 *                   example: true
 *                 profile_pic:
 *                   type: string
 *                   example: "$user_details.profile_pic"
 *                 phone_number:
 *                   type: string
 *                   example: "$user_details.phone_number"
 *                 department_id:
 *                   type: string
 *                   example: "$user_details.department_id"
 *                 designation_id:
 *                   type: string
 *                   example: "$user_details.designation_id"
 *           table4:
 *             type: array
 *             items:
 *               type: object
 *               properties:
 *                 role_id:
 *                   type: string
 *                   example: "$user_roles.role_id"
 *                 user_id:
 *                   type: string
 *                   example: "@table1.id"
 *       table:
 *         type: array
 *         items:
 *           type: string
 *         example: ["users", "user_details", "user_roles", "user_roles"]
 *       action:
 *         type: array
 *         items:
 *           type: string
 *         example: ["update", "update", "hard_delete", "insert"]
 *       conditions:
 *         type: object
 *         properties:
 *           table1:
 *             type: array
 *             items:
 *               type: object
 *               properties:
 *                 uuid:
 *                   type: string
 *                   example: "$unique_id"
 *           table2:
 *             type: array
 *             items:
 *               type: object
 *               properties:
 *                 user_id:
 *                   type: string
 *                   example: "@table1.id"
 *           table3:
 *             type: array
 *             items:
 *               type: object
 *               properties:
 *                 user_id:
 *                   type: string
 *                   example: "@table1.id"
 *       table_mapping:
 *         type: array
 *         items:
 *           type: string
 *         example: ["table1", "table2", "table3", "table4"]
 */
/**
 * @openapi
 * /common/language-content:
 *   post:
 *     tags:
 *       - Language
 *     summary: Language List.
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/LanguageContent'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/import-template/details:
 *   post:
 *     tags:
 *       - Common
 *     summary: Import template details.
 *     requestBody:
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/definitions/ImportMasterTemplateRequest'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/import-template/validate:
 *   post:
 *     tags:
 *       - Common
 *     summary: Import template validate.
 *     requestBody:
 *       content:
 *         multipart/form-data:
 *           schema:
 *             $ref: '#/definitions/ImportMasterTemplateRequest'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/import-template/validate/{template_uuid}/{file_uuid}:
 *   post:
 *     tags:
 *       - Common
 *     summary: Import template validate.
 *     parameters:
 *       - in: path
 *         name: template_uuid
 *         required: true
 *         description: uuid of the template that you are requesting
 *         schema:
 *           type: string
 *           example: b8647c83-1809-4330-8b33-873763cac421
 *       - in: path
 *         name: file_uuid
 *         required: true
 *         description: uuid of the file that you have uploaded
 *         schema:
 *           type: string
 *           example: b8647c83-1809-4330-8b33-873763cac421
 *     requestBody:
 *       content:
 *         'application/json':
 *           schema:
 *             $ref: '#/definitions/GridData'
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/import-template/remove/{file_uuid}:
 *   delete:
 *     tags:
 *       - Common
 *     summary: Import template validate.
 *     parameters:
 *       - in: path
 *         name: file_uuid
 *         required: true
 *         description: uuid of the file that you have uploaded
 *         schema:
 *           type: string
 *           example: a5f37042-df2e-418f-9739-ce5dfb811327
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/import-template/details/{id}:
 *   get:
 *     tags:
 *       - Common
 *     summary: Import template individual field details.
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         description: id of the import template that you have importing
 *         schema:
 *           type: number
 *           example: 1
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/attached-policies/{entity_name}:
 *   get:
 *     tags:
 *       - Common
 *     summary: Fetch attached policy list for the entity
 *     parameters:
 *       - in: path
 *         name: entity_name
 *         required: true
 *         description: name of the entity which is used to fetch policy list
 *         schema:
 *           type: string
 *           example: user
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/get-cron-jobs:
 *   get:
 *     tags:
 *       - Common
 *     summary: Get cron jobs.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/stop-cron-jobs:
 *   get:
 *     tags:
 *       - Common
 *     summary: Stop cron jobs.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/restart-cron-jobs:
 *   get:
 *     tags:
 *       - Common
 *     summary: Restart cron jobs.
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/start-cron-job/{id}:
 *   get:
 *     tags:
 *       - Common
 *     summary: Start cron job by id.
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         description: id of the cron job that you want to start
 *         schema:
 *           type: number
 *           example: 1
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/stop-cron-job/{id}:
 *   get:
 *     tags:
 *       - Common
 *     summary: Stop cron job by id.
 *     parameters:
 *       - in: path
 *         name: id
 *         required: true
 *         description: id of the cron job that you want to stop
 *         schema:
 *           type: number
 *           example: 1
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
/**
 * @openapi
 * /common/execute-child-process/{id}:
 *   post:
 *     tags:
 *       - Common
 *     summary: Execute Background Process.
 *     parameters:
 *       - in: path
 *         name: id
 *         schema:
 *           type: number
 *           example: "1"
 *         required: true
 *         description: Id of the background process
 *     responses:
 *       200:
 *         description: OK
 *     security:
 *       - AccessToken: []
 *       - Language: []
 */
