"use strict";var __awaiter=this&&this.__awaiter||function(e,t,o,r){return new(o||(o=Promise))((function(s,i){function n(e){try{a(r.next(e))}catch(e){i(e)}}function c(e){try{a(r.throw(e))}catch(e){i(e)}}function a(e){var t;e.done?s(e.value):(t=e.value,t instanceof o?t:new o((function(e){e(t)}))).then(n,c)}a((r=r.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.cronController=void 0;const cron_service_1=require("../../services/cron.service"),response_1=require("../../utilities/response"),common_service_1=require("../../services/common.service"),mail_1=require("../../utilities/mail"),path_1=__importDefault(require("path")),fs_1=__importDefault(require("fs")),prisma_service_1=__importDefault(require("../../services/prisma.service")),lcp_cron_1=__importDefault(require("../../utilities/lcp-cron")),config_1=require("../../../config");class CronController{constructor(){this.processEmailJobs=this.processEmailJobs.bind(this),this.processSingleEmailJob=this.processSingleEmailJob.bind(this),this.processMailData=this.processMailData.bind(this)}createCronJobs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=e.body,r=yield cron_service_1.cronService.createCronJobs(o);return(0,response_1.successResponse)(e,t,r,"Success.")}catch(e){o(e)}}))}getCronJobs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}stopCronJobs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{lcp_cron_1.default.stop();const o=lcp_cron_1.default.getStatus();return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}stopCronJob(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=e.params.id;if(lcp_cron_1.default.getStatus().jobs[o]){lcp_cron_1.default.stopJob(`${o}`);const r=lcp_cron_1.default.getStatus();return(0,response_1.successResponse)(e,t,r,"Success.")}return(0,response_1.errorResponse)(e,t,"Job does not exist","Job does not exist",config_1.statusCodes.data_not_found)}catch(e){o(e)}}))}startCronJob(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=e.params.id,r=lcp_cron_1.default.getStatus();if(console.log("jobs",r),r.jobs[o]){lcp_cron_1.default.startJob(`${o}`);const r=lcp_cron_1.default.getStatus();return(0,response_1.successResponse)(e,t,r,"Success.")}return(0,response_1.errorResponse)(e,t,"Job does not exist","Job does not exist",config_1.statusCodes.data_not_found)}catch(e){o(e)}}))}restartCronJobs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{yield lcp_cron_1.default.refreshJobs();const o=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}removeCronJob(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=e.params.id;if(lcp_cron_1.default.getStatus().jobs[o]){lcp_cron_1.default.stopJob(`${o}`),yield cron_service_1.cronService.removeCronJob(parseInt(o));const r=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,r,"Success.")}{yield cron_service_1.cronService.removeCronJob(parseInt(o));const r=yield cron_service_1.cronService.getCronJobs();return(0,response_1.successResponse)(e,t,r,"Success.")}}catch(e){o(e)}}))}updateCronJob(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=e.body,r=parseInt(e.params.id);if(isNaN(r))return(0,response_1.errorResponse)(e,t,"Invalid job ID: must be a number");lcp_cron_1.default.stopJob(r.toString());const s=yield cron_service_1.cronService.updateCronJob(r,o);return(0,response_1.successResponse)(e,t,Object.assign(Object.assign({},s),{message:"Cron job updated successfully"}),"Success")}catch(e){o(e)}}))}processAuditLogs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield cron_service_1.cronService.runScheduledJob("cron/truncate-audit-logs",cron_service_1.cronService.processAuditLogs);return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}processRequestLogs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield cron_service_1.cronService.runScheduledJob("cron/truncate-request-logs",cron_service_1.cronService.processRequestLogs);return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}scheduleImportJob(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield cron_service_1.cronService.runScheduledJob("cron/schedule-import-job",cron_service_1.cronService.scheduleImportJob);return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}processEmailJobs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield cron_service_1.cronService.runScheduledJob("cron/process-email-jobs",(()=>__awaiter(this,void 0,void 0,(function*(){const e=yield cron_service_1.cronService.getProcessEmailJobs(),t=yield Promise.all(e.map(this.processSingleEmailJob)),o=e.map((e=>e.id));let r=t.flat().filter((e=>null!==e));return r.length>0&&(yield this.insertNotificationJobs(r)),o.length>0&&(yield cron_service_1.cronService.updateProcessEmailJobs(o)),{status:"success",message:`Processed ${r.length} email jobs.`}}))));return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}processSingleEmailJob(e){return __awaiter(this,void 0,void 0,(function*(){const{unique_id:t,user_id:o,email_template_process_slug:r,prefill_data:s,company_id:i,created_by:n,attachments_name:c,attachments_path:a}=e,l=yield cron_service_1.cronService.getEmailProcess(i,r);if(!l)return null;let _=this.replacePlaceholders(l.query_information||"",t,o,s);const u=_?yield this.getTagData(_,i):{},d=yield cron_service_1.cronService.getAssignedMailData(l.id);return(yield Promise.all(d.map((e=>this.processMailData(e,u,o,s,c,a,i,n,r))))).filter((e=>null!==e))}))}replacePlaceholders(e,t,o,r){if(e=(e=e.replace(/@process\.unique_id/g,t)).replace(/@process\.user_id/g,`${o||0}`),r){const t=JSON.parse(r);for(const o in t)if(t.hasOwnProperty(o)){const r=new RegExp(`@process\\.prefill_data\\.${o}`,"g");e=e.replace(r,t[o]||"")}}return e}getTagData(e,t){return __awaiter(this,void 0,void 0,(function*(){const o=JSON.parse(e),r=yield common_service_1.commonService.getTableData(t,o);return(null==r?void 0:r.total_records)>0?r.records[0]:{}}))}processMailData(e,t,o,r,s,i,n,c,a){return __awaiter(this,void 0,void 0,(function*(){const{recipient_type:l,email_to:_,email_template_cc_bcc:u,email_template:d}=e;let p=this.parseEmailToArray(_);if("tag"===l&&(p=yield this.getEmailsForTagRecipients(p,o,r,n)),p.length>0){const e=Object.assign(Object.assign({},JSON.parse(r||"{}")),t),l=yield this.replaceContentPlaceholders(d.template_body,e),_=yield this.replaceContentPlaceholders(d.subject,e);let h="",f=[],v="",m=[];for(let e of u){let t=this.parseEmailToArray(e.email_to);"tag"===e.recipient_type&&(t=yield this.getEmailsForTagRecipients(t,o,r,n)),"cc"===e.send_type?f.push(t.join(", ")):m.push(t.join(", "))}return f.length&&(h+=f.join(", ")),m.length&&(v+=m.join(", ")),p.map((e=>({process_slug:a,notification_type_id:"ac4",notification_status_id:"ac7",notification_to:e,notification_subject:_,attachments_name:s,attachments_path:i,notification_content:l,notification_cc:h,notification_bcc:v,company_id:n,created_by:c})))}return null}))}parseEmailToArray(e){return(null==e?void 0:e.replace(/\s+/g,"").split(","))||[]}getEmailsForTagRecipients(e,t,o,r){return __awaiter(this,void 0,void 0,(function*(){const s=e.map((e=>Number(e))),i=yield cron_service_1.cronService.getMailRecipientTags(s);return(yield Promise.all(i.map((e=>__awaiter(this,void 0,void 0,(function*(){let s=this.replacePlaceholders(e.query_information,"",t,o);const i=JSON.parse(s),n=yield common_service_1.commonService.getTableData(r,i);return!n||n.total_records<1?null:1===n.total_records?n.records[0].email_to||n.records[0].email||null:n.total_records>1?n.records.map((e=>e.email_to||e.email)).filter((e=>null!==e)):void 0})))))).flat().filter((e=>null!==e))}))}replaceContentPlaceholders(e,t){return __awaiter(this,void 0,void 0,(function*(){let o=e;for(const e in t)if(t.hasOwnProperty(e)){const r=Array.isArray(t[e])?yield this.generateTable(t[e]):t[e],s=new RegExp(`\\[${e}\\]`,"g");o=o.replace(s,r||"")}return o}))}generateTable(e){return __awaiter(this,void 0,void 0,(function*(){if(!e||0===e.length)return"";const t=Object.keys(e[0]);let o='<table border="1" cellpadding="5" cellspacing="0"><thead><tr>';return t.forEach((e=>o+=`<th>${e}</th>`)),o+="</tr></thead><tbody>",e.forEach((e=>{o+="<tr>",t.forEach((t=>o+=`<td>${e[t]}</td>`)),o+="</tr>"})),o+="</tbody></table>",o}))}insertNotificationJobs(e){return __awaiter(this,void 0,void 0,(function*(){try{yield cron_service_1.cronService.insertNotificationJobs(e.flat())}catch(e){throw new Error(`Failed to insert notification jobs: ${null==e?void 0:e.message}`)}}))}sendEmailJobs(e,t,o){return __awaiter(this,void 0,void 0,(function*(){try{const o=yield cron_service_1.cronService.runScheduledJob("cron/send-email-jobs",(()=>__awaiter(this,void 0,void 0,(function*(){const e=yield cron_service_1.cronService.getNonsentEmailNotifications();let t=[];const o=e.map((e=>__awaiter(this,void 0,void 0,(function*(){const o=`\n                    <!DOCTYPE html>\n                    <html lang="en">\n                    <head>\n                      <meta charset="UTF-8">\n                      <meta name="viewport" content="width=device-width, initial-scale=1.0">\n                      <title>${e.notification_subject}</title>\n                    </head>\n                    <body>\n                      ${e.notification_content}\n                    </body>\n                    </html>`,r={to:e.notification_to||"",subject:e.notification_subject||"",html:o,attachments:[]};if(e.notification_cc&&(r.cc=e.notification_cc),e.notification_bcc&&(r.bcc=e.notification_bcc),e.attachments_path){const t=path_1.default.join(__dirname,"../../../public/",e.attachments_path);fs_1.default.existsSync(t)?(console.log(`📂 Attaching local file: ${t}`),r.attachments.push({filename:e.attachments_name,path:t})):console.warn(`❌ File not found: ${t}`)}try{yield(0,mail_1.sendMail)(r),yield cron_service_1.cronService.updateEmailNotificationStatus(e),console.log(`Notification ${e.id} sent successfully`)}catch(o){t.push({id:e.id,no_of_attempts:e.no_of_attempts}),console.error(`Error sending notification ${e.id}:`,o)}}))));if(yield Promise.all(o),t.length)for(let e of t)yield prisma_service_1.default.notificationJob.update({where:{id:e.id},data:{notification_status_id:"ac7",no_of_attempts:e.no_of_attempts+1}});return{status:"success",message:`Processed ${e.length} emails. Failed: ${t.length}`}}))));return(0,response_1.successResponse)(e,t,o,"Success.")}catch(e){o(e)}}))}}exports.cronController=new CronController;