-- CreateTable
CREATE TABLE "statuses" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "name" TEXT NOT NULL,
    "slug" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER DEFAULT 1,
    "transfer_status" INTEGER DEFAULT 1
);

-- CreateTable
CREATE TABLE "field_types" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "field_type" TEXT NOT NULL,
    "company_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "field_types_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "roles" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "roles_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "departments" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "code" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "department_head_id" INTEGER,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "departments_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "designations" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "code" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "designations_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "users" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "username" TEXT NOT NULL,
    "email" TEXT NOT NULL,
    "email_verified" BOOLEAN NOT NULL DEFAULT false,
    "password" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "role" TEXT NOT NULL DEFAULT 'user',
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "last_login" DATETIME,
    "last_login_device" TEXT,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "users_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "users_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "users_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "users_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "user_details" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "user_id" INTEGER NOT NULL,
    "code" TEXT NOT NULL,
    "first_name" TEXT NOT NULL,
    "last_name" TEXT,
    "designation_id" INTEGER,
    "department_id" INTEGER,
    "profile_pic" TEXT,
    "dob" DATETIME,
    "country_code" TEXT,
    "phone_number" TEXT,
    "gender" TEXT DEFAULT 'male',
    "user_time_zone" TEXT,
    "address" TEXT,
    "culture" TEXT,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER NOT NULL,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "user_details_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_designation_id_fkey" FOREIGN KEY ("company_id", "designation_id") REFERENCES "designations" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_department_id_fkey" FOREIGN KEY ("company_id", "department_id") REFERENCES "departments" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_created_by_fkey" FOREIGN KEY ("company_id", "created_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_updated_by_fkey" FOREIGN KEY ("company_id", "updated_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_details_company_id_deleted_by_fkey" FOREIGN KEY ("company_id", "deleted_by") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "user_roles" (
    "user_id" INTEGER NOT NULL,
    "role_id" INTEGER NOT NULL,
    "company_id" INTEGER NOT NULL,
    "transfer_status" INTEGER DEFAULT 1,

    PRIMARY KEY ("company_id", "user_id", "role_id"),
    CONSTRAINT "user_roles_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_roles_company_id_role_id_fkey" FOREIGN KEY ("company_id", "role_id") REFERENCES "roles" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "app_category_types" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "category_type_id" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "transfer_status" INTEGER DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER
);

-- CreateTable
CREATE TABLE "app_categories" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "category_type_id" TEXT NOT NULL,
    "category_id" TEXT NOT NULL,
    "parent_id" TEXT,
    "name" TEXT NOT NULL,
    "description" TEXT,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "app_categories_parent_id_fkey" FOREIGN KEY ("parent_id") REFERENCES "app_categories" ("category_id") ON DELETE SET NULL ON UPDATE CASCADE,
    CONSTRAINT "app_categories_category_type_id_company_id_fkey" FOREIGN KEY ("category_type_id", "company_id") REFERENCES "app_category_types" ("category_type_id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "app_configurations" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "uuid" TEXT NOT NULL,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "config_key" TEXT NOT NULL,
    "category_id" TEXT NOT NULL,
    "config_value" TEXT,
    "config_file_value" TEXT,
    "config_value_type" TEXT NOT NULL,
    "config_field_type" TEXT NOT NULL,
    "display_config" BOOLEAN NOT NULL DEFAULT true,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "created_by" INTEGER NOT NULL,
    "updated_at" DATETIME,
    "updated_by" INTEGER,
    "deleted_at" DATETIME,
    "deleted_by" INTEGER,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "app_configurations_category_id_company_id_fkey" FOREIGN KEY ("category_id", "company_id") REFERENCES "app_categories" ("category_id", "company_id") ON DELETE RESTRICT ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "menu_types" (
    "id" INTEGER NOT NULL,
    "name" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "menu_types_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "menu" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "slug" TEXT,
    "description" TEXT,
    "menu_type" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER NOT NULL,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "menu_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "wizard_group" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "slug" TEXT NOT NULL,
    "description" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "company_id" INTEGER NOT NULL,
    "transfer_status" INTEGER DEFAULT 1
);

-- CreateTable
CREATE TABLE "wizard_types" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "description" TEXT NOT NULL,
    "company_id" INTEGER NOT NULL,
    "transfer_status" INTEGER DEFAULT 1
);

-- CreateTable
CREATE TABLE "master_entities" (
    "id" INTEGER NOT NULL,
    "uuid" TEXT NOT NULL,
    "name" TEXT NOT NULL,
    "entity_name" TEXT NOT NULL,
    "entity_type" TEXT NOT NULL,
    "primary_table" TEXT,
    "associated_tables" TEXT,
    "query_information" TEXT,
    "form_information" TEXT,
    "add_query_information" TEXT,
    "edit_query_information" TEXT,
    "preset_query_information" TEXT,
    "static_page_content" TEXT,
    "dashboard_wizard_group_id" INTEGER,
    "dashboard_wizard_type" TEXT,
    "dashboard_wizard_rows" INTEGER,
    "dashboard_wizard_columns" INTEGER,
    "dashboard_wizard_order_no" DECIMAL DEFAULT 0,
    "dashboard_wizard_options" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "master_entities_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "master_entity_line_items" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "master_grid_id" INTEGER NOT NULL,
    "field_name" TEXT NOT NULL,
    "display_name" TEXT NOT NULL,
    "width" INTEGER DEFAULT 0,
    "format" TEXT,
    "is_default" BOOLEAN NOT NULL DEFAULT true,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "is_grid_column" BOOLEAN NOT NULL DEFAULT true,
    "is_searchable" BOOLEAN NOT NULL DEFAULT true,
    "is_sortable" BOOLEAN NOT NULL DEFAULT true,
    "field_type_id" INTEGER NOT NULL,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "master_entity_line_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "master_entity_line_items_company_id_master_grid_id_fkey" FOREIGN KEY ("company_id", "master_grid_id") REFERENCES "master_entities" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "master_entity_line_items_company_id_field_type_id_fkey" FOREIGN KEY ("company_id", "field_type_id") REFERENCES "field_types" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "permissions" (
    "id" INTEGER NOT NULL,
    "name" TEXT NOT NULL,
    "slug" TEXT NOT NULL,
    "entity_id" INTEGER,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_at" TEXT NOT NULL DEFAULT (datetime('now')),
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "permissions_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "permissions_company_id_entity_id_fkey" FOREIGN KEY ("company_id", "entity_id") REFERENCES "master_entities" ("company_id", "id") ON DELETE RESTRICT ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "menu_items" (
    "id" INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
    "menu_id" INTEGER NOT NULL,
    "name" TEXT NOT NULL,
    "target" TEXT,
    "parent_id" INTEGER,
    "permission_id" INTEGER,
    "entity_id" INTEGER,
    "link_type" INTEGER,
    "order_no" DECIMAL NOT NULL DEFAULT 0,
    "menu_img" TEXT,
    "short_cut_keys" TEXT,
    "status_id" INTEGER NOT NULL DEFAULT 1,
    "company_id" INTEGER NOT NULL,
    "created_by" INTEGER,
    "updated_by" INTEGER,
    "deleted_by" INTEGER,
    "created_at" TEXT DEFAULT (datetime('now')),
    "updated_at" DATETIME,
    "deleted_at" DATETIME,
    "transfer_status" INTEGER DEFAULT 1,
    CONSTRAINT "menu_items_status_id_fkey" FOREIGN KEY ("status_id") REFERENCES "statuses" ("id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateTable
CREATE TABLE "user_permissions" (
    "user_id" INTEGER NOT NULL,
    "permission_id" INTEGER NOT NULL,
    "company_id" INTEGER NOT NULL,
    "transfer_status" INTEGER DEFAULT 1,

    PRIMARY KEY ("company_id", "user_id", "permission_id"),
    CONSTRAINT "user_permissions_company_id_user_id_fkey" FOREIGN KEY ("company_id", "user_id") REFERENCES "users" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE,
    CONSTRAINT "user_permissions_company_id_permission_id_fkey" FOREIGN KEY ("company_id", "permission_id") REFERENCES "permissions" ("company_id", "id") ON DELETE CASCADE ON UPDATE CASCADE
);

-- CreateIndex
CREATE UNIQUE INDEX "statuses_id_key" ON "statuses"("id");

-- CreateIndex
CREATE UNIQUE INDEX "statuses_slug_key" ON "statuses"("slug");

-- CreateIndex
CREATE UNIQUE INDEX "field_types_company_id_id_key" ON "field_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "roles_company_id_id_key" ON "roles"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "roles_company_id_uuid_key" ON "roles"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "departments_company_id_id_key" ON "departments"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "departments_company_id_uuid_key" ON "departments"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "designations_company_id_id_key" ON "designations"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "designations_company_id_uuid_key" ON "designations"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_uuid_key" ON "users"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_email_role_key" ON "users"("company_id", "email", "role");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_username_key" ON "users"("company_id", "username");

-- CreateIndex
CREATE UNIQUE INDEX "users_company_id_id_key" ON "users"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "user_details_company_id_user_id_key" ON "user_details"("company_id", "user_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_company_id_category_type_id_key" ON "app_category_types"("company_id", "category_type_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_company_id_id_key" ON "app_category_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "app_category_types_company_id_name_key" ON "app_category_types"("company_id", "name");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_category_id_key" ON "app_categories"("category_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_company_id_category_id_key" ON "app_categories"("company_id", "category_id");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_company_id_id_key" ON "app_categories"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "app_categories_company_id_name_key" ON "app_categories"("company_id", "name");

-- CreateIndex
CREATE UNIQUE INDEX "app_configurations_company_id_id_key" ON "app_configurations"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "app_configurations_company_id_config_key_key" ON "app_configurations"("company_id", "config_key");

-- CreateIndex
CREATE UNIQUE INDEX "menu_types_company_id_id_key" ON "menu_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "menu_company_id_id_key" ON "menu"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "menu_company_id_uuid_key" ON "menu"("company_id", "uuid");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_group_company_id_id_key" ON "wizard_group"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_group_company_id_slug_key" ON "wizard_group"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_types_company_id_id_key" ON "wizard_types"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "wizard_types_company_id_name_key" ON "wizard_types"("company_id", "name");

-- CreateIndex
CREATE UNIQUE INDEX "master_entities_name_key" ON "master_entities"("name");

-- CreateIndex
CREATE UNIQUE INDEX "master_entities_company_id_id_key" ON "master_entities"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "master_entities_company_id_entity_name_key" ON "master_entities"("company_id", "entity_name");

-- CreateIndex
CREATE UNIQUE INDEX "master_entity_line_items_company_id_id_key" ON "master_entity_line_items"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "master_entity_line_items_company_id_master_grid_id_field_name_display_name_key" ON "master_entity_line_items"("company_id", "master_grid_id", "field_name", "display_name");

-- CreateIndex
CREATE INDEX "permissions_company_id_order_no_idx" ON "permissions"("company_id", "order_no");

-- CreateIndex
CREATE UNIQUE INDEX "permissions_company_id_slug_key" ON "permissions"("company_id", "slug");

-- CreateIndex
CREATE UNIQUE INDEX "permissions_company_id_id_key" ON "permissions"("company_id", "id");

-- CreateIndex
CREATE UNIQUE INDEX "menu_items_company_id_id_key" ON "menu_items"("company_id", "id");
