import { PrismaClient } from '@prisma/sql/client';

const prisma = new PrismaClient();

export async function deviceRegistrationSeeder(company_id: number) {
  try {
    console.log("🚀 Starting Device Registration Seeder...");

    // Fetch the user with super_admin role
    const user = await prisma.user.findFirst({
      where: { company_id, role: 'super_admin' },
    });

    if (!user) {
      console.log(`❌ Device Registration Seeder failed: No super_admin user found for company_id ${company_id}`);
      return false;
    }

    const createdBy = user.id;
    const utcNow = new Date();

    // Sample data for device registration
    const sampleDeviceRegistration = {
      company_id,
      device_name: 'Sample Device',
      device_unique_id: 'unique-id-5678',
      user_id: 1, // Replace with an actual user ID that exists in your database
      status_id: 1, // Assuming this corresponds to a valid status ID
      created_by: createdBy,
      created_at: utcNow,
      updated_by: createdBy,
      updated_at: utcNow,
      deleted_by: null,
      deleted_at: null,
    };

    // Use upsert to insert or update the device registration
    const deviceRegistration = await prisma.deviceRegistration.upsert({
      where: {
        company_id_device_unique_id: {
          company_id,
          device_unique_id: sampleDeviceRegistration.device_unique_id,
        },
      },
      update: {
        device_name: sampleDeviceRegistration.device_name,
        user_id: sampleDeviceRegistration.user_id,
        status_id: sampleDeviceRegistration.status_id,
        updated_by: createdBy,
        updated_at: utcNow,
      },
      create: sampleDeviceRegistration,
    });

    console.log(`✅ Device Registration Created/Updated: ${deviceRegistration.device_name}`);
    return true;
  } catch (error) {
    console.error(`❌ Error in deviceRegistrationSeeder: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
