import { PrismaClient } from '@prisma/pg/client';

const prisma = new PrismaClient();

const actionTypes = [
  { id: 1, name: 'view', description: 'view' },
  { id: 2, name: 'add', description: 'add' },
  { id: 3, name: 'edit', description: 'edit' },
  { id: 4, name: 'delete', description: 'delete' },
  { id: 5, name: 'details', description: 'details' },
  { id: 6, name: 'export_excel', description: 'export_excel' },
  { id: 7, name: 'import', description: 'import' },
  { id: 8, name: 'record_export', description: 'record_export' },
  { id: 9, name: 'assign', description: 'assign' },
  { id: 10, name: 'print', description: 'print' },
  { id: 11, name: 'email_resend', description: 'email_resend' },
  { id: 12, name: 'generate_vector', description: 'generate_vector' },
  { id: 13, name: 'child_details', description: 'child_details' },
  { id: 14, name: 'popup_add', description: 'popup_add' },
  { id: 15, name: 'popup_edit', description: 'popup_edit' },
  { id: 16, name: 'popup_details', description: 'popup_details' },
];

export async function actionTypeSeeder(company_id: number) {
  try {
    // Delete existing entities to avoid conflicts (optional)
    await prisma.actionType.deleteMany();

    for (const actionType of actionTypes) {
      const existingActionType = await prisma.actionType.findUnique({
        where: { id: actionType.id },
      });

      if (!existingActionType) {
        await prisma.actionType.create({
          data: {
            id: actionType.id,
            name: actionType.name,
            description: actionType.description,
            company_id: company_id,
          },
        });
        console.log(
          `Created actionType with id ${actionType.id}: ${actionType.name}`,
        );
      } else {
        console.log(`actionType with id ${actionType.id} already exists.`);
      }
    }
  } catch (error) {
    console.error(`Error in actionTypeSeeder: ${error}`);
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}
