import { PrismaClient } from '@prisma/pg/client';
const prisma = new PrismaClient();
import fs from 'fs';
const whatsappTemplateProcessSeeder = JSON.parse(fs.readFileSync(__dirname + '/json/whatsapp-template-process.json', 'utf-8'));
const whatsappTemplateTagsSeeder = JSON.parse(fs.readFileSync(__dirname + '/json/whatsapp-tags.json', 'utf-8'));
const whatsappRecipientsSeeder = JSON.parse(fs.readFileSync(__dirname + '/json/whatsapp-recipients.json', 'utf-8'));

async function findOrCreateProcess(process: any, company_id: number) {
    try {
        let templateProcess = await prisma.whatsappTemplateProcess.findUnique({
            where: {
                company_id_slug: { company_id, slug: process.slug }
            }
        });

        if (!templateProcess) {
        let data = {
            ...process,
            company_id,
            query_information: '',
        };
        if (process.query_information) {
            data.query_information = JSON.stringify(process.query_information);
        }

        templateProcess = await prisma.whatsappTemplateProcess.create({
            data,
        });
        console.log(
            `Whatsapp Template Process created successfully: ${templateProcess.name}`,
        );
        } else {
        let data = {
            ...process,
            query_information: '',
        };
        if (process.query_information) {
            data.query_information = JSON.stringify(process.query_information);
        }

        templateProcess = await prisma.whatsappTemplateProcess.update({
            where: { company_id_slug: { company_id, slug: process.slug } },
            data,
        });
        console.log(
            `Whatsapp Template Process updated successfully: ${templateProcess.name}`,
        );
        }

        return templateProcess;

    } catch (error) {
        console.log(`Whatsapp Template Process seeder failed: ${process.name}`);
        throw error;
    }
}

async function findOrCreateWhatsappTags(tag: any, company_id: number) {
    try {
        let templateTag =  await prisma.whatsappTemplateTag.findUnique({
            where: { company_id_slug: { company_id, slug: tag.slug } },
        });
    
        if (!templateTag) {
          let data = {
            ...tag,
            company_id,
          };
    
          templateTag = await prisma.whatsappTemplateTag.create({
            data,
          });
          console.log(`Whatsapp Template Tag created successfully: ${tag.slug}`);
        } else {
          let data = {
            ...tag,
          };
    
          templateTag = await prisma.whatsappTemplateTag.update({
            where: { company_id_slug: { company_id, slug: tag.slug } },
            data,
          });
          console.log(
            `Whatsapp Template Tag updated successfully: ${templateTag.slug}`,
          );
        }
    
        return templateTag;
    } catch (error) {
        console.log(`Whatsapp Tag Process seeder failed: ${tag.slug}`);
        throw error;
    }
}

async function findOrCreateWhatsappTagsAndTemplateMap(
  map: any,
  company_id: number,
) {
  try {
    console.log('map : ',map);
    const whatsapp_template_process = await prisma.whatsappTemplateProcess.findUnique(
      {
        where: {
          company_id_slug: { company_id, slug: map.whatsapp_template_process },
        },
      },
    );
    const whatsapp_template_tag = await prisma.whatsappTemplateTag.findUnique({
      where: { company_id_slug: { company_id, slug: map.whatsapp_template_tag } },
    });
    if (whatsapp_template_process && whatsapp_template_tag) {
      let templateGroup: any = await prisma.whatsappTemplateProcessTagsMapping.findUnique({
          where: {
            whatsapp_template_process_id_whatsapp_template_tag_id_company_id: {
              whatsapp_template_process_id: whatsapp_template_process.id,
              whatsapp_template_tag_id: whatsapp_template_tag.id,
              company_id,
            },
          },
        });

      if (!templateGroup) {
        let data: any = {
          whatsapp_template_process_id: whatsapp_template_process.id,
          whatsapp_template_tag_id: whatsapp_template_tag.id,
          company_id,
        };

        templateGroup = await prisma.whatsappTemplateProcessTagsMapping.create({
          data,
        });
        console.log(
          `Email Template group map created successfully: ${whatsapp_template_process.id}, ${whatsapp_template_tag.id}, ${company_id}`,
        );
      } else {
        console.log(
          `Email Template group map already exist: ${whatsapp_template_process.id}, ${whatsapp_template_tag.id}, ${company_id}`,
        );
      }

      return templateGroup;
    }
    return false;
  } catch (error) {
    console.log(
      `Email Template group map seeder failed: ${map.whatsapp_template_process}, ${map.whatsapp_template_tag}, ${company_id}`,
    );
    throw error;
  } finally {
    // await prisma.$disconnect();
  }
}

async function findOrCreateWhatsappRecipientTags(tag: any, company_id: number) {
    try {
        let templateTag = await prisma.whatsappTemplateRecipientTag.findUnique({
            where: { company_id_slug: { company_id, slug: tag.slug } },
        });
    
        if (!templateTag) {
            let data = {
            ...tag,
            company_id,
            query_information: '',
            };
            if (tag.query_information) {
            data.query_information = JSON.stringify(tag.query_information);
            }
    
            templateTag = await prisma.whatsappTemplateRecipientTag.create({
            data,
            });
            console.log(
            `Whatsapp Template Recipient Tag created successfully: ${tag.slug}`,
            );
        } else {
            let data = {
            ...tag,
            query_information: '',
            };
            if (tag.query_information) {
            data.query_information = JSON.stringify(tag.query_information);
            }
    
            templateTag = await prisma.whatsappTemplateRecipientTag.update({
                where: { company_id_slug: { company_id, slug: tag.slug } },
                data,
            });
            console.log(
            `Whatsapp Template Recipient Tag updated successfully: ${templateTag.slug}`,
            );
        }
    
        return templateTag;
    } catch (error) {
        console.log(`Whatsapp Reciepient tag Process seeder failed: ${tag.slug}`);
        throw error;
    }
}

export async function whatsappTemplatesProcessSeeder(company_id: number) {
    try {
        const company = await prisma.user.findFirst({
            where: { company_id: company_id },
        });

        if (!company) {
            console.log(
                `WARNING: whatsappTemplatesProcessSeeder: Company with id ${company_id} does not exist.`,
            );
            return;
        }

        const datas = whatsappTemplateProcessSeeder;

        for (const process of datas) {
            await findOrCreateProcess(process, company_id);
        }

        const tags = whatsappTemplateTagsSeeder;

        for (const tag of tags) {
            await findOrCreateWhatsappTags(tag, company_id);
        }

        const whatsappProcessAndTagGroup = [
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_firstname]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_fullname]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_email]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_lastname]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[username]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_phone]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_address]',
            },
            {
                whatsapp_template_process: 'user-created',
                whatsapp_template_tag: '[user_roles]',
            },
            {
                whatsapp_template_process: 'whatsapp-timesheet-approval',
                whatsapp_template_tag: '[user_fullname]',
            },
            {
                whatsapp_template_process: 'whatsapp-timesheet-approval',
                whatsapp_template_tag: '[whatsapp_custom_reason]',
            },
            {
                whatsapp_template_process: 'whatsapp-timesheet-approval',
                whatsapp_template_tag: '[manager_name]',
            },
            {
                whatsapp_template_process: 'whatsapp-timesheet-rejection',
                whatsapp_template_tag: '[user_fullname]',
            },
            {
                whatsapp_template_process: 'whatsapp-timesheet-rejection',
                whatsapp_template_tag: '[whatsapp_custom_reason]',
            },
            {
                whatsapp_template_process: 'whatsapp-timesheet-rejection',
                whatsapp_template_tag: '[manager_name]',
            },
        ];

        for (const map of whatsappProcessAndTagGroup) {
            await findOrCreateWhatsappTagsAndTemplateMap(map, company_id);
        }

        const recipientTags = whatsappRecipientsSeeder;

        for (const tag of recipientTags) {
            await findOrCreateWhatsappRecipientTags(tag, company_id);
        }

        console.log('Email Template process creation completed.');
    }
    catch (error) {
        throw error;
    }
}