import { activitySeeder } from './app-seeds/activity-type-seeds';
import { permissionsSeeder } from './app-seeds/permission-seeds';
import { menuItemsSeeder } from './app-seeds/menu-items-seeds';
import { gridSeeder } from './app-seeds/master-grid-seeds';
import { languageSeeds } from './app-seeds/language-seeds';
import { formEntitiesSeeder } from './app-seeds/form-entity-seeds';
import { languageContentSeeds } from './app-seeds/language-content-seeds';
import { wizardGroupSeeder } from './app-seeds/dashboard-wizard-seeds';
import { emailTemplatesProcessSeeder } from './app-seeds/email-template-process-seeds';
import { emailTemplatesSeeder } from './app-seeds/email-template-seeds';
import { emailTemplateAssignmentsSeeder } from './app-seeds/email-template-assignment-seeds';
import { policiesSeeder } from './app-seeds/policy-seeds';
import { appVersionsSeeder } from './app-seeds/app-version-seeds';
import { scheduledJobSeeder } from './app-seeds/scheduled-job-seeds';
import { logHoursSeeder } from './app-seeds/log-hours-seeds';
import { approvalWorkflowApproverTag } from './app-seeds/approval-workflow-approver-tag-seed';
import { approvalWorkflow } from './app-seeds/approval-workflow-seeds';
import { whatsappTemplatesProcessSeeder } from './app-seeds/whatsapp-template-process-seeds';
import { whatsappTemplateAssignmentsSeeder } from './app-seeds/whatsapp-template-assignment-seeds';
import { whatsappTemplatesSeeder } from './app-seeds/whatsapp-template-seeds';
import { chileProcessSeeder } from './app-seeds/child-process-seeds';

const company_id = 1;

async function applicationSeeders() {
  try {
    await scheduledJobSeeder();
    await scheduledJobSeeder();

    await gridSeeder(company_id);
    await wizardGroupSeeder(company_id);
    await formEntitiesSeeder(company_id);
    await permissionsSeeder(company_id);
    await menuItemsSeeder(company_id);
    // await languageSeeds(company_id);
    await languageContentSeeds(company_id);
    await chileProcessSeeder(company_id);
    await emailTemplatesProcessSeeder(company_id);
    await emailTemplatesSeeder(company_id);
    await emailTemplateAssignmentsSeeder(company_id);
    await policiesSeeder(company_id);
    await appVersionsSeeder(company_id);
    await activitySeeder(company_id);
    await logHoursSeeder(company_id);
    await whatsappTemplatesProcessSeeder(company_id);
    await whatsappTemplatesSeeder(company_id);
    await whatsappTemplateAssignmentsSeeder(company_id);
    await approvalWorkflowApproverTag(company_id);
    //await approvalWorkflow(company_id);
  } catch (error) {
    console.log(`Application seeder error: `, error);
  }
}

applicationSeeders();
