"use strict";var __awaiter=this&&this.__awaiter||function(e,t,r,i){return new(r||(r=Promise))((function(a,o){function s(e){try{c(i.next(e))}catch(e){o(e)}}function n(e){try{c(i.throw(e))}catch(e){o(e)}}function c(e){var t;e.done?a(e.value):(t=e.value,t instanceof r?t:new r((function(e){e(t)}))).then(s,n)}c((i=i.apply(e,t||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.cronService=void 0;const lcp_cron_1=__importDefault(require("../utilities/lcp-cron")),import_master_service_1=require("./import-master.service"),prisma_service_1=__importDefault(require("./prisma.service")),date_fns_1=require("date-fns"),common_service_1=require("../services/common.service");class cronService{static createCronJobs(e){return __awaiter(this,void 0,void 0,(function*(){try{console.log("Creating job with data:",e);return yield prisma_service_1.default.scheduledJob.create({data:{timing:e.timing,cron_url:e.cron_url,concat_base_url:e.concat_base_url,description:e.description}})}catch(e){console.error("Create error details:",e)}}))}static updateCronJob(e,t){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.scheduledJob.update({where:{id:e},data:{timing:t.timing,cron_url:t.cron_url,concat_base_url:t.concat_base_url,description:t.description}})}catch(e){throw console.error("Error updating cron job:",e),e}}))}static getCronJobs(){return __awaiter(this,void 0,void 0,(function*(){return{cron_list:yield prisma_service_1.default.scheduledJob.findMany(),cron_status:lcp_cron_1.default.getStatus()}}))}static removeCronJob(e){return __awaiter(this,void 0,void 0,(function*(){return yield prisma_service_1.default.scheduledJob.delete({where:{id:e}})}))}static runScheduledJob(e,t){return __awaiter(this,void 0,void 0,(function*(){let r=null;try{const i=yield prisma_service_1.default.scheduledJob.findFirst({where:{cron_url:e}});if(!i)throw new Error(`ScheduledJob not found for URL: ${e}`);r=i.id;const a=yield t();return yield prisma_service_1.default.scheduledJobLogs.create({data:{scheduled_job_id:r,executed_statement:`Executed job: ${e}`,schedule_status:a.status,response:a.message}}),a}catch(t){throw r&&(yield prisma_service_1.default.scheduledJobLogs.create({data:{scheduled_job_id:r,executed_statement:`Failed to execute job: ${e}`,schedule_status:"failed",response:t.message||"Unknown error"}})),console.error(`Error running scheduled job: ${e}`,t),t}}))}static processAuditLogs(){return __awaiter(this,void 0,void 0,(function*(){try{const e=new Date;e.setDate(e.getDate()-30);const t=yield prisma_service_1.default.auditLog.findMany({where:{deleted_at:null,created_at:{lt:e}},select:{id:!0}});if(0===t.length)return{status:"success",message:"No old logs to delete."};const r=t.map((e=>e.id));return yield prisma_service_1.default.auditLog.deleteMany({where:{id:{in:r}}}),{status:"success",message:`Marked ${r.length} request logs as deleted.`}}catch(e){throw console.error("Error processing request logs:",e),e}}))}static processRequestLogs(){return __awaiter(this,void 0,void 0,(function*(){try{return{status:"success",message:`Deleted ${(yield prisma_service_1.default.requestLog.deleteMany({})).count} request logs.`}}catch(e){throw console.error("Error deleting request logs:",e),e}}))}static scheduleImportJob(){return __awaiter(this,void 0,void 0,(function*(){var e;try{const t=yield prisma_service_1.default.importJob.findFirst({where:{status_id:1,job_status:{not:"completed"}},orderBy:[{job_status:"desc"},{id:"asc"}]});if(!t)return{status:"success",message:"No pending jobs found."};const{id:r,total_rows:i,batch_process_count:a=50,header_details:o,last_processed_row_id:s}=t,n=t.company_id,c=t.created_by||1,d=Number(null!=i?i:0),_=Number(null!=s?s:0),l=_>0?{id:{gt:_}}:{},u={template_uuid:null==o?void 0:o.selectedTemplate,file_uuid:null==o?void 0:o.fileUploadLog},p=yield prisma_service_1.default.importJobLineItem.findMany({where:Object.assign({import_job_id:r,company_id:n,job_status:{not:"processed"}},l),orderBy:{id:"asc"},take:a,select:{id:!0}});if(0===p.length){const[t,i,a,o]=yield Promise.all([prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:"processed"}}),prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:"invalid"}}),prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:{notIn:["processed","invalid"]}}}),prisma_service_1.default.importJobLineItem.findFirst({where:{import_job_id:r,company_id:n},orderBy:{id:"desc"},select:{id:!0}})]),s=t,c=(d>0?t+i>=d:0===a)?"completed":"in-progress";return yield prisma_service_1.default.importJob.update({where:{id:r},data:{job_status:c,last_processed_row_id:null!==(e=null==o?void 0:o.id)&&void 0!==e?e:_,error_rows:i,completed_rows:s}}),{status:"success",message:"completed"===c?"Job completed.":"No new window to process."}}const m=p.map((e=>e.id)),h=m[m.length-1];yield import_master_service_1.importMasterService.validateImportBatchFromDb(n,u,r,c,m);const f=yield prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:"invalid"}});yield prisma_service_1.default.importJob.update({where:{id:r},data:{error_rows:f}});const y=yield prisma_service_1.default.importJobLineItem.findMany({where:{id:{in:m},import_job_id:r,company_id:n,job_status:"valid"},orderBy:{id:"asc"},select:{id:!0,row_object:!0}});if(0===y.length){const[e,t]=yield Promise.all([prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:"processed"}}),prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:{notIn:["processed","invalid"]}}})]),i=e,a=(d>0?e+f>=d:0===t)?"completed":"in-progress";return yield prisma_service_1.default.importJob.update({where:{id:r},data:{last_processed_row_id:h,job_status:a,completed_rows:i}}),{status:"success",message:"No valid items in this batch window; advanced window."}}const g={row_datas:y.map((e=>e.row_object)).filter(Boolean),ind_row_datas:(null==o?void 0:o.ind_row_datas)||[]};yield import_master_service_1.importMasterService.importTemplateDetail(n,u,g,c);for(const e of y)yield prisma_service_1.default.importJobLineItem.update({where:{id:e.id},data:{job_status:"processed",row_object:Object.assign(Object.assign({},e.row_object),{warning:!1,errorMessages:"This item has been processed successfully",errors:{},warnings:{},errorstatus:'<span class="badge text-xs badge-outline-success">Processed</span>'})}});const[v,w,b]=yield Promise.all([prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:"processed"}}),prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:"invalid"}}),prisma_service_1.default.importJobLineItem.count({where:{import_job_id:r,company_id:n,job_status:{notIn:["processed","invalid"]}}})]),J=v,j=(d>0?v+w>=d:0===b)?"completed":"in-progress";return yield prisma_service_1.default.importJob.update({where:{id:r},data:{last_processed_row_id:h,job_status:j,completed_rows:J,error_rows:w}}),{status:"success",message:"Batch processed successfully."}}catch(e){return console.error("Error processing import job:",e),{status:"error",message:"Error processing import job."}}}))}static getProcessEmailJobs(){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailProcessJob.findMany({orderBy:[{id:"asc"}],where:{status_id:1},take:10})}catch(e){throw console.error("Error getting getProcessEmailJobs:",e),e}}))}static updateProcessEmailJobs(e){return __awaiter(this,arguments,void 0,(function*(e,t=3){try{return yield prisma_service_1.default.emailProcessJob.updateMany({where:{id:{in:e}},data:{status_id:t}})}catch(e){throw console.error("Error getting getProcessEmailJobs:",e),e}}))}static getEmailProcess(e,t){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailTemplateProcess.findFirst({orderBy:[{id:"desc"}],where:{company_id:e,slug:t,status_id:1}})}catch(r){throw console.error(`Error getting getEmailProcess: company_id:${e} slug:${t}`,r),r}}))}static getAssignedMailData(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailTemplateAssignment.findMany({orderBy:[{id:"asc"}],where:{email_template_process_id:e},select:{id:!0,uuid:!0,email_template_process_id:!0,template_id:!0,recipient_type:!0,email_to:!0,email_template_cc_bcc:{select:{id:!0,email_to:!0,recipient_type:!0,send_type:!0}},email_template:{select:{id:!0,uuid:!0,slug:!0,name:!0,subject:!0,template_body:!0}}}})}catch(t){throw console.error(`Error getting getAssignedMailData: email_template_process_id:${e}}`,t),t}}))}static getMailRecipientTags(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.emailTemplateRecipientTag.findMany({orderBy:[{id:"asc"}],where:{id:{in:e}},select:{id:!0,uuid:!0,slug:!0,name:!0,query_information:!0}})}catch(t){throw console.error(`Error getting getMailRecipientTags: email_to_array:${e} `,t),t}}))}static getWhatsappRecipientTags(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappTemplateRecipientTag.findMany({orderBy:[{id:"asc"}],where:{id:{in:e}},select:{id:!0,uuid:!0,slug:!0,name:!0,query_information:!0}})}catch(t){throw console.error(`Error getting getWhatsappRecipientTags: whatsapp_to_array:${e} `,t),t}}))}static getWhatsappProcess(e,t){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappTemplateProcess.findFirst({orderBy:[{id:"desc"}],where:{company_id:e,slug:t,status_id:1}})}catch(r){throw console.error(`Error getting getWhatsappProcess: company_id:${e} slug:${t}`,r),r}}))}static getProcessWhatsappJobs(){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappProcessJob.findMany({orderBy:[{id:"asc"}],where:{status_id:1},take:10})}catch(e){throw console.error("Error getting getProcessWhatsappJobs:",e),e}}))}static processWhatsappSingleJob(e){return __awaiter(this,void 0,void 0,(function*(){var t,r;try{const{unique_id:i,user_id:a,whatsapp_template_process_slug:o,prefill_data:s,company_id:n,created_by:c}=e,d=JSON.parse(s);let _=[],l=[];for(const e in d)d.hasOwnProperty(e)&&(e.includes("header")?_.push({type:"text",text:d[e]}):e.includes("body")&&l.push({type:"text",text:d[e]}));const u=yield cronService.getWhatsappProcess(n,o);if(!u)return{status:!1,data:{}};const p=yield cronService.getAssignedWhatsappData(u.id);for(let i of p){const{recipient_type:o,whatsapp_to:c,whatsapp_template:d}=i;let u=cronService.parseEmailToArray(c);"tag"===o&&(u=yield cronService.getWhatsappForTagRecipients(u,a,s,n));let p=[];for(let a of u)if((null===(t=null==i?void 0:i.whatsapp_template)||void 0===t?void 0:t.language)&&(null===(r=null==i?void 0:i.whatsapp_template)||void 0===r?void 0:r.name)){p.push({name:i.whatsapp_template.name,language:{code:null==d?void 0:d.language},components:[{type:"header",parameters:_},{type:"body",parameters:l}]});for(let t of p){const r={process_slug:null==e?void 0:e.whatsapp_template_process_slug,notification_to:a,notification_subject:void 0,notification_content:void 0,attachments_path:void 0,attachments_name:void 0,notification_cc:void 0,notification_bcc:void 0,notification_type_id:"ac15",notification_status_id:"ac7",notification_type:"whatsapp",whatsapp_notification_data:t,company_id:1,status_id:1,parent_id:0,no_of_attempts:0};yield prisma_service_1.default.notificationJob.create({data:r}),yield prisma_service_1.default.whatsappProcessJob.updateMany({where:{id:e.id},data:{status_id:3}})}}}return{status:!0,data:{}}}catch(e){throw e}}))}static getWhatsappForTagRecipients(e,t,r,i){return __awaiter(this,void 0,void 0,(function*(){const a=e.map((e=>Number(e))),o=yield cronService.getWhatsappRecipientTags(a);return(yield Promise.all(o.map((e=>__awaiter(this,void 0,void 0,(function*(){let a=cronService.replacePlaceholders(e.query_information,"",t,r);const o=JSON.parse(a),s=yield common_service_1.commonService.getTableData(i,o);if(!(null==s?void 0:s.total_records)||s.total_records<1)return null;const n=s.records.map((e=>e.phone_number)).filter((e=>null!=e));return 1===n.length?n[0]:n})))))).flat().filter((e=>null!==e))}))}static insertNotificationJobs(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.notificationJob.createMany({data:e})}catch(t){throw console.error(`Error insertNotificationJobs: jobs:${e} `,t),t}}))}static getNonsentNotifications(){return __awaiter(this,void 0,void 0,(function*(){try{let e=yield prisma_service_1.default.notificationJob.findMany({where:{notification_type_id:{in:["ac4","ac15"]},notification_status_id:"ac7",status_id:1},orderBy:[{id:"asc"}],take:10}),t=e.map((e=>e.id));return yield prisma_service_1.default.notificationJob.updateMany({where:{id:{in:t}},data:{notification_status_id:"ac8"}}),e}catch(e){throw console.error("Error getNonsentEmailNotifications: ",e),e}}))}static updateNotificationStatus(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.notificationJob.update({where:{id:e.id},data:{notification_status_id:"ac9",sent_at:new Date,no_of_attempts:e.no_of_attempts+1}})}catch(t){throw console.error(`Error updateNotificationStatus: notification.id:${e.id} `,t),t}}))}static toUtcMidnight(e){const t=new Date(e);t.setHours(0,0,0,0);return new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),0,0,0,0))}static createWeeklyDates(){return __awaiter(this,void 0,void 0,(function*(){try{const e=(new Date).getFullYear(),t=["January","February","March","April","May","June","July","August","September","October","November","December"];console.log(`Running month-wise week generator for ${e}...`),yield prisma_service_1.default.yearlyWeek.deleteMany({where:{year:e}});let r=(0,date_fns_1.startOfWeek)(new Date(e,0,1),{weekStartsOn:1}),i=(0,date_fns_1.getMonth)(r),a=1;for(yield prisma_service_1.default.yearlyWeek.updateMany({where:{AND:[{NOT:{year:e}},{end_date:{lte:new Date}}]},data:{is_current_year:!1}});;){const o=(0,date_fns_1.startOfWeek)(r,{weekStartsOn:1}),s=(0,date_fns_1.endOfWeek)(r,{weekStartsOn:1}),n=(0,date_fns_1.getYear)(o),c=(0,date_fns_1.getMonth)(o);if(n<e)a++,r=(0,date_fns_1.addWeeks)(r,1);else{if(n>e)break;c!==i&&(a=1,i=c),console.log("data: ",{year:n,weekNumber:a,month:t[c],start_date:this.toUtcMidnight(o),end_date:this.toUtcMidnight(s)}),yield prisma_service_1.default.yearlyWeek.create({data:{year:n,week_number:a,month:t[c],start_date:this.toUtcMidnight(o),end_date:this.toUtcMidnight(s),company_id:1,status_id:1,is_current_year:!0}}),a++,r=(0,date_fns_1.addWeeks)(r,1)}}return[]}catch(e){throw console.error("Error : ",e),e}}))}static replacePlaceholders(e,t,r,i){if(e=(e=e.replace(/@process\.unique_id/g,t)).replace(/@process\.user_id/g,`${r||0}`),i){const t=JSON.parse(i);for(const r in t)if(t.hasOwnProperty(r)){const i=new RegExp(`@process\\.prefill_data\\.${r}`,"g");e=e.replace(i,t[r]||"")}}return e}static getTagData(e,t){return __awaiter(this,void 0,void 0,(function*(){const r=JSON.parse(e),i=yield common_service_1.commonService.getTableData(t,r);return(null==i?void 0:i.total_records)>0?i.records[0]:{}}))}static getAssignedWhatsappData(e){return __awaiter(this,void 0,void 0,(function*(){try{return yield prisma_service_1.default.whatsappTemplateAssignment.findMany({orderBy:[{id:"asc"}],where:{whatsapp_template_process_id:e},select:{id:!0,uuid:!0,whatsapp_template_process_id:!0,template_id:!0,recipient_type:!0,whatsapp_to:!0,whatsapp_template:{select:{name:!0,language:!0}}}})}catch(t){throw console.error(`Error getting getAssignedwhatsappData: whatsapp_template_process_id:${e}}`,t),t}}))}static parseEmailToArray(e){return(null==e?void 0:e.replace(/\s+/g,"").split(","))||[]}static replaceContentPlaceholders(e,t){return __awaiter(this,void 0,void 0,(function*(){let r=e;for(const e in t)if(t.hasOwnProperty(e)){const i=Array.isArray(t[e])?yield cronService.generateTable(t[e]):t[e],a=new RegExp(`\\[${e}\\]`,"g");r=r.replace(a,i||"")}return r}))}static generateTable(e){return __awaiter(this,void 0,void 0,(function*(){if(!e||0===e.length)return"";const t=Object.keys(e[0]);let r='<table border="1" cellpadding="5" cellspacing="0"><thead><tr>';return t.forEach((e=>r+=`<th>${e}</th>`)),r+="</tr></thead><tbody>",e.forEach((e=>{r+="<tr>",t.forEach((t=>r+=`<td>${e[t]}</td>`)),r+="</tr>"})),r+="</tbody></table>",r}))}static syncWhatsappTemplates(){return __awaiter(this,void 0,void 0,(function*(){var e;let t=[];try{const r=["whatsapp_token","whatsapp_business_account"],i=(yield prisma_service_1.default.configurations.findMany({where:{config_key:{in:r}},select:{config_key:!0,config_value:!0}})).reduce(((e,t)=>(e[t.config_key]=t.config_value,e)),{}),a=i.whatsapp_token,o=`https://graph.facebook.com/v18.0/${i.whatsapp_business_account}/message_templates`,s=yield fetch(o,{method:"GET",headers:{Authorization:`Bearer ${a}`,"Content-Type":"application/json"}}).then((e=>e.text())).then((e=>JSON.parse(e)));if(console.log("response : ",s),null===(e=null==s?void 0:s.data)||void 0===e?void 0:e.length){t=s.data,console.log("templates : ",t);for(let e of t)yield prisma_service_1.default.whatsappTemplate.upsert({where:{name:e.name},update:{components:e.components,parameter_format:e.parameter_format,language:e.language,status:{connect:{id:"APPROVED"===e.status?1:3}},category:e.category,deleted_at:"APPROVED"===e.status?null:new Date,company_id:1},create:{name:e.name,components:e.components,parameter_format:e.parameter_format,language:e.language,status:{connect:{id:"APPROVED"===e.status?1:3}},category:e.category,company_id:1}})}}catch(e){throw console.error("Error getting workitem:",e),e}finally{return t}}))}}exports.cronService=cronService;