"use strict";
// Webhook verification route (GET request from Meta)
/**
 * @openapi
 * /hooks/webhook:
 *   get:
 *     tags:
 *       - Webhook
 *     summary: Webhook verification for WhatsApp Cloud API
 *     description: Meta will send a verification GET request with challenge to verify the webhook
 *     parameters:
 *       - name: hub.mode
 *         in: query
 *         required: true
 *         description: Mode of the request (subscribe)
 *       - name: hub.verify_token
 *         in: query
 *         required: true
 *         description: The verification token
 *       - name: hub.challenge
 *         in: query
 *         required: true
 *         description: Challenge token to validate webhook
 *     responses:
 *       200:
 *         description: Successfully verified webhook
 *       403:
 *         description: Forbidden if token does not match
 */
// Webhook for incoming POST requests (messages and events)
/**
 * @openapi
 * /hooks/webhook:
 *   post:
 *     tags:
 *       - Webhook
 *     summary: Handle incoming WhatsApp events (messages, delivery status, etc.)
 *     description: Receives POST events from WhatsApp Cloud API like incoming messages and status updates
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             example:
 *               object: "whatsapp_business_account"
 *               entry:
 *                 - id: "whatsapp_business_account_id"
 *                   changes:
 *                     - value:
 *                         messages:
 *                           - from: "911234567890"
 *                             id: "ABGGFlA5..."
 *                             text:
 *                               body: "Hello! How can I help you today?"
 *                             type: "text"
 *                       field: "messages"
 *     responses:
 *       200:
 *         description: Event received successfully
 *       404:
 *         description: If event source is not WhatsApp
 */ 
