"use strict";
/**
 * @openapi
 * /azure/projects:
 *   get:
 *     summary: Get all Azure DevOps projects
 *     tags:
 *       - Azure
 *     responses:
 *       200:
 *         description: List of projects
 */
/**
 * @openapi
 * /azure/workitems:
 *   get:
 *     summary: Get work items updated in last 24 hours
 *     tags: [Azure]
 *     responses:
 *       200:
 *         description: List of work items
 */
/**
 * @openapi
 * /azure/users:
 *   get:
 *     summary: Get all Azure DevOps users
 *     tags: [Azure]
 *     responses:
 *       200:
 *         description: List of users
 */
/**
 * @openapi
 * /azure/timesheet:
 *   post:
 *     summary: Get time sheet data for a user
 *     tags: [Azure]
 *     requestBody:
 *       required: true
 *       content:
 *         application/json:
 *           schema:
 *             type: object
 *             properties:
 *               user_id:
 *                 type: string
 *               start_date:
 *                 type: string
 *                 format: date-time
 *               end_date:
 *                 type: string
 *                 format: date-time
 *     responses:
 *       200:
 *         description: Time sheet data
 */
/**
 * @openapi
 * /azure/user/workitems/{email}:
 *   get:
 *     summary: Get work items assigned to a user
 *     tags: [Azure]
 *     parameters:
 *       - in: path
 *         name: email
 *         required: true
 *         schema:
 *           type: string
 *     responses:
 *       200:
 *         description: List of work items for user
 */
/**
 * @openapi
 * /azure/user/workitems/revisions/{email}:
 *   get:
 *     summary: Get work item revision history for a user
 *     tags: [Azure]
 *     parameters:
 *       - in: path
 *         name: email
 *         required: true
 *         schema:
 *           type: string
 *     responses:
 *       200:
 *         description: List of work item revisions for user
 */ 
