"use strict";var __createBinding=this&&this.__createBinding||(Object.create?function(e,s,r,i){void 0===i&&(i=r);var o=Object.getOwnPropertyDescriptor(s,r);o&&!("get"in o?!s.__esModule:o.writable||o.configurable)||(o={enumerable:!0,get:function(){return s[r]}}),Object.defineProperty(e,i,o)}:function(e,s,r,i){void 0===i&&(i=r),e[i]=s[r]}),__setModuleDefault=this&&this.__setModuleDefault||(Object.create?function(e,s){Object.defineProperty(e,"default",{enumerable:!0,value:s})}:function(e,s){e.default=s}),__importStar=this&&this.__importStar||function(e){if(e&&e.__esModule)return e;var s={};if(null!=e)for(var r in e)"default"!==r&&Object.prototype.hasOwnProperty.call(e,r)&&__createBinding(s,e,r);return __setModuleDefault(s,e),s},__awaiter=this&&this.__awaiter||function(e,s,r,i){return new(r||(r=Promise))((function(o,t){function n(e){try{c(i.next(e))}catch(e){t(e)}}function a(e){try{c(i.throw(e))}catch(e){t(e)}}function c(e){var s;e.done?o(e.value):(s=e.value,s instanceof r?s:new r((function(e){e(s)}))).then(n,a)}c((i=i.apply(e,s||[])).next())}))},__importDefault=this&&this.__importDefault||function(e){return e&&e.__esModule?e:{default:e}};Object.defineProperty(exports,"__esModule",{value:!0}),exports.authController=void 0;const password_service_1=require("../../services/password.service"),jsonwebtoken_1=__importDefault(require("jsonwebtoken")),user_service_1=require("../../services/user.service"),config_1=require("../../../config"),response_1=require("../../utilities/response"),datetime_1=require("../../utilities/datetime"),custom_validations_1=require("../../utilities/custom.validations"),file_upload_1=require("../../utilities/file-upload"),role_service_1=require("../../services/role.service"),common_service_1=require("../../services/common.service"),transaction_query_builder_service_1=require("../../services/transaction-query-builder.service"),XLSX=__importStar(require("xlsx")),path_1=require("path"),powerbi_service_1=require("../../services/powerbi.service"),prisma_service_1=__importDefault(require("../../services/prisma.service")),axios=require("axios");class AuthController{login(e,s,r){return __awaiter(this,void 0,void 0,(function*(){var i,o,t;try{const{role:r}=e.params,{email:n,password:a}=e.body,c=1;let d=yield user_service_1.userService.getUserByUsername(n,c,!0,!0,!0,!1,r),_=!1;if(Object.keys(d).length>0&&"otp"!==config_1.generalSettings.login_type&&(_=yield password_service_1.PasswordService.comparePasswords(a,d.password,d.role)),0!==Object.keys(d).length&&_||!config_1.generalSettings.allow_admin_url_to_sadmin||r!==user_service_1.roleTypes.admin||(d=yield user_service_1.userService.getUserByUsername(n,c,!0,!0,!0,!1,user_service_1.roleTypes.super_admin),Object.keys(d).length>0&&"otp"!==config_1.generalSettings.login_type&&(_=yield password_service_1.PasswordService.comparePasswords(a,d.password,d.role)),0!==Object.keys(d).length&&_||(d=yield user_service_1.userService.getUserByUsername(n,c,!0,!0,!0,!1,user_service_1.roleTypes.company_admin),Object.keys(d).length>0&&"otp"!==config_1.generalSettings.login_type&&(_=yield password_service_1.PasswordService.comparePasswords(a,d.password,d.role)))),0===Object.keys(d).length)throw new response_1.MyError({message:"User with given email not found.",code:config_1.statusCodes.user_defined_error});const l={id:d.id,uuid:d.uuid,email:d.email};if(d.deleted_at)throw new response_1.MyError({message:"Your account has been deleted, Please contact support.",code:config_1.statusCodes.user_defined_error,data:l});if(2==d.status_id)throw new response_1.MyError({message:"Your account has been blocked, Please contact support.",code:config_1.statusCodes.user_defined_error,data:l});if((!0!==config_1.generalSettings.allow_admin_url_to_sadmin||d.role!==user_service_1.roleTypes.super_admin&&d.role!==user_service_1.roleTypes.company_admin||r!==user_service_1.roleTypes.admin)&&r!==d.role)throw new response_1.MyError({message:"Access denied.",code:config_1.statusCodes.access_denied});if("otp"===config_1.generalSettings.login_type){const e=yield user_service_1.userService.updateUserOtp(d.id,d.company_id,user_service_1.OtpPurpose.login),s={data:{table1:[{user_id:`${d.id}`,unique_id:`${e.id}`,created_at:!0,created_by:!0,prefill_data:"{}",email_template_process_slug:"login-otp"}]},table:["email_process_jobs"],action:["insert"],table_mapping:["table1"]},r=yield transaction_query_builder_service_1.transactionQueryBuilderService.executeTransactions(s,c,d.id);throw new response_1.MyError({message:"An OTP has been sent to your email. Please check your inbox.",code:config_1.statusCodes.login_verification,data:r})}if(!_)throw yield prisma_service_1.default.userLoginHistory.create({data:{company_id:d.company_id,user_id:null!==(i=null==d?void 0:d.id)&&void 0!==i?i:0,ip_address:e.ip,user_agent:e.headers["user-agent"],login_status:"FAILED",failure_reason:"Invalid password"}}),new response_1.MyError({message:"Invalid password.",code:config_1.statusCodes.user_defined_error,data:l});if(config_1.generalSettings.email_verification&&!d.email_verified){const e=yield user_service_1.userService.updateUserOtp(d.id,d.company_id,user_service_1.OtpPurpose.verify_email),s={data:{table1:[{user_id:`${d.id}`,unique_id:`${e.id}`,created_at:!0,created_by:!0,prefill_data:"{}",email_template_process_slug:"email-verify"}]},table:["email_process_jobs"],action:["insert"],table_mapping:["table1"]},r=yield transaction_query_builder_service_1.transactionQueryBuilderService.executeTransactions(s,c,d.id);throw new response_1.MyError({message:"An email verification is required. Please check your email to proceed.",code:config_1.statusCodes.email_verification,data:r})}delete d.password,delete d.deleted_by,delete d.deleted_at;const u=config_1.jwtSecret,p=yield common_service_1.commonService.getConfigValues({configKeys:["token_expiration"],categoryIds:["ac1"]}),m=(yield prisma_service_1.default.userLoginHistory.create({data:{company_id:d.company_id,user_id:d.id,ip_address:e.ip,user_agent:e.headers["user-agent"],login_status:"SUCCESS"}}),jsonwebtoken_1.default.sign({id:d.id,uuid:d.uuid,email:d.email,role:d.role,company_id:d.company_id},u,{expiresIn:(null===(o=p[0])||void 0===o?void 0:o.config_value)||config_1.tokenExpiry})),g=yield role_service_1.roleService.getUserRoleAndPermissions(d.id),v=(yield role_service_1.roleService.getPermissions(d.company_id)).flatMap((e=>e.permissions.map((e=>{var s;if((null===(s=null==g?void 0:g.allPermissions)||void 0===s?void 0:s.length)&&d.role!==user_service_1.roleTypes.super_admin&&d.role!==user_service_1.roleTypes.company_admin){const s=g.allPermissions.some((s=>s.id===e.id));return Object.assign(Object.assign({},e),{accessible:s})}return Object.assign(Object.assign({},e),{accessible:d.role===user_service_1.roleTypes.super_admin||d.role===user_service_1.roleTypes.company_admin})})))),y=yield common_service_1.commonService.getVersionInfo(),f={primary_table:"menu_items",sort_columns:[["menu_items.id","asc"]],limit_range:7,select_columns:[["menu_items.id"],["menu_items.name"],["menu_items.menu_img"],["menu_items.target"],["menu_items.parent_id"],["menu_items.permission_id"],["menu_items.link_type"],["menu_items.order_no"],["master_entities.primary_table"],["master_entities.draft_mode"],["master_entities.entity_type","component_class_name"],["master_entities.entity_name"],["master_entities.static_page_content"],["permissions.name","action_slug"]],company_id:d.company_id,includes:[{table_name:"master_entities",join_type:"LEFT",join_condition:"master_entities.id = menu_items.entity_id"},{table_name:"permissions",join_type:"LEFT",join_condition:"permissions.id = menu_items.permission_id"}],search_all:[{column_name:"menu_items.status_id",operator:"=",value:"1"}]},w=yield common_service_1.commonService.getTableData(d.company_id,f),h={primary_table:"themes",sort_columns:[["themes.id","asc"]],limit_range:1e3,select_columns:[["themes.id"],["themes.uuid"],["themes.name"],["themes.description"],["themes.status_id"],["theme_line_items.id","attribute_id"],["theme_line_items.attribute"],["theme_line_items.value"]],company_id:d.company_id,includes:[{table_name:"theme_line_items",join_type:"LEFT",join_condition:"theme_line_items.theme_id = themes.id AND theme_line_items.company_id = themes.company_id"}],search_all:[{column_name:"themes.status_id",operator:"=",value:"1"}]},b=yield common_service_1.commonService.getTableData(d.company_id,h),S={};b.records&&b.records.length>0&&b.records.forEach((e=>{const s=e.id;S[s]||(S[s]={id:e.id,uuid:e.uuid,name:e.name,description:e.description,status_id:e.status_id,theme_line_items:{}}),e.attribute&&null!==e.value&&(S[s].theme_line_items[e.attribute]=e.value)}));let E=null;return[user_service_1.roleTypes.super_admin,user_service_1.roleTypes.company_admin].includes(r)||(E=yield user_service_1.userService.getUserRolePolicies(d.id,g.roles.map((e=>e.id)))),(0,response_1.successResponse)(e,s,Object.assign(Object.assign({},d),{token:m,permissions:v,menu_list:w.records,version_info:y,policies:E&&(null===(t=E[0])||void 0===t?void 0:t.result)||null,theme_info:S}),"User logged in successfully")}catch(e){console.error("Error loging user:",e),r(e)}}))}logout(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{user:r,headers:{device_id:i,device_type:o,fcm_token:t}}=e;return yield prisma_service_1.default.userLoginHistory.updateMany({where:{userId:r.id,logout_time:null},data:{logout_time:new Date}}),(0,response_1.successResponse)(e,s,{user:r,device_id:i,device_type:o,fcm_token:t},"User logged out successfully")}catch(e){console.error("Error logouting user:",e),r(e)}}))}register(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{role:r}=e.params,i=e.body,o=1;if(r===user_service_1.roleTypes.admin||r===user_service_1.roleTypes.super_admin||r===user_service_1.roleTypes.company_admin)throw new response_1.MyError({message:"Access denied.",code:config_1.statusCodes.access_denied});let t=Object.assign(Object.assign({},i),{created_by:0,role:r});const n=yield user_service_1.userService.addUser(t,o);return(0,response_1.successResponse)(e,s,{id:n.id,uuid:n.uuid,email:n.email},"User registration success.")}catch(e){console.error("Error registering user:",e),r(e)}}))}verifyOtp(e,s,r){return __awaiter(this,void 0,void 0,(function*(){var i;try{const{type:r,role:o}=e.params,{otp:t,uuid:n}=e.body,a=1;let c=yield user_service_1.userService.getUserByUuid(n,a,!0,!1,!0);if(!c||0===Object.keys(c).length)throw new response_1.MyError({message:"Invalid user.",code:config_1.statusCodes.invalid_user});if((!0!==config_1.generalSettings.allow_admin_url_to_sadmin||c.role!==user_service_1.roleTypes.super_admin&&c.role!==user_service_1.roleTypes.company_admin||o!==user_service_1.roleTypes.admin)&&o!==c.role)throw new response_1.MyError({message:"Access denied.",code:config_1.statusCodes.access_denied});if(2==c.status_id)throw new response_1.MyError({message:"Your account has been blocked, Please contact support.",code:config_1.statusCodes.user_defined_error});const d="login"===r?user_service_1.OtpPurpose.login:user_service_1.OtpPurpose.verify_email,_=yield user_service_1.userService.getUserOtp(c.id,d);if(t!==_.otp)throw new response_1.MyError({message:"Invalid OTP, Please try again.",code:config_1.statusCodes.invalid_otp});const l=(0,datetime_1.addMinutes)(_.created_at,config_1.generalSettings.otp_validity);if((0,datetime_1.isExpired)(l))throw new response_1.MyError({message:"OTP has been expired, Please try again.",code:config_1.statusCodes.otp_expired});if(user_service_1.userService.updateUserEmailVerified(a,c.id),"login"===r){const r=config_1.jwtSecret,o=yield common_service_1.commonService.getConfigValues({configKeys:["token_expiration"],categoryIds:["ac1"]}),t=jsonwebtoken_1.default.sign({id:c.id,uuid:c.uuid,email:c.email,role:c.role,company_id:c.company_id},r,{expiresIn:(null===(i=o[0])||void 0===i?void 0:i.config_value)||config_1.tokenExpiry}),n=yield role_service_1.roleService.getUserRoleAndPermissions(c.id),a=(yield role_service_1.roleService.getPermissions(c.company_id)).flatMap((e=>e.permissions.map((e=>{var s;if((null===(s=null==n?void 0:n.allPermissions)||void 0===s?void 0:s.length)&&c.role!==user_service_1.roleTypes.super_admin){const s=n.allPermissions.some((s=>s.id===e.id));return Object.assign(Object.assign({},e),{accessible:s})}return Object.assign(Object.assign({},e),{accessible:c.role===user_service_1.roleTypes.super_admin})}))));return(0,response_1.successResponse)(e,s,Object.assign(Object.assign({},c),{token:t,permissions:a}),"User logged in successfully")}return(0,response_1.successResponse)(e,s,{id:c.id,uuid:c.uuid,email:c.email},"Email verification success.")}catch(e){console.error("Error verifing user otp:",e),r(e)}}))}passwordRequest(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{email:r,role:i}=e.params,o=1;let t=yield user_service_1.userService.getUserByUsername(r,o,!0,!0,!0,!1,i);if(0===Object.keys(t).length&&config_1.generalSettings.allow_admin_url_to_sadmin&&i===user_service_1.roleTypes.admin&&(t=yield user_service_1.userService.getUserByUsername(r,o,!0,!0,!0,!1,user_service_1.roleTypes.super_admin),0===Object.keys(t).length&&(t=yield user_service_1.userService.getUserByUsername(r,o,!0,!0,!0,!1,user_service_1.roleTypes.company_admin))),0===Object.keys(t).length)throw new response_1.MyError({message:"Invalid user email given.",code:config_1.statusCodes.user_defined_error});if(t.deleted_at)throw new response_1.MyError({message:"Your account has been deleted, Please contact support.",code:config_1.statusCodes.user_defined_error});if(2==t.status_id)throw new response_1.MyError({message:"Your account has been blocked, Please contact support.",code:config_1.statusCodes.user_defined_error});if((!0!==config_1.generalSettings.allow_admin_url_to_sadmin||t.role!==user_service_1.roleTypes.super_admin&&t.role!==user_service_1.roleTypes.company_admin||i!==user_service_1.roleTypes.admin)&&i!==t.role)throw new response_1.MyError({message:"Access denied.",code:config_1.statusCodes.access_denied});const n=yield user_service_1.userService.updateUserOtp(t.id,t.company_id,user_service_1.OtpPurpose.password_reset),a={data:{table1:[{user_id:`${t.id}`,unique_id:`${n.id}`,created_at:!0,created_by:!0,prefill_data:"{}",email_template_process_slug:"forgot-password"}]},table:["email_process_jobs"],action:["insert"],table_mapping:["table1"]};yield transaction_query_builder_service_1.transactionQueryBuilderService.executeTransactions(a,o,t.id);return(0,response_1.successResponse)(e,s,{id:t.id,uuid:t.uuid,email:t.email},"reset_request_sent_for_otp")}catch(e){console.error("Error requesting user password:",e),r(e)}}))}resetPassword(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{otp:r,uuid:i,new_password:o,confirm_password:t}=e.body,{role:n}=e.params,a=1;if(o!==t)throw new response_1.MyError({message:"Password & Confirm password not matched.",code:config_1.statusCodes.invalid_token});const c=yield user_service_1.userService.getUserByUuid(i,a,!0,!1,!0);if(!c||0===Object.keys(c).length)throw new response_1.MyError({message:"Invalid user.",code:config_1.statusCodes.invalid_user});if((!0!==config_1.generalSettings.allow_admin_url_to_sadmin||c.role!==user_service_1.roleTypes.super_admin&&c.role!==user_service_1.roleTypes.company_admin||n!==user_service_1.roleTypes.admin)&&n!==c.role||c.role===user_service_1.roleTypes.super_admin)throw new response_1.MyError({message:"Access denied.",code:config_1.statusCodes.access_denied});if(2==c.status_id)throw new response_1.MyError({message:"Your account has been blocked, Please contact support.",code:config_1.statusCodes.user_defined_error});const d=yield user_service_1.userService.getUserOtp(c.id,user_service_1.OtpPurpose.password_reset);if(r!==d.otp)throw new response_1.MyError({message:"Invalid OTP, Please try again.",code:config_1.statusCodes.invalid_otp});const _=(0,datetime_1.addMinutes)(d.created_at,config_1.generalSettings.otp_validity);if((0,datetime_1.isExpired)(_))throw new response_1.MyError({message:"OTP has been expired, Please try again.",code:config_1.statusCodes.otp_expired});if(config_1.generalSettings.password_criteria&&!(0,custom_validations_1.isStrongPassword)(o))throw new response_1.MyError({message:"Password does not meet the criteria for a strong password.",code:config_1.statusCodes.password_criteria});return yield user_service_1.userService.updateUserPassword(c.id,o),(0,response_1.successResponse)(e,s,{id:c.id,uuid:c.uuid,email:c.email},"password_updated_successfully.")}catch(e){console.error("Error reseting user password:",e),r(e)}}))}resetPasswordAnyUser(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{uuid:r,password:i}=e.body,{company_id:o}=e.user,t=yield user_service_1.userService.getUserByUuid(r,o,!0,!1,!0);if(!t||0===Object.keys(t).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});if(config_1.generalSettings.password_criteria&&!(0,custom_validations_1.isStrongPassword)(i))throw new response_1.MyError({message:"Password does not meet the criteria for a strong password.",code:config_1.statusCodes.password_criteria,data:{id:t.id,uuid:r,email:t.email}});return yield user_service_1.userService.updateUserPassword(t.id,i,t.role),(0,response_1.successResponse)(e,s,{id:t.id,uuid:r,email:t.email},"password_updated_successfully.")}catch(e){console.error("Error Resetting user password:",e),r(e)}}))}changePassword(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{old_password:r,new_password:i}=e.body,{uuid:o,company_id:t}=e.user,n=yield user_service_1.userService.getUserByUuid(o,t,!0,!1,!0);if(!n||0===Object.keys(n).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});if(!(yield password_service_1.PasswordService.comparePasswords(r,n.password,n.role)))throw new response_1.MyError({message:"Incorrect old password.",code:config_1.statusCodes.old_password_invalid,data:{id:n.id,uuid:o,email:n.email}});if(config_1.generalSettings.password_criteria&&!(0,custom_validations_1.isStrongPassword)(i))throw new response_1.MyError({message:"Password does not meet the criteria for a strong password.",code:config_1.statusCodes.password_criteria,data:{id:n.id,uuid:o,email:n.email}});return yield user_service_1.userService.updateUserPassword(n.id,i,n.role),(0,response_1.successResponse)(e,s,{id:n.id,uuid:o,email:n.email},"password_updated_successfully.")}catch(e){console.error("Error changing user password:",e),r(e)}}))}myProfile(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{uuid:r,company_id:i}=e.user,o=yield user_service_1.userService.getUserByUuid(r,i);if(!o||0===Object.keys(o).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});return(0,response_1.successResponse)(e,s,Object.assign({},o),"Success.")}catch(e){console.error("Error getting user detail:",e),r(e)}}))}updateProfile(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{uuid:r,id:i,email:o,company_id:t}=e.user,n=e.body;let a=Object.assign(Object.assign({},n),{email:o,updated_by:i});const c=yield user_service_1.userService.updateUser(r,a,t);return(0,response_1.successResponse)(e,s,c,"Profile updated successfully.")}catch(e){console.error("Error updating profile detail:",e),r(e)}}))}updateProfilePic(e,s,r){return __awaiter(this,void 0,void 0,(function*(){var i,o;try{const{uuid:r,id:t,company_id:n}=e.user;let a=null===(i=e.files)||void 0===i?void 0:i.profile_pic;const c=yield user_service_1.userService.getUserByUuid(r,n);if(!c||0===Object.keys(c).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});if(a){const e=yield(0,file_upload_1.handleFileUpload)([a],"images/profile/");e.length&&(null===(o=e[0])||void 0===o?void 0:o.docName)&&(yield user_service_1.userService.updateUserDetail(c.id,{profile_pic:e[0].docName},c.id))}const d=yield user_service_1.userService.getUserByUuid(r,n);return(0,response_1.successResponse)(e,s,d,"Profile picture updated successfully.")}catch(e){console.error("Error updating profile picture detail:",e),r(e)}}))}getExcelHeaders(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{console.log("Request Body:",e.body);const{file_path:r,header_row:i}=e.body;if(!r||!i)throw new response_1.MyError({message:"File path and header row are required.",code:config_1.statusCodes.user_defined_error});const o=parseInt(i);let t="public";"development"==process.env.NODE_ENV&&(t="src/public");const n=(0,path_1.join)(process.cwd(),t,r);console.log("Full File Path:",n);if(!require("fs").existsSync(n))throw new response_1.MyError({message:"Excel file not found at the specified path.",code:config_1.statusCodes.user_defined_error});try{const r=XLSX.readFile(n,{cellDates:!0,cellNF:!1,cellText:!1});console.log("Workbook Sheets:",r.SheetNames);const i=r.Sheets[r.SheetNames[0]];if(!i)throw new response_1.MyError({message:"Excel file is empty or invalid.",code:config_1.statusCodes.user_defined_error});console.log("Sheet Range:",i["!ref"]);const t=XLSX.utils.decode_range(i["!ref"]||"A1"),a=[],c=o-1;for(let e=t.s.c;e<=t.e.c;++e){const s=XLSX.utils.encode_cell({r:c,c:e}),r=i[s];console.log(`Checking cell ${s}:`,r),r&&r.v&&a.push(String(r.v).trim())}if(console.log("Found Headers:",a),0===a.length)throw new response_1.MyError({message:`No headers found in row ${o}`,code:config_1.statusCodes.user_defined_error});return(0,response_1.successResponse)(e,s,a,"Excel headers retrieved successfully")}catch(e){if(console.error("Excel Processing Error:",e),e instanceof response_1.MyError)throw e;throw new response_1.MyError({message:`Error reading Excel file: ${e.message}`,code:config_1.statusCodes.user_defined_error})}}catch(e){console.error("Error getting Excel headers:",e),r(e)}}))}updateExportFile(e,s,r){return __awaiter(this,void 0,void 0,(function*(){var i,o,t;try{console.log(e);const{uuid:r,id:n,company_id:a}=e.user;let c=null===(i=e.files)||void 0===i?void 0:i.exportfile;const d=yield user_service_1.userService.getUserByUuid(r,a);if(!d||0===Object.keys(d).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});let _="";if(console.log(c),c){const e=yield(0,file_upload_1.handleFileUpload)([c],"export/");e.length&&(null===(o=e[0])||void 0===o?void 0:o.docName)&&(_=null===(t=e[0])||void 0===t?void 0:t.docName)}return console.log(_),(0,response_1.successResponse)(e,s,_,"Export File updated successfully.")}catch(e){console.error("Error updating export file detail:",e),r(e)}}))}updateConfigurationsPic(e,s,r){return __awaiter(this,void 0,void 0,(function*(){var i,o,t;try{console.log(e);const{uuid:r,id:n,company_id:a}=e.user;let c=null===(i=e.files)||void 0===i?void 0:i.pic;const d=yield user_service_1.userService.getUserByUuid(r,a);if(!d||0===Object.keys(d).length)throw new response_1.MyError({message:"User not found.",code:config_1.statusCodes.invalid_user});let _="";if(console.log(c),c){const e=yield(0,file_upload_1.handleFileUpload)([c],"images/config/");e.length&&(null===(o=e[0])||void 0===o?void 0:o.docName)&&(_=null===(t=e[0])||void 0===t?void 0:t.docName)}return console.log(_),(0,response_1.successResponse)(e,s,_,"Configuration picture updated successfully.")}catch(e){console.error("Error updating profile picture detail:",e),r(e)}}))}deleteAccount(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{uuid:r,id:i,company_id:o}=e.user;return yield user_service_1.userService.deleteUser(r,i,o),(0,response_1.successResponse)(e,s,{uuid:r},"Account deleted successfully.")}catch(e){console.error("Error deleting account detail:",e),r(e)}}))}myRoleAndPermissions(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const{id:r,company_id:i,role:o}=e.user,t=yield role_service_1.roleService.getUserRoleAndPermissions(r),n=(yield role_service_1.roleService.getPermissions(i)).flatMap((e=>e.permissions.map((e=>{var s;if((null===(s=null==t?void 0:t.allPermissions)||void 0===s?void 0:s.length)&&o!==user_service_1.roleTypes.super_admin&&o!==user_service_1.roleTypes.company_admin){const s=t.allPermissions.some((s=>s.id===e.id));return Object.assign(Object.assign({},e),{accessible:s})}return Object.assign(Object.assign({},e),{accessible:o===user_service_1.roleTypes.super_admin||o===user_service_1.roleTypes.company_admin})}))));return(0,response_1.successResponse)(e,s,n,"Success.")}catch(e){console.error("Error getting my role and permissions:",e),r(e)}}))}getUserMenus(e,s,r){return __awaiter(this,void 0,void 0,(function*(){try{const r=e.user,i=yield user_service_1.userService.getUserMenus(r.company_id,r.id);return(0,response_1.successResponse)(e,s,i,"Success.")}catch(e){r(e)}}))}generateReportEmbedToken(e,s,r){return __awaiter(this,void 0,void 0,(function*(){var i,o,t;const n=yield powerbi_service_1.PowerbiService.getPowerBiConfigValues(),a=Object.assign(Object.assign({},n&&n),{groupId:(null===(i=null==e?void 0:e.query.groupId)||void 0===i?void 0:i.trim())||"",reportId:(null===(o=null==e?void 0:e.query.reportId)||void 0===o?void 0:o.trim())||""}),c=`https://login.microsoftonline.com/${a.tenantId}/oauth2/v2.0/token`;try{const r=yield powerbi_service_1.PowerbiService.getAccessToken(a,c);if(!r)throw new Error("Failed to fetch access token");const i=yield powerbi_service_1.PowerbiService.getReportEmbedToken(a,"https://api.powerbi.com/v1.0/myorg",r);return(0,response_1.successResponse)(e,s,i.data.token,"Success.")}catch(e){console.error("Error generating embed token:",(null===(t=e.response)||void 0===t?void 0:t.data)||e.message),r(e)}}))}}exports.authController=new AuthController;