import {
  MenuMapService
} from "./chunk-3FLJCSSF.js";
import {
  LocalStorageService
} from "./chunk-P7K2QEDI.js";
import {
  BehaviorSubject,
  CommonModule,
  NgClass,
  NgIf,
  ViewContainerRef,
  catchError,
  map,
  of,
  ɵsetClassDebugInfo,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵinject,
  ɵɵloadQuery,
  ɵɵnamespaceSVG,
  ɵɵnextContext,
  ɵɵproperty,
  ɵɵqueryRefresh,
  ɵɵtemplate,
  ɵɵtemplateRefExtractor,
  ɵɵviewQuery
} from "./chunk-GKZIWABI.js";
import {
  __spreadProps,
  __spreadValues
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/service/common/menu-load.service.ts
var _MenuLoadService = class _MenuLoadService {
  constructor(menuMapService, localStorageService) {
    this.menuMapService = menuMapService;
    this.localStorageService = localStorageService;
    this.menuSubject = new BehaviorSubject(null);
    this.unorgMenuSubject = new BehaviorSubject(null);
  }
  getMenuList() {
    const storedMenuList = this.localStorageService.getData("menuList");
    if (storedMenuList) {
      this.menuSubject.next(JSON.parse(storedMenuList));
    }
    return this.menuSubject.asObservable();
  }
  getUnorgMenuList() {
    const storedUnorgMenuList = this.localStorageService.getData("unorgmenuList");
    if (storedUnorgMenuList) {
      this.unorgMenuSubject.next(JSON.parse(storedUnorgMenuList));
    }
    return this.unorgMenuSubject.asObservable();
  }
  organizeMenu(menuList) {
    const itemMap = /* @__PURE__ */ new Map();
    menuList.forEach((item) => {
      itemMap.set(item.id, __spreadProps(__spreadValues({}, item), { children: [] }));
    });
    menuList.forEach((item) => {
      if (item.parent_id !== null) {
        const parent = itemMap.get(item.parent_id);
        if (parent) {
          parent.children.push(itemMap.get(item.id));
        }
      }
    });
    return menuList.filter((item) => item.parent_id === null).map((item) => itemMap.get(item.id)).sort((a, b) => a.order_no - b.order_no);
  }
  fetchConfigData(companyId, userID) {
    const userConfigPayload = {
      company_id: companyId,
      primary_table: "app_user_configurations",
      sort_columns: [["app_user_configurations.id", "asc"]],
      limit_range: 1e3,
      select_columns: [
        ["app_user_configurations.id"],
        ["app_user_configurations.config_key"],
        ["app_user_configurations.category_id"],
        ["app_user_configurations.config_value"],
        ["app_user_configurations.config_value_type"],
        ["app_user_configurations.config_field_type"]
      ],
      includes: [],
      search_all: [
        { column_name: "app_user_configurations.user_id", value: userID, operator: "=" }
      ]
    };
    const processConfig = (finalObject) => {
      const user_data = this.localStorageService.getData("user_data") ? JSON.parse(this.localStorageService.getData("user_data")) : null;
      if (user_data) {
        if (finalObject.encrypt_local_storage == "true") {
          this.localStorageService.storeDataEncrypted("user_data", JSON.stringify(__spreadProps(__spreadValues({}, JSON.parse(this.localStorageService.getData("user_data") || "{}")), {
            user_id: userID
          })));
        } else {
          this.localStorageService.storeData("user_data", JSON.stringify(__spreadProps(__spreadValues({}, JSON.parse(this.localStorageService.getData("user_data") || "{}")), {
            user_id: userID
          })));
          this.localStorageService.removeData("enc_user");
        }
      }
      return true;
    };
    return this.menuMapService.getCommonList(userConfigPayload).pipe(
      map((userResponse) => {
        if (userResponse.code === 200 && userResponse.status && userResponse.data.records.length > 0) {
          const userConfig = userResponse.data.records.reduce((acc, record) => {
            acc[record.config_key] = record.config_value;
            return acc;
          }, {});
          if (userConfig.encrypt_local_storage !== void 0) {
            return processConfig(userConfig);
          }
        }
        const defaultConfigPayload = {
          company_id: companyId,
          primary_table: "app_configurations",
          sort_columns: [["app_configurations.id", "asc"]],
          limit_range: 1e3,
          select_columns: [
            ["app_configurations.id"],
            ["app_configurations.config_key"],
            ["app_configurations.category_id"],
            ["app_configurations.config_value"],
            ["app_configurations.config_value_type"],
            ["app_configurations.config_field_type"]
          ],
          includes: [],
          search_all: []
        };
        return this.menuMapService.getCommonList(defaultConfigPayload).pipe(map((response) => {
          if (response.code === 200 && response.status) {
            const finalObject = response.data.records.reduce((acc, record) => {
              acc[record.config_key] = record.config_value;
              return acc;
            }, {});
            return processConfig(finalObject);
          } else {
            console.warn("Data fetch failed:", response);
            return [];
          }
        }), catchError((error) => {
          console.error("Error fetching data:", error);
          return of([]);
        }));
      }),
      // If the result is an observable (from fallback), flatten it
      // This ensures the return type is always an observable
      // @ts-ignore
      // eslint-disable-next-line @typescript-eslint/no-unsafe-return
      map((result) => result && typeof result.subscribe === "function" ? result : result),
      catchError((error) => {
        console.error("Error fetching user config:", error);
        return of([]);
      })
    );
  }
  fetchMenuData(companyId) {
    const conf = this.localStorageService.getData("config");
    const enc_config = JSON.parse(conf);
    const userData = this.localStorageService.getData("user_data");
    this.user_info = userData ? JSON.parse(userData) : null;
    if (this.user_info && this.user_info.main && this.user_info.main.role) {
      if (this.user_info.main.role !== "super_admin") {
        this.menu_id = [1];
      } else {
        this.menu_id = [1, 2, 5];
      }
    } else {
      console.error("User info, main, or role is missing.");
      this.menu_id = [1];
    }
    const payload = {
      print_query: true,
      company_id: companyId,
      primary_table: "menu_items",
      sort_columns: [["menu_items.order_no", "asc"]],
      limit_range: 1e3,
      select_columns: [
        ["menu_items.id"],
        ["menu_items.menu_id"],
        ["menu_items.name"],
        ["menu_items.menu_img"],
        ["menu_items.target"],
        ["menu_items.parent_id"],
        ["menu_items.permission_id"],
        ["menu_items.link_type"],
        ["menu_items.order_no"],
        ["master_entities.primary_table"],
        ["master_entities.entity_type", "component_class_name"],
        ["master_entities.entity_name"],
        ["master_entities.draft_mode"],
        ["master_entities.static_page_content"],
        ["permissions.name", "action_slug"]
      ],
      includes: [
        {
          table_name: "master_entities",
          join_type: "LEFT",
          join_condition: "master_entities.id = menu_items.entity_id"
        },
        {
          table_name: "permissions",
          join_type: "LEFT",
          join_condition: "permissions.id = menu_items.permission_id"
        }
      ],
      search_all: [
        { column_name: "menu_items.status_id", operator: "=", value: "1" },
        { column_name: "menu_items.menu_id", operator: "IN", value: this.menu_id }
      ]
    };
    return this.menuMapService.getCommonList(payload).pipe(map((response) => {
      if (response.code === 200 && response.status) {
        const organizedMenu = this.organizeMenu(response.data.records);
        const user_data = this.localStorageService.getData("user_data") ? JSON.parse(this.localStorageService.getData("user_data")) : null;
        if (user_data) {
          if (enc_config != null && enc_config.encrypt_local_storage == "true") {
            this.localStorageService.storeDataEncrypted("user_data", JSON.stringify(__spreadProps(__spreadValues({}, JSON.parse(this.localStorageService.getData("user_data") || "{}")), {
              menuList: organizedMenu,
              unorgmenuList: response.data.records
            })));
          } else {
            this.localStorageService.storeData("user_data", JSON.stringify(__spreadProps(__spreadValues({}, JSON.parse(this.localStorageService.getData("user_data") || "{}")), {
              menuList: organizedMenu,
              unorgmenuList: response.data.records
            })));
            this.localStorageService.removeData("enc_user");
          }
        }
        return organizedMenu;
      } else {
        console.warn("Menu data fetch failed:", response);
        return [];
      }
    }), catchError((error) => {
      console.error("Error fetching menu data:", error);
      return of([]);
    }));
  }
  serviceMenus(companyId) {
    this.fetchMenuData(companyId);
    setTimeout(() => {
      window.location.reload();
    }, 1500);
  }
};
_MenuLoadService.\u0275fac = function MenuLoadService_Factory(t) {
  return new (t || _MenuLoadService)(\u0275\u0275inject(MenuMapService), \u0275\u0275inject(LocalStorageService));
};
_MenuLoadService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _MenuLoadService, factory: _MenuLoadService.\u0275fac, providedIn: "root" });
var MenuLoadService = _MenuLoadService;

// src/app/@lcp-framework/shared/icon/menu/icon-menu-dashboard.ts
var _c0 = ["template"];
function IconMenuDashboardComponent_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 1);
    \u0275\u0275element(1, "path", 2)(2, "path", 3);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
var _IconMenuDashboardComponent = class _IconMenuDashboardComponent {
  constructor(viewContainerRef) {
    this.viewContainerRef = viewContainerRef;
    this.class = "ng-star-inserted";
  }
  ngOnInit() {
    this.viewContainerRef.createEmbeddedView(this.template);
    this.viewContainerRef.element.nativeElement.remove();
  }
};
_IconMenuDashboardComponent.\u0275fac = function IconMenuDashboardComponent_Factory(t) {
  return new (t || _IconMenuDashboardComponent)(\u0275\u0275directiveInject(ViewContainerRef));
};
_IconMenuDashboardComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _IconMenuDashboardComponent, selectors: [["icon-menu-dashboard"]], viewQuery: function IconMenuDashboardComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 7);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.template = _t.first);
  }
}, inputs: { class: "class" }, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 2, vars: 0, consts: [["template", ""], ["width", "20", "height", "20", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass"], ["opacity", "0.5", "d", "M2 12.2039C2 9.91549 2 8.77128 2.5192 7.82274C3.0384 6.87421 3.98695 6.28551 5.88403 5.10813L7.88403 3.86687C9.88939 2.62229 10.8921 2 12 2C13.1079 2 14.1106 2.62229 16.116 3.86687L18.116 5.10812C20.0131 6.28551 20.9616 6.87421 21.4808 7.82274C22 8.77128 22 9.91549 22 12.2039V13.725C22 17.6258 22 19.5763 20.8284 20.7881C19.6569 22 17.7712 22 14 22H10C6.22876 22 4.34315 22 3.17157 20.7881C2 19.5763 2 17.6258 2 13.725V12.2039Z", "fill", "currentColor"], ["d", "M9 17.25C8.58579 17.25 8.25 17.5858 8.25 18C8.25 18.4142 8.58579 18.75 9 18.75H15C15.4142 18.75 15.75 18.4142 15.75 18C15.75 17.5858 15.4142 17.25 15 17.25H9Z", "fill", "currentColor"]], template: function IconMenuDashboardComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconMenuDashboardComponent_ng_template_0_Template, 3, 1, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
  }
}, dependencies: [CommonModule, NgClass], encapsulation: 2 });
var IconMenuDashboardComponent = _IconMenuDashboardComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(IconMenuDashboardComponent, { className: "IconMenuDashboardComponent", filePath: "src\\app\\@lcp-framework\\shared\\icon\\menu\\icon-menu-dashboard.ts", lineNumber: 24 });
})();

// src/app/@lcp-framework/shared/icon/icon-mail.ts
var _c02 = ["template"];
function IconMailComponent_ng_template_0__svg_svg_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 3);
    \u0275\u0275element(1, "path", 4)(2, "path", 5);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
function IconMailComponent_ng_template_0__svg_svg_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 6);
    \u0275\u0275element(1, "path", 7)(2, "path", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
function IconMailComponent_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconMailComponent_ng_template_0__svg_svg_0_Template, 3, 1, "svg", 1)(1, IconMailComponent_ng_template_0__svg_svg_1_Template, 3, 1, "svg", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngIf", !ctx_r0.fill);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.fill);
  }
}
var _IconMailComponent = class _IconMailComponent {
  constructor(viewContainerRef) {
    this.viewContainerRef = viewContainerRef;
    this.fill = false;
    this.class = "";
  }
  ngOnInit() {
    this.viewContainerRef.createEmbeddedView(this.template);
    this.viewContainerRef.element.nativeElement.remove();
  }
};
_IconMailComponent.\u0275fac = function IconMailComponent_Factory(t) {
  return new (t || _IconMailComponent)(\u0275\u0275directiveInject(ViewContainerRef));
};
_IconMailComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _IconMailComponent, selectors: [["icon-mail"]], viewQuery: function IconMailComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 7);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.template = _t.first);
  }
}, inputs: { fill: "fill", class: "class" }, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 2, vars: 0, consts: [["template", ""], ["width", "18", "height", "18", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass", 4, "ngIf"], ["width", "18", "height", "18", "viewBox", "0 0 18 18", "fill", "none", 3, "ngClass", 4, "ngIf"], ["width", "18", "height", "18", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass"], ["opacity", "0.5", "d", "M2 12C2 8.22876 2 6.34315 3.17157 5.17157C4.34315 4 6.22876 4 10 4H14C17.7712 4 19.6569 4 20.8284 5.17157C22 6.34315 22 8.22876 22 12C22 15.7712 22 17.6569 20.8284 18.8284C19.6569 20 17.7712 20 14 20H10C6.22876 20 4.34315 20 3.17157 18.8284C2 17.6569 2 15.7712 2 12Z", "stroke", "currentColor", "stroke-width", "1.5"], ["d", "M6 8L8.1589 9.79908C9.99553 11.3296 10.9139 12.0949 12 12.0949C13.0861 12.0949 14.0045 11.3296 15.8411 9.79908L18 8", "stroke", "currentColor", "stroke-width", "1.5", "stroke-linecap", "round"], ["width", "18", "height", "18", "viewBox", "0 0 18 18", "fill", "none", 3, "ngClass"], ["opacity", "0.5", "d", "M10.65 2.25H7.35C4.23873 2.25 2.6831 2.25 1.71655 3.23851C0.75 4.22703 0.75 5.81802 0.75 9C0.75 12.182 0.75 13.773 1.71655 14.7615C2.6831 15.75 4.23873 15.75 7.35 15.75H10.65C13.7613 15.75 15.3169 15.75 16.2835 14.7615C17.25 13.773 17.25 12.182 17.25 9C17.25 5.81802 17.25 4.22703 16.2835 3.23851C15.3169 2.25 13.7613 2.25 10.65 2.25Z", "fill", "currentColor"], ["d", "M14.3465 6.02574C14.609 5.80698 14.6445 5.41681 14.4257 5.15429C14.207 4.89177 13.8168 4.8563 13.5543 5.07507L11.7732 6.55931C11.0035 7.20072 10.4691 7.6446 10.018 7.93476C9.58125 8.21564 9.28509 8.30993 9.00041 8.30993C8.71572 8.30993 8.41956 8.21564 7.98284 7.93476C7.53168 7.6446 6.9973 7.20072 6.22761 6.55931L4.44652 5.07507C4.184 4.8563 3.79384 4.89177 3.57507 5.15429C3.3563 5.41681 3.39177 5.80698 3.65429 6.02574L5.4664 7.53583C6.19764 8.14522 6.79033 8.63914 7.31343 8.97558C7.85834 9.32604 8.38902 9.54743 9.00041 9.54743C9.6118 9.54743 10.1425 9.32604 10.6874 8.97558C11.2105 8.63914 11.8032 8.14522 12.5344 7.53582L14.3465 6.02574Z", "fill", "currentColor"]], template: function IconMailComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconMailComponent_ng_template_0_Template, 2, 2, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
  }
}, dependencies: [CommonModule, NgClass, NgIf], encapsulation: 2 });
var IconMailComponent = _IconMailComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(IconMailComponent, { className: "IconMailComponent", filePath: "src\\app\\@lcp-framework\\shared\\icon\\icon-mail.ts", lineNumber: 39 });
})();

// src/app/@lcp-framework/shared/icon/icon-lock-dots.ts
var _c03 = ["template"];
function IconLockDotsComponent_ng_template_0__svg_svg_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 3);
    \u0275\u0275element(1, "path", 4)(2, "path", 5);
    \u0275\u0275elementStart(3, "g", 6);
    \u0275\u0275element(4, "path", 7)(5, "path", 8)(6, "path", 9);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
function IconLockDotsComponent_ng_template_0__svg_svg_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 10);
    \u0275\u0275element(1, "path", 11)(2, "path", 12)(3, "path", 13)(4, "path", 14)(5, "path", 15);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
function IconLockDotsComponent_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconLockDotsComponent_ng_template_0__svg_svg_0_Template, 7, 1, "svg", 1)(1, IconLockDotsComponent_ng_template_0__svg_svg_1_Template, 6, 1, "svg", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngIf", !ctx_r0.fill);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.fill);
  }
}
var _IconLockDotsComponent = class _IconLockDotsComponent {
  constructor(viewContainerRef) {
    this.viewContainerRef = viewContainerRef;
    this.fill = false;
    this.class = "";
  }
  ngOnInit() {
    this.viewContainerRef.createEmbeddedView(this.template);
    this.viewContainerRef.element.nativeElement.remove();
  }
};
_IconLockDotsComponent.\u0275fac = function IconLockDotsComponent_Factory(t) {
  return new (t || _IconLockDotsComponent)(\u0275\u0275directiveInject(ViewContainerRef));
};
_IconLockDotsComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _IconLockDotsComponent, selectors: [["icon-lock-dots"]], viewQuery: function IconLockDotsComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 7);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.template = _t.first);
  }
}, inputs: { fill: "fill", class: "class" }, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 2, vars: 0, consts: [["template", ""], ["width", "18", "height", "18", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass", 4, "ngIf"], ["width", "18", "height", "18", "viewBox", "0 0 18 18", "fill", "none", 3, "ngClass", 4, "ngIf"], ["width", "18", "height", "18", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass"], ["d", "M2 16C2 13.1716 2 11.7574 2.87868 10.8787C3.75736 10 5.17157 10 8 10H16C18.8284 10 20.2426 10 21.1213 10.8787C22 11.7574 22 13.1716 22 16C22 18.8284 22 20.2426 21.1213 21.1213C20.2426 22 18.8284 22 16 22H8C5.17157 22 3.75736 22 2.87868 21.1213C2 20.2426 2 18.8284 2 16Z", "stroke", "currentColor", "stroke-width", "1.5"], ["opacity", "0.5", "d", "M6 10V8C6 4.68629 8.68629 2 12 2C15.3137 2 18 4.68629 18 8V10", "stroke", "currentColor", "stroke-width", "1.5", "stroke-linecap", "round"], ["opacity", "0.5"], ["d", "M9 16C9 16.5523 8.55228 17 8 17C7.44772 17 7 16.5523 7 16C7 15.4477 7.44772 15 8 15C8.55228 15 9 15.4477 9 16Z", "fill", "currentColor"], ["d", "M13 16C13 16.5523 12.5523 17 12 17C11.4477 17 11 16.5523 11 16C11 15.4477 11.4477 15 12 15C12.5523 15 13 15.4477 13 16Z", "fill", "currentColor"], ["d", "M17 16C17 16.5523 16.5523 17 16 17C15.4477 17 15 16.5523 15 16C15 15.4477 15.4477 15 16 15C16.5523 15 17 15.4477 17 16Z", "fill", "currentColor"], ["width", "18", "height", "18", "viewBox", "0 0 18 18", "fill", "none", 3, "ngClass"], ["opacity", "0.5", "d", "M1.5 12C1.5 9.87868 1.5 8.81802 2.15901 8.15901C2.81802 7.5 3.87868 7.5 6 7.5H12C14.1213 7.5 15.182 7.5 15.841 8.15901C16.5 8.81802 16.5 9.87868 16.5 12C16.5 14.1213 16.5 15.182 15.841 15.841C15.182 16.5 14.1213 16.5 12 16.5H6C3.87868 16.5 2.81802 16.5 2.15901 15.841C1.5 15.182 1.5 14.1213 1.5 12Z", "fill", "currentColor"], ["d", "M6 12.75C6.41421 12.75 6.75 12.4142 6.75 12C6.75 11.5858 6.41421 11.25 6 11.25C5.58579 11.25 5.25 11.5858 5.25 12C5.25 12.4142 5.58579 12.75 6 12.75Z", "fill", "currentColor"], ["d", "M9 12.75C9.41421 12.75 9.75 12.4142 9.75 12C9.75 11.5858 9.41421 11.25 9 11.25C8.58579 11.25 8.25 11.5858 8.25 12C8.25 12.4142 8.58579 12.75 9 12.75Z", "fill", "currentColor"], ["d", "M12.75 12C12.75 12.4142 12.4142 12.75 12 12.75C11.5858 12.75 11.25 12.4142 11.25 12C11.25 11.5858 11.5858 11.25 12 11.25C12.4142 11.25 12.75 11.5858 12.75 12Z", "fill", "currentColor"], ["d", "M5.0625 6C5.0625 3.82538 6.82538 2.0625 9 2.0625C11.1746 2.0625 12.9375 3.82538 12.9375 6V7.50268C13.363 7.50665 13.7351 7.51651 14.0625 7.54096V6C14.0625 3.20406 11.7959 0.9375 9 0.9375C6.20406 0.9375 3.9375 3.20406 3.9375 6V7.54096C4.26488 7.51651 4.63698 7.50665 5.0625 7.50268V6Z", "fill", "currentColor"]], template: function IconLockDotsComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconLockDotsComponent_ng_template_0_Template, 2, 2, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
  }
}, dependencies: [CommonModule, NgClass, NgIf], encapsulation: 2 });
var IconLockDotsComponent = _IconLockDotsComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(IconLockDotsComponent, { className: "IconLockDotsComponent", filePath: "src\\app\\@lcp-framework\\shared\\icon\\icon-lock-dots.ts", lineNumber: 65 });
})();

// src/app/@lcp-framework/shared/icon/icon-user.ts
var _c04 = ["template"];
function IconUserComponent_ng_template_0__svg_svg_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 3);
    \u0275\u0275element(1, "circle", 4)(2, "path", 5);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
function IconUserComponent_ng_template_0__svg_svg_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(0, "svg", 6);
    \u0275\u0275element(1, "circle", 7)(2, "path", 8);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngClass", ctx_r0.class);
  }
}
function IconUserComponent_ng_template_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconUserComponent_ng_template_0__svg_svg_0_Template, 3, 1, "svg", 1)(1, IconUserComponent_ng_template_0__svg_svg_1_Template, 3, 1, "svg", 2);
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275property("ngIf", !ctx_r0.fill);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.fill);
  }
}
var _IconUserComponent = class _IconUserComponent {
  constructor(viewContainerRef) {
    this.viewContainerRef = viewContainerRef;
    this.fill = false;
    this.class = "";
  }
  ngOnInit() {
    this.viewContainerRef.createEmbeddedView(this.template);
    this.viewContainerRef.element.nativeElement.remove();
  }
};
_IconUserComponent.\u0275fac = function IconUserComponent_Factory(t) {
  return new (t || _IconUserComponent)(\u0275\u0275directiveInject(ViewContainerRef));
};
_IconUserComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _IconUserComponent, selectors: [["icon-user"]], viewQuery: function IconUserComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c04, 7);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.template = _t.first);
  }
}, inputs: { fill: "fill", class: "class" }, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 2, vars: 0, consts: [["template", ""], ["width", "18", "height", "18", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass", 4, "ngIf"], ["width", "18", "height", "18", "viewBox", "0 0 18 18", "fill", "none", 3, "ngClass", 4, "ngIf"], ["width", "18", "height", "18", "viewBox", "0 0 24 24", "fill", "none", "xmlns", "http://www.w3.org/2000/svg", 3, "ngClass"], ["cx", "12", "cy", "6", "r", "4", "stroke", "currentColor", "stroke-width", "1.5"], ["opacity", "0.5", "d", "M20 17.5C20 19.9853 20 22 12 22C4 22 4 19.9853 4 17.5C4 15.0147 7.58172 13 12 13C16.4183 13 20 15.0147 20 17.5Z", "stroke", "currentColor", "stroke-width", "1.5"], ["width", "18", "height", "18", "viewBox", "0 0 18 18", "fill", "none", 3, "ngClass"], ["cx", "9", "cy", "4.5", "r", "3", "fill", "currentColor"], ["opacity", "0.5", "d", "M15 13.125C15 14.989 15 16.5 9 16.5C3 16.5 3 14.989 3 13.125C3 11.261 5.68629 9.75 9 9.75C12.3137 9.75 15 11.261 15 13.125Z", "fill", "currentColor"]], template: function IconUserComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, IconUserComponent_ng_template_0_Template, 2, 2, "ng-template", null, 0, \u0275\u0275templateRefExtractor);
  }
}, dependencies: [CommonModule, NgClass, NgIf], encapsulation: 2 });
var IconUserComponent = _IconUserComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(IconUserComponent, { className: "IconUserComponent", filePath: "src\\app\\@lcp-framework\\shared\\icon\\icon-user.ts", lineNumber: 31 });
})();

export {
  IconMenuDashboardComponent,
  MenuLoadService,
  IconMailComponent,
  IconLockDotsComponent,
  IconUserComponent
};
//# sourceMappingURL=chunk-RQRNO3LX.js.map
