import {
  require_FileSaver_min
} from "./chunk-TN2NHK56.js";
import {
  OpenaiService
} from "./chunk-TIV2UYBT.js";
import {
  BooleanStatusPipe,
  NgMultiSelectDropDownModule,
  jspdf_es_min_default,
  readSync,
  utils,
  writeSync
} from "./chunk-YWQICJL7.js";
import {
  require_html2canvas
} from "./chunk-LAL7OD5G.js";
import {
  StaticPageComponent
} from "./chunk-IAAODDF7.js";
import {
  FormBuilderComponent
} from "./chunk-FXJXZPYD.js";
import {
  LoaderComponent
} from "./chunk-X5XWBDVM.js";
import {
  require_sweetalert2_all
} from "./chunk-KLTWPXW2.js";
import {
  MenuMapService
} from "./chunk-3FLJCSSF.js";
import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  CommonSharedModule,
  DynamicFontSizeDirective,
  MenuButtonDirective,
  MenuDirective,
  MenuItemDirective,
  MenuItemsPanelDirective,
  NgScrollbar,
  NgxTippyDirective,
  Store,
  TimezoneService
} from "./chunk-7NQGM4EA.js";
import {
  CheckboxControlValueAccessor,
  DefaultValueAccessor,
  FormBuilder,
  FormControlName,
  FormGroupDirective,
  NgControlStatus,
  NgControlStatusGroup,
  NgModel,
  NgSelectOption,
  ReactiveFormsModule,
  RequiredValidator,
  SelectControlValueAccessor,
  TranslatePipe,
  TranslateService,
  Validators,
  ɵNgNoValidate,
  ɵNgSelectMultipleOption
} from "./chunk-NLYGDKUR.js";
import {
  animate,
  style,
  transition,
  trigger
} from "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  CryptoHttpService,
  GridApiService,
  LocalStorageService,
  Router,
  RouterLink,
  commonConfig,
  environment
} from "./chunk-P7K2QEDI.js";
import {
  BehaviorSubject,
  ChangeDetectorRef,
  DatePipe,
  EventEmitter,
  HttpClient,
  HttpClientModule,
  Location,
  NgClass,
  NgForOf,
  NgIf,
  NgSwitch,
  NgSwitchCase,
  NgSwitchDefault,
  NgTemplateOutlet,
  Observable,
  RendererFactory2,
  Title,
  firstValueFrom,
  lastValueFrom,
  map,
  ɵsetClassDebugInfo,
  ɵɵNgOnChangesFeature,
  ɵɵProvidersFeature,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵattribute,
  ɵɵclassMapInterpolate1,
  ɵɵclassProp,
  ɵɵconditional,
  ɵɵdefineComponent,
  ɵɵdefineInjectable,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementContainer,
  ɵɵelementContainerEnd,
  ɵɵelementContainerStart,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵinject,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnamespaceHTML,
  ɵɵnamespaceSVG,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵpropertyInterpolate1,
  ɵɵpureFunction1,
  ɵɵpureFunction2,
  ɵɵpureFunction4,
  ɵɵqueryRefresh,
  ɵɵreference,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵsanitizeUrl,
  ɵɵtemplate,
  ɵɵtemplateRefExtractor,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty,
  ɵɵviewQuery
} from "./chunk-GKZIWABI.js";
import {
  __async,
  __objRest,
  __spreadProps,
  __spreadValues,
  __toESM
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/service/user/profile-api.service.ts
var _ProfileApiService = class _ProfileApiService {
  constructor(http, cryptoHttp) {
    this.http = http;
    this.cryptoHttp = cryptoHttp;
  }
  getUserProfile() {
    return this.cryptoHttp.encryptedGet(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.getallprofile}`);
  }
  uploadProfilePicture(file) {
    const formData = new FormData();
    formData.append("profile_pic", file, file.name);
    return this.cryptoHttp.encryptedPut(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.updateprofileimage}`, formData, {
      reportProgress: true,
      observe: "events"
    });
  }
  updateUserProfile(formData) {
    return this.cryptoHttp.encryptedPut(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.updateprofile}`, formData);
  }
  changePassword(data) {
    return this.cryptoHttp.encryptedPost(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.updateprofilepwd}`, data);
  }
  resetPasswordAnyUser(data) {
    return this.cryptoHttp.encryptedPost(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.resetuserpwd}`, data);
  }
  forgetPasswordMail(data) {
    return this.cryptoHttp.encryptedGet(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.forgetpasswordEmail}${data}`);
  }
  resetPasswordMail(data) {
    return this.cryptoHttp.encryptedPost(`${environment.apiUrl}${environment.apiAddress}${commonConfig.API.resetpasswordEmail}`, data);
  }
};
_ProfileApiService.\u0275fac = function ProfileApiService_Factory(t) {
  return new (t || _ProfileApiService)(\u0275\u0275inject(HttpClient), \u0275\u0275inject(CryptoHttpService));
};
_ProfileApiService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _ProfileApiService, factory: _ProfileApiService.\u0275fac, providedIn: "root" });
var ProfileApiService = _ProfileApiService;

// src/app/@lcp-framework/service/common/export.service.ts
var import_file_saver = __toESM(require_FileSaver_min());
var import_html2canvas = __toESM(require_html2canvas());
var _ExportService = class _ExportService {
  constructor() {
  }
  exportToExcel(data, fileName) {
    const worksheet = utils.json_to_sheet(data);
    const columnWidths = this.calculateColumnWidths(data);
    worksheet["!cols"] = columnWidths;
    const workbook = { Sheets: { data: worksheet }, SheetNames: ["data"] };
    const excelBuffer = writeSync(workbook, { bookType: "xlsx", type: "array" });
    this.saveAsExcelFile(excelBuffer, fileName);
  }
  calculateColumnWidths(data) {
    const headers = Object.keys(data[0]);
    const columnWidths = headers.map((header) => ({ wch: header.length + 2 }));
    data.forEach((row) => {
      headers.forEach((header, index) => {
        const cellValue = row[header];
        const cellLength = cellValue ? cellValue.toString().length : 0;
        if (columnWidths[index].wch < cellLength + 2) {
          columnWidths[index].wch = cellLength + 2;
        }
      });
    });
    return columnWidths;
  }
  exportToPDF(data, fileName) {
    const table = this.createHtmlTable(data);
    const container = document.createElement("div");
    container.style.position = "absolute";
    container.style.top = "-9999px";
    container.appendChild(table);
    document.body.appendChild(container);
    (0, import_html2canvas.default)(table).then((canvas) => {
      const imgData = canvas.toDataURL("image/png");
      const doc = new jspdf_es_min_default();
      const imgWidth = 190;
      const pageHeight = doc.internal.pageSize.height;
      const imgHeight = canvas.height * imgWidth / canvas.width;
      let heightLeft = imgHeight;
      let position = 0;
      doc.addImage(imgData, "PNG", 10, position, imgWidth, imgHeight);
      heightLeft -= pageHeight;
      while (heightLeft >= 0) {
        position = heightLeft - imgHeight;
        doc.addPage();
        doc.addImage(imgData, "PNG", 10, position, imgWidth, imgHeight);
        heightLeft -= pageHeight;
      }
      doc.save(`${fileName}.pdf`);
      document.body.removeChild(container);
    });
  }
  createHtmlTable(data) {
    const table = document.createElement("table");
    table.style.width = "100%";
    table.style.borderCollapse = "collapse";
    table.style.tableLayout = "fixed";
    const thead = document.createElement("thead");
    const headerRow = document.createElement("tr");
    const headers = Object.keys(data[0] || {});
    headers.forEach((header) => {
      const th = document.createElement("th");
      th.textContent = header;
      th.style.border = "1px solid #000";
      th.style.padding = "8px";
      th.style.wordWrap = "break-word";
      th.style.overflow = "hidden";
      th.style.textOverflow = "ellipsis";
      headerRow.appendChild(th);
    });
    thead.appendChild(headerRow);
    table.appendChild(thead);
    const tbody = document.createElement("tbody");
    data.forEach((row) => {
      const tr = document.createElement("tr");
      headers.forEach((header) => {
        const td = document.createElement("td");
        td.textContent = String(row[header]);
        td.style.border = "1px solid #000";
        td.style.padding = "8px";
        td.style.wordWrap = "break-word";
        td.style.overflow = "hidden";
        td.style.textOverflow = "ellipsis";
        tr.appendChild(td);
      });
      tbody.appendChild(tr);
    });
    table.appendChild(tbody);
    const container = document.createElement("div");
    container.style.width = "100%";
    container.style.overflowX = "auto";
    container.appendChild(table);
    document.body.appendChild(container);
    const tableWidth = table.offsetWidth;
    const pageWidth = 190;
    const scaleFactor = Math.min(1, pageWidth / tableWidth);
    const minScaleFactor = 0.7;
    const finalScaleFactor = Math.max(scaleFactor, minScaleFactor);
    table.style.transform = `scale(${finalScaleFactor})`;
    table.style.transformOrigin = "top left";
    return container;
  }
  saveAsExcelFile(buffer, fileName) {
    const data = new Blob([buffer], { type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet" });
    (0, import_file_saver.saveAs)(data, `${fileName}.xlsx`);
  }
};
_ExportService.\u0275fac = function ExportService_Factory(t) {
  return new (t || _ExportService)();
};
_ExportService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _ExportService, factory: _ExportService.\u0275fac, providedIn: "root" });
var ExportService = _ExportService;

// src/app/@lcp-framework/pages/master-list-children/master-list-children.component.ts
var import_sweetalert2 = __toESM(require_sweetalert2_all());

// src/app/@lcp-framework/components/datatable-children/datatable-children.component.ts
var _c0 = ["searchInput"];
var _c1 = (a0) => [a0];
var _c2 = (a0) => ({ "bh-text-primary": a0 });
var _c3 = (a0) => ({ "cursor-pointer text-blue-600 underline": a0 });
var _c4 = (a0) => ({ $implicit: a0 });
var _c5 = (a0) => ({ "bg-blue-50": a0 });
function DataTableChildrenComponent_span_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 56);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(ctx_r1.getNonEmptyFilterCount());
  }
}
function DataTableChildrenComponent_div_22_ng_container_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "p", 73);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate("No filter applied");
  }
}
function DataTableChildrenComponent_div_22_ng_template_17_div_0_i_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 83);
  }
}
function DataTableChildrenComponent_div_22_ng_template_17_div_0_i_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 84);
  }
}
function DataTableChildrenComponent_div_22_ng_template_17_div_0_option_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 85);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r7 = ctx.$implicit;
    \u0275\u0275property("value", col_r7.field);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(col_r7.title);
  }
}
function DataTableChildrenComponent_div_22_ng_template_17_div_0_option_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 85);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const op_r8 = ctx.$implicit;
    \u0275\u0275property("value", op_r8.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(op_r8.label);
  }
}
function DataTableChildrenComponent_div_22_ng_template_17_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 75);
    \u0275\u0275template(1, DataTableChildrenComponent_div_22_ng_template_17_div_0_i_1_Template, 1, 0, "i", 76)(2, DataTableChildrenComponent_div_22_ng_template_17_div_0_i_2_Template, 1, 0, "i", 77);
    \u0275\u0275elementStart(3, "select", 78);
    \u0275\u0275listener("change", function DataTableChildrenComponent_div_22_ng_template_17_div_0_Template_select_change_3_listener($event) {
      const i_r5 = \u0275\u0275restoreView(_r4).index;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.onColumnChange($event, i_r5));
    });
    \u0275\u0275twoWayListener("ngModelChange", function DataTableChildrenComponent_div_22_ng_template_17_div_0_Template_select_ngModelChange_3_listener($event) {
      const condition_r6 = \u0275\u0275restoreView(_r4).$implicit;
      \u0275\u0275twoWayBindingSet(condition_r6.field, $event) || (condition_r6.field = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementStart(4, "option", 79);
    \u0275\u0275text(5);
    \u0275\u0275pipe(6, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275template(7, DataTableChildrenComponent_div_22_ng_template_17_div_0_option_7_Template, 2, 2, "option", 42);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "select", 80);
    \u0275\u0275twoWayListener("ngModelChange", function DataTableChildrenComponent_div_22_ng_template_17_div_0_Template_select_ngModelChange_8_listener($event) {
      const condition_r6 = \u0275\u0275restoreView(_r4).$implicit;
      \u0275\u0275twoWayBindingSet(condition_r6.operator, $event) || (condition_r6.operator = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementStart(9, "option", 79);
    \u0275\u0275text(10);
    \u0275\u0275pipe(11, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275template(12, DataTableChildrenComponent_div_22_ng_template_17_div_0_option_12_Template, 2, 2, "option", 42);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "input", 81);
    \u0275\u0275listener("ngModelChange", function DataTableChildrenComponent_div_22_ng_template_17_div_0_Template_input_ngModelChange_13_listener($event) {
      const i_r5 = \u0275\u0275restoreView(_r4).index;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.setConditionValue(i_r5, $event));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "button", 69);
    \u0275\u0275listener("click", function DataTableChildrenComponent_div_22_ng_template_17_div_0_Template_button_click_14_listener() {
      const i_r5 = \u0275\u0275restoreView(_r4).index;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.removeCondition(i_r5));
    });
    \u0275\u0275element(15, "i", 82);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const condition_r6 = ctx.$implicit;
    const i_r5 = ctx.index;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx_r1.filterCondition);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.filterCondition);
    \u0275\u0275advance();
    \u0275\u0275twoWayProperty("ngModel", condition_r6.field);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(6, 15, "table_multiselect_1"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx_r1.filteredColumns);
    \u0275\u0275advance();
    \u0275\u0275twoWayProperty("ngModel", condition_r6.operator);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(11, 17, "condition"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx_r1.getOperatorsForColumn(condition_r6.field));
    \u0275\u0275advance();
    \u0275\u0275property("ngModel", ctx_r1.getConditionValue(i_r5))("type", ctx_r1.getInputTypeForColumn(condition_r6.field))("placeholder", ctx_r1.getPlaceholderForColumn(condition_r6.field))("required", true);
    \u0275\u0275attribute("min", ctx_r1.getMinValueForColumn(condition_r6.field))("max", ctx_r1.getMaxValueForColumn(condition_r6.field))("pattern", ctx_r1.getPatternForColumn(condition_r6.field));
  }
}
function DataTableChildrenComponent_div_22_ng_template_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, DataTableChildrenComponent_div_22_ng_template_17_div_0_Template, 16, 19, "div", 74);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngForOf", ctx_r1.filterConditions);
  }
}
function DataTableChildrenComponent_div_22_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 57)(1, "div", 58)(2, "span");
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 59)(6, "button", 60);
    \u0275\u0275listener("click", function DataTableChildrenComponent_div_22_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.addCondition());
    });
    \u0275\u0275element(7, "i", 61);
    \u0275\u0275text(8, "\xA0");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label", 62)(10, "input", 63);
    \u0275\u0275twoWayListener("ngModelChange", function DataTableChildrenComponent_div_22_Template_input_ngModelChange_10_listener($event) {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.filterCondition, $event) || (ctx_r1.filterCondition = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275element(11, "span", 64);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "span");
    \u0275\u0275text(13);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "ng-scrollbar", 65)(15, "div", 66);
    \u0275\u0275template(16, DataTableChildrenComponent_div_22_ng_container_16_Template, 3, 1, "ng-container", 67)(17, DataTableChildrenComponent_div_22_ng_template_17_Template, 1, 1, "ng-template", null, 1, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "div", 68)(20, "button", 69);
    \u0275\u0275listener("click", function DataTableChildrenComponent_div_22_Template_button_click_20_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.clearFilters());
    });
    \u0275\u0275text(21);
    \u0275\u0275pipe(22, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(23, "div", 70)(24, "button", 71);
    \u0275\u0275listener("click", function DataTableChildrenComponent_div_22_Template_button_click_24_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.applyFilters());
    });
    \u0275\u0275text(25);
    \u0275\u0275pipe(26, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(27, "button", 72);
    \u0275\u0275listener("click", function DataTableChildrenComponent_div_22_Template_button_click_27_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.cancelFilters());
    });
    \u0275\u0275text(28);
    \u0275\u0275pipe(29, "translate");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const filterList_r9 = \u0275\u0275reference(18);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(4, 9, "table_advance_filter"));
    \u0275\u0275advance(7);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.filterCondition);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r1.filterCondition ? "AND" : "OR");
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ctx_r1.filterConditions.length === 0)("ngIfElse", filterList_r9);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(22, 11, "table_clear_filter"));
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx_r1.isApplyButtonEnabled());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(26, 13, "apply"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(29, 15, "cancel"));
  }
}
function DataTableChildrenComponent_ul_30_ng_container_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "li")(2, "div", 90)(3, "label", 91)(4, "input", 92);
    \u0275\u0275listener("ngModelChange", function DataTableChildrenComponent_ul_30_ng_container_9_Template_input_ngModelChange_4_listener() {
      const col_r12 = \u0275\u0275restoreView(_r11).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.toggleColumnFilterHide(col_r12));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "span", 93);
    \u0275\u0275text(6);
    \u0275\u0275pipe(7, "translate");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r12 = ctx.$implicit;
    const i_r13 = ctx.index;
    \u0275\u0275advance(3);
    \u0275\u0275property("for", "chk-" + i_r13);
    \u0275\u0275advance();
    \u0275\u0275property("id", "chk-" + i_r13)("ngModel", !col_r12.colFilterHide);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(7, 4, col_r12.header), "");
  }
}
function DataTableChildrenComponent_ul_30_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "ul", 86)(1, "li")(2, "div", 87)(3, "button", 88);
    \u0275\u0275listener("click", function DataTableChildrenComponent_ul_30_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectAll());
    });
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "button", 89);
    \u0275\u0275listener("click", function DataTableChildrenComponent_ul_30_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.clearAll());
    });
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(9, DataTableChildrenComponent_ul_30_ng_container_9_Template, 8, 6, "ng-container", 35);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("@toggleAnimation", void 0);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(5, 4, "select_all"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(8, 6, "clear_all"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx_r1.headercolumns);
  }
}
function DataTableChildrenComponent_div_31_ul_8_a_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 100);
    \u0275\u0275listener("click", function DataTableChildrenComponent_div_31_ul_8_a_2_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.exportTable("excel"));
    });
    \u0275\u0275element(1, "i", 101);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(3, 1, "excel"), " ");
  }
}
function DataTableChildrenComponent_div_31_ul_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ul", 98)(1, "li");
    \u0275\u0275template(2, DataTableChildrenComponent_div_31_ul_8_a_2_Template, 4, 3, "a", 99);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275property("@toggleAnimation", void 0);
  }
}
function DataTableChildrenComponent_div_31_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 94)(1, "div", 21)(2, "button", 95);
    \u0275\u0275element(3, "i", 96);
    \u0275\u0275text(4, " \xA0 ");
    \u0275\u0275elementStart(5, "span", 18);
    \u0275\u0275text(6);
    \u0275\u0275pipe(7, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275template(8, DataTableChildrenComponent_div_31_ul_8_Template, 3, 1, "ul", 97);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(7, 1, "export"), " ");
  }
}
function DataTableChildrenComponent_Conditional_32_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 102);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Conditional_32_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.syncTableSchema());
    });
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "button", 103);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Conditional_32_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.generateVectorForAllTable());
    });
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 2, "sync_table_schema"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(5, 4, "generate_vector_for_all_table"), " ");
  }
}
function DataTableChildrenComponent_button_34_Template(rf, ctx) {
  if (rf & 1) {
    const _r16 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 104);
    \u0275\u0275pipe(1, "translate");
    \u0275\u0275listener("click", function DataTableChildrenComponent_button_34_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r16);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.customAction.emit("addNew"));
    });
    \u0275\u0275element(2, "i", 61);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275propertyInterpolate1("ngxTippy", " ", \u0275\u0275pipeBind1(1, 3, ctx_r1.title), "");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("\xA0", \u0275\u0275pipeBind1(4, 5, "form_button_add_new"), " ");
  }
}
function DataTableChildrenComponent_button_36_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 104);
    \u0275\u0275pipe(1, "translate");
    \u0275\u0275listener("click", function DataTableChildrenComponent_button_36_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r17);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.customAction.emit("addNew"));
    });
    \u0275\u0275element(2, "i", 61);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275propertyInterpolate1("ngxTippy", " ", \u0275\u0275pipeBind1(1, 3, ctx_r1.title), "");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("\xA0", \u0275\u0275pipeBind1(4, 5, "form_button_add_new"), " ");
  }
}
function DataTableChildrenComponent_button_37_Template(rf, ctx) {
  if (rf & 1) {
    const _r18 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 105);
    \u0275\u0275listener("click", function DataTableChildrenComponent_button_37_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r18);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.location.back());
    });
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "back"), " ");
  }
}
function DataTableChildrenComponent_th_43_Template(rf, ctx) {
  if (rf & 1) {
    const _r19 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "th", 106)(1, "input", 107);
    \u0275\u0275listener("change", function DataTableChildrenComponent_th_43_Template_input_change_1_listener($event) {
      \u0275\u0275restoreView(_r19);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.toggleSelectAll($event));
    });
    \u0275\u0275elementEnd()();
  }
}
function DataTableChildrenComponent_ng_container_44_th_1_span_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 111);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(1, "svg", 112);
    \u0275\u0275element(2, "polygon", 113)(3, "polygon", 114);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const col_r21 = \u0275\u0275nextContext(2).$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c2, col_r21.sortDirection === "asc"));
    \u0275\u0275advance();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(4, _c2, col_r21.sortDirection === "desc"));
  }
}
function DataTableChildrenComponent_ng_container_44_th_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "th", 109);
    \u0275\u0275pipe(1, "translate");
    \u0275\u0275listener("click", function DataTableChildrenComponent_ng_container_44_th_1_Template_th_click_0_listener() {
      \u0275\u0275restoreView(_r20);
      const col_r21 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.sortColumn(col_r21));
    });
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275template(4, DataTableChildrenComponent_ng_container_44_th_1_span_4_Template, 4, 6, "span", 110);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r21 = \u0275\u0275nextContext();
    const col_r21 = ctx_r21.$implicit;
    const last_r23 = ctx_r21.last;
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(8, _c1, last_r23 ? "sticky right-0 z-10 bg-gray-50" : ""));
    \u0275\u0275attribute("data-tippy-content", \u0275\u0275pipeBind1(1, 4, col_r21.header));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 6, col_r21.header), " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", col_r21.is_sortable == "true" && col_r21.is_grid_column == "true");
  }
}
function DataTableChildrenComponent_ng_container_44_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_44_th_1_Template, 5, 10, "th", 108);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r21 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r21.is_grid_column == "true" && !col_r21.colFilterHide);
  }
}
function DataTableChildrenComponent_tr_46_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr")(1, "td", 115)(2, "section", 116);
    \u0275\u0275element(3, "div", 117)(4, "div", 117)(5, "div", 117)(6, "div", 117)(7, "div", 117);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275attribute("colspan", ctx_r1.gridColumnCount + (ctx_r1.enableCheckBox ? 1 : 0));
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_td_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r24 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "td")(1, "input", 118);
    \u0275\u0275listener("change", function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_td_1_Template_input_change_1_listener() {
      \u0275\u0275restoreView(_r24);
      const item_r25 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.toggleSelectItem(item_r25));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("checked", ctx_r1.selectedItems.includes(item_r25));
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r26 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "span", 121);
    \u0275\u0275listener("click", function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_container_1_Template_span_click_1_listener() {
      \u0275\u0275restoreView(_r26);
      const col_r27 = \u0275\u0275nextContext(3).$implicit;
      const item_r25 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.onLinkComponentClick(col_r27, item_r25));
    });
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "booleanStatus");
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r27 = \u0275\u0275nextContext(3).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 1, item_r25[col_r27.header]), " ");
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_container_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "a", 122);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "booleanStatus");
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r27 = \u0275\u0275nextContext(4).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("href", col_r27.link_action, \u0275\u0275sanitizeUrl);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 2, item_r25[col_r27.header]), " ");
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 125);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "booleanStatus");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r27 = \u0275\u0275nextContext(5).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(5, _c3, col_r27.link_type === "component"));
    \u0275\u0275attribute("data-tippy-content", item_r25[col_r27.header]);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 3, item_r25[col_r27.header]), " ");
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_template_1_span_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 126);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "booleanStatus");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r27 = \u0275\u0275nextContext(5).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, item_r25[col_r27.header]), " ");
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_Template, 3, 7, "span", 123)(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_template_1_span_1_Template, 3, 3, "span", 124);
  }
  if (rf & 2) {
    const col_r27 = \u0275\u0275nextContext(4).$implicit;
    \u0275\u0275property("ngIf", col_r27.header !== "Status" && col_r27.header !== "table_column_action");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r27.header === "Status" || col_r27.header === "table_column_action");
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_container_0_Template, 4, 4, "ng-container", 67)(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_ng_template_1_Template, 2, 2, "ng-template", null, 4, \u0275\u0275templateRefExtractor);
  }
  if (rf & 2) {
    const defaultCell_r28 = \u0275\u0275reference(2);
    const col_r27 = \u0275\u0275nextContext(3).$implicit;
    \u0275\u0275property("ngIf", col_r27.link_type === "url")("ngIfElse", defaultCell_r28);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_container_1_Template, 4, 3, "ng-container", 67)(2, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_ng_template_2_Template, 3, 2, "ng-template", null, 3, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const notComponent_r29 = \u0275\u0275reference(3);
    const col_r27 = \u0275\u0275nextContext(2).$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r27.link_type === "component")("ngIfElse", notComponent_r29);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_2_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainer(0);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_2_ng_container_1_Template, 1, 0, "ng-container", 127);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r27 = \u0275\u0275nextContext(2).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngTemplateOutlet", col_r27.customTemplate)("ngTemplateOutletContext", \u0275\u0275pureFunction1(2, _c4, item_r25));
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "td", 120);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_1_Template, 4, 2, "ng-container", 37)(2, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_ng_container_2_Template, 2, 4, "ng-container", 37);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r29 = \u0275\u0275nextContext();
    const col_r27 = ctx_r29.$implicit;
    const last_r31 = ctx_r29.last;
    \u0275\u0275property("ngClass", last_r31 ? "sticky right-0 z-10 bg-white" + col_r27.cellClass : col_r27.cellClass);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !col_r27.customTemplate && col_r27.is_grid_column == "true");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r27.customTemplate);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_td_1_Template, 3, 3, "td", 119);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r27 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !col_r27.colFilterHide);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr");
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_td_1_Template, 2, 1, "td", 37)(2, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_ng_container_2_Template, 2, 1, "ng-container", 35);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.enableCheckBox);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r1.headercolumns);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_tr_1_Template, 3, 2, "tr", 35);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r1.items);
  }
}
function DataTableChildrenComponent_ng_container_47_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr")(1, "td", 115);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275attribute("colspan", ctx_r1.gridColumnCount + (ctx_r1.enableCheckBox ? 1 : 0));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 2, "no_records_found"), " ");
  }
}
function DataTableChildrenComponent_ng_container_47_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableChildrenComponent_ng_container_47_ng_container_1_Template, 2, 1, "ng-container", 67)(2, DataTableChildrenComponent_ng_container_47_ng_template_2_Template, 4, 4, "ng-template", null, 2, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const noRecords_r32 = \u0275\u0275reference(3);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.items && ctx_r1.items.length > 0)("ngIfElse", noRecords_r32);
  }
}
function DataTableChildrenComponent_option_52_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 85);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const option_r33 = ctx.$implicit;
    \u0275\u0275property("value", option_r33);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(option_r33);
  }
}
function DataTableChildrenComponent_ng_container_80_button_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r34 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 131);
    \u0275\u0275listener("click", function DataTableChildrenComponent_ng_container_80_button_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r34);
      const i_r35 = \u0275\u0275nextContext().index;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.handleEllipsisClick(i_r35));
    });
    \u0275\u0275text(1, " ... ");
    \u0275\u0275elementEnd();
  }
}
function DataTableChildrenComponent_ng_container_80_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r36 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 132);
    \u0275\u0275listener("click", function DataTableChildrenComponent_ng_container_80_button_3_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r36);
      const page_r37 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.goToPage(page_r37));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const page_r37 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c5, ctx_r1.currentPage === page_r37));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", page_r37, " ");
  }
}
function DataTableChildrenComponent_ng_container_80_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0)(1, 128);
    \u0275\u0275template(2, DataTableChildrenComponent_ng_container_80_button_2_Template, 2, 0, "button", 129)(3, DataTableChildrenComponent_ng_container_80_button_3_Template, 2, 4, "button", 130);
    \u0275\u0275elementContainerEnd()();
  }
  if (rf & 2) {
    const page_r37 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitch", page_r37);
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "...");
  }
}
var _DataTableChildrenComponent = class _DataTableChildrenComponent {
  constructor(translate, toastr, storeData, datePipe, localstore, openaiService, location, timezoneService) {
    this.translate = translate;
    this.toastr = toastr;
    this.storeData = storeData;
    this.datePipe = datePipe;
    this.localstore = localstore;
    this.openaiService = openaiService;
    this.location = location;
    this.timezoneService = timezoneService;
    this.loading = false;
    this.customTemplates = {};
    this.title = "";
    this.enableCheckBox = false;
    this.masterInfo = [];
    this.selectcolumns = [];
    this.headercolumns = [];
    this.items = [];
    this.totalItems = 0;
    this.currentPage = 1;
    this.resultsPerPage = 10;
    this.column = "";
    this.query = "";
    this.delete = new EventEmitter();
    this.edit = new EventEmitter();
    this.view = new EventEmitter();
    this.customAction = new EventEmitter();
    this.pageChange = new EventEmitter();
    this.exportType = new EventEmitter();
    this.resultsPerPageChange = new EventEmitter();
    this.columnSort = new EventEmitter();
    this.searchQuery = new EventEmitter();
    this.advancedSearchQuery = new EventEmitter();
    this.linkComponentClick = new EventEmitter();
    this.search = "";
    this.selectedColumns = [];
    this.selectedColumn = "";
    this.searchCondition = "contains";
    this.selectedItems = [];
    this.totalPages = 1;
    this.filteredItems = [];
    this.filteredColumns = [];
    this.textClass = "";
    this.isMenuOpen = false;
    this.filterCondition = true;
    this.filterConditions = [];
    this.selectedColumnType = 1;
    this.currentSearchConditions = [];
    this.field_types = commonConfig.field_types;
    this.inputTypes = commonConfig.field_type;
    this.searchConditions = commonConfig.search_conditions;
    this.isSchemaChunks = false;
    this.mapConditionToSQL = (condition) => {
      switch (condition) {
        case "contains":
          return "ILIKE";
        case "not_contains":
          return "NOT ILIKE";
        case "starts_with":
          return "ILIKE";
        case "ends_with":
          return "ILIKE";
        case "is_empty":
          return "=";
        case "is_not_empty":
          return "<>";
        case "is_null":
          return "IS NULL";
        case "is_not_null":
          return "IS NOT NULL";
        default:
          return condition;
      }
    };
    this.addWildcards = (condition, value) => {
      switch (condition) {
        case "contains":
          return `%${value}%`;
        case "not_contains":
          return `%${value}%`;
        case "starts_with":
          return `${value}%`;
        case "ends_with":
          return `%${value}`;
        default:
          return value;
      }
    };
    this.dropdownSettings = {
      singleSelection: false,
      idField: "field",
      textField: "title",
      selectAllText: "Select All",
      unSelectAllText: "UnSelect All",
      itemsShowLimit: 3,
      allowSearchFilter: true,
      searchPlaceholderText: "Search"
    };
    this.paginationOptions = [];
    this.config = JSON.parse(this.localstore.getData("config"));
    this.user_info = JSON.parse(this.localstore.getData("user_data"));
    this.paginationOptions = this.config.grid_pagination_dropdown.split(",").map((item) => +item);
    this.initStore();
  }
  ngOnInit() {
    console.log(this.unique_id);
    this.headercolumns.forEach((col) => {
      col.sortDirection = "";
      col.colFilterHide = false;
    });
    console.log(this.items);
    this.filteredItems = [...this.items];
    this.translate.get(["table_multiselect_0", "table_multiselect_3"]).subscribe((translations) => {
      this.dropdownSettings = {
        singleSelection: false,
        idField: "field",
        textField: "title",
        selectAllText: translations["table_multiselect_0"],
        unSelectAllText: translations["table_multiselect_0"],
        itemsShowLimit: 3,
        allowSearchFilter: true,
        searchPlaceholderText: translations["table_multiselect_3"]
      };
    });
  }
  /* advanced search filter functions */
  updateFilterConditions() {
    this.currentSearchConditions = this.searchConditions[this.selectedColumnType] || [];
  }
  getOperatorsForColumn(column) {
    const columnType = this.filteredColumns.find((col) => col.field === column)?.field_type_id;
    return this.searchConditions[columnType] || [];
  }
  getInputTypeForColumn(column) {
    const columnType = this.filteredColumns.find((col) => col.field === column)?.field_type_id;
    return this.inputTypes[columnType] || "text";
  }
  onColumnChange(event, index) {
    const target = event.target;
    const column = target.value;
    this.filterConditions[index].field = column;
    const data = this.filteredColumns.find((col) => col.field === column);
    const columnType = data?.field_type_id;
    this.filterConditions[index].clause_type = data?.clause_type || "where";
    this.filterConditions[index].operator = this.searchConditions[columnType][0].value;
    this.filterConditions[index].value = "";
    this.currentSearchConditions = this.searchConditions[columnType] || [];
  }
  toggleMenu() {
    this.isMenuOpen = !this.isMenuOpen;
    if (this.isMenuOpen && this.filterConditions.length == 0) {
      this.addCondition();
    }
  }
  addCondition() {
    this.filterConditions.push({
      field: "",
      operator: "",
      value: "",
      clause_type: ""
    });
  }
  removeCondition(index) {
    this.filterConditions.splice(index, 1);
  }
  clearFilters() {
    this.filterConditions = [];
    this.applyFilters();
  }
  formatDateTime(dateTime) {
    return this.timezoneService.transformDateTime(dateTime);
  }
  formatDate(dateTime) {
    return this.timezoneService.transformDateOnly(dateTime);
  }
  getConditionValue(index) {
    const value = this.filterConditions[index].value;
    if (value) {
      const type = this.getInputTypeForColumn(this.filterConditions[index].field);
      if (type === "datetime-local") {
        return this.timezoneService.transformDate(value, "yyyy-MM-ddTHH:mm:ss");
      } else if (type === "date") {
        return this.timezoneService.transformDateOnly(value);
      }
    }
    return value;
  }
  setConditionValue(index, value) {
    const type = this.getInputTypeForColumn(this.filterConditions[index].field);
    if (type === "datetime-local" || type === "date") {
      this.filterConditions[index].value = value;
    } else {
      this.filterConditions[index].value = value;
    }
  }
  applyFilters() {
    this.removeEmptyFilters();
    this.isMenuOpen = false;
    const condition = this.filterCondition ? "AND" : "OR";
    const data = this.filterConditions.map((key, index) => {
      const type = this.getInputTypeForColumn(key.field);
      if (type == "datetime-local") {
        const formattedDate = this.formatDateTime(key.value);
        key.value = formattedDate;
      } else if (type == "date") {
        const formattedDate = this.formatDate(key.value);
        key.value = formattedDate;
      }
      return {
        column_name: key.field,
        operator: key.operator ? this.mapConditionToSQL(key.operator) : "=",
        value: this.addWildcards(key.operator, key.value).trim(),
        isAggregate: key?.clause_type === "having"
      };
    });
    const fdata = { data, condition };
    this.advancedSearchQuery.emit(fdata);
  }
  isApplyButtonEnabled() {
    return this.filterConditions.some((condition) => condition.field && condition.operator && condition.value.trim() !== "");
  }
  getPlaceholderForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    switch (columnType) {
      case "number":
        return "Enter a number";
      case "date":
      case "datetime-local":
        return "YYYY-MM-DD";
      default:
        return "Enter a value";
    }
  }
  getMinValueForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    if (columnType === "date" || columnType === "datetime-local") {
      return "1900-01-01";
    }
    return null;
  }
  getMaxValueForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    if (columnType === "date" || columnType === "datetime-local") {
      return "2099-12-31";
    }
    return null;
  }
  getPatternForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    switch (columnType) {
      case "email":
        return "[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,}$";
      case "tel":
        return "[0-9]{10}";
      default:
        return void 0;
    }
  }
  getNonEmptyFilterCount() {
    return this.filterConditions.filter((filter) => filter.value.trim() !== "").length;
  }
  removeEmptyFilters() {
    this.filterConditions = this.filterConditions.filter((filter) => filter.value.trim() !== "");
  }
  cancelFilters() {
    this.isMenuOpen = false;
  }
  /* advanced search filter functions */
  capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
  }
  initStore() {
    return __async(this, null, function* () {
      this.storeData.select((d) => d.index).subscribe((d) => {
        this.store = d;
      });
    });
  }
  ngOnChanges(changes) {
    if (this.selectcolumns.length > 0) {
      const translationKeys = this.selectcolumns.filter((col) => col.searchable).map((col) => `GRIDS.${this.title}.fields.${col.title}`);
      if (this.masterInfo.fullEntity === "schema_chunks") {
        this.isSchemaChunks = true;
      }
      this.translate.get(translationKeys).subscribe((translations) => {
        this.filteredColumns = this.selectcolumns.filter((col) => col.searchable).map((col) => {
          if (translations[`GRIDS.${this.title}.fields.${col.title}`].includes(".")) {
            return __spreadProps(__spreadValues({
              // colFilterHide: false,
              colSearchHide: false
            }, col), {
              title: this.capitalizeFirstLetter(col.title)
            });
          } else {
            return __spreadProps(__spreadValues({
              //colFilterHide: false,
              colSearchHide: false
            }, col), {
              title: translations[`GRIDS.${this.title}.fields.${col.title}`]
            });
          }
        });
      });
    }
  }
  toggleColumnFilterHide(col) {
    col.colFilterHide = !col.colFilterHide;
  }
  toggleColumnSearchHide(col) {
    col.colSearchHide = !col.colSearchHide;
  }
  // No need for now to
  updateColumn(col) {
    col.hide = !col.hide;
    this.selectedColumns = this.filteredColumns.filter((column) => !column.hide);
  }
  getTranslatedValues(key, label) {
    return this.translate.get(key).pipe(map((translations) => {
      return translations.includes(".") ? label : translations;
    }));
  }
  getTranslatedValueTitle(key, label) {
    return this.translate.get(key).pipe(map((translations) => {
      const title = translations.includes(".") ? label : translations;
      return title.split("Table")[0];
    }));
  }
  selectAll() {
    this.headercolumns.forEach((col) => {
      if (col.header !== "table_column_sno") {
        col.colFilterHide = false;
      }
    });
  }
  // Method to clear all checkboxes
  clearAll() {
    this.headercolumns.forEach((col) => {
      if (col.header !== "table_column_sno") {
        col.colFilterHide = true;
      }
    });
  }
  focusSearchInput() {
    this.searchInput.nativeElement.focus();
  }
  onSearch() {
    this.search = this.search.trim();
    let hereColumns = [...this.filteredColumns];
    let items = [3, 4];
    hereColumns = hereColumns.filter((item) => items.includes(item.field_type_id));
    if (this.selectedColumns.length > 0) {
      const whereData = this.selectedColumns.filter((key, index) => {
        return key.clause_type === "where";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const havingData = hereColumns.filter((key, index) => {
        return key.clause_type === "having";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const fdata = { where: { data: whereData, search: this.search }, having: { data: havingData, search: this.search } };
      this.searchQuery.emit(fdata);
    } else {
      const whereData = hereColumns.filter((key, index) => {
        return key.clause_type === "where";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const havingData = hereColumns.filter((key, index) => {
        return key.clause_type === "having";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const fdata = { where: { data: whereData, search: this.search }, having: { data: havingData, search: this.search } };
      this.searchQuery.emit(fdata);
    }
  }
  applyFilter() {
    if (this.selectedColumn && this.search) {
      this.filteredItems = this.items.filter((item) => item[this.selectedColumn]?.toString().toLowerCase().includes(this.search.toLowerCase()));
    } else {
      this.filteredItems = [...this.items];
    }
    this.totalItems = this.filteredItems.length;
    this.calculateTotalPages();
  }
  toggleSelectItem(item) {
    const index = this.selectedItems.indexOf(item);
    if (index === -1) {
      this.selectedItems.push(item);
    } else {
      this.selectedItems.splice(index, 1);
    }
  }
  toggleSelectAll(event) {
    if (event.target.checked) {
      this.selectedItems = [...this.items];
    } else {
      this.selectedItems = [];
    }
  }
  get gridColumnCount() {
    return this.headercolumns.filter((column) => column.is_grid_column == "true").length;
  }
  sortColumn(column) {
    if (column.is_grid_column == "true" && column.is_sortable == "true") {
      this.headercolumns.forEach((col) => {
        if (col !== column) {
          col.sortDirection = "";
        }
      });
      column.sortDirection = column.sortDirection === "asc" ? "desc" : "asc";
      this.columnSort.emit(column);
    }
  }
  deleteSelectedItems() {
    this.delete.emit(this.selectedItems);
    this.selectedItems = [];
  }
  exportTable(type) {
    this.exportType.emit({ type });
  }
  previousPage() {
    if (this.currentPage > 1) {
      this.currentPage--;
      const start_index = (this.currentPage - 1) * this.resultsPerPage;
      this.pageChange.emit({ page: this.currentPage, start_index });
    }
  }
  nextPage() {
    if (this.currentPage < this.totalPages) {
      this.currentPage++;
      const start_index = (this.currentPage - 1) * this.resultsPerPage;
      this.pageChange.emit({ page: this.currentPage, start_index });
    }
  }
  getDisplayedItemCount() {
    return Math.min(this.currentPage * this.resultsPerPage, this.totalItems);
  }
  getPageNumbers() {
    const totalPages = this.calculateTotalPages();
    const currentPage = this.currentPage;
    const pageNumbers = [];
    if (totalPages <= 7) {
      for (let i = 1; i <= totalPages; i++) {
        pageNumbers.push(i);
      }
    } else {
      pageNumbers.push(1);
      if (currentPage > 3) {
        pageNumbers.push("...");
      }
      const start = Math.max(2, currentPage - 1);
      const end = Math.min(totalPages - 1, currentPage + 1);
      for (let i = start; i <= end; i++) {
        pageNumbers.push(i);
      }
      if (currentPage < totalPages - 2) {
        pageNumbers.push("...");
      }
      pageNumbers.push(totalPages);
    }
    return pageNumbers;
  }
  handleEllipsisClick(index) {
    const pageNumbers = this.getPageNumbers();
    if (index === 1) {
      this.goToPage(Math.floor((1 + this.currentPage) / 2));
    } else if (index === pageNumbers.length - 2) {
      this.goToPage(Math.floor((this.totalPages + this.currentPage) / 2));
    }
  }
  goToPage(page) {
    if (this.items.length > 0 && typeof page === "number" && page !== this.currentPage) {
      this.currentPage = page;
      const start_index = (page - 1) * this.resultsPerPage;
      this.pageChange.emit({ page: this.currentPage, start_index });
    }
  }
  onResultsPerPageChange() {
    this.currentPage = 1;
    this.calculateTotalPages();
    const start_index = 0;
    this.resultsPerPageChange.emit({ resultsPerPage: parseInt(this.resultsPerPage), start_index });
  }
  searchData(search) {
    this.searchQuery.emit(search);
  }
  calculateTotalPages() {
    this.totalPages = Math.ceil(this.totalItems / this.resultsPerPage);
    return this.totalPages;
  }
  syncTableSchema() {
    this.loading = true;
    this.openaiService.syncTableSchema().subscribe((res) => {
      this.loading = false;
      if (res.status) {
        this.toastr.success("Table schema synced successfully", "Success");
        this.setPageReload();
      } else {
        this.toastr.error("Failed to sync table schema", "Error");
      }
    });
  }
  generateVectorForAllTable() {
    this.toastr.info("Syncing table schema..., it may take few minutes", "Info");
    this.loading = true;
    this.openaiService.generateVectorForAllTable().subscribe((res) => {
      this.loading = false;
      if (res.status) {
        this.toastr.success("Table schema synced successfully", "Success");
        this.setPageReload();
      } else {
        this.toastr.error("Failed to sync table schema", "Error");
      }
    });
  }
  setPageReload() {
    setTimeout(() => {
      window.location.reload();
    }, 1e3);
  }
  onLinkComponentClick(col, item) {
    this.linkComponentClick.emit({ col, item });
  }
};
_DataTableChildrenComponent.\u0275fac = function DataTableChildrenComponent_Factory(t) {
  return new (t || _DataTableChildrenComponent)(\u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(Store), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(OpenaiService), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(TimezoneService));
};
_DataTableChildrenComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _DataTableChildrenComponent, selectors: [["app-datatable-children"]], viewQuery: function DataTableChildrenComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.searchInput = _t.first);
  }
}, inputs: { unique_id: "unique_id", loading: "loading", customTemplates: "customTemplates", title: "title", enableCheckBox: "enableCheckBox", masterInfo: "masterInfo", selectcolumns: "selectcolumns", headercolumns: "headercolumns", items: "items", totalItems: "totalItems", currentPage: "currentPage", resultsPerPage: "resultsPerPage", column: "column", query: "query" }, outputs: { delete: "delete", edit: "edit", view: "view", customAction: "customAction", pageChange: "pageChange", exportType: "exportType", resultsPerPageChange: "resultsPerPageChange", columnSort: "columnSort", searchQuery: "searchQuery", advancedSearchQuery: "advancedSearchQuery", linkComponentClick: "linkComponentClick" }, standalone: true, features: [\u0275\u0275NgOnChangesFeature, \u0275\u0275StandaloneFeature], decls: 93, vars: 53, consts: [["searchInput", ""], ["filterList", ""], ["noRecords", ""], ["notComponent", ""], ["defaultCell", ""], [1, "panel", 2, "border-block", "none", "border-width", "10px"], [1, "mb-2.5"], [1, "header-panel", "mb-1", "mt-0", "flex", "flex-col", "gap-5", "px-2", "md:flex-row", "md:items-center"], ["appDynamicFontSize", "title", 1, "font-bold", "dark:text-white-light"], [1, "flex", "items-center", "gap-4", "md:flex-row", "md:items-center", "md:ltr:ml-auto", "md:rtl:mr-auto"], [1, "flex", "flex-col", "gap-2", "md:flex-row", "md:items-center"], [1, "relative", "mb-2", "flex-grow", "md:mb-0"], ["type", "text", "appDynamicFontSize", "body", 1, "form-input", "w-full", "pr-10", "text-gray-600", 3, "ngModelChange", "input", "ngModel", "placeholder"], ["href", "javascript:void(0);", 1, "search-btn", "absolute", "inset-y-0", "right-0", "flex", "items-center", "border-none", 3, "click"], [1, "fa-solid", "fa-magnifying-glass"], [1, "align-center", "align-items-center", "relative", "inline-flex", "justify-center"], ["aria-expanded", "true", "aria-haspopup", "true", "id", "options-menu", "type", "button", 1, "filter-button", "mr-2", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click"], [1, "fa-solid", "fa-filter"], [1, "hidden", "md:inline"], ["class", "badge absolute -top-3 rounded-full bg-danger p-0.5 px-1.5", 4, "ngIf"], ["aria-labelledby", "options-menu", "aria-orientation", "vertical", "class", "advancedfiltercontainer rigin-top-left absolute z-10 mt-2 divide-y divide-gray-100 rounded-md bg-white shadow-lg ring-1 ring-black ring-opacity-5", "role", "menu", 4, "ngIf"], ["hlMenu", "", 1, "dropdown", "mb-2", "md:mb-0"], ["hlMenuButton", "", "type", "button", "appDynamicFontSize", "body", 1, "mr-2", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark"], [1, "fa-solid", "fa-table-columns"], [1, "ltr:mr-1", "rtl:ml-1"], ["class", "w-max ltr:left-0 rtl:right-0", 4, "hlMenuItems"], ["class", "flex", 4, "ngIf"], [1, "flex", "flex-wrap", "items-center", "gap-2"], ["type", "button", "class", "btn-primary flex items-center rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold dark:border-[#253b5c] dark:bg-[#1b2e4b] dark:text-white-dark", 3, "ngxTippy", "click", 4, "ngIf"], ["type", "button", "class", "btn-danger rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold ltr:rounded-r rtl:rounded-l", 3, "click", 4, "ngIf"], [1, "datatable"], [1, "table-responsive", "overflow-x-auto"], [1, "table-hover", "relative", "min-w-full"], [1, "bg-gray-50"], ["class", "text-left uppercase tracking-wider", "appDynamicFontSize", "body", 4, "ngIf"], [4, "ngFor", "ngForOf"], [1, "divide-y", "divide-gray-200"], [4, "ngIf"], [1, "pagination", "flex", "items-center", "justify-between", "border-t", "border-gray-200", "py-1", "text-xs", "sm:mb-0"], [1, "flex", "items-center"], [1, "mr-4"], ["id", "results-per-page", "appDynamicFontSize", "body", 1, "py-1.5", "text-xs", 3, "ngModelChange", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], ["appDynamicFontSize", "body", 1, "py-1", "text-xs", "text-gray-700"], [1, "font-medium"], ["aria-label", "Pagination", "appDynamicFontSize", "body", 1, "isolate", "inline-flex", "-space-x-px", "rounded-md", "py-1.5", "text-xs", "shadow-sm"], [1, "relative", "inline-flex", "items-center", "rounded-l-md", "px-2", "py-1", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], [1, "sr-only"], ["viewBox", "0 0 20 20", "fill", "currentColor", "aria-hidden", "true", 1, "h-5", "w-5"], ["fill-rule", "evenodd", "d", "M15.79 14.77a.75.75 0 01-1.06.02l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 111.04 1.08L11.832 10l3.938 3.71a.75.75 0 01.02 1.06zm-6 0a.75.75 0 01-1.06.02l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 111.04 1.08L5.832 10l3.938 3.71a.75.75 0 01.02 1.06z", "clip-rule", "evenodd"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], ["fill-rule", "evenodd", "d", "M12.79 5.23a.75.75 0 01-.02 1.06L8.832 10l3.938 3.71a.75.75 0 11-1.04 1.08l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 011.06.02z", "clip-rule", "evenodd"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1.5", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], ["fill-rule", "evenodd", "d", "M7.21 14.77a.75.75 0 01.02-1.06L11.168 10 7.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z", "clip-rule", "evenodd"], [1, "relative", "inline-flex", "items-center", "rounded-r-md", "px-2", "py-1.5", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], ["fill-rule", "evenodd", "d", "M4.21 14.77a.75.75 0 01.02-1.06L8.168 10 4.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02zm6 0a.75.75 0 01.02-1.06L14.168 10 10.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z", "clip-rule", "evenodd"], [1, "badge", "absolute", "-top-3", "rounded-full", "bg-danger", "p-0.5", "px-1.5"], ["aria-labelledby", "options-menu", "aria-orientation", "vertical", "role", "menu", 1, "advancedfiltercontainer", "rigin-top-left", "absolute", "z-10", "mt-2", "divide-y", "divide-gray-100", "rounded-md", "bg-white", "shadow-lg", "ring-1", "ring-black", "ring-opacity-5"], [1, "flex", "items-center", "justify-between", "border-b", "border-gray-200", "p-4"], [1, "flex", "items-center", "gap-4"], ["ngxTippy", "Add Filter", 1, "text-blue-500", 3, "click"], [1, "fa-solid", "fa-plus"], [1, "relative", "h-6", "w-12"], ["type", "checkbox", "id", "custom_switch_checkbox", 1, "custom_switch", "peer", "absolute", "z-10", "h-full", "w-full", "cursor-pointer", "opacity-0", 3, "ngModelChange", "ngModel"], ["for", "custom_switch_checkbox", 1, "block", "h-full", "rounded-full", "bg-[#ebedf2]", "before:absolute", "before:bottom-1", "before:left-1", "before:h-4", "before:w-4", "before:rounded-full", "before:bg-white", "before:transition-all", "before:duration-300", "peer-checked:bg-primary", "peer-checked:before:left-7"], ["appearance", "compact", 1, "relative", "!h-[calc(40vh-40px)]"], [1, "space-y-2", "p-4"], [4, "ngIf", "ngIfElse"], [1, "flex", "items-center", "justify-between", "border-t", "border-gray-200", "p-4"], [1, "text-red-500", 3, "click"], [1, "flex", "gap-4"], [1, "btn", "btn-primary", 3, "click", "disabled"], [1, "btn", "btn-secondary", 3, "click"], [1, "text-gray-600"], ["class", "flex items-center gap-2", 4, "ngFor", "ngForOf"], [1, "flex", "items-center", "gap-2"], ["class", "fa-solid fa-diamond shrink-0 text-warning", 4, "ngIf"], ["class", "fa-solid fa-diamond shrink-0 text-info", 4, "ngIf"], [1, "form-select", "w-full", 3, "change", "ngModelChange", "ngModel"], ["value", "", "selected", "", "disabled", ""], [1, "form-select", "w-full", 3, "ngModelChange", "ngModel"], [1, "form-input", "w-full", "pr-10", "text-gray-600", 3, "ngModelChange", "ngModel", "type", "placeholder", "required"], [1, "fa-solid", "fa-xmark", "text-xl"], [1, "fa-solid", "fa-diamond", "shrink-0", "text-warning"], [1, "fa-solid", "fa-diamond", "shrink-0", "text-info"], [3, "value"], [1, "w-max", "ltr:left-0", "rtl:right-0"], [1, "flex", "items-center", "border-b", "border-gray-200", "px-4", "py-1"], [1, "mr-2", "px-2", "py-1", "text-blue-500", 3, "click"], [1, "px-2", "py-1", "text-red-500", 3, "click"], [1, "flex", "items-center", "px-4", "py-1"], [1, "mb-0", "cursor-pointer", 3, "for"], ["type", "checkbox", 1, "form-checkbox", 3, "ngModelChange", "id", "ngModel"], ["appDynamicFontSize", "body", 1, "uppercase", "ltr:ml-2", "rtl:mr-2"], [1, "flex"], ["type", "button", "hlMenuButton", "", 1, "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark"], [1, "fa-solid", "fa-download"], ["class", "whitespace-nowrap ltr:right-0 rtl:left-0", 4, "hlMenuItems"], [1, "whitespace-nowrap", "ltr:right-0", "rtl:left-0"], ["href", "javascript:;", 3, "click", 4, "hlMenuItem"], ["href", "javascript:;", 3, "click"], [1, "fa-solid", "fa-file-excel", "ltr:mr-2", "rtl:ml-2"], ["type", "button", 1, "btn", "btn-primary", "mr-2", "h-32", "text-xs", 3, "click"], ["type", "button", 1, "btn", "btn-primary", "h-32", "text-xs", 3, "click"], ["type", "button", 1, "btn-primary", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click", "ngxTippy"], ["type", "button", 1, "btn-danger", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], ["appDynamicFontSize", "body", 1, "text-left", "uppercase", "tracking-wider"], ["type", "checkbox", 3, "change"], ["scope", "col", "class", "max-w-140 cursor-pointer truncate whitespace-nowrap px-4 py-2 text-left tracking-wider", "appDynamicFontSize", "body", "ngxTippy", "", 3, "ngClass", "click", 4, "ngIf"], ["scope", "col", "appDynamicFontSize", "body", "ngxTippy", "", 1, "max-w-140", "cursor-pointer", "truncate", "whitespace-nowrap", "px-4", "py-2", "text-left", "tracking-wider", 3, "click", "ngClass"], ["class", "arrow-icon bh-ml-3 bh-sort bh-flex bh-items-center id asc ng-star-inserted", 4, "ngIf"], [1, "arrow-icon", "bh-ml-3", "bh-sort", "bh-flex", "bh-items-center", "id", "asc", "ng-star-inserted"], ["width", "16", "height", "16", "viewBox", "0 0 14 14", "fill", "none"], ["points", "3.11,6.25 10.89,6.25 7,1.75", "fill", "currentColor", 1, "bh-text-black", 3, "ngClass"], ["points", "7,12.25 10.89,7.75 3.11,7.75", "fill", "currentColor", 1, "bh-text-black", 3, "ngClass"], ["appDynamicFontSize", "body", 1, "py-4", "text-center", "text-gray-500"], [1, "dots-container"], [1, "dot"], ["type", "checkbox", 3, "change", "checked"], ["class", "max-w-150 truncate whitespace-nowrap", 3, "ngClass", 4, "ngIf"], [1, "max-w-150", "truncate", "whitespace-nowrap", 3, "ngClass"], [1, "block", "truncate", "text-blue-600", "cursor-pointer", "underline", 3, "click"], ["target", "_blank", 1, "block", "truncate", "text-blue-600", "underline", 3, "href"], ["class", "block truncate", "ngxTippy", "", 3, "ngClass", 4, "ngIf"], ["class", "block truncate", 4, "ngIf"], ["ngxTippy", "", 1, "block", "truncate", 3, "ngClass"], [1, "block", "truncate"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [3, "ngSwitch"], ["class", "relative inline-flex items-center px-2 py-1.5 text-xs font-semibold ring-1 ring-inset ring-gray-300 hover:bg-gray-50 focus:z-20 focus:outline-offset-0", 3, "click", 4, "ngSwitchCase"], ["class", "relative inline-flex items-center px-2 py-1.5 text-xs font-semibold ring-1 ring-inset ring-gray-300 hover:bg-gray-50 focus:z-20 focus:outline-offset-0", 3, "ngClass", "click", 4, "ngSwitchDefault"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1.5", "text-xs", "font-semibold", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1.5", "text-xs", "font-semibold", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "ngClass"]], template: function DataTableChildrenComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 5)(1, "div", 6)(2, "div", 7)(3, "div", 8);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 9)(7, "div", 10)(8, "div", 11)(9, "input", 12, 0);
    \u0275\u0275pipe(11, "translate");
    \u0275\u0275twoWayListener("ngModelChange", function DataTableChildrenComponent_Template_input_ngModelChange_9_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.search, $event) || (ctx.search = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("input", function DataTableChildrenComponent_Template_input_input_9_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onSearch());
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "a", 13);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Template_a_click_12_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onSearch());
    })("click", function DataTableChildrenComponent_Template_a_click_12_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.focusSearchInput());
    });
    \u0275\u0275element(13, "i", 14);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(14, "div", 15)(15, "button", 16);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Template_button_click_15_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.toggleMenu());
    });
    \u0275\u0275element(16, "i", 17);
    \u0275\u0275text(17, "\xA0");
    \u0275\u0275elementStart(18, "span", 18);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275template(21, DataTableChildrenComponent_span_21_Template, 2, 1, "span", 19);
    \u0275\u0275elementEnd();
    \u0275\u0275template(22, DataTableChildrenComponent_div_22_Template, 30, 17, "div", 20);
    \u0275\u0275elementStart(23, "div", 21)(24, "button", 22);
    \u0275\u0275element(25, "i", 23);
    \u0275\u0275text(26, "\xA0 ");
    \u0275\u0275elementStart(27, "span", 24);
    \u0275\u0275text(28);
    \u0275\u0275pipe(29, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275template(30, DataTableChildrenComponent_ul_30_Template, 10, 8, "ul", 25);
    \u0275\u0275elementEnd();
    \u0275\u0275template(31, DataTableChildrenComponent_div_31_Template, 9, 3, "div", 26)(32, DataTableChildrenComponent_Conditional_32_Template, 6, 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(33, "div", 27);
    \u0275\u0275template(34, DataTableChildrenComponent_button_34_Template, 5, 7, "button", 28);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(35, "div", 27);
    \u0275\u0275template(36, DataTableChildrenComponent_button_36_Template, 5, 7, "button", 28);
    \u0275\u0275elementEnd();
    \u0275\u0275template(37, DataTableChildrenComponent_button_37_Template, 3, 3, "button", 29);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(38, "div", 30)(39, "div", 31)(40, "table", 32)(41, "thead", 33)(42, "tr");
    \u0275\u0275template(43, DataTableChildrenComponent_th_43_Template, 2, 0, "th", 34)(44, DataTableChildrenComponent_ng_container_44_Template, 2, 1, "ng-container", 35);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(45, "tbody", 36);
    \u0275\u0275template(46, DataTableChildrenComponent_tr_46_Template, 8, 1, "tr", 37)(47, DataTableChildrenComponent_ng_container_47_Template, 4, 2, "ng-container", 37);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(48, "div", 38)(49, "div", 39)(50, "div", 40)(51, "select", 41);
    \u0275\u0275twoWayListener("ngModelChange", function DataTableChildrenComponent_Template_select_ngModelChange_51_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.resultsPerPage, $event) || (ctx.resultsPerPage = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("ngModelChange", function DataTableChildrenComponent_Template_select_ngModelChange_51_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onResultsPerPageChange());
    });
    \u0275\u0275template(52, DataTableChildrenComponent_option_52_Template, 2, 2, "option", 42);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(53, "div")(54, "p", 43)(55, "span", 44);
    \u0275\u0275text(56);
    \u0275\u0275elementEnd();
    \u0275\u0275text(57, " - ");
    \u0275\u0275elementStart(58, "span", 44);
    \u0275\u0275text(59);
    \u0275\u0275elementEnd();
    \u0275\u0275text(60);
    \u0275\u0275pipe(61, "translate");
    \u0275\u0275elementStart(62, "span", 44);
    \u0275\u0275text(63);
    \u0275\u0275elementEnd();
    \u0275\u0275text(64);
    \u0275\u0275pipe(65, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(66, "div")(67, "nav", 45)(68, "button", 46);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Template_button_click_68_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goToPage(1));
    });
    \u0275\u0275elementStart(69, "span", 47);
    \u0275\u0275text(70);
    \u0275\u0275pipe(71, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(72, "svg", 48);
    \u0275\u0275element(73, "path", 49);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(74, "button", 50);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Template_button_click_74_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.previousPage());
    });
    \u0275\u0275elementStart(75, "span", 47);
    \u0275\u0275text(76);
    \u0275\u0275pipe(77, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(78, "svg", 48);
    \u0275\u0275element(79, "path", 51);
    \u0275\u0275elementEnd()();
    \u0275\u0275template(80, DataTableChildrenComponent_ng_container_80_Template, 4, 2, "ng-container", 35);
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(81, "button", 52);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Template_button_click_81_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.nextPage());
    });
    \u0275\u0275elementStart(82, "span", 47);
    \u0275\u0275text(83);
    \u0275\u0275pipe(84, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(85, "svg", 48);
    \u0275\u0275element(86, "path", 53);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(87, "button", 54);
    \u0275\u0275listener("click", function DataTableChildrenComponent_Template_button_click_87_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goToPage(ctx.totalPages));
    });
    \u0275\u0275elementStart(88, "span", 47);
    \u0275\u0275text(89);
    \u0275\u0275pipe(90, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(91, "svg", 48);
    \u0275\u0275element(92, "path", 55);
    \u0275\u0275elementEnd()()()()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(5, 33, ctx.title), " ");
    \u0275\u0275advance(5);
    \u0275\u0275propertyInterpolate1("placeholder", "", \u0275\u0275pipeBind1(11, 35, "table_search_placeholder"), "...");
    \u0275\u0275twoWayProperty("ngModel", ctx.search);
    \u0275\u0275advance(10);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(20, 37, "table_filter"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.getNonEmptyFilterCount() > 0);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isMenuOpen);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(29, 39, "table_multiselect_1"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.export_excel);
    \u0275\u0275advance();
    \u0275\u0275conditional(32, ctx.isSchemaChunks ? 32 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.create);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.popup_create);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.unique_id && true);
    \u0275\u0275advance(6);
    \u0275\u0275property("ngIf", ctx.enableCheckBox);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx.headercolumns);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.loading);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx.loading);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx.resultsPerPage);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx.paginationOptions);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate((ctx.currentPage - 1) * ctx.resultsPerPage + 1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.getDisplayedItemCount());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(61, 41, "table_results_0"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.totalItems);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(65, 43, "table_results_1"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", ctx.currentPage === 1);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(71, 45, "first"));
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", ctx.currentPage === 1);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(77, 47, "previous"));
    \u0275\u0275advance(4);
    \u0275\u0275property("ngForOf", ctx.getPageNumbers());
    \u0275\u0275advance();
    \u0275\u0275property("disabled", ctx.currentPage === ctx.totalPages);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(84, 49, "next"));
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", ctx.currentPage === ctx.totalPages);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(90, 51, "last"));
  }
}, dependencies: [CommonSharedModule, NgClass, NgForOf, NgIf, NgTemplateOutlet, NgSwitch, NgSwitchCase, NgSwitchDefault, NgScrollbar, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, CheckboxControlValueAccessor, SelectControlValueAccessor, NgControlStatus, RequiredValidator, NgModel, MenuDirective, MenuButtonDirective, MenuItemsPanelDirective, MenuItemDirective, NgxTippyDirective, DynamicFontSizeDirective, TranslatePipe, NgMultiSelectDropDownModule, BooleanStatusPipe], styles: ["\n\n.arrow-icon[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common[_ngcontent-%COMP%] {\n  transform: rotate(90deg);\n  fill: grey;\n  vertical-align: middle;\n  margin: 0;\n  padding: 0;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common.active[_ngcontent-%COMP%] {\n  fill: black;\n  color: black;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common[_ngcontent-%COMP%]:first-child {\n  margin-bottom: -3px;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common[_ngcontent-%COMP%]:last-child {\n  margin-top: -1px;\n}\n.h-32[_ngcontent-%COMP%] {\n  height: 32px;\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  border-radius: 0.375rem;\n  border-width: 1px;\n  --tw-border-opacity: 1;\n  border-color: rgb(224 230 237 / var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(255 255 255 / var(--tw-bg-opacity));\n  padding-top: 0.375rem;\n  padding-bottom: 0.375rem;\n  padding-left: 0.5rem;\n  padding-right: 1rem;\n  font-weight: 600;\n  --tw-text-opacity: 1;\n  color: rgb(14 23 38 / var(--tw-text-opacity));\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus {\n  --tw-border-opacity: 1;\n  border-color: rgb(67 97 238 / var(--tw-border-opacity));\n  --tw-ring-color: transparent;\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60 / var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50 / var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168 / var(--tw-text-opacity));\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(67 97 238 / var(--tw-border-opacity));\n}\n@media (max-width: 768px) {\n  .form-select[_ngcontent-%COMP%] {\n    width: 100%;\n  }\n  .flex-wrap[_ngcontent-%COMP%] {\n    justify-content: space-between;\n  }\n  .pagination[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: center;\n  }\n  .pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    margin-bottom: 1rem;\n  }\n  .datatable[_ngcontent-%COMP%]   .table-responsive[_ngcontent-%COMP%] {\n    overflow-x: auto;\n  }\n  .datatable[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], .datatable[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n    white-space: nowrap;\n  }\n  .datatable[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]   .arrow-icon[_ngcontent-%COMP%] {\n    display: inline-block;\n    vertical-align: middle;\n    margin-left: 0.5rem;\n  }\n}\n.panel[_ngcontent-%COMP%] {\n  margin: -15px;\n  padding: 1.25rem 1.25rem 0.25rem 1.25rem;\n}\n.multiple-select[_ngcontent-%COMP%] {\n  width: 100%;\n  --tw-border-opacity: 1;\n  border-color: rgb(224 230 237/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(255 255 255/var(--tw-bg-opacity));\n  padding-left: 1rem;\n  padding-right: 1rem;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n  font-size: 0.875rem;\n  line-height: 1.25rem;\n  font-weight: 600;\n  --tw-text-opacity: 1;\n  color: rgb(14 23 38/var(--tw-text-opacity));\n  outline: 2px solid transparent !important;\n  outline-offset: 2px !important;\n}\n.multiple-select[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50/var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n.dropdown-list[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50/var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n.filter-textbox[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]   [_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50/var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n.header-panel[_ngcontent-%COMP%] {\n  margin-top: -15px;\n}\n.panel[_ngcontent-%COMP%] {\n  padding: 1.25rem 1.25rem 0.25rem 1.25rem;\n}\n.bh-text-black[_ngcontent-%COMP%] {\n  color: rgba(14, 23, 38, 0.2);\n}\n.bh-text-primary[_ngcontent-%COMP%] {\n  --tw-text-opacity: 1 !important;\n  color: rgb(67, 97, 238) !important;\n}\n.datatable[_ngcontent-%COMP%]   .table-responsive[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   tfoot[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], .datatable[_ngcontent-%COMP%]   .table-responsive[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  vertical-align: top;\n  font-weight: 700;\n}\n.form-select[_ngcontent-%COMP%] {\n  width: auto;\n  min-width: 120px;\n}\n[_ngcontent-%COMP%]:is(.dark   table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   tr)[_ngcontent-%COMP%], [_ngcontent-%COMP%]:is(.dark   table[_ngcontent-%COMP%]   tfoot[_ngcontent-%COMP%]   tr)[_ngcontent-%COMP%] {\n  --tw-bg-opacity: 1 !important;\n  background-color: rgb(26, 41, 65) !important;\n}\n[_ngcontent-%COMP%]:is(.dark   .datatable)[_ngcontent-%COMP%] {\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n[_ngcontent-%COMP%]:is(.dark   .datatable[_ngcontent-%COMP%]   .bh-sort[_ngcontent-%COMP%]   svg[_ngcontent-%COMP%]   polygon)[_ngcontent-%COMP%] {\n  --tw-text-opacity: 1;\n  color: rgb(59 63 92/var(--tw-text-opacity));\n}\n.sticky[_ngcontent-%COMP%] {\n  position: sticky;\n  background-clip: padding-box;\n}\nthead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%] {\n  background: #e5e7eb;\n}\ntbody[_ngcontent-%COMP%]   td.sticky[_ngcontent-%COMP%] {\n  background-color: #fff;\n}\nthead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  background-color: rgb(21, 33, 53) !important;\n}\ntbody[_ngcontent-%COMP%]   td.sticky[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  background-color: rgb(14 23 38/var(--tw-bg-opacity));\n}\n.sticky.right-0[_ngcontent-%COMP%] {\n  right: 0;\n}\n[_ngcontent-%COMP%]:is(.dark)   th[_ngcontent-%COMP%], [_ngcontent-%COMP%]:is(.dark)   td[_ngcontent-%COMP%] {\n  border-color: #374151;\n}\n[_ngcontent-%COMP%]:is(.dark)   thead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%] {\n  box-shadow: inset 1px 0 0 #374151;\n}\n[_ngcontent-%COMP%]:is(.dark)   tbody[_ngcontent-%COMP%]   td.sticky[_ngcontent-%COMP%] {\n  box-shadow: inset 1px 0 0 #374151;\n  background-color: #1f2937;\n}\n[_ngcontent-%COMP%]:is(.dark)   thead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%] {\n  background-color: #1f2937;\n}\n.truncate[_ngcontent-%COMP%] {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n.max-w-150[_ngcontent-%COMP%] {\n  max-width: 150px;\n}\n@media (max-width: 640px) {\n  .header-panel[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: stretch;\n  }\n  .flex-wrap[_ngcontent-%COMP%] {\n    flex-direction: column;\n  }\n  .form-select[_ngcontent-%COMP%], .form-input[_ngcontent-%COMP%], .btn[_ngcontent-%COMP%] {\n    margin-bottom: 0.5rem;\n  }\n  .relative.flex-grow[_ngcontent-%COMP%] {\n    width: 100%;\n  }\n  .flex.items-center.gap-4[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: stretch;\n  }\n}\n.search-btn[_ngcontent-%COMP%] {\n  padding-left: 1.25rem;\n  padding-right: 1.25rem;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n}\n.dropdown[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  z-index: 1000;\n}\n.advancedfiltercontainer[_ngcontent-%COMP%] {\n  min-width: 300px;\n  max-width: 100%;\n  width: 90%;\n  left: 50%;\n  transform: translateX(-50%);\n  right: auto;\n  z-index: 1000;\n  position: fixed;\n  top: 10%;\n  max-height: 60vh;\n  overflow-y: auto;\n}\n@media (min-width: 640px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%] {\n    min-width: 500px;\n    width: 60%;\n  }\n}\n@media (min-width: 1024px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%] {\n    max-width: 600px;\n    width: 70%;\n  }\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .relative[_ngcontent-%COMP%] {\n  max-height: calc(80vh - 120px);\n  overflow-y: auto;\n}\n@media (max-width: 640px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], .advancedfiltercontainer[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    width: 100%;\n    margin-bottom: 0.5rem;\n  }\n  .advancedfiltercontainer[_ngcontent-%COMP%]   .flex[_ngcontent-%COMP%] {\n    flex-direction: column;\n  }\n  .advancedfiltercontainer[_ngcontent-%COMP%]   .flex[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n    width: 100%;\n    margin-right: 0 !important;\n  }\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .flex.items-center.justify-between[_ngcontent-%COMP%] {\n  flex-wrap: wrap;\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .flex.items-center.justify-between[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n  margin-bottom: 0.5rem;\n}\n@media (max-width: 768px) {\n  .pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    margin-top: 1rem;\n  }\n  .filter-button[_ngcontent-%COMP%] {\n    height: 33.6px;\n  }\n}\n.dots-container[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  height: 100%;\n  width: 100%;\n}\n.dot[_ngcontent-%COMP%] {\n  height: 20px;\n  width: 20px;\n  margin-right: 10px;\n  border-radius: 10px;\n  background-color: #b3d4fc;\n  animation: _ngcontent-%COMP%_pulse 1.5s infinite ease-in-out;\n}\n.dot[_ngcontent-%COMP%]:last-child {\n  margin-right: 0;\n}\n.dot[_ngcontent-%COMP%]:nth-child(1) {\n  animation-delay: -0.3s;\n}\n.dot[_ngcontent-%COMP%]:nth-child(2) {\n  animation-delay: -0.1s;\n}\n.dot[_ngcontent-%COMP%]:nth-child(3) {\n  animation-delay: 0.1s;\n}\n@keyframes _ngcontent-%COMP%_pulse {\n  0% {\n    transform: scale(0.8);\n    background-color: #b3d4fc;\n    box-shadow: 0 0 0 0 rgba(178, 212, 252, 0.7);\n  }\n  50% {\n    transform: scale(1.2);\n    background-color: #6793fb;\n    box-shadow: 0 0 0 10px rgba(178, 212, 252, 0);\n  }\n  100% {\n    transform: scale(0.8);\n    background-color: #b3d4fc;\n    box-shadow: 0 0 0 0 rgba(178, 212, 252, 0.7);\n  }\n}\n/*# sourceMappingURL=datatable-children.component.css.map */"], data: { animation: [
  trigger("toggleAnimation", [
    transition(":enter", [style({ opacity: 0, transform: "scale(0.95)" }), animate("100ms ease-out", style({ opacity: 1, transform: "scale(1)" }))]),
    transition(":leave", [animate("75ms", style({ opacity: 0, transform: "scale(0.95)" }))])
  ])
] } });
var DataTableChildrenComponent = _DataTableChildrenComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(DataTableChildrenComponent, { className: "DataTableChildrenComponent", filePath: "src\\app\\@lcp-framework\\components\\datatable-children\\datatable-children.component.ts", lineNumber: 46 });
})();

// src/app/@lcp-framework/service/common/route-update.service.ts
var _RouteUpdateService = class _RouteUpdateService {
  constructor(rendererFactory, router, localStore) {
    this.rendererFactory = rendererFactory;
    this.router = router;
    this.localStore = localStore;
    this.apiUrl = environment.apiUrl;
    this.permissionsListSubject = new BehaviorSubject(null);
    this.routeList = [];
    this.renderer = this.rendererFactory.createRenderer(null, null);
    const permissionsList = this.localStore.getData("user_data") ? JSON.parse(this.localStore.getData("user_data")).permissions : null;
    this.permissionsListSubject.next(permissionsList);
  }
  setPermissionsList(permissions) {
    this.permissionsListSubject.next(permissions);
  }
  getPermissionListJSON() {
    return this.permissionsListSubject.asObservable();
  }
  extractRoutes(routes, parentPath = "") {
    for (const route of routes) {
      const path = parentPath + "/" + (route.path || "");
      if (route.component) {
        this.routeList.push({ path, component: route.component });
      }
      if (route.children) {
        this.extractRoutes(route.children, path);
      }
    }
  }
  changeFavicon(url) {
    const favicon = this.renderer.selectRootElement("#common-favicon", true);
    this.renderer.setAttribute(favicon, "href", url);
  }
  updateRoutesWithGridPermission(routeDataArray) {
    return new Observable((observer) => {
      this.getPermissionListJSON().subscribe((permissionListJSON) => {
        if (permissionListJSON) {
          const dynamicRoutes = routeDataArray.filter((routeData) => routeData.entity_name && routeData.component_class_name).map((routeData) => {
            const viewPermissionKey = `view_${routeData.entity_name}`;
            const createPermissionKey = `add_${routeData.entity_name}`;
            const editPermissionKey = `edit_${routeData.entity_name}`;
            const deletePermissionKey = `delete_${routeData.entity_name}`;
            const exportExcelPermissionKey = `export_excel_${routeData.entity_name}`;
            const detailsPermissionKey = `details_${routeData.entity_name}`;
            const assignPermissionKey = `assign_${routeData.entity_name}`;
            const printPermissionKey = `print_${routeData.entity_name}`;
            const recordExportPermissionKey = `record_export_${routeData.entity_name}`;
            const emailResendPermissionKey = `email_resend_${routeData.entity_name}`;
            const generateVectorPermissionKey = `generate_vector_${routeData.entity_name}`;
            const childDetailsPermissionKey = `child_details_${routeData.entity_name}`;
            const popupCreatePermissionKey = `popup_add_${routeData.entity_name}`;
            const popupEditPermissionKey = `popup_edit_${routeData.entity_name}`;
            const popupDetailsPermissionKey = `popup_details_${routeData.entity_name}`;
            const idColumn = `${routeData.primary_table}.id`;
            const deletedAtColumn = `${routeData.primary_table}.status_id`;
            const targetPath = routeData.target.startsWith("/") ? routeData.target.slice(1) : routeData.target;
            const sortCol = [[idColumn, "desc"]];
            const searchAllCol = [
              {
                column_name: deletedAtColumn,
                value: 3,
                operator: "!="
              }
            ];
            let finalAllCol = [];
            if (routeData.entity_name == "app_error_log") {
              finalAllCol = [
                ...searchAllCol,
                {
                  column_name: "request_logs.res_status",
                  value: false,
                  operator: "="
                }
              ];
            } else if (routeData.entity_name == "user") {
              finalAllCol = [
                ...searchAllCol,
                {
                  value: ["super_admin", "company_admin"],
                  operator: "NOT IN",
                  column_name: "users.role"
                }
              ];
            } else if (routeData.entity_name == "master_entity") {
              finalAllCol = [
                ...searchAllCol,
                {
                  column_name: `${routeData.primary_table}.entity_type`,
                  value: "help_page_module",
                  operator: "!="
                }
              ];
            } else {
              finalAllCol = searchAllCol;
            }
            const children = routeDataArray.reduce((acc, childRoute) => {
              if (childRoute.parent_id === routeData.id && childRoute.action_slug) {
                acc[childRoute.action_slug] = childRoute;
              }
              return acc;
            }, {});
            const componentMap = {
              grid_builder_module: () => import("./chunk-XGMBN3NH.js").then((m) => m.MasterListComponent),
              menu_module: () => import("./chunk-H2V74OW3.js").then((m) => m.MenuMappingComponent),
              static_page_builder_module: () => import("./chunk-UYJ2AAQL.js").then((m) => m.StaticPageComponent),
              form_builder_module: () => import("./chunk-C3JFLK4W.js").then((m) => m.FormBuilderComponent),
              entity_user_role_map_module: () => import("./chunk-C75HUCTF.js").then((m) => m.UserRolePermissionComponent),
              entity_form_module: () => import("./chunk-WX2AW5GB.js").then((m) => m.MasterEntityComponent),
              about_lcp_form_module: () => import("./chunk-U24FN4IB.js").then((m) => m.AboutlcpComponent),
              ai_playground_module: () => import("./chunk-6G7OEA4P.js").then((m) => m.AiPlaygroundComponent),
              query_builder_module: () => import("./chunk-ZHJUORUA.js").then((m) => m.QueryBuilderComponent),
              language_contents_module: () => import("./chunk-DCRMIUFM.js").then((m) => m.LanguageMappingComponent),
              job_builder_module: () => import("./chunk-LSFV726O.js").then((m) => m.JobPageComponent),
              export_module: () => import("./chunk-LSFV726O.js").then((m) => m.JobPageComponent),
              help_page_module: () => import("./chunk-CWPUQLJO.js").then((m) => m.DocumentationComponent),
              configurations_module: () => import("./chunk-X5QHF5B5.js").then((m) => m.ConfigurationComponent),
              user_configurations_module: () => import("./chunk-6ZDYSREJ.js").then((m) => m.UserConfigurationComponent),
              cron_setting_module: () => import("./chunk-CXKG4MEC.js").then((m) => m.CronSettingComponent),
              import_module: () => import("./chunk-CFAEF4MZ.js").then((m) => m.ImportMasterComponent),
              import_template_module: () => import("./chunk-R7H655GG.js").then((m) => m.ImportTemplateComponent),
              export_template_module: () => import("./chunk-YV5WAKLG.js").then((m) => m.ExportTemplateComponent),
              import_job_detail_module: () => import("./chunk-UM4VX223.js").then((m) => m.ImportJobDetailsComponent),
              policy_add_edit_module: () => import("./chunk-EPT3QTKW.js").then((m) => m.PolicyComponent),
              user_role_policy_module: () => import("./chunk-E5U3C7L5.js").then((m) => m.UserRolePolicyComponent),
              email_template_assignment_module: () => import("./chunk-4LVH2ORC.js").then((m) => m.EmailTemplateAssignmentComponent),
              whatsapp_template_assignment_module: () => import("./chunk-DBKBXQ5O.js").then((m) => m.WhatsappTemplateAssignmentComponent),
              approval_workflow_assignment_module: () => import("./chunk-OP5BXFOB.js").then((m) => m.ApprovalWorkflowAssignmentComponent),
              approval_requests_module: () => import("./chunk-JWSLKLJW.js").then((m) => m.ApprovalRequestsComponent),
              approval_requests_tracking_module: () => import("./chunk-MEBLKNBT.js").then((m) => m.ApprovalRequestsTrackingComponent),
              child_process_setting_module: () => import("./chunk-XR4MGT7Z.js").then((m) => m.ChildProcessSettingComponent),
              carousel_module: () => import("./chunk-Q6R6G37K.js").then((m) => m.CarouselComponent)
            };
            console.log(routeData);
            const route = {
              path: targetPath,
              // component: componentMap[routeData.component_class_name],
              loadComponent: componentMap[routeData.component_class_name] || null,
              title: routeData.entity_name,
              data: {
                pageInfo: {
                  targetPath,
                  fullEntity: routeData.entity_name,
                  title: routeData.entity_name,
                  Listname: routeData.entity_name,
                  action_slug: routeData.action_slug,
                  draft_mode: routeData.draft_mode,
                  ListQuery: {
                    print_query: true,
                    company_id: 0,
                    entity_name: routeData.entity_name,
                    cte: routeData.cte,
                    start_index: 0,
                    limit_range: 10,
                    //sort_columns: sortCol,
                    search_all: finalAllCol,
                    search_any: []
                  },
                  enable_row_checkbox: false,
                  permissions: {
                    create: permissionListJSON[createPermissionKey] || false,
                    edit: permissionListJSON[editPermissionKey] || false,
                    delete: permissionListJSON[deletePermissionKey] || false,
                    export_excel: permissionListJSON[exportExcelPermissionKey] || false,
                    details: permissionListJSON[detailsPermissionKey] || false,
                    assign: permissionListJSON[assignPermissionKey] || false,
                    print: permissionListJSON[printPermissionKey] || false,
                    record_export: permissionListJSON[recordExportPermissionKey] || false,
                    email_resend: permissionListJSON[emailResendPermissionKey] || false,
                    generate_vector: permissionListJSON[generateVectorPermissionKey] || false,
                    child_details: permissionListJSON[childDetailsPermissionKey] || false,
                    popup_create: permissionListJSON[popupCreatePermissionKey] || false,
                    popup_edit: permissionListJSON[popupEditPermissionKey] || false,
                    popup_details: permissionListJSON[popupDetailsPermissionKey] || false
                  },
                  children
                },
                defaultPermission: permissionListJSON[viewPermissionKey] || false,
                defaultKey: viewPermissionKey
              }
            };
            return route;
          });
          observer.next(dynamicRoutes);
          observer.complete();
        }
      });
    });
  }
  getPageInfo(entity_name) {
    return __async(this, null, function* () {
      console.log(entity_name);
      const user_data_raw = this.localStore.getData("user_data");
      if (!user_data_raw || user_data_raw === "undefined")
        return null;
      const user_data = JSON.parse(user_data_raw);
      const routeDataArray = user_data?.unorgmenuList || [];
      const permissionListJSON = yield firstValueFrom(this.getPermissionListJSON());
      if (!permissionListJSON || !routeDataArray.length)
        return null;
      console.log(routeDataArray);
      console.log(entity_name);
      console.log(permissionListJSON);
      if (permissionListJSON && routeDataArray) {
        const dynamicRoutes = routeDataArray.filter((routeData) => routeData.entity_name === entity_name && routeData.component_class_name).map((routeData) => {
          const viewPermissionKey = `view_${routeData.entity_name}`;
          const createPermissionKey = `add_${routeData.entity_name}`;
          const editPermissionKey = `edit_${routeData.entity_name}`;
          const deletePermissionKey = `delete_${routeData.entity_name}`;
          const exportExcelPermissionKey = `export_excel_${routeData.entity_name}`;
          const detailsPermissionKey = `details_${routeData.entity_name}`;
          const assignPermissionKey = `assign_${routeData.entity_name}`;
          const printPermissionKey = `print_${routeData.entity_name}`;
          const recordExportPermissionKey = `record_export_${routeData.entity_name}`;
          const emailResendPermissionKey = `email_resend_${routeData.entity_name}`;
          const generateVectorPermissionKey = `generate_vector_${routeData.entity_name}`;
          const childDetailsPermissionKey = `child_details_${routeData.entity_name}`;
          const popupCreatePermissionKey = `popup_add_${routeData.entity_name}`;
          const popupEditPermissionKey = `popup_edit_${routeData.entity_name}`;
          const popupDetailsPermissionKey = `popup_details_${routeData.entity_name}`;
          const idColumn = `${routeData.primary_table}.id`;
          const deletedAtColumn = `${routeData.primary_table}.status_id`;
          const targetPath = routeData.target.startsWith("/") ? routeData.target.slice(1) : routeData.target;
          const sortCol = [[idColumn, "desc"]];
          const searchAllCol = [
            {
              column_name: deletedAtColumn,
              value: 3,
              operator: "!="
            }
          ];
          let finalAllCol = searchAllCol;
          if (routeData.entity_name == "app_error_log") {
            finalAllCol = [
              ...searchAllCol,
              {
                column_name: "request_logs.res_status",
                value: false,
                operator: "="
              }
            ];
          } else if (routeData.entity_name == "user") {
            finalAllCol = [
              ...searchAllCol,
              {
                value: ["super_admin", "company_admin"],
                operator: "NOT IN",
                column_name: "users.role"
              }
            ];
          } else if (routeData.entity_name == "master_entity") {
            finalAllCol = [
              ...searchAllCol,
              {
                column_name: `${routeData.primary_table}.entity_type`,
                value: "help_page_module",
                operator: "!="
              }
            ];
          }
          const children = routeDataArray.reduce((acc, childRoute) => {
            if (childRoute.parent_id === routeData.id && childRoute.action_slug) {
              acc[childRoute.action_slug] = childRoute;
            }
            return acc;
          }, {});
          const componentMap = {
            grid_builder_module: () => import("./chunk-XGMBN3NH.js").then((m) => m.MasterListComponent),
            menu_module: () => import("./chunk-H2V74OW3.js").then((m) => m.MenuMappingComponent),
            static_page_builder_module: () => import("./chunk-UYJ2AAQL.js").then((m) => m.StaticPageComponent),
            form_builder_module: () => import("./chunk-C3JFLK4W.js").then((m) => m.FormBuilderComponent),
            entity_user_role_map_module: () => import("./chunk-C75HUCTF.js").then((m) => m.UserRolePermissionComponent),
            entity_form_module: () => import("./chunk-WX2AW5GB.js").then((m) => m.MasterEntityComponent),
            about_lcp_form_module: () => import("./chunk-U24FN4IB.js").then((m) => m.AboutlcpComponent),
            ai_playground_module: () => import("./chunk-6G7OEA4P.js").then((m) => m.AiPlaygroundComponent),
            query_builder_module: () => import("./chunk-ZHJUORUA.js").then((m) => m.QueryBuilderComponent),
            language_contents_module: () => import("./chunk-DCRMIUFM.js").then((m) => m.LanguageMappingComponent),
            job_builder_module: () => import("./chunk-LSFV726O.js").then((m) => m.JobPageComponent),
            export_module: () => import("./chunk-LSFV726O.js").then((m) => m.JobPageComponent),
            help_page_module: () => import("./chunk-CWPUQLJO.js").then((m) => m.DocumentationComponent),
            configurations_module: () => import("./chunk-X5QHF5B5.js").then((m) => m.ConfigurationComponent),
            user_configurations_module: () => import("./chunk-6ZDYSREJ.js").then((m) => m.UserConfigurationComponent),
            cron_setting_module: () => import("./chunk-CXKG4MEC.js").then((m) => m.CronSettingComponent),
            import_module: () => import("./chunk-CFAEF4MZ.js").then((m) => m.ImportMasterComponent),
            import_template_module: () => import("./chunk-R7H655GG.js").then((m) => m.ImportTemplateComponent),
            export_template_module: () => import("./chunk-YV5WAKLG.js").then((m) => m.ExportTemplateComponent),
            import_job_detail_module: () => import("./chunk-UM4VX223.js").then((m) => m.ImportJobDetailsComponent),
            policy_add_edit_module: () => import("./chunk-EPT3QTKW.js").then((m) => m.PolicyComponent),
            user_role_policy_module: () => import("./chunk-E5U3C7L5.js").then((m) => m.UserRolePolicyComponent),
            email_template_assignment_module: () => import("./chunk-4LVH2ORC.js").then((m) => m.EmailTemplateAssignmentComponent),
            approval_workflow_assignment_module: () => import("./chunk-OP5BXFOB.js").then((m) => m.ApprovalWorkflowAssignmentComponent),
            approval_requests_module: () => import("./chunk-JWSLKLJW.js").then((m) => m.ApprovalRequestsComponent),
            approval_requests_tracking_module: () => import("./chunk-MEBLKNBT.js").then((m) => m.ApprovalRequestsTrackingComponent),
            child_process_setting_module: () => import("./chunk-XR4MGT7Z.js").then((m) => m.ChildProcessSettingComponent),
            carousel_module: () => import("./chunk-Q6R6G37K.js").then((m) => m.CarouselComponent)
          };
          console.log(permissionListJSON);
          console.log(childDetailsPermissionKey);
          console.log(permissionListJSON[childDetailsPermissionKey]);
          const route = {
            path: targetPath,
            loadComponent: componentMap[routeData.component_class_name] || null,
            title: routeData.entity_name,
            data: {
              pageInfo: {
                targetPath,
                fullEntity: routeData.entity_name,
                title: routeData.entity_name,
                Listname: routeData.entity_name,
                action_slug: routeData.action_slug,
                draft_mode: routeData.draft_mode,
                ListQuery: {
                  print_query: true,
                  company_id: 0,
                  entity_name: routeData.entity_name,
                  cte: routeData.cte,
                  start_index: 0,
                  limit_range: 10,
                  search_all: finalAllCol,
                  search_any: []
                },
                enable_row_checkbox: false,
                permissions: {
                  create: permissionListJSON[createPermissionKey] || false,
                  edit: permissionListJSON[editPermissionKey] || false,
                  delete: permissionListJSON[deletePermissionKey] || false,
                  export_excel: permissionListJSON[exportExcelPermissionKey] || false,
                  details: permissionListJSON[detailsPermissionKey] || false,
                  assign: permissionListJSON[assignPermissionKey] || false,
                  print: permissionListJSON[printPermissionKey] || false,
                  record_export: permissionListJSON[recordExportPermissionKey] || false,
                  email_resend: permissionListJSON[emailResendPermissionKey] || false,
                  generate_vector: permissionListJSON[generateVectorPermissionKey] || false,
                  child_details: permissionListJSON[childDetailsPermissionKey] || false,
                  popup_create: permissionListJSON[popupCreatePermissionKey] || false,
                  popup_edit: permissionListJSON[popupEditPermissionKey] || false,
                  popup_details: permissionListJSON[popupDetailsPermissionKey] || false
                },
                children
              },
              defaultPermission: permissionListJSON[viewPermissionKey] || false,
              defaultKey: viewPermissionKey
            }
          };
          return route;
        });
        return dynamicRoutes;
      }
      return null;
    });
  }
  addDynamicRoutes() {
    const resn = JSON.parse(this.localStore.getData("config"));
    if (resn) {
      this.changeFavicon(this.apiUrl + "/" + resn.favicon);
    }
    const user_data = this.localStore.getData("user_data") ? JSON.parse(this.localStore.getData("user_data")) : null;
    const unorgmenuList = user_data && user_data?.unorgmenuList ? user_data?.unorgmenuList : null;
    if (unorgmenuList) {
      this.updateRoutesWithGridPermission(unorgmenuList).subscribe((dynamicRoutes) => {
        const config = this.router.config;
        const appLayoutRoute = config.find((route) => route.path === "");
        if (appLayoutRoute && appLayoutRoute.children) {
          appLayoutRoute.children.unshift(...dynamicRoutes);
          this.router.resetConfig(config);
        }
      });
    }
  }
};
_RouteUpdateService.\u0275fac = function RouteUpdateService_Factory(t) {
  return new (t || _RouteUpdateService)(\u0275\u0275inject(RendererFactory2), \u0275\u0275inject(Router), \u0275\u0275inject(LocalStorageService));
};
_RouteUpdateService.\u0275prov = /* @__PURE__ */ \u0275\u0275defineInjectable({ token: _RouteUpdateService, factory: _RouteUpdateService.\u0275fac, providedIn: "root" });
var RouteUpdateService = _RouteUpdateService;

// src/app/@lcp-framework/pages/master-list-children/master-list-children.component.ts
var _c02 = ["actionTemplate"];
var _c12 = ["statusTemplate"];
var _c22 = ["processStatusTemplate"];
var _c32 = ["linkDownloadVideoURLTemplate"];
var _c42 = ["linkDownloadPdfURLTemplate"];
var _c52 = ["linkDownloadWordURLTemplate"];
var _c6 = (a0, a1, a2, a3) => ({ "h-5.5 w-5.5": a0, "h-4.5 w-4.5": a1, "h-3.5 w-3.5": a2, "text-red-500": a3 });
var _c7 = (a0, a1) => [a0, a1];
var _c8 = (a0) => [a0];
function MasterListChildrenComponent_ng_template_2_a_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 19);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_1_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r2);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.emailResendItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa-solid fa-arrows-rotate ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r5 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 20);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_2_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r5);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.viewItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa-regular fa-eye ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r6 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 20);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_3_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r6);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.viewPopupItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa-regular fa-eye ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_4_Template(rf, ctx) {
  if (rf & 1) {
    const _r7 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 21);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_4_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r7);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.editItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa-regular fa-pen-to-square ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 21);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_5_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r8);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.editPopupItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa-regular fa-pen-to-square ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r9 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 22);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_6_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r9);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.deleteItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa-regular fa-trash-can ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_7_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 23);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_7_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r10);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.assignItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa fa-tasks ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_8_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 24);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_8_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r11);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.printItem(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa fa-print ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r12 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 25);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_9_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r12);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.recordExport(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa fa-download ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_10_Template(rf, ctx) {
  if (rf & 1) {
    const _r13 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 26);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_10_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r13);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.generateVector(item_r3));
    });
    \u0275\u0275element(1, "i");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275classMapInterpolate1("fa fa-sync ", ctx_r3.store.fontsize === "large" ? "h-5.5 w-5.5" : ctx_r3.store.fontsize === "medium" ? "h-4.5 w-4.5" : "h-3.5 w-3.5", "");
  }
}
function MasterListChildrenComponent_ng_template_2_a_11_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 27);
    \u0275\u0275listener("click", function MasterListChildrenComponent_ng_template_2_a_11_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r14);
      const item_r3 = \u0275\u0275nextContext().$implicit;
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.passwordModal(item_r3));
    });
    \u0275\u0275element(1, "i", 28);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r3 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275classProp("text-red-500", !item_r3.password)("hover:text-primary", item_r3.password);
    \u0275\u0275attribute("data-tippy-content", !item_r3.password ? "Set New Password" : "Reset Password");
    \u0275\u0275advance();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction4(6, _c6, ctx_r3.store.fontsize === "large", ctx_r3.store.fontsize === "medium", ctx_r3.store.fontsize === "small", !item_r3.password));
  }
}
function MasterListChildrenComponent_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 9);
    \u0275\u0275template(1, MasterListChildrenComponent_ng_template_2_a_1_Template, 2, 3, "a", 10)(2, MasterListChildrenComponent_ng_template_2_a_2_Template, 2, 3, "a", 11)(3, MasterListChildrenComponent_ng_template_2_a_3_Template, 2, 3, "a", 11)(4, MasterListChildrenComponent_ng_template_2_a_4_Template, 2, 3, "a", 12)(5, MasterListChildrenComponent_ng_template_2_a_5_Template, 2, 3, "a", 12)(6, MasterListChildrenComponent_ng_template_2_a_6_Template, 2, 3, "a", 13)(7, MasterListChildrenComponent_ng_template_2_a_7_Template, 2, 3, "a", 14)(8, MasterListChildrenComponent_ng_template_2_a_8_Template, 2, 3, "a", 15)(9, MasterListChildrenComponent_ng_template_2_a_9_Template, 2, 3, "a", 16)(10, MasterListChildrenComponent_ng_template_2_a_10_Template, 2, 3, "a", 17)(11, MasterListChildrenComponent_ng_template_2_a_11_Template, 2, 11, "a", 18);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r3 = ctx.$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.email_resend);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.details);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.popup_details);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.edit && ((ctx_r3.masterInfo == null ? null : ctx_r3.masterInfo.Listname) == "mrn_grid" ? (item_r3 == null ? null : item_r3.mrn_status) != "completed" : (ctx_r3.masterInfo == null ? null : ctx_r3.masterInfo.Listname) == "min_grid" ? (item_r3 == null ? null : item_r3.min_status) != "completed" : true));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.popup_edit && ((ctx_r3.masterInfo == null ? null : ctx_r3.masterInfo.Listname) == "mrn_grid" ? (item_r3 == null ? null : item_r3.mrn_status) != "completed" : (ctx_r3.masterInfo == null ? null : ctx_r3.masterInfo.Listname) == "min_grid" ? (item_r3 == null ? null : item_r3.min_status) != "completed" : true));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.delete);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.assign);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.print);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.record_export);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.masterInfo.permissions.generate_vector);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.allowPasswordModal);
  }
}
function MasterListChildrenComponent_ng_template_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 29);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r15 = ctx.$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction2(4, _c7, ctx_r3.store.fontsize === "large" ? "text-base" : ctx_r3.store.fontsize === "medium" ? "text-sm" : "text-xs", ctx_r3.statuses[item_r15.status] == null ? null : ctx_r3.statuses[item_r15.status].border_color));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 2, ctx_r3.statuses[item_r15.status].value), " ");
  }
}
function MasterListChildrenComponent_ng_template_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 29);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r16 = ctx.$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction2(4, _c7, ctx_r3.store.fontsize === "large" ? "text-base" : ctx_r3.store.fontsize === "medium" ? "text-sm" : "text-xs", ctx_r3.processStatuses[item_r16.process_status] == null ? null : ctx_r3.processStatuses[item_r16.process_status].border_color));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 2, ctx_r3.processStatuses[item_r16.process_status].value), " ");
  }
}
function MasterListChildrenComponent_ng_template_8_a_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "a", 31);
    \u0275\u0275element(1, "i", 32);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r17 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("href", item_r17.documentation_video_url, \u0275\u0275sanitizeUrl)("ngClass", \u0275\u0275pureFunction1(3, _c8, ctx_r3.store.fontsize === "large" ? "text-base" : ctx_r3.store.fontsize === "medium" ? "text-sm" : "text-xs"));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", item_r17.documentation_video_url, " ");
  }
}
function MasterListChildrenComponent_ng_template_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, MasterListChildrenComponent_ng_template_8_a_0_Template, 3, 5, "a", 30);
  }
  if (rf & 2) {
    const item_r17 = ctx.$implicit;
    \u0275\u0275property("ngIf", item_r17.documentation_video_url);
  }
}
function MasterListChildrenComponent_ng_template_10_a_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "a", 31);
    \u0275\u0275element(1, "i", 33);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r18 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("href", ctx_r3.apiUrl + "/" + item_r18.documentation_pdf, \u0275\u0275sanitizeUrl)("ngClass", \u0275\u0275pureFunction1(3, _c8, ctx_r3.store.fontsize === "large" ? "text-base" : ctx_r3.store.fontsize === "medium" ? "text-sm" : "text-xs"));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", item_r18.documentation_pdf, " ");
  }
}
function MasterListChildrenComponent_ng_template_10_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, MasterListChildrenComponent_ng_template_10_a_0_Template, 3, 5, "a", 30);
  }
  if (rf & 2) {
    const item_r18 = ctx.$implicit;
    \u0275\u0275property("ngIf", item_r18.documentation_pdf);
  }
}
function MasterListChildrenComponent_ng_template_12_a_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "a", 31);
    \u0275\u0275element(1, "i", 33);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const item_r19 = \u0275\u0275nextContext().$implicit;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275property("href", ctx_r3.apiUrl + "/" + item_r19.documentation_word, \u0275\u0275sanitizeUrl)("ngClass", \u0275\u0275pureFunction1(3, _c8, ctx_r3.store.fontsize === "large" ? "text-base" : ctx_r3.store.fontsize === "medium" ? "text-sm" : "text-xs"));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", item_r19.documentation_word, " ");
  }
}
function MasterListChildrenComponent_ng_template_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, MasterListChildrenComponent_ng_template_12_a_0_Template, 3, 5, "a", 30);
  }
  if (rf & 2) {
    const item_r19 = ctx.$implicit;
    \u0275\u0275property("ngIf", item_r19.documentation_word);
  }
}
function MasterListChildrenComponent_app_loader_14_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "app-loader");
  }
}
function MasterListChildrenComponent_div_15_div_22_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275text(1, " Password must include at least 8 characters, one uppercase letter, and one special character. ");
    \u0275\u0275elementContainerEnd();
  }
}
function MasterListChildrenComponent_div_15_div_22_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 56);
    \u0275\u0275template(1, MasterListChildrenComponent_div_15_div_22_ng_container_1_Template, 2, 0, "ng-container", 7);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    let tmp_8_0;
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", (tmp_8_0 = ctx_r3.changePasswordForm.get("new_password")) == null ? null : tmp_8_0.errors == null ? null : tmp_8_0.errors["passwordInvalid"]);
  }
}
function MasterListChildrenComponent_div_15_div_28_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 56);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "form_confirm_new_pwd_req_msg"), " ");
  }
}
function MasterListChildrenComponent_div_15_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 34);
    \u0275\u0275element(1, "div", 35);
    \u0275\u0275elementStart(2, "div", 36)(3, "div", 37)(4, "div", 38)(5, "div", 39)(6, "h3", 40);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "button", 41);
    \u0275\u0275listener("click", function MasterListChildrenComponent_div_15_Template_button_click_9_listener() {
      \u0275\u0275restoreView(_r20);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.cancelResetPwd());
    });
    \u0275\u0275elementStart(10, "span", 42);
    \u0275\u0275text(11, "Close");
    \u0275\u0275elementEnd();
    \u0275\u0275element(12, "i", 43);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(13, "div", 44)(14, "form", 45);
    \u0275\u0275listener("ngSubmit", function MasterListChildrenComponent_div_15_Template_form_ngSubmit_14_listener() {
      \u0275\u0275restoreView(_r20);
      const ctx_r3 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r3.onChangePassword());
    });
    \u0275\u0275elementStart(15, "div", 46)(16, "div", 47)(17, "div")(18, "label", 48);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(21, "input", 49);
    \u0275\u0275template(22, MasterListChildrenComponent_div_15_div_22_Template, 2, 1, "div", 50);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(23, "div")(24, "label", 51);
    \u0275\u0275text(25);
    \u0275\u0275pipe(26, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(27, "input", 52);
    \u0275\u0275template(28, MasterListChildrenComponent_div_15_div_28_Template, 3, 3, "div", 50);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(29, "div", 53)(30, "button", 54);
    \u0275\u0275text(31);
    \u0275\u0275pipe(32, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(33, "p", 55)(34, "strong");
    \u0275\u0275text(35, "Note:");
    \u0275\u0275elementEnd();
    \u0275\u0275text(36, " Password must contain at least 8 characters, including one uppercase letter and one special character. ");
    \u0275\u0275elementEnd()()()()()();
  }
  if (rf & 2) {
    let tmp_10_0;
    let tmp_12_0;
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(8, 7, "title_reset_password"), " ");
    \u0275\u0275advance(7);
    \u0275\u0275property("formGroup", ctx_r3.changePasswordForm);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(20, 9, "form_label_new_pwd"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ((tmp_10_0 = ctx_r3.changePasswordForm.get("new_password")) == null ? null : tmp_10_0.invalid) && ((tmp_10_0 = ctx_r3.changePasswordForm.get("new_password")) == null ? null : tmp_10_0.touched));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(26, 11, "form_label_confirm_new_pwd"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ((tmp_12_0 = ctx_r3.changePasswordForm.get("confirm_new_password")) == null ? null : tmp_12_0.invalid) && ((tmp_12_0 = ctx_r3.changePasswordForm.get("confirm_new_password")) == null ? null : tmp_12_0.touched));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(32, 13, "submit"));
  }
}
function MasterListChildrenComponent_div_16_app_static_page_5_Template(rf, ctx) {
  if (rf & 1) {
    const _r21 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "app-static-page", 61);
    \u0275\u0275listener("closeModal", function MasterListChildrenComponent_div_16_app_static_page_5_Template_app_static_page_closeModal_0_listener() {
      \u0275\u0275restoreView(_r21);
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.closeViewPopup());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275property("uuid", ctx_r3.selectedItemUuid)("entityName", ctx_r3.popupEntityName)("isModal", true);
  }
}
function MasterListChildrenComponent_div_16_app_form_builder_6_Template(rf, ctx) {
  if (rf & 1) {
    const _r22 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "app-form-builder", 61);
    \u0275\u0275listener("closeModal", function MasterListChildrenComponent_div_16_app_form_builder_6_Template_app_form_builder_closeModal_0_listener() {
      \u0275\u0275restoreView(_r22);
      const ctx_r3 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r3.closeViewPopup());
    });
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext(2);
    \u0275\u0275property("uuid", ctx_r3.selectedItemUuid)("entityName", ctx_r3.popupEntityName)("isModal", true);
  }
}
function MasterListChildrenComponent_div_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 34);
    \u0275\u0275element(1, "div", 35);
    \u0275\u0275elementStart(2, "div", 57)(3, "div", 58)(4, "div", 59);
    \u0275\u0275template(5, MasterListChildrenComponent_div_16_app_static_page_5_Template, 1, 3, "app-static-page", 60)(6, MasterListChildrenComponent_div_16_app_form_builder_6_Template, 1, 3, "app-form-builder", 60);
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const ctx_r3 = \u0275\u0275nextContext();
    \u0275\u0275advance(5);
    \u0275\u0275property("ngIf", ctx_r3.popupName == "popup_details");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r3.popupName == "popup_add" || ctx_r3.popupName == "popup_edit");
  }
}
var _MasterListChildrenComponent = class _MasterListChildrenComponent {
  constructor(toastr, gridApiService, apiService, http, route, cdr, datepipe, router, storeData, exportService, datePipe, translate, localStorageService, commonService, titleService, formBuilder, openaiService, routeUpdateService, timezoneService) {
    this.toastr = toastr;
    this.gridApiService = gridApiService;
    this.apiService = apiService;
    this.http = http;
    this.route = route;
    this.cdr = cdr;
    this.datepipe = datepipe;
    this.router = router;
    this.storeData = storeData;
    this.exportService = exportService;
    this.datePipe = datePipe;
    this.translate = translate;
    this.localStorageService = localStorageService;
    this.commonService = commonService;
    this.titleService = titleService;
    this.formBuilder = formBuilder;
    this.openaiService = openaiService;
    this.routeUpdateService = routeUpdateService;
    this.timezoneService = timezoneService;
    this.uuid = null;
    this.entity_name = "";
    this.isViewPopupOpen = false;
    this.customTemplates = {};
    this.isItemModalOpen = false;
    this.column = "";
    this.query = "";
    this.allowPasswordModal = false;
    this.selectcolumns = [];
    this.headercolumns = [];
    this.items = [];
    this.totalItems = 0;
    this.currentPage = 1;
    this.resultsPerPage = 10;
    this.enableCheckBox = false;
    this.policyData = null;
    this.loading = false;
    this.loadingpopup = false;
    this.gridloading = true;
    this.title = "";
    this.listQuery = "";
    this.defaultQuery = "";
    this.attachedPolicies = [];
    this.apiUrl = environment.apiUrl;
    this.statuses = {
      1: {
        value: "table_status_val_0",
        border_color: "badge-outline-success"
      },
      2: {
        value: "table_status_val_1",
        border_color: "badge-outline-danger"
      },
      3: {
        value: "table_status_val_2",
        border_color: "badge-outline-secondary"
      }
    };
    this.processStatuses = {
      submitted: {
        value: "table_process_status_val_0",
        border_color: "badge-outline-primary"
      },
      approved: {
        value: "table_process_status_val_1",
        border_color: "badge-outline-success"
      },
      rejected: {
        value: "table_process_status_val_2",
        border_color: "badge-outline-danger"
      },
      under_approval: {
        value: "table_process_status_val_3",
        border_color: "badge-outline-warning"
      },
      created: {
        value: "table_process_status_val_4",
        border_color: "badge-outline-success"
      },
      not_appear: {
        value: "table_process_status_val_5",
        border_color: "badge-outline-danger"
      }
    };
    this.selectedItemUuid = null;
    this.isUUid = true;
    this.initStore();
    this.route.paramMap.subscribe((params) => {
      const id = params.get("id");
      const uuid = params.get("uuid");
      if (id) {
        this.isUUid = false;
      } else {
        this.isUUid = true;
      }
      const value = id || uuid;
      this.uniqueId = value;
    });
    this.changePasswordForm = this.formBuilder.group({
      new_password: ["", [Validators.required, Validators.minLength(8), this.passwordValidator]],
      confirm_new_password: ["", Validators.required]
    }, { validators: this.passwordMatchValidator });
  }
  passwordValidator(control) {
    const value = control.value;
    if (!value) {
      return null;
    }
    const hasUpperCase = /[A-Z]/.test(value);
    const hasSpecialChar = /[!@#$%^&*(),.?":{}|<>]/.test(value);
    const isValid = hasUpperCase && hasSpecialChar;
    return !isValid ? { passwordInvalid: true } : null;
  }
  passwordMatchValidator(group) {
    const newPassword = group.get("new_password")?.value;
    const confirmNewPassword = group.get("confirm_new_password")?.value;
    return newPassword === confirmNewPassword ? null : { passwordsMismatch: true };
  }
  ngAfterViewInit() {
    return __async(this, null, function* () {
      this.config = JSON.parse(this.localStorageService.getData("config"));
      console.log(this.config);
      console.log(this.entity_name);
      if (this.uuid && this.entity_name) {
        const routes = yield this.routeUpdateService.getPageInfo(this.entity_name);
        console.log(routes);
        const pageInfo = routes && routes.length ? routes[0].data.pageInfo : null;
        console.log(pageInfo);
        this.setupPageInfo(pageInfo);
      } else {
        const pageInfo = this.route.snapshot.data["pageInfo"] || "";
        this.setupPageInfo(pageInfo);
      }
      this.cdr.detectChanges();
    });
  }
  setupPageInfo(pageInfo) {
    this.user_info = JSON.parse(this.localStorageService.getData("user_data"));
    this.resultsPerPage = parseInt(this.config.grid_pagination_default);
    this.grid_records_delete = this.config.grid_enable_associated_records_deletion;
    if (pageInfo && this.resultsPerPage) {
      if (this.user_info.main?.policies) {
        this.policyData = this.user_info.main?.policies || null;
      }
      this.masterInfo = pageInfo;
      if (this.masterInfo.ListQuery.entity_name == "user") {
        this.allowPasswordModal = true;
      }
      const masterListConfig = pageInfo;
      const translateTitle = this.translate.instant(masterListConfig.fullEntity);
      this.titleService.setTitle(translateTitle);
      this.enableCheckBox = masterListConfig.enable_row_checkbox;
      this.title = masterListConfig.fullEntity;
      this.defaultQuery = masterListConfig.ListQuery;
      this.listQuery = JSON.parse(JSON.stringify(this.defaultQuery));
      this.listQuery.start_index = 0;
      this.fetchAttachedPolicies(this.listQuery);
    } else {
      this.title = "Default Title";
      this.headercolumns = [];
      this.items = [];
    }
  }
  initStore() {
    return __async(this, null, function* () {
      this.storeData.select((d) => d.index).subscribe((d) => {
        this.store = d;
      });
    });
  }
  onChangePassword() {
    if (this.changePasswordForm && this.changePasswordForm.errors && this.changePasswordForm.errors["passwordsMismatch"]) {
      const key = "passwords_do_not_match";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
      return;
    }
    if (this.changePasswordForm.invalid) {
      this.markAllAsTouched();
      return;
    }
    const formData = {
      uuid: this.user_id,
      password: this.changePasswordForm.get("new_password")?.value
    };
    this.apiService.resetPasswordAnyUser(formData).subscribe((response) => {
      const key = "password_resetted_successfully";
      const successMessage = this.translate.instant(key);
      this.toastr.success(successMessage);
      this.changePasswordForm.reset();
      this.isItemModalOpen = false;
      this.fetchData(this.listQuery);
    }, (error) => {
      const key = "error_resetting_password";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage + error, "Error");
      this.isItemModalOpen = false;
    });
  }
  markAllAsTouched() {
    Object.values(this.changePasswordForm.controls).forEach((control) => {
      control.markAsTouched();
    });
  }
  sortColumn(column) {
    this.column = column;
    this.listQuery.limit_range = this.resultsPerPage;
    this.listQuery.sort_columns = [[this.column.header, this.column.sortDirection]];
    this.fetchData(this.listQuery);
  }
  passwordModal(item) {
    this.isItemModalOpen = true;
    this.user_id = item.uuid;
  }
  cancelResetPwd() {
    this.changePasswordForm.reset();
    this.isItemModalOpen = false;
  }
  advancedSearchData(data) {
    const query = data.data;
    const uncleanedwhereConditions = query.filter((d) => !d.isAggregate);
    const whereConditions = uncleanedwhereConditions.map((_a) => {
      var _b = _a, { isAggregate } = _b, rest = __objRest(_b, ["isAggregate"]);
      return rest;
    });
    const uncleanedhavingConditions = query.filter((d) => d.isAggregate);
    const havingConditions = uncleanedhavingConditions.map((_c) => {
      var _d = _c, { isAggregate } = _d, rest = __objRest(_d, ["isAggregate"]);
      return rest;
    });
    const condition = data.condition;
    const clonedListQuery = this.listQuery;
    const orgListQuery = this.defaultQuery;
    if (whereConditions.length == 0 && havingConditions.length == 0) {
      if (condition == "AND") {
        clonedListQuery.search_all = [...orgListQuery.search_all];
      } else {
        clonedListQuery.search_any = [...orgListQuery.search_any];
      }
      this.fetchData(clonedListQuery);
      return;
    }
    if (havingConditions.length > 0) {
      if (condition == "AND") {
        clonedListQuery.having_conditions = [...havingConditions];
      } else {
        clonedListQuery.having_any_conditions = [...havingConditions];
      }
    }
    if (condition == "AND") {
      if (whereConditions.length === 1 && whereConditions[0].column_name === "") {
        clonedListQuery.search_all = [];
        clonedListQuery.search_all = [...orgListQuery.search_all];
      } else {
        clonedListQuery.search_all = [];
        clonedListQuery.search_all = [...orgListQuery.search_all, ...whereConditions];
      }
      clonedListQuery.start_index = 0;
      this.currentPage = 1;
      this.fetchData(clonedListQuery);
    } else {
      if (whereConditions.length === 1 && whereConditions[0].column_name === "") {
        clonedListQuery.search_any = [...clonedListQuery.search_any];
      } else {
        clonedListQuery.search_any = [...clonedListQuery.search_any, ...whereConditions];
      }
      clonedListQuery.start_index = 0;
      this.currentPage = 1;
      this.fetchData(clonedListQuery);
    }
  }
  searchData(input) {
    const clonedListQuery = this.listQuery;
    if (input.where.data.length) {
      const query = input.where.data;
      const search = input.where.search;
      if (search == "") {
        const orgListQuery = this.defaultQuery;
        clonedListQuery.search_any = [];
        clonedListQuery.search_any = [...orgListQuery.search_any];
        this.fetchData(clonedListQuery);
        return;
      }
      if (query.length === 1 && query[0].column_name === "") {
        clonedListQuery.search_any = [...clonedListQuery.search_any];
      } else {
        clonedListQuery.search_any = [...query];
      }
    }
    if (input.having.data.length) {
      const query = input.having.data;
      const search = input.having.search;
      if (search.length)
        clonedListQuery.having_any_conditions = [...query];
    }
    clonedListQuery.start_index = 0;
    this.currentPage = 1;
    this.fetchData(clonedListQuery);
  }
  exportTable(item) {
    if (this.masterInfo.permissions.export_excel) {
      this.loading = true;
      if (this.masterInfo.children.export_excel && this.masterInfo.children.export_excel.component_class_name == "export_module") {
        this.exportItem(item);
      } else {
        const query = __spreadValues({}, this.listQuery);
        query.limit_range = 1e6;
        const export_download = this.masterInfo?.Listname.replace("_grid", "") + "_table_data";
        let listParams = this.localStorageService.replaceUniqueId(this.localStorageService.formatPayloadWithPolicyConditions(query, this.policyData, this.attachedPolicies), "$session_user_id", this.user_info.main.id);
        listParams = this.localStorageService.replaceUniqueId(listParams, "$unique_id", this.uniqueId || "");
        this.gridApiService.getAllRecords(listParams).subscribe((response) => {
          if (response.status && response.code === 200) {
            if (response.data.records && response.data.headers) {
              const filteredData = this.filterAndTransformData(response.data.headers, response.data.records);
              if (item.type == "pdf") {
                this.exportService.exportToPDF(filteredData, export_download);
              } else {
                this.exportService.exportToExcel(filteredData, export_download);
              }
              this.loading = false;
            }
          } else {
            this.loading = false;
            this.items = [];
            this.totalItems = 0;
            const key = response.message;
            const errorMessage = this.translate.instant(key);
            this.toastr.error(errorMessage, "Error");
          }
        }, (error) => {
          this.loading = false;
          const key = "error";
          const errorMessage = this.translate.instant(key);
          this.toastr.error(errorMessage, "Error");
        });
      }
    }
  }
  filterAndTransformData(headers, records) {
    const filteredHeaders = headers.filter((header) => header.header !== "id" && header.header !== "uuid");
    const transformedRecords = records.map((record) => {
      const transformedRecord = {};
      filteredHeaders.forEach((header) => {
        const translationKey = `${header.header}`;
        const translatedHeader = this.translate.instant(translationKey);
        if (header.field_type_id == "5") {
          transformedRecord[translatedHeader] = this.timezoneService.transformDateOnly(record[header.header]);
        } else if (header.field_type_id == "7") {
          transformedRecord[translatedHeader] = this.timezoneService.transformDateTime(record[header.header]);
        } else if (header.header == "status") {
          transformedRecord[translatedHeader] = this.getStatusTranslation(record[header.header]);
        } else if (header.header == "process_status") {
          transformedRecord[translatedHeader] = this.getProcessStatusTranslation(record[header.header]);
        } else {
          transformedRecord[translatedHeader] = record[header.header];
        }
      });
      return transformedRecord;
    });
    return transformedRecords;
  }
  getStatusTranslation(status) {
    return this.translate.instant(this.statuses[status].value);
  }
  getProcessStatusTranslation(status) {
    return this.translate.instant(this.processStatuses[status].value);
  }
  fetchAttachedPolicies(params) {
    this.gridApiService.getAttachedPolicies({ entity_name: params.entity_name }).subscribe((response) => {
      if (response.status && response.code === 200) {
        this.attachedPolicies = response.data.attached_policies || [];
      }
    }, (error) => {
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    }, () => {
      this.fetchColumns(this.listQuery);
      this.fetchData(this.listQuery);
    });
  }
  fetchColumns(params) {
    this.gridApiService.getAllColumns({ entity_name: params.entity_name }).subscribe((response) => {
      if (response.status && response.code === 200) {
        const data = response.data.records.map((key, index) => {
          return __spreadValues({
            field: key.field_name,
            title: this.translate.instant(key.display_name),
            sorting: key.is_sortable,
            searchable: key.is_searchable,
            enable: true
          }, key);
        });
        this.selectcolumns = [
          {
            field: "S.No",
            title: "S.No",
            sorting: false,
            searchable: false,
            enable: false,
            field_type_id: 1
          },
          ...data,
          {
            field: "Status",
            title: "Status",
            sorting: false,
            searchable: false,
            enable: false,
            field_type_id: 1
          },
          {
            field: "Action",
            title: "Action",
            sorting: false,
            searchable: false,
            enable: false,
            field_type_id: 0
          }
        ];
      }
    }, (error) => {
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  fetchData(params) {
    params.limit_range = this.resultsPerPage;
    let payload = this.localStorageService.replaceUniqueId(this.localStorageService.formatPayloadWithPolicyConditions(params, this.policyData, this.attachedPolicies), "$session_user_id", this.user_info.main.id);
    console.log(this.uniqueId);
    if (this.uniqueId) {
      payload.unique_id = this.uniqueId;
    }
    if (this.uuid) {
      payload.unique_id = this.uuid;
    }
    payload = this.localStorageService.replaceUniqueId(payload, "$unique_id", this.uniqueId || "");
    console.log(payload);
    this.gridApiService.getAllRecords(payload).subscribe((response) => {
      if (response.status && response.code === 200) {
        if (response.data.headers) {
          if (this.headercolumns.length == 0) {
            const data = response.data.headers.filter((key) => key.is_grid_column == "true").map((key) => __spreadProps(__spreadValues({}, key), {
              column_width: "40px"
            }));
            const isOnlyViewOrViewExport = (!this.masterInfo.permissions.export_excel || this.masterInfo.permissions.export_excel === true) && (!this.masterInfo.permissions.create || this.masterInfo.permissions.create === true) && Object.keys(this.masterInfo.permissions).every((key) => key === "export_excel" || key === "create" || this.masterInfo.permissions[key] === false);
            if (this.config.grid_show_serial_number == "true") {
              this.headercolumns = [
                {
                  header: "table_column_sno",
                  field_value: "S.No",
                  is_sortable: "false",
                  column_order: "0.00",
                  column_width: "40px",
                  is_searchable: "false",
                  is_grid_column: "true"
                },
                ...data
              ];
              if (!isOnlyViewOrViewExport) {
                this.headercolumns.push({
                  header: "table_column_action",
                  field_value: "Action",
                  is_sortable: "false",
                  column_order: "0.00",
                  column_width: "50px",
                  is_searchable: "false",
                  is_grid_column: "true"
                });
              }
            } else {
              this.headercolumns = [...data];
              if (!isOnlyViewOrViewExport) {
                this.headercolumns.push({
                  header: "table_column_action",
                  field_value: "Action",
                  is_sortable: "false",
                  column_order: "0.00",
                  column_width: "50px",
                  is_searchable: "false",
                  is_grid_column: "true"
                });
              }
            }
          }
          this.headercolumns = this.headercolumns.map((item) => {
            if (item.header === "status") {
              return __spreadProps(__spreadValues({}, item), {
                customTemplate: this.statusTemplate
              });
            } else if (item.header === "process_status") {
              return __spreadProps(__spreadValues({}, item), {
                customTemplate: this.processStatusTemplate
              });
            } else if (item.header === "table_column_action") {
              return __spreadProps(__spreadValues({}, item), {
                customTemplate: this.actionTemplate
              });
            } else if (item.header === "documentation_video_url") {
              return __spreadProps(__spreadValues({}, item), {
                customTemplate: this.linkDownloadVideoURLTemplate
              });
            } else if (item.header === "documentation_pdf") {
              return __spreadProps(__spreadValues({}, item), {
                customTemplate: this.linkDownloadPdfURLTemplate
              });
            } else if (item.header === "documentation_word") {
              return __spreadProps(__spreadValues({}, item), {
                customTemplate: this.linkDownloadWordURLTemplate
              });
            } else {
              return __spreadValues({}, item);
            }
          });
        }
        if (response.data.records) {
          this.items = response.data.records.map((item, index) => {
            const formattedItem = __spreadValues({}, item);
            for (const key in formattedItem) {
              if (formattedItem.hasOwnProperty(key) && (key.toLowerCase().includes("date") || key.toLowerCase().includes("deleted_at") || key.toLowerCase().includes("created_at") || key.toLowerCase().includes("updated_at")) && this.isDate(formattedItem[key])) {
                const transformedDate = this.timezoneService.transformDateTime(formattedItem[key]);
                if (transformedDate) {
                  formattedItem[key] = transformedDate;
                }
              }
            }
            if (this.config.grid_show_serial_number == "true") {
              return __spreadProps(__spreadValues({
                table_column_sno: this.listQuery.start_index + index + 1
              }, formattedItem), {
                Action: index + 1
              });
            }
            return __spreadProps(__spreadValues({}, formattedItem), {
              Action: index + 1
            });
          });
          this.totalItems = response.data.total_records;
          this.gridloading = false;
        } else {
          this.items = [];
          this.totalItems = 0;
          this.gridloading = false;
        }
      } else {
        this.items = [];
        this.totalItems = 0;
        this.gridloading = false;
        const key = response.message;
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      }
    }, (error) => {
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
      this.gridloading = false;
    });
  }
  executeJob(inputObject) {
    return __async(this, null, function* () {
      if (inputObject.record_info.id) {
        const job_query_information = this.localStorageService.replaceUniqueId(inputObject.query_information, "$unique_id", inputObject.record_info.id);
        try {
          const response = yield lastValueFrom(this.gridApiService.executeTransaction(job_query_information));
          if (!response.status) {
            throw new Error(response.message);
          }
        } catch (error) {
          throw error;
        }
      }
    });
  }
  isDate(value) {
    return !isNaN(Date.parse(value));
  }
  formatDate(value) {
    return this.timezoneService.transformDateOnly(value);
  }
  capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
  }
  deleteItems(items) {
    this.items = this.items.filter((item) => !items.includes(item));
  }
  editItem(item) {
    if (this.masterInfo.children.edit) {
      let targetRoute = this.masterInfo.children.edit.target;
      if (targetRoute.includes(":uuid") && item.uuid) {
        console.log("coming");
        targetRoute = targetRoute.replace(":uuid", item.uuid);
      } else if (targetRoute.includes(":id") && item.id) {
        console.log("coming");
        targetRoute = targetRoute.replace(":id", item.uuid);
      }
      this.router.navigate([targetRoute]);
    }
  }
  exportItem(item) {
    if (this.masterInfo.children.export_excel) {
      this.gridApiService.exportAllRecords(this.masterInfo.children.export_excel.id).subscribe({
        next: (response) => {
          try {
            const blob = new Blob([response.blob], {
              type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
            });
            if (item.type === "excel") {
              const url = window.URL.createObjectURL(blob);
              const link = document.createElement("a");
              link.href = url;
              link.download = response.fileName;
              document.body.appendChild(link);
              link.click();
              document.body.removeChild(link);
              window.URL.revokeObjectURL(url);
              this.loading = false;
            } else if (item.type === "pdf") {
              this.convertExcelToPDF(blob, response.fileName.replace(".xlsx", ".pdf"));
              this.loading = false;
            }
          } catch (err) {
            this.loading = false;
            console.error("Download error:", err);
            this.toastr.error("Error downloading file");
          }
        },
        error: (error) => {
          this.loading = false;
          console.error("Export error:", error);
          this.toastr.error("Error exporting data");
        }
      });
    }
  }
  convertExcelToPDF(blob, pdfFileName) {
    const reader = new FileReader();
    reader.onload = (event) => {
      const data = new Uint8Array(event.target.result);
      const workbook = readSync(data, { type: "array" });
      const firstSheetName = workbook.SheetNames[0];
      const worksheet = workbook.Sheets[firstSheetName];
      const sheetData = utils.sheet_to_json(worksheet, { header: 1 });
      const doc = new jspdf_es_min_default();
      let y = 10;
      sheetData.forEach((row) => {
        const rowText = row.join("  ");
        doc.text(rowText, 10, y);
        y += 10;
      });
      doc.save(pdfFileName);
    };
    reader.readAsArrayBuffer(blob);
  }
  assignItem(item) {
    if (this.masterInfo.children.assign) {
      let targetRoute = this.masterInfo.children.assign.target;
      if (targetRoute.includes(":uuid") && item.uuid) {
        console.log("coming");
        targetRoute = targetRoute.replace(":uuid", item.uuid);
      } else if (targetRoute.includes(":id") && item.id) {
        console.log("coming");
        targetRoute = targetRoute.replace(":id", item.uuid);
      }
      this.router.navigate([targetRoute]);
    }
  }
  recordExport(item) {
    this.loading = true;
    if (this.masterInfo.children.record_export) {
      let targetRoute = this.masterInfo.children.record_export.target;
      let recordID = item.id;
      if (targetRoute.includes(":uuid") && item.uuid) {
        recordID = item.uuid;
      } else if (targetRoute.includes(":id") && item.id) {
        recordID = item.id;
      }
      this.gridApiService.exportIndividualRecords(this.masterInfo.children.record_export.id, recordID).subscribe({
        next: (response) => {
          try {
            const blob = new Blob([response.blob], {
              type: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
            });
            const url = window.URL.createObjectURL(blob);
            const link = document.createElement("a");
            link.href = url;
            link.download = response.fileName;
            document.body.appendChild(link);
            link.click();
            document.body.removeChild(link);
            window.URL.revokeObjectURL(url);
            this.loading = false;
          } catch (err) {
            console.error("Download error:", err);
            this.toastr.error("Error downloading file");
            this.loading = false;
          }
        },
        error: (error) => {
          console.error("Export error:", error);
          this.toastr.error("Error exporting data");
          this.loading = false;
        }
      });
    }
  }
  commonTranslate(msg) {
    return this.translate.instant(msg);
  }
  printItem(item) {
    if (this.masterInfo.children.print) {
      let targetRoute = this.masterInfo.children.print.target;
      if (targetRoute.includes(":uuid") && item.uuid) {
        console.log("coming");
        targetRoute = targetRoute.replace(":uuid", item.uuid);
      } else if (targetRoute.includes(":id") && item.id) {
        console.log("coming");
        targetRoute = targetRoute.replace(":id", item.uuid);
      }
      this.router.navigate([targetRoute]);
    }
  }
  directDeleteItem(item) {
    import_sweetalert2.default.fire({
      icon: "warning",
      title: "Are you sure?",
      text: "You won't be able to revert this!",
      showCancelButton: true,
      confirmButtonText: "Delete",
      padding: "2em"
    }).then((result) => __async(this, null, function* () {
      if (result.value) {
        try {
          const jobResponse = yield this.localStorageService.getMasterEntity({
            record_info: item,
            entity_name: this.masterInfo.children.delete.entity_name,
            entity_type: this.masterInfo.children.delete.component_class_name
          });
          if (jobResponse) {
            yield this.executeJob(__spreadProps(__spreadValues({}, jobResponse), { record_info: item }));
            import_sweetalert2.default.fire({ title: "Deleted!", text: "Your file has been deleted.", icon: "success" });
            this.fetchData(this.listQuery);
          }
        } catch (error) {
          const key = "error";
          const errorMessage = this.translate.instant(key);
          this.toastr.error(errorMessage, error.message);
        }
      }
    }));
  }
  generateVector(item) {
    if (this.masterInfo.permissions.generate_vector) {
      import_sweetalert2.default.fire({
        icon: "info",
        title: "Generate Vector?",
        text: "are you sure, you want to generate vector?",
        showCancelButton: true,
        confirmButtonText: "Generate",
        padding: "2em"
      }).then((result) => __async(this, null, function* () {
        if (result.value) {
          this.loading = true;
          this.openaiService.generateVectorForTable({ uuid: item.uuid }).subscribe((res) => {
            this.loading = false;
            if (res.status) {
              this.toastr.success("Vector generated successfully", "Success");
              this.setPageReload();
            } else {
              this.toastr.error("Failed to generate vector", "Error");
            }
          });
        }
      }));
    }
  }
  setPageReload() {
    setTimeout(() => {
      window.location.reload();
    }, 1e3);
  }
  emailResendItem(item) {
    if (this.masterInfo.children.email_resend && this.masterInfo.children.email_resend.component_class_name === commonConfig.ENTITY_TYPES.JOB_BUILDER_MODULE) {
      import_sweetalert2.default.fire({
        icon: "info",
        title: "Resend Mail?",
        text: "are you sure, you want to resend mail?",
        showCancelButton: true,
        confirmButtonText: "Resend",
        padding: "2em"
      }).then((result) => __async(this, null, function* () {
        if (result.value) {
          try {
            const jobResponse = yield this.localStorageService.getMasterEntity({
              record_info: item,
              entity_name: this.masterInfo.children.email_resend.entity_name,
              entity_type: this.masterInfo.children.email_resend.component_class_name
            });
            if (jobResponse) {
              yield this.executeJob(__spreadProps(__spreadValues({}, jobResponse), { record_info: item }));
              import_sweetalert2.default.fire({ title: "Mail resent request initiated!", text: "Mail resent request has been initiated.", icon: "success" });
              this.fetchData(this.listQuery);
            }
          } catch (error) {
            const key = "error";
            const errorMessage = this.translate.instant(key);
            this.toastr.error(errorMessage, error.message);
          }
        }
      }));
    }
  }
  deleteItem(item) {
    if (this.masterInfo.children.delete && this.masterInfo.children.delete.component_class_name === commonConfig.ENTITY_TYPES.JOB_BUILDER_MODULE) {
      let targetRoute = this.masterInfo.children.delete.target;
      if (this.grid_records_delete == "true") {
        const procedureParams = { proc_name: "check_for_related_records", params: { entity_name: this.listQuery.entity_name, record_id: item.id } };
        this.commonService.procedureCall(procedureParams).subscribe({
          next: (response) => {
            if (response.code === 200 && response.status && response.data) {
              const res = response.data?.[0]?.result || [];
              if (Object.keys(res).length > 0) {
                let htmlInput = `
  <span>` + this.commonTranslate("config_delete_msg_0") + `</span><br><br>
  <table style="width: 100%; text-align: center; border-collapse: collapse;">
  <thead>
    <tr>
      <th style="border: 1px solid #ddd; padding: 8px;">` + this.commonTranslate("config_delete_msg_1") + `</th>
      <th style="border: 1px solid #ddd; padding: 8px;">` + this.commonTranslate("config_delete_msg_2") + `</th>
    </tr> </thead><tbody>
`;
                Object.entries(res).forEach(([key, value]) => {
                  htmlInput += `
    <tr>
      <td style="border: 1px solid #ddd; padding: 8px;">${key}</td>
      <td style="border: 1px solid #ddd; padding: 8px;">${value}</td>
    </tr>
  `;
                });
                htmlInput += `</tbody></table>`;
                import_sweetalert2.default.fire({
                  title: `<span style="color: orange;">` + this.commonTranslate("config_delete_msg_3") + `!</span>`,
                  html: htmlInput,
                  customClass: {
                    title: "swal-title"
                  }
                });
              } else {
                this.directDeleteItem(item);
              }
            } else {
              const key = "error";
              const errorMessage = this.translate.instant(key);
              this.toastr.error(errorMessage, "Error");
            }
          },
          error: (error) => {
            console.error("Error fetching data:", error);
          },
          complete: () => {
          }
        });
      } else {
        this.directDeleteItem(item);
      }
    }
  }
  viewItem(item) {
    console.log(item);
    if (this.masterInfo.children.details) {
      let targetRoute = this.masterInfo.children.details.target;
      if (targetRoute.includes(":uuid") && item.uuid) {
        console.log("coming");
        targetRoute = targetRoute.replace(":uuid", item.uuid);
      } else if (targetRoute.includes(":id") && item.id) {
        console.log("coming");
        targetRoute = targetRoute.replace(":id", item.uuid);
      }
      this.router.navigate([targetRoute]);
    }
  }
  handleCustomAction(action) {
    console.log(action);
    console.log(this.masterInfo);
    if (action === "addNew" && this.masterInfo.children.add) {
      this.router.navigate([`${this.masterInfo.children.add.target}`]);
    }
    if (action === "addNew" && this.masterInfo.children.popup_add) {
      this.loadingpopup = true;
      console.log("coming");
      this.popupName = "popup_add";
      this.selectedItemUuid = null;
      this.popupEntityName = this.masterInfo.children.popup_add.entity_name;
      this.isViewPopupOpen = true;
      setTimeout(() => {
        this.loadingpopup = false;
      }, 500);
    }
  }
  editPopupItem(item) {
    this.loadingpopup = true;
    this.popupName = "popup_edit";
    console.log(this.popupName);
    console.log(this.masterInfo);
    this.selectedItemUuid = item.uuid;
    this.popupEntityName = this.masterInfo.children.popup_edit.entity_name;
    this.isViewPopupOpen = true;
    setTimeout(() => {
      this.loadingpopup = false;
    }, 500);
  }
  viewPopupItem(item) {
    this.loadingpopup = true;
    this.popupName = "popup_details";
    this.selectedItemUuid = item.uuid;
    this.popupEntityName = this.masterInfo.children.popup_details.entity_name;
    this.isViewPopupOpen = true;
    setTimeout(() => {
      this.loadingpopup = false;
    }, 500);
  }
  closeViewPopup() {
    this.isViewPopupOpen = false;
    this.selectedItemUuid = null;
  }
  onPageChange(event) {
    this.currentPage = event.page;
    this.listQuery.start_index = event.start_index;
    this.listQuery.limit_range = this.resultsPerPage;
    this.fetchData(this.listQuery);
  }
  onResultsPerPageChange(event) {
    this.currentPage = 1;
    this.resultsPerPage = event.resultsPerPage;
    this.listQuery.start_index = event.start_index;
    this.listQuery.limit_range = event.resultsPerPage;
    this.fetchData(this.listQuery);
  }
  openFormBuilderPopup(entityName, item) {
    this.loadingpopup = true;
    this.popupName = "popup_details";
    this.selectedItemUuid = item.uuid;
    this.popupEntityName = entityName;
    this.isViewPopupOpen = true;
    setTimeout(() => {
      this.loadingpopup = false;
    }, 500);
  }
  onLinkComponentClick(event) {
    if (event.col.link_type === "component") {
      const mode = event.col.link_mode || "popup_details";
      this.popupName = mode;
      this.selectedItemUuid = event.item.uuid;
      console.log(this.selectedItemUuid);
      if (mode === "popup_add") {
        this.selectedItemUuid = null;
      }
      this.popupEntityName = event.col.link_action;
      console.log(this.popupEntityName);
      this.isViewPopupOpen = true;
      this.loadingpopup = true;
      setTimeout(() => {
        this.loadingpopup = false;
      }, 500);
    }
  }
};
_MasterListChildrenComponent.\u0275fac = function MasterListChildrenComponent_Factory(t) {
  return new (t || _MasterListChildrenComponent)(\u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(ProfileApiService), \u0275\u0275directiveInject(HttpClient), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(ChangeDetectorRef), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(Store), \u0275\u0275directiveInject(ExportService), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(MenuMapService), \u0275\u0275directiveInject(Title), \u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(OpenaiService), \u0275\u0275directiveInject(RouteUpdateService), \u0275\u0275directiveInject(TimezoneService));
};
_MasterListChildrenComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _MasterListChildrenComponent, selectors: [["master-list-children"]], viewQuery: function MasterListChildrenComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c02, 5);
    \u0275\u0275viewQuery(_c12, 5);
    \u0275\u0275viewQuery(_c22, 5);
    \u0275\u0275viewQuery(_c32, 5);
    \u0275\u0275viewQuery(_c42, 5);
    \u0275\u0275viewQuery(_c52, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.actionTemplate = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.statusTemplate = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.processStatusTemplate = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.linkDownloadVideoURLTemplate = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.linkDownloadPdfURLTemplate = _t.first);
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.linkDownloadWordURLTemplate = _t.first);
  }
}, inputs: { uuid: "uuid", entity_name: "entity_name", isViewPopupOpen: "isViewPopupOpen" }, standalone: true, features: [\u0275\u0275ProvidersFeature([DatePipe]), \u0275\u0275StandaloneFeature], decls: 17, vars: 17, consts: [["actionTemplate", ""], ["statusTemplate", ""], ["processStatusTemplate", ""], ["linkDownloadVideoURLTemplate", ""], ["linkDownloadPdfURLTemplate", ""], ["linkDownloadWordURLTemplate", ""], [3, "delete", "edit", "view", "customAction", "pageChange", "resultsPerPageChange", "columnSort", "searchQuery", "exportType", "advancedSearchQuery", "linkComponentClick", "loading", "masterInfo", "enableCheckBox", "customTemplates", "headercolumns", "selectcolumns", "items", "totalItems", "currentPage", "resultsPerPage", "column", "title", "query", "unique_id"], [4, "ngIf"], ["class", "fixed inset-0 z-50 overflow-y-auto", 4, "ngIf"], [1, "flex", "items-center", "gap-4"], ["href", "javascript:void(0);", "class", "hover:text-primary", "ngxTippy", "", "data-tippy-content", "Resend Email", "appDynamicFontSize", "body", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-primary", "ngxTippy", "", "data-tippy-content", "Details", "appDynamicFontSize", "body", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-info", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Edit", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-primary", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Delete", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-primary", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Assign", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-primary", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Print", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-primary", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Record Export", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "class", "hover:text-primary", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Generate Vector", 3, "click", 4, "ngIf"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", 3, "text-red-500", "hover:text-primary", "click", 4, "ngIf"], ["href", "javascript:void(0);", "ngxTippy", "", "data-tippy-content", "Resend Email", "appDynamicFontSize", "body", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "ngxTippy", "", "data-tippy-content", "Details", "appDynamicFontSize", "body", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Edit", 1, "hover:text-info", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Delete", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Assign", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Print", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Record Export", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", "data-tippy-content", "Generate Vector", 1, "hover:text-primary", 3, "click"], ["href", "javascript:void(0);", "appDynamicFontSize", "body", "ngxTippy", "", 3, "click"], [1, "fa", "fa-key", 3, "ngClass"], [1, "badge", 3, "ngClass"], ["target", "_blank", "rel", "noopener noreferrer", "class", "flex items-center gap-2 text-blue-600 hover:underline", 3, "href", "ngClass", 4, "ngIf"], ["target", "_blank", "rel", "noopener noreferrer", 1, "flex", "items-center", "gap-2", "text-blue-600", "hover:underline", 3, "href", "ngClass"], [1, "fa-solid", "fa-up-right-from-square"], [1, "fa-solid", "fa-download"], [1, "fixed", "inset-0", "z-50", "overflow-y-auto"], [1, "fixed", "inset-0", "bg-black/50", "transition-opacity", "dark:bg-black/70"], [1, "flex", "min-h-screen", "items-center", "justify-center", "p-2", "sm:p-4"], [1, "relative", "w-full", "max-w-4xl", "transform", "overflow-hidden", "rounded-lg", "bg-white", "shadow-xl", "transition-all", "dark:border", "dark:border-gray-700", "dark:bg-gray-800"], [1, "border-b", "bg-gray-50", "px-4", "py-3", "dark:border-gray-700", "dark:bg-gray-900", "sm:px-6"], [1, "flex", "items-center", "justify-between"], [1, "text-base", "font-medium", "text-gray-900", "dark:text-gray-100", "sm:text-lg"], ["type", "button", 1, "rounded-md", "p-2", "text-gray-400", "hover:text-gray-900", "focus:outline-none", "focus:ring-2", "focus:ring-blue-500", "dark:hover:text-gray-100", 3, "click"], [1, "sr-only"], [1, "fa-solid", "fa-xmark"], [1, "px-4", "py-4", "sm:px-6"], [1, "mb-5", "rounded-md", "border", "border-[#ebedf2]", "bg-white", "p-4", "dark:border-[#191e3a]", "dark:bg-[#0e1726]", 3, "ngSubmit", "formGroup"], [1, "flex", "flex-col", "sm:flex-row"], [1, "grid", "flex-1", "gap-5", "sm:grid-cols-2"], ["for", "new_password", 1, "form-label"], ["type", "password", "formControlName", "new_password", "id", "new_password", 1, "form-input"], ["class", "text-red-500", 4, "ngIf"], ["for", "confirm_new_password", 1, "form-label"], ["type", "password", "formControlName", "confirm_new_password", "id", "confirm_new_password", 1, "form-input"], [1, "mt-5", "flex", "flex-col", "items-center"], ["appDynamicFontSize", "body", "type", "submit", 1, "btn", "btn-primary"], [1, "mt-3", "text-center", "text-sm", "text-gray-500", "dark:text-gray-400"], [1, "text-red-500"], [1, "flex", "min-h-screen", "items-center", "justify-center", "p-6", "sm:p-8"], [1, "relative", "w-full", "max-w-screen-xl", "transform", "overflow-hidden", "rounded-2xl", "bg-white", "shadow-2xl", "transition-all", "dark:border", "dark:border-gray-700", "dark:bg-gray-800"], [1, "max-h-[85vh]", "overflow-y-auto", "p-8", "sm:px-12", "sm:py-8"], [3, "uuid", "entityName", "isModal", "closeModal", 4, "ngIf"], [3, "closeModal", "uuid", "entityName", "isModal"]], template: function MasterListChildrenComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div")(1, "app-datatable-children", 6);
    \u0275\u0275listener("delete", function MasterListChildrenComponent_Template_app_datatable_children_delete_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.deleteItems($event));
    })("edit", function MasterListChildrenComponent_Template_app_datatable_children_edit_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.editItem($event));
    })("view", function MasterListChildrenComponent_Template_app_datatable_children_view_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.viewItem($event));
    })("customAction", function MasterListChildrenComponent_Template_app_datatable_children_customAction_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.handleCustomAction($event));
    })("pageChange", function MasterListChildrenComponent_Template_app_datatable_children_pageChange_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onPageChange($event));
    })("resultsPerPageChange", function MasterListChildrenComponent_Template_app_datatable_children_resultsPerPageChange_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onResultsPerPageChange($event));
    })("columnSort", function MasterListChildrenComponent_Template_app_datatable_children_columnSort_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.sortColumn($event));
    })("searchQuery", function MasterListChildrenComponent_Template_app_datatable_children_searchQuery_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.searchData($event));
    })("exportType", function MasterListChildrenComponent_Template_app_datatable_children_exportType_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.exportTable($event));
    })("advancedSearchQuery", function MasterListChildrenComponent_Template_app_datatable_children_advancedSearchQuery_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.advancedSearchData($event));
    })("linkComponentClick", function MasterListChildrenComponent_Template_app_datatable_children_linkComponentClick_1_listener($event) {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onLinkComponentClick($event));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275template(2, MasterListChildrenComponent_ng_template_2_Template, 12, 11, "ng-template", null, 0, \u0275\u0275templateRefExtractor)(4, MasterListChildrenComponent_ng_template_4_Template, 3, 7, "ng-template", null, 1, \u0275\u0275templateRefExtractor)(6, MasterListChildrenComponent_ng_template_6_Template, 3, 7, "ng-template", null, 2, \u0275\u0275templateRefExtractor)(8, MasterListChildrenComponent_ng_template_8_Template, 1, 1, "ng-template", null, 3, \u0275\u0275templateRefExtractor)(10, MasterListChildrenComponent_ng_template_10_Template, 1, 1, "ng-template", null, 4, \u0275\u0275templateRefExtractor)(12, MasterListChildrenComponent_ng_template_12_Template, 1, 1, "ng-template", null, 5, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementEnd();
    \u0275\u0275template(14, MasterListChildrenComponent_app_loader_14_Template, 1, 0, "app-loader", 7)(15, MasterListChildrenComponent_div_15_Template, 37, 15, "div", 8)(16, MasterListChildrenComponent_div_16_Template, 7, 2, "div", 8);
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275property("loading", ctx.gridloading)("masterInfo", ctx.masterInfo)("enableCheckBox", ctx.enableCheckBox)("customTemplates", ctx.customTemplates)("headercolumns", ctx.headercolumns)("selectcolumns", ctx.selectcolumns)("items", ctx.items)("totalItems", ctx.totalItems)("currentPage", ctx.currentPage)("resultsPerPage", ctx.resultsPerPage)("column", ctx.column)("title", ctx.title)("query", ctx.query)("unique_id", ctx.uniqueId);
    \u0275\u0275advance(13);
    \u0275\u0275property("ngIf", ctx.loading);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isItemModalOpen);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isViewPopupOpen);
  }
}, dependencies: [CommonSharedModule, NgClass, NgIf, \u0275NgNoValidate, DefaultValueAccessor, NgControlStatus, NgControlStatusGroup, NgxTippyDirective, DynamicFontSizeDirective, TranslatePipe, HttpClientModule, DataTableChildrenComponent, LoaderComponent, ReactiveFormsModule, FormGroupDirective, FormControlName, StaticPageComponent, FormBuilderComponent], encapsulation: 2, data: { animation: [
  trigger("toggleAnimation", [
    transition(":enter", [style({ opacity: 0, transform: "scale(0.95)" }), animate("100ms ease-out", style({ opacity: 1, transform: "scale(1)" }))]),
    transition(":leave", [animate("75ms", style({ opacity: 0, transform: "scale(0.95)" }))])
  ])
] } });
var MasterListChildrenComponent = _MasterListChildrenComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(MasterListChildrenComponent, { className: "MasterListChildrenComponent", filePath: "src\\app\\@lcp-framework\\pages\\master-list-children\\master-list-children.component.ts", lineNumber: 64 });
})();

// src/app/@lcp-framework/components/child-datatable/child-datatable.component.ts
var _ChildDatatableComponent = class _ChildDatatableComponent {
  constructor() {
  }
  ngOnInit() {
    console.log(this.uuid);
    console.log(this.entity_name);
  }
};
_ChildDatatableComponent.\u0275fac = function ChildDatatableComponent_Factory(t) {
  return new (t || _ChildDatatableComponent)();
};
_ChildDatatableComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ChildDatatableComponent, selectors: [["app-child-datatable"]], inputs: { uuid: "uuid", entity_name: "entity_name" }, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 1, vars: 2, consts: [[3, "uuid", "entity_name"]], template: function ChildDatatableComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "master-list-children", 0);
  }
  if (rf & 2) {
    \u0275\u0275property("uuid", ctx.uuid)("entity_name", ctx.entity_name);
  }
}, dependencies: [MasterListChildrenComponent] });
var ChildDatatableComponent = _ChildDatatableComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ChildDatatableComponent, { className: "ChildDatatableComponent", filePath: "src\\app\\@lcp-framework\\components\\child-datatable\\child-datatable.component.ts", lineNumber: 12 });
})();

// src/app/@lcp-framework/components/datatable/datatable.component.ts
var _c03 = ["searchInput"];
var _c13 = (a0) => [a0];
var _c23 = (a0) => ({ "bh-text-primary": a0 });
var _c33 = (a0) => ({ "cursor-pointer text-blue-600 underline": a0 });
var _c43 = (a0) => ({ $implicit: a0 });
var _c53 = (a0) => ({ "bg-blue-50": a0 });
function DataTableComponent_span_21_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 57);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(ctx_r1.getNonEmptyFilterCount());
  }
}
function DataTableComponent_div_22_ng_container_16_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "p", 74);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate("No filter applied");
  }
}
function DataTableComponent_div_22_ng_template_17_div_0_i_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 84);
  }
}
function DataTableComponent_div_22_ng_template_17_div_0_i_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "i", 85);
  }
}
function DataTableComponent_div_22_ng_template_17_div_0_option_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 86);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r7 = ctx.$implicit;
    \u0275\u0275property("value", col_r7.field);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(col_r7.title);
  }
}
function DataTableComponent_div_22_ng_template_17_div_0_option_12_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 86);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const op_r8 = ctx.$implicit;
    \u0275\u0275property("value", op_r8.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(op_r8.label);
  }
}
function DataTableComponent_div_22_ng_template_17_div_0_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 76);
    \u0275\u0275template(1, DataTableComponent_div_22_ng_template_17_div_0_i_1_Template, 1, 0, "i", 77)(2, DataTableComponent_div_22_ng_template_17_div_0_i_2_Template, 1, 0, "i", 78);
    \u0275\u0275elementStart(3, "select", 79);
    \u0275\u0275listener("change", function DataTableComponent_div_22_ng_template_17_div_0_Template_select_change_3_listener($event) {
      const i_r5 = \u0275\u0275restoreView(_r4).index;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.onColumnChange($event, i_r5));
    });
    \u0275\u0275twoWayListener("ngModelChange", function DataTableComponent_div_22_ng_template_17_div_0_Template_select_ngModelChange_3_listener($event) {
      const condition_r6 = \u0275\u0275restoreView(_r4).$implicit;
      \u0275\u0275twoWayBindingSet(condition_r6.field, $event) || (condition_r6.field = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementStart(4, "option", 80);
    \u0275\u0275text(5);
    \u0275\u0275pipe(6, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275template(7, DataTableComponent_div_22_ng_template_17_div_0_option_7_Template, 2, 2, "option", 43);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(8, "select", 81);
    \u0275\u0275twoWayListener("ngModelChange", function DataTableComponent_div_22_ng_template_17_div_0_Template_select_ngModelChange_8_listener($event) {
      const condition_r6 = \u0275\u0275restoreView(_r4).$implicit;
      \u0275\u0275twoWayBindingSet(condition_r6.operator, $event) || (condition_r6.operator = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementStart(9, "option", 80);
    \u0275\u0275text(10);
    \u0275\u0275pipe(11, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275template(12, DataTableComponent_div_22_ng_template_17_div_0_option_12_Template, 2, 2, "option", 43);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(13, "input", 82);
    \u0275\u0275listener("ngModelChange", function DataTableComponent_div_22_ng_template_17_div_0_Template_input_ngModelChange_13_listener($event) {
      const i_r5 = \u0275\u0275restoreView(_r4).index;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.setConditionValue(i_r5, $event));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(14, "button", 70);
    \u0275\u0275listener("click", function DataTableComponent_div_22_ng_template_17_div_0_Template_button_click_14_listener() {
      const i_r5 = \u0275\u0275restoreView(_r4).index;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.removeCondition(i_r5));
    });
    \u0275\u0275element(15, "i", 83);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const condition_r6 = ctx.$implicit;
    const i_r5 = ctx.index;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx_r1.filterCondition);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.filterCondition);
    \u0275\u0275advance();
    \u0275\u0275twoWayProperty("ngModel", condition_r6.field);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(6, 15, "table_multiselect_1"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx_r1.filteredColumns);
    \u0275\u0275advance();
    \u0275\u0275twoWayProperty("ngModel", condition_r6.operator);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(11, 17, "condition"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx_r1.getOperatorsForColumn(condition_r6.field));
    \u0275\u0275advance();
    \u0275\u0275property("ngModel", ctx_r1.getConditionValue(i_r5))("type", ctx_r1.getInputTypeForColumn(condition_r6.field))("placeholder", ctx_r1.getPlaceholderForColumn(condition_r6.field))("required", true);
    \u0275\u0275attribute("min", ctx_r1.getMinValueForColumn(condition_r6.field))("max", ctx_r1.getMaxValueForColumn(condition_r6.field))("pattern", ctx_r1.getPatternForColumn(condition_r6.field));
  }
}
function DataTableComponent_div_22_ng_template_17_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, DataTableComponent_div_22_ng_template_17_div_0_Template, 16, 19, "div", 75);
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275property("ngForOf", ctx_r1.filterConditions);
  }
}
function DataTableComponent_div_22_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 58)(1, "div", 59)(2, "span");
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 60)(6, "button", 61);
    \u0275\u0275listener("click", function DataTableComponent_div_22_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.addCondition());
    });
    \u0275\u0275element(7, "i", 62);
    \u0275\u0275text(8, "\xA0");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "label", 63)(10, "input", 64);
    \u0275\u0275twoWayListener("ngModelChange", function DataTableComponent_div_22_Template_input_ngModelChange_10_listener($event) {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      \u0275\u0275twoWayBindingSet(ctx_r1.filterCondition, $event) || (ctx_r1.filterCondition = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275element(11, "span", 65);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "span");
    \u0275\u0275text(13);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "ng-scrollbar", 66)(15, "div", 67);
    \u0275\u0275template(16, DataTableComponent_div_22_ng_container_16_Template, 3, 1, "ng-container", 68)(17, DataTableComponent_div_22_ng_template_17_Template, 1, 1, "ng-template", null, 1, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(19, "div", 69)(20, "button", 70);
    \u0275\u0275listener("click", function DataTableComponent_div_22_Template_button_click_20_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.clearFilters());
    });
    \u0275\u0275text(21);
    \u0275\u0275pipe(22, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(23, "div", 71)(24, "button", 72);
    \u0275\u0275listener("click", function DataTableComponent_div_22_Template_button_click_24_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.applyFilters());
    });
    \u0275\u0275text(25);
    \u0275\u0275pipe(26, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(27, "button", 73);
    \u0275\u0275listener("click", function DataTableComponent_div_22_Template_button_click_27_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.cancelFilters());
    });
    \u0275\u0275text(28);
    \u0275\u0275pipe(29, "translate");
    \u0275\u0275elementEnd()()()();
  }
  if (rf & 2) {
    const filterList_r9 = \u0275\u0275reference(18);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(4, 9, "table_advance_filter"));
    \u0275\u0275advance(7);
    \u0275\u0275twoWayProperty("ngModel", ctx_r1.filterCondition);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx_r1.filterCondition ? "AND" : "OR");
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ctx_r1.filterConditions.length === 0)("ngIfElse", filterList_r9);
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(22, 11, "table_clear_filter"));
    \u0275\u0275advance(3);
    \u0275\u0275property("disabled", !ctx_r1.isApplyButtonEnabled());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(26, 13, "apply"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(29, 15, "cancel"));
  }
}
function DataTableComponent_ul_30_ng_container_9_Template(rf, ctx) {
  if (rf & 1) {
    const _r11 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "li")(2, "div", 91)(3, "label", 92)(4, "input", 93);
    \u0275\u0275listener("ngModelChange", function DataTableComponent_ul_30_ng_container_9_Template_input_ngModelChange_4_listener() {
      const col_r12 = \u0275\u0275restoreView(_r11).$implicit;
      const ctx_r1 = \u0275\u0275nextContext(2);
      return \u0275\u0275resetView(ctx_r1.toggleColumnFilterHide(col_r12));
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "span", 94);
    \u0275\u0275text(6);
    \u0275\u0275pipe(7, "translate");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r12 = ctx.$implicit;
    const i_r13 = ctx.index;
    \u0275\u0275advance(3);
    \u0275\u0275property("for", "chk-" + i_r13);
    \u0275\u0275advance();
    \u0275\u0275property("id", "chk-" + i_r13)("ngModel", !col_r12.colFilterHide);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(7, 4, col_r12.header), "");
  }
}
function DataTableComponent_ul_30_Template(rf, ctx) {
  if (rf & 1) {
    const _r10 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "ul", 87)(1, "li")(2, "div", 88)(3, "button", 89);
    \u0275\u0275listener("click", function DataTableComponent_ul_30_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.selectAll());
    });
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "button", 90);
    \u0275\u0275listener("click", function DataTableComponent_ul_30_Template_button_click_6_listener() {
      \u0275\u0275restoreView(_r10);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.clearAll());
    });
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(9, DataTableComponent_ul_30_ng_container_9_Template, 8, 6, "ng-container", 36);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("@toggleAnimation", void 0);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(5, 4, "select_all"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(8, 6, "clear_all"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngForOf", ctx_r1.headercolumns);
  }
}
function DataTableComponent_div_31_ul_8_a_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r14 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "a", 101);
    \u0275\u0275listener("click", function DataTableComponent_div_31_ul_8_a_2_Template_a_click_0_listener() {
      \u0275\u0275restoreView(_r14);
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.exportTable("excel"));
    });
    \u0275\u0275element(1, "i", 102);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(3, 1, "excel"), " ");
  }
}
function DataTableComponent_div_31_ul_8_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "ul", 99)(1, "li");
    \u0275\u0275template(2, DataTableComponent_div_31_ul_8_a_2_Template, 4, 3, "a", 100);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275property("@toggleAnimation", void 0);
  }
}
function DataTableComponent_div_31_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 95)(1, "div", 22)(2, "button", 96);
    \u0275\u0275element(3, "i", 97);
    \u0275\u0275text(4, " \xA0 ");
    \u0275\u0275elementStart(5, "span", 19);
    \u0275\u0275text(6);
    \u0275\u0275pipe(7, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275template(8, DataTableComponent_div_31_ul_8_Template, 3, 1, "ul", 98);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1("", \u0275\u0275pipeBind1(7, 1, "export"), " ");
  }
}
function DataTableComponent_Conditional_32_Template(rf, ctx) {
  if (rf & 1) {
    const _r15 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 103);
    \u0275\u0275listener("click", function DataTableComponent_Conditional_32_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.syncTableSchema());
    });
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(3, "button", 104);
    \u0275\u0275listener("click", function DataTableComponent_Conditional_32_Template_button_click_3_listener() {
      \u0275\u0275restoreView(_r15);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.generateVectorForAllTable());
    });
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 2, "sync_table_schema"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(5, 4, "generate_vector_for_all_table"), " ");
  }
}
function DataTableComponent_button_34_Template(rf, ctx) {
  if (rf & 1) {
    const _r16 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 105);
    \u0275\u0275pipe(1, "translate");
    \u0275\u0275listener("click", function DataTableComponent_button_34_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r16);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.customAction.emit("addNew"));
    });
    \u0275\u0275element(2, "i", 62);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275propertyInterpolate1("ngxTippy", " ", \u0275\u0275pipeBind1(1, 3, ctx_r1.title), "");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("\xA0", \u0275\u0275pipeBind1(4, 5, "form_button_add_new"), " ");
  }
}
function DataTableComponent_button_36_Template(rf, ctx) {
  if (rf & 1) {
    const _r17 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 105);
    \u0275\u0275pipe(1, "translate");
    \u0275\u0275listener("click", function DataTableComponent_button_36_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r17);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.customAction.emit("addNew"));
    });
    \u0275\u0275element(2, "i", 62);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275propertyInterpolate1("ngxTippy", " ", \u0275\u0275pipeBind1(1, 3, ctx_r1.title), "");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1("\xA0", \u0275\u0275pipeBind1(4, 5, "form_button_add_new"), " ");
  }
}
function DataTableComponent_button_37_Template(rf, ctx) {
  if (rf & 1) {
    const _r18 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 106);
    \u0275\u0275listener("click", function DataTableComponent_button_37_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r18);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.location.back());
    });
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, "back"), " ");
  }
}
function DataTableComponent_th_43_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275element(0, "th", 107);
  }
}
function DataTableComponent_th_44_Template(rf, ctx) {
  if (rf & 1) {
    const _r19 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "th", 107)(1, "input", 108);
    \u0275\u0275listener("change", function DataTableComponent_th_44_Template_input_change_1_listener($event) {
      \u0275\u0275restoreView(_r19);
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.toggleSelectAll($event));
    });
    \u0275\u0275elementEnd()();
  }
}
function DataTableComponent_ng_container_45_th_1_span_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 112);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(1, "svg", 113);
    \u0275\u0275element(2, "polygon", 114)(3, "polygon", 115);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const col_r21 = \u0275\u0275nextContext(2).$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c23, col_r21.sortDirection === "asc"));
    \u0275\u0275advance();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(4, _c23, col_r21.sortDirection === "desc"));
  }
}
function DataTableComponent_ng_container_45_th_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r20 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "th", 110);
    \u0275\u0275pipe(1, "translate");
    \u0275\u0275listener("click", function DataTableComponent_ng_container_45_th_1_Template_th_click_0_listener() {
      \u0275\u0275restoreView(_r20);
      const col_r21 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.sortColumn(col_r21));
    });
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275template(4, DataTableComponent_ng_container_45_th_1_span_4_Template, 4, 6, "span", 111);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r21 = \u0275\u0275nextContext();
    const col_r21 = ctx_r21.$implicit;
    const last_r23 = ctx_r21.last;
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(8, _c13, last_r23 ? "sticky right-0 z-10 bg-gray-50" : ""));
    \u0275\u0275attribute("data-tippy-content", \u0275\u0275pipeBind1(1, 4, col_r21.header));
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 6, col_r21.header), " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", col_r21.is_sortable == "true" && col_r21.is_grid_column == "true");
  }
}
function DataTableComponent_ng_container_45_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_45_th_1_Template, 5, 10, "th", 109);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r21 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r21.is_grid_column == "true" && !col_r21.colFilterHide);
  }
}
function DataTableComponent_tr_47_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr")(1, "td", 116)(2, "section", 117);
    \u0275\u0275element(3, "div", 118)(4, "div", 118)(5, "div", 118)(6, "div", 118)(7, "div", 118);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275attribute("colspan", ctx_r1.gridColumnCount + (ctx_r1.enableCheckBox ? 1 : 0));
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_td_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r24 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "td", 120);
    \u0275\u0275listener("click", function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_td_2_Template_td_click_0_listener() {
      \u0275\u0275restoreView(_r24);
      const item_r25 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.toggleRow(item_r25["uuid"]));
    });
    \u0275\u0275elementStart(1, "button", 121);
    \u0275\u0275element(2, "i", 122);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngClass", ctx_r1.expandedItem === item_r25["uuid"] ? "fa-minus" : "fa-plus");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_td_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r26 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "td")(1, "input", 123);
    \u0275\u0275listener("change", function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_td_3_Template_input_change_1_listener() {
      \u0275\u0275restoreView(_r26);
      const item_r25 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.toggleSelectItem(item_r25));
    });
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("checked", ctx_r1.selectedItems.includes(item_r25));
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r27 = \u0275\u0275getCurrentView();
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "span", 126);
    \u0275\u0275listener("click", function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_container_1_Template_span_click_1_listener() {
      \u0275\u0275restoreView(_r27);
      const col_r28 = \u0275\u0275nextContext(3).$implicit;
      const item_r25 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.onLinkComponentClick(col_r28, item_r25));
    });
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "booleanStatus");
    \u0275\u0275elementEnd();
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(3).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 1, item_r25[col_r28.header]), " ");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_container_0_a_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "a", 128);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "booleanStatus");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(5).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("routerLink", col_r28.link_action);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 2, item_r25[col_r28.header]), " ");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_container_0_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "a", 129);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "booleanStatus");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(5).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("href", col_r28.link_action, \u0275\u0275sanitizeUrl);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 2, item_r25[col_r28.header]), " ");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_container_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_container_0_a_1_Template, 3, 4, "a", 127)(2, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_container_0_ng_template_2_Template, 3, 4, "ng-template", null, 5, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const externalUrl_r29 = \u0275\u0275reference(3);
    const col_r28 = \u0275\u0275nextContext(4).$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r28.link_action && col_r28.link_action.startsWith("/master-entities"))("ngIfElse", externalUrl_r29);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_button_1_Template(rf, ctx) {
  if (rf & 1) {
    const _r30 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 134);
    \u0275\u0275listener("click", function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_button_1_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r30);
      const col_r28 = \u0275\u0275nextContext(6).$implicit;
      const item_r25 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext(3);
      return \u0275\u0275resetView(ctx_r1.toggleColumnChildGrid(item_r25["uuid"], col_r28));
    });
    \u0275\u0275element(1, "i", 122);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(6).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngClass", ctx_r1.isColumnChildGridExpanded(item_r25["uuid"], col_r28) ? "fa-chevron-up" : "fa-chevron-down");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 132);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_button_1_Template, 2, 1, "button", 133);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "booleanStatus");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(5).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(6, _c33, col_r28.link_type === "component"));
    \u0275\u0275attribute("data-tippy-content", item_r25[col_r28.header]);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r28.link_type === "child_grid");
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 4, item_r25[col_r28.header]), " ");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "span", 135);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "booleanStatus");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(5).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(2, 1, item_r25[col_r28.header]), " ");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_0_Template, 4, 8, "span", 130)(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_span_1_Template, 3, 3, "span", 131);
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(4).$implicit;
    \u0275\u0275property("ngIf", col_r28.header !== "Status" && col_r28.header !== "table_column_action");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r28.header === "Status" || col_r28.header === "table_column_action");
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275template(0, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_container_0_Template, 4, 2, "ng-container", 68)(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_ng_template_1_Template, 2, 2, "ng-template", null, 4, \u0275\u0275templateRefExtractor);
  }
  if (rf & 2) {
    const defaultCell_r31 = \u0275\u0275reference(2);
    const col_r28 = \u0275\u0275nextContext(3).$implicit;
    \u0275\u0275property("ngIf", col_r28.link_type === "url")("ngIfElse", defaultCell_r31);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_container_1_Template, 4, 3, "ng-container", 68)(2, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_ng_template_2_Template, 3, 2, "ng-template", null, 3, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const notComponent_r32 = \u0275\u0275reference(3);
    const col_r28 = \u0275\u0275nextContext(2).$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r28.link_type === "component")("ngIfElse", notComponent_r32);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_2_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainer(0);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_2_ng_container_1_Template, 1, 0, "ng-container", 136);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r28 = \u0275\u0275nextContext(2).$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngTemplateOutlet", col_r28.customTemplate)("ngTemplateOutletContext", \u0275\u0275pureFunction1(2, _c43, item_r25));
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "td", 125);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_1_Template, 4, 2, "ng-container", 38)(2, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_ng_container_2_Template, 2, 4, "ng-container", 38);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r32 = \u0275\u0275nextContext();
    const col_r28 = ctx_r32.$implicit;
    const last_r34 = ctx_r32.last;
    \u0275\u0275property("ngClass", last_r34 ? "sticky right-0 z-10 bg-white" + col_r28.cellClass : col_r28.cellClass);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !col_r28.customTemplate && col_r28.is_grid_column == "true");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r28.customTemplate);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_td_1_Template, 3, 3, "td", 124);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r28 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !col_r28.colFilterHide);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_tr_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr")(1, "td", 137)(2, "div", 138);
    \u0275\u0275element(3, "app-child-datatable", 139);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275attribute("colspan", ctx_r1.gridColumnCount + (ctx_r1.enableCheckBox ? 1 : 0) + 1);
    \u0275\u0275advance(2);
    \u0275\u0275property("uuid", item_r25["uuid"])("entity_name", ctx_r1.masterInfo == null ? null : ctx_r1.masterInfo.children.child_details.entity_name);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_6_tr_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr")(1, "td", 137)(2, "div", 138);
    \u0275\u0275element(3, "app-child-datatable", 139);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const col_r35 = \u0275\u0275nextContext().$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275attribute("colspan", ctx_r1.gridColumnCount + (ctx_r1.enableCheckBox ? 1 : 0) + 1);
    \u0275\u0275advance(2);
    \u0275\u0275property("uuid", item_r25["uuid"])("entity_name", col_r35.link_action);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_6_tr_1_Template, 4, 3, "tr", 38);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const col_r35 = ctx.$implicit;
    const item_r25 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", col_r35.link_type === "child_grid" && ctx_r1.isColumnChildGridExpanded(item_r25["uuid"], col_r35));
  }
}
function DataTableComponent_ng_container_48_ng_container_1_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275elementStart(1, "tr");
    \u0275\u0275template(2, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_td_2_Template, 3, 1, "td", 119)(3, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_td_3_Template, 2, 1, "td", 38)(4, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_4_Template, 2, 1, "ng-container", 36);
    \u0275\u0275elementEnd();
    \u0275\u0275template(5, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_tr_5_Template, 4, 3, "tr", 38)(6, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_ng_container_6_Template, 2, 1, "ng-container", 36);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const item_r25 = ctx.$implicit;
    const ctx_r1 = \u0275\u0275nextContext(3);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx_r1.masterInfo == null ? null : ctx_r1.masterInfo.permissions.child_details);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.enableCheckBox);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r1.headercolumns);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.expandedItem === item_r25["uuid"] && (ctx_r1.masterInfo == null ? null : ctx_r1.masterInfo.permissions.child_details));
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r1.headercolumns);
  }
}
function DataTableComponent_ng_container_48_ng_container_1_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_ng_container_1_Template, 7, 5, "ng-container", 36);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx_r1.items);
  }
}
function DataTableComponent_ng_container_48_ng_template_2_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "tr")(1, "td", 116);
    \u0275\u0275text(2);
    \u0275\u0275pipe(3, "translate");
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r1 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275attribute("colspan", ctx_r1.gridColumnCount + (ctx_r1.enableCheckBox ? 1 : 0));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(3, 2, "no_records_found"), " ");
  }
}
function DataTableComponent_ng_container_48_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0);
    \u0275\u0275template(1, DataTableComponent_ng_container_48_ng_container_1_Template, 2, 1, "ng-container", 68)(2, DataTableComponent_ng_container_48_ng_template_2_Template, 4, 4, "ng-template", null, 2, \u0275\u0275templateRefExtractor);
    \u0275\u0275elementContainerEnd();
  }
  if (rf & 2) {
    const noRecords_r36 = \u0275\u0275reference(3);
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r1.items && ctx_r1.items.length > 0)("ngIfElse", noRecords_r36);
  }
}
function DataTableComponent_option_53_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 86);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const option_r37 = ctx.$implicit;
    \u0275\u0275property("value", option_r37);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(option_r37);
  }
}
function DataTableComponent_ng_container_81_button_2_Template(rf, ctx) {
  if (rf & 1) {
    const _r38 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 143);
    \u0275\u0275listener("click", function DataTableComponent_ng_container_81_button_2_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r38);
      const i_r39 = \u0275\u0275nextContext().index;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.handleEllipsisClick(i_r39));
    });
    \u0275\u0275text(1, " ... ");
    \u0275\u0275elementEnd();
  }
}
function DataTableComponent_ng_container_81_button_3_Template(rf, ctx) {
  if (rf & 1) {
    const _r40 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "button", 144);
    \u0275\u0275listener("click", function DataTableComponent_ng_container_81_button_3_Template_button_click_0_listener() {
      \u0275\u0275restoreView(_r40);
      const page_r41 = \u0275\u0275nextContext().$implicit;
      const ctx_r1 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r1.goToPage(page_r41));
    });
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const page_r41 = \u0275\u0275nextContext().$implicit;
    const ctx_r1 = \u0275\u0275nextContext();
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(2, _c53, ctx_r1.currentPage === page_r41));
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", page_r41, " ");
  }
}
function DataTableComponent_ng_container_81_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementContainerStart(0)(1, 140);
    \u0275\u0275template(2, DataTableComponent_ng_container_81_button_2_Template, 2, 0, "button", 141)(3, DataTableComponent_ng_container_81_button_3_Template, 2, 4, "button", 142);
    \u0275\u0275elementContainerEnd()();
  }
  if (rf & 2) {
    const page_r41 = ctx.$implicit;
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitch", page_r41);
    \u0275\u0275advance();
    \u0275\u0275property("ngSwitchCase", "...");
  }
}
var _DataTableComponent = class _DataTableComponent {
  constructor(translate, toastr, storeData, datePipe, localstore, openaiService, location, timezoneService) {
    this.translate = translate;
    this.toastr = toastr;
    this.storeData = storeData;
    this.datePipe = datePipe;
    this.localstore = localstore;
    this.openaiService = openaiService;
    this.location = location;
    this.timezoneService = timezoneService;
    this.expandedItem = null;
    this.expandedColumnChildGrid = null;
    this.loading = false;
    this.customTemplates = {};
    this.title = "";
    this.enableCheckBox = false;
    this.masterInfo = [];
    this.selectcolumns = [];
    this.headercolumns = [];
    this.items = [];
    this.totalItems = 0;
    this.currentPage = 1;
    this.resultsPerPage = 10;
    this.column = "";
    this.query = "";
    this.delete = new EventEmitter();
    this.edit = new EventEmitter();
    this.view = new EventEmitter();
    this.customAction = new EventEmitter();
    this.pageChange = new EventEmitter();
    this.exportType = new EventEmitter();
    this.resultsPerPageChange = new EventEmitter();
    this.columnSort = new EventEmitter();
    this.searchQuery = new EventEmitter();
    this.advancedSearchQuery = new EventEmitter();
    this.linkComponentClick = new EventEmitter();
    this.search = "";
    this.selectedColumns = [];
    this.selectedColumn = "";
    this.searchCondition = "contains";
    this.selectedItems = [];
    this.totalPages = 1;
    this.filteredItems = [];
    this.filteredColumns = [];
    this.textClass = "";
    this.isMenuOpen = false;
    this.filterCondition = true;
    this.filterConditions = [];
    this.selectedColumnType = 1;
    this.currentSearchConditions = [];
    this.field_types = commonConfig.field_types;
    this.inputTypes = commonConfig.field_type;
    this.searchConditions = commonConfig.search_conditions;
    this.isSchemaChunks = false;
    this.mapConditionToSQL = (condition) => {
      switch (condition) {
        case "contains":
          return "ILIKE";
        case "not_contains":
          return "NOT ILIKE";
        case "starts_with":
          return "ILIKE";
        case "ends_with":
          return "ILIKE";
        case "is_empty":
          return "=";
        case "is_not_empty":
          return "<>";
        case "is_null":
          return "IS NULL";
        case "is_not_null":
          return "IS NOT NULL";
        default:
          return condition;
      }
    };
    this.addWildcards = (condition, value) => {
      switch (condition) {
        case "contains":
          return `%${value}%`;
        case "not_contains":
          return `%${value}%`;
        case "starts_with":
          return `${value}%`;
        case "ends_with":
          return `%${value}`;
        default:
          return value;
      }
    };
    this.dropdownSettings = {
      singleSelection: false,
      idField: "field",
      textField: "title",
      selectAllText: "Select All",
      unSelectAllText: "UnSelect All",
      itemsShowLimit: 3,
      allowSearchFilter: true,
      searchPlaceholderText: "Search"
    };
    this.paginationOptions = [];
    this.config = JSON.parse(this.localstore.getData("config"));
    this.user_info = JSON.parse(this.localstore.getData("user_data"));
    this.paginationOptions = this.config.grid_pagination_dropdown.split(",").map((item) => +item);
    this.initStore();
  }
  toggleRow(item) {
    if (this.expandedItem === item) {
      this.expandedItem = null;
      if (this.expandedColumnChildGrid && this.expandedColumnChildGrid.uuid === item) {
        this.expandedColumnChildGrid = null;
      }
    } else {
      if (this.expandedItem !== null && this.expandedColumnChildGrid && this.expandedColumnChildGrid.uuid === this.expandedItem) {
        this.expandedColumnChildGrid = null;
      }
      this.expandedItem = item;
      if (this.expandedColumnChildGrid && this.expandedColumnChildGrid.uuid === item) {
        this.expandedColumnChildGrid = null;
      }
    }
  }
  ngOnInit() {
    console.log(this.unique_id);
    this.headercolumns.forEach((col) => {
      col.sortDirection = "";
      col.colFilterHide = false;
    });
    console.log(this.items);
    this.filteredItems = [...this.items];
    this.translate.get(["table_multiselect_0", "table_multiselect_3"]).subscribe((translations) => {
      this.dropdownSettings = {
        singleSelection: false,
        idField: "field",
        textField: "title",
        selectAllText: translations["table_multiselect_0"],
        unSelectAllText: translations["table_multiselect_0"],
        itemsShowLimit: 3,
        allowSearchFilter: true,
        searchPlaceholderText: translations["table_multiselect_3"]
      };
    });
  }
  /* advanced search filter functions */
  updateFilterConditions() {
    this.currentSearchConditions = this.searchConditions[this.selectedColumnType] || [];
  }
  getOperatorsForColumn(column) {
    const columnType = this.filteredColumns.find((col) => col.field === column)?.field_type_id;
    return this.searchConditions[columnType] || [];
  }
  getInputTypeForColumn(column) {
    const columnType = this.filteredColumns.find((col) => col.field === column)?.field_type_id;
    return this.inputTypes[columnType] || "text";
  }
  onColumnChange(event, index) {
    const target = event.target;
    const column = target.value;
    this.filterConditions[index].field = column;
    const data = this.filteredColumns.find((col) => col.field === column);
    const columnType = data?.field_type_id;
    this.filterConditions[index].clause_type = data?.clause_type || "where";
    this.filterConditions[index].operator = this.searchConditions[columnType][0].value;
    this.filterConditions[index].value = "";
    this.currentSearchConditions = this.searchConditions[columnType] || [];
  }
  toggleMenu() {
    this.isMenuOpen = !this.isMenuOpen;
    if (this.isMenuOpen && this.filterConditions.length == 0) {
      this.addCondition();
    }
  }
  addCondition() {
    this.filterConditions.push({
      field: "",
      operator: "",
      value: "",
      clause_type: ""
    });
  }
  removeCondition(index) {
    this.filterConditions.splice(index, 1);
  }
  clearFilters() {
    this.filterConditions = [];
    this.applyFilters();
  }
  formatDateTime(dateTime) {
    return this.timezoneService.transformDateTime(dateTime);
  }
  formatDate(dateTime) {
    return this.timezoneService.transformDateOnly(dateTime);
  }
  getConditionValue(index) {
    const value = this.filterConditions[index].value;
    if (value) {
      const type = this.getInputTypeForColumn(this.filterConditions[index].field);
      if (type === "datetime-local") {
        return this.timezoneService.transformDate(value, "yyyy-MM-ddTHH:mm:ss");
      } else if (type === "date") {
        return this.timezoneService.transformDateOnly(value);
      }
    }
    return value;
  }
  setConditionValue(index, value) {
    const type = this.getInputTypeForColumn(this.filterConditions[index].field);
    if (type === "datetime-local" || type === "date") {
      this.filterConditions[index].value = value;
    } else {
      this.filterConditions[index].value = value;
    }
  }
  applyFilters() {
    this.removeEmptyFilters();
    this.isMenuOpen = false;
    const condition = this.filterCondition ? "AND" : "OR";
    const data = this.filterConditions.map((key, index) => {
      const type = this.getInputTypeForColumn(key.field);
      if (type == "datetime-local") {
        const formattedDate = this.formatDateTime(key.value);
        key.value = formattedDate;
      } else if (type == "date") {
        const formattedDate = this.formatDate(key.value);
        key.value = formattedDate;
      }
      return {
        column_name: key.field,
        operator: key.operator ? this.mapConditionToSQL(key.operator) : "=",
        value: this.addWildcards(key.operator, key.value).trim(),
        isAggregate: key?.clause_type === "having"
      };
    });
    const fdata = { data, condition };
    this.advancedSearchQuery.emit(fdata);
  }
  isApplyButtonEnabled() {
    return this.filterConditions.some((condition) => condition.field && condition.operator && condition.value.trim() !== "");
  }
  getPlaceholderForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    switch (columnType) {
      case "number":
        return "Enter a number";
      case "date":
      case "datetime-local":
        return "YYYY-MM-DD";
      default:
        return "Enter a value";
    }
  }
  getMinValueForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    if (columnType === "date" || columnType === "datetime-local") {
      return "1900-01-01";
    }
    return null;
  }
  getMaxValueForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    if (columnType === "date" || columnType === "datetime-local") {
      return "2099-12-31";
    }
    return null;
  }
  getPatternForColumn(column) {
    const columnType = this.getInputTypeForColumn(column);
    switch (columnType) {
      case "email":
        return "[a-z0-9._%+-]+@[a-z0-9.-]+\\.[a-z]{2,}$";
      case "tel":
        return "[0-9]{10}";
      default:
        return void 0;
    }
  }
  getNonEmptyFilterCount() {
    return this.filterConditions.filter((filter) => filter.value.trim() !== "").length;
  }
  removeEmptyFilters() {
    this.filterConditions = this.filterConditions.filter((filter) => filter.value.trim() !== "");
  }
  cancelFilters() {
    this.isMenuOpen = false;
  }
  /* advanced search filter functions */
  capitalizeFirstLetter(string) {
    return string.charAt(0).toUpperCase() + string.slice(1);
  }
  initStore() {
    return __async(this, null, function* () {
      this.storeData.select((d) => d.index).subscribe((d) => {
        this.store = d;
      });
    });
  }
  ngOnChanges(changes) {
    console.log(this.masterInfo);
    if (this.selectcolumns.length > 0) {
      const translationKeys = this.selectcolumns.filter((col) => col.searchable).map((col) => `GRIDS.${this.title}.fields.${col.title}`);
      if (this.masterInfo.fullEntity === "schema_chunks") {
        this.isSchemaChunks = true;
      }
      this.translate.get(translationKeys).subscribe((translations) => {
        this.filteredColumns = this.selectcolumns.filter((col) => col.searchable).map((col) => {
          if (translations[`GRIDS.${this.title}.fields.${col.title}`].includes(".")) {
            return __spreadProps(__spreadValues({
              // colFilterHide: false,
              colSearchHide: false
            }, col), {
              title: this.capitalizeFirstLetter(col.title)
            });
          } else {
            return __spreadProps(__spreadValues({
              //colFilterHide: false,
              colSearchHide: false
            }, col), {
              title: translations[`GRIDS.${this.title}.fields.${col.title}`]
            });
          }
        });
      });
    }
  }
  toggleColumnFilterHide(col) {
    col.colFilterHide = !col.colFilterHide;
  }
  toggleColumnSearchHide(col) {
    col.colSearchHide = !col.colSearchHide;
  }
  // No need for now to
  updateColumn(col) {
    col.hide = !col.hide;
    this.selectedColumns = this.filteredColumns.filter((column) => !column.hide);
  }
  getTranslatedValues(key, label) {
    return this.translate.get(key).pipe(map((translations) => {
      return translations.includes(".") ? label : translations;
    }));
  }
  getTranslatedValueTitle(key, label) {
    return this.translate.get(key).pipe(map((translations) => {
      const title = translations.includes(".") ? label : translations;
      return title.split("Table")[0];
    }));
  }
  selectAll() {
    this.headercolumns.forEach((col) => {
      if (col.header !== "table_column_sno") {
        col.colFilterHide = false;
      }
    });
  }
  // Method to clear all checkboxes
  clearAll() {
    this.headercolumns.forEach((col) => {
      if (col.header !== "table_column_sno") {
        col.colFilterHide = true;
      }
    });
  }
  focusSearchInput() {
    this.searchInput.nativeElement.focus();
  }
  onSearch() {
    this.search = this.search.trim();
    let hereColumns = [...this.filteredColumns];
    let items = [3, 4];
    hereColumns = hereColumns.filter((item) => items.includes(item.field_type_id));
    if (this.selectedColumns.length > 0) {
      const whereData = this.selectedColumns.filter((key, index) => {
        return key.clause_type === "where";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const havingData = hereColumns.filter((key, index) => {
        return key.clause_type === "having";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const fdata = { where: { data: whereData, search: this.search }, having: { data: havingData, search: this.search } };
      this.searchQuery.emit(fdata);
    } else {
      const whereData = hereColumns.filter((key, index) => {
        return key.clause_type === "where";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const havingData = hereColumns.filter((key, index) => {
        return key.clause_type === "having";
      }).map((key, index) => {
        return {
          column_name: key.field,
          operator: this.searchCondition ? this.mapConditionToSQL(this.searchCondition) : "=",
          value: this.addWildcards(this.searchCondition, this.search)
        };
      });
      const fdata = { where: { data: whereData, search: this.search }, having: { data: havingData, search: this.search } };
      this.searchQuery.emit(fdata);
    }
  }
  applyFilter() {
    if (this.selectedColumn && this.search) {
      this.filteredItems = this.items.filter((item) => item[this.selectedColumn]?.toString().toLowerCase().includes(this.search.toLowerCase()));
    } else {
      this.filteredItems = [...this.items];
    }
    this.totalItems = this.filteredItems.length;
    this.calculateTotalPages();
  }
  toggleSelectItem(item) {
    const index = this.selectedItems.indexOf(item);
    if (index === -1) {
      this.selectedItems.push(item);
    } else {
      this.selectedItems.splice(index, 1);
    }
  }
  toggleSelectAll(event) {
    if (event.target.checked) {
      this.selectedItems = [...this.items];
    } else {
      this.selectedItems = [];
    }
  }
  get gridColumnCount() {
    return this.headercolumns.filter((column) => column.is_grid_column == "true").length;
  }
  sortColumn(column) {
    if (column.is_grid_column == "true" && column.is_sortable == "true") {
      this.headercolumns.forEach((col) => {
        if (col !== column) {
          col.sortDirection = "";
        }
      });
      column.sortDirection = column.sortDirection === "asc" ? "desc" : "asc";
      this.columnSort.emit(column);
    }
  }
  deleteSelectedItems() {
    this.delete.emit(this.selectedItems);
    this.selectedItems = [];
  }
  exportTable(type) {
    this.exportType.emit({ type });
  }
  previousPage() {
    if (this.currentPage > 1) {
      this.currentPage--;
      const start_index = (this.currentPage - 1) * this.resultsPerPage;
      this.pageChange.emit({ page: this.currentPage, start_index });
    }
  }
  nextPage() {
    if (this.currentPage < this.totalPages) {
      this.currentPage++;
      const start_index = (this.currentPage - 1) * this.resultsPerPage;
      this.pageChange.emit({ page: this.currentPage, start_index });
    }
  }
  getDisplayedItemCount() {
    return Math.min(this.currentPage * this.resultsPerPage, this.totalItems);
  }
  getPageNumbers() {
    const totalPages = this.calculateTotalPages();
    const currentPage = this.currentPage;
    const pageNumbers = [];
    if (totalPages <= 7) {
      for (let i = 1; i <= totalPages; i++) {
        pageNumbers.push(i);
      }
    } else {
      pageNumbers.push(1);
      if (currentPage > 3) {
        pageNumbers.push("...");
      }
      const start = Math.max(2, currentPage - 1);
      const end = Math.min(totalPages - 1, currentPage + 1);
      for (let i = start; i <= end; i++) {
        pageNumbers.push(i);
      }
      if (currentPage < totalPages - 2) {
        pageNumbers.push("...");
      }
      pageNumbers.push(totalPages);
    }
    return pageNumbers;
  }
  handleEllipsisClick(index) {
    const pageNumbers = this.getPageNumbers();
    if (index === 1) {
      this.goToPage(Math.floor((1 + this.currentPage) / 2));
    } else if (index === pageNumbers.length - 2) {
      this.goToPage(Math.floor((this.totalPages + this.currentPage) / 2));
    }
  }
  goToPage(page) {
    if (this.items.length > 0 && typeof page === "number" && page !== this.currentPage) {
      this.currentPage = page;
      const start_index = (page - 1) * this.resultsPerPage;
      this.pageChange.emit({ page: this.currentPage, start_index });
    }
  }
  onResultsPerPageChange() {
    this.currentPage = 1;
    this.calculateTotalPages();
    const start_index = 0;
    this.resultsPerPageChange.emit({ resultsPerPage: parseInt(this.resultsPerPage), start_index });
  }
  searchData(search) {
    this.searchQuery.emit(search);
  }
  calculateTotalPages() {
    this.totalPages = Math.ceil(this.totalItems / this.resultsPerPage);
    return this.totalPages;
  }
  syncTableSchema() {
    this.loading = true;
    this.openaiService.syncTableSchema().subscribe((res) => {
      this.loading = false;
      if (res.status) {
        this.toastr.success("Table schema synced successfully", "Success");
        this.setPageReload();
      } else {
        this.toastr.error("Failed to sync table schema", "Error");
      }
    });
  }
  generateVectorForAllTable() {
    this.toastr.info("Syncing table schema..., it may take few minutes", "Info");
    this.loading = true;
    this.openaiService.generateVectorForAllTable().subscribe((res) => {
      this.loading = false;
      if (res.status) {
        this.toastr.success("Table schema synced successfully", "Success");
        this.setPageReload();
      } else {
        this.toastr.error("Failed to sync table schema", "Error");
      }
    });
  }
  setPageReload() {
    setTimeout(() => {
      window.location.reload();
    }, 1e3);
  }
  onLinkComponentClick(col, item) {
    this.linkComponentClick.emit({ col, item });
  }
  toggleColumnChildGrid(uuid, col) {
    if (this.expandedColumnChildGrid && this.expandedColumnChildGrid.uuid === uuid && this.expandedColumnChildGrid.colHeader === col.header) {
      this.expandedColumnChildGrid = null;
    } else {
      this.expandedColumnChildGrid = { uuid, colHeader: col.header };
    }
  }
  isColumnChildGridExpanded(uuid, col) {
    return !!this.expandedColumnChildGrid && this.expandedColumnChildGrid.uuid === uuid && this.expandedColumnChildGrid.colHeader === col.header;
  }
};
_DataTableComponent.\u0275fac = function DataTableComponent_Factory(t) {
  return new (t || _DataTableComponent)(\u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(Store), \u0275\u0275directiveInject(DatePipe), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(OpenaiService), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(TimezoneService));
};
_DataTableComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _DataTableComponent, selectors: [["app-datatable"]], viewQuery: function DataTableComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c03, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.searchInput = _t.first);
  }
}, inputs: { unique_id: "unique_id", loading: "loading", customTemplates: "customTemplates", title: "title", enableCheckBox: "enableCheckBox", masterInfo: "masterInfo", selectcolumns: "selectcolumns", headercolumns: "headercolumns", items: "items", totalItems: "totalItems", currentPage: "currentPage", resultsPerPage: "resultsPerPage", column: "column", query: "query" }, outputs: { delete: "delete", edit: "edit", view: "view", customAction: "customAction", pageChange: "pageChange", exportType: "exportType", resultsPerPageChange: "resultsPerPageChange", columnSort: "columnSort", searchQuery: "searchQuery", advancedSearchQuery: "advancedSearchQuery", linkComponentClick: "linkComponentClick" }, standalone: true, features: [\u0275\u0275NgOnChangesFeature, \u0275\u0275StandaloneFeature], decls: 94, vars: 54, consts: [["searchInput", ""], ["filterList", ""], ["noRecords", ""], ["notComponent", ""], ["defaultCell", ""], ["externalUrl", ""], [1, "panel"], [1, "mb-2.5"], [1, "header-panel", "mb-1", "mt-0", "flex", "flex-col", "gap-5", "px-2", "md:flex-row", "md:items-center"], ["appDynamicFontSize", "title", 1, "font-bold", "dark:text-white-light"], [1, "flex", "items-center", "gap-4", "md:flex-row", "md:items-center", "md:ltr:ml-auto", "md:rtl:mr-auto"], [1, "flex", "flex-col", "gap-2", "md:flex-row", "md:items-center"], [1, "relative", "mb-2", "flex-grow", "md:mb-0"], ["type", "text", "appDynamicFontSize", "body", 1, "form-input", "w-full", "pr-10", "text-gray-600", 3, "ngModelChange", "input", "ngModel", "placeholder"], ["href", "javascript:void(0);", 1, "search-btn", "absolute", "inset-y-0", "right-0", "flex", "items-center", "border-none", 3, "click"], [1, "fa-solid", "fa-magnifying-glass"], [1, "align-center", "align-items-center", "relative", "inline-flex", "justify-center"], ["aria-expanded", "true", "aria-haspopup", "true", "id", "options-menu", "type", "button", 1, "filter-button", "mr-2", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click"], [1, "fa-solid", "fa-filter"], [1, "hidden", "md:inline"], ["class", "badge absolute -top-3 rounded-full bg-danger p-0.5 px-1.5", 4, "ngIf"], ["aria-labelledby", "options-menu", "aria-orientation", "vertical", "class", "advancedfiltercontainer rigin-top-left absolute z-10 mt-2 divide-y divide-gray-100 rounded-md bg-white shadow-lg ring-1 ring-black ring-opacity-5", "role", "menu", 4, "ngIf"], ["hlMenu", "", 1, "dropdown", "mb-2", "md:mb-0"], ["hlMenuButton", "", "type", "button", "appDynamicFontSize", "body", 1, "mr-2", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark"], [1, "fa-solid", "fa-table-columns"], [1, "ltr:mr-1", "rtl:ml-1"], ["class", "w-max ltr:left-0 rtl:right-0", 4, "hlMenuItems"], ["class", "flex", 4, "ngIf"], [1, "flex", "flex-wrap", "items-center", "gap-2"], ["type", "button", "class", "btn-primary flex items-center rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold dark:border-[#253b5c] dark:bg-[#1b2e4b] dark:text-white-dark", 3, "ngxTippy", "click", 4, "ngIf"], ["type", "button", "class", "btn-danger rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold ltr:rounded-r rtl:rounded-l", 3, "click", 4, "ngIf"], [1, "datatable"], [1, "table-responsive", "overflow-x-auto"], [1, "table-hover", "relative", "min-w-full"], [1, "bg-gray-50"], ["class", "text-left uppercase tracking-wider", "appDynamicFontSize", "body", 4, "ngIf"], [4, "ngFor", "ngForOf"], [1, "divide-y", "divide-gray-200"], [4, "ngIf"], [1, "pagination", "flex", "items-center", "justify-between", "border-t", "border-gray-200", "py-1", "text-xs", "sm:mb-0"], [1, "flex", "items-center"], [1, "mr-4"], ["id", "results-per-page", "appDynamicFontSize", "body", 1, "py-1.5", "text-xs", 3, "ngModelChange", "ngModel"], [3, "value", 4, "ngFor", "ngForOf"], ["appDynamicFontSize", "body", 1, "py-1", "text-xs", "text-gray-700"], [1, "font-medium"], ["aria-label", "Pagination", "appDynamicFontSize", "body", 1, "isolate", "inline-flex", "-space-x-px", "rounded-md", "py-1.5", "text-xs", "shadow-sm"], [1, "relative", "inline-flex", "items-center", "rounded-l-md", "px-2", "py-1", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], [1, "sr-only"], ["viewBox", "0 0 20 20", "fill", "currentColor", "aria-hidden", "true", 1, "h-5", "w-5"], ["fill-rule", "evenodd", "d", "M15.79 14.77a.75.75 0 01-1.06.02l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 111.04 1.08L11.832 10l3.938 3.71a.75.75 0 01.02 1.06zm-6 0a.75.75 0 01-1.06.02l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 111.04 1.08L5.832 10l3.938 3.71a.75.75 0 01.02 1.06z", "clip-rule", "evenodd"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], ["fill-rule", "evenodd", "d", "M12.79 5.23a.75.75 0 01-.02 1.06L8.832 10l3.938 3.71a.75.75 0 11-1.04 1.08l-4.5-4.25a.75.75 0 010-1.08l4.5-4.25a.75.75 0 011.06.02z", "clip-rule", "evenodd"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1.5", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], ["fill-rule", "evenodd", "d", "M7.21 14.77a.75.75 0 01.02-1.06L11.168 10 7.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z", "clip-rule", "evenodd"], [1, "relative", "inline-flex", "items-center", "rounded-r-md", "px-2", "py-1.5", "text-xs", "text-gray-400", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "disabled"], ["fill-rule", "evenodd", "d", "M4.21 14.77a.75.75 0 01.02-1.06L8.168 10 4.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02zm6 0a.75.75 0 01.02-1.06L14.168 10 10.23 6.29a.75.75 0 111.04-1.08l4.5 4.25a.75.75 0 010 1.08l-4.5 4.25a.75.75 0 01-1.06-.02z", "clip-rule", "evenodd"], [1, "badge", "absolute", "-top-3", "rounded-full", "bg-danger", "p-0.5", "px-1.5"], ["aria-labelledby", "options-menu", "aria-orientation", "vertical", "role", "menu", 1, "advancedfiltercontainer", "rigin-top-left", "absolute", "z-10", "mt-2", "divide-y", "divide-gray-100", "rounded-md", "bg-white", "shadow-lg", "ring-1", "ring-black", "ring-opacity-5"], [1, "flex", "items-center", "justify-between", "border-b", "border-gray-200", "p-4"], [1, "flex", "items-center", "gap-4"], ["ngxTippy", "Add Filter", 1, "text-blue-500", 3, "click"], [1, "fa-solid", "fa-plus"], [1, "relative", "h-6", "w-12"], ["type", "checkbox", "id", "custom_switch_checkbox", 1, "custom_switch", "peer", "absolute", "z-10", "h-full", "w-full", "cursor-pointer", "opacity-0", 3, "ngModelChange", "ngModel"], ["for", "custom_switch_checkbox", 1, "block", "h-full", "rounded-full", "bg-[#ebedf2]", "before:absolute", "before:bottom-1", "before:left-1", "before:h-4", "before:w-4", "before:rounded-full", "before:bg-white", "before:transition-all", "before:duration-300", "peer-checked:bg-primary", "peer-checked:before:left-7"], ["appearance", "compact", 1, "relative", "!h-[calc(40vh-40px)]"], [1, "space-y-2", "p-4"], [4, "ngIf", "ngIfElse"], [1, "flex", "items-center", "justify-between", "border-t", "border-gray-200", "p-4"], [1, "text-red-500", 3, "click"], [1, "flex", "gap-4"], [1, "btn", "btn-primary", 3, "click", "disabled"], [1, "btn", "btn-secondary", 3, "click"], [1, "text-gray-600"], ["class", "flex items-center gap-2", 4, "ngFor", "ngForOf"], [1, "flex", "items-center", "gap-2"], ["class", "fa-solid fa-diamond shrink-0 text-warning", 4, "ngIf"], ["class", "fa-solid fa-diamond shrink-0 text-info", 4, "ngIf"], [1, "form-select", "w-full", 3, "change", "ngModelChange", "ngModel"], ["value", "", "selected", "", "disabled", ""], [1, "form-select", "w-full", 3, "ngModelChange", "ngModel"], [1, "form-input", "w-full", "pr-10", "text-gray-600", 3, "ngModelChange", "ngModel", "type", "placeholder", "required"], [1, "fa-solid", "fa-xmark", "text-xl"], [1, "fa-solid", "fa-diamond", "shrink-0", "text-warning"], [1, "fa-solid", "fa-diamond", "shrink-0", "text-info"], [3, "value"], [1, "w-max", "ltr:left-0", "rtl:right-0"], [1, "flex", "items-center", "border-b", "border-gray-200", "px-4", "py-1"], [1, "mr-2", "px-2", "py-1", "text-blue-500", 3, "click"], [1, "px-2", "py-1", "text-red-500", 3, "click"], [1, "flex", "items-center", "px-4", "py-1"], [1, "mb-0", "cursor-pointer", 3, "for"], ["type", "checkbox", 1, "form-checkbox", 3, "ngModelChange", "id", "ngModel"], ["appDynamicFontSize", "body", 1, "uppercase", "ltr:ml-2", "rtl:mr-2"], [1, "flex"], ["type", "button", "hlMenuButton", "", 1, "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark"], [1, "fa-solid", "fa-download"], ["class", "whitespace-nowrap ltr:right-0 rtl:left-0", 4, "hlMenuItems"], [1, "whitespace-nowrap", "ltr:right-0", "rtl:left-0"], ["href", "javascript:;", 3, "click", 4, "hlMenuItem"], ["href", "javascript:;", 3, "click"], [1, "fa-solid", "fa-file-excel", "ltr:mr-2", "rtl:ml-2"], ["type", "button", 1, "btn", "btn-primary", "mr-2", "h-32", "text-xs", 3, "click"], ["type", "button", 1, "btn", "btn-primary", "h-32", "text-xs", 3, "click"], ["type", "button", 1, "btn-primary", "flex", "items-center", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "dark:border-[#253b5c]", "dark:bg-[#1b2e4b]", "dark:text-white-dark", 3, "click", "ngxTippy"], ["type", "button", 1, "btn-danger", "rounded-md", "border", "border-[#e0e6ed]", "px-4", "py-2", "font-semibold", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], ["appDynamicFontSize", "body", 1, "text-left", "uppercase", "tracking-wider"], ["type", "checkbox", 3, "change"], ["scope", "col", "class", "max-w-140 cursor-pointer truncate whitespace-nowrap px-4 py-2 text-left tracking-wider", "appDynamicFontSize", "body", "ngxTippy", "", 3, "ngClass", "click", 4, "ngIf"], ["scope", "col", "appDynamicFontSize", "body", "ngxTippy", "", 1, "max-w-140", "cursor-pointer", "truncate", "whitespace-nowrap", "px-4", "py-2", "text-left", "tracking-wider", 3, "click", "ngClass"], ["class", "arrow-icon bh-ml-3 bh-sort bh-flex bh-items-center id asc ng-star-inserted", 4, "ngIf"], [1, "arrow-icon", "bh-ml-3", "bh-sort", "bh-flex", "bh-items-center", "id", "asc", "ng-star-inserted"], ["width", "16", "height", "16", "viewBox", "0 0 14 14", "fill", "none"], ["points", "3.11,6.25 10.89,6.25 7,1.75", "fill", "currentColor", 1, "bh-text-black", 3, "ngClass"], ["points", "7,12.25 10.89,7.75 3.11,7.75", "fill", "currentColor", 1, "bh-text-black", 3, "ngClass"], ["appDynamicFontSize", "body", 1, "py-4", "text-center", "text-gray-500"], [1, "dots-container"], [1, "dot"], [3, "click", 4, "ngIf"], [3, "click"], [1, "expand-collapse-btn"], [1, "fa", 3, "ngClass"], ["type", "checkbox", 3, "change", "checked"], ["class", "max-w-150 truncate whitespace-nowrap", 3, "ngClass", 4, "ngIf"], [1, "max-w-150", "truncate", "whitespace-nowrap", 3, "ngClass"], [1, "block", "truncate", "text-blue-600", "cursor-pointer", "underline", 3, "click"], ["class", "block truncate text-blue-600 underline", 3, "routerLink", 4, "ngIf", "ngIfElse"], [1, "block", "truncate", "text-blue-600", "underline", 3, "routerLink"], ["target", "_blank", 1, "block", "truncate", "text-blue-600", "underline", 3, "href"], ["class", "block truncate", "ngxTippy", "", 3, "ngClass", 4, "ngIf"], ["class", "block truncate", 4, "ngIf"], ["ngxTippy", "", 1, "block", "truncate", 3, "ngClass"], ["class", "expand-collapse-btn ml-1", "style", "background: none; border: none; padding: 0; margin-left: 6px; cursor: pointer;", 3, "click", 4, "ngIf"], [1, "expand-collapse-btn", "ml-1", 2, "background", "none", "border", "none", "padding", "0", "margin-left", "6px", "cursor", "pointer", 3, "click"], [1, "block", "truncate"], [4, "ngTemplateOutlet", "ngTemplateOutletContext"], [1, "p-0"], [1, "bg-gray-50", "p-4"], [3, "uuid", "entity_name"], [3, "ngSwitch"], ["class", "relative inline-flex items-center px-2 py-1.5 text-xs font-semibold ring-1 ring-inset ring-gray-300 hover:bg-gray-50 focus:z-20 focus:outline-offset-0", 3, "click", 4, "ngSwitchCase"], ["class", "relative inline-flex items-center px-2 py-1.5 text-xs font-semibold ring-1 ring-inset ring-gray-300 hover:bg-gray-50 focus:z-20 focus:outline-offset-0", 3, "ngClass", "click", 4, "ngSwitchDefault"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1.5", "text-xs", "font-semibold", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click"], [1, "relative", "inline-flex", "items-center", "px-2", "py-1.5", "text-xs", "font-semibold", "ring-1", "ring-inset", "ring-gray-300", "hover:bg-gray-50", "focus:z-20", "focus:outline-offset-0", 3, "click", "ngClass"]], template: function DataTableComponent_Template(rf, ctx) {
  if (rf & 1) {
    const _r1 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 6)(1, "div", 7)(2, "div", 8)(3, "div", 9);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 10)(7, "div", 11)(8, "div", 12)(9, "input", 13, 0);
    \u0275\u0275pipe(11, "translate");
    \u0275\u0275twoWayListener("ngModelChange", function DataTableComponent_Template_input_ngModelChange_9_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.search, $event) || (ctx.search = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("input", function DataTableComponent_Template_input_input_9_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onSearch());
    });
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(12, "a", 14);
    \u0275\u0275listener("click", function DataTableComponent_Template_a_click_12_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onSearch());
    })("click", function DataTableComponent_Template_a_click_12_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.focusSearchInput());
    });
    \u0275\u0275element(13, "i", 15);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(14, "div", 16)(15, "button", 17);
    \u0275\u0275listener("click", function DataTableComponent_Template_button_click_15_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.toggleMenu());
    });
    \u0275\u0275element(16, "i", 18);
    \u0275\u0275text(17, "\xA0");
    \u0275\u0275elementStart(18, "span", 19);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275template(21, DataTableComponent_span_21_Template, 2, 1, "span", 20);
    \u0275\u0275elementEnd();
    \u0275\u0275template(22, DataTableComponent_div_22_Template, 30, 17, "div", 21);
    \u0275\u0275elementStart(23, "div", 22)(24, "button", 23);
    \u0275\u0275element(25, "i", 24);
    \u0275\u0275text(26, "\xA0 ");
    \u0275\u0275elementStart(27, "span", 25);
    \u0275\u0275text(28);
    \u0275\u0275pipe(29, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275template(30, DataTableComponent_ul_30_Template, 10, 8, "ul", 26);
    \u0275\u0275elementEnd();
    \u0275\u0275template(31, DataTableComponent_div_31_Template, 9, 3, "div", 27)(32, DataTableComponent_Conditional_32_Template, 6, 6);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(33, "div", 28);
    \u0275\u0275template(34, DataTableComponent_button_34_Template, 5, 7, "button", 29);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(35, "div", 28);
    \u0275\u0275template(36, DataTableComponent_button_36_Template, 5, 7, "button", 29);
    \u0275\u0275elementEnd();
    \u0275\u0275template(37, DataTableComponent_button_37_Template, 3, 3, "button", 30);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(38, "div", 31)(39, "div", 32)(40, "table", 33)(41, "thead", 34)(42, "tr");
    \u0275\u0275template(43, DataTableComponent_th_43_Template, 1, 0, "th", 35)(44, DataTableComponent_th_44_Template, 2, 0, "th", 35)(45, DataTableComponent_ng_container_45_Template, 2, 1, "ng-container", 36);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(46, "tbody", 37);
    \u0275\u0275template(47, DataTableComponent_tr_47_Template, 8, 1, "tr", 38)(48, DataTableComponent_ng_container_48_Template, 4, 2, "ng-container", 38);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(49, "div", 39)(50, "div", 40)(51, "div", 41)(52, "select", 42);
    \u0275\u0275twoWayListener("ngModelChange", function DataTableComponent_Template_select_ngModelChange_52_listener($event) {
      \u0275\u0275restoreView(_r1);
      \u0275\u0275twoWayBindingSet(ctx.resultsPerPage, $event) || (ctx.resultsPerPage = $event);
      return \u0275\u0275resetView($event);
    });
    \u0275\u0275listener("ngModelChange", function DataTableComponent_Template_select_ngModelChange_52_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.onResultsPerPageChange());
    });
    \u0275\u0275template(53, DataTableComponent_option_53_Template, 2, 2, "option", 43);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(54, "div")(55, "p", 44)(56, "span", 45);
    \u0275\u0275text(57);
    \u0275\u0275elementEnd();
    \u0275\u0275text(58, " - ");
    \u0275\u0275elementStart(59, "span", 45);
    \u0275\u0275text(60);
    \u0275\u0275elementEnd();
    \u0275\u0275text(61);
    \u0275\u0275pipe(62, "translate");
    \u0275\u0275elementStart(63, "span", 45);
    \u0275\u0275text(64);
    \u0275\u0275elementEnd();
    \u0275\u0275text(65);
    \u0275\u0275pipe(66, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(67, "div")(68, "nav", 46)(69, "button", 47);
    \u0275\u0275listener("click", function DataTableComponent_Template_button_click_69_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goToPage(1));
    });
    \u0275\u0275elementStart(70, "span", 48);
    \u0275\u0275text(71);
    \u0275\u0275pipe(72, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(73, "svg", 49);
    \u0275\u0275element(74, "path", 50);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(75, "button", 51);
    \u0275\u0275listener("click", function DataTableComponent_Template_button_click_75_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.previousPage());
    });
    \u0275\u0275elementStart(76, "span", 48);
    \u0275\u0275text(77);
    \u0275\u0275pipe(78, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(79, "svg", 49);
    \u0275\u0275element(80, "path", 52);
    \u0275\u0275elementEnd()();
    \u0275\u0275template(81, DataTableComponent_ng_container_81_Template, 4, 2, "ng-container", 36);
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(82, "button", 53);
    \u0275\u0275listener("click", function DataTableComponent_Template_button_click_82_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.nextPage());
    });
    \u0275\u0275elementStart(83, "span", 48);
    \u0275\u0275text(84);
    \u0275\u0275pipe(85, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(86, "svg", 49);
    \u0275\u0275element(87, "path", 54);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(88, "button", 55);
    \u0275\u0275listener("click", function DataTableComponent_Template_button_click_88_listener() {
      \u0275\u0275restoreView(_r1);
      return \u0275\u0275resetView(ctx.goToPage(ctx.totalPages));
    });
    \u0275\u0275elementStart(89, "span", 48);
    \u0275\u0275text(90);
    \u0275\u0275pipe(91, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(92, "svg", 49);
    \u0275\u0275element(93, "path", 56);
    \u0275\u0275elementEnd()()()()()()()();
  }
  if (rf & 2) {
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(5, 34, ctx.title), " ");
    \u0275\u0275advance(5);
    \u0275\u0275propertyInterpolate1("placeholder", "", \u0275\u0275pipeBind1(11, 36, "table_search_placeholder"), "...");
    \u0275\u0275twoWayProperty("ngModel", ctx.search);
    \u0275\u0275advance(10);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(20, 38, "table_filter"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.getNonEmptyFilterCount() > 0);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isMenuOpen);
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(29, 40, "table_multiselect_1"));
    \u0275\u0275advance(3);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.export_excel);
    \u0275\u0275advance();
    \u0275\u0275conditional(32, ctx.isSchemaChunks ? 32 : -1);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.create);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.popup_create);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.unique_id && true);
    \u0275\u0275advance(6);
    \u0275\u0275property("ngIf", ctx.masterInfo == null ? null : ctx.masterInfo.permissions.child_details);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.enableCheckBox);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx.headercolumns);
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.loading);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx.loading);
    \u0275\u0275advance(4);
    \u0275\u0275twoWayProperty("ngModel", ctx.resultsPerPage);
    \u0275\u0275advance();
    \u0275\u0275property("ngForOf", ctx.paginationOptions);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate((ctx.currentPage - 1) * ctx.resultsPerPage + 1);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.getDisplayedItemCount());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(62, 42, "table_results_0"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(ctx.totalItems);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(66, 44, "table_results_1"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", ctx.currentPage === 1);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(72, 46, "first"));
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", ctx.currentPage === 1);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(78, 48, "previous"));
    \u0275\u0275advance(4);
    \u0275\u0275property("ngForOf", ctx.getPageNumbers());
    \u0275\u0275advance();
    \u0275\u0275property("disabled", ctx.currentPage === ctx.totalPages);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(85, 50, "next"));
    \u0275\u0275advance(4);
    \u0275\u0275property("disabled", ctx.currentPage === ctx.totalPages);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(91, 52, "last"));
  }
}, dependencies: [CommonSharedModule, NgClass, NgForOf, NgIf, NgTemplateOutlet, NgSwitch, NgSwitchCase, NgSwitchDefault, NgScrollbar, NgSelectOption, \u0275NgSelectMultipleOption, DefaultValueAccessor, CheckboxControlValueAccessor, SelectControlValueAccessor, NgControlStatus, RequiredValidator, NgModel, RouterLink, MenuDirective, MenuButtonDirective, MenuItemsPanelDirective, MenuItemDirective, NgxTippyDirective, DynamicFontSizeDirective, TranslatePipe, NgMultiSelectDropDownModule, BooleanStatusPipe, ChildDatatableComponent], styles: ["\n\n.arrow-icon[_ngcontent-%COMP%] {\n  display: inline-block;\n  vertical-align: middle;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common[_ngcontent-%COMP%] {\n  transform: rotate(90deg);\n  fill: grey;\n  vertical-align: middle;\n  margin: 0;\n  padding: 0;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common.active[_ngcontent-%COMP%] {\n  fill: black;\n  color: black;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common[_ngcontent-%COMP%]:first-child {\n  margin-bottom: -3px;\n}\n.arrow-icon[_ngcontent-%COMP%]   .common[_ngcontent-%COMP%]:last-child {\n  margin-top: -1px;\n}\n.h-32[_ngcontent-%COMP%] {\n  height: 32px;\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n  border-radius: 0.375rem;\n  border-width: 1px;\n  --tw-border-opacity: 1;\n  border-color: rgb(224 230 237 / var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(255 255 255 / var(--tw-bg-opacity));\n  padding-top: 0.375rem;\n  padding-bottom: 0.375rem;\n  padding-left: 0.5rem;\n  padding-right: 1rem;\n  font-weight: 600;\n  --tw-text-opacity: 1;\n  color: rgb(14 23 38 / var(--tw-text-opacity));\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus {\n  --tw-border-opacity: 1;\n  border-color: rgb(67 97 238 / var(--tw-border-opacity));\n  --tw-ring-color: transparent;\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60 / var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50 / var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168 / var(--tw-text-opacity));\n}\n.pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%]:focus:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(67 97 238 / var(--tw-border-opacity));\n}\n@media (max-width: 768px) {\n  .form-select[_ngcontent-%COMP%] {\n    width: 100%;\n  }\n  .flex-wrap[_ngcontent-%COMP%] {\n    justify-content: space-between;\n  }\n  .pagination[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: center;\n  }\n  .pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    margin-bottom: 1rem;\n  }\n  .datatable[_ngcontent-%COMP%]   .table-responsive[_ngcontent-%COMP%] {\n    overflow-x: auto;\n  }\n  .datatable[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], .datatable[_ngcontent-%COMP%]   td[_ngcontent-%COMP%] {\n    white-space: nowrap;\n  }\n  .datatable[_ngcontent-%COMP%]   th[_ngcontent-%COMP%]   .arrow-icon[_ngcontent-%COMP%] {\n    display: inline-block;\n    vertical-align: middle;\n    margin-left: 0.5rem;\n  }\n}\n.panel[_ngcontent-%COMP%] {\n  margin: -15px;\n  padding: 1.25rem 1.25rem 0.25rem 1.25rem;\n}\n.multiple-select[_ngcontent-%COMP%] {\n  width: 100%;\n  --tw-border-opacity: 1;\n  border-color: rgb(224 230 237/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(255 255 255/var(--tw-bg-opacity));\n  padding-left: 1rem;\n  padding-right: 1rem;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n  font-size: 0.875rem;\n  line-height: 1.25rem;\n  font-weight: 600;\n  --tw-text-opacity: 1;\n  color: rgb(14 23 38/var(--tw-text-opacity));\n  outline: 2px solid transparent !important;\n  outline-offset: 2px !important;\n}\n.multiple-select[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50/var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n.dropdown-list[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50/var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n.filter-textbox[_ngcontent-%COMP%]   input[_ngcontent-%COMP%]   [_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  --tw-border-opacity: 1;\n  border-color: rgb(23 38 60/var(--tw-border-opacity));\n  --tw-bg-opacity: 1;\n  background-color: rgb(18 30 50/var(--tw-bg-opacity));\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n.header-panel[_ngcontent-%COMP%] {\n  margin-top: -15px;\n}\n.panel[_ngcontent-%COMP%] {\n  padding: 1.25rem 1.25rem 0.25rem 1.25rem;\n}\n.bh-text-black[_ngcontent-%COMP%] {\n  color: rgba(14, 23, 38, 0.2);\n}\n.bh-text-primary[_ngcontent-%COMP%] {\n  --tw-text-opacity: 1 !important;\n  color: rgb(67, 97, 238) !important;\n}\n.datatable[_ngcontent-%COMP%]   .table-responsive[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   tfoot[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   th[_ngcontent-%COMP%], .datatable[_ngcontent-%COMP%]   .table-responsive[_ngcontent-%COMP%]   table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   tr[_ngcontent-%COMP%]   th[_ngcontent-%COMP%] {\n  vertical-align: top;\n  font-weight: 700;\n}\n.form-select[_ngcontent-%COMP%] {\n  width: auto;\n  min-width: 120px;\n}\n[_ngcontent-%COMP%]:is(.dark   table[_ngcontent-%COMP%]   thead[_ngcontent-%COMP%]   tr)[_ngcontent-%COMP%], [_ngcontent-%COMP%]:is(.dark   table[_ngcontent-%COMP%]   tfoot[_ngcontent-%COMP%]   tr)[_ngcontent-%COMP%] {\n  --tw-bg-opacity: 1 !important;\n  background-color: rgb(26, 41, 65) !important;\n}\n[_ngcontent-%COMP%]:is(.dark   .datatable)[_ngcontent-%COMP%] {\n  --tw-text-opacity: 1;\n  color: rgb(136 142 168/var(--tw-text-opacity));\n}\n[_ngcontent-%COMP%]:is(.dark   .datatable[_ngcontent-%COMP%]   .bh-sort[_ngcontent-%COMP%]   svg[_ngcontent-%COMP%]   polygon)[_ngcontent-%COMP%] {\n  --tw-text-opacity: 1;\n  color: rgb(59 63 92/var(--tw-text-opacity));\n}\n.sticky[_ngcontent-%COMP%] {\n  position: sticky;\n  background-clip: padding-box;\n}\nthead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%] {\n  background: #e5e7eb;\n}\ntbody[_ngcontent-%COMP%]   td.sticky[_ngcontent-%COMP%] {\n  background-color: #fff;\n}\nthead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  background-color: rgb(21, 33, 53) !important;\n}\ntbody[_ngcontent-%COMP%]   td.sticky[_ngcontent-%COMP%]:is(.dark   *)[_ngcontent-%COMP%] {\n  background-color: rgb(14 23 38/var(--tw-bg-opacity));\n}\n.sticky.right-0[_ngcontent-%COMP%] {\n  right: 0;\n}\n[_ngcontent-%COMP%]:is(.dark)   th[_ngcontent-%COMP%], [_ngcontent-%COMP%]:is(.dark)   td[_ngcontent-%COMP%] {\n  border-color: #374151;\n}\n[_ngcontent-%COMP%]:is(.dark)   thead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%] {\n  box-shadow: inset 1px 0 0 #374151;\n}\n[_ngcontent-%COMP%]:is(.dark)   tbody[_ngcontent-%COMP%]   td.sticky[_ngcontent-%COMP%] {\n  box-shadow: inset 1px 0 0 #374151;\n  background-color: #1f2937;\n}\n[_ngcontent-%COMP%]:is(.dark)   thead[_ngcontent-%COMP%]   th.sticky[_ngcontent-%COMP%] {\n  background-color: #1f2937;\n}\n.truncate[_ngcontent-%COMP%] {\n  overflow: hidden;\n  text-overflow: ellipsis;\n  white-space: nowrap;\n}\n.max-w-150[_ngcontent-%COMP%] {\n  max-width: 150px;\n}\n@media (max-width: 640px) {\n  .header-panel[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: stretch;\n  }\n  .flex-wrap[_ngcontent-%COMP%] {\n    flex-direction: column;\n  }\n  .form-select[_ngcontent-%COMP%], .form-input[_ngcontent-%COMP%], .btn[_ngcontent-%COMP%] {\n    margin-bottom: 0.5rem;\n  }\n  .relative.flex-grow[_ngcontent-%COMP%] {\n    width: 100%;\n  }\n  .flex.items-center.gap-4[_ngcontent-%COMP%] {\n    flex-direction: column;\n    align-items: stretch;\n  }\n}\n.search-btn[_ngcontent-%COMP%] {\n  padding-left: 1.25rem;\n  padding-right: 1.25rem;\n  padding-top: 0.5rem;\n  padding-bottom: 0.5rem;\n}\n.dropdown[_ngcontent-%COMP%]   ul[_ngcontent-%COMP%] {\n  z-index: 1000;\n}\n.advancedfiltercontainer[_ngcontent-%COMP%] {\n  min-width: 300px;\n  max-width: 100%;\n  width: 90%;\n  left: 50%;\n  transform: translateX(-50%);\n  right: auto;\n  z-index: 1000;\n  position: fixed;\n  top: 10%;\n  max-height: 60vh;\n  overflow-y: auto;\n}\n@media (min-width: 640px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%] {\n    min-width: 500px;\n    width: 60%;\n  }\n}\n@media (min-width: 1024px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%] {\n    max-width: 600px;\n    width: 70%;\n  }\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .relative[_ngcontent-%COMP%] {\n  max-height: calc(80vh - 120px);\n  overflow-y: auto;\n}\n@media (max-width: 640px) {\n  .advancedfiltercontainer[_ngcontent-%COMP%]   input[_ngcontent-%COMP%], .advancedfiltercontainer[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    width: 100%;\n    margin-bottom: 0.5rem;\n  }\n  .advancedfiltercontainer[_ngcontent-%COMP%]   .flex[_ngcontent-%COMP%] {\n    flex-direction: column;\n  }\n  .advancedfiltercontainer[_ngcontent-%COMP%]   .flex[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n    width: 100%;\n    margin-right: 0 !important;\n  }\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .flex.items-center.justify-between[_ngcontent-%COMP%] {\n  flex-wrap: wrap;\n}\n.advancedfiltercontainer[_ngcontent-%COMP%]   .flex.items-center.justify-between[_ngcontent-%COMP%]    > *[_ngcontent-%COMP%] {\n  margin-bottom: 0.5rem;\n}\n@media (max-width: 768px) {\n  .pagination[_ngcontent-%COMP%]   select[_ngcontent-%COMP%] {\n    margin-top: 1rem;\n  }\n  .filter-button[_ngcontent-%COMP%] {\n    height: 33.6px;\n  }\n}\n.dots-container[_ngcontent-%COMP%] {\n  display: flex;\n  align-items: center;\n  justify-content: center;\n  height: 100%;\n  width: 100%;\n}\n.dot[_ngcontent-%COMP%] {\n  height: 20px;\n  width: 20px;\n  margin-right: 10px;\n  border-radius: 10px;\n  background-color: #b3d4fc;\n  animation: _ngcontent-%COMP%_pulse 1.5s infinite ease-in-out;\n}\n.dot[_ngcontent-%COMP%]:last-child {\n  margin-right: 0;\n}\n.dot[_ngcontent-%COMP%]:nth-child(1) {\n  animation-delay: -0.3s;\n}\n.dot[_ngcontent-%COMP%]:nth-child(2) {\n  animation-delay: -0.1s;\n}\n.dot[_ngcontent-%COMP%]:nth-child(3) {\n  animation-delay: 0.1s;\n}\n@keyframes _ngcontent-%COMP%_pulse {\n  0% {\n    transform: scale(0.8);\n    background-color: #b3d4fc;\n    box-shadow: 0 0 0 0 rgba(178, 212, 252, 0.7);\n  }\n  50% {\n    transform: scale(1.2);\n    background-color: #6793fb;\n    box-shadow: 0 0 0 10px rgba(178, 212, 252, 0);\n  }\n  100% {\n    transform: scale(0.8);\n    background-color: #b3d4fc;\n    box-shadow: 0 0 0 0 rgba(178, 212, 252, 0.7);\n  }\n}\n/*# sourceMappingURL=datatable.component.css.map */"], data: { animation: [
  trigger("toggleAnimation", [
    transition(":enter", [style({ opacity: 0, transform: "scale(0.95)" }), animate("100ms ease-out", style({ opacity: 1, transform: "scale(1)" }))]),
    transition(":leave", [animate("75ms", style({ opacity: 0, transform: "scale(0.95)" }))])
  ])
] } });
var DataTableComponent = _DataTableComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(DataTableComponent, { className: "DataTableComponent", filePath: "src\\app\\@lcp-framework\\components\\datatable\\datatable.component.ts", lineNumber: 46 });
})();

export {
  ProfileApiService,
  ExportService,
  DataTableComponent,
  RouteUpdateService
};
//# sourceMappingURL=chunk-KV3IUGXW.js.map
