import {
  _typeof
} from "./chunk-BP5JJWGC.js";
import {
  DefaultValueAccessor,
  FormsModule,
  NG_VALUE_ACCESSOR,
  NgControlStatus,
  NgModel
} from "./chunk-NLYGDKUR.js";
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  CommonModule,
  Component,
  Directive,
  ElementRef,
  EventEmitter,
  HostListener,
  Input,
  NgClass,
  NgForOf,
  NgIf,
  NgModule,
  Output,
  Pipe,
  forwardRef,
  setClassMetadata,
  ɵɵProvidersFeature,
  ɵɵadvance,
  ɵɵattribute,
  ɵɵclassProp,
  ɵɵdefineComponent,
  ɵɵdefineDirective,
  ɵɵdefineInjector,
  ɵɵdefineNgModule,
  ɵɵdefinePipe,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind2,
  ɵɵproperty,
  ɵɵpureFunction1,
  ɵɵresetView,
  ɵɵresolveDocument,
  ɵɵrestoreView,
  ɵɵstyleProp,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵtwoWayBindingSet,
  ɵɵtwoWayListener,
  ɵɵtwoWayProperty
} from "./chunk-GKZIWABI.js";

// node_modules/xlsx/xlsx.mjs
var XLSX = {};
XLSX.version = "0.18.5";
var current_codepage = 1200;
var current_ansi = 1252;
var VALID_ANSI = [874, 932, 936, 949, 950, 1250, 1251, 1252, 1253, 1254, 1255, 1256, 1257, 1258, 1e4];
var CS2CP = {
  /*::[*/
  0: 1252,
  /* ANSI */
  /*::[*/
  1: 65001,
  /* DEFAULT */
  /*::[*/
  2: 65001,
  /* SYMBOL */
  /*::[*/
  77: 1e4,
  /* MAC */
  /*::[*/
  128: 932,
  /* SHIFTJIS */
  /*::[*/
  129: 949,
  /* HANGUL */
  /*::[*/
  130: 1361,
  /* JOHAB */
  /*::[*/
  134: 936,
  /* GB2312 */
  /*::[*/
  136: 950,
  /* CHINESEBIG5 */
  /*::[*/
  161: 1253,
  /* GREEK */
  /*::[*/
  162: 1254,
  /* TURKISH */
  /*::[*/
  163: 1258,
  /* VIETNAMESE */
  /*::[*/
  177: 1255,
  /* HEBREW */
  /*::[*/
  178: 1256,
  /* ARABIC */
  /*::[*/
  186: 1257,
  /* BALTIC */
  /*::[*/
  204: 1251,
  /* RUSSIAN */
  /*::[*/
  222: 874,
  /* THAI */
  /*::[*/
  238: 1250,
  /* EASTEUROPE */
  /*::[*/
  255: 1252,
  /* OEM */
  /*::[*/
  69: 6969
  /* MISC */
};
var set_ansi = function(cp) {
  if (VALID_ANSI.indexOf(cp) == -1)
    return;
  current_ansi = CS2CP[0] = cp;
};
function reset_ansi() {
  set_ansi(1252);
}
var set_cp = function(cp) {
  current_codepage = cp;
  set_ansi(cp);
};
function reset_cp() {
  set_cp(1200);
  reset_ansi();
}
function char_codes(data) {
  var o2 = [];
  for (var i2 = 0, len = data.length; i2 < len; ++i2)
    o2[i2] = data.charCodeAt(i2);
  return o2;
}
function utf16leread(data) {
  var o2 = [];
  for (var i2 = 0; i2 < data.length >> 1; ++i2)
    o2[i2] = String.fromCharCode(data.charCodeAt(2 * i2) + (data.charCodeAt(2 * i2 + 1) << 8));
  return o2.join("");
}
function utf16beread(data) {
  var o2 = [];
  for (var i2 = 0; i2 < data.length >> 1; ++i2)
    o2[i2] = String.fromCharCode(data.charCodeAt(2 * i2 + 1) + (data.charCodeAt(2 * i2) << 8));
  return o2.join("");
}
var debom = function(data) {
  var c1 = data.charCodeAt(0), c2 = data.charCodeAt(1);
  if (c1 == 255 && c2 == 254)
    return utf16leread(data.slice(2));
  if (c1 == 254 && c2 == 255)
    return utf16beread(data.slice(2));
  if (c1 == 65279)
    return data.slice(1);
  return data;
};
var _getchar = function _gc1(x2) {
  return String.fromCharCode(x2);
};
var _getansi = function _ga1(x2) {
  return String.fromCharCode(x2);
};
var $cptable;
var DENSE = null;
var DIF_XL = true;
var Base64_map = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";
function Base64_encode(input) {
  var o2 = "";
  var c1 = 0, c2 = 0, c3 = 0, e1 = 0, e2 = 0, e3 = 0, e4 = 0;
  for (var i2 = 0; i2 < input.length; ) {
    c1 = input.charCodeAt(i2++);
    e1 = c1 >> 2;
    c2 = input.charCodeAt(i2++);
    e2 = (c1 & 3) << 4 | c2 >> 4;
    c3 = input.charCodeAt(i2++);
    e3 = (c2 & 15) << 2 | c3 >> 6;
    e4 = c3 & 63;
    if (isNaN(c2)) {
      e3 = e4 = 64;
    } else if (isNaN(c3)) {
      e4 = 64;
    }
    o2 += Base64_map.charAt(e1) + Base64_map.charAt(e2) + Base64_map.charAt(e3) + Base64_map.charAt(e4);
  }
  return o2;
}
function Base64_decode(input) {
  var o2 = "";
  var c1 = 0, c2 = 0, c3 = 0, e1 = 0, e2 = 0, e3 = 0, e4 = 0;
  input = input.replace(/[^\w\+\/\=]/g, "");
  for (var i2 = 0; i2 < input.length; ) {
    e1 = Base64_map.indexOf(input.charAt(i2++));
    e2 = Base64_map.indexOf(input.charAt(i2++));
    c1 = e1 << 2 | e2 >> 4;
    o2 += String.fromCharCode(c1);
    e3 = Base64_map.indexOf(input.charAt(i2++));
    c2 = (e2 & 15) << 4 | e3 >> 2;
    if (e3 !== 64) {
      o2 += String.fromCharCode(c2);
    }
    e4 = Base64_map.indexOf(input.charAt(i2++));
    c3 = (e3 & 3) << 6 | e4;
    if (e4 !== 64) {
      o2 += String.fromCharCode(c3);
    }
  }
  return o2;
}
var has_buf = /* @__PURE__ */ function() {
  return typeof Buffer !== "undefined" && typeof process !== "undefined" && typeof process.versions !== "undefined" && !!process.versions.node;
}();
var Buffer_from = /* @__PURE__ */ function() {
  if (typeof Buffer !== "undefined") {
    var nbfs = !Buffer.from;
    if (!nbfs)
      try {
        Buffer.from("foo", "utf8");
      } catch (e) {
        nbfs = true;
      }
    return nbfs ? function(buf, enc) {
      return enc ? new Buffer(buf, enc) : new Buffer(buf);
    } : Buffer.from.bind(Buffer);
  }
  return function() {
  };
}();
function new_raw_buf(len) {
  if (has_buf)
    return Buffer.alloc ? Buffer.alloc(len) : new Buffer(len);
  return typeof Uint8Array != "undefined" ? new Uint8Array(len) : new Array(len);
}
function new_unsafe_buf(len) {
  if (has_buf)
    return Buffer.allocUnsafe ? Buffer.allocUnsafe(len) : new Buffer(len);
  return typeof Uint8Array != "undefined" ? new Uint8Array(len) : new Array(len);
}
var s2a = function s2a2(s2) {
  if (has_buf)
    return Buffer_from(s2, "binary");
  return s2.split("").map(function(x2) {
    return x2.charCodeAt(0) & 255;
  });
};
function s2ab(s2) {
  if (typeof ArrayBuffer === "undefined")
    return s2a(s2);
  var buf = new ArrayBuffer(s2.length), view = new Uint8Array(buf);
  for (var i2 = 0; i2 != s2.length; ++i2)
    view[i2] = s2.charCodeAt(i2) & 255;
  return buf;
}
function a2s(data) {
  if (Array.isArray(data))
    return data.map(function(c2) {
      return String.fromCharCode(c2);
    }).join("");
  var o2 = [];
  for (var i2 = 0; i2 < data.length; ++i2)
    o2[i2] = String.fromCharCode(data[i2]);
  return o2.join("");
}
function a2u(data) {
  if (typeof Uint8Array === "undefined")
    throw new Error("Unsupported");
  return new Uint8Array(data);
}
function ab2a(data) {
  if (typeof ArrayBuffer == "undefined")
    throw new Error("Unsupported");
  if (data instanceof ArrayBuffer)
    return ab2a(new Uint8Array(data));
  var o2 = new Array(data.length);
  for (var i2 = 0; i2 < data.length; ++i2)
    o2[i2] = data[i2];
  return o2;
}
var bconcat = has_buf ? function(bufs) {
  return Buffer.concat(bufs.map(function(buf) {
    return Buffer.isBuffer(buf) ? buf : Buffer_from(buf);
  }));
} : function(bufs) {
  if (typeof Uint8Array !== "undefined") {
    var i2 = 0, maxlen = 0;
    for (i2 = 0; i2 < bufs.length; ++i2)
      maxlen += bufs[i2].length;
    var o2 = new Uint8Array(maxlen);
    var len = 0;
    for (i2 = 0, maxlen = 0; i2 < bufs.length; maxlen += len, ++i2) {
      len = bufs[i2].length;
      if (bufs[i2] instanceof Uint8Array)
        o2.set(bufs[i2], maxlen);
      else if (typeof bufs[i2] == "string") {
        throw "wtf";
      } else
        o2.set(new Uint8Array(bufs[i2]), maxlen);
    }
    return o2;
  }
  return [].concat.apply([], bufs.map(function(buf) {
    return Array.isArray(buf) ? buf : [].slice.call(buf);
  }));
};
function utf8decode(content) {
  var out = [], widx = 0, L2 = content.length + 250;
  var o2 = new_raw_buf(content.length + 255);
  for (var ridx = 0; ridx < content.length; ++ridx) {
    var c2 = content.charCodeAt(ridx);
    if (c2 < 128)
      o2[widx++] = c2;
    else if (c2 < 2048) {
      o2[widx++] = 192 | c2 >> 6 & 31;
      o2[widx++] = 128 | c2 & 63;
    } else if (c2 >= 55296 && c2 < 57344) {
      c2 = (c2 & 1023) + 64;
      var d2 = content.charCodeAt(++ridx) & 1023;
      o2[widx++] = 240 | c2 >> 8 & 7;
      o2[widx++] = 128 | c2 >> 2 & 63;
      o2[widx++] = 128 | d2 >> 6 & 15 | (c2 & 3) << 4;
      o2[widx++] = 128 | d2 & 63;
    } else {
      o2[widx++] = 224 | c2 >> 12 & 15;
      o2[widx++] = 128 | c2 >> 6 & 63;
      o2[widx++] = 128 | c2 & 63;
    }
    if (widx > L2) {
      out.push(o2.slice(0, widx));
      widx = 0;
      o2 = new_raw_buf(65535);
      L2 = 65530;
    }
  }
  out.push(o2.slice(0, widx));
  return bconcat(out);
}
var chr0 = /\u0000/g;
var chr1 = /[\u0001-\u0006]/g;
function _strrev(x2) {
  var o2 = "", i2 = x2.length - 1;
  while (i2 >= 0)
    o2 += x2.charAt(i2--);
  return o2;
}
function pad0(v2, d2) {
  var t2 = "" + v2;
  return t2.length >= d2 ? t2 : fill("0", d2 - t2.length) + t2;
}
function pad_(v2, d2) {
  var t2 = "" + v2;
  return t2.length >= d2 ? t2 : fill(" ", d2 - t2.length) + t2;
}
function rpad_(v2, d2) {
  var t2 = "" + v2;
  return t2.length >= d2 ? t2 : t2 + fill(" ", d2 - t2.length);
}
function pad0r1(v2, d2) {
  var t2 = "" + Math.round(v2);
  return t2.length >= d2 ? t2 : fill("0", d2 - t2.length) + t2;
}
function pad0r2(v2, d2) {
  var t2 = "" + v2;
  return t2.length >= d2 ? t2 : fill("0", d2 - t2.length) + t2;
}
var p2_32 = /* @__PURE__ */ Math.pow(2, 32);
function pad0r(v2, d2) {
  if (v2 > p2_32 || v2 < -p2_32)
    return pad0r1(v2, d2);
  var i2 = Math.round(v2);
  return pad0r2(i2, d2);
}
function SSF_isgeneral(s2, i2) {
  i2 = i2 || 0;
  return s2.length >= 7 + i2 && (s2.charCodeAt(i2) | 32) === 103 && (s2.charCodeAt(i2 + 1) | 32) === 101 && (s2.charCodeAt(i2 + 2) | 32) === 110 && (s2.charCodeAt(i2 + 3) | 32) === 101 && (s2.charCodeAt(i2 + 4) | 32) === 114 && (s2.charCodeAt(i2 + 5) | 32) === 97 && (s2.charCodeAt(i2 + 6) | 32) === 108;
}
var days = [
  ["Sun", "Sunday"],
  ["Mon", "Monday"],
  ["Tue", "Tuesday"],
  ["Wed", "Wednesday"],
  ["Thu", "Thursday"],
  ["Fri", "Friday"],
  ["Sat", "Saturday"]
];
var months = [
  ["J", "Jan", "January"],
  ["F", "Feb", "February"],
  ["M", "Mar", "March"],
  ["A", "Apr", "April"],
  ["M", "May", "May"],
  ["J", "Jun", "June"],
  ["J", "Jul", "July"],
  ["A", "Aug", "August"],
  ["S", "Sep", "September"],
  ["O", "Oct", "October"],
  ["N", "Nov", "November"],
  ["D", "Dec", "December"]
];
function SSF_init_table(t2) {
  if (!t2)
    t2 = {};
  t2[0] = "General";
  t2[1] = "0";
  t2[2] = "0.00";
  t2[3] = "#,##0";
  t2[4] = "#,##0.00";
  t2[9] = "0%";
  t2[10] = "0.00%";
  t2[11] = "0.00E+00";
  t2[12] = "# ?/?";
  t2[13] = "# ??/??";
  t2[14] = "m/d/yy";
  t2[15] = "d-mmm-yy";
  t2[16] = "d-mmm";
  t2[17] = "mmm-yy";
  t2[18] = "h:mm AM/PM";
  t2[19] = "h:mm:ss AM/PM";
  t2[20] = "h:mm";
  t2[21] = "h:mm:ss";
  t2[22] = "m/d/yy h:mm";
  t2[37] = "#,##0 ;(#,##0)";
  t2[38] = "#,##0 ;[Red](#,##0)";
  t2[39] = "#,##0.00;(#,##0.00)";
  t2[40] = "#,##0.00;[Red](#,##0.00)";
  t2[45] = "mm:ss";
  t2[46] = "[h]:mm:ss";
  t2[47] = "mmss.0";
  t2[48] = "##0.0E+0";
  t2[49] = "@";
  t2[56] = '"\u4E0A\u5348/\u4E0B\u5348 "hh"\u6642"mm"\u5206"ss"\u79D2 "';
  return t2;
}
var table_fmt = {
  0: "General",
  1: "0",
  2: "0.00",
  3: "#,##0",
  4: "#,##0.00",
  9: "0%",
  10: "0.00%",
  11: "0.00E+00",
  12: "# ?/?",
  13: "# ??/??",
  14: "m/d/yy",
  15: "d-mmm-yy",
  16: "d-mmm",
  17: "mmm-yy",
  18: "h:mm AM/PM",
  19: "h:mm:ss AM/PM",
  20: "h:mm",
  21: "h:mm:ss",
  22: "m/d/yy h:mm",
  37: "#,##0 ;(#,##0)",
  38: "#,##0 ;[Red](#,##0)",
  39: "#,##0.00;(#,##0.00)",
  40: "#,##0.00;[Red](#,##0.00)",
  45: "mm:ss",
  46: "[h]:mm:ss",
  47: "mmss.0",
  48: "##0.0E+0",
  49: "@",
  56: '"\u4E0A\u5348/\u4E0B\u5348 "hh"\u6642"mm"\u5206"ss"\u79D2 "'
};
var SSF_default_map = {
  5: 37,
  6: 38,
  7: 39,
  8: 40,
  //  5 -> 37 ...  8 -> 40
  23: 0,
  24: 0,
  25: 0,
  26: 0,
  // 23 ->  0 ... 26 ->  0
  27: 14,
  28: 14,
  29: 14,
  30: 14,
  31: 14,
  // 27 -> 14 ... 31 -> 14
  50: 14,
  51: 14,
  52: 14,
  53: 14,
  54: 14,
  // 50 -> 14 ... 58 -> 14
  55: 14,
  56: 14,
  57: 14,
  58: 14,
  59: 1,
  60: 2,
  61: 3,
  62: 4,
  // 59 ->  1 ... 62 ->  4
  67: 9,
  68: 10,
  // 67 ->  9 ... 68 -> 10
  69: 12,
  70: 13,
  71: 14,
  // 69 -> 12 ... 71 -> 14
  72: 14,
  73: 15,
  74: 16,
  75: 17,
  // 72 -> 14 ... 75 -> 17
  76: 20,
  77: 21,
  78: 22,
  // 76 -> 20 ... 78 -> 22
  79: 45,
  80: 46,
  81: 47,
  // 79 -> 45 ... 81 -> 47
  82: 0
  // 82 ->  0 ... 65536 -> 0 (omitted)
};
var SSF_default_str = {
  //  5 -- Currency,   0 decimal, black negative
  5: '"$"#,##0_);\\("$"#,##0\\)',
  63: '"$"#,##0_);\\("$"#,##0\\)',
  //  6 -- Currency,   0 decimal, red   negative
  6: '"$"#,##0_);[Red]\\("$"#,##0\\)',
  64: '"$"#,##0_);[Red]\\("$"#,##0\\)',
  //  7 -- Currency,   2 decimal, black negative
  7: '"$"#,##0.00_);\\("$"#,##0.00\\)',
  65: '"$"#,##0.00_);\\("$"#,##0.00\\)',
  //  8 -- Currency,   2 decimal, red   negative
  8: '"$"#,##0.00_);[Red]\\("$"#,##0.00\\)',
  66: '"$"#,##0.00_);[Red]\\("$"#,##0.00\\)',
  // 41 -- Accounting, 0 decimal, No Symbol
  41: '_(* #,##0_);_(* \\(#,##0\\);_(* "-"_);_(@_)',
  // 42 -- Accounting, 0 decimal, $  Symbol
  42: '_("$"* #,##0_);_("$"* \\(#,##0\\);_("$"* "-"_);_(@_)',
  // 43 -- Accounting, 2 decimal, No Symbol
  43: '_(* #,##0.00_);_(* \\(#,##0.00\\);_(* "-"??_);_(@_)',
  // 44 -- Accounting, 2 decimal, $  Symbol
  44: '_("$"* #,##0.00_);_("$"* \\(#,##0.00\\);_("$"* "-"??_);_(@_)'
};
function SSF_frac(x2, D2, mixed) {
  var sgn = x2 < 0 ? -1 : 1;
  var B2 = x2 * sgn;
  var P_2 = 0, P_1 = 1, P2 = 0;
  var Q_2 = 1, Q_1 = 0, Q2 = 0;
  var A2 = Math.floor(B2);
  while (Q_1 < D2) {
    A2 = Math.floor(B2);
    P2 = A2 * P_1 + P_2;
    Q2 = A2 * Q_1 + Q_2;
    if (B2 - A2 < 5e-8)
      break;
    B2 = 1 / (B2 - A2);
    P_2 = P_1;
    P_1 = P2;
    Q_2 = Q_1;
    Q_1 = Q2;
  }
  if (Q2 > D2) {
    if (Q_1 > D2) {
      Q2 = Q_2;
      P2 = P_2;
    } else {
      Q2 = Q_1;
      P2 = P_1;
    }
  }
  if (!mixed)
    return [0, sgn * P2, Q2];
  var q2 = Math.floor(sgn * P2 / Q2);
  return [q2, sgn * P2 - q2 * Q2, Q2];
}
function SSF_parse_date_code(v2, opts, b2) {
  if (v2 > 2958465 || v2 < 0)
    return null;
  var date = v2 | 0, time = Math.floor(86400 * (v2 - date)), dow = 0;
  var dout = [];
  var out = { D: date, T: time, u: 86400 * (v2 - date) - time, y: 0, m: 0, d: 0, H: 0, M: 0, S: 0, q: 0 };
  if (Math.abs(out.u) < 1e-6)
    out.u = 0;
  if (opts && opts.date1904)
    date += 1462;
  if (out.u > 0.9999) {
    out.u = 0;
    if (++time == 86400) {
      out.T = time = 0;
      ++date;
      ++out.D;
    }
  }
  if (date === 60) {
    dout = b2 ? [1317, 10, 29] : [1900, 2, 29];
    dow = 3;
  } else if (date === 0) {
    dout = b2 ? [1317, 8, 29] : [1900, 1, 0];
    dow = 6;
  } else {
    if (date > 60)
      --date;
    var d2 = new Date(1900, 0, 1);
    d2.setDate(d2.getDate() + date - 1);
    dout = [d2.getFullYear(), d2.getMonth() + 1, d2.getDate()];
    dow = d2.getDay();
    if (date < 60)
      dow = (dow + 6) % 7;
    if (b2)
      dow = SSF_fix_hijri(d2, dout);
  }
  out.y = dout[0];
  out.m = dout[1];
  out.d = dout[2];
  out.S = time % 60;
  time = Math.floor(time / 60);
  out.M = time % 60;
  time = Math.floor(time / 60);
  out.H = time;
  out.q = dow;
  return out;
}
var SSFbasedate = /* @__PURE__ */ new Date(1899, 11, 31, 0, 0, 0);
var SSFdnthresh = /* @__PURE__ */ SSFbasedate.getTime();
var SSFbase1904 = /* @__PURE__ */ new Date(1900, 2, 1, 0, 0, 0);
function datenum_local(v2, date1904) {
  var epoch = /* @__PURE__ */ v2.getTime();
  if (date1904)
    epoch -= 1461 * 24 * 60 * 60 * 1e3;
  else if (v2 >= SSFbase1904)
    epoch += 24 * 60 * 60 * 1e3;
  return (epoch - (SSFdnthresh + (/* @__PURE__ */ v2.getTimezoneOffset() - /* @__PURE__ */ SSFbasedate.getTimezoneOffset()) * 6e4)) / (24 * 60 * 60 * 1e3);
}
function SSF_strip_decimal(o2) {
  return o2.indexOf(".") == -1 ? o2 : o2.replace(/(?:\.0*|(\.\d*[1-9])0+)$/, "$1");
}
function SSF_normalize_exp(o2) {
  if (o2.indexOf("E") == -1)
    return o2;
  return o2.replace(/(?:\.0*|(\.\d*[1-9])0+)[Ee]/, "$1E").replace(/(E[+-])(\d)$/, "$10$2");
}
function SSF_small_exp(v2) {
  var w2 = v2 < 0 ? 12 : 11;
  var o2 = SSF_strip_decimal(v2.toFixed(12));
  if (o2.length <= w2)
    return o2;
  o2 = v2.toPrecision(10);
  if (o2.length <= w2)
    return o2;
  return v2.toExponential(5);
}
function SSF_large_exp(v2) {
  var o2 = SSF_strip_decimal(v2.toFixed(11));
  return o2.length > (v2 < 0 ? 12 : 11) || o2 === "0" || o2 === "-0" ? v2.toPrecision(6) : o2;
}
function SSF_general_num(v2) {
  var V2 = Math.floor(Math.log(Math.abs(v2)) * Math.LOG10E), o2;
  if (V2 >= -4 && V2 <= -1)
    o2 = v2.toPrecision(10 + V2);
  else if (Math.abs(V2) <= 9)
    o2 = SSF_small_exp(v2);
  else if (V2 === 10)
    o2 = v2.toFixed(10).substr(0, 12);
  else
    o2 = SSF_large_exp(v2);
  return SSF_strip_decimal(SSF_normalize_exp(o2.toUpperCase()));
}
function SSF_general(v2, opts) {
  switch (typeof v2) {
    case "string":
      return v2;
    case "boolean":
      return v2 ? "TRUE" : "FALSE";
    case "number":
      return (v2 | 0) === v2 ? v2.toString(10) : SSF_general_num(v2);
    case "undefined":
      return "";
    case "object":
      if (v2 == null)
        return "";
      if (v2 instanceof Date)
        return SSF_format(14, datenum_local(v2, opts && opts.date1904), opts);
  }
  throw new Error("unsupported value in General format: " + v2);
}
function SSF_fix_hijri(date, o2) {
  o2[0] -= 581;
  var dow = date.getDay();
  if (date < 60)
    dow = (dow + 6) % 7;
  return dow;
}
function SSF_write_date(type, fmt, val, ss0) {
  var o2 = "", ss = 0, tt2 = 0, y2 = val.y, out, outl = 0;
  switch (type) {
    case 98:
      y2 = val.y + 543;
    case 121:
      switch (fmt.length) {
        case 1:
        case 2:
          out = y2 % 100;
          outl = 2;
          break;
        default:
          out = y2 % 1e4;
          outl = 4;
          break;
      }
      break;
    case 109:
      switch (fmt.length) {
        case 1:
        case 2:
          out = val.m;
          outl = fmt.length;
          break;
        case 3:
          return months[val.m - 1][1];
        case 5:
          return months[val.m - 1][0];
        default:
          return months[val.m - 1][2];
      }
      break;
    case 100:
      switch (fmt.length) {
        case 1:
        case 2:
          out = val.d;
          outl = fmt.length;
          break;
        case 3:
          return days[val.q][0];
        default:
          return days[val.q][1];
      }
      break;
    case 104:
      switch (fmt.length) {
        case 1:
        case 2:
          out = 1 + (val.H + 11) % 12;
          outl = fmt.length;
          break;
        default:
          throw "bad hour format: " + fmt;
      }
      break;
    case 72:
      switch (fmt.length) {
        case 1:
        case 2:
          out = val.H;
          outl = fmt.length;
          break;
        default:
          throw "bad hour format: " + fmt;
      }
      break;
    case 77:
      switch (fmt.length) {
        case 1:
        case 2:
          out = val.M;
          outl = fmt.length;
          break;
        default:
          throw "bad minute format: " + fmt;
      }
      break;
    case 115:
      if (fmt != "s" && fmt != "ss" && fmt != ".0" && fmt != ".00" && fmt != ".000")
        throw "bad second format: " + fmt;
      if (val.u === 0 && (fmt == "s" || fmt == "ss"))
        return pad0(val.S, fmt.length);
      if (ss0 >= 2)
        tt2 = ss0 === 3 ? 1e3 : 100;
      else
        tt2 = ss0 === 1 ? 10 : 1;
      ss = Math.round(tt2 * (val.S + val.u));
      if (ss >= 60 * tt2)
        ss = 0;
      if (fmt === "s")
        return ss === 0 ? "0" : "" + ss / tt2;
      o2 = pad0(ss, 2 + ss0);
      if (fmt === "ss")
        return o2.substr(0, 2);
      return "." + o2.substr(2, fmt.length - 1);
    case 90:
      switch (fmt) {
        case "[h]":
        case "[hh]":
          out = val.D * 24 + val.H;
          break;
        case "[m]":
        case "[mm]":
          out = (val.D * 24 + val.H) * 60 + val.M;
          break;
        case "[s]":
        case "[ss]":
          out = ((val.D * 24 + val.H) * 60 + val.M) * 60 + Math.round(val.S + val.u);
          break;
        default:
          throw "bad abstime format: " + fmt;
      }
      outl = fmt.length === 3 ? 1 : 2;
      break;
    case 101:
      out = y2;
      outl = 1;
      break;
  }
  var outstr = outl > 0 ? pad0(out, outl) : "";
  return outstr;
}
function commaify(s2) {
  var w2 = 3;
  if (s2.length <= w2)
    return s2;
  var j2 = s2.length % w2, o2 = s2.substr(0, j2);
  for (; j2 != s2.length; j2 += w2)
    o2 += (o2.length > 0 ? "," : "") + s2.substr(j2, w2);
  return o2;
}
var pct1 = /%/g;
function write_num_pct(type, fmt, val) {
  var sfmt = fmt.replace(pct1, ""), mul = fmt.length - sfmt.length;
  return write_num(type, sfmt, val * Math.pow(10, 2 * mul)) + fill("%", mul);
}
function write_num_cm(type, fmt, val) {
  var idx = fmt.length - 1;
  while (fmt.charCodeAt(idx - 1) === 44)
    --idx;
  return write_num(type, fmt.substr(0, idx), val / Math.pow(10, 3 * (fmt.length - idx)));
}
function write_num_exp(fmt, val) {
  var o2;
  var idx = fmt.indexOf("E") - fmt.indexOf(".") - 1;
  if (fmt.match(/^#+0.0E\+0$/)) {
    if (val == 0)
      return "0.0E+0";
    else if (val < 0)
      return "-" + write_num_exp(fmt, -val);
    var period = fmt.indexOf(".");
    if (period === -1)
      period = fmt.indexOf("E");
    var ee2 = Math.floor(Math.log(val) * Math.LOG10E) % period;
    if (ee2 < 0)
      ee2 += period;
    o2 = (val / Math.pow(10, ee2)).toPrecision(idx + 1 + (period + ee2) % period);
    if (o2.indexOf("e") === -1) {
      var fakee = Math.floor(Math.log(val) * Math.LOG10E);
      if (o2.indexOf(".") === -1)
        o2 = o2.charAt(0) + "." + o2.substr(1) + "E+" + (fakee - o2.length + ee2);
      else
        o2 += "E+" + (fakee - ee2);
      while (o2.substr(0, 2) === "0.") {
        o2 = o2.charAt(0) + o2.substr(2, period) + "." + o2.substr(2 + period);
        o2 = o2.replace(/^0+([1-9])/, "$1").replace(/^0+\./, "0.");
      }
      o2 = o2.replace(/\+-/, "-");
    }
    o2 = o2.replace(/^([+-]?)(\d*)\.(\d*)[Ee]/, function($$, $1, $22, $3) {
      return $1 + $22 + $3.substr(0, (period + ee2) % period) + "." + $3.substr(ee2) + "E";
    });
  } else
    o2 = val.toExponential(idx);
  if (fmt.match(/E\+00$/) && o2.match(/e[+-]\d$/))
    o2 = o2.substr(0, o2.length - 1) + "0" + o2.charAt(o2.length - 1);
  if (fmt.match(/E\-/) && o2.match(/e\+/))
    o2 = o2.replace(/e\+/, "e");
  return o2.replace("e", "E");
}
var frac1 = /# (\?+)( ?)\/( ?)(\d+)/;
function write_num_f1(r, aval, sign) {
  var den = parseInt(r[4], 10), rr = Math.round(aval * den), base = Math.floor(rr / den);
  var myn = rr - base * den, myd = den;
  return sign + (base === 0 ? "" : "" + base) + " " + (myn === 0 ? fill(" ", r[1].length + 1 + r[4].length) : pad_(myn, r[1].length) + r[2] + "/" + r[3] + pad0(myd, r[4].length));
}
function write_num_f2(r, aval, sign) {
  return sign + (aval === 0 ? "" : "" + aval) + fill(" ", r[1].length + 2 + r[4].length);
}
var dec1 = /^#*0*\.([0#]+)/;
var closeparen = /\).*[0#]/;
var phone = /\(###\) ###\\?-####/;
function hashq(str) {
  var o2 = "", cc;
  for (var i2 = 0; i2 != str.length; ++i2)
    switch (cc = str.charCodeAt(i2)) {
      case 35:
        break;
      case 63:
        o2 += " ";
        break;
      case 48:
        o2 += "0";
        break;
      default:
        o2 += String.fromCharCode(cc);
    }
  return o2;
}
function rnd(val, d2) {
  var dd = Math.pow(10, d2);
  return "" + Math.round(val * dd) / dd;
}
function dec(val, d2) {
  var _frac = val - Math.floor(val), dd = Math.pow(10, d2);
  if (d2 < ("" + Math.round(_frac * dd)).length)
    return 0;
  return Math.round(_frac * dd);
}
function carry(val, d2) {
  if (d2 < ("" + Math.round((val - Math.floor(val)) * Math.pow(10, d2))).length) {
    return 1;
  }
  return 0;
}
function flr(val) {
  if (val < 2147483647 && val > -2147483648)
    return "" + (val >= 0 ? val | 0 : val - 1 | 0);
  return "" + Math.floor(val);
}
function write_num_flt(type, fmt, val) {
  if (type.charCodeAt(0) === 40 && !fmt.match(closeparen)) {
    var ffmt = fmt.replace(/\( */, "").replace(/ \)/, "").replace(/\)/, "");
    if (val >= 0)
      return write_num_flt("n", ffmt, val);
    return "(" + write_num_flt("n", ffmt, -val) + ")";
  }
  if (fmt.charCodeAt(fmt.length - 1) === 44)
    return write_num_cm(type, fmt, val);
  if (fmt.indexOf("%") !== -1)
    return write_num_pct(type, fmt, val);
  if (fmt.indexOf("E") !== -1)
    return write_num_exp(fmt, val);
  if (fmt.charCodeAt(0) === 36)
    return "$" + write_num_flt(type, fmt.substr(fmt.charAt(1) == " " ? 2 : 1), val);
  var o2;
  var r, ri, ff, aval = Math.abs(val), sign = val < 0 ? "-" : "";
  if (fmt.match(/^00+$/))
    return sign + pad0r(aval, fmt.length);
  if (fmt.match(/^[#?]+$/)) {
    o2 = pad0r(val, 0);
    if (o2 === "0")
      o2 = "";
    return o2.length > fmt.length ? o2 : hashq(fmt.substr(0, fmt.length - o2.length)) + o2;
  }
  if (r = fmt.match(frac1))
    return write_num_f1(r, aval, sign);
  if (fmt.match(/^#+0+$/))
    return sign + pad0r(aval, fmt.length - fmt.indexOf("0"));
  if (r = fmt.match(dec1)) {
    o2 = rnd(val, r[1].length).replace(/^([^\.]+)$/, "$1." + hashq(r[1])).replace(/\.$/, "." + hashq(r[1])).replace(/\.(\d*)$/, function($$, $1) {
      return "." + $1 + fill("0", hashq(
        /*::(*/
        r[1]
      ).length - $1.length);
    });
    return fmt.indexOf("0.") !== -1 ? o2 : o2.replace(/^0\./, ".");
  }
  fmt = fmt.replace(/^#+([0.])/, "$1");
  if (r = fmt.match(/^(0*)\.(#*)$/)) {
    return sign + rnd(aval, r[2].length).replace(/\.(\d*[1-9])0*$/, ".$1").replace(/^(-?\d*)$/, "$1.").replace(/^0\./, r[1].length ? "0." : ".");
  }
  if (r = fmt.match(/^#{1,3},##0(\.?)$/))
    return sign + commaify(pad0r(aval, 0));
  if (r = fmt.match(/^#,##0\.([#0]*0)$/)) {
    return val < 0 ? "-" + write_num_flt(type, fmt, -val) : commaify("" + (Math.floor(val) + carry(val, r[1].length))) + "." + pad0(dec(val, r[1].length), r[1].length);
  }
  if (r = fmt.match(/^#,#*,#0/))
    return write_num_flt(type, fmt.replace(/^#,#*,/, ""), val);
  if (r = fmt.match(/^([0#]+)(\\?-([0#]+))+$/)) {
    o2 = _strrev(write_num_flt(type, fmt.replace(/[\\-]/g, ""), val));
    ri = 0;
    return _strrev(_strrev(fmt.replace(/\\/g, "")).replace(/[0#]/g, function(x3) {
      return ri < o2.length ? o2.charAt(ri++) : x3 === "0" ? "0" : "";
    }));
  }
  if (fmt.match(phone)) {
    o2 = write_num_flt(type, "##########", val);
    return "(" + o2.substr(0, 3) + ") " + o2.substr(3, 3) + "-" + o2.substr(6);
  }
  var oa = "";
  if (r = fmt.match(/^([#0?]+)( ?)\/( ?)([#0?]+)/)) {
    ri = Math.min(
      /*::String(*/
      r[4].length,
      7
    );
    ff = SSF_frac(aval, Math.pow(10, ri) - 1, false);
    o2 = "" + sign;
    oa = write_num(
      "n",
      /*::String(*/
      r[1],
      ff[1]
    );
    if (oa.charAt(oa.length - 1) == " ")
      oa = oa.substr(0, oa.length - 1) + "0";
    o2 += oa + /*::String(*/
    r[2] + "/" + /*::String(*/
    r[3];
    oa = rpad_(ff[2], ri);
    if (oa.length < r[4].length)
      oa = hashq(r[4].substr(r[4].length - oa.length)) + oa;
    o2 += oa;
    return o2;
  }
  if (r = fmt.match(/^# ([#0?]+)( ?)\/( ?)([#0?]+)/)) {
    ri = Math.min(Math.max(r[1].length, r[4].length), 7);
    ff = SSF_frac(aval, Math.pow(10, ri) - 1, true);
    return sign + (ff[0] || (ff[1] ? "" : "0")) + " " + (ff[1] ? pad_(ff[1], ri) + r[2] + "/" + r[3] + rpad_(ff[2], ri) : fill(" ", 2 * ri + 1 + r[2].length + r[3].length));
  }
  if (r = fmt.match(/^[#0?]+$/)) {
    o2 = pad0r(val, 0);
    if (fmt.length <= o2.length)
      return o2;
    return hashq(fmt.substr(0, fmt.length - o2.length)) + o2;
  }
  if (r = fmt.match(/^([#0?]+)\.([#0]+)$/)) {
    o2 = "" + val.toFixed(Math.min(r[2].length, 10)).replace(/([^0])0+$/, "$1");
    ri = o2.indexOf(".");
    var lres = fmt.indexOf(".") - ri, rres = fmt.length - o2.length - lres;
    return hashq(fmt.substr(0, lres) + o2 + fmt.substr(fmt.length - rres));
  }
  if (r = fmt.match(/^00,000\.([#0]*0)$/)) {
    ri = dec(val, r[1].length);
    return val < 0 ? "-" + write_num_flt(type, fmt, -val) : commaify(flr(val)).replace(/^\d,\d{3}$/, "0$&").replace(/^\d*$/, function($$) {
      return "00," + ($$.length < 3 ? pad0(0, 3 - $$.length) : "") + $$;
    }) + "." + pad0(ri, r[1].length);
  }
  switch (fmt) {
    case "###,##0.00":
      return write_num_flt(type, "#,##0.00", val);
    case "###,###":
    case "##,###":
    case "#,###":
      var x2 = commaify(pad0r(aval, 0));
      return x2 !== "0" ? sign + x2 : "";
    case "###,###.00":
      return write_num_flt(type, "###,##0.00", val).replace(/^0\./, ".");
    case "#,###.00":
      return write_num_flt(type, "#,##0.00", val).replace(/^0\./, ".");
    default:
  }
  throw new Error("unsupported format |" + fmt + "|");
}
function write_num_cm2(type, fmt, val) {
  var idx = fmt.length - 1;
  while (fmt.charCodeAt(idx - 1) === 44)
    --idx;
  return write_num(type, fmt.substr(0, idx), val / Math.pow(10, 3 * (fmt.length - idx)));
}
function write_num_pct2(type, fmt, val) {
  var sfmt = fmt.replace(pct1, ""), mul = fmt.length - sfmt.length;
  return write_num(type, sfmt, val * Math.pow(10, 2 * mul)) + fill("%", mul);
}
function write_num_exp2(fmt, val) {
  var o2;
  var idx = fmt.indexOf("E") - fmt.indexOf(".") - 1;
  if (fmt.match(/^#+0.0E\+0$/)) {
    if (val == 0)
      return "0.0E+0";
    else if (val < 0)
      return "-" + write_num_exp2(fmt, -val);
    var period = fmt.indexOf(".");
    if (period === -1)
      period = fmt.indexOf("E");
    var ee2 = Math.floor(Math.log(val) * Math.LOG10E) % period;
    if (ee2 < 0)
      ee2 += period;
    o2 = (val / Math.pow(10, ee2)).toPrecision(idx + 1 + (period + ee2) % period);
    if (!o2.match(/[Ee]/)) {
      var fakee = Math.floor(Math.log(val) * Math.LOG10E);
      if (o2.indexOf(".") === -1)
        o2 = o2.charAt(0) + "." + o2.substr(1) + "E+" + (fakee - o2.length + ee2);
      else
        o2 += "E+" + (fakee - ee2);
      o2 = o2.replace(/\+-/, "-");
    }
    o2 = o2.replace(/^([+-]?)(\d*)\.(\d*)[Ee]/, function($$, $1, $22, $3) {
      return $1 + $22 + $3.substr(0, (period + ee2) % period) + "." + $3.substr(ee2) + "E";
    });
  } else
    o2 = val.toExponential(idx);
  if (fmt.match(/E\+00$/) && o2.match(/e[+-]\d$/))
    o2 = o2.substr(0, o2.length - 1) + "0" + o2.charAt(o2.length - 1);
  if (fmt.match(/E\-/) && o2.match(/e\+/))
    o2 = o2.replace(/e\+/, "e");
  return o2.replace("e", "E");
}
function write_num_int(type, fmt, val) {
  if (type.charCodeAt(0) === 40 && !fmt.match(closeparen)) {
    var ffmt = fmt.replace(/\( */, "").replace(/ \)/, "").replace(/\)/, "");
    if (val >= 0)
      return write_num_int("n", ffmt, val);
    return "(" + write_num_int("n", ffmt, -val) + ")";
  }
  if (fmt.charCodeAt(fmt.length - 1) === 44)
    return write_num_cm2(type, fmt, val);
  if (fmt.indexOf("%") !== -1)
    return write_num_pct2(type, fmt, val);
  if (fmt.indexOf("E") !== -1)
    return write_num_exp2(fmt, val);
  if (fmt.charCodeAt(0) === 36)
    return "$" + write_num_int(type, fmt.substr(fmt.charAt(1) == " " ? 2 : 1), val);
  var o2;
  var r, ri, ff, aval = Math.abs(val), sign = val < 0 ? "-" : "";
  if (fmt.match(/^00+$/))
    return sign + pad0(aval, fmt.length);
  if (fmt.match(/^[#?]+$/)) {
    o2 = "" + val;
    if (val === 0)
      o2 = "";
    return o2.length > fmt.length ? o2 : hashq(fmt.substr(0, fmt.length - o2.length)) + o2;
  }
  if (r = fmt.match(frac1))
    return write_num_f2(r, aval, sign);
  if (fmt.match(/^#+0+$/))
    return sign + pad0(aval, fmt.length - fmt.indexOf("0"));
  if (r = fmt.match(dec1)) {
    o2 = ("" + val).replace(/^([^\.]+)$/, "$1." + hashq(r[1])).replace(/\.$/, "." + hashq(r[1]));
    o2 = o2.replace(/\.(\d*)$/, function($$, $1) {
      return "." + $1 + fill("0", hashq(r[1]).length - $1.length);
    });
    return fmt.indexOf("0.") !== -1 ? o2 : o2.replace(/^0\./, ".");
  }
  fmt = fmt.replace(/^#+([0.])/, "$1");
  if (r = fmt.match(/^(0*)\.(#*)$/)) {
    return sign + ("" + aval).replace(/\.(\d*[1-9])0*$/, ".$1").replace(/^(-?\d*)$/, "$1.").replace(/^0\./, r[1].length ? "0." : ".");
  }
  if (r = fmt.match(/^#{1,3},##0(\.?)$/))
    return sign + commaify("" + aval);
  if (r = fmt.match(/^#,##0\.([#0]*0)$/)) {
    return val < 0 ? "-" + write_num_int(type, fmt, -val) : commaify("" + val) + "." + fill("0", r[1].length);
  }
  if (r = fmt.match(/^#,#*,#0/))
    return write_num_int(type, fmt.replace(/^#,#*,/, ""), val);
  if (r = fmt.match(/^([0#]+)(\\?-([0#]+))+$/)) {
    o2 = _strrev(write_num_int(type, fmt.replace(/[\\-]/g, ""), val));
    ri = 0;
    return _strrev(_strrev(fmt.replace(/\\/g, "")).replace(/[0#]/g, function(x3) {
      return ri < o2.length ? o2.charAt(ri++) : x3 === "0" ? "0" : "";
    }));
  }
  if (fmt.match(phone)) {
    o2 = write_num_int(type, "##########", val);
    return "(" + o2.substr(0, 3) + ") " + o2.substr(3, 3) + "-" + o2.substr(6);
  }
  var oa = "";
  if (r = fmt.match(/^([#0?]+)( ?)\/( ?)([#0?]+)/)) {
    ri = Math.min(
      /*::String(*/
      r[4].length,
      7
    );
    ff = SSF_frac(aval, Math.pow(10, ri) - 1, false);
    o2 = "" + sign;
    oa = write_num(
      "n",
      /*::String(*/
      r[1],
      ff[1]
    );
    if (oa.charAt(oa.length - 1) == " ")
      oa = oa.substr(0, oa.length - 1) + "0";
    o2 += oa + /*::String(*/
    r[2] + "/" + /*::String(*/
    r[3];
    oa = rpad_(ff[2], ri);
    if (oa.length < r[4].length)
      oa = hashq(r[4].substr(r[4].length - oa.length)) + oa;
    o2 += oa;
    return o2;
  }
  if (r = fmt.match(/^# ([#0?]+)( ?)\/( ?)([#0?]+)/)) {
    ri = Math.min(Math.max(r[1].length, r[4].length), 7);
    ff = SSF_frac(aval, Math.pow(10, ri) - 1, true);
    return sign + (ff[0] || (ff[1] ? "" : "0")) + " " + (ff[1] ? pad_(ff[1], ri) + r[2] + "/" + r[3] + rpad_(ff[2], ri) : fill(" ", 2 * ri + 1 + r[2].length + r[3].length));
  }
  if (r = fmt.match(/^[#0?]+$/)) {
    o2 = "" + val;
    if (fmt.length <= o2.length)
      return o2;
    return hashq(fmt.substr(0, fmt.length - o2.length)) + o2;
  }
  if (r = fmt.match(/^([#0]+)\.([#0]+)$/)) {
    o2 = "" + val.toFixed(Math.min(r[2].length, 10)).replace(/([^0])0+$/, "$1");
    ri = o2.indexOf(".");
    var lres = fmt.indexOf(".") - ri, rres = fmt.length - o2.length - lres;
    return hashq(fmt.substr(0, lres) + o2 + fmt.substr(fmt.length - rres));
  }
  if (r = fmt.match(/^00,000\.([#0]*0)$/)) {
    return val < 0 ? "-" + write_num_int(type, fmt, -val) : commaify("" + val).replace(/^\d,\d{3}$/, "0$&").replace(/^\d*$/, function($$) {
      return "00," + ($$.length < 3 ? pad0(0, 3 - $$.length) : "") + $$;
    }) + "." + pad0(0, r[1].length);
  }
  switch (fmt) {
    case "###,###":
    case "##,###":
    case "#,###":
      var x2 = commaify("" + aval);
      return x2 !== "0" ? sign + x2 : "";
    default:
      if (fmt.match(/\.[0#?]*$/))
        return write_num_int(type, fmt.slice(0, fmt.lastIndexOf(".")), val) + hashq(fmt.slice(fmt.lastIndexOf(".")));
  }
  throw new Error("unsupported format |" + fmt + "|");
}
function write_num(type, fmt, val) {
  return (val | 0) === val ? write_num_int(type, fmt, val) : write_num_flt(type, fmt, val);
}
function SSF_split_fmt(fmt) {
  var out = [];
  var in_str = false;
  for (var i2 = 0, j2 = 0; i2 < fmt.length; ++i2)
    switch (
      /*cc=*/
      fmt.charCodeAt(i2)
    ) {
      case 34:
        in_str = !in_str;
        break;
      case 95:
      case 42:
      case 92:
        ++i2;
        break;
      case 59:
        out[out.length] = fmt.substr(j2, i2 - j2);
        j2 = i2 + 1;
    }
  out[out.length] = fmt.substr(j2);
  if (in_str === true)
    throw new Error("Format |" + fmt + "| unterminated string ");
  return out;
}
var SSF_abstime = /\[[HhMmSs\u0E0A\u0E19\u0E17]*\]/;
function fmt_is_date(fmt) {
  var i2 = 0, c2 = "", o2 = "";
  while (i2 < fmt.length) {
    switch (c2 = fmt.charAt(i2)) {
      case "G":
        if (SSF_isgeneral(fmt, i2))
          i2 += 6;
        i2++;
        break;
      case '"':
        for (
          ;
          /*cc=*/
          fmt.charCodeAt(++i2) !== 34 && i2 < fmt.length;
        ) {
        }
        ++i2;
        break;
      case "\\":
        i2 += 2;
        break;
      case "_":
        i2 += 2;
        break;
      case "@":
        ++i2;
        break;
      case "B":
      case "b":
        if (fmt.charAt(i2 + 1) === "1" || fmt.charAt(i2 + 1) === "2")
          return true;
      case "M":
      case "D":
      case "Y":
      case "H":
      case "S":
      case "E":
      case "m":
      case "d":
      case "y":
      case "h":
      case "s":
      case "e":
      case "g":
        return true;
      case "A":
      case "a":
      case "\u4E0A":
        if (fmt.substr(i2, 3).toUpperCase() === "A/P")
          return true;
        if (fmt.substr(i2, 5).toUpperCase() === "AM/PM")
          return true;
        if (fmt.substr(i2, 5).toUpperCase() === "\u4E0A\u5348/\u4E0B\u5348")
          return true;
        ++i2;
        break;
      case "[":
        o2 = c2;
        while (fmt.charAt(i2++) !== "]" && i2 < fmt.length)
          o2 += fmt.charAt(i2);
        if (o2.match(SSF_abstime))
          return true;
        break;
      case ".":
      case "0":
      case "#":
        while (i2 < fmt.length && ("0#?.,E+-%".indexOf(c2 = fmt.charAt(++i2)) > -1 || c2 == "\\" && fmt.charAt(i2 + 1) == "-" && "0#".indexOf(fmt.charAt(i2 + 2)) > -1)) {
        }
        break;
      case "?":
        while (fmt.charAt(++i2) === c2) {
        }
        break;
      case "*":
        ++i2;
        if (fmt.charAt(i2) == " " || fmt.charAt(i2) == "*")
          ++i2;
        break;
      case "(":
      case ")":
        ++i2;
        break;
      case "1":
      case "2":
      case "3":
      case "4":
      case "5":
      case "6":
      case "7":
      case "8":
      case "9":
        while (i2 < fmt.length && "0123456789".indexOf(fmt.charAt(++i2)) > -1) {
        }
        break;
      case " ":
        ++i2;
        break;
      default:
        ++i2;
        break;
    }
  }
  return false;
}
function eval_fmt(fmt, v2, opts, flen) {
  var out = [], o2 = "", i2 = 0, c2 = "", lst = "t", dt2, j2, cc;
  var hr = "H";
  while (i2 < fmt.length) {
    switch (c2 = fmt.charAt(i2)) {
      case "G":
        if (!SSF_isgeneral(fmt, i2))
          throw new Error("unrecognized character " + c2 + " in " + fmt);
        out[out.length] = { t: "G", v: "General" };
        i2 += 7;
        break;
      case '"':
        for (o2 = ""; (cc = fmt.charCodeAt(++i2)) !== 34 && i2 < fmt.length; )
          o2 += String.fromCharCode(cc);
        out[out.length] = { t: "t", v: o2 };
        ++i2;
        break;
      case "\\":
        var w2 = fmt.charAt(++i2), t2 = w2 === "(" || w2 === ")" ? w2 : "t";
        out[out.length] = { t: t2, v: w2 };
        ++i2;
        break;
      case "_":
        out[out.length] = { t: "t", v: " " };
        i2 += 2;
        break;
      case "@":
        out[out.length] = { t: "T", v: v2 };
        ++i2;
        break;
      case "B":
      case "b":
        if (fmt.charAt(i2 + 1) === "1" || fmt.charAt(i2 + 1) === "2") {
          if (dt2 == null) {
            dt2 = SSF_parse_date_code(v2, opts, fmt.charAt(i2 + 1) === "2");
            if (dt2 == null)
              return "";
          }
          out[out.length] = { t: "X", v: fmt.substr(i2, 2) };
          lst = c2;
          i2 += 2;
          break;
        }
      case "M":
      case "D":
      case "Y":
      case "H":
      case "S":
      case "E":
        c2 = c2.toLowerCase();
      case "m":
      case "d":
      case "y":
      case "h":
      case "s":
      case "e":
      case "g":
        if (v2 < 0)
          return "";
        if (dt2 == null) {
          dt2 = SSF_parse_date_code(v2, opts);
          if (dt2 == null)
            return "";
        }
        o2 = c2;
        while (++i2 < fmt.length && fmt.charAt(i2).toLowerCase() === c2)
          o2 += c2;
        if (c2 === "m" && lst.toLowerCase() === "h")
          c2 = "M";
        if (c2 === "h")
          c2 = hr;
        out[out.length] = { t: c2, v: o2 };
        lst = c2;
        break;
      case "A":
      case "a":
      case "\u4E0A":
        var q2 = { t: c2, v: c2 };
        if (dt2 == null)
          dt2 = SSF_parse_date_code(v2, opts);
        if (fmt.substr(i2, 3).toUpperCase() === "A/P") {
          if (dt2 != null)
            q2.v = dt2.H >= 12 ? "P" : "A";
          q2.t = "T";
          hr = "h";
          i2 += 3;
        } else if (fmt.substr(i2, 5).toUpperCase() === "AM/PM") {
          if (dt2 != null)
            q2.v = dt2.H >= 12 ? "PM" : "AM";
          q2.t = "T";
          i2 += 5;
          hr = "h";
        } else if (fmt.substr(i2, 5).toUpperCase() === "\u4E0A\u5348/\u4E0B\u5348") {
          if (dt2 != null)
            q2.v = dt2.H >= 12 ? "\u4E0B\u5348" : "\u4E0A\u5348";
          q2.t = "T";
          i2 += 5;
          hr = "h";
        } else {
          q2.t = "t";
          ++i2;
        }
        if (dt2 == null && q2.t === "T")
          return "";
        out[out.length] = q2;
        lst = c2;
        break;
      case "[":
        o2 = c2;
        while (fmt.charAt(i2++) !== "]" && i2 < fmt.length)
          o2 += fmt.charAt(i2);
        if (o2.slice(-1) !== "]")
          throw 'unterminated "[" block: |' + o2 + "|";
        if (o2.match(SSF_abstime)) {
          if (dt2 == null) {
            dt2 = SSF_parse_date_code(v2, opts);
            if (dt2 == null)
              return "";
          }
          out[out.length] = { t: "Z", v: o2.toLowerCase() };
          lst = o2.charAt(1);
        } else if (o2.indexOf("$") > -1) {
          o2 = (o2.match(/\$([^-\[\]]*)/) || [])[1] || "$";
          if (!fmt_is_date(fmt))
            out[out.length] = { t: "t", v: o2 };
        }
        break;
      case ".":
        if (dt2 != null) {
          o2 = c2;
          while (++i2 < fmt.length && (c2 = fmt.charAt(i2)) === "0")
            o2 += c2;
          out[out.length] = { t: "s", v: o2 };
          break;
        }
      case "0":
      case "#":
        o2 = c2;
        while (++i2 < fmt.length && "0#?.,E+-%".indexOf(c2 = fmt.charAt(i2)) > -1)
          o2 += c2;
        out[out.length] = { t: "n", v: o2 };
        break;
      case "?":
        o2 = c2;
        while (fmt.charAt(++i2) === c2)
          o2 += c2;
        out[out.length] = { t: c2, v: o2 };
        lst = c2;
        break;
      case "*":
        ++i2;
        if (fmt.charAt(i2) == " " || fmt.charAt(i2) == "*")
          ++i2;
        break;
      case "(":
      case ")":
        out[out.length] = { t: flen === 1 ? "t" : c2, v: c2 };
        ++i2;
        break;
      case "1":
      case "2":
      case "3":
      case "4":
      case "5":
      case "6":
      case "7":
      case "8":
      case "9":
        o2 = c2;
        while (i2 < fmt.length && "0123456789".indexOf(fmt.charAt(++i2)) > -1)
          o2 += fmt.charAt(i2);
        out[out.length] = { t: "D", v: o2 };
        break;
      case " ":
        out[out.length] = { t: c2, v: c2 };
        ++i2;
        break;
      case "$":
        out[out.length] = { t: "t", v: "$" };
        ++i2;
        break;
      default:
        if (",$-+/():!^&'~{}<>=\u20ACacfijklopqrtuvwxzP".indexOf(c2) === -1)
          throw new Error("unrecognized character " + c2 + " in " + fmt);
        out[out.length] = { t: "t", v: c2 };
        ++i2;
        break;
    }
  }
  var bt2 = 0, ss0 = 0, ssm;
  for (i2 = out.length - 1, lst = "t"; i2 >= 0; --i2) {
    switch (out[i2].t) {
      case "h":
      case "H":
        out[i2].t = hr;
        lst = "h";
        if (bt2 < 1)
          bt2 = 1;
        break;
      case "s":
        if (ssm = out[i2].v.match(/\.0+$/))
          ss0 = Math.max(ss0, ssm[0].length - 1);
        if (bt2 < 3)
          bt2 = 3;
      case "d":
      case "y":
      case "M":
      case "e":
        lst = out[i2].t;
        break;
      case "m":
        if (lst === "s") {
          out[i2].t = "M";
          if (bt2 < 2)
            bt2 = 2;
        }
        break;
      case "X":
        break;
      case "Z":
        if (bt2 < 1 && out[i2].v.match(/[Hh]/))
          bt2 = 1;
        if (bt2 < 2 && out[i2].v.match(/[Mm]/))
          bt2 = 2;
        if (bt2 < 3 && out[i2].v.match(/[Ss]/))
          bt2 = 3;
    }
  }
  switch (bt2) {
    case 0:
      break;
    case 1:
      if (dt2.u >= 0.5) {
        dt2.u = 0;
        ++dt2.S;
      }
      if (dt2.S >= 60) {
        dt2.S = 0;
        ++dt2.M;
      }
      if (dt2.M >= 60) {
        dt2.M = 0;
        ++dt2.H;
      }
      break;
    case 2:
      if (dt2.u >= 0.5) {
        dt2.u = 0;
        ++dt2.S;
      }
      if (dt2.S >= 60) {
        dt2.S = 0;
        ++dt2.M;
      }
      break;
  }
  var nstr = "", jj;
  for (i2 = 0; i2 < out.length; ++i2) {
    switch (out[i2].t) {
      case "t":
      case "T":
      case " ":
      case "D":
        break;
      case "X":
        out[i2].v = "";
        out[i2].t = ";";
        break;
      case "d":
      case "m":
      case "y":
      case "h":
      case "H":
      case "M":
      case "s":
      case "e":
      case "b":
      case "Z":
        out[i2].v = SSF_write_date(out[i2].t.charCodeAt(0), out[i2].v, dt2, ss0);
        out[i2].t = "t";
        break;
      case "n":
      case "?":
        jj = i2 + 1;
        while (out[jj] != null && ((c2 = out[jj].t) === "?" || c2 === "D" || (c2 === " " || c2 === "t") && out[jj + 1] != null && (out[jj + 1].t === "?" || out[jj + 1].t === "t" && out[jj + 1].v === "/") || out[i2].t === "(" && (c2 === " " || c2 === "n" || c2 === ")") || c2 === "t" && (out[jj].v === "/" || out[jj].v === " " && out[jj + 1] != null && out[jj + 1].t == "?"))) {
          out[i2].v += out[jj].v;
          out[jj] = { v: "", t: ";" };
          ++jj;
        }
        nstr += out[i2].v;
        i2 = jj - 1;
        break;
      case "G":
        out[i2].t = "t";
        out[i2].v = SSF_general(v2, opts);
        break;
    }
  }
  var vv = "", myv, ostr;
  if (nstr.length > 0) {
    if (nstr.charCodeAt(0) == 40) {
      myv = v2 < 0 && nstr.charCodeAt(0) === 45 ? -v2 : v2;
      ostr = write_num("n", nstr, myv);
    } else {
      myv = v2 < 0 && flen > 1 ? -v2 : v2;
      ostr = write_num("n", nstr, myv);
      if (myv < 0 && out[0] && out[0].t == "t") {
        ostr = ostr.substr(1);
        out[0].v = "-" + out[0].v;
      }
    }
    jj = ostr.length - 1;
    var decpt = out.length;
    for (i2 = 0; i2 < out.length; ++i2)
      if (out[i2] != null && out[i2].t != "t" && out[i2].v.indexOf(".") > -1) {
        decpt = i2;
        break;
      }
    var lasti = out.length;
    if (decpt === out.length && ostr.indexOf("E") === -1) {
      for (i2 = out.length - 1; i2 >= 0; --i2) {
        if (out[i2] == null || "n?".indexOf(out[i2].t) === -1)
          continue;
        if (jj >= out[i2].v.length - 1) {
          jj -= out[i2].v.length;
          out[i2].v = ostr.substr(jj + 1, out[i2].v.length);
        } else if (jj < 0)
          out[i2].v = "";
        else {
          out[i2].v = ostr.substr(0, jj + 1);
          jj = -1;
        }
        out[i2].t = "t";
        lasti = i2;
      }
      if (jj >= 0 && lasti < out.length)
        out[lasti].v = ostr.substr(0, jj + 1) + out[lasti].v;
    } else if (decpt !== out.length && ostr.indexOf("E") === -1) {
      jj = ostr.indexOf(".") - 1;
      for (i2 = decpt; i2 >= 0; --i2) {
        if (out[i2] == null || "n?".indexOf(out[i2].t) === -1)
          continue;
        j2 = out[i2].v.indexOf(".") > -1 && i2 === decpt ? out[i2].v.indexOf(".") - 1 : out[i2].v.length - 1;
        vv = out[i2].v.substr(j2 + 1);
        for (; j2 >= 0; --j2) {
          if (jj >= 0 && (out[i2].v.charAt(j2) === "0" || out[i2].v.charAt(j2) === "#"))
            vv = ostr.charAt(jj--) + vv;
        }
        out[i2].v = vv;
        out[i2].t = "t";
        lasti = i2;
      }
      if (jj >= 0 && lasti < out.length)
        out[lasti].v = ostr.substr(0, jj + 1) + out[lasti].v;
      jj = ostr.indexOf(".") + 1;
      for (i2 = decpt; i2 < out.length; ++i2) {
        if (out[i2] == null || "n?(".indexOf(out[i2].t) === -1 && i2 !== decpt)
          continue;
        j2 = out[i2].v.indexOf(".") > -1 && i2 === decpt ? out[i2].v.indexOf(".") + 1 : 0;
        vv = out[i2].v.substr(0, j2);
        for (; j2 < out[i2].v.length; ++j2) {
          if (jj < ostr.length)
            vv += ostr.charAt(jj++);
        }
        out[i2].v = vv;
        out[i2].t = "t";
        lasti = i2;
      }
    }
  }
  for (i2 = 0; i2 < out.length; ++i2)
    if (out[i2] != null && "n?".indexOf(out[i2].t) > -1) {
      myv = flen > 1 && v2 < 0 && i2 > 0 && out[i2 - 1].v === "-" ? -v2 : v2;
      out[i2].v = write_num(out[i2].t, out[i2].v, myv);
      out[i2].t = "t";
    }
  var retval = "";
  for (i2 = 0; i2 !== out.length; ++i2)
    if (out[i2] != null)
      retval += out[i2].v;
  return retval;
}
var cfregex2 = /\[(=|>[=]?|<[>=]?)(-?\d+(?:\.\d*)?)\]/;
function chkcond(v2, rr) {
  if (rr == null)
    return false;
  var thresh = parseFloat(rr[2]);
  switch (rr[1]) {
    case "=":
      if (v2 == thresh)
        return true;
      break;
    case ">":
      if (v2 > thresh)
        return true;
      break;
    case "<":
      if (v2 < thresh)
        return true;
      break;
    case "<>":
      if (v2 != thresh)
        return true;
      break;
    case ">=":
      if (v2 >= thresh)
        return true;
      break;
    case "<=":
      if (v2 <= thresh)
        return true;
      break;
  }
  return false;
}
function choose_fmt(f2, v2) {
  var fmt = SSF_split_fmt(f2);
  var l2 = fmt.length, lat = fmt[l2 - 1].indexOf("@");
  if (l2 < 4 && lat > -1)
    --l2;
  if (fmt.length > 4)
    throw new Error("cannot find right format for |" + fmt.join("|") + "|");
  if (typeof v2 !== "number")
    return [4, fmt.length === 4 || lat > -1 ? fmt[fmt.length - 1] : "@"];
  switch (fmt.length) {
    case 1:
      fmt = lat > -1 ? ["General", "General", "General", fmt[0]] : [fmt[0], fmt[0], fmt[0], "@"];
      break;
    case 2:
      fmt = lat > -1 ? [fmt[0], fmt[0], fmt[0], fmt[1]] : [fmt[0], fmt[1], fmt[0], "@"];
      break;
    case 3:
      fmt = lat > -1 ? [fmt[0], fmt[1], fmt[0], fmt[2]] : [fmt[0], fmt[1], fmt[2], "@"];
      break;
    case 4:
      break;
  }
  var ff = v2 > 0 ? fmt[0] : v2 < 0 ? fmt[1] : fmt[2];
  if (fmt[0].indexOf("[") === -1 && fmt[1].indexOf("[") === -1)
    return [l2, ff];
  if (fmt[0].match(/\[[=<>]/) != null || fmt[1].match(/\[[=<>]/) != null) {
    var m1 = fmt[0].match(cfregex2);
    var m2 = fmt[1].match(cfregex2);
    return chkcond(v2, m1) ? [l2, fmt[0]] : chkcond(v2, m2) ? [l2, fmt[1]] : [l2, fmt[m1 != null && m2 != null ? 2 : 1]];
  }
  return [l2, ff];
}
function SSF_format(fmt, v2, o2) {
  if (o2 == null)
    o2 = {};
  var sfmt = "";
  switch (typeof fmt) {
    case "string":
      if (fmt == "m/d/yy" && o2.dateNF)
        sfmt = o2.dateNF;
      else
        sfmt = fmt;
      break;
    case "number":
      if (fmt == 14 && o2.dateNF)
        sfmt = o2.dateNF;
      else
        sfmt = (o2.table != null ? o2.table : table_fmt)[fmt];
      if (sfmt == null)
        sfmt = o2.table && o2.table[SSF_default_map[fmt]] || table_fmt[SSF_default_map[fmt]];
      if (sfmt == null)
        sfmt = SSF_default_str[fmt] || "General";
      break;
  }
  if (SSF_isgeneral(sfmt, 0))
    return SSF_general(v2, o2);
  if (v2 instanceof Date)
    v2 = datenum_local(v2, o2.date1904);
  var f2 = choose_fmt(sfmt, v2);
  if (SSF_isgeneral(f2[1]))
    return SSF_general(v2, o2);
  if (v2 === true)
    v2 = "TRUE";
  else if (v2 === false)
    v2 = "FALSE";
  else if (v2 === "" || v2 == null)
    return "";
  return eval_fmt(f2[1], v2, o2, f2[0]);
}
function SSF_load(fmt, idx) {
  if (typeof idx != "number") {
    idx = +idx || -1;
    for (var i2 = 0; i2 < 392; ++i2) {
      if (table_fmt[i2] == void 0) {
        if (idx < 0)
          idx = i2;
        continue;
      }
      if (table_fmt[i2] == fmt) {
        idx = i2;
        break;
      }
    }
    if (idx < 0)
      idx = 391;
  }
  table_fmt[idx] = fmt;
  return idx;
}
function SSF_load_table(tbl) {
  for (var i2 = 0; i2 != 392; ++i2)
    if (tbl[i2] !== void 0)
      SSF_load(tbl[i2], i2);
}
function make_ssf() {
  table_fmt = SSF_init_table();
}
var SSFImplicit = {
  "5": '"$"#,##0_);\\("$"#,##0\\)',
  "6": '"$"#,##0_);[Red]\\("$"#,##0\\)',
  "7": '"$"#,##0.00_);\\("$"#,##0.00\\)',
  "8": '"$"#,##0.00_);[Red]\\("$"#,##0.00\\)',
  "23": "General",
  "24": "General",
  "25": "General",
  "26": "General",
  "27": "m/d/yy",
  "28": "m/d/yy",
  "29": "m/d/yy",
  "30": "m/d/yy",
  "31": "m/d/yy",
  "32": "h:mm:ss",
  "33": "h:mm:ss",
  "34": "h:mm:ss",
  "35": "h:mm:ss",
  "36": "m/d/yy",
  "41": '_(* #,##0_);_(* (#,##0);_(* "-"_);_(@_)',
  "42": '_("$"* #,##0_);_("$"* (#,##0);_("$"* "-"_);_(@_)',
  "43": '_(* #,##0.00_);_(* (#,##0.00);_(* "-"??_);_(@_)',
  "44": '_("$"* #,##0.00_);_("$"* (#,##0.00);_("$"* "-"??_);_(@_)',
  "50": "m/d/yy",
  "51": "m/d/yy",
  "52": "m/d/yy",
  "53": "m/d/yy",
  "54": "m/d/yy",
  "55": "m/d/yy",
  "56": "m/d/yy",
  "57": "m/d/yy",
  "58": "m/d/yy",
  "59": "0",
  "60": "0.00",
  "61": "#,##0",
  "62": "#,##0.00",
  "63": '"$"#,##0_);\\("$"#,##0\\)',
  "64": '"$"#,##0_);[Red]\\("$"#,##0\\)',
  "65": '"$"#,##0.00_);\\("$"#,##0.00\\)',
  "66": '"$"#,##0.00_);[Red]\\("$"#,##0.00\\)',
  "67": "0%",
  "68": "0.00%",
  "69": "# ?/?",
  "70": "# ??/??",
  "71": "m/d/yy",
  "72": "m/d/yy",
  "73": "d-mmm-yy",
  "74": "d-mmm",
  "75": "mmm-yy",
  "76": "h:mm",
  "77": "h:mm:ss",
  "78": "m/d/yy h:mm",
  "79": "mm:ss",
  "80": "[h]:mm:ss",
  "81": "mmss.0"
};
var dateNFregex = /[dD]+|[mM]+|[yYeE]+|[Hh]+|[Ss]+/g;
function dateNF_regex(dateNF) {
  var fmt = typeof dateNF == "number" ? table_fmt[dateNF] : dateNF;
  fmt = fmt.replace(dateNFregex, "(\\d+)");
  return new RegExp("^" + fmt + "$");
}
function dateNF_fix(str, dateNF, match) {
  var Y2 = -1, m2 = -1, d2 = -1, H2 = -1, M2 = -1, S2 = -1;
  (dateNF.match(dateNFregex) || []).forEach(function(n2, i2) {
    var v2 = parseInt(match[i2 + 1], 10);
    switch (n2.toLowerCase().charAt(0)) {
      case "y":
        Y2 = v2;
        break;
      case "d":
        d2 = v2;
        break;
      case "h":
        H2 = v2;
        break;
      case "s":
        S2 = v2;
        break;
      case "m":
        if (H2 >= 0)
          M2 = v2;
        else
          m2 = v2;
        break;
    }
  });
  if (S2 >= 0 && M2 == -1 && m2 >= 0) {
    M2 = m2;
    m2 = -1;
  }
  var datestr = ("" + (Y2 >= 0 ? Y2 : (/* @__PURE__ */ new Date()).getFullYear())).slice(-4) + "-" + ("00" + (m2 >= 1 ? m2 : 1)).slice(-2) + "-" + ("00" + (d2 >= 1 ? d2 : 1)).slice(-2);
  if (datestr.length == 7)
    datestr = "0" + datestr;
  if (datestr.length == 8)
    datestr = "20" + datestr;
  var timestr = ("00" + (H2 >= 0 ? H2 : 0)).slice(-2) + ":" + ("00" + (M2 >= 0 ? M2 : 0)).slice(-2) + ":" + ("00" + (S2 >= 0 ? S2 : 0)).slice(-2);
  if (H2 == -1 && M2 == -1 && S2 == -1)
    return datestr;
  if (Y2 == -1 && m2 == -1 && d2 == -1)
    return timestr;
  return datestr + "T" + timestr;
}
var CRC32 = /* @__PURE__ */ function() {
  var CRC322 = {};
  CRC322.version = "1.2.0";
  function signed_crc_table() {
    var c2 = 0, table = new Array(256);
    for (var n2 = 0; n2 != 256; ++n2) {
      c2 = n2;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      c2 = c2 & 1 ? -306674912 ^ c2 >>> 1 : c2 >>> 1;
      table[n2] = c2;
    }
    return typeof Int32Array !== "undefined" ? new Int32Array(table) : table;
  }
  var T0 = signed_crc_table();
  function slice_by_16_tables(T10) {
    var c2 = 0, v2 = 0, n2 = 0, table = typeof Int32Array !== "undefined" ? new Int32Array(4096) : new Array(4096);
    for (n2 = 0; n2 != 256; ++n2)
      table[n2] = T10[n2];
    for (n2 = 0; n2 != 256; ++n2) {
      v2 = T10[n2];
      for (c2 = 256 + n2; c2 < 4096; c2 += 256)
        v2 = table[c2] = v2 >>> 8 ^ T10[v2 & 255];
    }
    var out = [];
    for (n2 = 1; n2 != 16; ++n2)
      out[n2 - 1] = typeof Int32Array !== "undefined" ? table.subarray(n2 * 256, n2 * 256 + 256) : table.slice(n2 * 256, n2 * 256 + 256);
    return out;
  }
  var TT = slice_by_16_tables(T0);
  var T1 = TT[0], T2 = TT[1], T3 = TT[2], T4 = TT[3], T5 = TT[4];
  var T6 = TT[5], T7 = TT[6], T8 = TT[7], T9 = TT[8], Ta = TT[9];
  var Tb = TT[10], Tc = TT[11], Td = TT[12], Te = TT[13], Tf = TT[14];
  function crc32_bstr(bstr, seed) {
    var C2 = seed ^ -1;
    for (var i2 = 0, L2 = bstr.length; i2 < L2; )
      C2 = C2 >>> 8 ^ T0[(C2 ^ bstr.charCodeAt(i2++)) & 255];
    return ~C2;
  }
  function crc32_buf(B2, seed) {
    var C2 = seed ^ -1, L2 = B2.length - 15, i2 = 0;
    for (; i2 < L2; )
      C2 = Tf[B2[i2++] ^ C2 & 255] ^ Te[B2[i2++] ^ C2 >> 8 & 255] ^ Td[B2[i2++] ^ C2 >> 16 & 255] ^ Tc[B2[i2++] ^ C2 >>> 24] ^ Tb[B2[i2++]] ^ Ta[B2[i2++]] ^ T9[B2[i2++]] ^ T8[B2[i2++]] ^ T7[B2[i2++]] ^ T6[B2[i2++]] ^ T5[B2[i2++]] ^ T4[B2[i2++]] ^ T3[B2[i2++]] ^ T2[B2[i2++]] ^ T1[B2[i2++]] ^ T0[B2[i2++]];
    L2 += 15;
    while (i2 < L2)
      C2 = C2 >>> 8 ^ T0[(C2 ^ B2[i2++]) & 255];
    return ~C2;
  }
  function crc32_str(str, seed) {
    var C2 = seed ^ -1;
    for (var i2 = 0, L2 = str.length, c2 = 0, d2 = 0; i2 < L2; ) {
      c2 = str.charCodeAt(i2++);
      if (c2 < 128) {
        C2 = C2 >>> 8 ^ T0[(C2 ^ c2) & 255];
      } else if (c2 < 2048) {
        C2 = C2 >>> 8 ^ T0[(C2 ^ (192 | c2 >> 6 & 31)) & 255];
        C2 = C2 >>> 8 ^ T0[(C2 ^ (128 | c2 & 63)) & 255];
      } else if (c2 >= 55296 && c2 < 57344) {
        c2 = (c2 & 1023) + 64;
        d2 = str.charCodeAt(i2++) & 1023;
        C2 = C2 >>> 8 ^ T0[(C2 ^ (240 | c2 >> 8 & 7)) & 255];
        C2 = C2 >>> 8 ^ T0[(C2 ^ (128 | c2 >> 2 & 63)) & 255];
        C2 = C2 >>> 8 ^ T0[(C2 ^ (128 | d2 >> 6 & 15 | (c2 & 3) << 4)) & 255];
        C2 = C2 >>> 8 ^ T0[(C2 ^ (128 | d2 & 63)) & 255];
      } else {
        C2 = C2 >>> 8 ^ T0[(C2 ^ (224 | c2 >> 12 & 15)) & 255];
        C2 = C2 >>> 8 ^ T0[(C2 ^ (128 | c2 >> 6 & 63)) & 255];
        C2 = C2 >>> 8 ^ T0[(C2 ^ (128 | c2 & 63)) & 255];
      }
    }
    return ~C2;
  }
  CRC322.table = T0;
  CRC322.bstr = crc32_bstr;
  CRC322.buf = crc32_buf;
  CRC322.str = crc32_str;
  return CRC322;
}();
var CFB = /* @__PURE__ */ function _CFB() {
  var exports = {};
  exports.version = "1.2.1";
  function namecmp(l2, r) {
    var L2 = l2.split("/"), R2 = r.split("/");
    for (var i3 = 0, c2 = 0, Z2 = Math.min(L2.length, R2.length); i3 < Z2; ++i3) {
      if (c2 = L2[i3].length - R2[i3].length)
        return c2;
      if (L2[i3] != R2[i3])
        return L2[i3] < R2[i3] ? -1 : 1;
    }
    return L2.length - R2.length;
  }
  function dirname(p2) {
    if (p2.charAt(p2.length - 1) == "/")
      return p2.slice(0, -1).indexOf("/") === -1 ? p2 : dirname(p2.slice(0, -1));
    var c2 = p2.lastIndexOf("/");
    return c2 === -1 ? p2 : p2.slice(0, c2 + 1);
  }
  function filename(p2) {
    if (p2.charAt(p2.length - 1) == "/")
      return filename(p2.slice(0, -1));
    var c2 = p2.lastIndexOf("/");
    return c2 === -1 ? p2 : p2.slice(c2 + 1);
  }
  function write_dos_date(buf, date) {
    if (typeof date === "string")
      date = new Date(date);
    var hms = date.getHours();
    hms = hms << 6 | date.getMinutes();
    hms = hms << 5 | date.getSeconds() >>> 1;
    buf.write_shift(2, hms);
    var ymd = date.getFullYear() - 1980;
    ymd = ymd << 4 | date.getMonth() + 1;
    ymd = ymd << 5 | date.getDate();
    buf.write_shift(2, ymd);
  }
  function parse_dos_date(buf) {
    var hms = buf.read_shift(2) & 65535;
    var ymd = buf.read_shift(2) & 65535;
    var val = /* @__PURE__ */ new Date();
    var d2 = ymd & 31;
    ymd >>>= 5;
    var m2 = ymd & 15;
    ymd >>>= 4;
    val.setMilliseconds(0);
    val.setFullYear(ymd + 1980);
    val.setMonth(m2 - 1);
    val.setDate(d2);
    var S2 = hms & 31;
    hms >>>= 5;
    var M2 = hms & 63;
    hms >>>= 6;
    val.setHours(hms);
    val.setMinutes(M2);
    val.setSeconds(S2 << 1);
    return val;
  }
  function parse_extra_field(blob) {
    prep_blob(blob, 0);
    var o2 = (
      /*::(*/
      {}
    );
    var flags = 0;
    while (blob.l <= blob.length - 4) {
      var type = blob.read_shift(2);
      var sz = blob.read_shift(2), tgt = blob.l + sz;
      var p2 = {};
      switch (type) {
        case 21589:
          {
            flags = blob.read_shift(1);
            if (flags & 1)
              p2.mtime = blob.read_shift(4);
            if (sz > 5) {
              if (flags & 2)
                p2.atime = blob.read_shift(4);
              if (flags & 4)
                p2.ctime = blob.read_shift(4);
            }
            if (p2.mtime)
              p2.mt = new Date(p2.mtime * 1e3);
          }
          break;
      }
      blob.l = tgt;
      o2[type] = p2;
    }
    return o2;
  }
  var fs;
  function get_fs() {
    return fs || (fs = {});
  }
  function parse(file, options) {
    if (file[0] == 80 && file[1] == 75)
      return parse_zip2(file, options);
    if ((file[0] | 32) == 109 && (file[1] | 32) == 105)
      return parse_mad(file, options);
    if (file.length < 512)
      throw new Error("CFB file size " + file.length + " < 512");
    var mver = 3;
    var ssz = 512;
    var nmfs = 0;
    var difat_sec_cnt = 0;
    var dir_start = 0;
    var minifat_start = 0;
    var difat_start = 0;
    var fat_addrs = [];
    var blob = (
      /*::(*/
      file.slice(0, 512)
    );
    prep_blob(blob, 0);
    var mv = check_get_mver(blob);
    mver = mv[0];
    switch (mver) {
      case 3:
        ssz = 512;
        break;
      case 4:
        ssz = 4096;
        break;
      case 0:
        if (mv[1] == 0)
          return parse_zip2(file, options);
      default:
        throw new Error("Major Version: Expected 3 or 4 saw " + mver);
    }
    if (ssz !== 512) {
      blob = /*::(*/
      file.slice(0, ssz);
      prep_blob(
        blob,
        28
        /* blob.l */
      );
    }
    var header = file.slice(0, ssz);
    check_shifts(blob, mver);
    var dir_cnt = blob.read_shift(4, "i");
    if (mver === 3 && dir_cnt !== 0)
      throw new Error("# Directory Sectors: Expected 0 saw " + dir_cnt);
    blob.l += 4;
    dir_start = blob.read_shift(4, "i");
    blob.l += 4;
    blob.chk("00100000", "Mini Stream Cutoff Size: ");
    minifat_start = blob.read_shift(4, "i");
    nmfs = blob.read_shift(4, "i");
    difat_start = blob.read_shift(4, "i");
    difat_sec_cnt = blob.read_shift(4, "i");
    for (var q3 = -1, j2 = 0; j2 < 109; ++j2) {
      q3 = blob.read_shift(4, "i");
      if (q3 < 0)
        break;
      fat_addrs[j2] = q3;
    }
    var sectors = sectorify(file, ssz);
    sleuth_fat(difat_start, difat_sec_cnt, sectors, ssz, fat_addrs);
    var sector_list = make_sector_list(sectors, dir_start, fat_addrs, ssz);
    sector_list[dir_start].name = "!Directory";
    if (nmfs > 0 && minifat_start !== ENDOFCHAIN)
      sector_list[minifat_start].name = "!MiniFAT";
    sector_list[fat_addrs[0]].name = "!FAT";
    sector_list.fat_addrs = fat_addrs;
    sector_list.ssz = ssz;
    var files = {}, Paths = [], FileIndex = [], FullPaths = [];
    read_directory(dir_start, sector_list, sectors, Paths, nmfs, files, FileIndex, minifat_start);
    build_full_paths(FileIndex, FullPaths, Paths);
    Paths.shift();
    var o2 = {
      FileIndex,
      FullPaths
    };
    if (options && options.raw)
      o2.raw = { header, sectors };
    return o2;
  }
  function check_get_mver(blob) {
    if (blob[blob.l] == 80 && blob[blob.l + 1] == 75)
      return [0, 0];
    blob.chk(HEADER_SIGNATURE, "Header Signature: ");
    blob.l += 16;
    var mver = blob.read_shift(2, "u");
    return [blob.read_shift(2, "u"), mver];
  }
  function check_shifts(blob, mver) {
    var shift = 9;
    blob.l += 2;
    switch (shift = blob.read_shift(2)) {
      case 9:
        if (mver != 3)
          throw new Error("Sector Shift: Expected 9 saw " + shift);
        break;
      case 12:
        if (mver != 4)
          throw new Error("Sector Shift: Expected 12 saw " + shift);
        break;
      default:
        throw new Error("Sector Shift: Expected 9 or 12 saw " + shift);
    }
    blob.chk("0600", "Mini Sector Shift: ");
    blob.chk("000000000000", "Reserved: ");
  }
  function sectorify(file, ssz) {
    var nsectors = Math.ceil(file.length / ssz) - 1;
    var sectors = [];
    for (var i3 = 1; i3 < nsectors; ++i3)
      sectors[i3 - 1] = file.slice(i3 * ssz, (i3 + 1) * ssz);
    sectors[nsectors - 1] = file.slice(nsectors * ssz);
    return sectors;
  }
  function build_full_paths(FI, FP, Paths) {
    var i3 = 0, L2 = 0, R2 = 0, C2 = 0, j2 = 0, pl = Paths.length;
    var dad = [], q3 = [];
    for (; i3 < pl; ++i3) {
      dad[i3] = q3[i3] = i3;
      FP[i3] = Paths[i3];
    }
    for (; j2 < q3.length; ++j2) {
      i3 = q3[j2];
      L2 = FI[i3].L;
      R2 = FI[i3].R;
      C2 = FI[i3].C;
      if (dad[i3] === i3) {
        if (L2 !== -1 && dad[L2] !== L2)
          dad[i3] = dad[L2];
        if (R2 !== -1 && dad[R2] !== R2)
          dad[i3] = dad[R2];
      }
      if (C2 !== -1)
        dad[C2] = i3;
      if (L2 !== -1 && i3 != dad[i3]) {
        dad[L2] = dad[i3];
        if (q3.lastIndexOf(L2) < j2)
          q3.push(L2);
      }
      if (R2 !== -1 && i3 != dad[i3]) {
        dad[R2] = dad[i3];
        if (q3.lastIndexOf(R2) < j2)
          q3.push(R2);
      }
    }
    for (i3 = 1; i3 < pl; ++i3)
      if (dad[i3] === i3) {
        if (R2 !== -1 && dad[R2] !== R2)
          dad[i3] = dad[R2];
        else if (L2 !== -1 && dad[L2] !== L2)
          dad[i3] = dad[L2];
      }
    for (i3 = 1; i3 < pl; ++i3) {
      if (FI[i3].type === 0)
        continue;
      j2 = i3;
      if (j2 != dad[j2])
        do {
          j2 = dad[j2];
          FP[i3] = FP[j2] + "/" + FP[i3];
        } while (j2 !== 0 && -1 !== dad[j2] && j2 != dad[j2]);
      dad[i3] = -1;
    }
    FP[0] += "/";
    for (i3 = 1; i3 < pl; ++i3) {
      if (FI[i3].type !== 2)
        FP[i3] += "/";
    }
  }
  function get_mfat_entry(entry, payload, mini) {
    var start = entry.start, size = entry.size;
    var o2 = [];
    var idx = start;
    while (mini && size > 0 && idx >= 0) {
      o2.push(payload.slice(idx * MSSZ, idx * MSSZ + MSSZ));
      size -= MSSZ;
      idx = __readInt32LE(mini, idx * 4);
    }
    if (o2.length === 0)
      return new_buf(0);
    return bconcat(o2).slice(0, entry.size);
  }
  function sleuth_fat(idx, cnt, sectors, ssz, fat_addrs) {
    var q3 = ENDOFCHAIN;
    if (idx === ENDOFCHAIN) {
      if (cnt !== 0)
        throw new Error("DIFAT chain shorter than expected");
    } else if (idx !== -1) {
      var sector = sectors[idx], m2 = (ssz >>> 2) - 1;
      if (!sector)
        return;
      for (var i3 = 0; i3 < m2; ++i3) {
        if ((q3 = __readInt32LE(sector, i3 * 4)) === ENDOFCHAIN)
          break;
        fat_addrs.push(q3);
      }
      sleuth_fat(__readInt32LE(sector, ssz - 4), cnt - 1, sectors, ssz, fat_addrs);
    }
  }
  function get_sector_list(sectors, start, fat_addrs, ssz, chkd) {
    var buf = [], buf_chain = [];
    if (!chkd)
      chkd = [];
    var modulus = ssz - 1, j2 = 0, jj = 0;
    for (j2 = start; j2 >= 0; ) {
      chkd[j2] = true;
      buf[buf.length] = j2;
      buf_chain.push(sectors[j2]);
      var addr = fat_addrs[Math.floor(j2 * 4 / ssz)];
      jj = j2 * 4 & modulus;
      if (ssz < 4 + jj)
        throw new Error("FAT boundary crossed: " + j2 + " 4 " + ssz);
      if (!sectors[addr])
        break;
      j2 = __readInt32LE(sectors[addr], jj);
    }
    return { nodes: buf, data: __toBuffer([buf_chain]) };
  }
  function make_sector_list(sectors, dir_start, fat_addrs, ssz) {
    var sl = sectors.length, sector_list = [];
    var chkd = [], buf = [], buf_chain = [];
    var modulus = ssz - 1, i3 = 0, j2 = 0, k2 = 0, jj = 0;
    for (i3 = 0; i3 < sl; ++i3) {
      buf = [];
      k2 = i3 + dir_start;
      if (k2 >= sl)
        k2 -= sl;
      if (chkd[k2])
        continue;
      buf_chain = [];
      var seen = [];
      for (j2 = k2; j2 >= 0; ) {
        seen[j2] = true;
        chkd[j2] = true;
        buf[buf.length] = j2;
        buf_chain.push(sectors[j2]);
        var addr = fat_addrs[Math.floor(j2 * 4 / ssz)];
        jj = j2 * 4 & modulus;
        if (ssz < 4 + jj)
          throw new Error("FAT boundary crossed: " + j2 + " 4 " + ssz);
        if (!sectors[addr])
          break;
        j2 = __readInt32LE(sectors[addr], jj);
        if (seen[j2])
          break;
      }
      sector_list[k2] = { nodes: buf, data: __toBuffer([buf_chain]) };
    }
    return sector_list;
  }
  function read_directory(dir_start, sector_list, sectors, Paths, nmfs, files, FileIndex, mini) {
    var minifat_store = 0, pl = Paths.length ? 2 : 0;
    var sector = sector_list[dir_start].data;
    var i3 = 0, namelen = 0, name;
    for (; i3 < sector.length; i3 += 128) {
      var blob = (
        /*::(*/
        sector.slice(i3, i3 + 128)
      );
      prep_blob(blob, 64);
      namelen = blob.read_shift(2);
      name = __utf16le(blob, 0, namelen - pl);
      Paths.push(name);
      var o2 = {
        name,
        type: blob.read_shift(1),
        color: blob.read_shift(1),
        L: blob.read_shift(4, "i"),
        R: blob.read_shift(4, "i"),
        C: blob.read_shift(4, "i"),
        clsid: blob.read_shift(16),
        state: blob.read_shift(4, "i"),
        start: 0,
        size: 0
      };
      var ctime = blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2);
      if (ctime !== 0)
        o2.ct = read_date(blob, blob.l - 8);
      var mtime = blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2) + blob.read_shift(2);
      if (mtime !== 0)
        o2.mt = read_date(blob, blob.l - 8);
      o2.start = blob.read_shift(4, "i");
      o2.size = blob.read_shift(4, "i");
      if (o2.size < 0 && o2.start < 0) {
        o2.size = o2.type = 0;
        o2.start = ENDOFCHAIN;
        o2.name = "";
      }
      if (o2.type === 5) {
        minifat_store = o2.start;
        if (nmfs > 0 && minifat_store !== ENDOFCHAIN)
          sector_list[minifat_store].name = "!StreamData";
      } else if (o2.size >= 4096) {
        o2.storage = "fat";
        if (sector_list[o2.start] === void 0)
          sector_list[o2.start] = get_sector_list(sectors, o2.start, sector_list.fat_addrs, sector_list.ssz);
        sector_list[o2.start].name = o2.name;
        o2.content = sector_list[o2.start].data.slice(0, o2.size);
      } else {
        o2.storage = "minifat";
        if (o2.size < 0)
          o2.size = 0;
        else if (minifat_store !== ENDOFCHAIN && o2.start !== ENDOFCHAIN && sector_list[minifat_store]) {
          o2.content = get_mfat_entry(o2, sector_list[minifat_store].data, (sector_list[mini] || {}).data);
        }
      }
      if (o2.content)
        prep_blob(o2.content, 0);
      files[name] = o2;
      FileIndex.push(o2);
    }
  }
  function read_date(blob, offset) {
    return new Date((__readUInt32LE(blob, offset + 4) / 1e7 * Math.pow(2, 32) + __readUInt32LE(blob, offset) / 1e7 - 11644473600) * 1e3);
  }
  function read_file(filename2, options) {
    get_fs();
    return parse(fs.readFileSync(filename2), options);
  }
  function read(blob, options) {
    var type = options && options.type;
    if (!type) {
      if (has_buf && Buffer.isBuffer(blob))
        type = "buffer";
    }
    switch (type || "base64") {
      case "file":
        return read_file(blob, options);
      case "base64":
        return parse(s2a(Base64_decode(blob)), options);
      case "binary":
        return parse(s2a(blob), options);
    }
    return parse(
      /*::typeof blob == 'string' ? new Buffer(blob, 'utf-8') : */
      blob,
      options
    );
  }
  function init_cfb(cfb, opts) {
    var o2 = opts || {}, root = o2.root || "Root Entry";
    if (!cfb.FullPaths)
      cfb.FullPaths = [];
    if (!cfb.FileIndex)
      cfb.FileIndex = [];
    if (cfb.FullPaths.length !== cfb.FileIndex.length)
      throw new Error("inconsistent CFB structure");
    if (cfb.FullPaths.length === 0) {
      cfb.FullPaths[0] = root + "/";
      cfb.FileIndex[0] = { name: root, type: 5 };
    }
    if (o2.CLSID)
      cfb.FileIndex[0].clsid = o2.CLSID;
    seed_cfb(cfb);
  }
  function seed_cfb(cfb) {
    var nm = "Sh33tJ5";
    if (CFB.find(cfb, "/" + nm))
      return;
    var p2 = new_buf(4);
    p2[0] = 55;
    p2[1] = p2[3] = 50;
    p2[2] = 54;
    cfb.FileIndex.push({ name: nm, type: 2, content: p2, size: 4, L: 69, R: 69, C: 69 });
    cfb.FullPaths.push(cfb.FullPaths[0] + nm);
    rebuild_cfb(cfb);
  }
  function rebuild_cfb(cfb, f2) {
    init_cfb(cfb);
    var gc = false, s2 = false;
    for (var i3 = cfb.FullPaths.length - 1; i3 >= 0; --i3) {
      var _file = cfb.FileIndex[i3];
      switch (_file.type) {
        case 0:
          if (s2)
            gc = true;
          else {
            cfb.FileIndex.pop();
            cfb.FullPaths.pop();
          }
          break;
        case 1:
        case 2:
        case 5:
          s2 = true;
          if (isNaN(_file.R * _file.L * _file.C))
            gc = true;
          if (_file.R > -1 && _file.L > -1 && _file.R == _file.L)
            gc = true;
          break;
        default:
          gc = true;
          break;
      }
    }
    if (!gc && !f2)
      return;
    var now = new Date(1987, 1, 19), j2 = 0;
    var fullPaths = Object.create ? /* @__PURE__ */ Object.create(null) : {};
    var data = [];
    for (i3 = 0; i3 < cfb.FullPaths.length; ++i3) {
      fullPaths[cfb.FullPaths[i3]] = true;
      if (cfb.FileIndex[i3].type === 0)
        continue;
      data.push([cfb.FullPaths[i3], cfb.FileIndex[i3]]);
    }
    for (i3 = 0; i3 < data.length; ++i3) {
      var dad = dirname(data[i3][0]);
      s2 = fullPaths[dad];
      if (!s2) {
        data.push([dad, {
          name: filename(dad).replace("/", ""),
          type: 1,
          clsid: HEADER_CLSID,
          ct: now,
          mt: now,
          content: null
        }]);
        fullPaths[dad] = true;
      }
    }
    data.sort(function(x2, y2) {
      return namecmp(x2[0], y2[0]);
    });
    cfb.FullPaths = [];
    cfb.FileIndex = [];
    for (i3 = 0; i3 < data.length; ++i3) {
      cfb.FullPaths[i3] = data[i3][0];
      cfb.FileIndex[i3] = data[i3][1];
    }
    for (i3 = 0; i3 < data.length; ++i3) {
      var elt = cfb.FileIndex[i3];
      var nm = cfb.FullPaths[i3];
      elt.name = filename(nm).replace("/", "");
      elt.L = elt.R = elt.C = -(elt.color = 1);
      elt.size = elt.content ? elt.content.length : 0;
      elt.start = 0;
      elt.clsid = elt.clsid || HEADER_CLSID;
      if (i3 === 0) {
        elt.C = data.length > 1 ? 1 : -1;
        elt.size = 0;
        elt.type = 5;
      } else if (nm.slice(-1) == "/") {
        for (j2 = i3 + 1; j2 < data.length; ++j2)
          if (dirname(cfb.FullPaths[j2]) == nm)
            break;
        elt.C = j2 >= data.length ? -1 : j2;
        for (j2 = i3 + 1; j2 < data.length; ++j2)
          if (dirname(cfb.FullPaths[j2]) == dirname(nm))
            break;
        elt.R = j2 >= data.length ? -1 : j2;
        elt.type = 1;
      } else {
        if (dirname(cfb.FullPaths[i3 + 1] || "") == dirname(nm))
          elt.R = i3 + 1;
        elt.type = 2;
      }
    }
  }
  function _write(cfb, options) {
    var _opts = options || {};
    if (_opts.fileType == "mad")
      return write_mad(cfb, _opts);
    rebuild_cfb(cfb);
    switch (_opts.fileType) {
      case "zip":
        return write_zip2(cfb, _opts);
    }
    var L2 = function(cfb2) {
      var mini_size = 0, fat_size = 0;
      for (var i4 = 0; i4 < cfb2.FileIndex.length; ++i4) {
        var file2 = cfb2.FileIndex[i4];
        if (!file2.content)
          continue;
        var flen2 = file2.content.length;
        if (flen2 > 0) {
          if (flen2 < 4096)
            mini_size += flen2 + 63 >> 6;
          else
            fat_size += flen2 + 511 >> 9;
        }
      }
      var dir_cnt = cfb2.FullPaths.length + 3 >> 2;
      var mini_cnt = mini_size + 7 >> 3;
      var mfat_cnt = mini_size + 127 >> 7;
      var fat_base = mini_cnt + fat_size + dir_cnt + mfat_cnt;
      var fat_cnt = fat_base + 127 >> 7;
      var difat_cnt = fat_cnt <= 109 ? 0 : Math.ceil((fat_cnt - 109) / 127);
      while (fat_base + fat_cnt + difat_cnt + 127 >> 7 > fat_cnt)
        difat_cnt = ++fat_cnt <= 109 ? 0 : Math.ceil((fat_cnt - 109) / 127);
      var L3 = [1, difat_cnt, fat_cnt, mfat_cnt, dir_cnt, fat_size, mini_size, 0];
      cfb2.FileIndex[0].size = mini_size << 6;
      L3[7] = (cfb2.FileIndex[0].start = L3[0] + L3[1] + L3[2] + L3[3] + L3[4] + L3[5]) + (L3[6] + 7 >> 3);
      return L3;
    }(cfb);
    var o2 = new_buf(L2[7] << 9);
    var i3 = 0, T2 = 0;
    {
      for (i3 = 0; i3 < 8; ++i3)
        o2.write_shift(1, HEADER_SIG[i3]);
      for (i3 = 0; i3 < 8; ++i3)
        o2.write_shift(2, 0);
      o2.write_shift(2, 62);
      o2.write_shift(2, 3);
      o2.write_shift(2, 65534);
      o2.write_shift(2, 9);
      o2.write_shift(2, 6);
      for (i3 = 0; i3 < 3; ++i3)
        o2.write_shift(2, 0);
      o2.write_shift(4, 0);
      o2.write_shift(4, L2[2]);
      o2.write_shift(4, L2[0] + L2[1] + L2[2] + L2[3] - 1);
      o2.write_shift(4, 0);
      o2.write_shift(4, 1 << 12);
      o2.write_shift(4, L2[3] ? L2[0] + L2[1] + L2[2] - 1 : ENDOFCHAIN);
      o2.write_shift(4, L2[3]);
      o2.write_shift(-4, L2[1] ? L2[0] - 1 : ENDOFCHAIN);
      o2.write_shift(4, L2[1]);
      for (i3 = 0; i3 < 109; ++i3)
        o2.write_shift(-4, i3 < L2[2] ? L2[1] + i3 : -1);
    }
    if (L2[1]) {
      for (T2 = 0; T2 < L2[1]; ++T2) {
        for (; i3 < 236 + T2 * 127; ++i3)
          o2.write_shift(-4, i3 < L2[2] ? L2[1] + i3 : -1);
        o2.write_shift(-4, T2 === L2[1] - 1 ? ENDOFCHAIN : T2 + 1);
      }
    }
    var chainit = function(w2) {
      for (T2 += w2; i3 < T2 - 1; ++i3)
        o2.write_shift(-4, i3 + 1);
      if (w2) {
        ++i3;
        o2.write_shift(-4, ENDOFCHAIN);
      }
    };
    T2 = i3 = 0;
    for (T2 += L2[1]; i3 < T2; ++i3)
      o2.write_shift(-4, consts.DIFSECT);
    for (T2 += L2[2]; i3 < T2; ++i3)
      o2.write_shift(-4, consts.FATSECT);
    chainit(L2[3]);
    chainit(L2[4]);
    var j2 = 0, flen = 0;
    var file = cfb.FileIndex[0];
    for (; j2 < cfb.FileIndex.length; ++j2) {
      file = cfb.FileIndex[j2];
      if (!file.content)
        continue;
      flen = file.content.length;
      if (flen < 4096)
        continue;
      file.start = T2;
      chainit(flen + 511 >> 9);
    }
    chainit(L2[6] + 7 >> 3);
    while (o2.l & 511)
      o2.write_shift(-4, consts.ENDOFCHAIN);
    T2 = i3 = 0;
    for (j2 = 0; j2 < cfb.FileIndex.length; ++j2) {
      file = cfb.FileIndex[j2];
      if (!file.content)
        continue;
      flen = file.content.length;
      if (!flen || flen >= 4096)
        continue;
      file.start = T2;
      chainit(flen + 63 >> 6);
    }
    while (o2.l & 511)
      o2.write_shift(-4, consts.ENDOFCHAIN);
    for (i3 = 0; i3 < L2[4] << 2; ++i3) {
      var nm = cfb.FullPaths[i3];
      if (!nm || nm.length === 0) {
        for (j2 = 0; j2 < 17; ++j2)
          o2.write_shift(4, 0);
        for (j2 = 0; j2 < 3; ++j2)
          o2.write_shift(4, -1);
        for (j2 = 0; j2 < 12; ++j2)
          o2.write_shift(4, 0);
        continue;
      }
      file = cfb.FileIndex[i3];
      if (i3 === 0)
        file.start = file.size ? file.start - 1 : ENDOFCHAIN;
      var _nm = i3 === 0 && _opts.root || file.name;
      flen = 2 * (_nm.length + 1);
      o2.write_shift(64, _nm, "utf16le");
      o2.write_shift(2, flen);
      o2.write_shift(1, file.type);
      o2.write_shift(1, file.color);
      o2.write_shift(-4, file.L);
      o2.write_shift(-4, file.R);
      o2.write_shift(-4, file.C);
      if (!file.clsid)
        for (j2 = 0; j2 < 4; ++j2)
          o2.write_shift(4, 0);
      else
        o2.write_shift(16, file.clsid, "hex");
      o2.write_shift(4, file.state || 0);
      o2.write_shift(4, 0);
      o2.write_shift(4, 0);
      o2.write_shift(4, 0);
      o2.write_shift(4, 0);
      o2.write_shift(4, file.start);
      o2.write_shift(4, file.size);
      o2.write_shift(4, 0);
    }
    for (i3 = 1; i3 < cfb.FileIndex.length; ++i3) {
      file = cfb.FileIndex[i3];
      if (file.size >= 4096) {
        o2.l = file.start + 1 << 9;
        if (has_buf && Buffer.isBuffer(file.content)) {
          file.content.copy(o2, o2.l, 0, file.size);
          o2.l += file.size + 511 & -512;
        } else {
          for (j2 = 0; j2 < file.size; ++j2)
            o2.write_shift(1, file.content[j2]);
          for (; j2 & 511; ++j2)
            o2.write_shift(1, 0);
        }
      }
    }
    for (i3 = 1; i3 < cfb.FileIndex.length; ++i3) {
      file = cfb.FileIndex[i3];
      if (file.size > 0 && file.size < 4096) {
        if (has_buf && Buffer.isBuffer(file.content)) {
          file.content.copy(o2, o2.l, 0, file.size);
          o2.l += file.size + 63 & -64;
        } else {
          for (j2 = 0; j2 < file.size; ++j2)
            o2.write_shift(1, file.content[j2]);
          for (; j2 & 63; ++j2)
            o2.write_shift(1, 0);
        }
      }
    }
    if (has_buf) {
      o2.l = o2.length;
    } else {
      while (o2.l < o2.length)
        o2.write_shift(1, 0);
    }
    return o2;
  }
  function find(cfb, path) {
    var UCFullPaths = cfb.FullPaths.map(function(x2) {
      return x2.toUpperCase();
    });
    var UCPaths = UCFullPaths.map(function(x2) {
      var y2 = x2.split("/");
      return y2[y2.length - (x2.slice(-1) == "/" ? 2 : 1)];
    });
    var k2 = false;
    if (path.charCodeAt(0) === 47) {
      k2 = true;
      path = UCFullPaths[0].slice(0, -1) + path;
    } else
      k2 = path.indexOf("/") !== -1;
    var UCPath = path.toUpperCase();
    var w2 = k2 === true ? UCFullPaths.indexOf(UCPath) : UCPaths.indexOf(UCPath);
    if (w2 !== -1)
      return cfb.FileIndex[w2];
    var m2 = !UCPath.match(chr1);
    UCPath = UCPath.replace(chr0, "");
    if (m2)
      UCPath = UCPath.replace(chr1, "!");
    for (w2 = 0; w2 < UCFullPaths.length; ++w2) {
      if ((m2 ? UCFullPaths[w2].replace(chr1, "!") : UCFullPaths[w2]).replace(chr0, "") == UCPath)
        return cfb.FileIndex[w2];
      if ((m2 ? UCPaths[w2].replace(chr1, "!") : UCPaths[w2]).replace(chr0, "") == UCPath)
        return cfb.FileIndex[w2];
    }
    return null;
  }
  var MSSZ = 64;
  var ENDOFCHAIN = -2;
  var HEADER_SIGNATURE = "d0cf11e0a1b11ae1";
  var HEADER_SIG = [208, 207, 17, 224, 161, 177, 26, 225];
  var HEADER_CLSID = "00000000000000000000000000000000";
  var consts = {
    /* 2.1 Compund File Sector Numbers and Types */
    MAXREGSECT: -6,
    DIFSECT: -4,
    FATSECT: -3,
    ENDOFCHAIN,
    FREESECT: -1,
    /* 2.2 Compound File Header */
    HEADER_SIGNATURE,
    HEADER_MINOR_VERSION: "3e00",
    MAXREGSID: -6,
    NOSTREAM: -1,
    HEADER_CLSID,
    /* 2.6.1 Compound File Directory Entry */
    EntryTypes: ["unknown", "storage", "stream", "lockbytes", "property", "root"]
  };
  function write_file(cfb, filename2, options) {
    get_fs();
    var o2 = _write(cfb, options);
    fs.writeFileSync(filename2, o2);
  }
  function a2s2(o2) {
    var out = new Array(o2.length);
    for (var i3 = 0; i3 < o2.length; ++i3)
      out[i3] = String.fromCharCode(o2[i3]);
    return out.join("");
  }
  function write(cfb, options) {
    var o2 = _write(cfb, options);
    switch (options && options.type || "buffer") {
      case "file":
        get_fs();
        fs.writeFileSync(options.filename, o2);
        return o2;
      case "binary":
        return typeof o2 == "string" ? o2 : a2s2(o2);
      case "base64":
        return Base64_encode(typeof o2 == "string" ? o2 : a2s2(o2));
      case "buffer":
        if (has_buf)
          return Buffer.isBuffer(o2) ? o2 : Buffer_from(o2);
      case "array":
        return typeof o2 == "string" ? s2a(o2) : o2;
    }
    return o2;
  }
  var _zlib;
  function use_zlib(zlib) {
    try {
      var InflateRaw = zlib.InflateRaw;
      var InflRaw = new InflateRaw();
      InflRaw._processChunk(new Uint8Array([3, 0]), InflRaw._finishFlushFlag);
      if (InflRaw.bytesRead)
        _zlib = zlib;
      else
        throw new Error("zlib does not expose bytesRead");
    } catch (e) {
      console.error("cannot use native zlib: " + (e.message || e));
    }
  }
  function _inflateRawSync(payload, usz) {
    if (!_zlib)
      return _inflate(payload, usz);
    var InflateRaw = _zlib.InflateRaw;
    var InflRaw = new InflateRaw();
    var out = InflRaw._processChunk(payload.slice(payload.l), InflRaw._finishFlushFlag);
    payload.l += InflRaw.bytesRead;
    return out;
  }
  function _deflateRawSync(payload) {
    return _zlib ? _zlib.deflateRawSync(payload) : _deflate(payload);
  }
  var CLEN_ORDER = [16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15];
  var LEN_LN = [3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15, 17, 19, 23, 27, 31, 35, 43, 51, 59, 67, 83, 99, 115, 131, 163, 195, 227, 258];
  var DST_LN = [1, 2, 3, 4, 5, 7, 9, 13, 17, 25, 33, 49, 65, 97, 129, 193, 257, 385, 513, 769, 1025, 1537, 2049, 3073, 4097, 6145, 8193, 12289, 16385, 24577];
  function bit_swap_8(n2) {
    var t2 = (n2 << 1 | n2 << 11) & 139536 | (n2 << 5 | n2 << 15) & 558144;
    return (t2 >> 16 | t2 >> 8 | t2) & 255;
  }
  var use_typed_arrays = typeof Uint8Array !== "undefined";
  var bitswap8 = use_typed_arrays ? new Uint8Array(1 << 8) : [];
  for (var q2 = 0; q2 < 1 << 8; ++q2)
    bitswap8[q2] = bit_swap_8(q2);
  function bit_swap_n(n2, b2) {
    var rev2 = bitswap8[n2 & 255];
    if (b2 <= 8)
      return rev2 >>> 8 - b2;
    rev2 = rev2 << 8 | bitswap8[n2 >> 8 & 255];
    if (b2 <= 16)
      return rev2 >>> 16 - b2;
    rev2 = rev2 << 8 | bitswap8[n2 >> 16 & 255];
    return rev2 >>> 24 - b2;
  }
  function read_bits_2(buf, bl) {
    var w2 = bl & 7, h2 = bl >>> 3;
    return (buf[h2] | (w2 <= 6 ? 0 : buf[h2 + 1] << 8)) >>> w2 & 3;
  }
  function read_bits_3(buf, bl) {
    var w2 = bl & 7, h2 = bl >>> 3;
    return (buf[h2] | (w2 <= 5 ? 0 : buf[h2 + 1] << 8)) >>> w2 & 7;
  }
  function read_bits_4(buf, bl) {
    var w2 = bl & 7, h2 = bl >>> 3;
    return (buf[h2] | (w2 <= 4 ? 0 : buf[h2 + 1] << 8)) >>> w2 & 15;
  }
  function read_bits_5(buf, bl) {
    var w2 = bl & 7, h2 = bl >>> 3;
    return (buf[h2] | (w2 <= 3 ? 0 : buf[h2 + 1] << 8)) >>> w2 & 31;
  }
  function read_bits_7(buf, bl) {
    var w2 = bl & 7, h2 = bl >>> 3;
    return (buf[h2] | (w2 <= 1 ? 0 : buf[h2 + 1] << 8)) >>> w2 & 127;
  }
  function read_bits_n(buf, bl, n2) {
    var w2 = bl & 7, h2 = bl >>> 3, f2 = (1 << n2) - 1;
    var v2 = buf[h2] >>> w2;
    if (n2 < 8 - w2)
      return v2 & f2;
    v2 |= buf[h2 + 1] << 8 - w2;
    if (n2 < 16 - w2)
      return v2 & f2;
    v2 |= buf[h2 + 2] << 16 - w2;
    if (n2 < 24 - w2)
      return v2 & f2;
    v2 |= buf[h2 + 3] << 24 - w2;
    return v2 & f2;
  }
  function write_bits_3(buf, bl, v2) {
    var w2 = bl & 7, h2 = bl >>> 3;
    if (w2 <= 5)
      buf[h2] |= (v2 & 7) << w2;
    else {
      buf[h2] |= v2 << w2 & 255;
      buf[h2 + 1] = (v2 & 7) >> 8 - w2;
    }
    return bl + 3;
  }
  function write_bits_1(buf, bl, v2) {
    var w2 = bl & 7, h2 = bl >>> 3;
    v2 = (v2 & 1) << w2;
    buf[h2] |= v2;
    return bl + 1;
  }
  function write_bits_8(buf, bl, v2) {
    var w2 = bl & 7, h2 = bl >>> 3;
    v2 <<= w2;
    buf[h2] |= v2 & 255;
    v2 >>>= 8;
    buf[h2 + 1] = v2;
    return bl + 8;
  }
  function write_bits_16(buf, bl, v2) {
    var w2 = bl & 7, h2 = bl >>> 3;
    v2 <<= w2;
    buf[h2] |= v2 & 255;
    v2 >>>= 8;
    buf[h2 + 1] = v2 & 255;
    buf[h2 + 2] = v2 >>> 8;
    return bl + 16;
  }
  function realloc(b2, sz) {
    var L2 = b2.length, M2 = 2 * L2 > sz ? 2 * L2 : sz + 5, i3 = 0;
    if (L2 >= sz)
      return b2;
    if (has_buf) {
      var o2 = new_unsafe_buf(M2);
      if (b2.copy)
        b2.copy(o2);
      else
        for (; i3 < b2.length; ++i3)
          o2[i3] = b2[i3];
      return o2;
    } else if (use_typed_arrays) {
      var a2 = new Uint8Array(M2);
      if (a2.set)
        a2.set(b2);
      else
        for (; i3 < L2; ++i3)
          a2[i3] = b2[i3];
      return a2;
    }
    b2.length = M2;
    return b2;
  }
  function zero_fill_array(n2) {
    var o2 = new Array(n2);
    for (var i3 = 0; i3 < n2; ++i3)
      o2[i3] = 0;
    return o2;
  }
  function build_tree(clens, cmap, MAX) {
    var maxlen = 1, w2 = 0, i3 = 0, j2 = 0, ccode = 0, L2 = clens.length;
    var bl_count = use_typed_arrays ? new Uint16Array(32) : zero_fill_array(32);
    for (i3 = 0; i3 < 32; ++i3)
      bl_count[i3] = 0;
    for (i3 = L2; i3 < MAX; ++i3)
      clens[i3] = 0;
    L2 = clens.length;
    var ctree = use_typed_arrays ? new Uint16Array(L2) : zero_fill_array(L2);
    for (i3 = 0; i3 < L2; ++i3) {
      bl_count[w2 = clens[i3]]++;
      if (maxlen < w2)
        maxlen = w2;
      ctree[i3] = 0;
    }
    bl_count[0] = 0;
    for (i3 = 1; i3 <= maxlen; ++i3)
      bl_count[i3 + 16] = ccode = ccode + bl_count[i3 - 1] << 1;
    for (i3 = 0; i3 < L2; ++i3) {
      ccode = clens[i3];
      if (ccode != 0)
        ctree[i3] = bl_count[ccode + 16]++;
    }
    var cleni = 0;
    for (i3 = 0; i3 < L2; ++i3) {
      cleni = clens[i3];
      if (cleni != 0) {
        ccode = bit_swap_n(ctree[i3], maxlen) >> maxlen - cleni;
        for (j2 = (1 << maxlen + 4 - cleni) - 1; j2 >= 0; --j2)
          cmap[ccode | j2 << cleni] = cleni & 15 | i3 << 4;
      }
    }
    return maxlen;
  }
  var fix_lmap = use_typed_arrays ? new Uint16Array(512) : zero_fill_array(512);
  var fix_dmap = use_typed_arrays ? new Uint16Array(32) : zero_fill_array(32);
  if (!use_typed_arrays) {
    for (var i2 = 0; i2 < 512; ++i2)
      fix_lmap[i2] = 0;
    for (i2 = 0; i2 < 32; ++i2)
      fix_dmap[i2] = 0;
  }
  (function() {
    var dlens = [];
    var i3 = 0;
    for (; i3 < 32; i3++)
      dlens.push(5);
    build_tree(dlens, fix_dmap, 32);
    var clens = [];
    i3 = 0;
    for (; i3 <= 143; i3++)
      clens.push(8);
    for (; i3 <= 255; i3++)
      clens.push(9);
    for (; i3 <= 279; i3++)
      clens.push(7);
    for (; i3 <= 287; i3++)
      clens.push(8);
    build_tree(clens, fix_lmap, 288);
  })();
  var _deflateRaw = /* @__PURE__ */ function _deflateRawIIFE() {
    var DST_LN_RE = use_typed_arrays ? new Uint8Array(32768) : [];
    var j2 = 0, k2 = 0;
    for (; j2 < DST_LN.length - 1; ++j2) {
      for (; k2 < DST_LN[j2 + 1]; ++k2)
        DST_LN_RE[k2] = j2;
    }
    for (; k2 < 32768; ++k2)
      DST_LN_RE[k2] = 29;
    var LEN_LN_RE = use_typed_arrays ? new Uint8Array(259) : [];
    for (j2 = 0, k2 = 0; j2 < LEN_LN.length - 1; ++j2) {
      for (; k2 < LEN_LN[j2 + 1]; ++k2)
        LEN_LN_RE[k2] = j2;
    }
    function write_stored(data, out) {
      var boff = 0;
      while (boff < data.length) {
        var L2 = Math.min(65535, data.length - boff);
        var h2 = boff + L2 == data.length;
        out.write_shift(1, +h2);
        out.write_shift(2, L2);
        out.write_shift(2, ~L2 & 65535);
        while (L2-- > 0)
          out[out.l++] = data[boff++];
      }
      return out.l;
    }
    function write_huff_fixed(data, out) {
      var bl = 0;
      var boff = 0;
      var addrs = use_typed_arrays ? new Uint16Array(32768) : [];
      while (boff < data.length) {
        var L2 = (
          /* data.length - boff; */
          Math.min(65535, data.length - boff)
        );
        if (L2 < 10) {
          bl = write_bits_3(out, bl, +!!(boff + L2 == data.length));
          if (bl & 7)
            bl += 8 - (bl & 7);
          out.l = bl / 8 | 0;
          out.write_shift(2, L2);
          out.write_shift(2, ~L2 & 65535);
          while (L2-- > 0)
            out[out.l++] = data[boff++];
          bl = out.l * 8;
          continue;
        }
        bl = write_bits_3(out, bl, +!!(boff + L2 == data.length) + 2);
        var hash = 0;
        while (L2-- > 0) {
          var d2 = data[boff];
          hash = (hash << 5 ^ d2) & 32767;
          var match = -1, mlen = 0;
          if (match = addrs[hash]) {
            match |= boff & ~32767;
            if (match > boff)
              match -= 32768;
            if (match < boff)
              while (data[match + mlen] == data[boff + mlen] && mlen < 250)
                ++mlen;
          }
          if (mlen > 2) {
            d2 = LEN_LN_RE[mlen];
            if (d2 <= 22)
              bl = write_bits_8(out, bl, bitswap8[d2 + 1] >> 1) - 1;
            else {
              write_bits_8(out, bl, 3);
              bl += 5;
              write_bits_8(out, bl, bitswap8[d2 - 23] >> 5);
              bl += 3;
            }
            var len_eb = d2 < 8 ? 0 : d2 - 4 >> 2;
            if (len_eb > 0) {
              write_bits_16(out, bl, mlen - LEN_LN[d2]);
              bl += len_eb;
            }
            d2 = DST_LN_RE[boff - match];
            bl = write_bits_8(out, bl, bitswap8[d2] >> 3);
            bl -= 3;
            var dst_eb = d2 < 4 ? 0 : d2 - 2 >> 1;
            if (dst_eb > 0) {
              write_bits_16(out, bl, boff - match - DST_LN[d2]);
              bl += dst_eb;
            }
            for (var q3 = 0; q3 < mlen; ++q3) {
              addrs[hash] = boff & 32767;
              hash = (hash << 5 ^ data[boff]) & 32767;
              ++boff;
            }
            L2 -= mlen - 1;
          } else {
            if (d2 <= 143)
              d2 = d2 + 48;
            else
              bl = write_bits_1(out, bl, 1);
            bl = write_bits_8(out, bl, bitswap8[d2]);
            addrs[hash] = boff & 32767;
            ++boff;
          }
        }
        bl = write_bits_8(out, bl, 0) - 1;
      }
      out.l = (bl + 7) / 8 | 0;
      return out.l;
    }
    return function _deflateRaw2(data, out) {
      if (data.length < 8)
        return write_stored(data, out);
      return write_huff_fixed(data, out);
    };
  }();
  function _deflate(data) {
    var buf = new_buf(50 + Math.floor(data.length * 1.1));
    var off = _deflateRaw(data, buf);
    return buf.slice(0, off);
  }
  var dyn_lmap = use_typed_arrays ? new Uint16Array(32768) : zero_fill_array(32768);
  var dyn_dmap = use_typed_arrays ? new Uint16Array(32768) : zero_fill_array(32768);
  var dyn_cmap = use_typed_arrays ? new Uint16Array(128) : zero_fill_array(128);
  var dyn_len_1 = 1, dyn_len_2 = 1;
  function dyn(data, boff) {
    var _HLIT = read_bits_5(data, boff) + 257;
    boff += 5;
    var _HDIST = read_bits_5(data, boff) + 1;
    boff += 5;
    var _HCLEN = read_bits_4(data, boff) + 4;
    boff += 4;
    var w2 = 0;
    var clens = use_typed_arrays ? new Uint8Array(19) : zero_fill_array(19);
    var ctree = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
    var maxlen = 1;
    var bl_count = use_typed_arrays ? new Uint8Array(8) : zero_fill_array(8);
    var next_code = use_typed_arrays ? new Uint8Array(8) : zero_fill_array(8);
    var L2 = clens.length;
    for (var i3 = 0; i3 < _HCLEN; ++i3) {
      clens[CLEN_ORDER[i3]] = w2 = read_bits_3(data, boff);
      if (maxlen < w2)
        maxlen = w2;
      bl_count[w2]++;
      boff += 3;
    }
    var ccode = 0;
    bl_count[0] = 0;
    for (i3 = 1; i3 <= maxlen; ++i3)
      next_code[i3] = ccode = ccode + bl_count[i3 - 1] << 1;
    for (i3 = 0; i3 < L2; ++i3)
      if ((ccode = clens[i3]) != 0)
        ctree[i3] = next_code[ccode]++;
    var cleni = 0;
    for (i3 = 0; i3 < L2; ++i3) {
      cleni = clens[i3];
      if (cleni != 0) {
        ccode = bitswap8[ctree[i3]] >> 8 - cleni;
        for (var j2 = (1 << 7 - cleni) - 1; j2 >= 0; --j2)
          dyn_cmap[ccode | j2 << cleni] = cleni & 7 | i3 << 3;
      }
    }
    var hcodes = [];
    maxlen = 1;
    for (; hcodes.length < _HLIT + _HDIST; ) {
      ccode = dyn_cmap[read_bits_7(data, boff)];
      boff += ccode & 7;
      switch (ccode >>>= 3) {
        case 16:
          w2 = 3 + read_bits_2(data, boff);
          boff += 2;
          ccode = hcodes[hcodes.length - 1];
          while (w2-- > 0)
            hcodes.push(ccode);
          break;
        case 17:
          w2 = 3 + read_bits_3(data, boff);
          boff += 3;
          while (w2-- > 0)
            hcodes.push(0);
          break;
        case 18:
          w2 = 11 + read_bits_7(data, boff);
          boff += 7;
          while (w2-- > 0)
            hcodes.push(0);
          break;
        default:
          hcodes.push(ccode);
          if (maxlen < ccode)
            maxlen = ccode;
          break;
      }
    }
    var h1 = hcodes.slice(0, _HLIT), h2 = hcodes.slice(_HLIT);
    for (i3 = _HLIT; i3 < 286; ++i3)
      h1[i3] = 0;
    for (i3 = _HDIST; i3 < 30; ++i3)
      h2[i3] = 0;
    dyn_len_1 = build_tree(h1, dyn_lmap, 286);
    dyn_len_2 = build_tree(h2, dyn_dmap, 30);
    return boff;
  }
  function inflate(data, usz) {
    if (data[0] == 3 && !(data[1] & 3)) {
      return [new_raw_buf(usz), 2];
    }
    var boff = 0;
    var header = 0;
    var outbuf = new_unsafe_buf(usz ? usz : 1 << 18);
    var woff = 0;
    var OL = outbuf.length >>> 0;
    var max_len_1 = 0, max_len_2 = 0;
    while ((header & 1) == 0) {
      header = read_bits_3(data, boff);
      boff += 3;
      if (header >>> 1 == 0) {
        if (boff & 7)
          boff += 8 - (boff & 7);
        var sz = data[boff >>> 3] | data[(boff >>> 3) + 1] << 8;
        boff += 32;
        if (sz > 0) {
          if (!usz && OL < woff + sz) {
            outbuf = realloc(outbuf, woff + sz);
            OL = outbuf.length;
          }
          while (sz-- > 0) {
            outbuf[woff++] = data[boff >>> 3];
            boff += 8;
          }
        }
        continue;
      } else if (header >> 1 == 1) {
        max_len_1 = 9;
        max_len_2 = 5;
      } else {
        boff = dyn(data, boff);
        max_len_1 = dyn_len_1;
        max_len_2 = dyn_len_2;
      }
      for (; ; ) {
        if (!usz && OL < woff + 32767) {
          outbuf = realloc(outbuf, woff + 32767);
          OL = outbuf.length;
        }
        var bits2 = read_bits_n(data, boff, max_len_1);
        var code = header >>> 1 == 1 ? fix_lmap[bits2] : dyn_lmap[bits2];
        boff += code & 15;
        code >>>= 4;
        if ((code >>> 8 & 255) === 0)
          outbuf[woff++] = code;
        else if (code == 256)
          break;
        else {
          code -= 257;
          var len_eb = code < 8 ? 0 : code - 4 >> 2;
          if (len_eb > 5)
            len_eb = 0;
          var tgt = woff + LEN_LN[code];
          if (len_eb > 0) {
            tgt += read_bits_n(data, boff, len_eb);
            boff += len_eb;
          }
          bits2 = read_bits_n(data, boff, max_len_2);
          code = header >>> 1 == 1 ? fix_dmap[bits2] : dyn_dmap[bits2];
          boff += code & 15;
          code >>>= 4;
          var dst_eb = code < 4 ? 0 : code - 2 >> 1;
          var dst = DST_LN[code];
          if (dst_eb > 0) {
            dst += read_bits_n(data, boff, dst_eb);
            boff += dst_eb;
          }
          if (!usz && OL < tgt) {
            outbuf = realloc(outbuf, tgt + 100);
            OL = outbuf.length;
          }
          while (woff < tgt) {
            outbuf[woff] = outbuf[woff - dst];
            ++woff;
          }
        }
      }
    }
    if (usz)
      return [outbuf, boff + 7 >>> 3];
    return [outbuf.slice(0, woff), boff + 7 >>> 3];
  }
  function _inflate(payload, usz) {
    var data = payload.slice(payload.l || 0);
    var out = inflate(data, usz);
    payload.l += out[1];
    return out[0];
  }
  function warn_or_throw(wrn, msg) {
    if (wrn) {
      if (typeof console !== "undefined")
        console.error(msg);
    } else
      throw new Error(msg);
  }
  function parse_zip2(file, options) {
    var blob = (
      /*::(*/
      file
    );
    prep_blob(blob, 0);
    var FileIndex = [], FullPaths = [];
    var o2 = {
      FileIndex,
      FullPaths
    };
    init_cfb(o2, { root: options.root });
    var i3 = blob.length - 4;
    while ((blob[i3] != 80 || blob[i3 + 1] != 75 || blob[i3 + 2] != 5 || blob[i3 + 3] != 6) && i3 >= 0)
      --i3;
    blob.l = i3 + 4;
    blob.l += 4;
    var fcnt = blob.read_shift(2);
    blob.l += 6;
    var start_cd = blob.read_shift(4);
    blob.l = start_cd;
    for (i3 = 0; i3 < fcnt; ++i3) {
      blob.l += 20;
      var csz = blob.read_shift(4);
      var usz = blob.read_shift(4);
      var namelen = blob.read_shift(2);
      var efsz = blob.read_shift(2);
      var fcsz = blob.read_shift(2);
      blob.l += 8;
      var offset = blob.read_shift(4);
      var EF = parse_extra_field(
        /*::(*/
        blob.slice(blob.l + namelen, blob.l + namelen + efsz)
        /*:: :any)*/
      );
      blob.l += namelen + efsz + fcsz;
      var L2 = blob.l;
      blob.l = offset + 4;
      parse_local_file(blob, csz, usz, o2, EF);
      blob.l = L2;
    }
    return o2;
  }
  function parse_local_file(blob, csz, usz, o2, EF) {
    blob.l += 2;
    var flags = blob.read_shift(2);
    var meth = blob.read_shift(2);
    var date = parse_dos_date(blob);
    if (flags & 8257)
      throw new Error("Unsupported ZIP encryption");
    var crc32 = blob.read_shift(4);
    var _csz = blob.read_shift(4);
    var _usz = blob.read_shift(4);
    var namelen = blob.read_shift(2);
    var efsz = blob.read_shift(2);
    var name = "";
    for (var i3 = 0; i3 < namelen; ++i3)
      name += String.fromCharCode(blob[blob.l++]);
    if (efsz) {
      var ef = parse_extra_field(
        /*::(*/
        blob.slice(blob.l, blob.l + efsz)
        /*:: :any)*/
      );
      if ((ef[21589] || {}).mt)
        date = ef[21589].mt;
      if (((EF || {})[21589] || {}).mt)
        date = EF[21589].mt;
    }
    blob.l += efsz;
    var data = blob.slice(blob.l, blob.l + _csz);
    switch (meth) {
      case 8:
        data = _inflateRawSync(blob, _usz);
        break;
      case 0:
        break;
      default:
        throw new Error("Unsupported ZIP Compression method " + meth);
    }
    var wrn = false;
    if (flags & 8) {
      crc32 = blob.read_shift(4);
      if (crc32 == 134695760) {
        crc32 = blob.read_shift(4);
        wrn = true;
      }
      _csz = blob.read_shift(4);
      _usz = blob.read_shift(4);
    }
    if (_csz != csz)
      warn_or_throw(wrn, "Bad compressed size: " + csz + " != " + _csz);
    if (_usz != usz)
      warn_or_throw(wrn, "Bad uncompressed size: " + usz + " != " + _usz);
    cfb_add(o2, name, data, { unsafe: true, mt: date });
  }
  function write_zip2(cfb, options) {
    var _opts = options || {};
    var out = [], cdirs = [];
    var o2 = new_buf(1);
    var method = _opts.compression ? 8 : 0, flags = 0;
    var desc = false;
    if (desc)
      flags |= 8;
    var i3 = 0, j2 = 0;
    var start_cd = 0, fcnt = 0;
    var root = cfb.FullPaths[0], fp = root, fi = cfb.FileIndex[0];
    var crcs = [];
    var sz_cd = 0;
    for (i3 = 1; i3 < cfb.FullPaths.length; ++i3) {
      fp = cfb.FullPaths[i3].slice(root.length);
      fi = cfb.FileIndex[i3];
      if (!fi.size || !fi.content || fp == "Sh33tJ5")
        continue;
      var start = start_cd;
      var namebuf = new_buf(fp.length);
      for (j2 = 0; j2 < fp.length; ++j2)
        namebuf.write_shift(1, fp.charCodeAt(j2) & 127);
      namebuf = namebuf.slice(0, namebuf.l);
      crcs[fcnt] = CRC32.buf(
        /*::((*/
        fi.content,
        0
      );
      var outbuf = fi.content;
      if (method == 8)
        outbuf = _deflateRawSync(outbuf);
      o2 = new_buf(30);
      o2.write_shift(4, 67324752);
      o2.write_shift(2, 20);
      o2.write_shift(2, flags);
      o2.write_shift(2, method);
      if (fi.mt)
        write_dos_date(o2, fi.mt);
      else
        o2.write_shift(4, 0);
      o2.write_shift(-4, flags & 8 ? 0 : crcs[fcnt]);
      o2.write_shift(4, flags & 8 ? 0 : outbuf.length);
      o2.write_shift(4, flags & 8 ? 0 : (
        /*::(*/
        fi.content.length
      ));
      o2.write_shift(2, namebuf.length);
      o2.write_shift(2, 0);
      start_cd += o2.length;
      out.push(o2);
      start_cd += namebuf.length;
      out.push(namebuf);
      start_cd += outbuf.length;
      out.push(outbuf);
      if (flags & 8) {
        o2 = new_buf(12);
        o2.write_shift(-4, crcs[fcnt]);
        o2.write_shift(4, outbuf.length);
        o2.write_shift(
          4,
          /*::(*/
          fi.content.length
        );
        start_cd += o2.l;
        out.push(o2);
      }
      o2 = new_buf(46);
      o2.write_shift(4, 33639248);
      o2.write_shift(2, 0);
      o2.write_shift(2, 20);
      o2.write_shift(2, flags);
      o2.write_shift(2, method);
      o2.write_shift(4, 0);
      o2.write_shift(-4, crcs[fcnt]);
      o2.write_shift(4, outbuf.length);
      o2.write_shift(
        4,
        /*::(*/
        fi.content.length
      );
      o2.write_shift(2, namebuf.length);
      o2.write_shift(2, 0);
      o2.write_shift(2, 0);
      o2.write_shift(2, 0);
      o2.write_shift(2, 0);
      o2.write_shift(4, 0);
      o2.write_shift(4, start);
      sz_cd += o2.l;
      cdirs.push(o2);
      sz_cd += namebuf.length;
      cdirs.push(namebuf);
      ++fcnt;
    }
    o2 = new_buf(22);
    o2.write_shift(4, 101010256);
    o2.write_shift(2, 0);
    o2.write_shift(2, 0);
    o2.write_shift(2, fcnt);
    o2.write_shift(2, fcnt);
    o2.write_shift(4, sz_cd);
    o2.write_shift(4, start_cd);
    o2.write_shift(2, 0);
    return bconcat([bconcat(out), bconcat(cdirs), o2]);
  }
  var ContentTypeMap = {
    "htm": "text/html",
    "xml": "text/xml",
    "gif": "image/gif",
    "jpg": "image/jpeg",
    "png": "image/png",
    "mso": "application/x-mso",
    "thmx": "application/vnd.ms-officetheme",
    "sh33tj5": "application/octet-stream"
  };
  function get_content_type(fi, fp) {
    if (fi.ctype)
      return fi.ctype;
    var ext = fi.name || "", m2 = ext.match(/\.([^\.]+)$/);
    if (m2 && ContentTypeMap[m2[1]])
      return ContentTypeMap[m2[1]];
    if (fp) {
      m2 = (ext = fp).match(/[\.\\]([^\.\\])+$/);
      if (m2 && ContentTypeMap[m2[1]])
        return ContentTypeMap[m2[1]];
    }
    return "application/octet-stream";
  }
  function write_base64_76(bstr) {
    var data = Base64_encode(bstr);
    var o2 = [];
    for (var i3 = 0; i3 < data.length; i3 += 76)
      o2.push(data.slice(i3, i3 + 76));
    return o2.join("\r\n") + "\r\n";
  }
  function write_quoted_printable(text) {
    var encoded = text.replace(/[\x00-\x08\x0B\x0C\x0E-\x1F\x7E-\xFF=]/g, function(c2) {
      var w2 = c2.charCodeAt(0).toString(16).toUpperCase();
      return "=" + (w2.length == 1 ? "0" + w2 : w2);
    });
    encoded = encoded.replace(/ $/mg, "=20").replace(/\t$/mg, "=09");
    if (encoded.charAt(0) == "\n")
      encoded = "=0D" + encoded.slice(1);
    encoded = encoded.replace(/\r(?!\n)/mg, "=0D").replace(/\n\n/mg, "\n=0A").replace(/([^\r\n])\n/mg, "$1=0A");
    var o2 = [], split = encoded.split("\r\n");
    for (var si = 0; si < split.length; ++si) {
      var str = split[si];
      if (str.length == 0) {
        o2.push("");
        continue;
      }
      for (var i3 = 0; i3 < str.length; ) {
        var end = 76;
        var tmp = str.slice(i3, i3 + end);
        if (tmp.charAt(end - 1) == "=")
          end--;
        else if (tmp.charAt(end - 2) == "=")
          end -= 2;
        else if (tmp.charAt(end - 3) == "=")
          end -= 3;
        tmp = str.slice(i3, i3 + end);
        i3 += end;
        if (i3 < str.length)
          tmp += "=";
        o2.push(tmp);
      }
    }
    return o2.join("\r\n");
  }
  function parse_quoted_printable(data) {
    var o2 = [];
    for (var di = 0; di < data.length; ++di) {
      var line = data[di];
      while (di <= data.length && line.charAt(line.length - 1) == "=")
        line = line.slice(0, line.length - 1) + data[++di];
      o2.push(line);
    }
    for (var oi = 0; oi < o2.length; ++oi)
      o2[oi] = o2[oi].replace(/[=][0-9A-Fa-f]{2}/g, function($$) {
        return String.fromCharCode(parseInt($$.slice(1), 16));
      });
    return s2a(o2.join("\r\n"));
  }
  function parse_mime(cfb, data, root) {
    var fname = "", cte = "", ctype = "", fdata;
    var di = 0;
    for (; di < 10; ++di) {
      var line = data[di];
      if (!line || line.match(/^\s*$/))
        break;
      var m2 = line.match(/^(.*?):\s*([^\s].*)$/);
      if (m2)
        switch (m2[1].toLowerCase()) {
          case "content-location":
            fname = m2[2].trim();
            break;
          case "content-type":
            ctype = m2[2].trim();
            break;
          case "content-transfer-encoding":
            cte = m2[2].trim();
            break;
        }
    }
    ++di;
    switch (cte.toLowerCase()) {
      case "base64":
        fdata = s2a(Base64_decode(data.slice(di).join("")));
        break;
      case "quoted-printable":
        fdata = parse_quoted_printable(data.slice(di));
        break;
      default:
        throw new Error("Unsupported Content-Transfer-Encoding " + cte);
    }
    var file = cfb_add(cfb, fname.slice(root.length), fdata, { unsafe: true });
    if (ctype)
      file.ctype = ctype;
  }
  function parse_mad(file, options) {
    if (a2s2(file.slice(0, 13)).toLowerCase() != "mime-version:")
      throw new Error("Unsupported MAD header");
    var root = options && options.root || "";
    var data = (has_buf && Buffer.isBuffer(file) ? file.toString("binary") : a2s2(file)).split("\r\n");
    var di = 0, row = "";
    for (di = 0; di < data.length; ++di) {
      row = data[di];
      if (!/^Content-Location:/i.test(row))
        continue;
      row = row.slice(row.indexOf("file"));
      if (!root)
        root = row.slice(0, row.lastIndexOf("/") + 1);
      if (row.slice(0, root.length) == root)
        continue;
      while (root.length > 0) {
        root = root.slice(0, root.length - 1);
        root = root.slice(0, root.lastIndexOf("/") + 1);
        if (row.slice(0, root.length) == root)
          break;
      }
    }
    var mboundary = (data[1] || "").match(/boundary="(.*?)"/);
    if (!mboundary)
      throw new Error("MAD cannot find boundary");
    var boundary = "--" + (mboundary[1] || "");
    var FileIndex = [], FullPaths = [];
    var o2 = {
      FileIndex,
      FullPaths
    };
    init_cfb(o2);
    var start_di, fcnt = 0;
    for (di = 0; di < data.length; ++di) {
      var line = data[di];
      if (line !== boundary && line !== boundary + "--")
        continue;
      if (fcnt++)
        parse_mime(o2, data.slice(start_di, di), root);
      start_di = di;
    }
    return o2;
  }
  function write_mad(cfb, options) {
    var opts = options || {};
    var boundary = opts.boundary || "SheetJS";
    boundary = "------=" + boundary;
    var out = [
      "MIME-Version: 1.0",
      'Content-Type: multipart/related; boundary="' + boundary.slice(2) + '"',
      "",
      "",
      ""
    ];
    var root = cfb.FullPaths[0], fp = root, fi = cfb.FileIndex[0];
    for (var i3 = 1; i3 < cfb.FullPaths.length; ++i3) {
      fp = cfb.FullPaths[i3].slice(root.length);
      fi = cfb.FileIndex[i3];
      if (!fi.size || !fi.content || fp == "Sh33tJ5")
        continue;
      fp = fp.replace(/[\x00-\x08\x0B\x0C\x0E-\x1F\x7E-\xFF]/g, function(c2) {
        return "_x" + c2.charCodeAt(0).toString(16) + "_";
      }).replace(/[\u0080-\uFFFF]/g, function(u2) {
        return "_u" + u2.charCodeAt(0).toString(16) + "_";
      });
      var ca = fi.content;
      var cstr = has_buf && Buffer.isBuffer(ca) ? ca.toString("binary") : a2s2(ca);
      var dispcnt = 0, L2 = Math.min(1024, cstr.length), cc = 0;
      for (var csl = 0; csl <= L2; ++csl)
        if ((cc = cstr.charCodeAt(csl)) >= 32 && cc < 128)
          ++dispcnt;
      var qp = dispcnt >= L2 * 4 / 5;
      out.push(boundary);
      out.push("Content-Location: " + (opts.root || "file:///C:/SheetJS/") + fp);
      out.push("Content-Transfer-Encoding: " + (qp ? "quoted-printable" : "base64"));
      out.push("Content-Type: " + get_content_type(fi, fp));
      out.push("");
      out.push(qp ? write_quoted_printable(cstr) : write_base64_76(cstr));
    }
    out.push(boundary + "--\r\n");
    return out.join("\r\n");
  }
  function cfb_new(opts) {
    var o2 = {};
    init_cfb(o2, opts);
    return o2;
  }
  function cfb_add(cfb, name, content, opts) {
    var unsafe = opts && opts.unsafe;
    if (!unsafe)
      init_cfb(cfb);
    var file = !unsafe && CFB.find(cfb, name);
    if (!file) {
      var fpath = cfb.FullPaths[0];
      if (name.slice(0, fpath.length) == fpath)
        fpath = name;
      else {
        if (fpath.slice(-1) != "/")
          fpath += "/";
        fpath = (fpath + name).replace("//", "/");
      }
      file = { name: filename(name), type: 2 };
      cfb.FileIndex.push(file);
      cfb.FullPaths.push(fpath);
      if (!unsafe)
        CFB.utils.cfb_gc(cfb);
    }
    file.content = content;
    file.size = content ? content.length : 0;
    if (opts) {
      if (opts.CLSID)
        file.clsid = opts.CLSID;
      if (opts.mt)
        file.mt = opts.mt;
      if (opts.ct)
        file.ct = opts.ct;
    }
    return file;
  }
  function cfb_del(cfb, name) {
    init_cfb(cfb);
    var file = CFB.find(cfb, name);
    if (file) {
      for (var j2 = 0; j2 < cfb.FileIndex.length; ++j2)
        if (cfb.FileIndex[j2] == file) {
          cfb.FileIndex.splice(j2, 1);
          cfb.FullPaths.splice(j2, 1);
          return true;
        }
    }
    return false;
  }
  function cfb_mov(cfb, old_name, new_name) {
    init_cfb(cfb);
    var file = CFB.find(cfb, old_name);
    if (file) {
      for (var j2 = 0; j2 < cfb.FileIndex.length; ++j2)
        if (cfb.FileIndex[j2] == file) {
          cfb.FileIndex[j2].name = filename(new_name);
          cfb.FullPaths[j2] = new_name;
          return true;
        }
    }
    return false;
  }
  function cfb_gc(cfb) {
    rebuild_cfb(cfb, true);
  }
  exports.find = find;
  exports.read = read;
  exports.parse = parse;
  exports.write = write;
  exports.writeFile = write_file;
  exports.utils = {
    cfb_new,
    cfb_add,
    cfb_del,
    cfb_mov,
    cfb_gc,
    ReadShift,
    CheckField,
    prep_blob,
    bconcat,
    use_zlib,
    _deflateRaw: _deflate,
    _inflateRaw: _inflate,
    consts
  };
  return exports;
}();
var _fs = void 0;
function blobify(data) {
  if (typeof data === "string")
    return s2ab(data);
  if (Array.isArray(data))
    return a2u(data);
  return data;
}
function write_dl(fname, payload, enc) {
  if (typeof _fs !== "undefined" && _fs.writeFileSync)
    return enc ? _fs.writeFileSync(fname, payload, enc) : _fs.writeFileSync(fname, payload);
  if (typeof Deno !== "undefined") {
    if (enc && typeof payload == "string")
      switch (enc) {
        case "utf8":
          payload = new TextEncoder(enc).encode(payload);
          break;
        case "binary":
          payload = s2ab(payload);
          break;
        default:
          throw new Error("Unsupported encoding " + enc);
      }
    return Deno.writeFileSync(fname, payload);
  }
  var data = enc == "utf8" ? utf8write(payload) : payload;
  if (typeof IE_SaveFile !== "undefined")
    return IE_SaveFile(data, fname);
  if (typeof Blob !== "undefined") {
    var blob = new Blob([blobify(data)], { type: "application/octet-stream" });
    if (typeof navigator !== "undefined" && navigator.msSaveBlob)
      return navigator.msSaveBlob(blob, fname);
    if (typeof saveAs !== "undefined")
      return saveAs(blob, fname);
    if (typeof URL !== "undefined" && typeof document !== "undefined" && document.createElement && URL.createObjectURL) {
      var url = URL.createObjectURL(blob);
      if (typeof chrome === "object" && typeof (chrome.downloads || {}).download == "function") {
        if (URL.revokeObjectURL && typeof setTimeout !== "undefined")
          setTimeout(function() {
            URL.revokeObjectURL(url);
          }, 6e4);
        return chrome.downloads.download({ url, filename: fname, saveAs: true });
      }
      var a2 = document.createElement("a");
      if (a2.download != null) {
        a2.download = fname;
        a2.href = url;
        document.body.appendChild(a2);
        a2.click();
        document.body.removeChild(a2);
        if (URL.revokeObjectURL && typeof setTimeout !== "undefined")
          setTimeout(function() {
            URL.revokeObjectURL(url);
          }, 6e4);
        return url;
      }
    }
  }
  if (typeof $ !== "undefined" && typeof File !== "undefined" && typeof Folder !== "undefined")
    try {
      var out = File(fname);
      out.open("w");
      out.encoding = "binary";
      if (Array.isArray(payload))
        payload = a2s(payload);
      out.write(payload);
      out.close();
      return payload;
    } catch (e) {
      if (!e.message || !e.message.match(/onstruct/))
        throw e;
    }
  throw new Error("cannot save file " + fname);
}
function read_binary(path) {
  if (typeof _fs !== "undefined")
    return _fs.readFileSync(path);
  if (typeof Deno !== "undefined")
    return Deno.readFileSync(path);
  if (typeof $ !== "undefined" && typeof File !== "undefined" && typeof Folder !== "undefined")
    try {
      var infile = File(path);
      infile.open("r");
      infile.encoding = "binary";
      var data = infile.read();
      infile.close();
      return data;
    } catch (e) {
      if (!e.message || !e.message.match(/onstruct/))
        throw e;
    }
  throw new Error("Cannot access file " + path);
}
function keys(o2) {
  var ks = Object.keys(o2), o22 = [];
  for (var i2 = 0; i2 < ks.length; ++i2)
    if (Object.prototype.hasOwnProperty.call(o2, ks[i2]))
      o22.push(ks[i2]);
  return o22;
}
function evert_key(obj, key) {
  var o2 = [], K2 = keys(obj);
  for (var i2 = 0; i2 !== K2.length; ++i2)
    if (o2[obj[K2[i2]][key]] == null)
      o2[obj[K2[i2]][key]] = K2[i2];
  return o2;
}
function evert(obj) {
  var o2 = [], K2 = keys(obj);
  for (var i2 = 0; i2 !== K2.length; ++i2)
    o2[obj[K2[i2]]] = K2[i2];
  return o2;
}
function evert_num(obj) {
  var o2 = [], K2 = keys(obj);
  for (var i2 = 0; i2 !== K2.length; ++i2)
    o2[obj[K2[i2]]] = parseInt(K2[i2], 10);
  return o2;
}
function evert_arr(obj) {
  var o2 = [], K2 = keys(obj);
  for (var i2 = 0; i2 !== K2.length; ++i2) {
    if (o2[obj[K2[i2]]] == null)
      o2[obj[K2[i2]]] = [];
    o2[obj[K2[i2]]].push(K2[i2]);
  }
  return o2;
}
var basedate = /* @__PURE__ */ new Date(1899, 11, 30, 0, 0, 0);
function datenum(v2, date1904) {
  var epoch = /* @__PURE__ */ v2.getTime();
  if (date1904)
    epoch -= 1462 * 24 * 60 * 60 * 1e3;
  var dnthresh2 = /* @__PURE__ */ basedate.getTime() + (/* @__PURE__ */ v2.getTimezoneOffset() - /* @__PURE__ */ basedate.getTimezoneOffset()) * 6e4;
  return (epoch - dnthresh2) / (24 * 60 * 60 * 1e3);
}
var refdate = /* @__PURE__ */ new Date();
var dnthresh = /* @__PURE__ */ basedate.getTime() + (/* @__PURE__ */ refdate.getTimezoneOffset() - /* @__PURE__ */ basedate.getTimezoneOffset()) * 6e4;
var refoffset = /* @__PURE__ */ refdate.getTimezoneOffset();
function numdate(v2) {
  var out = /* @__PURE__ */ new Date();
  out.setTime(v2 * 24 * 60 * 60 * 1e3 + dnthresh);
  if (out.getTimezoneOffset() !== refoffset) {
    out.setTime(out.getTime() + (out.getTimezoneOffset() - refoffset) * 6e4);
  }
  return out;
}
function parse_isodur(s2) {
  var sec = 0, mt2 = 0, time = false;
  var m2 = s2.match(/P([0-9\.]+Y)?([0-9\.]+M)?([0-9\.]+D)?T([0-9\.]+H)?([0-9\.]+M)?([0-9\.]+S)?/);
  if (!m2)
    throw new Error("|" + s2 + "| is not an ISO8601 Duration");
  for (var i2 = 1; i2 != m2.length; ++i2) {
    if (!m2[i2])
      continue;
    mt2 = 1;
    if (i2 > 3)
      time = true;
    switch (m2[i2].slice(m2[i2].length - 1)) {
      case "Y":
        throw new Error("Unsupported ISO Duration Field: " + m2[i2].slice(m2[i2].length - 1));
      case "D":
        mt2 *= 24;
      case "H":
        mt2 *= 60;
      case "M":
        if (!time)
          throw new Error("Unsupported ISO Duration Field: M");
        else
          mt2 *= 60;
      case "S":
        break;
    }
    sec += mt2 * parseInt(m2[i2], 10);
  }
  return sec;
}
var good_pd_date_1 = /* @__PURE__ */ new Date("2017-02-19T19:06:09.000Z");
var good_pd_date = /* @__PURE__ */ isNaN(/* @__PURE__ */ good_pd_date_1.getFullYear()) ? /* @__PURE__ */ new Date("2/19/17") : good_pd_date_1;
var good_pd = /* @__PURE__ */ good_pd_date.getFullYear() == 2017;
function parseDate(str, fixdate) {
  var d2 = new Date(str);
  if (good_pd) {
    if (fixdate > 0)
      d2.setTime(d2.getTime() + d2.getTimezoneOffset() * 60 * 1e3);
    else if (fixdate < 0)
      d2.setTime(d2.getTime() - d2.getTimezoneOffset() * 60 * 1e3);
    return d2;
  }
  if (str instanceof Date)
    return str;
  if (good_pd_date.getFullYear() == 1917 && !isNaN(d2.getFullYear())) {
    var s2 = d2.getFullYear();
    if (str.indexOf("" + s2) > -1)
      return d2;
    d2.setFullYear(d2.getFullYear() + 100);
    return d2;
  }
  var n2 = str.match(/\d+/g) || ["2017", "2", "19", "0", "0", "0"];
  var out = new Date(+n2[0], +n2[1] - 1, +n2[2], +n2[3] || 0, +n2[4] || 0, +n2[5] || 0);
  if (str.indexOf("Z") > -1)
    out = new Date(out.getTime() - out.getTimezoneOffset() * 60 * 1e3);
  return out;
}
function cc2str(arr, debomit) {
  if (has_buf && Buffer.isBuffer(arr)) {
    if (debomit) {
      if (arr[0] == 255 && arr[1] == 254)
        return utf8write(arr.slice(2).toString("utf16le"));
      if (arr[1] == 254 && arr[2] == 255)
        return utf8write(utf16beread(arr.slice(2).toString("binary")));
    }
    return arr.toString("binary");
  }
  if (typeof TextDecoder !== "undefined")
    try {
      if (debomit) {
        if (arr[0] == 255 && arr[1] == 254)
          return utf8write(new TextDecoder("utf-16le").decode(arr.slice(2)));
        if (arr[0] == 254 && arr[1] == 255)
          return utf8write(new TextDecoder("utf-16be").decode(arr.slice(2)));
      }
      var rev2 = {
        "\u20AC": "\x80",
        "\u201A": "\x82",
        "\u0192": "\x83",
        "\u201E": "\x84",
        "\u2026": "\x85",
        "\u2020": "\x86",
        "\u2021": "\x87",
        "\u02C6": "\x88",
        "\u2030": "\x89",
        "\u0160": "\x8A",
        "\u2039": "\x8B",
        "\u0152": "\x8C",
        "\u017D": "\x8E",
        "\u2018": "\x91",
        "\u2019": "\x92",
        "\u201C": "\x93",
        "\u201D": "\x94",
        "\u2022": "\x95",
        "\u2013": "\x96",
        "\u2014": "\x97",
        "\u02DC": "\x98",
        "\u2122": "\x99",
        "\u0161": "\x9A",
        "\u203A": "\x9B",
        "\u0153": "\x9C",
        "\u017E": "\x9E",
        "\u0178": "\x9F"
      };
      if (Array.isArray(arr))
        arr = new Uint8Array(arr);
      return new TextDecoder("latin1").decode(arr).replace(/[€‚ƒ„…†‡ˆ‰Š‹ŒŽ‘’“”•–—˜™š›œžŸ]/g, function(c2) {
        return rev2[c2] || c2;
      });
    } catch (e) {
    }
  var o2 = [];
  for (var i2 = 0; i2 != arr.length; ++i2)
    o2.push(String.fromCharCode(arr[i2]));
  return o2.join("");
}
function dup(o2) {
  if (typeof JSON != "undefined" && !Array.isArray(o2))
    return JSON.parse(JSON.stringify(o2));
  if (typeof o2 != "object" || o2 == null)
    return o2;
  if (o2 instanceof Date)
    return new Date(o2.getTime());
  var out = {};
  for (var k2 in o2)
    if (Object.prototype.hasOwnProperty.call(o2, k2))
      out[k2] = dup(o2[k2]);
  return out;
}
function fill(c2, l2) {
  var o2 = "";
  while (o2.length < l2)
    o2 += c2;
  return o2;
}
function fuzzynum(s2) {
  var v2 = Number(s2);
  if (!isNaN(v2))
    return isFinite(v2) ? v2 : NaN;
  if (!/\d/.test(s2))
    return v2;
  var wt2 = 1;
  var ss = s2.replace(/([\d]),([\d])/g, "$1$2").replace(/[$]/g, "").replace(/[%]/g, function() {
    wt2 *= 100;
    return "";
  });
  if (!isNaN(v2 = Number(ss)))
    return v2 / wt2;
  ss = ss.replace(/[(](.*)[)]/, function($$, $1) {
    wt2 = -wt2;
    return $1;
  });
  if (!isNaN(v2 = Number(ss)))
    return v2 / wt2;
  return v2;
}
var lower_months = ["january", "february", "march", "april", "may", "june", "july", "august", "september", "october", "november", "december"];
function fuzzydate(s2) {
  var o2 = new Date(s2), n2 = /* @__PURE__ */ new Date(NaN);
  var y2 = o2.getYear(), m2 = o2.getMonth(), d2 = o2.getDate();
  if (isNaN(d2))
    return n2;
  var lower = s2.toLowerCase();
  if (lower.match(/jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec/)) {
    lower = lower.replace(/[^a-z]/g, "").replace(/([^a-z]|^)[ap]m?([^a-z]|$)/, "");
    if (lower.length > 3 && lower_months.indexOf(lower) == -1)
      return n2;
  } else if (lower.match(/[a-z]/))
    return n2;
  if (y2 < 0 || y2 > 8099)
    return n2;
  if ((m2 > 0 || d2 > 1) && y2 != 101)
    return o2;
  if (s2.match(/[^-0-9:,\/\\]/))
    return n2;
  return o2;
}
var split_regex = /* @__PURE__ */ function() {
  var safe_split_regex = "abacaba".split(/(:?b)/i).length == 5;
  return function split_regex2(str, re2, def) {
    if (safe_split_regex || typeof re2 == "string")
      return str.split(re2);
    var p2 = str.split(re2), o2 = [p2[0]];
    for (var i2 = 1; i2 < p2.length; ++i2) {
      o2.push(def);
      o2.push(p2[i2]);
    }
    return o2;
  };
}();
function getdatastr(data) {
  if (!data)
    return null;
  if (data.content && data.type)
    return cc2str(data.content, true);
  if (data.data)
    return debom(data.data);
  if (data.asNodeBuffer && has_buf)
    return debom(data.asNodeBuffer().toString("binary"));
  if (data.asBinary)
    return debom(data.asBinary());
  if (data._data && data._data.getContent)
    return debom(cc2str(Array.prototype.slice.call(data._data.getContent(), 0)));
  return null;
}
function getdatabin(data) {
  if (!data)
    return null;
  if (data.data)
    return char_codes(data.data);
  if (data.asNodeBuffer && has_buf)
    return data.asNodeBuffer();
  if (data._data && data._data.getContent) {
    var o2 = data._data.getContent();
    if (typeof o2 == "string")
      return char_codes(o2);
    return Array.prototype.slice.call(o2);
  }
  if (data.content && data.type)
    return data.content;
  return null;
}
function getdata(data) {
  return data && data.name.slice(-4) === ".bin" ? getdatabin(data) : getdatastr(data);
}
function safegetzipfile(zip, file) {
  var k2 = zip.FullPaths || keys(zip.files);
  var f2 = file.toLowerCase().replace(/[\/]/g, "\\"), g2 = f2.replace(/\\/g, "/");
  for (var i2 = 0; i2 < k2.length; ++i2) {
    var n2 = k2[i2].replace(/^Root Entry[\/]/, "").toLowerCase();
    if (f2 == n2 || g2 == n2)
      return zip.files ? zip.files[k2[i2]] : zip.FileIndex[i2];
  }
  return null;
}
function getzipfile(zip, file) {
  var o2 = safegetzipfile(zip, file);
  if (o2 == null)
    throw new Error("Cannot find file " + file + " in zip");
  return o2;
}
function getzipdata(zip, file, safe) {
  if (!safe)
    return getdata(getzipfile(zip, file));
  if (!file)
    return null;
  try {
    return getzipdata(zip, file);
  } catch (e) {
    return null;
  }
}
function getzipstr(zip, file, safe) {
  if (!safe)
    return getdatastr(getzipfile(zip, file));
  if (!file)
    return null;
  try {
    return getzipstr(zip, file);
  } catch (e) {
    return null;
  }
}
function getzipbin(zip, file, safe) {
  if (!safe)
    return getdatabin(getzipfile(zip, file));
  if (!file)
    return null;
  try {
    return getzipbin(zip, file);
  } catch (e) {
    return null;
  }
}
function zipentries(zip) {
  var k2 = zip.FullPaths || keys(zip.files), o2 = [];
  for (var i2 = 0; i2 < k2.length; ++i2)
    if (k2[i2].slice(-1) != "/")
      o2.push(k2[i2].replace(/^Root Entry[\/]/, ""));
  return o2.sort();
}
function zip_add_file(zip, path, content) {
  if (zip.FullPaths) {
    if (typeof content == "string") {
      var res;
      if (has_buf)
        res = Buffer_from(content);
      else
        res = utf8decode(content);
      return CFB.utils.cfb_add(zip, path, res);
    }
    CFB.utils.cfb_add(zip, path, content);
  } else
    zip.file(path, content);
}
function zip_new() {
  return CFB.utils.cfb_new();
}
function zip_read(d2, o2) {
  switch (o2.type) {
    case "base64":
      return CFB.read(d2, { type: "base64" });
    case "binary":
      return CFB.read(d2, { type: "binary" });
    case "buffer":
    case "array":
      return CFB.read(d2, { type: "buffer" });
  }
  throw new Error("Unrecognized type " + o2.type);
}
function resolve_path(path, base) {
  if (path.charAt(0) == "/")
    return path.slice(1);
  var result = base.split("/");
  if (base.slice(-1) != "/")
    result.pop();
  var target = path.split("/");
  while (target.length !== 0) {
    var step = target.shift();
    if (step === "..")
      result.pop();
    else if (step !== ".")
      result.push(step);
  }
  return result.join("/");
}
var XML_HEADER = '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>\r\n';
var attregexg = /([^"\s?>\/]+)\s*=\s*((?:")([^"]*)(?:")|(?:')([^']*)(?:')|([^'">\s]+))/g;
var tagregex1 = /<[\/\?]?[a-zA-Z0-9:_-]+(?:\s+[^"\s?>\/]+\s*=\s*(?:"[^"]*"|'[^']*'|[^'">\s=]+))*\s*[\/\?]?>/mg;
var tagregex2 = /<[^>]*>/g;
var tagregex = /* @__PURE__ */ XML_HEADER.match(tagregex1) ? tagregex1 : tagregex2;
var nsregex = /<\w*:/;
var nsregex2 = /<(\/?)\w+:/;
function parsexmltag(tag, skip_root, skip_LC) {
  var z2 = {};
  var eq = 0, c2 = 0;
  for (; eq !== tag.length; ++eq)
    if ((c2 = tag.charCodeAt(eq)) === 32 || c2 === 10 || c2 === 13)
      break;
  if (!skip_root)
    z2[0] = tag.slice(0, eq);
  if (eq === tag.length)
    return z2;
  var m2 = tag.match(attregexg), j2 = 0, v2 = "", i2 = 0, q2 = "", cc = "", quot = 1;
  if (m2)
    for (i2 = 0; i2 != m2.length; ++i2) {
      cc = m2[i2];
      for (c2 = 0; c2 != cc.length; ++c2)
        if (cc.charCodeAt(c2) === 61)
          break;
      q2 = cc.slice(0, c2).trim();
      while (cc.charCodeAt(c2 + 1) == 32)
        ++c2;
      quot = (eq = cc.charCodeAt(c2 + 1)) == 34 || eq == 39 ? 1 : 0;
      v2 = cc.slice(c2 + 1 + quot, cc.length - quot);
      for (j2 = 0; j2 != q2.length; ++j2)
        if (q2.charCodeAt(j2) === 58)
          break;
      if (j2 === q2.length) {
        if (q2.indexOf("_") > 0)
          q2 = q2.slice(0, q2.indexOf("_"));
        z2[q2] = v2;
        if (!skip_LC)
          z2[q2.toLowerCase()] = v2;
      } else {
        var k2 = (j2 === 5 && q2.slice(0, 5) === "xmlns" ? "xmlns" : "") + q2.slice(j2 + 1);
        if (z2[k2] && q2.slice(j2 - 3, j2) == "ext")
          continue;
        z2[k2] = v2;
        if (!skip_LC)
          z2[k2.toLowerCase()] = v2;
      }
    }
  return z2;
}
function strip_ns(x2) {
  return x2.replace(nsregex2, "<$1");
}
var encodings = {
  "&quot;": '"',
  "&apos;": "'",
  "&gt;": ">",
  "&lt;": "<",
  "&amp;": "&"
};
var rencoding = /* @__PURE__ */ evert(encodings);
var unescapexml = /* @__PURE__ */ function() {
  var encregex = /&(?:quot|apos|gt|lt|amp|#x?([\da-fA-F]+));/ig, coderegex = /_x([\da-fA-F]{4})_/ig;
  return function unescapexml2(text) {
    var s2 = text + "", i2 = s2.indexOf("<![CDATA[");
    if (i2 == -1)
      return s2.replace(encregex, function($$, $1) {
        return encodings[$$] || String.fromCharCode(parseInt($1, $$.indexOf("x") > -1 ? 16 : 10)) || $$;
      }).replace(coderegex, function(m2, c2) {
        return String.fromCharCode(parseInt(c2, 16));
      });
    var j2 = s2.indexOf("]]>");
    return unescapexml2(s2.slice(0, i2)) + s2.slice(i2 + 9, j2) + unescapexml2(s2.slice(j2 + 3));
  };
}();
var decregex = /[&<>'"]/g;
var charegex = /[\u0000-\u0008\u000b-\u001f]/g;
function escapexml(text) {
  var s2 = text + "";
  return s2.replace(decregex, function(y2) {
    return rencoding[y2];
  }).replace(charegex, function(s3) {
    return "_x" + ("000" + s3.charCodeAt(0).toString(16)).slice(-4) + "_";
  });
}
function escapexmltag(text) {
  return escapexml(text).replace(/ /g, "_x0020_");
}
var htmlcharegex = /[\u0000-\u001f]/g;
function escapehtml(text) {
  var s2 = text + "";
  return s2.replace(decregex, function(y2) {
    return rencoding[y2];
  }).replace(/\n/g, "<br/>").replace(htmlcharegex, function(s3) {
    return "&#x" + ("000" + s3.charCodeAt(0).toString(16)).slice(-4) + ";";
  });
}
function escapexlml(text) {
  var s2 = text + "";
  return s2.replace(decregex, function(y2) {
    return rencoding[y2];
  }).replace(htmlcharegex, function(s3) {
    return "&#x" + s3.charCodeAt(0).toString(16).toUpperCase() + ";";
  });
}
var xlml_fixstr = /* @__PURE__ */ function() {
  var entregex = /&#(\d+);/g;
  function entrepl($$, $1) {
    return String.fromCharCode(parseInt($1, 10));
  }
  return function xlml_fixstr2(str) {
    return str.replace(entregex, entrepl);
  };
}();
function xlml_unfixstr(str) {
  return str.replace(/(\r\n|[\r\n])/g, "&#10;");
}
function parsexmlbool(value) {
  switch (value) {
    case 1:
    case true:
    case "1":
    case "true":
    case "TRUE":
      return true;
    default:
      return false;
  }
}
function utf8reada(orig) {
  var out = "", i2 = 0, c2 = 0, d2 = 0, e = 0, f2 = 0, w2 = 0;
  while (i2 < orig.length) {
    c2 = orig.charCodeAt(i2++);
    if (c2 < 128) {
      out += String.fromCharCode(c2);
      continue;
    }
    d2 = orig.charCodeAt(i2++);
    if (c2 > 191 && c2 < 224) {
      f2 = (c2 & 31) << 6;
      f2 |= d2 & 63;
      out += String.fromCharCode(f2);
      continue;
    }
    e = orig.charCodeAt(i2++);
    if (c2 < 240) {
      out += String.fromCharCode((c2 & 15) << 12 | (d2 & 63) << 6 | e & 63);
      continue;
    }
    f2 = orig.charCodeAt(i2++);
    w2 = ((c2 & 7) << 18 | (d2 & 63) << 12 | (e & 63) << 6 | f2 & 63) - 65536;
    out += String.fromCharCode(55296 + (w2 >>> 10 & 1023));
    out += String.fromCharCode(56320 + (w2 & 1023));
  }
  return out;
}
function utf8readb(data) {
  var out = new_raw_buf(2 * data.length), w2, i2, j2 = 1, k2 = 0, ww = 0, c2;
  for (i2 = 0; i2 < data.length; i2 += j2) {
    j2 = 1;
    if ((c2 = data.charCodeAt(i2)) < 128)
      w2 = c2;
    else if (c2 < 224) {
      w2 = (c2 & 31) * 64 + (data.charCodeAt(i2 + 1) & 63);
      j2 = 2;
    } else if (c2 < 240) {
      w2 = (c2 & 15) * 4096 + (data.charCodeAt(i2 + 1) & 63) * 64 + (data.charCodeAt(i2 + 2) & 63);
      j2 = 3;
    } else {
      j2 = 4;
      w2 = (c2 & 7) * 262144 + (data.charCodeAt(i2 + 1) & 63) * 4096 + (data.charCodeAt(i2 + 2) & 63) * 64 + (data.charCodeAt(i2 + 3) & 63);
      w2 -= 65536;
      ww = 55296 + (w2 >>> 10 & 1023);
      w2 = 56320 + (w2 & 1023);
    }
    if (ww !== 0) {
      out[k2++] = ww & 255;
      out[k2++] = ww >>> 8;
      ww = 0;
    }
    out[k2++] = w2 % 256;
    out[k2++] = w2 >>> 8;
  }
  return out.slice(0, k2).toString("ucs2");
}
function utf8readc(data) {
  return Buffer_from(data, "binary").toString("utf8");
}
var utf8corpus = "foo bar baz\xE2\x98\x83\xF0\x9F\x8D\xA3";
var utf8read = has_buf && (/* @__PURE__ */ utf8readc(utf8corpus) == /* @__PURE__ */ utf8reada(utf8corpus) && utf8readc || /* @__PURE__ */ utf8readb(utf8corpus) == /* @__PURE__ */ utf8reada(utf8corpus) && utf8readb) || utf8reada;
var utf8write = has_buf ? function(data) {
  return Buffer_from(data, "utf8").toString("binary");
} : function(orig) {
  var out = [], i2 = 0, c2 = 0, d2 = 0;
  while (i2 < orig.length) {
    c2 = orig.charCodeAt(i2++);
    switch (true) {
      case c2 < 128:
        out.push(String.fromCharCode(c2));
        break;
      case c2 < 2048:
        out.push(String.fromCharCode(192 + (c2 >> 6)));
        out.push(String.fromCharCode(128 + (c2 & 63)));
        break;
      case (c2 >= 55296 && c2 < 57344):
        c2 -= 55296;
        d2 = orig.charCodeAt(i2++) - 56320 + (c2 << 10);
        out.push(String.fromCharCode(240 + (d2 >> 18 & 7)));
        out.push(String.fromCharCode(144 + (d2 >> 12 & 63)));
        out.push(String.fromCharCode(128 + (d2 >> 6 & 63)));
        out.push(String.fromCharCode(128 + (d2 & 63)));
        break;
      default:
        out.push(String.fromCharCode(224 + (c2 >> 12)));
        out.push(String.fromCharCode(128 + (c2 >> 6 & 63)));
        out.push(String.fromCharCode(128 + (c2 & 63)));
    }
  }
  return out.join("");
};
var matchtag = /* @__PURE__ */ function() {
  var mtcache = {};
  return function matchtag2(f2, g2) {
    var t2 = f2 + "|" + (g2 || "");
    if (mtcache[t2])
      return mtcache[t2];
    return mtcache[t2] = new RegExp("<(?:\\w+:)?" + f2 + '(?: xml:space="preserve")?(?:[^>]*)>([\\s\\S]*?)</(?:\\w+:)?' + f2 + ">", g2 || "");
  };
}();
var htmldecode = /* @__PURE__ */ function() {
  var entities = [
    ["nbsp", " "],
    ["middot", "\xB7"],
    ["quot", '"'],
    ["apos", "'"],
    ["gt", ">"],
    ["lt", "<"],
    ["amp", "&"]
  ].map(function(x2) {
    return [new RegExp("&" + x2[0] + ";", "ig"), x2[1]];
  });
  return function htmldecode2(str) {
    var o2 = str.replace(/^[\t\n\r ]+/, "").replace(/[\t\n\r ]+$/, "").replace(/>\s+/g, ">").replace(/\s+</g, "<").replace(/[\t\n\r ]+/g, " ").replace(/<\s*[bB][rR]\s*\/?>/g, "\n").replace(/<[^>]*>/g, "");
    for (var i2 = 0; i2 < entities.length; ++i2)
      o2 = o2.replace(entities[i2][0], entities[i2][1]);
    return o2;
  };
}();
var vtregex = /* @__PURE__ */ function() {
  var vt_cache = {};
  return function vt_regex(bt2) {
    if (vt_cache[bt2] !== void 0)
      return vt_cache[bt2];
    return vt_cache[bt2] = new RegExp("<(?:vt:)?" + bt2 + ">([\\s\\S]*?)</(?:vt:)?" + bt2 + ">", "g");
  };
}();
var vtvregex = /<\/?(?:vt:)?variant>/g;
var vtmregex = /<(?:vt:)([^>]*)>([\s\S]*)</;
function parseVector(data, opts) {
  var h2 = parsexmltag(data);
  var matches = data.match(vtregex(h2.baseType)) || [];
  var res = [];
  if (matches.length != h2.size) {
    if (opts.WTF)
      throw new Error("unexpected vector length " + matches.length + " != " + h2.size);
    return res;
  }
  matches.forEach(function(x2) {
    var v2 = x2.replace(vtvregex, "").match(vtmregex);
    if (v2)
      res.push({ v: utf8read(v2[2]), t: v2[1] });
  });
  return res;
}
var wtregex = /(^\s|\s$|\n)/;
function writetag(f2, g2) {
  return "<" + f2 + (g2.match(wtregex) ? ' xml:space="preserve"' : "") + ">" + g2 + "</" + f2 + ">";
}
function wxt_helper(h2) {
  return keys(h2).map(function(k2) {
    return " " + k2 + '="' + h2[k2] + '"';
  }).join("");
}
function writextag(f2, g2, h2) {
  return "<" + f2 + (h2 != null ? wxt_helper(h2) : "") + (g2 != null ? (g2.match(wtregex) ? ' xml:space="preserve"' : "") + ">" + g2 + "</" + f2 : "/") + ">";
}
function write_w3cdtf(d2, t2) {
  try {
    return d2.toISOString().replace(/\.\d*/, "");
  } catch (e) {
    if (t2)
      throw e;
  }
  return "";
}
function write_vt(s2, xlsx) {
  switch (typeof s2) {
    case "string":
      var o2 = writextag("vt:lpwstr", escapexml(s2));
      if (xlsx)
        o2 = o2.replace(/&quot;/g, "_x0022_");
      return o2;
    case "number":
      return writextag((s2 | 0) == s2 ? "vt:i4" : "vt:r8", escapexml(String(s2)));
    case "boolean":
      return writextag("vt:bool", s2 ? "true" : "false");
  }
  if (s2 instanceof Date)
    return writextag("vt:filetime", write_w3cdtf(s2));
  throw new Error("Unable to serialize " + s2);
}
function xlml_normalize(d2) {
  if (has_buf && /*::typeof Buffer !== "undefined" && d != null && d instanceof Buffer &&*/
  Buffer.isBuffer(d2))
    return d2.toString("utf8");
  if (typeof d2 === "string")
    return d2;
  if (typeof Uint8Array !== "undefined" && d2 instanceof Uint8Array)
    return utf8read(a2s(ab2a(d2)));
  throw new Error("Bad input format: expected Buffer or string");
}
var xlmlregex = /<(\/?)([^\s?><!\/:]*:|)([^\s?<>:\/]+)(?:[\s?:\/][^>]*)?>/mg;
var XMLNS = {
  CORE_PROPS: "http://schemas.openxmlformats.org/package/2006/metadata/core-properties",
  CUST_PROPS: "http://schemas.openxmlformats.org/officeDocument/2006/custom-properties",
  EXT_PROPS: "http://schemas.openxmlformats.org/officeDocument/2006/extended-properties",
  CT: "http://schemas.openxmlformats.org/package/2006/content-types",
  RELS: "http://schemas.openxmlformats.org/package/2006/relationships",
  TCMNT: "http://schemas.microsoft.com/office/spreadsheetml/2018/threadedcomments",
  "dc": "http://purl.org/dc/elements/1.1/",
  "dcterms": "http://purl.org/dc/terms/",
  "dcmitype": "http://purl.org/dc/dcmitype/",
  "mx": "http://schemas.microsoft.com/office/mac/excel/2008/main",
  "r": "http://schemas.openxmlformats.org/officeDocument/2006/relationships",
  "sjs": "http://schemas.openxmlformats.org/package/2006/sheetjs/core-properties",
  "vt": "http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes",
  "xsi": "http://www.w3.org/2001/XMLSchema-instance",
  "xsd": "http://www.w3.org/2001/XMLSchema"
};
var XMLNS_main = [
  "http://schemas.openxmlformats.org/spreadsheetml/2006/main",
  "http://purl.oclc.org/ooxml/spreadsheetml/main",
  "http://schemas.microsoft.com/office/excel/2006/main",
  "http://schemas.microsoft.com/office/excel/2006/2"
];
var XLMLNS = {
  "o": "urn:schemas-microsoft-com:office:office",
  "x": "urn:schemas-microsoft-com:office:excel",
  "ss": "urn:schemas-microsoft-com:office:spreadsheet",
  "dt": "uuid:C2F41010-65B3-11d1-A29F-00AA00C14882",
  "mv": "http://macVmlSchemaUri",
  "v": "urn:schemas-microsoft-com:vml",
  "html": "http://www.w3.org/TR/REC-html40"
};
function read_double_le(b2, idx) {
  var s2 = 1 - 2 * (b2[idx + 7] >>> 7);
  var e = ((b2[idx + 7] & 127) << 4) + (b2[idx + 6] >>> 4 & 15);
  var m2 = b2[idx + 6] & 15;
  for (var i2 = 5; i2 >= 0; --i2)
    m2 = m2 * 256 + b2[idx + i2];
  if (e == 2047)
    return m2 == 0 ? s2 * Infinity : NaN;
  if (e == 0)
    e = -1022;
  else {
    e -= 1023;
    m2 += Math.pow(2, 52);
  }
  return s2 * Math.pow(2, e - 52) * m2;
}
function write_double_le(b2, v2, idx) {
  var bs = (v2 < 0 || 1 / v2 == -Infinity ? 1 : 0) << 7, e = 0, m2 = 0;
  var av = bs ? -v2 : v2;
  if (!isFinite(av)) {
    e = 2047;
    m2 = isNaN(v2) ? 26985 : 0;
  } else if (av == 0)
    e = m2 = 0;
  else {
    e = Math.floor(Math.log(av) / Math.LN2);
    m2 = av * Math.pow(2, 52 - e);
    if (e <= -1023 && (!isFinite(m2) || m2 < Math.pow(2, 52))) {
      e = -1022;
    } else {
      m2 -= Math.pow(2, 52);
      e += 1023;
    }
  }
  for (var i2 = 0; i2 <= 5; ++i2, m2 /= 256)
    b2[idx + i2] = m2 & 255;
  b2[idx + 6] = (e & 15) << 4 | m2 & 15;
  b2[idx + 7] = e >> 4 | bs;
}
var ___toBuffer = function(bufs) {
  var x2 = [], w2 = 10240;
  for (var i2 = 0; i2 < bufs[0].length; ++i2)
    if (bufs[0][i2])
      for (var j2 = 0, L2 = bufs[0][i2].length; j2 < L2; j2 += w2)
        x2.push.apply(x2, bufs[0][i2].slice(j2, j2 + w2));
  return x2;
};
var __toBuffer = has_buf ? function(bufs) {
  return bufs[0].length > 0 && Buffer.isBuffer(bufs[0][0]) ? Buffer.concat(bufs[0].map(function(x2) {
    return Buffer.isBuffer(x2) ? x2 : Buffer_from(x2);
  })) : ___toBuffer(bufs);
} : ___toBuffer;
var ___utf16le = function(b2, s2, e) {
  var ss = [];
  for (var i2 = s2; i2 < e; i2 += 2)
    ss.push(String.fromCharCode(__readUInt16LE(b2, i2)));
  return ss.join("").replace(chr0, "");
};
var __utf16le = has_buf ? function(b2, s2, e) {
  if (!Buffer.isBuffer(b2))
    return ___utf16le(b2, s2, e);
  return b2.toString("utf16le", s2, e).replace(chr0, "");
} : ___utf16le;
var ___hexlify = function(b2, s2, l2) {
  var ss = [];
  for (var i2 = s2; i2 < s2 + l2; ++i2)
    ss.push(("0" + b2[i2].toString(16)).slice(-2));
  return ss.join("");
};
var __hexlify = has_buf ? function(b2, s2, l2) {
  return Buffer.isBuffer(b2) ? b2.toString("hex", s2, s2 + l2) : ___hexlify(b2, s2, l2);
} : ___hexlify;
var ___utf8 = function(b2, s2, e) {
  var ss = [];
  for (var i2 = s2; i2 < e; i2++)
    ss.push(String.fromCharCode(__readUInt8(b2, i2)));
  return ss.join("");
};
var __utf8 = has_buf ? function utf8_b(b2, s2, e) {
  return Buffer.isBuffer(b2) ? b2.toString("utf8", s2, e) : ___utf8(b2, s2, e);
} : ___utf8;
var ___lpstr = function(b2, i2) {
  var len = __readUInt32LE(b2, i2);
  return len > 0 ? __utf8(b2, i2 + 4, i2 + 4 + len - 1) : "";
};
var __lpstr = ___lpstr;
var ___cpstr = function(b2, i2) {
  var len = __readUInt32LE(b2, i2);
  return len > 0 ? __utf8(b2, i2 + 4, i2 + 4 + len - 1) : "";
};
var __cpstr = ___cpstr;
var ___lpwstr = function(b2, i2) {
  var len = 2 * __readUInt32LE(b2, i2);
  return len > 0 ? __utf8(b2, i2 + 4, i2 + 4 + len - 1) : "";
};
var __lpwstr = ___lpwstr;
var ___lpp4 = function lpp4_(b2, i2) {
  var len = __readUInt32LE(b2, i2);
  return len > 0 ? __utf16le(b2, i2 + 4, i2 + 4 + len) : "";
};
var __lpp4 = ___lpp4;
var ___8lpp4 = function(b2, i2) {
  var len = __readUInt32LE(b2, i2);
  return len > 0 ? __utf8(b2, i2 + 4, i2 + 4 + len) : "";
};
var __8lpp4 = ___8lpp4;
var ___double = function(b2, idx) {
  return read_double_le(b2, idx);
};
var __double = ___double;
var is_buf = function is_buf_a(a2) {
  return Array.isArray(a2) || typeof Uint8Array !== "undefined" && a2 instanceof Uint8Array;
};
if (has_buf) {
  __lpstr = function lpstr_b(b2, i2) {
    if (!Buffer.isBuffer(b2))
      return ___lpstr(b2, i2);
    var len = b2.readUInt32LE(i2);
    return len > 0 ? b2.toString("utf8", i2 + 4, i2 + 4 + len - 1) : "";
  };
  __cpstr = function cpstr_b(b2, i2) {
    if (!Buffer.isBuffer(b2))
      return ___cpstr(b2, i2);
    var len = b2.readUInt32LE(i2);
    return len > 0 ? b2.toString("utf8", i2 + 4, i2 + 4 + len - 1) : "";
  };
  __lpwstr = function lpwstr_b(b2, i2) {
    if (!Buffer.isBuffer(b2))
      return ___lpwstr(b2, i2);
    var len = 2 * b2.readUInt32LE(i2);
    return b2.toString("utf16le", i2 + 4, i2 + 4 + len - 1);
  };
  __lpp4 = function lpp4_b(b2, i2) {
    if (!Buffer.isBuffer(b2))
      return ___lpp4(b2, i2);
    var len = b2.readUInt32LE(i2);
    return b2.toString("utf16le", i2 + 4, i2 + 4 + len);
  };
  __8lpp4 = function lpp4_8b(b2, i2) {
    if (!Buffer.isBuffer(b2))
      return ___8lpp4(b2, i2);
    var len = b2.readUInt32LE(i2);
    return b2.toString("utf8", i2 + 4, i2 + 4 + len);
  };
  __double = function double_(b2, i2) {
    if (Buffer.isBuffer(b2))
      return b2.readDoubleLE(i2);
    return ___double(b2, i2);
  };
  is_buf = function is_buf_b(a2) {
    return Buffer.isBuffer(a2) || Array.isArray(a2) || typeof Uint8Array !== "undefined" && a2 instanceof Uint8Array;
  };
}
function cpdoit() {
  __utf16le = function(b2, s2, e) {
    return $cptable.utils.decode(1200, b2.slice(s2, e)).replace(chr0, "");
  };
  __utf8 = function(b2, s2, e) {
    return $cptable.utils.decode(65001, b2.slice(s2, e));
  };
  __lpstr = function(b2, i2) {
    var len = __readUInt32LE(b2, i2);
    return len > 0 ? $cptable.utils.decode(current_ansi, b2.slice(i2 + 4, i2 + 4 + len - 1)) : "";
  };
  __cpstr = function(b2, i2) {
    var len = __readUInt32LE(b2, i2);
    return len > 0 ? $cptable.utils.decode(current_codepage, b2.slice(i2 + 4, i2 + 4 + len - 1)) : "";
  };
  __lpwstr = function(b2, i2) {
    var len = 2 * __readUInt32LE(b2, i2);
    return len > 0 ? $cptable.utils.decode(1200, b2.slice(i2 + 4, i2 + 4 + len - 1)) : "";
  };
  __lpp4 = function(b2, i2) {
    var len = __readUInt32LE(b2, i2);
    return len > 0 ? $cptable.utils.decode(1200, b2.slice(i2 + 4, i2 + 4 + len)) : "";
  };
  __8lpp4 = function(b2, i2) {
    var len = __readUInt32LE(b2, i2);
    return len > 0 ? $cptable.utils.decode(65001, b2.slice(i2 + 4, i2 + 4 + len)) : "";
  };
}
if (typeof $cptable !== "undefined")
  cpdoit();
var __readUInt8 = function(b2, idx) {
  return b2[idx];
};
var __readUInt16LE = function(b2, idx) {
  return b2[idx + 1] * (1 << 8) + b2[idx];
};
var __readInt16LE = function(b2, idx) {
  var u2 = b2[idx + 1] * (1 << 8) + b2[idx];
  return u2 < 32768 ? u2 : (65535 - u2 + 1) * -1;
};
var __readUInt32LE = function(b2, idx) {
  return b2[idx + 3] * (1 << 24) + (b2[idx + 2] << 16) + (b2[idx + 1] << 8) + b2[idx];
};
var __readInt32LE = function(b2, idx) {
  return b2[idx + 3] << 24 | b2[idx + 2] << 16 | b2[idx + 1] << 8 | b2[idx];
};
var __readInt32BE = function(b2, idx) {
  return b2[idx] << 24 | b2[idx + 1] << 16 | b2[idx + 2] << 8 | b2[idx + 3];
};
function ReadShift(size, t2) {
  var o2 = "", oI, oR, oo = [], w2, vv, i2, loc;
  switch (t2) {
    case "dbcs":
      loc = this.l;
      if (has_buf && Buffer.isBuffer(this))
        o2 = this.slice(this.l, this.l + 2 * size).toString("utf16le");
      else
        for (i2 = 0; i2 < size; ++i2) {
          o2 += String.fromCharCode(__readUInt16LE(this, loc));
          loc += 2;
        }
      size *= 2;
      break;
    case "utf8":
      o2 = __utf8(this, this.l, this.l + size);
      break;
    case "utf16le":
      size *= 2;
      o2 = __utf16le(this, this.l, this.l + size);
      break;
    case "wstr":
      if (typeof $cptable !== "undefined")
        o2 = $cptable.utils.decode(current_codepage, this.slice(this.l, this.l + 2 * size));
      else
        return ReadShift.call(this, size, "dbcs");
      size = 2 * size;
      break;
    case "lpstr-ansi":
      o2 = __lpstr(this, this.l);
      size = 4 + __readUInt32LE(this, this.l);
      break;
    case "lpstr-cp":
      o2 = __cpstr(this, this.l);
      size = 4 + __readUInt32LE(this, this.l);
      break;
    case "lpwstr":
      o2 = __lpwstr(this, this.l);
      size = 4 + 2 * __readUInt32LE(this, this.l);
      break;
    case "lpp4":
      size = 4 + __readUInt32LE(this, this.l);
      o2 = __lpp4(this, this.l);
      if (size & 2)
        size += 2;
      break;
    case "8lpp4":
      size = 4 + __readUInt32LE(this, this.l);
      o2 = __8lpp4(this, this.l);
      if (size & 3)
        size += 4 - (size & 3);
      break;
    case "cstr":
      size = 0;
      o2 = "";
      while ((w2 = __readUInt8(this, this.l + size++)) !== 0)
        oo.push(_getchar(w2));
      o2 = oo.join("");
      break;
    case "_wstr":
      size = 0;
      o2 = "";
      while ((w2 = __readUInt16LE(this, this.l + size)) !== 0) {
        oo.push(_getchar(w2));
        size += 2;
      }
      size += 2;
      o2 = oo.join("");
      break;
    case "dbcs-cont":
      o2 = "";
      loc = this.l;
      for (i2 = 0; i2 < size; ++i2) {
        if (this.lens && this.lens.indexOf(loc) !== -1) {
          w2 = __readUInt8(this, loc);
          this.l = loc + 1;
          vv = ReadShift.call(this, size - i2, w2 ? "dbcs-cont" : "sbcs-cont");
          return oo.join("") + vv;
        }
        oo.push(_getchar(__readUInt16LE(this, loc)));
        loc += 2;
      }
      o2 = oo.join("");
      size *= 2;
      break;
    case "cpstr":
      if (typeof $cptable !== "undefined") {
        o2 = $cptable.utils.decode(current_codepage, this.slice(this.l, this.l + size));
        break;
      }
    case "sbcs-cont":
      o2 = "";
      loc = this.l;
      for (i2 = 0; i2 != size; ++i2) {
        if (this.lens && this.lens.indexOf(loc) !== -1) {
          w2 = __readUInt8(this, loc);
          this.l = loc + 1;
          vv = ReadShift.call(this, size - i2, w2 ? "dbcs-cont" : "sbcs-cont");
          return oo.join("") + vv;
        }
        oo.push(_getchar(__readUInt8(this, loc)));
        loc += 1;
      }
      o2 = oo.join("");
      break;
    default:
      switch (size) {
        case 1:
          oI = __readUInt8(this, this.l);
          this.l++;
          return oI;
        case 2:
          oI = (t2 === "i" ? __readInt16LE : __readUInt16LE)(this, this.l);
          this.l += 2;
          return oI;
        case 4:
        case -4:
          if (t2 === "i" || (this[this.l + 3] & 128) === 0) {
            oI = (size > 0 ? __readInt32LE : __readInt32BE)(this, this.l);
            this.l += 4;
            return oI;
          } else {
            oR = __readUInt32LE(this, this.l);
            this.l += 4;
          }
          return oR;
        case 8:
        case -8:
          if (t2 === "f") {
            if (size == 8)
              oR = __double(this, this.l);
            else
              oR = __double([this[this.l + 7], this[this.l + 6], this[this.l + 5], this[this.l + 4], this[this.l + 3], this[this.l + 2], this[this.l + 1], this[this.l + 0]], 0);
            this.l += 8;
            return oR;
          } else
            size = 8;
        case 16:
          o2 = __hexlify(this, this.l, size);
          break;
      }
  }
  this.l += size;
  return o2;
}
var __writeUInt32LE = function(b2, val, idx) {
  b2[idx] = val & 255;
  b2[idx + 1] = val >>> 8 & 255;
  b2[idx + 2] = val >>> 16 & 255;
  b2[idx + 3] = val >>> 24 & 255;
};
var __writeInt32LE = function(b2, val, idx) {
  b2[idx] = val & 255;
  b2[idx + 1] = val >> 8 & 255;
  b2[idx + 2] = val >> 16 & 255;
  b2[idx + 3] = val >> 24 & 255;
};
var __writeUInt16LE = function(b2, val, idx) {
  b2[idx] = val & 255;
  b2[idx + 1] = val >>> 8 & 255;
};
function WriteShift(t2, val, f2) {
  var size = 0, i2 = 0;
  if (f2 === "dbcs") {
    for (i2 = 0; i2 != val.length; ++i2)
      __writeUInt16LE(this, val.charCodeAt(i2), this.l + 2 * i2);
    size = 2 * val.length;
  } else if (f2 === "sbcs") {
    if (typeof $cptable !== "undefined" && current_ansi == 874) {
      for (i2 = 0; i2 != val.length; ++i2) {
        var cppayload = $cptable.utils.encode(current_ansi, val.charAt(i2));
        this[this.l + i2] = cppayload[0];
      }
    } else {
      val = val.replace(/[^\x00-\x7F]/g, "_");
      for (i2 = 0; i2 != val.length; ++i2)
        this[this.l + i2] = val.charCodeAt(i2) & 255;
    }
    size = val.length;
  } else if (f2 === "hex") {
    for (; i2 < t2; ++i2) {
      this[this.l++] = parseInt(val.slice(2 * i2, 2 * i2 + 2), 16) || 0;
    }
    return this;
  } else if (f2 === "utf16le") {
    var end = Math.min(this.l + t2, this.length);
    for (i2 = 0; i2 < Math.min(val.length, t2); ++i2) {
      var cc = val.charCodeAt(i2);
      this[this.l++] = cc & 255;
      this[this.l++] = cc >> 8;
    }
    while (this.l < end)
      this[this.l++] = 0;
    return this;
  } else
    switch (t2) {
      case 1:
        size = 1;
        this[this.l] = val & 255;
        break;
      case 2:
        size = 2;
        this[this.l] = val & 255;
        val >>>= 8;
        this[this.l + 1] = val & 255;
        break;
      case 3:
        size = 3;
        this[this.l] = val & 255;
        val >>>= 8;
        this[this.l + 1] = val & 255;
        val >>>= 8;
        this[this.l + 2] = val & 255;
        break;
      case 4:
        size = 4;
        __writeUInt32LE(this, val, this.l);
        break;
      case 8:
        size = 8;
        if (f2 === "f") {
          write_double_le(this, val, this.l);
          break;
        }
      case 16:
        break;
      case -4:
        size = 4;
        __writeInt32LE(this, val, this.l);
        break;
    }
  this.l += size;
  return this;
}
function CheckField(hexstr, fld) {
  var m2 = __hexlify(this, this.l, hexstr.length >> 1);
  if (m2 !== hexstr)
    throw new Error(fld + "Expected " + hexstr + " saw " + m2);
  this.l += hexstr.length >> 1;
}
function prep_blob(blob, pos) {
  blob.l = pos;
  blob.read_shift = /*::(*/
  ReadShift;
  blob.chk = CheckField;
  blob.write_shift = WriteShift;
}
function parsenoop(blob, length) {
  blob.l += length;
}
function new_buf(sz) {
  var o2 = new_raw_buf(sz);
  prep_blob(o2, 0);
  return o2;
}
function recordhopper(data, cb, opts) {
  if (!data)
    return;
  var tmpbyte, cntbyte, length;
  prep_blob(data, data.l || 0);
  var L2 = data.length, RT = 0, tgt = 0;
  while (data.l < L2) {
    RT = data.read_shift(1);
    if (RT & 128)
      RT = (RT & 127) + ((data.read_shift(1) & 127) << 7);
    var R2 = XLSBRecordEnum[RT] || XLSBRecordEnum[65535];
    tmpbyte = data.read_shift(1);
    length = tmpbyte & 127;
    for (cntbyte = 1; cntbyte < 4 && tmpbyte & 128; ++cntbyte)
      length += ((tmpbyte = data.read_shift(1)) & 127) << 7 * cntbyte;
    tgt = data.l + length;
    var d2 = R2.f && R2.f(data, length, opts);
    data.l = tgt;
    if (cb(d2, R2, RT))
      return;
  }
}
function buf_array() {
  var bufs = [], blksz = has_buf ? 256 : 2048;
  var newblk = function ba_newblk(sz) {
    var o2 = new_buf(sz);
    prep_blob(o2, 0);
    return o2;
  };
  var curbuf = newblk(blksz);
  var endbuf = function ba_endbuf() {
    if (!curbuf)
      return;
    if (curbuf.length > curbuf.l) {
      curbuf = curbuf.slice(0, curbuf.l);
      curbuf.l = curbuf.length;
    }
    if (curbuf.length > 0)
      bufs.push(curbuf);
    curbuf = null;
  };
  var next = function ba_next(sz) {
    if (curbuf && sz < curbuf.length - curbuf.l)
      return curbuf;
    endbuf();
    return curbuf = newblk(Math.max(sz + 1, blksz));
  };
  var end = function ba_end() {
    endbuf();
    return bconcat(bufs);
  };
  var push = function ba_push(buf) {
    endbuf();
    curbuf = buf;
    if (curbuf.l == null)
      curbuf.l = curbuf.length;
    next(blksz);
  };
  return { next, push, end, _bufs: bufs };
}
function write_record(ba, type, payload, length) {
  var t2 = +type, l2;
  if (isNaN(t2))
    return;
  if (!length)
    length = XLSBRecordEnum[t2].p || (payload || []).length || 0;
  l2 = 1 + (t2 >= 128 ? 1 : 0) + 1;
  if (length >= 128)
    ++l2;
  if (length >= 16384)
    ++l2;
  if (length >= 2097152)
    ++l2;
  var o2 = ba.next(l2);
  if (t2 <= 127)
    o2.write_shift(1, t2);
  else {
    o2.write_shift(1, (t2 & 127) + 128);
    o2.write_shift(1, t2 >> 7);
  }
  for (var i2 = 0; i2 != 4; ++i2) {
    if (length >= 128) {
      o2.write_shift(1, (length & 127) + 128);
      length >>= 7;
    } else {
      o2.write_shift(1, length);
      break;
    }
  }
  if (
    /*:: length != null &&*/
    length > 0 && is_buf(payload)
  )
    ba.push(payload);
}
function shift_cell_xls(cell, tgt, opts) {
  var out = dup(cell);
  if (tgt.s) {
    if (out.cRel)
      out.c += tgt.s.c;
    if (out.rRel)
      out.r += tgt.s.r;
  } else {
    if (out.cRel)
      out.c += tgt.c;
    if (out.rRel)
      out.r += tgt.r;
  }
  if (!opts || opts.biff < 12) {
    while (out.c >= 256)
      out.c -= 256;
    while (out.r >= 65536)
      out.r -= 65536;
  }
  return out;
}
function shift_range_xls(cell, range, opts) {
  var out = dup(cell);
  out.s = shift_cell_xls(out.s, range.s, opts);
  out.e = shift_cell_xls(out.e, range.s, opts);
  return out;
}
function encode_cell_xls(c2, biff) {
  if (c2.cRel && c2.c < 0) {
    c2 = dup(c2);
    while (c2.c < 0)
      c2.c += biff > 8 ? 16384 : 256;
  }
  if (c2.rRel && c2.r < 0) {
    c2 = dup(c2);
    while (c2.r < 0)
      c2.r += biff > 8 ? 1048576 : biff > 5 ? 65536 : 16384;
  }
  var s2 = encode_cell(c2);
  if (!c2.cRel && c2.cRel != null)
    s2 = fix_col(s2);
  if (!c2.rRel && c2.rRel != null)
    s2 = fix_row(s2);
  return s2;
}
function encode_range_xls(r, opts) {
  if (r.s.r == 0 && !r.s.rRel) {
    if (r.e.r == (opts.biff >= 12 ? 1048575 : opts.biff >= 8 ? 65536 : 16384) && !r.e.rRel) {
      return (r.s.cRel ? "" : "$") + encode_col(r.s.c) + ":" + (r.e.cRel ? "" : "$") + encode_col(r.e.c);
    }
  }
  if (r.s.c == 0 && !r.s.cRel) {
    if (r.e.c == (opts.biff >= 12 ? 16383 : 255) && !r.e.cRel) {
      return (r.s.rRel ? "" : "$") + encode_row(r.s.r) + ":" + (r.e.rRel ? "" : "$") + encode_row(r.e.r);
    }
  }
  return encode_cell_xls(r.s, opts.biff) + ":" + encode_cell_xls(r.e, opts.biff);
}
function decode_row(rowstr) {
  return parseInt(unfix_row(rowstr), 10) - 1;
}
function encode_row(row) {
  return "" + (row + 1);
}
function fix_row(cstr) {
  return cstr.replace(/([A-Z]|^)(\d+)$/, "$1$$$2");
}
function unfix_row(cstr) {
  return cstr.replace(/\$(\d+)$/, "$1");
}
function decode_col(colstr) {
  var c2 = unfix_col(colstr), d2 = 0, i2 = 0;
  for (; i2 !== c2.length; ++i2)
    d2 = 26 * d2 + c2.charCodeAt(i2) - 64;
  return d2 - 1;
}
function encode_col(col) {
  if (col < 0)
    throw new Error("invalid column " + col);
  var s2 = "";
  for (++col; col; col = Math.floor((col - 1) / 26))
    s2 = String.fromCharCode((col - 1) % 26 + 65) + s2;
  return s2;
}
function fix_col(cstr) {
  return cstr.replace(/^([A-Z])/, "$$$1");
}
function unfix_col(cstr) {
  return cstr.replace(/^\$([A-Z])/, "$1");
}
function split_cell(cstr) {
  return cstr.replace(/(\$?[A-Z]*)(\$?\d*)/, "$1,$2").split(",");
}
function decode_cell(cstr) {
  var R2 = 0, C2 = 0;
  for (var i2 = 0; i2 < cstr.length; ++i2) {
    var cc = cstr.charCodeAt(i2);
    if (cc >= 48 && cc <= 57)
      R2 = 10 * R2 + (cc - 48);
    else if (cc >= 65 && cc <= 90)
      C2 = 26 * C2 + (cc - 64);
  }
  return { c: C2 - 1, r: R2 - 1 };
}
function encode_cell(cell) {
  var col = cell.c + 1;
  var s2 = "";
  for (; col; col = (col - 1) / 26 | 0)
    s2 = String.fromCharCode((col - 1) % 26 + 65) + s2;
  return s2 + (cell.r + 1);
}
function decode_range(range) {
  var idx = range.indexOf(":");
  if (idx == -1)
    return { s: decode_cell(range), e: decode_cell(range) };
  return { s: decode_cell(range.slice(0, idx)), e: decode_cell(range.slice(idx + 1)) };
}
function encode_range(cs, ce2) {
  if (typeof ce2 === "undefined" || typeof ce2 === "number") {
    return encode_range(cs.s, cs.e);
  }
  if (typeof cs !== "string")
    cs = encode_cell(cs);
  if (typeof ce2 !== "string")
    ce2 = encode_cell(ce2);
  return cs == ce2 ? cs : cs + ":" + ce2;
}
function safe_decode_range(range) {
  var o2 = { s: { c: 0, r: 0 }, e: { c: 0, r: 0 } };
  var idx = 0, i2 = 0, cc = 0;
  var len = range.length;
  for (idx = 0; i2 < len; ++i2) {
    if ((cc = range.charCodeAt(i2) - 64) < 1 || cc > 26)
      break;
    idx = 26 * idx + cc;
  }
  o2.s.c = --idx;
  for (idx = 0; i2 < len; ++i2) {
    if ((cc = range.charCodeAt(i2) - 48) < 0 || cc > 9)
      break;
    idx = 10 * idx + cc;
  }
  o2.s.r = --idx;
  if (i2 === len || cc != 10) {
    o2.e.c = o2.s.c;
    o2.e.r = o2.s.r;
    return o2;
  }
  ++i2;
  for (idx = 0; i2 != len; ++i2) {
    if ((cc = range.charCodeAt(i2) - 64) < 1 || cc > 26)
      break;
    idx = 26 * idx + cc;
  }
  o2.e.c = --idx;
  for (idx = 0; i2 != len; ++i2) {
    if ((cc = range.charCodeAt(i2) - 48) < 0 || cc > 9)
      break;
    idx = 10 * idx + cc;
  }
  o2.e.r = --idx;
  return o2;
}
function safe_format_cell(cell, v2) {
  var q2 = cell.t == "d" && v2 instanceof Date;
  if (cell.z != null)
    try {
      return cell.w = SSF_format(cell.z, q2 ? datenum(v2) : v2);
    } catch (e) {
    }
  try {
    return cell.w = SSF_format((cell.XF || {}).numFmtId || (q2 ? 14 : 0), q2 ? datenum(v2) : v2);
  } catch (e) {
    return "" + v2;
  }
}
function format_cell(cell, v2, o2) {
  if (cell == null || cell.t == null || cell.t == "z")
    return "";
  if (cell.w !== void 0)
    return cell.w;
  if (cell.t == "d" && !cell.z && o2 && o2.dateNF)
    cell.z = o2.dateNF;
  if (cell.t == "e")
    return BErr[cell.v] || cell.v;
  if (v2 == void 0)
    return safe_format_cell(cell, cell.v);
  return safe_format_cell(cell, v2);
}
function sheet_to_workbook(sheet, opts) {
  var n2 = opts && opts.sheet ? opts.sheet : "Sheet1";
  var sheets = {};
  sheets[n2] = sheet;
  return { SheetNames: [n2], Sheets: sheets };
}
function sheet_add_aoa(_ws, data, opts) {
  var o2 = opts || {};
  var dense = _ws ? Array.isArray(_ws) : o2.dense;
  if (DENSE != null && dense == null)
    dense = DENSE;
  var ws = _ws || (dense ? [] : {});
  var _R = 0, _C = 0;
  if (ws && o2.origin != null) {
    if (typeof o2.origin == "number")
      _R = o2.origin;
    else {
      var _origin = typeof o2.origin == "string" ? decode_cell(o2.origin) : o2.origin;
      _R = _origin.r;
      _C = _origin.c;
    }
    if (!ws["!ref"])
      ws["!ref"] = "A1:A1";
  }
  var range = { s: { c: 1e7, r: 1e7 }, e: { c: 0, r: 0 } };
  if (ws["!ref"]) {
    var _range = safe_decode_range(ws["!ref"]);
    range.s.c = _range.s.c;
    range.s.r = _range.s.r;
    range.e.c = Math.max(range.e.c, _range.e.c);
    range.e.r = Math.max(range.e.r, _range.e.r);
    if (_R == -1)
      range.e.r = _R = _range.e.r + 1;
  }
  for (var R2 = 0; R2 != data.length; ++R2) {
    if (!data[R2])
      continue;
    if (!Array.isArray(data[R2]))
      throw new Error("aoa_to_sheet expects an array of arrays");
    for (var C2 = 0; C2 != data[R2].length; ++C2) {
      if (typeof data[R2][C2] === "undefined")
        continue;
      var cell = { v: data[R2][C2] };
      var __R = _R + R2, __C = _C + C2;
      if (range.s.r > __R)
        range.s.r = __R;
      if (range.s.c > __C)
        range.s.c = __C;
      if (range.e.r < __R)
        range.e.r = __R;
      if (range.e.c < __C)
        range.e.c = __C;
      if (data[R2][C2] && typeof data[R2][C2] === "object" && !Array.isArray(data[R2][C2]) && !(data[R2][C2] instanceof Date))
        cell = data[R2][C2];
      else {
        if (Array.isArray(cell.v)) {
          cell.f = data[R2][C2][1];
          cell.v = cell.v[0];
        }
        if (cell.v === null) {
          if (cell.f)
            cell.t = "n";
          else if (o2.nullError) {
            cell.t = "e";
            cell.v = 0;
          } else if (!o2.sheetStubs)
            continue;
          else
            cell.t = "z";
        } else if (typeof cell.v === "number")
          cell.t = "n";
        else if (typeof cell.v === "boolean")
          cell.t = "b";
        else if (cell.v instanceof Date) {
          cell.z = o2.dateNF || table_fmt[14];
          if (o2.cellDates) {
            cell.t = "d";
            cell.w = SSF_format(cell.z, datenum(cell.v));
          } else {
            cell.t = "n";
            cell.v = datenum(cell.v);
            cell.w = SSF_format(cell.z, cell.v);
          }
        } else
          cell.t = "s";
      }
      if (dense) {
        if (!ws[__R])
          ws[__R] = [];
        if (ws[__R][__C] && ws[__R][__C].z)
          cell.z = ws[__R][__C].z;
        ws[__R][__C] = cell;
      } else {
        var cell_ref = encode_cell({ c: __C, r: __R });
        if (ws[cell_ref] && ws[cell_ref].z)
          cell.z = ws[cell_ref].z;
        ws[cell_ref] = cell;
      }
    }
  }
  if (range.s.c < 1e7)
    ws["!ref"] = encode_range(range);
  return ws;
}
function aoa_to_sheet(data, opts) {
  return sheet_add_aoa(null, data, opts);
}
function parse_Int32LE(data) {
  return data.read_shift(4, "i");
}
function write_UInt32LE(x2, o2) {
  if (!o2)
    o2 = new_buf(4);
  o2.write_shift(4, x2);
  return o2;
}
function parse_XLWideString(data) {
  var cchCharacters = data.read_shift(4);
  return cchCharacters === 0 ? "" : data.read_shift(cchCharacters, "dbcs");
}
function write_XLWideString(data, o2) {
  var _null = false;
  if (o2 == null) {
    _null = true;
    o2 = new_buf(4 + 2 * data.length);
  }
  o2.write_shift(4, data.length);
  if (data.length > 0)
    o2.write_shift(0, data, "dbcs");
  return _null ? o2.slice(0, o2.l) : o2;
}
function parse_StrRun(data) {
  return { ich: data.read_shift(2), ifnt: data.read_shift(2) };
}
function write_StrRun(run, o2) {
  if (!o2)
    o2 = new_buf(4);
  o2.write_shift(2, run.ich || 0);
  o2.write_shift(2, run.ifnt || 0);
  return o2;
}
function parse_RichStr(data, length) {
  var start = data.l;
  var flags = data.read_shift(1);
  var str = parse_XLWideString(data);
  var rgsStrRun = [];
  var z2 = { t: str, h: str };
  if ((flags & 1) !== 0) {
    var dwSizeStrRun = data.read_shift(4);
    for (var i2 = 0; i2 != dwSizeStrRun; ++i2)
      rgsStrRun.push(parse_StrRun(data));
    z2.r = rgsStrRun;
  } else
    z2.r = [{ ich: 0, ifnt: 0 }];
  data.l = start + length;
  return z2;
}
function write_RichStr(str, o2) {
  var _null = false;
  if (o2 == null) {
    _null = true;
    o2 = new_buf(15 + 4 * str.t.length);
  }
  o2.write_shift(1, 0);
  write_XLWideString(str.t, o2);
  return _null ? o2.slice(0, o2.l) : o2;
}
var parse_BrtCommentText = parse_RichStr;
function write_BrtCommentText(str, o2) {
  var _null = false;
  if (o2 == null) {
    _null = true;
    o2 = new_buf(23 + 4 * str.t.length);
  }
  o2.write_shift(1, 1);
  write_XLWideString(str.t, o2);
  o2.write_shift(4, 1);
  write_StrRun({ ich: 0, ifnt: 0 }, o2);
  return _null ? o2.slice(0, o2.l) : o2;
}
function parse_XLSBCell(data) {
  var col = data.read_shift(4);
  var iStyleRef = data.read_shift(2);
  iStyleRef += data.read_shift(1) << 16;
  data.l++;
  return { c: col, iStyleRef };
}
function write_XLSBCell(cell, o2) {
  if (o2 == null)
    o2 = new_buf(8);
  o2.write_shift(-4, cell.c);
  o2.write_shift(3, cell.iStyleRef || cell.s);
  o2.write_shift(1, 0);
  return o2;
}
function parse_XLSBShortCell(data) {
  var iStyleRef = data.read_shift(2);
  iStyleRef += data.read_shift(1) << 16;
  data.l++;
  return { c: -1, iStyleRef };
}
function write_XLSBShortCell(cell, o2) {
  if (o2 == null)
    o2 = new_buf(4);
  o2.write_shift(3, cell.iStyleRef || cell.s);
  o2.write_shift(1, 0);
  return o2;
}
var parse_XLSBCodeName = parse_XLWideString;
var write_XLSBCodeName = write_XLWideString;
function parse_XLNullableWideString(data) {
  var cchCharacters = data.read_shift(4);
  return cchCharacters === 0 || cchCharacters === 4294967295 ? "" : data.read_shift(cchCharacters, "dbcs");
}
function write_XLNullableWideString(data, o2) {
  var _null = false;
  if (o2 == null) {
    _null = true;
    o2 = new_buf(127);
  }
  o2.write_shift(4, data.length > 0 ? data.length : 4294967295);
  if (data.length > 0)
    o2.write_shift(0, data, "dbcs");
  return _null ? o2.slice(0, o2.l) : o2;
}
var parse_XLNameWideString = parse_XLWideString;
var parse_RelID = parse_XLNullableWideString;
var write_RelID = write_XLNullableWideString;
function parse_RkNumber(data) {
  var b2 = data.slice(data.l, data.l + 4);
  var fX100 = b2[0] & 1, fInt = b2[0] & 2;
  data.l += 4;
  var RK = fInt === 0 ? __double([0, 0, 0, 0, b2[0] & 252, b2[1], b2[2], b2[3]], 0) : __readInt32LE(b2, 0) >> 2;
  return fX100 ? RK / 100 : RK;
}
function write_RkNumber(data, o2) {
  if (o2 == null)
    o2 = new_buf(4);
  var fX100 = 0, fInt = 0, d100 = data * 100;
  if (data == (data | 0) && data >= -(1 << 29) && data < 1 << 29) {
    fInt = 1;
  } else if (d100 == (d100 | 0) && d100 >= -(1 << 29) && d100 < 1 << 29) {
    fInt = 1;
    fX100 = 1;
  }
  if (fInt)
    o2.write_shift(-4, ((fX100 ? d100 : data) << 2) + (fX100 + 2));
  else
    throw new Error("unsupported RkNumber " + data);
}
function parse_RfX(data) {
  var cell = { s: {}, e: {} };
  cell.s.r = data.read_shift(4);
  cell.e.r = data.read_shift(4);
  cell.s.c = data.read_shift(4);
  cell.e.c = data.read_shift(4);
  return cell;
}
function write_RfX(r, o2) {
  if (!o2)
    o2 = new_buf(16);
  o2.write_shift(4, r.s.r);
  o2.write_shift(4, r.e.r);
  o2.write_shift(4, r.s.c);
  o2.write_shift(4, r.e.c);
  return o2;
}
var parse_UncheckedRfX = parse_RfX;
var write_UncheckedRfX = write_RfX;
function parse_Xnum(data) {
  if (data.length - data.l < 8)
    throw "XLS Xnum Buffer underflow";
  return data.read_shift(8, "f");
}
function write_Xnum(data, o2) {
  return (o2 || new_buf(8)).write_shift(8, data, "f");
}
function parse_BrtColor(data) {
  var out = {};
  var d2 = data.read_shift(1);
  var xColorType = d2 >>> 1;
  var index = data.read_shift(1);
  var nTS = data.read_shift(2, "i");
  var bR = data.read_shift(1);
  var bG = data.read_shift(1);
  var bB = data.read_shift(1);
  data.l++;
  switch (xColorType) {
    case 0:
      out.auto = 1;
      break;
    case 1:
      out.index = index;
      var icv = XLSIcv[index];
      if (icv)
        out.rgb = rgb2Hex(icv);
      break;
    case 2:
      out.rgb = rgb2Hex([bR, bG, bB]);
      break;
    case 3:
      out.theme = index;
      break;
  }
  if (nTS != 0)
    out.tint = nTS > 0 ? nTS / 32767 : nTS / 32768;
  return out;
}
function write_BrtColor(color, o2) {
  if (!o2)
    o2 = new_buf(8);
  if (!color || color.auto) {
    o2.write_shift(4, 0);
    o2.write_shift(4, 0);
    return o2;
  }
  if (color.index != null) {
    o2.write_shift(1, 2);
    o2.write_shift(1, color.index);
  } else if (color.theme != null) {
    o2.write_shift(1, 6);
    o2.write_shift(1, color.theme);
  } else {
    o2.write_shift(1, 5);
    o2.write_shift(1, 0);
  }
  var nTS = color.tint || 0;
  if (nTS > 0)
    nTS *= 32767;
  else if (nTS < 0)
    nTS *= 32768;
  o2.write_shift(2, nTS);
  if (!color.rgb || color.theme != null) {
    o2.write_shift(2, 0);
    o2.write_shift(1, 0);
    o2.write_shift(1, 0);
  } else {
    var rgb = color.rgb || "FFFFFF";
    if (typeof rgb == "number")
      rgb = ("000000" + rgb.toString(16)).slice(-6);
    o2.write_shift(1, parseInt(rgb.slice(0, 2), 16));
    o2.write_shift(1, parseInt(rgb.slice(2, 4), 16));
    o2.write_shift(1, parseInt(rgb.slice(4, 6), 16));
    o2.write_shift(1, 255);
  }
  return o2;
}
function parse_FontFlags(data) {
  var d2 = data.read_shift(1);
  data.l++;
  var out = {
    fBold: d2 & 1,
    fItalic: d2 & 2,
    fUnderline: d2 & 4,
    fStrikeout: d2 & 8,
    fOutline: d2 & 16,
    fShadow: d2 & 32,
    fCondense: d2 & 64,
    fExtend: d2 & 128
  };
  return out;
}
function write_FontFlags(font, o2) {
  if (!o2)
    o2 = new_buf(2);
  var grbit = (font.italic ? 2 : 0) | (font.strike ? 8 : 0) | (font.outline ? 16 : 0) | (font.shadow ? 32 : 0) | (font.condense ? 64 : 0) | (font.extend ? 128 : 0);
  o2.write_shift(1, grbit);
  o2.write_shift(1, 0);
  return o2;
}
function parse_ClipboardFormatOrString(o2, w2) {
  var ClipFmt = { 2: "BITMAP", 3: "METAFILEPICT", 8: "DIB", 14: "ENHMETAFILE" };
  var m2 = o2.read_shift(4);
  switch (m2) {
    case 0:
      return "";
    case 4294967295:
    case 4294967294:
      return ClipFmt[o2.read_shift(4)] || "";
  }
  if (m2 > 400)
    throw new Error("Unsupported Clipboard: " + m2.toString(16));
  o2.l -= 4;
  return o2.read_shift(0, w2 == 1 ? "lpstr" : "lpwstr");
}
function parse_ClipboardFormatOrAnsiString(o2) {
  return parse_ClipboardFormatOrString(o2, 1);
}
function parse_ClipboardFormatOrUnicodeString(o2) {
  return parse_ClipboardFormatOrString(o2, 2);
}
var VT_I2 = 2;
var VT_I4 = 3;
var VT_BOOL = 11;
var VT_VARIANT = 12;
var VT_UI4 = 19;
var VT_FILETIME = 64;
var VT_BLOB = 65;
var VT_CF = 71;
var VT_VECTOR_VARIANT = 4108;
var VT_VECTOR_LPSTR = 4126;
var VT_STRING = 80;
var VT_USTR = 81;
var VT_CUSTOM = [VT_STRING, VT_USTR];
var DocSummaryPIDDSI = {
  /*::[*/
  1: { n: "CodePage", t: VT_I2 },
  /*::[*/
  2: { n: "Category", t: VT_STRING },
  /*::[*/
  3: { n: "PresentationFormat", t: VT_STRING },
  /*::[*/
  4: { n: "ByteCount", t: VT_I4 },
  /*::[*/
  5: { n: "LineCount", t: VT_I4 },
  /*::[*/
  6: { n: "ParagraphCount", t: VT_I4 },
  /*::[*/
  7: { n: "SlideCount", t: VT_I4 },
  /*::[*/
  8: { n: "NoteCount", t: VT_I4 },
  /*::[*/
  9: { n: "HiddenCount", t: VT_I4 },
  /*::[*/
  10: { n: "MultimediaClipCount", t: VT_I4 },
  /*::[*/
  11: { n: "ScaleCrop", t: VT_BOOL },
  /*::[*/
  12: {
    n: "HeadingPairs",
    t: VT_VECTOR_VARIANT
    /* VT_VECTOR | VT_VARIANT */
  },
  /*::[*/
  13: {
    n: "TitlesOfParts",
    t: VT_VECTOR_LPSTR
    /* VT_VECTOR | VT_LPSTR */
  },
  /*::[*/
  14: { n: "Manager", t: VT_STRING },
  /*::[*/
  15: { n: "Company", t: VT_STRING },
  /*::[*/
  16: { n: "LinksUpToDate", t: VT_BOOL },
  /*::[*/
  17: { n: "CharacterCount", t: VT_I4 },
  /*::[*/
  19: { n: "SharedDoc", t: VT_BOOL },
  /*::[*/
  22: { n: "HyperlinksChanged", t: VT_BOOL },
  /*::[*/
  23: { n: "AppVersion", t: VT_I4, p: "version" },
  /*::[*/
  24: { n: "DigSig", t: VT_BLOB },
  /*::[*/
  26: { n: "ContentType", t: VT_STRING },
  /*::[*/
  27: { n: "ContentStatus", t: VT_STRING },
  /*::[*/
  28: { n: "Language", t: VT_STRING },
  /*::[*/
  29: { n: "Version", t: VT_STRING },
  /*::[*/
  255: {},
  /* [MS-OLEPS] 2.18 */
  /*::[*/
  2147483648: { n: "Locale", t: VT_UI4 },
  /*::[*/
  2147483651: { n: "Behavior", t: VT_UI4 },
  /*::[*/
  1919054434: {}
};
var SummaryPIDSI = {
  /*::[*/
  1: { n: "CodePage", t: VT_I2 },
  /*::[*/
  2: { n: "Title", t: VT_STRING },
  /*::[*/
  3: { n: "Subject", t: VT_STRING },
  /*::[*/
  4: { n: "Author", t: VT_STRING },
  /*::[*/
  5: { n: "Keywords", t: VT_STRING },
  /*::[*/
  6: { n: "Comments", t: VT_STRING },
  /*::[*/
  7: { n: "Template", t: VT_STRING },
  /*::[*/
  8: { n: "LastAuthor", t: VT_STRING },
  /*::[*/
  9: { n: "RevNumber", t: VT_STRING },
  /*::[*/
  10: { n: "EditTime", t: VT_FILETIME },
  /*::[*/
  11: { n: "LastPrinted", t: VT_FILETIME },
  /*::[*/
  12: { n: "CreatedDate", t: VT_FILETIME },
  /*::[*/
  13: { n: "ModifiedDate", t: VT_FILETIME },
  /*::[*/
  14: { n: "PageCount", t: VT_I4 },
  /*::[*/
  15: { n: "WordCount", t: VT_I4 },
  /*::[*/
  16: { n: "CharCount", t: VT_I4 },
  /*::[*/
  17: { n: "Thumbnail", t: VT_CF },
  /*::[*/
  18: { n: "Application", t: VT_STRING },
  /*::[*/
  19: { n: "DocSecurity", t: VT_I4 },
  /*::[*/
  255: {},
  /* [MS-OLEPS] 2.18 */
  /*::[*/
  2147483648: { n: "Locale", t: VT_UI4 },
  /*::[*/
  2147483651: { n: "Behavior", t: VT_UI4 },
  /*::[*/
  1919054434: {}
};
var CountryEnum = {
  /*::[*/
  1: "US",
  // United States
  /*::[*/
  2: "CA",
  // Canada
  /*::[*/
  3: "",
  // Latin America (except Brazil)
  /*::[*/
  7: "RU",
  // Russia
  /*::[*/
  20: "EG",
  // Egypt
  /*::[*/
  30: "GR",
  // Greece
  /*::[*/
  31: "NL",
  // Netherlands
  /*::[*/
  32: "BE",
  // Belgium
  /*::[*/
  33: "FR",
  // France
  /*::[*/
  34: "ES",
  // Spain
  /*::[*/
  36: "HU",
  // Hungary
  /*::[*/
  39: "IT",
  // Italy
  /*::[*/
  41: "CH",
  // Switzerland
  /*::[*/
  43: "AT",
  // Austria
  /*::[*/
  44: "GB",
  // United Kingdom
  /*::[*/
  45: "DK",
  // Denmark
  /*::[*/
  46: "SE",
  // Sweden
  /*::[*/
  47: "NO",
  // Norway
  /*::[*/
  48: "PL",
  // Poland
  /*::[*/
  49: "DE",
  // Germany
  /*::[*/
  52: "MX",
  // Mexico
  /*::[*/
  55: "BR",
  // Brazil
  /*::[*/
  61: "AU",
  // Australia
  /*::[*/
  64: "NZ",
  // New Zealand
  /*::[*/
  66: "TH",
  // Thailand
  /*::[*/
  81: "JP",
  // Japan
  /*::[*/
  82: "KR",
  // Korea
  /*::[*/
  84: "VN",
  // Viet Nam
  /*::[*/
  86: "CN",
  // China
  /*::[*/
  90: "TR",
  // Turkey
  /*::[*/
  105: "JS",
  // Ramastan
  /*::[*/
  213: "DZ",
  // Algeria
  /*::[*/
  216: "MA",
  // Morocco
  /*::[*/
  218: "LY",
  // Libya
  /*::[*/
  351: "PT",
  // Portugal
  /*::[*/
  354: "IS",
  // Iceland
  /*::[*/
  358: "FI",
  // Finland
  /*::[*/
  420: "CZ",
  // Czech Republic
  /*::[*/
  886: "TW",
  // Taiwan
  /*::[*/
  961: "LB",
  // Lebanon
  /*::[*/
  962: "JO",
  // Jordan
  /*::[*/
  963: "SY",
  // Syria
  /*::[*/
  964: "IQ",
  // Iraq
  /*::[*/
  965: "KW",
  // Kuwait
  /*::[*/
  966: "SA",
  // Saudi Arabia
  /*::[*/
  971: "AE",
  // United Arab Emirates
  /*::[*/
  972: "IL",
  // Israel
  /*::[*/
  974: "QA",
  // Qatar
  /*::[*/
  981: "IR",
  // Iran
  /*::[*/
  65535: "US"
  // United States
};
var XLSFillPattern = [
  null,
  "solid",
  "mediumGray",
  "darkGray",
  "lightGray",
  "darkHorizontal",
  "darkVertical",
  "darkDown",
  "darkUp",
  "darkGrid",
  "darkTrellis",
  "lightHorizontal",
  "lightVertical",
  "lightDown",
  "lightUp",
  "lightGrid",
  "lightTrellis",
  "gray125",
  "gray0625"
];
function rgbify(arr) {
  return arr.map(function(x2) {
    return [x2 >> 16 & 255, x2 >> 8 & 255, x2 & 255];
  });
}
var _XLSIcv = /* @__PURE__ */ rgbify([
  /* Color Constants */
  0,
  16777215,
  16711680,
  65280,
  255,
  16776960,
  16711935,
  65535,
  /* Overridable Defaults */
  0,
  16777215,
  16711680,
  65280,
  255,
  16776960,
  16711935,
  65535,
  8388608,
  32768,
  128,
  8421376,
  8388736,
  32896,
  12632256,
  8421504,
  10066431,
  10040166,
  16777164,
  13434879,
  6684774,
  16744576,
  26316,
  13421823,
  128,
  16711935,
  16776960,
  65535,
  8388736,
  8388608,
  32896,
  255,
  52479,
  13434879,
  13434828,
  16777113,
  10079487,
  16751052,
  13408767,
  16764057,
  3368703,
  3394764,
  10079232,
  16763904,
  16750848,
  16737792,
  6710937,
  9868950,
  13158,
  3381606,
  13056,
  3355392,
  10040064,
  10040166,
  3355545,
  3355443,
  /* Other entries to appease BIFF8/12 */
  16777215,
  /* 0x40 icvForeground ?? */
  0,
  /* 0x41 icvBackground ?? */
  0,
  /* 0x42 icvFrame ?? */
  0,
  /* 0x43 icv3D ?? */
  0,
  /* 0x44 icv3DText ?? */
  0,
  /* 0x45 icv3DHilite ?? */
  0,
  /* 0x46 icv3DShadow ?? */
  0,
  /* 0x47 icvHilite ?? */
  0,
  /* 0x48 icvCtlText ?? */
  0,
  /* 0x49 icvCtlScrl ?? */
  0,
  /* 0x4A icvCtlInv ?? */
  0,
  /* 0x4B icvCtlBody ?? */
  0,
  /* 0x4C icvCtlFrame ?? */
  0,
  /* 0x4D icvCtlFore ?? */
  0,
  /* 0x4E icvCtlBack ?? */
  0,
  /* 0x4F icvCtlNeutral */
  0,
  /* 0x50 icvInfoBk ?? */
  0
  /* 0x51 icvInfoText ?? */
]);
var XLSIcv = /* @__PURE__ */ dup(_XLSIcv);
var BErr = {
  /*::[*/
  0: "#NULL!",
  /*::[*/
  7: "#DIV/0!",
  /*::[*/
  15: "#VALUE!",
  /*::[*/
  23: "#REF!",
  /*::[*/
  29: "#NAME?",
  /*::[*/
  36: "#NUM!",
  /*::[*/
  42: "#N/A",
  /*::[*/
  43: "#GETTING_DATA",
  /*::[*/
  255: "#WTF?"
};
var RBErr = {
  "#NULL!": 0,
  "#DIV/0!": 7,
  "#VALUE!": 15,
  "#REF!": 23,
  "#NAME?": 29,
  "#NUM!": 36,
  "#N/A": 42,
  "#GETTING_DATA": 43,
  "#WTF?": 255
};
var ct2type = {
  /* Workbook */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml": "workbooks",
  "application/vnd.ms-excel.sheet.macroEnabled.main+xml": "workbooks",
  "application/vnd.ms-excel.sheet.binary.macroEnabled.main": "workbooks",
  "application/vnd.ms-excel.addin.macroEnabled.main+xml": "workbooks",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml": "workbooks",
  /* Worksheet */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml": "sheets",
  "application/vnd.ms-excel.worksheet": "sheets",
  "application/vnd.ms-excel.binIndexWs": "TODO",
  /* Binary Index */
  /* Chartsheet */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml": "charts",
  "application/vnd.ms-excel.chartsheet": "charts",
  /* Macrosheet */
  "application/vnd.ms-excel.macrosheet+xml": "macros",
  "application/vnd.ms-excel.macrosheet": "macros",
  "application/vnd.ms-excel.intlmacrosheet": "TODO",
  "application/vnd.ms-excel.binIndexMs": "TODO",
  /* Binary Index */
  /* Dialogsheet */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml": "dialogs",
  "application/vnd.ms-excel.dialogsheet": "dialogs",
  /* Shared Strings */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml": "strs",
  "application/vnd.ms-excel.sharedStrings": "strs",
  /* Styles */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml": "styles",
  "application/vnd.ms-excel.styles": "styles",
  /* File Properties */
  "application/vnd.openxmlformats-package.core-properties+xml": "coreprops",
  "application/vnd.openxmlformats-officedocument.custom-properties+xml": "custprops",
  "application/vnd.openxmlformats-officedocument.extended-properties+xml": "extprops",
  /* Custom Data Properties */
  "application/vnd.openxmlformats-officedocument.customXmlProperties+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.customProperty": "TODO",
  /* Comments */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml": "comments",
  "application/vnd.ms-excel.comments": "comments",
  "application/vnd.ms-excel.threadedcomments+xml": "threadedcomments",
  "application/vnd.ms-excel.person+xml": "people",
  /* Metadata (Stock/Geography and Dynamic Array) */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml": "metadata",
  "application/vnd.ms-excel.sheetMetadata": "metadata",
  /* PivotTable */
  "application/vnd.ms-excel.pivotTable": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotTable+xml": "TODO",
  /* Chart Objects */
  "application/vnd.openxmlformats-officedocument.drawingml.chart+xml": "TODO",
  /* Chart Colors */
  "application/vnd.ms-office.chartcolorstyle+xml": "TODO",
  /* Chart Style */
  "application/vnd.ms-office.chartstyle+xml": "TODO",
  /* Chart Advanced */
  "application/vnd.ms-office.chartex+xml": "TODO",
  /* Calculation Chain */
  "application/vnd.ms-excel.calcChain": "calcchains",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.calcChain+xml": "calcchains",
  /* Printer Settings */
  "application/vnd.openxmlformats-officedocument.spreadsheetml.printerSettings": "TODO",
  /* ActiveX */
  "application/vnd.ms-office.activeX": "TODO",
  "application/vnd.ms-office.activeX+xml": "TODO",
  /* Custom Toolbars */
  "application/vnd.ms-excel.attachedToolbars": "TODO",
  /* External Data Connections */
  "application/vnd.ms-excel.connections": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.connections+xml": "TODO",
  /* External Links */
  "application/vnd.ms-excel.externalLink": "links",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.externalLink+xml": "links",
  /* PivotCache */
  "application/vnd.ms-excel.pivotCacheDefinition": "TODO",
  "application/vnd.ms-excel.pivotCacheRecords": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheDefinition+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.pivotCacheRecords+xml": "TODO",
  /* Query Table */
  "application/vnd.ms-excel.queryTable": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.queryTable+xml": "TODO",
  /* Shared Workbook */
  "application/vnd.ms-excel.userNames": "TODO",
  "application/vnd.ms-excel.revisionHeaders": "TODO",
  "application/vnd.ms-excel.revisionLog": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionHeaders+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.revisionLog+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.userNames+xml": "TODO",
  /* Single Cell Table */
  "application/vnd.ms-excel.tableSingleCells": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.tableSingleCells+xml": "TODO",
  /* Slicer */
  "application/vnd.ms-excel.slicer": "TODO",
  "application/vnd.ms-excel.slicerCache": "TODO",
  "application/vnd.ms-excel.slicer+xml": "TODO",
  "application/vnd.ms-excel.slicerCache+xml": "TODO",
  /* Sort Map */
  "application/vnd.ms-excel.wsSortMap": "TODO",
  /* Table */
  "application/vnd.ms-excel.table": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml": "TODO",
  /* Themes */
  "application/vnd.openxmlformats-officedocument.theme+xml": "themes",
  /* Theme Override */
  "application/vnd.openxmlformats-officedocument.themeOverride+xml": "TODO",
  /* Timeline */
  "application/vnd.ms-excel.Timeline+xml": "TODO",
  /* verify */
  "application/vnd.ms-excel.TimelineCache+xml": "TODO",
  /* verify */
  /* VBA */
  "application/vnd.ms-office.vbaProject": "vba",
  "application/vnd.ms-office.vbaProjectSignature": "TODO",
  /* Volatile Dependencies */
  "application/vnd.ms-office.volatileDependencies": "TODO",
  "application/vnd.openxmlformats-officedocument.spreadsheetml.volatileDependencies+xml": "TODO",
  /* Control Properties */
  "application/vnd.ms-excel.controlproperties+xml": "TODO",
  /* Data Model */
  "application/vnd.openxmlformats-officedocument.model+data": "TODO",
  /* Survey */
  "application/vnd.ms-excel.Survey+xml": "TODO",
  /* Drawing */
  "application/vnd.openxmlformats-officedocument.drawing+xml": "drawings",
  "application/vnd.openxmlformats-officedocument.drawingml.chartshapes+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.drawingml.diagramColors+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.drawingml.diagramData+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.drawingml.diagramLayout+xml": "TODO",
  "application/vnd.openxmlformats-officedocument.drawingml.diagramStyle+xml": "TODO",
  /* VML */
  "application/vnd.openxmlformats-officedocument.vmlDrawing": "TODO",
  "application/vnd.openxmlformats-package.relationships+xml": "rels",
  "application/vnd.openxmlformats-officedocument.oleObject": "TODO",
  /* Image */
  "image/png": "TODO",
  "sheet": "js"
};
var CT_LIST = {
  workbooks: {
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet.main+xml",
    xlsm: "application/vnd.ms-excel.sheet.macroEnabled.main+xml",
    xlsb: "application/vnd.ms-excel.sheet.binary.macroEnabled.main",
    xlam: "application/vnd.ms-excel.addin.macroEnabled.main+xml",
    xltx: "application/vnd.openxmlformats-officedocument.spreadsheetml.template.main+xml"
  },
  strs: {
    /* Shared Strings */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml",
    xlsb: "application/vnd.ms-excel.sharedStrings"
  },
  comments: {
    /* Comments */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml",
    xlsb: "application/vnd.ms-excel.comments"
  },
  sheets: {
    /* Worksheet */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml",
    xlsb: "application/vnd.ms-excel.worksheet"
  },
  charts: {
    /* Chartsheet */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.chartsheet+xml",
    xlsb: "application/vnd.ms-excel.chartsheet"
  },
  dialogs: {
    /* Dialogsheet */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.dialogsheet+xml",
    xlsb: "application/vnd.ms-excel.dialogsheet"
  },
  macros: {
    /* Macrosheet (Excel 4.0 Macros) */
    xlsx: "application/vnd.ms-excel.macrosheet+xml",
    xlsb: "application/vnd.ms-excel.macrosheet"
  },
  metadata: {
    /* Metadata (Stock/Geography and Dynamic Array) */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheetMetadata+xml",
    xlsb: "application/vnd.ms-excel.sheetMetadata"
  },
  styles: {
    /* Styles */
    xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.styles+xml",
    xlsb: "application/vnd.ms-excel.styles"
  }
};
function new_ct() {
  return {
    workbooks: [],
    sheets: [],
    charts: [],
    dialogs: [],
    macros: [],
    rels: [],
    strs: [],
    comments: [],
    threadedcomments: [],
    links: [],
    coreprops: [],
    extprops: [],
    custprops: [],
    themes: [],
    styles: [],
    calcchains: [],
    vba: [],
    drawings: [],
    metadata: [],
    people: [],
    TODO: [],
    xmlns: ""
  };
}
function parse_ct(data) {
  var ct2 = new_ct();
  if (!data || !data.match)
    return ct2;
  var ctext = {};
  (data.match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    switch (y2[0].replace(nsregex, "<")) {
      case "<?xml":
        break;
      case "<Types":
        ct2.xmlns = y2["xmlns" + (y2[0].match(/<(\w+):/) || ["", ""])[1]];
        break;
      case "<Default":
        ctext[y2.Extension] = y2.ContentType;
        break;
      case "<Override":
        if (ct2[ct2type[y2.ContentType]] !== void 0)
          ct2[ct2type[y2.ContentType]].push(y2.PartName);
        break;
    }
  });
  if (ct2.xmlns !== XMLNS.CT)
    throw new Error("Unknown Namespace: " + ct2.xmlns);
  ct2.calcchain = ct2.calcchains.length > 0 ? ct2.calcchains[0] : "";
  ct2.sst = ct2.strs.length > 0 ? ct2.strs[0] : "";
  ct2.style = ct2.styles.length > 0 ? ct2.styles[0] : "";
  ct2.defaults = ctext;
  delete ct2.calcchains;
  return ct2;
}
function write_ct(ct2, opts) {
  var type2ct = evert_arr(ct2type);
  var o2 = [], v2;
  o2[o2.length] = XML_HEADER;
  o2[o2.length] = writextag("Types", null, {
    "xmlns": XMLNS.CT,
    "xmlns:xsd": XMLNS.xsd,
    "xmlns:xsi": XMLNS.xsi
  });
  o2 = o2.concat([
    ["xml", "application/xml"],
    ["bin", "application/vnd.ms-excel.sheet.binary.macroEnabled.main"],
    ["vml", "application/vnd.openxmlformats-officedocument.vmlDrawing"],
    ["data", "application/vnd.openxmlformats-officedocument.model+data"],
    /* from test files */
    ["bmp", "image/bmp"],
    ["png", "image/png"],
    ["gif", "image/gif"],
    ["emf", "image/x-emf"],
    ["wmf", "image/x-wmf"],
    ["jpg", "image/jpeg"],
    ["jpeg", "image/jpeg"],
    ["tif", "image/tiff"],
    ["tiff", "image/tiff"],
    ["pdf", "application/pdf"],
    ["rels", "application/vnd.openxmlformats-package.relationships+xml"]
  ].map(function(x2) {
    return writextag("Default", null, { "Extension": x2[0], "ContentType": x2[1] });
  }));
  var f1 = function(w2) {
    if (ct2[w2] && ct2[w2].length > 0) {
      v2 = ct2[w2][0];
      o2[o2.length] = writextag("Override", null, {
        "PartName": (v2[0] == "/" ? "" : "/") + v2,
        "ContentType": CT_LIST[w2][opts.bookType] || CT_LIST[w2]["xlsx"]
      });
    }
  };
  var f2 = function(w2) {
    (ct2[w2] || []).forEach(function(v3) {
      o2[o2.length] = writextag("Override", null, {
        "PartName": (v3[0] == "/" ? "" : "/") + v3,
        "ContentType": CT_LIST[w2][opts.bookType] || CT_LIST[w2]["xlsx"]
      });
    });
  };
  var f3 = function(t2) {
    (ct2[t2] || []).forEach(function(v3) {
      o2[o2.length] = writextag("Override", null, {
        "PartName": (v3[0] == "/" ? "" : "/") + v3,
        "ContentType": type2ct[t2][0]
      });
    });
  };
  f1("workbooks");
  f2("sheets");
  f2("charts");
  f3("themes");
  ["strs", "styles"].forEach(f1);
  ["coreprops", "extprops", "custprops"].forEach(f3);
  f3("vba");
  f3("comments");
  f3("threadedcomments");
  f3("drawings");
  f2("metadata");
  f3("people");
  if (o2.length > 2) {
    o2[o2.length] = "</Types>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
var RELS = {
  WB: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument",
  SHEET: "http://sheetjs.openxmlformats.org/officeDocument/2006/relationships/officeDocument",
  HLINK: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink",
  VML: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/vmlDrawing",
  XPATH: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLinkPath",
  XMISS: "http://schemas.microsoft.com/office/2006/relationships/xlExternalLinkPath/xlPathMissing",
  XLINK: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/externalLink",
  CXML: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXml",
  CXMLP: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/customXmlProps",
  CMNT: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/comments",
  CORE_PROPS: "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties",
  EXT_PROPS: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/extended-properties",
  CUST_PROPS: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/custom-properties",
  SST: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sharedStrings",
  STY: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles",
  THEME: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme",
  CHART: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/chart",
  CHARTEX: "http://schemas.microsoft.com/office/2014/relationships/chartEx",
  CS: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/chartsheet",
  WS: [
    "http://schemas.openxmlformats.org/officeDocument/2006/relationships/worksheet",
    "http://purl.oclc.org/ooxml/officeDocument/relationships/worksheet"
  ],
  DS: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/dialogsheet",
  MS: "http://schemas.microsoft.com/office/2006/relationships/xlMacrosheet",
  IMG: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image",
  DRAW: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/drawing",
  XLMETA: "http://schemas.openxmlformats.org/officeDocument/2006/relationships/sheetMetadata",
  TCMNT: "http://schemas.microsoft.com/office/2017/10/relationships/threadedComment",
  PEOPLE: "http://schemas.microsoft.com/office/2017/10/relationships/person",
  VBA: "http://schemas.microsoft.com/office/2006/relationships/vbaProject"
};
function get_rels_path(file) {
  var n2 = file.lastIndexOf("/");
  return file.slice(0, n2 + 1) + "_rels/" + file.slice(n2 + 1) + ".rels";
}
function parse_rels(data, currentFilePath) {
  var rels = { "!id": {} };
  if (!data)
    return rels;
  if (currentFilePath.charAt(0) !== "/") {
    currentFilePath = "/" + currentFilePath;
  }
  var hash = {};
  (data.match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    if (y2[0] === "<Relationship") {
      var rel = {};
      rel.Type = y2.Type;
      rel.Target = y2.Target;
      rel.Id = y2.Id;
      if (y2.TargetMode)
        rel.TargetMode = y2.TargetMode;
      var canonictarget = y2.TargetMode === "External" ? y2.Target : resolve_path(y2.Target, currentFilePath);
      rels[canonictarget] = rel;
      hash[y2.Id] = rel;
    }
  });
  rels["!id"] = hash;
  return rels;
}
function write_rels(rels) {
  var o2 = [XML_HEADER, writextag("Relationships", null, {
    //'xmlns:ns0': XMLNS.RELS,
    "xmlns": XMLNS.RELS
  })];
  keys(rels["!id"]).forEach(function(rid) {
    o2[o2.length] = writextag("Relationship", null, rels["!id"][rid]);
  });
  if (o2.length > 2) {
    o2[o2.length] = "</Relationships>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
function add_rels(rels, rId, f2, type, relobj, targetmode) {
  if (!relobj)
    relobj = {};
  if (!rels["!id"])
    rels["!id"] = {};
  if (!rels["!idx"])
    rels["!idx"] = 1;
  if (rId < 0)
    for (rId = rels["!idx"]; rels["!id"]["rId" + rId]; ++rId) {
    }
  rels["!idx"] = rId + 1;
  relobj.Id = "rId" + rId;
  relobj.Type = type;
  relobj.Target = f2;
  if (targetmode)
    relobj.TargetMode = targetmode;
  else if ([RELS.HLINK, RELS.XPATH, RELS.XMISS].indexOf(relobj.Type) > -1)
    relobj.TargetMode = "External";
  if (rels["!id"][relobj.Id])
    throw new Error("Cannot rewrite rId " + rId);
  rels["!id"][relobj.Id] = relobj;
  rels[("/" + relobj.Target).replace("//", "/")] = relobj;
  return rId;
}
var CT_ODS = "application/vnd.oasis.opendocument.spreadsheet";
function parse_manifest(d2, opts) {
  var str = xlml_normalize(d2);
  var Rn;
  var FEtag;
  while (Rn = xlmlregex.exec(str))
    switch (Rn[3]) {
      case "manifest":
        break;
      case "file-entry":
        FEtag = parsexmltag(Rn[0], false);
        if (FEtag.path == "/" && FEtag.type !== CT_ODS)
          throw new Error("This OpenDocument is not a spreadsheet");
        break;
      case "encryption-data":
      case "algorithm":
      case "start-key-generation":
      case "key-derivation":
        throw new Error("Unsupported ODS Encryption");
      default:
        if (opts && opts.WTF)
          throw Rn;
    }
}
function write_manifest(manifest) {
  var o2 = [XML_HEADER];
  o2.push('<manifest:manifest xmlns:manifest="urn:oasis:names:tc:opendocument:xmlns:manifest:1.0" manifest:version="1.2">\n');
  o2.push('  <manifest:file-entry manifest:full-path="/" manifest:version="1.2" manifest:media-type="application/vnd.oasis.opendocument.spreadsheet"/>\n');
  for (var i2 = 0; i2 < manifest.length; ++i2)
    o2.push('  <manifest:file-entry manifest:full-path="' + manifest[i2][0] + '" manifest:media-type="' + manifest[i2][1] + '"/>\n');
  o2.push("</manifest:manifest>");
  return o2.join("");
}
function write_rdf_type(file, res, tag) {
  return [
    '  <rdf:Description rdf:about="' + file + '">\n',
    '    <rdf:type rdf:resource="http://docs.oasis-open.org/ns/office/1.2/meta/' + (tag || "odf") + "#" + res + '"/>\n',
    "  </rdf:Description>\n"
  ].join("");
}
function write_rdf_has(base, file) {
  return [
    '  <rdf:Description rdf:about="' + base + '">\n',
    '    <ns0:hasPart xmlns:ns0="http://docs.oasis-open.org/ns/office/1.2/meta/pkg#" rdf:resource="' + file + '"/>\n',
    "  </rdf:Description>\n"
  ].join("");
}
function write_rdf(rdf) {
  var o2 = [XML_HEADER];
  o2.push('<rdf:RDF xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#">\n');
  for (var i2 = 0; i2 != rdf.length; ++i2) {
    o2.push(write_rdf_type(rdf[i2][0], rdf[i2][1]));
    o2.push(write_rdf_has("", rdf[i2][0]));
  }
  o2.push(write_rdf_type("", "Document", "pkg"));
  o2.push("</rdf:RDF>");
  return o2.join("");
}
function write_meta_ods() {
  return '<office:document-meta xmlns:office="urn:oasis:names:tc:opendocument:xmlns:office:1.0" xmlns:meta="urn:oasis:names:tc:opendocument:xmlns:meta:1.0" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xlink="http://www.w3.org/1999/xlink" office:version="1.2"><office:meta><meta:generator>SheetJS ' + XLSX.version + "</meta:generator></office:meta></office:document-meta>";
}
var CORE_PROPS = [
  ["cp:category", "Category"],
  ["cp:contentStatus", "ContentStatus"],
  ["cp:keywords", "Keywords"],
  ["cp:lastModifiedBy", "LastAuthor"],
  ["cp:lastPrinted", "LastPrinted"],
  ["cp:revision", "RevNumber"],
  ["cp:version", "Version"],
  ["dc:creator", "Author"],
  ["dc:description", "Comments"],
  ["dc:identifier", "Identifier"],
  ["dc:language", "Language"],
  ["dc:subject", "Subject"],
  ["dc:title", "Title"],
  ["dcterms:created", "CreatedDate", "date"],
  ["dcterms:modified", "ModifiedDate", "date"]
];
var CORE_PROPS_REGEX = /* @__PURE__ */ function() {
  var r = new Array(CORE_PROPS.length);
  for (var i2 = 0; i2 < CORE_PROPS.length; ++i2) {
    var f2 = CORE_PROPS[i2];
    var g2 = "(?:" + f2[0].slice(0, f2[0].indexOf(":")) + ":)" + f2[0].slice(f2[0].indexOf(":") + 1);
    r[i2] = new RegExp("<" + g2 + "[^>]*>([\\s\\S]*?)</" + g2 + ">");
  }
  return r;
}();
function parse_core_props(data) {
  var p2 = {};
  data = utf8read(data);
  for (var i2 = 0; i2 < CORE_PROPS.length; ++i2) {
    var f2 = CORE_PROPS[i2], cur = data.match(CORE_PROPS_REGEX[i2]);
    if (cur != null && cur.length > 0)
      p2[f2[1]] = unescapexml(cur[1]);
    if (f2[2] === "date" && p2[f2[1]])
      p2[f2[1]] = parseDate(p2[f2[1]]);
  }
  return p2;
}
function cp_doit(f2, g2, h2, o2, p2) {
  if (p2[f2] != null || g2 == null || g2 === "")
    return;
  p2[f2] = g2;
  g2 = escapexml(g2);
  o2[o2.length] = h2 ? writextag(f2, g2, h2) : writetag(f2, g2);
}
function write_core_props(cp, _opts) {
  var opts = _opts || {};
  var o2 = [XML_HEADER, writextag("cp:coreProperties", null, {
    //'xmlns': XMLNS.CORE_PROPS,
    "xmlns:cp": XMLNS.CORE_PROPS,
    "xmlns:dc": XMLNS.dc,
    "xmlns:dcterms": XMLNS.dcterms,
    "xmlns:dcmitype": XMLNS.dcmitype,
    "xmlns:xsi": XMLNS.xsi
  })], p2 = {};
  if (!cp && !opts.Props)
    return o2.join("");
  if (cp) {
    if (cp.CreatedDate != null)
      cp_doit("dcterms:created", typeof cp.CreatedDate === "string" ? cp.CreatedDate : write_w3cdtf(cp.CreatedDate, opts.WTF), { "xsi:type": "dcterms:W3CDTF" }, o2, p2);
    if (cp.ModifiedDate != null)
      cp_doit("dcterms:modified", typeof cp.ModifiedDate === "string" ? cp.ModifiedDate : write_w3cdtf(cp.ModifiedDate, opts.WTF), { "xsi:type": "dcterms:W3CDTF" }, o2, p2);
  }
  for (var i2 = 0; i2 != CORE_PROPS.length; ++i2) {
    var f2 = CORE_PROPS[i2];
    var v2 = opts.Props && opts.Props[f2[1]] != null ? opts.Props[f2[1]] : cp ? cp[f2[1]] : null;
    if (v2 === true)
      v2 = "1";
    else if (v2 === false)
      v2 = "0";
    else if (typeof v2 == "number")
      v2 = String(v2);
    if (v2 != null)
      cp_doit(f2[0], v2, null, o2, p2);
  }
  if (o2.length > 2) {
    o2[o2.length] = "</cp:coreProperties>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
var EXT_PROPS = [
  ["Application", "Application", "string"],
  ["AppVersion", "AppVersion", "string"],
  ["Company", "Company", "string"],
  ["DocSecurity", "DocSecurity", "string"],
  ["Manager", "Manager", "string"],
  ["HyperlinksChanged", "HyperlinksChanged", "bool"],
  ["SharedDoc", "SharedDoc", "bool"],
  ["LinksUpToDate", "LinksUpToDate", "bool"],
  ["ScaleCrop", "ScaleCrop", "bool"],
  ["HeadingPairs", "HeadingPairs", "raw"],
  ["TitlesOfParts", "TitlesOfParts", "raw"]
];
var PseudoPropsPairs = [
  "Worksheets",
  "SheetNames",
  "NamedRanges",
  "DefinedNames",
  "Chartsheets",
  "ChartNames"
];
function load_props_pairs(HP, TOP, props, opts) {
  var v2 = [];
  if (typeof HP == "string")
    v2 = parseVector(HP, opts);
  else
    for (var j2 = 0; j2 < HP.length; ++j2)
      v2 = v2.concat(HP[j2].map(function(hp) {
        return { v: hp };
      }));
  var parts = typeof TOP == "string" ? parseVector(TOP, opts).map(function(x2) {
    return x2.v;
  }) : TOP;
  var idx = 0, len = 0;
  if (parts.length > 0)
    for (var i2 = 0; i2 !== v2.length; i2 += 2) {
      len = +v2[i2 + 1].v;
      switch (v2[i2].v) {
        case "Worksheets":
        case "\u5DE5\u4F5C\u8868":
        case "\u041B\u0438\u0441\u0442\u044B":
        case "\u0623\u0648\u0631\u0627\u0642 \u0627\u0644\u0639\u0645\u0644":
        case "\u30EF\u30FC\u30AF\u30B7\u30FC\u30C8":
        case "\u05D2\u05DC\u05D9\u05D5\u05E0\u05D5\u05EA \u05E2\u05D1\u05D5\u05D3\u05D4":
        case "Arbeitsbl\xE4tter":
        case "\xC7al\u0131\u015Fma Sayfalar\u0131":
        case "Feuilles de calcul":
        case "Fogli di lavoro":
        case "Folhas de c\xE1lculo":
        case "Planilhas":
        case "Regneark":
        case "Hojas de c\xE1lculo":
        case "Werkbladen":
          props.Worksheets = len;
          props.SheetNames = parts.slice(idx, idx + len);
          break;
        case "Named Ranges":
        case "Rangos con nombre":
        case "\u540D\u524D\u4ED8\u304D\u4E00\u89A7":
        case "Benannte Bereiche":
        case "Navngivne omr\xE5der":
          props.NamedRanges = len;
          props.DefinedNames = parts.slice(idx, idx + len);
          break;
        case "Charts":
        case "Diagramme":
          props.Chartsheets = len;
          props.ChartNames = parts.slice(idx, idx + len);
          break;
      }
      idx += len;
    }
}
function parse_ext_props(data, p2, opts) {
  var q2 = {};
  if (!p2)
    p2 = {};
  data = utf8read(data);
  EXT_PROPS.forEach(function(f2) {
    var xml = (data.match(matchtag(f2[0])) || [])[1];
    switch (f2[2]) {
      case "string":
        if (xml)
          p2[f2[1]] = unescapexml(xml);
        break;
      case "bool":
        p2[f2[1]] = xml === "true";
        break;
      case "raw":
        var cur = data.match(new RegExp("<" + f2[0] + "[^>]*>([\\s\\S]*?)</" + f2[0] + ">"));
        if (cur && cur.length > 0)
          q2[f2[1]] = cur[1];
        break;
    }
  });
  if (q2.HeadingPairs && q2.TitlesOfParts)
    load_props_pairs(q2.HeadingPairs, q2.TitlesOfParts, p2, opts);
  return p2;
}
function write_ext_props(cp) {
  var o2 = [], W2 = writextag;
  if (!cp)
    cp = {};
  cp.Application = "SheetJS";
  o2[o2.length] = XML_HEADER;
  o2[o2.length] = writextag("Properties", null, {
    "xmlns": XMLNS.EXT_PROPS,
    "xmlns:vt": XMLNS.vt
  });
  EXT_PROPS.forEach(function(f2) {
    if (cp[f2[1]] === void 0)
      return;
    var v2;
    switch (f2[2]) {
      case "string":
        v2 = escapexml(String(cp[f2[1]]));
        break;
      case "bool":
        v2 = cp[f2[1]] ? "true" : "false";
        break;
    }
    if (v2 !== void 0)
      o2[o2.length] = W2(f2[0], v2);
  });
  o2[o2.length] = W2("HeadingPairs", W2("vt:vector", W2("vt:variant", "<vt:lpstr>Worksheets</vt:lpstr>") + W2("vt:variant", W2("vt:i4", String(cp.Worksheets))), { size: 2, baseType: "variant" }));
  o2[o2.length] = W2("TitlesOfParts", W2("vt:vector", cp.SheetNames.map(function(s2) {
    return "<vt:lpstr>" + escapexml(s2) + "</vt:lpstr>";
  }).join(""), { size: cp.Worksheets, baseType: "lpstr" }));
  if (o2.length > 2) {
    o2[o2.length] = "</Properties>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
var custregex = /<[^>]+>[^<]*/g;
function parse_cust_props(data, opts) {
  var p2 = {}, name = "";
  var m2 = data.match(custregex);
  if (m2)
    for (var i2 = 0; i2 != m2.length; ++i2) {
      var x2 = m2[i2], y2 = parsexmltag(x2);
      switch (y2[0]) {
        case "<?xml":
          break;
        case "<Properties":
          break;
        case "<property":
          name = unescapexml(y2.name);
          break;
        case "</property>":
          name = null;
          break;
        default:
          if (x2.indexOf("<vt:") === 0) {
            var toks = x2.split(">");
            var type = toks[0].slice(4), text = toks[1];
            switch (type) {
              case "lpstr":
              case "bstr":
              case "lpwstr":
                p2[name] = unescapexml(text);
                break;
              case "bool":
                p2[name] = parsexmlbool(text);
                break;
              case "i1":
              case "i2":
              case "i4":
              case "i8":
              case "int":
              case "uint":
                p2[name] = parseInt(text, 10);
                break;
              case "r4":
              case "r8":
              case "decimal":
                p2[name] = parseFloat(text);
                break;
              case "filetime":
              case "date":
                p2[name] = parseDate(text);
                break;
              case "cy":
              case "error":
                p2[name] = unescapexml(text);
                break;
              default:
                if (type.slice(-1) == "/")
                  break;
                if (opts.WTF && typeof console !== "undefined")
                  console.warn("Unexpected", x2, type, toks);
            }
          } else if (x2.slice(0, 2) === "</") {
          } else if (opts.WTF)
            throw new Error(x2);
      }
    }
  return p2;
}
function write_cust_props(cp) {
  var o2 = [XML_HEADER, writextag("Properties", null, {
    "xmlns": XMLNS.CUST_PROPS,
    "xmlns:vt": XMLNS.vt
  })];
  if (!cp)
    return o2.join("");
  var pid = 1;
  keys(cp).forEach(function custprop(k2) {
    ++pid;
    o2[o2.length] = writextag("property", write_vt(cp[k2], true), {
      "fmtid": "{D5CDD505-2E9C-101B-9397-08002B2CF9AE}",
      "pid": pid,
      "name": escapexml(k2)
    });
  });
  if (o2.length > 2) {
    o2[o2.length] = "</Properties>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
var XLMLDocPropsMap = {
  Title: "Title",
  Subject: "Subject",
  Author: "Author",
  Keywords: "Keywords",
  Comments: "Description",
  LastAuthor: "LastAuthor",
  RevNumber: "Revision",
  Application: "AppName",
  /* TotalTime: 'TotalTime', */
  LastPrinted: "LastPrinted",
  CreatedDate: "Created",
  ModifiedDate: "LastSaved",
  /* Pages */
  /* Words */
  /* Characters */
  Category: "Category",
  /* PresentationFormat */
  Manager: "Manager",
  Company: "Company",
  /* Guid */
  /* HyperlinkBase */
  /* Bytes */
  /* Lines */
  /* Paragraphs */
  /* CharactersWithSpaces */
  AppVersion: "Version",
  ContentStatus: "ContentStatus",
  /* NOTE: missing from schema */
  Identifier: "Identifier",
  /* NOTE: missing from schema */
  Language: "Language"
  /* NOTE: missing from schema */
};
var evert_XLMLDPM;
function xlml_set_prop(Props, tag, val) {
  if (!evert_XLMLDPM)
    evert_XLMLDPM = evert(XLMLDocPropsMap);
  tag = evert_XLMLDPM[tag] || tag;
  Props[tag] = val;
}
function xlml_write_docprops(Props, opts) {
  var o2 = [];
  keys(XLMLDocPropsMap).map(function(m2) {
    for (var i2 = 0; i2 < CORE_PROPS.length; ++i2)
      if (CORE_PROPS[i2][1] == m2)
        return CORE_PROPS[i2];
    for (i2 = 0; i2 < EXT_PROPS.length; ++i2)
      if (EXT_PROPS[i2][1] == m2)
        return EXT_PROPS[i2];
    throw m2;
  }).forEach(function(p2) {
    if (Props[p2[1]] == null)
      return;
    var m2 = opts && opts.Props && opts.Props[p2[1]] != null ? opts.Props[p2[1]] : Props[p2[1]];
    switch (p2[2]) {
      case "date":
        m2 = new Date(m2).toISOString().replace(/\.\d*Z/, "Z");
        break;
    }
    if (typeof m2 == "number")
      m2 = String(m2);
    else if (m2 === true || m2 === false) {
      m2 = m2 ? "1" : "0";
    } else if (m2 instanceof Date)
      m2 = new Date(m2).toISOString().replace(/\.\d*Z/, "");
    o2.push(writetag(XLMLDocPropsMap[p2[1]] || p2[1], m2));
  });
  return writextag("DocumentProperties", o2.join(""), { xmlns: XLMLNS.o });
}
function xlml_write_custprops(Props, Custprops) {
  var BLACKLIST = ["Worksheets", "SheetNames"];
  var T2 = "CustomDocumentProperties";
  var o2 = [];
  if (Props)
    keys(Props).forEach(function(k2) {
      if (!Object.prototype.hasOwnProperty.call(Props, k2))
        return;
      for (var i2 = 0; i2 < CORE_PROPS.length; ++i2)
        if (k2 == CORE_PROPS[i2][1])
          return;
      for (i2 = 0; i2 < EXT_PROPS.length; ++i2)
        if (k2 == EXT_PROPS[i2][1])
          return;
      for (i2 = 0; i2 < BLACKLIST.length; ++i2)
        if (k2 == BLACKLIST[i2])
          return;
      var m2 = Props[k2];
      var t2 = "string";
      if (typeof m2 == "number") {
        t2 = "float";
        m2 = String(m2);
      } else if (m2 === true || m2 === false) {
        t2 = "boolean";
        m2 = m2 ? "1" : "0";
      } else
        m2 = String(m2);
      o2.push(writextag(escapexmltag(k2), m2, { "dt:dt": t2 }));
    });
  if (Custprops)
    keys(Custprops).forEach(function(k2) {
      if (!Object.prototype.hasOwnProperty.call(Custprops, k2))
        return;
      if (Props && Object.prototype.hasOwnProperty.call(Props, k2))
        return;
      var m2 = Custprops[k2];
      var t2 = "string";
      if (typeof m2 == "number") {
        t2 = "float";
        m2 = String(m2);
      } else if (m2 === true || m2 === false) {
        t2 = "boolean";
        m2 = m2 ? "1" : "0";
      } else if (m2 instanceof Date) {
        t2 = "dateTime.tz";
        m2 = m2.toISOString();
      } else
        m2 = String(m2);
      o2.push(writextag(escapexmltag(k2), m2, { "dt:dt": t2 }));
    });
  return "<" + T2 + ' xmlns="' + XLMLNS.o + '">' + o2.join("") + "</" + T2 + ">";
}
function parse_FILETIME(blob) {
  var dwLowDateTime = blob.read_shift(4), dwHighDateTime = blob.read_shift(4);
  return new Date((dwHighDateTime / 1e7 * Math.pow(2, 32) + dwLowDateTime / 1e7 - 11644473600) * 1e3).toISOString().replace(/\.000/, "");
}
function write_FILETIME(time) {
  var date = typeof time == "string" ? new Date(Date.parse(time)) : time;
  var t2 = date.getTime() / 1e3 + 11644473600;
  var l2 = t2 % Math.pow(2, 32), h2 = (t2 - l2) / Math.pow(2, 32);
  l2 *= 1e7;
  h2 *= 1e7;
  var w2 = l2 / Math.pow(2, 32) | 0;
  if (w2 > 0) {
    l2 = l2 % Math.pow(2, 32);
    h2 += w2;
  }
  var o2 = new_buf(8);
  o2.write_shift(4, l2);
  o2.write_shift(4, h2);
  return o2;
}
function parse_lpstr(blob, type, pad) {
  var start = blob.l;
  var str = blob.read_shift(0, "lpstr-cp");
  if (pad)
    while (blob.l - start & 3)
      ++blob.l;
  return str;
}
function parse_lpwstr(blob, type, pad) {
  var str = blob.read_shift(0, "lpwstr");
  if (pad)
    blob.l += 4 - (str.length + 1 & 3) & 3;
  return str;
}
function parse_VtStringBase(blob, stringType, pad) {
  if (stringType === 31)
    return parse_lpwstr(blob);
  return parse_lpstr(blob, stringType, pad);
}
function parse_VtString(blob, t2, pad) {
  return parse_VtStringBase(blob, t2, pad === false ? 0 : 4);
}
function parse_VtUnalignedString(blob, t2) {
  if (!t2)
    throw new Error("VtUnalignedString must have positive length");
  return parse_VtStringBase(blob, t2, 0);
}
function parse_VtVecLpwstrValue(blob) {
  var length = blob.read_shift(4);
  var ret = [];
  for (var i2 = 0; i2 != length; ++i2) {
    var start = blob.l;
    ret[i2] = blob.read_shift(0, "lpwstr").replace(chr0, "");
    if (blob.l - start & 2)
      blob.l += 2;
  }
  return ret;
}
function parse_VtVecUnalignedLpstrValue(blob) {
  var length = blob.read_shift(4);
  var ret = [];
  for (var i2 = 0; i2 != length; ++i2)
    ret[i2] = blob.read_shift(0, "lpstr-cp").replace(chr0, "");
  return ret;
}
function parse_VtHeadingPair(blob) {
  var start = blob.l;
  var headingString = parse_TypedPropertyValue(blob, VT_USTR);
  if (blob[blob.l] == 0 && blob[blob.l + 1] == 0 && blob.l - start & 2)
    blob.l += 2;
  var headerParts = parse_TypedPropertyValue(blob, VT_I4);
  return [headingString, headerParts];
}
function parse_VtVecHeadingPairValue(blob) {
  var cElements = blob.read_shift(4);
  var out = [];
  for (var i2 = 0; i2 < cElements / 2; ++i2)
    out.push(parse_VtHeadingPair(blob));
  return out;
}
function parse_dictionary(blob, CodePage) {
  var cnt = blob.read_shift(4);
  var dict = {};
  for (var j2 = 0; j2 != cnt; ++j2) {
    var pid = blob.read_shift(4);
    var len = blob.read_shift(4);
    dict[pid] = blob.read_shift(len, CodePage === 1200 ? "utf16le" : "utf8").replace(chr0, "").replace(chr1, "!");
    if (CodePage === 1200 && len % 2)
      blob.l += 2;
  }
  if (blob.l & 3)
    blob.l = blob.l >> 2 + 1 << 2;
  return dict;
}
function parse_BLOB(blob) {
  var size = blob.read_shift(4);
  var bytes = blob.slice(blob.l, blob.l + size);
  blob.l += size;
  if ((size & 3) > 0)
    blob.l += 4 - (size & 3) & 3;
  return bytes;
}
function parse_ClipboardData(blob) {
  var o2 = {};
  o2.Size = blob.read_shift(4);
  blob.l += o2.Size + 3 - (o2.Size - 1) % 4;
  return o2;
}
function parse_TypedPropertyValue(blob, type, _opts) {
  var t2 = blob.read_shift(2), ret, opts = _opts || {};
  blob.l += 2;
  if (type !== VT_VARIANT) {
    if (t2 !== type && VT_CUSTOM.indexOf(type) === -1 && !((type & 65534) == 4126 && (t2 & 65534) == 4126))
      throw new Error("Expected type " + type + " saw " + t2);
  }
  switch (type === VT_VARIANT ? t2 : type) {
    case 2:
      ret = blob.read_shift(2, "i");
      if (!opts.raw)
        blob.l += 2;
      return ret;
    case 3:
      ret = blob.read_shift(4, "i");
      return ret;
    case 11:
      return blob.read_shift(4) !== 0;
    case 19:
      ret = blob.read_shift(4);
      return ret;
    case 30:
      return parse_lpstr(blob, t2, 4).replace(chr0, "");
    case 31:
      return parse_lpwstr(blob);
    case 64:
      return parse_FILETIME(blob);
    case 65:
      return parse_BLOB(blob);
    case 71:
      return parse_ClipboardData(blob);
    case 80:
      return parse_VtString(blob, t2, !opts.raw).replace(chr0, "");
    case 81:
      return parse_VtUnalignedString(
        blob,
        t2
        /*, 4*/
      ).replace(chr0, "");
    case 4108:
      return parse_VtVecHeadingPairValue(blob);
    case 4126:
    case 4127:
      return t2 == 4127 ? parse_VtVecLpwstrValue(blob) : parse_VtVecUnalignedLpstrValue(blob);
    default:
      throw new Error("TypedPropertyValue unrecognized type " + type + " " + t2);
  }
}
function write_TypedPropertyValue(type, value) {
  var o2 = new_buf(4), p2 = new_buf(4);
  o2.write_shift(4, type == 80 ? 31 : type);
  switch (type) {
    case 3:
      p2.write_shift(-4, value);
      break;
    case 5:
      p2 = new_buf(8);
      p2.write_shift(8, value, "f");
      break;
    case 11:
      p2.write_shift(4, value ? 1 : 0);
      break;
    case 64:
      p2 = write_FILETIME(value);
      break;
    case 31:
    case 80:
      p2 = new_buf(4 + 2 * (value.length + 1) + (value.length % 2 ? 0 : 2));
      p2.write_shift(4, value.length + 1);
      p2.write_shift(0, value, "dbcs");
      while (p2.l != p2.length)
        p2.write_shift(1, 0);
      break;
    default:
      throw new Error("TypedPropertyValue unrecognized type " + type + " " + value);
  }
  return bconcat([o2, p2]);
}
function parse_PropertySet(blob, PIDSI) {
  var start_addr = blob.l;
  var size = blob.read_shift(4);
  var NumProps = blob.read_shift(4);
  var Props = [], i2 = 0;
  var CodePage = 0;
  var Dictionary = -1, DictObj = {};
  for (i2 = 0; i2 != NumProps; ++i2) {
    var PropID = blob.read_shift(4);
    var Offset = blob.read_shift(4);
    Props[i2] = [PropID, Offset + start_addr];
  }
  Props.sort(function(x2, y2) {
    return x2[1] - y2[1];
  });
  var PropH = {};
  for (i2 = 0; i2 != NumProps; ++i2) {
    if (blob.l !== Props[i2][1]) {
      var fail = true;
      if (i2 > 0 && PIDSI)
        switch (PIDSI[Props[i2 - 1][0]].t) {
          case 2:
            if (blob.l + 2 === Props[i2][1]) {
              blob.l += 2;
              fail = false;
            }
            break;
          case 80:
            if (blob.l <= Props[i2][1]) {
              blob.l = Props[i2][1];
              fail = false;
            }
            break;
          case 4108:
            if (blob.l <= Props[i2][1]) {
              blob.l = Props[i2][1];
              fail = false;
            }
            break;
        }
      if ((!PIDSI || i2 == 0) && blob.l <= Props[i2][1]) {
        fail = false;
        blob.l = Props[i2][1];
      }
      if (fail)
        throw new Error("Read Error: Expected address " + Props[i2][1] + " at " + blob.l + " :" + i2);
    }
    if (PIDSI) {
      var piddsi = PIDSI[Props[i2][0]];
      PropH[piddsi.n] = parse_TypedPropertyValue(blob, piddsi.t, { raw: true });
      if (piddsi.p === "version")
        PropH[piddsi.n] = String(PropH[piddsi.n] >> 16) + "." + ("0000" + String(PropH[piddsi.n] & 65535)).slice(-4);
      if (piddsi.n == "CodePage")
        switch (PropH[piddsi.n]) {
          case 0:
            PropH[piddsi.n] = 1252;
          case 874:
          case 932:
          case 936:
          case 949:
          case 950:
          case 1250:
          case 1251:
          case 1253:
          case 1254:
          case 1255:
          case 1256:
          case 1257:
          case 1258:
          case 1e4:
          case 1200:
          case 1201:
          case 1252:
          case 65e3:
          case -536:
          case 65001:
          case -535:
            set_cp(CodePage = PropH[piddsi.n] >>> 0 & 65535);
            break;
          default:
            throw new Error("Unsupported CodePage: " + PropH[piddsi.n]);
        }
    } else {
      if (Props[i2][0] === 1) {
        CodePage = PropH.CodePage = parse_TypedPropertyValue(blob, VT_I2);
        set_cp(CodePage);
        if (Dictionary !== -1) {
          var oldpos = blob.l;
          blob.l = Props[Dictionary][1];
          DictObj = parse_dictionary(blob, CodePage);
          blob.l = oldpos;
        }
      } else if (Props[i2][0] === 0) {
        if (CodePage === 0) {
          Dictionary = i2;
          blob.l = Props[i2 + 1][1];
          continue;
        }
        DictObj = parse_dictionary(blob, CodePage);
      } else {
        var name = DictObj[Props[i2][0]];
        var val;
        switch (blob[blob.l]) {
          case 65:
            blob.l += 4;
            val = parse_BLOB(blob);
            break;
          case 30:
            blob.l += 4;
            val = parse_VtString(blob, blob[blob.l - 4]).replace(/\u0000+$/, "");
            break;
          case 31:
            blob.l += 4;
            val = parse_VtString(blob, blob[blob.l - 4]).replace(/\u0000+$/, "");
            break;
          case 3:
            blob.l += 4;
            val = blob.read_shift(4, "i");
            break;
          case 19:
            blob.l += 4;
            val = blob.read_shift(4);
            break;
          case 5:
            blob.l += 4;
            val = blob.read_shift(8, "f");
            break;
          case 11:
            blob.l += 4;
            val = parsebool(blob, 4);
            break;
          case 64:
            blob.l += 4;
            val = parseDate(parse_FILETIME(blob));
            break;
          default:
            throw new Error("unparsed value: " + blob[blob.l]);
        }
        PropH[name] = val;
      }
    }
  }
  blob.l = start_addr + size;
  return PropH;
}
var XLSPSSkip = ["CodePage", "Thumbnail", "_PID_LINKBASE", "_PID_HLINKS", "SystemIdentifier", "FMTID"];
function guess_property_type(val) {
  switch (typeof val) {
    case "boolean":
      return 11;
    case "number":
      return (val | 0) == val ? 3 : 5;
    case "string":
      return 31;
    case "object":
      if (val instanceof Date)
        return 64;
      break;
  }
  return -1;
}
function write_PropertySet(entries, RE, PIDSI) {
  var hdr = new_buf(8), piao = [], prop = [];
  var sz = 8, i2 = 0;
  var pr = new_buf(8), pio = new_buf(8);
  pr.write_shift(4, 2);
  pr.write_shift(4, 1200);
  pio.write_shift(4, 1);
  prop.push(pr);
  piao.push(pio);
  sz += 8 + pr.length;
  if (!RE) {
    pio = new_buf(8);
    pio.write_shift(4, 0);
    piao.unshift(pio);
    var bufs = [new_buf(4)];
    bufs[0].write_shift(4, entries.length);
    for (i2 = 0; i2 < entries.length; ++i2) {
      var value = entries[i2][0];
      pr = new_buf(4 + 4 + 2 * (value.length + 1) + (value.length % 2 ? 0 : 2));
      pr.write_shift(4, i2 + 2);
      pr.write_shift(4, value.length + 1);
      pr.write_shift(0, value, "dbcs");
      while (pr.l != pr.length)
        pr.write_shift(1, 0);
      bufs.push(pr);
    }
    pr = bconcat(bufs);
    prop.unshift(pr);
    sz += 8 + pr.length;
  }
  for (i2 = 0; i2 < entries.length; ++i2) {
    if (RE && !RE[entries[i2][0]])
      continue;
    if (XLSPSSkip.indexOf(entries[i2][0]) > -1 || PseudoPropsPairs.indexOf(entries[i2][0]) > -1)
      continue;
    if (entries[i2][1] == null)
      continue;
    var val = entries[i2][1], idx = 0;
    if (RE) {
      idx = +RE[entries[i2][0]];
      var pinfo = PIDSI[idx];
      if (pinfo.p == "version" && typeof val == "string") {
        var arr = val.split(".");
        val = (+arr[0] << 16) + (+arr[1] || 0);
      }
      pr = write_TypedPropertyValue(pinfo.t, val);
    } else {
      var T2 = guess_property_type(val);
      if (T2 == -1) {
        T2 = 31;
        val = String(val);
      }
      pr = write_TypedPropertyValue(T2, val);
    }
    prop.push(pr);
    pio = new_buf(8);
    pio.write_shift(4, !RE ? 2 + i2 : idx);
    piao.push(pio);
    sz += 8 + pr.length;
  }
  var w2 = 8 * (prop.length + 1);
  for (i2 = 0; i2 < prop.length; ++i2) {
    piao[i2].write_shift(4, w2);
    w2 += prop[i2].length;
  }
  hdr.write_shift(4, sz);
  hdr.write_shift(4, prop.length);
  return bconcat([hdr].concat(piao).concat(prop));
}
function parse_PropertySetStream(file, PIDSI, clsid) {
  var blob = file.content;
  if (!blob)
    return {};
  prep_blob(blob, 0);
  var NumSets, FMTID0, FMTID1, Offset0, Offset1 = 0;
  blob.chk("feff", "Byte Order: ");
  blob.read_shift(2);
  var SystemIdentifier = blob.read_shift(4);
  var CLSID = blob.read_shift(16);
  if (CLSID !== CFB.utils.consts.HEADER_CLSID && CLSID !== clsid)
    throw new Error("Bad PropertySet CLSID " + CLSID);
  NumSets = blob.read_shift(4);
  if (NumSets !== 1 && NumSets !== 2)
    throw new Error("Unrecognized #Sets: " + NumSets);
  FMTID0 = blob.read_shift(16);
  Offset0 = blob.read_shift(4);
  if (NumSets === 1 && Offset0 !== blob.l)
    throw new Error("Length mismatch: " + Offset0 + " !== " + blob.l);
  else if (NumSets === 2) {
    FMTID1 = blob.read_shift(16);
    Offset1 = blob.read_shift(4);
  }
  var PSet0 = parse_PropertySet(blob, PIDSI);
  var rval = { SystemIdentifier };
  for (var y2 in PSet0)
    rval[y2] = PSet0[y2];
  rval.FMTID = FMTID0;
  if (NumSets === 1)
    return rval;
  if (Offset1 - blob.l == 2)
    blob.l += 2;
  if (blob.l !== Offset1)
    throw new Error("Length mismatch 2: " + blob.l + " !== " + Offset1);
  var PSet1;
  try {
    PSet1 = parse_PropertySet(blob, null);
  } catch (e) {
  }
  for (y2 in PSet1)
    rval[y2] = PSet1[y2];
  rval.FMTID = [FMTID0, FMTID1];
  return rval;
}
function write_PropertySetStream(entries, clsid, RE, PIDSI, entries2, clsid2) {
  var hdr = new_buf(entries2 ? 68 : 48);
  var bufs = [hdr];
  hdr.write_shift(2, 65534);
  hdr.write_shift(2, 0);
  hdr.write_shift(4, 842412599);
  hdr.write_shift(16, CFB.utils.consts.HEADER_CLSID, "hex");
  hdr.write_shift(4, entries2 ? 2 : 1);
  hdr.write_shift(16, clsid, "hex");
  hdr.write_shift(4, entries2 ? 68 : 48);
  var ps0 = write_PropertySet(entries, RE, PIDSI);
  bufs.push(ps0);
  if (entries2) {
    var ps1 = write_PropertySet(entries2, null, null);
    hdr.write_shift(16, clsid2, "hex");
    hdr.write_shift(4, 68 + ps0.length);
    bufs.push(ps1);
  }
  return bconcat(bufs);
}
function parsenoop2(blob, length) {
  blob.read_shift(length);
  return null;
}
function writezeroes(n2, o2) {
  if (!o2)
    o2 = new_buf(n2);
  for (var j2 = 0; j2 < n2; ++j2)
    o2.write_shift(1, 0);
  return o2;
}
function parslurp(blob, length, cb) {
  var arr = [], target = blob.l + length;
  while (blob.l < target)
    arr.push(cb(blob, target - blob.l));
  if (target !== blob.l)
    throw new Error("Slurp error");
  return arr;
}
function parsebool(blob, length) {
  return blob.read_shift(length) === 1;
}
function writebool(v2, o2) {
  if (!o2)
    o2 = new_buf(2);
  o2.write_shift(2, +!!v2);
  return o2;
}
function parseuint16(blob) {
  return blob.read_shift(2, "u");
}
function writeuint16(v2, o2) {
  if (!o2)
    o2 = new_buf(2);
  o2.write_shift(2, v2);
  return o2;
}
function parseuint16a(blob, length) {
  return parslurp(blob, length, parseuint16);
}
function parse_Bes(blob) {
  var v2 = blob.read_shift(1), t2 = blob.read_shift(1);
  return t2 === 1 ? v2 : v2 === 1;
}
function write_Bes(v2, t2, o2) {
  if (!o2)
    o2 = new_buf(2);
  o2.write_shift(1, t2 == "e" ? +v2 : +!!v2);
  o2.write_shift(1, t2 == "e" ? 1 : 0);
  return o2;
}
function parse_ShortXLUnicodeString(blob, length, opts) {
  var cch = blob.read_shift(opts && opts.biff >= 12 ? 2 : 1);
  var encoding = "sbcs-cont";
  var cp = current_codepage;
  if (opts && opts.biff >= 8)
    current_codepage = 1200;
  if (!opts || opts.biff == 8) {
    var fHighByte = blob.read_shift(1);
    if (fHighByte) {
      encoding = "dbcs-cont";
    }
  } else if (opts.biff == 12) {
    encoding = "wstr";
  }
  if (opts.biff >= 2 && opts.biff <= 5)
    encoding = "cpstr";
  var o2 = cch ? blob.read_shift(cch, encoding) : "";
  current_codepage = cp;
  return o2;
}
function parse_XLUnicodeRichExtendedString(blob) {
  var cp = current_codepage;
  current_codepage = 1200;
  var cch = blob.read_shift(2), flags = blob.read_shift(1);
  var fExtSt = flags & 4, fRichSt = flags & 8;
  var width = 1 + (flags & 1);
  var cRun = 0, cbExtRst;
  var z2 = {};
  if (fRichSt)
    cRun = blob.read_shift(2);
  if (fExtSt)
    cbExtRst = blob.read_shift(4);
  var encoding = width == 2 ? "dbcs-cont" : "sbcs-cont";
  var msg = cch === 0 ? "" : blob.read_shift(cch, encoding);
  if (fRichSt)
    blob.l += 4 * cRun;
  if (fExtSt)
    blob.l += cbExtRst;
  z2.t = msg;
  if (!fRichSt) {
    z2.raw = "<t>" + z2.t + "</t>";
    z2.r = z2.t;
  }
  current_codepage = cp;
  return z2;
}
function write_XLUnicodeRichExtendedString(xlstr) {
  var str = xlstr.t || "", nfmts = 1;
  var hdr = new_buf(3 + (nfmts > 1 ? 2 : 0));
  hdr.write_shift(2, str.length);
  hdr.write_shift(1, (nfmts > 1 ? 8 : 0) | 1);
  if (nfmts > 1)
    hdr.write_shift(2, nfmts);
  var otext = new_buf(2 * str.length);
  otext.write_shift(2 * str.length, str, "utf16le");
  var out = [hdr, otext];
  return bconcat(out);
}
function parse_XLUnicodeStringNoCch(blob, cch, opts) {
  var retval;
  if (opts) {
    if (opts.biff >= 2 && opts.biff <= 5)
      return blob.read_shift(cch, "cpstr");
    if (opts.biff >= 12)
      return blob.read_shift(cch, "dbcs-cont");
  }
  var fHighByte = blob.read_shift(1);
  if (fHighByte === 0) {
    retval = blob.read_shift(cch, "sbcs-cont");
  } else {
    retval = blob.read_shift(cch, "dbcs-cont");
  }
  return retval;
}
function parse_XLUnicodeString(blob, length, opts) {
  var cch = blob.read_shift(opts && opts.biff == 2 ? 1 : 2);
  if (cch === 0) {
    blob.l++;
    return "";
  }
  return parse_XLUnicodeStringNoCch(blob, cch, opts);
}
function parse_XLUnicodeString2(blob, length, opts) {
  if (opts.biff > 5)
    return parse_XLUnicodeString(blob, length, opts);
  var cch = blob.read_shift(1);
  if (cch === 0) {
    blob.l++;
    return "";
  }
  return blob.read_shift(cch, opts.biff <= 4 || !blob.lens ? "cpstr" : "sbcs-cont");
}
function write_XLUnicodeString(str, opts, o2) {
  if (!o2)
    o2 = new_buf(3 + 2 * str.length);
  o2.write_shift(2, str.length);
  o2.write_shift(1, 1);
  o2.write_shift(31, str, "utf16le");
  return o2;
}
function parse_ControlInfo(blob) {
  var flags = blob.read_shift(1);
  blob.l++;
  var accel = blob.read_shift(2);
  blob.l += 2;
  return [flags, accel];
}
function parse_URLMoniker(blob) {
  var len = blob.read_shift(4), start = blob.l;
  var extra = false;
  if (len > 24) {
    blob.l += len - 24;
    if (blob.read_shift(16) === "795881f43b1d7f48af2c825dc4852763")
      extra = true;
    blob.l = start;
  }
  var url = blob.read_shift((extra ? len - 24 : len) >> 1, "utf16le").replace(chr0, "");
  if (extra)
    blob.l += 24;
  return url;
}
function parse_FileMoniker(blob) {
  var cAnti = blob.read_shift(2);
  var preamble = "";
  while (cAnti-- > 0)
    preamble += "../";
  var ansiPath = blob.read_shift(0, "lpstr-ansi");
  blob.l += 2;
  if (blob.read_shift(2) != 57005)
    throw new Error("Bad FileMoniker");
  var sz = blob.read_shift(4);
  if (sz === 0)
    return preamble + ansiPath.replace(/\\/g, "/");
  var bytes = blob.read_shift(4);
  if (blob.read_shift(2) != 3)
    throw new Error("Bad FileMoniker");
  var unicodePath = blob.read_shift(bytes >> 1, "utf16le").replace(chr0, "");
  return preamble + unicodePath;
}
function parse_HyperlinkMoniker(blob, length) {
  var clsid = blob.read_shift(16);
  length -= 16;
  switch (clsid) {
    case "e0c9ea79f9bace118c8200aa004ba90b":
      return parse_URLMoniker(blob, length);
    case "0303000000000000c000000000000046":
      return parse_FileMoniker(blob, length);
    default:
      throw new Error("Unsupported Moniker " + clsid);
  }
}
function parse_HyperlinkString(blob) {
  var len = blob.read_shift(4);
  var o2 = len > 0 ? blob.read_shift(len, "utf16le").replace(chr0, "") : "";
  return o2;
}
function write_HyperlinkString(str, o2) {
  if (!o2)
    o2 = new_buf(6 + str.length * 2);
  o2.write_shift(4, 1 + str.length);
  for (var i2 = 0; i2 < str.length; ++i2)
    o2.write_shift(2, str.charCodeAt(i2));
  o2.write_shift(2, 0);
  return o2;
}
function parse_Hyperlink(blob, length) {
  var end = blob.l + length;
  var sVer = blob.read_shift(4);
  if (sVer !== 2)
    throw new Error("Unrecognized streamVersion: " + sVer);
  var flags = blob.read_shift(2);
  blob.l += 2;
  var displayName, targetFrameName, moniker, oleMoniker, Loc = "", guid, fileTime;
  if (flags & 16)
    displayName = parse_HyperlinkString(blob, end - blob.l);
  if (flags & 128)
    targetFrameName = parse_HyperlinkString(blob, end - blob.l);
  if ((flags & 257) === 257)
    moniker = parse_HyperlinkString(blob, end - blob.l);
  if ((flags & 257) === 1)
    oleMoniker = parse_HyperlinkMoniker(blob, end - blob.l);
  if (flags & 8)
    Loc = parse_HyperlinkString(blob, end - blob.l);
  if (flags & 32)
    guid = blob.read_shift(16);
  if (flags & 64)
    fileTime = parse_FILETIME(
      blob
      /*, 8*/
    );
  blob.l = end;
  var target = targetFrameName || moniker || oleMoniker || "";
  if (target && Loc)
    target += "#" + Loc;
  if (!target)
    target = "#" + Loc;
  if (flags & 2 && target.charAt(0) == "/" && target.charAt(1) != "/")
    target = "file://" + target;
  var out = { Target: target };
  if (guid)
    out.guid = guid;
  if (fileTime)
    out.time = fileTime;
  if (displayName)
    out.Tooltip = displayName;
  return out;
}
function write_Hyperlink(hl) {
  var out = new_buf(512), i2 = 0;
  var Target = hl.Target;
  if (Target.slice(0, 7) == "file://")
    Target = Target.slice(7);
  var hashidx = Target.indexOf("#");
  var F2 = hashidx > -1 ? 31 : 23;
  switch (Target.charAt(0)) {
    case "#":
      F2 = 28;
      break;
    case ".":
      F2 &= ~2;
      break;
  }
  out.write_shift(4, 2);
  out.write_shift(4, F2);
  var data = [8, 6815827, 6619237, 4849780, 83];
  for (i2 = 0; i2 < data.length; ++i2)
    out.write_shift(4, data[i2]);
  if (F2 == 28) {
    Target = Target.slice(1);
    write_HyperlinkString(Target, out);
  } else if (F2 & 2) {
    data = "e0 c9 ea 79 f9 ba ce 11 8c 82 00 aa 00 4b a9 0b".split(" ");
    for (i2 = 0; i2 < data.length; ++i2)
      out.write_shift(1, parseInt(data[i2], 16));
    var Pretarget = hashidx > -1 ? Target.slice(0, hashidx) : Target;
    out.write_shift(4, 2 * (Pretarget.length + 1));
    for (i2 = 0; i2 < Pretarget.length; ++i2)
      out.write_shift(2, Pretarget.charCodeAt(i2));
    out.write_shift(2, 0);
    if (F2 & 8)
      write_HyperlinkString(hashidx > -1 ? Target.slice(hashidx + 1) : "", out);
  } else {
    data = "03 03 00 00 00 00 00 00 c0 00 00 00 00 00 00 46".split(" ");
    for (i2 = 0; i2 < data.length; ++i2)
      out.write_shift(1, parseInt(data[i2], 16));
    var P2 = 0;
    while (Target.slice(P2 * 3, P2 * 3 + 3) == "../" || Target.slice(P2 * 3, P2 * 3 + 3) == "..\\")
      ++P2;
    out.write_shift(2, P2);
    out.write_shift(4, Target.length - 3 * P2 + 1);
    for (i2 = 0; i2 < Target.length - 3 * P2; ++i2)
      out.write_shift(1, Target.charCodeAt(i2 + 3 * P2) & 255);
    out.write_shift(1, 0);
    out.write_shift(2, 65535);
    out.write_shift(2, 57005);
    for (i2 = 0; i2 < 6; ++i2)
      out.write_shift(4, 0);
  }
  return out.slice(0, out.l);
}
function parse_LongRGBA(blob) {
  var r = blob.read_shift(1), g2 = blob.read_shift(1), b2 = blob.read_shift(1), a2 = blob.read_shift(1);
  return [r, g2, b2, a2];
}
function parse_LongRGB(blob, length) {
  var x2 = parse_LongRGBA(blob, length);
  x2[3] = 0;
  return x2;
}
function parse_XLSCell(blob) {
  var rw = blob.read_shift(2);
  var col = blob.read_shift(2);
  var ixfe = blob.read_shift(2);
  return { r: rw, c: col, ixfe };
}
function write_XLSCell(R2, C2, ixfe, o2) {
  if (!o2)
    o2 = new_buf(6);
  o2.write_shift(2, R2);
  o2.write_shift(2, C2);
  o2.write_shift(2, ixfe || 0);
  return o2;
}
function parse_frtHeader(blob) {
  var rt2 = blob.read_shift(2);
  var flags = blob.read_shift(2);
  blob.l += 8;
  return { type: rt2, flags };
}
function parse_OptXLUnicodeString(blob, length, opts) {
  return length === 0 ? "" : parse_XLUnicodeString2(blob, length, opts);
}
function parse_XTI(blob, length, opts) {
  var w2 = opts.biff > 8 ? 4 : 2;
  var iSupBook = blob.read_shift(w2), itabFirst = blob.read_shift(w2, "i"), itabLast = blob.read_shift(w2, "i");
  return [iSupBook, itabFirst, itabLast];
}
function parse_RkRec(blob) {
  var ixfe = blob.read_shift(2);
  var RK = parse_RkNumber(blob);
  return [ixfe, RK];
}
function parse_AddinUdf(blob, length, opts) {
  blob.l += 4;
  length -= 4;
  var l2 = blob.l + length;
  var udfName = parse_ShortXLUnicodeString(blob, length, opts);
  var cb = blob.read_shift(2);
  l2 -= blob.l;
  if (cb !== l2)
    throw new Error("Malformed AddinUdf: padding = " + l2 + " != " + cb);
  blob.l += cb;
  return udfName;
}
function parse_Ref8U(blob) {
  var rwFirst = blob.read_shift(2);
  var rwLast = blob.read_shift(2);
  var colFirst = blob.read_shift(2);
  var colLast = blob.read_shift(2);
  return { s: { c: colFirst, r: rwFirst }, e: { c: colLast, r: rwLast } };
}
function write_Ref8U(r, o2) {
  if (!o2)
    o2 = new_buf(8);
  o2.write_shift(2, r.s.r);
  o2.write_shift(2, r.e.r);
  o2.write_shift(2, r.s.c);
  o2.write_shift(2, r.e.c);
  return o2;
}
function parse_RefU(blob) {
  var rwFirst = blob.read_shift(2);
  var rwLast = blob.read_shift(2);
  var colFirst = blob.read_shift(1);
  var colLast = blob.read_shift(1);
  return { s: { c: colFirst, r: rwFirst }, e: { c: colLast, r: rwLast } };
}
var parse_Ref = parse_RefU;
function parse_FtCmo(blob) {
  blob.l += 4;
  var ot2 = blob.read_shift(2);
  var id = blob.read_shift(2);
  var flags = blob.read_shift(2);
  blob.l += 12;
  return [id, ot2, flags];
}
function parse_FtNts(blob) {
  var out = {};
  blob.l += 4;
  blob.l += 16;
  out.fSharedNote = blob.read_shift(2);
  blob.l += 4;
  return out;
}
function parse_FtCf(blob) {
  var out = {};
  blob.l += 4;
  blob.cf = blob.read_shift(2);
  return out;
}
function parse_FtSkip(blob) {
  blob.l += 2;
  blob.l += blob.read_shift(2);
}
var FtTab = {
  /*::[*/
  0: parse_FtSkip,
  /* FtEnd */
  /*::[*/
  4: parse_FtSkip,
  /* FtMacro */
  /*::[*/
  5: parse_FtSkip,
  /* FtButton */
  /*::[*/
  6: parse_FtSkip,
  /* FtGmo */
  /*::[*/
  7: parse_FtCf,
  /* FtCf */
  /*::[*/
  8: parse_FtSkip,
  /* FtPioGrbit */
  /*::[*/
  9: parse_FtSkip,
  /* FtPictFmla */
  /*::[*/
  10: parse_FtSkip,
  /* FtCbls */
  /*::[*/
  11: parse_FtSkip,
  /* FtRbo */
  /*::[*/
  12: parse_FtSkip,
  /* FtSbs */
  /*::[*/
  13: parse_FtNts,
  /* FtNts */
  /*::[*/
  14: parse_FtSkip,
  /* FtSbsFmla */
  /*::[*/
  15: parse_FtSkip,
  /* FtGboData */
  /*::[*/
  16: parse_FtSkip,
  /* FtEdoData */
  /*::[*/
  17: parse_FtSkip,
  /* FtRboData */
  /*::[*/
  18: parse_FtSkip,
  /* FtCblsData */
  /*::[*/
  19: parse_FtSkip,
  /* FtLbsData */
  /*::[*/
  20: parse_FtSkip,
  /* FtCblsFmla */
  /*::[*/
  21: parse_FtCmo
};
function parse_FtArray(blob, length) {
  var tgt = blob.l + length;
  var fts = [];
  while (blob.l < tgt) {
    var ft2 = blob.read_shift(2);
    blob.l -= 2;
    try {
      fts.push(FtTab[ft2](blob, tgt - blob.l));
    } catch (e) {
      blob.l = tgt;
      return fts;
    }
  }
  if (blob.l != tgt)
    blob.l = tgt;
  return fts;
}
function parse_BOF(blob, length) {
  var o2 = { BIFFVer: 0, dt: 0 };
  o2.BIFFVer = blob.read_shift(2);
  length -= 2;
  if (length >= 2) {
    o2.dt = blob.read_shift(2);
    blob.l -= 2;
  }
  switch (o2.BIFFVer) {
    case 1536:
    case 1280:
    case 1024:
    case 768:
    case 512:
    case 2:
    case 7:
      break;
    default:
      if (length > 6)
        throw new Error("Unexpected BIFF Ver " + o2.BIFFVer);
  }
  blob.read_shift(length);
  return o2;
}
function write_BOF(wb, t2, o2) {
  var h2 = 1536, w2 = 16;
  switch (o2.bookType) {
    case "biff8":
      break;
    case "biff5":
      h2 = 1280;
      w2 = 8;
      break;
    case "biff4":
      h2 = 4;
      w2 = 6;
      break;
    case "biff3":
      h2 = 3;
      w2 = 6;
      break;
    case "biff2":
      h2 = 2;
      w2 = 4;
      break;
    case "xla":
      break;
    default:
      throw new Error("unsupported BIFF version");
  }
  var out = new_buf(w2);
  out.write_shift(2, h2);
  out.write_shift(2, t2);
  if (w2 > 4)
    out.write_shift(2, 29282);
  if (w2 > 6)
    out.write_shift(2, 1997);
  if (w2 > 8) {
    out.write_shift(2, 49161);
    out.write_shift(2, 1);
    out.write_shift(2, 1798);
    out.write_shift(2, 0);
  }
  return out;
}
function parse_InterfaceHdr(blob, length) {
  if (length === 0)
    return 1200;
  if (blob.read_shift(2) !== 1200) {
  }
  return 1200;
}
function parse_WriteAccess(blob, length, opts) {
  if (opts.enc) {
    blob.l += length;
    return "";
  }
  var l2 = blob.l;
  var UserName = parse_XLUnicodeString2(blob, 0, opts);
  blob.read_shift(length + l2 - blob.l);
  return UserName;
}
function write_WriteAccess(s2, opts) {
  var b8 = !opts || opts.biff == 8;
  var o2 = new_buf(b8 ? 112 : 54);
  o2.write_shift(opts.biff == 8 ? 2 : 1, 7);
  if (b8)
    o2.write_shift(1, 0);
  o2.write_shift(4, 859007059);
  o2.write_shift(4, 5458548 | (b8 ? 0 : 536870912));
  while (o2.l < o2.length)
    o2.write_shift(1, b8 ? 0 : 32);
  return o2;
}
function parse_WsBool(blob, length, opts) {
  var flags = opts && opts.biff == 8 || length == 2 ? blob.read_shift(2) : (blob.l += length, 0);
  return { fDialog: flags & 16, fBelow: flags & 64, fRight: flags & 128 };
}
function parse_BoundSheet8(blob, length, opts) {
  var pos = blob.read_shift(4);
  var hidden = blob.read_shift(1) & 3;
  var dt2 = blob.read_shift(1);
  switch (dt2) {
    case 0:
      dt2 = "Worksheet";
      break;
    case 1:
      dt2 = "Macrosheet";
      break;
    case 2:
      dt2 = "Chartsheet";
      break;
    case 6:
      dt2 = "VBAModule";
      break;
  }
  var name = parse_ShortXLUnicodeString(blob, 0, opts);
  if (name.length === 0)
    name = "Sheet1";
  return { pos, hs: hidden, dt: dt2, name };
}
function write_BoundSheet8(data, opts) {
  var w2 = !opts || opts.biff >= 8 ? 2 : 1;
  var o2 = new_buf(8 + w2 * data.name.length);
  o2.write_shift(4, data.pos);
  o2.write_shift(1, data.hs || 0);
  o2.write_shift(1, data.dt);
  o2.write_shift(1, data.name.length);
  if (opts.biff >= 8)
    o2.write_shift(1, 1);
  o2.write_shift(w2 * data.name.length, data.name, opts.biff < 8 ? "sbcs" : "utf16le");
  var out = o2.slice(0, o2.l);
  out.l = o2.l;
  return out;
}
function parse_SST(blob, length) {
  var end = blob.l + length;
  var cnt = blob.read_shift(4);
  var ucnt = blob.read_shift(4);
  var strs2 = [];
  for (var i2 = 0; i2 != ucnt && blob.l < end; ++i2) {
    strs2.push(parse_XLUnicodeRichExtendedString(blob));
  }
  strs2.Count = cnt;
  strs2.Unique = ucnt;
  return strs2;
}
function write_SST(sst, opts) {
  var header = new_buf(8);
  header.write_shift(4, sst.Count);
  header.write_shift(4, sst.Unique);
  var strs2 = [];
  for (var j2 = 0; j2 < sst.length; ++j2)
    strs2[j2] = write_XLUnicodeRichExtendedString(sst[j2], opts);
  var o2 = bconcat([header].concat(strs2));
  o2.parts = [header.length].concat(strs2.map(function(str) {
    return str.length;
  }));
  return o2;
}
function parse_ExtSST(blob, length) {
  var extsst = {};
  extsst.dsst = blob.read_shift(2);
  blob.l += length - 2;
  return extsst;
}
function parse_Row(blob) {
  var z2 = {};
  z2.r = blob.read_shift(2);
  z2.c = blob.read_shift(2);
  z2.cnt = blob.read_shift(2) - z2.c;
  var miyRw = blob.read_shift(2);
  blob.l += 4;
  var flags = blob.read_shift(1);
  blob.l += 3;
  if (flags & 7)
    z2.level = flags & 7;
  if (flags & 32)
    z2.hidden = true;
  if (flags & 64)
    z2.hpt = miyRw / 20;
  return z2;
}
function parse_ForceFullCalculation(blob) {
  var header = parse_frtHeader(blob);
  if (header.type != 2211)
    throw new Error("Invalid Future Record " + header.type);
  var fullcalc = blob.read_shift(4);
  return fullcalc !== 0;
}
function parse_RecalcId(blob) {
  blob.read_shift(2);
  return blob.read_shift(4);
}
function parse_DefaultRowHeight(blob, length, opts) {
  var f2 = 0;
  if (!(opts && opts.biff == 2)) {
    f2 = blob.read_shift(2);
  }
  var miyRw = blob.read_shift(2);
  if (opts && opts.biff == 2) {
    f2 = 1 - (miyRw >> 15);
    miyRw &= 32767;
  }
  var fl2 = { Unsynced: f2 & 1, DyZero: (f2 & 2) >> 1, ExAsc: (f2 & 4) >> 2, ExDsc: (f2 & 8) >> 3 };
  return [fl2, miyRw];
}
function parse_Window1(blob) {
  var xWn = blob.read_shift(2), yWn = blob.read_shift(2), dxWn = blob.read_shift(2), dyWn = blob.read_shift(2);
  var flags = blob.read_shift(2), iTabCur = blob.read_shift(2), iTabFirst = blob.read_shift(2);
  var ctabSel = blob.read_shift(2), wTabRatio = blob.read_shift(2);
  return {
    Pos: [xWn, yWn],
    Dim: [dxWn, dyWn],
    Flags: flags,
    CurTab: iTabCur,
    FirstTab: iTabFirst,
    Selected: ctabSel,
    TabRatio: wTabRatio
  };
}
function write_Window1() {
  var o2 = new_buf(18);
  o2.write_shift(2, 0);
  o2.write_shift(2, 0);
  o2.write_shift(2, 29280);
  o2.write_shift(2, 17600);
  o2.write_shift(2, 56);
  o2.write_shift(2, 0);
  o2.write_shift(2, 0);
  o2.write_shift(2, 1);
  o2.write_shift(2, 500);
  return o2;
}
function parse_Window2(blob, length, opts) {
  if (opts && opts.biff >= 2 && opts.biff < 5)
    return {};
  var f2 = blob.read_shift(2);
  return { RTL: f2 & 64 };
}
function write_Window2(view) {
  var o2 = new_buf(18), f2 = 1718;
  if (view && view.RTL)
    f2 |= 64;
  o2.write_shift(2, f2);
  o2.write_shift(4, 0);
  o2.write_shift(4, 64);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  return o2;
}
function parse_Pane() {
}
function parse_Font(blob, length, opts) {
  var o2 = {
    dyHeight: blob.read_shift(2),
    fl: blob.read_shift(2)
  };
  switch (opts && opts.biff || 8) {
    case 2:
      break;
    case 3:
    case 4:
      blob.l += 2;
      break;
    default:
      blob.l += 10;
      break;
  }
  o2.name = parse_ShortXLUnicodeString(blob, 0, opts);
  return o2;
}
function write_Font(data, opts) {
  var name = data.name || "Arial";
  var b5 = opts && opts.biff == 5, w2 = b5 ? 15 + name.length : 16 + 2 * name.length;
  var o2 = new_buf(w2);
  o2.write_shift(2, (data.sz || 12) * 20);
  o2.write_shift(4, 0);
  o2.write_shift(2, 400);
  o2.write_shift(4, 0);
  o2.write_shift(2, 0);
  o2.write_shift(1, name.length);
  if (!b5)
    o2.write_shift(1, 1);
  o2.write_shift((b5 ? 1 : 2) * name.length, name, b5 ? "sbcs" : "utf16le");
  return o2;
}
function parse_LabelSst(blob) {
  var cell = parse_XLSCell(blob);
  cell.isst = blob.read_shift(4);
  return cell;
}
function write_LabelSst(R2, C2, v2, os) {
  var o2 = new_buf(10);
  write_XLSCell(R2, C2, os, o2);
  o2.write_shift(4, v2);
  return o2;
}
function parse_Label(blob, length, opts) {
  if (opts.biffguess && opts.biff == 2)
    opts.biff = 5;
  var target = blob.l + length;
  var cell = parse_XLSCell(blob, 6);
  if (opts.biff == 2)
    blob.l++;
  var str = parse_XLUnicodeString(blob, target - blob.l, opts);
  cell.val = str;
  return cell;
}
function write_Label(R2, C2, v2, os, opts) {
  var b8 = !opts || opts.biff == 8;
  var o2 = new_buf(6 + 2 + +b8 + (1 + b8) * v2.length);
  write_XLSCell(R2, C2, os, o2);
  o2.write_shift(2, v2.length);
  if (b8)
    o2.write_shift(1, 1);
  o2.write_shift((1 + b8) * v2.length, v2, b8 ? "utf16le" : "sbcs");
  return o2;
}
function parse_Format(blob, length, opts) {
  var numFmtId = blob.read_shift(2);
  var fmtstr = parse_XLUnicodeString2(blob, 0, opts);
  return [numFmtId, fmtstr];
}
function write_Format(i2, f2, opts, o2) {
  var b5 = opts && opts.biff == 5;
  if (!o2)
    o2 = new_buf(b5 ? 3 + f2.length : 5 + 2 * f2.length);
  o2.write_shift(2, i2);
  o2.write_shift(b5 ? 1 : 2, f2.length);
  if (!b5)
    o2.write_shift(1, 1);
  o2.write_shift((b5 ? 1 : 2) * f2.length, f2, b5 ? "sbcs" : "utf16le");
  var out = o2.length > o2.l ? o2.slice(0, o2.l) : o2;
  if (out.l == null)
    out.l = out.length;
  return out;
}
var parse_BIFF2Format = parse_XLUnicodeString2;
function parse_Dimensions(blob, length, opts) {
  var end = blob.l + length;
  var w2 = opts.biff == 8 || !opts.biff ? 4 : 2;
  var r = blob.read_shift(w2), R2 = blob.read_shift(w2);
  var c2 = blob.read_shift(2), C2 = blob.read_shift(2);
  blob.l = end;
  return { s: { r, c: c2 }, e: { r: R2, c: C2 } };
}
function write_Dimensions(range, opts) {
  var w2 = opts.biff == 8 || !opts.biff ? 4 : 2;
  var o2 = new_buf(2 * w2 + 6);
  o2.write_shift(w2, range.s.r);
  o2.write_shift(w2, range.e.r + 1);
  o2.write_shift(2, range.s.c);
  o2.write_shift(2, range.e.c + 1);
  o2.write_shift(2, 0);
  return o2;
}
function parse_RK(blob) {
  var rw = blob.read_shift(2), col = blob.read_shift(2);
  var rkrec = parse_RkRec(blob);
  return { r: rw, c: col, ixfe: rkrec[0], rknum: rkrec[1] };
}
function parse_MulRk(blob, length) {
  var target = blob.l + length - 2;
  var rw = blob.read_shift(2), col = blob.read_shift(2);
  var rkrecs = [];
  while (blob.l < target)
    rkrecs.push(parse_RkRec(blob));
  if (blob.l !== target)
    throw new Error("MulRK read error");
  var lastcol = blob.read_shift(2);
  if (rkrecs.length != lastcol - col + 1)
    throw new Error("MulRK length mismatch");
  return { r: rw, c: col, C: lastcol, rkrec: rkrecs };
}
function parse_MulBlank(blob, length) {
  var target = blob.l + length - 2;
  var rw = blob.read_shift(2), col = blob.read_shift(2);
  var ixfes = [];
  while (blob.l < target)
    ixfes.push(blob.read_shift(2));
  if (blob.l !== target)
    throw new Error("MulBlank read error");
  var lastcol = blob.read_shift(2);
  if (ixfes.length != lastcol - col + 1)
    throw new Error("MulBlank length mismatch");
  return { r: rw, c: col, C: lastcol, ixfe: ixfes };
}
function parse_CellStyleXF(blob, length, style, opts) {
  var o2 = {};
  var a2 = blob.read_shift(4), b2 = blob.read_shift(4);
  var c2 = blob.read_shift(4), d2 = blob.read_shift(2);
  o2.patternType = XLSFillPattern[c2 >> 26];
  if (!opts.cellStyles)
    return o2;
  o2.alc = a2 & 7;
  o2.fWrap = a2 >> 3 & 1;
  o2.alcV = a2 >> 4 & 7;
  o2.fJustLast = a2 >> 7 & 1;
  o2.trot = a2 >> 8 & 255;
  o2.cIndent = a2 >> 16 & 15;
  o2.fShrinkToFit = a2 >> 20 & 1;
  o2.iReadOrder = a2 >> 22 & 2;
  o2.fAtrNum = a2 >> 26 & 1;
  o2.fAtrFnt = a2 >> 27 & 1;
  o2.fAtrAlc = a2 >> 28 & 1;
  o2.fAtrBdr = a2 >> 29 & 1;
  o2.fAtrPat = a2 >> 30 & 1;
  o2.fAtrProt = a2 >> 31 & 1;
  o2.dgLeft = b2 & 15;
  o2.dgRight = b2 >> 4 & 15;
  o2.dgTop = b2 >> 8 & 15;
  o2.dgBottom = b2 >> 12 & 15;
  o2.icvLeft = b2 >> 16 & 127;
  o2.icvRight = b2 >> 23 & 127;
  o2.grbitDiag = b2 >> 30 & 3;
  o2.icvTop = c2 & 127;
  o2.icvBottom = c2 >> 7 & 127;
  o2.icvDiag = c2 >> 14 & 127;
  o2.dgDiag = c2 >> 21 & 15;
  o2.icvFore = d2 & 127;
  o2.icvBack = d2 >> 7 & 127;
  o2.fsxButton = d2 >> 14 & 1;
  return o2;
}
function parse_XF(blob, length, opts) {
  var o2 = {};
  o2.ifnt = blob.read_shift(2);
  o2.numFmtId = blob.read_shift(2);
  o2.flags = blob.read_shift(2);
  o2.fStyle = o2.flags >> 2 & 1;
  length -= 6;
  o2.data = parse_CellStyleXF(blob, length, o2.fStyle, opts);
  return o2;
}
function write_XF(data, ixfeP, opts, o2) {
  var b5 = opts && opts.biff == 5;
  if (!o2)
    o2 = new_buf(b5 ? 16 : 20);
  o2.write_shift(2, 0);
  if (data.style) {
    o2.write_shift(2, data.numFmtId || 0);
    o2.write_shift(2, 65524);
  } else {
    o2.write_shift(2, data.numFmtId || 0);
    o2.write_shift(2, ixfeP << 4);
  }
  var f2 = 0;
  if (data.numFmtId > 0 && b5)
    f2 |= 1024;
  o2.write_shift(4, f2);
  o2.write_shift(4, 0);
  if (!b5)
    o2.write_shift(4, 0);
  o2.write_shift(2, 0);
  return o2;
}
function parse_Guts(blob) {
  blob.l += 4;
  var out = [blob.read_shift(2), blob.read_shift(2)];
  if (out[0] !== 0)
    out[0]--;
  if (out[1] !== 0)
    out[1]--;
  if (out[0] > 7 || out[1] > 7)
    throw new Error("Bad Gutters: " + out.join("|"));
  return out;
}
function write_Guts(guts) {
  var o2 = new_buf(8);
  o2.write_shift(4, 0);
  o2.write_shift(2, guts[0] ? guts[0] + 1 : 0);
  o2.write_shift(2, guts[1] ? guts[1] + 1 : 0);
  return o2;
}
function parse_BoolErr(blob, length, opts) {
  var cell = parse_XLSCell(blob, 6);
  if (opts.biff == 2 || length == 9)
    ++blob.l;
  var val = parse_Bes(blob, 2);
  cell.val = val;
  cell.t = val === true || val === false ? "b" : "e";
  return cell;
}
function write_BoolErr(R2, C2, v2, os, opts, t2) {
  var o2 = new_buf(8);
  write_XLSCell(R2, C2, os, o2);
  write_Bes(v2, t2, o2);
  return o2;
}
function parse_Number(blob, length, opts) {
  if (opts.biffguess && opts.biff == 2)
    opts.biff = 5;
  var cell = parse_XLSCell(blob, 6);
  var xnum = parse_Xnum(blob, 8);
  cell.val = xnum;
  return cell;
}
function write_Number(R2, C2, v2, os) {
  var o2 = new_buf(14);
  write_XLSCell(R2, C2, os, o2);
  write_Xnum(v2, o2);
  return o2;
}
var parse_XLHeaderFooter = parse_OptXLUnicodeString;
function parse_SupBook(blob, length, opts) {
  var end = blob.l + length;
  var ctab = blob.read_shift(2);
  var cch = blob.read_shift(2);
  opts.sbcch = cch;
  if (cch == 1025 || cch == 14849)
    return [cch, ctab];
  if (cch < 1 || cch > 255)
    throw new Error("Unexpected SupBook type: " + cch);
  var virtPath = parse_XLUnicodeStringNoCch(blob, cch);
  var rgst = [];
  while (end > blob.l)
    rgst.push(parse_XLUnicodeString(blob));
  return [cch, ctab, virtPath, rgst];
}
function parse_ExternName(blob, length, opts) {
  var flags = blob.read_shift(2);
  var body;
  var o2 = {
    fBuiltIn: flags & 1,
    fWantAdvise: flags >>> 1 & 1,
    fWantPict: flags >>> 2 & 1,
    fOle: flags >>> 3 & 1,
    fOleLink: flags >>> 4 & 1,
    cf: flags >>> 5 & 1023,
    fIcon: flags >>> 15 & 1
  };
  if (opts.sbcch === 14849)
    body = parse_AddinUdf(blob, length - 2, opts);
  o2.body = body || blob.read_shift(length - 2);
  if (typeof body === "string")
    o2.Name = body;
  return o2;
}
var XLSLblBuiltIn = [
  "_xlnm.Consolidate_Area",
  "_xlnm.Auto_Open",
  "_xlnm.Auto_Close",
  "_xlnm.Extract",
  "_xlnm.Database",
  "_xlnm.Criteria",
  "_xlnm.Print_Area",
  "_xlnm.Print_Titles",
  "_xlnm.Recorder",
  "_xlnm.Data_Form",
  "_xlnm.Auto_Activate",
  "_xlnm.Auto_Deactivate",
  "_xlnm.Sheet_Title",
  "_xlnm._FilterDatabase"
];
function parse_Lbl(blob, length, opts) {
  var target = blob.l + length;
  var flags = blob.read_shift(2);
  var chKey = blob.read_shift(1);
  var cch = blob.read_shift(1);
  var cce = blob.read_shift(opts && opts.biff == 2 ? 1 : 2);
  var itab = 0;
  if (!opts || opts.biff >= 5) {
    if (opts.biff != 5)
      blob.l += 2;
    itab = blob.read_shift(2);
    if (opts.biff == 5)
      blob.l += 2;
    blob.l += 4;
  }
  var name = parse_XLUnicodeStringNoCch(blob, cch, opts);
  if (flags & 32)
    name = XLSLblBuiltIn[name.charCodeAt(0)];
  var npflen = target - blob.l;
  if (opts && opts.biff == 2)
    --npflen;
  var rgce = target == blob.l || cce === 0 || !(npflen > 0) ? [] : parse_NameParsedFormula(blob, npflen, opts, cce);
  return {
    chKey,
    Name: name,
    itab,
    rgce
  };
}
function parse_ExternSheet(blob, length, opts) {
  if (opts.biff < 8)
    return parse_BIFF5ExternSheet(blob, length, opts);
  var o2 = [], target = blob.l + length, len = blob.read_shift(opts.biff > 8 ? 4 : 2);
  while (len-- !== 0)
    o2.push(parse_XTI(blob, opts.biff > 8 ? 12 : 6, opts));
  if (blob.l != target)
    throw new Error("Bad ExternSheet: " + blob.l + " != " + target);
  return o2;
}
function parse_BIFF5ExternSheet(blob, length, opts) {
  if (blob[blob.l + 1] == 3)
    blob[blob.l]++;
  var o2 = parse_ShortXLUnicodeString(blob, length, opts);
  return o2.charCodeAt(0) == 3 ? o2.slice(1) : o2;
}
function parse_NameCmt(blob, length, opts) {
  if (opts.biff < 8) {
    blob.l += length;
    return;
  }
  var cchName = blob.read_shift(2);
  var cchComment = blob.read_shift(2);
  var name = parse_XLUnicodeStringNoCch(blob, cchName, opts);
  var comment = parse_XLUnicodeStringNoCch(blob, cchComment, opts);
  return [name, comment];
}
function parse_ShrFmla(blob, length, opts) {
  var ref = parse_RefU(blob, 6);
  blob.l++;
  var cUse = blob.read_shift(1);
  length -= 8;
  return [parse_SharedParsedFormula(blob, length, opts), cUse, ref];
}
function parse_Array(blob, length, opts) {
  var ref = parse_Ref(blob, 6);
  switch (opts.biff) {
    case 2:
      blob.l++;
      length -= 7;
      break;
    case 3:
    case 4:
      blob.l += 2;
      length -= 8;
      break;
    default:
      blob.l += 6;
      length -= 12;
  }
  return [ref, parse_ArrayParsedFormula(blob, length, opts, ref)];
}
function parse_MTRSettings(blob) {
  var fMTREnabled = blob.read_shift(4) !== 0;
  var fUserSetThreadCount = blob.read_shift(4) !== 0;
  var cUserThreadCount = blob.read_shift(4);
  return [fMTREnabled, fUserSetThreadCount, cUserThreadCount];
}
function parse_NoteSh(blob, length, opts) {
  if (opts.biff < 8)
    return;
  var row = blob.read_shift(2), col = blob.read_shift(2);
  var flags = blob.read_shift(2), idObj = blob.read_shift(2);
  var stAuthor = parse_XLUnicodeString2(blob, 0, opts);
  if (opts.biff < 8)
    blob.read_shift(1);
  return [{ r: row, c: col }, stAuthor, idObj, flags];
}
function parse_Note(blob, length, opts) {
  return parse_NoteSh(blob, length, opts);
}
function parse_MergeCells(blob, length) {
  var merges = [];
  var cmcs = blob.read_shift(2);
  while (cmcs--)
    merges.push(parse_Ref8U(blob, length));
  return merges;
}
function write_MergeCells(merges) {
  var o2 = new_buf(2 + merges.length * 8);
  o2.write_shift(2, merges.length);
  for (var i2 = 0; i2 < merges.length; ++i2)
    write_Ref8U(merges[i2], o2);
  return o2;
}
function parse_Obj(blob, length, opts) {
  if (opts && opts.biff < 8)
    return parse_BIFF5Obj(blob, length, opts);
  var cmo = parse_FtCmo(blob, 22);
  var fts = parse_FtArray(blob, length - 22, cmo[1]);
  return { cmo, ft: fts };
}
var parse_BIFF5OT = {
  8: function(blob, length) {
    var tgt = blob.l + length;
    blob.l += 10;
    var cf = blob.read_shift(2);
    blob.l += 4;
    blob.l += 2;
    blob.l += 2;
    blob.l += 2;
    blob.l += 4;
    var cchName = blob.read_shift(1);
    blob.l += cchName;
    blob.l = tgt;
    return { fmt: cf };
  }
};
function parse_BIFF5Obj(blob, length, opts) {
  blob.l += 4;
  var ot2 = blob.read_shift(2);
  var id = blob.read_shift(2);
  var grbit = blob.read_shift(2);
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 2;
  blob.l += 6;
  length -= 36;
  var fts = [];
  fts.push((parse_BIFF5OT[ot2] || parsenoop)(blob, length, opts));
  return { cmo: [id, ot2, grbit], ft: fts };
}
function parse_TxO(blob, length, opts) {
  var s2 = blob.l;
  var texts = "";
  try {
    blob.l += 4;
    var ot2 = (opts.lastobj || { cmo: [0, 0] }).cmo[1];
    var controlInfo;
    if ([0, 5, 7, 11, 12, 14].indexOf(ot2) == -1)
      blob.l += 6;
    else
      controlInfo = parse_ControlInfo(blob, 6, opts);
    var cchText = blob.read_shift(2);
    blob.read_shift(2);
    parseuint16(blob, 2);
    var len = blob.read_shift(2);
    blob.l += len;
    for (var i2 = 1; i2 < blob.lens.length - 1; ++i2) {
      if (blob.l - s2 != blob.lens[i2])
        throw new Error("TxO: bad continue record");
      var hdr = blob[blob.l];
      var t2 = parse_XLUnicodeStringNoCch(blob, blob.lens[i2 + 1] - blob.lens[i2] - 1);
      texts += t2;
      if (texts.length >= (hdr ? cchText : 2 * cchText))
        break;
    }
    if (texts.length !== cchText && texts.length !== cchText * 2) {
      throw new Error("cchText: " + cchText + " != " + texts.length);
    }
    blob.l = s2 + length;
    return { t: texts };
  } catch (e) {
    blob.l = s2 + length;
    return { t: texts };
  }
}
function parse_HLink(blob, length) {
  var ref = parse_Ref8U(blob, 8);
  blob.l += 16;
  var hlink = parse_Hyperlink(blob, length - 24);
  return [ref, hlink];
}
function write_HLink(hl) {
  var O2 = new_buf(24);
  var ref = decode_cell(hl[0]);
  O2.write_shift(2, ref.r);
  O2.write_shift(2, ref.r);
  O2.write_shift(2, ref.c);
  O2.write_shift(2, ref.c);
  var clsid = "d0 c9 ea 79 f9 ba ce 11 8c 82 00 aa 00 4b a9 0b".split(" ");
  for (var i2 = 0; i2 < 16; ++i2)
    O2.write_shift(1, parseInt(clsid[i2], 16));
  return bconcat([O2, write_Hyperlink(hl[1])]);
}
function parse_HLinkTooltip(blob, length) {
  blob.read_shift(2);
  var ref = parse_Ref8U(blob, 8);
  var wzTooltip = blob.read_shift((length - 10) / 2, "dbcs-cont");
  wzTooltip = wzTooltip.replace(chr0, "");
  return [ref, wzTooltip];
}
function write_HLinkTooltip(hl) {
  var TT = hl[1].Tooltip;
  var O2 = new_buf(10 + 2 * (TT.length + 1));
  O2.write_shift(2, 2048);
  var ref = decode_cell(hl[0]);
  O2.write_shift(2, ref.r);
  O2.write_shift(2, ref.r);
  O2.write_shift(2, ref.c);
  O2.write_shift(2, ref.c);
  for (var i2 = 0; i2 < TT.length; ++i2)
    O2.write_shift(2, TT.charCodeAt(i2));
  O2.write_shift(2, 0);
  return O2;
}
function parse_Country(blob) {
  var o2 = [0, 0], d2;
  d2 = blob.read_shift(2);
  o2[0] = CountryEnum[d2] || d2;
  d2 = blob.read_shift(2);
  o2[1] = CountryEnum[d2] || d2;
  return o2;
}
function write_Country(o2) {
  if (!o2)
    o2 = new_buf(4);
  o2.write_shift(2, 1);
  o2.write_shift(2, 1);
  return o2;
}
function parse_ClrtClient(blob) {
  var ccv = blob.read_shift(2);
  var o2 = [];
  while (ccv-- > 0)
    o2.push(parse_LongRGB(blob, 8));
  return o2;
}
function parse_Palette(blob) {
  var ccv = blob.read_shift(2);
  var o2 = [];
  while (ccv-- > 0)
    o2.push(parse_LongRGB(blob, 8));
  return o2;
}
function parse_XFCRC(blob) {
  blob.l += 2;
  var o2 = { cxfs: 0, crc: 0 };
  o2.cxfs = blob.read_shift(2);
  o2.crc = blob.read_shift(4);
  return o2;
}
function parse_ColInfo(blob, length, opts) {
  if (!opts.cellStyles)
    return parsenoop(blob, length);
  var w2 = opts && opts.biff >= 12 ? 4 : 2;
  var colFirst = blob.read_shift(w2);
  var colLast = blob.read_shift(w2);
  var coldx = blob.read_shift(w2);
  var ixfe = blob.read_shift(w2);
  var flags = blob.read_shift(2);
  if (w2 == 2)
    blob.l += 2;
  var o2 = { s: colFirst, e: colLast, w: coldx, ixfe, flags };
  if (opts.biff >= 5 || !opts.biff)
    o2.level = flags >> 8 & 7;
  return o2;
}
function write_ColInfo(col, idx) {
  var o2 = new_buf(12);
  o2.write_shift(2, idx);
  o2.write_shift(2, idx);
  o2.write_shift(2, col.width * 256);
  o2.write_shift(2, 0);
  var f2 = 0;
  if (col.hidden)
    f2 |= 1;
  o2.write_shift(1, f2);
  f2 = col.level || 0;
  o2.write_shift(1, f2);
  o2.write_shift(2, 0);
  return o2;
}
function parse_Setup(blob, length) {
  var o2 = {};
  if (length < 32)
    return o2;
  blob.l += 16;
  o2.header = parse_Xnum(blob, 8);
  o2.footer = parse_Xnum(blob, 8);
  blob.l += 2;
  return o2;
}
function parse_ShtProps(blob, length, opts) {
  var def = { area: false };
  if (opts.biff != 5) {
    blob.l += length;
    return def;
  }
  var d2 = blob.read_shift(1);
  blob.l += 3;
  if (d2 & 16)
    def.area = true;
  return def;
}
function write_RRTabId(n2) {
  var out = new_buf(2 * n2);
  for (var i2 = 0; i2 < n2; ++i2)
    out.write_shift(2, i2 + 1);
  return out;
}
var parse_Blank = parse_XLSCell;
var parse_Scl = parseuint16a;
var parse_String = parse_XLUnicodeString;
function parse_ImData(blob) {
  var cf = blob.read_shift(2);
  var env = blob.read_shift(2);
  var lcb = blob.read_shift(4);
  var o2 = { fmt: cf, env, len: lcb, data: blob.slice(blob.l, blob.l + lcb) };
  blob.l += lcb;
  return o2;
}
function parse_BIFF2STR(blob, length, opts) {
  if (opts.biffguess && opts.biff == 5)
    opts.biff = 2;
  var cell = parse_XLSCell(blob, 6);
  ++blob.l;
  var str = parse_XLUnicodeString2(blob, length - 7, opts);
  cell.t = "str";
  cell.val = str;
  return cell;
}
function parse_BIFF2NUM(blob) {
  var cell = parse_XLSCell(blob, 6);
  ++blob.l;
  var num = parse_Xnum(blob, 8);
  cell.t = "n";
  cell.val = num;
  return cell;
}
function write_BIFF2NUM(r, c2, val) {
  var out = new_buf(15);
  write_BIFF2Cell(out, r, c2);
  out.write_shift(8, val, "f");
  return out;
}
function parse_BIFF2INT(blob) {
  var cell = parse_XLSCell(blob, 6);
  ++blob.l;
  var num = blob.read_shift(2);
  cell.t = "n";
  cell.val = num;
  return cell;
}
function write_BIFF2INT(r, c2, val) {
  var out = new_buf(9);
  write_BIFF2Cell(out, r, c2);
  out.write_shift(2, val);
  return out;
}
function parse_BIFF2STRING(blob) {
  var cch = blob.read_shift(1);
  if (cch === 0) {
    blob.l++;
    return "";
  }
  return blob.read_shift(cch, "sbcs-cont");
}
function parse_BIFF2FONTXTRA(blob, length) {
  blob.l += 6;
  blob.l += 2;
  blob.l += 1;
  blob.l += 3;
  blob.l += 1;
  blob.l += length - 13;
}
function parse_RString(blob, length, opts) {
  var end = blob.l + length;
  var cell = parse_XLSCell(blob, 6);
  var cch = blob.read_shift(2);
  var str = parse_XLUnicodeStringNoCch(blob, cch, opts);
  blob.l = end;
  cell.t = "str";
  cell.val = str;
  return cell;
}
var DBF_SUPPORTED_VERSIONS = [2, 3, 48, 49, 131, 139, 140, 245];
var DBF = /* @__PURE__ */ function() {
  var dbf_codepage_map = {
    /* Code Pages Supported by Visual FoxPro */
    /*::[*/
    1: 437,
    /*::[*/
    2: 850,
    /*::[*/
    3: 1252,
    /*::[*/
    4: 1e4,
    /*::[*/
    100: 852,
    /*::[*/
    101: 866,
    /*::[*/
    102: 865,
    /*::[*/
    103: 861,
    /*::[*/
    104: 895,
    /*::[*/
    105: 620,
    /*::[*/
    106: 737,
    /*::[*/
    107: 857,
    /*::[*/
    120: 950,
    /*::[*/
    121: 949,
    /*::[*/
    122: 936,
    /*::[*/
    123: 932,
    /*::[*/
    124: 874,
    /*::[*/
    125: 1255,
    /*::[*/
    126: 1256,
    /*::[*/
    150: 10007,
    /*::[*/
    151: 10029,
    /*::[*/
    152: 10006,
    /*::[*/
    200: 1250,
    /*::[*/
    201: 1251,
    /*::[*/
    202: 1254,
    /*::[*/
    203: 1253,
    /* shapefile DBF extension */
    /*::[*/
    0: 20127,
    /*::[*/
    8: 865,
    /*::[*/
    9: 437,
    /*::[*/
    10: 850,
    /*::[*/
    11: 437,
    /*::[*/
    13: 437,
    /*::[*/
    14: 850,
    /*::[*/
    15: 437,
    /*::[*/
    16: 850,
    /*::[*/
    17: 437,
    /*::[*/
    18: 850,
    /*::[*/
    19: 932,
    /*::[*/
    20: 850,
    /*::[*/
    21: 437,
    /*::[*/
    22: 850,
    /*::[*/
    23: 865,
    /*::[*/
    24: 437,
    /*::[*/
    25: 437,
    /*::[*/
    26: 850,
    /*::[*/
    27: 437,
    /*::[*/
    28: 863,
    /*::[*/
    29: 850,
    /*::[*/
    31: 852,
    /*::[*/
    34: 852,
    /*::[*/
    35: 852,
    /*::[*/
    36: 860,
    /*::[*/
    37: 850,
    /*::[*/
    38: 866,
    /*::[*/
    55: 850,
    /*::[*/
    64: 852,
    /*::[*/
    77: 936,
    /*::[*/
    78: 949,
    /*::[*/
    79: 950,
    /*::[*/
    80: 874,
    /*::[*/
    87: 1252,
    /*::[*/
    88: 1252,
    /*::[*/
    89: 1252,
    /*::[*/
    108: 863,
    /*::[*/
    134: 737,
    /*::[*/
    135: 852,
    /*::[*/
    136: 857,
    /*::[*/
    204: 1257,
    /*::[*/
    255: 16969
  };
  var dbf_reverse_map = evert({
    /*::[*/
    1: 437,
    /*::[*/
    2: 850,
    /*::[*/
    3: 1252,
    /*::[*/
    4: 1e4,
    /*::[*/
    100: 852,
    /*::[*/
    101: 866,
    /*::[*/
    102: 865,
    /*::[*/
    103: 861,
    /*::[*/
    104: 895,
    /*::[*/
    105: 620,
    /*::[*/
    106: 737,
    /*::[*/
    107: 857,
    /*::[*/
    120: 950,
    /*::[*/
    121: 949,
    /*::[*/
    122: 936,
    /*::[*/
    123: 932,
    /*::[*/
    124: 874,
    /*::[*/
    125: 1255,
    /*::[*/
    126: 1256,
    /*::[*/
    150: 10007,
    /*::[*/
    151: 10029,
    /*::[*/
    152: 10006,
    /*::[*/
    200: 1250,
    /*::[*/
    201: 1251,
    /*::[*/
    202: 1254,
    /*::[*/
    203: 1253,
    /*::[*/
    0: 20127
  });
  function dbf_to_aoa(buf, opts) {
    var out = [];
    var d2 = new_raw_buf(1);
    switch (opts.type) {
      case "base64":
        d2 = s2a(Base64_decode(buf));
        break;
      case "binary":
        d2 = s2a(buf);
        break;
      case "buffer":
      case "array":
        d2 = buf;
        break;
    }
    prep_blob(d2, 0);
    var ft2 = d2.read_shift(1);
    var memo = !!(ft2 & 136);
    var vfp = false, l7 = false;
    switch (ft2) {
      case 2:
        break;
      case 3:
        break;
      case 48:
        vfp = true;
        memo = true;
        break;
      case 49:
        vfp = true;
        memo = true;
        break;
      case 131:
        break;
      case 139:
        break;
      case 140:
        l7 = true;
        break;
      case 245:
        break;
      default:
        throw new Error("DBF Unsupported Version: " + ft2.toString(16));
    }
    var nrow = 0, fpos = 521;
    if (ft2 == 2)
      nrow = d2.read_shift(2);
    d2.l += 3;
    if (ft2 != 2)
      nrow = d2.read_shift(4);
    if (nrow > 1048576)
      nrow = 1e6;
    if (ft2 != 2)
      fpos = d2.read_shift(2);
    var rlen = d2.read_shift(2);
    var current_cp = opts.codepage || 1252;
    if (ft2 != 2) {
      d2.l += 16;
      d2.read_shift(1);
      if (d2[d2.l] !== 0)
        current_cp = dbf_codepage_map[d2[d2.l]];
      d2.l += 1;
      d2.l += 2;
    }
    if (l7)
      d2.l += 36;
    var fields = [], field = {};
    var hend = Math.min(d2.length, ft2 == 2 ? 521 : fpos - 10 - (vfp ? 264 : 0));
    var ww = l7 ? 32 : 11;
    while (d2.l < hend && d2[d2.l] != 13) {
      field = {};
      field.name = $cptable.utils.decode(current_cp, d2.slice(d2.l, d2.l + ww)).replace(/[\u0000\r\n].*$/g, "");
      d2.l += ww;
      field.type = String.fromCharCode(d2.read_shift(1));
      if (ft2 != 2 && !l7)
        field.offset = d2.read_shift(4);
      field.len = d2.read_shift(1);
      if (ft2 == 2)
        field.offset = d2.read_shift(2);
      field.dec = d2.read_shift(1);
      if (field.name.length)
        fields.push(field);
      if (ft2 != 2)
        d2.l += l7 ? 13 : 14;
      switch (field.type) {
        case "B":
          if ((!vfp || field.len != 8) && opts.WTF)
            console.log("Skipping " + field.name + ":" + field.type);
          break;
        case "G":
        case "P":
          if (opts.WTF)
            console.log("Skipping " + field.name + ":" + field.type);
          break;
        case "+":
        case "0":
        case "@":
        case "C":
        case "D":
        case "F":
        case "I":
        case "L":
        case "M":
        case "N":
        case "O":
        case "T":
        case "Y":
          break;
        default:
          throw new Error("Unknown Field Type: " + field.type);
      }
    }
    if (d2[d2.l] !== 13)
      d2.l = fpos - 1;
    if (d2.read_shift(1) !== 13)
      throw new Error("DBF Terminator not found " + d2.l + " " + d2[d2.l]);
    d2.l = fpos;
    var R2 = 0, C2 = 0;
    out[0] = [];
    for (C2 = 0; C2 != fields.length; ++C2)
      out[0][C2] = fields[C2].name;
    while (nrow-- > 0) {
      if (d2[d2.l] === 42) {
        d2.l += rlen;
        continue;
      }
      ++d2.l;
      out[++R2] = [];
      C2 = 0;
      for (C2 = 0; C2 != fields.length; ++C2) {
        var dd = d2.slice(d2.l, d2.l + fields[C2].len);
        d2.l += fields[C2].len;
        prep_blob(dd, 0);
        var s2 = $cptable.utils.decode(current_cp, dd);
        switch (fields[C2].type) {
          case "C":
            if (s2.trim().length)
              out[R2][C2] = s2.replace(/\s+$/, "");
            break;
          case "D":
            if (s2.length === 8)
              out[R2][C2] = new Date(+s2.slice(0, 4), +s2.slice(4, 6) - 1, +s2.slice(6, 8));
            else
              out[R2][C2] = s2;
            break;
          case "F":
            out[R2][C2] = parseFloat(s2.trim());
            break;
          case "+":
          case "I":
            out[R2][C2] = l7 ? dd.read_shift(-4, "i") ^ 2147483648 : dd.read_shift(4, "i");
            break;
          case "L":
            switch (s2.trim().toUpperCase()) {
              case "Y":
              case "T":
                out[R2][C2] = true;
                break;
              case "N":
              case "F":
                out[R2][C2] = false;
                break;
              case "":
              case "?":
                break;
              default:
                throw new Error("DBF Unrecognized L:|" + s2 + "|");
            }
            break;
          case "M":
            if (!memo)
              throw new Error("DBF Unexpected MEMO for type " + ft2.toString(16));
            out[R2][C2] = "##MEMO##" + (l7 ? parseInt(s2.trim(), 10) : dd.read_shift(4));
            break;
          case "N":
            s2 = s2.replace(/\u0000/g, "").trim();
            if (s2 && s2 != ".")
              out[R2][C2] = +s2 || 0;
            break;
          case "@":
            out[R2][C2] = new Date(dd.read_shift(-8, "f") - 621356832e5);
            break;
          case "T":
            out[R2][C2] = new Date((dd.read_shift(4) - 2440588) * 864e5 + dd.read_shift(4));
            break;
          case "Y":
            out[R2][C2] = dd.read_shift(4, "i") / 1e4 + dd.read_shift(4, "i") / 1e4 * Math.pow(2, 32);
            break;
          case "O":
            out[R2][C2] = -dd.read_shift(-8, "f");
            break;
          case "B":
            if (vfp && fields[C2].len == 8) {
              out[R2][C2] = dd.read_shift(8, "f");
              break;
            }
          case "G":
          case "P":
            dd.l += fields[C2].len;
            break;
          case "0":
            if (fields[C2].name === "_NullFlags")
              break;
          default:
            throw new Error("DBF Unsupported data type " + fields[C2].type);
        }
      }
    }
    if (ft2 != 2) {
      if (d2.l < d2.length && d2[d2.l++] != 26)
        throw new Error("DBF EOF Marker missing " + (d2.l - 1) + " of " + d2.length + " " + d2[d2.l - 1].toString(16));
    }
    if (opts && opts.sheetRows)
      out = out.slice(0, opts.sheetRows);
    opts.DBF = fields;
    return out;
  }
  function dbf_to_sheet(buf, opts) {
    var o2 = opts || {};
    if (!o2.dateNF)
      o2.dateNF = "yyyymmdd";
    var ws = aoa_to_sheet(dbf_to_aoa(buf, o2), o2);
    ws["!cols"] = o2.DBF.map(function(field) {
      return {
        wch: field.len,
        DBF: field
      };
    });
    delete o2.DBF;
    return ws;
  }
  function dbf_to_workbook(buf, opts) {
    try {
      return sheet_to_workbook(dbf_to_sheet(buf, opts), opts);
    } catch (e) {
      if (opts && opts.WTF)
        throw e;
    }
    return { SheetNames: [], Sheets: {} };
  }
  var _RLEN = { "B": 8, "C": 250, "L": 1, "D": 8, "?": 0, "": 0 };
  function sheet_to_dbf(ws, opts) {
    var o2 = opts || {};
    if (+o2.codepage >= 0)
      set_cp(+o2.codepage);
    if (o2.type == "string")
      throw new Error("Cannot write DBF to JS string");
    var ba = buf_array();
    var aoa = sheet_to_json(ws, { header: 1, raw: true, cellDates: true });
    var headers = aoa[0], data = aoa.slice(1), cols = ws["!cols"] || [];
    var i2 = 0, j2 = 0, hcnt = 0, rlen = 1;
    for (i2 = 0; i2 < headers.length; ++i2) {
      if (((cols[i2] || {}).DBF || {}).name) {
        headers[i2] = cols[i2].DBF.name;
        ++hcnt;
        continue;
      }
      if (headers[i2] == null)
        continue;
      ++hcnt;
      if (typeof headers[i2] === "number")
        headers[i2] = headers[i2].toString(10);
      if (typeof headers[i2] !== "string")
        throw new Error("DBF Invalid column name " + headers[i2] + " |" + typeof headers[i2] + "|");
      if (headers.indexOf(headers[i2]) !== i2) {
        for (j2 = 0; j2 < 1024; ++j2)
          if (headers.indexOf(headers[i2] + "_" + j2) == -1) {
            headers[i2] += "_" + j2;
            break;
          }
      }
    }
    var range = safe_decode_range(ws["!ref"]);
    var coltypes = [];
    var colwidths = [];
    var coldecimals = [];
    for (i2 = 0; i2 <= range.e.c - range.s.c; ++i2) {
      var guess = "", _guess = "", maxlen = 0;
      var col = [];
      for (j2 = 0; j2 < data.length; ++j2) {
        if (data[j2][i2] != null)
          col.push(data[j2][i2]);
      }
      if (col.length == 0 || headers[i2] == null) {
        coltypes[i2] = "?";
        continue;
      }
      for (j2 = 0; j2 < col.length; ++j2) {
        switch (typeof col[j2]) {
          case "number":
            _guess = "B";
            break;
          case "string":
            _guess = "C";
            break;
          case "boolean":
            _guess = "L";
            break;
          case "object":
            _guess = col[j2] instanceof Date ? "D" : "C";
            break;
          default:
            _guess = "C";
        }
        maxlen = Math.max(maxlen, String(col[j2]).length);
        guess = guess && guess != _guess ? "C" : _guess;
      }
      if (maxlen > 250)
        maxlen = 250;
      _guess = ((cols[i2] || {}).DBF || {}).type;
      if (_guess == "C") {
        if (cols[i2].DBF.len > maxlen)
          maxlen = cols[i2].DBF.len;
      }
      if (guess == "B" && _guess == "N") {
        guess = "N";
        coldecimals[i2] = cols[i2].DBF.dec;
        maxlen = cols[i2].DBF.len;
      }
      colwidths[i2] = guess == "C" || _guess == "N" ? maxlen : _RLEN[guess] || 0;
      rlen += colwidths[i2];
      coltypes[i2] = guess;
    }
    var h2 = ba.next(32);
    h2.write_shift(4, 318902576);
    h2.write_shift(4, data.length);
    h2.write_shift(2, 296 + 32 * hcnt);
    h2.write_shift(2, rlen);
    for (i2 = 0; i2 < 4; ++i2)
      h2.write_shift(4, 0);
    h2.write_shift(4, 0 | (+dbf_reverse_map[
      /*::String(*/
      current_ansi
      /*::)*/
    ] || 3) << 8);
    for (i2 = 0, j2 = 0; i2 < headers.length; ++i2) {
      if (headers[i2] == null)
        continue;
      var hf = ba.next(32);
      var _f = (headers[i2].slice(-10) + "\0\0\0\0\0\0\0\0\0\0\0").slice(0, 11);
      hf.write_shift(1, _f, "sbcs");
      hf.write_shift(1, coltypes[i2] == "?" ? "C" : coltypes[i2], "sbcs");
      hf.write_shift(4, j2);
      hf.write_shift(1, colwidths[i2] || _RLEN[coltypes[i2]] || 0);
      hf.write_shift(1, coldecimals[i2] || 0);
      hf.write_shift(1, 2);
      hf.write_shift(4, 0);
      hf.write_shift(1, 0);
      hf.write_shift(4, 0);
      hf.write_shift(4, 0);
      j2 += colwidths[i2] || _RLEN[coltypes[i2]] || 0;
    }
    var hb = ba.next(264);
    hb.write_shift(4, 13);
    for (i2 = 0; i2 < 65; ++i2)
      hb.write_shift(4, 0);
    for (i2 = 0; i2 < data.length; ++i2) {
      var rout = ba.next(rlen);
      rout.write_shift(1, 0);
      for (j2 = 0; j2 < headers.length; ++j2) {
        if (headers[j2] == null)
          continue;
        switch (coltypes[j2]) {
          case "L":
            rout.write_shift(1, data[i2][j2] == null ? 63 : data[i2][j2] ? 84 : 70);
            break;
          case "B":
            rout.write_shift(8, data[i2][j2] || 0, "f");
            break;
          case "N":
            var _n = "0";
            if (typeof data[i2][j2] == "number")
              _n = data[i2][j2].toFixed(coldecimals[j2] || 0);
            for (hcnt = 0; hcnt < colwidths[j2] - _n.length; ++hcnt)
              rout.write_shift(1, 32);
            rout.write_shift(1, _n, "sbcs");
            break;
          case "D":
            if (!data[i2][j2])
              rout.write_shift(8, "00000000", "sbcs");
            else {
              rout.write_shift(4, ("0000" + data[i2][j2].getFullYear()).slice(-4), "sbcs");
              rout.write_shift(2, ("00" + (data[i2][j2].getMonth() + 1)).slice(-2), "sbcs");
              rout.write_shift(2, ("00" + data[i2][j2].getDate()).slice(-2), "sbcs");
            }
            break;
          case "C":
            var _s = String(data[i2][j2] != null ? data[i2][j2] : "").slice(0, colwidths[j2]);
            rout.write_shift(1, _s, "sbcs");
            for (hcnt = 0; hcnt < colwidths[j2] - _s.length; ++hcnt)
              rout.write_shift(1, 32);
            break;
        }
      }
    }
    ba.next(1).write_shift(1, 26);
    return ba.end();
  }
  return {
    to_workbook: dbf_to_workbook,
    to_sheet: dbf_to_sheet,
    from_sheet: sheet_to_dbf
  };
}();
var SYLK = /* @__PURE__ */ function() {
  var sylk_escapes = {
    AA: "\xC0",
    BA: "\xC1",
    CA: "\xC2",
    DA: 195,
    HA: "\xC4",
    JA: 197,
    AE: "\xC8",
    BE: "\xC9",
    CE: "\xCA",
    HE: "\xCB",
    AI: "\xCC",
    BI: "\xCD",
    CI: "\xCE",
    HI: "\xCF",
    AO: "\xD2",
    BO: "\xD3",
    CO: "\xD4",
    DO: 213,
    HO: "\xD6",
    AU: "\xD9",
    BU: "\xDA",
    CU: "\xDB",
    HU: "\xDC",
    Aa: "\xE0",
    Ba: "\xE1",
    Ca: "\xE2",
    Da: 227,
    Ha: "\xE4",
    Ja: 229,
    Ae: "\xE8",
    Be: "\xE9",
    Ce: "\xEA",
    He: "\xEB",
    Ai: "\xEC",
    Bi: "\xED",
    Ci: "\xEE",
    Hi: "\xEF",
    Ao: "\xF2",
    Bo: "\xF3",
    Co: "\xF4",
    Do: 245,
    Ho: "\xF6",
    Au: "\xF9",
    Bu: "\xFA",
    Cu: "\xFB",
    Hu: "\xFC",
    KC: "\xC7",
    Kc: "\xE7",
    q: "\xE6",
    z: "\u0153",
    a: "\xC6",
    j: "\u0152",
    DN: 209,
    Dn: 241,
    Hy: 255,
    S: 169,
    c: 170,
    R: 174,
    "B ": 180,
    /*::[*/
    0: 176,
    /*::[*/
    1: 177,
    /*::[*/
    2: 178,
    /*::[*/
    3: 179,
    /*::[*/
    5: 181,
    /*::[*/
    6: 182,
    /*::[*/
    7: 183,
    Q: 185,
    k: 186,
    b: 208,
    i: 216,
    l: 222,
    s: 240,
    y: 248,
    "!": 161,
    '"': 162,
    "#": 163,
    "(": 164,
    "%": 165,
    "'": 167,
    "H ": 168,
    "+": 171,
    ";": 187,
    "<": 188,
    "=": 189,
    ">": 190,
    "?": 191,
    "{": 223
  };
  var sylk_char_regex = new RegExp("\x1BN(" + keys(sylk_escapes).join("|").replace(/\|\|\|/, "|\\||").replace(/([?()+])/g, "\\$1") + "|\\|)", "gm");
  var sylk_char_fn = function(_2, $1) {
    var o2 = sylk_escapes[$1];
    return typeof o2 == "number" ? _getansi(o2) : o2;
  };
  var decode_sylk_char = function($$, $1, $22) {
    var newcc = $1.charCodeAt(0) - 32 << 4 | $22.charCodeAt(0) - 48;
    return newcc == 59 ? $$ : _getansi(newcc);
  };
  sylk_escapes["|"] = 254;
  function sylk_to_aoa(d2, opts) {
    switch (opts.type) {
      case "base64":
        return sylk_to_aoa_str(Base64_decode(d2), opts);
      case "binary":
        return sylk_to_aoa_str(d2, opts);
      case "buffer":
        return sylk_to_aoa_str(has_buf && Buffer.isBuffer(d2) ? d2.toString("binary") : a2s(d2), opts);
      case "array":
        return sylk_to_aoa_str(cc2str(d2), opts);
    }
    throw new Error("Unrecognized type " + opts.type);
  }
  function sylk_to_aoa_str(str, opts) {
    var records = str.split(/[\n\r]+/), R2 = -1, C2 = -1, ri = 0, rj = 0, arr = [];
    var formats = [];
    var next_cell_format = null;
    var sht = {}, rowinfo = [], colinfo = [], cw = [];
    var Mval = 0, j2;
    if (+opts.codepage >= 0)
      set_cp(+opts.codepage);
    for (; ri !== records.length; ++ri) {
      Mval = 0;
      var rstr = records[ri].trim().replace(/\x1B([\x20-\x2F])([\x30-\x3F])/g, decode_sylk_char).replace(sylk_char_regex, sylk_char_fn);
      var record = rstr.replace(/;;/g, "\0").split(";").map(function(x2) {
        return x2.replace(/\u0000/g, ";");
      });
      var RT = record[0], val;
      if (rstr.length > 0)
        switch (RT) {
          case "ID":
            break;
          case "E":
            break;
          case "B":
            break;
          case "O":
            break;
          case "W":
            break;
          case "P":
            if (record[1].charAt(0) == "P")
              formats.push(rstr.slice(3).replace(/;;/g, ";"));
            break;
          case "C":
            var C_seen_K = false, C_seen_X = false, C_seen_S = false, C_seen_E = false, _R = -1, _C = -1;
            for (rj = 1; rj < record.length; ++rj)
              switch (record[rj].charAt(0)) {
                case "A":
                  break;
                case "X":
                  C2 = parseInt(record[rj].slice(1)) - 1;
                  C_seen_X = true;
                  break;
                case "Y":
                  R2 = parseInt(record[rj].slice(1)) - 1;
                  if (!C_seen_X)
                    C2 = 0;
                  for (j2 = arr.length; j2 <= R2; ++j2)
                    arr[j2] = [];
                  break;
                case "K":
                  val = record[rj].slice(1);
                  if (val.charAt(0) === '"')
                    val = val.slice(1, val.length - 1);
                  else if (val === "TRUE")
                    val = true;
                  else if (val === "FALSE")
                    val = false;
                  else if (!isNaN(fuzzynum(val))) {
                    val = fuzzynum(val);
                    if (next_cell_format !== null && fmt_is_date(next_cell_format))
                      val = numdate(val);
                  } else if (!isNaN(fuzzydate(val).getDate())) {
                    val = parseDate(val);
                  }
                  if (typeof $cptable !== "undefined" && typeof val == "string" && (opts || {}).type != "string" && (opts || {}).codepage)
                    val = $cptable.utils.decode(opts.codepage, val);
                  C_seen_K = true;
                  break;
                case "E":
                  C_seen_E = true;
                  var formula = rc_to_a1(record[rj].slice(1), { r: R2, c: C2 });
                  arr[R2][C2] = [arr[R2][C2], formula];
                  break;
                case "S":
                  C_seen_S = true;
                  arr[R2][C2] = [arr[R2][C2], "S5S"];
                  break;
                case "G":
                  break;
                case "R":
                  _R = parseInt(record[rj].slice(1)) - 1;
                  break;
                case "C":
                  _C = parseInt(record[rj].slice(1)) - 1;
                  break;
                default:
                  if (opts && opts.WTF)
                    throw new Error("SYLK bad record " + rstr);
              }
            if (C_seen_K) {
              if (arr[R2][C2] && arr[R2][C2].length == 2)
                arr[R2][C2][0] = val;
              else
                arr[R2][C2] = val;
              next_cell_format = null;
            }
            if (C_seen_S) {
              if (C_seen_E)
                throw new Error("SYLK shared formula cannot have own formula");
              var shrbase = _R > -1 && arr[_R][_C];
              if (!shrbase || !shrbase[1])
                throw new Error("SYLK shared formula cannot find base");
              arr[R2][C2][1] = shift_formula_str(shrbase[1], { r: R2 - _R, c: C2 - _C });
            }
            break;
          case "F":
            var F_seen = 0;
            for (rj = 1; rj < record.length; ++rj)
              switch (record[rj].charAt(0)) {
                case "X":
                  C2 = parseInt(record[rj].slice(1)) - 1;
                  ++F_seen;
                  break;
                case "Y":
                  R2 = parseInt(record[rj].slice(1)) - 1;
                  for (j2 = arr.length; j2 <= R2; ++j2)
                    arr[j2] = [];
                  break;
                case "M":
                  Mval = parseInt(record[rj].slice(1)) / 20;
                  break;
                case "F":
                  break;
                case "G":
                  break;
                case "P":
                  next_cell_format = formats[parseInt(record[rj].slice(1))];
                  break;
                case "S":
                  break;
                case "D":
                  break;
                case "N":
                  break;
                case "W":
                  cw = record[rj].slice(1).split(" ");
                  for (j2 = parseInt(cw[0], 10); j2 <= parseInt(cw[1], 10); ++j2) {
                    Mval = parseInt(cw[2], 10);
                    colinfo[j2 - 1] = Mval === 0 ? { hidden: true } : { wch: Mval };
                    process_col(colinfo[j2 - 1]);
                  }
                  break;
                case "C":
                  C2 = parseInt(record[rj].slice(1)) - 1;
                  if (!colinfo[C2])
                    colinfo[C2] = {};
                  break;
                case "R":
                  R2 = parseInt(record[rj].slice(1)) - 1;
                  if (!rowinfo[R2])
                    rowinfo[R2] = {};
                  if (Mval > 0) {
                    rowinfo[R2].hpt = Mval;
                    rowinfo[R2].hpx = pt2px(Mval);
                  } else if (Mval === 0)
                    rowinfo[R2].hidden = true;
                  break;
                default:
                  if (opts && opts.WTF)
                    throw new Error("SYLK bad record " + rstr);
              }
            if (F_seen < 1)
              next_cell_format = null;
            break;
          default:
            if (opts && opts.WTF)
              throw new Error("SYLK bad record " + rstr);
        }
    }
    if (rowinfo.length > 0)
      sht["!rows"] = rowinfo;
    if (colinfo.length > 0)
      sht["!cols"] = colinfo;
    if (opts && opts.sheetRows)
      arr = arr.slice(0, opts.sheetRows);
    return [arr, sht];
  }
  function sylk_to_sheet(d2, opts) {
    var aoasht = sylk_to_aoa(d2, opts);
    var aoa = aoasht[0], ws = aoasht[1];
    var o2 = aoa_to_sheet(aoa, opts);
    keys(ws).forEach(function(k2) {
      o2[k2] = ws[k2];
    });
    return o2;
  }
  function sylk_to_workbook(d2, opts) {
    return sheet_to_workbook(sylk_to_sheet(d2, opts), opts);
  }
  function write_ws_cell_sylk(cell, ws, R2, C2) {
    var o2 = "C;Y" + (R2 + 1) + ";X" + (C2 + 1) + ";K";
    switch (cell.t) {
      case "n":
        o2 += cell.v || 0;
        if (cell.f && !cell.F)
          o2 += ";E" + a1_to_rc(cell.f, { r: R2, c: C2 });
        break;
      case "b":
        o2 += cell.v ? "TRUE" : "FALSE";
        break;
      case "e":
        o2 += cell.w || cell.v;
        break;
      case "d":
        o2 += '"' + (cell.w || cell.v) + '"';
        break;
      case "s":
        o2 += '"' + cell.v.replace(/"/g, "").replace(/;/g, ";;") + '"';
        break;
    }
    return o2;
  }
  function write_ws_cols_sylk(out, cols) {
    cols.forEach(function(col, i2) {
      var rec = "F;W" + (i2 + 1) + " " + (i2 + 1) + " ";
      if (col.hidden)
        rec += "0";
      else {
        if (typeof col.width == "number" && !col.wpx)
          col.wpx = width2px(col.width);
        if (typeof col.wpx == "number" && !col.wch)
          col.wch = px2char(col.wpx);
        if (typeof col.wch == "number")
          rec += Math.round(col.wch);
      }
      if (rec.charAt(rec.length - 1) != " ")
        out.push(rec);
    });
  }
  function write_ws_rows_sylk(out, rows) {
    rows.forEach(function(row, i2) {
      var rec = "F;";
      if (row.hidden)
        rec += "M0;";
      else if (row.hpt)
        rec += "M" + 20 * row.hpt + ";";
      else if (row.hpx)
        rec += "M" + 20 * px2pt(row.hpx) + ";";
      if (rec.length > 2)
        out.push(rec + "R" + (i2 + 1));
    });
  }
  function sheet_to_sylk(ws, opts) {
    var preamble = ["ID;PWXL;N;E"], o2 = [];
    var r = safe_decode_range(ws["!ref"]), cell;
    var dense = Array.isArray(ws);
    var RS = "\r\n";
    preamble.push("P;PGeneral");
    preamble.push("F;P0;DG0G8;M255");
    if (ws["!cols"])
      write_ws_cols_sylk(preamble, ws["!cols"]);
    if (ws["!rows"])
      write_ws_rows_sylk(preamble, ws["!rows"]);
    preamble.push("B;Y" + (r.e.r - r.s.r + 1) + ";X" + (r.e.c - r.s.c + 1) + ";D" + [r.s.c, r.s.r, r.e.c, r.e.r].join(" "));
    for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
      for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
        var coord = encode_cell({ r: R2, c: C2 });
        cell = dense ? (ws[R2] || [])[C2] : ws[coord];
        if (!cell || cell.v == null && (!cell.f || cell.F))
          continue;
        o2.push(write_ws_cell_sylk(cell, ws, R2, C2, opts));
      }
    }
    return preamble.join(RS) + RS + o2.join(RS) + RS + "E" + RS;
  }
  return {
    to_workbook: sylk_to_workbook,
    to_sheet: sylk_to_sheet,
    from_sheet: sheet_to_sylk
  };
}();
var DIF = /* @__PURE__ */ function() {
  function dif_to_aoa(d2, opts) {
    switch (opts.type) {
      case "base64":
        return dif_to_aoa_str(Base64_decode(d2), opts);
      case "binary":
        return dif_to_aoa_str(d2, opts);
      case "buffer":
        return dif_to_aoa_str(has_buf && Buffer.isBuffer(d2) ? d2.toString("binary") : a2s(d2), opts);
      case "array":
        return dif_to_aoa_str(cc2str(d2), opts);
    }
    throw new Error("Unrecognized type " + opts.type);
  }
  function dif_to_aoa_str(str, opts) {
    var records = str.split("\n"), R2 = -1, C2 = -1, ri = 0, arr = [];
    for (; ri !== records.length; ++ri) {
      if (records[ri].trim() === "BOT") {
        arr[++R2] = [];
        C2 = 0;
        continue;
      }
      if (R2 < 0)
        continue;
      var metadata = records[ri].trim().split(",");
      var type = metadata[0], value = metadata[1];
      ++ri;
      var data = records[ri] || "";
      while ((data.match(/["]/g) || []).length & 1 && ri < records.length - 1)
        data += "\n" + records[++ri];
      data = data.trim();
      switch (+type) {
        case -1:
          if (data === "BOT") {
            arr[++R2] = [];
            C2 = 0;
            continue;
          } else if (data !== "EOD")
            throw new Error("Unrecognized DIF special command " + data);
          break;
        case 0:
          if (data === "TRUE")
            arr[R2][C2] = true;
          else if (data === "FALSE")
            arr[R2][C2] = false;
          else if (!isNaN(fuzzynum(value)))
            arr[R2][C2] = fuzzynum(value);
          else if (!isNaN(fuzzydate(value).getDate()))
            arr[R2][C2] = parseDate(value);
          else
            arr[R2][C2] = value;
          ++C2;
          break;
        case 1:
          data = data.slice(1, data.length - 1);
          data = data.replace(/""/g, '"');
          if (DIF_XL && data && data.match(/^=".*"$/))
            data = data.slice(2, -1);
          arr[R2][C2++] = data !== "" ? data : null;
          break;
      }
      if (data === "EOD")
        break;
    }
    if (opts && opts.sheetRows)
      arr = arr.slice(0, opts.sheetRows);
    return arr;
  }
  function dif_to_sheet(str, opts) {
    return aoa_to_sheet(dif_to_aoa(str, opts), opts);
  }
  function dif_to_workbook(str, opts) {
    return sheet_to_workbook(dif_to_sheet(str, opts), opts);
  }
  var sheet_to_dif = /* @__PURE__ */ function() {
    var push_field = function pf(o2, topic, v2, n2, s2) {
      o2.push(topic);
      o2.push(v2 + "," + n2);
      o2.push('"' + s2.replace(/"/g, '""') + '"');
    };
    var push_value = function po(o2, type, v2, s2) {
      o2.push(type + "," + v2);
      o2.push(type == 1 ? '"' + s2.replace(/"/g, '""') + '"' : s2);
    };
    return function sheet_to_dif2(ws) {
      var o2 = [];
      var r = safe_decode_range(ws["!ref"]), cell;
      var dense = Array.isArray(ws);
      push_field(o2, "TABLE", 0, 1, "sheetjs");
      push_field(o2, "VECTORS", 0, r.e.r - r.s.r + 1, "");
      push_field(o2, "TUPLES", 0, r.e.c - r.s.c + 1, "");
      push_field(o2, "DATA", 0, 0, "");
      for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
        push_value(o2, -1, 0, "BOT");
        for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
          var coord = encode_cell({ r: R2, c: C2 });
          cell = dense ? (ws[R2] || [])[C2] : ws[coord];
          if (!cell) {
            push_value(o2, 1, 0, "");
            continue;
          }
          switch (cell.t) {
            case "n":
              var val = DIF_XL ? cell.w : cell.v;
              if (!val && cell.v != null)
                val = cell.v;
              if (val == null) {
                if (DIF_XL && cell.f && !cell.F)
                  push_value(o2, 1, 0, "=" + cell.f);
                else
                  push_value(o2, 1, 0, "");
              } else
                push_value(o2, 0, val, "V");
              break;
            case "b":
              push_value(o2, 0, cell.v ? 1 : 0, cell.v ? "TRUE" : "FALSE");
              break;
            case "s":
              push_value(o2, 1, 0, !DIF_XL || isNaN(cell.v) ? cell.v : '="' + cell.v + '"');
              break;
            case "d":
              if (!cell.w)
                cell.w = SSF_format(cell.z || table_fmt[14], datenum(parseDate(cell.v)));
              if (DIF_XL)
                push_value(o2, 0, cell.w, "V");
              else
                push_value(o2, 1, 0, cell.w);
              break;
            default:
              push_value(o2, 1, 0, "");
          }
        }
      }
      push_value(o2, -1, 0, "EOD");
      var RS = "\r\n";
      var oo = o2.join(RS);
      return oo;
    };
  }();
  return {
    to_workbook: dif_to_workbook,
    to_sheet: dif_to_sheet,
    from_sheet: sheet_to_dif
  };
}();
var ETH = /* @__PURE__ */ function() {
  function decode(s2) {
    return s2.replace(/\\b/g, "\\").replace(/\\c/g, ":").replace(/\\n/g, "\n");
  }
  function encode(s2) {
    return s2.replace(/\\/g, "\\b").replace(/:/g, "\\c").replace(/\n/g, "\\n");
  }
  function eth_to_aoa(str, opts) {
    var records = str.split("\n"), R2 = -1, C2 = -1, ri = 0, arr = [];
    for (; ri !== records.length; ++ri) {
      var record = records[ri].trim().split(":");
      if (record[0] !== "cell")
        continue;
      var addr = decode_cell(record[1]);
      if (arr.length <= addr.r) {
        for (R2 = arr.length; R2 <= addr.r; ++R2)
          if (!arr[R2])
            arr[R2] = [];
      }
      R2 = addr.r;
      C2 = addr.c;
      switch (record[2]) {
        case "t":
          arr[R2][C2] = decode(record[3]);
          break;
        case "v":
          arr[R2][C2] = +record[3];
          break;
        case "vtf":
          var _f = record[record.length - 1];
        case "vtc":
          switch (record[3]) {
            case "nl":
              arr[R2][C2] = +record[4] ? true : false;
              break;
            default:
              arr[R2][C2] = +record[4];
              break;
          }
          if (record[2] == "vtf")
            arr[R2][C2] = [arr[R2][C2], _f];
      }
    }
    if (opts && opts.sheetRows)
      arr = arr.slice(0, opts.sheetRows);
    return arr;
  }
  function eth_to_sheet(d2, opts) {
    return aoa_to_sheet(eth_to_aoa(d2, opts), opts);
  }
  function eth_to_workbook(d2, opts) {
    return sheet_to_workbook(eth_to_sheet(d2, opts), opts);
  }
  var header = [
    "socialcalc:version:1.5",
    "MIME-Version: 1.0",
    "Content-Type: multipart/mixed; boundary=SocialCalcSpreadsheetControlSave"
  ].join("\n");
  var sep = [
    "--SocialCalcSpreadsheetControlSave",
    "Content-type: text/plain; charset=UTF-8"
  ].join("\n") + "\n";
  var meta = [
    "# SocialCalc Spreadsheet Control Save",
    "part:sheet"
  ].join("\n");
  var end = "--SocialCalcSpreadsheetControlSave--";
  function sheet_to_eth_data(ws) {
    if (!ws || !ws["!ref"])
      return "";
    var o2 = [], oo = [], cell, coord = "";
    var r = decode_range(ws["!ref"]);
    var dense = Array.isArray(ws);
    for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
      for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
        coord = encode_cell({ r: R2, c: C2 });
        cell = dense ? (ws[R2] || [])[C2] : ws[coord];
        if (!cell || cell.v == null || cell.t === "z")
          continue;
        oo = ["cell", coord, "t"];
        switch (cell.t) {
          case "s":
          case "str":
            oo.push(encode(cell.v));
            break;
          case "n":
            if (!cell.f) {
              oo[2] = "v";
              oo[3] = cell.v;
            } else {
              oo[2] = "vtf";
              oo[3] = "n";
              oo[4] = cell.v;
              oo[5] = encode(cell.f);
            }
            break;
          case "b":
            oo[2] = "vt" + (cell.f ? "f" : "c");
            oo[3] = "nl";
            oo[4] = cell.v ? "1" : "0";
            oo[5] = encode(cell.f || (cell.v ? "TRUE" : "FALSE"));
            break;
          case "d":
            var t2 = datenum(parseDate(cell.v));
            oo[2] = "vtc";
            oo[3] = "nd";
            oo[4] = "" + t2;
            oo[5] = cell.w || SSF_format(cell.z || table_fmt[14], t2);
            break;
          case "e":
            continue;
        }
        o2.push(oo.join(":"));
      }
    }
    o2.push("sheet:c:" + (r.e.c - r.s.c + 1) + ":r:" + (r.e.r - r.s.r + 1) + ":tvf:1");
    o2.push("valueformat:1:text-wiki");
    return o2.join("\n");
  }
  function sheet_to_eth(ws) {
    return [header, sep, meta, sep, sheet_to_eth_data(ws), end].join("\n");
  }
  return {
    to_workbook: eth_to_workbook,
    to_sheet: eth_to_sheet,
    from_sheet: sheet_to_eth
  };
}();
var PRN = /* @__PURE__ */ function() {
  function set_text_arr(data, arr, R2, C2, o2) {
    if (o2.raw)
      arr[R2][C2] = data;
    else if (data === "") {
    } else if (data === "TRUE")
      arr[R2][C2] = true;
    else if (data === "FALSE")
      arr[R2][C2] = false;
    else if (!isNaN(fuzzynum(data)))
      arr[R2][C2] = fuzzynum(data);
    else if (!isNaN(fuzzydate(data).getDate()))
      arr[R2][C2] = parseDate(data);
    else
      arr[R2][C2] = data;
  }
  function prn_to_aoa_str(f2, opts) {
    var o2 = opts || {};
    var arr = [];
    if (!f2 || f2.length === 0)
      return arr;
    var lines = f2.split(/[\r\n]/);
    var L2 = lines.length - 1;
    while (L2 >= 0 && lines[L2].length === 0)
      --L2;
    var start = 10, idx = 0;
    var R2 = 0;
    for (; R2 <= L2; ++R2) {
      idx = lines[R2].indexOf(" ");
      if (idx == -1)
        idx = lines[R2].length;
      else
        idx++;
      start = Math.max(start, idx);
    }
    for (R2 = 0; R2 <= L2; ++R2) {
      arr[R2] = [];
      var C2 = 0;
      set_text_arr(lines[R2].slice(0, start).trim(), arr, R2, C2, o2);
      for (C2 = 1; C2 <= (lines[R2].length - start) / 10 + 1; ++C2)
        set_text_arr(lines[R2].slice(start + (C2 - 1) * 10, start + C2 * 10).trim(), arr, R2, C2, o2);
    }
    if (o2.sheetRows)
      arr = arr.slice(0, o2.sheetRows);
    return arr;
  }
  var guess_seps = {
    /*::[*/
    44: ",",
    /*::[*/
    9: "	",
    /*::[*/
    59: ";",
    /*::[*/
    124: "|"
  };
  var guess_sep_weights = {
    /*::[*/
    44: 3,
    /*::[*/
    9: 2,
    /*::[*/
    59: 1,
    /*::[*/
    124: 0
  };
  function guess_sep(str) {
    var cnt = {}, instr = false, end = 0, cc = 0;
    for (; end < str.length; ++end) {
      if ((cc = str.charCodeAt(end)) == 34)
        instr = !instr;
      else if (!instr && cc in guess_seps)
        cnt[cc] = (cnt[cc] || 0) + 1;
    }
    cc = [];
    for (end in cnt)
      if (Object.prototype.hasOwnProperty.call(cnt, end)) {
        cc.push([cnt[end], end]);
      }
    if (!cc.length) {
      cnt = guess_sep_weights;
      for (end in cnt)
        if (Object.prototype.hasOwnProperty.call(cnt, end)) {
          cc.push([cnt[end], end]);
        }
    }
    cc.sort(function(a2, b2) {
      return a2[0] - b2[0] || guess_sep_weights[a2[1]] - guess_sep_weights[b2[1]];
    });
    return guess_seps[cc.pop()[1]] || 44;
  }
  function dsv_to_sheet_str(str, opts) {
    var o2 = opts || {};
    var sep = "";
    if (DENSE != null && o2.dense == null)
      o2.dense = DENSE;
    var ws = o2.dense ? [] : {};
    var range = { s: { c: 0, r: 0 }, e: { c: 0, r: 0 } };
    if (str.slice(0, 4) == "sep=") {
      if (str.charCodeAt(5) == 13 && str.charCodeAt(6) == 10) {
        sep = str.charAt(4);
        str = str.slice(7);
      } else if (str.charCodeAt(5) == 13 || str.charCodeAt(5) == 10) {
        sep = str.charAt(4);
        str = str.slice(6);
      } else
        sep = guess_sep(str.slice(0, 1024));
    } else if (o2 && o2.FS)
      sep = o2.FS;
    else
      sep = guess_sep(str.slice(0, 1024));
    var R2 = 0, C2 = 0, v2 = 0;
    var start = 0, end = 0, sepcc = sep.charCodeAt(0), instr = false, cc = 0, startcc = str.charCodeAt(0);
    str = str.replace(/\r\n/mg, "\n");
    var _re = o2.dateNF != null ? dateNF_regex(o2.dateNF) : null;
    function finish_cell() {
      var s2 = str.slice(start, end);
      var cell = {};
      if (s2.charAt(0) == '"' && s2.charAt(s2.length - 1) == '"')
        s2 = s2.slice(1, -1).replace(/""/g, '"');
      if (s2.length === 0)
        cell.t = "z";
      else if (o2.raw) {
        cell.t = "s";
        cell.v = s2;
      } else if (s2.trim().length === 0) {
        cell.t = "s";
        cell.v = s2;
      } else if (s2.charCodeAt(0) == 61) {
        if (s2.charCodeAt(1) == 34 && s2.charCodeAt(s2.length - 1) == 34) {
          cell.t = "s";
          cell.v = s2.slice(2, -1).replace(/""/g, '"');
        } else if (fuzzyfmla(s2)) {
          cell.t = "n";
          cell.f = s2.slice(1);
        } else {
          cell.t = "s";
          cell.v = s2;
        }
      } else if (s2 == "TRUE") {
        cell.t = "b";
        cell.v = true;
      } else if (s2 == "FALSE") {
        cell.t = "b";
        cell.v = false;
      } else if (!isNaN(v2 = fuzzynum(s2))) {
        cell.t = "n";
        if (o2.cellText !== false)
          cell.w = s2;
        cell.v = v2;
      } else if (!isNaN(fuzzydate(s2).getDate()) || _re && s2.match(_re)) {
        cell.z = o2.dateNF || table_fmt[14];
        var k2 = 0;
        if (_re && s2.match(_re)) {
          s2 = dateNF_fix(s2, o2.dateNF, s2.match(_re) || []);
          k2 = 1;
        }
        if (o2.cellDates) {
          cell.t = "d";
          cell.v = parseDate(s2, k2);
        } else {
          cell.t = "n";
          cell.v = datenum(parseDate(s2, k2));
        }
        if (o2.cellText !== false)
          cell.w = SSF_format(cell.z, cell.v instanceof Date ? datenum(cell.v) : cell.v);
        if (!o2.cellNF)
          delete cell.z;
      } else {
        cell.t = "s";
        cell.v = s2;
      }
      if (cell.t == "z") {
      } else if (o2.dense) {
        if (!ws[R2])
          ws[R2] = [];
        ws[R2][C2] = cell;
      } else
        ws[encode_cell({ c: C2, r: R2 })] = cell;
      start = end + 1;
      startcc = str.charCodeAt(start);
      if (range.e.c < C2)
        range.e.c = C2;
      if (range.e.r < R2)
        range.e.r = R2;
      if (cc == sepcc)
        ++C2;
      else {
        C2 = 0;
        ++R2;
        if (o2.sheetRows && o2.sheetRows <= R2)
          return true;
      }
    }
    outer:
      for (; end < str.length; ++end)
        switch (cc = str.charCodeAt(end)) {
          case 34:
            if (startcc === 34)
              instr = !instr;
            break;
          case sepcc:
          case 10:
          case 13:
            if (!instr && finish_cell())
              break outer;
            break;
          default:
            break;
        }
    if (end - start > 0)
      finish_cell();
    ws["!ref"] = encode_range(range);
    return ws;
  }
  function prn_to_sheet_str(str, opts) {
    if (!(opts && opts.PRN))
      return dsv_to_sheet_str(str, opts);
    if (opts.FS)
      return dsv_to_sheet_str(str, opts);
    if (str.slice(0, 4) == "sep=")
      return dsv_to_sheet_str(str, opts);
    if (str.indexOf("	") >= 0 || str.indexOf(",") >= 0 || str.indexOf(";") >= 0)
      return dsv_to_sheet_str(str, opts);
    return aoa_to_sheet(prn_to_aoa_str(str, opts), opts);
  }
  function prn_to_sheet(d2, opts) {
    var str = "", bytes = opts.type == "string" ? [0, 0, 0, 0] : firstbyte(d2, opts);
    switch (opts.type) {
      case "base64":
        str = Base64_decode(d2);
        break;
      case "binary":
        str = d2;
        break;
      case "buffer":
        if (opts.codepage == 65001)
          str = d2.toString("utf8");
        else if (opts.codepage && typeof $cptable !== "undefined")
          str = $cptable.utils.decode(opts.codepage, d2);
        else
          str = has_buf && Buffer.isBuffer(d2) ? d2.toString("binary") : a2s(d2);
        break;
      case "array":
        str = cc2str(d2);
        break;
      case "string":
        str = d2;
        break;
      default:
        throw new Error("Unrecognized type " + opts.type);
    }
    if (bytes[0] == 239 && bytes[1] == 187 && bytes[2] == 191)
      str = utf8read(str.slice(3));
    else if (opts.type != "string" && opts.type != "buffer" && opts.codepage == 65001)
      str = utf8read(str);
    else if (opts.type == "binary" && typeof $cptable !== "undefined" && opts.codepage)
      str = $cptable.utils.decode(opts.codepage, $cptable.utils.encode(28591, str));
    if (str.slice(0, 19) == "socialcalc:version:")
      return ETH.to_sheet(opts.type == "string" ? str : utf8read(str), opts);
    return prn_to_sheet_str(str, opts);
  }
  function prn_to_workbook(d2, opts) {
    return sheet_to_workbook(prn_to_sheet(d2, opts), opts);
  }
  function sheet_to_prn(ws) {
    var o2 = [];
    var r = safe_decode_range(ws["!ref"]), cell;
    var dense = Array.isArray(ws);
    for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
      var oo = [];
      for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
        var coord = encode_cell({ r: R2, c: C2 });
        cell = dense ? (ws[R2] || [])[C2] : ws[coord];
        if (!cell || cell.v == null) {
          oo.push("          ");
          continue;
        }
        var w2 = (cell.w || (format_cell(cell), cell.w) || "").slice(0, 10);
        while (w2.length < 10)
          w2 += " ";
        oo.push(w2 + (C2 === 0 ? " " : ""));
      }
      o2.push(oo.join(""));
    }
    return o2.join("\n");
  }
  return {
    to_workbook: prn_to_workbook,
    to_sheet: prn_to_sheet,
    from_sheet: sheet_to_prn
  };
}();
function read_wb_ID(d2, opts) {
  var o2 = opts || {}, OLD_WTF = !!o2.WTF;
  o2.WTF = true;
  try {
    var out = SYLK.to_workbook(d2, o2);
    o2.WTF = OLD_WTF;
    return out;
  } catch (e) {
    o2.WTF = OLD_WTF;
    if (!e.message.match(/SYLK bad record ID/) && OLD_WTF)
      throw e;
    return PRN.to_workbook(d2, opts);
  }
}
var WK_ = /* @__PURE__ */ function() {
  function lotushopper(data, cb, opts) {
    if (!data)
      return;
    prep_blob(data, data.l || 0);
    var Enum = opts.Enum || WK1Enum;
    while (data.l < data.length) {
      var RT = data.read_shift(2);
      var R2 = Enum[RT] || Enum[65535];
      var length = data.read_shift(2);
      var tgt = data.l + length;
      var d2 = R2.f && R2.f(data, length, opts);
      data.l = tgt;
      if (cb(d2, R2, RT))
        return;
    }
  }
  function lotus_to_workbook(d2, opts) {
    switch (opts.type) {
      case "base64":
        return lotus_to_workbook_buf(s2a(Base64_decode(d2)), opts);
      case "binary":
        return lotus_to_workbook_buf(s2a(d2), opts);
      case "buffer":
      case "array":
        return lotus_to_workbook_buf(d2, opts);
    }
    throw "Unsupported type " + opts.type;
  }
  function lotus_to_workbook_buf(d2, opts) {
    if (!d2)
      return d2;
    var o2 = opts || {};
    if (DENSE != null && o2.dense == null)
      o2.dense = DENSE;
    var s2 = o2.dense ? [] : {}, n2 = "Sheet1", next_n = "", sidx = 0;
    var sheets = {}, snames = [], realnames = [];
    var refguess = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
    var sheetRows = o2.sheetRows || 0;
    if (d2[2] == 0) {
      if (d2[3] == 8 || d2[3] == 9) {
        if (d2.length >= 16 && d2[14] == 5 && d2[15] === 108)
          throw new Error("Unsupported Works 3 for Mac file");
      }
    }
    if (d2[2] == 2) {
      o2.Enum = WK1Enum;
      lotushopper(d2, function(val, R2, RT) {
        switch (RT) {
          case 0:
            o2.vers = val;
            if (val >= 4096)
              o2.qpro = true;
            break;
          case 6:
            refguess = val;
            break;
          case 204:
            if (val)
              next_n = val;
            break;
          case 222:
            next_n = val;
            break;
          case 15:
          case 51:
            if (!o2.qpro)
              val[1].v = val[1].v.slice(1);
          case 13:
          case 14:
          case 16:
            if (RT == 14 && (val[2] & 112) == 112 && (val[2] & 15) > 1 && (val[2] & 15) < 15) {
              val[1].z = o2.dateNF || table_fmt[14];
              if (o2.cellDates) {
                val[1].t = "d";
                val[1].v = numdate(val[1].v);
              }
            }
            if (o2.qpro) {
              if (val[3] > sidx) {
                s2["!ref"] = encode_range(refguess);
                sheets[n2] = s2;
                snames.push(n2);
                s2 = o2.dense ? [] : {};
                refguess = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
                sidx = val[3];
                n2 = next_n || "Sheet" + (sidx + 1);
                next_n = "";
              }
            }
            var tmpcell = o2.dense ? (s2[val[0].r] || [])[val[0].c] : s2[encode_cell(val[0])];
            if (tmpcell) {
              tmpcell.t = val[1].t;
              tmpcell.v = val[1].v;
              if (val[1].z != null)
                tmpcell.z = val[1].z;
              if (val[1].f != null)
                tmpcell.f = val[1].f;
              break;
            }
            if (o2.dense) {
              if (!s2[val[0].r])
                s2[val[0].r] = [];
              s2[val[0].r][val[0].c] = val[1];
            } else
              s2[encode_cell(val[0])] = val[1];
            break;
          default:
        }
      }, o2);
    } else if (d2[2] == 26 || d2[2] == 14) {
      o2.Enum = WK3Enum;
      if (d2[2] == 14) {
        o2.qpro = true;
        d2.l = 0;
      }
      lotushopper(d2, function(val, R2, RT) {
        switch (RT) {
          case 204:
            n2 = val;
            break;
          case 22:
            val[1].v = val[1].v.slice(1);
          case 23:
          case 24:
          case 25:
          case 37:
          case 39:
          case 40:
            if (val[3] > sidx) {
              s2["!ref"] = encode_range(refguess);
              sheets[n2] = s2;
              snames.push(n2);
              s2 = o2.dense ? [] : {};
              refguess = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
              sidx = val[3];
              n2 = "Sheet" + (sidx + 1);
            }
            if (sheetRows > 0 && val[0].r >= sheetRows)
              break;
            if (o2.dense) {
              if (!s2[val[0].r])
                s2[val[0].r] = [];
              s2[val[0].r][val[0].c] = val[1];
            } else
              s2[encode_cell(val[0])] = val[1];
            if (refguess.e.c < val[0].c)
              refguess.e.c = val[0].c;
            if (refguess.e.r < val[0].r)
              refguess.e.r = val[0].r;
            break;
          case 27:
            if (val[14e3])
              realnames[val[14e3][0]] = val[14e3][1];
            break;
          case 1537:
            realnames[val[0]] = val[1];
            if (val[0] == sidx)
              n2 = val[1];
            break;
          default:
            break;
        }
      }, o2);
    } else
      throw new Error("Unrecognized LOTUS BOF " + d2[2]);
    s2["!ref"] = encode_range(refguess);
    sheets[next_n || n2] = s2;
    snames.push(next_n || n2);
    if (!realnames.length)
      return { SheetNames: snames, Sheets: sheets };
    var osheets = {}, rnames = [];
    for (var i2 = 0; i2 < realnames.length; ++i2)
      if (sheets[snames[i2]]) {
        rnames.push(realnames[i2] || snames[i2]);
        osheets[realnames[i2]] = sheets[realnames[i2]] || sheets[snames[i2]];
      } else {
        rnames.push(realnames[i2]);
        osheets[realnames[i2]] = { "!ref": "A1" };
      }
    return { SheetNames: rnames, Sheets: osheets };
  }
  function sheet_to_wk1(ws, opts) {
    var o2 = opts || {};
    if (+o2.codepage >= 0)
      set_cp(+o2.codepage);
    if (o2.type == "string")
      throw new Error("Cannot write WK1 to JS string");
    var ba = buf_array();
    var range = safe_decode_range(ws["!ref"]);
    var dense = Array.isArray(ws);
    var cols = [];
    write_biff_rec(ba, 0, write_BOF_WK1(1030));
    write_biff_rec(ba, 6, write_RANGE(range));
    var max_R = Math.min(range.e.r, 8191);
    for (var R2 = range.s.r; R2 <= max_R; ++R2) {
      var rr = encode_row(R2);
      for (var C2 = range.s.c; C2 <= range.e.c; ++C2) {
        if (R2 === range.s.r)
          cols[C2] = encode_col(C2);
        var ref = cols[C2] + rr;
        var cell = dense ? (ws[R2] || [])[C2] : ws[ref];
        if (!cell || cell.t == "z")
          continue;
        if (cell.t == "n") {
          if ((cell.v | 0) == cell.v && cell.v >= -32768 && cell.v <= 32767)
            write_biff_rec(ba, 13, write_INTEGER(R2, C2, cell.v));
          else
            write_biff_rec(ba, 14, write_NUMBER(R2, C2, cell.v));
        } else {
          var str = format_cell(cell);
          write_biff_rec(ba, 15, write_LABEL(R2, C2, str.slice(0, 239)));
        }
      }
    }
    write_biff_rec(ba, 1);
    return ba.end();
  }
  function book_to_wk3(wb, opts) {
    var o2 = opts || {};
    if (+o2.codepage >= 0)
      set_cp(+o2.codepage);
    if (o2.type == "string")
      throw new Error("Cannot write WK3 to JS string");
    var ba = buf_array();
    write_biff_rec(ba, 0, write_BOF_WK3(wb));
    for (var i2 = 0, cnt = 0; i2 < wb.SheetNames.length; ++i2)
      if ((wb.Sheets[wb.SheetNames[i2]] || {})["!ref"])
        write_biff_rec(ba, 27, write_XFORMAT_SHEETNAME(wb.SheetNames[i2], cnt++));
    var wsidx = 0;
    for (i2 = 0; i2 < wb.SheetNames.length; ++i2) {
      var ws = wb.Sheets[wb.SheetNames[i2]];
      if (!ws || !ws["!ref"])
        continue;
      var range = safe_decode_range(ws["!ref"]);
      var dense = Array.isArray(ws);
      var cols = [];
      var max_R = Math.min(range.e.r, 8191);
      for (var R2 = range.s.r; R2 <= max_R; ++R2) {
        var rr = encode_row(R2);
        for (var C2 = range.s.c; C2 <= range.e.c; ++C2) {
          if (R2 === range.s.r)
            cols[C2] = encode_col(C2);
          var ref = cols[C2] + rr;
          var cell = dense ? (ws[R2] || [])[C2] : ws[ref];
          if (!cell || cell.t == "z")
            continue;
          if (cell.t == "n") {
            write_biff_rec(ba, 23, write_NUMBER_17(R2, C2, wsidx, cell.v));
          } else {
            var str = format_cell(cell);
            write_biff_rec(ba, 22, write_LABEL_16(R2, C2, wsidx, str.slice(0, 239)));
          }
        }
      }
      ++wsidx;
    }
    write_biff_rec(ba, 1);
    return ba.end();
  }
  function write_BOF_WK1(v2) {
    var out = new_buf(2);
    out.write_shift(2, v2);
    return out;
  }
  function write_BOF_WK3(wb) {
    var out = new_buf(26);
    out.write_shift(2, 4096);
    out.write_shift(2, 4);
    out.write_shift(4, 0);
    var rows = 0, cols = 0, wscnt = 0;
    for (var i2 = 0; i2 < wb.SheetNames.length; ++i2) {
      var name = wb.SheetNames[i2];
      var ws = wb.Sheets[name];
      if (!ws || !ws["!ref"])
        continue;
      ++wscnt;
      var range = decode_range(ws["!ref"]);
      if (rows < range.e.r)
        rows = range.e.r;
      if (cols < range.e.c)
        cols = range.e.c;
    }
    if (rows > 8191)
      rows = 8191;
    out.write_shift(2, rows);
    out.write_shift(1, wscnt);
    out.write_shift(1, cols);
    out.write_shift(2, 0);
    out.write_shift(2, 0);
    out.write_shift(1, 1);
    out.write_shift(1, 2);
    out.write_shift(4, 0);
    out.write_shift(4, 0);
    return out;
  }
  function parse_RANGE(blob, length, opts) {
    var o2 = { s: { c: 0, r: 0 }, e: { c: 0, r: 0 } };
    if (length == 8 && opts.qpro) {
      o2.s.c = blob.read_shift(1);
      blob.l++;
      o2.s.r = blob.read_shift(2);
      o2.e.c = blob.read_shift(1);
      blob.l++;
      o2.e.r = blob.read_shift(2);
      return o2;
    }
    o2.s.c = blob.read_shift(2);
    o2.s.r = blob.read_shift(2);
    if (length == 12 && opts.qpro)
      blob.l += 2;
    o2.e.c = blob.read_shift(2);
    o2.e.r = blob.read_shift(2);
    if (length == 12 && opts.qpro)
      blob.l += 2;
    if (o2.s.c == 65535)
      o2.s.c = o2.e.c = o2.s.r = o2.e.r = 0;
    return o2;
  }
  function write_RANGE(range) {
    var out = new_buf(8);
    out.write_shift(2, range.s.c);
    out.write_shift(2, range.s.r);
    out.write_shift(2, range.e.c);
    out.write_shift(2, range.e.r);
    return out;
  }
  function parse_cell(blob, length, opts) {
    var o2 = [{ c: 0, r: 0 }, { t: "n", v: 0 }, 0, 0];
    if (opts.qpro && opts.vers != 20768) {
      o2[0].c = blob.read_shift(1);
      o2[3] = blob.read_shift(1);
      o2[0].r = blob.read_shift(2);
      blob.l += 2;
    } else {
      o2[2] = blob.read_shift(1);
      o2[0].c = blob.read_shift(2);
      o2[0].r = blob.read_shift(2);
    }
    return o2;
  }
  function parse_LABEL(blob, length, opts) {
    var tgt = blob.l + length;
    var o2 = parse_cell(blob, length, opts);
    o2[1].t = "s";
    if (opts.vers == 20768) {
      blob.l++;
      var len = blob.read_shift(1);
      o2[1].v = blob.read_shift(len, "utf8");
      return o2;
    }
    if (opts.qpro)
      blob.l++;
    o2[1].v = blob.read_shift(tgt - blob.l, "cstr");
    return o2;
  }
  function write_LABEL(R2, C2, s2) {
    var o2 = new_buf(7 + s2.length);
    o2.write_shift(1, 255);
    o2.write_shift(2, C2);
    o2.write_shift(2, R2);
    o2.write_shift(1, 39);
    for (var i2 = 0; i2 < o2.length; ++i2) {
      var cc = s2.charCodeAt(i2);
      o2.write_shift(1, cc >= 128 ? 95 : cc);
    }
    o2.write_shift(1, 0);
    return o2;
  }
  function parse_INTEGER(blob, length, opts) {
    var o2 = parse_cell(blob, length, opts);
    o2[1].v = blob.read_shift(2, "i");
    return o2;
  }
  function write_INTEGER(R2, C2, v2) {
    var o2 = new_buf(7);
    o2.write_shift(1, 255);
    o2.write_shift(2, C2);
    o2.write_shift(2, R2);
    o2.write_shift(2, v2, "i");
    return o2;
  }
  function parse_NUMBER(blob, length, opts) {
    var o2 = parse_cell(blob, length, opts);
    o2[1].v = blob.read_shift(8, "f");
    return o2;
  }
  function write_NUMBER(R2, C2, v2) {
    var o2 = new_buf(13);
    o2.write_shift(1, 255);
    o2.write_shift(2, C2);
    o2.write_shift(2, R2);
    o2.write_shift(8, v2, "f");
    return o2;
  }
  function parse_FORMULA(blob, length, opts) {
    var tgt = blob.l + length;
    var o2 = parse_cell(blob, length, opts);
    o2[1].v = blob.read_shift(8, "f");
    if (opts.qpro)
      blob.l = tgt;
    else {
      var flen = blob.read_shift(2);
      wk1_fmla_to_csf(blob.slice(blob.l, blob.l + flen), o2);
      blob.l += flen;
    }
    return o2;
  }
  function wk1_parse_rc(B2, V2, col) {
    var rel = V2 & 32768;
    V2 &= ~32768;
    V2 = (rel ? B2 : 0) + (V2 >= 8192 ? V2 - 16384 : V2);
    return (rel ? "" : "$") + (col ? encode_col(V2) : encode_row(V2));
  }
  var FuncTab = {
    51: ["FALSE", 0],
    52: ["TRUE", 0],
    70: ["LEN", 1],
    80: ["SUM", 69],
    81: ["AVERAGEA", 69],
    82: ["COUNTA", 69],
    83: ["MINA", 69],
    84: ["MAXA", 69],
    111: ["T", 1]
  };
  var BinOpTab = [
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    "",
    // eslint-disable-line no-mixed-spaces-and-tabs
    "",
    "+",
    "-",
    "*",
    "/",
    "^",
    "=",
    "<>",
    // eslint-disable-line no-mixed-spaces-and-tabs
    "<=",
    ">=",
    "<",
    ">",
    "",
    "",
    "",
    "",
    // eslint-disable-line no-mixed-spaces-and-tabs
    "&",
    "",
    "",
    "",
    "",
    "",
    "",
    ""
    // eslint-disable-line no-mixed-spaces-and-tabs
  ];
  function wk1_fmla_to_csf(blob, o2) {
    prep_blob(blob, 0);
    var out = [], argc = 0, R2 = "", C2 = "", argL = "", argR = "";
    while (blob.l < blob.length) {
      var cc = blob[blob.l++];
      switch (cc) {
        case 0:
          out.push(blob.read_shift(8, "f"));
          break;
        case 1:
          {
            C2 = wk1_parse_rc(o2[0].c, blob.read_shift(2), true);
            R2 = wk1_parse_rc(o2[0].r, blob.read_shift(2), false);
            out.push(C2 + R2);
          }
          break;
        case 2:
          {
            var c2 = wk1_parse_rc(o2[0].c, blob.read_shift(2), true);
            var r = wk1_parse_rc(o2[0].r, blob.read_shift(2), false);
            C2 = wk1_parse_rc(o2[0].c, blob.read_shift(2), true);
            R2 = wk1_parse_rc(o2[0].r, blob.read_shift(2), false);
            out.push(c2 + r + ":" + C2 + R2);
          }
          break;
        case 3:
          if (blob.l < blob.length) {
            console.error("WK1 premature formula end");
            return;
          }
          break;
        case 4:
          out.push("(" + out.pop() + ")");
          break;
        case 5:
          out.push(blob.read_shift(2));
          break;
        case 6:
          {
            var Z2 = "";
            while (cc = blob[blob.l++])
              Z2 += String.fromCharCode(cc);
            out.push('"' + Z2.replace(/"/g, '""') + '"');
          }
          break;
        case 8:
          out.push("-" + out.pop());
          break;
        case 23:
          out.push("+" + out.pop());
          break;
        case 22:
          out.push("NOT(" + out.pop() + ")");
          break;
        case 20:
        case 21:
          {
            argR = out.pop();
            argL = out.pop();
            out.push(["AND", "OR"][cc - 20] + "(" + argL + "," + argR + ")");
          }
          break;
        default:
          if (cc < 32 && BinOpTab[cc]) {
            argR = out.pop();
            argL = out.pop();
            out.push(argL + BinOpTab[cc] + argR);
          } else if (FuncTab[cc]) {
            argc = FuncTab[cc][1];
            if (argc == 69)
              argc = blob[blob.l++];
            if (argc > out.length) {
              console.error("WK1 bad formula parse 0x" + cc.toString(16) + ":|" + out.join("|") + "|");
              return;
            }
            var args = out.slice(-argc);
            out.length -= argc;
            out.push(FuncTab[cc][0] + "(" + args.join(",") + ")");
          } else if (cc <= 7)
            return console.error("WK1 invalid opcode " + cc.toString(16));
          else if (cc <= 24)
            return console.error("WK1 unsupported op " + cc.toString(16));
          else if (cc <= 30)
            return console.error("WK1 invalid opcode " + cc.toString(16));
          else if (cc <= 115)
            return console.error("WK1 unsupported function opcode " + cc.toString(16));
          else
            return console.error("WK1 unrecognized opcode " + cc.toString(16));
      }
    }
    if (out.length == 1)
      o2[1].f = "" + out[0];
    else
      console.error("WK1 bad formula parse |" + out.join("|") + "|");
  }
  function parse_cell_3(blob) {
    var o2 = [{ c: 0, r: 0 }, { t: "n", v: 0 }, 0];
    o2[0].r = blob.read_shift(2);
    o2[3] = blob[blob.l++];
    o2[0].c = blob[blob.l++];
    return o2;
  }
  function parse_LABEL_16(blob, length) {
    var o2 = parse_cell_3(blob, length);
    o2[1].t = "s";
    o2[1].v = blob.read_shift(length - 4, "cstr");
    return o2;
  }
  function write_LABEL_16(R2, C2, wsidx, s2) {
    var o2 = new_buf(6 + s2.length);
    o2.write_shift(2, R2);
    o2.write_shift(1, wsidx);
    o2.write_shift(1, C2);
    o2.write_shift(1, 39);
    for (var i2 = 0; i2 < s2.length; ++i2) {
      var cc = s2.charCodeAt(i2);
      o2.write_shift(1, cc >= 128 ? 95 : cc);
    }
    o2.write_shift(1, 0);
    return o2;
  }
  function parse_NUMBER_18(blob, length) {
    var o2 = parse_cell_3(blob, length);
    o2[1].v = blob.read_shift(2);
    var v2 = o2[1].v >> 1;
    if (o2[1].v & 1) {
      switch (v2 & 7) {
        case 0:
          v2 = (v2 >> 3) * 5e3;
          break;
        case 1:
          v2 = (v2 >> 3) * 500;
          break;
        case 2:
          v2 = (v2 >> 3) / 20;
          break;
        case 3:
          v2 = (v2 >> 3) / 200;
          break;
        case 4:
          v2 = (v2 >> 3) / 2e3;
          break;
        case 5:
          v2 = (v2 >> 3) / 2e4;
          break;
        case 6:
          v2 = (v2 >> 3) / 16;
          break;
        case 7:
          v2 = (v2 >> 3) / 64;
          break;
      }
    }
    o2[1].v = v2;
    return o2;
  }
  function parse_NUMBER_17(blob, length) {
    var o2 = parse_cell_3(blob, length);
    var v1 = blob.read_shift(4);
    var v2 = blob.read_shift(4);
    var e = blob.read_shift(2);
    if (e == 65535) {
      if (v1 === 0 && v2 === 3221225472) {
        o2[1].t = "e";
        o2[1].v = 15;
      } else if (v1 === 0 && v2 === 3489660928) {
        o2[1].t = "e";
        o2[1].v = 42;
      } else
        o2[1].v = 0;
      return o2;
    }
    var s2 = e & 32768;
    e = (e & 32767) - 16446;
    o2[1].v = (1 - s2 * 2) * (v2 * Math.pow(2, e + 32) + v1 * Math.pow(2, e));
    return o2;
  }
  function write_NUMBER_17(R2, C2, wsidx, v2) {
    var o2 = new_buf(14);
    o2.write_shift(2, R2);
    o2.write_shift(1, wsidx);
    o2.write_shift(1, C2);
    if (v2 == 0) {
      o2.write_shift(4, 0);
      o2.write_shift(4, 0);
      o2.write_shift(2, 65535);
      return o2;
    }
    var s2 = 0, e = 0, v1 = 0, v22 = 0;
    if (v2 < 0) {
      s2 = 1;
      v2 = -v2;
    }
    e = Math.log2(v2) | 0;
    v2 /= Math.pow(2, e - 31);
    v22 = v2 >>> 0;
    if ((v22 & 2147483648) == 0) {
      v2 /= 2;
      ++e;
      v22 = v2 >>> 0;
    }
    v2 -= v22;
    v22 |= 2147483648;
    v22 >>>= 0;
    v2 *= Math.pow(2, 32);
    v1 = v2 >>> 0;
    o2.write_shift(4, v1);
    o2.write_shift(4, v22);
    e += 16383 + (s2 ? 32768 : 0);
    o2.write_shift(2, e);
    return o2;
  }
  function parse_FORMULA_19(blob, length) {
    var o2 = parse_NUMBER_17(blob, 14);
    blob.l += length - 14;
    return o2;
  }
  function parse_NUMBER_25(blob, length) {
    var o2 = parse_cell_3(blob, length);
    var v1 = blob.read_shift(4);
    o2[1].v = v1 >> 6;
    return o2;
  }
  function parse_NUMBER_27(blob, length) {
    var o2 = parse_cell_3(blob, length);
    var v1 = blob.read_shift(8, "f");
    o2[1].v = v1;
    return o2;
  }
  function parse_FORMULA_28(blob, length) {
    var o2 = parse_NUMBER_27(blob, 14);
    blob.l += length - 10;
    return o2;
  }
  function parse_SHEETNAMECS(blob, length) {
    return blob[blob.l + length - 1] == 0 ? blob.read_shift(length, "cstr") : "";
  }
  function parse_SHEETNAMELP(blob, length) {
    var len = blob[blob.l++];
    if (len > length - 1)
      len = length - 1;
    var o2 = "";
    while (o2.length < len)
      o2 += String.fromCharCode(blob[blob.l++]);
    return o2;
  }
  function parse_SHEETINFOQP(blob, length, opts) {
    if (!opts.qpro || length < 21)
      return;
    var id = blob.read_shift(1);
    blob.l += 17;
    blob.l += 1;
    blob.l += 2;
    var nm = blob.read_shift(length - 21, "cstr");
    return [id, nm];
  }
  function parse_XFORMAT(blob, length) {
    var o2 = {}, tgt = blob.l + length;
    while (blob.l < tgt) {
      var dt2 = blob.read_shift(2);
      if (dt2 == 14e3) {
        o2[dt2] = [0, ""];
        o2[dt2][0] = blob.read_shift(2);
        while (blob[blob.l]) {
          o2[dt2][1] += String.fromCharCode(blob[blob.l]);
          blob.l++;
        }
        blob.l++;
      }
    }
    return o2;
  }
  function write_XFORMAT_SHEETNAME(name, wsidx) {
    var out = new_buf(5 + name.length);
    out.write_shift(2, 14e3);
    out.write_shift(2, wsidx);
    for (var i2 = 0; i2 < name.length; ++i2) {
      var cc = name.charCodeAt(i2);
      out[out.l++] = cc > 127 ? 95 : cc;
    }
    out[out.l++] = 0;
    return out;
  }
  var WK1Enum = {
    /*::[*/
    0: { n: "BOF", f: parseuint16 },
    /*::[*/
    1: { n: "EOF" },
    /*::[*/
    2: { n: "CALCMODE" },
    /*::[*/
    3: { n: "CALCORDER" },
    /*::[*/
    4: { n: "SPLIT" },
    /*::[*/
    5: { n: "SYNC" },
    /*::[*/
    6: { n: "RANGE", f: parse_RANGE },
    /*::[*/
    7: { n: "WINDOW1" },
    /*::[*/
    8: { n: "COLW1" },
    /*::[*/
    9: { n: "WINTWO" },
    /*::[*/
    10: { n: "COLW2" },
    /*::[*/
    11: { n: "NAME" },
    /*::[*/
    12: { n: "BLANK" },
    /*::[*/
    13: { n: "INTEGER", f: parse_INTEGER },
    /*::[*/
    14: { n: "NUMBER", f: parse_NUMBER },
    /*::[*/
    15: { n: "LABEL", f: parse_LABEL },
    /*::[*/
    16: { n: "FORMULA", f: parse_FORMULA },
    /*::[*/
    24: { n: "TABLE" },
    /*::[*/
    25: { n: "ORANGE" },
    /*::[*/
    26: { n: "PRANGE" },
    /*::[*/
    27: { n: "SRANGE" },
    /*::[*/
    28: { n: "FRANGE" },
    /*::[*/
    29: { n: "KRANGE1" },
    /*::[*/
    32: { n: "HRANGE" },
    /*::[*/
    35: { n: "KRANGE2" },
    /*::[*/
    36: { n: "PROTEC" },
    /*::[*/
    37: { n: "FOOTER" },
    /*::[*/
    38: { n: "HEADER" },
    /*::[*/
    39: { n: "SETUP" },
    /*::[*/
    40: { n: "MARGINS" },
    /*::[*/
    41: { n: "LABELFMT" },
    /*::[*/
    42: { n: "TITLES" },
    /*::[*/
    43: { n: "SHEETJS" },
    /*::[*/
    45: { n: "GRAPH" },
    /*::[*/
    46: { n: "NGRAPH" },
    /*::[*/
    47: { n: "CALCCOUNT" },
    /*::[*/
    48: { n: "UNFORMATTED" },
    /*::[*/
    49: { n: "CURSORW12" },
    /*::[*/
    50: { n: "WINDOW" },
    /*::[*/
    51: { n: "STRING", f: parse_LABEL },
    /*::[*/
    55: { n: "PASSWORD" },
    /*::[*/
    56: { n: "LOCKED" },
    /*::[*/
    60: { n: "QUERY" },
    /*::[*/
    61: { n: "QUERYNAME" },
    /*::[*/
    62: { n: "PRINT" },
    /*::[*/
    63: { n: "PRINTNAME" },
    /*::[*/
    64: { n: "GRAPH2" },
    /*::[*/
    65: { n: "GRAPHNAME" },
    /*::[*/
    66: { n: "ZOOM" },
    /*::[*/
    67: { n: "SYMSPLIT" },
    /*::[*/
    68: { n: "NSROWS" },
    /*::[*/
    69: { n: "NSCOLS" },
    /*::[*/
    70: { n: "RULER" },
    /*::[*/
    71: { n: "NNAME" },
    /*::[*/
    72: { n: "ACOMM" },
    /*::[*/
    73: { n: "AMACRO" },
    /*::[*/
    74: { n: "PARSE" },
    /*::[*/
    102: { n: "PRANGES??" },
    /*::[*/
    103: { n: "RRANGES??" },
    /*::[*/
    104: { n: "FNAME??" },
    /*::[*/
    105: { n: "MRANGES??" },
    /*::[*/
    204: { n: "SHEETNAMECS", f: parse_SHEETNAMECS },
    /*::[*/
    222: { n: "SHEETNAMELP", f: parse_SHEETNAMELP },
    /*::[*/
    65535: { n: "" }
  };
  var WK3Enum = {
    /*::[*/
    0: { n: "BOF" },
    /*::[*/
    1: { n: "EOF" },
    /*::[*/
    2: { n: "PASSWORD" },
    /*::[*/
    3: { n: "CALCSET" },
    /*::[*/
    4: { n: "WINDOWSET" },
    /*::[*/
    5: { n: "SHEETCELLPTR" },
    /*::[*/
    6: { n: "SHEETLAYOUT" },
    /*::[*/
    7: { n: "COLUMNWIDTH" },
    /*::[*/
    8: { n: "HIDDENCOLUMN" },
    /*::[*/
    9: { n: "USERRANGE" },
    /*::[*/
    10: { n: "SYSTEMRANGE" },
    /*::[*/
    11: { n: "ZEROFORCE" },
    /*::[*/
    12: { n: "SORTKEYDIR" },
    /*::[*/
    13: { n: "FILESEAL" },
    /*::[*/
    14: { n: "DATAFILLNUMS" },
    /*::[*/
    15: { n: "PRINTMAIN" },
    /*::[*/
    16: { n: "PRINTSTRING" },
    /*::[*/
    17: { n: "GRAPHMAIN" },
    /*::[*/
    18: { n: "GRAPHSTRING" },
    /*::[*/
    19: { n: "??" },
    /*::[*/
    20: { n: "ERRCELL" },
    /*::[*/
    21: { n: "NACELL" },
    /*::[*/
    22: { n: "LABEL16", f: parse_LABEL_16 },
    /*::[*/
    23: { n: "NUMBER17", f: parse_NUMBER_17 },
    /*::[*/
    24: { n: "NUMBER18", f: parse_NUMBER_18 },
    /*::[*/
    25: { n: "FORMULA19", f: parse_FORMULA_19 },
    /*::[*/
    26: { n: "FORMULA1A" },
    /*::[*/
    27: { n: "XFORMAT", f: parse_XFORMAT },
    /*::[*/
    28: { n: "DTLABELMISC" },
    /*::[*/
    29: { n: "DTLABELCELL" },
    /*::[*/
    30: { n: "GRAPHWINDOW" },
    /*::[*/
    31: { n: "CPA" },
    /*::[*/
    32: { n: "LPLAUTO" },
    /*::[*/
    33: { n: "QUERY" },
    /*::[*/
    34: { n: "HIDDENSHEET" },
    /*::[*/
    35: { n: "??" },
    /*::[*/
    37: { n: "NUMBER25", f: parse_NUMBER_25 },
    /*::[*/
    38: { n: "??" },
    /*::[*/
    39: { n: "NUMBER27", f: parse_NUMBER_27 },
    /*::[*/
    40: { n: "FORMULA28", f: parse_FORMULA_28 },
    /*::[*/
    142: { n: "??" },
    /*::[*/
    147: { n: "??" },
    /*::[*/
    150: { n: "??" },
    /*::[*/
    151: { n: "??" },
    /*::[*/
    152: { n: "??" },
    /*::[*/
    153: { n: "??" },
    /*::[*/
    154: { n: "??" },
    /*::[*/
    155: { n: "??" },
    /*::[*/
    156: { n: "??" },
    /*::[*/
    163: { n: "??" },
    /*::[*/
    174: { n: "??" },
    /*::[*/
    175: { n: "??" },
    /*::[*/
    176: { n: "??" },
    /*::[*/
    177: { n: "??" },
    /*::[*/
    184: { n: "??" },
    /*::[*/
    185: { n: "??" },
    /*::[*/
    186: { n: "??" },
    /*::[*/
    187: { n: "??" },
    /*::[*/
    188: { n: "??" },
    /*::[*/
    195: { n: "??" },
    /*::[*/
    201: { n: "??" },
    /*::[*/
    204: { n: "SHEETNAMECS", f: parse_SHEETNAMECS },
    /*::[*/
    205: { n: "??" },
    /*::[*/
    206: { n: "??" },
    /*::[*/
    207: { n: "??" },
    /*::[*/
    208: { n: "??" },
    /*::[*/
    256: { n: "??" },
    /*::[*/
    259: { n: "??" },
    /*::[*/
    260: { n: "??" },
    /*::[*/
    261: { n: "??" },
    /*::[*/
    262: { n: "??" },
    /*::[*/
    263: { n: "??" },
    /*::[*/
    265: { n: "??" },
    /*::[*/
    266: { n: "??" },
    /*::[*/
    267: { n: "??" },
    /*::[*/
    268: { n: "??" },
    /*::[*/
    270: { n: "??" },
    /*::[*/
    271: { n: "??" },
    /*::[*/
    384: { n: "??" },
    /*::[*/
    389: { n: "??" },
    /*::[*/
    390: { n: "??" },
    /*::[*/
    393: { n: "??" },
    /*::[*/
    396: { n: "??" },
    /*::[*/
    512: { n: "??" },
    /*::[*/
    514: { n: "??" },
    /*::[*/
    513: { n: "??" },
    /*::[*/
    516: { n: "??" },
    /*::[*/
    517: { n: "??" },
    /*::[*/
    640: { n: "??" },
    /*::[*/
    641: { n: "??" },
    /*::[*/
    642: { n: "??" },
    /*::[*/
    643: { n: "??" },
    /*::[*/
    644: { n: "??" },
    /*::[*/
    645: { n: "??" },
    /*::[*/
    646: { n: "??" },
    /*::[*/
    647: { n: "??" },
    /*::[*/
    648: { n: "??" },
    /*::[*/
    658: { n: "??" },
    /*::[*/
    659: { n: "??" },
    /*::[*/
    660: { n: "??" },
    /*::[*/
    661: { n: "??" },
    /*::[*/
    662: { n: "??" },
    /*::[*/
    665: { n: "??" },
    /*::[*/
    666: { n: "??" },
    /*::[*/
    768: { n: "??" },
    /*::[*/
    772: { n: "??" },
    /*::[*/
    1537: { n: "SHEETINFOQP", f: parse_SHEETINFOQP },
    /*::[*/
    1600: { n: "??" },
    /*::[*/
    1602: { n: "??" },
    /*::[*/
    1793: { n: "??" },
    /*::[*/
    1794: { n: "??" },
    /*::[*/
    1795: { n: "??" },
    /*::[*/
    1796: { n: "??" },
    /*::[*/
    1920: { n: "??" },
    /*::[*/
    2048: { n: "??" },
    /*::[*/
    2049: { n: "??" },
    /*::[*/
    2052: { n: "??" },
    /*::[*/
    2688: { n: "??" },
    /*::[*/
    10998: { n: "??" },
    /*::[*/
    12849: { n: "??" },
    /*::[*/
    28233: { n: "??" },
    /*::[*/
    28484: { n: "??" },
    /*::[*/
    65535: { n: "" }
  };
  return {
    sheet_to_wk1,
    book_to_wk3,
    to_workbook: lotus_to_workbook
  };
}();
function parse_rpr(rpr) {
  var font = {}, m2 = rpr.match(tagregex), i2 = 0;
  var pass = false;
  if (m2)
    for (; i2 != m2.length; ++i2) {
      var y2 = parsexmltag(m2[i2]);
      switch (y2[0].replace(/\w*:/g, "")) {
        case "<condense":
          break;
        case "<extend":
          break;
        case "<shadow":
          if (!y2.val)
            break;
        case "<shadow>":
        case "<shadow/>":
          font.shadow = 1;
          break;
        case "</shadow>":
          break;
        case "<charset":
          if (y2.val == "1")
            break;
          font.cp = CS2CP[parseInt(y2.val, 10)];
          break;
        case "<outline":
          if (!y2.val)
            break;
        case "<outline>":
        case "<outline/>":
          font.outline = 1;
          break;
        case "</outline>":
          break;
        case "<rFont":
          font.name = y2.val;
          break;
        case "<sz":
          font.sz = y2.val;
          break;
        case "<strike":
          if (!y2.val)
            break;
        case "<strike>":
        case "<strike/>":
          font.strike = 1;
          break;
        case "</strike>":
          break;
        case "<u":
          if (!y2.val)
            break;
          switch (y2.val) {
            case "double":
              font.uval = "double";
              break;
            case "singleAccounting":
              font.uval = "single-accounting";
              break;
            case "doubleAccounting":
              font.uval = "double-accounting";
              break;
          }
        case "<u>":
        case "<u/>":
          font.u = 1;
          break;
        case "</u>":
          break;
        case "<b":
          if (y2.val == "0")
            break;
        case "<b>":
        case "<b/>":
          font.b = 1;
          break;
        case "</b>":
          break;
        case "<i":
          if (y2.val == "0")
            break;
        case "<i>":
        case "<i/>":
          font.i = 1;
          break;
        case "</i>":
          break;
        case "<color":
          if (y2.rgb)
            font.color = y2.rgb.slice(2, 8);
          break;
        case "<color>":
        case "<color/>":
        case "</color>":
          break;
        case "<family":
          font.family = y2.val;
          break;
        case "<family>":
        case "<family/>":
        case "</family>":
          break;
        case "<vertAlign":
          font.valign = y2.val;
          break;
        case "<vertAlign>":
        case "<vertAlign/>":
        case "</vertAlign>":
          break;
        case "<scheme":
          break;
        case "<scheme>":
        case "<scheme/>":
        case "</scheme>":
          break;
        case "<extLst":
        case "<extLst>":
        case "</extLst>":
          break;
        case "<ext":
          pass = true;
          break;
        case "</ext>":
          pass = false;
          break;
        default:
          if (y2[0].charCodeAt(1) !== 47 && !pass)
            throw new Error("Unrecognized rich format " + y2[0]);
      }
    }
  return font;
}
var parse_rs = /* @__PURE__ */ function() {
  var tregex = matchtag("t"), rpregex = matchtag("rPr");
  function parse_r(r) {
    var t2 = r.match(tregex);
    if (!t2)
      return { t: "s", v: "" };
    var o2 = { t: "s", v: unescapexml(t2[1]) };
    var rpr = r.match(rpregex);
    if (rpr)
      o2.s = parse_rpr(rpr[1]);
    return o2;
  }
  var rregex = /<(?:\w+:)?r>/g, rend = /<\/(?:\w+:)?r>/;
  return function parse_rs2(rs) {
    return rs.replace(rregex, "").split(rend).map(parse_r).filter(function(r) {
      return r.v;
    });
  };
}();
var rs_to_html = /* @__PURE__ */ function parse_rs_factory() {
  var nlregex = /(\r\n|\n)/g;
  function parse_rpr2(font, intro, outro) {
    var style = [];
    if (font.u)
      style.push("text-decoration: underline;");
    if (font.uval)
      style.push("text-underline-style:" + font.uval + ";");
    if (font.sz)
      style.push("font-size:" + font.sz + "pt;");
    if (font.outline)
      style.push("text-effect: outline;");
    if (font.shadow)
      style.push("text-shadow: auto;");
    intro.push('<span style="' + style.join("") + '">');
    if (font.b) {
      intro.push("<b>");
      outro.push("</b>");
    }
    if (font.i) {
      intro.push("<i>");
      outro.push("</i>");
    }
    if (font.strike) {
      intro.push("<s>");
      outro.push("</s>");
    }
    var align = font.valign || "";
    if (align == "superscript" || align == "super")
      align = "sup";
    else if (align == "subscript")
      align = "sub";
    if (align != "") {
      intro.push("<" + align + ">");
      outro.push("</" + align + ">");
    }
    outro.push("</span>");
    return font;
  }
  function r_to_html(r) {
    var terms = [[], r.v, []];
    if (!r.v)
      return "";
    if (r.s)
      parse_rpr2(r.s, terms[0], terms[2]);
    return terms[0].join("") + terms[1].replace(nlregex, "<br/>") + terms[2].join("");
  }
  return function parse_rs2(rs) {
    return rs.map(r_to_html).join("");
  };
}();
var sitregex = /<(?:\w+:)?t[^>]*>([^<]*)<\/(?:\w+:)?t>/g;
var sirregex = /<(?:\w+:)?r>/;
var sirphregex = /<(?:\w+:)?rPh.*?>([\s\S]*?)<\/(?:\w+:)?rPh>/g;
function parse_si(x2, opts) {
  var html = opts ? opts.cellHTML : true;
  var z2 = {};
  if (!x2)
    return { t: "" };
  if (x2.match(/^\s*<(?:\w+:)?t[^>]*>/)) {
    z2.t = unescapexml(utf8read(x2.slice(x2.indexOf(">") + 1).split(/<\/(?:\w+:)?t>/)[0] || ""));
    z2.r = utf8read(x2);
    if (html)
      z2.h = escapehtml(z2.t);
  } else if (
    /*y = */
    x2.match(sirregex)
  ) {
    z2.r = utf8read(x2);
    z2.t = unescapexml(utf8read((x2.replace(sirphregex, "").match(sitregex) || []).join("").replace(tagregex, "")));
    if (html)
      z2.h = rs_to_html(parse_rs(z2.r));
  }
  return z2;
}
var sstr0 = /<(?:\w+:)?sst([^>]*)>([\s\S]*)<\/(?:\w+:)?sst>/;
var sstr1 = /<(?:\w+:)?(?:si|sstItem)>/g;
var sstr2 = /<\/(?:\w+:)?(?:si|sstItem)>/;
function parse_sst_xml(data, opts) {
  var s2 = [], ss = "";
  if (!data)
    return s2;
  var sst = data.match(sstr0);
  if (sst) {
    ss = sst[2].replace(sstr1, "").split(sstr2);
    for (var i2 = 0; i2 != ss.length; ++i2) {
      var o2 = parse_si(ss[i2].trim(), opts);
      if (o2 != null)
        s2[s2.length] = o2;
    }
    sst = parsexmltag(sst[1]);
    s2.Count = sst.count;
    s2.Unique = sst.uniqueCount;
  }
  return s2;
}
var straywsregex = /^\s|\s$|[\t\n\r]/;
function write_sst_xml(sst, opts) {
  if (!opts.bookSST)
    return "";
  var o2 = [XML_HEADER];
  o2[o2.length] = writextag("sst", null, {
    xmlns: XMLNS_main[0],
    count: sst.Count,
    uniqueCount: sst.Unique
  });
  for (var i2 = 0; i2 != sst.length; ++i2) {
    if (sst[i2] == null)
      continue;
    var s2 = sst[i2];
    var sitag = "<si>";
    if (s2.r)
      sitag += s2.r;
    else {
      sitag += "<t";
      if (!s2.t)
        s2.t = "";
      if (s2.t.match(straywsregex))
        sitag += ' xml:space="preserve"';
      sitag += ">" + escapexml(s2.t) + "</t>";
    }
    sitag += "</si>";
    o2[o2.length] = sitag;
  }
  if (o2.length > 2) {
    o2[o2.length] = "</sst>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
function parse_BrtBeginSst(data) {
  return [data.read_shift(4), data.read_shift(4)];
}
function parse_sst_bin(data, opts) {
  var s2 = [];
  var pass = false;
  recordhopper(data, function hopper_sst(val, R2, RT) {
    switch (RT) {
      case 159:
        s2.Count = val[0];
        s2.Unique = val[1];
        break;
      case 19:
        s2.push(val);
        break;
      case 160:
        return true;
      case 35:
        pass = true;
        break;
      case 36:
        pass = false;
        break;
      default:
        if (R2.T) {
        }
        if (!pass || opts.WTF)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  });
  return s2;
}
function write_BrtBeginSst(sst, o2) {
  if (!o2)
    o2 = new_buf(8);
  o2.write_shift(4, sst.Count);
  o2.write_shift(4, sst.Unique);
  return o2;
}
var write_BrtSSTItem = write_RichStr;
function write_sst_bin(sst) {
  var ba = buf_array();
  write_record(ba, 159, write_BrtBeginSst(sst));
  for (var i2 = 0; i2 < sst.length; ++i2)
    write_record(ba, 19, write_BrtSSTItem(sst[i2]));
  write_record(
    ba,
    160
    /* BrtEndSst */
  );
  return ba.end();
}
function _JS2ANSI(str) {
  if (typeof $cptable !== "undefined")
    return $cptable.utils.encode(current_ansi, str);
  var o2 = [], oo = str.split("");
  for (var i2 = 0; i2 < oo.length; ++i2)
    o2[i2] = oo[i2].charCodeAt(0);
  return o2;
}
function parse_CRYPTOVersion(blob, length) {
  var o2 = {};
  o2.Major = blob.read_shift(2);
  o2.Minor = blob.read_shift(2);
  if (length >= 4)
    blob.l += length - 4;
  return o2;
}
function parse_DataSpaceVersionInfo(blob) {
  var o2 = {};
  o2.id = blob.read_shift(0, "lpp4");
  o2.R = parse_CRYPTOVersion(blob, 4);
  o2.U = parse_CRYPTOVersion(blob, 4);
  o2.W = parse_CRYPTOVersion(blob, 4);
  return o2;
}
function parse_DataSpaceMapEntry(blob) {
  var len = blob.read_shift(4);
  var end = blob.l + len - 4;
  var o2 = {};
  var cnt = blob.read_shift(4);
  var comps = [];
  while (cnt-- > 0)
    comps.push({ t: blob.read_shift(4), v: blob.read_shift(0, "lpp4") });
  o2.name = blob.read_shift(0, "lpp4");
  o2.comps = comps;
  if (blob.l != end)
    throw new Error("Bad DataSpaceMapEntry: " + blob.l + " != " + end);
  return o2;
}
function parse_DataSpaceMap(blob) {
  var o2 = [];
  blob.l += 4;
  var cnt = blob.read_shift(4);
  while (cnt-- > 0)
    o2.push(parse_DataSpaceMapEntry(blob));
  return o2;
}
function parse_DataSpaceDefinition(blob) {
  var o2 = [];
  blob.l += 4;
  var cnt = blob.read_shift(4);
  while (cnt-- > 0)
    o2.push(blob.read_shift(0, "lpp4"));
  return o2;
}
function parse_TransformInfoHeader(blob) {
  var o2 = {};
  blob.read_shift(4);
  blob.l += 4;
  o2.id = blob.read_shift(0, "lpp4");
  o2.name = blob.read_shift(0, "lpp4");
  o2.R = parse_CRYPTOVersion(blob, 4);
  o2.U = parse_CRYPTOVersion(blob, 4);
  o2.W = parse_CRYPTOVersion(blob, 4);
  return o2;
}
function parse_Primary(blob) {
  var hdr = parse_TransformInfoHeader(blob);
  hdr.ename = blob.read_shift(0, "8lpp4");
  hdr.blksz = blob.read_shift(4);
  hdr.cmode = blob.read_shift(4);
  if (blob.read_shift(4) != 4)
    throw new Error("Bad !Primary record");
  return hdr;
}
function parse_EncryptionHeader(blob, length) {
  var tgt = blob.l + length;
  var o2 = {};
  o2.Flags = blob.read_shift(4) & 63;
  blob.l += 4;
  o2.AlgID = blob.read_shift(4);
  var valid = false;
  switch (o2.AlgID) {
    case 26126:
    case 26127:
    case 26128:
      valid = o2.Flags == 36;
      break;
    case 26625:
      valid = o2.Flags == 4;
      break;
    case 0:
      valid = o2.Flags == 16 || o2.Flags == 4 || o2.Flags == 36;
      break;
    default:
      throw "Unrecognized encryption algorithm: " + o2.AlgID;
  }
  if (!valid)
    throw new Error("Encryption Flags/AlgID mismatch");
  o2.AlgIDHash = blob.read_shift(4);
  o2.KeySize = blob.read_shift(4);
  o2.ProviderType = blob.read_shift(4);
  blob.l += 8;
  o2.CSPName = blob.read_shift(tgt - blob.l >> 1, "utf16le");
  blob.l = tgt;
  return o2;
}
function parse_EncryptionVerifier(blob, length) {
  var o2 = {}, tgt = blob.l + length;
  blob.l += 4;
  o2.Salt = blob.slice(blob.l, blob.l + 16);
  blob.l += 16;
  o2.Verifier = blob.slice(blob.l, blob.l + 16);
  blob.l += 16;
  blob.read_shift(4);
  o2.VerifierHash = blob.slice(blob.l, tgt);
  blob.l = tgt;
  return o2;
}
function parse_EncryptionInfo(blob) {
  var vers = parse_CRYPTOVersion(blob);
  switch (vers.Minor) {
    case 2:
      return [vers.Minor, parse_EncInfoStd(blob, vers)];
    case 3:
      return [vers.Minor, parse_EncInfoExt(blob, vers)];
    case 4:
      return [vers.Minor, parse_EncInfoAgl(blob, vers)];
  }
  throw new Error("ECMA-376 Encrypted file unrecognized Version: " + vers.Minor);
}
function parse_EncInfoStd(blob) {
  var flags = blob.read_shift(4);
  if ((flags & 63) != 36)
    throw new Error("EncryptionInfo mismatch");
  var sz = blob.read_shift(4);
  var hdr = parse_EncryptionHeader(blob, sz);
  var verifier = parse_EncryptionVerifier(blob, blob.length - blob.l);
  return { t: "Std", h: hdr, v: verifier };
}
function parse_EncInfoExt() {
  throw new Error("File is password-protected: ECMA-376 Extensible");
}
function parse_EncInfoAgl(blob) {
  var KeyData = ["saltSize", "blockSize", "keyBits", "hashSize", "cipherAlgorithm", "cipherChaining", "hashAlgorithm", "saltValue"];
  blob.l += 4;
  var xml = blob.read_shift(blob.length - blob.l, "utf8");
  var o2 = {};
  xml.replace(tagregex, function xml_agile(x2) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<?xml":
        break;
      case "<encryption":
      case "</encryption>":
        break;
      case "<keyData":
        KeyData.forEach(function(k2) {
          o2[k2] = y2[k2];
        });
        break;
      case "<dataIntegrity":
        o2.encryptedHmacKey = y2.encryptedHmacKey;
        o2.encryptedHmacValue = y2.encryptedHmacValue;
        break;
      case "<keyEncryptors>":
      case "<keyEncryptors":
        o2.encs = [];
        break;
      case "</keyEncryptors>":
        break;
      case "<keyEncryptor":
        o2.uri = y2.uri;
        break;
      case "</keyEncryptor>":
        break;
      case "<encryptedKey":
        o2.encs.push(y2);
        break;
      default:
        throw y2[0];
    }
  });
  return o2;
}
function parse_RC4CryptoHeader(blob, length) {
  var o2 = {};
  var vers = o2.EncryptionVersionInfo = parse_CRYPTOVersion(blob, 4);
  length -= 4;
  if (vers.Minor != 2)
    throw new Error("unrecognized minor version code: " + vers.Minor);
  if (vers.Major > 4 || vers.Major < 2)
    throw new Error("unrecognized major version code: " + vers.Major);
  o2.Flags = blob.read_shift(4);
  length -= 4;
  var sz = blob.read_shift(4);
  length -= 4;
  o2.EncryptionHeader = parse_EncryptionHeader(blob, sz);
  length -= sz;
  o2.EncryptionVerifier = parse_EncryptionVerifier(blob, length);
  return o2;
}
function parse_RC4Header(blob) {
  var o2 = {};
  var vers = o2.EncryptionVersionInfo = parse_CRYPTOVersion(blob, 4);
  if (vers.Major != 1 || vers.Minor != 1)
    throw "unrecognized version code " + vers.Major + " : " + vers.Minor;
  o2.Salt = blob.read_shift(16);
  o2.EncryptedVerifier = blob.read_shift(16);
  o2.EncryptedVerifierHash = blob.read_shift(16);
  return o2;
}
function crypto_CreatePasswordVerifier_Method1(Password) {
  var Verifier = 0, PasswordArray;
  var PasswordDecoded = _JS2ANSI(Password);
  var len = PasswordDecoded.length + 1, i2, PasswordByte;
  var Intermediate1, Intermediate2, Intermediate3;
  PasswordArray = new_raw_buf(len);
  PasswordArray[0] = PasswordDecoded.length;
  for (i2 = 1; i2 != len; ++i2)
    PasswordArray[i2] = PasswordDecoded[i2 - 1];
  for (i2 = len - 1; i2 >= 0; --i2) {
    PasswordByte = PasswordArray[i2];
    Intermediate1 = (Verifier & 16384) === 0 ? 0 : 1;
    Intermediate2 = Verifier << 1 & 32767;
    Intermediate3 = Intermediate1 | Intermediate2;
    Verifier = Intermediate3 ^ PasswordByte;
  }
  return Verifier ^ 52811;
}
var crypto_CreateXorArray_Method1 = /* @__PURE__ */ function() {
  var PadArray = [187, 255, 255, 186, 255, 255, 185, 128, 0, 190, 15, 0, 191, 15, 0];
  var InitialCode = [57840, 7439, 52380, 33984, 4364, 3600, 61902, 12606, 6258, 57657, 54287, 34041, 10252, 43370, 20163];
  var XorMatrix = [44796, 19929, 39858, 10053, 20106, 40212, 10761, 31585, 63170, 64933, 60267, 50935, 40399, 11199, 17763, 35526, 1453, 2906, 5812, 11624, 23248, 885, 1770, 3540, 7080, 14160, 28320, 56640, 55369, 41139, 20807, 41614, 21821, 43642, 17621, 28485, 56970, 44341, 19019, 38038, 14605, 29210, 60195, 50791, 40175, 10751, 21502, 43004, 24537, 18387, 36774, 3949, 7898, 15796, 31592, 63184, 47201, 24803, 49606, 37805, 14203, 28406, 56812, 17824, 35648, 1697, 3394, 6788, 13576, 27152, 43601, 17539, 35078, 557, 1114, 2228, 4456, 30388, 60776, 51953, 34243, 7079, 14158, 28316, 14128, 28256, 56512, 43425, 17251, 34502, 7597, 13105, 26210, 52420, 35241, 883, 1766, 3532, 4129, 8258, 16516, 33032, 4657, 9314, 18628];
  var Ror = function(Byte) {
    return (Byte / 2 | Byte * 128) & 255;
  };
  var XorRor = function(byte1, byte2) {
    return Ror(byte1 ^ byte2);
  };
  var CreateXorKey_Method1 = function(Password) {
    var XorKey = InitialCode[Password.length - 1];
    var CurrentElement = 104;
    for (var i2 = Password.length - 1; i2 >= 0; --i2) {
      var Char = Password[i2];
      for (var j2 = 0; j2 != 7; ++j2) {
        if (Char & 64)
          XorKey ^= XorMatrix[CurrentElement];
        Char *= 2;
        --CurrentElement;
      }
    }
    return XorKey;
  };
  return function(password) {
    var Password = _JS2ANSI(password);
    var XorKey = CreateXorKey_Method1(Password);
    var Index = Password.length;
    var ObfuscationArray = new_raw_buf(16);
    for (var i2 = 0; i2 != 16; ++i2)
      ObfuscationArray[i2] = 0;
    var Temp, PasswordLastChar, PadIndex;
    if ((Index & 1) === 1) {
      Temp = XorKey >> 8;
      ObfuscationArray[Index] = XorRor(PadArray[0], Temp);
      --Index;
      Temp = XorKey & 255;
      PasswordLastChar = Password[Password.length - 1];
      ObfuscationArray[Index] = XorRor(PasswordLastChar, Temp);
    }
    while (Index > 0) {
      --Index;
      Temp = XorKey >> 8;
      ObfuscationArray[Index] = XorRor(Password[Index], Temp);
      --Index;
      Temp = XorKey & 255;
      ObfuscationArray[Index] = XorRor(Password[Index], Temp);
    }
    Index = 15;
    PadIndex = 15 - Password.length;
    while (PadIndex > 0) {
      Temp = XorKey >> 8;
      ObfuscationArray[Index] = XorRor(PadArray[PadIndex], Temp);
      --Index;
      --PadIndex;
      Temp = XorKey & 255;
      ObfuscationArray[Index] = XorRor(Password[Index], Temp);
      --Index;
      --PadIndex;
    }
    return ObfuscationArray;
  };
}();
var crypto_DecryptData_Method1 = function(password, Data, XorArrayIndex, XorArray, O2) {
  if (!O2)
    O2 = Data;
  if (!XorArray)
    XorArray = crypto_CreateXorArray_Method1(password);
  var Index, Value;
  for (Index = 0; Index != Data.length; ++Index) {
    Value = Data[Index];
    Value ^= XorArray[XorArrayIndex];
    Value = (Value >> 5 | Value << 3) & 255;
    O2[Index] = Value;
    ++XorArrayIndex;
  }
  return [O2, XorArrayIndex, XorArray];
};
var crypto_MakeXorDecryptor = function(password) {
  var XorArrayIndex = 0, XorArray = crypto_CreateXorArray_Method1(password);
  return function(Data) {
    var O2 = crypto_DecryptData_Method1("", Data, XorArrayIndex, XorArray);
    XorArrayIndex = O2[1];
    return O2[0];
  };
};
function parse_XORObfuscation(blob, length, opts, out) {
  var o2 = { key: parseuint16(blob), verificationBytes: parseuint16(blob) };
  if (opts.password)
    o2.verifier = crypto_CreatePasswordVerifier_Method1(opts.password);
  out.valid = o2.verificationBytes === o2.verifier;
  if (out.valid)
    out.insitu = crypto_MakeXorDecryptor(opts.password);
  return o2;
}
function parse_FilePassHeader(blob, length, oo) {
  var o2 = oo || {};
  o2.Info = blob.read_shift(2);
  blob.l -= 2;
  if (o2.Info === 1)
    o2.Data = parse_RC4Header(blob, length);
  else
    o2.Data = parse_RC4CryptoHeader(blob, length);
  return o2;
}
function parse_FilePass(blob, length, opts) {
  var o2 = { Type: opts.biff >= 8 ? blob.read_shift(2) : 0 };
  if (o2.Type)
    parse_FilePassHeader(blob, length - 2, o2);
  else
    parse_XORObfuscation(blob, opts.biff >= 8 ? length : length - 2, opts, o2);
  return o2;
}
var RTF = /* @__PURE__ */ function() {
  function rtf_to_sheet(d2, opts) {
    switch (opts.type) {
      case "base64":
        return rtf_to_sheet_str(Base64_decode(d2), opts);
      case "binary":
        return rtf_to_sheet_str(d2, opts);
      case "buffer":
        return rtf_to_sheet_str(has_buf && Buffer.isBuffer(d2) ? d2.toString("binary") : a2s(d2), opts);
      case "array":
        return rtf_to_sheet_str(cc2str(d2), opts);
    }
    throw new Error("Unrecognized type " + opts.type);
  }
  function rtf_to_sheet_str(str, opts) {
    var o2 = opts || {};
    var ws = o2.dense ? [] : {};
    var rows = str.match(/\\trowd.*?\\row\b/g);
    if (!rows.length)
      throw new Error("RTF missing table");
    var range = { s: { c: 0, r: 0 }, e: { c: 0, r: rows.length - 1 } };
    rows.forEach(function(rowtf, R2) {
      if (Array.isArray(ws))
        ws[R2] = [];
      var rtfre = /\\\w+\b/g;
      var last_index = 0;
      var res;
      var C2 = -1;
      while (res = rtfre.exec(rowtf)) {
        switch (res[0]) {
          case "\\cell":
            var data = rowtf.slice(last_index, rtfre.lastIndex - res[0].length);
            if (data[0] == " ")
              data = data.slice(1);
            ++C2;
            if (data.length) {
              var cell = { v: data, t: "s" };
              if (Array.isArray(ws))
                ws[R2][C2] = cell;
              else
                ws[encode_cell({ r: R2, c: C2 })] = cell;
            }
            break;
        }
        last_index = rtfre.lastIndex;
      }
      if (C2 > range.e.c)
        range.e.c = C2;
    });
    ws["!ref"] = encode_range(range);
    return ws;
  }
  function rtf_to_workbook(d2, opts) {
    return sheet_to_workbook(rtf_to_sheet(d2, opts), opts);
  }
  function sheet_to_rtf(ws) {
    var o2 = ["{\\rtf1\\ansi"];
    var r = safe_decode_range(ws["!ref"]), cell;
    var dense = Array.isArray(ws);
    for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
      o2.push("\\trowd\\trautofit1");
      for (var C2 = r.s.c; C2 <= r.e.c; ++C2)
        o2.push("\\cellx" + (C2 + 1));
      o2.push("\\pard\\intbl");
      for (C2 = r.s.c; C2 <= r.e.c; ++C2) {
        var coord = encode_cell({ r: R2, c: C2 });
        cell = dense ? (ws[R2] || [])[C2] : ws[coord];
        if (!cell || cell.v == null && (!cell.f || cell.F))
          continue;
        o2.push(" " + (cell.w || (format_cell(cell), cell.w)));
        o2.push("\\cell");
      }
      o2.push("\\pard\\intbl\\row");
    }
    return o2.join("") + "}";
  }
  return {
    to_workbook: rtf_to_workbook,
    to_sheet: rtf_to_sheet,
    from_sheet: sheet_to_rtf
  };
}();
function hex2RGB(h2) {
  var o2 = h2.slice(h2[0] === "#" ? 1 : 0).slice(0, 6);
  return [parseInt(o2.slice(0, 2), 16), parseInt(o2.slice(2, 4), 16), parseInt(o2.slice(4, 6), 16)];
}
function rgb2Hex(rgb) {
  for (var i2 = 0, o2 = 1; i2 != 3; ++i2)
    o2 = o2 * 256 + (rgb[i2] > 255 ? 255 : rgb[i2] < 0 ? 0 : rgb[i2]);
  return o2.toString(16).toUpperCase().slice(1);
}
function rgb2HSL(rgb) {
  var R2 = rgb[0] / 255, G2 = rgb[1] / 255, B2 = rgb[2] / 255;
  var M2 = Math.max(R2, G2, B2), m2 = Math.min(R2, G2, B2), C2 = M2 - m2;
  if (C2 === 0)
    return [0, 0, R2];
  var H6 = 0, S2 = 0, L2 = M2 + m2;
  S2 = C2 / (L2 > 1 ? 2 - L2 : L2);
  switch (M2) {
    case R2:
      H6 = ((G2 - B2) / C2 + 6) % 6;
      break;
    case G2:
      H6 = (B2 - R2) / C2 + 2;
      break;
    case B2:
      H6 = (R2 - G2) / C2 + 4;
      break;
  }
  return [H6 / 6, S2, L2 / 2];
}
function hsl2RGB(hsl) {
  var H2 = hsl[0], S2 = hsl[1], L2 = hsl[2];
  var C2 = S2 * 2 * (L2 < 0.5 ? L2 : 1 - L2), m2 = L2 - C2 / 2;
  var rgb = [m2, m2, m2], h6 = 6 * H2;
  var X2;
  if (S2 !== 0)
    switch (h6 | 0) {
      case 0:
      case 6:
        X2 = C2 * h6;
        rgb[0] += C2;
        rgb[1] += X2;
        break;
      case 1:
        X2 = C2 * (2 - h6);
        rgb[0] += X2;
        rgb[1] += C2;
        break;
      case 2:
        X2 = C2 * (h6 - 2);
        rgb[1] += C2;
        rgb[2] += X2;
        break;
      case 3:
        X2 = C2 * (4 - h6);
        rgb[1] += X2;
        rgb[2] += C2;
        break;
      case 4:
        X2 = C2 * (h6 - 4);
        rgb[2] += C2;
        rgb[0] += X2;
        break;
      case 5:
        X2 = C2 * (6 - h6);
        rgb[2] += X2;
        rgb[0] += C2;
        break;
    }
  for (var i2 = 0; i2 != 3; ++i2)
    rgb[i2] = Math.round(rgb[i2] * 255);
  return rgb;
}
function rgb_tint(hex, tint) {
  if (tint === 0)
    return hex;
  var hsl = rgb2HSL(hex2RGB(hex));
  if (tint < 0)
    hsl[2] = hsl[2] * (1 + tint);
  else
    hsl[2] = 1 - (1 - hsl[2]) * (1 - tint);
  return rgb2Hex(hsl2RGB(hsl));
}
var DEF_MDW = 6;
var MAX_MDW = 15;
var MIN_MDW = 1;
var MDW = DEF_MDW;
function width2px(width) {
  return Math.floor((width + Math.round(128 / MDW) / 256) * MDW);
}
function px2char(px) {
  return Math.floor((px - 5) / MDW * 100 + 0.5) / 100;
}
function char2width(chr) {
  return Math.round((chr * MDW + 5) / MDW * 256) / 256;
}
function cycle_width(collw) {
  return char2width(px2char(width2px(collw)));
}
function find_mdw_colw(collw) {
  var delta = Math.abs(collw - cycle_width(collw)), _MDW = MDW;
  if (delta > 5e-3) {
    for (MDW = MIN_MDW; MDW < MAX_MDW; ++MDW)
      if (Math.abs(collw - cycle_width(collw)) <= delta) {
        delta = Math.abs(collw - cycle_width(collw));
        _MDW = MDW;
      }
  }
  MDW = _MDW;
}
function process_col(coll) {
  if (coll.width) {
    coll.wpx = width2px(coll.width);
    coll.wch = px2char(coll.wpx);
    coll.MDW = MDW;
  } else if (coll.wpx) {
    coll.wch = px2char(coll.wpx);
    coll.width = char2width(coll.wch);
    coll.MDW = MDW;
  } else if (typeof coll.wch == "number") {
    coll.width = char2width(coll.wch);
    coll.wpx = width2px(coll.width);
    coll.MDW = MDW;
  }
  if (coll.customWidth)
    delete coll.customWidth;
}
var DEF_PPI = 96;
var PPI = DEF_PPI;
function px2pt(px) {
  return px * 96 / PPI;
}
function pt2px(pt2) {
  return pt2 * PPI / 96;
}
var XLMLPatternTypeMap = {
  "None": "none",
  "Solid": "solid",
  "Gray50": "mediumGray",
  "Gray75": "darkGray",
  "Gray25": "lightGray",
  "HorzStripe": "darkHorizontal",
  "VertStripe": "darkVertical",
  "ReverseDiagStripe": "darkDown",
  "DiagStripe": "darkUp",
  "DiagCross": "darkGrid",
  "ThickDiagCross": "darkTrellis",
  "ThinHorzStripe": "lightHorizontal",
  "ThinVertStripe": "lightVertical",
  "ThinReverseDiagStripe": "lightDown",
  "ThinHorzCross": "lightGrid"
};
function parse_borders(t2, styles, themes, opts) {
  styles.Borders = [];
  var border = {};
  var pass = false;
  (t2[0].match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<borders":
      case "<borders>":
      case "</borders>":
        break;
      case "<border":
      case "<border>":
      case "<border/>":
        border = /*::(*/
        {};
        if (y2.diagonalUp)
          border.diagonalUp = parsexmlbool(y2.diagonalUp);
        if (y2.diagonalDown)
          border.diagonalDown = parsexmlbool(y2.diagonalDown);
        styles.Borders.push(border);
        break;
      case "</border>":
        break;
      case "<left/>":
        break;
      case "<left":
      case "<left>":
        break;
      case "</left>":
        break;
      case "<right/>":
        break;
      case "<right":
      case "<right>":
        break;
      case "</right>":
        break;
      case "<top/>":
        break;
      case "<top":
      case "<top>":
        break;
      case "</top>":
        break;
      case "<bottom/>":
        break;
      case "<bottom":
      case "<bottom>":
        break;
      case "</bottom>":
        break;
      case "<diagonal":
      case "<diagonal>":
      case "<diagonal/>":
        break;
      case "</diagonal>":
        break;
      case "<horizontal":
      case "<horizontal>":
      case "<horizontal/>":
        break;
      case "</horizontal>":
        break;
      case "<vertical":
      case "<vertical>":
      case "<vertical/>":
        break;
      case "</vertical>":
        break;
      case "<start":
      case "<start>":
      case "<start/>":
        break;
      case "</start>":
        break;
      case "<end":
      case "<end>":
      case "<end/>":
        break;
      case "</end>":
        break;
      case "<color":
      case "<color>":
        break;
      case "<color/>":
      case "</color>":
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      default:
        if (opts && opts.WTF) {
          if (!pass)
            throw new Error("unrecognized " + y2[0] + " in borders");
        }
    }
  });
}
function parse_fills(t2, styles, themes, opts) {
  styles.Fills = [];
  var fill2 = {};
  var pass = false;
  (t2[0].match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<fills":
      case "<fills>":
      case "</fills>":
        break;
      case "<fill>":
      case "<fill":
      case "<fill/>":
        fill2 = {};
        styles.Fills.push(fill2);
        break;
      case "</fill>":
        break;
      case "<gradientFill>":
        break;
      case "<gradientFill":
      case "</gradientFill>":
        styles.Fills.push(fill2);
        fill2 = {};
        break;
      case "<patternFill":
      case "<patternFill>":
        if (y2.patternType)
          fill2.patternType = y2.patternType;
        break;
      case "<patternFill/>":
      case "</patternFill>":
        break;
      case "<bgColor":
        if (!fill2.bgColor)
          fill2.bgColor = {};
        if (y2.indexed)
          fill2.bgColor.indexed = parseInt(y2.indexed, 10);
        if (y2.theme)
          fill2.bgColor.theme = parseInt(y2.theme, 10);
        if (y2.tint)
          fill2.bgColor.tint = parseFloat(y2.tint);
        if (y2.rgb)
          fill2.bgColor.rgb = y2.rgb.slice(-6);
        break;
      case "<bgColor/>":
      case "</bgColor>":
        break;
      case "<fgColor":
        if (!fill2.fgColor)
          fill2.fgColor = {};
        if (y2.theme)
          fill2.fgColor.theme = parseInt(y2.theme, 10);
        if (y2.tint)
          fill2.fgColor.tint = parseFloat(y2.tint);
        if (y2.rgb != null)
          fill2.fgColor.rgb = y2.rgb.slice(-6);
        break;
      case "<fgColor/>":
      case "</fgColor>":
        break;
      case "<stop":
      case "<stop/>":
        break;
      case "</stop>":
        break;
      case "<color":
      case "<color/>":
        break;
      case "</color>":
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      default:
        if (opts && opts.WTF) {
          if (!pass)
            throw new Error("unrecognized " + y2[0] + " in fills");
        }
    }
  });
}
function parse_fonts(t2, styles, themes, opts) {
  styles.Fonts = [];
  var font = {};
  var pass = false;
  (t2[0].match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<fonts":
      case "<fonts>":
      case "</fonts>":
        break;
      case "<font":
      case "<font>":
        break;
      case "</font>":
      case "<font/>":
        styles.Fonts.push(font);
        font = {};
        break;
      case "<name":
        if (y2.val)
          font.name = utf8read(y2.val);
        break;
      case "<name/>":
      case "</name>":
        break;
      case "<b":
        font.bold = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<b/>":
        font.bold = 1;
        break;
      case "<i":
        font.italic = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<i/>":
        font.italic = 1;
        break;
      case "<u":
        switch (y2.val) {
          case "none":
            font.underline = 0;
            break;
          case "single":
            font.underline = 1;
            break;
          case "double":
            font.underline = 2;
            break;
          case "singleAccounting":
            font.underline = 33;
            break;
          case "doubleAccounting":
            font.underline = 34;
            break;
        }
        break;
      case "<u/>":
        font.underline = 1;
        break;
      case "<strike":
        font.strike = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<strike/>":
        font.strike = 1;
        break;
      case "<outline":
        font.outline = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<outline/>":
        font.outline = 1;
        break;
      case "<shadow":
        font.shadow = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<shadow/>":
        font.shadow = 1;
        break;
      case "<condense":
        font.condense = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<condense/>":
        font.condense = 1;
        break;
      case "<extend":
        font.extend = y2.val ? parsexmlbool(y2.val) : 1;
        break;
      case "<extend/>":
        font.extend = 1;
        break;
      case "<sz":
        if (y2.val)
          font.sz = +y2.val;
        break;
      case "<sz/>":
      case "</sz>":
        break;
      case "<vertAlign":
        if (y2.val)
          font.vertAlign = y2.val;
        break;
      case "<vertAlign/>":
      case "</vertAlign>":
        break;
      case "<family":
        if (y2.val)
          font.family = parseInt(y2.val, 10);
        break;
      case "<family/>":
      case "</family>":
        break;
      case "<scheme":
        if (y2.val)
          font.scheme = y2.val;
        break;
      case "<scheme/>":
      case "</scheme>":
        break;
      case "<charset":
        if (y2.val == "1")
          break;
        y2.codepage = CS2CP[parseInt(y2.val, 10)];
        break;
      case "<color":
        if (!font.color)
          font.color = {};
        if (y2.auto)
          font.color.auto = parsexmlbool(y2.auto);
        if (y2.rgb)
          font.color.rgb = y2.rgb.slice(-6);
        else if (y2.indexed) {
          font.color.index = parseInt(y2.indexed, 10);
          var icv = XLSIcv[font.color.index];
          if (font.color.index == 81)
            icv = XLSIcv[1];
          if (!icv)
            icv = XLSIcv[1];
          font.color.rgb = icv[0].toString(16) + icv[1].toString(16) + icv[2].toString(16);
        } else if (y2.theme) {
          font.color.theme = parseInt(y2.theme, 10);
          if (y2.tint)
            font.color.tint = parseFloat(y2.tint);
          if (y2.theme && themes.themeElements && themes.themeElements.clrScheme) {
            font.color.rgb = rgb_tint(themes.themeElements.clrScheme[font.color.theme].rgb, font.color.tint || 0);
          }
        }
        break;
      case "<color/>":
      case "</color>":
        break;
      case "<AlternateContent":
        pass = true;
        break;
      case "</AlternateContent>":
        pass = false;
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      default:
        if (opts && opts.WTF) {
          if (!pass)
            throw new Error("unrecognized " + y2[0] + " in fonts");
        }
    }
  });
}
function parse_numFmts(t2, styles, opts) {
  styles.NumberFmt = [];
  var k2 = keys(table_fmt);
  for (var i2 = 0; i2 < k2.length; ++i2)
    styles.NumberFmt[k2[i2]] = table_fmt[k2[i2]];
  var m2 = t2[0].match(tagregex);
  if (!m2)
    return;
  for (i2 = 0; i2 < m2.length; ++i2) {
    var y2 = parsexmltag(m2[i2]);
    switch (strip_ns(y2[0])) {
      case "<numFmts":
      case "</numFmts>":
      case "<numFmts/>":
      case "<numFmts>":
        break;
      case "<numFmt":
        {
          var f2 = unescapexml(utf8read(y2.formatCode)), j2 = parseInt(y2.numFmtId, 10);
          styles.NumberFmt[j2] = f2;
          if (j2 > 0) {
            if (j2 > 392) {
              for (j2 = 392; j2 > 60; --j2)
                if (styles.NumberFmt[j2] == null)
                  break;
              styles.NumberFmt[j2] = f2;
            }
            SSF_load(f2, j2);
          }
        }
        break;
      case "</numFmt>":
        break;
      default:
        if (opts.WTF)
          throw new Error("unrecognized " + y2[0] + " in numFmts");
    }
  }
}
function write_numFmts(NF) {
  var o2 = ["<numFmts>"];
  [[5, 8], [23, 26], [41, 44], [
    /*63*/
    50,
    /*66],[164,*/
    392
  ]].forEach(function(r) {
    for (var i2 = r[0]; i2 <= r[1]; ++i2)
      if (NF[i2] != null)
        o2[o2.length] = writextag("numFmt", null, { numFmtId: i2, formatCode: escapexml(NF[i2]) });
  });
  if (o2.length === 1)
    return "";
  o2[o2.length] = "</numFmts>";
  o2[0] = writextag("numFmts", null, { count: o2.length - 2 }).replace("/>", ">");
  return o2.join("");
}
var cellXF_uint = ["numFmtId", "fillId", "fontId", "borderId", "xfId"];
var cellXF_bool = ["applyAlignment", "applyBorder", "applyFill", "applyFont", "applyNumberFormat", "applyProtection", "pivotButton", "quotePrefix"];
function parse_cellXfs(t2, styles, opts) {
  styles.CellXf = [];
  var xf;
  var pass = false;
  (t2[0].match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2), i2 = 0;
    switch (strip_ns(y2[0])) {
      case "<cellXfs":
      case "<cellXfs>":
      case "<cellXfs/>":
      case "</cellXfs>":
        break;
      case "<xf":
      case "<xf/>":
        xf = y2;
        delete xf[0];
        for (i2 = 0; i2 < cellXF_uint.length; ++i2)
          if (xf[cellXF_uint[i2]])
            xf[cellXF_uint[i2]] = parseInt(xf[cellXF_uint[i2]], 10);
        for (i2 = 0; i2 < cellXF_bool.length; ++i2)
          if (xf[cellXF_bool[i2]])
            xf[cellXF_bool[i2]] = parsexmlbool(xf[cellXF_bool[i2]]);
        if (styles.NumberFmt && xf.numFmtId > 392) {
          for (i2 = 392; i2 > 60; --i2)
            if (styles.NumberFmt[xf.numFmtId] == styles.NumberFmt[i2]) {
              xf.numFmtId = i2;
              break;
            }
        }
        styles.CellXf.push(xf);
        break;
      case "</xf>":
        break;
      case "<alignment":
      case "<alignment/>":
        var alignment = {};
        if (y2.vertical)
          alignment.vertical = y2.vertical;
        if (y2.horizontal)
          alignment.horizontal = y2.horizontal;
        if (y2.textRotation != null)
          alignment.textRotation = y2.textRotation;
        if (y2.indent)
          alignment.indent = y2.indent;
        if (y2.wrapText)
          alignment.wrapText = parsexmlbool(y2.wrapText);
        xf.alignment = alignment;
        break;
      case "</alignment>":
        break;
      case "<protection":
        break;
      case "</protection>":
      case "<protection/>":
        break;
      case "<AlternateContent":
        pass = true;
        break;
      case "</AlternateContent>":
        pass = false;
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      default:
        if (opts && opts.WTF) {
          if (!pass)
            throw new Error("unrecognized " + y2[0] + " in cellXfs");
        }
    }
  });
}
function write_cellXfs(cellXfs) {
  var o2 = [];
  o2[o2.length] = writextag("cellXfs", null);
  cellXfs.forEach(function(c2) {
    o2[o2.length] = writextag("xf", null, c2);
  });
  o2[o2.length] = "</cellXfs>";
  if (o2.length === 2)
    return "";
  o2[0] = writextag("cellXfs", null, { count: o2.length - 2 }).replace("/>", ">");
  return o2.join("");
}
var parse_sty_xml = /* @__PURE__ */ function make_pstyx() {
  var numFmtRegex = /<(?:\w+:)?numFmts([^>]*)>[\S\s]*?<\/(?:\w+:)?numFmts>/;
  var cellXfRegex = /<(?:\w+:)?cellXfs([^>]*)>[\S\s]*?<\/(?:\w+:)?cellXfs>/;
  var fillsRegex = /<(?:\w+:)?fills([^>]*)>[\S\s]*?<\/(?:\w+:)?fills>/;
  var fontsRegex = /<(?:\w+:)?fonts([^>]*)>[\S\s]*?<\/(?:\w+:)?fonts>/;
  var bordersRegex = /<(?:\w+:)?borders([^>]*)>[\S\s]*?<\/(?:\w+:)?borders>/;
  return function parse_sty_xml2(data, themes, opts) {
    var styles = {};
    if (!data)
      return styles;
    data = data.replace(/<!--([\s\S]*?)-->/mg, "").replace(/<!DOCTYPE[^\[]*\[[^\]]*\]>/gm, "");
    var t2;
    if (t2 = data.match(numFmtRegex))
      parse_numFmts(t2, styles, opts);
    if (t2 = data.match(fontsRegex))
      parse_fonts(t2, styles, themes, opts);
    if (t2 = data.match(fillsRegex))
      parse_fills(t2, styles, themes, opts);
    if (t2 = data.match(bordersRegex))
      parse_borders(t2, styles, themes, opts);
    if (t2 = data.match(cellXfRegex))
      parse_cellXfs(t2, styles, opts);
    return styles;
  };
}();
function write_sty_xml(wb, opts) {
  var o2 = [XML_HEADER, writextag("styleSheet", null, {
    "xmlns": XMLNS_main[0],
    "xmlns:vt": XMLNS.vt
  })], w2;
  if (wb.SSF && (w2 = write_numFmts(wb.SSF)) != null)
    o2[o2.length] = w2;
  o2[o2.length] = '<fonts count="1"><font><sz val="12"/><color theme="1"/><name val="Calibri"/><family val="2"/><scheme val="minor"/></font></fonts>';
  o2[o2.length] = '<fills count="2"><fill><patternFill patternType="none"/></fill><fill><patternFill patternType="gray125"/></fill></fills>';
  o2[o2.length] = '<borders count="1"><border><left/><right/><top/><bottom/><diagonal/></border></borders>';
  o2[o2.length] = '<cellStyleXfs count="1"><xf numFmtId="0" fontId="0" fillId="0" borderId="0"/></cellStyleXfs>';
  if (w2 = write_cellXfs(opts.cellXfs))
    o2[o2.length] = w2;
  o2[o2.length] = '<cellStyles count="1"><cellStyle name="Normal" xfId="0" builtinId="0"/></cellStyles>';
  o2[o2.length] = '<dxfs count="0"/>';
  o2[o2.length] = '<tableStyles count="0" defaultTableStyle="TableStyleMedium9" defaultPivotStyle="PivotStyleMedium4"/>';
  if (o2.length > 2) {
    o2[o2.length] = "</styleSheet>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
function parse_BrtFmt(data, length) {
  var numFmtId = data.read_shift(2);
  var stFmtCode = parse_XLWideString(data, length - 2);
  return [numFmtId, stFmtCode];
}
function write_BrtFmt(i2, f2, o2) {
  if (!o2)
    o2 = new_buf(6 + 4 * f2.length);
  o2.write_shift(2, i2);
  write_XLWideString(f2, o2);
  var out = o2.length > o2.l ? o2.slice(0, o2.l) : o2;
  if (o2.l == null)
    o2.l = o2.length;
  return out;
}
function parse_BrtFont(data, length, opts) {
  var out = {};
  out.sz = data.read_shift(2) / 20;
  var grbit = parse_FontFlags(data, 2, opts);
  if (grbit.fItalic)
    out.italic = 1;
  if (grbit.fCondense)
    out.condense = 1;
  if (grbit.fExtend)
    out.extend = 1;
  if (grbit.fShadow)
    out.shadow = 1;
  if (grbit.fOutline)
    out.outline = 1;
  if (grbit.fStrikeout)
    out.strike = 1;
  var bls = data.read_shift(2);
  if (bls === 700)
    out.bold = 1;
  switch (data.read_shift(2)) {
    case 1:
      out.vertAlign = "superscript";
      break;
    case 2:
      out.vertAlign = "subscript";
      break;
  }
  var underline = data.read_shift(1);
  if (underline != 0)
    out.underline = underline;
  var family = data.read_shift(1);
  if (family > 0)
    out.family = family;
  var bCharSet = data.read_shift(1);
  if (bCharSet > 0)
    out.charset = bCharSet;
  data.l++;
  out.color = parse_BrtColor(data, 8);
  switch (data.read_shift(1)) {
    case 1:
      out.scheme = "major";
      break;
    case 2:
      out.scheme = "minor";
      break;
  }
  out.name = parse_XLWideString(data, length - 21);
  return out;
}
function write_BrtFont(font, o2) {
  if (!o2)
    o2 = new_buf(25 + 4 * 32);
  o2.write_shift(2, font.sz * 20);
  write_FontFlags(font, o2);
  o2.write_shift(2, font.bold ? 700 : 400);
  var sss = 0;
  if (font.vertAlign == "superscript")
    sss = 1;
  else if (font.vertAlign == "subscript")
    sss = 2;
  o2.write_shift(2, sss);
  o2.write_shift(1, font.underline || 0);
  o2.write_shift(1, font.family || 0);
  o2.write_shift(1, font.charset || 0);
  o2.write_shift(1, 0);
  write_BrtColor(font.color, o2);
  var scheme = 0;
  if (font.scheme == "major")
    scheme = 1;
  if (font.scheme == "minor")
    scheme = 2;
  o2.write_shift(1, scheme);
  write_XLWideString(font.name, o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
var XLSBFillPTNames = [
  "none",
  "solid",
  "mediumGray",
  "darkGray",
  "lightGray",
  "darkHorizontal",
  "darkVertical",
  "darkDown",
  "darkUp",
  "darkGrid",
  "darkTrellis",
  "lightHorizontal",
  "lightVertical",
  "lightDown",
  "lightUp",
  "lightGrid",
  "lightTrellis",
  "gray125",
  "gray0625"
];
var rev_XLSBFillPTNames;
var parse_BrtFill = parsenoop;
function write_BrtFill(fill2, o2) {
  if (!o2)
    o2 = new_buf(4 * 3 + 8 * 7 + 16 * 1);
  if (!rev_XLSBFillPTNames)
    rev_XLSBFillPTNames = evert(XLSBFillPTNames);
  var fls = rev_XLSBFillPTNames[fill2.patternType];
  if (fls == null)
    fls = 40;
  o2.write_shift(4, fls);
  var j2 = 0;
  if (fls != 40) {
    write_BrtColor({ auto: 1 }, o2);
    write_BrtColor({ auto: 1 }, o2);
    for (; j2 < 12; ++j2)
      o2.write_shift(4, 0);
  } else {
    for (; j2 < 4; ++j2)
      o2.write_shift(4, 0);
    for (; j2 < 12; ++j2)
      o2.write_shift(4, 0);
  }
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function parse_BrtXF(data, length) {
  var tgt = data.l + length;
  var ixfeParent = data.read_shift(2);
  var ifmt = data.read_shift(2);
  data.l = tgt;
  return { ixfe: ixfeParent, numFmtId: ifmt };
}
function write_BrtXF(data, ixfeP, o2) {
  if (!o2)
    o2 = new_buf(16);
  o2.write_shift(2, ixfeP || 0);
  o2.write_shift(2, data.numFmtId || 0);
  o2.write_shift(2, 0);
  o2.write_shift(2, 0);
  o2.write_shift(2, 0);
  o2.write_shift(1, 0);
  o2.write_shift(1, 0);
  var flow = 0;
  o2.write_shift(1, flow);
  o2.write_shift(1, 0);
  o2.write_shift(1, 0);
  o2.write_shift(1, 0);
  return o2;
}
function write_Blxf(data, o2) {
  if (!o2)
    o2 = new_buf(10);
  o2.write_shift(1, 0);
  o2.write_shift(1, 0);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  return o2;
}
var parse_BrtBorder = parsenoop;
function write_BrtBorder(border, o2) {
  if (!o2)
    o2 = new_buf(51);
  o2.write_shift(1, 0);
  write_Blxf(null, o2);
  write_Blxf(null, o2);
  write_Blxf(null, o2);
  write_Blxf(null, o2);
  write_Blxf(null, o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function write_BrtStyle(style, o2) {
  if (!o2)
    o2 = new_buf(12 + 4 * 10);
  o2.write_shift(4, style.xfId);
  o2.write_shift(2, 1);
  o2.write_shift(1, +style.builtinId);
  o2.write_shift(1, 0);
  write_XLNullableWideString(style.name || "", o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function write_BrtBeginTableStyles(cnt, defTableStyle, defPivotStyle) {
  var o2 = new_buf(4 + 256 * 2 * 4);
  o2.write_shift(4, cnt);
  write_XLNullableWideString(defTableStyle, o2);
  write_XLNullableWideString(defPivotStyle, o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function parse_sty_bin(data, themes, opts) {
  var styles = {};
  styles.NumberFmt = [];
  for (var y2 in table_fmt)
    styles.NumberFmt[y2] = table_fmt[y2];
  styles.CellXf = [];
  styles.Fonts = [];
  var state = [];
  var pass = false;
  recordhopper(data, function hopper_sty(val, R2, RT) {
    switch (RT) {
      case 44:
        styles.NumberFmt[val[0]] = val[1];
        SSF_load(val[1], val[0]);
        break;
      case 43:
        styles.Fonts.push(val);
        if (val.color.theme != null && themes && themes.themeElements && themes.themeElements.clrScheme) {
          val.color.rgb = rgb_tint(themes.themeElements.clrScheme[val.color.theme].rgb, val.color.tint || 0);
        }
        break;
      case 1025:
        break;
      case 45:
        break;
      case 46:
        break;
      case 47:
        if (state[state.length - 1] == 617) {
          styles.CellXf.push(val);
        }
        break;
      case 48:
      case 507:
      case 572:
      case 475:
        break;
      case 1171:
      case 2102:
      case 1130:
      case 512:
      case 2095:
      case 3072:
        break;
      case 35:
        pass = true;
        break;
      case 36:
        pass = false;
        break;
      case 37:
        state.push(RT);
        pass = true;
        break;
      case 38:
        state.pop();
        pass = false;
        break;
      default:
        if (R2.T > 0)
          state.push(RT);
        else if (R2.T < 0)
          state.pop();
        else if (!pass || opts.WTF && state[state.length - 1] != 37)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  });
  return styles;
}
function write_FMTS_bin(ba, NF) {
  if (!NF)
    return;
  var cnt = 0;
  [[5, 8], [23, 26], [41, 44], [
    /*63*/
    50,
    /*66],[164,*/
    392
  ]].forEach(function(r) {
    for (var i2 = r[0]; i2 <= r[1]; ++i2)
      if (NF[i2] != null)
        ++cnt;
  });
  if (cnt == 0)
    return;
  write_record(ba, 615, write_UInt32LE(cnt));
  [[5, 8], [23, 26], [41, 44], [
    /*63*/
    50,
    /*66],[164,*/
    392
  ]].forEach(function(r) {
    for (var i2 = r[0]; i2 <= r[1]; ++i2)
      if (NF[i2] != null)
        write_record(ba, 44, write_BrtFmt(i2, NF[i2]));
  });
  write_record(
    ba,
    616
    /* BrtEndFmts */
  );
}
function write_FONTS_bin(ba) {
  var cnt = 1;
  if (cnt == 0)
    return;
  write_record(ba, 611, write_UInt32LE(cnt));
  write_record(ba, 43, write_BrtFont({
    sz: 12,
    color: { theme: 1 },
    name: "Calibri",
    family: 2,
    scheme: "minor"
  }));
  write_record(
    ba,
    612
    /* BrtEndFonts */
  );
}
function write_FILLS_bin(ba) {
  var cnt = 2;
  if (cnt == 0)
    return;
  write_record(ba, 603, write_UInt32LE(cnt));
  write_record(ba, 45, write_BrtFill({ patternType: "none" }));
  write_record(ba, 45, write_BrtFill({ patternType: "gray125" }));
  write_record(
    ba,
    604
    /* BrtEndFills */
  );
}
function write_BORDERS_bin(ba) {
  var cnt = 1;
  if (cnt == 0)
    return;
  write_record(ba, 613, write_UInt32LE(cnt));
  write_record(ba, 46, write_BrtBorder({}));
  write_record(
    ba,
    614
    /* BrtEndBorders */
  );
}
function write_CELLSTYLEXFS_bin(ba) {
  var cnt = 1;
  write_record(ba, 626, write_UInt32LE(cnt));
  write_record(ba, 47, write_BrtXF({
    numFmtId: 0,
    fontId: 0,
    fillId: 0,
    borderId: 0
  }, 65535));
  write_record(
    ba,
    627
    /* BrtEndCellStyleXFs */
  );
}
function write_CELLXFS_bin(ba, data) {
  write_record(ba, 617, write_UInt32LE(data.length));
  data.forEach(function(c2) {
    write_record(ba, 47, write_BrtXF(c2, 0));
  });
  write_record(
    ba,
    618
    /* BrtEndCellXFs */
  );
}
function write_STYLES_bin(ba) {
  var cnt = 1;
  write_record(ba, 619, write_UInt32LE(cnt));
  write_record(ba, 48, write_BrtStyle({
    xfId: 0,
    builtinId: 0,
    name: "Normal"
  }));
  write_record(
    ba,
    620
    /* BrtEndStyles */
  );
}
function write_DXFS_bin(ba) {
  var cnt = 0;
  write_record(ba, 505, write_UInt32LE(cnt));
  write_record(
    ba,
    506
    /* BrtEndDXFs */
  );
}
function write_TABLESTYLES_bin(ba) {
  var cnt = 0;
  write_record(ba, 508, write_BrtBeginTableStyles(cnt, "TableStyleMedium9", "PivotStyleMedium4"));
  write_record(
    ba,
    509
    /* BrtEndTableStyles */
  );
}
function write_COLORPALETTE_bin() {
  return;
}
function write_sty_bin(wb, opts) {
  var ba = buf_array();
  write_record(
    ba,
    278
    /* BrtBeginStyleSheet */
  );
  write_FMTS_bin(ba, wb.SSF);
  write_FONTS_bin(ba, wb);
  write_FILLS_bin(ba, wb);
  write_BORDERS_bin(ba, wb);
  write_CELLSTYLEXFS_bin(ba, wb);
  write_CELLXFS_bin(ba, opts.cellXfs);
  write_STYLES_bin(ba, wb);
  write_DXFS_bin(ba, wb);
  write_TABLESTYLES_bin(ba, wb);
  write_COLORPALETTE_bin(ba, wb);
  write_record(
    ba,
    279
    /* BrtEndStyleSheet */
  );
  return ba.end();
}
var XLSXThemeClrScheme = [
  "</a:lt1>",
  "</a:dk1>",
  "</a:lt2>",
  "</a:dk2>",
  "</a:accent1>",
  "</a:accent2>",
  "</a:accent3>",
  "</a:accent4>",
  "</a:accent5>",
  "</a:accent6>",
  "</a:hlink>",
  "</a:folHlink>"
];
function parse_clrScheme(t2, themes, opts) {
  themes.themeElements.clrScheme = [];
  var color = {};
  (t2[0].match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    switch (y2[0]) {
      case "<a:clrScheme":
      case "</a:clrScheme>":
        break;
      case "<a:srgbClr":
        color.rgb = y2.val;
        break;
      case "<a:sysClr":
        color.rgb = y2.lastClr;
        break;
      case "<a:dk1>":
      case "</a:dk1>":
      case "<a:lt1>":
      case "</a:lt1>":
      case "<a:dk2>":
      case "</a:dk2>":
      case "<a:lt2>":
      case "</a:lt2>":
      case "<a:accent1>":
      case "</a:accent1>":
      case "<a:accent2>":
      case "</a:accent2>":
      case "<a:accent3>":
      case "</a:accent3>":
      case "<a:accent4>":
      case "</a:accent4>":
      case "<a:accent5>":
      case "</a:accent5>":
      case "<a:accent6>":
      case "</a:accent6>":
      case "<a:hlink>":
      case "</a:hlink>":
      case "<a:folHlink>":
      case "</a:folHlink>":
        if (y2[0].charAt(1) === "/") {
          themes.themeElements.clrScheme[XLSXThemeClrScheme.indexOf(y2[0])] = color;
          color = {};
        } else {
          color.name = y2[0].slice(3, y2[0].length - 1);
        }
        break;
      default:
        if (opts && opts.WTF)
          throw new Error("Unrecognized " + y2[0] + " in clrScheme");
    }
  });
}
function parse_fontScheme() {
}
function parse_fmtScheme() {
}
var clrsregex = /<a:clrScheme([^>]*)>[\s\S]*<\/a:clrScheme>/;
var fntsregex = /<a:fontScheme([^>]*)>[\s\S]*<\/a:fontScheme>/;
var fmtsregex = /<a:fmtScheme([^>]*)>[\s\S]*<\/a:fmtScheme>/;
function parse_themeElements(data, themes, opts) {
  themes.themeElements = {};
  var t2;
  [
    /* clrScheme CT_ColorScheme */
    ["clrScheme", clrsregex, parse_clrScheme],
    /* fontScheme CT_FontScheme */
    ["fontScheme", fntsregex, parse_fontScheme],
    /* fmtScheme CT_StyleMatrix */
    ["fmtScheme", fmtsregex, parse_fmtScheme]
  ].forEach(function(m2) {
    if (!(t2 = data.match(m2[1])))
      throw new Error(m2[0] + " not found in themeElements");
    m2[2](t2, themes, opts);
  });
}
var themeltregex = /<a:themeElements([^>]*)>[\s\S]*<\/a:themeElements>/;
function parse_theme_xml(data, opts) {
  if (!data || data.length === 0)
    data = write_theme();
  var t2;
  var themes = {};
  if (!(t2 = data.match(themeltregex)))
    throw new Error("themeElements not found in theme");
  parse_themeElements(t2[0], themes, opts);
  themes.raw = data;
  return themes;
}
function write_theme(Themes, opts) {
  if (opts && opts.themeXLSX)
    return opts.themeXLSX;
  if (Themes && typeof Themes.raw == "string")
    return Themes.raw;
  var o2 = [XML_HEADER];
  o2[o2.length] = '<a:theme xmlns:a="http://schemas.openxmlformats.org/drawingml/2006/main" name="Office Theme">';
  o2[o2.length] = "<a:themeElements>";
  o2[o2.length] = '<a:clrScheme name="Office">';
  o2[o2.length] = '<a:dk1><a:sysClr val="windowText" lastClr="000000"/></a:dk1>';
  o2[o2.length] = '<a:lt1><a:sysClr val="window" lastClr="FFFFFF"/></a:lt1>';
  o2[o2.length] = '<a:dk2><a:srgbClr val="1F497D"/></a:dk2>';
  o2[o2.length] = '<a:lt2><a:srgbClr val="EEECE1"/></a:lt2>';
  o2[o2.length] = '<a:accent1><a:srgbClr val="4F81BD"/></a:accent1>';
  o2[o2.length] = '<a:accent2><a:srgbClr val="C0504D"/></a:accent2>';
  o2[o2.length] = '<a:accent3><a:srgbClr val="9BBB59"/></a:accent3>';
  o2[o2.length] = '<a:accent4><a:srgbClr val="8064A2"/></a:accent4>';
  o2[o2.length] = '<a:accent5><a:srgbClr val="4BACC6"/></a:accent5>';
  o2[o2.length] = '<a:accent6><a:srgbClr val="F79646"/></a:accent6>';
  o2[o2.length] = '<a:hlink><a:srgbClr val="0000FF"/></a:hlink>';
  o2[o2.length] = '<a:folHlink><a:srgbClr val="800080"/></a:folHlink>';
  o2[o2.length] = "</a:clrScheme>";
  o2[o2.length] = '<a:fontScheme name="Office">';
  o2[o2.length] = "<a:majorFont>";
  o2[o2.length] = '<a:latin typeface="Cambria"/>';
  o2[o2.length] = '<a:ea typeface=""/>';
  o2[o2.length] = '<a:cs typeface=""/>';
  o2[o2.length] = '<a:font script="Jpan" typeface="\uFF2D\uFF33 \uFF30\u30B4\u30B7\u30C3\u30AF"/>';
  o2[o2.length] = '<a:font script="Hang" typeface="\uB9D1\uC740 \uACE0\uB515"/>';
  o2[o2.length] = '<a:font script="Hans" typeface="\u5B8B\u4F53"/>';
  o2[o2.length] = '<a:font script="Hant" typeface="\u65B0\u7D30\u660E\u9AD4"/>';
  o2[o2.length] = '<a:font script="Arab" typeface="Times New Roman"/>';
  o2[o2.length] = '<a:font script="Hebr" typeface="Times New Roman"/>';
  o2[o2.length] = '<a:font script="Thai" typeface="Tahoma"/>';
  o2[o2.length] = '<a:font script="Ethi" typeface="Nyala"/>';
  o2[o2.length] = '<a:font script="Beng" typeface="Vrinda"/>';
  o2[o2.length] = '<a:font script="Gujr" typeface="Shruti"/>';
  o2[o2.length] = '<a:font script="Khmr" typeface="MoolBoran"/>';
  o2[o2.length] = '<a:font script="Knda" typeface="Tunga"/>';
  o2[o2.length] = '<a:font script="Guru" typeface="Raavi"/>';
  o2[o2.length] = '<a:font script="Cans" typeface="Euphemia"/>';
  o2[o2.length] = '<a:font script="Cher" typeface="Plantagenet Cherokee"/>';
  o2[o2.length] = '<a:font script="Yiii" typeface="Microsoft Yi Baiti"/>';
  o2[o2.length] = '<a:font script="Tibt" typeface="Microsoft Himalaya"/>';
  o2[o2.length] = '<a:font script="Thaa" typeface="MV Boli"/>';
  o2[o2.length] = '<a:font script="Deva" typeface="Mangal"/>';
  o2[o2.length] = '<a:font script="Telu" typeface="Gautami"/>';
  o2[o2.length] = '<a:font script="Taml" typeface="Latha"/>';
  o2[o2.length] = '<a:font script="Syrc" typeface="Estrangelo Edessa"/>';
  o2[o2.length] = '<a:font script="Orya" typeface="Kalinga"/>';
  o2[o2.length] = '<a:font script="Mlym" typeface="Kartika"/>';
  o2[o2.length] = '<a:font script="Laoo" typeface="DokChampa"/>';
  o2[o2.length] = '<a:font script="Sinh" typeface="Iskoola Pota"/>';
  o2[o2.length] = '<a:font script="Mong" typeface="Mongolian Baiti"/>';
  o2[o2.length] = '<a:font script="Viet" typeface="Times New Roman"/>';
  o2[o2.length] = '<a:font script="Uigh" typeface="Microsoft Uighur"/>';
  o2[o2.length] = '<a:font script="Geor" typeface="Sylfaen"/>';
  o2[o2.length] = "</a:majorFont>";
  o2[o2.length] = "<a:minorFont>";
  o2[o2.length] = '<a:latin typeface="Calibri"/>';
  o2[o2.length] = '<a:ea typeface=""/>';
  o2[o2.length] = '<a:cs typeface=""/>';
  o2[o2.length] = '<a:font script="Jpan" typeface="\uFF2D\uFF33 \uFF30\u30B4\u30B7\u30C3\u30AF"/>';
  o2[o2.length] = '<a:font script="Hang" typeface="\uB9D1\uC740 \uACE0\uB515"/>';
  o2[o2.length] = '<a:font script="Hans" typeface="\u5B8B\u4F53"/>';
  o2[o2.length] = '<a:font script="Hant" typeface="\u65B0\u7D30\u660E\u9AD4"/>';
  o2[o2.length] = '<a:font script="Arab" typeface="Arial"/>';
  o2[o2.length] = '<a:font script="Hebr" typeface="Arial"/>';
  o2[o2.length] = '<a:font script="Thai" typeface="Tahoma"/>';
  o2[o2.length] = '<a:font script="Ethi" typeface="Nyala"/>';
  o2[o2.length] = '<a:font script="Beng" typeface="Vrinda"/>';
  o2[o2.length] = '<a:font script="Gujr" typeface="Shruti"/>';
  o2[o2.length] = '<a:font script="Khmr" typeface="DaunPenh"/>';
  o2[o2.length] = '<a:font script="Knda" typeface="Tunga"/>';
  o2[o2.length] = '<a:font script="Guru" typeface="Raavi"/>';
  o2[o2.length] = '<a:font script="Cans" typeface="Euphemia"/>';
  o2[o2.length] = '<a:font script="Cher" typeface="Plantagenet Cherokee"/>';
  o2[o2.length] = '<a:font script="Yiii" typeface="Microsoft Yi Baiti"/>';
  o2[o2.length] = '<a:font script="Tibt" typeface="Microsoft Himalaya"/>';
  o2[o2.length] = '<a:font script="Thaa" typeface="MV Boli"/>';
  o2[o2.length] = '<a:font script="Deva" typeface="Mangal"/>';
  o2[o2.length] = '<a:font script="Telu" typeface="Gautami"/>';
  o2[o2.length] = '<a:font script="Taml" typeface="Latha"/>';
  o2[o2.length] = '<a:font script="Syrc" typeface="Estrangelo Edessa"/>';
  o2[o2.length] = '<a:font script="Orya" typeface="Kalinga"/>';
  o2[o2.length] = '<a:font script="Mlym" typeface="Kartika"/>';
  o2[o2.length] = '<a:font script="Laoo" typeface="DokChampa"/>';
  o2[o2.length] = '<a:font script="Sinh" typeface="Iskoola Pota"/>';
  o2[o2.length] = '<a:font script="Mong" typeface="Mongolian Baiti"/>';
  o2[o2.length] = '<a:font script="Viet" typeface="Arial"/>';
  o2[o2.length] = '<a:font script="Uigh" typeface="Microsoft Uighur"/>';
  o2[o2.length] = '<a:font script="Geor" typeface="Sylfaen"/>';
  o2[o2.length] = "</a:minorFont>";
  o2[o2.length] = "</a:fontScheme>";
  o2[o2.length] = '<a:fmtScheme name="Office">';
  o2[o2.length] = "<a:fillStyleLst>";
  o2[o2.length] = '<a:solidFill><a:schemeClr val="phClr"/></a:solidFill>';
  o2[o2.length] = '<a:gradFill rotWithShape="1">';
  o2[o2.length] = "<a:gsLst>";
  o2[o2.length] = '<a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="50000"/><a:satMod val="300000"/></a:schemeClr></a:gs>';
  o2[o2.length] = '<a:gs pos="35000"><a:schemeClr val="phClr"><a:tint val="37000"/><a:satMod val="300000"/></a:schemeClr></a:gs>';
  o2[o2.length] = '<a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="15000"/><a:satMod val="350000"/></a:schemeClr></a:gs>';
  o2[o2.length] = "</a:gsLst>";
  o2[o2.length] = '<a:lin ang="16200000" scaled="1"/>';
  o2[o2.length] = "</a:gradFill>";
  o2[o2.length] = '<a:gradFill rotWithShape="1">';
  o2[o2.length] = "<a:gsLst>";
  o2[o2.length] = '<a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="100000"/><a:shade val="100000"/><a:satMod val="130000"/></a:schemeClr></a:gs>';
  o2[o2.length] = '<a:gs pos="100000"><a:schemeClr val="phClr"><a:tint val="50000"/><a:shade val="100000"/><a:satMod val="350000"/></a:schemeClr></a:gs>';
  o2[o2.length] = "</a:gsLst>";
  o2[o2.length] = '<a:lin ang="16200000" scaled="0"/>';
  o2[o2.length] = "</a:gradFill>";
  o2[o2.length] = "</a:fillStyleLst>";
  o2[o2.length] = "<a:lnStyleLst>";
  o2[o2.length] = '<a:ln w="9525" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"><a:shade val="95000"/><a:satMod val="105000"/></a:schemeClr></a:solidFill><a:prstDash val="solid"/></a:ln>';
  o2[o2.length] = '<a:ln w="25400" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln>';
  o2[o2.length] = '<a:ln w="38100" cap="flat" cmpd="sng" algn="ctr"><a:solidFill><a:schemeClr val="phClr"/></a:solidFill><a:prstDash val="solid"/></a:ln>';
  o2[o2.length] = "</a:lnStyleLst>";
  o2[o2.length] = "<a:effectStyleLst>";
  o2[o2.length] = "<a:effectStyle>";
  o2[o2.length] = "<a:effectLst>";
  o2[o2.length] = '<a:outerShdw blurRad="40000" dist="20000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="38000"/></a:srgbClr></a:outerShdw>';
  o2[o2.length] = "</a:effectLst>";
  o2[o2.length] = "</a:effectStyle>";
  o2[o2.length] = "<a:effectStyle>";
  o2[o2.length] = "<a:effectLst>";
  o2[o2.length] = '<a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw>';
  o2[o2.length] = "</a:effectLst>";
  o2[o2.length] = "</a:effectStyle>";
  o2[o2.length] = "<a:effectStyle>";
  o2[o2.length] = "<a:effectLst>";
  o2[o2.length] = '<a:outerShdw blurRad="40000" dist="23000" dir="5400000" rotWithShape="0"><a:srgbClr val="000000"><a:alpha val="35000"/></a:srgbClr></a:outerShdw>';
  o2[o2.length] = "</a:effectLst>";
  o2[o2.length] = '<a:scene3d><a:camera prst="orthographicFront"><a:rot lat="0" lon="0" rev="0"/></a:camera><a:lightRig rig="threePt" dir="t"><a:rot lat="0" lon="0" rev="1200000"/></a:lightRig></a:scene3d>';
  o2[o2.length] = '<a:sp3d><a:bevelT w="63500" h="25400"/></a:sp3d>';
  o2[o2.length] = "</a:effectStyle>";
  o2[o2.length] = "</a:effectStyleLst>";
  o2[o2.length] = "<a:bgFillStyleLst>";
  o2[o2.length] = '<a:solidFill><a:schemeClr val="phClr"/></a:solidFill>';
  o2[o2.length] = '<a:gradFill rotWithShape="1">';
  o2[o2.length] = "<a:gsLst>";
  o2[o2.length] = '<a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="40000"/><a:satMod val="350000"/></a:schemeClr></a:gs>';
  o2[o2.length] = '<a:gs pos="40000"><a:schemeClr val="phClr"><a:tint val="45000"/><a:shade val="99000"/><a:satMod val="350000"/></a:schemeClr></a:gs>';
  o2[o2.length] = '<a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="20000"/><a:satMod val="255000"/></a:schemeClr></a:gs>';
  o2[o2.length] = "</a:gsLst>";
  o2[o2.length] = '<a:path path="circle"><a:fillToRect l="50000" t="-80000" r="50000" b="180000"/></a:path>';
  o2[o2.length] = "</a:gradFill>";
  o2[o2.length] = '<a:gradFill rotWithShape="1">';
  o2[o2.length] = "<a:gsLst>";
  o2[o2.length] = '<a:gs pos="0"><a:schemeClr val="phClr"><a:tint val="80000"/><a:satMod val="300000"/></a:schemeClr></a:gs>';
  o2[o2.length] = '<a:gs pos="100000"><a:schemeClr val="phClr"><a:shade val="30000"/><a:satMod val="200000"/></a:schemeClr></a:gs>';
  o2[o2.length] = "</a:gsLst>";
  o2[o2.length] = '<a:path path="circle"><a:fillToRect l="50000" t="50000" r="50000" b="50000"/></a:path>';
  o2[o2.length] = "</a:gradFill>";
  o2[o2.length] = "</a:bgFillStyleLst>";
  o2[o2.length] = "</a:fmtScheme>";
  o2[o2.length] = "</a:themeElements>";
  o2[o2.length] = "<a:objectDefaults>";
  o2[o2.length] = "<a:spDef>";
  o2[o2.length] = '<a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx="1"><a:schemeClr val="accent1"/></a:lnRef><a:fillRef idx="3"><a:schemeClr val="accent1"/></a:fillRef><a:effectRef idx="2"><a:schemeClr val="accent1"/></a:effectRef><a:fontRef idx="minor"><a:schemeClr val="lt1"/></a:fontRef></a:style>';
  o2[o2.length] = "</a:spDef>";
  o2[o2.length] = "<a:lnDef>";
  o2[o2.length] = '<a:spPr/><a:bodyPr/><a:lstStyle/><a:style><a:lnRef idx="2"><a:schemeClr val="accent1"/></a:lnRef><a:fillRef idx="0"><a:schemeClr val="accent1"/></a:fillRef><a:effectRef idx="1"><a:schemeClr val="accent1"/></a:effectRef><a:fontRef idx="minor"><a:schemeClr val="tx1"/></a:fontRef></a:style>';
  o2[o2.length] = "</a:lnDef>";
  o2[o2.length] = "</a:objectDefaults>";
  o2[o2.length] = "<a:extraClrSchemeLst/>";
  o2[o2.length] = "</a:theme>";
  return o2.join("");
}
function parse_Theme(blob, length, opts) {
  var end = blob.l + length;
  var dwThemeVersion = blob.read_shift(4);
  if (dwThemeVersion === 124226)
    return;
  if (!opts.cellStyles) {
    blob.l = end;
    return;
  }
  var data = blob.slice(blob.l);
  blob.l = end;
  var zip;
  try {
    zip = zip_read(data, { type: "array" });
  } catch (e) {
    return;
  }
  var themeXML = getzipstr(zip, "theme/theme/theme1.xml", true);
  if (!themeXML)
    return;
  return parse_theme_xml(themeXML, opts);
}
function parse_ColorTheme(blob) {
  return blob.read_shift(4);
}
function parse_FullColorExt(blob) {
  var o2 = {};
  o2.xclrType = blob.read_shift(2);
  o2.nTintShade = blob.read_shift(2);
  switch (o2.xclrType) {
    case 0:
      blob.l += 4;
      break;
    case 1:
      o2.xclrValue = parse_IcvXF(blob, 4);
      break;
    case 2:
      o2.xclrValue = parse_LongRGBA(blob, 4);
      break;
    case 3:
      o2.xclrValue = parse_ColorTheme(blob, 4);
      break;
    case 4:
      blob.l += 4;
      break;
  }
  blob.l += 8;
  return o2;
}
function parse_IcvXF(blob, length) {
  return parsenoop(blob, length);
}
function parse_XFExtGradient(blob, length) {
  return parsenoop(blob, length);
}
function parse_ExtProp(blob) {
  var extType = blob.read_shift(2);
  var cb = blob.read_shift(2) - 4;
  var o2 = [extType];
  switch (extType) {
    case 4:
    case 5:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 13:
      o2[1] = parse_FullColorExt(blob, cb);
      break;
    case 6:
      o2[1] = parse_XFExtGradient(blob, cb);
      break;
    case 14:
    case 15:
      o2[1] = blob.read_shift(cb === 1 ? 1 : 2);
      break;
    default:
      throw new Error("Unrecognized ExtProp type: " + extType + " " + cb);
  }
  return o2;
}
function parse_XFExt(blob, length) {
  var end = blob.l + length;
  blob.l += 2;
  var ixfe = blob.read_shift(2);
  blob.l += 2;
  var cexts = blob.read_shift(2);
  var ext = [];
  while (cexts-- > 0)
    ext.push(parse_ExtProp(blob, end - blob.l));
  return { ixfe, ext };
}
function update_xfext(xf, xfext) {
  xfext.forEach(function(xfe) {
    switch (xfe[0]) {
      case 4:
        break;
      case 5:
        break;
      case 6:
        break;
      case 7:
        break;
      case 8:
        break;
      case 9:
        break;
      case 10:
        break;
      case 11:
        break;
      case 13:
        break;
      case 14:
        break;
      case 15:
        break;
    }
  });
}
function parse_BrtMdtinfo(data, length) {
  return {
    flags: data.read_shift(4),
    version: data.read_shift(4),
    name: parse_XLWideString(data, length - 8)
  };
}
function write_BrtMdtinfo(data) {
  var o2 = new_buf(12 + 2 * data.name.length);
  o2.write_shift(4, data.flags);
  o2.write_shift(4, data.version);
  write_XLWideString(data.name, o2);
  return o2.slice(0, o2.l);
}
function parse_BrtMdb(data) {
  var out = [];
  var cnt = data.read_shift(4);
  while (cnt-- > 0)
    out.push([data.read_shift(4), data.read_shift(4)]);
  return out;
}
function write_BrtMdb(mdb) {
  var o2 = new_buf(4 + 8 * mdb.length);
  o2.write_shift(4, mdb.length);
  for (var i2 = 0; i2 < mdb.length; ++i2) {
    o2.write_shift(4, mdb[i2][0]);
    o2.write_shift(4, mdb[i2][1]);
  }
  return o2;
}
function write_BrtBeginEsfmd(cnt, name) {
  var o2 = new_buf(8 + 2 * name.length);
  o2.write_shift(4, cnt);
  write_XLWideString(name, o2);
  return o2.slice(0, o2.l);
}
function parse_BrtBeginEsmdb(data) {
  data.l += 4;
  return data.read_shift(4) != 0;
}
function write_BrtBeginEsmdb(cnt, cm) {
  var o2 = new_buf(8);
  o2.write_shift(4, cnt);
  o2.write_shift(4, cm ? 1 : 0);
  return o2;
}
function parse_xlmeta_bin(data, name, _opts) {
  var out = { Types: [], Cell: [], Value: [] };
  var opts = _opts || {};
  var state = [];
  var pass = false;
  var metatype = 2;
  recordhopper(data, function(val, R2, RT) {
    switch (RT) {
      case 335:
        out.Types.push({ name: val.name });
        break;
      case 51:
        val.forEach(function(r) {
          if (metatype == 1)
            out.Cell.push({ type: out.Types[r[0] - 1].name, index: r[1] });
          else if (metatype == 0)
            out.Value.push({ type: out.Types[r[0] - 1].name, index: r[1] });
        });
        break;
      case 337:
        metatype = val ? 1 : 0;
        break;
      case 338:
        metatype = 2;
        break;
      case 35:
        state.push(RT);
        pass = true;
        break;
      case 36:
        state.pop();
        pass = false;
        break;
      default:
        if (R2.T) {
        } else if (!pass || opts.WTF && state[state.length - 1] != 35)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  });
  return out;
}
function write_xlmeta_bin() {
  var ba = buf_array();
  write_record(ba, 332);
  write_record(ba, 334, write_UInt32LE(1));
  write_record(ba, 335, write_BrtMdtinfo({
    name: "XLDAPR",
    version: 12e4,
    flags: 3496657072
  }));
  write_record(ba, 336);
  write_record(ba, 339, write_BrtBeginEsfmd(1, "XLDAPR"));
  write_record(ba, 52);
  write_record(ba, 35, write_UInt32LE(514));
  write_record(ba, 4096, write_UInt32LE(0));
  write_record(ba, 4097, writeuint16(1));
  write_record(ba, 36);
  write_record(ba, 53);
  write_record(ba, 340);
  write_record(ba, 337, write_BrtBeginEsmdb(1, true));
  write_record(ba, 51, write_BrtMdb([[1, 0]]));
  write_record(ba, 338);
  write_record(ba, 333);
  return ba.end();
}
function parse_xlmeta_xml(data, name, opts) {
  var out = { Types: [], Cell: [], Value: [] };
  if (!data)
    return out;
  var pass = false;
  var metatype = 2;
  var lastmeta;
  data.replace(tagregex, function(x2) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<?xml":
        break;
      case "<metadata":
      case "</metadata>":
        break;
      case "<metadataTypes":
      case "</metadataTypes>":
        break;
      case "<metadataType":
        out.Types.push({ name: y2.name });
        break;
      case "</metadataType>":
        break;
      case "<futureMetadata":
        for (var j2 = 0; j2 < out.Types.length; ++j2)
          if (out.Types[j2].name == y2.name)
            lastmeta = out.Types[j2];
        break;
      case "</futureMetadata>":
        break;
      case "<bk>":
        break;
      case "</bk>":
        break;
      case "<rc":
        if (metatype == 1)
          out.Cell.push({ type: out.Types[y2.t - 1].name, index: +y2.v });
        else if (metatype == 0)
          out.Value.push({ type: out.Types[y2.t - 1].name, index: +y2.v });
        break;
      case "</rc>":
        break;
      case "<cellMetadata":
        metatype = 1;
        break;
      case "</cellMetadata>":
        metatype = 2;
        break;
      case "<valueMetadata":
        metatype = 0;
        break;
      case "</valueMetadata>":
        metatype = 2;
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
      case "<extLst/>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      case "<rvb":
        if (!lastmeta)
          break;
        if (!lastmeta.offsets)
          lastmeta.offsets = [];
        lastmeta.offsets.push(+y2.i);
        break;
      default:
        if (!pass && opts.WTF)
          throw new Error("unrecognized " + y2[0] + " in metadata");
    }
    return x2;
  });
  return out;
}
function write_xlmeta_xml() {
  var o2 = [XML_HEADER];
  o2.push('<metadata xmlns="http://schemas.openxmlformats.org/spreadsheetml/2006/main" xmlns:xlrd="http://schemas.microsoft.com/office/spreadsheetml/2017/richdata" xmlns:xda="http://schemas.microsoft.com/office/spreadsheetml/2017/dynamicarray">\n  <metadataTypes count="1">\n    <metadataType name="XLDAPR" minSupportedVersion="120000" copy="1" pasteAll="1" pasteValues="1" merge="1" splitFirst="1" rowColShift="1" clearFormats="1" clearComments="1" assign="1" coerce="1" cellMeta="1"/>\n  </metadataTypes>\n  <futureMetadata name="XLDAPR" count="1">\n    <bk>\n      <extLst>\n        <ext uri="{bdbb8cdc-fa1e-496e-a857-3c3f30c029c3}">\n          <xda:dynamicArrayProperties fDynamic="1" fCollapsed="0"/>\n        </ext>\n      </extLst>\n    </bk>\n  </futureMetadata>\n  <cellMetadata count="1">\n    <bk>\n      <rc t="1" v="0"/>\n    </bk>\n  </cellMetadata>\n</metadata>');
  return o2.join("");
}
function parse_cc_xml(data) {
  var d2 = [];
  if (!data)
    return d2;
  var i2 = 1;
  (data.match(tagregex) || []).forEach(function(x2) {
    var y2 = parsexmltag(x2);
    switch (y2[0]) {
      case "<?xml":
        break;
      case "<calcChain":
      case "<calcChain>":
      case "</calcChain>":
        break;
      case "<c":
        delete y2[0];
        if (y2.i)
          i2 = y2.i;
        else
          y2.i = i2;
        d2.push(y2);
        break;
    }
  });
  return d2;
}
function parse_BrtCalcChainItem$(data) {
  var out = {};
  out.i = data.read_shift(4);
  var cell = {};
  cell.r = data.read_shift(4);
  cell.c = data.read_shift(4);
  out.r = encode_cell(cell);
  var flags = data.read_shift(1);
  if (flags & 2)
    out.l = "1";
  if (flags & 8)
    out.a = "1";
  return out;
}
function parse_cc_bin(data, name, opts) {
  var out = [];
  var pass = false;
  recordhopper(data, function hopper_cc(val, R2, RT) {
    switch (RT) {
      case 63:
        out.push(val);
        break;
      default:
        if (R2.T) {
        } else if (!pass || opts.WTF)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  });
  return out;
}
function parse_xlink_xml() {
}
function parse_xlink_bin(data, rel, name, _opts) {
  if (!data)
    return data;
  var opts = _opts || {};
  var pass = false, end = false;
  recordhopper(data, function xlink_parse(val, R2, RT) {
    if (end)
      return;
    switch (RT) {
      case 359:
      case 363:
      case 364:
      case 366:
      case 367:
      case 368:
      case 369:
      case 370:
      case 371:
      case 472:
      case 577:
      case 578:
      case 579:
      case 580:
      case 581:
      case 582:
      case 583:
      case 584:
      case 585:
      case 586:
      case 587:
        break;
      case 35:
        pass = true;
        break;
      case 36:
        pass = false;
        break;
      default:
        if (R2.T) {
        } else if (!pass || opts.WTF)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  }, opts);
}
function parse_drawing(data, rels) {
  if (!data)
    return "??";
  var id = (data.match(/<c:chart [^>]*r:id="([^"]*)"/) || ["", ""])[1];
  return rels["!id"][id].Target;
}
var _shapeid = 1024;
function write_comments_vml(rId, comments) {
  var csize = [21600, 21600];
  var bbox = ["m0,0l0", csize[1], csize[0], csize[1], csize[0], "0xe"].join(",");
  var o2 = [
    writextag("xml", null, { "xmlns:v": XLMLNS.v, "xmlns:o": XLMLNS.o, "xmlns:x": XLMLNS.x, "xmlns:mv": XLMLNS.mv }).replace(/\/>/, ">"),
    writextag("o:shapelayout", writextag("o:idmap", null, { "v:ext": "edit", "data": rId }), { "v:ext": "edit" }),
    writextag("v:shapetype", [
      writextag("v:stroke", null, { joinstyle: "miter" }),
      writextag("v:path", null, { gradientshapeok: "t", "o:connecttype": "rect" })
    ].join(""), { id: "_x0000_t202", "o:spt": 202, coordsize: csize.join(","), path: bbox })
  ];
  while (_shapeid < rId * 1e3)
    _shapeid += 1e3;
  comments.forEach(function(x2) {
    var c2 = decode_cell(x2[0]);
    var fillopts = (
      /*::(*/
      { "color2": "#BEFF82", "type": "gradient" }
    );
    if (fillopts.type == "gradient")
      fillopts.angle = "-180";
    var fillparm = fillopts.type == "gradient" ? writextag("o:fill", null, { type: "gradientUnscaled", "v:ext": "view" }) : null;
    var fillxml = writextag("v:fill", fillparm, fillopts);
    var shadata = { on: "t", "obscured": "t" };
    ++_shapeid;
    o2 = o2.concat([
      "<v:shape" + wxt_helper({
        id: "_x0000_s" + _shapeid,
        type: "#_x0000_t202",
        style: "position:absolute; margin-left:80pt;margin-top:5pt;width:104pt;height:64pt;z-index:10" + (x2[1].hidden ? ";visibility:hidden" : ""),
        fillcolor: "#ECFAD4",
        strokecolor: "#edeaa1"
      }) + ">",
      fillxml,
      writextag("v:shadow", null, shadata),
      writextag("v:path", null, { "o:connecttype": "none" }),
      '<v:textbox><div style="text-align:left"></div></v:textbox>',
      '<x:ClientData ObjectType="Note">',
      "<x:MoveWithCells/>",
      "<x:SizeWithCells/>",
      /* Part 4 19.4.2.3 Anchor (Anchor) */
      writetag("x:Anchor", [c2.c + 1, 0, c2.r + 1, 0, c2.c + 3, 20, c2.r + 5, 20].join(",")),
      writetag("x:AutoFill", "False"),
      writetag("x:Row", String(c2.r)),
      writetag("x:Column", String(c2.c)),
      x2[1].hidden ? "" : "<x:Visible/>",
      "</x:ClientData>",
      "</v:shape>"
    ]);
  });
  o2.push("</xml>");
  return o2.join("");
}
function sheet_insert_comments(sheet, comments, threaded, people) {
  var dense = Array.isArray(sheet);
  var cell;
  comments.forEach(function(comment) {
    var r = decode_cell(comment.ref);
    if (dense) {
      if (!sheet[r.r])
        sheet[r.r] = [];
      cell = sheet[r.r][r.c];
    } else
      cell = sheet[comment.ref];
    if (!cell) {
      cell = { t: "z" };
      if (dense)
        sheet[r.r][r.c] = cell;
      else
        sheet[comment.ref] = cell;
      var range = safe_decode_range(sheet["!ref"] || "BDWGO1000001:A1");
      if (range.s.r > r.r)
        range.s.r = r.r;
      if (range.e.r < r.r)
        range.e.r = r.r;
      if (range.s.c > r.c)
        range.s.c = r.c;
      if (range.e.c < r.c)
        range.e.c = r.c;
      var encoded = encode_range(range);
      if (encoded !== sheet["!ref"])
        sheet["!ref"] = encoded;
    }
    if (!cell.c)
      cell.c = [];
    var o2 = { a: comment.author, t: comment.t, r: comment.r, T: threaded };
    if (comment.h)
      o2.h = comment.h;
    for (var i2 = cell.c.length - 1; i2 >= 0; --i2) {
      if (!threaded && cell.c[i2].T)
        return;
      if (threaded && !cell.c[i2].T)
        cell.c.splice(i2, 1);
    }
    if (threaded && people)
      for (i2 = 0; i2 < people.length; ++i2) {
        if (o2.a == people[i2].id) {
          o2.a = people[i2].name || o2.a;
          break;
        }
      }
    cell.c.push(o2);
  });
}
function parse_comments_xml(data, opts) {
  if (data.match(/<(?:\w+:)?comments *\/>/))
    return [];
  var authors = [];
  var commentList = [];
  var authtag = data.match(/<(?:\w+:)?authors>([\s\S]*)<\/(?:\w+:)?authors>/);
  if (authtag && authtag[1])
    authtag[1].split(/<\/\w*:?author>/).forEach(function(x2) {
      if (x2 === "" || x2.trim() === "")
        return;
      var a2 = x2.match(/<(?:\w+:)?author[^>]*>(.*)/);
      if (a2)
        authors.push(a2[1]);
    });
  var cmnttag = data.match(/<(?:\w+:)?commentList>([\s\S]*)<\/(?:\w+:)?commentList>/);
  if (cmnttag && cmnttag[1])
    cmnttag[1].split(/<\/\w*:?comment>/).forEach(function(x2) {
      if (x2 === "" || x2.trim() === "")
        return;
      var cm = x2.match(/<(?:\w+:)?comment[^>]*>/);
      if (!cm)
        return;
      var y2 = parsexmltag(cm[0]);
      var comment = { author: y2.authorId && authors[y2.authorId] || "sheetjsghost", ref: y2.ref, guid: y2.guid };
      var cell = decode_cell(y2.ref);
      if (opts.sheetRows && opts.sheetRows <= cell.r)
        return;
      var textMatch = x2.match(/<(?:\w+:)?text>([\s\S]*)<\/(?:\w+:)?text>/);
      var rt2 = !!textMatch && !!textMatch[1] && parse_si(textMatch[1]) || { r: "", t: "", h: "" };
      comment.r = rt2.r;
      if (rt2.r == "<t></t>")
        rt2.t = rt2.h = "";
      comment.t = (rt2.t || "").replace(/\r\n/g, "\n").replace(/\r/g, "\n");
      if (opts.cellHTML)
        comment.h = rt2.h;
      commentList.push(comment);
    });
  return commentList;
}
function write_comments_xml(data) {
  var o2 = [XML_HEADER, writextag("comments", null, { "xmlns": XMLNS_main[0] })];
  var iauthor = [];
  o2.push("<authors>");
  data.forEach(function(x2) {
    x2[1].forEach(function(w2) {
      var a2 = escapexml(w2.a);
      if (iauthor.indexOf(a2) == -1) {
        iauthor.push(a2);
        o2.push("<author>" + a2 + "</author>");
      }
      if (w2.T && w2.ID && iauthor.indexOf("tc=" + w2.ID) == -1) {
        iauthor.push("tc=" + w2.ID);
        o2.push("<author>tc=" + w2.ID + "</author>");
      }
    });
  });
  if (iauthor.length == 0) {
    iauthor.push("SheetJ5");
    o2.push("<author>SheetJ5</author>");
  }
  o2.push("</authors>");
  o2.push("<commentList>");
  data.forEach(function(d2) {
    var lastauthor = 0, ts = [];
    if (d2[1][0] && d2[1][0].T && d2[1][0].ID)
      lastauthor = iauthor.indexOf("tc=" + d2[1][0].ID);
    else
      d2[1].forEach(function(c2) {
        if (c2.a)
          lastauthor = iauthor.indexOf(escapexml(c2.a));
        ts.push(c2.t || "");
      });
    o2.push('<comment ref="' + d2[0] + '" authorId="' + lastauthor + '"><text>');
    if (ts.length <= 1)
      o2.push(writetag("t", escapexml(ts[0] || "")));
    else {
      var t2 = "Comment:\n    " + ts[0] + "\n";
      for (var i2 = 1; i2 < ts.length; ++i2)
        t2 += "Reply:\n    " + ts[i2] + "\n";
      o2.push(writetag("t", escapexml(t2)));
    }
    o2.push("</text></comment>");
  });
  o2.push("</commentList>");
  if (o2.length > 2) {
    o2[o2.length] = "</comments>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
function parse_tcmnt_xml(data, opts) {
  var out = [];
  var pass = false, comment = {}, tidx = 0;
  data.replace(tagregex, function xml_tcmnt(x2, idx) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<?xml":
        break;
      case "<ThreadedComments":
        break;
      case "</ThreadedComments>":
        break;
      case "<threadedComment":
        comment = { author: y2.personId, guid: y2.id, ref: y2.ref, T: 1 };
        break;
      case "</threadedComment>":
        if (comment.t != null)
          out.push(comment);
        break;
      case "<text>":
      case "<text":
        tidx = idx + x2.length;
        break;
      case "</text>":
        comment.t = data.slice(tidx, idx).replace(/\r\n/g, "\n").replace(/\r/g, "\n");
        break;
      case "<mentions":
      case "<mentions>":
        pass = true;
        break;
      case "</mentions>":
        pass = false;
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
      case "<extLst/>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      default:
        if (!pass && opts.WTF)
          throw new Error("unrecognized " + y2[0] + " in threaded comments");
    }
    return x2;
  });
  return out;
}
function write_tcmnt_xml(comments, people, opts) {
  var o2 = [XML_HEADER, writextag("ThreadedComments", null, { "xmlns": XMLNS.TCMNT }).replace(/[\/]>/, ">")];
  comments.forEach(function(carr) {
    var rootid = "";
    (carr[1] || []).forEach(function(c2, idx) {
      if (!c2.T) {
        delete c2.ID;
        return;
      }
      if (c2.a && people.indexOf(c2.a) == -1)
        people.push(c2.a);
      var tcopts = {
        ref: carr[0],
        id: "{54EE7951-7262-4200-6969-" + ("000000000000" + opts.tcid++).slice(-12) + "}"
      };
      if (idx == 0)
        rootid = tcopts.id;
      else
        tcopts.parentId = rootid;
      c2.ID = tcopts.id;
      if (c2.a)
        tcopts.personId = "{54EE7950-7262-4200-6969-" + ("000000000000" + people.indexOf(c2.a)).slice(-12) + "}";
      o2.push(writextag("threadedComment", writetag("text", c2.t || ""), tcopts));
    });
  });
  o2.push("</ThreadedComments>");
  return o2.join("");
}
function parse_people_xml(data, opts) {
  var out = [];
  var pass = false;
  data.replace(tagregex, function xml_tcmnt(x2) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<?xml":
        break;
      case "<personList":
        break;
      case "</personList>":
        break;
      case "<person":
        out.push({ name: y2.displayname, id: y2.id });
        break;
      case "</person>":
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
      case "<extLst/>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      default:
        if (!pass && opts.WTF)
          throw new Error("unrecognized " + y2[0] + " in threaded comments");
    }
    return x2;
  });
  return out;
}
function write_people_xml(people) {
  var o2 = [XML_HEADER, writextag("personList", null, {
    "xmlns": XMLNS.TCMNT,
    "xmlns:x": XMLNS_main[0]
  }).replace(/[\/]>/, ">")];
  people.forEach(function(person, idx) {
    o2.push(writextag("person", null, {
      displayName: person,
      id: "{54EE7950-7262-4200-6969-" + ("000000000000" + idx).slice(-12) + "}",
      userId: person,
      providerId: "None"
    }));
  });
  o2.push("</personList>");
  return o2.join("");
}
function parse_BrtBeginComment(data) {
  var out = {};
  out.iauthor = data.read_shift(4);
  var rfx = parse_UncheckedRfX(data, 16);
  out.rfx = rfx.s;
  out.ref = encode_cell(rfx.s);
  data.l += 16;
  return out;
}
function write_BrtBeginComment(data, o2) {
  if (o2 == null)
    o2 = new_buf(36);
  o2.write_shift(4, data[1].iauthor);
  write_UncheckedRfX(data[0], o2);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  return o2;
}
var parse_BrtCommentAuthor = parse_XLWideString;
function write_BrtCommentAuthor(data) {
  return write_XLWideString(data.slice(0, 54));
}
function parse_comments_bin(data, opts) {
  var out = [];
  var authors = [];
  var c2 = {};
  var pass = false;
  recordhopper(data, function hopper_cmnt(val, R2, RT) {
    switch (RT) {
      case 632:
        authors.push(val);
        break;
      case 635:
        c2 = val;
        break;
      case 637:
        c2.t = val.t;
        c2.h = val.h;
        c2.r = val.r;
        break;
      case 636:
        c2.author = authors[c2.iauthor];
        delete c2.iauthor;
        if (opts.sheetRows && c2.rfx && opts.sheetRows <= c2.rfx.r)
          break;
        if (!c2.t)
          c2.t = "";
        delete c2.rfx;
        out.push(c2);
        break;
      case 3072:
        break;
      case 35:
        pass = true;
        break;
      case 36:
        pass = false;
        break;
      case 37:
        break;
      case 38:
        break;
      default:
        if (R2.T) {
        } else if (!pass || opts.WTF)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  });
  return out;
}
function write_comments_bin(data) {
  var ba = buf_array();
  var iauthor = [];
  write_record(
    ba,
    628
    /* BrtBeginComments */
  );
  write_record(
    ba,
    630
    /* BrtBeginCommentAuthors */
  );
  data.forEach(function(comment) {
    comment[1].forEach(function(c2) {
      if (iauthor.indexOf(c2.a) > -1)
        return;
      iauthor.push(c2.a.slice(0, 54));
      write_record(ba, 632, write_BrtCommentAuthor(c2.a));
    });
  });
  write_record(
    ba,
    631
    /* BrtEndCommentAuthors */
  );
  write_record(
    ba,
    633
    /* BrtBeginCommentList */
  );
  data.forEach(function(comment) {
    comment[1].forEach(function(c2) {
      c2.iauthor = iauthor.indexOf(c2.a);
      var range = { s: decode_cell(comment[0]), e: decode_cell(comment[0]) };
      write_record(ba, 635, write_BrtBeginComment([range, c2]));
      if (c2.t && c2.t.length > 0)
        write_record(ba, 637, write_BrtCommentText(c2));
      write_record(
        ba,
        636
        /* BrtEndComment */
      );
      delete c2.iauthor;
    });
  });
  write_record(
    ba,
    634
    /* BrtEndCommentList */
  );
  write_record(
    ba,
    629
    /* BrtEndComments */
  );
  return ba.end();
}
var CT_VBA = "application/vnd.ms-office.vbaProject";
function make_vba_xls(cfb) {
  var newcfb = CFB.utils.cfb_new({ root: "R" });
  cfb.FullPaths.forEach(function(p2, i2) {
    if (p2.slice(-1) === "/" || !p2.match(/_VBA_PROJECT_CUR/))
      return;
    var newpath = p2.replace(/^[^\/]*/, "R").replace(/\/_VBA_PROJECT_CUR\u0000*/, "");
    CFB.utils.cfb_add(newcfb, newpath, cfb.FileIndex[i2].content);
  });
  return CFB.write(newcfb);
}
function fill_vba_xls(cfb, vba) {
  vba.FullPaths.forEach(function(p2, i2) {
    if (i2 == 0)
      return;
    var newpath = p2.replace(/[^\/]*[\/]/, "/_VBA_PROJECT_CUR/");
    if (newpath.slice(-1) !== "/")
      CFB.utils.cfb_add(cfb, newpath, vba.FileIndex[i2].content);
  });
}
var VBAFMTS = ["xlsb", "xlsm", "xlam", "biff8", "xla"];
function parse_ds_bin() {
  return { "!type": "dialog" };
}
function parse_ds_xml() {
  return { "!type": "dialog" };
}
function parse_ms_bin() {
  return { "!type": "macro" };
}
function parse_ms_xml() {
  return { "!type": "macro" };
}
var rc_to_a1 = /* @__PURE__ */ function() {
  var rcregex = /(^|[^A-Za-z_])R(\[?-?\d+\]|[1-9]\d*|)C(\[?-?\d+\]|[1-9]\d*|)(?![A-Za-z0-9_])/g;
  var rcbase = { r: 0, c: 0 };
  function rcfunc($$, $1, $22, $3) {
    var cRel = false, rRel = false;
    if ($22.length == 0)
      rRel = true;
    else if ($22.charAt(0) == "[") {
      rRel = true;
      $22 = $22.slice(1, -1);
    }
    if ($3.length == 0)
      cRel = true;
    else if ($3.charAt(0) == "[") {
      cRel = true;
      $3 = $3.slice(1, -1);
    }
    var R2 = $22.length > 0 ? parseInt($22, 10) | 0 : 0, C2 = $3.length > 0 ? parseInt($3, 10) | 0 : 0;
    if (cRel)
      C2 += rcbase.c;
    else
      --C2;
    if (rRel)
      R2 += rcbase.r;
    else
      --R2;
    return $1 + (cRel ? "" : "$") + encode_col(C2) + (rRel ? "" : "$") + encode_row(R2);
  }
  return function rc_to_a12(fstr, base) {
    rcbase = base;
    return fstr.replace(rcregex, rcfunc);
  };
}();
var crefregex = /(^|[^._A-Z0-9])([$]?)([A-Z]{1,2}|[A-W][A-Z]{2}|X[A-E][A-Z]|XF[A-D])([$]?)(10[0-3]\d{4}|104[0-7]\d{3}|1048[0-4]\d{2}|10485[0-6]\d|104857[0-6]|[1-9]\d{0,5})(?![_.\(A-Za-z0-9])/g;
var a1_to_rc = /* @__PURE__ */ function() {
  return function a1_to_rc2(fstr, base) {
    return fstr.replace(crefregex, function($0, $1, $22, $3, $4, $5) {
      var c2 = decode_col($3) - ($22 ? 0 : base.c);
      var r = decode_row($5) - ($4 ? 0 : base.r);
      var R2 = r == 0 ? "" : !$4 ? "[" + r + "]" : r + 1;
      var C2 = c2 == 0 ? "" : !$22 ? "[" + c2 + "]" : c2 + 1;
      return $1 + "R" + R2 + "C" + C2;
    });
  };
}();
function shift_formula_str(f2, delta) {
  return f2.replace(crefregex, function($0, $1, $22, $3, $4, $5) {
    return $1 + ($22 == "$" ? $22 + $3 : encode_col(decode_col($3) + delta.c)) + ($4 == "$" ? $4 + $5 : encode_row(decode_row($5) + delta.r));
  });
}
function shift_formula_xlsx(f2, range, cell) {
  var r = decode_range(range), s2 = r.s, c2 = decode_cell(cell);
  var delta = { r: c2.r - s2.r, c: c2.c - s2.c };
  return shift_formula_str(f2, delta);
}
function fuzzyfmla(f2) {
  if (f2.length == 1)
    return false;
  return true;
}
function _xlfn(f2) {
  return f2.replace(/_xlfn\./g, "");
}
function parseread1(blob) {
  blob.l += 1;
  return;
}
function parse_ColRelU(blob, length) {
  var c2 = blob.read_shift(length == 1 ? 1 : 2);
  return [c2 & 16383, c2 >> 14 & 1, c2 >> 15 & 1];
}
function parse_RgceArea(blob, length, opts) {
  var w2 = 2;
  if (opts) {
    if (opts.biff >= 2 && opts.biff <= 5)
      return parse_RgceArea_BIFF2(blob, length, opts);
    else if (opts.biff == 12)
      w2 = 4;
  }
  var r = blob.read_shift(w2), R2 = blob.read_shift(w2);
  var c2 = parse_ColRelU(blob, 2);
  var C2 = parse_ColRelU(blob, 2);
  return { s: { r, c: c2[0], cRel: c2[1], rRel: c2[2] }, e: { r: R2, c: C2[0], cRel: C2[1], rRel: C2[2] } };
}
function parse_RgceArea_BIFF2(blob) {
  var r = parse_ColRelU(blob, 2), R2 = parse_ColRelU(blob, 2);
  var c2 = blob.read_shift(1);
  var C2 = blob.read_shift(1);
  return { s: { r: r[0], c: c2, cRel: r[1], rRel: r[2] }, e: { r: R2[0], c: C2, cRel: R2[1], rRel: R2[2] } };
}
function parse_RgceAreaRel(blob, length, opts) {
  if (opts.biff < 8)
    return parse_RgceArea_BIFF2(blob, length, opts);
  var r = blob.read_shift(opts.biff == 12 ? 4 : 2), R2 = blob.read_shift(opts.biff == 12 ? 4 : 2);
  var c2 = parse_ColRelU(blob, 2);
  var C2 = parse_ColRelU(blob, 2);
  return { s: { r, c: c2[0], cRel: c2[1], rRel: c2[2] }, e: { r: R2, c: C2[0], cRel: C2[1], rRel: C2[2] } };
}
function parse_RgceLoc(blob, length, opts) {
  if (opts && opts.biff >= 2 && opts.biff <= 5)
    return parse_RgceLoc_BIFF2(blob, length, opts);
  var r = blob.read_shift(opts && opts.biff == 12 ? 4 : 2);
  var c2 = parse_ColRelU(blob, 2);
  return { r, c: c2[0], cRel: c2[1], rRel: c2[2] };
}
function parse_RgceLoc_BIFF2(blob) {
  var r = parse_ColRelU(blob, 2);
  var c2 = blob.read_shift(1);
  return { r: r[0], c: c2, cRel: r[1], rRel: r[2] };
}
function parse_RgceElfLoc(blob) {
  var r = blob.read_shift(2);
  var c2 = blob.read_shift(2);
  return { r, c: c2 & 255, fQuoted: !!(c2 & 16384), cRel: c2 >> 15, rRel: c2 >> 15 };
}
function parse_RgceLocRel(blob, length, opts) {
  var biff = opts && opts.biff ? opts.biff : 8;
  if (biff >= 2 && biff <= 5)
    return parse_RgceLocRel_BIFF2(blob, length, opts);
  var r = blob.read_shift(biff >= 12 ? 4 : 2);
  var cl = blob.read_shift(2);
  var cRel = (cl & 16384) >> 14, rRel = (cl & 32768) >> 15;
  cl &= 16383;
  if (rRel == 1)
    while (r > 524287)
      r -= 1048576;
  if (cRel == 1)
    while (cl > 8191)
      cl = cl - 16384;
  return { r, c: cl, cRel, rRel };
}
function parse_RgceLocRel_BIFF2(blob) {
  var rl = blob.read_shift(2);
  var c2 = blob.read_shift(1);
  var rRel = (rl & 32768) >> 15, cRel = (rl & 16384) >> 14;
  rl &= 16383;
  if (rRel == 1 && rl >= 8192)
    rl = rl - 16384;
  if (cRel == 1 && c2 >= 128)
    c2 = c2 - 256;
  return { r: rl, c: c2, cRel, rRel };
}
function parse_PtgArea(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  var area = parse_RgceArea(blob, opts.biff >= 2 && opts.biff <= 5 ? 6 : 8, opts);
  return [type, area];
}
function parse_PtgArea3d(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  var ixti = blob.read_shift(2, "i");
  var w2 = 8;
  if (opts)
    switch (opts.biff) {
      case 5:
        blob.l += 12;
        w2 = 6;
        break;
      case 12:
        w2 = 12;
        break;
    }
  var area = parse_RgceArea(blob, w2, opts);
  return [type, ixti, area];
}
function parse_PtgAreaErr(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  blob.l += opts && opts.biff > 8 ? 12 : opts.biff < 8 ? 6 : 8;
  return [type];
}
function parse_PtgAreaErr3d(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  var ixti = blob.read_shift(2);
  var w2 = 8;
  if (opts)
    switch (opts.biff) {
      case 5:
        blob.l += 12;
        w2 = 6;
        break;
      case 12:
        w2 = 12;
        break;
    }
  blob.l += w2;
  return [type, ixti];
}
function parse_PtgAreaN(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  var area = parse_RgceAreaRel(blob, length - 1, opts);
  return [type, area];
}
function parse_PtgArray(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  blob.l += opts.biff == 2 ? 6 : opts.biff == 12 ? 14 : 7;
  return [type];
}
function parse_PtgAttrBaxcel(blob) {
  var bitSemi = blob[blob.l + 1] & 1;
  var bitBaxcel = 1;
  blob.l += 4;
  return [bitSemi, bitBaxcel];
}
function parse_PtgAttrChoose(blob, length, opts) {
  blob.l += 2;
  var offset = blob.read_shift(opts && opts.biff == 2 ? 1 : 2);
  var o2 = [];
  for (var i2 = 0; i2 <= offset; ++i2)
    o2.push(blob.read_shift(opts && opts.biff == 2 ? 1 : 2));
  return o2;
}
function parse_PtgAttrGoto(blob, length, opts) {
  var bitGoto = blob[blob.l + 1] & 255 ? 1 : 0;
  blob.l += 2;
  return [bitGoto, blob.read_shift(opts && opts.biff == 2 ? 1 : 2)];
}
function parse_PtgAttrIf(blob, length, opts) {
  var bitIf = blob[blob.l + 1] & 255 ? 1 : 0;
  blob.l += 2;
  return [bitIf, blob.read_shift(opts && opts.biff == 2 ? 1 : 2)];
}
function parse_PtgAttrIfError(blob) {
  var bitIf = blob[blob.l + 1] & 255 ? 1 : 0;
  blob.l += 2;
  return [bitIf, blob.read_shift(2)];
}
function parse_PtgAttrSemi(blob, length, opts) {
  var bitSemi = blob[blob.l + 1] & 255 ? 1 : 0;
  blob.l += opts && opts.biff == 2 ? 3 : 4;
  return [bitSemi];
}
function parse_PtgAttrSpaceType(blob) {
  var type = blob.read_shift(1), cch = blob.read_shift(1);
  return [type, cch];
}
function parse_PtgAttrSpace(blob) {
  blob.read_shift(2);
  return parse_PtgAttrSpaceType(blob, 2);
}
function parse_PtgAttrSpaceSemi(blob) {
  blob.read_shift(2);
  return parse_PtgAttrSpaceType(blob, 2);
}
function parse_PtgRef(blob, length, opts) {
  var type = (blob[blob.l] & 96) >> 5;
  blob.l += 1;
  var loc = parse_RgceLoc(blob, 0, opts);
  return [type, loc];
}
function parse_PtgRefN(blob, length, opts) {
  var type = (blob[blob.l] & 96) >> 5;
  blob.l += 1;
  var loc = parse_RgceLocRel(blob, 0, opts);
  return [type, loc];
}
function parse_PtgRef3d(blob, length, opts) {
  var type = (blob[blob.l] & 96) >> 5;
  blob.l += 1;
  var ixti = blob.read_shift(2);
  if (opts && opts.biff == 5)
    blob.l += 12;
  var loc = parse_RgceLoc(blob, 0, opts);
  return [type, ixti, loc];
}
function parse_PtgFunc(blob, length, opts) {
  var type = (blob[blob.l] & 96) >> 5;
  blob.l += 1;
  var iftab = blob.read_shift(opts && opts.biff <= 3 ? 1 : 2);
  return [FtabArgc[iftab], Ftab[iftab], type];
}
function parse_PtgFuncVar(blob, length, opts) {
  var type = blob[blob.l++];
  var cparams = blob.read_shift(1), tab = opts && opts.biff <= 3 ? [type == 88 ? -1 : 0, blob.read_shift(1)] : parsetab(blob);
  return [cparams, (tab[0] === 0 ? Ftab : Cetab)[tab[1]]];
}
function parsetab(blob) {
  return [blob[blob.l + 1] >> 7, blob.read_shift(2) & 32767];
}
function parse_PtgAttrSum(blob, length, opts) {
  blob.l += opts && opts.biff == 2 ? 3 : 4;
  return;
}
function parse_PtgExp(blob, length, opts) {
  blob.l++;
  if (opts && opts.biff == 12)
    return [blob.read_shift(4, "i"), 0];
  var row = blob.read_shift(2);
  var col = blob.read_shift(opts && opts.biff == 2 ? 1 : 2);
  return [row, col];
}
function parse_PtgErr(blob) {
  blob.l++;
  return BErr[blob.read_shift(1)];
}
function parse_PtgInt(blob) {
  blob.l++;
  return blob.read_shift(2);
}
function parse_PtgBool(blob) {
  blob.l++;
  return blob.read_shift(1) !== 0;
}
function parse_PtgNum(blob) {
  blob.l++;
  return parse_Xnum(blob, 8);
}
function parse_PtgStr(blob, length, opts) {
  blob.l++;
  return parse_ShortXLUnicodeString(blob, length - 1, opts);
}
function parse_SerAr(blob, biff) {
  var val = [blob.read_shift(1)];
  if (biff == 12)
    switch (val[0]) {
      case 2:
        val[0] = 4;
        break;
      case 4:
        val[0] = 16;
        break;
      case 0:
        val[0] = 1;
        break;
      case 1:
        val[0] = 2;
        break;
    }
  switch (val[0]) {
    case 4:
      val[1] = parsebool(blob, 1) ? "TRUE" : "FALSE";
      if (biff != 12)
        blob.l += 7;
      break;
    case 37:
    case 16:
      val[1] = BErr[blob[blob.l]];
      blob.l += biff == 12 ? 4 : 8;
      break;
    case 0:
      blob.l += 8;
      break;
    case 1:
      val[1] = parse_Xnum(blob, 8);
      break;
    case 2:
      val[1] = parse_XLUnicodeString2(blob, 0, { biff: biff > 0 && biff < 8 ? 2 : biff });
      break;
    default:
      throw new Error("Bad SerAr: " + val[0]);
  }
  return val;
}
function parse_PtgExtraMem(blob, cce, opts) {
  var count = blob.read_shift(opts.biff == 12 ? 4 : 2);
  var out = [];
  for (var i2 = 0; i2 != count; ++i2)
    out.push((opts.biff == 12 ? parse_UncheckedRfX : parse_Ref8U)(blob, 8));
  return out;
}
function parse_PtgExtraArray(blob, length, opts) {
  var rows = 0, cols = 0;
  if (opts.biff == 12) {
    rows = blob.read_shift(4);
    cols = blob.read_shift(4);
  } else {
    cols = 1 + blob.read_shift(1);
    rows = 1 + blob.read_shift(2);
  }
  if (opts.biff >= 2 && opts.biff < 8) {
    --rows;
    if (--cols == 0)
      cols = 256;
  }
  for (var i2 = 0, o2 = []; i2 != rows && (o2[i2] = []); ++i2)
    for (var j2 = 0; j2 != cols; ++j2)
      o2[i2][j2] = parse_SerAr(blob, opts.biff);
  return o2;
}
function parse_PtgName(blob, length, opts) {
  var type = blob.read_shift(1) >>> 5 & 3;
  var w2 = !opts || opts.biff >= 8 ? 4 : 2;
  var nameindex = blob.read_shift(w2);
  switch (opts.biff) {
    case 2:
      blob.l += 5;
      break;
    case 3:
    case 4:
      blob.l += 8;
      break;
    case 5:
      blob.l += 12;
      break;
  }
  return [type, 0, nameindex];
}
function parse_PtgNameX(blob, length, opts) {
  if (opts.biff == 5)
    return parse_PtgNameX_BIFF5(blob, length, opts);
  var type = blob.read_shift(1) >>> 5 & 3;
  var ixti = blob.read_shift(2);
  var nameindex = blob.read_shift(4);
  return [type, ixti, nameindex];
}
function parse_PtgNameX_BIFF5(blob) {
  var type = blob.read_shift(1) >>> 5 & 3;
  var ixti = blob.read_shift(2, "i");
  blob.l += 8;
  var nameindex = blob.read_shift(2);
  blob.l += 12;
  return [type, ixti, nameindex];
}
function parse_PtgMemArea(blob, length, opts) {
  var type = blob.read_shift(1) >>> 5 & 3;
  blob.l += opts && opts.biff == 2 ? 3 : 4;
  var cce = blob.read_shift(opts && opts.biff == 2 ? 1 : 2);
  return [type, cce];
}
function parse_PtgMemFunc(blob, length, opts) {
  var type = blob.read_shift(1) >>> 5 & 3;
  var cce = blob.read_shift(opts && opts.biff == 2 ? 1 : 2);
  return [type, cce];
}
function parse_PtgRefErr(blob, length, opts) {
  var type = blob.read_shift(1) >>> 5 & 3;
  blob.l += 4;
  if (opts.biff < 8)
    blob.l--;
  if (opts.biff == 12)
    blob.l += 2;
  return [type];
}
function parse_PtgRefErr3d(blob, length, opts) {
  var type = (blob[blob.l++] & 96) >> 5;
  var ixti = blob.read_shift(2);
  var w2 = 4;
  if (opts)
    switch (opts.biff) {
      case 5:
        w2 = 15;
        break;
      case 12:
        w2 = 6;
        break;
    }
  blob.l += w2;
  return [type, ixti];
}
var parse_PtgMemErr = parsenoop;
var parse_PtgMemNoMem = parsenoop;
var parse_PtgTbl = parsenoop;
function parse_PtgElfLoc(blob, length, opts) {
  blob.l += 2;
  return [parse_RgceElfLoc(blob, 4, opts)];
}
function parse_PtgElfNoop(blob) {
  blob.l += 6;
  return [];
}
var parse_PtgElfCol = parse_PtgElfLoc;
var parse_PtgElfColS = parse_PtgElfNoop;
var parse_PtgElfColSV = parse_PtgElfNoop;
var parse_PtgElfColV = parse_PtgElfLoc;
function parse_PtgElfLel(blob) {
  blob.l += 2;
  return [parseuint16(blob), blob.read_shift(2) & 1];
}
var parse_PtgElfRadical = parse_PtgElfLoc;
var parse_PtgElfRadicalLel = parse_PtgElfLel;
var parse_PtgElfRadicalS = parse_PtgElfNoop;
var parse_PtgElfRw = parse_PtgElfLoc;
var parse_PtgElfRwV = parse_PtgElfLoc;
var PtgListRT = [
  "Data",
  "All",
  "Headers",
  "??",
  "?Data2",
  "??",
  "?DataHeaders",
  "??",
  "Totals",
  "??",
  "??",
  "??",
  "?DataTotals",
  "??",
  "??",
  "??",
  "?Current"
];
function parse_PtgList(blob) {
  blob.l += 2;
  var ixti = blob.read_shift(2);
  var flags = blob.read_shift(2);
  var idx = blob.read_shift(4);
  var c2 = blob.read_shift(2);
  var C2 = blob.read_shift(2);
  var rt2 = PtgListRT[flags >> 2 & 31];
  return { ixti, coltype: flags & 3, rt: rt2, idx, c: c2, C: C2 };
}
function parse_PtgSxName(blob) {
  blob.l += 2;
  return [blob.read_shift(4)];
}
function parse_PtgSheet(blob, length, opts) {
  blob.l += 5;
  blob.l += 2;
  blob.l += opts.biff == 2 ? 1 : 4;
  return ["PTGSHEET"];
}
function parse_PtgEndSheet(blob, length, opts) {
  blob.l += opts.biff == 2 ? 4 : 5;
  return ["PTGENDSHEET"];
}
function parse_PtgMemAreaN(blob) {
  var type = blob.read_shift(1) >>> 5 & 3;
  var cce = blob.read_shift(2);
  return [type, cce];
}
function parse_PtgMemNoMemN(blob) {
  var type = blob.read_shift(1) >>> 5 & 3;
  var cce = blob.read_shift(2);
  return [type, cce];
}
function parse_PtgAttrNoop(blob) {
  blob.l += 4;
  return [0, 0];
}
var PtgTypes = {
  /*::[*/
  1: { n: "PtgExp", f: parse_PtgExp },
  /*::[*/
  2: { n: "PtgTbl", f: parse_PtgTbl },
  /*::[*/
  3: { n: "PtgAdd", f: parseread1 },
  /*::[*/
  4: { n: "PtgSub", f: parseread1 },
  /*::[*/
  5: { n: "PtgMul", f: parseread1 },
  /*::[*/
  6: { n: "PtgDiv", f: parseread1 },
  /*::[*/
  7: { n: "PtgPower", f: parseread1 },
  /*::[*/
  8: { n: "PtgConcat", f: parseread1 },
  /*::[*/
  9: { n: "PtgLt", f: parseread1 },
  /*::[*/
  10: { n: "PtgLe", f: parseread1 },
  /*::[*/
  11: { n: "PtgEq", f: parseread1 },
  /*::[*/
  12: { n: "PtgGe", f: parseread1 },
  /*::[*/
  13: { n: "PtgGt", f: parseread1 },
  /*::[*/
  14: { n: "PtgNe", f: parseread1 },
  /*::[*/
  15: { n: "PtgIsect", f: parseread1 },
  /*::[*/
  16: { n: "PtgUnion", f: parseread1 },
  /*::[*/
  17: { n: "PtgRange", f: parseread1 },
  /*::[*/
  18: { n: "PtgUplus", f: parseread1 },
  /*::[*/
  19: { n: "PtgUminus", f: parseread1 },
  /*::[*/
  20: { n: "PtgPercent", f: parseread1 },
  /*::[*/
  21: { n: "PtgParen", f: parseread1 },
  /*::[*/
  22: { n: "PtgMissArg", f: parseread1 },
  /*::[*/
  23: { n: "PtgStr", f: parse_PtgStr },
  /*::[*/
  26: { n: "PtgSheet", f: parse_PtgSheet },
  /*::[*/
  27: { n: "PtgEndSheet", f: parse_PtgEndSheet },
  /*::[*/
  28: { n: "PtgErr", f: parse_PtgErr },
  /*::[*/
  29: { n: "PtgBool", f: parse_PtgBool },
  /*::[*/
  30: { n: "PtgInt", f: parse_PtgInt },
  /*::[*/
  31: { n: "PtgNum", f: parse_PtgNum },
  /*::[*/
  32: { n: "PtgArray", f: parse_PtgArray },
  /*::[*/
  33: { n: "PtgFunc", f: parse_PtgFunc },
  /*::[*/
  34: { n: "PtgFuncVar", f: parse_PtgFuncVar },
  /*::[*/
  35: { n: "PtgName", f: parse_PtgName },
  /*::[*/
  36: { n: "PtgRef", f: parse_PtgRef },
  /*::[*/
  37: { n: "PtgArea", f: parse_PtgArea },
  /*::[*/
  38: { n: "PtgMemArea", f: parse_PtgMemArea },
  /*::[*/
  39: { n: "PtgMemErr", f: parse_PtgMemErr },
  /*::[*/
  40: { n: "PtgMemNoMem", f: parse_PtgMemNoMem },
  /*::[*/
  41: { n: "PtgMemFunc", f: parse_PtgMemFunc },
  /*::[*/
  42: { n: "PtgRefErr", f: parse_PtgRefErr },
  /*::[*/
  43: { n: "PtgAreaErr", f: parse_PtgAreaErr },
  /*::[*/
  44: { n: "PtgRefN", f: parse_PtgRefN },
  /*::[*/
  45: { n: "PtgAreaN", f: parse_PtgAreaN },
  /*::[*/
  46: { n: "PtgMemAreaN", f: parse_PtgMemAreaN },
  /*::[*/
  47: { n: "PtgMemNoMemN", f: parse_PtgMemNoMemN },
  /*::[*/
  57: { n: "PtgNameX", f: parse_PtgNameX },
  /*::[*/
  58: { n: "PtgRef3d", f: parse_PtgRef3d },
  /*::[*/
  59: { n: "PtgArea3d", f: parse_PtgArea3d },
  /*::[*/
  60: { n: "PtgRefErr3d", f: parse_PtgRefErr3d },
  /*::[*/
  61: { n: "PtgAreaErr3d", f: parse_PtgAreaErr3d },
  /*::[*/
  255: {}
};
var PtgDupes = {
  /*::[*/
  64: 32,
  /*::[*/
  96: 32,
  /*::[*/
  65: 33,
  /*::[*/
  97: 33,
  /*::[*/
  66: 34,
  /*::[*/
  98: 34,
  /*::[*/
  67: 35,
  /*::[*/
  99: 35,
  /*::[*/
  68: 36,
  /*::[*/
  100: 36,
  /*::[*/
  69: 37,
  /*::[*/
  101: 37,
  /*::[*/
  70: 38,
  /*::[*/
  102: 38,
  /*::[*/
  71: 39,
  /*::[*/
  103: 39,
  /*::[*/
  72: 40,
  /*::[*/
  104: 40,
  /*::[*/
  73: 41,
  /*::[*/
  105: 41,
  /*::[*/
  74: 42,
  /*::[*/
  106: 42,
  /*::[*/
  75: 43,
  /*::[*/
  107: 43,
  /*::[*/
  76: 44,
  /*::[*/
  108: 44,
  /*::[*/
  77: 45,
  /*::[*/
  109: 45,
  /*::[*/
  78: 46,
  /*::[*/
  110: 46,
  /*::[*/
  79: 47,
  /*::[*/
  111: 47,
  /*::[*/
  88: 34,
  /*::[*/
  120: 34,
  /*::[*/
  89: 57,
  /*::[*/
  121: 57,
  /*::[*/
  90: 58,
  /*::[*/
  122: 58,
  /*::[*/
  91: 59,
  /*::[*/
  123: 59,
  /*::[*/
  92: 60,
  /*::[*/
  124: 60,
  /*::[*/
  93: 61,
  /*::[*/
  125: 61
};
var Ptg18 = {
  /*::[*/
  1: { n: "PtgElfLel", f: parse_PtgElfLel },
  /*::[*/
  2: { n: "PtgElfRw", f: parse_PtgElfRw },
  /*::[*/
  3: { n: "PtgElfCol", f: parse_PtgElfCol },
  /*::[*/
  6: { n: "PtgElfRwV", f: parse_PtgElfRwV },
  /*::[*/
  7: { n: "PtgElfColV", f: parse_PtgElfColV },
  /*::[*/
  10: { n: "PtgElfRadical", f: parse_PtgElfRadical },
  /*::[*/
  11: { n: "PtgElfRadicalS", f: parse_PtgElfRadicalS },
  /*::[*/
  13: { n: "PtgElfColS", f: parse_PtgElfColS },
  /*::[*/
  15: { n: "PtgElfColSV", f: parse_PtgElfColSV },
  /*::[*/
  16: { n: "PtgElfRadicalLel", f: parse_PtgElfRadicalLel },
  /*::[*/
  25: { n: "PtgList", f: parse_PtgList },
  /*::[*/
  29: { n: "PtgSxName", f: parse_PtgSxName },
  /*::[*/
  255: {}
};
var Ptg19 = {
  /*::[*/
  0: { n: "PtgAttrNoop", f: parse_PtgAttrNoop },
  /*::[*/
  1: { n: "PtgAttrSemi", f: parse_PtgAttrSemi },
  /*::[*/
  2: { n: "PtgAttrIf", f: parse_PtgAttrIf },
  /*::[*/
  4: { n: "PtgAttrChoose", f: parse_PtgAttrChoose },
  /*::[*/
  8: { n: "PtgAttrGoto", f: parse_PtgAttrGoto },
  /*::[*/
  16: { n: "PtgAttrSum", f: parse_PtgAttrSum },
  /*::[*/
  32: { n: "PtgAttrBaxcel", f: parse_PtgAttrBaxcel },
  /*::[*/
  33: { n: "PtgAttrBaxcel", f: parse_PtgAttrBaxcel },
  /*::[*/
  64: { n: "PtgAttrSpace", f: parse_PtgAttrSpace },
  /*::[*/
  65: { n: "PtgAttrSpaceSemi", f: parse_PtgAttrSpaceSemi },
  /*::[*/
  128: { n: "PtgAttrIfError", f: parse_PtgAttrIfError },
  /*::[*/
  255: {}
};
function parse_RgbExtra(blob, length, rgce, opts) {
  if (opts.biff < 8)
    return parsenoop(blob, length);
  var target = blob.l + length;
  var o2 = [];
  for (var i2 = 0; i2 !== rgce.length; ++i2) {
    switch (rgce[i2][0]) {
      case "PtgArray":
        rgce[i2][1] = parse_PtgExtraArray(blob, 0, opts);
        o2.push(rgce[i2][1]);
        break;
      case "PtgMemArea":
        rgce[i2][2] = parse_PtgExtraMem(blob, rgce[i2][1], opts);
        o2.push(rgce[i2][2]);
        break;
      case "PtgExp":
        if (opts && opts.biff == 12) {
          rgce[i2][1][1] = blob.read_shift(4);
          o2.push(rgce[i2][1]);
        }
        break;
      case "PtgList":
      case "PtgElfRadicalS":
      case "PtgElfColS":
      case "PtgElfColSV":
        throw "Unsupported " + rgce[i2][0];
      default:
        break;
    }
  }
  length = target - blob.l;
  if (length !== 0)
    o2.push(parsenoop(blob, length));
  return o2;
}
function parse_Rgce(blob, length, opts) {
  var target = blob.l + length;
  var R2, id, ptgs = [];
  while (target != blob.l) {
    length = target - blob.l;
    id = blob[blob.l];
    R2 = PtgTypes[id] || PtgTypes[PtgDupes[id]];
    if (id === 24 || id === 25)
      R2 = (id === 24 ? Ptg18 : Ptg19)[blob[blob.l + 1]];
    if (!R2 || !R2.f) {
      parsenoop(blob, length);
    } else {
      ptgs.push([R2.n, R2.f(blob, length, opts)]);
    }
  }
  return ptgs;
}
function stringify_array(f2) {
  var o2 = [];
  for (var i2 = 0; i2 < f2.length; ++i2) {
    var x2 = f2[i2], r = [];
    for (var j2 = 0; j2 < x2.length; ++j2) {
      var y2 = x2[j2];
      if (y2)
        switch (y2[0]) {
          case 2:
            r.push('"' + y2[1].replace(/"/g, '""') + '"');
            break;
          default:
            r.push(y2[1]);
        }
      else
        r.push("");
    }
    o2.push(r.join(","));
  }
  return o2.join(";");
}
var PtgBinOp = {
  PtgAdd: "+",
  PtgConcat: "&",
  PtgDiv: "/",
  PtgEq: "=",
  PtgGe: ">=",
  PtgGt: ">",
  PtgLe: "<=",
  PtgLt: "<",
  PtgMul: "*",
  PtgNe: "<>",
  PtgPower: "^",
  PtgSub: "-"
};
function formula_quote_sheet_name(sname, opts) {
  if (!sname && !(opts && opts.biff <= 5 && opts.biff >= 2))
    throw new Error("empty sheet name");
  if (/[^\w\u4E00-\u9FFF\u3040-\u30FF]/.test(sname))
    return "'" + sname + "'";
  return sname;
}
function get_ixti_raw(supbooks, ixti, opts) {
  if (!supbooks)
    return "SH33TJSERR0";
  if (opts.biff > 8 && (!supbooks.XTI || !supbooks.XTI[ixti]))
    return supbooks.SheetNames[ixti];
  if (!supbooks.XTI)
    return "SH33TJSERR6";
  var XTI = supbooks.XTI[ixti];
  if (opts.biff < 8) {
    if (ixti > 1e4)
      ixti -= 65536;
    if (ixti < 0)
      ixti = -ixti;
    return ixti == 0 ? "" : supbooks.XTI[ixti - 1];
  }
  if (!XTI)
    return "SH33TJSERR1";
  var o2 = "";
  if (opts.biff > 8)
    switch (supbooks[XTI[0]][0]) {
      case 357:
        o2 = XTI[1] == -1 ? "#REF" : supbooks.SheetNames[XTI[1]];
        return XTI[1] == XTI[2] ? o2 : o2 + ":" + supbooks.SheetNames[XTI[2]];
      case 358:
        if (opts.SID != null)
          return supbooks.SheetNames[opts.SID];
        return "SH33TJSSAME" + supbooks[XTI[0]][0];
      case 355:
      default:
        return "SH33TJSSRC" + supbooks[XTI[0]][0];
    }
  switch (supbooks[XTI[0]][0][0]) {
    case 1025:
      o2 = XTI[1] == -1 ? "#REF" : supbooks.SheetNames[XTI[1]] || "SH33TJSERR3";
      return XTI[1] == XTI[2] ? o2 : o2 + ":" + supbooks.SheetNames[XTI[2]];
    case 14849:
      return supbooks[XTI[0]].slice(1).map(function(name) {
        return name.Name;
      }).join(";;");
    default:
      if (!supbooks[XTI[0]][0][3])
        return "SH33TJSERR2";
      o2 = XTI[1] == -1 ? "#REF" : supbooks[XTI[0]][0][3][XTI[1]] || "SH33TJSERR4";
      return XTI[1] == XTI[2] ? o2 : o2 + ":" + supbooks[XTI[0]][0][3][XTI[2]];
  }
}
function get_ixti(supbooks, ixti, opts) {
  var ixtiraw = get_ixti_raw(supbooks, ixti, opts);
  return ixtiraw == "#REF" ? ixtiraw : formula_quote_sheet_name(ixtiraw, opts);
}
function stringify_formula(formula, range, cell, supbooks, opts) {
  var biff = opts && opts.biff || 8;
  var _range = (
    /*range != null ? range :*/
    { s: { c: 0, r: 0 }, e: { c: 0, r: 0 } }
  );
  var stack = [], e1, e2, c2, ixti = 0, nameidx = 0, r, sname = "";
  if (!formula[0] || !formula[0][0])
    return "";
  var last_sp = -1, sp = "";
  for (var ff = 0, fflen = formula[0].length; ff < fflen; ++ff) {
    var f2 = formula[0][ff];
    switch (f2[0]) {
      case "PtgUminus":
        stack.push("-" + stack.pop());
        break;
      case "PtgUplus":
        stack.push("+" + stack.pop());
        break;
      case "PtgPercent":
        stack.push(stack.pop() + "%");
        break;
      case "PtgAdd":
      case "PtgConcat":
      case "PtgDiv":
      case "PtgEq":
      case "PtgGe":
      case "PtgGt":
      case "PtgLe":
      case "PtgLt":
      case "PtgMul":
      case "PtgNe":
      case "PtgPower":
      case "PtgSub":
        e1 = stack.pop();
        e2 = stack.pop();
        if (last_sp >= 0) {
          switch (formula[0][last_sp][1][0]) {
            case 0:
              sp = fill(" ", formula[0][last_sp][1][1]);
              break;
            case 1:
              sp = fill("\r", formula[0][last_sp][1][1]);
              break;
            default:
              sp = "";
              if (opts.WTF)
                throw new Error("Unexpected PtgAttrSpaceType " + formula[0][last_sp][1][0]);
          }
          e2 = e2 + sp;
          last_sp = -1;
        }
        stack.push(e2 + PtgBinOp[f2[0]] + e1);
        break;
      case "PtgIsect":
        e1 = stack.pop();
        e2 = stack.pop();
        stack.push(e2 + " " + e1);
        break;
      case "PtgUnion":
        e1 = stack.pop();
        e2 = stack.pop();
        stack.push(e2 + "," + e1);
        break;
      case "PtgRange":
        e1 = stack.pop();
        e2 = stack.pop();
        stack.push(e2 + ":" + e1);
        break;
      case "PtgAttrChoose":
        break;
      case "PtgAttrGoto":
        break;
      case "PtgAttrIf":
        break;
      case "PtgAttrIfError":
        break;
      case "PtgRef":
        c2 = shift_cell_xls(f2[1][1], _range, opts);
        stack.push(encode_cell_xls(c2, biff));
        break;
      case "PtgRefN":
        c2 = cell ? shift_cell_xls(f2[1][1], cell, opts) : f2[1][1];
        stack.push(encode_cell_xls(c2, biff));
        break;
      case "PtgRef3d":
        ixti = /*::Number(*/
        f2[1][1];
        c2 = shift_cell_xls(f2[1][2], _range, opts);
        sname = get_ixti(supbooks, ixti, opts);
        var w2 = sname;
        stack.push(sname + "!" + encode_cell_xls(c2, biff));
        break;
      case "PtgFunc":
      case "PtgFuncVar":
        var argc = f2[1][0], func = f2[1][1];
        if (!argc)
          argc = 0;
        argc &= 127;
        var args = argc == 0 ? [] : stack.slice(-argc);
        stack.length -= argc;
        if (func === "User")
          func = args.shift();
        stack.push(func + "(" + args.join(",") + ")");
        break;
      case "PtgBool":
        stack.push(f2[1] ? "TRUE" : "FALSE");
        break;
      case "PtgInt":
        stack.push(
          /*::String(*/
          f2[1]
          /*::)*/
        );
        break;
      case "PtgNum":
        stack.push(String(f2[1]));
        break;
      case "PtgStr":
        stack.push('"' + f2[1].replace(/"/g, '""') + '"');
        break;
      case "PtgErr":
        stack.push(
          /*::String(*/
          f2[1]
          /*::)*/
        );
        break;
      case "PtgAreaN":
        r = shift_range_xls(f2[1][1], cell ? { s: cell } : _range, opts);
        stack.push(encode_range_xls(r, opts));
        break;
      case "PtgArea":
        r = shift_range_xls(f2[1][1], _range, opts);
        stack.push(encode_range_xls(r, opts));
        break;
      case "PtgArea3d":
        ixti = /*::Number(*/
        f2[1][1];
        r = f2[1][2];
        sname = get_ixti(supbooks, ixti, opts);
        stack.push(sname + "!" + encode_range_xls(r, opts));
        break;
      case "PtgAttrSum":
        stack.push("SUM(" + stack.pop() + ")");
        break;
      case "PtgAttrBaxcel":
      case "PtgAttrSemi":
        break;
      case "PtgName":
        nameidx = f2[1][2];
        var lbl = (supbooks.names || [])[nameidx - 1] || (supbooks[0] || [])[nameidx];
        var name = lbl ? lbl.Name : "SH33TJSNAME" + String(nameidx);
        if (name && name.slice(0, 6) == "_xlfn." && !opts.xlfn)
          name = name.slice(6);
        stack.push(name);
        break;
      case "PtgNameX":
        var bookidx = f2[1][1];
        nameidx = f2[1][2];
        var externbook;
        if (opts.biff <= 5) {
          if (bookidx < 0)
            bookidx = -bookidx;
          if (supbooks[bookidx])
            externbook = supbooks[bookidx][nameidx];
        } else {
          var o2 = "";
          if (((supbooks[bookidx] || [])[0] || [])[0] == 14849) {
          } else if (((supbooks[bookidx] || [])[0] || [])[0] == 1025) {
            if (supbooks[bookidx][nameidx] && supbooks[bookidx][nameidx].itab > 0) {
              o2 = supbooks.SheetNames[supbooks[bookidx][nameidx].itab - 1] + "!";
            }
          } else
            o2 = supbooks.SheetNames[nameidx - 1] + "!";
          if (supbooks[bookidx] && supbooks[bookidx][nameidx])
            o2 += supbooks[bookidx][nameidx].Name;
          else if (supbooks[0] && supbooks[0][nameidx])
            o2 += supbooks[0][nameidx].Name;
          else {
            var ixtidata = (get_ixti_raw(supbooks, bookidx, opts) || "").split(";;");
            if (ixtidata[nameidx - 1])
              o2 = ixtidata[nameidx - 1];
            else
              o2 += "SH33TJSERRX";
          }
          stack.push(o2);
          break;
        }
        if (!externbook)
          externbook = { Name: "SH33TJSERRY" };
        stack.push(externbook.Name);
        break;
      case "PtgParen":
        var lp = "(", rp = ")";
        if (last_sp >= 0) {
          sp = "";
          switch (formula[0][last_sp][1][0]) {
            case 2:
              lp = fill(" ", formula[0][last_sp][1][1]) + lp;
              break;
            case 3:
              lp = fill("\r", formula[0][last_sp][1][1]) + lp;
              break;
            case 4:
              rp = fill(" ", formula[0][last_sp][1][1]) + rp;
              break;
            case 5:
              rp = fill("\r", formula[0][last_sp][1][1]) + rp;
              break;
            default:
              if (opts.WTF)
                throw new Error("Unexpected PtgAttrSpaceType " + formula[0][last_sp][1][0]);
          }
          last_sp = -1;
        }
        stack.push(lp + stack.pop() + rp);
        break;
      case "PtgRefErr":
        stack.push("#REF!");
        break;
      case "PtgRefErr3d":
        stack.push("#REF!");
        break;
      case "PtgExp":
        c2 = { c: f2[1][1], r: f2[1][0] };
        var q2 = { c: cell.c, r: cell.r };
        if (supbooks.sharedf[encode_cell(c2)]) {
          var parsedf = supbooks.sharedf[encode_cell(c2)];
          stack.push(stringify_formula(parsedf, _range, q2, supbooks, opts));
        } else {
          var fnd = false;
          for (e1 = 0; e1 != supbooks.arrayf.length; ++e1) {
            e2 = supbooks.arrayf[e1];
            if (c2.c < e2[0].s.c || c2.c > e2[0].e.c)
              continue;
            if (c2.r < e2[0].s.r || c2.r > e2[0].e.r)
              continue;
            stack.push(stringify_formula(e2[1], _range, q2, supbooks, opts));
            fnd = true;
            break;
          }
          if (!fnd)
            stack.push(
              /*::String(*/
              f2[1]
              /*::)*/
            );
        }
        break;
      case "PtgArray":
        stack.push("{" + stringify_array(
          /*::(*/
          f2[1]
          /*:: :any)*/
        ) + "}");
        break;
      case "PtgMemArea":
        break;
      case "PtgAttrSpace":
      case "PtgAttrSpaceSemi":
        last_sp = ff;
        break;
      case "PtgTbl":
        break;
      case "PtgMemErr":
        break;
      case "PtgMissArg":
        stack.push("");
        break;
      case "PtgAreaErr":
        stack.push("#REF!");
        break;
      case "PtgAreaErr3d":
        stack.push("#REF!");
        break;
      case "PtgList":
        stack.push("Table" + f2[1].idx + "[#" + f2[1].rt + "]");
        break;
      case "PtgMemAreaN":
      case "PtgMemNoMemN":
      case "PtgAttrNoop":
      case "PtgSheet":
      case "PtgEndSheet":
        break;
      case "PtgMemFunc":
        break;
      case "PtgMemNoMem":
        break;
      case "PtgElfCol":
      case "PtgElfColS":
      case "PtgElfColSV":
      case "PtgElfColV":
      case "PtgElfLel":
      case "PtgElfRadical":
      case "PtgElfRadicalLel":
      case "PtgElfRadicalS":
      case "PtgElfRw":
      case "PtgElfRwV":
        throw new Error("Unsupported ELFs");
      case "PtgSxName":
        throw new Error("Unrecognized Formula Token: " + String(f2));
      default:
        throw new Error("Unrecognized Formula Token: " + String(f2));
    }
    var PtgNonDisp = ["PtgAttrSpace", "PtgAttrSpaceSemi", "PtgAttrGoto"];
    if (opts.biff != 3) {
      if (last_sp >= 0 && PtgNonDisp.indexOf(formula[0][ff][0]) == -1) {
        f2 = formula[0][last_sp];
        var _left = true;
        switch (f2[1][0]) {
          case 4:
            _left = false;
          case 0:
            sp = fill(" ", f2[1][1]);
            break;
          case 5:
            _left = false;
          case 1:
            sp = fill("\r", f2[1][1]);
            break;
          default:
            sp = "";
            if (opts.WTF)
              throw new Error("Unexpected PtgAttrSpaceType " + f2[1][0]);
        }
        stack.push((_left ? sp : "") + stack.pop() + (_left ? "" : sp));
        last_sp = -1;
      }
    }
  }
  if (stack.length > 1 && opts.WTF)
    throw new Error("bad formula stack");
  return stack[0];
}
function parse_ArrayParsedFormula(blob, length, opts) {
  var target = blob.l + length, len = opts.biff == 2 ? 1 : 2;
  var rgcb, cce = blob.read_shift(len);
  if (cce == 65535)
    return [[], parsenoop(blob, length - 2)];
  var rgce = parse_Rgce(blob, cce, opts);
  if (length !== cce + len)
    rgcb = parse_RgbExtra(blob, length - cce - len, rgce, opts);
  blob.l = target;
  return [rgce, rgcb];
}
function parse_XLSCellParsedFormula(blob, length, opts) {
  var target = blob.l + length, len = opts.biff == 2 ? 1 : 2;
  var rgcb, cce = blob.read_shift(len);
  if (cce == 65535)
    return [[], parsenoop(blob, length - 2)];
  var rgce = parse_Rgce(blob, cce, opts);
  if (length !== cce + len)
    rgcb = parse_RgbExtra(blob, length - cce - len, rgce, opts);
  blob.l = target;
  return [rgce, rgcb];
}
function parse_NameParsedFormula(blob, length, opts, cce) {
  var target = blob.l + length;
  var rgce = parse_Rgce(blob, cce, opts);
  var rgcb;
  if (target !== blob.l)
    rgcb = parse_RgbExtra(blob, target - blob.l, rgce, opts);
  return [rgce, rgcb];
}
function parse_SharedParsedFormula(blob, length, opts) {
  var target = blob.l + length;
  var rgcb, cce = blob.read_shift(2);
  var rgce = parse_Rgce(blob, cce, opts);
  if (cce == 65535)
    return [[], parsenoop(blob, length - 2)];
  if (length !== cce + 2)
    rgcb = parse_RgbExtra(blob, target - cce - 2, rgce, opts);
  return [rgce, rgcb];
}
function parse_FormulaValue(blob) {
  var b2;
  if (__readUInt16LE(blob, blob.l + 6) !== 65535)
    return [parse_Xnum(blob), "n"];
  switch (blob[blob.l]) {
    case 0:
      blob.l += 8;
      return ["String", "s"];
    case 1:
      b2 = blob[blob.l + 2] === 1;
      blob.l += 8;
      return [b2, "b"];
    case 2:
      b2 = blob[blob.l + 2];
      blob.l += 8;
      return [b2, "e"];
    case 3:
      blob.l += 8;
      return ["", "s"];
  }
  return [];
}
function write_FormulaValue(value) {
  if (value == null) {
    var o2 = new_buf(8);
    o2.write_shift(1, 3);
    o2.write_shift(1, 0);
    o2.write_shift(2, 0);
    o2.write_shift(2, 0);
    o2.write_shift(2, 65535);
    return o2;
  } else if (typeof value == "number")
    return write_Xnum(value);
  return write_Xnum(0);
}
function parse_Formula(blob, length, opts) {
  var end = blob.l + length;
  var cell = parse_XLSCell(blob, 6);
  if (opts.biff == 2)
    ++blob.l;
  var val = parse_FormulaValue(blob, 8);
  var flags = blob.read_shift(1);
  if (opts.biff != 2) {
    blob.read_shift(1);
    if (opts.biff >= 5) {
      blob.read_shift(4);
    }
  }
  var cbf = parse_XLSCellParsedFormula(blob, end - blob.l, opts);
  return { cell, val: val[0], formula: cbf, shared: flags >> 3 & 1, tt: val[1] };
}
function write_Formula(cell, R2, C2, opts, os) {
  var o1 = write_XLSCell(R2, C2, os);
  var o2 = write_FormulaValue(cell.v);
  var o3 = new_buf(6);
  var flags = 1 | 32;
  o3.write_shift(2, flags);
  o3.write_shift(4, 0);
  var bf = new_buf(cell.bf.length);
  for (var i2 = 0; i2 < cell.bf.length; ++i2)
    bf[i2] = cell.bf[i2];
  var out = bconcat([o1, o2, o3, bf]);
  return out;
}
function parse_XLSBParsedFormula(data, length, opts) {
  var cce = data.read_shift(4);
  var rgce = parse_Rgce(data, cce, opts);
  var cb = data.read_shift(4);
  var rgcb = cb > 0 ? parse_RgbExtra(data, cb, rgce, opts) : null;
  return [rgce, rgcb];
}
var parse_XLSBArrayParsedFormula = parse_XLSBParsedFormula;
var parse_XLSBCellParsedFormula = parse_XLSBParsedFormula;
var parse_XLSBNameParsedFormula = parse_XLSBParsedFormula;
var parse_XLSBSharedParsedFormula = parse_XLSBParsedFormula;
var Cetab = {
  0: "BEEP",
  1: "OPEN",
  2: "OPEN.LINKS",
  3: "CLOSE.ALL",
  4: "SAVE",
  5: "SAVE.AS",
  6: "FILE.DELETE",
  7: "PAGE.SETUP",
  8: "PRINT",
  9: "PRINTER.SETUP",
  10: "QUIT",
  11: "NEW.WINDOW",
  12: "ARRANGE.ALL",
  13: "WINDOW.SIZE",
  14: "WINDOW.MOVE",
  15: "FULL",
  16: "CLOSE",
  17: "RUN",
  22: "SET.PRINT.AREA",
  23: "SET.PRINT.TITLES",
  24: "SET.PAGE.BREAK",
  25: "REMOVE.PAGE.BREAK",
  26: "FONT",
  27: "DISPLAY",
  28: "PROTECT.DOCUMENT",
  29: "PRECISION",
  30: "A1.R1C1",
  31: "CALCULATE.NOW",
  32: "CALCULATION",
  34: "DATA.FIND",
  35: "EXTRACT",
  36: "DATA.DELETE",
  37: "SET.DATABASE",
  38: "SET.CRITERIA",
  39: "SORT",
  40: "DATA.SERIES",
  41: "TABLE",
  42: "FORMAT.NUMBER",
  43: "ALIGNMENT",
  44: "STYLE",
  45: "BORDER",
  46: "CELL.PROTECTION",
  47: "COLUMN.WIDTH",
  48: "UNDO",
  49: "CUT",
  50: "COPY",
  51: "PASTE",
  52: "CLEAR",
  53: "PASTE.SPECIAL",
  54: "EDIT.DELETE",
  55: "INSERT",
  56: "FILL.RIGHT",
  57: "FILL.DOWN",
  61: "DEFINE.NAME",
  62: "CREATE.NAMES",
  63: "FORMULA.GOTO",
  64: "FORMULA.FIND",
  65: "SELECT.LAST.CELL",
  66: "SHOW.ACTIVE.CELL",
  67: "GALLERY.AREA",
  68: "GALLERY.BAR",
  69: "GALLERY.COLUMN",
  70: "GALLERY.LINE",
  71: "GALLERY.PIE",
  72: "GALLERY.SCATTER",
  73: "COMBINATION",
  74: "PREFERRED",
  75: "ADD.OVERLAY",
  76: "GRIDLINES",
  77: "SET.PREFERRED",
  78: "AXES",
  79: "LEGEND",
  80: "ATTACH.TEXT",
  81: "ADD.ARROW",
  82: "SELECT.CHART",
  83: "SELECT.PLOT.AREA",
  84: "PATTERNS",
  85: "MAIN.CHART",
  86: "OVERLAY",
  87: "SCALE",
  88: "FORMAT.LEGEND",
  89: "FORMAT.TEXT",
  90: "EDIT.REPEAT",
  91: "PARSE",
  92: "JUSTIFY",
  93: "HIDE",
  94: "UNHIDE",
  95: "WORKSPACE",
  96: "FORMULA",
  97: "FORMULA.FILL",
  98: "FORMULA.ARRAY",
  99: "DATA.FIND.NEXT",
  100: "DATA.FIND.PREV",
  101: "FORMULA.FIND.NEXT",
  102: "FORMULA.FIND.PREV",
  103: "ACTIVATE",
  104: "ACTIVATE.NEXT",
  105: "ACTIVATE.PREV",
  106: "UNLOCKED.NEXT",
  107: "UNLOCKED.PREV",
  108: "COPY.PICTURE",
  109: "SELECT",
  110: "DELETE.NAME",
  111: "DELETE.FORMAT",
  112: "VLINE",
  113: "HLINE",
  114: "VPAGE",
  115: "HPAGE",
  116: "VSCROLL",
  117: "HSCROLL",
  118: "ALERT",
  119: "NEW",
  120: "CANCEL.COPY",
  121: "SHOW.CLIPBOARD",
  122: "MESSAGE",
  124: "PASTE.LINK",
  125: "APP.ACTIVATE",
  126: "DELETE.ARROW",
  127: "ROW.HEIGHT",
  128: "FORMAT.MOVE",
  129: "FORMAT.SIZE",
  130: "FORMULA.REPLACE",
  131: "SEND.KEYS",
  132: "SELECT.SPECIAL",
  133: "APPLY.NAMES",
  134: "REPLACE.FONT",
  135: "FREEZE.PANES",
  136: "SHOW.INFO",
  137: "SPLIT",
  138: "ON.WINDOW",
  139: "ON.DATA",
  140: "DISABLE.INPUT",
  142: "OUTLINE",
  143: "LIST.NAMES",
  144: "FILE.CLOSE",
  145: "SAVE.WORKBOOK",
  146: "DATA.FORM",
  147: "COPY.CHART",
  148: "ON.TIME",
  149: "WAIT",
  150: "FORMAT.FONT",
  151: "FILL.UP",
  152: "FILL.LEFT",
  153: "DELETE.OVERLAY",
  155: "SHORT.MENUS",
  159: "SET.UPDATE.STATUS",
  161: "COLOR.PALETTE",
  162: "DELETE.STYLE",
  163: "WINDOW.RESTORE",
  164: "WINDOW.MAXIMIZE",
  166: "CHANGE.LINK",
  167: "CALCULATE.DOCUMENT",
  168: "ON.KEY",
  169: "APP.RESTORE",
  170: "APP.MOVE",
  171: "APP.SIZE",
  172: "APP.MINIMIZE",
  173: "APP.MAXIMIZE",
  174: "BRING.TO.FRONT",
  175: "SEND.TO.BACK",
  185: "MAIN.CHART.TYPE",
  186: "OVERLAY.CHART.TYPE",
  187: "SELECT.END",
  188: "OPEN.MAIL",
  189: "SEND.MAIL",
  190: "STANDARD.FONT",
  191: "CONSOLIDATE",
  192: "SORT.SPECIAL",
  193: "GALLERY.3D.AREA",
  194: "GALLERY.3D.COLUMN",
  195: "GALLERY.3D.LINE",
  196: "GALLERY.3D.PIE",
  197: "VIEW.3D",
  198: "GOAL.SEEK",
  199: "WORKGROUP",
  200: "FILL.GROUP",
  201: "UPDATE.LINK",
  202: "PROMOTE",
  203: "DEMOTE",
  204: "SHOW.DETAIL",
  206: "UNGROUP",
  207: "OBJECT.PROPERTIES",
  208: "SAVE.NEW.OBJECT",
  209: "SHARE",
  210: "SHARE.NAME",
  211: "DUPLICATE",
  212: "APPLY.STYLE",
  213: "ASSIGN.TO.OBJECT",
  214: "OBJECT.PROTECTION",
  215: "HIDE.OBJECT",
  216: "SET.EXTRACT",
  217: "CREATE.PUBLISHER",
  218: "SUBSCRIBE.TO",
  219: "ATTRIBUTES",
  220: "SHOW.TOOLBAR",
  222: "PRINT.PREVIEW",
  223: "EDIT.COLOR",
  224: "SHOW.LEVELS",
  225: "FORMAT.MAIN",
  226: "FORMAT.OVERLAY",
  227: "ON.RECALC",
  228: "EDIT.SERIES",
  229: "DEFINE.STYLE",
  240: "LINE.PRINT",
  243: "ENTER.DATA",
  249: "GALLERY.RADAR",
  250: "MERGE.STYLES",
  251: "EDITION.OPTIONS",
  252: "PASTE.PICTURE",
  253: "PASTE.PICTURE.LINK",
  254: "SPELLING",
  256: "ZOOM",
  259: "INSERT.OBJECT",
  260: "WINDOW.MINIMIZE",
  265: "SOUND.NOTE",
  266: "SOUND.PLAY",
  267: "FORMAT.SHAPE",
  268: "EXTEND.POLYGON",
  269: "FORMAT.AUTO",
  272: "GALLERY.3D.BAR",
  273: "GALLERY.3D.SURFACE",
  274: "FILL.AUTO",
  276: "CUSTOMIZE.TOOLBAR",
  277: "ADD.TOOL",
  278: "EDIT.OBJECT",
  279: "ON.DOUBLECLICK",
  280: "ON.ENTRY",
  281: "WORKBOOK.ADD",
  282: "WORKBOOK.MOVE",
  283: "WORKBOOK.COPY",
  284: "WORKBOOK.OPTIONS",
  285: "SAVE.WORKSPACE",
  288: "CHART.WIZARD",
  289: "DELETE.TOOL",
  290: "MOVE.TOOL",
  291: "WORKBOOK.SELECT",
  292: "WORKBOOK.ACTIVATE",
  293: "ASSIGN.TO.TOOL",
  295: "COPY.TOOL",
  296: "RESET.TOOL",
  297: "CONSTRAIN.NUMERIC",
  298: "PASTE.TOOL",
  302: "WORKBOOK.NEW",
  305: "SCENARIO.CELLS",
  306: "SCENARIO.DELETE",
  307: "SCENARIO.ADD",
  308: "SCENARIO.EDIT",
  309: "SCENARIO.SHOW",
  310: "SCENARIO.SHOW.NEXT",
  311: "SCENARIO.SUMMARY",
  312: "PIVOT.TABLE.WIZARD",
  313: "PIVOT.FIELD.PROPERTIES",
  314: "PIVOT.FIELD",
  315: "PIVOT.ITEM",
  316: "PIVOT.ADD.FIELDS",
  318: "OPTIONS.CALCULATION",
  319: "OPTIONS.EDIT",
  320: "OPTIONS.VIEW",
  321: "ADDIN.MANAGER",
  322: "MENU.EDITOR",
  323: "ATTACH.TOOLBARS",
  324: "VBAActivate",
  325: "OPTIONS.CHART",
  328: "VBA.INSERT.FILE",
  330: "VBA.PROCEDURE.DEFINITION",
  336: "ROUTING.SLIP",
  338: "ROUTE.DOCUMENT",
  339: "MAIL.LOGON",
  342: "INSERT.PICTURE",
  343: "EDIT.TOOL",
  344: "GALLERY.DOUGHNUT",
  350: "CHART.TREND",
  352: "PIVOT.ITEM.PROPERTIES",
  354: "WORKBOOK.INSERT",
  355: "OPTIONS.TRANSITION",
  356: "OPTIONS.GENERAL",
  370: "FILTER.ADVANCED",
  373: "MAIL.ADD.MAILER",
  374: "MAIL.DELETE.MAILER",
  375: "MAIL.REPLY",
  376: "MAIL.REPLY.ALL",
  377: "MAIL.FORWARD",
  378: "MAIL.NEXT.LETTER",
  379: "DATA.LABEL",
  380: "INSERT.TITLE",
  381: "FONT.PROPERTIES",
  382: "MACRO.OPTIONS",
  383: "WORKBOOK.HIDE",
  384: "WORKBOOK.UNHIDE",
  385: "WORKBOOK.DELETE",
  386: "WORKBOOK.NAME",
  388: "GALLERY.CUSTOM",
  390: "ADD.CHART.AUTOFORMAT",
  391: "DELETE.CHART.AUTOFORMAT",
  392: "CHART.ADD.DATA",
  393: "AUTO.OUTLINE",
  394: "TAB.ORDER",
  395: "SHOW.DIALOG",
  396: "SELECT.ALL",
  397: "UNGROUP.SHEETS",
  398: "SUBTOTAL.CREATE",
  399: "SUBTOTAL.REMOVE",
  400: "RENAME.OBJECT",
  412: "WORKBOOK.SCROLL",
  413: "WORKBOOK.NEXT",
  414: "WORKBOOK.PREV",
  415: "WORKBOOK.TAB.SPLIT",
  416: "FULL.SCREEN",
  417: "WORKBOOK.PROTECT",
  420: "SCROLLBAR.PROPERTIES",
  421: "PIVOT.SHOW.PAGES",
  422: "TEXT.TO.COLUMNS",
  423: "FORMAT.CHARTTYPE",
  424: "LINK.FORMAT",
  425: "TRACER.DISPLAY",
  430: "TRACER.NAVIGATE",
  431: "TRACER.CLEAR",
  432: "TRACER.ERROR",
  433: "PIVOT.FIELD.GROUP",
  434: "PIVOT.FIELD.UNGROUP",
  435: "CHECKBOX.PROPERTIES",
  436: "LABEL.PROPERTIES",
  437: "LISTBOX.PROPERTIES",
  438: "EDITBOX.PROPERTIES",
  439: "PIVOT.REFRESH",
  440: "LINK.COMBO",
  441: "OPEN.TEXT",
  442: "HIDE.DIALOG",
  443: "SET.DIALOG.FOCUS",
  444: "ENABLE.OBJECT",
  445: "PUSHBUTTON.PROPERTIES",
  446: "SET.DIALOG.DEFAULT",
  447: "FILTER",
  448: "FILTER.SHOW.ALL",
  449: "CLEAR.OUTLINE",
  450: "FUNCTION.WIZARD",
  451: "ADD.LIST.ITEM",
  452: "SET.LIST.ITEM",
  453: "REMOVE.LIST.ITEM",
  454: "SELECT.LIST.ITEM",
  455: "SET.CONTROL.VALUE",
  456: "SAVE.COPY.AS",
  458: "OPTIONS.LISTS.ADD",
  459: "OPTIONS.LISTS.DELETE",
  460: "SERIES.AXES",
  461: "SERIES.X",
  462: "SERIES.Y",
  463: "ERRORBAR.X",
  464: "ERRORBAR.Y",
  465: "FORMAT.CHART",
  466: "SERIES.ORDER",
  467: "MAIL.LOGOFF",
  468: "CLEAR.ROUTING.SLIP",
  469: "APP.ACTIVATE.MICROSOFT",
  470: "MAIL.EDIT.MAILER",
  471: "ON.SHEET",
  472: "STANDARD.WIDTH",
  473: "SCENARIO.MERGE",
  474: "SUMMARY.INFO",
  475: "FIND.FILE",
  476: "ACTIVE.CELL.FONT",
  477: "ENABLE.TIPWIZARD",
  478: "VBA.MAKE.ADDIN",
  480: "INSERTDATATABLE",
  481: "WORKGROUP.OPTIONS",
  482: "MAIL.SEND.MAILER",
  485: "AUTOCORRECT",
  489: "POST.DOCUMENT",
  491: "PICKLIST",
  493: "VIEW.SHOW",
  494: "VIEW.DEFINE",
  495: "VIEW.DELETE",
  509: "SHEET.BACKGROUND",
  510: "INSERT.MAP.OBJECT",
  511: "OPTIONS.MENONO",
  517: "MSOCHECKS",
  518: "NORMAL",
  519: "LAYOUT",
  520: "RM.PRINT.AREA",
  521: "CLEAR.PRINT.AREA",
  522: "ADD.PRINT.AREA",
  523: "MOVE.BRK",
  545: "HIDECURR.NOTE",
  546: "HIDEALL.NOTES",
  547: "DELETE.NOTE",
  548: "TRAVERSE.NOTES",
  549: "ACTIVATE.NOTES",
  620: "PROTECT.REVISIONS",
  621: "UNPROTECT.REVISIONS",
  647: "OPTIONS.ME",
  653: "WEB.PUBLISH",
  667: "NEWWEBQUERY",
  673: "PIVOT.TABLE.CHART",
  753: "OPTIONS.SAVE",
  755: "OPTIONS.SPELL",
  808: "HIDEALL.INKANNOTS"
};
var Ftab = {
  0: "COUNT",
  1: "IF",
  2: "ISNA",
  3: "ISERROR",
  4: "SUM",
  5: "AVERAGE",
  6: "MIN",
  7: "MAX",
  8: "ROW",
  9: "COLUMN",
  10: "NA",
  11: "NPV",
  12: "STDEV",
  13: "DOLLAR",
  14: "FIXED",
  15: "SIN",
  16: "COS",
  17: "TAN",
  18: "ATAN",
  19: "PI",
  20: "SQRT",
  21: "EXP",
  22: "LN",
  23: "LOG10",
  24: "ABS",
  25: "INT",
  26: "SIGN",
  27: "ROUND",
  28: "LOOKUP",
  29: "INDEX",
  30: "REPT",
  31: "MID",
  32: "LEN",
  33: "VALUE",
  34: "TRUE",
  35: "FALSE",
  36: "AND",
  37: "OR",
  38: "NOT",
  39: "MOD",
  40: "DCOUNT",
  41: "DSUM",
  42: "DAVERAGE",
  43: "DMIN",
  44: "DMAX",
  45: "DSTDEV",
  46: "VAR",
  47: "DVAR",
  48: "TEXT",
  49: "LINEST",
  50: "TREND",
  51: "LOGEST",
  52: "GROWTH",
  53: "GOTO",
  54: "HALT",
  55: "RETURN",
  56: "PV",
  57: "FV",
  58: "NPER",
  59: "PMT",
  60: "RATE",
  61: "MIRR",
  62: "IRR",
  63: "RAND",
  64: "MATCH",
  65: "DATE",
  66: "TIME",
  67: "DAY",
  68: "MONTH",
  69: "YEAR",
  70: "WEEKDAY",
  71: "HOUR",
  72: "MINUTE",
  73: "SECOND",
  74: "NOW",
  75: "AREAS",
  76: "ROWS",
  77: "COLUMNS",
  78: "OFFSET",
  79: "ABSREF",
  80: "RELREF",
  81: "ARGUMENT",
  82: "SEARCH",
  83: "TRANSPOSE",
  84: "ERROR",
  85: "STEP",
  86: "TYPE",
  87: "ECHO",
  88: "SET.NAME",
  89: "CALLER",
  90: "DEREF",
  91: "WINDOWS",
  92: "SERIES",
  93: "DOCUMENTS",
  94: "ACTIVE.CELL",
  95: "SELECTION",
  96: "RESULT",
  97: "ATAN2",
  98: "ASIN",
  99: "ACOS",
  100: "CHOOSE",
  101: "HLOOKUP",
  102: "VLOOKUP",
  103: "LINKS",
  104: "INPUT",
  105: "ISREF",
  106: "GET.FORMULA",
  107: "GET.NAME",
  108: "SET.VALUE",
  109: "LOG",
  110: "EXEC",
  111: "CHAR",
  112: "LOWER",
  113: "UPPER",
  114: "PROPER",
  115: "LEFT",
  116: "RIGHT",
  117: "EXACT",
  118: "TRIM",
  119: "REPLACE",
  120: "SUBSTITUTE",
  121: "CODE",
  122: "NAMES",
  123: "DIRECTORY",
  124: "FIND",
  125: "CELL",
  126: "ISERR",
  127: "ISTEXT",
  128: "ISNUMBER",
  129: "ISBLANK",
  130: "T",
  131: "N",
  132: "FOPEN",
  133: "FCLOSE",
  134: "FSIZE",
  135: "FREADLN",
  136: "FREAD",
  137: "FWRITELN",
  138: "FWRITE",
  139: "FPOS",
  140: "DATEVALUE",
  141: "TIMEVALUE",
  142: "SLN",
  143: "SYD",
  144: "DDB",
  145: "GET.DEF",
  146: "REFTEXT",
  147: "TEXTREF",
  148: "INDIRECT",
  149: "REGISTER",
  150: "CALL",
  151: "ADD.BAR",
  152: "ADD.MENU",
  153: "ADD.COMMAND",
  154: "ENABLE.COMMAND",
  155: "CHECK.COMMAND",
  156: "RENAME.COMMAND",
  157: "SHOW.BAR",
  158: "DELETE.MENU",
  159: "DELETE.COMMAND",
  160: "GET.CHART.ITEM",
  161: "DIALOG.BOX",
  162: "CLEAN",
  163: "MDETERM",
  164: "MINVERSE",
  165: "MMULT",
  166: "FILES",
  167: "IPMT",
  168: "PPMT",
  169: "COUNTA",
  170: "CANCEL.KEY",
  171: "FOR",
  172: "WHILE",
  173: "BREAK",
  174: "NEXT",
  175: "INITIATE",
  176: "REQUEST",
  177: "POKE",
  178: "EXECUTE",
  179: "TERMINATE",
  180: "RESTART",
  181: "HELP",
  182: "GET.BAR",
  183: "PRODUCT",
  184: "FACT",
  185: "GET.CELL",
  186: "GET.WORKSPACE",
  187: "GET.WINDOW",
  188: "GET.DOCUMENT",
  189: "DPRODUCT",
  190: "ISNONTEXT",
  191: "GET.NOTE",
  192: "NOTE",
  193: "STDEVP",
  194: "VARP",
  195: "DSTDEVP",
  196: "DVARP",
  197: "TRUNC",
  198: "ISLOGICAL",
  199: "DCOUNTA",
  200: "DELETE.BAR",
  201: "UNREGISTER",
  204: "USDOLLAR",
  205: "FINDB",
  206: "SEARCHB",
  207: "REPLACEB",
  208: "LEFTB",
  209: "RIGHTB",
  210: "MIDB",
  211: "LENB",
  212: "ROUNDUP",
  213: "ROUNDDOWN",
  214: "ASC",
  215: "DBCS",
  216: "RANK",
  219: "ADDRESS",
  220: "DAYS360",
  221: "TODAY",
  222: "VDB",
  223: "ELSE",
  224: "ELSE.IF",
  225: "END.IF",
  226: "FOR.CELL",
  227: "MEDIAN",
  228: "SUMPRODUCT",
  229: "SINH",
  230: "COSH",
  231: "TANH",
  232: "ASINH",
  233: "ACOSH",
  234: "ATANH",
  235: "DGET",
  236: "CREATE.OBJECT",
  237: "VOLATILE",
  238: "LAST.ERROR",
  239: "CUSTOM.UNDO",
  240: "CUSTOM.REPEAT",
  241: "FORMULA.CONVERT",
  242: "GET.LINK.INFO",
  243: "TEXT.BOX",
  244: "INFO",
  245: "GROUP",
  246: "GET.OBJECT",
  247: "DB",
  248: "PAUSE",
  251: "RESUME",
  252: "FREQUENCY",
  253: "ADD.TOOLBAR",
  254: "DELETE.TOOLBAR",
  255: "User",
  256: "RESET.TOOLBAR",
  257: "EVALUATE",
  258: "GET.TOOLBAR",
  259: "GET.TOOL",
  260: "SPELLING.CHECK",
  261: "ERROR.TYPE",
  262: "APP.TITLE",
  263: "WINDOW.TITLE",
  264: "SAVE.TOOLBAR",
  265: "ENABLE.TOOL",
  266: "PRESS.TOOL",
  267: "REGISTER.ID",
  268: "GET.WORKBOOK",
  269: "AVEDEV",
  270: "BETADIST",
  271: "GAMMALN",
  272: "BETAINV",
  273: "BINOMDIST",
  274: "CHIDIST",
  275: "CHIINV",
  276: "COMBIN",
  277: "CONFIDENCE",
  278: "CRITBINOM",
  279: "EVEN",
  280: "EXPONDIST",
  281: "FDIST",
  282: "FINV",
  283: "FISHER",
  284: "FISHERINV",
  285: "FLOOR",
  286: "GAMMADIST",
  287: "GAMMAINV",
  288: "CEILING",
  289: "HYPGEOMDIST",
  290: "LOGNORMDIST",
  291: "LOGINV",
  292: "NEGBINOMDIST",
  293: "NORMDIST",
  294: "NORMSDIST",
  295: "NORMINV",
  296: "NORMSINV",
  297: "STANDARDIZE",
  298: "ODD",
  299: "PERMUT",
  300: "POISSON",
  301: "TDIST",
  302: "WEIBULL",
  303: "SUMXMY2",
  304: "SUMX2MY2",
  305: "SUMX2PY2",
  306: "CHITEST",
  307: "CORREL",
  308: "COVAR",
  309: "FORECAST",
  310: "FTEST",
  311: "INTERCEPT",
  312: "PEARSON",
  313: "RSQ",
  314: "STEYX",
  315: "SLOPE",
  316: "TTEST",
  317: "PROB",
  318: "DEVSQ",
  319: "GEOMEAN",
  320: "HARMEAN",
  321: "SUMSQ",
  322: "KURT",
  323: "SKEW",
  324: "ZTEST",
  325: "LARGE",
  326: "SMALL",
  327: "QUARTILE",
  328: "PERCENTILE",
  329: "PERCENTRANK",
  330: "MODE",
  331: "TRIMMEAN",
  332: "TINV",
  334: "MOVIE.COMMAND",
  335: "GET.MOVIE",
  336: "CONCATENATE",
  337: "POWER",
  338: "PIVOT.ADD.DATA",
  339: "GET.PIVOT.TABLE",
  340: "GET.PIVOT.FIELD",
  341: "GET.PIVOT.ITEM",
  342: "RADIANS",
  343: "DEGREES",
  344: "SUBTOTAL",
  345: "SUMIF",
  346: "COUNTIF",
  347: "COUNTBLANK",
  348: "SCENARIO.GET",
  349: "OPTIONS.LISTS.GET",
  350: "ISPMT",
  351: "DATEDIF",
  352: "DATESTRING",
  353: "NUMBERSTRING",
  354: "ROMAN",
  355: "OPEN.DIALOG",
  356: "SAVE.DIALOG",
  357: "VIEW.GET",
  358: "GETPIVOTDATA",
  359: "HYPERLINK",
  360: "PHONETIC",
  361: "AVERAGEA",
  362: "MAXA",
  363: "MINA",
  364: "STDEVPA",
  365: "VARPA",
  366: "STDEVA",
  367: "VARA",
  368: "BAHTTEXT",
  369: "THAIDAYOFWEEK",
  370: "THAIDIGIT",
  371: "THAIMONTHOFYEAR",
  372: "THAINUMSOUND",
  373: "THAINUMSTRING",
  374: "THAISTRINGLENGTH",
  375: "ISTHAIDIGIT",
  376: "ROUNDBAHTDOWN",
  377: "ROUNDBAHTUP",
  378: "THAIYEAR",
  379: "RTD",
  380: "CUBEVALUE",
  381: "CUBEMEMBER",
  382: "CUBEMEMBERPROPERTY",
  383: "CUBERANKEDMEMBER",
  384: "HEX2BIN",
  385: "HEX2DEC",
  386: "HEX2OCT",
  387: "DEC2BIN",
  388: "DEC2HEX",
  389: "DEC2OCT",
  390: "OCT2BIN",
  391: "OCT2HEX",
  392: "OCT2DEC",
  393: "BIN2DEC",
  394: "BIN2OCT",
  395: "BIN2HEX",
  396: "IMSUB",
  397: "IMDIV",
  398: "IMPOWER",
  399: "IMABS",
  400: "IMSQRT",
  401: "IMLN",
  402: "IMLOG2",
  403: "IMLOG10",
  404: "IMSIN",
  405: "IMCOS",
  406: "IMEXP",
  407: "IMARGUMENT",
  408: "IMCONJUGATE",
  409: "IMAGINARY",
  410: "IMREAL",
  411: "COMPLEX",
  412: "IMSUM",
  413: "IMPRODUCT",
  414: "SERIESSUM",
  415: "FACTDOUBLE",
  416: "SQRTPI",
  417: "QUOTIENT",
  418: "DELTA",
  419: "GESTEP",
  420: "ISEVEN",
  421: "ISODD",
  422: "MROUND",
  423: "ERF",
  424: "ERFC",
  425: "BESSELJ",
  426: "BESSELK",
  427: "BESSELY",
  428: "BESSELI",
  429: "XIRR",
  430: "XNPV",
  431: "PRICEMAT",
  432: "YIELDMAT",
  433: "INTRATE",
  434: "RECEIVED",
  435: "DISC",
  436: "PRICEDISC",
  437: "YIELDDISC",
  438: "TBILLEQ",
  439: "TBILLPRICE",
  440: "TBILLYIELD",
  441: "PRICE",
  442: "YIELD",
  443: "DOLLARDE",
  444: "DOLLARFR",
  445: "NOMINAL",
  446: "EFFECT",
  447: "CUMPRINC",
  448: "CUMIPMT",
  449: "EDATE",
  450: "EOMONTH",
  451: "YEARFRAC",
  452: "COUPDAYBS",
  453: "COUPDAYS",
  454: "COUPDAYSNC",
  455: "COUPNCD",
  456: "COUPNUM",
  457: "COUPPCD",
  458: "DURATION",
  459: "MDURATION",
  460: "ODDLPRICE",
  461: "ODDLYIELD",
  462: "ODDFPRICE",
  463: "ODDFYIELD",
  464: "RANDBETWEEN",
  465: "WEEKNUM",
  466: "AMORDEGRC",
  467: "AMORLINC",
  468: "CONVERT",
  724: "SHEETJS",
  469: "ACCRINT",
  470: "ACCRINTM",
  471: "WORKDAY",
  472: "NETWORKDAYS",
  473: "GCD",
  474: "MULTINOMIAL",
  475: "LCM",
  476: "FVSCHEDULE",
  477: "CUBEKPIMEMBER",
  478: "CUBESET",
  479: "CUBESETCOUNT",
  480: "IFERROR",
  481: "COUNTIFS",
  482: "SUMIFS",
  483: "AVERAGEIF",
  484: "AVERAGEIFS"
};
var FtabArgc = {
  2: 1,
  3: 1,
  10: 0,
  15: 1,
  16: 1,
  17: 1,
  18: 1,
  19: 0,
  20: 1,
  21: 1,
  22: 1,
  23: 1,
  24: 1,
  25: 1,
  26: 1,
  27: 2,
  30: 2,
  31: 3,
  32: 1,
  33: 1,
  34: 0,
  35: 0,
  38: 1,
  39: 2,
  40: 3,
  41: 3,
  42: 3,
  43: 3,
  44: 3,
  45: 3,
  47: 3,
  48: 2,
  53: 1,
  61: 3,
  63: 0,
  65: 3,
  66: 3,
  67: 1,
  68: 1,
  69: 1,
  70: 1,
  71: 1,
  72: 1,
  73: 1,
  74: 0,
  75: 1,
  76: 1,
  77: 1,
  79: 2,
  80: 2,
  83: 1,
  85: 0,
  86: 1,
  89: 0,
  90: 1,
  94: 0,
  95: 0,
  97: 2,
  98: 1,
  99: 1,
  101: 3,
  102: 3,
  105: 1,
  106: 1,
  108: 2,
  111: 1,
  112: 1,
  113: 1,
  114: 1,
  117: 2,
  118: 1,
  119: 4,
  121: 1,
  126: 1,
  127: 1,
  128: 1,
  129: 1,
  130: 1,
  131: 1,
  133: 1,
  134: 1,
  135: 1,
  136: 2,
  137: 2,
  138: 2,
  140: 1,
  141: 1,
  142: 3,
  143: 4,
  144: 4,
  161: 1,
  162: 1,
  163: 1,
  164: 1,
  165: 2,
  172: 1,
  175: 2,
  176: 2,
  177: 3,
  178: 2,
  179: 1,
  184: 1,
  186: 1,
  189: 3,
  190: 1,
  195: 3,
  196: 3,
  197: 1,
  198: 1,
  199: 3,
  201: 1,
  207: 4,
  210: 3,
  211: 1,
  212: 2,
  213: 2,
  214: 1,
  215: 1,
  225: 0,
  229: 1,
  230: 1,
  231: 1,
  232: 1,
  233: 1,
  234: 1,
  235: 3,
  244: 1,
  247: 4,
  252: 2,
  257: 1,
  261: 1,
  271: 1,
  273: 4,
  274: 2,
  275: 2,
  276: 2,
  277: 3,
  278: 3,
  279: 1,
  280: 3,
  281: 3,
  282: 3,
  283: 1,
  284: 1,
  285: 2,
  286: 4,
  287: 3,
  288: 2,
  289: 4,
  290: 3,
  291: 3,
  292: 3,
  293: 4,
  294: 1,
  295: 3,
  296: 1,
  297: 3,
  298: 1,
  299: 2,
  300: 3,
  301: 3,
  302: 4,
  303: 2,
  304: 2,
  305: 2,
  306: 2,
  307: 2,
  308: 2,
  309: 3,
  310: 2,
  311: 2,
  312: 2,
  313: 2,
  314: 2,
  315: 2,
  316: 4,
  325: 2,
  326: 2,
  327: 2,
  328: 2,
  331: 2,
  332: 2,
  337: 2,
  342: 1,
  343: 1,
  346: 2,
  347: 1,
  350: 4,
  351: 3,
  352: 1,
  353: 2,
  360: 1,
  368: 1,
  369: 1,
  370: 1,
  371: 1,
  372: 1,
  373: 1,
  374: 1,
  375: 1,
  376: 1,
  377: 1,
  378: 1,
  382: 3,
  385: 1,
  392: 1,
  393: 1,
  396: 2,
  397: 2,
  398: 2,
  399: 1,
  400: 1,
  401: 1,
  402: 1,
  403: 1,
  404: 1,
  405: 1,
  406: 1,
  407: 1,
  408: 1,
  409: 1,
  410: 1,
  414: 4,
  415: 1,
  416: 1,
  417: 2,
  420: 1,
  421: 1,
  422: 2,
  424: 1,
  425: 2,
  426: 2,
  427: 2,
  428: 2,
  430: 3,
  438: 3,
  439: 3,
  440: 3,
  443: 2,
  444: 2,
  445: 2,
  446: 2,
  447: 6,
  448: 6,
  449: 2,
  450: 2,
  464: 2,
  468: 3,
  476: 2,
  479: 1,
  480: 2,
  65535: 0
};
function ods_to_csf_formula(f2) {
  if (f2.slice(0, 3) == "of:")
    f2 = f2.slice(3);
  if (f2.charCodeAt(0) == 61) {
    f2 = f2.slice(1);
    if (f2.charCodeAt(0) == 61)
      f2 = f2.slice(1);
  }
  f2 = f2.replace(/COM\.MICROSOFT\./g, "");
  f2 = f2.replace(/\[((?:\.[A-Z]+[0-9]+)(?::\.[A-Z]+[0-9]+)?)\]/g, function($$, $1) {
    return $1.replace(/\./g, "");
  });
  f2 = f2.replace(/\[.(#[A-Z]*[?!])\]/g, "$1");
  return f2.replace(/[;~]/g, ",").replace(/\|/g, ";");
}
function csf_to_ods_formula(f2) {
  var o2 = "of:=" + f2.replace(crefregex, "$1[.$2$3$4$5]").replace(/\]:\[/g, ":");
  return o2.replace(/;/g, "|").replace(/,/g, ";");
}
function ods_to_csf_3D(r) {
  var a2 = r.split(":");
  var s2 = a2[0].split(".")[0];
  return [s2, a2[0].split(".")[1] + (a2.length > 1 ? ":" + (a2[1].split(".")[1] || a2[1].split(".")[0]) : "")];
}
function csf_to_ods_3D(r) {
  return r.replace(/\./, "!");
}
var strs = {};
var _ssfopts = {};
var browser_has_Map = typeof Map !== "undefined";
function get_sst_id(sst, str, rev2) {
  var i2 = 0, len = sst.length;
  if (rev2) {
    if (browser_has_Map ? rev2.has(str) : Object.prototype.hasOwnProperty.call(rev2, str)) {
      var revarr = browser_has_Map ? rev2.get(str) : rev2[str];
      for (; i2 < revarr.length; ++i2) {
        if (sst[revarr[i2]].t === str) {
          sst.Count++;
          return revarr[i2];
        }
      }
    }
  } else
    for (; i2 < len; ++i2) {
      if (sst[i2].t === str) {
        sst.Count++;
        return i2;
      }
    }
  sst[len] = { t: str };
  sst.Count++;
  sst.Unique++;
  if (rev2) {
    if (browser_has_Map) {
      if (!rev2.has(str))
        rev2.set(str, []);
      rev2.get(str).push(len);
    } else {
      if (!Object.prototype.hasOwnProperty.call(rev2, str))
        rev2[str] = [];
      rev2[str].push(len);
    }
  }
  return len;
}
function col_obj_w(C2, col) {
  var p2 = { min: C2 + 1, max: C2 + 1 };
  var wch = -1;
  if (col.MDW)
    MDW = col.MDW;
  if (col.width != null)
    p2.customWidth = 1;
  else if (col.wpx != null)
    wch = px2char(col.wpx);
  else if (col.wch != null)
    wch = col.wch;
  if (wch > -1) {
    p2.width = char2width(wch);
    p2.customWidth = 1;
  } else if (col.width != null)
    p2.width = col.width;
  if (col.hidden)
    p2.hidden = true;
  if (col.level != null) {
    p2.outlineLevel = p2.level = col.level;
  }
  return p2;
}
function default_margins(margins, mode) {
  if (!margins)
    return;
  var defs = [0.7, 0.7, 0.75, 0.75, 0.3, 0.3];
  if (mode == "xlml")
    defs = [1, 1, 1, 1, 0.5, 0.5];
  if (margins.left == null)
    margins.left = defs[0];
  if (margins.right == null)
    margins.right = defs[1];
  if (margins.top == null)
    margins.top = defs[2];
  if (margins.bottom == null)
    margins.bottom = defs[3];
  if (margins.header == null)
    margins.header = defs[4];
  if (margins.footer == null)
    margins.footer = defs[5];
}
function get_cell_style(styles, cell, opts) {
  var z2 = opts.revssf[cell.z != null ? cell.z : "General"];
  var i2 = 60, len = styles.length;
  if (z2 == null && opts.ssf) {
    for (; i2 < 392; ++i2)
      if (opts.ssf[i2] == null) {
        SSF_load(cell.z, i2);
        opts.ssf[i2] = cell.z;
        opts.revssf[cell.z] = z2 = i2;
        break;
      }
  }
  for (i2 = 0; i2 != len; ++i2)
    if (styles[i2].numFmtId === z2)
      return i2;
  styles[len] = {
    numFmtId: z2,
    fontId: 0,
    fillId: 0,
    borderId: 0,
    xfId: 0,
    applyNumberFormat: 1
  };
  return len;
}
function safe_format(p2, fmtid, fillid, opts, themes, styles) {
  try {
    if (opts.cellNF)
      p2.z = table_fmt[fmtid];
  } catch (e) {
    if (opts.WTF)
      throw e;
  }
  if (p2.t === "z" && !opts.cellStyles)
    return;
  if (p2.t === "d" && typeof p2.v === "string")
    p2.v = parseDate(p2.v);
  if ((!opts || opts.cellText !== false) && p2.t !== "z")
    try {
      if (table_fmt[fmtid] == null)
        SSF_load(SSFImplicit[fmtid] || "General", fmtid);
      if (p2.t === "e")
        p2.w = p2.w || BErr[p2.v];
      else if (fmtid === 0) {
        if (p2.t === "n") {
          if ((p2.v | 0) === p2.v)
            p2.w = p2.v.toString(10);
          else
            p2.w = SSF_general_num(p2.v);
        } else if (p2.t === "d") {
          var dd = datenum(p2.v);
          if ((dd | 0) === dd)
            p2.w = dd.toString(10);
          else
            p2.w = SSF_general_num(dd);
        } else if (p2.v === void 0)
          return "";
        else
          p2.w = SSF_general(p2.v, _ssfopts);
      } else if (p2.t === "d")
        p2.w = SSF_format(fmtid, datenum(p2.v), _ssfopts);
      else
        p2.w = SSF_format(fmtid, p2.v, _ssfopts);
    } catch (e) {
      if (opts.WTF)
        throw e;
    }
  if (!opts.cellStyles)
    return;
  if (fillid != null)
    try {
      p2.s = styles.Fills[fillid];
      if (p2.s.fgColor && p2.s.fgColor.theme && !p2.s.fgColor.rgb) {
        p2.s.fgColor.rgb = rgb_tint(themes.themeElements.clrScheme[p2.s.fgColor.theme].rgb, p2.s.fgColor.tint || 0);
        if (opts.WTF)
          p2.s.fgColor.raw_rgb = themes.themeElements.clrScheme[p2.s.fgColor.theme].rgb;
      }
      if (p2.s.bgColor && p2.s.bgColor.theme) {
        p2.s.bgColor.rgb = rgb_tint(themes.themeElements.clrScheme[p2.s.bgColor.theme].rgb, p2.s.bgColor.tint || 0);
        if (opts.WTF)
          p2.s.bgColor.raw_rgb = themes.themeElements.clrScheme[p2.s.bgColor.theme].rgb;
      }
    } catch (e) {
      if (opts.WTF && styles.Fills)
        throw e;
    }
}
function check_ws(ws, sname, i2) {
  if (ws && ws["!ref"]) {
    var range = safe_decode_range(ws["!ref"]);
    if (range.e.c < range.s.c || range.e.r < range.s.r)
      throw new Error("Bad range (" + i2 + "): " + ws["!ref"]);
  }
}
function parse_ws_xml_dim(ws, s2) {
  var d2 = safe_decode_range(s2);
  if (d2.s.r <= d2.e.r && d2.s.c <= d2.e.c && d2.s.r >= 0 && d2.s.c >= 0)
    ws["!ref"] = encode_range(d2);
}
var mergecregex = /<(?:\w:)?mergeCell ref="[A-Z0-9:]+"\s*[\/]?>/g;
var sheetdataregex = /<(?:\w+:)?sheetData[^>]*>([\s\S]*)<\/(?:\w+:)?sheetData>/;
var hlinkregex = /<(?:\w:)?hyperlink [^>]*>/mg;
var dimregex = /"(\w*:\w*)"/;
var colregex = /<(?:\w:)?col\b[^>]*[\/]?>/g;
var afregex = /<(?:\w:)?autoFilter[^>]*([\/]|>([\s\S]*)<\/(?:\w:)?autoFilter)>/g;
var marginregex = /<(?:\w:)?pageMargins[^>]*\/>/g;
var sheetprregex = /<(?:\w:)?sheetPr\b(?:[^>a-z][^>]*)?\/>/;
var sheetprregex2 = /<(?:\w:)?sheetPr[^>]*(?:[\/]|>([\s\S]*)<\/(?:\w:)?sheetPr)>/;
var svsregex = /<(?:\w:)?sheetViews[^>]*(?:[\/]|>([\s\S]*)<\/(?:\w:)?sheetViews)>/;
function parse_ws_xml(data, opts, idx, rels, wb, themes, styles) {
  if (!data)
    return data;
  if (!rels)
    rels = { "!id": {} };
  if (DENSE != null && opts.dense == null)
    opts.dense = DENSE;
  var s2 = opts.dense ? [] : {};
  var refguess = { s: { r: 2e6, c: 2e6 }, e: { r: 0, c: 0 } };
  var data1 = "", data2 = "";
  var mtch = data.match(sheetdataregex);
  if (mtch) {
    data1 = data.slice(0, mtch.index);
    data2 = data.slice(mtch.index + mtch[0].length);
  } else
    data1 = data2 = data;
  var sheetPr = data1.match(sheetprregex);
  if (sheetPr)
    parse_ws_xml_sheetpr(sheetPr[0], s2, wb, idx);
  else if (sheetPr = data1.match(sheetprregex2))
    parse_ws_xml_sheetpr2(sheetPr[0], sheetPr[1] || "", s2, wb, idx, styles, themes);
  var ridx = (data1.match(/<(?:\w*:)?dimension/) || { index: -1 }).index;
  if (ridx > 0) {
    var ref = data1.slice(ridx, ridx + 50).match(dimregex);
    if (ref)
      parse_ws_xml_dim(s2, ref[1]);
  }
  var svs = data1.match(svsregex);
  if (svs && svs[1])
    parse_ws_xml_sheetviews(svs[1], wb);
  var columns = [];
  if (opts.cellStyles) {
    var cols = data1.match(colregex);
    if (cols)
      parse_ws_xml_cols(columns, cols);
  }
  if (mtch)
    parse_ws_xml_data(mtch[1], s2, opts, refguess, themes, styles);
  var afilter = data2.match(afregex);
  if (afilter)
    s2["!autofilter"] = parse_ws_xml_autofilter(afilter[0]);
  var merges = [];
  var _merge = data2.match(mergecregex);
  if (_merge)
    for (ridx = 0; ridx != _merge.length; ++ridx)
      merges[ridx] = safe_decode_range(_merge[ridx].slice(_merge[ridx].indexOf('"') + 1));
  var hlink = data2.match(hlinkregex);
  if (hlink)
    parse_ws_xml_hlinks(s2, hlink, rels);
  var margins = data2.match(marginregex);
  if (margins)
    s2["!margins"] = parse_ws_xml_margins(parsexmltag(margins[0]));
  if (!s2["!ref"] && refguess.e.c >= refguess.s.c && refguess.e.r >= refguess.s.r)
    s2["!ref"] = encode_range(refguess);
  if (opts.sheetRows > 0 && s2["!ref"]) {
    var tmpref = safe_decode_range(s2["!ref"]);
    if (opts.sheetRows <= +tmpref.e.r) {
      tmpref.e.r = opts.sheetRows - 1;
      if (tmpref.e.r > refguess.e.r)
        tmpref.e.r = refguess.e.r;
      if (tmpref.e.r < tmpref.s.r)
        tmpref.s.r = tmpref.e.r;
      if (tmpref.e.c > refguess.e.c)
        tmpref.e.c = refguess.e.c;
      if (tmpref.e.c < tmpref.s.c)
        tmpref.s.c = tmpref.e.c;
      s2["!fullref"] = s2["!ref"];
      s2["!ref"] = encode_range(tmpref);
    }
  }
  if (columns.length > 0)
    s2["!cols"] = columns;
  if (merges.length > 0)
    s2["!merges"] = merges;
  return s2;
}
function write_ws_xml_merges(merges) {
  if (merges.length === 0)
    return "";
  var o2 = '<mergeCells count="' + merges.length + '">';
  for (var i2 = 0; i2 != merges.length; ++i2)
    o2 += '<mergeCell ref="' + encode_range(merges[i2]) + '"/>';
  return o2 + "</mergeCells>";
}
function parse_ws_xml_sheetpr(sheetPr, s2, wb, idx) {
  var data = parsexmltag(sheetPr);
  if (!wb.Sheets[idx])
    wb.Sheets[idx] = {};
  if (data.codeName)
    wb.Sheets[idx].CodeName = unescapexml(utf8read(data.codeName));
}
function parse_ws_xml_sheetpr2(sheetPr, body, s2, wb, idx) {
  parse_ws_xml_sheetpr(sheetPr.slice(0, sheetPr.indexOf(">")), s2, wb, idx);
}
function write_ws_xml_sheetpr(ws, wb, idx, opts, o2) {
  var needed = false;
  var props = {}, payload = null;
  if (opts.bookType !== "xlsx" && wb.vbaraw) {
    var cname = wb.SheetNames[idx];
    try {
      if (wb.Workbook)
        cname = wb.Workbook.Sheets[idx].CodeName || cname;
    } catch (e) {
    }
    needed = true;
    props.codeName = utf8write(escapexml(cname));
  }
  if (ws && ws["!outline"]) {
    var outlineprops = { summaryBelow: 1, summaryRight: 1 };
    if (ws["!outline"].above)
      outlineprops.summaryBelow = 0;
    if (ws["!outline"].left)
      outlineprops.summaryRight = 0;
    payload = (payload || "") + writextag("outlinePr", null, outlineprops);
  }
  if (!needed && !payload)
    return;
  o2[o2.length] = writextag("sheetPr", payload, props);
}
var sheetprot_deffalse = ["objects", "scenarios", "selectLockedCells", "selectUnlockedCells"];
var sheetprot_deftrue = [
  "formatColumns",
  "formatRows",
  "formatCells",
  "insertColumns",
  "insertRows",
  "insertHyperlinks",
  "deleteColumns",
  "deleteRows",
  "sort",
  "autoFilter",
  "pivotTables"
];
function write_ws_xml_protection(sp) {
  var o2 = { sheet: 1 };
  sheetprot_deffalse.forEach(function(n2) {
    if (sp[n2] != null && sp[n2])
      o2[n2] = "1";
  });
  sheetprot_deftrue.forEach(function(n2) {
    if (sp[n2] != null && !sp[n2])
      o2[n2] = "0";
  });
  if (sp.password)
    o2.password = crypto_CreatePasswordVerifier_Method1(sp.password).toString(16).toUpperCase();
  return writextag("sheetProtection", null, o2);
}
function parse_ws_xml_hlinks(s2, data, rels) {
  var dense = Array.isArray(s2);
  for (var i2 = 0; i2 != data.length; ++i2) {
    var val = parsexmltag(utf8read(data[i2]), true);
    if (!val.ref)
      return;
    var rel = ((rels || {})["!id"] || [])[val.id];
    if (rel) {
      val.Target = rel.Target;
      if (val.location)
        val.Target += "#" + unescapexml(val.location);
    } else {
      val.Target = "#" + unescapexml(val.location);
      rel = { Target: val.Target, TargetMode: "Internal" };
    }
    val.Rel = rel;
    if (val.tooltip) {
      val.Tooltip = val.tooltip;
      delete val.tooltip;
    }
    var rng = safe_decode_range(val.ref);
    for (var R2 = rng.s.r; R2 <= rng.e.r; ++R2)
      for (var C2 = rng.s.c; C2 <= rng.e.c; ++C2) {
        var addr = encode_cell({ c: C2, r: R2 });
        if (dense) {
          if (!s2[R2])
            s2[R2] = [];
          if (!s2[R2][C2])
            s2[R2][C2] = { t: "z", v: void 0 };
          s2[R2][C2].l = val;
        } else {
          if (!s2[addr])
            s2[addr] = { t: "z", v: void 0 };
          s2[addr].l = val;
        }
      }
  }
}
function parse_ws_xml_margins(margin) {
  var o2 = {};
  ["left", "right", "top", "bottom", "header", "footer"].forEach(function(k2) {
    if (margin[k2])
      o2[k2] = parseFloat(margin[k2]);
  });
  return o2;
}
function write_ws_xml_margins(margin) {
  default_margins(margin);
  return writextag("pageMargins", null, margin);
}
function parse_ws_xml_cols(columns, cols) {
  var seencol = false;
  for (var coli = 0; coli != cols.length; ++coli) {
    var coll = parsexmltag(cols[coli], true);
    if (coll.hidden)
      coll.hidden = parsexmlbool(coll.hidden);
    var colm = parseInt(coll.min, 10) - 1, colM = parseInt(coll.max, 10) - 1;
    if (coll.outlineLevel)
      coll.level = +coll.outlineLevel || 0;
    delete coll.min;
    delete coll.max;
    coll.width = +coll.width;
    if (!seencol && coll.width) {
      seencol = true;
      find_mdw_colw(coll.width);
    }
    process_col(coll);
    while (colm <= colM)
      columns[colm++] = dup(coll);
  }
}
function write_ws_xml_cols(ws, cols) {
  var o2 = ["<cols>"], col;
  for (var i2 = 0; i2 != cols.length; ++i2) {
    if (!(col = cols[i2]))
      continue;
    o2[o2.length] = writextag("col", null, col_obj_w(i2, col));
  }
  o2[o2.length] = "</cols>";
  return o2.join("");
}
function parse_ws_xml_autofilter(data) {
  var o2 = { ref: (data.match(/ref="([^"]*)"/) || [])[1] };
  return o2;
}
function write_ws_xml_autofilter(data, ws, wb, idx) {
  var ref = typeof data.ref == "string" ? data.ref : encode_range(data.ref);
  if (!wb.Workbook)
    wb.Workbook = { Sheets: [] };
  if (!wb.Workbook.Names)
    wb.Workbook.Names = [];
  var names = wb.Workbook.Names;
  var range = decode_range(ref);
  if (range.s.r == range.e.r) {
    range.e.r = decode_range(ws["!ref"]).e.r;
    ref = encode_range(range);
  }
  for (var i2 = 0; i2 < names.length; ++i2) {
    var name = names[i2];
    if (name.Name != "_xlnm._FilterDatabase")
      continue;
    if (name.Sheet != idx)
      continue;
    name.Ref = "'" + wb.SheetNames[idx] + "'!" + ref;
    break;
  }
  if (i2 == names.length)
    names.push({ Name: "_xlnm._FilterDatabase", Sheet: idx, Ref: "'" + wb.SheetNames[idx] + "'!" + ref });
  return writextag("autoFilter", null, { ref });
}
var sviewregex = /<(?:\w:)?sheetView(?:[^>a-z][^>]*)?\/?>/;
function parse_ws_xml_sheetviews(data, wb) {
  if (!wb.Views)
    wb.Views = [{}];
  (data.match(sviewregex) || []).forEach(function(r, i2) {
    var tag = parsexmltag(r);
    if (!wb.Views[i2])
      wb.Views[i2] = {};
    if (+tag.zoomScale)
      wb.Views[i2].zoom = +tag.zoomScale;
    if (parsexmlbool(tag.rightToLeft))
      wb.Views[i2].RTL = true;
  });
}
function write_ws_xml_sheetviews(ws, opts, idx, wb) {
  var sview = { workbookViewId: "0" };
  if ((((wb || {}).Workbook || {}).Views || [])[0])
    sview.rightToLeft = wb.Workbook.Views[0].RTL ? "1" : "0";
  return writextag("sheetViews", writextag("sheetView", null, sview), {});
}
function write_ws_xml_cell(cell, ref, ws, opts) {
  if (cell.c)
    ws["!comments"].push([ref, cell.c]);
  if (cell.v === void 0 && typeof cell.f !== "string" || cell.t === "z" && !cell.f)
    return "";
  var vv = "";
  var oldt = cell.t, oldv = cell.v;
  if (cell.t !== "z")
    switch (cell.t) {
      case "b":
        vv = cell.v ? "1" : "0";
        break;
      case "n":
        vv = "" + cell.v;
        break;
      case "e":
        vv = BErr[cell.v];
        break;
      case "d":
        if (opts && opts.cellDates)
          vv = parseDate(cell.v, -1).toISOString();
        else {
          cell = dup(cell);
          cell.t = "n";
          vv = "" + (cell.v = datenum(parseDate(cell.v)));
        }
        if (typeof cell.z === "undefined")
          cell.z = table_fmt[14];
        break;
      default:
        vv = cell.v;
        break;
    }
  var v2 = writetag("v", escapexml(vv)), o2 = { r: ref };
  var os = get_cell_style(opts.cellXfs, cell, opts);
  if (os !== 0)
    o2.s = os;
  switch (cell.t) {
    case "n":
      break;
    case "d":
      o2.t = "d";
      break;
    case "b":
      o2.t = "b";
      break;
    case "e":
      o2.t = "e";
      break;
    case "z":
      break;
    default:
      if (cell.v == null) {
        delete cell.t;
        break;
      }
      if (cell.v.length > 32767)
        throw new Error("Text length must not exceed 32767 characters");
      if (opts && opts.bookSST) {
        v2 = writetag("v", "" + get_sst_id(opts.Strings, cell.v, opts.revStrings));
        o2.t = "s";
        break;
      }
      o2.t = "str";
      break;
  }
  if (cell.t != oldt) {
    cell.t = oldt;
    cell.v = oldv;
  }
  if (typeof cell.f == "string" && cell.f) {
    var ff = cell.F && cell.F.slice(0, ref.length) == ref ? { t: "array", ref: cell.F } : null;
    v2 = writextag("f", escapexml(cell.f), ff) + (cell.v != null ? v2 : "");
  }
  if (cell.l)
    ws["!links"].push([ref, cell.l]);
  if (cell.D)
    o2.cm = 1;
  return writextag("c", v2, o2);
}
var parse_ws_xml_data = /* @__PURE__ */ function() {
  var cellregex = /<(?:\w+:)?c[ \/>]/, rowregex = /<\/(?:\w+:)?row>/;
  var rregex = /r=["']([^"']*)["']/, isregex = /<(?:\w+:)?is>([\S\s]*?)<\/(?:\w+:)?is>/;
  var refregex = /ref=["']([^"']*)["']/;
  var match_v = matchtag("v"), match_f = matchtag("f");
  return function parse_ws_xml_data2(sdata, s2, opts, guess, themes, styles) {
    var ri = 0, x2 = "", cells = [], cref = [], idx = 0, i2 = 0, cc = 0, d2 = "", p2;
    var tag, tagr = 0, tagc = 0;
    var sstr, ftag;
    var fmtid = 0, fillid = 0;
    var do_format = Array.isArray(styles.CellXf), cf;
    var arrayf = [];
    var sharedf = [];
    var dense = Array.isArray(s2);
    var rows = [], rowobj = {}, rowrite = false;
    var sheetStubs = !!opts.sheetStubs;
    for (var marr = sdata.split(rowregex), mt2 = 0, marrlen = marr.length; mt2 != marrlen; ++mt2) {
      x2 = marr[mt2].trim();
      var xlen = x2.length;
      if (xlen === 0)
        continue;
      var rstarti = 0;
      outa:
        for (ri = 0; ri < xlen; ++ri)
          switch (
            /*x.charCodeAt(ri)*/
            x2[ri]
          ) {
            case ">":
              if (
                /*x.charCodeAt(ri-1) != 47*/
                x2[ri - 1] != "/"
              ) {
                ++ri;
                break outa;
              }
              if (opts && opts.cellStyles) {
                tag = parsexmltag(x2.slice(rstarti, ri), true);
                tagr = tag.r != null ? parseInt(tag.r, 10) : tagr + 1;
                tagc = -1;
                if (opts.sheetRows && opts.sheetRows < tagr)
                  continue;
                rowobj = {};
                rowrite = false;
                if (tag.ht) {
                  rowrite = true;
                  rowobj.hpt = parseFloat(tag.ht);
                  rowobj.hpx = pt2px(rowobj.hpt);
                }
                if (tag.hidden == "1") {
                  rowrite = true;
                  rowobj.hidden = true;
                }
                if (tag.outlineLevel != null) {
                  rowrite = true;
                  rowobj.level = +tag.outlineLevel;
                }
                if (rowrite)
                  rows[tagr - 1] = rowobj;
              }
              break;
            case "<":
              rstarti = ri;
              break;
          }
      if (rstarti >= ri)
        break;
      tag = parsexmltag(x2.slice(rstarti, ri), true);
      tagr = tag.r != null ? parseInt(tag.r, 10) : tagr + 1;
      tagc = -1;
      if (opts.sheetRows && opts.sheetRows < tagr)
        continue;
      if (guess.s.r > tagr - 1)
        guess.s.r = tagr - 1;
      if (guess.e.r < tagr - 1)
        guess.e.r = tagr - 1;
      if (opts && opts.cellStyles) {
        rowobj = {};
        rowrite = false;
        if (tag.ht) {
          rowrite = true;
          rowobj.hpt = parseFloat(tag.ht);
          rowobj.hpx = pt2px(rowobj.hpt);
        }
        if (tag.hidden == "1") {
          rowrite = true;
          rowobj.hidden = true;
        }
        if (tag.outlineLevel != null) {
          rowrite = true;
          rowobj.level = +tag.outlineLevel;
        }
        if (rowrite)
          rows[tagr - 1] = rowobj;
      }
      cells = x2.slice(ri).split(cellregex);
      for (var rslice = 0; rslice != cells.length; ++rslice)
        if (cells[rslice].trim().charAt(0) != "<")
          break;
      cells = cells.slice(rslice);
      for (ri = 0; ri != cells.length; ++ri) {
        x2 = cells[ri].trim();
        if (x2.length === 0)
          continue;
        cref = x2.match(rregex);
        idx = ri;
        i2 = 0;
        cc = 0;
        x2 = "<c " + (x2.slice(0, 1) == "<" ? ">" : "") + x2;
        if (cref != null && cref.length === 2) {
          idx = 0;
          d2 = cref[1];
          for (i2 = 0; i2 != d2.length; ++i2) {
            if ((cc = d2.charCodeAt(i2) - 64) < 1 || cc > 26)
              break;
            idx = 26 * idx + cc;
          }
          --idx;
          tagc = idx;
        } else
          ++tagc;
        for (i2 = 0; i2 != x2.length; ++i2)
          if (x2.charCodeAt(i2) === 62)
            break;
        ++i2;
        tag = parsexmltag(x2.slice(0, i2), true);
        if (!tag.r)
          tag.r = encode_cell({ r: tagr - 1, c: tagc });
        d2 = x2.slice(i2);
        p2 = { t: "" };
        if ((cref = d2.match(match_v)) != null && /*::cref != null && */
        cref[1] !== "")
          p2.v = unescapexml(cref[1]);
        if (opts.cellFormula) {
          if ((cref = d2.match(match_f)) != null && /*::cref != null && */
          cref[1] !== "") {
            p2.f = unescapexml(utf8read(cref[1])).replace(/\r\n/g, "\n");
            if (!opts.xlfn)
              p2.f = _xlfn(p2.f);
            if (
              /*::cref != null && cref[0] != null && */
              cref[0].indexOf('t="array"') > -1
            ) {
              p2.F = (d2.match(refregex) || [])[1];
              if (p2.F.indexOf(":") > -1)
                arrayf.push([safe_decode_range(p2.F), p2.F]);
            } else if (
              /*::cref != null && cref[0] != null && */
              cref[0].indexOf('t="shared"') > -1
            ) {
              ftag = parsexmltag(cref[0]);
              var ___f = unescapexml(utf8read(cref[1]));
              if (!opts.xlfn)
                ___f = _xlfn(___f);
              sharedf[parseInt(ftag.si, 10)] = [ftag, ___f, tag.r];
            }
          } else if (cref = d2.match(/<f[^>]*\/>/)) {
            ftag = parsexmltag(cref[0]);
            if (sharedf[ftag.si])
              p2.f = shift_formula_xlsx(sharedf[ftag.si][1], sharedf[ftag.si][2], tag.r);
          }
          var _tag = decode_cell(tag.r);
          for (i2 = 0; i2 < arrayf.length; ++i2)
            if (_tag.r >= arrayf[i2][0].s.r && _tag.r <= arrayf[i2][0].e.r) {
              if (_tag.c >= arrayf[i2][0].s.c && _tag.c <= arrayf[i2][0].e.c)
                p2.F = arrayf[i2][1];
            }
        }
        if (tag.t == null && p2.v === void 0) {
          if (p2.f || p2.F) {
            p2.v = 0;
            p2.t = "n";
          } else if (!sheetStubs)
            continue;
          else
            p2.t = "z";
        } else
          p2.t = tag.t || "n";
        if (guess.s.c > tagc)
          guess.s.c = tagc;
        if (guess.e.c < tagc)
          guess.e.c = tagc;
        switch (p2.t) {
          case "n":
            if (p2.v == "" || p2.v == null) {
              if (!sheetStubs)
                continue;
              p2.t = "z";
            } else
              p2.v = parseFloat(p2.v);
            break;
          case "s":
            if (typeof p2.v == "undefined") {
              if (!sheetStubs)
                continue;
              p2.t = "z";
            } else {
              sstr = strs[parseInt(p2.v, 10)];
              p2.v = sstr.t;
              p2.r = sstr.r;
              if (opts.cellHTML)
                p2.h = sstr.h;
            }
            break;
          case "str":
            p2.t = "s";
            p2.v = p2.v != null ? utf8read(p2.v) : "";
            if (opts.cellHTML)
              p2.h = escapehtml(p2.v);
            break;
          case "inlineStr":
            cref = d2.match(isregex);
            p2.t = "s";
            if (cref != null && (sstr = parse_si(cref[1]))) {
              p2.v = sstr.t;
              if (opts.cellHTML)
                p2.h = sstr.h;
            } else
              p2.v = "";
            break;
          case "b":
            p2.v = parsexmlbool(p2.v);
            break;
          case "d":
            if (opts.cellDates)
              p2.v = parseDate(p2.v, 1);
            else {
              p2.v = datenum(parseDate(p2.v, 1));
              p2.t = "n";
            }
            break;
          case "e":
            if (!opts || opts.cellText !== false)
              p2.w = p2.v;
            p2.v = RBErr[p2.v];
            break;
        }
        fmtid = fillid = 0;
        cf = null;
        if (do_format && tag.s !== void 0) {
          cf = styles.CellXf[tag.s];
          if (cf != null) {
            if (cf.numFmtId != null)
              fmtid = cf.numFmtId;
            if (opts.cellStyles) {
              if (cf.fillId != null)
                fillid = cf.fillId;
            }
          }
        }
        safe_format(p2, fmtid, fillid, opts, themes, styles);
        if (opts.cellDates && do_format && p2.t == "n" && fmt_is_date(table_fmt[fmtid])) {
          p2.t = "d";
          p2.v = numdate(p2.v);
        }
        if (tag.cm && opts.xlmeta) {
          var cm = (opts.xlmeta.Cell || [])[+tag.cm - 1];
          if (cm && cm.type == "XLDAPR")
            p2.D = true;
        }
        if (dense) {
          var _r = decode_cell(tag.r);
          if (!s2[_r.r])
            s2[_r.r] = [];
          s2[_r.r][_r.c] = p2;
        } else
          s2[tag.r] = p2;
      }
    }
    if (rows.length > 0)
      s2["!rows"] = rows;
  };
}();
function write_ws_xml_data(ws, opts, idx, wb) {
  var o2 = [], r = [], range = safe_decode_range(ws["!ref"]), cell = "", ref, rr = "", cols = [], R2 = 0, C2 = 0, rows = ws["!rows"];
  var dense = Array.isArray(ws);
  var params = { r: rr }, row, height = -1;
  for (C2 = range.s.c; C2 <= range.e.c; ++C2)
    cols[C2] = encode_col(C2);
  for (R2 = range.s.r; R2 <= range.e.r; ++R2) {
    r = [];
    rr = encode_row(R2);
    for (C2 = range.s.c; C2 <= range.e.c; ++C2) {
      ref = cols[C2] + rr;
      var _cell = dense ? (ws[R2] || [])[C2] : ws[ref];
      if (_cell === void 0)
        continue;
      if ((cell = write_ws_xml_cell(_cell, ref, ws, opts, idx, wb)) != null)
        r.push(cell);
    }
    if (r.length > 0 || rows && rows[R2]) {
      params = { r: rr };
      if (rows && rows[R2]) {
        row = rows[R2];
        if (row.hidden)
          params.hidden = 1;
        height = -1;
        if (row.hpx)
          height = px2pt(row.hpx);
        else if (row.hpt)
          height = row.hpt;
        if (height > -1) {
          params.ht = height;
          params.customHeight = 1;
        }
        if (row.level) {
          params.outlineLevel = row.level;
        }
      }
      o2[o2.length] = writextag("row", r.join(""), params);
    }
  }
  if (rows)
    for (; R2 < rows.length; ++R2) {
      if (rows && rows[R2]) {
        params = { r: R2 + 1 };
        row = rows[R2];
        if (row.hidden)
          params.hidden = 1;
        height = -1;
        if (row.hpx)
          height = px2pt(row.hpx);
        else if (row.hpt)
          height = row.hpt;
        if (height > -1) {
          params.ht = height;
          params.customHeight = 1;
        }
        if (row.level) {
          params.outlineLevel = row.level;
        }
        o2[o2.length] = writextag("row", "", params);
      }
    }
  return o2.join("");
}
function write_ws_xml(idx, opts, wb, rels) {
  var o2 = [XML_HEADER, writextag("worksheet", null, {
    "xmlns": XMLNS_main[0],
    "xmlns:r": XMLNS.r
  })];
  var s2 = wb.SheetNames[idx], sidx = 0, rdata = "";
  var ws = wb.Sheets[s2];
  if (ws == null)
    ws = {};
  var ref = ws["!ref"] || "A1";
  var range = safe_decode_range(ref);
  if (range.e.c > 16383 || range.e.r > 1048575) {
    if (opts.WTF)
      throw new Error("Range " + ref + " exceeds format limit A1:XFD1048576");
    range.e.c = Math.min(range.e.c, 16383);
    range.e.r = Math.min(range.e.c, 1048575);
    ref = encode_range(range);
  }
  if (!rels)
    rels = {};
  ws["!comments"] = [];
  var _drawing = [];
  write_ws_xml_sheetpr(ws, wb, idx, opts, o2);
  o2[o2.length] = writextag("dimension", null, { "ref": ref });
  o2[o2.length] = write_ws_xml_sheetviews(ws, opts, idx, wb);
  if (opts.sheetFormat)
    o2[o2.length] = writextag("sheetFormatPr", null, {
      defaultRowHeight: opts.sheetFormat.defaultRowHeight || "16",
      baseColWidth: opts.sheetFormat.baseColWidth || "10",
      outlineLevelRow: opts.sheetFormat.outlineLevelRow || "7"
    });
  if (ws["!cols"] != null && ws["!cols"].length > 0)
    o2[o2.length] = write_ws_xml_cols(ws, ws["!cols"]);
  o2[sidx = o2.length] = "<sheetData/>";
  ws["!links"] = [];
  if (ws["!ref"] != null) {
    rdata = write_ws_xml_data(ws, opts, idx, wb, rels);
    if (rdata.length > 0)
      o2[o2.length] = rdata;
  }
  if (o2.length > sidx + 1) {
    o2[o2.length] = "</sheetData>";
    o2[sidx] = o2[sidx].replace("/>", ">");
  }
  if (ws["!protect"])
    o2[o2.length] = write_ws_xml_protection(ws["!protect"]);
  if (ws["!autofilter"] != null)
    o2[o2.length] = write_ws_xml_autofilter(ws["!autofilter"], ws, wb, idx);
  if (ws["!merges"] != null && ws["!merges"].length > 0)
    o2[o2.length] = write_ws_xml_merges(ws["!merges"]);
  var relc = -1, rel, rId = -1;
  if (
    /*::(*/
    ws["!links"].length > 0
  ) {
    o2[o2.length] = "<hyperlinks>";
    ws["!links"].forEach(function(l2) {
      if (!l2[1].Target)
        return;
      rel = { "ref": l2[0] };
      if (l2[1].Target.charAt(0) != "#") {
        rId = add_rels(rels, -1, escapexml(l2[1].Target).replace(/#.*$/, ""), RELS.HLINK);
        rel["r:id"] = "rId" + rId;
      }
      if ((relc = l2[1].Target.indexOf("#")) > -1)
        rel.location = escapexml(l2[1].Target.slice(relc + 1));
      if (l2[1].Tooltip)
        rel.tooltip = escapexml(l2[1].Tooltip);
      o2[o2.length] = writextag("hyperlink", null, rel);
    });
    o2[o2.length] = "</hyperlinks>";
  }
  delete ws["!links"];
  if (ws["!margins"] != null)
    o2[o2.length] = write_ws_xml_margins(ws["!margins"]);
  if (!opts || opts.ignoreEC || opts.ignoreEC == void 0)
    o2[o2.length] = writetag("ignoredErrors", writextag("ignoredError", null, { numberStoredAsText: 1, sqref: ref }));
  if (_drawing.length > 0) {
    rId = add_rels(rels, -1, "../drawings/drawing" + (idx + 1) + ".xml", RELS.DRAW);
    o2[o2.length] = writextag("drawing", null, { "r:id": "rId" + rId });
    ws["!drawing"] = _drawing;
  }
  if (ws["!comments"].length > 0) {
    rId = add_rels(rels, -1, "../drawings/vmlDrawing" + (idx + 1) + ".vml", RELS.VML);
    o2[o2.length] = writextag("legacyDrawing", null, { "r:id": "rId" + rId });
    ws["!legacy"] = rId;
  }
  if (o2.length > 1) {
    o2[o2.length] = "</worksheet>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
function parse_BrtRowHdr(data, length) {
  var z2 = {};
  var tgt = data.l + length;
  z2.r = data.read_shift(4);
  data.l += 4;
  var miyRw = data.read_shift(2);
  data.l += 1;
  var flags = data.read_shift(1);
  data.l = tgt;
  if (flags & 7)
    z2.level = flags & 7;
  if (flags & 16)
    z2.hidden = true;
  if (flags & 32)
    z2.hpt = miyRw / 20;
  return z2;
}
function write_BrtRowHdr(R2, range, ws) {
  var o2 = new_buf(17 + 8 * 16);
  var row = (ws["!rows"] || [])[R2] || {};
  o2.write_shift(4, R2);
  o2.write_shift(4, 0);
  var miyRw = 320;
  if (row.hpx)
    miyRw = px2pt(row.hpx) * 20;
  else if (row.hpt)
    miyRw = row.hpt * 20;
  o2.write_shift(2, miyRw);
  o2.write_shift(1, 0);
  var flags = 0;
  if (row.level)
    flags |= row.level;
  if (row.hidden)
    flags |= 16;
  if (row.hpx || row.hpt)
    flags |= 32;
  o2.write_shift(1, flags);
  o2.write_shift(1, 0);
  var ncolspan = 0, lcs = o2.l;
  o2.l += 4;
  var caddr = { r: R2, c: 0 };
  for (var i2 = 0; i2 < 16; ++i2) {
    if (range.s.c > i2 + 1 << 10 || range.e.c < i2 << 10)
      continue;
    var first = -1, last = -1;
    for (var j2 = i2 << 10; j2 < i2 + 1 << 10; ++j2) {
      caddr.c = j2;
      var cell = Array.isArray(ws) ? (ws[caddr.r] || [])[caddr.c] : ws[encode_cell(caddr)];
      if (cell) {
        if (first < 0)
          first = j2;
        last = j2;
      }
    }
    if (first < 0)
      continue;
    ++ncolspan;
    o2.write_shift(4, first);
    o2.write_shift(4, last);
  }
  var l2 = o2.l;
  o2.l = lcs;
  o2.write_shift(4, ncolspan);
  o2.l = l2;
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function write_row_header(ba, ws, range, R2) {
  var o2 = write_BrtRowHdr(R2, range, ws);
  if (o2.length > 17 || (ws["!rows"] || [])[R2])
    write_record(ba, 0, o2);
}
var parse_BrtWsDim = parse_UncheckedRfX;
var write_BrtWsDim = write_UncheckedRfX;
function parse_BrtWsFmtInfo() {
}
function parse_BrtWsProp(data, length) {
  var z2 = {};
  var f2 = data[data.l];
  ++data.l;
  z2.above = !(f2 & 64);
  z2.left = !(f2 & 128);
  data.l += 18;
  z2.name = parse_XLSBCodeName(data, length - 19);
  return z2;
}
function write_BrtWsProp(str, outl, o2) {
  if (o2 == null)
    o2 = new_buf(84 + 4 * str.length);
  var f2 = 192;
  if (outl) {
    if (outl.above)
      f2 &= ~64;
    if (outl.left)
      f2 &= ~128;
  }
  o2.write_shift(1, f2);
  for (var i2 = 1; i2 < 3; ++i2)
    o2.write_shift(1, 0);
  write_BrtColor({ auto: 1 }, o2);
  o2.write_shift(-4, -1);
  o2.write_shift(-4, -1);
  write_XLSBCodeName(str, o2);
  return o2.slice(0, o2.l);
}
function parse_BrtCellBlank(data) {
  var cell = parse_XLSBCell(data);
  return [cell];
}
function write_BrtCellBlank(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(8);
  return write_XLSBCell(ncell, o2);
}
function parse_BrtShortBlank(data) {
  var cell = parse_XLSBShortCell(data);
  return [cell];
}
function write_BrtShortBlank(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(4);
  return write_XLSBShortCell(ncell, o2);
}
function parse_BrtCellBool(data) {
  var cell = parse_XLSBCell(data);
  var fBool = data.read_shift(1);
  return [cell, fBool, "b"];
}
function write_BrtCellBool(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(9);
  write_XLSBCell(ncell, o2);
  o2.write_shift(1, cell.v ? 1 : 0);
  return o2;
}
function parse_BrtShortBool(data) {
  var cell = parse_XLSBShortCell(data);
  var fBool = data.read_shift(1);
  return [cell, fBool, "b"];
}
function write_BrtShortBool(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(5);
  write_XLSBShortCell(ncell, o2);
  o2.write_shift(1, cell.v ? 1 : 0);
  return o2;
}
function parse_BrtCellError(data) {
  var cell = parse_XLSBCell(data);
  var bError = data.read_shift(1);
  return [cell, bError, "e"];
}
function write_BrtCellError(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(9);
  write_XLSBCell(ncell, o2);
  o2.write_shift(1, cell.v);
  return o2;
}
function parse_BrtShortError(data) {
  var cell = parse_XLSBShortCell(data);
  var bError = data.read_shift(1);
  return [cell, bError, "e"];
}
function write_BrtShortError(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(8);
  write_XLSBShortCell(ncell, o2);
  o2.write_shift(1, cell.v);
  o2.write_shift(2, 0);
  o2.write_shift(1, 0);
  return o2;
}
function parse_BrtCellIsst(data) {
  var cell = parse_XLSBCell(data);
  var isst = data.read_shift(4);
  return [cell, isst, "s"];
}
function write_BrtCellIsst(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(12);
  write_XLSBCell(ncell, o2);
  o2.write_shift(4, ncell.v);
  return o2;
}
function parse_BrtShortIsst(data) {
  var cell = parse_XLSBShortCell(data);
  var isst = data.read_shift(4);
  return [cell, isst, "s"];
}
function write_BrtShortIsst(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(8);
  write_XLSBShortCell(ncell, o2);
  o2.write_shift(4, ncell.v);
  return o2;
}
function parse_BrtCellReal(data) {
  var cell = parse_XLSBCell(data);
  var value = parse_Xnum(data);
  return [cell, value, "n"];
}
function write_BrtCellReal(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(16);
  write_XLSBCell(ncell, o2);
  write_Xnum(cell.v, o2);
  return o2;
}
function parse_BrtShortReal(data) {
  var cell = parse_XLSBShortCell(data);
  var value = parse_Xnum(data);
  return [cell, value, "n"];
}
function write_BrtShortReal(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(12);
  write_XLSBShortCell(ncell, o2);
  write_Xnum(cell.v, o2);
  return o2;
}
function parse_BrtCellRk(data) {
  var cell = parse_XLSBCell(data);
  var value = parse_RkNumber(data);
  return [cell, value, "n"];
}
function write_BrtCellRk(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(12);
  write_XLSBCell(ncell, o2);
  write_RkNumber(cell.v, o2);
  return o2;
}
function parse_BrtShortRk(data) {
  var cell = parse_XLSBShortCell(data);
  var value = parse_RkNumber(data);
  return [cell, value, "n"];
}
function write_BrtShortRk(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(8);
  write_XLSBShortCell(ncell, o2);
  write_RkNumber(cell.v, o2);
  return o2;
}
function parse_BrtCellRString(data) {
  var cell = parse_XLSBCell(data);
  var value = parse_RichStr(data);
  return [cell, value, "is"];
}
function parse_BrtCellSt(data) {
  var cell = parse_XLSBCell(data);
  var value = parse_XLWideString(data);
  return [cell, value, "str"];
}
function write_BrtCellSt(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(12 + 4 * cell.v.length);
  write_XLSBCell(ncell, o2);
  write_XLWideString(cell.v, o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function parse_BrtShortSt(data) {
  var cell = parse_XLSBShortCell(data);
  var value = parse_XLWideString(data);
  return [cell, value, "str"];
}
function write_BrtShortSt(cell, ncell, o2) {
  if (o2 == null)
    o2 = new_buf(8 + 4 * cell.v.length);
  write_XLSBShortCell(ncell, o2);
  write_XLWideString(cell.v, o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function parse_BrtFmlaBool(data, length, opts) {
  var end = data.l + length;
  var cell = parse_XLSBCell(data);
  cell.r = opts["!row"];
  var value = data.read_shift(1);
  var o2 = [cell, value, "b"];
  if (opts.cellFormula) {
    data.l += 2;
    var formula = parse_XLSBCellParsedFormula(data, end - data.l, opts);
    o2[3] = stringify_formula(formula, null, cell, opts.supbooks, opts);
  } else
    data.l = end;
  return o2;
}
function parse_BrtFmlaError(data, length, opts) {
  var end = data.l + length;
  var cell = parse_XLSBCell(data);
  cell.r = opts["!row"];
  var value = data.read_shift(1);
  var o2 = [cell, value, "e"];
  if (opts.cellFormula) {
    data.l += 2;
    var formula = parse_XLSBCellParsedFormula(data, end - data.l, opts);
    o2[3] = stringify_formula(formula, null, cell, opts.supbooks, opts);
  } else
    data.l = end;
  return o2;
}
function parse_BrtFmlaNum(data, length, opts) {
  var end = data.l + length;
  var cell = parse_XLSBCell(data);
  cell.r = opts["!row"];
  var value = parse_Xnum(data);
  var o2 = [cell, value, "n"];
  if (opts.cellFormula) {
    data.l += 2;
    var formula = parse_XLSBCellParsedFormula(data, end - data.l, opts);
    o2[3] = stringify_formula(formula, null, cell, opts.supbooks, opts);
  } else
    data.l = end;
  return o2;
}
function parse_BrtFmlaString(data, length, opts) {
  var end = data.l + length;
  var cell = parse_XLSBCell(data);
  cell.r = opts["!row"];
  var value = parse_XLWideString(data);
  var o2 = [cell, value, "str"];
  if (opts.cellFormula) {
    data.l += 2;
    var formula = parse_XLSBCellParsedFormula(data, end - data.l, opts);
    o2[3] = stringify_formula(formula, null, cell, opts.supbooks, opts);
  } else
    data.l = end;
  return o2;
}
var parse_BrtMergeCell = parse_UncheckedRfX;
var write_BrtMergeCell = write_UncheckedRfX;
function write_BrtBeginMergeCells(cnt, o2) {
  if (o2 == null)
    o2 = new_buf(4);
  o2.write_shift(4, cnt);
  return o2;
}
function parse_BrtHLink(data, length) {
  var end = data.l + length;
  var rfx = parse_UncheckedRfX(data, 16);
  var relId = parse_XLNullableWideString(data);
  var loc = parse_XLWideString(data);
  var tooltip = parse_XLWideString(data);
  var display = parse_XLWideString(data);
  data.l = end;
  var o2 = { rfx, relId, loc, display };
  if (tooltip)
    o2.Tooltip = tooltip;
  return o2;
}
function write_BrtHLink(l2, rId) {
  var o2 = new_buf(50 + 4 * (l2[1].Target.length + (l2[1].Tooltip || "").length));
  write_UncheckedRfX({ s: decode_cell(l2[0]), e: decode_cell(l2[0]) }, o2);
  write_RelID("rId" + rId, o2);
  var locidx = l2[1].Target.indexOf("#");
  var loc = locidx == -1 ? "" : l2[1].Target.slice(locidx + 1);
  write_XLWideString(loc || "", o2);
  write_XLWideString(l2[1].Tooltip || "", o2);
  write_XLWideString("", o2);
  return o2.slice(0, o2.l);
}
function parse_BrtPane() {
}
function parse_BrtArrFmla(data, length, opts) {
  var end = data.l + length;
  var rfx = parse_RfX(data, 16);
  var fAlwaysCalc = data.read_shift(1);
  var o2 = [rfx];
  o2[2] = fAlwaysCalc;
  if (opts.cellFormula) {
    var formula = parse_XLSBArrayParsedFormula(data, end - data.l, opts);
    o2[1] = formula;
  } else
    data.l = end;
  return o2;
}
function parse_BrtShrFmla(data, length, opts) {
  var end = data.l + length;
  var rfx = parse_UncheckedRfX(data, 16);
  var o2 = [rfx];
  if (opts.cellFormula) {
    var formula = parse_XLSBSharedParsedFormula(data, end - data.l, opts);
    o2[1] = formula;
    data.l = end;
  } else
    data.l = end;
  return o2;
}
function write_BrtColInfo(C2, col, o2) {
  if (o2 == null)
    o2 = new_buf(18);
  var p2 = col_obj_w(C2, col);
  o2.write_shift(-4, C2);
  o2.write_shift(-4, C2);
  o2.write_shift(4, (p2.width || 10) * 256);
  o2.write_shift(
    4,
    0
    /*ixfe*/
  );
  var flags = 0;
  if (col.hidden)
    flags |= 1;
  if (typeof p2.width == "number")
    flags |= 2;
  if (col.level)
    flags |= col.level << 8;
  o2.write_shift(2, flags);
  return o2;
}
var BrtMarginKeys = ["left", "right", "top", "bottom", "header", "footer"];
function parse_BrtMargins(data) {
  var margins = {};
  BrtMarginKeys.forEach(function(k2) {
    margins[k2] = parse_Xnum(data, 8);
  });
  return margins;
}
function write_BrtMargins(margins, o2) {
  if (o2 == null)
    o2 = new_buf(6 * 8);
  default_margins(margins);
  BrtMarginKeys.forEach(function(k2) {
    write_Xnum(margins[k2], o2);
  });
  return o2;
}
function parse_BrtBeginWsView(data) {
  var f2 = data.read_shift(2);
  data.l += 28;
  return { RTL: f2 & 32 };
}
function write_BrtBeginWsView(ws, Workbook, o2) {
  if (o2 == null)
    o2 = new_buf(30);
  var f2 = 924;
  if ((((Workbook || {}).Views || [])[0] || {}).RTL)
    f2 |= 32;
  o2.write_shift(2, f2);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  o2.write_shift(1, 0);
  o2.write_shift(1, 0);
  o2.write_shift(2, 0);
  o2.write_shift(2, 100);
  o2.write_shift(2, 0);
  o2.write_shift(2, 0);
  o2.write_shift(2, 0);
  o2.write_shift(4, 0);
  return o2;
}
function write_BrtCellIgnoreEC(ref) {
  var o2 = new_buf(24);
  o2.write_shift(4, 4);
  o2.write_shift(4, 1);
  write_UncheckedRfX(ref, o2);
  return o2;
}
function write_BrtSheetProtection(sp, o2) {
  if (o2 == null)
    o2 = new_buf(16 * 4 + 2);
  o2.write_shift(2, sp.password ? crypto_CreatePasswordVerifier_Method1(sp.password) : 0);
  o2.write_shift(4, 1);
  [
    ["objects", false],
    // fObjects
    ["scenarios", false],
    // fScenarios
    ["formatCells", true],
    // fFormatCells
    ["formatColumns", true],
    // fFormatColumns
    ["formatRows", true],
    // fFormatRows
    ["insertColumns", true],
    // fInsertColumns
    ["insertRows", true],
    // fInsertRows
    ["insertHyperlinks", true],
    // fInsertHyperlinks
    ["deleteColumns", true],
    // fDeleteColumns
    ["deleteRows", true],
    // fDeleteRows
    ["selectLockedCells", false],
    // fSelLockedCells
    ["sort", true],
    // fSort
    ["autoFilter", true],
    // fAutoFilter
    ["pivotTables", true],
    // fPivotTables
    ["selectUnlockedCells", false]
    // fSelUnlockedCells
  ].forEach(function(n2) {
    if (n2[1])
      o2.write_shift(4, sp[n2[0]] != null && !sp[n2[0]] ? 1 : 0);
    else
      o2.write_shift(4, sp[n2[0]] != null && sp[n2[0]] ? 0 : 1);
  });
  return o2;
}
function parse_BrtDVal() {
}
function parse_BrtDVal14() {
}
function parse_ws_bin(data, _opts, idx, rels, wb, themes, styles) {
  if (!data)
    return data;
  var opts = _opts || {};
  if (!rels)
    rels = { "!id": {} };
  if (DENSE != null && opts.dense == null)
    opts.dense = DENSE;
  var s2 = opts.dense ? [] : {};
  var ref;
  var refguess = { s: { r: 2e6, c: 2e6 }, e: { r: 0, c: 0 } };
  var state = [];
  var pass = false, end = false;
  var row, p2, cf, R2, C2, addr, sstr, rr, cell;
  var merges = [];
  opts.biff = 12;
  opts["!row"] = 0;
  var ai = 0, af = false;
  var arrayf = [];
  var sharedf = {};
  var supbooks = opts.supbooks || /*::(*/
  wb.supbooks || [[]];
  supbooks.sharedf = sharedf;
  supbooks.arrayf = arrayf;
  supbooks.SheetNames = wb.SheetNames || wb.Sheets.map(function(x2) {
    return x2.name;
  });
  if (!opts.supbooks) {
    opts.supbooks = supbooks;
    if (wb.Names)
      for (var i2 = 0; i2 < wb.Names.length; ++i2)
        supbooks[0][i2 + 1] = wb.Names[i2];
  }
  var colinfo = [], rowinfo = [];
  var seencol = false;
  XLSBRecordEnum[16] = { n: "BrtShortReal", f: parse_BrtShortReal };
  var cm, vm;
  recordhopper(data, function ws_parse(val, RR, RT) {
    if (end)
      return;
    switch (RT) {
      case 148:
        ref = val;
        break;
      case 0:
        row = val;
        if (opts.sheetRows && opts.sheetRows <= row.r)
          end = true;
        rr = encode_row(R2 = row.r);
        opts["!row"] = row.r;
        if (val.hidden || val.hpt || val.level != null) {
          if (val.hpt)
            val.hpx = pt2px(val.hpt);
          rowinfo[val.r] = val;
        }
        break;
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 62:
        p2 = { t: val[2] };
        switch (val[2]) {
          case "n":
            p2.v = val[1];
            break;
          case "s":
            sstr = strs[val[1]];
            p2.v = sstr.t;
            p2.r = sstr.r;
            break;
          case "b":
            p2.v = val[1] ? true : false;
            break;
          case "e":
            p2.v = val[1];
            if (opts.cellText !== false)
              p2.w = BErr[p2.v];
            break;
          case "str":
            p2.t = "s";
            p2.v = val[1];
            break;
          case "is":
            p2.t = "s";
            p2.v = val[1].t;
            break;
        }
        if (cf = styles.CellXf[val[0].iStyleRef])
          safe_format(p2, cf.numFmtId, null, opts, themes, styles);
        C2 = val[0].c == -1 ? C2 + 1 : val[0].c;
        if (opts.dense) {
          if (!s2[R2])
            s2[R2] = [];
          s2[R2][C2] = p2;
        } else
          s2[encode_col(C2) + rr] = p2;
        if (opts.cellFormula) {
          af = false;
          for (ai = 0; ai < arrayf.length; ++ai) {
            var aii = arrayf[ai];
            if (row.r >= aii[0].s.r && row.r <= aii[0].e.r) {
              if (C2 >= aii[0].s.c && C2 <= aii[0].e.c) {
                p2.F = encode_range(aii[0]);
                af = true;
              }
            }
          }
          if (!af && val.length > 3)
            p2.f = val[3];
        }
        if (refguess.s.r > row.r)
          refguess.s.r = row.r;
        if (refguess.s.c > C2)
          refguess.s.c = C2;
        if (refguess.e.r < row.r)
          refguess.e.r = row.r;
        if (refguess.e.c < C2)
          refguess.e.c = C2;
        if (opts.cellDates && cf && p2.t == "n" && fmt_is_date(table_fmt[cf.numFmtId])) {
          var _d = SSF_parse_date_code(p2.v);
          if (_d) {
            p2.t = "d";
            p2.v = new Date(_d.y, _d.m - 1, _d.d, _d.H, _d.M, _d.S, _d.u);
          }
        }
        if (cm) {
          if (cm.type == "XLDAPR")
            p2.D = true;
          cm = void 0;
        }
        if (vm)
          vm = void 0;
        break;
      case 1:
      case 12:
        if (!opts.sheetStubs || pass)
          break;
        p2 = { t: "z", v: void 0 };
        C2 = val[0].c == -1 ? C2 + 1 : val[0].c;
        if (opts.dense) {
          if (!s2[R2])
            s2[R2] = [];
          s2[R2][C2] = p2;
        } else
          s2[encode_col(C2) + rr] = p2;
        if (refguess.s.r > row.r)
          refguess.s.r = row.r;
        if (refguess.s.c > C2)
          refguess.s.c = C2;
        if (refguess.e.r < row.r)
          refguess.e.r = row.r;
        if (refguess.e.c < C2)
          refguess.e.c = C2;
        if (cm) {
          if (cm.type == "XLDAPR")
            p2.D = true;
          cm = void 0;
        }
        if (vm)
          vm = void 0;
        break;
      case 176:
        merges.push(val);
        break;
      case 49:
        {
          cm = ((opts.xlmeta || {}).Cell || [])[val - 1];
        }
        break;
      case 494:
        var rel = rels["!id"][val.relId];
        if (rel) {
          val.Target = rel.Target;
          if (val.loc)
            val.Target += "#" + val.loc;
          val.Rel = rel;
        } else if (val.relId == "") {
          val.Target = "#" + val.loc;
        }
        for (R2 = val.rfx.s.r; R2 <= val.rfx.e.r; ++R2)
          for (C2 = val.rfx.s.c; C2 <= val.rfx.e.c; ++C2) {
            if (opts.dense) {
              if (!s2[R2])
                s2[R2] = [];
              if (!s2[R2][C2])
                s2[R2][C2] = { t: "z", v: void 0 };
              s2[R2][C2].l = val;
            } else {
              addr = encode_cell({ c: C2, r: R2 });
              if (!s2[addr])
                s2[addr] = { t: "z", v: void 0 };
              s2[addr].l = val;
            }
          }
        break;
      case 426:
        if (!opts.cellFormula)
          break;
        arrayf.push(val);
        cell = opts.dense ? s2[R2][C2] : s2[encode_col(C2) + rr];
        cell.f = stringify_formula(val[1], refguess, { r: row.r, c: C2 }, supbooks, opts);
        cell.F = encode_range(val[0]);
        break;
      case 427:
        if (!opts.cellFormula)
          break;
        sharedf[encode_cell(val[0].s)] = val[1];
        cell = opts.dense ? s2[R2][C2] : s2[encode_col(C2) + rr];
        cell.f = stringify_formula(val[1], refguess, { r: row.r, c: C2 }, supbooks, opts);
        break;
      case 60:
        if (!opts.cellStyles)
          break;
        while (val.e >= val.s) {
          colinfo[val.e--] = { width: val.w / 256, hidden: !!(val.flags & 1), level: val.level };
          if (!seencol) {
            seencol = true;
            find_mdw_colw(val.w / 256);
          }
          process_col(colinfo[val.e + 1]);
        }
        break;
      case 161:
        s2["!autofilter"] = { ref: encode_range(val) };
        break;
      case 476:
        s2["!margins"] = val;
        break;
      case 147:
        if (!wb.Sheets[idx])
          wb.Sheets[idx] = {};
        if (val.name)
          wb.Sheets[idx].CodeName = val.name;
        if (val.above || val.left)
          s2["!outline"] = { above: val.above, left: val.left };
        break;
      case 137:
        if (!wb.Views)
          wb.Views = [{}];
        if (!wb.Views[0])
          wb.Views[0] = {};
        if (val.RTL)
          wb.Views[0].RTL = true;
        break;
      case 485:
        break;
      case 64:
      case 1053:
        break;
      case 151:
        break;
      case 152:
      case 175:
      case 644:
      case 625:
      case 562:
      case 396:
      case 1112:
      case 1146:
      case 471:
      case 1050:
      case 649:
      case 1105:
      case 589:
      case 607:
      case 564:
      case 1055:
      case 168:
      case 174:
      case 1180:
      case 499:
      case 507:
      case 550:
      case 171:
      case 167:
      case 1177:
      case 169:
      case 1181:
      case 551:
      case 552:
      case 661:
      case 639:
      case 478:
      case 537:
      case 477:
      case 536:
      case 1103:
      case 680:
      case 1104:
      case 1024:
      case 663:
      case 535:
      case 678:
      case 504:
      case 1043:
      case 428:
      case 170:
      case 3072:
      case 50:
      case 2070:
      case 1045:
        break;
      case 35:
        pass = true;
        break;
      case 36:
        pass = false;
        break;
      case 37:
        state.push(RT);
        pass = true;
        break;
      case 38:
        state.pop();
        pass = false;
        break;
      default:
        if (RR.T) {
        } else if (!pass || opts.WTF)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  }, opts);
  delete opts.supbooks;
  delete opts["!row"];
  if (!s2["!ref"] && (refguess.s.r < 2e6 || ref && (ref.e.r > 0 || ref.e.c > 0 || ref.s.r > 0 || ref.s.c > 0)))
    s2["!ref"] = encode_range(ref || refguess);
  if (opts.sheetRows && s2["!ref"]) {
    var tmpref = safe_decode_range(s2["!ref"]);
    if (opts.sheetRows <= +tmpref.e.r) {
      tmpref.e.r = opts.sheetRows - 1;
      if (tmpref.e.r > refguess.e.r)
        tmpref.e.r = refguess.e.r;
      if (tmpref.e.r < tmpref.s.r)
        tmpref.s.r = tmpref.e.r;
      if (tmpref.e.c > refguess.e.c)
        tmpref.e.c = refguess.e.c;
      if (tmpref.e.c < tmpref.s.c)
        tmpref.s.c = tmpref.e.c;
      s2["!fullref"] = s2["!ref"];
      s2["!ref"] = encode_range(tmpref);
    }
  }
  if (merges.length > 0)
    s2["!merges"] = merges;
  if (colinfo.length > 0)
    s2["!cols"] = colinfo;
  if (rowinfo.length > 0)
    s2["!rows"] = rowinfo;
  return s2;
}
function write_ws_bin_cell(ba, cell, R2, C2, opts, ws, last_seen) {
  if (cell.v === void 0)
    return false;
  var vv = "";
  switch (cell.t) {
    case "b":
      vv = cell.v ? "1" : "0";
      break;
    case "d":
      cell = dup(cell);
      cell.z = cell.z || table_fmt[14];
      cell.v = datenum(parseDate(cell.v));
      cell.t = "n";
      break;
    case "n":
    case "e":
      vv = "" + cell.v;
      break;
    default:
      vv = cell.v;
      break;
  }
  var o2 = { r: R2, c: C2 };
  o2.s = get_cell_style(opts.cellXfs, cell, opts);
  if (cell.l)
    ws["!links"].push([encode_cell(o2), cell.l]);
  if (cell.c)
    ws["!comments"].push([encode_cell(o2), cell.c]);
  switch (cell.t) {
    case "s":
    case "str":
      if (opts.bookSST) {
        vv = get_sst_id(opts.Strings, cell.v, opts.revStrings);
        o2.t = "s";
        o2.v = vv;
        if (last_seen)
          write_record(ba, 18, write_BrtShortIsst(cell, o2));
        else
          write_record(ba, 7, write_BrtCellIsst(cell, o2));
      } else {
        o2.t = "str";
        if (last_seen)
          write_record(ba, 17, write_BrtShortSt(cell, o2));
        else
          write_record(ba, 6, write_BrtCellSt(cell, o2));
      }
      return true;
    case "n":
      if (cell.v == (cell.v | 0) && cell.v > -1e3 && cell.v < 1e3) {
        if (last_seen)
          write_record(ba, 13, write_BrtShortRk(cell, o2));
        else
          write_record(ba, 2, write_BrtCellRk(cell, o2));
      } else {
        if (last_seen)
          write_record(ba, 16, write_BrtShortReal(cell, o2));
        else
          write_record(ba, 5, write_BrtCellReal(cell, o2));
      }
      return true;
    case "b":
      o2.t = "b";
      if (last_seen)
        write_record(ba, 15, write_BrtShortBool(cell, o2));
      else
        write_record(ba, 4, write_BrtCellBool(cell, o2));
      return true;
    case "e":
      o2.t = "e";
      if (last_seen)
        write_record(ba, 14, write_BrtShortError(cell, o2));
      else
        write_record(ba, 3, write_BrtCellError(cell, o2));
      return true;
  }
  if (last_seen)
    write_record(ba, 12, write_BrtShortBlank(cell, o2));
  else
    write_record(ba, 1, write_BrtCellBlank(cell, o2));
  return true;
}
function write_CELLTABLE(ba, ws, idx, opts) {
  var range = safe_decode_range(ws["!ref"] || "A1"), ref, rr = "", cols = [];
  write_record(
    ba,
    145
    /* BrtBeginSheetData */
  );
  var dense = Array.isArray(ws);
  var cap = range.e.r;
  if (ws["!rows"])
    cap = Math.max(range.e.r, ws["!rows"].length - 1);
  for (var R2 = range.s.r; R2 <= cap; ++R2) {
    rr = encode_row(R2);
    write_row_header(ba, ws, range, R2);
    var last_seen = false;
    if (R2 <= range.e.r)
      for (var C2 = range.s.c; C2 <= range.e.c; ++C2) {
        if (R2 === range.s.r)
          cols[C2] = encode_col(C2);
        ref = cols[C2] + rr;
        var cell = dense ? (ws[R2] || [])[C2] : ws[ref];
        if (!cell) {
          last_seen = false;
          continue;
        }
        last_seen = write_ws_bin_cell(ba, cell, R2, C2, opts, ws, last_seen);
      }
  }
  write_record(
    ba,
    146
    /* BrtEndSheetData */
  );
}
function write_MERGECELLS(ba, ws) {
  if (!ws || !ws["!merges"])
    return;
  write_record(ba, 177, write_BrtBeginMergeCells(ws["!merges"].length));
  ws["!merges"].forEach(function(m2) {
    write_record(ba, 176, write_BrtMergeCell(m2));
  });
  write_record(
    ba,
    178
    /* BrtEndMergeCells */
  );
}
function write_COLINFOS(ba, ws) {
  if (!ws || !ws["!cols"])
    return;
  write_record(
    ba,
    390
    /* BrtBeginColInfos */
  );
  ws["!cols"].forEach(function(m2, i2) {
    if (m2)
      write_record(ba, 60, write_BrtColInfo(i2, m2));
  });
  write_record(
    ba,
    391
    /* BrtEndColInfos */
  );
}
function write_IGNOREECS(ba, ws) {
  if (!ws || !ws["!ref"])
    return;
  write_record(
    ba,
    648
    /* BrtBeginCellIgnoreECs */
  );
  write_record(ba, 649, write_BrtCellIgnoreEC(safe_decode_range(ws["!ref"])));
  write_record(
    ba,
    650
    /* BrtEndCellIgnoreECs */
  );
}
function write_HLINKS(ba, ws, rels) {
  ws["!links"].forEach(function(l2) {
    if (!l2[1].Target)
      return;
    var rId = add_rels(rels, -1, l2[1].Target.replace(/#.*$/, ""), RELS.HLINK);
    write_record(ba, 494, write_BrtHLink(l2, rId));
  });
  delete ws["!links"];
}
function write_LEGACYDRAWING(ba, ws, idx, rels) {
  if (ws["!comments"].length > 0) {
    var rId = add_rels(rels, -1, "../drawings/vmlDrawing" + (idx + 1) + ".vml", RELS.VML);
    write_record(ba, 551, write_RelID("rId" + rId));
    ws["!legacy"] = rId;
  }
}
function write_AUTOFILTER(ba, ws, wb, idx) {
  if (!ws["!autofilter"])
    return;
  var data = ws["!autofilter"];
  var ref = typeof data.ref === "string" ? data.ref : encode_range(data.ref);
  if (!wb.Workbook)
    wb.Workbook = { Sheets: [] };
  if (!wb.Workbook.Names)
    wb.Workbook.Names = [];
  var names = wb.Workbook.Names;
  var range = decode_range(ref);
  if (range.s.r == range.e.r) {
    range.e.r = decode_range(ws["!ref"]).e.r;
    ref = encode_range(range);
  }
  for (var i2 = 0; i2 < names.length; ++i2) {
    var name = names[i2];
    if (name.Name != "_xlnm._FilterDatabase")
      continue;
    if (name.Sheet != idx)
      continue;
    name.Ref = "'" + wb.SheetNames[idx] + "'!" + ref;
    break;
  }
  if (i2 == names.length)
    names.push({ Name: "_xlnm._FilterDatabase", Sheet: idx, Ref: "'" + wb.SheetNames[idx] + "'!" + ref });
  write_record(ba, 161, write_UncheckedRfX(safe_decode_range(ref)));
  write_record(
    ba,
    162
    /* BrtEndAFilter */
  );
}
function write_WSVIEWS2(ba, ws, Workbook) {
  write_record(
    ba,
    133
    /* BrtBeginWsViews */
  );
  {
    write_record(ba, 137, write_BrtBeginWsView(ws, Workbook));
    write_record(
      ba,
      138
      /* BrtEndWsView */
    );
  }
  write_record(
    ba,
    134
    /* BrtEndWsViews */
  );
}
function write_WSFMTINFO() {
}
function write_SHEETPROTECT(ba, ws) {
  if (!ws["!protect"])
    return;
  write_record(ba, 535, write_BrtSheetProtection(ws["!protect"]));
}
function write_ws_bin(idx, opts, wb, rels) {
  var ba = buf_array();
  var s2 = wb.SheetNames[idx], ws = wb.Sheets[s2] || {};
  var c2 = s2;
  try {
    if (wb && wb.Workbook)
      c2 = wb.Workbook.Sheets[idx].CodeName || c2;
  } catch (e) {
  }
  var r = safe_decode_range(ws["!ref"] || "A1");
  if (r.e.c > 16383 || r.e.r > 1048575) {
    if (opts.WTF)
      throw new Error("Range " + (ws["!ref"] || "A1") + " exceeds format limit A1:XFD1048576");
    r.e.c = Math.min(r.e.c, 16383);
    r.e.r = Math.min(r.e.c, 1048575);
  }
  ws["!links"] = [];
  ws["!comments"] = [];
  write_record(
    ba,
    129
    /* BrtBeginSheet */
  );
  if (wb.vbaraw || ws["!outline"])
    write_record(ba, 147, write_BrtWsProp(c2, ws["!outline"]));
  write_record(ba, 148, write_BrtWsDim(r));
  write_WSVIEWS2(ba, ws, wb.Workbook);
  write_WSFMTINFO(ba, ws);
  write_COLINFOS(ba, ws, idx, opts, wb);
  write_CELLTABLE(ba, ws, idx, opts, wb);
  write_SHEETPROTECT(ba, ws);
  write_AUTOFILTER(ba, ws, wb, idx);
  write_MERGECELLS(ba, ws);
  write_HLINKS(ba, ws, rels);
  if (ws["!margins"])
    write_record(ba, 476, write_BrtMargins(ws["!margins"]));
  if (!opts || opts.ignoreEC || opts.ignoreEC == void 0)
    write_IGNOREECS(ba, ws);
  write_LEGACYDRAWING(ba, ws, idx, rels);
  write_record(
    ba,
    130
    /* BrtEndSheet */
  );
  return ba.end();
}
function parse_Cache(data) {
  var col = [];
  var num = data.match(/^<c:numCache>/);
  var f2;
  (data.match(/<c:pt idx="(\d*)">(.*?)<\/c:pt>/mg) || []).forEach(function(pt2) {
    var q2 = pt2.match(/<c:pt idx="(\d*?)"><c:v>(.*)<\/c:v><\/c:pt>/);
    if (!q2)
      return;
    col[+q2[1]] = num ? +q2[2] : q2[2];
  });
  var nf = unescapexml((data.match(/<c:formatCode>([\s\S]*?)<\/c:formatCode>/) || ["", "General"])[1]);
  (data.match(/<c:f>(.*?)<\/c:f>/mg) || []).forEach(function(F2) {
    f2 = F2.replace(/<.*?>/g, "");
  });
  return [col, nf, f2];
}
function parse_chart(data, name, opts, rels, wb, csheet) {
  var cs = csheet || { "!type": "chart" };
  if (!data)
    return csheet;
  var C2 = 0, R2 = 0, col = "A";
  var refguess = { s: { r: 2e6, c: 2e6 }, e: { r: 0, c: 0 } };
  (data.match(/<c:numCache>[\s\S]*?<\/c:numCache>/gm) || []).forEach(function(nc) {
    var cache = parse_Cache(nc);
    refguess.s.r = refguess.s.c = 0;
    refguess.e.c = C2;
    col = encode_col(C2);
    cache[0].forEach(function(n2, i2) {
      cs[col + encode_row(i2)] = { t: "n", v: n2, z: cache[1] };
      R2 = i2;
    });
    if (refguess.e.r < R2)
      refguess.e.r = R2;
    ++C2;
  });
  if (C2 > 0)
    cs["!ref"] = encode_range(refguess);
  return cs;
}
function parse_cs_xml(data, opts, idx, rels, wb) {
  if (!data)
    return data;
  if (!rels)
    rels = { "!id": {} };
  var s2 = { "!type": "chart", "!drawel": null, "!rel": "" };
  var m2;
  var sheetPr = data.match(sheetprregex);
  if (sheetPr)
    parse_ws_xml_sheetpr(sheetPr[0], s2, wb, idx);
  if (m2 = data.match(/drawing r:id="(.*?)"/))
    s2["!rel"] = m2[1];
  if (rels["!id"][s2["!rel"]])
    s2["!drawel"] = rels["!id"][s2["!rel"]];
  return s2;
}
function parse_BrtCsProp(data, length) {
  data.l += 10;
  var name = parse_XLWideString(data, length - 10);
  return { name };
}
function parse_cs_bin(data, opts, idx, rels, wb) {
  if (!data)
    return data;
  if (!rels)
    rels = { "!id": {} };
  var s2 = { "!type": "chart", "!drawel": null, "!rel": "" };
  var state = [];
  var pass = false;
  recordhopper(data, function cs_parse(val, R2, RT) {
    switch (RT) {
      case 550:
        s2["!rel"] = val;
        break;
      case 651:
        if (!wb.Sheets[idx])
          wb.Sheets[idx] = {};
        if (val.name)
          wb.Sheets[idx].CodeName = val.name;
        break;
      case 562:
      case 652:
      case 669:
      case 679:
      case 551:
      case 552:
      case 476:
      case 3072:
        break;
      case 35:
        pass = true;
        break;
      case 36:
        pass = false;
        break;
      case 37:
        state.push(RT);
        break;
      case 38:
        state.pop();
        break;
      default:
        if (R2.T > 0)
          state.push(RT);
        else if (R2.T < 0)
          state.pop();
        else if (!pass || opts.WTF)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  }, opts);
  if (rels["!id"][s2["!rel"]])
    s2["!drawel"] = rels["!id"][s2["!rel"]];
  return s2;
}
var WBPropsDef = [
  ["allowRefreshQuery", false, "bool"],
  ["autoCompressPictures", true, "bool"],
  ["backupFile", false, "bool"],
  ["checkCompatibility", false, "bool"],
  ["CodeName", ""],
  ["date1904", false, "bool"],
  ["defaultThemeVersion", 0, "int"],
  ["filterPrivacy", false, "bool"],
  ["hidePivotFieldList", false, "bool"],
  ["promptedSolutions", false, "bool"],
  ["publishItems", false, "bool"],
  ["refreshAllConnections", false, "bool"],
  ["saveExternalLinkValues", true, "bool"],
  ["showBorderUnselectedTables", true, "bool"],
  ["showInkAnnotation", true, "bool"],
  ["showObjects", "all"],
  ["showPivotChartFilter", false, "bool"],
  ["updateLinks", "userSet"]
];
var WBViewDef = [
  ["activeTab", 0, "int"],
  ["autoFilterDateGrouping", true, "bool"],
  ["firstSheet", 0, "int"],
  ["minimized", false, "bool"],
  ["showHorizontalScroll", true, "bool"],
  ["showSheetTabs", true, "bool"],
  ["showVerticalScroll", true, "bool"],
  ["tabRatio", 600, "int"],
  ["visibility", "visible"]
  //window{Height,Width}, {x,y}Window
];
var SheetDef = [
  //['state', 'visible']
];
var CalcPrDef = [
  ["calcCompleted", "true"],
  ["calcMode", "auto"],
  ["calcOnSave", "true"],
  ["concurrentCalc", "true"],
  ["fullCalcOnLoad", "false"],
  ["fullPrecision", "true"],
  ["iterate", "false"],
  ["iterateCount", "100"],
  ["iterateDelta", "0.001"],
  ["refMode", "A1"]
];
function push_defaults_array(target, defaults) {
  for (var j2 = 0; j2 != target.length; ++j2) {
    var w2 = target[j2];
    for (var i2 = 0; i2 != defaults.length; ++i2) {
      var z2 = defaults[i2];
      if (w2[z2[0]] == null)
        w2[z2[0]] = z2[1];
      else
        switch (z2[2]) {
          case "bool":
            if (typeof w2[z2[0]] == "string")
              w2[z2[0]] = parsexmlbool(w2[z2[0]]);
            break;
          case "int":
            if (typeof w2[z2[0]] == "string")
              w2[z2[0]] = parseInt(w2[z2[0]], 10);
            break;
        }
    }
  }
}
function push_defaults(target, defaults) {
  for (var i2 = 0; i2 != defaults.length; ++i2) {
    var z2 = defaults[i2];
    if (target[z2[0]] == null)
      target[z2[0]] = z2[1];
    else
      switch (z2[2]) {
        case "bool":
          if (typeof target[z2[0]] == "string")
            target[z2[0]] = parsexmlbool(target[z2[0]]);
          break;
        case "int":
          if (typeof target[z2[0]] == "string")
            target[z2[0]] = parseInt(target[z2[0]], 10);
          break;
      }
  }
}
function parse_wb_defaults(wb) {
  push_defaults(wb.WBProps, WBPropsDef);
  push_defaults(wb.CalcPr, CalcPrDef);
  push_defaults_array(wb.WBView, WBViewDef);
  push_defaults_array(wb.Sheets, SheetDef);
  _ssfopts.date1904 = parsexmlbool(wb.WBProps.date1904);
}
function safe1904(wb) {
  if (!wb.Workbook)
    return "false";
  if (!wb.Workbook.WBProps)
    return "false";
  return parsexmlbool(wb.Workbook.WBProps.date1904) ? "true" : "false";
}
var badchars = /* @__PURE__ */ "][*?/\\".split("");
function check_ws_name(n2, safe) {
  if (n2.length > 31) {
    if (safe)
      return false;
    throw new Error("Sheet names cannot exceed 31 chars");
  }
  var _good = true;
  badchars.forEach(function(c2) {
    if (n2.indexOf(c2) == -1)
      return;
    if (!safe)
      throw new Error("Sheet name cannot contain : \\ / ? * [ ]");
    _good = false;
  });
  return _good;
}
function check_wb_names(N2, S2, codes) {
  N2.forEach(function(n2, i2) {
    check_ws_name(n2);
    for (var j2 = 0; j2 < i2; ++j2)
      if (n2 == N2[j2])
        throw new Error("Duplicate Sheet Name: " + n2);
    if (codes) {
      var cn = S2 && S2[i2] && S2[i2].CodeName || n2;
      if (cn.charCodeAt(0) == 95 && cn.length > 22)
        throw new Error("Bad Code Name: Worksheet" + cn);
    }
  });
}
function check_wb(wb) {
  if (!wb || !wb.SheetNames || !wb.Sheets)
    throw new Error("Invalid Workbook");
  if (!wb.SheetNames.length)
    throw new Error("Workbook is empty");
  var Sheets = wb.Workbook && wb.Workbook.Sheets || [];
  check_wb_names(wb.SheetNames, Sheets, !!wb.vbaraw);
  for (var i2 = 0; i2 < wb.SheetNames.length; ++i2)
    check_ws(wb.Sheets[wb.SheetNames[i2]], wb.SheetNames[i2], i2);
}
var wbnsregex = /<\w+:workbook/;
function parse_wb_xml(data, opts) {
  if (!data)
    throw new Error("Could not find file");
  var wb = (
    /*::(*/
    { AppVersion: {}, WBProps: {}, WBView: [], Sheets: [], CalcPr: {}, Names: [], xmlns: "" }
  );
  var pass = false, xmlns = "xmlns";
  var dname = {}, dnstart = 0;
  data.replace(tagregex, function xml_wb(x2, idx) {
    var y2 = parsexmltag(x2);
    switch (strip_ns(y2[0])) {
      case "<?xml":
        break;
      case "<workbook":
        if (x2.match(wbnsregex))
          xmlns = "xmlns" + x2.match(/<(\w+):/)[1];
        wb.xmlns = y2[xmlns];
        break;
      case "</workbook>":
        break;
      case "<fileVersion":
        delete y2[0];
        wb.AppVersion = y2;
        break;
      case "<fileVersion/>":
      case "</fileVersion>":
        break;
      case "<fileSharing":
        break;
      case "<fileSharing/>":
        break;
      case "<workbookPr":
      case "<workbookPr/>":
        WBPropsDef.forEach(function(w2) {
          if (y2[w2[0]] == null)
            return;
          switch (w2[2]) {
            case "bool":
              wb.WBProps[w2[0]] = parsexmlbool(y2[w2[0]]);
              break;
            case "int":
              wb.WBProps[w2[0]] = parseInt(y2[w2[0]], 10);
              break;
            default:
              wb.WBProps[w2[0]] = y2[w2[0]];
          }
        });
        if (y2.codeName)
          wb.WBProps.CodeName = utf8read(y2.codeName);
        break;
      case "</workbookPr>":
        break;
      case "<workbookProtection":
        break;
      case "<workbookProtection/>":
        break;
      case "<bookViews":
      case "<bookViews>":
      case "</bookViews>":
        break;
      case "<workbookView":
      case "<workbookView/>":
        delete y2[0];
        wb.WBView.push(y2);
        break;
      case "</workbookView>":
        break;
      case "<sheets":
      case "<sheets>":
      case "</sheets>":
        break;
      case "<sheet":
        switch (y2.state) {
          case "hidden":
            y2.Hidden = 1;
            break;
          case "veryHidden":
            y2.Hidden = 2;
            break;
          default:
            y2.Hidden = 0;
        }
        delete y2.state;
        y2.name = unescapexml(utf8read(y2.name));
        delete y2[0];
        wb.Sheets.push(y2);
        break;
      case "</sheet>":
        break;
      case "<functionGroups":
      case "<functionGroups/>":
        break;
      case "<functionGroup":
        break;
      case "<externalReferences":
      case "</externalReferences>":
      case "<externalReferences>":
        break;
      case "<externalReference":
        break;
      case "<definedNames/>":
        break;
      case "<definedNames>":
      case "<definedNames":
        pass = true;
        break;
      case "</definedNames>":
        pass = false;
        break;
      case "<definedName":
        {
          dname = {};
          dname.Name = utf8read(y2.name);
          if (y2.comment)
            dname.Comment = y2.comment;
          if (y2.localSheetId)
            dname.Sheet = +y2.localSheetId;
          if (parsexmlbool(y2.hidden || "0"))
            dname.Hidden = true;
          dnstart = idx + x2.length;
        }
        break;
      case "</definedName>":
        {
          dname.Ref = unescapexml(utf8read(data.slice(dnstart, idx)));
          wb.Names.push(dname);
        }
        break;
      case "<definedName/>":
        break;
      case "<calcPr":
        delete y2[0];
        wb.CalcPr = y2;
        break;
      case "<calcPr/>":
        delete y2[0];
        wb.CalcPr = y2;
        break;
      case "</calcPr>":
        break;
      case "<oleSize":
        break;
      case "<customWorkbookViews>":
      case "</customWorkbookViews>":
      case "<customWorkbookViews":
        break;
      case "<customWorkbookView":
      case "</customWorkbookView>":
        break;
      case "<pivotCaches>":
      case "</pivotCaches>":
      case "<pivotCaches":
        break;
      case "<pivotCache":
        break;
      case "<smartTagPr":
      case "<smartTagPr/>":
        break;
      case "<smartTagTypes":
      case "<smartTagTypes>":
      case "</smartTagTypes>":
        break;
      case "<smartTagType":
        break;
      case "<webPublishing":
      case "<webPublishing/>":
        break;
      case "<fileRecoveryPr":
      case "<fileRecoveryPr/>":
        break;
      case "<webPublishObjects>":
      case "<webPublishObjects":
      case "</webPublishObjects>":
        break;
      case "<webPublishObject":
        break;
      case "<extLst":
      case "<extLst>":
      case "</extLst>":
      case "<extLst/>":
        break;
      case "<ext":
        pass = true;
        break;
      case "</ext>":
        pass = false;
        break;
      case "<ArchID":
        break;
      case "<AlternateContent":
      case "<AlternateContent>":
        pass = true;
        break;
      case "</AlternateContent>":
        pass = false;
        break;
      case "<revisionPtr":
        break;
      default:
        if (!pass && opts.WTF)
          throw new Error("unrecognized " + y2[0] + " in workbook");
    }
    return x2;
  });
  if (XMLNS_main.indexOf(wb.xmlns) === -1)
    throw new Error("Unknown Namespace: " + wb.xmlns);
  parse_wb_defaults(wb);
  return wb;
}
function write_wb_xml(wb) {
  var o2 = [XML_HEADER];
  o2[o2.length] = writextag("workbook", null, {
    "xmlns": XMLNS_main[0],
    //'xmlns:mx': XMLNS.mx,
    //'xmlns:s': XMLNS_main[0],
    "xmlns:r": XMLNS.r
  });
  var write_names = wb.Workbook && (wb.Workbook.Names || []).length > 0;
  var workbookPr = { codeName: "ThisWorkbook" };
  if (wb.Workbook && wb.Workbook.WBProps) {
    WBPropsDef.forEach(function(x2) {
      if (wb.Workbook.WBProps[x2[0]] == null)
        return;
      if (wb.Workbook.WBProps[x2[0]] == x2[1])
        return;
      workbookPr[x2[0]] = wb.Workbook.WBProps[x2[0]];
    });
    if (wb.Workbook.WBProps.CodeName) {
      workbookPr.codeName = wb.Workbook.WBProps.CodeName;
      delete workbookPr.CodeName;
    }
  }
  o2[o2.length] = writextag("workbookPr", null, workbookPr);
  var sheets = wb.Workbook && wb.Workbook.Sheets || [];
  var i2 = 0;
  if (sheets && sheets[0] && !!sheets[0].Hidden) {
    o2[o2.length] = "<bookViews>";
    for (i2 = 0; i2 != wb.SheetNames.length; ++i2) {
      if (!sheets[i2])
        break;
      if (!sheets[i2].Hidden)
        break;
    }
    if (i2 == wb.SheetNames.length)
      i2 = 0;
    o2[o2.length] = '<workbookView firstSheet="' + i2 + '" activeTab="' + i2 + '"/>';
    o2[o2.length] = "</bookViews>";
  }
  o2[o2.length] = "<sheets>";
  for (i2 = 0; i2 != wb.SheetNames.length; ++i2) {
    var sht = { name: escapexml(wb.SheetNames[i2].slice(0, 31)) };
    sht.sheetId = "" + (i2 + 1);
    sht["r:id"] = "rId" + (i2 + 1);
    if (sheets[i2])
      switch (sheets[i2].Hidden) {
        case 1:
          sht.state = "hidden";
          break;
        case 2:
          sht.state = "veryHidden";
          break;
      }
    o2[o2.length] = writextag("sheet", null, sht);
  }
  o2[o2.length] = "</sheets>";
  if (write_names) {
    o2[o2.length] = "<definedNames>";
    if (wb.Workbook && wb.Workbook.Names)
      wb.Workbook.Names.forEach(function(n2) {
        var d2 = { name: n2.Name };
        if (n2.Comment)
          d2.comment = n2.Comment;
        if (n2.Sheet != null)
          d2.localSheetId = "" + n2.Sheet;
        if (n2.Hidden)
          d2.hidden = "1";
        if (!n2.Ref)
          return;
        o2[o2.length] = writextag("definedName", escapexml(n2.Ref), d2);
      });
    o2[o2.length] = "</definedNames>";
  }
  if (o2.length > 2) {
    o2[o2.length] = "</workbook>";
    o2[1] = o2[1].replace("/>", ">");
  }
  return o2.join("");
}
function parse_BrtBundleSh(data, length) {
  var z2 = {};
  z2.Hidden = data.read_shift(4);
  z2.iTabID = data.read_shift(4);
  z2.strRelID = parse_RelID(data, length - 8);
  z2.name = parse_XLWideString(data);
  return z2;
}
function write_BrtBundleSh(data, o2) {
  if (!o2)
    o2 = new_buf(127);
  o2.write_shift(4, data.Hidden);
  o2.write_shift(4, data.iTabID);
  write_RelID(data.strRelID, o2);
  write_XLWideString(data.name.slice(0, 31), o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function parse_BrtWbProp(data, length) {
  var o2 = {};
  var flags = data.read_shift(4);
  o2.defaultThemeVersion = data.read_shift(4);
  var strName = length > 8 ? parse_XLWideString(data) : "";
  if (strName.length > 0)
    o2.CodeName = strName;
  o2.autoCompressPictures = !!(flags & 65536);
  o2.backupFile = !!(flags & 64);
  o2.checkCompatibility = !!(flags & 4096);
  o2.date1904 = !!(flags & 1);
  o2.filterPrivacy = !!(flags & 8);
  o2.hidePivotFieldList = !!(flags & 1024);
  o2.promptedSolutions = !!(flags & 16);
  o2.publishItems = !!(flags & 2048);
  o2.refreshAllConnections = !!(flags & 262144);
  o2.saveExternalLinkValues = !!(flags & 128);
  o2.showBorderUnselectedTables = !!(flags & 4);
  o2.showInkAnnotation = !!(flags & 32);
  o2.showObjects = ["all", "placeholders", "none"][flags >> 13 & 3];
  o2.showPivotChartFilter = !!(flags & 32768);
  o2.updateLinks = ["userSet", "never", "always"][flags >> 8 & 3];
  return o2;
}
function write_BrtWbProp(data, o2) {
  if (!o2)
    o2 = new_buf(72);
  var flags = 0;
  if (data) {
    if (data.filterPrivacy)
      flags |= 8;
  }
  o2.write_shift(4, flags);
  o2.write_shift(4, 0);
  write_XLSBCodeName(data && data.CodeName || "ThisWorkbook", o2);
  return o2.slice(0, o2.l);
}
function parse_BrtFRTArchID$(data, length) {
  var o2 = {};
  data.read_shift(4);
  o2.ArchID = data.read_shift(4);
  data.l += length - 8;
  return o2;
}
function parse_BrtName(data, length, opts) {
  var end = data.l + length;
  data.l += 4;
  data.l += 1;
  var itab = data.read_shift(4);
  var name = parse_XLNameWideString(data);
  var formula = parse_XLSBNameParsedFormula(data, 0, opts);
  var comment = parse_XLNullableWideString(data);
  data.l = end;
  var out = { Name: name, Ptg: formula };
  if (itab < 268435455)
    out.Sheet = itab;
  if (comment)
    out.Comment = comment;
  return out;
}
function parse_wb_bin(data, opts) {
  var wb = { AppVersion: {}, WBProps: {}, WBView: [], Sheets: [], CalcPr: {}, xmlns: "" };
  var state = [];
  var pass = false;
  if (!opts)
    opts = {};
  opts.biff = 12;
  var Names = [];
  var supbooks = [[]];
  supbooks.SheetNames = [];
  supbooks.XTI = [];
  XLSBRecordEnum[16] = { n: "BrtFRTArchID$", f: parse_BrtFRTArchID$ };
  recordhopper(data, function hopper_wb(val, R2, RT) {
    switch (RT) {
      case 156:
        supbooks.SheetNames.push(val.name);
        wb.Sheets.push(val);
        break;
      case 153:
        wb.WBProps = val;
        break;
      case 39:
        if (val.Sheet != null)
          opts.SID = val.Sheet;
        val.Ref = stringify_formula(val.Ptg, null, null, supbooks, opts);
        delete opts.SID;
        delete val.Ptg;
        Names.push(val);
        break;
      case 1036:
        break;
      case 357:
      case 358:
      case 355:
      case 667:
        if (!supbooks[0].length)
          supbooks[0] = [RT, val];
        else
          supbooks.push([RT, val]);
        supbooks[supbooks.length - 1].XTI = [];
        break;
      case 362:
        if (supbooks.length === 0) {
          supbooks[0] = [];
          supbooks[0].XTI = [];
        }
        supbooks[supbooks.length - 1].XTI = supbooks[supbooks.length - 1].XTI.concat(val);
        supbooks.XTI = supbooks.XTI.concat(val);
        break;
      case 361:
        break;
      case 2071:
      case 158:
      case 143:
      case 664:
      case 353:
        break;
      case 3072:
      case 3073:
      case 534:
      case 677:
      case 157:
      case 610:
      case 2050:
      case 155:
      case 548:
      case 676:
      case 128:
      case 665:
      case 2128:
      case 2125:
      case 549:
      case 2053:
      case 596:
      case 2076:
      case 2075:
      case 2082:
      case 397:
      case 154:
      case 1117:
      case 553:
      case 2091:
        break;
      case 35:
        state.push(RT);
        pass = true;
        break;
      case 36:
        state.pop();
        pass = false;
        break;
      case 37:
        state.push(RT);
        pass = true;
        break;
      case 38:
        state.pop();
        pass = false;
        break;
      case 16:
        break;
      default:
        if (R2.T) {
        } else if (!pass || opts.WTF && state[state.length - 1] != 37 && state[state.length - 1] != 35)
          throw new Error("Unexpected record 0x" + RT.toString(16));
    }
  }, opts);
  parse_wb_defaults(wb);
  wb.Names = Names;
  wb.supbooks = supbooks;
  return wb;
}
function write_BUNDLESHS(ba, wb) {
  write_record(
    ba,
    143
    /* BrtBeginBundleShs */
  );
  for (var idx = 0; idx != wb.SheetNames.length; ++idx) {
    var viz = wb.Workbook && wb.Workbook.Sheets && wb.Workbook.Sheets[idx] && wb.Workbook.Sheets[idx].Hidden || 0;
    var d2 = { Hidden: viz, iTabID: idx + 1, strRelID: "rId" + (idx + 1), name: wb.SheetNames[idx] };
    write_record(ba, 156, write_BrtBundleSh(d2));
  }
  write_record(
    ba,
    144
    /* BrtEndBundleShs */
  );
}
function write_BrtFileVersion(data, o2) {
  if (!o2)
    o2 = new_buf(127);
  for (var i2 = 0; i2 != 4; ++i2)
    o2.write_shift(4, 0);
  write_XLWideString("SheetJS", o2);
  write_XLWideString(XLSX.version, o2);
  write_XLWideString(XLSX.version, o2);
  write_XLWideString("7262", o2);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function write_BrtBookView(idx, o2) {
  if (!o2)
    o2 = new_buf(29);
  o2.write_shift(-4, 0);
  o2.write_shift(-4, 460);
  o2.write_shift(4, 28800);
  o2.write_shift(4, 17600);
  o2.write_shift(4, 500);
  o2.write_shift(4, idx);
  o2.write_shift(4, idx);
  var flags = 120;
  o2.write_shift(1, flags);
  return o2.length > o2.l ? o2.slice(0, o2.l) : o2;
}
function write_BOOKVIEWS(ba, wb) {
  if (!wb.Workbook || !wb.Workbook.Sheets)
    return;
  var sheets = wb.Workbook.Sheets;
  var i2 = 0, vistab = -1, hidden = -1;
  for (; i2 < sheets.length; ++i2) {
    if (!sheets[i2] || !sheets[i2].Hidden && vistab == -1)
      vistab = i2;
    else if (sheets[i2].Hidden == 1 && hidden == -1)
      hidden = i2;
  }
  if (hidden > vistab)
    return;
  write_record(
    ba,
    135
    /* BrtBeginBookViews */
  );
  write_record(ba, 158, write_BrtBookView(vistab));
  write_record(
    ba,
    136
    /* BrtEndBookViews */
  );
}
function write_wb_bin(wb, opts) {
  var ba = buf_array();
  write_record(
    ba,
    131
    /* BrtBeginBook */
  );
  write_record(ba, 128, write_BrtFileVersion());
  write_record(ba, 153, write_BrtWbProp(wb.Workbook && wb.Workbook.WBProps || null));
  write_BOOKVIEWS(ba, wb, opts);
  write_BUNDLESHS(ba, wb, opts);
  write_record(
    ba,
    132
    /* BrtEndBook */
  );
  return ba.end();
}
function parse_wb(data, name, opts) {
  if (name.slice(-4) === ".bin")
    return parse_wb_bin(data, opts);
  return parse_wb_xml(data, opts);
}
function parse_ws(data, name, idx, opts, rels, wb, themes, styles) {
  if (name.slice(-4) === ".bin")
    return parse_ws_bin(data, opts, idx, rels, wb, themes, styles);
  return parse_ws_xml(data, opts, idx, rels, wb, themes, styles);
}
function parse_cs(data, name, idx, opts, rels, wb, themes, styles) {
  if (name.slice(-4) === ".bin")
    return parse_cs_bin(data, opts, idx, rels, wb, themes, styles);
  return parse_cs_xml(data, opts, idx, rels, wb, themes, styles);
}
function parse_ms(data, name, idx, opts, rels, wb, themes, styles) {
  if (name.slice(-4) === ".bin")
    return parse_ms_bin(data, opts, idx, rels, wb, themes, styles);
  return parse_ms_xml(data, opts, idx, rels, wb, themes, styles);
}
function parse_ds(data, name, idx, opts, rels, wb, themes, styles) {
  if (name.slice(-4) === ".bin")
    return parse_ds_bin(data, opts, idx, rels, wb, themes, styles);
  return parse_ds_xml(data, opts, idx, rels, wb, themes, styles);
}
function parse_sty(data, name, themes, opts) {
  if (name.slice(-4) === ".bin")
    return parse_sty_bin(data, themes, opts);
  return parse_sty_xml(data, themes, opts);
}
function parse_theme(data, name, opts) {
  return parse_theme_xml(data, opts);
}
function parse_sst(data, name, opts) {
  if (name.slice(-4) === ".bin")
    return parse_sst_bin(data, opts);
  return parse_sst_xml(data, opts);
}
function parse_cmnt(data, name, opts) {
  if (name.slice(-4) === ".bin")
    return parse_comments_bin(data, opts);
  return parse_comments_xml(data, opts);
}
function parse_cc(data, name, opts) {
  if (name.slice(-4) === ".bin")
    return parse_cc_bin(data, name, opts);
  return parse_cc_xml(data, name, opts);
}
function parse_xlink(data, rel, name, opts) {
  if (name.slice(-4) === ".bin")
    return parse_xlink_bin(data, rel, name, opts);
  return parse_xlink_xml(data, rel, name, opts);
}
function parse_xlmeta(data, name, opts) {
  if (name.slice(-4) === ".bin")
    return parse_xlmeta_bin(data, name, opts);
  return parse_xlmeta_xml(data, name, opts);
}
function write_wb(wb, name, opts) {
  return (name.slice(-4) === ".bin" ? write_wb_bin : write_wb_xml)(wb, opts);
}
function write_ws(data, name, opts, wb, rels) {
  return (name.slice(-4) === ".bin" ? write_ws_bin : write_ws_xml)(data, opts, wb, rels);
}
function write_sty(data, name, opts) {
  return (name.slice(-4) === ".bin" ? write_sty_bin : write_sty_xml)(data, opts);
}
function write_sst(data, name, opts) {
  return (name.slice(-4) === ".bin" ? write_sst_bin : write_sst_xml)(data, opts);
}
function write_cmnt(data, name, opts) {
  return (name.slice(-4) === ".bin" ? write_comments_bin : write_comments_xml)(data, opts);
}
function write_xlmeta(name) {
  return (name.slice(-4) === ".bin" ? write_xlmeta_bin : write_xlmeta_xml)();
}
var attregexg2 = /([\w:]+)=((?:")([^"]*)(?:")|(?:')([^']*)(?:'))/g;
var attregex2 = /([\w:]+)=((?:")(?:[^"]*)(?:")|(?:')(?:[^']*)(?:'))/;
function xlml_parsexmltag(tag, skip_root) {
  var words = tag.split(/\s+/);
  var z2 = [];
  if (!skip_root)
    z2[0] = words[0];
  if (words.length === 1)
    return z2;
  var m2 = tag.match(attregexg2), y2, j2, w2, i2;
  if (m2)
    for (i2 = 0; i2 != m2.length; ++i2) {
      y2 = m2[i2].match(attregex2);
      if ((j2 = y2[1].indexOf(":")) === -1)
        z2[y2[1]] = y2[2].slice(1, y2[2].length - 1);
      else {
        if (y2[1].slice(0, 6) === "xmlns:")
          w2 = "xmlns" + y2[1].slice(6);
        else
          w2 = y2[1].slice(j2 + 1);
        z2[w2] = y2[2].slice(1, y2[2].length - 1);
      }
    }
  return z2;
}
function xlml_parsexmltagobj(tag) {
  var words = tag.split(/\s+/);
  var z2 = {};
  if (words.length === 1)
    return z2;
  var m2 = tag.match(attregexg2), y2, j2, w2, i2;
  if (m2)
    for (i2 = 0; i2 != m2.length; ++i2) {
      y2 = m2[i2].match(attregex2);
      if ((j2 = y2[1].indexOf(":")) === -1)
        z2[y2[1]] = y2[2].slice(1, y2[2].length - 1);
      else {
        if (y2[1].slice(0, 6) === "xmlns:")
          w2 = "xmlns" + y2[1].slice(6);
        else
          w2 = y2[1].slice(j2 + 1);
        z2[w2] = y2[2].slice(1, y2[2].length - 1);
      }
    }
  return z2;
}
var XLMLFormatMap;
function xlml_format(format, value) {
  var fmt = XLMLFormatMap[format] || unescapexml(format);
  if (fmt === "General")
    return SSF_general(value);
  return SSF_format(fmt, value);
}
function xlml_set_custprop(Custprops, key, cp, val) {
  var oval = val;
  switch ((cp[0].match(/dt:dt="([\w.]+)"/) || ["", ""])[1]) {
    case "boolean":
      oval = parsexmlbool(val);
      break;
    case "i2":
    case "int":
      oval = parseInt(val, 10);
      break;
    case "r4":
    case "float":
      oval = parseFloat(val);
      break;
    case "date":
    case "dateTime.tz":
      oval = parseDate(val);
      break;
    case "i8":
    case "string":
    case "fixed":
    case "uuid":
    case "bin.base64":
      break;
    default:
      throw new Error("bad custprop:" + cp[0]);
  }
  Custprops[unescapexml(key)] = oval;
}
function safe_format_xlml(cell, nf, o2) {
  if (cell.t === "z")
    return;
  if (!o2 || o2.cellText !== false)
    try {
      if (cell.t === "e") {
        cell.w = cell.w || BErr[cell.v];
      } else if (nf === "General") {
        if (cell.t === "n") {
          if ((cell.v | 0) === cell.v)
            cell.w = cell.v.toString(10);
          else
            cell.w = SSF_general_num(cell.v);
        } else
          cell.w = SSF_general(cell.v);
      } else
        cell.w = xlml_format(nf || "General", cell.v);
    } catch (e) {
      if (o2.WTF)
        throw e;
    }
  try {
    var z2 = XLMLFormatMap[nf] || nf || "General";
    if (o2.cellNF)
      cell.z = z2;
    if (o2.cellDates && cell.t == "n" && fmt_is_date(z2)) {
      var _d = SSF_parse_date_code(cell.v);
      if (_d) {
        cell.t = "d";
        cell.v = new Date(_d.y, _d.m - 1, _d.d, _d.H, _d.M, _d.S, _d.u);
      }
    }
  } catch (e) {
    if (o2.WTF)
      throw e;
  }
}
function process_style_xlml(styles, stag, opts) {
  if (opts.cellStyles) {
    if (stag.Interior) {
      var I2 = stag.Interior;
      if (I2.Pattern)
        I2.patternType = XLMLPatternTypeMap[I2.Pattern] || I2.Pattern;
    }
  }
  styles[stag.ID] = stag;
}
function parse_xlml_data(xml, ss, data, cell, base, styles, csty, row, arrayf, o2) {
  var nf = "General", sid = cell.StyleID, S2 = {};
  o2 = o2 || {};
  var interiors = [];
  var i2 = 0;
  if (sid === void 0 && row)
    sid = row.StyleID;
  if (sid === void 0 && csty)
    sid = csty.StyleID;
  while (styles[sid] !== void 0) {
    if (styles[sid].nf)
      nf = styles[sid].nf;
    if (styles[sid].Interior)
      interiors.push(styles[sid].Interior);
    if (!styles[sid].Parent)
      break;
    sid = styles[sid].Parent;
  }
  switch (data.Type) {
    case "Boolean":
      cell.t = "b";
      cell.v = parsexmlbool(xml);
      break;
    case "String":
      cell.t = "s";
      cell.r = xlml_fixstr(unescapexml(xml));
      cell.v = xml.indexOf("<") > -1 ? unescapexml(ss || xml).replace(/<.*?>/g, "") : cell.r;
      break;
    case "DateTime":
      if (xml.slice(-1) != "Z")
        xml += "Z";
      cell.v = (parseDate(xml) - new Date(Date.UTC(1899, 11, 30))) / (24 * 60 * 60 * 1e3);
      if (cell.v !== cell.v)
        cell.v = unescapexml(xml);
      else if (cell.v < 60)
        cell.v = cell.v - 1;
      if (!nf || nf == "General")
        nf = "yyyy-mm-dd";
    case "Number":
      if (cell.v === void 0)
        cell.v = +xml;
      if (!cell.t)
        cell.t = "n";
      break;
    case "Error":
      cell.t = "e";
      cell.v = RBErr[xml];
      if (o2.cellText !== false)
        cell.w = xml;
      break;
    default:
      if (xml == "" && ss == "") {
        cell.t = "z";
      } else {
        cell.t = "s";
        cell.v = xlml_fixstr(ss || xml);
      }
      break;
  }
  safe_format_xlml(cell, nf, o2);
  if (o2.cellFormula !== false) {
    if (cell.Formula) {
      var fstr = unescapexml(cell.Formula);
      if (fstr.charCodeAt(0) == 61)
        fstr = fstr.slice(1);
      cell.f = rc_to_a1(fstr, base);
      delete cell.Formula;
      if (cell.ArrayRange == "RC")
        cell.F = rc_to_a1("RC:RC", base);
      else if (cell.ArrayRange) {
        cell.F = rc_to_a1(cell.ArrayRange, base);
        arrayf.push([safe_decode_range(cell.F), cell.F]);
      }
    } else {
      for (i2 = 0; i2 < arrayf.length; ++i2)
        if (base.r >= arrayf[i2][0].s.r && base.r <= arrayf[i2][0].e.r) {
          if (base.c >= arrayf[i2][0].s.c && base.c <= arrayf[i2][0].e.c)
            cell.F = arrayf[i2][1];
        }
    }
  }
  if (o2.cellStyles) {
    interiors.forEach(function(x2) {
      if (!S2.patternType && x2.patternType)
        S2.patternType = x2.patternType;
    });
    cell.s = S2;
  }
  if (cell.StyleID !== void 0)
    cell.ixfe = cell.StyleID;
}
function xlml_clean_comment(comment) {
  comment.t = comment.v || "";
  comment.t = comment.t.replace(/\r\n/g, "\n").replace(/\r/g, "\n");
  comment.v = comment.w = comment.ixfe = void 0;
}
function parse_xlml_xml(d2, _opts) {
  var opts = _opts || {};
  make_ssf();
  var str = debom(xlml_normalize(d2));
  if (opts.type == "binary" || opts.type == "array" || opts.type == "base64") {
    if (typeof $cptable !== "undefined")
      str = $cptable.utils.decode(65001, char_codes(str));
    else
      str = utf8read(str);
  }
  var opening = str.slice(0, 1024).toLowerCase(), ishtml = false;
  opening = opening.replace(/".*?"/g, "");
  if ((opening.indexOf(">") & 1023) > Math.min(opening.indexOf(",") & 1023, opening.indexOf(";") & 1023)) {
    var _o = dup(opts);
    _o.type = "string";
    return PRN.to_workbook(str, _o);
  }
  if (opening.indexOf("<?xml") == -1)
    ["html", "table", "head", "meta", "script", "style", "div"].forEach(function(tag) {
      if (opening.indexOf("<" + tag) >= 0)
        ishtml = true;
    });
  if (ishtml)
    return html_to_workbook(str, opts);
  XLMLFormatMap = {
    "General Number": "General",
    "General Date": table_fmt[22],
    "Long Date": "dddd, mmmm dd, yyyy",
    "Medium Date": table_fmt[15],
    "Short Date": table_fmt[14],
    "Long Time": table_fmt[19],
    "Medium Time": table_fmt[18],
    "Short Time": table_fmt[20],
    "Currency": '"$"#,##0.00_);[Red]\\("$"#,##0.00\\)',
    "Fixed": table_fmt[2],
    "Standard": table_fmt[4],
    "Percent": table_fmt[10],
    "Scientific": table_fmt[11],
    "Yes/No": '"Yes";"Yes";"No";@',
    "True/False": '"True";"True";"False";@',
    "On/Off": '"Yes";"Yes";"No";@'
  };
  var Rn;
  var state = [], tmp;
  if (DENSE != null && opts.dense == null)
    opts.dense = DENSE;
  var sheets = {}, sheetnames = [], cursheet = opts.dense ? [] : {}, sheetname = "";
  var cell = {}, row = {};
  var dtag = xlml_parsexmltag('<Data ss:Type="String">'), didx = 0;
  var c2 = 0, r = 0;
  var refguess = { s: { r: 2e6, c: 2e6 }, e: { r: 0, c: 0 } };
  var styles = {}, stag = {};
  var ss = "", fidx = 0;
  var merges = [];
  var Props = {}, Custprops = {}, pidx = 0, cp = [];
  var comments = [], comment = {};
  var cstys = [], csty, seencol = false;
  var arrayf = [];
  var rowinfo = [], rowobj = {}, cc = 0, rr = 0;
  var Workbook = { Sheets: [], WBProps: { date1904: false } }, wsprops = {};
  xlmlregex.lastIndex = 0;
  str = str.replace(/<!--([\s\S]*?)-->/mg, "");
  var raw_Rn3 = "";
  while (Rn = xlmlregex.exec(str))
    switch (Rn[3] = (raw_Rn3 = Rn[3]).toLowerCase()) {
      case "data":
        if (raw_Rn3 == "data") {
          if (Rn[1] === "/") {
            if ((tmp = state.pop())[0] !== Rn[3])
              throw new Error("Bad state: " + tmp.join("|"));
          } else if (Rn[0].charAt(Rn[0].length - 2) !== "/")
            state.push([Rn[3], true]);
          break;
        }
        if (state[state.length - 1][1])
          break;
        if (Rn[1] === "/")
          parse_xlml_data(str.slice(didx, Rn.index), ss, dtag, state[state.length - 1][0] == /*"Comment"*/
          "comment" ? comment : cell, { c: c2, r }, styles, cstys[c2], row, arrayf, opts);
        else {
          ss = "";
          dtag = xlml_parsexmltag(Rn[0]);
          didx = Rn.index + Rn[0].length;
        }
        break;
      case "cell":
        if (Rn[1] === "/") {
          if (comments.length > 0)
            cell.c = comments;
          if ((!opts.sheetRows || opts.sheetRows > r) && cell.v !== void 0) {
            if (opts.dense) {
              if (!cursheet[r])
                cursheet[r] = [];
              cursheet[r][c2] = cell;
            } else
              cursheet[encode_col(c2) + encode_row(r)] = cell;
          }
          if (cell.HRef) {
            cell.l = { Target: unescapexml(cell.HRef) };
            if (cell.HRefScreenTip)
              cell.l.Tooltip = cell.HRefScreenTip;
            delete cell.HRef;
            delete cell.HRefScreenTip;
          }
          if (cell.MergeAcross || cell.MergeDown) {
            cc = c2 + (parseInt(cell.MergeAcross, 10) | 0);
            rr = r + (parseInt(cell.MergeDown, 10) | 0);
            merges.push({ s: { c: c2, r }, e: { c: cc, r: rr } });
          }
          if (!opts.sheetStubs) {
            if (cell.MergeAcross)
              c2 = cc + 1;
            else
              ++c2;
          } else if (cell.MergeAcross || cell.MergeDown) {
            for (var cma = c2; cma <= cc; ++cma) {
              for (var cmd = r; cmd <= rr; ++cmd) {
                if (cma > c2 || cmd > r) {
                  if (opts.dense) {
                    if (!cursheet[cmd])
                      cursheet[cmd] = [];
                    cursheet[cmd][cma] = { t: "z" };
                  } else
                    cursheet[encode_col(cma) + encode_row(cmd)] = { t: "z" };
                }
              }
            }
            c2 = cc + 1;
          } else
            ++c2;
        } else {
          cell = xlml_parsexmltagobj(Rn[0]);
          if (cell.Index)
            c2 = +cell.Index - 1;
          if (c2 < refguess.s.c)
            refguess.s.c = c2;
          if (c2 > refguess.e.c)
            refguess.e.c = c2;
          if (Rn[0].slice(-2) === "/>")
            ++c2;
          comments = [];
        }
        break;
      case "row":
        if (Rn[1] === "/" || Rn[0].slice(-2) === "/>") {
          if (r < refguess.s.r)
            refguess.s.r = r;
          if (r > refguess.e.r)
            refguess.e.r = r;
          if (Rn[0].slice(-2) === "/>") {
            row = xlml_parsexmltag(Rn[0]);
            if (row.Index)
              r = +row.Index - 1;
          }
          c2 = 0;
          ++r;
        } else {
          row = xlml_parsexmltag(Rn[0]);
          if (row.Index)
            r = +row.Index - 1;
          rowobj = {};
          if (row.AutoFitHeight == "0" || row.Height) {
            rowobj.hpx = parseInt(row.Height, 10);
            rowobj.hpt = px2pt(rowobj.hpx);
            rowinfo[r] = rowobj;
          }
          if (row.Hidden == "1") {
            rowobj.hidden = true;
            rowinfo[r] = rowobj;
          }
        }
        break;
      case "worksheet":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
          sheetnames.push(sheetname);
          if (refguess.s.r <= refguess.e.r && refguess.s.c <= refguess.e.c) {
            cursheet["!ref"] = encode_range(refguess);
            if (opts.sheetRows && opts.sheetRows <= refguess.e.r) {
              cursheet["!fullref"] = cursheet["!ref"];
              refguess.e.r = opts.sheetRows - 1;
              cursheet["!ref"] = encode_range(refguess);
            }
          }
          if (merges.length)
            cursheet["!merges"] = merges;
          if (cstys.length > 0)
            cursheet["!cols"] = cstys;
          if (rowinfo.length > 0)
            cursheet["!rows"] = rowinfo;
          sheets[sheetname] = cursheet;
        } else {
          refguess = { s: { r: 2e6, c: 2e6 }, e: { r: 0, c: 0 } };
          r = c2 = 0;
          state.push([Rn[3], false]);
          tmp = xlml_parsexmltag(Rn[0]);
          sheetname = unescapexml(tmp.Name);
          cursheet = opts.dense ? [] : {};
          merges = [];
          arrayf = [];
          rowinfo = [];
          wsprops = { name: sheetname, Hidden: 0 };
          Workbook.Sheets.push(wsprops);
        }
        break;
      case "table":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
        } else if (Rn[0].slice(-2) == "/>")
          break;
        else {
          state.push([Rn[3], false]);
          cstys = [];
          seencol = false;
        }
        break;
      case "style":
        if (Rn[1] === "/")
          process_style_xlml(styles, stag, opts);
        else
          stag = xlml_parsexmltag(Rn[0]);
        break;
      case "numberformat":
        stag.nf = unescapexml(xlml_parsexmltag(Rn[0]).Format || "General");
        if (XLMLFormatMap[stag.nf])
          stag.nf = XLMLFormatMap[stag.nf];
        for (var ssfidx = 0; ssfidx != 392; ++ssfidx)
          if (table_fmt[ssfidx] == stag.nf)
            break;
        if (ssfidx == 392) {
          for (ssfidx = 57; ssfidx != 392; ++ssfidx)
            if (table_fmt[ssfidx] == null) {
              SSF_load(stag.nf, ssfidx);
              break;
            }
        }
        break;
      case "column":
        if (state[state.length - 1][0] !== /*'Table'*/
        "table")
          break;
        csty = xlml_parsexmltag(Rn[0]);
        if (csty.Hidden) {
          csty.hidden = true;
          delete csty.Hidden;
        }
        if (csty.Width)
          csty.wpx = parseInt(csty.Width, 10);
        if (!seencol && csty.wpx > 10) {
          seencol = true;
          MDW = DEF_MDW;
          for (var _col = 0; _col < cstys.length; ++_col)
            if (cstys[_col])
              process_col(cstys[_col]);
        }
        if (seencol)
          process_col(csty);
        cstys[csty.Index - 1 || cstys.length] = csty;
        for (var i2 = 0; i2 < +csty.Span; ++i2)
          cstys[cstys.length] = dup(csty);
        break;
      case "namedrange":
        if (Rn[1] === "/")
          break;
        if (!Workbook.Names)
          Workbook.Names = [];
        var _NamedRange = parsexmltag(Rn[0]);
        var _DefinedName = {
          Name: _NamedRange.Name,
          Ref: rc_to_a1(_NamedRange.RefersTo.slice(1), { r: 0, c: 0 })
        };
        if (Workbook.Sheets.length > 0)
          _DefinedName.Sheet = Workbook.Sheets.length - 1;
        Workbook.Names.push(_DefinedName);
        break;
      case "namedcell":
        break;
      case "b":
        break;
      case "i":
        break;
      case "u":
        break;
      case "s":
        break;
      case "em":
        break;
      case "h2":
        break;
      case "h3":
        break;
      case "sub":
        break;
      case "sup":
        break;
      case "span":
        break;
      case "alignment":
        break;
      case "borders":
        break;
      case "border":
        break;
      case "font":
        if (Rn[0].slice(-2) === "/>")
          break;
        else if (Rn[1] === "/")
          ss += str.slice(fidx, Rn.index);
        else
          fidx = Rn.index + Rn[0].length;
        break;
      case "interior":
        if (!opts.cellStyles)
          break;
        stag.Interior = xlml_parsexmltag(Rn[0]);
        break;
      case "protection":
        break;
      case "author":
      case "title":
      case "description":
      case "created":
      case "keywords":
      case "subject":
      case "category":
      case "company":
      case "lastauthor":
      case "lastsaved":
      case "lastprinted":
      case "version":
      case "revision":
      case "totaltime":
      case "hyperlinkbase":
      case "manager":
      case "contentstatus":
      case "identifier":
      case "language":
      case "appname":
        if (Rn[0].slice(-2) === "/>")
          break;
        else if (Rn[1] === "/")
          xlml_set_prop(Props, raw_Rn3, str.slice(pidx, Rn.index));
        else
          pidx = Rn.index + Rn[0].length;
        break;
      case "paragraphs":
        break;
      case "styles":
      case "workbook":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
        } else
          state.push([Rn[3], false]);
        break;
      case "comment":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
          xlml_clean_comment(comment);
          comments.push(comment);
        } else {
          state.push([Rn[3], false]);
          tmp = xlml_parsexmltag(Rn[0]);
          comment = { a: tmp.Author };
        }
        break;
      case "autofilter":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/") {
          var AutoFilter = xlml_parsexmltag(Rn[0]);
          cursheet["!autofilter"] = { ref: rc_to_a1(AutoFilter.Range).replace(/\$/g, "") };
          state.push([Rn[3], true]);
        }
        break;
      case "name":
        break;
      case "datavalidation":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
        } else {
          if (Rn[0].charAt(Rn[0].length - 2) !== "/")
            state.push([Rn[3], true]);
        }
        break;
      case "pixelsperinch":
        break;
      case "componentoptions":
      case "documentproperties":
      case "customdocumentproperties":
      case "officedocumentsettings":
      case "pivottable":
      case "pivotcache":
      case "names":
      case "mapinfo":
      case "pagebreaks":
      case "querytable":
      case "sorting":
      case "schema":
      case "conditionalformatting":
      case "smarttagtype":
      case "smarttags":
      case "excelworkbook":
      case "workbookoptions":
      case "worksheetoptions":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw new Error("Bad state: " + tmp.join("|"));
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/")
          state.push([Rn[3], true]);
        break;
      case "null":
        break;
      default:
        if (state.length == 0 && Rn[3] == "document")
          return parse_fods(str, opts);
        if (state.length == 0 && Rn[3] == "uof")
          return parse_fods(str, opts);
        var seen = true;
        switch (state[state.length - 1][0]) {
          case "officedocumentsettings":
            switch (Rn[3]) {
              case "allowpng":
                break;
              case "removepersonalinformation":
                break;
              case "downloadcomponents":
                break;
              case "locationofcomponents":
                break;
              case "colors":
                break;
              case "color":
                break;
              case "index":
                break;
              case "rgb":
                break;
              case "targetscreensize":
                break;
              case "readonlyrecommended":
                break;
              default:
                seen = false;
            }
            break;
          case "componentoptions":
            switch (Rn[3]) {
              case "toolbar":
                break;
              case "hideofficelogo":
                break;
              case "spreadsheetautofit":
                break;
              case "label":
                break;
              case "caption":
                break;
              case "maxheight":
                break;
              case "maxwidth":
                break;
              case "nextsheetnumber":
                break;
              default:
                seen = false;
            }
            break;
          case "excelworkbook":
            switch (Rn[3]) {
              case "date1904":
                Workbook.WBProps.date1904 = true;
                break;
              case "windowheight":
                break;
              case "windowwidth":
                break;
              case "windowtopx":
                break;
              case "windowtopy":
                break;
              case "tabratio":
                break;
              case "protectstructure":
                break;
              case "protectwindow":
                break;
              case "protectwindows":
                break;
              case "activesheet":
                break;
              case "displayinknotes":
                break;
              case "firstvisiblesheet":
                break;
              case "supbook":
                break;
              case "sheetname":
                break;
              case "sheetindex":
                break;
              case "sheetindexfirst":
                break;
              case "sheetindexlast":
                break;
              case "dll":
                break;
              case "acceptlabelsinformulas":
                break;
              case "donotsavelinkvalues":
                break;
              case "iteration":
                break;
              case "maxiterations":
                break;
              case "maxchange":
                break;
              case "path":
                break;
              case "xct":
                break;
              case "count":
                break;
              case "selectedsheets":
                break;
              case "calculation":
                break;
              case "uncalced":
                break;
              case "startupprompt":
                break;
              case "crn":
                break;
              case "externname":
                break;
              case "formula":
                break;
              case "colfirst":
                break;
              case "collast":
                break;
              case "wantadvise":
                break;
              case "boolean":
                break;
              case "error":
                break;
              case "text":
                break;
              case "ole":
                break;
              case "noautorecover":
                break;
              case "publishobjects":
                break;
              case "donotcalculatebeforesave":
                break;
              case "number":
                break;
              case "refmoder1c1":
                break;
              case "embedsavesmarttags":
                break;
              default:
                seen = false;
            }
            break;
          case "workbookoptions":
            switch (Rn[3]) {
              case "owcversion":
                break;
              case "height":
                break;
              case "width":
                break;
              default:
                seen = false;
            }
            break;
          case "worksheetoptions":
            switch (Rn[3]) {
              case "visible":
                if (Rn[0].slice(-2) === "/>") {
                } else if (Rn[1] === "/")
                  switch (str.slice(pidx, Rn.index)) {
                    case "SheetHidden":
                      wsprops.Hidden = 1;
                      break;
                    case "SheetVeryHidden":
                      wsprops.Hidden = 2;
                      break;
                  }
                else
                  pidx = Rn.index + Rn[0].length;
                break;
              case "header":
                if (!cursheet["!margins"])
                  default_margins(cursheet["!margins"] = {}, "xlml");
                if (!isNaN(+parsexmltag(Rn[0]).Margin))
                  cursheet["!margins"].header = +parsexmltag(Rn[0]).Margin;
                break;
              case "footer":
                if (!cursheet["!margins"])
                  default_margins(cursheet["!margins"] = {}, "xlml");
                if (!isNaN(+parsexmltag(Rn[0]).Margin))
                  cursheet["!margins"].footer = +parsexmltag(Rn[0]).Margin;
                break;
              case "pagemargins":
                var pagemargins = parsexmltag(Rn[0]);
                if (!cursheet["!margins"])
                  default_margins(cursheet["!margins"] = {}, "xlml");
                if (!isNaN(+pagemargins.Top))
                  cursheet["!margins"].top = +pagemargins.Top;
                if (!isNaN(+pagemargins.Left))
                  cursheet["!margins"].left = +pagemargins.Left;
                if (!isNaN(+pagemargins.Right))
                  cursheet["!margins"].right = +pagemargins.Right;
                if (!isNaN(+pagemargins.Bottom))
                  cursheet["!margins"].bottom = +pagemargins.Bottom;
                break;
              case "displayrighttoleft":
                if (!Workbook.Views)
                  Workbook.Views = [];
                if (!Workbook.Views[0])
                  Workbook.Views[0] = {};
                Workbook.Views[0].RTL = true;
                break;
              case "freezepanes":
                break;
              case "frozennosplit":
                break;
              case "splithorizontal":
              case "splitvertical":
                break;
              case "donotdisplaygridlines":
                break;
              case "activerow":
                break;
              case "activecol":
                break;
              case "toprowbottompane":
                break;
              case "leftcolumnrightpane":
                break;
              case "unsynced":
                break;
              case "print":
                break;
              case "printerrors":
                break;
              case "panes":
                break;
              case "scale":
                break;
              case "pane":
                break;
              case "number":
                break;
              case "layout":
                break;
              case "pagesetup":
                break;
              case "selected":
                break;
              case "protectobjects":
                break;
              case "enableselection":
                break;
              case "protectscenarios":
                break;
              case "validprinterinfo":
                break;
              case "horizontalresolution":
                break;
              case "verticalresolution":
                break;
              case "numberofcopies":
                break;
              case "activepane":
                break;
              case "toprowvisible":
                break;
              case "leftcolumnvisible":
                break;
              case "fittopage":
                break;
              case "rangeselection":
                break;
              case "papersizeindex":
                break;
              case "pagelayoutzoom":
                break;
              case "pagebreakzoom":
                break;
              case "filteron":
                break;
              case "fitwidth":
                break;
              case "fitheight":
                break;
              case "commentslayout":
                break;
              case "zoom":
                break;
              case "lefttoright":
                break;
              case "gridlines":
                break;
              case "allowsort":
                break;
              case "allowfilter":
                break;
              case "allowinsertrows":
                break;
              case "allowdeleterows":
                break;
              case "allowinsertcols":
                break;
              case "allowdeletecols":
                break;
              case "allowinserthyperlinks":
                break;
              case "allowformatcells":
                break;
              case "allowsizecols":
                break;
              case "allowsizerows":
                break;
              case "nosummaryrowsbelowdetail":
                if (!cursheet["!outline"])
                  cursheet["!outline"] = {};
                cursheet["!outline"].above = true;
                break;
              case "tabcolorindex":
                break;
              case "donotdisplayheadings":
                break;
              case "showpagelayoutzoom":
                break;
              case "nosummarycolumnsrightdetail":
                if (!cursheet["!outline"])
                  cursheet["!outline"] = {};
                cursheet["!outline"].left = true;
                break;
              case "blackandwhite":
                break;
              case "donotdisplayzeros":
                break;
              case "displaypagebreak":
                break;
              case "rowcolheadings":
                break;
              case "donotdisplayoutline":
                break;
              case "noorientation":
                break;
              case "allowusepivottables":
                break;
              case "zeroheight":
                break;
              case "viewablerange":
                break;
              case "selection":
                break;
              case "protectcontents":
                break;
              default:
                seen = false;
            }
            break;
          case "pivottable":
          case "pivotcache":
            switch (Rn[3]) {
              case "immediateitemsondrop":
                break;
              case "showpagemultipleitemlabel":
                break;
              case "compactrowindent":
                break;
              case "location":
                break;
              case "pivotfield":
                break;
              case "orientation":
                break;
              case "layoutform":
                break;
              case "layoutsubtotallocation":
                break;
              case "layoutcompactrow":
                break;
              case "position":
                break;
              case "pivotitem":
                break;
              case "datatype":
                break;
              case "datafield":
                break;
              case "sourcename":
                break;
              case "parentfield":
                break;
              case "ptlineitems":
                break;
              case "ptlineitem":
                break;
              case "countofsameitems":
                break;
              case "item":
                break;
              case "itemtype":
                break;
              case "ptsource":
                break;
              case "cacheindex":
                break;
              case "consolidationreference":
                break;
              case "filename":
                break;
              case "reference":
                break;
              case "nocolumngrand":
                break;
              case "norowgrand":
                break;
              case "blanklineafteritems":
                break;
              case "hidden":
                break;
              case "subtotal":
                break;
              case "basefield":
                break;
              case "mapchilditems":
                break;
              case "function":
                break;
              case "refreshonfileopen":
                break;
              case "printsettitles":
                break;
              case "mergelabels":
                break;
              case "defaultversion":
                break;
              case "refreshname":
                break;
              case "refreshdate":
                break;
              case "refreshdatecopy":
                break;
              case "versionlastrefresh":
                break;
              case "versionlastupdate":
                break;
              case "versionupdateablemin":
                break;
              case "versionrefreshablemin":
                break;
              case "calculation":
                break;
              default:
                seen = false;
            }
            break;
          case "pagebreaks":
            switch (Rn[3]) {
              case "colbreaks":
                break;
              case "colbreak":
                break;
              case "rowbreaks":
                break;
              case "rowbreak":
                break;
              case "colstart":
                break;
              case "colend":
                break;
              case "rowend":
                break;
              default:
                seen = false;
            }
            break;
          case "autofilter":
            switch (Rn[3]) {
              case "autofiltercolumn":
                break;
              case "autofiltercondition":
                break;
              case "autofilterand":
                break;
              case "autofilteror":
                break;
              default:
                seen = false;
            }
            break;
          case "querytable":
            switch (Rn[3]) {
              case "id":
                break;
              case "autoformatfont":
                break;
              case "autoformatpattern":
                break;
              case "querysource":
                break;
              case "querytype":
                break;
              case "enableredirections":
                break;
              case "refreshedinxl9":
                break;
              case "urlstring":
                break;
              case "htmltables":
                break;
              case "connection":
                break;
              case "commandtext":
                break;
              case "refreshinfo":
                break;
              case "notitles":
                break;
              case "nextid":
                break;
              case "columninfo":
                break;
              case "overwritecells":
                break;
              case "donotpromptforfile":
                break;
              case "textwizardsettings":
                break;
              case "source":
                break;
              case "number":
                break;
              case "decimal":
                break;
              case "thousandseparator":
                break;
              case "trailingminusnumbers":
                break;
              case "formatsettings":
                break;
              case "fieldtype":
                break;
              case "delimiters":
                break;
              case "tab":
                break;
              case "comma":
                break;
              case "autoformatname":
                break;
              case "versionlastedit":
                break;
              case "versionlastrefresh":
                break;
              default:
                seen = false;
            }
            break;
          case "datavalidation":
            switch (Rn[3]) {
              case "range":
                break;
              case "type":
                break;
              case "min":
                break;
              case "max":
                break;
              case "sort":
                break;
              case "descending":
                break;
              case "order":
                break;
              case "casesensitive":
                break;
              case "value":
                break;
              case "errorstyle":
                break;
              case "errormessage":
                break;
              case "errortitle":
                break;
              case "inputmessage":
                break;
              case "inputtitle":
                break;
              case "combohide":
                break;
              case "inputhide":
                break;
              case "condition":
                break;
              case "qualifier":
                break;
              case "useblank":
                break;
              case "value1":
                break;
              case "value2":
                break;
              case "format":
                break;
              case "cellrangelist":
                break;
              default:
                seen = false;
            }
            break;
          case "sorting":
          case "conditionalformatting":
            switch (Rn[3]) {
              case "range":
                break;
              case "type":
                break;
              case "min":
                break;
              case "max":
                break;
              case "sort":
                break;
              case "descending":
                break;
              case "order":
                break;
              case "casesensitive":
                break;
              case "value":
                break;
              case "errorstyle":
                break;
              case "errormessage":
                break;
              case "errortitle":
                break;
              case "cellrangelist":
                break;
              case "inputmessage":
                break;
              case "inputtitle":
                break;
              case "combohide":
                break;
              case "inputhide":
                break;
              case "condition":
                break;
              case "qualifier":
                break;
              case "useblank":
                break;
              case "value1":
                break;
              case "value2":
                break;
              case "format":
                break;
              default:
                seen = false;
            }
            break;
          case "mapinfo":
          case "schema":
          case "data":
            switch (Rn[3]) {
              case "map":
                break;
              case "entry":
                break;
              case "range":
                break;
              case "xpath":
                break;
              case "field":
                break;
              case "xsdtype":
                break;
              case "filteron":
                break;
              case "aggregate":
                break;
              case "elementtype":
                break;
              case "attributetype":
                break;
              case "schema":
              case "element":
              case "complextype":
              case "datatype":
              case "all":
              case "attribute":
              case "extends":
                break;
              case "row":
                break;
              default:
                seen = false;
            }
            break;
          case "smarttags":
            break;
          default:
            seen = false;
            break;
        }
        if (seen)
          break;
        if (Rn[3].match(/!\[CDATA/))
          break;
        if (!state[state.length - 1][1])
          throw "Unrecognized tag: " + Rn[3] + "|" + state.join("|");
        if (state[state.length - 1][0] === /*'CustomDocumentProperties'*/
        "customdocumentproperties") {
          if (Rn[0].slice(-2) === "/>")
            break;
          else if (Rn[1] === "/")
            xlml_set_custprop(Custprops, raw_Rn3, cp, str.slice(pidx, Rn.index));
          else {
            cp = Rn;
            pidx = Rn.index + Rn[0].length;
          }
          break;
        }
        if (opts.WTF)
          throw "Unrecognized tag: " + Rn[3] + "|" + state.join("|");
    }
  var out = {};
  if (!opts.bookSheets && !opts.bookProps)
    out.Sheets = sheets;
  out.SheetNames = sheetnames;
  out.Workbook = Workbook;
  out.SSF = dup(table_fmt);
  out.Props = Props;
  out.Custprops = Custprops;
  return out;
}
function parse_xlml(data, opts) {
  fix_read_opts(opts = opts || {});
  switch (opts.type || "base64") {
    case "base64":
      return parse_xlml_xml(Base64_decode(data), opts);
    case "binary":
    case "buffer":
    case "file":
      return parse_xlml_xml(data, opts);
    case "array":
      return parse_xlml_xml(a2s(data), opts);
  }
}
function write_props_xlml(wb, opts) {
  var o2 = [];
  if (wb.Props)
    o2.push(xlml_write_docprops(wb.Props, opts));
  if (wb.Custprops)
    o2.push(xlml_write_custprops(wb.Props, wb.Custprops, opts));
  return o2.join("");
}
function write_wb_xlml() {
  return "";
}
function write_sty_xlml(wb, opts) {
  var styles = ['<Style ss:ID="Default" ss:Name="Normal"><NumberFormat/></Style>'];
  opts.cellXfs.forEach(function(xf, id) {
    var payload = [];
    payload.push(writextag("NumberFormat", null, { "ss:Format": escapexml(table_fmt[xf.numFmtId]) }));
    var o2 = (
      /*::(*/
      { "ss:ID": "s" + (21 + id) }
    );
    styles.push(writextag("Style", payload.join(""), o2));
  });
  return writextag("Styles", styles.join(""));
}
function write_name_xlml(n2) {
  return writextag("NamedRange", null, { "ss:Name": n2.Name, "ss:RefersTo": "=" + a1_to_rc(n2.Ref, { r: 0, c: 0 }) });
}
function write_names_xlml(wb) {
  if (!((wb || {}).Workbook || {}).Names)
    return "";
  var names = wb.Workbook.Names;
  var out = [];
  for (var i2 = 0; i2 < names.length; ++i2) {
    var n2 = names[i2];
    if (n2.Sheet != null)
      continue;
    if (n2.Name.match(/^_xlfn\./))
      continue;
    out.push(write_name_xlml(n2));
  }
  return writextag("Names", out.join(""));
}
function write_ws_xlml_names(ws, opts, idx, wb) {
  if (!ws)
    return "";
  if (!((wb || {}).Workbook || {}).Names)
    return "";
  var names = wb.Workbook.Names;
  var out = [];
  for (var i2 = 0; i2 < names.length; ++i2) {
    var n2 = names[i2];
    if (n2.Sheet != idx)
      continue;
    if (n2.Name.match(/^_xlfn\./))
      continue;
    out.push(write_name_xlml(n2));
  }
  return out.join("");
}
function write_ws_xlml_wsopts(ws, opts, idx, wb) {
  if (!ws)
    return "";
  var o2 = [];
  if (ws["!margins"]) {
    o2.push("<PageSetup>");
    if (ws["!margins"].header)
      o2.push(writextag("Header", null, { "x:Margin": ws["!margins"].header }));
    if (ws["!margins"].footer)
      o2.push(writextag("Footer", null, { "x:Margin": ws["!margins"].footer }));
    o2.push(writextag("PageMargins", null, {
      "x:Bottom": ws["!margins"].bottom || "0.75",
      "x:Left": ws["!margins"].left || "0.7",
      "x:Right": ws["!margins"].right || "0.7",
      "x:Top": ws["!margins"].top || "0.75"
    }));
    o2.push("</PageSetup>");
  }
  if (wb && wb.Workbook && wb.Workbook.Sheets && wb.Workbook.Sheets[idx]) {
    if (wb.Workbook.Sheets[idx].Hidden)
      o2.push(writextag("Visible", wb.Workbook.Sheets[idx].Hidden == 1 ? "SheetHidden" : "SheetVeryHidden", {}));
    else {
      for (var i2 = 0; i2 < idx; ++i2)
        if (wb.Workbook.Sheets[i2] && !wb.Workbook.Sheets[i2].Hidden)
          break;
      if (i2 == idx)
        o2.push("<Selected/>");
    }
  }
  if (((((wb || {}).Workbook || {}).Views || [])[0] || {}).RTL)
    o2.push("<DisplayRightToLeft/>");
  if (ws["!protect"]) {
    o2.push(writetag("ProtectContents", "True"));
    if (ws["!protect"].objects)
      o2.push(writetag("ProtectObjects", "True"));
    if (ws["!protect"].scenarios)
      o2.push(writetag("ProtectScenarios", "True"));
    if (ws["!protect"].selectLockedCells != null && !ws["!protect"].selectLockedCells)
      o2.push(writetag("EnableSelection", "NoSelection"));
    else if (ws["!protect"].selectUnlockedCells != null && !ws["!protect"].selectUnlockedCells)
      o2.push(writetag("EnableSelection", "UnlockedCells"));
    [
      ["formatCells", "AllowFormatCells"],
      ["formatColumns", "AllowSizeCols"],
      ["formatRows", "AllowSizeRows"],
      ["insertColumns", "AllowInsertCols"],
      ["insertRows", "AllowInsertRows"],
      ["insertHyperlinks", "AllowInsertHyperlinks"],
      ["deleteColumns", "AllowDeleteCols"],
      ["deleteRows", "AllowDeleteRows"],
      ["sort", "AllowSort"],
      ["autoFilter", "AllowFilter"],
      ["pivotTables", "AllowUsePivotTables"]
    ].forEach(function(x2) {
      if (ws["!protect"][x2[0]])
        o2.push("<" + x2[1] + "/>");
    });
  }
  if (o2.length == 0)
    return "";
  return writextag("WorksheetOptions", o2.join(""), { xmlns: XLMLNS.x });
}
function write_ws_xlml_comment(comments) {
  return comments.map(function(c2) {
    var t2 = xlml_unfixstr(c2.t || "");
    var d2 = writextag("ss:Data", t2, { "xmlns": "http://www.w3.org/TR/REC-html40" });
    return writextag("Comment", d2, { "ss:Author": c2.a });
  }).join("");
}
function write_ws_xlml_cell(cell, ref, ws, opts, idx, wb, addr) {
  if (!cell || cell.v == void 0 && cell.f == void 0)
    return "";
  var attr = {};
  if (cell.f)
    attr["ss:Formula"] = "=" + escapexml(a1_to_rc(cell.f, addr));
  if (cell.F && cell.F.slice(0, ref.length) == ref) {
    var end = decode_cell(cell.F.slice(ref.length + 1));
    attr["ss:ArrayRange"] = "RC:R" + (end.r == addr.r ? "" : "[" + (end.r - addr.r) + "]") + "C" + (end.c == addr.c ? "" : "[" + (end.c - addr.c) + "]");
  }
  if (cell.l && cell.l.Target) {
    attr["ss:HRef"] = escapexml(cell.l.Target);
    if (cell.l.Tooltip)
      attr["x:HRefScreenTip"] = escapexml(cell.l.Tooltip);
  }
  if (ws["!merges"]) {
    var marr = ws["!merges"];
    for (var mi = 0; mi != marr.length; ++mi) {
      if (marr[mi].s.c != addr.c || marr[mi].s.r != addr.r)
        continue;
      if (marr[mi].e.c > marr[mi].s.c)
        attr["ss:MergeAcross"] = marr[mi].e.c - marr[mi].s.c;
      if (marr[mi].e.r > marr[mi].s.r)
        attr["ss:MergeDown"] = marr[mi].e.r - marr[mi].s.r;
    }
  }
  var t2 = "", p2 = "";
  switch (cell.t) {
    case "z":
      if (!opts.sheetStubs)
        return "";
      break;
    case "n":
      t2 = "Number";
      p2 = String(cell.v);
      break;
    case "b":
      t2 = "Boolean";
      p2 = cell.v ? "1" : "0";
      break;
    case "e":
      t2 = "Error";
      p2 = BErr[cell.v];
      break;
    case "d":
      t2 = "DateTime";
      p2 = new Date(cell.v).toISOString();
      if (cell.z == null)
        cell.z = cell.z || table_fmt[14];
      break;
    case "s":
      t2 = "String";
      p2 = escapexlml(cell.v || "");
      break;
  }
  var os = get_cell_style(opts.cellXfs, cell, opts);
  attr["ss:StyleID"] = "s" + (21 + os);
  attr["ss:Index"] = addr.c + 1;
  var _v = cell.v != null ? p2 : "";
  var m2 = cell.t == "z" ? "" : '<Data ss:Type="' + t2 + '">' + _v + "</Data>";
  if ((cell.c || []).length > 0)
    m2 += write_ws_xlml_comment(cell.c);
  return writextag("Cell", m2, attr);
}
function write_ws_xlml_row(R2, row) {
  var o2 = '<Row ss:Index="' + (R2 + 1) + '"';
  if (row) {
    if (row.hpt && !row.hpx)
      row.hpx = pt2px(row.hpt);
    if (row.hpx)
      o2 += ' ss:AutoFitHeight="0" ss:Height="' + row.hpx + '"';
    if (row.hidden)
      o2 += ' ss:Hidden="1"';
  }
  return o2 + ">";
}
function write_ws_xlml_table(ws, opts, idx, wb) {
  if (!ws["!ref"])
    return "";
  var range = safe_decode_range(ws["!ref"]);
  var marr = ws["!merges"] || [], mi = 0;
  var o2 = [];
  if (ws["!cols"])
    ws["!cols"].forEach(function(n2, i2) {
      process_col(n2);
      var w2 = !!n2.width;
      var p2 = col_obj_w(i2, n2);
      var k2 = { "ss:Index": i2 + 1 };
      if (w2)
        k2["ss:Width"] = width2px(p2.width);
      if (n2.hidden)
        k2["ss:Hidden"] = "1";
      o2.push(writextag("Column", null, k2));
    });
  var dense = Array.isArray(ws);
  for (var R2 = range.s.r; R2 <= range.e.r; ++R2) {
    var row = [write_ws_xlml_row(R2, (ws["!rows"] || [])[R2])];
    for (var C2 = range.s.c; C2 <= range.e.c; ++C2) {
      var skip = false;
      for (mi = 0; mi != marr.length; ++mi) {
        if (marr[mi].s.c > C2)
          continue;
        if (marr[mi].s.r > R2)
          continue;
        if (marr[mi].e.c < C2)
          continue;
        if (marr[mi].e.r < R2)
          continue;
        if (marr[mi].s.c != C2 || marr[mi].s.r != R2)
          skip = true;
        break;
      }
      if (skip)
        continue;
      var addr = { r: R2, c: C2 };
      var ref = encode_cell(addr), cell = dense ? (ws[R2] || [])[C2] : ws[ref];
      row.push(write_ws_xlml_cell(cell, ref, ws, opts, idx, wb, addr));
    }
    row.push("</Row>");
    if (row.length > 2)
      o2.push(row.join(""));
  }
  return o2.join("");
}
function write_ws_xlml(idx, opts, wb) {
  var o2 = [];
  var s2 = wb.SheetNames[idx];
  var ws = wb.Sheets[s2];
  var t2 = ws ? write_ws_xlml_names(ws, opts, idx, wb) : "";
  if (t2.length > 0)
    o2.push("<Names>" + t2 + "</Names>");
  t2 = ws ? write_ws_xlml_table(ws, opts, idx, wb) : "";
  if (t2.length > 0)
    o2.push("<Table>" + t2 + "</Table>");
  o2.push(write_ws_xlml_wsopts(ws, opts, idx, wb));
  return o2.join("");
}
function write_xlml(wb, opts) {
  if (!opts)
    opts = {};
  if (!wb.SSF)
    wb.SSF = dup(table_fmt);
  if (wb.SSF) {
    make_ssf();
    SSF_load_table(wb.SSF);
    opts.revssf = evert_num(wb.SSF);
    opts.revssf[wb.SSF[65535]] = 0;
    opts.ssf = wb.SSF;
    opts.cellXfs = [];
    get_cell_style(opts.cellXfs, {}, { revssf: { "General": 0 } });
  }
  var d2 = [];
  d2.push(write_props_xlml(wb, opts));
  d2.push(write_wb_xlml(wb, opts));
  d2.push("");
  d2.push("");
  for (var i2 = 0; i2 < wb.SheetNames.length; ++i2)
    d2.push(writextag("Worksheet", write_ws_xlml(i2, opts, wb), { "ss:Name": escapexml(wb.SheetNames[i2]) }));
  d2[2] = write_sty_xlml(wb, opts);
  d2[3] = write_names_xlml(wb, opts);
  return XML_HEADER + writextag("Workbook", d2.join(""), {
    "xmlns": XLMLNS.ss,
    "xmlns:o": XLMLNS.o,
    "xmlns:x": XLMLNS.x,
    "xmlns:ss": XLMLNS.ss,
    "xmlns:dt": XLMLNS.dt,
    "xmlns:html": XLMLNS.html
  });
}
function parse_compobj(obj) {
  var v2 = {};
  var o2 = obj.content;
  o2.l = 28;
  v2.AnsiUserType = o2.read_shift(0, "lpstr-ansi");
  v2.AnsiClipboardFormat = parse_ClipboardFormatOrAnsiString(o2);
  if (o2.length - o2.l <= 4)
    return v2;
  var m2 = o2.read_shift(4);
  if (m2 == 0 || m2 > 40)
    return v2;
  o2.l -= 4;
  v2.Reserved1 = o2.read_shift(0, "lpstr-ansi");
  if (o2.length - o2.l <= 4)
    return v2;
  m2 = o2.read_shift(4);
  if (m2 !== 1907505652)
    return v2;
  v2.UnicodeClipboardFormat = parse_ClipboardFormatOrUnicodeString(o2);
  m2 = o2.read_shift(4);
  if (m2 == 0 || m2 > 40)
    return v2;
  o2.l -= 4;
  v2.Reserved2 = o2.read_shift(0, "lpwstr");
}
var CONTINUE_RT = [60, 1084, 2066, 2165, 2175];
function slurp(RecordType, R2, blob, length, opts) {
  var l2 = length;
  var bufs = [];
  var d2 = blob.slice(blob.l, blob.l + l2);
  if (opts && opts.enc && opts.enc.insitu && d2.length > 0)
    switch (RecordType) {
      case 9:
      case 521:
      case 1033:
      case 2057:
      case 47:
      case 405:
      case 225:
      case 406:
      case 312:
      case 404:
      case 10:
        break;
      case 133:
        break;
      default:
        opts.enc.insitu(d2);
    }
  bufs.push(d2);
  blob.l += l2;
  var nextrt = __readUInt16LE(blob, blob.l), next = XLSRecordEnum[nextrt];
  var start = 0;
  while (next != null && CONTINUE_RT.indexOf(nextrt) > -1) {
    l2 = __readUInt16LE(blob, blob.l + 2);
    start = blob.l + 4;
    if (nextrt == 2066)
      start += 4;
    else if (nextrt == 2165 || nextrt == 2175) {
      start += 12;
    }
    d2 = blob.slice(start, blob.l + 4 + l2);
    bufs.push(d2);
    blob.l += 4 + l2;
    next = XLSRecordEnum[nextrt = __readUInt16LE(blob, blob.l)];
  }
  var b2 = bconcat(bufs);
  prep_blob(b2, 0);
  var ll = 0;
  b2.lens = [];
  for (var j2 = 0; j2 < bufs.length; ++j2) {
    b2.lens.push(ll);
    ll += bufs[j2].length;
  }
  if (b2.length < length)
    throw "XLS Record 0x" + RecordType.toString(16) + " Truncated: " + b2.length + " < " + length;
  return R2.f(b2, b2.length, opts);
}
function safe_format_xf(p2, opts, date1904) {
  if (p2.t === "z")
    return;
  if (!p2.XF)
    return;
  var fmtid = 0;
  try {
    fmtid = p2.z || p2.XF.numFmtId || 0;
    if (opts.cellNF)
      p2.z = table_fmt[fmtid];
  } catch (e) {
    if (opts.WTF)
      throw e;
  }
  if (!opts || opts.cellText !== false)
    try {
      if (p2.t === "e") {
        p2.w = p2.w || BErr[p2.v];
      } else if (fmtid === 0 || fmtid == "General") {
        if (p2.t === "n") {
          if ((p2.v | 0) === p2.v)
            p2.w = p2.v.toString(10);
          else
            p2.w = SSF_general_num(p2.v);
        } else
          p2.w = SSF_general(p2.v);
      } else
        p2.w = SSF_format(fmtid, p2.v, { date1904: !!date1904, dateNF: opts && opts.dateNF });
    } catch (e) {
      if (opts.WTF)
        throw e;
    }
  if (opts.cellDates && fmtid && p2.t == "n" && fmt_is_date(table_fmt[fmtid] || String(fmtid))) {
    var _d = SSF_parse_date_code(p2.v);
    if (_d) {
      p2.t = "d";
      p2.v = new Date(_d.y, _d.m - 1, _d.d, _d.H, _d.M, _d.S, _d.u);
    }
  }
}
function make_cell(val, ixfe, t2) {
  return { v: val, ixfe, t: t2 };
}
function parse_workbook(blob, options) {
  var wb = { opts: {} };
  var Sheets = {};
  if (DENSE != null && options.dense == null)
    options.dense = DENSE;
  var out = options.dense ? [] : {};
  var Directory = {};
  var range = {};
  var last_formula = null;
  var sst = [];
  var cur_sheet = "";
  var Preamble = {};
  var lastcell, last_cell = "", cc, cmnt, rngC, rngR;
  var sharedf = {};
  var arrayf = [];
  var temp_val;
  var country;
  var XFs = [];
  var palette = [];
  var Workbook = { Sheets: [], WBProps: { date1904: false }, Views: [{}] }, wsprops = {};
  var get_rgb = function getrgb(icv) {
    if (icv < 8)
      return XLSIcv[icv];
    if (icv < 64)
      return palette[icv - 8] || XLSIcv[icv];
    return XLSIcv[icv];
  };
  var process_cell_style = function pcs(cell, line, options2) {
    var xfd = line.XF.data;
    if (!xfd || !xfd.patternType || !options2 || !options2.cellStyles)
      return;
    line.s = {};
    line.s.patternType = xfd.patternType;
    var t2;
    if (t2 = rgb2Hex(get_rgb(xfd.icvFore))) {
      line.s.fgColor = { rgb: t2 };
    }
    if (t2 = rgb2Hex(get_rgb(xfd.icvBack))) {
      line.s.bgColor = { rgb: t2 };
    }
  };
  var addcell = function addcell2(cell, line, options2) {
    if (file_depth > 1)
      return;
    if (options2.sheetRows && cell.r >= options2.sheetRows)
      return;
    if (options2.cellStyles && line.XF && line.XF.data)
      process_cell_style(cell, line, options2);
    delete line.ixfe;
    delete line.XF;
    lastcell = cell;
    last_cell = encode_cell(cell);
    if (!range || !range.s || !range.e)
      range = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
    if (cell.r < range.s.r)
      range.s.r = cell.r;
    if (cell.c < range.s.c)
      range.s.c = cell.c;
    if (cell.r + 1 > range.e.r)
      range.e.r = cell.r + 1;
    if (cell.c + 1 > range.e.c)
      range.e.c = cell.c + 1;
    if (options2.cellFormula && line.f) {
      for (var afi = 0; afi < arrayf.length; ++afi) {
        if (arrayf[afi][0].s.c > cell.c || arrayf[afi][0].s.r > cell.r)
          continue;
        if (arrayf[afi][0].e.c < cell.c || arrayf[afi][0].e.r < cell.r)
          continue;
        line.F = encode_range(arrayf[afi][0]);
        if (arrayf[afi][0].s.c != cell.c || arrayf[afi][0].s.r != cell.r)
          delete line.f;
        if (line.f)
          line.f = "" + stringify_formula(arrayf[afi][1], range, cell, supbooks, opts);
        break;
      }
    }
    {
      if (options2.dense) {
        if (!out[cell.r])
          out[cell.r] = [];
        out[cell.r][cell.c] = line;
      } else
        out[last_cell] = line;
    }
  };
  var opts = {
    enc: false,
    // encrypted
    sbcch: 0,
    // cch in the preceding SupBook
    snames: [],
    // sheetnames
    sharedf,
    // shared formulae by address
    arrayf,
    // array formulae array
    rrtabid: [],
    // RRTabId
    lastuser: "",
    // Last User from WriteAccess
    biff: 8,
    // BIFF version
    codepage: 0,
    // CP from CodePage record
    winlocked: 0,
    // fLockWn from WinProtect
    cellStyles: !!options && !!options.cellStyles,
    WTF: !!options && !!options.wtf
  };
  if (options.password)
    opts.password = options.password;
  var themes;
  var merges = [];
  var objects = [];
  var colinfo = [], rowinfo = [];
  var seencol = false;
  var supbooks = [];
  supbooks.SheetNames = opts.snames;
  supbooks.sharedf = opts.sharedf;
  supbooks.arrayf = opts.arrayf;
  supbooks.names = [];
  supbooks.XTI = [];
  var last_RT = 0;
  var file_depth = 0;
  var BIFF2Fmt = 0, BIFF2FmtTable = [];
  var FilterDatabases = [];
  var last_lbl;
  opts.codepage = 1200;
  set_cp(1200);
  var seen_codepage = false;
  while (blob.l < blob.length - 1) {
    var s2 = blob.l;
    var RecordType = blob.read_shift(2);
    if (RecordType === 0 && last_RT === 10)
      break;
    var length = blob.l === blob.length ? 0 : blob.read_shift(2);
    var R2 = XLSRecordEnum[RecordType];
    if (R2 && R2.f) {
      if (options.bookSheets) {
        if (last_RT === 133 && RecordType !== 133)
          break;
      }
      last_RT = RecordType;
      if (R2.r === 2 || R2.r == 12) {
        var rt2 = blob.read_shift(2);
        length -= 2;
        if (!opts.enc && rt2 !== RecordType && ((rt2 & 255) << 8 | rt2 >> 8) !== RecordType)
          throw new Error("rt mismatch: " + rt2 + "!=" + RecordType);
        if (R2.r == 12) {
          blob.l += 10;
          length -= 10;
        }
      }
      var val = {};
      if (RecordType === 10)
        val = /*::(*/
        R2.f(blob, length, opts);
      else
        val = /*::(*/
        slurp(RecordType, R2, blob, length, opts);
      if (file_depth == 0 && [9, 521, 1033, 2057].indexOf(last_RT) === -1)
        continue;
      switch (RecordType) {
        case 34:
          wb.opts.Date1904 = Workbook.WBProps.date1904 = val;
          break;
        case 134:
          wb.opts.WriteProtect = true;
          break;
        case 47:
          if (!opts.enc)
            blob.l = 0;
          opts.enc = val;
          if (!options.password)
            throw new Error("File is password-protected");
          if (val.valid == null)
            throw new Error("Encryption scheme unsupported");
          if (!val.valid)
            throw new Error("Password is incorrect");
          break;
        case 92:
          opts.lastuser = val;
          break;
        case 66:
          var cpval = Number(val);
          switch (cpval) {
            case 21010:
              cpval = 1200;
              break;
            case 32768:
              cpval = 1e4;
              break;
            case 32769:
              cpval = 1252;
              break;
          }
          set_cp(opts.codepage = cpval);
          seen_codepage = true;
          break;
        case 317:
          opts.rrtabid = val;
          break;
        case 25:
          opts.winlocked = val;
          break;
        case 439:
          wb.opts["RefreshAll"] = val;
          break;
        case 12:
          wb.opts["CalcCount"] = val;
          break;
        case 16:
          wb.opts["CalcDelta"] = val;
          break;
        case 17:
          wb.opts["CalcIter"] = val;
          break;
        case 13:
          wb.opts["CalcMode"] = val;
          break;
        case 14:
          wb.opts["CalcPrecision"] = val;
          break;
        case 95:
          wb.opts["CalcSaveRecalc"] = val;
          break;
        case 15:
          opts.CalcRefMode = val;
          break;
        case 2211:
          wb.opts.FullCalc = val;
          break;
        case 129:
          if (val.fDialog)
            out["!type"] = "dialog";
          if (!val.fBelow)
            (out["!outline"] || (out["!outline"] = {})).above = true;
          if (!val.fRight)
            (out["!outline"] || (out["!outline"] = {})).left = true;
          break;
        case 224:
          XFs.push(val);
          break;
        case 430:
          supbooks.push([val]);
          supbooks[supbooks.length - 1].XTI = [];
          break;
        case 35:
        case 547:
          supbooks[supbooks.length - 1].push(val);
          break;
        case 24:
        case 536:
          last_lbl = {
            Name: val.Name,
            Ref: stringify_formula(val.rgce, range, null, supbooks, opts)
          };
          if (val.itab > 0)
            last_lbl.Sheet = val.itab - 1;
          supbooks.names.push(last_lbl);
          if (!supbooks[0]) {
            supbooks[0] = [];
            supbooks[0].XTI = [];
          }
          supbooks[supbooks.length - 1].push(val);
          if (val.Name == "_xlnm._FilterDatabase" && val.itab > 0) {
            if (val.rgce && val.rgce[0] && val.rgce[0][0] && val.rgce[0][0][0] == "PtgArea3d")
              FilterDatabases[val.itab - 1] = { ref: encode_range(val.rgce[0][0][1][2]) };
          }
          break;
        case 22:
          opts.ExternCount = val;
          break;
        case 23:
          if (supbooks.length == 0) {
            supbooks[0] = [];
            supbooks[0].XTI = [];
          }
          supbooks[supbooks.length - 1].XTI = supbooks[supbooks.length - 1].XTI.concat(val);
          supbooks.XTI = supbooks.XTI.concat(val);
          break;
        case 2196:
          if (opts.biff < 8)
            break;
          if (last_lbl != null)
            last_lbl.Comment = val[1];
          break;
        case 18:
          out["!protect"] = val;
          break;
        case 19:
          if (val !== 0 && opts.WTF)
            console.error("Password verifier: " + val);
          break;
        case 133:
          {
            Directory[val.pos] = val;
            opts.snames.push(val.name);
          }
          break;
        case 10:
          {
            if (--file_depth)
              break;
            if (range.e) {
              if (range.e.r > 0 && range.e.c > 0) {
                range.e.r--;
                range.e.c--;
                out["!ref"] = encode_range(range);
                if (options.sheetRows && options.sheetRows <= range.e.r) {
                  var tmpri = range.e.r;
                  range.e.r = options.sheetRows - 1;
                  out["!fullref"] = out["!ref"];
                  out["!ref"] = encode_range(range);
                  range.e.r = tmpri;
                }
                range.e.r++;
                range.e.c++;
              }
              if (merges.length > 0)
                out["!merges"] = merges;
              if (objects.length > 0)
                out["!objects"] = objects;
              if (colinfo.length > 0)
                out["!cols"] = colinfo;
              if (rowinfo.length > 0)
                out["!rows"] = rowinfo;
              Workbook.Sheets.push(wsprops);
            }
            if (cur_sheet === "")
              Preamble = out;
            else
              Sheets[cur_sheet] = out;
            out = options.dense ? [] : {};
          }
          break;
        case 9:
        case 521:
        case 1033:
        case 2057:
          {
            if (opts.biff === 8)
              opts.biff = {
                /*::[*/
                9: 2,
                /*::[*/
                521: 3,
                /*::[*/
                1033: 4
              }[RecordType] || {
                /*::[*/
                512: 2,
                /*::[*/
                768: 3,
                /*::[*/
                1024: 4,
                /*::[*/
                1280: 5,
                /*::[*/
                1536: 8,
                /*::[*/
                2: 2,
                /*::[*/
                7: 2
              }[val.BIFFVer] || 8;
            opts.biffguess = val.BIFFVer == 0;
            if (val.BIFFVer == 0 && val.dt == 4096) {
              opts.biff = 5;
              seen_codepage = true;
              set_cp(opts.codepage = 28591);
            }
            if (opts.biff == 8 && val.BIFFVer == 0 && val.dt == 16)
              opts.biff = 2;
            if (file_depth++)
              break;
            out = options.dense ? [] : {};
            if (opts.biff < 8 && !seen_codepage) {
              seen_codepage = true;
              set_cp(opts.codepage = options.codepage || 1252);
            }
            if (opts.biff < 5 || val.BIFFVer == 0 && val.dt == 4096) {
              if (cur_sheet === "")
                cur_sheet = "Sheet1";
              range = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
              var fakebs8 = { pos: blob.l - length, name: cur_sheet };
              Directory[fakebs8.pos] = fakebs8;
              opts.snames.push(cur_sheet);
            } else
              cur_sheet = (Directory[s2] || { name: "" }).name;
            if (val.dt == 32)
              out["!type"] = "chart";
            if (val.dt == 64)
              out["!type"] = "macro";
            merges = [];
            objects = [];
            opts.arrayf = arrayf = [];
            colinfo = [];
            rowinfo = [];
            seencol = false;
            wsprops = { Hidden: (Directory[s2] || { hs: 0 }).hs, name: cur_sheet };
          }
          break;
        case 515:
        case 3:
        case 2:
          {
            if (out["!type"] == "chart") {
              if (options.dense ? (out[val.r] || [])[val.c] : out[encode_cell({ c: val.c, r: val.r })])
                ++val.c;
            }
            temp_val = { ixfe: val.ixfe, XF: XFs[val.ixfe] || {}, v: val.val, t: "n" };
            if (BIFF2Fmt > 0)
              temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
            safe_format_xf(temp_val, options, wb.opts.Date1904);
            addcell({ c: val.c, r: val.r }, temp_val, options);
          }
          break;
        case 5:
        case 517:
          {
            temp_val = { ixfe: val.ixfe, XF: XFs[val.ixfe], v: val.val, t: val.t };
            if (BIFF2Fmt > 0)
              temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
            safe_format_xf(temp_val, options, wb.opts.Date1904);
            addcell({ c: val.c, r: val.r }, temp_val, options);
          }
          break;
        case 638:
          {
            temp_val = { ixfe: val.ixfe, XF: XFs[val.ixfe], v: val.rknum, t: "n" };
            if (BIFF2Fmt > 0)
              temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
            safe_format_xf(temp_val, options, wb.opts.Date1904);
            addcell({ c: val.c, r: val.r }, temp_val, options);
          }
          break;
        case 189:
          {
            for (var j2 = val.c; j2 <= val.C; ++j2) {
              var ixfe = val.rkrec[j2 - val.c][0];
              temp_val = { ixfe, XF: XFs[ixfe], v: val.rkrec[j2 - val.c][1], t: "n" };
              if (BIFF2Fmt > 0)
                temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
              safe_format_xf(temp_val, options, wb.opts.Date1904);
              addcell({ c: j2, r: val.r }, temp_val, options);
            }
          }
          break;
        case 6:
        case 518:
        case 1030:
          {
            if (val.val == "String") {
              last_formula = val;
              break;
            }
            temp_val = make_cell(val.val, val.cell.ixfe, val.tt);
            temp_val.XF = XFs[temp_val.ixfe];
            if (options.cellFormula) {
              var _f = val.formula;
              if (_f && _f[0] && _f[0][0] && _f[0][0][0] == "PtgExp") {
                var _fr = _f[0][0][1][0], _fc = _f[0][0][1][1];
                var _fe = encode_cell({ r: _fr, c: _fc });
                if (sharedf[_fe])
                  temp_val.f = "" + stringify_formula(val.formula, range, val.cell, supbooks, opts);
                else
                  temp_val.F = ((options.dense ? (out[_fr] || [])[_fc] : out[_fe]) || {}).F;
              } else
                temp_val.f = "" + stringify_formula(val.formula, range, val.cell, supbooks, opts);
            }
            if (BIFF2Fmt > 0)
              temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
            safe_format_xf(temp_val, options, wb.opts.Date1904);
            addcell(val.cell, temp_val, options);
            last_formula = val;
          }
          break;
        case 7:
        case 519:
          {
            if (last_formula) {
              last_formula.val = val;
              temp_val = make_cell(val, last_formula.cell.ixfe, "s");
              temp_val.XF = XFs[temp_val.ixfe];
              if (options.cellFormula) {
                temp_val.f = "" + stringify_formula(last_formula.formula, range, last_formula.cell, supbooks, opts);
              }
              if (BIFF2Fmt > 0)
                temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
              safe_format_xf(temp_val, options, wb.opts.Date1904);
              addcell(last_formula.cell, temp_val, options);
              last_formula = null;
            } else
              throw new Error("String record expects Formula");
          }
          break;
        case 33:
        case 545:
          {
            arrayf.push(val);
            var _arraystart = encode_cell(val[0].s);
            cc = options.dense ? (out[val[0].s.r] || [])[val[0].s.c] : out[_arraystart];
            if (options.cellFormula && cc) {
              if (!last_formula)
                break;
              if (!_arraystart || !cc)
                break;
              cc.f = "" + stringify_formula(val[1], range, val[0], supbooks, opts);
              cc.F = encode_range(val[0]);
            }
          }
          break;
        case 1212:
          {
            if (!options.cellFormula)
              break;
            if (last_cell) {
              if (!last_formula)
                break;
              sharedf[encode_cell(last_formula.cell)] = val[0];
              cc = options.dense ? (out[last_formula.cell.r] || [])[last_formula.cell.c] : out[encode_cell(last_formula.cell)];
              (cc || {}).f = "" + stringify_formula(val[0], range, lastcell, supbooks, opts);
            }
          }
          break;
        case 253:
          temp_val = make_cell(sst[val.isst].t, val.ixfe, "s");
          if (sst[val.isst].h)
            temp_val.h = sst[val.isst].h;
          temp_val.XF = XFs[temp_val.ixfe];
          if (BIFF2Fmt > 0)
            temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
          safe_format_xf(temp_val, options, wb.opts.Date1904);
          addcell({ c: val.c, r: val.r }, temp_val, options);
          break;
        case 513:
          if (options.sheetStubs) {
            temp_val = { ixfe: val.ixfe, XF: XFs[val.ixfe], t: "z" };
            if (BIFF2Fmt > 0)
              temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
            safe_format_xf(temp_val, options, wb.opts.Date1904);
            addcell({ c: val.c, r: val.r }, temp_val, options);
          }
          break;
        case 190:
          if (options.sheetStubs) {
            for (var _j = val.c; _j <= val.C; ++_j) {
              var _ixfe = val.ixfe[_j - val.c];
              temp_val = { ixfe: _ixfe, XF: XFs[_ixfe], t: "z" };
              if (BIFF2Fmt > 0)
                temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
              safe_format_xf(temp_val, options, wb.opts.Date1904);
              addcell({ c: _j, r: val.r }, temp_val, options);
            }
          }
          break;
        case 214:
        case 516:
        case 4:
          temp_val = make_cell(val.val, val.ixfe, "s");
          temp_val.XF = XFs[temp_val.ixfe];
          if (BIFF2Fmt > 0)
            temp_val.z = BIFF2FmtTable[temp_val.ixfe >> 8 & 63];
          safe_format_xf(temp_val, options, wb.opts.Date1904);
          addcell({ c: val.c, r: val.r }, temp_val, options);
          break;
        case 0:
        case 512:
          {
            if (file_depth === 1)
              range = val;
          }
          break;
        case 252:
          {
            sst = val;
          }
          break;
        case 1054:
          {
            if (opts.biff == 4) {
              BIFF2FmtTable[BIFF2Fmt++] = val[1];
              for (var b4idx = 0; b4idx < BIFF2Fmt + 163; ++b4idx)
                if (table_fmt[b4idx] == val[1])
                  break;
              if (b4idx >= 163)
                SSF_load(val[1], BIFF2Fmt + 163);
            } else
              SSF_load(val[1], val[0]);
          }
          break;
        case 30:
          {
            BIFF2FmtTable[BIFF2Fmt++] = val;
            for (var b2idx = 0; b2idx < BIFF2Fmt + 163; ++b2idx)
              if (table_fmt[b2idx] == val)
                break;
            if (b2idx >= 163)
              SSF_load(val, BIFF2Fmt + 163);
          }
          break;
        case 229:
          merges = merges.concat(val);
          break;
        case 93:
          objects[val.cmo[0]] = opts.lastobj = val;
          break;
        case 438:
          opts.lastobj.TxO = val;
          break;
        case 127:
          opts.lastobj.ImData = val;
          break;
        case 440:
          {
            for (rngR = val[0].s.r; rngR <= val[0].e.r; ++rngR)
              for (rngC = val[0].s.c; rngC <= val[0].e.c; ++rngC) {
                cc = options.dense ? (out[rngR] || [])[rngC] : out[encode_cell({ c: rngC, r: rngR })];
                if (cc)
                  cc.l = val[1];
              }
          }
          break;
        case 2048:
          {
            for (rngR = val[0].s.r; rngR <= val[0].e.r; ++rngR)
              for (rngC = val[0].s.c; rngC <= val[0].e.c; ++rngC) {
                cc = options.dense ? (out[rngR] || [])[rngC] : out[encode_cell({ c: rngC, r: rngR })];
                if (cc && cc.l)
                  cc.l.Tooltip = val[1];
              }
          }
          break;
        case 28:
          {
            if (opts.biff <= 5 && opts.biff >= 2)
              break;
            cc = options.dense ? (out[val[0].r] || [])[val[0].c] : out[encode_cell(val[0])];
            var noteobj = objects[val[2]];
            if (!cc) {
              if (options.dense) {
                if (!out[val[0].r])
                  out[val[0].r] = [];
                cc = out[val[0].r][val[0].c] = { t: "z" };
              } else {
                cc = out[encode_cell(val[0])] = { t: "z" };
              }
              range.e.r = Math.max(range.e.r, val[0].r);
              range.s.r = Math.min(range.s.r, val[0].r);
              range.e.c = Math.max(range.e.c, val[0].c);
              range.s.c = Math.min(range.s.c, val[0].c);
            }
            if (!cc.c)
              cc.c = [];
            cmnt = { a: val[1], t: noteobj.TxO.t };
            cc.c.push(cmnt);
          }
          break;
        case 2173:
          update_xfext(XFs[val.ixfe], val.ext);
          break;
        case 125:
          {
            if (!opts.cellStyles)
              break;
            while (val.e >= val.s) {
              colinfo[val.e--] = { width: val.w / 256, level: val.level || 0, hidden: !!(val.flags & 1) };
              if (!seencol) {
                seencol = true;
                find_mdw_colw(val.w / 256);
              }
              process_col(colinfo[val.e + 1]);
            }
          }
          break;
        case 520:
          {
            var rowobj = {};
            if (val.level != null) {
              rowinfo[val.r] = rowobj;
              rowobj.level = val.level;
            }
            if (val.hidden) {
              rowinfo[val.r] = rowobj;
              rowobj.hidden = true;
            }
            if (val.hpt) {
              rowinfo[val.r] = rowobj;
              rowobj.hpt = val.hpt;
              rowobj.hpx = pt2px(val.hpt);
            }
          }
          break;
        case 38:
        case 39:
        case 40:
        case 41:
          if (!out["!margins"])
            default_margins(out["!margins"] = {});
          out["!margins"][{ 38: "left", 39: "right", 40: "top", 41: "bottom" }[RecordType]] = val;
          break;
        case 161:
          if (!out["!margins"])
            default_margins(out["!margins"] = {});
          out["!margins"].header = val.header;
          out["!margins"].footer = val.footer;
          break;
        case 574:
          if (val.RTL)
            Workbook.Views[0].RTL = true;
          break;
        case 146:
          palette = val;
          break;
        case 2198:
          themes = val;
          break;
        case 140:
          country = val;
          break;
        case 442:
          {
            if (!cur_sheet)
              Workbook.WBProps.CodeName = val || "ThisWorkbook";
            else
              wsprops.CodeName = val || wsprops.name;
          }
          break;
      }
    } else {
      if (!R2)
        console.error("Missing Info for XLS Record 0x" + RecordType.toString(16));
      blob.l += length;
    }
  }
  wb.SheetNames = keys(Directory).sort(function(a2, b2) {
    return Number(a2) - Number(b2);
  }).map(function(x2) {
    return Directory[x2].name;
  });
  if (!options.bookSheets)
    wb.Sheets = Sheets;
  if (!wb.SheetNames.length && Preamble["!ref"]) {
    wb.SheetNames.push("Sheet1");
    if (wb.Sheets)
      wb.Sheets["Sheet1"] = Preamble;
  } else
    wb.Preamble = Preamble;
  if (wb.Sheets)
    FilterDatabases.forEach(function(r, i2) {
      wb.Sheets[wb.SheetNames[i2]]["!autofilter"] = r;
    });
  wb.Strings = sst;
  wb.SSF = dup(table_fmt);
  if (opts.enc)
    wb.Encryption = opts.enc;
  if (themes)
    wb.Themes = themes;
  wb.Metadata = {};
  if (country !== void 0)
    wb.Metadata.Country = country;
  if (supbooks.names.length > 0)
    Workbook.Names = supbooks.names;
  wb.Workbook = Workbook;
  return wb;
}
var PSCLSID = {
  SI: "e0859ff2f94f6810ab9108002b27b3d9",
  DSI: "02d5cdd59c2e1b10939708002b2cf9ae",
  UDI: "05d5cdd59c2e1b10939708002b2cf9ae"
};
function parse_xls_props(cfb, props, o2) {
  var DSI = CFB.find(cfb, "/!DocumentSummaryInformation");
  if (DSI && DSI.size > 0)
    try {
      var DocSummary = parse_PropertySetStream(DSI, DocSummaryPIDDSI, PSCLSID.DSI);
      for (var d2 in DocSummary)
        props[d2] = DocSummary[d2];
    } catch (e) {
      if (o2.WTF)
        throw e;
    }
  var SI = CFB.find(cfb, "/!SummaryInformation");
  if (SI && SI.size > 0)
    try {
      var Summary = parse_PropertySetStream(SI, SummaryPIDSI, PSCLSID.SI);
      for (var s2 in Summary)
        if (props[s2] == null)
          props[s2] = Summary[s2];
    } catch (e) {
      if (o2.WTF)
        throw e;
    }
  if (props.HeadingPairs && props.TitlesOfParts) {
    load_props_pairs(props.HeadingPairs, props.TitlesOfParts, props, o2);
    delete props.HeadingPairs;
    delete props.TitlesOfParts;
  }
}
function write_xls_props(wb, cfb) {
  var DSEntries = [], SEntries = [], CEntries = [];
  var i2 = 0, Keys;
  var DocSummaryRE = evert_key(DocSummaryPIDDSI, "n");
  var SummaryRE = evert_key(SummaryPIDSI, "n");
  if (wb.Props) {
    Keys = keys(wb.Props);
    for (i2 = 0; i2 < Keys.length; ++i2)
      (Object.prototype.hasOwnProperty.call(DocSummaryRE, Keys[i2]) ? DSEntries : Object.prototype.hasOwnProperty.call(SummaryRE, Keys[i2]) ? SEntries : CEntries).push([Keys[i2], wb.Props[Keys[i2]]]);
  }
  if (wb.Custprops) {
    Keys = keys(wb.Custprops);
    for (i2 = 0; i2 < Keys.length; ++i2)
      if (!Object.prototype.hasOwnProperty.call(wb.Props || {}, Keys[i2]))
        (Object.prototype.hasOwnProperty.call(DocSummaryRE, Keys[i2]) ? DSEntries : Object.prototype.hasOwnProperty.call(SummaryRE, Keys[i2]) ? SEntries : CEntries).push([Keys[i2], wb.Custprops[Keys[i2]]]);
  }
  var CEntries2 = [];
  for (i2 = 0; i2 < CEntries.length; ++i2) {
    if (XLSPSSkip.indexOf(CEntries[i2][0]) > -1 || PseudoPropsPairs.indexOf(CEntries[i2][0]) > -1)
      continue;
    if (CEntries[i2][1] == null)
      continue;
    CEntries2.push(CEntries[i2]);
  }
  if (SEntries.length)
    CFB.utils.cfb_add(cfb, "/SummaryInformation", write_PropertySetStream(SEntries, PSCLSID.SI, SummaryRE, SummaryPIDSI));
  if (DSEntries.length || CEntries2.length)
    CFB.utils.cfb_add(cfb, "/DocumentSummaryInformation", write_PropertySetStream(DSEntries, PSCLSID.DSI, DocSummaryRE, DocSummaryPIDDSI, CEntries2.length ? CEntries2 : null, PSCLSID.UDI));
}
function parse_xlscfb(cfb, options) {
  if (!options)
    options = {};
  fix_read_opts(options);
  reset_cp();
  if (options.codepage)
    set_ansi(options.codepage);
  var CompObj, WB;
  if (cfb.FullPaths) {
    if (CFB.find(cfb, "/encryption"))
      throw new Error("File is password-protected");
    CompObj = CFB.find(cfb, "!CompObj");
    WB = CFB.find(cfb, "/Workbook") || CFB.find(cfb, "/Book");
  } else {
    switch (options.type) {
      case "base64":
        cfb = s2a(Base64_decode(cfb));
        break;
      case "binary":
        cfb = s2a(cfb);
        break;
      case "buffer":
        break;
      case "array":
        if (!Array.isArray(cfb))
          cfb = Array.prototype.slice.call(cfb);
        break;
    }
    prep_blob(cfb, 0);
    WB = { content: cfb };
  }
  var WorkbookP;
  var _data;
  if (CompObj)
    parse_compobj(CompObj);
  if (options.bookProps && !options.bookSheets)
    WorkbookP = {};
  else {
    var T2 = has_buf ? "buffer" : "array";
    if (WB && WB.content)
      WorkbookP = parse_workbook(WB.content, options);
    else if ((_data = CFB.find(cfb, "PerfectOffice_MAIN")) && _data.content)
      WorkbookP = WK_.to_workbook(_data.content, (options.type = T2, options));
    else if ((_data = CFB.find(cfb, "NativeContent_MAIN")) && _data.content)
      WorkbookP = WK_.to_workbook(_data.content, (options.type = T2, options));
    else if ((_data = CFB.find(cfb, "MN0")) && _data.content)
      throw new Error("Unsupported Works 4 for Mac file");
    else
      throw new Error("Cannot find Workbook stream");
    if (options.bookVBA && cfb.FullPaths && CFB.find(cfb, "/_VBA_PROJECT_CUR/VBA/dir"))
      WorkbookP.vbaraw = make_vba_xls(cfb);
  }
  var props = {};
  if (cfb.FullPaths)
    parse_xls_props(
      /*::((*/
      cfb,
      props,
      options
    );
  WorkbookP.Props = WorkbookP.Custprops = props;
  if (options.bookFiles)
    WorkbookP.cfb = cfb;
  return WorkbookP;
}
function write_xlscfb(wb, opts) {
  var o2 = opts || {};
  var cfb = CFB.utils.cfb_new({ root: "R" });
  var wbpath = "/Workbook";
  switch (o2.bookType || "xls") {
    case "xls":
      o2.bookType = "biff8";
    case "xla":
      if (!o2.bookType)
        o2.bookType = "xla";
    case "biff8":
      wbpath = "/Workbook";
      o2.biff = 8;
      break;
    case "biff5":
      wbpath = "/Book";
      o2.biff = 5;
      break;
    default:
      throw new Error("invalid type " + o2.bookType + " for XLS CFB");
  }
  CFB.utils.cfb_add(cfb, wbpath, write_biff_buf(wb, o2));
  if (o2.biff == 8 && (wb.Props || wb.Custprops))
    write_xls_props(wb, cfb);
  if (o2.biff == 8 && wb.vbaraw)
    fill_vba_xls(cfb, CFB.read(wb.vbaraw, { type: typeof wb.vbaraw == "string" ? "binary" : "buffer" }));
  return cfb;
}
var XLSBRecordEnum = {
  /*::[*/
  0: {
    /* n:"BrtRowHdr", */
    f: parse_BrtRowHdr
  },
  /*::[*/
  1: {
    /* n:"BrtCellBlank", */
    f: parse_BrtCellBlank
  },
  /*::[*/
  2: {
    /* n:"BrtCellRk", */
    f: parse_BrtCellRk
  },
  /*::[*/
  3: {
    /* n:"BrtCellError", */
    f: parse_BrtCellError
  },
  /*::[*/
  4: {
    /* n:"BrtCellBool", */
    f: parse_BrtCellBool
  },
  /*::[*/
  5: {
    /* n:"BrtCellReal", */
    f: parse_BrtCellReal
  },
  /*::[*/
  6: {
    /* n:"BrtCellSt", */
    f: parse_BrtCellSt
  },
  /*::[*/
  7: {
    /* n:"BrtCellIsst", */
    f: parse_BrtCellIsst
  },
  /*::[*/
  8: {
    /* n:"BrtFmlaString", */
    f: parse_BrtFmlaString
  },
  /*::[*/
  9: {
    /* n:"BrtFmlaNum", */
    f: parse_BrtFmlaNum
  },
  /*::[*/
  10: {
    /* n:"BrtFmlaBool", */
    f: parse_BrtFmlaBool
  },
  /*::[*/
  11: {
    /* n:"BrtFmlaError", */
    f: parse_BrtFmlaError
  },
  /*::[*/
  12: {
    /* n:"BrtShortBlank", */
    f: parse_BrtShortBlank
  },
  /*::[*/
  13: {
    /* n:"BrtShortRk", */
    f: parse_BrtShortRk
  },
  /*::[*/
  14: {
    /* n:"BrtShortError", */
    f: parse_BrtShortError
  },
  /*::[*/
  15: {
    /* n:"BrtShortBool", */
    f: parse_BrtShortBool
  },
  /*::[*/
  16: {
    /* n:"BrtShortReal", */
    f: parse_BrtShortReal
  },
  /*::[*/
  17: {
    /* n:"BrtShortSt", */
    f: parse_BrtShortSt
  },
  /*::[*/
  18: {
    /* n:"BrtShortIsst", */
    f: parse_BrtShortIsst
  },
  /*::[*/
  19: {
    /* n:"BrtSSTItem", */
    f: parse_RichStr
  },
  /*::[*/
  20: {
    /* n:"BrtPCDIMissing" */
  },
  /*::[*/
  21: {
    /* n:"BrtPCDINumber" */
  },
  /*::[*/
  22: {
    /* n:"BrtPCDIBoolean" */
  },
  /*::[*/
  23: {
    /* n:"BrtPCDIError" */
  },
  /*::[*/
  24: {
    /* n:"BrtPCDIString" */
  },
  /*::[*/
  25: {
    /* n:"BrtPCDIDatetime" */
  },
  /*::[*/
  26: {
    /* n:"BrtPCDIIndex" */
  },
  /*::[*/
  27: {
    /* n:"BrtPCDIAMissing" */
  },
  /*::[*/
  28: {
    /* n:"BrtPCDIANumber" */
  },
  /*::[*/
  29: {
    /* n:"BrtPCDIABoolean" */
  },
  /*::[*/
  30: {
    /* n:"BrtPCDIAError" */
  },
  /*::[*/
  31: {
    /* n:"BrtPCDIAString" */
  },
  /*::[*/
  32: {
    /* n:"BrtPCDIADatetime" */
  },
  /*::[*/
  33: {
    /* n:"BrtPCRRecord" */
  },
  /*::[*/
  34: {
    /* n:"BrtPCRRecordDt" */
  },
  /*::[*/
  35: {
    /* n:"BrtFRTBegin", */
    T: 1
  },
  /*::[*/
  36: {
    /* n:"BrtFRTEnd", */
    T: -1
  },
  /*::[*/
  37: {
    /* n:"BrtACBegin", */
    T: 1
  },
  /*::[*/
  38: {
    /* n:"BrtACEnd", */
    T: -1
  },
  /*::[*/
  39: {
    /* n:"BrtName", */
    f: parse_BrtName
  },
  /*::[*/
  40: {
    /* n:"BrtIndexRowBlock" */
  },
  /*::[*/
  42: {
    /* n:"BrtIndexBlock" */
  },
  /*::[*/
  43: {
    /* n:"BrtFont", */
    f: parse_BrtFont
  },
  /*::[*/
  44: {
    /* n:"BrtFmt", */
    f: parse_BrtFmt
  },
  /*::[*/
  45: {
    /* n:"BrtFill", */
    f: parse_BrtFill
  },
  /*::[*/
  46: {
    /* n:"BrtBorder", */
    f: parse_BrtBorder
  },
  /*::[*/
  47: {
    /* n:"BrtXF", */
    f: parse_BrtXF
  },
  /*::[*/
  48: {
    /* n:"BrtStyle" */
  },
  /*::[*/
  49: {
    /* n:"BrtCellMeta", */
    f: parse_Int32LE
  },
  /*::[*/
  50: {
    /* n:"BrtValueMeta" */
  },
  /*::[*/
  51: {
    /* n:"BrtMdb" */
    f: parse_BrtMdb
  },
  /*::[*/
  52: {
    /* n:"BrtBeginFmd", */
    T: 1
  },
  /*::[*/
  53: {
    /* n:"BrtEndFmd", */
    T: -1
  },
  /*::[*/
  54: {
    /* n:"BrtBeginMdx", */
    T: 1
  },
  /*::[*/
  55: {
    /* n:"BrtEndMdx", */
    T: -1
  },
  /*::[*/
  56: {
    /* n:"BrtBeginMdxTuple", */
    T: 1
  },
  /*::[*/
  57: {
    /* n:"BrtEndMdxTuple", */
    T: -1
  },
  /*::[*/
  58: {
    /* n:"BrtMdxMbrIstr" */
  },
  /*::[*/
  59: {
    /* n:"BrtStr" */
  },
  /*::[*/
  60: {
    /* n:"BrtColInfo", */
    f: parse_ColInfo
  },
  /*::[*/
  62: {
    /* n:"BrtCellRString", */
    f: parse_BrtCellRString
  },
  /*::[*/
  63: {
    /* n:"BrtCalcChainItem$", */
    f: parse_BrtCalcChainItem$
  },
  /*::[*/
  64: {
    /* n:"BrtDVal", */
    f: parse_BrtDVal
  },
  /*::[*/
  65: {
    /* n:"BrtSxvcellNum" */
  },
  /*::[*/
  66: {
    /* n:"BrtSxvcellStr" */
  },
  /*::[*/
  67: {
    /* n:"BrtSxvcellBool" */
  },
  /*::[*/
  68: {
    /* n:"BrtSxvcellErr" */
  },
  /*::[*/
  69: {
    /* n:"BrtSxvcellDate" */
  },
  /*::[*/
  70: {
    /* n:"BrtSxvcellNil" */
  },
  /*::[*/
  128: {
    /* n:"BrtFileVersion" */
  },
  /*::[*/
  129: {
    /* n:"BrtBeginSheet", */
    T: 1
  },
  /*::[*/
  130: {
    /* n:"BrtEndSheet", */
    T: -1
  },
  /*::[*/
  131: {
    /* n:"BrtBeginBook", */
    T: 1,
    f: parsenoop,
    p: 0
  },
  /*::[*/
  132: {
    /* n:"BrtEndBook", */
    T: -1
  },
  /*::[*/
  133: {
    /* n:"BrtBeginWsViews", */
    T: 1
  },
  /*::[*/
  134: {
    /* n:"BrtEndWsViews", */
    T: -1
  },
  /*::[*/
  135: {
    /* n:"BrtBeginBookViews", */
    T: 1
  },
  /*::[*/
  136: {
    /* n:"BrtEndBookViews", */
    T: -1
  },
  /*::[*/
  137: {
    /* n:"BrtBeginWsView", */
    T: 1,
    f: parse_BrtBeginWsView
  },
  /*::[*/
  138: {
    /* n:"BrtEndWsView", */
    T: -1
  },
  /*::[*/
  139: {
    /* n:"BrtBeginCsViews", */
    T: 1
  },
  /*::[*/
  140: {
    /* n:"BrtEndCsViews", */
    T: -1
  },
  /*::[*/
  141: {
    /* n:"BrtBeginCsView", */
    T: 1
  },
  /*::[*/
  142: {
    /* n:"BrtEndCsView", */
    T: -1
  },
  /*::[*/
  143: {
    /* n:"BrtBeginBundleShs", */
    T: 1
  },
  /*::[*/
  144: {
    /* n:"BrtEndBundleShs", */
    T: -1
  },
  /*::[*/
  145: {
    /* n:"BrtBeginSheetData", */
    T: 1
  },
  /*::[*/
  146: {
    /* n:"BrtEndSheetData", */
    T: -1
  },
  /*::[*/
  147: {
    /* n:"BrtWsProp", */
    f: parse_BrtWsProp
  },
  /*::[*/
  148: {
    /* n:"BrtWsDim", */
    f: parse_BrtWsDim,
    p: 16
  },
  /*::[*/
  151: {
    /* n:"BrtPane", */
    f: parse_BrtPane
  },
  /*::[*/
  152: {
    /* n:"BrtSel" */
  },
  /*::[*/
  153: {
    /* n:"BrtWbProp", */
    f: parse_BrtWbProp
  },
  /*::[*/
  154: {
    /* n:"BrtWbFactoid" */
  },
  /*::[*/
  155: {
    /* n:"BrtFileRecover" */
  },
  /*::[*/
  156: {
    /* n:"BrtBundleSh", */
    f: parse_BrtBundleSh
  },
  /*::[*/
  157: {
    /* n:"BrtCalcProp" */
  },
  /*::[*/
  158: {
    /* n:"BrtBookView" */
  },
  /*::[*/
  159: {
    /* n:"BrtBeginSst", */
    T: 1,
    f: parse_BrtBeginSst
  },
  /*::[*/
  160: {
    /* n:"BrtEndSst", */
    T: -1
  },
  /*::[*/
  161: {
    /* n:"BrtBeginAFilter", */
    T: 1,
    f: parse_UncheckedRfX
  },
  /*::[*/
  162: {
    /* n:"BrtEndAFilter", */
    T: -1
  },
  /*::[*/
  163: {
    /* n:"BrtBeginFilterColumn", */
    T: 1
  },
  /*::[*/
  164: {
    /* n:"BrtEndFilterColumn", */
    T: -1
  },
  /*::[*/
  165: {
    /* n:"BrtBeginFilters", */
    T: 1
  },
  /*::[*/
  166: {
    /* n:"BrtEndFilters", */
    T: -1
  },
  /*::[*/
  167: {
    /* n:"BrtFilter" */
  },
  /*::[*/
  168: {
    /* n:"BrtColorFilter" */
  },
  /*::[*/
  169: {
    /* n:"BrtIconFilter" */
  },
  /*::[*/
  170: {
    /* n:"BrtTop10Filter" */
  },
  /*::[*/
  171: {
    /* n:"BrtDynamicFilter" */
  },
  /*::[*/
  172: {
    /* n:"BrtBeginCustomFilters", */
    T: 1
  },
  /*::[*/
  173: {
    /* n:"BrtEndCustomFilters", */
    T: -1
  },
  /*::[*/
  174: {
    /* n:"BrtCustomFilter" */
  },
  /*::[*/
  175: {
    /* n:"BrtAFilterDateGroupItem" */
  },
  /*::[*/
  176: {
    /* n:"BrtMergeCell", */
    f: parse_BrtMergeCell
  },
  /*::[*/
  177: {
    /* n:"BrtBeginMergeCells", */
    T: 1
  },
  /*::[*/
  178: {
    /* n:"BrtEndMergeCells", */
    T: -1
  },
  /*::[*/
  179: {
    /* n:"BrtBeginPivotCacheDef", */
    T: 1
  },
  /*::[*/
  180: {
    /* n:"BrtEndPivotCacheDef", */
    T: -1
  },
  /*::[*/
  181: {
    /* n:"BrtBeginPCDFields", */
    T: 1
  },
  /*::[*/
  182: {
    /* n:"BrtEndPCDFields", */
    T: -1
  },
  /*::[*/
  183: {
    /* n:"BrtBeginPCDField", */
    T: 1
  },
  /*::[*/
  184: {
    /* n:"BrtEndPCDField", */
    T: -1
  },
  /*::[*/
  185: {
    /* n:"BrtBeginPCDSource", */
    T: 1
  },
  /*::[*/
  186: {
    /* n:"BrtEndPCDSource", */
    T: -1
  },
  /*::[*/
  187: {
    /* n:"BrtBeginPCDSRange", */
    T: 1
  },
  /*::[*/
  188: {
    /* n:"BrtEndPCDSRange", */
    T: -1
  },
  /*::[*/
  189: {
    /* n:"BrtBeginPCDFAtbl", */
    T: 1
  },
  /*::[*/
  190: {
    /* n:"BrtEndPCDFAtbl", */
    T: -1
  },
  /*::[*/
  191: {
    /* n:"BrtBeginPCDIRun", */
    T: 1
  },
  /*::[*/
  192: {
    /* n:"BrtEndPCDIRun", */
    T: -1
  },
  /*::[*/
  193: {
    /* n:"BrtBeginPivotCacheRecords", */
    T: 1
  },
  /*::[*/
  194: {
    /* n:"BrtEndPivotCacheRecords", */
    T: -1
  },
  /*::[*/
  195: {
    /* n:"BrtBeginPCDHierarchies", */
    T: 1
  },
  /*::[*/
  196: {
    /* n:"BrtEndPCDHierarchies", */
    T: -1
  },
  /*::[*/
  197: {
    /* n:"BrtBeginPCDHierarchy", */
    T: 1
  },
  /*::[*/
  198: {
    /* n:"BrtEndPCDHierarchy", */
    T: -1
  },
  /*::[*/
  199: {
    /* n:"BrtBeginPCDHFieldsUsage", */
    T: 1
  },
  /*::[*/
  200: {
    /* n:"BrtEndPCDHFieldsUsage", */
    T: -1
  },
  /*::[*/
  201: {
    /* n:"BrtBeginExtConnection", */
    T: 1
  },
  /*::[*/
  202: {
    /* n:"BrtEndExtConnection", */
    T: -1
  },
  /*::[*/
  203: {
    /* n:"BrtBeginECDbProps", */
    T: 1
  },
  /*::[*/
  204: {
    /* n:"BrtEndECDbProps", */
    T: -1
  },
  /*::[*/
  205: {
    /* n:"BrtBeginECOlapProps", */
    T: 1
  },
  /*::[*/
  206: {
    /* n:"BrtEndECOlapProps", */
    T: -1
  },
  /*::[*/
  207: {
    /* n:"BrtBeginPCDSConsol", */
    T: 1
  },
  /*::[*/
  208: {
    /* n:"BrtEndPCDSConsol", */
    T: -1
  },
  /*::[*/
  209: {
    /* n:"BrtBeginPCDSCPages", */
    T: 1
  },
  /*::[*/
  210: {
    /* n:"BrtEndPCDSCPages", */
    T: -1
  },
  /*::[*/
  211: {
    /* n:"BrtBeginPCDSCPage", */
    T: 1
  },
  /*::[*/
  212: {
    /* n:"BrtEndPCDSCPage", */
    T: -1
  },
  /*::[*/
  213: {
    /* n:"BrtBeginPCDSCPItem", */
    T: 1
  },
  /*::[*/
  214: {
    /* n:"BrtEndPCDSCPItem", */
    T: -1
  },
  /*::[*/
  215: {
    /* n:"BrtBeginPCDSCSets", */
    T: 1
  },
  /*::[*/
  216: {
    /* n:"BrtEndPCDSCSets", */
    T: -1
  },
  /*::[*/
  217: {
    /* n:"BrtBeginPCDSCSet", */
    T: 1
  },
  /*::[*/
  218: {
    /* n:"BrtEndPCDSCSet", */
    T: -1
  },
  /*::[*/
  219: {
    /* n:"BrtBeginPCDFGroup", */
    T: 1
  },
  /*::[*/
  220: {
    /* n:"BrtEndPCDFGroup", */
    T: -1
  },
  /*::[*/
  221: {
    /* n:"BrtBeginPCDFGItems", */
    T: 1
  },
  /*::[*/
  222: {
    /* n:"BrtEndPCDFGItems", */
    T: -1
  },
  /*::[*/
  223: {
    /* n:"BrtBeginPCDFGRange", */
    T: 1
  },
  /*::[*/
  224: {
    /* n:"BrtEndPCDFGRange", */
    T: -1
  },
  /*::[*/
  225: {
    /* n:"BrtBeginPCDFGDiscrete", */
    T: 1
  },
  /*::[*/
  226: {
    /* n:"BrtEndPCDFGDiscrete", */
    T: -1
  },
  /*::[*/
  227: {
    /* n:"BrtBeginPCDSDTupleCache", */
    T: 1
  },
  /*::[*/
  228: {
    /* n:"BrtEndPCDSDTupleCache", */
    T: -1
  },
  /*::[*/
  229: {
    /* n:"BrtBeginPCDSDTCEntries", */
    T: 1
  },
  /*::[*/
  230: {
    /* n:"BrtEndPCDSDTCEntries", */
    T: -1
  },
  /*::[*/
  231: {
    /* n:"BrtBeginPCDSDTCEMembers", */
    T: 1
  },
  /*::[*/
  232: {
    /* n:"BrtEndPCDSDTCEMembers", */
    T: -1
  },
  /*::[*/
  233: {
    /* n:"BrtBeginPCDSDTCEMember", */
    T: 1
  },
  /*::[*/
  234: {
    /* n:"BrtEndPCDSDTCEMember", */
    T: -1
  },
  /*::[*/
  235: {
    /* n:"BrtBeginPCDSDTCQueries", */
    T: 1
  },
  /*::[*/
  236: {
    /* n:"BrtEndPCDSDTCQueries", */
    T: -1
  },
  /*::[*/
  237: {
    /* n:"BrtBeginPCDSDTCQuery", */
    T: 1
  },
  /*::[*/
  238: {
    /* n:"BrtEndPCDSDTCQuery", */
    T: -1
  },
  /*::[*/
  239: {
    /* n:"BrtBeginPCDSDTCSets", */
    T: 1
  },
  /*::[*/
  240: {
    /* n:"BrtEndPCDSDTCSets", */
    T: -1
  },
  /*::[*/
  241: {
    /* n:"BrtBeginPCDSDTCSet", */
    T: 1
  },
  /*::[*/
  242: {
    /* n:"BrtEndPCDSDTCSet", */
    T: -1
  },
  /*::[*/
  243: {
    /* n:"BrtBeginPCDCalcItems", */
    T: 1
  },
  /*::[*/
  244: {
    /* n:"BrtEndPCDCalcItems", */
    T: -1
  },
  /*::[*/
  245: {
    /* n:"BrtBeginPCDCalcItem", */
    T: 1
  },
  /*::[*/
  246: {
    /* n:"BrtEndPCDCalcItem", */
    T: -1
  },
  /*::[*/
  247: {
    /* n:"BrtBeginPRule", */
    T: 1
  },
  /*::[*/
  248: {
    /* n:"BrtEndPRule", */
    T: -1
  },
  /*::[*/
  249: {
    /* n:"BrtBeginPRFilters", */
    T: 1
  },
  /*::[*/
  250: {
    /* n:"BrtEndPRFilters", */
    T: -1
  },
  /*::[*/
  251: {
    /* n:"BrtBeginPRFilter", */
    T: 1
  },
  /*::[*/
  252: {
    /* n:"BrtEndPRFilter", */
    T: -1
  },
  /*::[*/
  253: {
    /* n:"BrtBeginPNames", */
    T: 1
  },
  /*::[*/
  254: {
    /* n:"BrtEndPNames", */
    T: -1
  },
  /*::[*/
  255: {
    /* n:"BrtBeginPName", */
    T: 1
  },
  /*::[*/
  256: {
    /* n:"BrtEndPName", */
    T: -1
  },
  /*::[*/
  257: {
    /* n:"BrtBeginPNPairs", */
    T: 1
  },
  /*::[*/
  258: {
    /* n:"BrtEndPNPairs", */
    T: -1
  },
  /*::[*/
  259: {
    /* n:"BrtBeginPNPair", */
    T: 1
  },
  /*::[*/
  260: {
    /* n:"BrtEndPNPair", */
    T: -1
  },
  /*::[*/
  261: {
    /* n:"BrtBeginECWebProps", */
    T: 1
  },
  /*::[*/
  262: {
    /* n:"BrtEndECWebProps", */
    T: -1
  },
  /*::[*/
  263: {
    /* n:"BrtBeginEcWpTables", */
    T: 1
  },
  /*::[*/
  264: {
    /* n:"BrtEndECWPTables", */
    T: -1
  },
  /*::[*/
  265: {
    /* n:"BrtBeginECParams", */
    T: 1
  },
  /*::[*/
  266: {
    /* n:"BrtEndECParams", */
    T: -1
  },
  /*::[*/
  267: {
    /* n:"BrtBeginECParam", */
    T: 1
  },
  /*::[*/
  268: {
    /* n:"BrtEndECParam", */
    T: -1
  },
  /*::[*/
  269: {
    /* n:"BrtBeginPCDKPIs", */
    T: 1
  },
  /*::[*/
  270: {
    /* n:"BrtEndPCDKPIs", */
    T: -1
  },
  /*::[*/
  271: {
    /* n:"BrtBeginPCDKPI", */
    T: 1
  },
  /*::[*/
  272: {
    /* n:"BrtEndPCDKPI", */
    T: -1
  },
  /*::[*/
  273: {
    /* n:"BrtBeginDims", */
    T: 1
  },
  /*::[*/
  274: {
    /* n:"BrtEndDims", */
    T: -1
  },
  /*::[*/
  275: {
    /* n:"BrtBeginDim", */
    T: 1
  },
  /*::[*/
  276: {
    /* n:"BrtEndDim", */
    T: -1
  },
  /*::[*/
  277: {
    /* n:"BrtIndexPartEnd" */
  },
  /*::[*/
  278: {
    /* n:"BrtBeginStyleSheet", */
    T: 1
  },
  /*::[*/
  279: {
    /* n:"BrtEndStyleSheet", */
    T: -1
  },
  /*::[*/
  280: {
    /* n:"BrtBeginSXView", */
    T: 1
  },
  /*::[*/
  281: {
    /* n:"BrtEndSXVI", */
    T: -1
  },
  /*::[*/
  282: {
    /* n:"BrtBeginSXVI", */
    T: 1
  },
  /*::[*/
  283: {
    /* n:"BrtBeginSXVIs", */
    T: 1
  },
  /*::[*/
  284: {
    /* n:"BrtEndSXVIs", */
    T: -1
  },
  /*::[*/
  285: {
    /* n:"BrtBeginSXVD", */
    T: 1
  },
  /*::[*/
  286: {
    /* n:"BrtEndSXVD", */
    T: -1
  },
  /*::[*/
  287: {
    /* n:"BrtBeginSXVDs", */
    T: 1
  },
  /*::[*/
  288: {
    /* n:"BrtEndSXVDs", */
    T: -1
  },
  /*::[*/
  289: {
    /* n:"BrtBeginSXPI", */
    T: 1
  },
  /*::[*/
  290: {
    /* n:"BrtEndSXPI", */
    T: -1
  },
  /*::[*/
  291: {
    /* n:"BrtBeginSXPIs", */
    T: 1
  },
  /*::[*/
  292: {
    /* n:"BrtEndSXPIs", */
    T: -1
  },
  /*::[*/
  293: {
    /* n:"BrtBeginSXDI", */
    T: 1
  },
  /*::[*/
  294: {
    /* n:"BrtEndSXDI", */
    T: -1
  },
  /*::[*/
  295: {
    /* n:"BrtBeginSXDIs", */
    T: 1
  },
  /*::[*/
  296: {
    /* n:"BrtEndSXDIs", */
    T: -1
  },
  /*::[*/
  297: {
    /* n:"BrtBeginSXLI", */
    T: 1
  },
  /*::[*/
  298: {
    /* n:"BrtEndSXLI", */
    T: -1
  },
  /*::[*/
  299: {
    /* n:"BrtBeginSXLIRws", */
    T: 1
  },
  /*::[*/
  300: {
    /* n:"BrtEndSXLIRws", */
    T: -1
  },
  /*::[*/
  301: {
    /* n:"BrtBeginSXLICols", */
    T: 1
  },
  /*::[*/
  302: {
    /* n:"BrtEndSXLICols", */
    T: -1
  },
  /*::[*/
  303: {
    /* n:"BrtBeginSXFormat", */
    T: 1
  },
  /*::[*/
  304: {
    /* n:"BrtEndSXFormat", */
    T: -1
  },
  /*::[*/
  305: {
    /* n:"BrtBeginSXFormats", */
    T: 1
  },
  /*::[*/
  306: {
    /* n:"BrtEndSxFormats", */
    T: -1
  },
  /*::[*/
  307: {
    /* n:"BrtBeginSxSelect", */
    T: 1
  },
  /*::[*/
  308: {
    /* n:"BrtEndSxSelect", */
    T: -1
  },
  /*::[*/
  309: {
    /* n:"BrtBeginISXVDRws", */
    T: 1
  },
  /*::[*/
  310: {
    /* n:"BrtEndISXVDRws", */
    T: -1
  },
  /*::[*/
  311: {
    /* n:"BrtBeginISXVDCols", */
    T: 1
  },
  /*::[*/
  312: {
    /* n:"BrtEndISXVDCols", */
    T: -1
  },
  /*::[*/
  313: {
    /* n:"BrtEndSXLocation", */
    T: -1
  },
  /*::[*/
  314: {
    /* n:"BrtBeginSXLocation", */
    T: 1
  },
  /*::[*/
  315: {
    /* n:"BrtEndSXView", */
    T: -1
  },
  /*::[*/
  316: {
    /* n:"BrtBeginSXTHs", */
    T: 1
  },
  /*::[*/
  317: {
    /* n:"BrtEndSXTHs", */
    T: -1
  },
  /*::[*/
  318: {
    /* n:"BrtBeginSXTH", */
    T: 1
  },
  /*::[*/
  319: {
    /* n:"BrtEndSXTH", */
    T: -1
  },
  /*::[*/
  320: {
    /* n:"BrtBeginISXTHRws", */
    T: 1
  },
  /*::[*/
  321: {
    /* n:"BrtEndISXTHRws", */
    T: -1
  },
  /*::[*/
  322: {
    /* n:"BrtBeginISXTHCols", */
    T: 1
  },
  /*::[*/
  323: {
    /* n:"BrtEndISXTHCols", */
    T: -1
  },
  /*::[*/
  324: {
    /* n:"BrtBeginSXTDMPS", */
    T: 1
  },
  /*::[*/
  325: {
    /* n:"BrtEndSXTDMPs", */
    T: -1
  },
  /*::[*/
  326: {
    /* n:"BrtBeginSXTDMP", */
    T: 1
  },
  /*::[*/
  327: {
    /* n:"BrtEndSXTDMP", */
    T: -1
  },
  /*::[*/
  328: {
    /* n:"BrtBeginSXTHItems", */
    T: 1
  },
  /*::[*/
  329: {
    /* n:"BrtEndSXTHItems", */
    T: -1
  },
  /*::[*/
  330: {
    /* n:"BrtBeginSXTHItem", */
    T: 1
  },
  /*::[*/
  331: {
    /* n:"BrtEndSXTHItem", */
    T: -1
  },
  /*::[*/
  332: {
    /* n:"BrtBeginMetadata", */
    T: 1
  },
  /*::[*/
  333: {
    /* n:"BrtEndMetadata", */
    T: -1
  },
  /*::[*/
  334: {
    /* n:"BrtBeginEsmdtinfo", */
    T: 1
  },
  /*::[*/
  335: {
    /* n:"BrtMdtinfo", */
    f: parse_BrtMdtinfo
  },
  /*::[*/
  336: {
    /* n:"BrtEndEsmdtinfo", */
    T: -1
  },
  /*::[*/
  337: {
    /* n:"BrtBeginEsmdb", */
    f: parse_BrtBeginEsmdb,
    T: 1
  },
  /*::[*/
  338: {
    /* n:"BrtEndEsmdb", */
    T: -1
  },
  /*::[*/
  339: {
    /* n:"BrtBeginEsfmd", */
    T: 1
  },
  /*::[*/
  340: {
    /* n:"BrtEndEsfmd", */
    T: -1
  },
  /*::[*/
  341: {
    /* n:"BrtBeginSingleCells", */
    T: 1
  },
  /*::[*/
  342: {
    /* n:"BrtEndSingleCells", */
    T: -1
  },
  /*::[*/
  343: {
    /* n:"BrtBeginList", */
    T: 1
  },
  /*::[*/
  344: {
    /* n:"BrtEndList", */
    T: -1
  },
  /*::[*/
  345: {
    /* n:"BrtBeginListCols", */
    T: 1
  },
  /*::[*/
  346: {
    /* n:"BrtEndListCols", */
    T: -1
  },
  /*::[*/
  347: {
    /* n:"BrtBeginListCol", */
    T: 1
  },
  /*::[*/
  348: {
    /* n:"BrtEndListCol", */
    T: -1
  },
  /*::[*/
  349: {
    /* n:"BrtBeginListXmlCPr", */
    T: 1
  },
  /*::[*/
  350: {
    /* n:"BrtEndListXmlCPr", */
    T: -1
  },
  /*::[*/
  351: {
    /* n:"BrtListCCFmla" */
  },
  /*::[*/
  352: {
    /* n:"BrtListTrFmla" */
  },
  /*::[*/
  353: {
    /* n:"BrtBeginExternals", */
    T: 1
  },
  /*::[*/
  354: {
    /* n:"BrtEndExternals", */
    T: -1
  },
  /*::[*/
  355: {
    /* n:"BrtSupBookSrc", */
    f: parse_RelID
  },
  /*::[*/
  357: {
    /* n:"BrtSupSelf" */
  },
  /*::[*/
  358: {
    /* n:"BrtSupSame" */
  },
  /*::[*/
  359: {
    /* n:"BrtSupTabs" */
  },
  /*::[*/
  360: {
    /* n:"BrtBeginSupBook", */
    T: 1
  },
  /*::[*/
  361: {
    /* n:"BrtPlaceholderName" */
  },
  /*::[*/
  362: {
    /* n:"BrtExternSheet", */
    f: parse_ExternSheet
  },
  /*::[*/
  363: {
    /* n:"BrtExternTableStart" */
  },
  /*::[*/
  364: {
    /* n:"BrtExternTableEnd" */
  },
  /*::[*/
  366: {
    /* n:"BrtExternRowHdr" */
  },
  /*::[*/
  367: {
    /* n:"BrtExternCellBlank" */
  },
  /*::[*/
  368: {
    /* n:"BrtExternCellReal" */
  },
  /*::[*/
  369: {
    /* n:"BrtExternCellBool" */
  },
  /*::[*/
  370: {
    /* n:"BrtExternCellError" */
  },
  /*::[*/
  371: {
    /* n:"BrtExternCellString" */
  },
  /*::[*/
  372: {
    /* n:"BrtBeginEsmdx", */
    T: 1
  },
  /*::[*/
  373: {
    /* n:"BrtEndEsmdx", */
    T: -1
  },
  /*::[*/
  374: {
    /* n:"BrtBeginMdxSet", */
    T: 1
  },
  /*::[*/
  375: {
    /* n:"BrtEndMdxSet", */
    T: -1
  },
  /*::[*/
  376: {
    /* n:"BrtBeginMdxMbrProp", */
    T: 1
  },
  /*::[*/
  377: {
    /* n:"BrtEndMdxMbrProp", */
    T: -1
  },
  /*::[*/
  378: {
    /* n:"BrtBeginMdxKPI", */
    T: 1
  },
  /*::[*/
  379: {
    /* n:"BrtEndMdxKPI", */
    T: -1
  },
  /*::[*/
  380: {
    /* n:"BrtBeginEsstr", */
    T: 1
  },
  /*::[*/
  381: {
    /* n:"BrtEndEsstr", */
    T: -1
  },
  /*::[*/
  382: {
    /* n:"BrtBeginPRFItem", */
    T: 1
  },
  /*::[*/
  383: {
    /* n:"BrtEndPRFItem", */
    T: -1
  },
  /*::[*/
  384: {
    /* n:"BrtBeginPivotCacheIDs", */
    T: 1
  },
  /*::[*/
  385: {
    /* n:"BrtEndPivotCacheIDs", */
    T: -1
  },
  /*::[*/
  386: {
    /* n:"BrtBeginPivotCacheID", */
    T: 1
  },
  /*::[*/
  387: {
    /* n:"BrtEndPivotCacheID", */
    T: -1
  },
  /*::[*/
  388: {
    /* n:"BrtBeginISXVIs", */
    T: 1
  },
  /*::[*/
  389: {
    /* n:"BrtEndISXVIs", */
    T: -1
  },
  /*::[*/
  390: {
    /* n:"BrtBeginColInfos", */
    T: 1
  },
  /*::[*/
  391: {
    /* n:"BrtEndColInfos", */
    T: -1
  },
  /*::[*/
  392: {
    /* n:"BrtBeginRwBrk", */
    T: 1
  },
  /*::[*/
  393: {
    /* n:"BrtEndRwBrk", */
    T: -1
  },
  /*::[*/
  394: {
    /* n:"BrtBeginColBrk", */
    T: 1
  },
  /*::[*/
  395: {
    /* n:"BrtEndColBrk", */
    T: -1
  },
  /*::[*/
  396: {
    /* n:"BrtBrk" */
  },
  /*::[*/
  397: {
    /* n:"BrtUserBookView" */
  },
  /*::[*/
  398: {
    /* n:"BrtInfo" */
  },
  /*::[*/
  399: {
    /* n:"BrtCUsr" */
  },
  /*::[*/
  400: {
    /* n:"BrtUsr" */
  },
  /*::[*/
  401: {
    /* n:"BrtBeginUsers", */
    T: 1
  },
  /*::[*/
  403: {
    /* n:"BrtEOF" */
  },
  /*::[*/
  404: {
    /* n:"BrtUCR" */
  },
  /*::[*/
  405: {
    /* n:"BrtRRInsDel" */
  },
  /*::[*/
  406: {
    /* n:"BrtRREndInsDel" */
  },
  /*::[*/
  407: {
    /* n:"BrtRRMove" */
  },
  /*::[*/
  408: {
    /* n:"BrtRREndMove" */
  },
  /*::[*/
  409: {
    /* n:"BrtRRChgCell" */
  },
  /*::[*/
  410: {
    /* n:"BrtRREndChgCell" */
  },
  /*::[*/
  411: {
    /* n:"BrtRRHeader" */
  },
  /*::[*/
  412: {
    /* n:"BrtRRUserView" */
  },
  /*::[*/
  413: {
    /* n:"BrtRRRenSheet" */
  },
  /*::[*/
  414: {
    /* n:"BrtRRInsertSh" */
  },
  /*::[*/
  415: {
    /* n:"BrtRRDefName" */
  },
  /*::[*/
  416: {
    /* n:"BrtRRNote" */
  },
  /*::[*/
  417: {
    /* n:"BrtRRConflict" */
  },
  /*::[*/
  418: {
    /* n:"BrtRRTQSIF" */
  },
  /*::[*/
  419: {
    /* n:"BrtRRFormat" */
  },
  /*::[*/
  420: {
    /* n:"BrtRREndFormat" */
  },
  /*::[*/
  421: {
    /* n:"BrtRRAutoFmt" */
  },
  /*::[*/
  422: {
    /* n:"BrtBeginUserShViews", */
    T: 1
  },
  /*::[*/
  423: {
    /* n:"BrtBeginUserShView", */
    T: 1
  },
  /*::[*/
  424: {
    /* n:"BrtEndUserShView", */
    T: -1
  },
  /*::[*/
  425: {
    /* n:"BrtEndUserShViews", */
    T: -1
  },
  /*::[*/
  426: {
    /* n:"BrtArrFmla", */
    f: parse_BrtArrFmla
  },
  /*::[*/
  427: {
    /* n:"BrtShrFmla", */
    f: parse_BrtShrFmla
  },
  /*::[*/
  428: {
    /* n:"BrtTable" */
  },
  /*::[*/
  429: {
    /* n:"BrtBeginExtConnections", */
    T: 1
  },
  /*::[*/
  430: {
    /* n:"BrtEndExtConnections", */
    T: -1
  },
  /*::[*/
  431: {
    /* n:"BrtBeginPCDCalcMems", */
    T: 1
  },
  /*::[*/
  432: {
    /* n:"BrtEndPCDCalcMems", */
    T: -1
  },
  /*::[*/
  433: {
    /* n:"BrtBeginPCDCalcMem", */
    T: 1
  },
  /*::[*/
  434: {
    /* n:"BrtEndPCDCalcMem", */
    T: -1
  },
  /*::[*/
  435: {
    /* n:"BrtBeginPCDHGLevels", */
    T: 1
  },
  /*::[*/
  436: {
    /* n:"BrtEndPCDHGLevels", */
    T: -1
  },
  /*::[*/
  437: {
    /* n:"BrtBeginPCDHGLevel", */
    T: 1
  },
  /*::[*/
  438: {
    /* n:"BrtEndPCDHGLevel", */
    T: -1
  },
  /*::[*/
  439: {
    /* n:"BrtBeginPCDHGLGroups", */
    T: 1
  },
  /*::[*/
  440: {
    /* n:"BrtEndPCDHGLGroups", */
    T: -1
  },
  /*::[*/
  441: {
    /* n:"BrtBeginPCDHGLGroup", */
    T: 1
  },
  /*::[*/
  442: {
    /* n:"BrtEndPCDHGLGroup", */
    T: -1
  },
  /*::[*/
  443: {
    /* n:"BrtBeginPCDHGLGMembers", */
    T: 1
  },
  /*::[*/
  444: {
    /* n:"BrtEndPCDHGLGMembers", */
    T: -1
  },
  /*::[*/
  445: {
    /* n:"BrtBeginPCDHGLGMember", */
    T: 1
  },
  /*::[*/
  446: {
    /* n:"BrtEndPCDHGLGMember", */
    T: -1
  },
  /*::[*/
  447: {
    /* n:"BrtBeginQSI", */
    T: 1
  },
  /*::[*/
  448: {
    /* n:"BrtEndQSI", */
    T: -1
  },
  /*::[*/
  449: {
    /* n:"BrtBeginQSIR", */
    T: 1
  },
  /*::[*/
  450: {
    /* n:"BrtEndQSIR", */
    T: -1
  },
  /*::[*/
  451: {
    /* n:"BrtBeginDeletedNames", */
    T: 1
  },
  /*::[*/
  452: {
    /* n:"BrtEndDeletedNames", */
    T: -1
  },
  /*::[*/
  453: {
    /* n:"BrtBeginDeletedName", */
    T: 1
  },
  /*::[*/
  454: {
    /* n:"BrtEndDeletedName", */
    T: -1
  },
  /*::[*/
  455: {
    /* n:"BrtBeginQSIFs", */
    T: 1
  },
  /*::[*/
  456: {
    /* n:"BrtEndQSIFs", */
    T: -1
  },
  /*::[*/
  457: {
    /* n:"BrtBeginQSIF", */
    T: 1
  },
  /*::[*/
  458: {
    /* n:"BrtEndQSIF", */
    T: -1
  },
  /*::[*/
  459: {
    /* n:"BrtBeginAutoSortScope", */
    T: 1
  },
  /*::[*/
  460: {
    /* n:"BrtEndAutoSortScope", */
    T: -1
  },
  /*::[*/
  461: {
    /* n:"BrtBeginConditionalFormatting", */
    T: 1
  },
  /*::[*/
  462: {
    /* n:"BrtEndConditionalFormatting", */
    T: -1
  },
  /*::[*/
  463: {
    /* n:"BrtBeginCFRule", */
    T: 1
  },
  /*::[*/
  464: {
    /* n:"BrtEndCFRule", */
    T: -1
  },
  /*::[*/
  465: {
    /* n:"BrtBeginIconSet", */
    T: 1
  },
  /*::[*/
  466: {
    /* n:"BrtEndIconSet", */
    T: -1
  },
  /*::[*/
  467: {
    /* n:"BrtBeginDatabar", */
    T: 1
  },
  /*::[*/
  468: {
    /* n:"BrtEndDatabar", */
    T: -1
  },
  /*::[*/
  469: {
    /* n:"BrtBeginColorScale", */
    T: 1
  },
  /*::[*/
  470: {
    /* n:"BrtEndColorScale", */
    T: -1
  },
  /*::[*/
  471: {
    /* n:"BrtCFVO" */
  },
  /*::[*/
  472: {
    /* n:"BrtExternValueMeta" */
  },
  /*::[*/
  473: {
    /* n:"BrtBeginColorPalette", */
    T: 1
  },
  /*::[*/
  474: {
    /* n:"BrtEndColorPalette", */
    T: -1
  },
  /*::[*/
  475: {
    /* n:"BrtIndexedColor" */
  },
  /*::[*/
  476: {
    /* n:"BrtMargins", */
    f: parse_BrtMargins
  },
  /*::[*/
  477: {
    /* n:"BrtPrintOptions" */
  },
  /*::[*/
  478: {
    /* n:"BrtPageSetup" */
  },
  /*::[*/
  479: {
    /* n:"BrtBeginHeaderFooter", */
    T: 1
  },
  /*::[*/
  480: {
    /* n:"BrtEndHeaderFooter", */
    T: -1
  },
  /*::[*/
  481: {
    /* n:"BrtBeginSXCrtFormat", */
    T: 1
  },
  /*::[*/
  482: {
    /* n:"BrtEndSXCrtFormat", */
    T: -1
  },
  /*::[*/
  483: {
    /* n:"BrtBeginSXCrtFormats", */
    T: 1
  },
  /*::[*/
  484: {
    /* n:"BrtEndSXCrtFormats", */
    T: -1
  },
  /*::[*/
  485: {
    /* n:"BrtWsFmtInfo", */
    f: parse_BrtWsFmtInfo
  },
  /*::[*/
  486: {
    /* n:"BrtBeginMgs", */
    T: 1
  },
  /*::[*/
  487: {
    /* n:"BrtEndMGs", */
    T: -1
  },
  /*::[*/
  488: {
    /* n:"BrtBeginMGMaps", */
    T: 1
  },
  /*::[*/
  489: {
    /* n:"BrtEndMGMaps", */
    T: -1
  },
  /*::[*/
  490: {
    /* n:"BrtBeginMG", */
    T: 1
  },
  /*::[*/
  491: {
    /* n:"BrtEndMG", */
    T: -1
  },
  /*::[*/
  492: {
    /* n:"BrtBeginMap", */
    T: 1
  },
  /*::[*/
  493: {
    /* n:"BrtEndMap", */
    T: -1
  },
  /*::[*/
  494: {
    /* n:"BrtHLink", */
    f: parse_BrtHLink
  },
  /*::[*/
  495: {
    /* n:"BrtBeginDCon", */
    T: 1
  },
  /*::[*/
  496: {
    /* n:"BrtEndDCon", */
    T: -1
  },
  /*::[*/
  497: {
    /* n:"BrtBeginDRefs", */
    T: 1
  },
  /*::[*/
  498: {
    /* n:"BrtEndDRefs", */
    T: -1
  },
  /*::[*/
  499: {
    /* n:"BrtDRef" */
  },
  /*::[*/
  500: {
    /* n:"BrtBeginScenMan", */
    T: 1
  },
  /*::[*/
  501: {
    /* n:"BrtEndScenMan", */
    T: -1
  },
  /*::[*/
  502: {
    /* n:"BrtBeginSct", */
    T: 1
  },
  /*::[*/
  503: {
    /* n:"BrtEndSct", */
    T: -1
  },
  /*::[*/
  504: {
    /* n:"BrtSlc" */
  },
  /*::[*/
  505: {
    /* n:"BrtBeginDXFs", */
    T: 1
  },
  /*::[*/
  506: {
    /* n:"BrtEndDXFs", */
    T: -1
  },
  /*::[*/
  507: {
    /* n:"BrtDXF" */
  },
  /*::[*/
  508: {
    /* n:"BrtBeginTableStyles", */
    T: 1
  },
  /*::[*/
  509: {
    /* n:"BrtEndTableStyles", */
    T: -1
  },
  /*::[*/
  510: {
    /* n:"BrtBeginTableStyle", */
    T: 1
  },
  /*::[*/
  511: {
    /* n:"BrtEndTableStyle", */
    T: -1
  },
  /*::[*/
  512: {
    /* n:"BrtTableStyleElement" */
  },
  /*::[*/
  513: {
    /* n:"BrtTableStyleClient" */
  },
  /*::[*/
  514: {
    /* n:"BrtBeginVolDeps", */
    T: 1
  },
  /*::[*/
  515: {
    /* n:"BrtEndVolDeps", */
    T: -1
  },
  /*::[*/
  516: {
    /* n:"BrtBeginVolType", */
    T: 1
  },
  /*::[*/
  517: {
    /* n:"BrtEndVolType", */
    T: -1
  },
  /*::[*/
  518: {
    /* n:"BrtBeginVolMain", */
    T: 1
  },
  /*::[*/
  519: {
    /* n:"BrtEndVolMain", */
    T: -1
  },
  /*::[*/
  520: {
    /* n:"BrtBeginVolTopic", */
    T: 1
  },
  /*::[*/
  521: {
    /* n:"BrtEndVolTopic", */
    T: -1
  },
  /*::[*/
  522: {
    /* n:"BrtVolSubtopic" */
  },
  /*::[*/
  523: {
    /* n:"BrtVolRef" */
  },
  /*::[*/
  524: {
    /* n:"BrtVolNum" */
  },
  /*::[*/
  525: {
    /* n:"BrtVolErr" */
  },
  /*::[*/
  526: {
    /* n:"BrtVolStr" */
  },
  /*::[*/
  527: {
    /* n:"BrtVolBool" */
  },
  /*::[*/
  528: {
    /* n:"BrtBeginCalcChain$", */
    T: 1
  },
  /*::[*/
  529: {
    /* n:"BrtEndCalcChain$", */
    T: -1
  },
  /*::[*/
  530: {
    /* n:"BrtBeginSortState", */
    T: 1
  },
  /*::[*/
  531: {
    /* n:"BrtEndSortState", */
    T: -1
  },
  /*::[*/
  532: {
    /* n:"BrtBeginSortCond", */
    T: 1
  },
  /*::[*/
  533: {
    /* n:"BrtEndSortCond", */
    T: -1
  },
  /*::[*/
  534: {
    /* n:"BrtBookProtection" */
  },
  /*::[*/
  535: {
    /* n:"BrtSheetProtection" */
  },
  /*::[*/
  536: {
    /* n:"BrtRangeProtection" */
  },
  /*::[*/
  537: {
    /* n:"BrtPhoneticInfo" */
  },
  /*::[*/
  538: {
    /* n:"BrtBeginECTxtWiz", */
    T: 1
  },
  /*::[*/
  539: {
    /* n:"BrtEndECTxtWiz", */
    T: -1
  },
  /*::[*/
  540: {
    /* n:"BrtBeginECTWFldInfoLst", */
    T: 1
  },
  /*::[*/
  541: {
    /* n:"BrtEndECTWFldInfoLst", */
    T: -1
  },
  /*::[*/
  542: {
    /* n:"BrtBeginECTwFldInfo", */
    T: 1
  },
  /*::[*/
  548: {
    /* n:"BrtFileSharing" */
  },
  /*::[*/
  549: {
    /* n:"BrtOleSize" */
  },
  /*::[*/
  550: {
    /* n:"BrtDrawing", */
    f: parse_RelID
  },
  /*::[*/
  551: {
    /* n:"BrtLegacyDrawing" */
  },
  /*::[*/
  552: {
    /* n:"BrtLegacyDrawingHF" */
  },
  /*::[*/
  553: {
    /* n:"BrtWebOpt" */
  },
  /*::[*/
  554: {
    /* n:"BrtBeginWebPubItems", */
    T: 1
  },
  /*::[*/
  555: {
    /* n:"BrtEndWebPubItems", */
    T: -1
  },
  /*::[*/
  556: {
    /* n:"BrtBeginWebPubItem", */
    T: 1
  },
  /*::[*/
  557: {
    /* n:"BrtEndWebPubItem", */
    T: -1
  },
  /*::[*/
  558: {
    /* n:"BrtBeginSXCondFmt", */
    T: 1
  },
  /*::[*/
  559: {
    /* n:"BrtEndSXCondFmt", */
    T: -1
  },
  /*::[*/
  560: {
    /* n:"BrtBeginSXCondFmts", */
    T: 1
  },
  /*::[*/
  561: {
    /* n:"BrtEndSXCondFmts", */
    T: -1
  },
  /*::[*/
  562: {
    /* n:"BrtBkHim" */
  },
  /*::[*/
  564: {
    /* n:"BrtColor" */
  },
  /*::[*/
  565: {
    /* n:"BrtBeginIndexedColors", */
    T: 1
  },
  /*::[*/
  566: {
    /* n:"BrtEndIndexedColors", */
    T: -1
  },
  /*::[*/
  569: {
    /* n:"BrtBeginMRUColors", */
    T: 1
  },
  /*::[*/
  570: {
    /* n:"BrtEndMRUColors", */
    T: -1
  },
  /*::[*/
  572: {
    /* n:"BrtMRUColor" */
  },
  /*::[*/
  573: {
    /* n:"BrtBeginDVals", */
    T: 1
  },
  /*::[*/
  574: {
    /* n:"BrtEndDVals", */
    T: -1
  },
  /*::[*/
  577: {
    /* n:"BrtSupNameStart" */
  },
  /*::[*/
  578: {
    /* n:"BrtSupNameValueStart" */
  },
  /*::[*/
  579: {
    /* n:"BrtSupNameValueEnd" */
  },
  /*::[*/
  580: {
    /* n:"BrtSupNameNum" */
  },
  /*::[*/
  581: {
    /* n:"BrtSupNameErr" */
  },
  /*::[*/
  582: {
    /* n:"BrtSupNameSt" */
  },
  /*::[*/
  583: {
    /* n:"BrtSupNameNil" */
  },
  /*::[*/
  584: {
    /* n:"BrtSupNameBool" */
  },
  /*::[*/
  585: {
    /* n:"BrtSupNameFmla" */
  },
  /*::[*/
  586: {
    /* n:"BrtSupNameBits" */
  },
  /*::[*/
  587: {
    /* n:"BrtSupNameEnd" */
  },
  /*::[*/
  588: {
    /* n:"BrtEndSupBook", */
    T: -1
  },
  /*::[*/
  589: {
    /* n:"BrtCellSmartTagProperty" */
  },
  /*::[*/
  590: {
    /* n:"BrtBeginCellSmartTag", */
    T: 1
  },
  /*::[*/
  591: {
    /* n:"BrtEndCellSmartTag", */
    T: -1
  },
  /*::[*/
  592: {
    /* n:"BrtBeginCellSmartTags", */
    T: 1
  },
  /*::[*/
  593: {
    /* n:"BrtEndCellSmartTags", */
    T: -1
  },
  /*::[*/
  594: {
    /* n:"BrtBeginSmartTags", */
    T: 1
  },
  /*::[*/
  595: {
    /* n:"BrtEndSmartTags", */
    T: -1
  },
  /*::[*/
  596: {
    /* n:"BrtSmartTagType" */
  },
  /*::[*/
  597: {
    /* n:"BrtBeginSmartTagTypes", */
    T: 1
  },
  /*::[*/
  598: {
    /* n:"BrtEndSmartTagTypes", */
    T: -1
  },
  /*::[*/
  599: {
    /* n:"BrtBeginSXFilters", */
    T: 1
  },
  /*::[*/
  600: {
    /* n:"BrtEndSXFilters", */
    T: -1
  },
  /*::[*/
  601: {
    /* n:"BrtBeginSXFILTER", */
    T: 1
  },
  /*::[*/
  602: {
    /* n:"BrtEndSXFilter", */
    T: -1
  },
  /*::[*/
  603: {
    /* n:"BrtBeginFills", */
    T: 1
  },
  /*::[*/
  604: {
    /* n:"BrtEndFills", */
    T: -1
  },
  /*::[*/
  605: {
    /* n:"BrtBeginCellWatches", */
    T: 1
  },
  /*::[*/
  606: {
    /* n:"BrtEndCellWatches", */
    T: -1
  },
  /*::[*/
  607: {
    /* n:"BrtCellWatch" */
  },
  /*::[*/
  608: {
    /* n:"BrtBeginCRErrs", */
    T: 1
  },
  /*::[*/
  609: {
    /* n:"BrtEndCRErrs", */
    T: -1
  },
  /*::[*/
  610: {
    /* n:"BrtCrashRecErr" */
  },
  /*::[*/
  611: {
    /* n:"BrtBeginFonts", */
    T: 1
  },
  /*::[*/
  612: {
    /* n:"BrtEndFonts", */
    T: -1
  },
  /*::[*/
  613: {
    /* n:"BrtBeginBorders", */
    T: 1
  },
  /*::[*/
  614: {
    /* n:"BrtEndBorders", */
    T: -1
  },
  /*::[*/
  615: {
    /* n:"BrtBeginFmts", */
    T: 1
  },
  /*::[*/
  616: {
    /* n:"BrtEndFmts", */
    T: -1
  },
  /*::[*/
  617: {
    /* n:"BrtBeginCellXFs", */
    T: 1
  },
  /*::[*/
  618: {
    /* n:"BrtEndCellXFs", */
    T: -1
  },
  /*::[*/
  619: {
    /* n:"BrtBeginStyles", */
    T: 1
  },
  /*::[*/
  620: {
    /* n:"BrtEndStyles", */
    T: -1
  },
  /*::[*/
  625: {
    /* n:"BrtBigName" */
  },
  /*::[*/
  626: {
    /* n:"BrtBeginCellStyleXFs", */
    T: 1
  },
  /*::[*/
  627: {
    /* n:"BrtEndCellStyleXFs", */
    T: -1
  },
  /*::[*/
  628: {
    /* n:"BrtBeginComments", */
    T: 1
  },
  /*::[*/
  629: {
    /* n:"BrtEndComments", */
    T: -1
  },
  /*::[*/
  630: {
    /* n:"BrtBeginCommentAuthors", */
    T: 1
  },
  /*::[*/
  631: {
    /* n:"BrtEndCommentAuthors", */
    T: -1
  },
  /*::[*/
  632: {
    /* n:"BrtCommentAuthor", */
    f: parse_BrtCommentAuthor
  },
  /*::[*/
  633: {
    /* n:"BrtBeginCommentList", */
    T: 1
  },
  /*::[*/
  634: {
    /* n:"BrtEndCommentList", */
    T: -1
  },
  /*::[*/
  635: {
    /* n:"BrtBeginComment", */
    T: 1,
    f: parse_BrtBeginComment
  },
  /*::[*/
  636: {
    /* n:"BrtEndComment", */
    T: -1
  },
  /*::[*/
  637: {
    /* n:"BrtCommentText", */
    f: parse_BrtCommentText
  },
  /*::[*/
  638: {
    /* n:"BrtBeginOleObjects", */
    T: 1
  },
  /*::[*/
  639: {
    /* n:"BrtOleObject" */
  },
  /*::[*/
  640: {
    /* n:"BrtEndOleObjects", */
    T: -1
  },
  /*::[*/
  641: {
    /* n:"BrtBeginSxrules", */
    T: 1
  },
  /*::[*/
  642: {
    /* n:"BrtEndSxRules", */
    T: -1
  },
  /*::[*/
  643: {
    /* n:"BrtBeginActiveXControls", */
    T: 1
  },
  /*::[*/
  644: {
    /* n:"BrtActiveX" */
  },
  /*::[*/
  645: {
    /* n:"BrtEndActiveXControls", */
    T: -1
  },
  /*::[*/
  646: {
    /* n:"BrtBeginPCDSDTCEMembersSortBy", */
    T: 1
  },
  /*::[*/
  648: {
    /* n:"BrtBeginCellIgnoreECs", */
    T: 1
  },
  /*::[*/
  649: {
    /* n:"BrtCellIgnoreEC" */
  },
  /*::[*/
  650: {
    /* n:"BrtEndCellIgnoreECs", */
    T: -1
  },
  /*::[*/
  651: {
    /* n:"BrtCsProp", */
    f: parse_BrtCsProp
  },
  /*::[*/
  652: {
    /* n:"BrtCsPageSetup" */
  },
  /*::[*/
  653: {
    /* n:"BrtBeginUserCsViews", */
    T: 1
  },
  /*::[*/
  654: {
    /* n:"BrtEndUserCsViews", */
    T: -1
  },
  /*::[*/
  655: {
    /* n:"BrtBeginUserCsView", */
    T: 1
  },
  /*::[*/
  656: {
    /* n:"BrtEndUserCsView", */
    T: -1
  },
  /*::[*/
  657: {
    /* n:"BrtBeginPcdSFCIEntries", */
    T: 1
  },
  /*::[*/
  658: {
    /* n:"BrtEndPCDSFCIEntries", */
    T: -1
  },
  /*::[*/
  659: {
    /* n:"BrtPCDSFCIEntry" */
  },
  /*::[*/
  660: {
    /* n:"BrtBeginListParts", */
    T: 1
  },
  /*::[*/
  661: {
    /* n:"BrtListPart" */
  },
  /*::[*/
  662: {
    /* n:"BrtEndListParts", */
    T: -1
  },
  /*::[*/
  663: {
    /* n:"BrtSheetCalcProp" */
  },
  /*::[*/
  664: {
    /* n:"BrtBeginFnGroup", */
    T: 1
  },
  /*::[*/
  665: {
    /* n:"BrtFnGroup" */
  },
  /*::[*/
  666: {
    /* n:"BrtEndFnGroup", */
    T: -1
  },
  /*::[*/
  667: {
    /* n:"BrtSupAddin" */
  },
  /*::[*/
  668: {
    /* n:"BrtSXTDMPOrder" */
  },
  /*::[*/
  669: {
    /* n:"BrtCsProtection" */
  },
  /*::[*/
  671: {
    /* n:"BrtBeginWsSortMap", */
    T: 1
  },
  /*::[*/
  672: {
    /* n:"BrtEndWsSortMap", */
    T: -1
  },
  /*::[*/
  673: {
    /* n:"BrtBeginRRSort", */
    T: 1
  },
  /*::[*/
  674: {
    /* n:"BrtEndRRSort", */
    T: -1
  },
  /*::[*/
  675: {
    /* n:"BrtRRSortItem" */
  },
  /*::[*/
  676: {
    /* n:"BrtFileSharingIso" */
  },
  /*::[*/
  677: {
    /* n:"BrtBookProtectionIso" */
  },
  /*::[*/
  678: {
    /* n:"BrtSheetProtectionIso" */
  },
  /*::[*/
  679: {
    /* n:"BrtCsProtectionIso" */
  },
  /*::[*/
  680: {
    /* n:"BrtRangeProtectionIso" */
  },
  /*::[*/
  681: {
    /* n:"BrtDValList" */
  },
  /*::[*/
  1024: {
    /* n:"BrtRwDescent" */
  },
  /*::[*/
  1025: {
    /* n:"BrtKnownFonts" */
  },
  /*::[*/
  1026: {
    /* n:"BrtBeginSXTupleSet", */
    T: 1
  },
  /*::[*/
  1027: {
    /* n:"BrtEndSXTupleSet", */
    T: -1
  },
  /*::[*/
  1028: {
    /* n:"BrtBeginSXTupleSetHeader", */
    T: 1
  },
  /*::[*/
  1029: {
    /* n:"BrtEndSXTupleSetHeader", */
    T: -1
  },
  /*::[*/
  1030: {
    /* n:"BrtSXTupleSetHeaderItem" */
  },
  /*::[*/
  1031: {
    /* n:"BrtBeginSXTupleSetData", */
    T: 1
  },
  /*::[*/
  1032: {
    /* n:"BrtEndSXTupleSetData", */
    T: -1
  },
  /*::[*/
  1033: {
    /* n:"BrtBeginSXTupleSetRow", */
    T: 1
  },
  /*::[*/
  1034: {
    /* n:"BrtEndSXTupleSetRow", */
    T: -1
  },
  /*::[*/
  1035: {
    /* n:"BrtSXTupleSetRowItem" */
  },
  /*::[*/
  1036: {
    /* n:"BrtNameExt" */
  },
  /*::[*/
  1037: {
    /* n:"BrtPCDH14" */
  },
  /*::[*/
  1038: {
    /* n:"BrtBeginPCDCalcMem14", */
    T: 1
  },
  /*::[*/
  1039: {
    /* n:"BrtEndPCDCalcMem14", */
    T: -1
  },
  /*::[*/
  1040: {
    /* n:"BrtSXTH14" */
  },
  /*::[*/
  1041: {
    /* n:"BrtBeginSparklineGroup", */
    T: 1
  },
  /*::[*/
  1042: {
    /* n:"BrtEndSparklineGroup", */
    T: -1
  },
  /*::[*/
  1043: {
    /* n:"BrtSparkline" */
  },
  /*::[*/
  1044: {
    /* n:"BrtSXDI14" */
  },
  /*::[*/
  1045: {
    /* n:"BrtWsFmtInfoEx14" */
  },
  /*::[*/
  1046: {
    /* n:"BrtBeginConditionalFormatting14", */
    T: 1
  },
  /*::[*/
  1047: {
    /* n:"BrtEndConditionalFormatting14", */
    T: -1
  },
  /*::[*/
  1048: {
    /* n:"BrtBeginCFRule14", */
    T: 1
  },
  /*::[*/
  1049: {
    /* n:"BrtEndCFRule14", */
    T: -1
  },
  /*::[*/
  1050: {
    /* n:"BrtCFVO14" */
  },
  /*::[*/
  1051: {
    /* n:"BrtBeginDatabar14", */
    T: 1
  },
  /*::[*/
  1052: {
    /* n:"BrtBeginIconSet14", */
    T: 1
  },
  /*::[*/
  1053: {
    /* n:"BrtDVal14", */
    f: parse_BrtDVal14
  },
  /*::[*/
  1054: {
    /* n:"BrtBeginDVals14", */
    T: 1
  },
  /*::[*/
  1055: {
    /* n:"BrtColor14" */
  },
  /*::[*/
  1056: {
    /* n:"BrtBeginSparklines", */
    T: 1
  },
  /*::[*/
  1057: {
    /* n:"BrtEndSparklines", */
    T: -1
  },
  /*::[*/
  1058: {
    /* n:"BrtBeginSparklineGroups", */
    T: 1
  },
  /*::[*/
  1059: {
    /* n:"BrtEndSparklineGroups", */
    T: -1
  },
  /*::[*/
  1061: {
    /* n:"BrtSXVD14" */
  },
  /*::[*/
  1062: {
    /* n:"BrtBeginSXView14", */
    T: 1
  },
  /*::[*/
  1063: {
    /* n:"BrtEndSXView14", */
    T: -1
  },
  /*::[*/
  1064: {
    /* n:"BrtBeginSXView16", */
    T: 1
  },
  /*::[*/
  1065: {
    /* n:"BrtEndSXView16", */
    T: -1
  },
  /*::[*/
  1066: {
    /* n:"BrtBeginPCD14", */
    T: 1
  },
  /*::[*/
  1067: {
    /* n:"BrtEndPCD14", */
    T: -1
  },
  /*::[*/
  1068: {
    /* n:"BrtBeginExtConn14", */
    T: 1
  },
  /*::[*/
  1069: {
    /* n:"BrtEndExtConn14", */
    T: -1
  },
  /*::[*/
  1070: {
    /* n:"BrtBeginSlicerCacheIDs", */
    T: 1
  },
  /*::[*/
  1071: {
    /* n:"BrtEndSlicerCacheIDs", */
    T: -1
  },
  /*::[*/
  1072: {
    /* n:"BrtBeginSlicerCacheID", */
    T: 1
  },
  /*::[*/
  1073: {
    /* n:"BrtEndSlicerCacheID", */
    T: -1
  },
  /*::[*/
  1075: {
    /* n:"BrtBeginSlicerCache", */
    T: 1
  },
  /*::[*/
  1076: {
    /* n:"BrtEndSlicerCache", */
    T: -1
  },
  /*::[*/
  1077: {
    /* n:"BrtBeginSlicerCacheDef", */
    T: 1
  },
  /*::[*/
  1078: {
    /* n:"BrtEndSlicerCacheDef", */
    T: -1
  },
  /*::[*/
  1079: {
    /* n:"BrtBeginSlicersEx", */
    T: 1
  },
  /*::[*/
  1080: {
    /* n:"BrtEndSlicersEx", */
    T: -1
  },
  /*::[*/
  1081: {
    /* n:"BrtBeginSlicerEx", */
    T: 1
  },
  /*::[*/
  1082: {
    /* n:"BrtEndSlicerEx", */
    T: -1
  },
  /*::[*/
  1083: {
    /* n:"BrtBeginSlicer", */
    T: 1
  },
  /*::[*/
  1084: {
    /* n:"BrtEndSlicer", */
    T: -1
  },
  /*::[*/
  1085: {
    /* n:"BrtSlicerCachePivotTables" */
  },
  /*::[*/
  1086: {
    /* n:"BrtBeginSlicerCacheOlapImpl", */
    T: 1
  },
  /*::[*/
  1087: {
    /* n:"BrtEndSlicerCacheOlapImpl", */
    T: -1
  },
  /*::[*/
  1088: {
    /* n:"BrtBeginSlicerCacheLevelsData", */
    T: 1
  },
  /*::[*/
  1089: {
    /* n:"BrtEndSlicerCacheLevelsData", */
    T: -1
  },
  /*::[*/
  1090: {
    /* n:"BrtBeginSlicerCacheLevelData", */
    T: 1
  },
  /*::[*/
  1091: {
    /* n:"BrtEndSlicerCacheLevelData", */
    T: -1
  },
  /*::[*/
  1092: {
    /* n:"BrtBeginSlicerCacheSiRanges", */
    T: 1
  },
  /*::[*/
  1093: {
    /* n:"BrtEndSlicerCacheSiRanges", */
    T: -1
  },
  /*::[*/
  1094: {
    /* n:"BrtBeginSlicerCacheSiRange", */
    T: 1
  },
  /*::[*/
  1095: {
    /* n:"BrtEndSlicerCacheSiRange", */
    T: -1
  },
  /*::[*/
  1096: {
    /* n:"BrtSlicerCacheOlapItem" */
  },
  /*::[*/
  1097: {
    /* n:"BrtBeginSlicerCacheSelections", */
    T: 1
  },
  /*::[*/
  1098: {
    /* n:"BrtSlicerCacheSelection" */
  },
  /*::[*/
  1099: {
    /* n:"BrtEndSlicerCacheSelections", */
    T: -1
  },
  /*::[*/
  1100: {
    /* n:"BrtBeginSlicerCacheNative", */
    T: 1
  },
  /*::[*/
  1101: {
    /* n:"BrtEndSlicerCacheNative", */
    T: -1
  },
  /*::[*/
  1102: {
    /* n:"BrtSlicerCacheNativeItem" */
  },
  /*::[*/
  1103: {
    /* n:"BrtRangeProtection14" */
  },
  /*::[*/
  1104: {
    /* n:"BrtRangeProtectionIso14" */
  },
  /*::[*/
  1105: {
    /* n:"BrtCellIgnoreEC14" */
  },
  /*::[*/
  1111: {
    /* n:"BrtList14" */
  },
  /*::[*/
  1112: {
    /* n:"BrtCFIcon" */
  },
  /*::[*/
  1113: {
    /* n:"BrtBeginSlicerCachesPivotCacheIDs", */
    T: 1
  },
  /*::[*/
  1114: {
    /* n:"BrtEndSlicerCachesPivotCacheIDs", */
    T: -1
  },
  /*::[*/
  1115: {
    /* n:"BrtBeginSlicers", */
    T: 1
  },
  /*::[*/
  1116: {
    /* n:"BrtEndSlicers", */
    T: -1
  },
  /*::[*/
  1117: {
    /* n:"BrtWbProp14" */
  },
  /*::[*/
  1118: {
    /* n:"BrtBeginSXEdit", */
    T: 1
  },
  /*::[*/
  1119: {
    /* n:"BrtEndSXEdit", */
    T: -1
  },
  /*::[*/
  1120: {
    /* n:"BrtBeginSXEdits", */
    T: 1
  },
  /*::[*/
  1121: {
    /* n:"BrtEndSXEdits", */
    T: -1
  },
  /*::[*/
  1122: {
    /* n:"BrtBeginSXChange", */
    T: 1
  },
  /*::[*/
  1123: {
    /* n:"BrtEndSXChange", */
    T: -1
  },
  /*::[*/
  1124: {
    /* n:"BrtBeginSXChanges", */
    T: 1
  },
  /*::[*/
  1125: {
    /* n:"BrtEndSXChanges", */
    T: -1
  },
  /*::[*/
  1126: {
    /* n:"BrtSXTupleItems" */
  },
  /*::[*/
  1128: {
    /* n:"BrtBeginSlicerStyle", */
    T: 1
  },
  /*::[*/
  1129: {
    /* n:"BrtEndSlicerStyle", */
    T: -1
  },
  /*::[*/
  1130: {
    /* n:"BrtSlicerStyleElement" */
  },
  /*::[*/
  1131: {
    /* n:"BrtBeginStyleSheetExt14", */
    T: 1
  },
  /*::[*/
  1132: {
    /* n:"BrtEndStyleSheetExt14", */
    T: -1
  },
  /*::[*/
  1133: {
    /* n:"BrtBeginSlicerCachesPivotCacheID", */
    T: 1
  },
  /*::[*/
  1134: {
    /* n:"BrtEndSlicerCachesPivotCacheID", */
    T: -1
  },
  /*::[*/
  1135: {
    /* n:"BrtBeginConditionalFormattings", */
    T: 1
  },
  /*::[*/
  1136: {
    /* n:"BrtEndConditionalFormattings", */
    T: -1
  },
  /*::[*/
  1137: {
    /* n:"BrtBeginPCDCalcMemExt", */
    T: 1
  },
  /*::[*/
  1138: {
    /* n:"BrtEndPCDCalcMemExt", */
    T: -1
  },
  /*::[*/
  1139: {
    /* n:"BrtBeginPCDCalcMemsExt", */
    T: 1
  },
  /*::[*/
  1140: {
    /* n:"BrtEndPCDCalcMemsExt", */
    T: -1
  },
  /*::[*/
  1141: {
    /* n:"BrtPCDField14" */
  },
  /*::[*/
  1142: {
    /* n:"BrtBeginSlicerStyles", */
    T: 1
  },
  /*::[*/
  1143: {
    /* n:"BrtEndSlicerStyles", */
    T: -1
  },
  /*::[*/
  1144: {
    /* n:"BrtBeginSlicerStyleElements", */
    T: 1
  },
  /*::[*/
  1145: {
    /* n:"BrtEndSlicerStyleElements", */
    T: -1
  },
  /*::[*/
  1146: {
    /* n:"BrtCFRuleExt" */
  },
  /*::[*/
  1147: {
    /* n:"BrtBeginSXCondFmt14", */
    T: 1
  },
  /*::[*/
  1148: {
    /* n:"BrtEndSXCondFmt14", */
    T: -1
  },
  /*::[*/
  1149: {
    /* n:"BrtBeginSXCondFmts14", */
    T: 1
  },
  /*::[*/
  1150: {
    /* n:"BrtEndSXCondFmts14", */
    T: -1
  },
  /*::[*/
  1152: {
    /* n:"BrtBeginSortCond14", */
    T: 1
  },
  /*::[*/
  1153: {
    /* n:"BrtEndSortCond14", */
    T: -1
  },
  /*::[*/
  1154: {
    /* n:"BrtEndDVals14", */
    T: -1
  },
  /*::[*/
  1155: {
    /* n:"BrtEndIconSet14", */
    T: -1
  },
  /*::[*/
  1156: {
    /* n:"BrtEndDatabar14", */
    T: -1
  },
  /*::[*/
  1157: {
    /* n:"BrtBeginColorScale14", */
    T: 1
  },
  /*::[*/
  1158: {
    /* n:"BrtEndColorScale14", */
    T: -1
  },
  /*::[*/
  1159: {
    /* n:"BrtBeginSxrules14", */
    T: 1
  },
  /*::[*/
  1160: {
    /* n:"BrtEndSxrules14", */
    T: -1
  },
  /*::[*/
  1161: {
    /* n:"BrtBeginPRule14", */
    T: 1
  },
  /*::[*/
  1162: {
    /* n:"BrtEndPRule14", */
    T: -1
  },
  /*::[*/
  1163: {
    /* n:"BrtBeginPRFilters14", */
    T: 1
  },
  /*::[*/
  1164: {
    /* n:"BrtEndPRFilters14", */
    T: -1
  },
  /*::[*/
  1165: {
    /* n:"BrtBeginPRFilter14", */
    T: 1
  },
  /*::[*/
  1166: {
    /* n:"BrtEndPRFilter14", */
    T: -1
  },
  /*::[*/
  1167: {
    /* n:"BrtBeginPRFItem14", */
    T: 1
  },
  /*::[*/
  1168: {
    /* n:"BrtEndPRFItem14", */
    T: -1
  },
  /*::[*/
  1169: {
    /* n:"BrtBeginCellIgnoreECs14", */
    T: 1
  },
  /*::[*/
  1170: {
    /* n:"BrtEndCellIgnoreECs14", */
    T: -1
  },
  /*::[*/
  1171: {
    /* n:"BrtDxf14" */
  },
  /*::[*/
  1172: {
    /* n:"BrtBeginDxF14s", */
    T: 1
  },
  /*::[*/
  1173: {
    /* n:"BrtEndDxf14s", */
    T: -1
  },
  /*::[*/
  1177: {
    /* n:"BrtFilter14" */
  },
  /*::[*/
  1178: {
    /* n:"BrtBeginCustomFilters14", */
    T: 1
  },
  /*::[*/
  1180: {
    /* n:"BrtCustomFilter14" */
  },
  /*::[*/
  1181: {
    /* n:"BrtIconFilter14" */
  },
  /*::[*/
  1182: {
    /* n:"BrtPivotCacheConnectionName" */
  },
  /*::[*/
  2048: {
    /* n:"BrtBeginDecoupledPivotCacheIDs", */
    T: 1
  },
  /*::[*/
  2049: {
    /* n:"BrtEndDecoupledPivotCacheIDs", */
    T: -1
  },
  /*::[*/
  2050: {
    /* n:"BrtDecoupledPivotCacheID" */
  },
  /*::[*/
  2051: {
    /* n:"BrtBeginPivotTableRefs", */
    T: 1
  },
  /*::[*/
  2052: {
    /* n:"BrtEndPivotTableRefs", */
    T: -1
  },
  /*::[*/
  2053: {
    /* n:"BrtPivotTableRef" */
  },
  /*::[*/
  2054: {
    /* n:"BrtSlicerCacheBookPivotTables" */
  },
  /*::[*/
  2055: {
    /* n:"BrtBeginSxvcells", */
    T: 1
  },
  /*::[*/
  2056: {
    /* n:"BrtEndSxvcells", */
    T: -1
  },
  /*::[*/
  2057: {
    /* n:"BrtBeginSxRow", */
    T: 1
  },
  /*::[*/
  2058: {
    /* n:"BrtEndSxRow", */
    T: -1
  },
  /*::[*/
  2060: {
    /* n:"BrtPcdCalcMem15" */
  },
  /*::[*/
  2067: {
    /* n:"BrtQsi15" */
  },
  /*::[*/
  2068: {
    /* n:"BrtBeginWebExtensions", */
    T: 1
  },
  /*::[*/
  2069: {
    /* n:"BrtEndWebExtensions", */
    T: -1
  },
  /*::[*/
  2070: {
    /* n:"BrtWebExtension" */
  },
  /*::[*/
  2071: {
    /* n:"BrtAbsPath15" */
  },
  /*::[*/
  2072: {
    /* n:"BrtBeginPivotTableUISettings", */
    T: 1
  },
  /*::[*/
  2073: {
    /* n:"BrtEndPivotTableUISettings", */
    T: -1
  },
  /*::[*/
  2075: {
    /* n:"BrtTableSlicerCacheIDs" */
  },
  /*::[*/
  2076: {
    /* n:"BrtTableSlicerCacheID" */
  },
  /*::[*/
  2077: {
    /* n:"BrtBeginTableSlicerCache", */
    T: 1
  },
  /*::[*/
  2078: {
    /* n:"BrtEndTableSlicerCache", */
    T: -1
  },
  /*::[*/
  2079: {
    /* n:"BrtSxFilter15" */
  },
  /*::[*/
  2080: {
    /* n:"BrtBeginTimelineCachePivotCacheIDs", */
    T: 1
  },
  /*::[*/
  2081: {
    /* n:"BrtEndTimelineCachePivotCacheIDs", */
    T: -1
  },
  /*::[*/
  2082: {
    /* n:"BrtTimelineCachePivotCacheID" */
  },
  /*::[*/
  2083: {
    /* n:"BrtBeginTimelineCacheIDs", */
    T: 1
  },
  /*::[*/
  2084: {
    /* n:"BrtEndTimelineCacheIDs", */
    T: -1
  },
  /*::[*/
  2085: {
    /* n:"BrtBeginTimelineCacheID", */
    T: 1
  },
  /*::[*/
  2086: {
    /* n:"BrtEndTimelineCacheID", */
    T: -1
  },
  /*::[*/
  2087: {
    /* n:"BrtBeginTimelinesEx", */
    T: 1
  },
  /*::[*/
  2088: {
    /* n:"BrtEndTimelinesEx", */
    T: -1
  },
  /*::[*/
  2089: {
    /* n:"BrtBeginTimelineEx", */
    T: 1
  },
  /*::[*/
  2090: {
    /* n:"BrtEndTimelineEx", */
    T: -1
  },
  /*::[*/
  2091: {
    /* n:"BrtWorkBookPr15" */
  },
  /*::[*/
  2092: {
    /* n:"BrtPCDH15" */
  },
  /*::[*/
  2093: {
    /* n:"BrtBeginTimelineStyle", */
    T: 1
  },
  /*::[*/
  2094: {
    /* n:"BrtEndTimelineStyle", */
    T: -1
  },
  /*::[*/
  2095: {
    /* n:"BrtTimelineStyleElement" */
  },
  /*::[*/
  2096: {
    /* n:"BrtBeginTimelineStylesheetExt15", */
    T: 1
  },
  /*::[*/
  2097: {
    /* n:"BrtEndTimelineStylesheetExt15", */
    T: -1
  },
  /*::[*/
  2098: {
    /* n:"BrtBeginTimelineStyles", */
    T: 1
  },
  /*::[*/
  2099: {
    /* n:"BrtEndTimelineStyles", */
    T: -1
  },
  /*::[*/
  2100: {
    /* n:"BrtBeginTimelineStyleElements", */
    T: 1
  },
  /*::[*/
  2101: {
    /* n:"BrtEndTimelineStyleElements", */
    T: -1
  },
  /*::[*/
  2102: {
    /* n:"BrtDxf15" */
  },
  /*::[*/
  2103: {
    /* n:"BrtBeginDxfs15", */
    T: 1
  },
  /*::[*/
  2104: {
    /* n:"BrtEndDxfs15", */
    T: -1
  },
  /*::[*/
  2105: {
    /* n:"BrtSlicerCacheHideItemsWithNoData" */
  },
  /*::[*/
  2106: {
    /* n:"BrtBeginItemUniqueNames", */
    T: 1
  },
  /*::[*/
  2107: {
    /* n:"BrtEndItemUniqueNames", */
    T: -1
  },
  /*::[*/
  2108: {
    /* n:"BrtItemUniqueName" */
  },
  /*::[*/
  2109: {
    /* n:"BrtBeginExtConn15", */
    T: 1
  },
  /*::[*/
  2110: {
    /* n:"BrtEndExtConn15", */
    T: -1
  },
  /*::[*/
  2111: {
    /* n:"BrtBeginOledbPr15", */
    T: 1
  },
  /*::[*/
  2112: {
    /* n:"BrtEndOledbPr15", */
    T: -1
  },
  /*::[*/
  2113: {
    /* n:"BrtBeginDataFeedPr15", */
    T: 1
  },
  /*::[*/
  2114: {
    /* n:"BrtEndDataFeedPr15", */
    T: -1
  },
  /*::[*/
  2115: {
    /* n:"BrtTextPr15" */
  },
  /*::[*/
  2116: {
    /* n:"BrtRangePr15" */
  },
  /*::[*/
  2117: {
    /* n:"BrtDbCommand15" */
  },
  /*::[*/
  2118: {
    /* n:"BrtBeginDbTables15", */
    T: 1
  },
  /*::[*/
  2119: {
    /* n:"BrtEndDbTables15", */
    T: -1
  },
  /*::[*/
  2120: {
    /* n:"BrtDbTable15" */
  },
  /*::[*/
  2121: {
    /* n:"BrtBeginDataModel", */
    T: 1
  },
  /*::[*/
  2122: {
    /* n:"BrtEndDataModel", */
    T: -1
  },
  /*::[*/
  2123: {
    /* n:"BrtBeginModelTables", */
    T: 1
  },
  /*::[*/
  2124: {
    /* n:"BrtEndModelTables", */
    T: -1
  },
  /*::[*/
  2125: {
    /* n:"BrtModelTable" */
  },
  /*::[*/
  2126: {
    /* n:"BrtBeginModelRelationships", */
    T: 1
  },
  /*::[*/
  2127: {
    /* n:"BrtEndModelRelationships", */
    T: -1
  },
  /*::[*/
  2128: {
    /* n:"BrtModelRelationship" */
  },
  /*::[*/
  2129: {
    /* n:"BrtBeginECTxtWiz15", */
    T: 1
  },
  /*::[*/
  2130: {
    /* n:"BrtEndECTxtWiz15", */
    T: -1
  },
  /*::[*/
  2131: {
    /* n:"BrtBeginECTWFldInfoLst15", */
    T: 1
  },
  /*::[*/
  2132: {
    /* n:"BrtEndECTWFldInfoLst15", */
    T: -1
  },
  /*::[*/
  2133: {
    /* n:"BrtBeginECTWFldInfo15", */
    T: 1
  },
  /*::[*/
  2134: {
    /* n:"BrtFieldListActiveItem" */
  },
  /*::[*/
  2135: {
    /* n:"BrtPivotCacheIdVersion" */
  },
  /*::[*/
  2136: {
    /* n:"BrtSXDI15" */
  },
  /*::[*/
  2137: {
    /* n:"BrtBeginModelTimeGroupings", */
    T: 1
  },
  /*::[*/
  2138: {
    /* n:"BrtEndModelTimeGroupings", */
    T: -1
  },
  /*::[*/
  2139: {
    /* n:"BrtBeginModelTimeGrouping", */
    T: 1
  },
  /*::[*/
  2140: {
    /* n:"BrtEndModelTimeGrouping", */
    T: -1
  },
  /*::[*/
  2141: {
    /* n:"BrtModelTimeGroupingCalcCol" */
  },
  /*::[*/
  3072: {
    /* n:"BrtUid" */
  },
  /*::[*/
  3073: {
    /* n:"BrtRevisionPtr" */
  },
  /*::[*/
  4096: {
    /* n:"BrtBeginDynamicArrayPr", */
    T: 1
  },
  /*::[*/
  4097: {
    /* n:"BrtEndDynamicArrayPr", */
    T: -1
  },
  /*::[*/
  5002: {
    /* n:"BrtBeginRichValueBlock", */
    T: 1
  },
  /*::[*/
  5003: {
    /* n:"BrtEndRichValueBlock", */
    T: -1
  },
  /*::[*/
  5081: {
    /* n:"BrtBeginRichFilters", */
    T: 1
  },
  /*::[*/
  5082: {
    /* n:"BrtEndRichFilters", */
    T: -1
  },
  /*::[*/
  5083: {
    /* n:"BrtRichFilter" */
  },
  /*::[*/
  5084: {
    /* n:"BrtBeginRichFilterColumn", */
    T: 1
  },
  /*::[*/
  5085: {
    /* n:"BrtEndRichFilterColumn", */
    T: -1
  },
  /*::[*/
  5086: {
    /* n:"BrtBeginCustomRichFilters", */
    T: 1
  },
  /*::[*/
  5087: {
    /* n:"BrtEndCustomRichFilters", */
    T: -1
  },
  /*::[*/
  5088: {
    /* n:"BrtCustomRichFilter" */
  },
  /*::[*/
  5089: {
    /* n:"BrtTop10RichFilter" */
  },
  /*::[*/
  5090: {
    /* n:"BrtDynamicRichFilter" */
  },
  /*::[*/
  5092: {
    /* n:"BrtBeginRichSortCondition", */
    T: 1
  },
  /*::[*/
  5093: {
    /* n:"BrtEndRichSortCondition", */
    T: -1
  },
  /*::[*/
  5094: {
    /* n:"BrtRichFilterDateGroupItem" */
  },
  /*::[*/
  5095: {
    /* n:"BrtBeginCalcFeatures", */
    T: 1
  },
  /*::[*/
  5096: {
    /* n:"BrtEndCalcFeatures", */
    T: -1
  },
  /*::[*/
  5097: {
    /* n:"BrtCalcFeature" */
  },
  /*::[*/
  5099: {
    /* n:"BrtExternalLinksPr" */
  },
  /*::[*/
  65535: { n: "" }
};
var XLSRecordEnum = {
  /* [MS-XLS] 2.3 Record Enumeration 2021-08-17 */
  /*::[*/
  6: {
    /* n:"Formula", */
    f: parse_Formula
  },
  /*::[*/
  10: {
    /* n:"EOF", */
    f: parsenoop2
  },
  /*::[*/
  12: {
    /* n:"CalcCount", */
    f: parseuint16
  },
  //
  /*::[*/
  13: {
    /* n:"CalcMode", */
    f: parseuint16
  },
  //
  /*::[*/
  14: {
    /* n:"CalcPrecision", */
    f: parsebool
  },
  //
  /*::[*/
  15: {
    /* n:"CalcRefMode", */
    f: parsebool
  },
  //
  /*::[*/
  16: {
    /* n:"CalcDelta", */
    f: parse_Xnum
  },
  //
  /*::[*/
  17: {
    /* n:"CalcIter", */
    f: parsebool
  },
  //
  /*::[*/
  18: {
    /* n:"Protect", */
    f: parsebool
  },
  /*::[*/
  19: {
    /* n:"Password", */
    f: parseuint16
  },
  /*::[*/
  20: {
    /* n:"Header", */
    f: parse_XLHeaderFooter
  },
  /*::[*/
  21: {
    /* n:"Footer", */
    f: parse_XLHeaderFooter
  },
  /*::[*/
  23: {
    /* n:"ExternSheet", */
    f: parse_ExternSheet
  },
  /*::[*/
  24: {
    /* n:"Lbl", */
    f: parse_Lbl
  },
  /*::[*/
  25: {
    /* n:"WinProtect", */
    f: parsebool
  },
  /*::[*/
  26: {
    /* n:"VerticalPageBreaks", */
  },
  /*::[*/
  27: {
    /* n:"HorizontalPageBreaks", */
  },
  /*::[*/
  28: {
    /* n:"Note", */
    f: parse_Note
  },
  /*::[*/
  29: {
    /* n:"Selection", */
  },
  /*::[*/
  34: {
    /* n:"Date1904", */
    f: parsebool
  },
  /*::[*/
  35: {
    /* n:"ExternName", */
    f: parse_ExternName
  },
  /*::[*/
  38: {
    /* n:"LeftMargin", */
    f: parse_Xnum
  },
  // *
  /*::[*/
  39: {
    /* n:"RightMargin", */
    f: parse_Xnum
  },
  // *
  /*::[*/
  40: {
    /* n:"TopMargin", */
    f: parse_Xnum
  },
  // *
  /*::[*/
  41: {
    /* n:"BottomMargin", */
    f: parse_Xnum
  },
  // *
  /*::[*/
  42: {
    /* n:"PrintRowCol", */
    f: parsebool
  },
  /*::[*/
  43: {
    /* n:"PrintGrid", */
    f: parsebool
  },
  /*::[*/
  47: {
    /* n:"FilePass", */
    f: parse_FilePass
  },
  /*::[*/
  49: {
    /* n:"Font", */
    f: parse_Font
  },
  /*::[*/
  51: {
    /* n:"PrintSize", */
    f: parseuint16
  },
  /*::[*/
  60: {
    /* n:"Continue", */
  },
  /*::[*/
  61: {
    /* n:"Window1", */
    f: parse_Window1
  },
  /*::[*/
  64: {
    /* n:"Backup", */
    f: parsebool
  },
  /*::[*/
  65: {
    /* n:"Pane", */
    f: parse_Pane
  },
  /*::[*/
  66: {
    /* n:"CodePage", */
    f: parseuint16
  },
  /*::[*/
  77: {
    /* n:"Pls", */
  },
  /*::[*/
  80: {
    /* n:"DCon", */
  },
  /*::[*/
  81: {
    /* n:"DConRef", */
  },
  /*::[*/
  82: {
    /* n:"DConName", */
  },
  /*::[*/
  85: {
    /* n:"DefColWidth", */
    f: parseuint16
  },
  /*::[*/
  89: {
    /* n:"XCT", */
  },
  /*::[*/
  90: {
    /* n:"CRN", */
  },
  /*::[*/
  91: {
    /* n:"FileSharing", */
  },
  /*::[*/
  92: {
    /* n:"WriteAccess", */
    f: parse_WriteAccess
  },
  /*::[*/
  93: {
    /* n:"Obj", */
    f: parse_Obj
  },
  /*::[*/
  94: {
    /* n:"Uncalced", */
  },
  /*::[*/
  95: {
    /* n:"CalcSaveRecalc", */
    f: parsebool
  },
  //
  /*::[*/
  96: {
    /* n:"Template", */
  },
  /*::[*/
  97: {
    /* n:"Intl", */
  },
  /*::[*/
  99: {
    /* n:"ObjProtect", */
    f: parsebool
  },
  /*::[*/
  125: {
    /* n:"ColInfo", */
    f: parse_ColInfo
  },
  /*::[*/
  128: {
    /* n:"Guts", */
    f: parse_Guts
  },
  /*::[*/
  129: {
    /* n:"WsBool", */
    f: parse_WsBool
  },
  /*::[*/
  130: {
    /* n:"GridSet", */
    f: parseuint16
  },
  /*::[*/
  131: {
    /* n:"HCenter", */
    f: parsebool
  },
  /*::[*/
  132: {
    /* n:"VCenter", */
    f: parsebool
  },
  /*::[*/
  133: {
    /* n:"BoundSheet8", */
    f: parse_BoundSheet8
  },
  /*::[*/
  134: {
    /* n:"WriteProtect", */
  },
  /*::[*/
  140: {
    /* n:"Country", */
    f: parse_Country
  },
  /*::[*/
  141: {
    /* n:"HideObj", */
    f: parseuint16
  },
  /*::[*/
  144: {
    /* n:"Sort", */
  },
  /*::[*/
  146: {
    /* n:"Palette", */
    f: parse_Palette
  },
  /*::[*/
  151: {
    /* n:"Sync", */
  },
  /*::[*/
  152: {
    /* n:"LPr", */
  },
  /*::[*/
  153: {
    /* n:"DxGCol", */
  },
  /*::[*/
  154: {
    /* n:"FnGroupName", */
  },
  /*::[*/
  155: {
    /* n:"FilterMode", */
  },
  /*::[*/
  156: {
    /* n:"BuiltInFnGroupCount", */
    f: parseuint16
  },
  /*::[*/
  157: {
    /* n:"AutoFilterInfo", */
  },
  /*::[*/
  158: {
    /* n:"AutoFilter", */
  },
  /*::[*/
  160: {
    /* n:"Scl", */
    f: parse_Scl
  },
  /*::[*/
  161: {
    /* n:"Setup", */
    f: parse_Setup
  },
  /*::[*/
  174: {
    /* n:"ScenMan", */
  },
  /*::[*/
  175: {
    /* n:"SCENARIO", */
  },
  /*::[*/
  176: {
    /* n:"SxView", */
  },
  /*::[*/
  177: {
    /* n:"Sxvd", */
  },
  /*::[*/
  178: {
    /* n:"SXVI", */
  },
  /*::[*/
  180: {
    /* n:"SxIvd", */
  },
  /*::[*/
  181: {
    /* n:"SXLI", */
  },
  /*::[*/
  182: {
    /* n:"SXPI", */
  },
  /*::[*/
  184: {
    /* n:"DocRoute", */
  },
  /*::[*/
  185: {
    /* n:"RecipName", */
  },
  /*::[*/
  189: {
    /* n:"MulRk", */
    f: parse_MulRk
  },
  /*::[*/
  190: {
    /* n:"MulBlank", */
    f: parse_MulBlank
  },
  /*::[*/
  193: {
    /* n:"Mms", */
    f: parsenoop2
  },
  /*::[*/
  197: {
    /* n:"SXDI", */
  },
  /*::[*/
  198: {
    /* n:"SXDB", */
  },
  /*::[*/
  199: {
    /* n:"SXFDB", */
  },
  /*::[*/
  200: {
    /* n:"SXDBB", */
  },
  /*::[*/
  201: {
    /* n:"SXNum", */
  },
  /*::[*/
  202: {
    /* n:"SxBool", */
    f: parsebool
  },
  /*::[*/
  203: {
    /* n:"SxErr", */
  },
  /*::[*/
  204: {
    /* n:"SXInt", */
  },
  /*::[*/
  205: {
    /* n:"SXString", */
  },
  /*::[*/
  206: {
    /* n:"SXDtr", */
  },
  /*::[*/
  207: {
    /* n:"SxNil", */
  },
  /*::[*/
  208: {
    /* n:"SXTbl", */
  },
  /*::[*/
  209: {
    /* n:"SXTBRGIITM", */
  },
  /*::[*/
  210: {
    /* n:"SxTbpg", */
  },
  /*::[*/
  211: {
    /* n:"ObProj", */
  },
  /*::[*/
  213: {
    /* n:"SXStreamID", */
  },
  /*::[*/
  215: {
    /* n:"DBCell", */
  },
  /*::[*/
  216: {
    /* n:"SXRng", */
  },
  /*::[*/
  217: {
    /* n:"SxIsxoper", */
  },
  /*::[*/
  218: {
    /* n:"BookBool", */
    f: parseuint16
  },
  /*::[*/
  220: {
    /* n:"DbOrParamQry", */
  },
  /*::[*/
  221: {
    /* n:"ScenarioProtect", */
    f: parsebool
  },
  /*::[*/
  222: {
    /* n:"OleObjectSize", */
  },
  /*::[*/
  224: {
    /* n:"XF", */
    f: parse_XF
  },
  /*::[*/
  225: {
    /* n:"InterfaceHdr", */
    f: parse_InterfaceHdr
  },
  /*::[*/
  226: {
    /* n:"InterfaceEnd", */
    f: parsenoop2
  },
  /*::[*/
  227: {
    /* n:"SXVS", */
  },
  /*::[*/
  229: {
    /* n:"MergeCells", */
    f: parse_MergeCells
  },
  /*::[*/
  233: {
    /* n:"BkHim", */
  },
  /*::[*/
  235: {
    /* n:"MsoDrawingGroup", */
  },
  /*::[*/
  236: {
    /* n:"MsoDrawing", */
  },
  /*::[*/
  237: {
    /* n:"MsoDrawingSelection", */
  },
  /*::[*/
  239: {
    /* n:"PhoneticInfo", */
  },
  /*::[*/
  240: {
    /* n:"SxRule", */
  },
  /*::[*/
  241: {
    /* n:"SXEx", */
  },
  /*::[*/
  242: {
    /* n:"SxFilt", */
  },
  /*::[*/
  244: {
    /* n:"SxDXF", */
  },
  /*::[*/
  245: {
    /* n:"SxItm", */
  },
  /*::[*/
  246: {
    /* n:"SxName", */
  },
  /*::[*/
  247: {
    /* n:"SxSelect", */
  },
  /*::[*/
  248: {
    /* n:"SXPair", */
  },
  /*::[*/
  249: {
    /* n:"SxFmla", */
  },
  /*::[*/
  251: {
    /* n:"SxFormat", */
  },
  /*::[*/
  252: {
    /* n:"SST", */
    f: parse_SST
  },
  /*::[*/
  253: {
    /* n:"LabelSst", */
    f: parse_LabelSst
  },
  /*::[*/
  255: {
    /* n:"ExtSST", */
    f: parse_ExtSST
  },
  /*::[*/
  256: {
    /* n:"SXVDEx", */
  },
  /*::[*/
  259: {
    /* n:"SXFormula", */
  },
  /*::[*/
  290: {
    /* n:"SXDBEx", */
  },
  /*::[*/
  311: {
    /* n:"RRDInsDel", */
  },
  /*::[*/
  312: {
    /* n:"RRDHead", */
  },
  /*::[*/
  315: {
    /* n:"RRDChgCell", */
  },
  /*::[*/
  317: {
    /* n:"RRTabId", */
    f: parseuint16a
  },
  /*::[*/
  318: {
    /* n:"RRDRenSheet", */
  },
  /*::[*/
  319: {
    /* n:"RRSort", */
  },
  /*::[*/
  320: {
    /* n:"RRDMove", */
  },
  /*::[*/
  330: {
    /* n:"RRFormat", */
  },
  /*::[*/
  331: {
    /* n:"RRAutoFmt", */
  },
  /*::[*/
  333: {
    /* n:"RRInsertSh", */
  },
  /*::[*/
  334: {
    /* n:"RRDMoveBegin", */
  },
  /*::[*/
  335: {
    /* n:"RRDMoveEnd", */
  },
  /*::[*/
  336: {
    /* n:"RRDInsDelBegin", */
  },
  /*::[*/
  337: {
    /* n:"RRDInsDelEnd", */
  },
  /*::[*/
  338: {
    /* n:"RRDConflict", */
  },
  /*::[*/
  339: {
    /* n:"RRDDefName", */
  },
  /*::[*/
  340: {
    /* n:"RRDRstEtxp", */
  },
  /*::[*/
  351: {
    /* n:"LRng", */
  },
  /*::[*/
  352: {
    /* n:"UsesELFs", */
    f: parsebool
  },
  /*::[*/
  353: {
    /* n:"DSF", */
    f: parsenoop2
  },
  /*::[*/
  401: {
    /* n:"CUsr", */
  },
  /*::[*/
  402: {
    /* n:"CbUsr", */
  },
  /*::[*/
  403: {
    /* n:"UsrInfo", */
  },
  /*::[*/
  404: {
    /* n:"UsrExcl", */
  },
  /*::[*/
  405: {
    /* n:"FileLock", */
  },
  /*::[*/
  406: {
    /* n:"RRDInfo", */
  },
  /*::[*/
  407: {
    /* n:"BCUsrs", */
  },
  /*::[*/
  408: {
    /* n:"UsrChk", */
  },
  /*::[*/
  425: {
    /* n:"UserBView", */
  },
  /*::[*/
  426: {
    /* n:"UserSViewBegin", */
  },
  /*::[*/
  427: {
    /* n:"UserSViewEnd", */
  },
  /*::[*/
  428: {
    /* n:"RRDUserView", */
  },
  /*::[*/
  429: {
    /* n:"Qsi", */
  },
  /*::[*/
  430: {
    /* n:"SupBook", */
    f: parse_SupBook
  },
  /*::[*/
  431: {
    /* n:"Prot4Rev", */
    f: parsebool
  },
  /*::[*/
  432: {
    /* n:"CondFmt", */
  },
  /*::[*/
  433: {
    /* n:"CF", */
  },
  /*::[*/
  434: {
    /* n:"DVal", */
  },
  /*::[*/
  437: {
    /* n:"DConBin", */
  },
  /*::[*/
  438: {
    /* n:"TxO", */
    f: parse_TxO
  },
  /*::[*/
  439: {
    /* n:"RefreshAll", */
    f: parsebool
  },
  //
  /*::[*/
  440: {
    /* n:"HLink", */
    f: parse_HLink
  },
  /*::[*/
  441: {
    /* n:"Lel", */
  },
  /*::[*/
  442: {
    /* n:"CodeName", */
    f: parse_XLUnicodeString
  },
  /*::[*/
  443: {
    /* n:"SXFDBType", */
  },
  /*::[*/
  444: {
    /* n:"Prot4RevPass", */
    f: parseuint16
  },
  /*::[*/
  445: {
    /* n:"ObNoMacros", */
  },
  /*::[*/
  446: {
    /* n:"Dv", */
  },
  /*::[*/
  448: {
    /* n:"Excel9File", */
    f: parsenoop2
  },
  /*::[*/
  449: {
    /* n:"RecalcId", */
    f: parse_RecalcId,
    r: 2
  },
  /*::[*/
  450: {
    /* n:"EntExU2", */
    f: parsenoop2
  },
  /*::[*/
  512: {
    /* n:"Dimensions", */
    f: parse_Dimensions
  },
  /*::[*/
  513: {
    /* n:"Blank", */
    f: parse_Blank
  },
  /*::[*/
  515: {
    /* n:"Number", */
    f: parse_Number
  },
  /*::[*/
  516: {
    /* n:"Label", */
    f: parse_Label
  },
  /*::[*/
  517: {
    /* n:"BoolErr", */
    f: parse_BoolErr
  },
  /*::[*/
  519: {
    /* n:"String", */
    f: parse_String
  },
  /*::[*/
  520: {
    /* n:"Row", */
    f: parse_Row
  },
  /*::[*/
  523: {
    /* n:"Index", */
  },
  /*::[*/
  545: {
    /* n:"Array", */
    f: parse_Array
  },
  /*::[*/
  549: {
    /* n:"DefaultRowHeight", */
    f: parse_DefaultRowHeight
  },
  /*::[*/
  566: {
    /* n:"Table", */
  },
  /*::[*/
  574: {
    /* n:"Window2", */
    f: parse_Window2
  },
  /*::[*/
  638: {
    /* n:"RK", */
    f: parse_RK
  },
  /*::[*/
  659: {
    /* n:"Style", */
  },
  /*::[*/
  1048: {
    /* n:"BigName", */
  },
  /*::[*/
  1054: {
    /* n:"Format", */
    f: parse_Format
  },
  /*::[*/
  1084: {
    /* n:"ContinueBigName", */
  },
  /*::[*/
  1212: {
    /* n:"ShrFmla", */
    f: parse_ShrFmla
  },
  /*::[*/
  2048: {
    /* n:"HLinkTooltip", */
    f: parse_HLinkTooltip
  },
  /*::[*/
  2049: {
    /* n:"WebPub", */
  },
  /*::[*/
  2050: {
    /* n:"QsiSXTag", */
  },
  /*::[*/
  2051: {
    /* n:"DBQueryExt", */
  },
  /*::[*/
  2052: {
    /* n:"ExtString", */
  },
  /*::[*/
  2053: {
    /* n:"TxtQry", */
  },
  /*::[*/
  2054: {
    /* n:"Qsir", */
  },
  /*::[*/
  2055: {
    /* n:"Qsif", */
  },
  /*::[*/
  2056: {
    /* n:"RRDTQSIF", */
  },
  /*::[*/
  2057: {
    /* n:"BOF", */
    f: parse_BOF
  },
  /*::[*/
  2058: {
    /* n:"OleDbConn", */
  },
  /*::[*/
  2059: {
    /* n:"WOpt", */
  },
  /*::[*/
  2060: {
    /* n:"SXViewEx", */
  },
  /*::[*/
  2061: {
    /* n:"SXTH", */
  },
  /*::[*/
  2062: {
    /* n:"SXPIEx", */
  },
  /*::[*/
  2063: {
    /* n:"SXVDTEx", */
  },
  /*::[*/
  2064: {
    /* n:"SXViewEx9", */
  },
  /*::[*/
  2066: {
    /* n:"ContinueFrt", */
  },
  /*::[*/
  2067: {
    /* n:"RealTimeData", */
  },
  /*::[*/
  2128: {
    /* n:"ChartFrtInfo", */
  },
  /*::[*/
  2129: {
    /* n:"FrtWrapper", */
  },
  /*::[*/
  2130: {
    /* n:"StartBlock", */
  },
  /*::[*/
  2131: {
    /* n:"EndBlock", */
  },
  /*::[*/
  2132: {
    /* n:"StartObject", */
  },
  /*::[*/
  2133: {
    /* n:"EndObject", */
  },
  /*::[*/
  2134: {
    /* n:"CatLab", */
  },
  /*::[*/
  2135: {
    /* n:"YMult", */
  },
  /*::[*/
  2136: {
    /* n:"SXViewLink", */
  },
  /*::[*/
  2137: {
    /* n:"PivotChartBits", */
  },
  /*::[*/
  2138: {
    /* n:"FrtFontList", */
  },
  /*::[*/
  2146: {
    /* n:"SheetExt", */
  },
  /*::[*/
  2147: {
    /* n:"BookExt", */
    r: 12
  },
  /*::[*/
  2148: {
    /* n:"SXAddl", */
  },
  /*::[*/
  2149: {
    /* n:"CrErr", */
  },
  /*::[*/
  2150: {
    /* n:"HFPicture", */
  },
  /*::[*/
  2151: {
    /* n:"FeatHdr", */
    f: parsenoop2
  },
  /*::[*/
  2152: {
    /* n:"Feat", */
  },
  /*::[*/
  2154: {
    /* n:"DataLabExt", */
  },
  /*::[*/
  2155: {
    /* n:"DataLabExtContents", */
  },
  /*::[*/
  2156: {
    /* n:"CellWatch", */
  },
  /*::[*/
  2161: {
    /* n:"FeatHdr11", */
  },
  /*::[*/
  2162: {
    /* n:"Feature11", */
  },
  /*::[*/
  2164: {
    /* n:"DropDownObjIds", */
  },
  /*::[*/
  2165: {
    /* n:"ContinueFrt11", */
  },
  /*::[*/
  2166: {
    /* n:"DConn", */
  },
  /*::[*/
  2167: {
    /* n:"List12", */
  },
  /*::[*/
  2168: {
    /* n:"Feature12", */
  },
  /*::[*/
  2169: {
    /* n:"CondFmt12", */
  },
  /*::[*/
  2170: {
    /* n:"CF12", */
  },
  /*::[*/
  2171: {
    /* n:"CFEx", */
  },
  /*::[*/
  2172: {
    /* n:"XFCRC", */
    f: parse_XFCRC,
    r: 12
  },
  /*::[*/
  2173: {
    /* n:"XFExt", */
    f: parse_XFExt,
    r: 12
  },
  /*::[*/
  2174: {
    /* n:"AutoFilter12", */
  },
  /*::[*/
  2175: {
    /* n:"ContinueFrt12", */
  },
  /*::[*/
  2180: {
    /* n:"MDTInfo", */
  },
  /*::[*/
  2181: {
    /* n:"MDXStr", */
  },
  /*::[*/
  2182: {
    /* n:"MDXTuple", */
  },
  /*::[*/
  2183: {
    /* n:"MDXSet", */
  },
  /*::[*/
  2184: {
    /* n:"MDXProp", */
  },
  /*::[*/
  2185: {
    /* n:"MDXKPI", */
  },
  /*::[*/
  2186: {
    /* n:"MDB", */
  },
  /*::[*/
  2187: {
    /* n:"PLV", */
  },
  /*::[*/
  2188: {
    /* n:"Compat12", */
    f: parsebool,
    r: 12
  },
  /*::[*/
  2189: {
    /* n:"DXF", */
  },
  /*::[*/
  2190: {
    /* n:"TableStyles", */
    r: 12
  },
  /*::[*/
  2191: {
    /* n:"TableStyle", */
  },
  /*::[*/
  2192: {
    /* n:"TableStyleElement", */
  },
  /*::[*/
  2194: {
    /* n:"StyleExt", */
  },
  /*::[*/
  2195: {
    /* n:"NamePublish", */
  },
  /*::[*/
  2196: {
    /* n:"NameCmt", */
    f: parse_NameCmt,
    r: 12
  },
  /*::[*/
  2197: {
    /* n:"SortData", */
  },
  /*::[*/
  2198: {
    /* n:"Theme", */
    f: parse_Theme,
    r: 12
  },
  /*::[*/
  2199: {
    /* n:"GUIDTypeLib", */
  },
  /*::[*/
  2200: {
    /* n:"FnGrp12", */
  },
  /*::[*/
  2201: {
    /* n:"NameFnGrp12", */
  },
  /*::[*/
  2202: {
    /* n:"MTRSettings", */
    f: parse_MTRSettings,
    r: 12
  },
  /*::[*/
  2203: {
    /* n:"CompressPictures", */
    f: parsenoop2
  },
  /*::[*/
  2204: {
    /* n:"HeaderFooter", */
  },
  /*::[*/
  2205: {
    /* n:"CrtLayout12", */
  },
  /*::[*/
  2206: {
    /* n:"CrtMlFrt", */
  },
  /*::[*/
  2207: {
    /* n:"CrtMlFrtContinue", */
  },
  /*::[*/
  2211: {
    /* n:"ForceFullCalculation", */
    f: parse_ForceFullCalculation
  },
  /*::[*/
  2212: {
    /* n:"ShapePropsStream", */
  },
  /*::[*/
  2213: {
    /* n:"TextPropsStream", */
  },
  /*::[*/
  2214: {
    /* n:"RichTextStream", */
  },
  /*::[*/
  2215: {
    /* n:"CrtLayout12A", */
  },
  /*::[*/
  4097: {
    /* n:"Units", */
  },
  /*::[*/
  4098: {
    /* n:"Chart", */
  },
  /*::[*/
  4099: {
    /* n:"Series", */
  },
  /*::[*/
  4102: {
    /* n:"DataFormat", */
  },
  /*::[*/
  4103: {
    /* n:"LineFormat", */
  },
  /*::[*/
  4105: {
    /* n:"MarkerFormat", */
  },
  /*::[*/
  4106: {
    /* n:"AreaFormat", */
  },
  /*::[*/
  4107: {
    /* n:"PieFormat", */
  },
  /*::[*/
  4108: {
    /* n:"AttachedLabel", */
  },
  /*::[*/
  4109: {
    /* n:"SeriesText", */
  },
  /*::[*/
  4116: {
    /* n:"ChartFormat", */
  },
  /*::[*/
  4117: {
    /* n:"Legend", */
  },
  /*::[*/
  4118: {
    /* n:"SeriesList", */
  },
  /*::[*/
  4119: {
    /* n:"Bar", */
  },
  /*::[*/
  4120: {
    /* n:"Line", */
  },
  /*::[*/
  4121: {
    /* n:"Pie", */
  },
  /*::[*/
  4122: {
    /* n:"Area", */
  },
  /*::[*/
  4123: {
    /* n:"Scatter", */
  },
  /*::[*/
  4124: {
    /* n:"CrtLine", */
  },
  /*::[*/
  4125: {
    /* n:"Axis", */
  },
  /*::[*/
  4126: {
    /* n:"Tick", */
  },
  /*::[*/
  4127: {
    /* n:"ValueRange", */
  },
  /*::[*/
  4128: {
    /* n:"CatSerRange", */
  },
  /*::[*/
  4129: {
    /* n:"AxisLine", */
  },
  /*::[*/
  4130: {
    /* n:"CrtLink", */
  },
  /*::[*/
  4132: {
    /* n:"DefaultText", */
  },
  /*::[*/
  4133: {
    /* n:"Text", */
  },
  /*::[*/
  4134: {
    /* n:"FontX", */
    f: parseuint16
  },
  /*::[*/
  4135: {
    /* n:"ObjectLink", */
  },
  /*::[*/
  4146: {
    /* n:"Frame", */
  },
  /*::[*/
  4147: {
    /* n:"Begin", */
  },
  /*::[*/
  4148: {
    /* n:"End", */
  },
  /*::[*/
  4149: {
    /* n:"PlotArea", */
  },
  /*::[*/
  4154: {
    /* n:"Chart3d", */
  },
  /*::[*/
  4156: {
    /* n:"PicF", */
  },
  /*::[*/
  4157: {
    /* n:"DropBar", */
  },
  /*::[*/
  4158: {
    /* n:"Radar", */
  },
  /*::[*/
  4159: {
    /* n:"Surf", */
  },
  /*::[*/
  4160: {
    /* n:"RadarArea", */
  },
  /*::[*/
  4161: {
    /* n:"AxisParent", */
  },
  /*::[*/
  4163: {
    /* n:"LegendException", */
  },
  /*::[*/
  4164: {
    /* n:"ShtProps", */
    f: parse_ShtProps
  },
  /*::[*/
  4165: {
    /* n:"SerToCrt", */
  },
  /*::[*/
  4166: {
    /* n:"AxesUsed", */
  },
  /*::[*/
  4168: {
    /* n:"SBaseRef", */
  },
  /*::[*/
  4170: {
    /* n:"SerParent", */
  },
  /*::[*/
  4171: {
    /* n:"SerAuxTrend", */
  },
  /*::[*/
  4174: {
    /* n:"IFmtRecord", */
  },
  /*::[*/
  4175: {
    /* n:"Pos", */
  },
  /*::[*/
  4176: {
    /* n:"AlRuns", */
  },
  /*::[*/
  4177: {
    /* n:"BRAI", */
  },
  /*::[*/
  4187: {
    /* n:"SerAuxErrBar", */
  },
  /*::[*/
  4188: {
    /* n:"ClrtClient", */
    f: parse_ClrtClient
  },
  /*::[*/
  4189: {
    /* n:"SerFmt", */
  },
  /*::[*/
  4191: {
    /* n:"Chart3DBarShape", */
  },
  /*::[*/
  4192: {
    /* n:"Fbi", */
  },
  /*::[*/
  4193: {
    /* n:"BopPop", */
  },
  /*::[*/
  4194: {
    /* n:"AxcExt", */
  },
  /*::[*/
  4195: {
    /* n:"Dat", */
  },
  /*::[*/
  4196: {
    /* n:"PlotGrowth", */
  },
  /*::[*/
  4197: {
    /* n:"SIIndex", */
  },
  /*::[*/
  4198: {
    /* n:"GelFrame", */
  },
  /*::[*/
  4199: {
    /* n:"BopPopCustom", */
  },
  /*::[*/
  4200: {
    /* n:"Fbi2", */
  },
  /*::[*/
  0: {
    /* n:"Dimensions", */
    f: parse_Dimensions
  },
  /*::[*/
  1: {
    /* n:"BIFF2BLANK", */
  },
  /*::[*/
  2: {
    /* n:"BIFF2INT", */
    f: parse_BIFF2INT
  },
  /*::[*/
  3: {
    /* n:"BIFF2NUM", */
    f: parse_BIFF2NUM
  },
  /*::[*/
  4: {
    /* n:"BIFF2STR", */
    f: parse_BIFF2STR
  },
  /*::[*/
  5: {
    /* n:"BoolErr", */
    f: parse_BoolErr
  },
  /*::[*/
  7: {
    /* n:"String", */
    f: parse_BIFF2STRING
  },
  /*::[*/
  8: {
    /* n:"BIFF2ROW", */
  },
  /*::[*/
  9: {
    /* n:"BOF", */
    f: parse_BOF
  },
  /*::[*/
  11: {
    /* n:"Index", */
  },
  /*::[*/
  22: {
    /* n:"ExternCount", */
    f: parseuint16
  },
  /*::[*/
  30: {
    /* n:"BIFF2FORMAT", */
    f: parse_BIFF2Format
  },
  /*::[*/
  31: {
    /* n:"BIFF2FMTCNT", */
  },
  /* 16-bit cnt of BIFF2FORMAT records */
  /*::[*/
  32: {
    /* n:"BIFF2COLINFO", */
  },
  /*::[*/
  33: {
    /* n:"Array", */
    f: parse_Array
  },
  /*::[*/
  36: {
    /* n:"COLWIDTH", */
  },
  /*::[*/
  37: {
    /* n:"DefaultRowHeight", */
    f: parse_DefaultRowHeight
  },
  // 0x2c ??
  // 0x2d ??
  // 0x2e ??
  // 0x30 FONTCOUNT: number of fonts
  /*::[*/
  50: {
    /* n:"BIFF2FONTXTRA", */
    f: parse_BIFF2FONTXTRA
  },
  // 0x35: INFOOPTS
  // 0x36: TABLE (BIFF2 only)
  // 0x37: TABLE2 (BIFF2 only)
  // 0x38: WNDESK
  // 0x39 ??
  // 0x3a: BEGINPREF
  // 0x3b: ENDPREF
  /*::[*/
  62: {
    /* n:"BIFF2WINDOW2", */
  },
  // 0x3f ??
  // 0x46: SHOWSCROLL
  // 0x47: SHOWFORMULA
  // 0x48: STATUSBAR
  // 0x49: SHORTMENUS
  // 0x4A:
  // 0x4B:
  // 0x4C:
  // 0x4E:
  // 0x4F:
  // 0x58: TOOLBAR (BIFF3)
  /* - - - */
  /*::[*/
  52: {
    /* n:"DDEObjName", */
  },
  /*::[*/
  67: {
    /* n:"BIFF2XF", */
  },
  /*::[*/
  68: {
    /* n:"BIFF2XFINDEX", */
    f: parseuint16
  },
  /*::[*/
  69: {
    /* n:"BIFF2FONTCLR", */
  },
  /*::[*/
  86: {
    /* n:"BIFF4FMTCNT", */
  },
  /* 16-bit cnt, similar to BIFF2 */
  /*::[*/
  126: {
    /* n:"RK", */
  },
  /* Not necessarily same as 0x027e */
  /*::[*/
  127: {
    /* n:"ImData", */
    f: parse_ImData
  },
  /*::[*/
  135: {
    /* n:"Addin", */
  },
  /*::[*/
  136: {
    /* n:"Edg", */
  },
  /*::[*/
  137: {
    /* n:"Pub", */
  },
  // 0x8A
  // 0x8B LH: alternate menu key flag (BIFF3/4)
  // 0x8E
  // 0x8F
  /*::[*/
  145: {
    /* n:"Sub", */
  },
  // 0x93 STYLE
  /*::[*/
  148: {
    /* n:"LHRecord", */
  },
  /*::[*/
  149: {
    /* n:"LHNGraph", */
  },
  /*::[*/
  150: {
    /* n:"Sound", */
  },
  // 0xA2 FNPROTO: function prototypes (BIFF4)
  // 0xA3
  // 0xA8
  /*::[*/
  169: {
    /* n:"CoordList", */
  },
  /*::[*/
  171: {
    /* n:"GCW", */
  },
  /*::[*/
  188: {
    /* n:"ShrFmla", */
  },
  /* Not necessarily same as 0x04bc */
  /*::[*/
  191: {
    /* n:"ToolbarHdr", */
  },
  /*::[*/
  192: {
    /* n:"ToolbarEnd", */
  },
  /*::[*/
  194: {
    /* n:"AddMenu", */
  },
  /*::[*/
  195: {
    /* n:"DelMenu", */
  },
  /*::[*/
  214: {
    /* n:"RString", */
    f: parse_RString
  },
  /*::[*/
  223: {
    /* n:"UDDesc", */
  },
  /*::[*/
  234: {
    /* n:"TabIdConf", */
  },
  /*::[*/
  354: {
    /* n:"XL5Modify", */
  },
  /*::[*/
  421: {
    /* n:"FileSharing2", */
  },
  /*::[*/
  518: {
    /* n:"Formula", */
    f: parse_Formula
  },
  /*::[*/
  521: {
    /* n:"BOF", */
    f: parse_BOF
  },
  /*::[*/
  536: {
    /* n:"Lbl", */
    f: parse_Lbl
  },
  /*::[*/
  547: {
    /* n:"ExternName", */
    f: parse_ExternName
  },
  /*::[*/
  561: {
    /* n:"Font", */
  },
  /*::[*/
  579: {
    /* n:"BIFF3XF", */
  },
  /*::[*/
  1030: {
    /* n:"Formula", */
    f: parse_Formula
  },
  /*::[*/
  1033: {
    /* n:"BOF", */
    f: parse_BOF
  },
  /*::[*/
  1091: {
    /* n:"BIFF4XF", */
  },
  /*::[*/
  2157: {
    /* n:"FeatInfo", */
  },
  /*::[*/
  2163: {
    /* n:"FeatInfo11", */
  },
  /*::[*/
  2177: {
    /* n:"SXAddl12", */
  },
  /*::[*/
  2240: {
    /* n:"AutoWebPub", */
  },
  /*::[*/
  2241: {
    /* n:"ListObj", */
  },
  /*::[*/
  2242: {
    /* n:"ListField", */
  },
  /*::[*/
  2243: {
    /* n:"ListDV", */
  },
  /*::[*/
  2244: {
    /* n:"ListCondFmt", */
  },
  /*::[*/
  2245: {
    /* n:"ListCF", */
  },
  /*::[*/
  2246: {
    /* n:"FMQry", */
  },
  /*::[*/
  2247: {
    /* n:"FMSQry", */
  },
  /*::[*/
  2248: {
    /* n:"PLV", */
  },
  /*::[*/
  2249: {
    /* n:"LnExt", */
  },
  /*::[*/
  2250: {
    /* n:"MkrExt", */
  },
  /*::[*/
  2251: {
    /* n:"CrtCoopt", */
  },
  /*::[*/
  2262: {
    /* n:"FRTArchId$", */
    r: 12
  },
  /*::[*/
  29282: {}
};
function write_biff_rec(ba, type, payload, length) {
  var t2 = type;
  if (isNaN(t2))
    return;
  var len = length || (payload || []).length || 0;
  var o2 = ba.next(4);
  o2.write_shift(2, t2);
  o2.write_shift(2, len);
  if (
    /*:: len != null &&*/
    len > 0 && is_buf(payload)
  )
    ba.push(payload);
}
function write_biff_continue(ba, type, payload, length) {
  var len = length || (payload || []).length || 0;
  if (len <= 8224)
    return write_biff_rec(ba, type, payload, len);
  var t2 = type;
  if (isNaN(t2))
    return;
  var parts = payload.parts || [], sidx = 0;
  var i2 = 0, w2 = 0;
  while (w2 + (parts[sidx] || 8224) <= 8224) {
    w2 += parts[sidx] || 8224;
    sidx++;
  }
  var o2 = ba.next(4);
  o2.write_shift(2, t2);
  o2.write_shift(2, w2);
  ba.push(payload.slice(i2, i2 + w2));
  i2 += w2;
  while (i2 < len) {
    o2 = ba.next(4);
    o2.write_shift(2, 60);
    w2 = 0;
    while (w2 + (parts[sidx] || 8224) <= 8224) {
      w2 += parts[sidx] || 8224;
      sidx++;
    }
    o2.write_shift(2, w2);
    ba.push(payload.slice(i2, i2 + w2));
    i2 += w2;
  }
}
function write_BIFF2Cell(out, r, c2) {
  if (!out)
    out = new_buf(7);
  out.write_shift(2, r);
  out.write_shift(2, c2);
  out.write_shift(2, 0);
  out.write_shift(1, 0);
  return out;
}
function write_BIFF2BERR(r, c2, val, t2) {
  var out = new_buf(9);
  write_BIFF2Cell(out, r, c2);
  write_Bes(val, t2 || "b", out);
  return out;
}
function write_BIFF2LABEL(r, c2, val) {
  var out = new_buf(8 + 2 * val.length);
  write_BIFF2Cell(out, r, c2);
  out.write_shift(1, val.length);
  out.write_shift(val.length, val, "sbcs");
  return out.l < out.length ? out.slice(0, out.l) : out;
}
function write_ws_biff2_cell(ba, cell, R2, C2) {
  if (cell.v != null)
    switch (cell.t) {
      case "d":
      case "n":
        var v2 = cell.t == "d" ? datenum(parseDate(cell.v)) : cell.v;
        if (v2 == (v2 | 0) && v2 >= 0 && v2 < 65536)
          write_biff_rec(ba, 2, write_BIFF2INT(R2, C2, v2));
        else
          write_biff_rec(ba, 3, write_BIFF2NUM(R2, C2, v2));
        return;
      case "b":
      case "e":
        write_biff_rec(ba, 5, write_BIFF2BERR(R2, C2, cell.v, cell.t));
        return;
      case "s":
      case "str":
        write_biff_rec(ba, 4, write_BIFF2LABEL(R2, C2, (cell.v || "").slice(0, 255)));
        return;
    }
  write_biff_rec(ba, 1, write_BIFF2Cell(null, R2, C2));
}
function write_ws_biff2(ba, ws, idx, opts) {
  var dense = Array.isArray(ws);
  var range = safe_decode_range(ws["!ref"] || "A1"), ref, rr = "", cols = [];
  if (range.e.c > 255 || range.e.r > 16383) {
    if (opts.WTF)
      throw new Error("Range " + (ws["!ref"] || "A1") + " exceeds format limit A1:IV16384");
    range.e.c = Math.min(range.e.c, 255);
    range.e.r = Math.min(range.e.c, 16383);
    ref = encode_range(range);
  }
  for (var R2 = range.s.r; R2 <= range.e.r; ++R2) {
    rr = encode_row(R2);
    for (var C2 = range.s.c; C2 <= range.e.c; ++C2) {
      if (R2 === range.s.r)
        cols[C2] = encode_col(C2);
      ref = cols[C2] + rr;
      var cell = dense ? (ws[R2] || [])[C2] : ws[ref];
      if (!cell)
        continue;
      write_ws_biff2_cell(ba, cell, R2, C2, opts);
    }
  }
}
function write_biff2_buf(wb, opts) {
  var o2 = opts || {};
  if (DENSE != null && o2.dense == null)
    o2.dense = DENSE;
  var ba = buf_array();
  var idx = 0;
  for (var i2 = 0; i2 < wb.SheetNames.length; ++i2)
    if (wb.SheetNames[i2] == o2.sheet)
      idx = i2;
  if (idx == 0 && !!o2.sheet && wb.SheetNames[0] != o2.sheet)
    throw new Error("Sheet not found: " + o2.sheet);
  write_biff_rec(ba, o2.biff == 4 ? 1033 : o2.biff == 3 ? 521 : 9, write_BOF(wb, 16, o2));
  write_ws_biff2(ba, wb.Sheets[wb.SheetNames[idx]], idx, o2, wb);
  write_biff_rec(ba, 10);
  return ba.end();
}
function write_FONTS_biff8(ba, data, opts) {
  write_biff_rec(ba, 49, write_Font({
    sz: 12,
    color: { theme: 1 },
    name: "Arial",
    family: 2,
    scheme: "minor"
  }, opts));
}
function write_FMTS_biff8(ba, NF, opts) {
  if (!NF)
    return;
  [[5, 8], [23, 26], [41, 44], [
    /*63*/
    50,
    /*66],[164,*/
    392
  ]].forEach(function(r) {
    for (var i2 = r[0]; i2 <= r[1]; ++i2)
      if (NF[i2] != null)
        write_biff_rec(ba, 1054, write_Format(i2, NF[i2], opts));
  });
}
function write_FEAT(ba, ws) {
  var o2 = new_buf(19);
  o2.write_shift(4, 2151);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  o2.write_shift(2, 3);
  o2.write_shift(1, 1);
  o2.write_shift(4, 0);
  write_biff_rec(ba, 2151, o2);
  o2 = new_buf(39);
  o2.write_shift(4, 2152);
  o2.write_shift(4, 0);
  o2.write_shift(4, 0);
  o2.write_shift(2, 3);
  o2.write_shift(1, 0);
  o2.write_shift(4, 0);
  o2.write_shift(2, 1);
  o2.write_shift(4, 4);
  o2.write_shift(2, 0);
  write_Ref8U(safe_decode_range(ws["!ref"] || "A1"), o2);
  o2.write_shift(4, 4);
  write_biff_rec(ba, 2152, o2);
}
function write_CELLXFS_biff8(ba, opts) {
  for (var i2 = 0; i2 < 16; ++i2)
    write_biff_rec(ba, 224, write_XF({ numFmtId: 0, style: true }, 0, opts));
  opts.cellXfs.forEach(function(c2) {
    write_biff_rec(ba, 224, write_XF(c2, 0, opts));
  });
}
function write_ws_biff8_hlinks(ba, ws) {
  for (var R2 = 0; R2 < ws["!links"].length; ++R2) {
    var HL = ws["!links"][R2];
    write_biff_rec(ba, 440, write_HLink(HL));
    if (HL[1].Tooltip)
      write_biff_rec(ba, 2048, write_HLinkTooltip(HL));
  }
  delete ws["!links"];
}
function write_ws_cols_biff8(ba, cols) {
  if (!cols)
    return;
  var cnt = 0;
  cols.forEach(function(col, idx) {
    if (++cnt <= 256 && col) {
      write_biff_rec(ba, 125, write_ColInfo(col_obj_w(idx, col), idx));
    }
  });
}
function write_ws_biff8_cell(ba, cell, R2, C2, opts) {
  var os = 16 + get_cell_style(opts.cellXfs, cell, opts);
  if (cell.v == null && !cell.bf) {
    write_biff_rec(ba, 513, write_XLSCell(R2, C2, os));
    return;
  }
  if (cell.bf)
    write_biff_rec(ba, 6, write_Formula(cell, R2, C2, opts, os));
  else
    switch (cell.t) {
      case "d":
      case "n":
        var v2 = cell.t == "d" ? datenum(parseDate(cell.v)) : cell.v;
        write_biff_rec(ba, 515, write_Number(R2, C2, v2, os, opts));
        break;
      case "b":
      case "e":
        write_biff_rec(ba, 517, write_BoolErr(R2, C2, cell.v, os, opts, cell.t));
        break;
      case "s":
      case "str":
        if (opts.bookSST) {
          var isst = get_sst_id(opts.Strings, cell.v, opts.revStrings);
          write_biff_rec(ba, 253, write_LabelSst(R2, C2, isst, os, opts));
        } else
          write_biff_rec(ba, 516, write_Label(R2, C2, (cell.v || "").slice(0, 255), os, opts));
        break;
      default:
        write_biff_rec(ba, 513, write_XLSCell(R2, C2, os));
    }
}
function write_ws_biff8(idx, opts, wb) {
  var ba = buf_array();
  var s2 = wb.SheetNames[idx], ws = wb.Sheets[s2] || {};
  var _WB = (wb || {}).Workbook || {};
  var _sheet = (_WB.Sheets || [])[idx] || {};
  var dense = Array.isArray(ws);
  var b8 = opts.biff == 8;
  var ref, rr = "", cols = [];
  var range = safe_decode_range(ws["!ref"] || "A1");
  var MAX_ROWS = b8 ? 65536 : 16384;
  if (range.e.c > 255 || range.e.r >= MAX_ROWS) {
    if (opts.WTF)
      throw new Error("Range " + (ws["!ref"] || "A1") + " exceeds format limit A1:IV16384");
    range.e.c = Math.min(range.e.c, 255);
    range.e.r = Math.min(range.e.c, MAX_ROWS - 1);
  }
  write_biff_rec(ba, 2057, write_BOF(wb, 16, opts));
  write_biff_rec(ba, 13, writeuint16(1));
  write_biff_rec(ba, 12, writeuint16(100));
  write_biff_rec(ba, 15, writebool(true));
  write_biff_rec(ba, 17, writebool(false));
  write_biff_rec(ba, 16, write_Xnum(1e-3));
  write_biff_rec(ba, 95, writebool(true));
  write_biff_rec(ba, 42, writebool(false));
  write_biff_rec(ba, 43, writebool(false));
  write_biff_rec(ba, 130, writeuint16(1));
  write_biff_rec(ba, 128, write_Guts([0, 0]));
  write_biff_rec(ba, 131, writebool(false));
  write_biff_rec(ba, 132, writebool(false));
  if (b8)
    write_ws_cols_biff8(ba, ws["!cols"]);
  write_biff_rec(ba, 512, write_Dimensions(range, opts));
  if (b8)
    ws["!links"] = [];
  for (var R2 = range.s.r; R2 <= range.e.r; ++R2) {
    rr = encode_row(R2);
    for (var C2 = range.s.c; C2 <= range.e.c; ++C2) {
      if (R2 === range.s.r)
        cols[C2] = encode_col(C2);
      ref = cols[C2] + rr;
      var cell = dense ? (ws[R2] || [])[C2] : ws[ref];
      if (!cell)
        continue;
      write_ws_biff8_cell(ba, cell, R2, C2, opts);
      if (b8 && cell.l)
        ws["!links"].push([ref, cell.l]);
    }
  }
  var cname = _sheet.CodeName || _sheet.name || s2;
  if (b8)
    write_biff_rec(ba, 574, write_Window2((_WB.Views || [])[0]));
  if (b8 && (ws["!merges"] || []).length)
    write_biff_rec(ba, 229, write_MergeCells(ws["!merges"]));
  if (b8)
    write_ws_biff8_hlinks(ba, ws);
  write_biff_rec(ba, 442, write_XLUnicodeString(cname, opts));
  if (b8)
    write_FEAT(ba, ws);
  write_biff_rec(
    ba,
    10
    /* EOF */
  );
  return ba.end();
}
function write_biff8_global(wb, bufs, opts) {
  var A2 = buf_array();
  var _WB = (wb || {}).Workbook || {};
  var _sheets = _WB.Sheets || [];
  var _wb = (
    /*::((*/
    _WB.WBProps || {
      /*::CodeName:"ThisWorkbook"*/
    }
  );
  var b8 = opts.biff == 8, b5 = opts.biff == 5;
  write_biff_rec(A2, 2057, write_BOF(wb, 5, opts));
  if (opts.bookType == "xla")
    write_biff_rec(
      A2,
      135
      /* Addin */
    );
  write_biff_rec(A2, 225, b8 ? writeuint16(1200) : null);
  write_biff_rec(A2, 193, writezeroes(2));
  if (b5)
    write_biff_rec(
      A2,
      191
      /* ToolbarHdr */
    );
  if (b5)
    write_biff_rec(
      A2,
      192
      /* ToolbarEnd */
    );
  write_biff_rec(
    A2,
    226
    /* InterfaceEnd */
  );
  write_biff_rec(A2, 92, write_WriteAccess("SheetJS", opts));
  write_biff_rec(A2, 66, writeuint16(b8 ? 1200 : 1252));
  if (b8)
    write_biff_rec(A2, 353, writeuint16(0));
  if (b8)
    write_biff_rec(
      A2,
      448
      /* Excel9File */
    );
  write_biff_rec(A2, 317, write_RRTabId(wb.SheetNames.length));
  if (b8 && wb.vbaraw)
    write_biff_rec(
      A2,
      211
      /* ObProj */
    );
  if (b8 && wb.vbaraw) {
    var cname = _wb.CodeName || "ThisWorkbook";
    write_biff_rec(A2, 442, write_XLUnicodeString(cname, opts));
  }
  write_biff_rec(A2, 156, writeuint16(17));
  write_biff_rec(A2, 25, writebool(false));
  write_biff_rec(A2, 18, writebool(false));
  write_biff_rec(A2, 19, writeuint16(0));
  if (b8)
    write_biff_rec(A2, 431, writebool(false));
  if (b8)
    write_biff_rec(A2, 444, writeuint16(0));
  write_biff_rec(A2, 61, write_Window1(opts));
  write_biff_rec(A2, 64, writebool(false));
  write_biff_rec(A2, 141, writeuint16(0));
  write_biff_rec(A2, 34, writebool(safe1904(wb) == "true"));
  write_biff_rec(A2, 14, writebool(true));
  if (b8)
    write_biff_rec(A2, 439, writebool(false));
  write_biff_rec(A2, 218, writeuint16(0));
  write_FONTS_biff8(A2, wb, opts);
  write_FMTS_biff8(A2, wb.SSF, opts);
  write_CELLXFS_biff8(A2, opts);
  if (b8)
    write_biff_rec(A2, 352, writebool(false));
  var a2 = A2.end();
  var C2 = buf_array();
  if (b8)
    write_biff_rec(C2, 140, write_Country());
  if (b8 && opts.Strings)
    write_biff_continue(C2, 252, write_SST(opts.Strings, opts));
  write_biff_rec(
    C2,
    10
    /* EOF */
  );
  var c2 = C2.end();
  var B2 = buf_array();
  var blen = 0, j2 = 0;
  for (j2 = 0; j2 < wb.SheetNames.length; ++j2)
    blen += (b8 ? 12 : 11) + (b8 ? 2 : 1) * wb.SheetNames[j2].length;
  var start = a2.length + blen + c2.length;
  for (j2 = 0; j2 < wb.SheetNames.length; ++j2) {
    var _sheet = _sheets[j2] || {};
    write_biff_rec(B2, 133, write_BoundSheet8({ pos: start, hs: _sheet.Hidden || 0, dt: 0, name: wb.SheetNames[j2] }, opts));
    start += bufs[j2].length;
  }
  var b2 = B2.end();
  if (blen != b2.length)
    throw new Error("BS8 " + blen + " != " + b2.length);
  var out = [];
  if (a2.length)
    out.push(a2);
  if (b2.length)
    out.push(b2);
  if (c2.length)
    out.push(c2);
  return bconcat(out);
}
function write_biff8_buf(wb, opts) {
  var o2 = opts || {};
  var bufs = [];
  if (wb && !wb.SSF) {
    wb.SSF = dup(table_fmt);
  }
  if (wb && wb.SSF) {
    make_ssf();
    SSF_load_table(wb.SSF);
    o2.revssf = evert_num(wb.SSF);
    o2.revssf[wb.SSF[65535]] = 0;
    o2.ssf = wb.SSF;
  }
  o2.Strings = /*::((*/
  [];
  o2.Strings.Count = 0;
  o2.Strings.Unique = 0;
  fix_write_opts(o2);
  o2.cellXfs = [];
  get_cell_style(o2.cellXfs, {}, { revssf: { "General": 0 } });
  if (!wb.Props)
    wb.Props = {};
  for (var i2 = 0; i2 < wb.SheetNames.length; ++i2)
    bufs[bufs.length] = write_ws_biff8(i2, o2, wb);
  bufs.unshift(write_biff8_global(wb, bufs, o2));
  return bconcat(bufs);
}
function write_biff_buf(wb, opts) {
  for (var i2 = 0; i2 <= wb.SheetNames.length; ++i2) {
    var ws = wb.Sheets[wb.SheetNames[i2]];
    if (!ws || !ws["!ref"])
      continue;
    var range = decode_range(ws["!ref"]);
    if (range.e.c > 255) {
      if (typeof console != "undefined" && console.error)
        console.error("Worksheet '" + wb.SheetNames[i2] + "' extends beyond column IV (255).  Data may be lost.");
    }
  }
  var o2 = opts || {};
  switch (o2.biff || 2) {
    case 8:
    case 5:
      return write_biff8_buf(wb, opts);
    case 4:
    case 3:
    case 2:
      return write_biff2_buf(wb, opts);
  }
  throw new Error("invalid type " + o2.bookType + " for BIFF");
}
function html_to_sheet(str, _opts) {
  var opts = _opts || {};
  if (DENSE != null && opts.dense == null)
    opts.dense = DENSE;
  var ws = opts.dense ? [] : {};
  str = str.replace(/<!--.*?-->/g, "");
  var mtch = str.match(/<table/i);
  if (!mtch)
    throw new Error("Invalid HTML: could not find <table>");
  var mtch2 = str.match(/<\/table/i);
  var i2 = mtch.index, j2 = mtch2 && mtch2.index || str.length;
  var rows = split_regex(str.slice(i2, j2), /(:?<tr[^>]*>)/i, "<tr>");
  var R2 = -1, C2 = 0, RS = 0, CS = 0;
  var range = { s: { r: 1e7, c: 1e7 }, e: { r: 0, c: 0 } };
  var merges = [];
  for (i2 = 0; i2 < rows.length; ++i2) {
    var row = rows[i2].trim();
    var hd = row.slice(0, 3).toLowerCase();
    if (hd == "<tr") {
      ++R2;
      if (opts.sheetRows && opts.sheetRows <= R2) {
        --R2;
        break;
      }
      C2 = 0;
      continue;
    }
    if (hd != "<td" && hd != "<th")
      continue;
    var cells = row.split(/<\/t[dh]>/i);
    for (j2 = 0; j2 < cells.length; ++j2) {
      var cell = cells[j2].trim();
      if (!cell.match(/<t[dh]/i))
        continue;
      var m2 = cell, cc = 0;
      while (m2.charAt(0) == "<" && (cc = m2.indexOf(">")) > -1)
        m2 = m2.slice(cc + 1);
      for (var midx = 0; midx < merges.length; ++midx) {
        var _merge = merges[midx];
        if (_merge.s.c == C2 && _merge.s.r < R2 && R2 <= _merge.e.r) {
          C2 = _merge.e.c + 1;
          midx = -1;
        }
      }
      var tag = parsexmltag(cell.slice(0, cell.indexOf(">")));
      CS = tag.colspan ? +tag.colspan : 1;
      if ((RS = +tag.rowspan) > 1 || CS > 1)
        merges.push({ s: { r: R2, c: C2 }, e: { r: R2 + (RS || 1) - 1, c: C2 + CS - 1 } });
      var _t2 = tag.t || tag["data-t"] || "";
      if (!m2.length) {
        C2 += CS;
        continue;
      }
      m2 = htmldecode(m2);
      if (range.s.r > R2)
        range.s.r = R2;
      if (range.e.r < R2)
        range.e.r = R2;
      if (range.s.c > C2)
        range.s.c = C2;
      if (range.e.c < C2)
        range.e.c = C2;
      if (!m2.length) {
        C2 += CS;
        continue;
      }
      var o2 = { t: "s", v: m2 };
      if (opts.raw || !m2.trim().length || _t2 == "s") {
      } else if (m2 === "TRUE")
        o2 = { t: "b", v: true };
      else if (m2 === "FALSE")
        o2 = { t: "b", v: false };
      else if (!isNaN(fuzzynum(m2)))
        o2 = { t: "n", v: fuzzynum(m2) };
      else if (!isNaN(fuzzydate(m2).getDate())) {
        o2 = { t: "d", v: parseDate(m2) };
        if (!opts.cellDates)
          o2 = { t: "n", v: datenum(o2.v) };
        o2.z = opts.dateNF || table_fmt[14];
      }
      if (opts.dense) {
        if (!ws[R2])
          ws[R2] = [];
        ws[R2][C2] = o2;
      } else
        ws[encode_cell({ r: R2, c: C2 })] = o2;
      C2 += CS;
    }
  }
  ws["!ref"] = encode_range(range);
  if (merges.length)
    ws["!merges"] = merges;
  return ws;
}
function make_html_row(ws, r, R2, o2) {
  var M2 = ws["!merges"] || [];
  var oo = [];
  for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
    var RS = 0, CS = 0;
    for (var j2 = 0; j2 < M2.length; ++j2) {
      if (M2[j2].s.r > R2 || M2[j2].s.c > C2)
        continue;
      if (M2[j2].e.r < R2 || M2[j2].e.c < C2)
        continue;
      if (M2[j2].s.r < R2 || M2[j2].s.c < C2) {
        RS = -1;
        break;
      }
      RS = M2[j2].e.r - M2[j2].s.r + 1;
      CS = M2[j2].e.c - M2[j2].s.c + 1;
      break;
    }
    if (RS < 0)
      continue;
    var coord = encode_cell({ r: R2, c: C2 });
    var cell = o2.dense ? (ws[R2] || [])[C2] : ws[coord];
    var w2 = cell && cell.v != null && (cell.h || escapehtml(cell.w || (format_cell(cell), cell.w) || "")) || "";
    var sp = {};
    if (RS > 1)
      sp.rowspan = RS;
    if (CS > 1)
      sp.colspan = CS;
    if (o2.editable)
      w2 = '<span contenteditable="true">' + w2 + "</span>";
    else if (cell) {
      sp["data-t"] = cell && cell.t || "z";
      if (cell.v != null)
        sp["data-v"] = cell.v;
      if (cell.z != null)
        sp["data-z"] = cell.z;
      if (cell.l && (cell.l.Target || "#").charAt(0) != "#")
        w2 = '<a href="' + cell.l.Target + '">' + w2 + "</a>";
    }
    sp.id = (o2.id || "sjs") + "-" + coord;
    oo.push(writextag("td", w2, sp));
  }
  var preamble = "<tr>";
  return preamble + oo.join("") + "</tr>";
}
var HTML_BEGIN = '<html><head><meta charset="utf-8"/><title>SheetJS Table Export</title></head><body>';
var HTML_END = "</body></html>";
function html_to_workbook(str, opts) {
  var mtch = str.match(/<table[\s\S]*?>[\s\S]*?<\/table>/gi);
  if (!mtch || mtch.length == 0)
    throw new Error("Invalid HTML: could not find <table>");
  if (mtch.length == 1)
    return sheet_to_workbook(html_to_sheet(mtch[0], opts), opts);
  var wb = book_new();
  mtch.forEach(function(s2, idx) {
    book_append_sheet(wb, html_to_sheet(s2, opts), "Sheet" + (idx + 1));
  });
  return wb;
}
function make_html_preamble(ws, R2, o2) {
  var out = [];
  return out.join("") + "<table" + (o2 && o2.id ? ' id="' + o2.id + '"' : "") + ">";
}
function sheet_to_html(ws, opts) {
  var o2 = opts || {};
  var header = o2.header != null ? o2.header : HTML_BEGIN;
  var footer = o2.footer != null ? o2.footer : HTML_END;
  var out = [header];
  var r = decode_range(ws["!ref"]);
  o2.dense = Array.isArray(ws);
  out.push(make_html_preamble(ws, r, o2));
  for (var R2 = r.s.r; R2 <= r.e.r; ++R2)
    out.push(make_html_row(ws, r, R2, o2));
  out.push("</table>" + footer);
  return out.join("");
}
function sheet_add_dom(ws, table, _opts) {
  var opts = _opts || {};
  if (DENSE != null)
    opts.dense = DENSE;
  var or_R = 0, or_C = 0;
  if (opts.origin != null) {
    if (typeof opts.origin == "number")
      or_R = opts.origin;
    else {
      var _origin = typeof opts.origin == "string" ? decode_cell(opts.origin) : opts.origin;
      or_R = _origin.r;
      or_C = _origin.c;
    }
  }
  var rows = table.getElementsByTagName("tr");
  var sheetRows = Math.min(opts.sheetRows || 1e7, rows.length);
  var range = { s: { r: 0, c: 0 }, e: { r: or_R, c: or_C } };
  if (ws["!ref"]) {
    var _range = decode_range(ws["!ref"]);
    range.s.r = Math.min(range.s.r, _range.s.r);
    range.s.c = Math.min(range.s.c, _range.s.c);
    range.e.r = Math.max(range.e.r, _range.e.r);
    range.e.c = Math.max(range.e.c, _range.e.c);
    if (or_R == -1)
      range.e.r = or_R = _range.e.r + 1;
  }
  var merges = [], midx = 0;
  var rowinfo = ws["!rows"] || (ws["!rows"] = []);
  var _R = 0, R2 = 0, _C = 0, C2 = 0, RS = 0, CS = 0;
  if (!ws["!cols"])
    ws["!cols"] = [];
  for (; _R < rows.length && R2 < sheetRows; ++_R) {
    var row = rows[_R];
    if (is_dom_element_hidden(row)) {
      if (opts.display)
        continue;
      rowinfo[R2] = { hidden: true };
    }
    var elts = row.children;
    for (_C = C2 = 0; _C < elts.length; ++_C) {
      var elt = elts[_C];
      if (opts.display && is_dom_element_hidden(elt))
        continue;
      var v2 = elt.hasAttribute("data-v") ? elt.getAttribute("data-v") : elt.hasAttribute("v") ? elt.getAttribute("v") : htmldecode(elt.innerHTML);
      var z2 = elt.getAttribute("data-z") || elt.getAttribute("z");
      for (midx = 0; midx < merges.length; ++midx) {
        var m2 = merges[midx];
        if (m2.s.c == C2 + or_C && m2.s.r < R2 + or_R && R2 + or_R <= m2.e.r) {
          C2 = m2.e.c + 1 - or_C;
          midx = -1;
        }
      }
      CS = +elt.getAttribute("colspan") || 1;
      if ((RS = +elt.getAttribute("rowspan") || 1) > 1 || CS > 1)
        merges.push({ s: { r: R2 + or_R, c: C2 + or_C }, e: { r: R2 + or_R + (RS || 1) - 1, c: C2 + or_C + (CS || 1) - 1 } });
      var o2 = { t: "s", v: v2 };
      var _t2 = elt.getAttribute("data-t") || elt.getAttribute("t") || "";
      if (v2 != null) {
        if (v2.length == 0)
          o2.t = _t2 || "z";
        else if (opts.raw || v2.trim().length == 0 || _t2 == "s") {
        } else if (v2 === "TRUE")
          o2 = { t: "b", v: true };
        else if (v2 === "FALSE")
          o2 = { t: "b", v: false };
        else if (!isNaN(fuzzynum(v2)))
          o2 = { t: "n", v: fuzzynum(v2) };
        else if (!isNaN(fuzzydate(v2).getDate())) {
          o2 = { t: "d", v: parseDate(v2) };
          if (!opts.cellDates)
            o2 = { t: "n", v: datenum(o2.v) };
          o2.z = opts.dateNF || table_fmt[14];
        }
      }
      if (o2.z === void 0 && z2 != null)
        o2.z = z2;
      var l2 = "", Aelts = elt.getElementsByTagName("A");
      if (Aelts && Aelts.length) {
        for (var Aelti = 0; Aelti < Aelts.length; ++Aelti)
          if (Aelts[Aelti].hasAttribute("href")) {
            l2 = Aelts[Aelti].getAttribute("href");
            if (l2.charAt(0) != "#")
              break;
          }
      }
      if (l2 && l2.charAt(0) != "#")
        o2.l = { Target: l2 };
      if (opts.dense) {
        if (!ws[R2 + or_R])
          ws[R2 + or_R] = [];
        ws[R2 + or_R][C2 + or_C] = o2;
      } else
        ws[encode_cell({ c: C2 + or_C, r: R2 + or_R })] = o2;
      if (range.e.c < C2 + or_C)
        range.e.c = C2 + or_C;
      C2 += CS;
    }
    ++R2;
  }
  if (merges.length)
    ws["!merges"] = (ws["!merges"] || []).concat(merges);
  range.e.r = Math.max(range.e.r, R2 - 1 + or_R);
  ws["!ref"] = encode_range(range);
  if (R2 >= sheetRows)
    ws["!fullref"] = encode_range((range.e.r = rows.length - _R + R2 - 1 + or_R, range));
  return ws;
}
function parse_dom_table(table, _opts) {
  var opts = _opts || {};
  var ws = opts.dense ? [] : {};
  return sheet_add_dom(ws, table, _opts);
}
function table_to_book(table, opts) {
  return sheet_to_workbook(parse_dom_table(table, opts), opts);
}
function is_dom_element_hidden(element) {
  var display = "";
  var get_computed_style = get_get_computed_style_function(element);
  if (get_computed_style)
    display = get_computed_style(element).getPropertyValue("display");
  if (!display)
    display = element.style && element.style.display;
  return display === "none";
}
function get_get_computed_style_function(element) {
  if (element.ownerDocument.defaultView && typeof element.ownerDocument.defaultView.getComputedStyle === "function")
    return element.ownerDocument.defaultView.getComputedStyle;
  if (typeof getComputedStyle === "function")
    return getComputedStyle;
  return null;
}
function parse_text_p(text) {
  var fixed = text.replace(/[\t\r\n]/g, " ").trim().replace(/ +/g, " ").replace(/<text:s\/>/g, " ").replace(/<text:s text:c="(\d+)"\/>/g, function($$, $1) {
    return Array(parseInt($1, 10) + 1).join(" ");
  }).replace(/<text:tab[^>]*\/>/g, "	").replace(/<text:line-break\/>/g, "\n");
  var v2 = unescapexml(fixed.replace(/<[^>]*>/g, ""));
  return [v2];
}
var number_formats_ods = {
  /* ods name: [short ssf fmt, long ssf fmt] */
  day: ["d", "dd"],
  month: ["m", "mm"],
  year: ["y", "yy"],
  hours: ["h", "hh"],
  minutes: ["m", "mm"],
  seconds: ["s", "ss"],
  "am-pm": ["A/P", "AM/PM"],
  "day-of-week": ["ddd", "dddd"],
  era: ["e", "ee"],
  /* there is no native representation of LO "Q" format */
  quarter: ["\\Qm", 'm\\"th quarter"']
};
function parse_content_xml(d2, _opts) {
  var opts = _opts || {};
  if (DENSE != null && opts.dense == null)
    opts.dense = DENSE;
  var str = xlml_normalize(d2);
  var state = [], tmp;
  var tag;
  var NFtag = { name: "" }, NF = "", pidx = 0;
  var sheetag;
  var rowtag;
  var Sheets = {}, SheetNames = [];
  var ws = opts.dense ? [] : {};
  var Rn, q2;
  var ctag = { value: "" };
  var textp = "", textpidx = 0, textptag;
  var textR = [];
  var R2 = -1, C2 = -1, range = { s: { r: 1e6, c: 1e7 }, e: { r: 0, c: 0 } };
  var row_ol = 0;
  var number_format_map = {};
  var merges = [], mrange = {}, mR = 0, mC = 0;
  var rowinfo = [], rowpeat = 1, colpeat = 1;
  var arrayf = [];
  var WB = { Names: [] };
  var atag = {};
  var _Ref = ["", ""];
  var comments = [], comment = {};
  var creator = "", creatoridx = 0;
  var isstub = false, intable = false;
  var i2 = 0;
  xlmlregex.lastIndex = 0;
  str = str.replace(/<!--([\s\S]*?)-->/mg, "").replace(/<!DOCTYPE[^\[]*\[[^\]]*\]>/gm, "");
  while (Rn = xlmlregex.exec(str))
    switch (Rn[3] = Rn[3].replace(/_.*$/, "")) {
      case "table":
      case "\u5DE5\u4F5C\u8868":
        if (Rn[1] === "/") {
          if (range.e.c >= range.s.c && range.e.r >= range.s.r)
            ws["!ref"] = encode_range(range);
          else
            ws["!ref"] = "A1:A1";
          if (opts.sheetRows > 0 && opts.sheetRows <= range.e.r) {
            ws["!fullref"] = ws["!ref"];
            range.e.r = opts.sheetRows - 1;
            ws["!ref"] = encode_range(range);
          }
          if (merges.length)
            ws["!merges"] = merges;
          if (rowinfo.length)
            ws["!rows"] = rowinfo;
          sheetag.name = sheetag["\u540D\u79F0"] || sheetag.name;
          if (typeof JSON !== "undefined")
            JSON.stringify(sheetag);
          SheetNames.push(sheetag.name);
          Sheets[sheetag.name] = ws;
          intable = false;
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/") {
          sheetag = parsexmltag(Rn[0], false);
          R2 = C2 = -1;
          range.s.r = range.s.c = 1e7;
          range.e.r = range.e.c = 0;
          ws = opts.dense ? [] : {};
          merges = [];
          rowinfo = [];
          intable = true;
        }
        break;
      case "table-row-group":
        if (Rn[1] === "/")
          --row_ol;
        else
          ++row_ol;
        break;
      case "table-row":
      case "\u884C":
        if (Rn[1] === "/") {
          R2 += rowpeat;
          rowpeat = 1;
          break;
        }
        rowtag = parsexmltag(Rn[0], false);
        if (rowtag["\u884C\u53F7"])
          R2 = rowtag["\u884C\u53F7"] - 1;
        else if (R2 == -1)
          R2 = 0;
        rowpeat = +rowtag["number-rows-repeated"] || 1;
        if (rowpeat < 10) {
          for (i2 = 0; i2 < rowpeat; ++i2)
            if (row_ol > 0)
              rowinfo[R2 + i2] = { level: row_ol };
        }
        C2 = -1;
        break;
      case "covered-table-cell":
        if (Rn[1] !== "/")
          ++C2;
        if (opts.sheetStubs) {
          if (opts.dense) {
            if (!ws[R2])
              ws[R2] = [];
            ws[R2][C2] = { t: "z" };
          } else
            ws[encode_cell({ r: R2, c: C2 })] = { t: "z" };
        }
        textp = "";
        textR = [];
        break;
      case "table-cell":
      case "\u6570\u636E":
        if (Rn[0].charAt(Rn[0].length - 2) === "/") {
          ++C2;
          ctag = parsexmltag(Rn[0], false);
          colpeat = parseInt(ctag["number-columns-repeated"] || "1", 10);
          q2 = {
            t: "z",
            v: null
            /*:: , z:null, w:"",c:[]*/
          };
          if (ctag.formula && opts.cellFormula != false)
            q2.f = ods_to_csf_formula(unescapexml(ctag.formula));
          if ((ctag["\u6570\u636E\u7C7B\u578B"] || ctag["value-type"]) == "string") {
            q2.t = "s";
            q2.v = unescapexml(ctag["string-value"] || "");
            if (opts.dense) {
              if (!ws[R2])
                ws[R2] = [];
              ws[R2][C2] = q2;
            } else {
              ws[encode_cell({ r: R2, c: C2 })] = q2;
            }
          }
          C2 += colpeat - 1;
        } else if (Rn[1] !== "/") {
          ++C2;
          textp = "";
          textpidx = 0;
          textR = [];
          colpeat = 1;
          var rptR = rowpeat ? R2 + rowpeat - 1 : R2;
          if (C2 > range.e.c)
            range.e.c = C2;
          if (C2 < range.s.c)
            range.s.c = C2;
          if (R2 < range.s.r)
            range.s.r = R2;
          if (rptR > range.e.r)
            range.e.r = rptR;
          ctag = parsexmltag(Rn[0], false);
          comments = [];
          comment = {};
          q2 = {
            t: ctag["\u6570\u636E\u7C7B\u578B"] || ctag["value-type"],
            v: null
            /*:: , z:null, w:"",c:[]*/
          };
          if (opts.cellFormula) {
            if (ctag.formula)
              ctag.formula = unescapexml(ctag.formula);
            if (ctag["number-matrix-columns-spanned"] && ctag["number-matrix-rows-spanned"]) {
              mR = parseInt(ctag["number-matrix-rows-spanned"], 10) || 0;
              mC = parseInt(ctag["number-matrix-columns-spanned"], 10) || 0;
              mrange = { s: { r: R2, c: C2 }, e: { r: R2 + mR - 1, c: C2 + mC - 1 } };
              q2.F = encode_range(mrange);
              arrayf.push([mrange, q2.F]);
            }
            if (ctag.formula)
              q2.f = ods_to_csf_formula(ctag.formula);
            else
              for (i2 = 0; i2 < arrayf.length; ++i2)
                if (R2 >= arrayf[i2][0].s.r && R2 <= arrayf[i2][0].e.r) {
                  if (C2 >= arrayf[i2][0].s.c && C2 <= arrayf[i2][0].e.c)
                    q2.F = arrayf[i2][1];
                }
          }
          if (ctag["number-columns-spanned"] || ctag["number-rows-spanned"]) {
            mR = parseInt(ctag["number-rows-spanned"], 10) || 0;
            mC = parseInt(ctag["number-columns-spanned"], 10) || 0;
            mrange = { s: { r: R2, c: C2 }, e: { r: R2 + mR - 1, c: C2 + mC - 1 } };
            merges.push(mrange);
          }
          if (ctag["number-columns-repeated"])
            colpeat = parseInt(ctag["number-columns-repeated"], 10);
          switch (q2.t) {
            case "boolean":
              q2.t = "b";
              q2.v = parsexmlbool(ctag["boolean-value"]);
              break;
            case "float":
              q2.t = "n";
              q2.v = parseFloat(ctag.value);
              break;
            case "percentage":
              q2.t = "n";
              q2.v = parseFloat(ctag.value);
              break;
            case "currency":
              q2.t = "n";
              q2.v = parseFloat(ctag.value);
              break;
            case "date":
              q2.t = "d";
              q2.v = parseDate(ctag["date-value"]);
              if (!opts.cellDates) {
                q2.t = "n";
                q2.v = datenum(q2.v);
              }
              q2.z = "m/d/yy";
              break;
            case "time":
              q2.t = "n";
              q2.v = parse_isodur(ctag["time-value"]) / 86400;
              if (opts.cellDates) {
                q2.t = "d";
                q2.v = numdate(q2.v);
              }
              q2.z = "HH:MM:SS";
              break;
            case "number":
              q2.t = "n";
              q2.v = parseFloat(ctag["\u6570\u636E\u6570\u503C"]);
              break;
            default:
              if (q2.t === "string" || q2.t === "text" || !q2.t) {
                q2.t = "s";
                if (ctag["string-value"] != null) {
                  textp = unescapexml(ctag["string-value"]);
                  textR = [];
                }
              } else
                throw new Error("Unsupported value type " + q2.t);
          }
        } else {
          isstub = false;
          if (q2.t === "s") {
            q2.v = textp || "";
            if (textR.length)
              q2.R = textR;
            isstub = textpidx == 0;
          }
          if (atag.Target)
            q2.l = atag;
          if (comments.length > 0) {
            q2.c = comments;
            comments = [];
          }
          if (textp && opts.cellText !== false)
            q2.w = textp;
          if (isstub) {
            q2.t = "z";
            delete q2.v;
          }
          if (!isstub || opts.sheetStubs) {
            if (!(opts.sheetRows && opts.sheetRows <= R2)) {
              for (var rpt = 0; rpt < rowpeat; ++rpt) {
                colpeat = parseInt(ctag["number-columns-repeated"] || "1", 10);
                if (opts.dense) {
                  if (!ws[R2 + rpt])
                    ws[R2 + rpt] = [];
                  ws[R2 + rpt][C2] = rpt == 0 ? q2 : dup(q2);
                  while (--colpeat > 0)
                    ws[R2 + rpt][C2 + colpeat] = dup(q2);
                } else {
                  ws[encode_cell({ r: R2 + rpt, c: C2 })] = q2;
                  while (--colpeat > 0)
                    ws[encode_cell({ r: R2 + rpt, c: C2 + colpeat })] = dup(q2);
                }
                if (range.e.c <= C2)
                  range.e.c = C2;
              }
            }
          }
          colpeat = parseInt(ctag["number-columns-repeated"] || "1", 10);
          C2 += colpeat - 1;
          colpeat = 0;
          q2 = {
            /*:: t:"", v:null, z:null, w:"",c:[]*/
          };
          textp = "";
          textR = [];
        }
        atag = {};
        break;
      case "document":
      case "document-content":
      case "\u7535\u5B50\u8868\u683C\u6587\u6863":
      case "spreadsheet":
      case "\u4E3B\u4F53":
      case "scripts":
      case "styles":
      case "font-face-decls":
      case "master-styles":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw "Bad state: " + tmp;
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/")
          state.push([Rn[3], true]);
        break;
      case "annotation":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw "Bad state: " + tmp;
          comment.t = textp;
          if (textR.length)
            comment.R = textR;
          comment.a = creator;
          comments.push(comment);
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/") {
          state.push([Rn[3], false]);
        }
        creator = "";
        creatoridx = 0;
        textp = "";
        textpidx = 0;
        textR = [];
        break;
      case "creator":
        if (Rn[1] === "/") {
          creator = str.slice(creatoridx, Rn.index);
        } else
          creatoridx = Rn.index + Rn[0].length;
        break;
      case "meta":
      case "\u5143\u6570\u636E":
      case "settings":
      case "config-item-set":
      case "config-item-map-indexed":
      case "config-item-map-entry":
      case "config-item-map-named":
      case "shapes":
      case "frame":
      case "text-box":
      case "image":
      case "data-pilot-tables":
      case "list-style":
      case "form":
      case "dde-links":
      case "event-listeners":
      case "chart":
        if (Rn[1] === "/") {
          if ((tmp = state.pop())[0] !== Rn[3])
            throw "Bad state: " + tmp;
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/")
          state.push([Rn[3], false]);
        textp = "";
        textpidx = 0;
        textR = [];
        break;
      case "scientific-number":
        break;
      case "currency-symbol":
        break;
      case "currency-style":
        break;
      case "number-style":
      case "percentage-style":
      case "date-style":
      case "time-style":
        if (Rn[1] === "/") {
          number_format_map[NFtag.name] = NF;
          if ((tmp = state.pop())[0] !== Rn[3])
            throw "Bad state: " + tmp;
        } else if (Rn[0].charAt(Rn[0].length - 2) !== "/") {
          NF = "";
          NFtag = parsexmltag(Rn[0], false);
          state.push([Rn[3], true]);
        }
        break;
      case "script":
        break;
      case "libraries":
        break;
      case "automatic-styles":
        break;
      case "default-style":
      case "page-layout":
        break;
      case "style":
        break;
      case "map":
        break;
      case "font-face":
        break;
      case "paragraph-properties":
        break;
      case "table-properties":
        break;
      case "table-column-properties":
        break;
      case "table-row-properties":
        break;
      case "table-cell-properties":
        break;
      case "number":
        switch (state[state.length - 1][0]) {
          case "time-style":
          case "date-style":
            tag = parsexmltag(Rn[0], false);
            NF += number_formats_ods[Rn[3]][tag.style === "long" ? 1 : 0];
            break;
        }
        break;
      case "fraction":
        break;
      case "day":
      case "month":
      case "year":
      case "era":
      case "day-of-week":
      case "week-of-year":
      case "quarter":
      case "hours":
      case "minutes":
      case "seconds":
      case "am-pm":
        switch (state[state.length - 1][0]) {
          case "time-style":
          case "date-style":
            tag = parsexmltag(Rn[0], false);
            NF += number_formats_ods[Rn[3]][tag.style === "long" ? 1 : 0];
            break;
        }
        break;
      case "boolean-style":
        break;
      case "boolean":
        break;
      case "text-style":
        break;
      case "text":
        if (Rn[0].slice(-2) === "/>")
          break;
        else if (Rn[1] === "/")
          switch (state[state.length - 1][0]) {
            case "number-style":
            case "date-style":
            case "time-style":
              NF += str.slice(pidx, Rn.index);
              break;
          }
        else
          pidx = Rn.index + Rn[0].length;
        break;
      case "named-range":
        tag = parsexmltag(Rn[0], false);
        _Ref = ods_to_csf_3D(tag["cell-range-address"]);
        var nrange = { Name: tag.name, Ref: _Ref[0] + "!" + _Ref[1] };
        if (intable)
          nrange.Sheet = SheetNames.length;
        WB.Names.push(nrange);
        break;
      case "text-content":
        break;
      case "text-properties":
        break;
      case "embedded-text":
        break;
      case "body":
      case "\u7535\u5B50\u8868\u683C":
        break;
      case "forms":
        break;
      case "table-column":
        break;
      case "table-header-rows":
        break;
      case "table-rows":
        break;
      case "table-column-group":
        break;
      case "table-header-columns":
        break;
      case "table-columns":
        break;
      case "null-date":
        break;
      case "graphic-properties":
        break;
      case "calculation-settings":
        break;
      case "named-expressions":
        break;
      case "label-range":
        break;
      case "label-ranges":
        break;
      case "named-expression":
        break;
      case "sort":
        break;
      case "sort-by":
        break;
      case "sort-groups":
        break;
      case "tab":
        break;
      case "line-break":
        break;
      case "span":
        break;
      case "p":
      case "\u6587\u672C\u4E32":
        if (["master-styles"].indexOf(state[state.length - 1][0]) > -1)
          break;
        if (Rn[1] === "/" && (!ctag || !ctag["string-value"])) {
          var ptp = parse_text_p(str.slice(textpidx, Rn.index), textptag);
          textp = (textp.length > 0 ? textp + "\n" : "") + ptp[0];
        } else {
          textptag = parsexmltag(Rn[0], false);
          textpidx = Rn.index + Rn[0].length;
        }
        break;
      case "s":
        break;
      case "database-range":
        if (Rn[1] === "/")
          break;
        try {
          _Ref = ods_to_csf_3D(parsexmltag(Rn[0])["target-range-address"]);
          Sheets[_Ref[0]]["!autofilter"] = { ref: _Ref[1] };
        } catch (e) {
        }
        break;
      case "date":
        break;
      case "object":
        break;
      case "title":
      case "\u6807\u9898":
        break;
      case "desc":
        break;
      case "binary-data":
        break;
      case "table-source":
        break;
      case "scenario":
        break;
      case "iteration":
        break;
      case "content-validations":
        break;
      case "content-validation":
        break;
      case "help-message":
        break;
      case "error-message":
        break;
      case "database-ranges":
        break;
      case "filter":
        break;
      case "filter-and":
        break;
      case "filter-or":
        break;
      case "filter-condition":
        break;
      case "list-level-style-bullet":
        break;
      case "list-level-style-number":
        break;
      case "list-level-properties":
        break;
      case "sender-firstname":
      case "sender-lastname":
      case "sender-initials":
      case "sender-title":
      case "sender-position":
      case "sender-email":
      case "sender-phone-private":
      case "sender-fax":
      case "sender-company":
      case "sender-phone-work":
      case "sender-street":
      case "sender-city":
      case "sender-postal-code":
      case "sender-country":
      case "sender-state-or-province":
      case "author-name":
      case "author-initials":
      case "chapter":
      case "file-name":
      case "template-name":
      case "sheet-name":
        break;
      case "event-listener":
        break;
      case "initial-creator":
      case "creation-date":
      case "print-date":
      case "generator":
      case "document-statistic":
      case "user-defined":
      case "editing-duration":
      case "editing-cycles":
        break;
      case "config-item":
        break;
      case "page-number":
        break;
      case "page-count":
        break;
      case "time":
        break;
      case "cell-range-source":
        break;
      case "detective":
        break;
      case "operation":
        break;
      case "highlighted-range":
        break;
      case "data-pilot-table":
      case "source-cell-range":
      case "source-service":
      case "data-pilot-field":
      case "data-pilot-level":
      case "data-pilot-subtotals":
      case "data-pilot-subtotal":
      case "data-pilot-members":
      case "data-pilot-member":
      case "data-pilot-display-info":
      case "data-pilot-sort-info":
      case "data-pilot-layout-info":
      case "data-pilot-field-reference":
      case "data-pilot-groups":
      case "data-pilot-group":
      case "data-pilot-group-member":
        break;
      case "rect":
        break;
      case "dde-connection-decls":
      case "dde-connection-decl":
      case "dde-link":
      case "dde-source":
        break;
      case "properties":
        break;
      case "property":
        break;
      case "a":
        if (Rn[1] !== "/") {
          atag = parsexmltag(Rn[0], false);
          if (!atag.href)
            break;
          atag.Target = unescapexml(atag.href);
          delete atag.href;
          if (atag.Target.charAt(0) == "#" && atag.Target.indexOf(".") > -1) {
            _Ref = ods_to_csf_3D(atag.Target.slice(1));
            atag.Target = "#" + _Ref[0] + "!" + _Ref[1];
          } else if (atag.Target.match(/^\.\.[\\\/]/))
            atag.Target = atag.Target.slice(3);
        }
        break;
      case "table-protection":
        break;
      case "data-pilot-grand-total":
        break;
      case "office-document-common-attrs":
        break;
      default:
        switch (Rn[2]) {
          case "dc:":
          case "calcext:":
          case "loext:":
          case "ooo:":
          case "chartooo:":
          case "draw:":
          case "style:":
          case "chart:":
          case "form:":
          case "uof:":
          case "\u8868:":
          case "\u5B57:":
            break;
          default:
            if (opts.WTF)
              throw new Error(Rn);
        }
    }
  var out = {
    Sheets,
    SheetNames,
    Workbook: WB
  };
  if (opts.bookSheets)
    delete /*::(*/
    out.Sheets;
  return out;
}
function parse_ods(zip, opts) {
  opts = opts || {};
  if (safegetzipfile(zip, "META-INF/manifest.xml"))
    parse_manifest(getzipdata(zip, "META-INF/manifest.xml"), opts);
  var content = getzipstr(zip, "content.xml");
  if (!content)
    throw new Error("Missing content.xml in ODS / UOF file");
  var wb = parse_content_xml(utf8read(content), opts);
  if (safegetzipfile(zip, "meta.xml"))
    wb.Props = parse_core_props(getzipdata(zip, "meta.xml"));
  return wb;
}
function parse_fods(data, opts) {
  return parse_content_xml(data, opts);
}
var write_styles_ods = /* @__PURE__ */ function() {
  var master_styles = [
    "<office:master-styles>",
    '<style:master-page style:name="mp1" style:page-layout-name="mp1">',
    "<style:header/>",
    '<style:header-left style:display="false"/>',
    "<style:footer/>",
    '<style:footer-left style:display="false"/>',
    "</style:master-page>",
    "</office:master-styles>"
  ].join("");
  var payload = "<office:document-styles " + wxt_helper({
    "xmlns:office": "urn:oasis:names:tc:opendocument:xmlns:office:1.0",
    "xmlns:table": "urn:oasis:names:tc:opendocument:xmlns:table:1.0",
    "xmlns:style": "urn:oasis:names:tc:opendocument:xmlns:style:1.0",
    "xmlns:text": "urn:oasis:names:tc:opendocument:xmlns:text:1.0",
    "xmlns:draw": "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0",
    "xmlns:fo": "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0",
    "xmlns:xlink": "http://www.w3.org/1999/xlink",
    "xmlns:dc": "http://purl.org/dc/elements/1.1/",
    "xmlns:number": "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0",
    "xmlns:svg": "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0",
    "xmlns:of": "urn:oasis:names:tc:opendocument:xmlns:of:1.2",
    "office:version": "1.2"
  }) + ">" + master_styles + "</office:document-styles>";
  return function wso() {
    return XML_HEADER + payload;
  };
}();
var write_content_ods = /* @__PURE__ */ function() {
  var write_text_p = function(text) {
    return escapexml(text).replace(/  +/g, function($$) {
      return '<text:s text:c="' + $$.length + '"/>';
    }).replace(/\t/g, "<text:tab/>").replace(/\n/g, "</text:p><text:p>").replace(/^ /, "<text:s/>").replace(/ $/, "<text:s/>");
  };
  var null_cell_xml = "          <table:table-cell />\n";
  var covered_cell_xml = "          <table:covered-table-cell/>\n";
  var write_ws2 = function(ws, wb, i2) {
    var o2 = [];
    o2.push('      <table:table table:name="' + escapexml(wb.SheetNames[i2]) + '" table:style-name="ta1">\n');
    var R2 = 0, C2 = 0, range = decode_range(ws["!ref"] || "A1");
    var marr = ws["!merges"] || [], mi = 0;
    var dense = Array.isArray(ws);
    if (ws["!cols"]) {
      for (C2 = 0; C2 <= range.e.c; ++C2)
        o2.push("        <table:table-column" + (ws["!cols"][C2] ? ' table:style-name="co' + ws["!cols"][C2].ods + '"' : "") + "></table:table-column>\n");
    }
    var H2 = "", ROWS = ws["!rows"] || [];
    for (R2 = 0; R2 < range.s.r; ++R2) {
      H2 = ROWS[R2] ? ' table:style-name="ro' + ROWS[R2].ods + '"' : "";
      o2.push("        <table:table-row" + H2 + "></table:table-row>\n");
    }
    for (; R2 <= range.e.r; ++R2) {
      H2 = ROWS[R2] ? ' table:style-name="ro' + ROWS[R2].ods + '"' : "";
      o2.push("        <table:table-row" + H2 + ">\n");
      for (C2 = 0; C2 < range.s.c; ++C2)
        o2.push(null_cell_xml);
      for (; C2 <= range.e.c; ++C2) {
        var skip = false, ct2 = {}, textp = "";
        for (mi = 0; mi != marr.length; ++mi) {
          if (marr[mi].s.c > C2)
            continue;
          if (marr[mi].s.r > R2)
            continue;
          if (marr[mi].e.c < C2)
            continue;
          if (marr[mi].e.r < R2)
            continue;
          if (marr[mi].s.c != C2 || marr[mi].s.r != R2)
            skip = true;
          ct2["table:number-columns-spanned"] = marr[mi].e.c - marr[mi].s.c + 1;
          ct2["table:number-rows-spanned"] = marr[mi].e.r - marr[mi].s.r + 1;
          break;
        }
        if (skip) {
          o2.push(covered_cell_xml);
          continue;
        }
        var ref = encode_cell({ r: R2, c: C2 }), cell = dense ? (ws[R2] || [])[C2] : ws[ref];
        if (cell && cell.f) {
          ct2["table:formula"] = escapexml(csf_to_ods_formula(cell.f));
          if (cell.F) {
            if (cell.F.slice(0, ref.length) == ref) {
              var _Fref = decode_range(cell.F);
              ct2["table:number-matrix-columns-spanned"] = _Fref.e.c - _Fref.s.c + 1;
              ct2["table:number-matrix-rows-spanned"] = _Fref.e.r - _Fref.s.r + 1;
            }
          }
        }
        if (!cell) {
          o2.push(null_cell_xml);
          continue;
        }
        switch (cell.t) {
          case "b":
            textp = cell.v ? "TRUE" : "FALSE";
            ct2["office:value-type"] = "boolean";
            ct2["office:boolean-value"] = cell.v ? "true" : "false";
            break;
          case "n":
            textp = cell.w || String(cell.v || 0);
            ct2["office:value-type"] = "float";
            ct2["office:value"] = cell.v || 0;
            break;
          case "s":
          case "str":
            textp = cell.v == null ? "" : cell.v;
            ct2["office:value-type"] = "string";
            break;
          case "d":
            textp = cell.w || parseDate(cell.v).toISOString();
            ct2["office:value-type"] = "date";
            ct2["office:date-value"] = parseDate(cell.v).toISOString();
            ct2["table:style-name"] = "ce1";
            break;
          default:
            o2.push(null_cell_xml);
            continue;
        }
        var text_p = write_text_p(textp);
        if (cell.l && cell.l.Target) {
          var _tgt = cell.l.Target;
          _tgt = _tgt.charAt(0) == "#" ? "#" + csf_to_ods_3D(_tgt.slice(1)) : _tgt;
          if (_tgt.charAt(0) != "#" && !_tgt.match(/^\w+:/))
            _tgt = "../" + _tgt;
          text_p = writextag("text:a", text_p, { "xlink:href": _tgt.replace(/&/g, "&amp;") });
        }
        o2.push("          " + writextag("table:table-cell", writextag("text:p", text_p, {}), ct2) + "\n");
      }
      o2.push("        </table:table-row>\n");
    }
    o2.push("      </table:table>\n");
    return o2.join("");
  };
  var write_automatic_styles_ods = function(o2, wb) {
    o2.push(" <office:automatic-styles>\n");
    o2.push('  <number:date-style style:name="N37" number:automatic-order="true">\n');
    o2.push('   <number:month number:style="long"/>\n');
    o2.push("   <number:text>/</number:text>\n");
    o2.push('   <number:day number:style="long"/>\n');
    o2.push("   <number:text>/</number:text>\n");
    o2.push("   <number:year/>\n");
    o2.push("  </number:date-style>\n");
    var cidx = 0;
    wb.SheetNames.map(function(n2) {
      return wb.Sheets[n2];
    }).forEach(function(ws) {
      if (!ws)
        return;
      if (ws["!cols"]) {
        for (var C2 = 0; C2 < ws["!cols"].length; ++C2)
          if (ws["!cols"][C2]) {
            var colobj = ws["!cols"][C2];
            if (colobj.width == null && colobj.wpx == null && colobj.wch == null)
              continue;
            process_col(colobj);
            colobj.ods = cidx;
            var w2 = ws["!cols"][C2].wpx + "px";
            o2.push('  <style:style style:name="co' + cidx + '" style:family="table-column">\n');
            o2.push('   <style:table-column-properties fo:break-before="auto" style:column-width="' + w2 + '"/>\n');
            o2.push("  </style:style>\n");
            ++cidx;
          }
      }
    });
    var ridx = 0;
    wb.SheetNames.map(function(n2) {
      return wb.Sheets[n2];
    }).forEach(function(ws) {
      if (!ws)
        return;
      if (ws["!rows"]) {
        for (var R2 = 0; R2 < ws["!rows"].length; ++R2)
          if (ws["!rows"][R2]) {
            ws["!rows"][R2].ods = ridx;
            var h2 = ws["!rows"][R2].hpx + "px";
            o2.push('  <style:style style:name="ro' + ridx + '" style:family="table-row">\n');
            o2.push('   <style:table-row-properties fo:break-before="auto" style:row-height="' + h2 + '"/>\n');
            o2.push("  </style:style>\n");
            ++ridx;
          }
      }
    });
    o2.push('  <style:style style:name="ta1" style:family="table" style:master-page-name="mp1">\n');
    o2.push('   <style:table-properties table:display="true" style:writing-mode="lr-tb"/>\n');
    o2.push("  </style:style>\n");
    o2.push('  <style:style style:name="ce1" style:family="table-cell" style:parent-style-name="Default" style:data-style-name="N37"/>\n');
    o2.push(" </office:automatic-styles>\n");
  };
  return function wcx(wb, opts) {
    var o2 = [XML_HEADER];
    var attr = wxt_helper({
      "xmlns:office": "urn:oasis:names:tc:opendocument:xmlns:office:1.0",
      "xmlns:table": "urn:oasis:names:tc:opendocument:xmlns:table:1.0",
      "xmlns:style": "urn:oasis:names:tc:opendocument:xmlns:style:1.0",
      "xmlns:text": "urn:oasis:names:tc:opendocument:xmlns:text:1.0",
      "xmlns:draw": "urn:oasis:names:tc:opendocument:xmlns:drawing:1.0",
      "xmlns:fo": "urn:oasis:names:tc:opendocument:xmlns:xsl-fo-compatible:1.0",
      "xmlns:xlink": "http://www.w3.org/1999/xlink",
      "xmlns:dc": "http://purl.org/dc/elements/1.1/",
      "xmlns:meta": "urn:oasis:names:tc:opendocument:xmlns:meta:1.0",
      "xmlns:number": "urn:oasis:names:tc:opendocument:xmlns:datastyle:1.0",
      "xmlns:presentation": "urn:oasis:names:tc:opendocument:xmlns:presentation:1.0",
      "xmlns:svg": "urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0",
      "xmlns:chart": "urn:oasis:names:tc:opendocument:xmlns:chart:1.0",
      "xmlns:dr3d": "urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0",
      "xmlns:math": "http://www.w3.org/1998/Math/MathML",
      "xmlns:form": "urn:oasis:names:tc:opendocument:xmlns:form:1.0",
      "xmlns:script": "urn:oasis:names:tc:opendocument:xmlns:script:1.0",
      "xmlns:ooo": "http://openoffice.org/2004/office",
      "xmlns:ooow": "http://openoffice.org/2004/writer",
      "xmlns:oooc": "http://openoffice.org/2004/calc",
      "xmlns:dom": "http://www.w3.org/2001/xml-events",
      "xmlns:xforms": "http://www.w3.org/2002/xforms",
      "xmlns:xsd": "http://www.w3.org/2001/XMLSchema",
      "xmlns:xsi": "http://www.w3.org/2001/XMLSchema-instance",
      "xmlns:sheet": "urn:oasis:names:tc:opendocument:sh33tjs:1.0",
      "xmlns:rpt": "http://openoffice.org/2005/report",
      "xmlns:of": "urn:oasis:names:tc:opendocument:xmlns:of:1.2",
      "xmlns:xhtml": "http://www.w3.org/1999/xhtml",
      "xmlns:grddl": "http://www.w3.org/2003/g/data-view#",
      "xmlns:tableooo": "http://openoffice.org/2009/table",
      "xmlns:drawooo": "http://openoffice.org/2010/draw",
      "xmlns:calcext": "urn:org:documentfoundation:names:experimental:calc:xmlns:calcext:1.0",
      "xmlns:loext": "urn:org:documentfoundation:names:experimental:office:xmlns:loext:1.0",
      "xmlns:field": "urn:openoffice:names:experimental:ooo-ms-interop:xmlns:field:1.0",
      "xmlns:formx": "urn:openoffice:names:experimental:ooxml-odf-interop:xmlns:form:1.0",
      "xmlns:css3t": "http://www.w3.org/TR/css3-text/",
      "office:version": "1.2"
    });
    var fods = wxt_helper({
      "xmlns:config": "urn:oasis:names:tc:opendocument:xmlns:config:1.0",
      "office:mimetype": "application/vnd.oasis.opendocument.spreadsheet"
    });
    if (opts.bookType == "fods") {
      o2.push("<office:document" + attr + fods + ">\n");
      o2.push(write_meta_ods().replace(/office:document-meta/g, "office:meta"));
    } else
      o2.push("<office:document-content" + attr + ">\n");
    write_automatic_styles_ods(o2, wb);
    o2.push("  <office:body>\n");
    o2.push("    <office:spreadsheet>\n");
    for (var i2 = 0; i2 != wb.SheetNames.length; ++i2)
      o2.push(write_ws2(wb.Sheets[wb.SheetNames[i2]], wb, i2, opts));
    o2.push("    </office:spreadsheet>\n");
    o2.push("  </office:body>\n");
    if (opts.bookType == "fods")
      o2.push("</office:document>");
    else
      o2.push("</office:document-content>");
    return o2.join("");
  };
}();
function write_ods(wb, opts) {
  if (opts.bookType == "fods")
    return write_content_ods(wb, opts);
  var zip = zip_new();
  var f2 = "";
  var manifest = [];
  var rdf = [];
  f2 = "mimetype";
  zip_add_file(zip, f2, "application/vnd.oasis.opendocument.spreadsheet");
  f2 = "content.xml";
  zip_add_file(zip, f2, write_content_ods(wb, opts));
  manifest.push([f2, "text/xml"]);
  rdf.push([f2, "ContentFile"]);
  f2 = "styles.xml";
  zip_add_file(zip, f2, write_styles_ods(wb, opts));
  manifest.push([f2, "text/xml"]);
  rdf.push([f2, "StylesFile"]);
  f2 = "meta.xml";
  zip_add_file(zip, f2, XML_HEADER + write_meta_ods(
    /*::wb, opts*/
  ));
  manifest.push([f2, "text/xml"]);
  rdf.push([f2, "MetadataFile"]);
  f2 = "manifest.rdf";
  zip_add_file(zip, f2, write_rdf(
    rdf
    /*, opts*/
  ));
  manifest.push([f2, "application/rdf+xml"]);
  f2 = "META-INF/manifest.xml";
  zip_add_file(zip, f2, write_manifest(
    manifest
    /*, opts*/
  ));
  return zip;
}
function u8_to_dataview(array) {
  return new DataView(array.buffer, array.byteOffset, array.byteLength);
}
function u8str(u82) {
  return typeof TextDecoder != "undefined" ? new TextDecoder().decode(u82) : utf8read(a2s(u82));
}
function stru8(str) {
  return typeof TextEncoder != "undefined" ? new TextEncoder().encode(str) : s2a(utf8write(str));
}
function u8contains(body, search) {
  outer:
    for (var L2 = 0; L2 <= body.length - search.length; ++L2) {
      for (var j2 = 0; j2 < search.length; ++j2)
        if (body[L2 + j2] != search[j2])
          continue outer;
      return true;
    }
  return false;
}
function u8concat(u8a) {
  var len = u8a.reduce(function(acc, x2) {
    return acc + x2.length;
  }, 0);
  var out = new Uint8Array(len);
  var off = 0;
  u8a.forEach(function(u82) {
    out.set(u82, off);
    off += u82.length;
  });
  return out;
}
function popcnt(x2) {
  x2 -= x2 >> 1 & 1431655765;
  x2 = (x2 & 858993459) + (x2 >> 2 & 858993459);
  return (x2 + (x2 >> 4) & 252645135) * 16843009 >>> 24;
}
function readDecimal128LE(buf, offset) {
  var exp = (buf[offset + 15] & 127) << 7 | buf[offset + 14] >> 1;
  var mantissa = buf[offset + 14] & 1;
  for (var j2 = offset + 13; j2 >= offset; --j2)
    mantissa = mantissa * 256 + buf[j2];
  return (buf[offset + 15] & 128 ? -mantissa : mantissa) * Math.pow(10, exp - 6176);
}
function writeDecimal128LE(buf, offset, value) {
  var exp = Math.floor(value == 0 ? 0 : Math.LOG10E * Math.log(Math.abs(value))) + 6176 - 20;
  var mantissa = value / Math.pow(10, exp - 6176);
  buf[offset + 15] |= exp >> 7;
  buf[offset + 14] |= (exp & 127) << 1;
  for (var i2 = 0; mantissa >= 1; ++i2, mantissa /= 256)
    buf[offset + i2] = mantissa & 255;
  buf[offset + 15] |= value >= 0 ? 0 : 128;
}
function parse_varint49(buf, ptr) {
  var l2 = ptr ? ptr[0] : 0;
  var usz = buf[l2] & 127;
  varint:
    if (buf[l2++] >= 128) {
      usz |= (buf[l2] & 127) << 7;
      if (buf[l2++] < 128)
        break varint;
      usz |= (buf[l2] & 127) << 14;
      if (buf[l2++] < 128)
        break varint;
      usz |= (buf[l2] & 127) << 21;
      if (buf[l2++] < 128)
        break varint;
      usz += (buf[l2] & 127) * Math.pow(2, 28);
      ++l2;
      if (buf[l2++] < 128)
        break varint;
      usz += (buf[l2] & 127) * Math.pow(2, 35);
      ++l2;
      if (buf[l2++] < 128)
        break varint;
      usz += (buf[l2] & 127) * Math.pow(2, 42);
      ++l2;
      if (buf[l2++] < 128)
        break varint;
    }
  if (ptr)
    ptr[0] = l2;
  return usz;
}
function write_varint49(v2) {
  var usz = new Uint8Array(7);
  usz[0] = v2 & 127;
  var L2 = 1;
  sz:
    if (v2 > 127) {
      usz[L2 - 1] |= 128;
      usz[L2] = v2 >> 7 & 127;
      ++L2;
      if (v2 <= 16383)
        break sz;
      usz[L2 - 1] |= 128;
      usz[L2] = v2 >> 14 & 127;
      ++L2;
      if (v2 <= 2097151)
        break sz;
      usz[L2 - 1] |= 128;
      usz[L2] = v2 >> 21 & 127;
      ++L2;
      if (v2 <= 268435455)
        break sz;
      usz[L2 - 1] |= 128;
      usz[L2] = v2 / 256 >>> 21 & 127;
      ++L2;
      if (v2 <= 34359738367)
        break sz;
      usz[L2 - 1] |= 128;
      usz[L2] = v2 / 65536 >>> 21 & 127;
      ++L2;
      if (v2 <= 4398046511103)
        break sz;
      usz[L2 - 1] |= 128;
      usz[L2] = v2 / 16777216 >>> 21 & 127;
      ++L2;
    }
  return usz.slice(0, L2);
}
function varint_to_i32(buf) {
  var l2 = 0, i322 = buf[l2] & 127;
  varint:
    if (buf[l2++] >= 128) {
      i322 |= (buf[l2] & 127) << 7;
      if (buf[l2++] < 128)
        break varint;
      i322 |= (buf[l2] & 127) << 14;
      if (buf[l2++] < 128)
        break varint;
      i322 |= (buf[l2] & 127) << 21;
      if (buf[l2++] < 128)
        break varint;
      i322 |= (buf[l2] & 127) << 28;
    }
  return i322;
}
function parse_shallow(buf) {
  var out = [], ptr = [0];
  while (ptr[0] < buf.length) {
    var off = ptr[0];
    var num = parse_varint49(buf, ptr);
    var type = num & 7;
    num = Math.floor(num / 8);
    var len = 0;
    var res;
    if (num == 0)
      break;
    switch (type) {
      case 0:
        {
          var l2 = ptr[0];
          while (buf[ptr[0]++] >= 128)
            ;
          res = buf.slice(l2, ptr[0]);
        }
        break;
      case 5:
        len = 4;
        res = buf.slice(ptr[0], ptr[0] + len);
        ptr[0] += len;
        break;
      case 1:
        len = 8;
        res = buf.slice(ptr[0], ptr[0] + len);
        ptr[0] += len;
        break;
      case 2:
        len = parse_varint49(buf, ptr);
        res = buf.slice(ptr[0], ptr[0] + len);
        ptr[0] += len;
        break;
      case 3:
      case 4:
      default:
        throw new Error("PB Type ".concat(type, " for Field ").concat(num, " at offset ").concat(off));
    }
    var v2 = { data: res, type };
    if (out[num] == null)
      out[num] = [v2];
    else
      out[num].push(v2);
  }
  return out;
}
function write_shallow(proto) {
  var out = [];
  proto.forEach(function(field, idx) {
    field.forEach(function(item) {
      if (!item.data)
        return;
      out.push(write_varint49(idx * 8 + item.type));
      if (item.type == 2)
        out.push(write_varint49(item.data.length));
      out.push(item.data);
    });
  });
  return u8concat(out);
}
function mappa(data, cb) {
  return (data == null ? void 0 : data.map(function(d2) {
    return cb(d2.data);
  })) || [];
}
function parse_iwa_file(buf) {
  var _a2;
  var out = [], ptr = [0];
  while (ptr[0] < buf.length) {
    var len = parse_varint49(buf, ptr);
    var ai = parse_shallow(buf.slice(ptr[0], ptr[0] + len));
    ptr[0] += len;
    var res = {
      id: varint_to_i32(ai[1][0].data),
      messages: []
    };
    ai[2].forEach(function(b2) {
      var mi = parse_shallow(b2.data);
      var fl2 = varint_to_i32(mi[3][0].data);
      res.messages.push({
        meta: mi,
        data: buf.slice(ptr[0], ptr[0] + fl2)
      });
      ptr[0] += fl2;
    });
    if ((_a2 = ai[3]) == null ? void 0 : _a2[0])
      res.merge = varint_to_i32(ai[3][0].data) >>> 0 > 0;
    out.push(res);
  }
  return out;
}
function write_iwa_file(ias) {
  var bufs = [];
  ias.forEach(function(ia) {
    var ai = [];
    ai[1] = [{ data: write_varint49(ia.id), type: 0 }];
    ai[2] = [];
    if (ia.merge != null)
      ai[3] = [{ data: write_varint49(+!!ia.merge), type: 0 }];
    var midata = [];
    ia.messages.forEach(function(mi) {
      midata.push(mi.data);
      mi.meta[3] = [{ type: 0, data: write_varint49(mi.data.length) }];
      ai[2].push({ data: write_shallow(mi.meta), type: 2 });
    });
    var aipayload = write_shallow(ai);
    bufs.push(write_varint49(aipayload.length));
    bufs.push(aipayload);
    midata.forEach(function(mid) {
      return bufs.push(mid);
    });
  });
  return u8concat(bufs);
}
function parse_snappy_chunk(type, buf) {
  if (type != 0)
    throw new Error("Unexpected Snappy chunk type ".concat(type));
  var ptr = [0];
  var usz = parse_varint49(buf, ptr);
  var chunks = [];
  while (ptr[0] < buf.length) {
    var tag = buf[ptr[0]] & 3;
    if (tag == 0) {
      var len = buf[ptr[0]++] >> 2;
      if (len < 60)
        ++len;
      else {
        var c2 = len - 59;
        len = buf[ptr[0]];
        if (c2 > 1)
          len |= buf[ptr[0] + 1] << 8;
        if (c2 > 2)
          len |= buf[ptr[0] + 2] << 16;
        if (c2 > 3)
          len |= buf[ptr[0] + 3] << 24;
        len >>>= 0;
        len++;
        ptr[0] += c2;
      }
      chunks.push(buf.slice(ptr[0], ptr[0] + len));
      ptr[0] += len;
      continue;
    } else {
      var offset = 0, length = 0;
      if (tag == 1) {
        length = (buf[ptr[0]] >> 2 & 7) + 4;
        offset = (buf[ptr[0]++] & 224) << 3;
        offset |= buf[ptr[0]++];
      } else {
        length = (buf[ptr[0]++] >> 2) + 1;
        if (tag == 2) {
          offset = buf[ptr[0]] | buf[ptr[0] + 1] << 8;
          ptr[0] += 2;
        } else {
          offset = (buf[ptr[0]] | buf[ptr[0] + 1] << 8 | buf[ptr[0] + 2] << 16 | buf[ptr[0] + 3] << 24) >>> 0;
          ptr[0] += 4;
        }
      }
      chunks = [u8concat(chunks)];
      if (offset == 0)
        throw new Error("Invalid offset 0");
      if (offset > chunks[0].length)
        throw new Error("Invalid offset beyond length");
      if (length >= offset) {
        chunks.push(chunks[0].slice(-offset));
        length -= offset;
        while (length >= chunks[chunks.length - 1].length) {
          chunks.push(chunks[chunks.length - 1]);
          length -= chunks[chunks.length - 1].length;
        }
      }
      chunks.push(chunks[0].slice(-offset, -offset + length));
    }
  }
  var o2 = u8concat(chunks);
  if (o2.length != usz)
    throw new Error("Unexpected length: ".concat(o2.length, " != ").concat(usz));
  return o2;
}
function decompress_iwa_file(buf) {
  var out = [];
  var l2 = 0;
  while (l2 < buf.length) {
    var t2 = buf[l2++];
    var len = buf[l2] | buf[l2 + 1] << 8 | buf[l2 + 2] << 16;
    l2 += 3;
    out.push(parse_snappy_chunk(t2, buf.slice(l2, l2 + len)));
    l2 += len;
  }
  if (l2 !== buf.length)
    throw new Error("data is not a valid framed stream!");
  return u8concat(out);
}
function compress_iwa_file(buf) {
  var out = [];
  var l2 = 0;
  while (l2 < buf.length) {
    var c2 = Math.min(buf.length - l2, 268435455);
    var frame = new Uint8Array(4);
    out.push(frame);
    var usz = write_varint49(c2);
    var L2 = usz.length;
    out.push(usz);
    if (c2 <= 60) {
      L2++;
      out.push(new Uint8Array([c2 - 1 << 2]));
    } else if (c2 <= 256) {
      L2 += 2;
      out.push(new Uint8Array([240, c2 - 1 & 255]));
    } else if (c2 <= 65536) {
      L2 += 3;
      out.push(new Uint8Array([244, c2 - 1 & 255, c2 - 1 >> 8 & 255]));
    } else if (c2 <= 16777216) {
      L2 += 4;
      out.push(new Uint8Array([248, c2 - 1 & 255, c2 - 1 >> 8 & 255, c2 - 1 >> 16 & 255]));
    } else if (c2 <= 4294967296) {
      L2 += 5;
      out.push(new Uint8Array([252, c2 - 1 & 255, c2 - 1 >> 8 & 255, c2 - 1 >> 16 & 255, c2 - 1 >>> 24 & 255]));
    }
    out.push(buf.slice(l2, l2 + c2));
    L2 += c2;
    frame[0] = 0;
    frame[1] = L2 & 255;
    frame[2] = L2 >> 8 & 255;
    frame[3] = L2 >> 16 & 255;
    l2 += c2;
  }
  return u8concat(out);
}
function parse_old_storage(buf, sst, rsst, v2) {
  var dv = u8_to_dataview(buf);
  var flags = dv.getUint32(4, true);
  var data_offset = (v2 > 1 ? 12 : 8) + popcnt(flags & (v2 > 1 ? 3470 : 398)) * 4;
  var ridx = -1, sidx = -1, ieee = NaN, dt2 = new Date(2001, 0, 1);
  if (flags & 512) {
    ridx = dv.getUint32(data_offset, true);
    data_offset += 4;
  }
  data_offset += popcnt(flags & (v2 > 1 ? 12288 : 4096)) * 4;
  if (flags & 16) {
    sidx = dv.getUint32(data_offset, true);
    data_offset += 4;
  }
  if (flags & 32) {
    ieee = dv.getFloat64(data_offset, true);
    data_offset += 8;
  }
  if (flags & 64) {
    dt2.setTime(dt2.getTime() + dv.getFloat64(data_offset, true) * 1e3);
    data_offset += 8;
  }
  var ret;
  switch (buf[2]) {
    case 0:
      break;
    case 2:
      ret = { t: "n", v: ieee };
      break;
    case 3:
      ret = { t: "s", v: sst[sidx] };
      break;
    case 5:
      ret = { t: "d", v: dt2 };
      break;
    case 6:
      ret = { t: "b", v: ieee > 0 };
      break;
    case 7:
      ret = { t: "n", v: ieee / 86400 };
      break;
    case 8:
      ret = { t: "e", v: 0 };
      break;
    case 9:
      {
        if (ridx > -1)
          ret = { t: "s", v: rsst[ridx] };
        else if (sidx > -1)
          ret = { t: "s", v: sst[sidx] };
        else if (!isNaN(ieee))
          ret = { t: "n", v: ieee };
        else
          throw new Error("Unsupported cell type ".concat(buf.slice(0, 4)));
      }
      break;
    default:
      throw new Error("Unsupported cell type ".concat(buf.slice(0, 4)));
  }
  return ret;
}
function parse_new_storage(buf, sst, rsst) {
  var dv = u8_to_dataview(buf);
  var flags = dv.getUint32(8, true);
  var data_offset = 12;
  var ridx = -1, sidx = -1, d128 = NaN, ieee = NaN, dt2 = new Date(2001, 0, 1);
  if (flags & 1) {
    d128 = readDecimal128LE(buf, data_offset);
    data_offset += 16;
  }
  if (flags & 2) {
    ieee = dv.getFloat64(data_offset, true);
    data_offset += 8;
  }
  if (flags & 4) {
    dt2.setTime(dt2.getTime() + dv.getFloat64(data_offset, true) * 1e3);
    data_offset += 8;
  }
  if (flags & 8) {
    sidx = dv.getUint32(data_offset, true);
    data_offset += 4;
  }
  if (flags & 16) {
    ridx = dv.getUint32(data_offset, true);
    data_offset += 4;
  }
  var ret;
  switch (buf[1]) {
    case 0:
      break;
    case 2:
      ret = { t: "n", v: d128 };
      break;
    case 3:
      ret = { t: "s", v: sst[sidx] };
      break;
    case 5:
      ret = { t: "d", v: dt2 };
      break;
    case 6:
      ret = { t: "b", v: ieee > 0 };
      break;
    case 7:
      ret = { t: "n", v: ieee / 86400 };
      break;
    case 8:
      ret = { t: "e", v: 0 };
      break;
    case 9:
      {
        if (ridx > -1)
          ret = { t: "s", v: rsst[ridx] };
        else
          throw new Error("Unsupported cell type ".concat(buf[1], " : ").concat(flags & 31, " : ").concat(buf.slice(0, 4)));
      }
      break;
    case 10:
      ret = { t: "n", v: d128 };
      break;
    default:
      throw new Error("Unsupported cell type ".concat(buf[1], " : ").concat(flags & 31, " : ").concat(buf.slice(0, 4)));
  }
  return ret;
}
function write_new_storage(cell, sst) {
  var out = new Uint8Array(32), dv = u8_to_dataview(out), l2 = 12, flags = 0;
  out[0] = 5;
  switch (cell.t) {
    case "n":
      out[1] = 2;
      writeDecimal128LE(out, l2, cell.v);
      flags |= 1;
      l2 += 16;
      break;
    case "b":
      out[1] = 6;
      dv.setFloat64(l2, cell.v ? 1 : 0, true);
      flags |= 2;
      l2 += 8;
      break;
    case "s":
      if (sst.indexOf(cell.v) == -1)
        throw new Error("Value ".concat(cell.v, " missing from SST!"));
      out[1] = 3;
      dv.setUint32(l2, sst.indexOf(cell.v), true);
      flags |= 8;
      l2 += 4;
      break;
    default:
      throw "unsupported cell type " + cell.t;
  }
  dv.setUint32(8, flags, true);
  return out.slice(0, l2);
}
function write_old_storage(cell, sst) {
  var out = new Uint8Array(32), dv = u8_to_dataview(out), l2 = 12, flags = 0;
  out[0] = 3;
  switch (cell.t) {
    case "n":
      out[2] = 2;
      dv.setFloat64(l2, cell.v, true);
      flags |= 32;
      l2 += 8;
      break;
    case "b":
      out[2] = 6;
      dv.setFloat64(l2, cell.v ? 1 : 0, true);
      flags |= 32;
      l2 += 8;
      break;
    case "s":
      if (sst.indexOf(cell.v) == -1)
        throw new Error("Value ".concat(cell.v, " missing from SST!"));
      out[2] = 3;
      dv.setUint32(l2, sst.indexOf(cell.v), true);
      flags |= 16;
      l2 += 4;
      break;
    default:
      throw "unsupported cell type " + cell.t;
  }
  dv.setUint32(4, flags, true);
  return out.slice(0, l2);
}
function parse_cell_storage(buf, sst, rsst) {
  switch (buf[0]) {
    case 0:
    case 1:
    case 2:
    case 3:
      return parse_old_storage(buf, sst, rsst, buf[0]);
    case 5:
      return parse_new_storage(buf, sst, rsst);
    default:
      throw new Error("Unsupported payload version ".concat(buf[0]));
  }
}
function parse_TSP_Reference(buf) {
  var pb = parse_shallow(buf);
  return parse_varint49(pb[1][0].data);
}
function parse_TST_TableDataList(M2, root) {
  var pb = parse_shallow(root.data);
  var type = varint_to_i32(pb[1][0].data);
  var entries = pb[3];
  var data = [];
  (entries || []).forEach(function(entry) {
    var le2 = parse_shallow(entry.data);
    var key = varint_to_i32(le2[1][0].data) >>> 0;
    switch (type) {
      case 1:
        data[key] = u8str(le2[3][0].data);
        break;
      case 8:
        {
          var rt2 = M2[parse_TSP_Reference(le2[9][0].data)][0];
          var rtp = parse_shallow(rt2.data);
          var rtpref = M2[parse_TSP_Reference(rtp[1][0].data)][0];
          var mtype = varint_to_i32(rtpref.meta[1][0].data);
          if (mtype != 2001)
            throw new Error("2000 unexpected reference to ".concat(mtype));
          var tswpsa = parse_shallow(rtpref.data);
          data[key] = tswpsa[3].map(function(x2) {
            return u8str(x2.data);
          }).join("");
        }
        break;
    }
  });
  return data;
}
function parse_TST_TileRowInfo(u82, type) {
  var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k, _l, _m, _n;
  var pb = parse_shallow(u82);
  var R2 = varint_to_i32(pb[1][0].data) >>> 0;
  var cnt = varint_to_i32(pb[2][0].data) >>> 0;
  var wide_offsets = ((_b2 = (_a2 = pb[8]) == null ? void 0 : _a2[0]) == null ? void 0 : _b2.data) && varint_to_i32(pb[8][0].data) > 0 || false;
  var used_storage_u8, used_storage;
  if (((_d = (_c = pb[7]) == null ? void 0 : _c[0]) == null ? void 0 : _d.data) && type != 0) {
    used_storage_u8 = (_f = (_e = pb[7]) == null ? void 0 : _e[0]) == null ? void 0 : _f.data;
    used_storage = (_h = (_g = pb[6]) == null ? void 0 : _g[0]) == null ? void 0 : _h.data;
  } else if (((_j = (_i = pb[4]) == null ? void 0 : _i[0]) == null ? void 0 : _j.data) && type != 1) {
    used_storage_u8 = (_l = (_k = pb[4]) == null ? void 0 : _k[0]) == null ? void 0 : _l.data;
    used_storage = (_n = (_m = pb[3]) == null ? void 0 : _m[0]) == null ? void 0 : _n.data;
  } else
    throw "NUMBERS Tile missing ".concat(type, " cell storage");
  var width = wide_offsets ? 4 : 1;
  var used_storage_offsets = u8_to_dataview(used_storage_u8);
  var offsets = [];
  for (var C2 = 0; C2 < used_storage_u8.length / 2; ++C2) {
    var off = used_storage_offsets.getUint16(C2 * 2, true);
    if (off < 65535)
      offsets.push([C2, off]);
  }
  if (offsets.length != cnt)
    throw "Expected ".concat(cnt, " cells, found ").concat(offsets.length);
  var cells = [];
  for (C2 = 0; C2 < offsets.length - 1; ++C2)
    cells[offsets[C2][0]] = used_storage.subarray(offsets[C2][1] * width, offsets[C2 + 1][1] * width);
  if (offsets.length >= 1)
    cells[offsets[offsets.length - 1][0]] = used_storage.subarray(offsets[offsets.length - 1][1] * width);
  return { R: R2, cells };
}
function parse_TST_Tile(M2, root) {
  var _a2;
  var pb = parse_shallow(root.data);
  var storage = ((_a2 = pb == null ? void 0 : pb[7]) == null ? void 0 : _a2[0]) ? varint_to_i32(pb[7][0].data) >>> 0 > 0 ? 1 : 0 : -1;
  var ri = mappa(pb[5], function(u82) {
    return parse_TST_TileRowInfo(u82, storage);
  });
  return {
    nrows: varint_to_i32(pb[4][0].data) >>> 0,
    data: ri.reduce(function(acc, x2) {
      if (!acc[x2.R])
        acc[x2.R] = [];
      x2.cells.forEach(function(cell, C2) {
        if (acc[x2.R][C2])
          throw new Error("Duplicate cell r=".concat(x2.R, " c=").concat(C2));
        acc[x2.R][C2] = cell;
      });
      return acc;
    }, [])
  };
}
function parse_TST_TableModelArchive(M2, root, ws) {
  var _a2;
  var pb = parse_shallow(root.data);
  var range = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
  range.e.r = (varint_to_i32(pb[6][0].data) >>> 0) - 1;
  if (range.e.r < 0)
    throw new Error("Invalid row varint ".concat(pb[6][0].data));
  range.e.c = (varint_to_i32(pb[7][0].data) >>> 0) - 1;
  if (range.e.c < 0)
    throw new Error("Invalid col varint ".concat(pb[7][0].data));
  ws["!ref"] = encode_range(range);
  var store = parse_shallow(pb[4][0].data);
  var sst = parse_TST_TableDataList(M2, M2[parse_TSP_Reference(store[4][0].data)][0]);
  var rsst = ((_a2 = store[17]) == null ? void 0 : _a2[0]) ? parse_TST_TableDataList(M2, M2[parse_TSP_Reference(store[17][0].data)][0]) : [];
  var tile = parse_shallow(store[3][0].data);
  var _R = 0;
  tile[1].forEach(function(t2) {
    var tl = parse_shallow(t2.data);
    var ref = M2[parse_TSP_Reference(tl[2][0].data)][0];
    var mtype = varint_to_i32(ref.meta[1][0].data);
    if (mtype != 6002)
      throw new Error("6001 unexpected reference to ".concat(mtype));
    var _tile = parse_TST_Tile(M2, ref);
    _tile.data.forEach(function(row, R2) {
      row.forEach(function(buf, C2) {
        var addr = encode_cell({ r: _R + R2, c: C2 });
        var res = parse_cell_storage(buf, sst, rsst);
        if (res)
          ws[addr] = res;
      });
    });
    _R += _tile.nrows;
  });
}
function parse_TST_TableInfoArchive(M2, root) {
  var pb = parse_shallow(root.data);
  var out = { "!ref": "A1" };
  var tableref = M2[parse_TSP_Reference(pb[2][0].data)];
  var mtype = varint_to_i32(tableref[0].meta[1][0].data);
  if (mtype != 6001)
    throw new Error("6000 unexpected reference to ".concat(mtype));
  parse_TST_TableModelArchive(M2, tableref[0], out);
  return out;
}
function parse_TN_SheetArchive(M2, root) {
  var _a2;
  var pb = parse_shallow(root.data);
  var out = {
    name: ((_a2 = pb[1]) == null ? void 0 : _a2[0]) ? u8str(pb[1][0].data) : "",
    sheets: []
  };
  var shapeoffs = mappa(pb[2], parse_TSP_Reference);
  shapeoffs.forEach(function(off) {
    M2[off].forEach(function(m2) {
      var mtype = varint_to_i32(m2.meta[1][0].data);
      if (mtype == 6e3)
        out.sheets.push(parse_TST_TableInfoArchive(M2, m2));
    });
  });
  return out;
}
function parse_TN_DocumentArchive(M2, root) {
  var out = book_new();
  var pb = parse_shallow(root.data);
  var sheetoffs = mappa(pb[1], parse_TSP_Reference);
  sheetoffs.forEach(function(off) {
    M2[off].forEach(function(m2) {
      var mtype = varint_to_i32(m2.meta[1][0].data);
      if (mtype == 2) {
        var root2 = parse_TN_SheetArchive(M2, m2);
        root2.sheets.forEach(function(sheet, idx) {
          book_append_sheet(out, sheet, idx == 0 ? root2.name : root2.name + "_" + idx, true);
        });
      }
    });
  });
  if (out.SheetNames.length == 0)
    throw new Error("Empty NUMBERS file");
  return out;
}
function parse_numbers_iwa(cfb) {
  var _a2, _b2, _c, _d;
  var M2 = {}, indices = [];
  cfb.FullPaths.forEach(function(p2) {
    if (p2.match(/\.iwpv2/))
      throw new Error("Unsupported password protection");
  });
  cfb.FileIndex.forEach(function(s2) {
    if (!s2.name.match(/\.iwa$/))
      return;
    var o2;
    try {
      o2 = decompress_iwa_file(s2.content);
    } catch (e) {
      return console.log("?? " + s2.content.length + " " + (e.message || e));
    }
    var packets;
    try {
      packets = parse_iwa_file(o2);
    } catch (e) {
      return console.log("## " + (e.message || e));
    }
    packets.forEach(function(packet) {
      M2[packet.id] = packet.messages;
      indices.push(packet.id);
    });
  });
  if (!indices.length)
    throw new Error("File has no messages");
  var docroot = ((_d = (_c = (_b2 = (_a2 = M2 == null ? void 0 : M2[1]) == null ? void 0 : _a2[0]) == null ? void 0 : _b2.meta) == null ? void 0 : _c[1]) == null ? void 0 : _d[0].data) && varint_to_i32(M2[1][0].meta[1][0].data) == 1 && M2[1][0];
  if (!docroot)
    indices.forEach(function(idx) {
      M2[idx].forEach(function(iwam) {
        var mtype = varint_to_i32(iwam.meta[1][0].data) >>> 0;
        if (mtype == 1) {
          if (!docroot)
            docroot = iwam;
          else
            throw new Error("Document has multiple roots");
        }
      });
    });
  if (!docroot)
    throw new Error("Cannot find Document root");
  return parse_TN_DocumentArchive(M2, docroot);
}
function write_tile_row(tri, data, SST) {
  var _a2, _b2, _c, _d;
  if (!((_a2 = tri[6]) == null ? void 0 : _a2[0]) || !((_b2 = tri[7]) == null ? void 0 : _b2[0]))
    throw "Mutation only works on post-BNC storages!";
  var wide_offsets = ((_d = (_c = tri[8]) == null ? void 0 : _c[0]) == null ? void 0 : _d.data) && varint_to_i32(tri[8][0].data) > 0 || false;
  if (wide_offsets)
    throw "Math only works with normal offsets";
  var cnt = 0;
  var dv = u8_to_dataview(tri[7][0].data), last_offset = 0, cell_storage = [];
  var _dv = u8_to_dataview(tri[4][0].data), _last_offset = 0, _cell_storage = [];
  for (var C2 = 0; C2 < data.length; ++C2) {
    if (data[C2] == null) {
      dv.setUint16(C2 * 2, 65535, true);
      _dv.setUint16(C2 * 2, 65535);
      continue;
    }
    dv.setUint16(C2 * 2, last_offset, true);
    _dv.setUint16(C2 * 2, _last_offset, true);
    var celload, _celload;
    switch (typeof data[C2]) {
      case "string":
        celload = write_new_storage({ t: "s", v: data[C2] }, SST);
        _celload = write_old_storage({ t: "s", v: data[C2] }, SST);
        break;
      case "number":
        celload = write_new_storage({ t: "n", v: data[C2] }, SST);
        _celload = write_old_storage({ t: "n", v: data[C2] }, SST);
        break;
      case "boolean":
        celload = write_new_storage({ t: "b", v: data[C2] }, SST);
        _celload = write_old_storage({ t: "b", v: data[C2] }, SST);
        break;
      default:
        throw new Error("Unsupported value " + data[C2]);
    }
    cell_storage.push(celload);
    last_offset += celload.length;
    _cell_storage.push(_celload);
    _last_offset += _celload.length;
    ++cnt;
  }
  tri[2][0].data = write_varint49(cnt);
  for (; C2 < tri[7][0].data.length / 2; ++C2) {
    dv.setUint16(C2 * 2, 65535, true);
    _dv.setUint16(C2 * 2, 65535, true);
  }
  tri[6][0].data = u8concat(cell_storage);
  tri[3][0].data = u8concat(_cell_storage);
  return cnt;
}
function write_numbers_iwa(wb, opts) {
  if (!opts || !opts.numbers)
    throw new Error("Must pass a `numbers` option -- check the README");
  var ws = wb.Sheets[wb.SheetNames[0]];
  if (wb.SheetNames.length > 1)
    console.error("The Numbers writer currently writes only the first table");
  var range = decode_range(ws["!ref"]);
  range.s.r = range.s.c = 0;
  var trunc = false;
  if (range.e.c > 9) {
    trunc = true;
    range.e.c = 9;
  }
  if (range.e.r > 49) {
    trunc = true;
    range.e.r = 49;
  }
  if (trunc)
    console.error("The Numbers writer is currently limited to ".concat(encode_range(range)));
  var data = sheet_to_json(ws, { range, header: 1 });
  var SST = ["~Sh33tJ5~"];
  data.forEach(function(row) {
    return row.forEach(function(cell) {
      if (typeof cell == "string")
        SST.push(cell);
    });
  });
  var dependents = {};
  var indices = [];
  var cfb = CFB.read(opts.numbers, { type: "base64" });
  cfb.FileIndex.map(function(fi, idx) {
    return [fi, cfb.FullPaths[idx]];
  }).forEach(function(row) {
    var fi = row[0], fp = row[1];
    if (fi.type != 2)
      return;
    if (!fi.name.match(/\.iwa/))
      return;
    var old_content = fi.content;
    var raw1 = decompress_iwa_file(old_content);
    var x22 = parse_iwa_file(raw1);
    x22.forEach(function(packet2) {
      indices.push(packet2.id);
      dependents[packet2.id] = { deps: [], location: fp, type: varint_to_i32(packet2.messages[0].meta[1][0].data) };
    });
  });
  indices.sort(function(x22, y22) {
    return x22 - y22;
  });
  var indices_varint = indices.filter(function(x22) {
    return x22 > 1;
  }).map(function(x22) {
    return [x22, write_varint49(x22)];
  });
  cfb.FileIndex.map(function(fi, idx) {
    return [fi, cfb.FullPaths[idx]];
  }).forEach(function(row) {
    var fi = row[0], fp = row[1];
    if (!fi.name.match(/\.iwa/))
      return;
    var x22 = parse_iwa_file(decompress_iwa_file(fi.content));
    x22.forEach(function(ia) {
      ia.messages.forEach(function(m2) {
        indices_varint.forEach(function(ivi) {
          if (ia.messages.some(function(mess) {
            return varint_to_i32(mess.meta[1][0].data) != 11006 && u8contains(mess.data, ivi[1]);
          })) {
            dependents[ivi[0]].deps.push(ia.id);
          }
        });
      });
    });
  });
  function get_unique_msgid() {
    for (var i2 = 927262; i2 < 2e6; ++i2)
      if (!dependents[i2])
        return i2;
    throw new Error("Too many messages");
  }
  var entry = CFB.find(cfb, dependents[1].location);
  var x2 = parse_iwa_file(decompress_iwa_file(entry.content));
  var docroot;
  for (var xi = 0; xi < x2.length; ++xi) {
    var packet = x2[xi];
    if (packet.id == 1)
      docroot = packet;
  }
  var sheetrootref = parse_TSP_Reference(parse_shallow(docroot.messages[0].data)[1][0].data);
  entry = CFB.find(cfb, dependents[sheetrootref].location);
  x2 = parse_iwa_file(decompress_iwa_file(entry.content));
  for (xi = 0; xi < x2.length; ++xi) {
    packet = x2[xi];
    if (packet.id == sheetrootref)
      docroot = packet;
  }
  sheetrootref = parse_TSP_Reference(parse_shallow(docroot.messages[0].data)[2][0].data);
  entry = CFB.find(cfb, dependents[sheetrootref].location);
  x2 = parse_iwa_file(decompress_iwa_file(entry.content));
  for (xi = 0; xi < x2.length; ++xi) {
    packet = x2[xi];
    if (packet.id == sheetrootref)
      docroot = packet;
  }
  sheetrootref = parse_TSP_Reference(parse_shallow(docroot.messages[0].data)[2][0].data);
  entry = CFB.find(cfb, dependents[sheetrootref].location);
  x2 = parse_iwa_file(decompress_iwa_file(entry.content));
  for (xi = 0; xi < x2.length; ++xi) {
    packet = x2[xi];
    if (packet.id == sheetrootref)
      docroot = packet;
  }
  var pb = parse_shallow(docroot.messages[0].data);
  {
    pb[6][0].data = write_varint49(range.e.r + 1);
    pb[7][0].data = write_varint49(range.e.c + 1);
    var cruidsref = parse_TSP_Reference(pb[46][0].data);
    var oldbucket = CFB.find(cfb, dependents[cruidsref].location);
    var _x = parse_iwa_file(decompress_iwa_file(oldbucket.content));
    {
      for (var j2 = 0; j2 < _x.length; ++j2) {
        if (_x[j2].id == cruidsref)
          break;
      }
      if (_x[j2].id != cruidsref)
        throw "Bad ColumnRowUIDMapArchive";
      var cruids = parse_shallow(_x[j2].messages[0].data);
      cruids[1] = [];
      cruids[2] = [], cruids[3] = [];
      for (var C2 = 0; C2 <= range.e.c; ++C2) {
        var uuid = [];
        uuid[1] = uuid[2] = [{ type: 0, data: write_varint49(C2 + 420690) }];
        cruids[1].push({ type: 2, data: write_shallow(uuid) });
        cruids[2].push({ type: 0, data: write_varint49(C2) });
        cruids[3].push({ type: 0, data: write_varint49(C2) });
      }
      cruids[4] = [];
      cruids[5] = [], cruids[6] = [];
      for (var R2 = 0; R2 <= range.e.r; ++R2) {
        uuid = [];
        uuid[1] = uuid[2] = [{ type: 0, data: write_varint49(R2 + 726270) }];
        cruids[4].push({ type: 2, data: write_shallow(uuid) });
        cruids[5].push({ type: 0, data: write_varint49(R2) });
        cruids[6].push({ type: 0, data: write_varint49(R2) });
      }
      _x[j2].messages[0].data = write_shallow(cruids);
    }
    oldbucket.content = compress_iwa_file(write_iwa_file(_x));
    oldbucket.size = oldbucket.content.length;
    delete pb[46];
    var store = parse_shallow(pb[4][0].data);
    {
      store[7][0].data = write_varint49(range.e.r + 1);
      var row_headers = parse_shallow(store[1][0].data);
      var row_header_ref = parse_TSP_Reference(row_headers[2][0].data);
      oldbucket = CFB.find(cfb, dependents[row_header_ref].location);
      _x = parse_iwa_file(decompress_iwa_file(oldbucket.content));
      {
        if (_x[0].id != row_header_ref)
          throw "Bad HeaderStorageBucket";
        var base_bucket = parse_shallow(_x[0].messages[0].data);
        for (R2 = 0; R2 < data.length; ++R2) {
          var _bucket = parse_shallow(base_bucket[2][0].data);
          _bucket[1][0].data = write_varint49(R2);
          _bucket[4][0].data = write_varint49(data[R2].length);
          base_bucket[2][R2] = { type: base_bucket[2][0].type, data: write_shallow(_bucket) };
        }
        _x[0].messages[0].data = write_shallow(base_bucket);
      }
      oldbucket.content = compress_iwa_file(write_iwa_file(_x));
      oldbucket.size = oldbucket.content.length;
      var col_header_ref = parse_TSP_Reference(store[2][0].data);
      oldbucket = CFB.find(cfb, dependents[col_header_ref].location);
      _x = parse_iwa_file(decompress_iwa_file(oldbucket.content));
      {
        if (_x[0].id != col_header_ref)
          throw "Bad HeaderStorageBucket";
        base_bucket = parse_shallow(_x[0].messages[0].data);
        for (C2 = 0; C2 <= range.e.c; ++C2) {
          _bucket = parse_shallow(base_bucket[2][0].data);
          _bucket[1][0].data = write_varint49(C2);
          _bucket[4][0].data = write_varint49(range.e.r + 1);
          base_bucket[2][C2] = { type: base_bucket[2][0].type, data: write_shallow(_bucket) };
        }
        _x[0].messages[0].data = write_shallow(base_bucket);
      }
      oldbucket.content = compress_iwa_file(write_iwa_file(_x));
      oldbucket.size = oldbucket.content.length;
      var sstref = parse_TSP_Reference(store[4][0].data);
      (function() {
        var sentry = CFB.find(cfb, dependents[sstref].location);
        var sx = parse_iwa_file(decompress_iwa_file(sentry.content));
        var sstroot;
        for (var sxi = 0; sxi < sx.length; ++sxi) {
          var packet2 = sx[sxi];
          if (packet2.id == sstref)
            sstroot = packet2;
        }
        var sstdata = parse_shallow(sstroot.messages[0].data);
        {
          sstdata[3] = [];
          var newsst = [];
          SST.forEach(function(str, i2) {
            newsst[1] = [{ type: 0, data: write_varint49(i2) }];
            newsst[2] = [{ type: 0, data: write_varint49(1) }];
            newsst[3] = [{ type: 2, data: stru8(str) }];
            sstdata[3].push({ type: 2, data: write_shallow(newsst) });
          });
        }
        sstroot.messages[0].data = write_shallow(sstdata);
        var sy = write_iwa_file(sx);
        var raw32 = compress_iwa_file(sy);
        sentry.content = raw32;
        sentry.size = sentry.content.length;
      })();
      var tile = parse_shallow(store[3][0].data);
      {
        var t2 = tile[1][0];
        delete tile[2];
        var tl = parse_shallow(t2.data);
        {
          var tileref = parse_TSP_Reference(tl[2][0].data);
          (function() {
            var tentry = CFB.find(cfb, dependents[tileref].location);
            var tx = parse_iwa_file(decompress_iwa_file(tentry.content));
            var tileroot;
            for (var sxi = 0; sxi < tx.length; ++sxi) {
              var packet2 = tx[sxi];
              if (packet2.id == tileref)
                tileroot = packet2;
            }
            var tiledata = parse_shallow(tileroot.messages[0].data);
            {
              delete tiledata[6];
              delete tile[7];
              var rowload = new Uint8Array(tiledata[5][0].data);
              tiledata[5] = [];
              var cnt = 0;
              for (var R22 = 0; R22 <= range.e.r; ++R22) {
                var tilerow = parse_shallow(rowload);
                cnt += write_tile_row(tilerow, data[R22], SST);
                tilerow[1][0].data = write_varint49(R22);
                tiledata[5].push({ data: write_shallow(tilerow), type: 2 });
              }
              tiledata[1] = [{ type: 0, data: write_varint49(range.e.c + 1) }];
              tiledata[2] = [{ type: 0, data: write_varint49(range.e.r + 1) }];
              tiledata[3] = [{ type: 0, data: write_varint49(cnt) }];
              tiledata[4] = [{ type: 0, data: write_varint49(range.e.r + 1) }];
            }
            tileroot.messages[0].data = write_shallow(tiledata);
            var ty = write_iwa_file(tx);
            var raw32 = compress_iwa_file(ty);
            tentry.content = raw32;
            tentry.size = tentry.content.length;
          })();
        }
        t2.data = write_shallow(tl);
      }
      store[3][0].data = write_shallow(tile);
    }
    pb[4][0].data = write_shallow(store);
  }
  docroot.messages[0].data = write_shallow(pb);
  var y2 = write_iwa_file(x2);
  var raw3 = compress_iwa_file(y2);
  entry.content = raw3;
  entry.size = entry.content.length;
  return cfb;
}
function fix_opts_func(defaults) {
  return function fix_opts(opts) {
    for (var i2 = 0; i2 != defaults.length; ++i2) {
      var d2 = defaults[i2];
      if (opts[d2[0]] === void 0)
        opts[d2[0]] = d2[1];
      if (d2[2] === "n")
        opts[d2[0]] = Number(opts[d2[0]]);
    }
  };
}
function fix_read_opts(opts) {
  fix_opts_func([
    ["cellNF", false],
    /* emit cell number format string as .z */
    ["cellHTML", true],
    /* emit html string as .h */
    ["cellFormula", true],
    /* emit formulae as .f */
    ["cellStyles", false],
    /* emits style/theme as .s */
    ["cellText", true],
    /* emit formatted text as .w */
    ["cellDates", false],
    /* emit date cells with type `d` */
    ["sheetStubs", false],
    /* emit empty cells */
    ["sheetRows", 0, "n"],
    /* read n rows (0 = read all rows) */
    ["bookDeps", false],
    /* parse calculation chains */
    ["bookSheets", false],
    /* only try to get sheet names (no Sheets) */
    ["bookProps", false],
    /* only try to get properties (no Sheets) */
    ["bookFiles", false],
    /* include raw file structure (keys, files, cfb) */
    ["bookVBA", false],
    /* include vba raw data (vbaraw) */
    ["password", ""],
    /* password */
    ["WTF", false]
    /* WTF mode (throws errors) */
  ])(opts);
}
function fix_write_opts(opts) {
  fix_opts_func([
    ["cellDates", false],
    /* write date cells with type `d` */
    ["bookSST", false],
    /* Generate Shared String Table */
    ["bookType", "xlsx"],
    /* Type of workbook (xlsx/m/b) */
    ["compression", false],
    /* Use file compression */
    ["WTF", false]
    /* WTF mode (throws errors) */
  ])(opts);
}
function get_sheet_type(n2) {
  if (RELS.WS.indexOf(n2) > -1)
    return "sheet";
  if (RELS.CS && n2 == RELS.CS)
    return "chart";
  if (RELS.DS && n2 == RELS.DS)
    return "dialog";
  if (RELS.MS && n2 == RELS.MS)
    return "macro";
  return n2 && n2.length ? n2 : "sheet";
}
function safe_parse_wbrels(wbrels, sheets) {
  if (!wbrels)
    return 0;
  try {
    wbrels = sheets.map(function pwbr(w2) {
      if (!w2.id)
        w2.id = w2.strRelID;
      return [w2.name, wbrels["!id"][w2.id].Target, get_sheet_type(wbrels["!id"][w2.id].Type)];
    });
  } catch (e) {
    return null;
  }
  return !wbrels || wbrels.length === 0 ? null : wbrels;
}
function safe_parse_sheet(zip, path, relsPath, sheet, idx, sheetRels, sheets, stype, opts, wb, themes, styles) {
  try {
    sheetRels[sheet] = parse_rels(getzipstr(zip, relsPath, true), path);
    var data = getzipdata(zip, path);
    var _ws;
    switch (stype) {
      case "sheet":
        _ws = parse_ws(data, path, idx, opts, sheetRels[sheet], wb, themes, styles);
        break;
      case "chart":
        _ws = parse_cs(data, path, idx, opts, sheetRels[sheet], wb, themes, styles);
        if (!_ws || !_ws["!drawel"])
          break;
        var dfile = resolve_path(_ws["!drawel"].Target, path);
        var drelsp = get_rels_path(dfile);
        var draw = parse_drawing(getzipstr(zip, dfile, true), parse_rels(getzipstr(zip, drelsp, true), dfile));
        var chartp = resolve_path(draw, dfile);
        var crelsp = get_rels_path(chartp);
        _ws = parse_chart(getzipstr(zip, chartp, true), chartp, opts, parse_rels(getzipstr(zip, crelsp, true), chartp), wb, _ws);
        break;
      case "macro":
        _ws = parse_ms(data, path, idx, opts, sheetRels[sheet], wb, themes, styles);
        break;
      case "dialog":
        _ws = parse_ds(data, path, idx, opts, sheetRels[sheet], wb, themes, styles);
        break;
      default:
        throw new Error("Unrecognized sheet type " + stype);
    }
    sheets[sheet] = _ws;
    var tcomments = [];
    if (sheetRels && sheetRels[sheet])
      keys(sheetRels[sheet]).forEach(function(n2) {
        var dfile2 = "";
        if (sheetRels[sheet][n2].Type == RELS.CMNT) {
          dfile2 = resolve_path(sheetRels[sheet][n2].Target, path);
          var comments = parse_cmnt(getzipdata(zip, dfile2, true), dfile2, opts);
          if (!comments || !comments.length)
            return;
          sheet_insert_comments(_ws, comments, false);
        }
        if (sheetRels[sheet][n2].Type == RELS.TCMNT) {
          dfile2 = resolve_path(sheetRels[sheet][n2].Target, path);
          tcomments = tcomments.concat(parse_tcmnt_xml(getzipdata(zip, dfile2, true), opts));
        }
      });
    if (tcomments && tcomments.length)
      sheet_insert_comments(_ws, tcomments, true, opts.people || []);
  } catch (e) {
    if (opts.WTF)
      throw e;
  }
}
function strip_front_slash(x2) {
  return x2.charAt(0) == "/" ? x2.slice(1) : x2;
}
function parse_zip(zip, opts) {
  make_ssf();
  opts = opts || {};
  fix_read_opts(opts);
  if (safegetzipfile(zip, "META-INF/manifest.xml"))
    return parse_ods(zip, opts);
  if (safegetzipfile(zip, "objectdata.xml"))
    return parse_ods(zip, opts);
  if (safegetzipfile(zip, "Index/Document.iwa")) {
    if (typeof Uint8Array == "undefined")
      throw new Error("NUMBERS file parsing requires Uint8Array support");
    if (typeof parse_numbers_iwa != "undefined") {
      if (zip.FileIndex)
        return parse_numbers_iwa(zip);
      var _zip = CFB.utils.cfb_new();
      zipentries(zip).forEach(function(e) {
        zip_add_file(_zip, e, getzipbin(zip, e));
      });
      return parse_numbers_iwa(_zip);
    }
    throw new Error("Unsupported NUMBERS file");
  }
  if (!safegetzipfile(zip, "[Content_Types].xml")) {
    if (safegetzipfile(zip, "index.xml.gz"))
      throw new Error("Unsupported NUMBERS 08 file");
    if (safegetzipfile(zip, "index.xml"))
      throw new Error("Unsupported NUMBERS 09 file");
    throw new Error("Unsupported ZIP file");
  }
  var entries = zipentries(zip);
  var dir = parse_ct(getzipstr(zip, "[Content_Types].xml"));
  var xlsb = false;
  var sheets, binname;
  if (dir.workbooks.length === 0) {
    binname = "xl/workbook.xml";
    if (getzipdata(zip, binname, true))
      dir.workbooks.push(binname);
  }
  if (dir.workbooks.length === 0) {
    binname = "xl/workbook.bin";
    if (!getzipdata(zip, binname, true))
      throw new Error("Could not find workbook");
    dir.workbooks.push(binname);
    xlsb = true;
  }
  if (dir.workbooks[0].slice(-3) == "bin")
    xlsb = true;
  var themes = {};
  var styles = {};
  if (!opts.bookSheets && !opts.bookProps) {
    strs = [];
    if (dir.sst)
      try {
        strs = parse_sst(getzipdata(zip, strip_front_slash(dir.sst)), dir.sst, opts);
      } catch (e) {
        if (opts.WTF)
          throw e;
      }
    if (opts.cellStyles && dir.themes.length)
      themes = parse_theme(getzipstr(zip, dir.themes[0].replace(/^\//, ""), true) || "", dir.themes[0], opts);
    if (dir.style)
      styles = parse_sty(getzipdata(zip, strip_front_slash(dir.style)), dir.style, themes, opts);
  }
  dir.links.map(function(link) {
    try {
      var rels = parse_rels(getzipstr(zip, get_rels_path(strip_front_slash(link))), link);
      return parse_xlink(getzipdata(zip, strip_front_slash(link)), rels, link, opts);
    } catch (e) {
    }
  });
  var wb = parse_wb(getzipdata(zip, strip_front_slash(dir.workbooks[0])), dir.workbooks[0], opts);
  var props = {}, propdata = "";
  if (dir.coreprops.length) {
    propdata = getzipdata(zip, strip_front_slash(dir.coreprops[0]), true);
    if (propdata)
      props = parse_core_props(propdata);
    if (dir.extprops.length !== 0) {
      propdata = getzipdata(zip, strip_front_slash(dir.extprops[0]), true);
      if (propdata)
        parse_ext_props(propdata, props, opts);
    }
  }
  var custprops = {};
  if (!opts.bookSheets || opts.bookProps) {
    if (dir.custprops.length !== 0) {
      propdata = getzipstr(zip, strip_front_slash(dir.custprops[0]), true);
      if (propdata)
        custprops = parse_cust_props(propdata, opts);
    }
  }
  var out = {};
  if (opts.bookSheets || opts.bookProps) {
    if (wb.Sheets)
      sheets = wb.Sheets.map(function pluck(x2) {
        return x2.name;
      });
    else if (props.Worksheets && props.SheetNames.length > 0)
      sheets = props.SheetNames;
    if (opts.bookProps) {
      out.Props = props;
      out.Custprops = custprops;
    }
    if (opts.bookSheets && typeof sheets !== "undefined")
      out.SheetNames = sheets;
    if (opts.bookSheets ? out.SheetNames : opts.bookProps)
      return out;
  }
  sheets = {};
  var deps = {};
  if (opts.bookDeps && dir.calcchain)
    deps = parse_cc(getzipdata(zip, strip_front_slash(dir.calcchain)), dir.calcchain, opts);
  var i2 = 0;
  var sheetRels = {};
  var path, relsPath;
  {
    var wbsheets = wb.Sheets;
    props.Worksheets = wbsheets.length;
    props.SheetNames = [];
    for (var j2 = 0; j2 != wbsheets.length; ++j2) {
      props.SheetNames[j2] = wbsheets[j2].name;
    }
  }
  var wbext = xlsb ? "bin" : "xml";
  var wbrelsi = dir.workbooks[0].lastIndexOf("/");
  var wbrelsfile = (dir.workbooks[0].slice(0, wbrelsi + 1) + "_rels/" + dir.workbooks[0].slice(wbrelsi + 1) + ".rels").replace(/^\//, "");
  if (!safegetzipfile(zip, wbrelsfile))
    wbrelsfile = "xl/_rels/workbook." + wbext + ".rels";
  var wbrels = parse_rels(getzipstr(zip, wbrelsfile, true), wbrelsfile.replace(/_rels.*/, "s5s"));
  if ((dir.metadata || []).length >= 1) {
    opts.xlmeta = parse_xlmeta(getzipdata(zip, strip_front_slash(dir.metadata[0])), dir.metadata[0], opts);
  }
  if ((dir.people || []).length >= 1) {
    opts.people = parse_people_xml(getzipdata(zip, strip_front_slash(dir.people[0])), opts);
  }
  if (wbrels)
    wbrels = safe_parse_wbrels(wbrels, wb.Sheets);
  var nmode = getzipdata(zip, "xl/worksheets/sheet.xml", true) ? 1 : 0;
  wsloop:
    for (i2 = 0; i2 != props.Worksheets; ++i2) {
      var stype = "sheet";
      if (wbrels && wbrels[i2]) {
        path = "xl/" + wbrels[i2][1].replace(/[\/]?xl\//, "");
        if (!safegetzipfile(zip, path))
          path = wbrels[i2][1];
        if (!safegetzipfile(zip, path))
          path = wbrelsfile.replace(/_rels\/.*$/, "") + wbrels[i2][1];
        stype = wbrels[i2][2];
      } else {
        path = "xl/worksheets/sheet" + (i2 + 1 - nmode) + "." + wbext;
        path = path.replace(/sheet0\./, "sheet.");
      }
      relsPath = path.replace(/^(.*)(\/)([^\/]*)$/, "$1/_rels/$3.rels");
      if (opts && opts.sheets != null)
        switch (typeof opts.sheets) {
          case "number":
            if (i2 != opts.sheets)
              continue wsloop;
            break;
          case "string":
            if (props.SheetNames[i2].toLowerCase() != opts.sheets.toLowerCase())
              continue wsloop;
            break;
          default:
            if (Array.isArray && Array.isArray(opts.sheets)) {
              var snjseen = false;
              for (var snj = 0; snj != opts.sheets.length; ++snj) {
                if (typeof opts.sheets[snj] == "number" && opts.sheets[snj] == i2)
                  snjseen = 1;
                if (typeof opts.sheets[snj] == "string" && opts.sheets[snj].toLowerCase() == props.SheetNames[i2].toLowerCase())
                  snjseen = 1;
              }
              if (!snjseen)
                continue wsloop;
            }
        }
      safe_parse_sheet(zip, path, relsPath, props.SheetNames[i2], i2, sheetRels, sheets, stype, opts, wb, themes, styles);
    }
  out = {
    Directory: dir,
    Workbook: wb,
    Props: props,
    Custprops: custprops,
    Deps: deps,
    Sheets: sheets,
    SheetNames: props.SheetNames,
    Strings: strs,
    Styles: styles,
    Themes: themes,
    SSF: dup(table_fmt)
  };
  if (opts && opts.bookFiles) {
    if (zip.files) {
      out.keys = entries;
      out.files = zip.files;
    } else {
      out.keys = [];
      out.files = {};
      zip.FullPaths.forEach(function(p2, idx) {
        p2 = p2.replace(/^Root Entry[\/]/, "");
        out.keys.push(p2);
        out.files[p2] = zip.FileIndex[idx];
      });
    }
  }
  if (opts && opts.bookVBA) {
    if (dir.vba.length > 0)
      out.vbaraw = getzipdata(zip, strip_front_slash(dir.vba[0]), true);
    else if (dir.defaults && dir.defaults.bin === CT_VBA)
      out.vbaraw = getzipdata(zip, "xl/vbaProject.bin", true);
  }
  return out;
}
function parse_xlsxcfb(cfb, _opts) {
  var opts = _opts || {};
  var f2 = "Workbook", data = CFB.find(cfb, f2);
  try {
    f2 = "/!DataSpaces/Version";
    data = CFB.find(cfb, f2);
    if (!data || !data.content)
      throw new Error("ECMA-376 Encrypted file missing " + f2);
    parse_DataSpaceVersionInfo(data.content);
    f2 = "/!DataSpaces/DataSpaceMap";
    data = CFB.find(cfb, f2);
    if (!data || !data.content)
      throw new Error("ECMA-376 Encrypted file missing " + f2);
    var dsm = parse_DataSpaceMap(data.content);
    if (dsm.length !== 1 || dsm[0].comps.length !== 1 || dsm[0].comps[0].t !== 0 || dsm[0].name !== "StrongEncryptionDataSpace" || dsm[0].comps[0].v !== "EncryptedPackage")
      throw new Error("ECMA-376 Encrypted file bad " + f2);
    f2 = "/!DataSpaces/DataSpaceInfo/StrongEncryptionDataSpace";
    data = CFB.find(cfb, f2);
    if (!data || !data.content)
      throw new Error("ECMA-376 Encrypted file missing " + f2);
    var seds = parse_DataSpaceDefinition(data.content);
    if (seds.length != 1 || seds[0] != "StrongEncryptionTransform")
      throw new Error("ECMA-376 Encrypted file bad " + f2);
    f2 = "/!DataSpaces/TransformInfo/StrongEncryptionTransform/!Primary";
    data = CFB.find(cfb, f2);
    if (!data || !data.content)
      throw new Error("ECMA-376 Encrypted file missing " + f2);
    parse_Primary(data.content);
  } catch (e) {
  }
  f2 = "/EncryptionInfo";
  data = CFB.find(cfb, f2);
  if (!data || !data.content)
    throw new Error("ECMA-376 Encrypted file missing " + f2);
  var einfo = parse_EncryptionInfo(data.content);
  f2 = "/EncryptedPackage";
  data = CFB.find(cfb, f2);
  if (!data || !data.content)
    throw new Error("ECMA-376 Encrypted file missing " + f2);
  if (einfo[0] == 4 && typeof decrypt_agile !== "undefined")
    return decrypt_agile(einfo[1], data.content, opts.password || "", opts);
  if (einfo[0] == 2 && typeof decrypt_std76 !== "undefined")
    return decrypt_std76(einfo[1], data.content, opts.password || "", opts);
  throw new Error("File is password-protected");
}
function write_zip(wb, opts) {
  if (opts.bookType == "ods")
    return write_ods(wb, opts);
  if (opts.bookType == "numbers")
    return write_numbers_iwa(wb, opts);
  if (opts.bookType == "xlsb")
    return write_zip_xlsxb(wb, opts);
  return write_zip_xlsx(wb, opts);
}
function write_zip_xlsxb(wb, opts) {
  _shapeid = 1024;
  if (wb && !wb.SSF) {
    wb.SSF = dup(table_fmt);
  }
  if (wb && wb.SSF) {
    make_ssf();
    SSF_load_table(wb.SSF);
    opts.revssf = evert_num(wb.SSF);
    opts.revssf[wb.SSF[65535]] = 0;
    opts.ssf = wb.SSF;
  }
  opts.rels = {};
  opts.wbrels = {};
  opts.Strings = /*::((*/
  [];
  opts.Strings.Count = 0;
  opts.Strings.Unique = 0;
  if (browser_has_Map)
    opts.revStrings = /* @__PURE__ */ new Map();
  else {
    opts.revStrings = {};
    opts.revStrings.foo = [];
    delete opts.revStrings.foo;
  }
  var wbext = opts.bookType == "xlsb" ? "bin" : "xml";
  var vbafmt = VBAFMTS.indexOf(opts.bookType) > -1;
  var ct2 = new_ct();
  fix_write_opts(opts = opts || {});
  var zip = zip_new();
  var f2 = "", rId = 0;
  opts.cellXfs = [];
  get_cell_style(opts.cellXfs, {}, { revssf: { "General": 0 } });
  if (!wb.Props)
    wb.Props = {};
  f2 = "docProps/core.xml";
  zip_add_file(zip, f2, write_core_props(wb.Props, opts));
  ct2.coreprops.push(f2);
  add_rels(opts.rels, 2, f2, RELS.CORE_PROPS);
  f2 = "docProps/app.xml";
  if (wb.Props && wb.Props.SheetNames) {
  } else if (!wb.Workbook || !wb.Workbook.Sheets)
    wb.Props.SheetNames = wb.SheetNames;
  else {
    var _sn = [];
    for (var _i = 0; _i < wb.SheetNames.length; ++_i)
      if ((wb.Workbook.Sheets[_i] || {}).Hidden != 2)
        _sn.push(wb.SheetNames[_i]);
    wb.Props.SheetNames = _sn;
  }
  wb.Props.Worksheets = wb.Props.SheetNames.length;
  zip_add_file(zip, f2, write_ext_props(wb.Props, opts));
  ct2.extprops.push(f2);
  add_rels(opts.rels, 3, f2, RELS.EXT_PROPS);
  if (wb.Custprops !== wb.Props && keys(wb.Custprops || {}).length > 0) {
    f2 = "docProps/custom.xml";
    zip_add_file(zip, f2, write_cust_props(wb.Custprops, opts));
    ct2.custprops.push(f2);
    add_rels(opts.rels, 4, f2, RELS.CUST_PROPS);
  }
  for (rId = 1; rId <= wb.SheetNames.length; ++rId) {
    var wsrels = { "!id": {} };
    var ws = wb.Sheets[wb.SheetNames[rId - 1]];
    var _type = (ws || {})["!type"] || "sheet";
    switch (_type) {
      case "chart":
      default:
        f2 = "xl/worksheets/sheet" + rId + "." + wbext;
        zip_add_file(zip, f2, write_ws(rId - 1, f2, opts, wb, wsrels));
        ct2.sheets.push(f2);
        add_rels(opts.wbrels, -1, "worksheets/sheet" + rId + "." + wbext, RELS.WS[0]);
    }
    if (ws) {
      var comments = ws["!comments"];
      var need_vml = false;
      var cf = "";
      if (comments && comments.length > 0) {
        cf = "xl/comments" + rId + "." + wbext;
        zip_add_file(zip, cf, write_cmnt(comments, cf, opts));
        ct2.comments.push(cf);
        add_rels(wsrels, -1, "../comments" + rId + "." + wbext, RELS.CMNT);
        need_vml = true;
      }
      if (ws["!legacy"]) {
        if (need_vml)
          zip_add_file(zip, "xl/drawings/vmlDrawing" + rId + ".vml", write_comments_vml(rId, ws["!comments"]));
      }
      delete ws["!comments"];
      delete ws["!legacy"];
    }
    if (wsrels["!id"].rId1)
      zip_add_file(zip, get_rels_path(f2), write_rels(wsrels));
  }
  if (opts.Strings != null && opts.Strings.length > 0) {
    f2 = "xl/sharedStrings." + wbext;
    zip_add_file(zip, f2, write_sst(opts.Strings, f2, opts));
    ct2.strs.push(f2);
    add_rels(opts.wbrels, -1, "sharedStrings." + wbext, RELS.SST);
  }
  f2 = "xl/workbook." + wbext;
  zip_add_file(zip, f2, write_wb(wb, f2, opts));
  ct2.workbooks.push(f2);
  add_rels(opts.rels, 1, f2, RELS.WB);
  f2 = "xl/theme/theme1.xml";
  zip_add_file(zip, f2, write_theme(wb.Themes, opts));
  ct2.themes.push(f2);
  add_rels(opts.wbrels, -1, "theme/theme1.xml", RELS.THEME);
  f2 = "xl/styles." + wbext;
  zip_add_file(zip, f2, write_sty(wb, f2, opts));
  ct2.styles.push(f2);
  add_rels(opts.wbrels, -1, "styles." + wbext, RELS.STY);
  if (wb.vbaraw && vbafmt) {
    f2 = "xl/vbaProject.bin";
    zip_add_file(zip, f2, wb.vbaraw);
    ct2.vba.push(f2);
    add_rels(opts.wbrels, -1, "vbaProject.bin", RELS.VBA);
  }
  f2 = "xl/metadata." + wbext;
  zip_add_file(zip, f2, write_xlmeta(f2));
  ct2.metadata.push(f2);
  add_rels(opts.wbrels, -1, "metadata." + wbext, RELS.XLMETA);
  zip_add_file(zip, "[Content_Types].xml", write_ct(ct2, opts));
  zip_add_file(zip, "_rels/.rels", write_rels(opts.rels));
  zip_add_file(zip, "xl/_rels/workbook." + wbext + ".rels", write_rels(opts.wbrels));
  delete opts.revssf;
  delete opts.ssf;
  return zip;
}
function write_zip_xlsx(wb, opts) {
  _shapeid = 1024;
  if (wb && !wb.SSF) {
    wb.SSF = dup(table_fmt);
  }
  if (wb && wb.SSF) {
    make_ssf();
    SSF_load_table(wb.SSF);
    opts.revssf = evert_num(wb.SSF);
    opts.revssf[wb.SSF[65535]] = 0;
    opts.ssf = wb.SSF;
  }
  opts.rels = {};
  opts.wbrels = {};
  opts.Strings = /*::((*/
  [];
  opts.Strings.Count = 0;
  opts.Strings.Unique = 0;
  if (browser_has_Map)
    opts.revStrings = /* @__PURE__ */ new Map();
  else {
    opts.revStrings = {};
    opts.revStrings.foo = [];
    delete opts.revStrings.foo;
  }
  var wbext = "xml";
  var vbafmt = VBAFMTS.indexOf(opts.bookType) > -1;
  var ct2 = new_ct();
  fix_write_opts(opts = opts || {});
  var zip = zip_new();
  var f2 = "", rId = 0;
  opts.cellXfs = [];
  get_cell_style(opts.cellXfs, {}, { revssf: { "General": 0 } });
  if (!wb.Props)
    wb.Props = {};
  f2 = "docProps/core.xml";
  zip_add_file(zip, f2, write_core_props(wb.Props, opts));
  ct2.coreprops.push(f2);
  add_rels(opts.rels, 2, f2, RELS.CORE_PROPS);
  f2 = "docProps/app.xml";
  if (wb.Props && wb.Props.SheetNames) {
  } else if (!wb.Workbook || !wb.Workbook.Sheets)
    wb.Props.SheetNames = wb.SheetNames;
  else {
    var _sn = [];
    for (var _i = 0; _i < wb.SheetNames.length; ++_i)
      if ((wb.Workbook.Sheets[_i] || {}).Hidden != 2)
        _sn.push(wb.SheetNames[_i]);
    wb.Props.SheetNames = _sn;
  }
  wb.Props.Worksheets = wb.Props.SheetNames.length;
  zip_add_file(zip, f2, write_ext_props(wb.Props, opts));
  ct2.extprops.push(f2);
  add_rels(opts.rels, 3, f2, RELS.EXT_PROPS);
  if (wb.Custprops !== wb.Props && keys(wb.Custprops || {}).length > 0) {
    f2 = "docProps/custom.xml";
    zip_add_file(zip, f2, write_cust_props(wb.Custprops, opts));
    ct2.custprops.push(f2);
    add_rels(opts.rels, 4, f2, RELS.CUST_PROPS);
  }
  var people = ["SheetJ5"];
  opts.tcid = 0;
  for (rId = 1; rId <= wb.SheetNames.length; ++rId) {
    var wsrels = { "!id": {} };
    var ws = wb.Sheets[wb.SheetNames[rId - 1]];
    var _type = (ws || {})["!type"] || "sheet";
    switch (_type) {
      case "chart":
      default:
        f2 = "xl/worksheets/sheet" + rId + "." + wbext;
        zip_add_file(zip, f2, write_ws_xml(rId - 1, opts, wb, wsrels));
        ct2.sheets.push(f2);
        add_rels(opts.wbrels, -1, "worksheets/sheet" + rId + "." + wbext, RELS.WS[0]);
    }
    if (ws) {
      var comments = ws["!comments"];
      var need_vml = false;
      var cf = "";
      if (comments && comments.length > 0) {
        var needtc = false;
        comments.forEach(function(carr) {
          carr[1].forEach(function(c2) {
            if (c2.T == true)
              needtc = true;
          });
        });
        if (needtc) {
          cf = "xl/threadedComments/threadedComment" + rId + "." + wbext;
          zip_add_file(zip, cf, write_tcmnt_xml(comments, people, opts));
          ct2.threadedcomments.push(cf);
          add_rels(wsrels, -1, "../threadedComments/threadedComment" + rId + "." + wbext, RELS.TCMNT);
        }
        cf = "xl/comments" + rId + "." + wbext;
        zip_add_file(zip, cf, write_comments_xml(comments, opts));
        ct2.comments.push(cf);
        add_rels(wsrels, -1, "../comments" + rId + "." + wbext, RELS.CMNT);
        need_vml = true;
      }
      if (ws["!legacy"]) {
        if (need_vml)
          zip_add_file(zip, "xl/drawings/vmlDrawing" + rId + ".vml", write_comments_vml(rId, ws["!comments"]));
      }
      delete ws["!comments"];
      delete ws["!legacy"];
    }
    if (wsrels["!id"].rId1)
      zip_add_file(zip, get_rels_path(f2), write_rels(wsrels));
  }
  if (opts.Strings != null && opts.Strings.length > 0) {
    f2 = "xl/sharedStrings." + wbext;
    zip_add_file(zip, f2, write_sst_xml(opts.Strings, opts));
    ct2.strs.push(f2);
    add_rels(opts.wbrels, -1, "sharedStrings." + wbext, RELS.SST);
  }
  f2 = "xl/workbook." + wbext;
  zip_add_file(zip, f2, write_wb_xml(wb, opts));
  ct2.workbooks.push(f2);
  add_rels(opts.rels, 1, f2, RELS.WB);
  f2 = "xl/theme/theme1.xml";
  zip_add_file(zip, f2, write_theme(wb.Themes, opts));
  ct2.themes.push(f2);
  add_rels(opts.wbrels, -1, "theme/theme1.xml", RELS.THEME);
  f2 = "xl/styles." + wbext;
  zip_add_file(zip, f2, write_sty_xml(wb, opts));
  ct2.styles.push(f2);
  add_rels(opts.wbrels, -1, "styles." + wbext, RELS.STY);
  if (wb.vbaraw && vbafmt) {
    f2 = "xl/vbaProject.bin";
    zip_add_file(zip, f2, wb.vbaraw);
    ct2.vba.push(f2);
    add_rels(opts.wbrels, -1, "vbaProject.bin", RELS.VBA);
  }
  f2 = "xl/metadata." + wbext;
  zip_add_file(zip, f2, write_xlmeta_xml());
  ct2.metadata.push(f2);
  add_rels(opts.wbrels, -1, "metadata." + wbext, RELS.XLMETA);
  if (people.length > 1) {
    f2 = "xl/persons/person.xml";
    zip_add_file(zip, f2, write_people_xml(people, opts));
    ct2.people.push(f2);
    add_rels(opts.wbrels, -1, "persons/person.xml", RELS.PEOPLE);
  }
  zip_add_file(zip, "[Content_Types].xml", write_ct(ct2, opts));
  zip_add_file(zip, "_rels/.rels", write_rels(opts.rels));
  zip_add_file(zip, "xl/_rels/workbook." + wbext + ".rels", write_rels(opts.wbrels));
  delete opts.revssf;
  delete opts.ssf;
  return zip;
}
function firstbyte(f2, o2) {
  var x2 = "";
  switch ((o2 || {}).type || "base64") {
    case "buffer":
      return [f2[0], f2[1], f2[2], f2[3], f2[4], f2[5], f2[6], f2[7]];
    case "base64":
      x2 = Base64_decode(f2.slice(0, 12));
      break;
    case "binary":
      x2 = f2;
      break;
    case "array":
      return [f2[0], f2[1], f2[2], f2[3], f2[4], f2[5], f2[6], f2[7]];
    default:
      throw new Error("Unrecognized type " + (o2 && o2.type || "undefined"));
  }
  return [x2.charCodeAt(0), x2.charCodeAt(1), x2.charCodeAt(2), x2.charCodeAt(3), x2.charCodeAt(4), x2.charCodeAt(5), x2.charCodeAt(6), x2.charCodeAt(7)];
}
function read_cfb(cfb, opts) {
  if (CFB.find(cfb, "EncryptedPackage"))
    return parse_xlsxcfb(cfb, opts);
  return parse_xlscfb(cfb, opts);
}
function read_zip(data, opts) {
  var zip, d2 = data;
  var o2 = opts || {};
  if (!o2.type)
    o2.type = has_buf && Buffer.isBuffer(data) ? "buffer" : "base64";
  zip = zip_read(d2, o2);
  return parse_zip(zip, o2);
}
function read_plaintext(data, o2) {
  var i2 = 0;
  main:
    while (i2 < data.length)
      switch (data.charCodeAt(i2)) {
        case 10:
        case 13:
        case 32:
          ++i2;
          break;
        case 60:
          return parse_xlml(data.slice(i2), o2);
        default:
          break main;
      }
  return PRN.to_workbook(data, o2);
}
function read_plaintext_raw(data, o2) {
  var str = "", bytes = firstbyte(data, o2);
  switch (o2.type) {
    case "base64":
      str = Base64_decode(data);
      break;
    case "binary":
      str = data;
      break;
    case "buffer":
      str = data.toString("binary");
      break;
    case "array":
      str = cc2str(data);
      break;
    default:
      throw new Error("Unrecognized type " + o2.type);
  }
  if (bytes[0] == 239 && bytes[1] == 187 && bytes[2] == 191)
    str = utf8read(str);
  o2.type = "binary";
  return read_plaintext(str, o2);
}
function read_utf16(data, o2) {
  var d2 = data;
  if (o2.type == "base64")
    d2 = Base64_decode(d2);
  d2 = $cptable.utils.decode(1200, d2.slice(2), "str");
  o2.type = "binary";
  return read_plaintext(d2, o2);
}
function bstrify(data) {
  return !data.match(/[^\x00-\x7F]/) ? data : utf8write(data);
}
function read_prn(data, d2, o2, str) {
  if (str) {
    o2.type = "string";
    return PRN.to_workbook(data, o2);
  }
  return PRN.to_workbook(d2, o2);
}
function readSync(data, opts) {
  reset_cp();
  var o2 = opts || {};
  if (typeof ArrayBuffer !== "undefined" && data instanceof ArrayBuffer)
    return readSync(new Uint8Array(data), (o2 = dup(o2), o2.type = "array", o2));
  if (typeof Uint8Array !== "undefined" && data instanceof Uint8Array && !o2.type)
    o2.type = typeof Deno !== "undefined" ? "buffer" : "array";
  var d2 = data, n2 = [0, 0, 0, 0], str = false;
  if (o2.cellStyles) {
    o2.cellNF = true;
    o2.sheetStubs = true;
  }
  _ssfopts = {};
  if (o2.dateNF)
    _ssfopts.dateNF = o2.dateNF;
  if (!o2.type)
    o2.type = has_buf && Buffer.isBuffer(data) ? "buffer" : "base64";
  if (o2.type == "file") {
    o2.type = has_buf ? "buffer" : "binary";
    d2 = read_binary(data);
    if (typeof Uint8Array !== "undefined" && !has_buf)
      o2.type = "array";
  }
  if (o2.type == "string") {
    str = true;
    o2.type = "binary";
    o2.codepage = 65001;
    d2 = bstrify(data);
  }
  if (o2.type == "array" && typeof Uint8Array !== "undefined" && data instanceof Uint8Array && typeof ArrayBuffer !== "undefined") {
    var ab = new ArrayBuffer(3), vu = new Uint8Array(ab);
    vu.foo = "bar";
    if (!vu.foo) {
      o2 = dup(o2);
      o2.type = "array";
      return readSync(ab2a(d2), o2);
    }
  }
  switch ((n2 = firstbyte(d2, o2))[0]) {
    case 208:
      if (n2[1] === 207 && n2[2] === 17 && n2[3] === 224 && n2[4] === 161 && n2[5] === 177 && n2[6] === 26 && n2[7] === 225)
        return read_cfb(CFB.read(d2, o2), o2);
      break;
    case 9:
      if (n2[1] <= 8)
        return parse_xlscfb(d2, o2);
      break;
    case 60:
      return parse_xlml(d2, o2);
    case 73:
      if (n2[1] === 73 && n2[2] === 42 && n2[3] === 0)
        throw new Error("TIFF Image File is not a spreadsheet");
      if (n2[1] === 68)
        return read_wb_ID(d2, o2);
      break;
    case 84:
      if (n2[1] === 65 && n2[2] === 66 && n2[3] === 76)
        return DIF.to_workbook(d2, o2);
      break;
    case 80:
      return n2[1] === 75 && n2[2] < 9 && n2[3] < 9 ? read_zip(d2, o2) : read_prn(data, d2, o2, str);
    case 239:
      return n2[3] === 60 ? parse_xlml(d2, o2) : read_prn(data, d2, o2, str);
    case 255:
      if (n2[1] === 254) {
        return read_utf16(d2, o2);
      } else if (n2[1] === 0 && n2[2] === 2 && n2[3] === 0)
        return WK_.to_workbook(d2, o2);
      break;
    case 0:
      if (n2[1] === 0) {
        if (n2[2] >= 2 && n2[3] === 0)
          return WK_.to_workbook(d2, o2);
        if (n2[2] === 0 && (n2[3] === 8 || n2[3] === 9))
          return WK_.to_workbook(d2, o2);
      }
      break;
    case 3:
    case 131:
    case 139:
    case 140:
      return DBF.to_workbook(d2, o2);
    case 123:
      if (n2[1] === 92 && n2[2] === 114 && n2[3] === 116)
        return RTF.to_workbook(d2, o2);
      break;
    case 10:
    case 13:
    case 32:
      return read_plaintext_raw(d2, o2);
    case 137:
      if (n2[1] === 80 && n2[2] === 78 && n2[3] === 71)
        throw new Error("PNG Image File is not a spreadsheet");
      break;
  }
  if (DBF_SUPPORTED_VERSIONS.indexOf(n2[0]) > -1 && n2[2] <= 12 && n2[3] <= 31)
    return DBF.to_workbook(d2, o2);
  return read_prn(data, d2, o2, str);
}
function write_cfb_ctr(cfb, o2) {
  switch (o2.type) {
    case "base64":
    case "binary":
      break;
    case "buffer":
    case "array":
      o2.type = "";
      break;
    case "file":
      return write_dl(o2.file, CFB.write(cfb, { type: has_buf ? "buffer" : "" }));
    case "string":
      throw new Error("'string' output type invalid for '" + o2.bookType + "' files");
    default:
      throw new Error("Unrecognized type " + o2.type);
  }
  return CFB.write(cfb, o2);
}
function write_zip_type(wb, opts) {
  var o2 = dup(opts || {});
  var z2 = write_zip(wb, o2);
  return write_zip_denouement(z2, o2);
}
function write_zip_denouement(z2, o2) {
  var oopts = {};
  var ftype = has_buf ? "nodebuffer" : typeof Uint8Array !== "undefined" ? "array" : "string";
  if (o2.compression)
    oopts.compression = "DEFLATE";
  if (o2.password)
    oopts.type = ftype;
  else
    switch (o2.type) {
      case "base64":
        oopts.type = "base64";
        break;
      case "binary":
        oopts.type = "string";
        break;
      case "string":
        throw new Error("'string' output type invalid for '" + o2.bookType + "' files");
      case "buffer":
      case "file":
        oopts.type = ftype;
        break;
      default:
        throw new Error("Unrecognized type " + o2.type);
    }
  var out = z2.FullPaths ? CFB.write(z2, { fileType: "zip", type: (
    /*::(*/
    { "nodebuffer": "buffer", "string": "binary" }[oopts.type] || oopts.type
  ), compression: !!o2.compression }) : z2.generate(oopts);
  if (typeof Deno !== "undefined") {
    if (typeof out == "string") {
      if (o2.type == "binary" || o2.type == "base64")
        return out;
      out = new Uint8Array(s2ab(out));
    }
  }
  if (o2.password && typeof encrypt_agile !== "undefined")
    return write_cfb_ctr(encrypt_agile(out, o2.password), o2);
  if (o2.type === "file")
    return write_dl(o2.file, out);
  return o2.type == "string" ? utf8read(
    /*::(*/
    out
    /*:: :any)*/
  ) : out;
}
function write_cfb_type(wb, opts) {
  var o2 = opts || {};
  var cfb = write_xlscfb(wb, o2);
  return write_cfb_ctr(cfb, o2);
}
function write_string_type(out, opts, bom) {
  if (!bom)
    bom = "";
  var o2 = bom + out;
  switch (opts.type) {
    case "base64":
      return Base64_encode(utf8write(o2));
    case "binary":
      return utf8write(o2);
    case "string":
      return out;
    case "file":
      return write_dl(opts.file, o2, "utf8");
    case "buffer": {
      if (has_buf)
        return Buffer_from(o2, "utf8");
      else if (typeof TextEncoder !== "undefined")
        return new TextEncoder().encode(o2);
      else
        return write_string_type(o2, { type: "binary" }).split("").map(function(c2) {
          return c2.charCodeAt(0);
        });
    }
  }
  throw new Error("Unrecognized type " + opts.type);
}
function write_stxt_type(out, opts) {
  switch (opts.type) {
    case "base64":
      return Base64_encode(out);
    case "binary":
      return out;
    case "string":
      return out;
    case "file":
      return write_dl(opts.file, out, "binary");
    case "buffer": {
      if (has_buf)
        return Buffer_from(out, "binary");
      else
        return out.split("").map(function(c2) {
          return c2.charCodeAt(0);
        });
    }
  }
  throw new Error("Unrecognized type " + opts.type);
}
function write_binary_type(out, opts) {
  switch (opts.type) {
    case "string":
    case "base64":
    case "binary":
      var bstr = "";
      for (var i2 = 0; i2 < out.length; ++i2)
        bstr += String.fromCharCode(out[i2]);
      return opts.type == "base64" ? Base64_encode(bstr) : opts.type == "string" ? utf8read(bstr) : bstr;
    case "file":
      return write_dl(opts.file, out);
    case "buffer":
      return out;
    default:
      throw new Error("Unrecognized type " + opts.type);
  }
}
function writeSync(wb, opts) {
  reset_cp();
  check_wb(wb);
  var o2 = dup(opts || {});
  if (o2.cellStyles) {
    o2.cellNF = true;
    o2.sheetStubs = true;
  }
  if (o2.type == "array") {
    o2.type = "binary";
    var out = writeSync(wb, o2);
    o2.type = "array";
    return s2ab(out);
  }
  var idx = 0;
  if (o2.sheet) {
    if (typeof o2.sheet == "number")
      idx = o2.sheet;
    else
      idx = wb.SheetNames.indexOf(o2.sheet);
    if (!wb.SheetNames[idx])
      throw new Error("Sheet not found: " + o2.sheet + " : " + typeof o2.sheet);
  }
  switch (o2.bookType || "xlsb") {
    case "xml":
    case "xlml":
      return write_string_type(write_xlml(wb, o2), o2);
    case "slk":
    case "sylk":
      return write_string_type(SYLK.from_sheet(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "htm":
    case "html":
      return write_string_type(sheet_to_html(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "txt":
      return write_stxt_type(sheet_to_txt(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "csv":
      return write_string_type(sheet_to_csv(wb.Sheets[wb.SheetNames[idx]], o2), o2, "\uFEFF");
    case "dif":
      return write_string_type(DIF.from_sheet(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "dbf":
      return write_binary_type(DBF.from_sheet(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "prn":
      return write_string_type(PRN.from_sheet(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "rtf":
      return write_string_type(RTF.from_sheet(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "eth":
      return write_string_type(ETH.from_sheet(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "fods":
      return write_string_type(write_ods(wb, o2), o2);
    case "wk1":
      return write_binary_type(WK_.sheet_to_wk1(wb.Sheets[wb.SheetNames[idx]], o2), o2);
    case "wk3":
      return write_binary_type(WK_.book_to_wk3(wb, o2), o2);
    case "biff2":
      if (!o2.biff)
        o2.biff = 2;
    case "biff3":
      if (!o2.biff)
        o2.biff = 3;
    case "biff4":
      if (!o2.biff)
        o2.biff = 4;
      return write_binary_type(write_biff_buf(wb, o2), o2);
    case "biff5":
      if (!o2.biff)
        o2.biff = 5;
    case "biff8":
    case "xla":
    case "xls":
      if (!o2.biff)
        o2.biff = 8;
      return write_cfb_type(wb, o2);
    case "xlsx":
    case "xlsm":
    case "xlam":
    case "xlsb":
    case "numbers":
    case "ods":
      return write_zip_type(wb, o2);
    default:
      throw new Error("Unrecognized bookType |" + o2.bookType + "|");
  }
}
function resolve_book_type(o2) {
  if (o2.bookType)
    return;
  var _BT = {
    "xls": "biff8",
    "htm": "html",
    "slk": "sylk",
    "socialcalc": "eth",
    "Sh33tJS": "WTF"
  };
  var ext = o2.file.slice(o2.file.lastIndexOf(".")).toLowerCase();
  if (ext.match(/^\.[a-z]+$/))
    o2.bookType = ext.slice(1);
  o2.bookType = _BT[o2.bookType] || o2.bookType;
}
function writeFileSync(wb, filename, opts) {
  var o2 = opts || {};
  o2.type = "file";
  o2.file = filename;
  resolve_book_type(o2);
  return writeSync(wb, o2);
}
function make_json_row(sheet, r, R2, cols, header, hdr, dense, o2) {
  var rr = encode_row(R2);
  var defval = o2.defval, raw = o2.raw || !Object.prototype.hasOwnProperty.call(o2, "raw");
  var isempty = true;
  var row = header === 1 ? [] : {};
  if (header !== 1) {
    if (Object.defineProperty)
      try {
        Object.defineProperty(row, "__rowNum__", { value: R2, enumerable: false });
      } catch (e) {
        row.__rowNum__ = R2;
      }
    else
      row.__rowNum__ = R2;
  }
  if (!dense || sheet[R2])
    for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
      var val = dense ? sheet[R2][C2] : sheet[cols[C2] + rr];
      if (val === void 0 || val.t === void 0) {
        if (defval === void 0)
          continue;
        if (hdr[C2] != null) {
          row[hdr[C2]] = defval;
        }
        continue;
      }
      var v2 = val.v;
      switch (val.t) {
        case "z":
          if (v2 == null)
            break;
          continue;
        case "e":
          v2 = v2 == 0 ? null : void 0;
          break;
        case "s":
        case "d":
        case "b":
        case "n":
          break;
        default:
          throw new Error("unrecognized type " + val.t);
      }
      if (hdr[C2] != null) {
        if (v2 == null) {
          if (val.t == "e" && v2 === null)
            row[hdr[C2]] = null;
          else if (defval !== void 0)
            row[hdr[C2]] = defval;
          else if (raw && v2 === null)
            row[hdr[C2]] = null;
          else
            continue;
        } else {
          row[hdr[C2]] = raw && (val.t !== "n" || val.t === "n" && o2.rawNumbers !== false) ? v2 : format_cell(val, v2, o2);
        }
        if (v2 != null)
          isempty = false;
      }
    }
  return { row, isempty };
}
function sheet_to_json(sheet, opts) {
  if (sheet == null || sheet["!ref"] == null)
    return [];
  var val = { t: "n", v: 0 }, header = 0, offset = 1, hdr = [], v2 = 0, vv = "";
  var r = { s: { r: 0, c: 0 }, e: { r: 0, c: 0 } };
  var o2 = opts || {};
  var range = o2.range != null ? o2.range : sheet["!ref"];
  if (o2.header === 1)
    header = 1;
  else if (o2.header === "A")
    header = 2;
  else if (Array.isArray(o2.header))
    header = 3;
  else if (o2.header == null)
    header = 0;
  switch (typeof range) {
    case "string":
      r = safe_decode_range(range);
      break;
    case "number":
      r = safe_decode_range(sheet["!ref"]);
      r.s.r = range;
      break;
    default:
      r = range;
  }
  if (header > 0)
    offset = 0;
  var rr = encode_row(r.s.r);
  var cols = [];
  var out = [];
  var outi = 0, counter = 0;
  var dense = Array.isArray(sheet);
  var R2 = r.s.r, C2 = 0;
  var header_cnt = {};
  if (dense && !sheet[R2])
    sheet[R2] = [];
  var colinfo = o2.skipHidden && sheet["!cols"] || [];
  var rowinfo = o2.skipHidden && sheet["!rows"] || [];
  for (C2 = r.s.c; C2 <= r.e.c; ++C2) {
    if ((colinfo[C2] || {}).hidden)
      continue;
    cols[C2] = encode_col(C2);
    val = dense ? sheet[R2][C2] : sheet[cols[C2] + rr];
    switch (header) {
      case 1:
        hdr[C2] = C2 - r.s.c;
        break;
      case 2:
        hdr[C2] = cols[C2];
        break;
      case 3:
        hdr[C2] = o2.header[C2 - r.s.c];
        break;
      default:
        if (val == null)
          val = { w: "__EMPTY", t: "s" };
        vv = v2 = format_cell(val, null, o2);
        counter = header_cnt[v2] || 0;
        if (!counter)
          header_cnt[v2] = 1;
        else {
          do {
            vv = v2 + "_" + counter++;
          } while (header_cnt[vv]);
          header_cnt[v2] = counter;
          header_cnt[vv] = 1;
        }
        hdr[C2] = vv;
    }
  }
  for (R2 = r.s.r + offset; R2 <= r.e.r; ++R2) {
    if ((rowinfo[R2] || {}).hidden)
      continue;
    var row = make_json_row(sheet, r, R2, cols, header, hdr, dense, o2);
    if (row.isempty === false || (header === 1 ? o2.blankrows !== false : !!o2.blankrows))
      out[outi++] = row.row;
  }
  out.length = outi;
  return out;
}
var qreg = /"/g;
function make_csv_row(sheet, r, R2, cols, fs, rs, FS, o2) {
  var isempty = true;
  var row = [], txt = "", rr = encode_row(R2);
  for (var C2 = r.s.c; C2 <= r.e.c; ++C2) {
    if (!cols[C2])
      continue;
    var val = o2.dense ? (sheet[R2] || [])[C2] : sheet[cols[C2] + rr];
    if (val == null)
      txt = "";
    else if (val.v != null) {
      isempty = false;
      txt = "" + (o2.rawNumbers && val.t == "n" ? val.v : format_cell(val, null, o2));
      for (var i2 = 0, cc = 0; i2 !== txt.length; ++i2)
        if ((cc = txt.charCodeAt(i2)) === fs || cc === rs || cc === 34 || o2.forceQuotes) {
          txt = '"' + txt.replace(qreg, '""') + '"';
          break;
        }
      if (txt == "ID")
        txt = '"ID"';
    } else if (val.f != null && !val.F) {
      isempty = false;
      txt = "=" + val.f;
      if (txt.indexOf(",") >= 0)
        txt = '"' + txt.replace(qreg, '""') + '"';
    } else
      txt = "";
    row.push(txt);
  }
  if (o2.blankrows === false && isempty)
    return null;
  return row.join(FS);
}
function sheet_to_csv(sheet, opts) {
  var out = [];
  var o2 = opts == null ? {} : opts;
  if (sheet == null || sheet["!ref"] == null)
    return "";
  var r = safe_decode_range(sheet["!ref"]);
  var FS = o2.FS !== void 0 ? o2.FS : ",", fs = FS.charCodeAt(0);
  var RS = o2.RS !== void 0 ? o2.RS : "\n", rs = RS.charCodeAt(0);
  var endregex = new RegExp((FS == "|" ? "\\|" : FS) + "+$");
  var row = "", cols = [];
  o2.dense = Array.isArray(sheet);
  var colinfo = o2.skipHidden && sheet["!cols"] || [];
  var rowinfo = o2.skipHidden && sheet["!rows"] || [];
  for (var C2 = r.s.c; C2 <= r.e.c; ++C2)
    if (!(colinfo[C2] || {}).hidden)
      cols[C2] = encode_col(C2);
  var w2 = 0;
  for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
    if ((rowinfo[R2] || {}).hidden)
      continue;
    row = make_csv_row(sheet, r, R2, cols, fs, rs, FS, o2);
    if (row == null) {
      continue;
    }
    if (o2.strip)
      row = row.replace(endregex, "");
    if (row || o2.blankrows !== false)
      out.push((w2++ ? RS : "") + row);
  }
  delete o2.dense;
  return out.join("");
}
function sheet_to_txt(sheet, opts) {
  if (!opts)
    opts = {};
  opts.FS = "	";
  opts.RS = "\n";
  var s2 = sheet_to_csv(sheet, opts);
  if (typeof $cptable == "undefined" || opts.type == "string")
    return s2;
  var o2 = $cptable.utils.encode(1200, s2, "str");
  return String.fromCharCode(255) + String.fromCharCode(254) + o2;
}
function sheet_to_formulae(sheet) {
  var y2 = "", x2, val = "";
  if (sheet == null || sheet["!ref"] == null)
    return [];
  var r = safe_decode_range(sheet["!ref"]), rr = "", cols = [], C2;
  var cmds = [];
  var dense = Array.isArray(sheet);
  for (C2 = r.s.c; C2 <= r.e.c; ++C2)
    cols[C2] = encode_col(C2);
  for (var R2 = r.s.r; R2 <= r.e.r; ++R2) {
    rr = encode_row(R2);
    for (C2 = r.s.c; C2 <= r.e.c; ++C2) {
      y2 = cols[C2] + rr;
      x2 = dense ? (sheet[R2] || [])[C2] : sheet[y2];
      val = "";
      if (x2 === void 0)
        continue;
      else if (x2.F != null) {
        y2 = x2.F;
        if (!x2.f)
          continue;
        val = x2.f;
        if (y2.indexOf(":") == -1)
          y2 = y2 + ":" + y2;
      }
      if (x2.f != null)
        val = x2.f;
      else if (x2.t == "z")
        continue;
      else if (x2.t == "n" && x2.v != null)
        val = "" + x2.v;
      else if (x2.t == "b")
        val = x2.v ? "TRUE" : "FALSE";
      else if (x2.w !== void 0)
        val = "'" + x2.w;
      else if (x2.v === void 0)
        continue;
      else if (x2.t == "s")
        val = "'" + x2.v;
      else
        val = "" + x2.v;
      cmds[cmds.length] = y2 + "=" + val;
    }
  }
  return cmds;
}
function sheet_add_json(_ws, js, opts) {
  var o2 = opts || {};
  var offset = +!o2.skipHeader;
  var ws = _ws || {};
  var _R = 0, _C = 0;
  if (ws && o2.origin != null) {
    if (typeof o2.origin == "number")
      _R = o2.origin;
    else {
      var _origin = typeof o2.origin == "string" ? decode_cell(o2.origin) : o2.origin;
      _R = _origin.r;
      _C = _origin.c;
    }
  }
  var cell;
  var range = { s: { c: 0, r: 0 }, e: { c: _C, r: _R + js.length - 1 + offset } };
  if (ws["!ref"]) {
    var _range = safe_decode_range(ws["!ref"]);
    range.e.c = Math.max(range.e.c, _range.e.c);
    range.e.r = Math.max(range.e.r, _range.e.r);
    if (_R == -1) {
      _R = _range.e.r + 1;
      range.e.r = _R + js.length - 1 + offset;
    }
  } else {
    if (_R == -1) {
      _R = 0;
      range.e.r = js.length - 1 + offset;
    }
  }
  var hdr = o2.header || [], C2 = 0;
  js.forEach(function(JS, R2) {
    keys(JS).forEach(function(k2) {
      if ((C2 = hdr.indexOf(k2)) == -1)
        hdr[C2 = hdr.length] = k2;
      var v2 = JS[k2];
      var t2 = "z";
      var z2 = "";
      var ref = encode_cell({ c: _C + C2, r: _R + R2 + offset });
      cell = ws_get_cell_stub(ws, ref);
      if (v2 && typeof v2 === "object" && !(v2 instanceof Date)) {
        ws[ref] = v2;
      } else {
        if (typeof v2 == "number")
          t2 = "n";
        else if (typeof v2 == "boolean")
          t2 = "b";
        else if (typeof v2 == "string")
          t2 = "s";
        else if (v2 instanceof Date) {
          t2 = "d";
          if (!o2.cellDates) {
            t2 = "n";
            v2 = datenum(v2);
          }
          z2 = o2.dateNF || table_fmt[14];
        } else if (v2 === null && o2.nullError) {
          t2 = "e";
          v2 = 0;
        }
        if (!cell)
          ws[ref] = cell = { t: t2, v: v2 };
        else {
          cell.t = t2;
          cell.v = v2;
          delete cell.w;
          delete cell.R;
          if (z2)
            cell.z = z2;
        }
        if (z2)
          cell.z = z2;
      }
    });
  });
  range.e.c = Math.max(range.e.c, _C + hdr.length - 1);
  var __R = encode_row(_R);
  if (offset)
    for (C2 = 0; C2 < hdr.length; ++C2)
      ws[encode_col(C2 + _C) + __R] = { t: "s", v: hdr[C2] };
  ws["!ref"] = encode_range(range);
  return ws;
}
function json_to_sheet(js, opts) {
  return sheet_add_json(null, js, opts);
}
function ws_get_cell_stub(ws, R2, C2) {
  if (typeof R2 == "string") {
    if (Array.isArray(ws)) {
      var RC = decode_cell(R2);
      if (!ws[RC.r])
        ws[RC.r] = [];
      return ws[RC.r][RC.c] || (ws[RC.r][RC.c] = { t: "z" });
    }
    return ws[R2] || (ws[R2] = { t: "z" });
  }
  if (typeof R2 != "number")
    return ws_get_cell_stub(ws, encode_cell(R2));
  return ws_get_cell_stub(ws, encode_cell({ r: R2, c: C2 || 0 }));
}
function wb_sheet_idx(wb, sh) {
  if (typeof sh == "number") {
    if (sh >= 0 && wb.SheetNames.length > sh)
      return sh;
    throw new Error("Cannot find sheet # " + sh);
  } else if (typeof sh == "string") {
    var idx = wb.SheetNames.indexOf(sh);
    if (idx > -1)
      return idx;
    throw new Error("Cannot find sheet name |" + sh + "|");
  } else
    throw new Error("Cannot find sheet |" + sh + "|");
}
function book_new() {
  return { SheetNames: [], Sheets: {} };
}
function book_append_sheet(wb, ws, name, roll) {
  var i2 = 1;
  if (!name) {
    for (; i2 <= 65535; ++i2, name = void 0)
      if (wb.SheetNames.indexOf(name = "Sheet" + i2) == -1)
        break;
  }
  if (!name || wb.SheetNames.length >= 65535)
    throw new Error("Too many worksheets");
  if (roll && wb.SheetNames.indexOf(name) >= 0) {
    var m2 = name.match(/(^.*?)(\d+)$/);
    i2 = m2 && +m2[2] || 0;
    var root = m2 && m2[1] || name;
    for (++i2; i2 <= 65535; ++i2)
      if (wb.SheetNames.indexOf(name = root + i2) == -1)
        break;
  }
  check_ws_name(name);
  if (wb.SheetNames.indexOf(name) >= 0)
    throw new Error("Worksheet with name |" + name + "| already exists!");
  wb.SheetNames.push(name);
  wb.Sheets[name] = ws;
  return name;
}
function book_set_sheet_visibility(wb, sh, vis) {
  if (!wb.Workbook)
    wb.Workbook = {};
  if (!wb.Workbook.Sheets)
    wb.Workbook.Sheets = [];
  var idx = wb_sheet_idx(wb, sh);
  if (!wb.Workbook.Sheets[idx])
    wb.Workbook.Sheets[idx] = {};
  switch (vis) {
    case 0:
    case 1:
    case 2:
      break;
    default:
      throw new Error("Bad sheet visibility setting " + vis);
  }
  wb.Workbook.Sheets[idx].Hidden = vis;
}
function cell_set_number_format(cell, fmt) {
  cell.z = fmt;
  return cell;
}
function cell_set_hyperlink(cell, target, tooltip) {
  if (!target) {
    delete cell.l;
  } else {
    cell.l = { Target: target };
    if (tooltip)
      cell.l.Tooltip = tooltip;
  }
  return cell;
}
function cell_set_internal_link(cell, range, tooltip) {
  return cell_set_hyperlink(cell, "#" + range, tooltip);
}
function cell_add_comment(cell, text, author) {
  if (!cell.c)
    cell.c = [];
  cell.c.push({ t: text, a: author || "SheetJS" });
}
function sheet_set_array_formula(ws, range, formula, dynamic) {
  var rng = typeof range != "string" ? range : safe_decode_range(range);
  var rngstr = typeof range == "string" ? range : encode_range(range);
  for (var R2 = rng.s.r; R2 <= rng.e.r; ++R2)
    for (var C2 = rng.s.c; C2 <= rng.e.c; ++C2) {
      var cell = ws_get_cell_stub(ws, R2, C2);
      cell.t = "n";
      cell.F = rngstr;
      delete cell.v;
      if (R2 == rng.s.r && C2 == rng.s.c) {
        cell.f = formula;
        if (dynamic)
          cell.D = true;
      }
    }
  return ws;
}
var utils = {
  encode_col,
  encode_row,
  encode_cell,
  encode_range,
  decode_col,
  decode_row,
  split_cell,
  decode_cell,
  decode_range,
  format_cell,
  sheet_add_aoa,
  sheet_add_json,
  sheet_add_dom,
  aoa_to_sheet,
  json_to_sheet,
  table_to_sheet: parse_dom_table,
  table_to_book,
  sheet_to_csv,
  sheet_to_txt,
  sheet_to_json,
  sheet_to_html,
  sheet_to_formulae,
  sheet_to_row_object_array: sheet_to_json,
  sheet_get_cell: ws_get_cell_stub,
  book_new,
  book_append_sheet,
  book_set_sheet_visibility,
  cell_set_number_format,
  cell_set_hyperlink,
  cell_set_internal_link,
  cell_add_comment,
  sheet_set_array_formula,
  consts: {
    SHEET_VISIBLE: 0,
    SHEET_HIDDEN: 1,
    SHEET_VERY_HIDDEN: 2
  }
};
var version = XLSX.version;

// node_modules/fflate/esm/browser.js
var u8 = Uint8Array;
var u16 = Uint16Array;
var i32 = Int32Array;
var fleb = new u8([
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  0,
  1,
  1,
  1,
  1,
  2,
  2,
  2,
  2,
  3,
  3,
  3,
  3,
  4,
  4,
  4,
  4,
  5,
  5,
  5,
  5,
  0,
  /* unused */
  0,
  0,
  /* impossible */
  0
]);
var fdeb = new u8([
  0,
  0,
  0,
  0,
  1,
  1,
  2,
  2,
  3,
  3,
  4,
  4,
  5,
  5,
  6,
  6,
  7,
  7,
  8,
  8,
  9,
  9,
  10,
  10,
  11,
  11,
  12,
  12,
  13,
  13,
  /* unused */
  0,
  0
]);
var clim = new u8([16, 17, 18, 0, 8, 7, 9, 6, 10, 5, 11, 4, 12, 3, 13, 2, 14, 1, 15]);
var freb = function(eb, start) {
  var b2 = new u16(31);
  for (var i2 = 0; i2 < 31; ++i2) {
    b2[i2] = start += 1 << eb[i2 - 1];
  }
  var r = new i32(b2[30]);
  for (var i2 = 1; i2 < 30; ++i2) {
    for (var j2 = b2[i2]; j2 < b2[i2 + 1]; ++j2) {
      r[j2] = j2 - b2[i2] << 5 | i2;
    }
  }
  return { b: b2, r };
};
var _a = freb(fleb, 2);
var fl = _a.b;
var revfl = _a.r;
fl[28] = 258, revfl[258] = 28;
var _b = freb(fdeb, 0);
var fd = _b.b;
var revfd = _b.r;
var rev = new u16(32768);
for (i2 = 0; i2 < 32768; ++i2) {
  x2 = (i2 & 43690) >> 1 | (i2 & 21845) << 1;
  x2 = (x2 & 52428) >> 2 | (x2 & 13107) << 2;
  x2 = (x2 & 61680) >> 4 | (x2 & 3855) << 4;
  rev[i2] = ((x2 & 65280) >> 8 | (x2 & 255) << 8) >> 1;
}
var x2;
var i2;
var hMap = function(cd, mb, r) {
  var s2 = cd.length;
  var i2 = 0;
  var l2 = new u16(mb);
  for (; i2 < s2; ++i2) {
    if (cd[i2])
      ++l2[cd[i2] - 1];
  }
  var le2 = new u16(mb);
  for (i2 = 1; i2 < mb; ++i2) {
    le2[i2] = le2[i2 - 1] + l2[i2 - 1] << 1;
  }
  var co;
  if (r) {
    co = new u16(1 << mb);
    var rvb = 15 - mb;
    for (i2 = 0; i2 < s2; ++i2) {
      if (cd[i2]) {
        var sv = i2 << 4 | cd[i2];
        var r_1 = mb - cd[i2];
        var v2 = le2[cd[i2] - 1]++ << r_1;
        for (var m2 = v2 | (1 << r_1) - 1; v2 <= m2; ++v2) {
          co[rev[v2] >> rvb] = sv;
        }
      }
    }
  } else {
    co = new u16(s2);
    for (i2 = 0; i2 < s2; ++i2) {
      if (cd[i2]) {
        co[i2] = rev[le2[cd[i2] - 1]++] >> 15 - cd[i2];
      }
    }
  }
  return co;
};
var flt = new u8(288);
for (i2 = 0; i2 < 144; ++i2)
  flt[i2] = 8;
var i2;
for (i2 = 144; i2 < 256; ++i2)
  flt[i2] = 9;
var i2;
for (i2 = 256; i2 < 280; ++i2)
  flt[i2] = 7;
var i2;
for (i2 = 280; i2 < 288; ++i2)
  flt[i2] = 8;
var i2;
var fdt = new u8(32);
for (i2 = 0; i2 < 32; ++i2)
  fdt[i2] = 5;
var i2;
var flm = /* @__PURE__ */ hMap(flt, 9, 0);
var flrm = /* @__PURE__ */ hMap(flt, 9, 1);
var fdm = /* @__PURE__ */ hMap(fdt, 5, 0);
var fdrm = /* @__PURE__ */ hMap(fdt, 5, 1);
var max = function(a2) {
  var m2 = a2[0];
  for (var i2 = 1; i2 < a2.length; ++i2) {
    if (a2[i2] > m2)
      m2 = a2[i2];
  }
  return m2;
};
var bits = function(d2, p2, m2) {
  var o2 = p2 / 8 | 0;
  return (d2[o2] | d2[o2 + 1] << 8) >> (p2 & 7) & m2;
};
var bits16 = function(d2, p2) {
  var o2 = p2 / 8 | 0;
  return (d2[o2] | d2[o2 + 1] << 8 | d2[o2 + 2] << 16) >> (p2 & 7);
};
var shft = function(p2) {
  return (p2 + 7) / 8 | 0;
};
var slc = function(v2, s2, e) {
  if (s2 == null || s2 < 0)
    s2 = 0;
  if (e == null || e > v2.length)
    e = v2.length;
  return new u8(v2.subarray(s2, e));
};
var ec = [
  "unexpected EOF",
  "invalid block type",
  "invalid length/literal",
  "invalid distance",
  "stream finished",
  "no stream handler",
  ,
  "no callback",
  "invalid UTF-8 data",
  "extra field too long",
  "date not in range 1980-2099",
  "filename too long",
  "stream finishing",
  "invalid zip data"
  // determined by unknown compression method
];
var err = function(ind, msg, nt2) {
  var e = new Error(msg || ec[ind]);
  e.code = ind;
  if (Error.captureStackTrace)
    Error.captureStackTrace(e, err);
  if (!nt2)
    throw e;
  return e;
};
var inflt = function(dat, st2, buf, dict) {
  var sl = dat.length, dl = dict ? dict.length : 0;
  if (!sl || st2.f && !st2.l)
    return buf || new u8(0);
  var noBuf = !buf;
  var resize = noBuf || st2.i != 2;
  var noSt = st2.i;
  if (noBuf)
    buf = new u8(sl * 3);
  var cbuf = function(l3) {
    var bl = buf.length;
    if (l3 > bl) {
      var nbuf = new u8(Math.max(bl * 2, l3));
      nbuf.set(buf);
      buf = nbuf;
    }
  };
  var final = st2.f || 0, pos = st2.p || 0, bt2 = st2.b || 0, lm = st2.l, dm = st2.d, lbt = st2.m, dbt = st2.n;
  var tbts = sl * 8;
  do {
    if (!lm) {
      final = bits(dat, pos, 1);
      var type = bits(dat, pos + 1, 3);
      pos += 3;
      if (!type) {
        var s2 = shft(pos) + 4, l2 = dat[s2 - 4] | dat[s2 - 3] << 8, t2 = s2 + l2;
        if (t2 > sl) {
          if (noSt)
            err(0);
          break;
        }
        if (resize)
          cbuf(bt2 + l2);
        buf.set(dat.subarray(s2, t2), bt2);
        st2.b = bt2 += l2, st2.p = pos = t2 * 8, st2.f = final;
        continue;
      } else if (type == 1)
        lm = flrm, dm = fdrm, lbt = 9, dbt = 5;
      else if (type == 2) {
        var hLit = bits(dat, pos, 31) + 257, hcLen = bits(dat, pos + 10, 15) + 4;
        var tl = hLit + bits(dat, pos + 5, 31) + 1;
        pos += 14;
        var ldt = new u8(tl);
        var clt = new u8(19);
        for (var i2 = 0; i2 < hcLen; ++i2) {
          clt[clim[i2]] = bits(dat, pos + i2 * 3, 7);
        }
        pos += hcLen * 3;
        var clb = max(clt), clbmsk = (1 << clb) - 1;
        var clm = hMap(clt, clb, 1);
        for (var i2 = 0; i2 < tl; ) {
          var r = clm[bits(dat, pos, clbmsk)];
          pos += r & 15;
          var s2 = r >> 4;
          if (s2 < 16) {
            ldt[i2++] = s2;
          } else {
            var c2 = 0, n2 = 0;
            if (s2 == 16)
              n2 = 3 + bits(dat, pos, 3), pos += 2, c2 = ldt[i2 - 1];
            else if (s2 == 17)
              n2 = 3 + bits(dat, pos, 7), pos += 3;
            else if (s2 == 18)
              n2 = 11 + bits(dat, pos, 127), pos += 7;
            while (n2--)
              ldt[i2++] = c2;
          }
        }
        var lt2 = ldt.subarray(0, hLit), dt2 = ldt.subarray(hLit);
        lbt = max(lt2);
        dbt = max(dt2);
        lm = hMap(lt2, lbt, 1);
        dm = hMap(dt2, dbt, 1);
      } else
        err(1);
      if (pos > tbts) {
        if (noSt)
          err(0);
        break;
      }
    }
    if (resize)
      cbuf(bt2 + 131072);
    var lms = (1 << lbt) - 1, dms = (1 << dbt) - 1;
    var lpos = pos;
    for (; ; lpos = pos) {
      var c2 = lm[bits16(dat, pos) & lms], sym = c2 >> 4;
      pos += c2 & 15;
      if (pos > tbts) {
        if (noSt)
          err(0);
        break;
      }
      if (!c2)
        err(2);
      if (sym < 256)
        buf[bt2++] = sym;
      else if (sym == 256) {
        lpos = pos, lm = null;
        break;
      } else {
        var add = sym - 254;
        if (sym > 264) {
          var i2 = sym - 257, b2 = fleb[i2];
          add = bits(dat, pos, (1 << b2) - 1) + fl[i2];
          pos += b2;
        }
        var d2 = dm[bits16(dat, pos) & dms], dsym = d2 >> 4;
        if (!d2)
          err(3);
        pos += d2 & 15;
        var dt2 = fd[dsym];
        if (dsym > 3) {
          var b2 = fdeb[dsym];
          dt2 += bits16(dat, pos) & (1 << b2) - 1, pos += b2;
        }
        if (pos > tbts) {
          if (noSt)
            err(0);
          break;
        }
        if (resize)
          cbuf(bt2 + 131072);
        var end = bt2 + add;
        if (bt2 < dt2) {
          var shift = dl - dt2, dend = Math.min(dt2, end);
          if (shift + bt2 < 0)
            err(3);
          for (; bt2 < dend; ++bt2)
            buf[bt2] = dict[shift + bt2];
        }
        for (; bt2 < end; ++bt2)
          buf[bt2] = buf[bt2 - dt2];
      }
    }
    st2.l = lm, st2.p = lpos, st2.b = bt2, st2.f = final;
    if (lm)
      final = 1, st2.m = lbt, st2.d = dm, st2.n = dbt;
  } while (!final);
  return bt2 != buf.length && noBuf ? slc(buf, 0, bt2) : buf.subarray(0, bt2);
};
var wbits = function(d2, p2, v2) {
  v2 <<= p2 & 7;
  var o2 = p2 / 8 | 0;
  d2[o2] |= v2;
  d2[o2 + 1] |= v2 >> 8;
};
var wbits16 = function(d2, p2, v2) {
  v2 <<= p2 & 7;
  var o2 = p2 / 8 | 0;
  d2[o2] |= v2;
  d2[o2 + 1] |= v2 >> 8;
  d2[o2 + 2] |= v2 >> 16;
};
var hTree = function(d2, mb) {
  var t2 = [];
  for (var i2 = 0; i2 < d2.length; ++i2) {
    if (d2[i2])
      t2.push({ s: i2, f: d2[i2] });
  }
  var s2 = t2.length;
  var t22 = t2.slice();
  if (!s2)
    return { t: et, l: 0 };
  if (s2 == 1) {
    var v2 = new u8(t2[0].s + 1);
    v2[t2[0].s] = 1;
    return { t: v2, l: 1 };
  }
  t2.sort(function(a2, b2) {
    return a2.f - b2.f;
  });
  t2.push({ s: -1, f: 25001 });
  var l2 = t2[0], r = t2[1], i0 = 0, i1 = 1, i22 = 2;
  t2[0] = { s: -1, f: l2.f + r.f, l: l2, r };
  while (i1 != s2 - 1) {
    l2 = t2[t2[i0].f < t2[i22].f ? i0++ : i22++];
    r = t2[i0 != i1 && t2[i0].f < t2[i22].f ? i0++ : i22++];
    t2[i1++] = { s: -1, f: l2.f + r.f, l: l2, r };
  }
  var maxSym = t22[0].s;
  for (var i2 = 1; i2 < s2; ++i2) {
    if (t22[i2].s > maxSym)
      maxSym = t22[i2].s;
  }
  var tr = new u16(maxSym + 1);
  var mbt = ln(t2[i1 - 1], tr, 0);
  if (mbt > mb) {
    var i2 = 0, dt2 = 0;
    var lft = mbt - mb, cst = 1 << lft;
    t22.sort(function(a2, b2) {
      return tr[b2.s] - tr[a2.s] || a2.f - b2.f;
    });
    for (; i2 < s2; ++i2) {
      var i2_1 = t22[i2].s;
      if (tr[i2_1] > mb) {
        dt2 += cst - (1 << mbt - tr[i2_1]);
        tr[i2_1] = mb;
      } else
        break;
    }
    dt2 >>= lft;
    while (dt2 > 0) {
      var i2_2 = t22[i2].s;
      if (tr[i2_2] < mb)
        dt2 -= 1 << mb - tr[i2_2]++ - 1;
      else
        ++i2;
    }
    for (; i2 >= 0 && dt2; --i2) {
      var i2_3 = t22[i2].s;
      if (tr[i2_3] == mb) {
        --tr[i2_3];
        ++dt2;
      }
    }
    mbt = mb;
  }
  return { t: new u8(tr), l: mbt };
};
var ln = function(n2, l2, d2) {
  return n2.s == -1 ? Math.max(ln(n2.l, l2, d2 + 1), ln(n2.r, l2, d2 + 1)) : l2[n2.s] = d2;
};
var lc = function(c2) {
  var s2 = c2.length;
  while (s2 && !c2[--s2])
    ;
  var cl = new u16(++s2);
  var cli = 0, cln = c2[0], cls = 1;
  var w2 = function(v2) {
    cl[cli++] = v2;
  };
  for (var i2 = 1; i2 <= s2; ++i2) {
    if (c2[i2] == cln && i2 != s2)
      ++cls;
    else {
      if (!cln && cls > 2) {
        for (; cls > 138; cls -= 138)
          w2(32754);
        if (cls > 2) {
          w2(cls > 10 ? cls - 11 << 5 | 28690 : cls - 3 << 5 | 12305);
          cls = 0;
        }
      } else if (cls > 3) {
        w2(cln), --cls;
        for (; cls > 6; cls -= 6)
          w2(8304);
        if (cls > 2)
          w2(cls - 3 << 5 | 8208), cls = 0;
      }
      while (cls--)
        w2(cln);
      cls = 1;
      cln = c2[i2];
    }
  }
  return { c: cl.subarray(0, cli), n: s2 };
};
var clen = function(cf, cl) {
  var l2 = 0;
  for (var i2 = 0; i2 < cl.length; ++i2)
    l2 += cf[i2] * cl[i2];
  return l2;
};
var wfblk = function(out, pos, dat) {
  var s2 = dat.length;
  var o2 = shft(pos + 2);
  out[o2] = s2 & 255;
  out[o2 + 1] = s2 >> 8;
  out[o2 + 2] = out[o2] ^ 255;
  out[o2 + 3] = out[o2 + 1] ^ 255;
  for (var i2 = 0; i2 < s2; ++i2)
    out[o2 + i2 + 4] = dat[i2];
  return (o2 + 4 + s2) * 8;
};
var wblk = function(dat, out, final, syms, lf, df, eb, li, bs, bl, p2) {
  wbits(out, p2++, final);
  ++lf[256];
  var _a2 = hTree(lf, 15), dlt = _a2.t, mlb = _a2.l;
  var _b2 = hTree(df, 15), ddt = _b2.t, mdb = _b2.l;
  var _c = lc(dlt), lclt = _c.c, nlc = _c.n;
  var _d = lc(ddt), lcdt = _d.c, ndc = _d.n;
  var lcfreq = new u16(19);
  for (var i2 = 0; i2 < lclt.length; ++i2)
    ++lcfreq[lclt[i2] & 31];
  for (var i2 = 0; i2 < lcdt.length; ++i2)
    ++lcfreq[lcdt[i2] & 31];
  var _e = hTree(lcfreq, 7), lct = _e.t, mlcb = _e.l;
  var nlcc = 19;
  for (; nlcc > 4 && !lct[clim[nlcc - 1]]; --nlcc)
    ;
  var flen = bl + 5 << 3;
  var ftlen = clen(lf, flt) + clen(df, fdt) + eb;
  var dtlen = clen(lf, dlt) + clen(df, ddt) + eb + 14 + 3 * nlcc + clen(lcfreq, lct) + 2 * lcfreq[16] + 3 * lcfreq[17] + 7 * lcfreq[18];
  if (bs >= 0 && flen <= ftlen && flen <= dtlen)
    return wfblk(out, p2, dat.subarray(bs, bs + bl));
  var lm, ll, dm, dl;
  wbits(out, p2, 1 + (dtlen < ftlen)), p2 += 2;
  if (dtlen < ftlen) {
    lm = hMap(dlt, mlb, 0), ll = dlt, dm = hMap(ddt, mdb, 0), dl = ddt;
    var llm = hMap(lct, mlcb, 0);
    wbits(out, p2, nlc - 257);
    wbits(out, p2 + 5, ndc - 1);
    wbits(out, p2 + 10, nlcc - 4);
    p2 += 14;
    for (var i2 = 0; i2 < nlcc; ++i2)
      wbits(out, p2 + 3 * i2, lct[clim[i2]]);
    p2 += 3 * nlcc;
    var lcts = [lclt, lcdt];
    for (var it2 = 0; it2 < 2; ++it2) {
      var clct = lcts[it2];
      for (var i2 = 0; i2 < clct.length; ++i2) {
        var len = clct[i2] & 31;
        wbits(out, p2, llm[len]), p2 += lct[len];
        if (len > 15)
          wbits(out, p2, clct[i2] >> 5 & 127), p2 += clct[i2] >> 12;
      }
    }
  } else {
    lm = flm, ll = flt, dm = fdm, dl = fdt;
  }
  for (var i2 = 0; i2 < li; ++i2) {
    var sym = syms[i2];
    if (sym > 255) {
      var len = sym >> 18 & 31;
      wbits16(out, p2, lm[len + 257]), p2 += ll[len + 257];
      if (len > 7)
        wbits(out, p2, sym >> 23 & 31), p2 += fleb[len];
      var dst = sym & 31;
      wbits16(out, p2, dm[dst]), p2 += dl[dst];
      if (dst > 3)
        wbits16(out, p2, sym >> 5 & 8191), p2 += fdeb[dst];
    } else {
      wbits16(out, p2, lm[sym]), p2 += ll[sym];
    }
  }
  wbits16(out, p2, lm[256]);
  return p2 + ll[256];
};
var deo = /* @__PURE__ */ new i32([65540, 131080, 131088, 131104, 262176, 1048704, 1048832, 2114560, 2117632]);
var et = /* @__PURE__ */ new u8(0);
var dflt = function(dat, lvl, plvl, pre, post, st2) {
  var s2 = st2.z || dat.length;
  var o2 = new u8(pre + s2 + 5 * (1 + Math.ceil(s2 / 7e3)) + post);
  var w2 = o2.subarray(pre, o2.length - post);
  var lst = st2.l;
  var pos = (st2.r || 0) & 7;
  if (lvl) {
    if (pos)
      w2[0] = st2.r >> 3;
    var opt = deo[lvl - 1];
    var n2 = opt >> 13, c2 = opt & 8191;
    var msk_1 = (1 << plvl) - 1;
    var prev = st2.p || new u16(32768), head = st2.h || new u16(msk_1 + 1);
    var bs1_1 = Math.ceil(plvl / 3), bs2_1 = 2 * bs1_1;
    var hsh = function(i3) {
      return (dat[i3] ^ dat[i3 + 1] << bs1_1 ^ dat[i3 + 2] << bs2_1) & msk_1;
    };
    var syms = new i32(25e3);
    var lf = new u16(288), df = new u16(32);
    var lc_1 = 0, eb = 0, i2 = st2.i || 0, li = 0, wi = st2.w || 0, bs = 0;
    for (; i2 + 2 < s2; ++i2) {
      var hv = hsh(i2);
      var imod = i2 & 32767, pimod = head[hv];
      prev[imod] = pimod;
      head[hv] = imod;
      if (wi <= i2) {
        var rem = s2 - i2;
        if ((lc_1 > 7e3 || li > 24576) && (rem > 423 || !lst)) {
          pos = wblk(dat, w2, 0, syms, lf, df, eb, li, bs, i2 - bs, pos);
          li = lc_1 = eb = 0, bs = i2;
          for (var j2 = 0; j2 < 286; ++j2)
            lf[j2] = 0;
          for (var j2 = 0; j2 < 30; ++j2)
            df[j2] = 0;
        }
        var l2 = 2, d2 = 0, ch_1 = c2, dif = imod - pimod & 32767;
        if (rem > 2 && hv == hsh(i2 - dif)) {
          var maxn = Math.min(n2, rem) - 1;
          var maxd = Math.min(32767, i2);
          var ml = Math.min(258, rem);
          while (dif <= maxd && --ch_1 && imod != pimod) {
            if (dat[i2 + l2] == dat[i2 + l2 - dif]) {
              var nl = 0;
              for (; nl < ml && dat[i2 + nl] == dat[i2 + nl - dif]; ++nl)
                ;
              if (nl > l2) {
                l2 = nl, d2 = dif;
                if (nl > maxn)
                  break;
                var mmd = Math.min(dif, nl - 2);
                var md = 0;
                for (var j2 = 0; j2 < mmd; ++j2) {
                  var ti = i2 - dif + j2 & 32767;
                  var pti = prev[ti];
                  var cd = ti - pti & 32767;
                  if (cd > md)
                    md = cd, pimod = ti;
                }
              }
            }
            imod = pimod, pimod = prev[imod];
            dif += imod - pimod & 32767;
          }
        }
        if (d2) {
          syms[li++] = 268435456 | revfl[l2] << 18 | revfd[d2];
          var lin = revfl[l2] & 31, din = revfd[d2] & 31;
          eb += fleb[lin] + fdeb[din];
          ++lf[257 + lin];
          ++df[din];
          wi = i2 + l2;
          ++lc_1;
        } else {
          syms[li++] = dat[i2];
          ++lf[dat[i2]];
        }
      }
    }
    for (i2 = Math.max(i2, wi); i2 < s2; ++i2) {
      syms[li++] = dat[i2];
      ++lf[dat[i2]];
    }
    pos = wblk(dat, w2, lst, syms, lf, df, eb, li, bs, i2 - bs, pos);
    if (!lst) {
      st2.r = pos & 7 | w2[pos / 8 | 0] << 3;
      pos -= 7;
      st2.h = head, st2.p = prev, st2.i = i2, st2.w = wi;
    }
  } else {
    for (var i2 = st2.w || 0; i2 < s2 + lst; i2 += 65535) {
      var e = i2 + 65535;
      if (e >= s2) {
        w2[pos / 8 | 0] = lst;
        e = s2;
      }
      pos = wfblk(w2, pos + 1, dat.subarray(i2, e));
    }
    st2.i = s2;
  }
  return slc(o2, 0, pre + shft(pos) + post);
};
var adler = function() {
  var a2 = 1, b2 = 0;
  return {
    p: function(d2) {
      var n2 = a2, m2 = b2;
      var l2 = d2.length | 0;
      for (var i2 = 0; i2 != l2; ) {
        var e = Math.min(i2 + 2655, l2);
        for (; i2 < e; ++i2)
          m2 += n2 += d2[i2];
        n2 = (n2 & 65535) + 15 * (n2 >> 16), m2 = (m2 & 65535) + 15 * (m2 >> 16);
      }
      a2 = n2, b2 = m2;
    },
    d: function() {
      a2 %= 65521, b2 %= 65521;
      return (a2 & 255) << 24 | (a2 & 65280) << 8 | (b2 & 255) << 8 | b2 >> 8;
    }
  };
};
var dopt = function(dat, opt, pre, post, st2) {
  if (!st2) {
    st2 = { l: 1 };
    if (opt.dictionary) {
      var dict = opt.dictionary.subarray(-32768);
      var newDat = new u8(dict.length + dat.length);
      newDat.set(dict);
      newDat.set(dat, dict.length);
      dat = newDat;
      st2.w = dict.length;
    }
  }
  return dflt(dat, opt.level == null ? 6 : opt.level, opt.mem == null ? st2.l ? Math.ceil(Math.max(8, Math.min(13, Math.log(dat.length))) * 1.5) : 20 : 12 + opt.mem, pre, post, st2);
};
var wbytes = function(d2, b2, v2) {
  for (; v2; ++b2)
    d2[b2] = v2, v2 >>>= 8;
};
var zlh = function(c2, o2) {
  var lv = o2.level, fl2 = lv == 0 ? 0 : lv < 6 ? 1 : lv == 9 ? 3 : 2;
  c2[0] = 120, c2[1] = fl2 << 6 | (o2.dictionary && 32);
  c2[1] |= 31 - (c2[0] << 8 | c2[1]) % 31;
  if (o2.dictionary) {
    var h2 = adler();
    h2.p(o2.dictionary);
    wbytes(c2, 2, h2.d());
  }
};
var zls = function(d2, dict) {
  if ((d2[0] & 15) != 8 || d2[0] >> 4 > 7 || (d2[0] << 8 | d2[1]) % 31)
    err(6, "invalid zlib data");
  if ((d2[1] >> 5 & 1) == +!dict)
    err(6, "invalid zlib data: " + (d2[1] & 32 ? "need" : "unexpected") + " dictionary");
  return (d2[1] >> 3 & 4) + 2;
};
function zlibSync(data, opts) {
  if (!opts)
    opts = {};
  var a2 = adler();
  a2.p(data);
  var d2 = dopt(data, opts, opts.dictionary ? 6 : 2, 4);
  return zlh(d2, opts), wbytes(d2, d2.length - 4, a2.d()), d2;
}
function unzlibSync(data, opts) {
  return inflt(data.subarray(zls(data, opts && opts.dictionary), -4), { i: 2 }, opts && opts.out, opts && opts.dictionary);
}
var td = typeof TextDecoder != "undefined" && /* @__PURE__ */ new TextDecoder();
var tds = 0;
try {
  td.decode(et, { stream: true });
  tds = 1;
} catch (e) {
}

// node_modules/jspdf/dist/jspdf.es.min.js
var n = /* @__PURE__ */ function() {
  return "undefined" != typeof window ? window : "undefined" != typeof global ? global : "undefined" != typeof self ? self : this;
}();
function i() {
  n.console && "function" == typeof n.console.log && n.console.log.apply(n.console, arguments);
}
var a = { log: i, warn: function(t2) {
  n.console && ("function" == typeof n.console.warn ? n.console.warn.apply(n.console, arguments) : i.call(null, arguments));
}, error: function(t2) {
  n.console && ("function" == typeof n.console.error ? n.console.error.apply(n.console, arguments) : i(t2));
} };
function o(t2, e, r) {
  var n2 = new XMLHttpRequest();
  n2.open("GET", t2), n2.responseType = "blob", n2.onload = function() {
    l(n2.response, e, r);
  }, n2.onerror = function() {
    a.error("could not download file");
  }, n2.send();
}
function s(t2) {
  var e = new XMLHttpRequest();
  e.open("HEAD", t2, false);
  try {
    e.send();
  } catch (t3) {
  }
  return e.status >= 200 && e.status <= 299;
}
function c(t2) {
  try {
    t2.dispatchEvent(new MouseEvent("click"));
  } catch (r) {
    var e = document.createEvent("MouseEvents");
    e.initMouseEvent("click", true, true, window, 0, 0, 0, 80, 20, false, false, false, false, 0, null), t2.dispatchEvent(e);
  }
}
var u;
var h;
var l = n.saveAs || ("object" !== ("undefined" == typeof window ? "undefined" : _typeof(window)) || window !== n ? function() {
} : "undefined" != typeof HTMLAnchorElement && "download" in HTMLAnchorElement.prototype ? function(t2, e, r) {
  var i2 = n.URL || n.webkitURL, a2 = document.createElement("a");
  e = e || t2.name || "download", a2.download = e, a2.rel = "noopener", "string" == typeof t2 ? (a2.href = t2, a2.origin !== location.origin ? s(a2.href) ? o(t2, e, r) : c(a2, a2.target = "_blank") : c(a2)) : (a2.href = i2.createObjectURL(t2), setTimeout(function() {
    i2.revokeObjectURL(a2.href);
  }, 4e4), setTimeout(function() {
    c(a2);
  }, 0));
} : "msSaveOrOpenBlob" in navigator ? function(e, r, n2) {
  if (r = r || e.name || "download", "string" == typeof e)
    if (s(e))
      o(e, r, n2);
    else {
      var i2 = document.createElement("a");
      i2.href = e, i2.target = "_blank", setTimeout(function() {
        c(i2);
      });
    }
  else
    navigator.msSaveOrOpenBlob(function(e2, r2) {
      return void 0 === r2 ? r2 = { autoBom: false } : "object" !== _typeof(r2) && (a.warn("Deprecated: Expected third argument to be a object"), r2 = { autoBom: !r2 }), r2.autoBom && /^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(e2.type) ? new Blob([String.fromCharCode(65279), e2], { type: e2.type }) : e2;
    }(e, n2), r);
} : function(e, r, i2, a2) {
  if ((a2 = a2 || open("", "_blank")) && (a2.document.title = a2.document.body.innerText = "downloading..."), "string" == typeof e)
    return o(e, r, i2);
  var s2 = "application/octet-stream" === e.type, c2 = /constructor/i.test(n.HTMLElement) || n.safari, u2 = /CriOS\/[\d]+/.test(navigator.userAgent);
  if ((u2 || s2 && c2) && "object" === ("undefined" == typeof FileReader ? "undefined" : _typeof(FileReader))) {
    var h2 = new FileReader();
    h2.onloadend = function() {
      var t2 = h2.result;
      t2 = u2 ? t2 : t2.replace(/^data:[^;]*;/, "data:attachment/file;"), a2 ? a2.location.href = t2 : location = t2, a2 = null;
    }, h2.readAsDataURL(e);
  } else {
    var l2 = n.URL || n.webkitURL, f2 = l2.createObjectURL(e);
    a2 ? a2.location = f2 : location.href = f2, a2 = null, setTimeout(function() {
      l2.revokeObjectURL(f2);
    }, 4e4);
  }
});
function f(t2) {
  var e;
  t2 = t2 || "", this.ok = false, "#" == t2.charAt(0) && (t2 = t2.substr(1, 6));
  t2 = { aliceblue: "f0f8ff", antiquewhite: "faebd7", aqua: "00ffff", aquamarine: "7fffd4", azure: "f0ffff", beige: "f5f5dc", bisque: "ffe4c4", black: "000000", blanchedalmond: "ffebcd", blue: "0000ff", blueviolet: "8a2be2", brown: "a52a2a", burlywood: "deb887", cadetblue: "5f9ea0", chartreuse: "7fff00", chocolate: "d2691e", coral: "ff7f50", cornflowerblue: "6495ed", cornsilk: "fff8dc", crimson: "dc143c", cyan: "00ffff", darkblue: "00008b", darkcyan: "008b8b", darkgoldenrod: "b8860b", darkgray: "a9a9a9", darkgreen: "006400", darkkhaki: "bdb76b", darkmagenta: "8b008b", darkolivegreen: "556b2f", darkorange: "ff8c00", darkorchid: "9932cc", darkred: "8b0000", darksalmon: "e9967a", darkseagreen: "8fbc8f", darkslateblue: "483d8b", darkslategray: "2f4f4f", darkturquoise: "00ced1", darkviolet: "9400d3", deeppink: "ff1493", deepskyblue: "00bfff", dimgray: "696969", dodgerblue: "1e90ff", feldspar: "d19275", firebrick: "b22222", floralwhite: "fffaf0", forestgreen: "228b22", fuchsia: "ff00ff", gainsboro: "dcdcdc", ghostwhite: "f8f8ff", gold: "ffd700", goldenrod: "daa520", gray: "808080", green: "008000", greenyellow: "adff2f", honeydew: "f0fff0", hotpink: "ff69b4", indianred: "cd5c5c", indigo: "4b0082", ivory: "fffff0", khaki: "f0e68c", lavender: "e6e6fa", lavenderblush: "fff0f5", lawngreen: "7cfc00", lemonchiffon: "fffacd", lightblue: "add8e6", lightcoral: "f08080", lightcyan: "e0ffff", lightgoldenrodyellow: "fafad2", lightgrey: "d3d3d3", lightgreen: "90ee90", lightpink: "ffb6c1", lightsalmon: "ffa07a", lightseagreen: "20b2aa", lightskyblue: "87cefa", lightslateblue: "8470ff", lightslategray: "778899", lightsteelblue: "b0c4de", lightyellow: "ffffe0", lime: "00ff00", limegreen: "32cd32", linen: "faf0e6", magenta: "ff00ff", maroon: "800000", mediumaquamarine: "66cdaa", mediumblue: "0000cd", mediumorchid: "ba55d3", mediumpurple: "9370d8", mediumseagreen: "3cb371", mediumslateblue: "7b68ee", mediumspringgreen: "00fa9a", mediumturquoise: "48d1cc", mediumvioletred: "c71585", midnightblue: "191970", mintcream: "f5fffa", mistyrose: "ffe4e1", moccasin: "ffe4b5", navajowhite: "ffdead", navy: "000080", oldlace: "fdf5e6", olive: "808000", olivedrab: "6b8e23", orange: "ffa500", orangered: "ff4500", orchid: "da70d6", palegoldenrod: "eee8aa", palegreen: "98fb98", paleturquoise: "afeeee", palevioletred: "d87093", papayawhip: "ffefd5", peachpuff: "ffdab9", peru: "cd853f", pink: "ffc0cb", plum: "dda0dd", powderblue: "b0e0e6", purple: "800080", red: "ff0000", rosybrown: "bc8f8f", royalblue: "4169e1", saddlebrown: "8b4513", salmon: "fa8072", sandybrown: "f4a460", seagreen: "2e8b57", seashell: "fff5ee", sienna: "a0522d", silver: "c0c0c0", skyblue: "87ceeb", slateblue: "6a5acd", slategray: "708090", snow: "fffafa", springgreen: "00ff7f", steelblue: "4682b4", tan: "d2b48c", teal: "008080", thistle: "d8bfd8", tomato: "ff6347", turquoise: "40e0d0", violet: "ee82ee", violetred: "d02090", wheat: "f5deb3", white: "ffffff", whitesmoke: "f5f5f5", yellow: "ffff00", yellowgreen: "9acd32" }[t2 = (t2 = t2.replace(/ /g, "")).toLowerCase()] || t2;
  for (var r = [{ re: /^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/, example: ["rgb(123, 234, 45)", "rgb(255,234,245)"], process: function(t3) {
    return [parseInt(t3[1]), parseInt(t3[2]), parseInt(t3[3])];
  } }, { re: /^(\w{2})(\w{2})(\w{2})$/, example: ["#00ff00", "336699"], process: function(t3) {
    return [parseInt(t3[1], 16), parseInt(t3[2], 16), parseInt(t3[3], 16)];
  } }, { re: /^(\w{1})(\w{1})(\w{1})$/, example: ["#fb0", "f0f"], process: function(t3) {
    return [parseInt(t3[1] + t3[1], 16), parseInt(t3[2] + t3[2], 16), parseInt(t3[3] + t3[3], 16)];
  } }], n2 = 0; n2 < r.length; n2++) {
    var i2 = r[n2].re, a2 = r[n2].process, o2 = i2.exec(t2);
    o2 && (e = a2(o2), this.r = e[0], this.g = e[1], this.b = e[2], this.ok = true);
  }
  this.r = this.r < 0 || isNaN(this.r) ? 0 : this.r > 255 ? 255 : this.r, this.g = this.g < 0 || isNaN(this.g) ? 0 : this.g > 255 ? 255 : this.g, this.b = this.b < 0 || isNaN(this.b) ? 0 : this.b > 255 ? 255 : this.b, this.toRGB = function() {
    return "rgb(" + this.r + ", " + this.g + ", " + this.b + ")";
  }, this.toHex = function() {
    var t3 = this.r.toString(16), e2 = this.g.toString(16), r2 = this.b.toString(16);
    return 1 == t3.length && (t3 = "0" + t3), 1 == e2.length && (e2 = "0" + e2), 1 == r2.length && (r2 = "0" + r2), "#" + t3 + e2 + r2;
  };
}
function d(t2, e) {
  var r = t2[0], n2 = t2[1], i2 = t2[2], a2 = t2[3];
  r = g(r, n2, i2, a2, e[0], 7, -680876936), a2 = g(a2, r, n2, i2, e[1], 12, -389564586), i2 = g(i2, a2, r, n2, e[2], 17, 606105819), n2 = g(n2, i2, a2, r, e[3], 22, -1044525330), r = g(r, n2, i2, a2, e[4], 7, -176418897), a2 = g(a2, r, n2, i2, e[5], 12, 1200080426), i2 = g(i2, a2, r, n2, e[6], 17, -1473231341), n2 = g(n2, i2, a2, r, e[7], 22, -45705983), r = g(r, n2, i2, a2, e[8], 7, 1770035416), a2 = g(a2, r, n2, i2, e[9], 12, -1958414417), i2 = g(i2, a2, r, n2, e[10], 17, -42063), n2 = g(n2, i2, a2, r, e[11], 22, -1990404162), r = g(r, n2, i2, a2, e[12], 7, 1804603682), a2 = g(a2, r, n2, i2, e[13], 12, -40341101), i2 = g(i2, a2, r, n2, e[14], 17, -1502002290), r = m(r, n2 = g(n2, i2, a2, r, e[15], 22, 1236535329), i2, a2, e[1], 5, -165796510), a2 = m(a2, r, n2, i2, e[6], 9, -1069501632), i2 = m(i2, a2, r, n2, e[11], 14, 643717713), n2 = m(n2, i2, a2, r, e[0], 20, -373897302), r = m(r, n2, i2, a2, e[5], 5, -701558691), a2 = m(a2, r, n2, i2, e[10], 9, 38016083), i2 = m(i2, a2, r, n2, e[15], 14, -660478335), n2 = m(n2, i2, a2, r, e[4], 20, -405537848), r = m(r, n2, i2, a2, e[9], 5, 568446438), a2 = m(a2, r, n2, i2, e[14], 9, -1019803690), i2 = m(i2, a2, r, n2, e[3], 14, -187363961), n2 = m(n2, i2, a2, r, e[8], 20, 1163531501), r = m(r, n2, i2, a2, e[13], 5, -1444681467), a2 = m(a2, r, n2, i2, e[2], 9, -51403784), i2 = m(i2, a2, r, n2, e[7], 14, 1735328473), r = v(r, n2 = m(n2, i2, a2, r, e[12], 20, -1926607734), i2, a2, e[5], 4, -378558), a2 = v(a2, r, n2, i2, e[8], 11, -2022574463), i2 = v(i2, a2, r, n2, e[11], 16, 1839030562), n2 = v(n2, i2, a2, r, e[14], 23, -35309556), r = v(r, n2, i2, a2, e[1], 4, -1530992060), a2 = v(a2, r, n2, i2, e[4], 11, 1272893353), i2 = v(i2, a2, r, n2, e[7], 16, -155497632), n2 = v(n2, i2, a2, r, e[10], 23, -1094730640), r = v(r, n2, i2, a2, e[13], 4, 681279174), a2 = v(a2, r, n2, i2, e[0], 11, -358537222), i2 = v(i2, a2, r, n2, e[3], 16, -722521979), n2 = v(n2, i2, a2, r, e[6], 23, 76029189), r = v(r, n2, i2, a2, e[9], 4, -640364487), a2 = v(a2, r, n2, i2, e[12], 11, -421815835), i2 = v(i2, a2, r, n2, e[15], 16, 530742520), r = b(r, n2 = v(n2, i2, a2, r, e[2], 23, -995338651), i2, a2, e[0], 6, -198630844), a2 = b(a2, r, n2, i2, e[7], 10, 1126891415), i2 = b(i2, a2, r, n2, e[14], 15, -1416354905), n2 = b(n2, i2, a2, r, e[5], 21, -57434055), r = b(r, n2, i2, a2, e[12], 6, 1700485571), a2 = b(a2, r, n2, i2, e[3], 10, -1894986606), i2 = b(i2, a2, r, n2, e[10], 15, -1051523), n2 = b(n2, i2, a2, r, e[1], 21, -2054922799), r = b(r, n2, i2, a2, e[8], 6, 1873313359), a2 = b(a2, r, n2, i2, e[15], 10, -30611744), i2 = b(i2, a2, r, n2, e[6], 15, -1560198380), n2 = b(n2, i2, a2, r, e[13], 21, 1309151649), r = b(r, n2, i2, a2, e[4], 6, -145523070), a2 = b(a2, r, n2, i2, e[11], 10, -1120210379), i2 = b(i2, a2, r, n2, e[2], 15, 718787259), n2 = b(n2, i2, a2, r, e[9], 21, -343485551), t2[0] = _(r, t2[0]), t2[1] = _(n2, t2[1]), t2[2] = _(i2, t2[2]), t2[3] = _(a2, t2[3]);
}
function p(t2, e, r, n2, i2, a2) {
  return e = _(_(e, t2), _(n2, a2)), _(e << i2 | e >>> 32 - i2, r);
}
function g(t2, e, r, n2, i2, a2, o2) {
  return p(e & r | ~e & n2, t2, e, i2, a2, o2);
}
function m(t2, e, r, n2, i2, a2, o2) {
  return p(e & n2 | r & ~n2, t2, e, i2, a2, o2);
}
function v(t2, e, r, n2, i2, a2, o2) {
  return p(e ^ r ^ n2, t2, e, i2, a2, o2);
}
function b(t2, e, r, n2, i2, a2, o2) {
  return p(r ^ (e | ~n2), t2, e, i2, a2, o2);
}
function y(t2) {
  var e, r = t2.length, n2 = [1732584193, -271733879, -1732584194, 271733878];
  for (e = 64; e <= t2.length; e += 64)
    d(n2, w(t2.substring(e - 64, e)));
  t2 = t2.substring(e - 64);
  var i2 = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
  for (e = 0; e < t2.length; e++)
    i2[e >> 2] |= t2.charCodeAt(e) << (e % 4 << 3);
  if (i2[e >> 2] |= 128 << (e % 4 << 3), e > 55)
    for (d(n2, i2), e = 0; e < 16; e++)
      i2[e] = 0;
  return i2[14] = 8 * r, d(n2, i2), n2;
}
function w(t2) {
  var e, r = [];
  for (e = 0; e < 64; e += 4)
    r[e >> 2] = t2.charCodeAt(e) + (t2.charCodeAt(e + 1) << 8) + (t2.charCodeAt(e + 2) << 16) + (t2.charCodeAt(e + 3) << 24);
  return r;
}
u = n.atob.bind(n), h = n.btoa.bind(n);
var N = "0123456789abcdef".split("");
function L(t2) {
  for (var e = "", r = 0; r < 4; r++)
    e += N[t2 >> 8 * r + 4 & 15] + N[t2 >> 8 * r & 15];
  return e;
}
function A(t2) {
  return String.fromCharCode((255 & t2) >> 0, (65280 & t2) >> 8, (16711680 & t2) >> 16, (4278190080 & t2) >> 24);
}
function x(t2) {
  return y(t2).map(A).join("");
}
var S = "5d41402abc4b2a76b9719d911017c592" != function(t2) {
  for (var e = 0; e < t2.length; e++)
    t2[e] = L(t2[e]);
  return t2.join("");
}(y("hello"));
function _(t2, e) {
  if (S) {
    var r = (65535 & t2) + (65535 & e);
    return (t2 >> 16) + (e >> 16) + (r >> 16) << 16 | 65535 & r;
  }
  return t2 + e & 4294967295;
}
function P(t2, e) {
  var r, n2, i2, a2;
  if (t2 !== r) {
    for (var o2 = (i2 = t2, a2 = 1 + (256 / t2.length >> 0), new Array(a2 + 1).join(i2)), s2 = [], c2 = 0; c2 < 256; c2++)
      s2[c2] = c2;
    var u2 = 0;
    for (c2 = 0; c2 < 256; c2++) {
      var h2 = s2[c2];
      u2 = (u2 + h2 + o2.charCodeAt(c2)) % 256, s2[c2] = s2[u2], s2[u2] = h2;
    }
    r = t2, n2 = s2;
  } else
    s2 = n2;
  var l2 = e.length, f2 = 0, d2 = 0, p2 = "";
  for (c2 = 0; c2 < l2; c2++)
    d2 = (d2 + (h2 = s2[f2 = (f2 + 1) % 256])) % 256, s2[f2] = s2[d2], s2[d2] = h2, o2 = s2[(s2[f2] + s2[d2]) % 256], p2 += String.fromCharCode(e.charCodeAt(c2) ^ o2);
  return p2;
}
var k = { print: 4, modify: 8, copy: 16, "annot-forms": 32 };
function I(t2, e, r, n2) {
  this.v = 1, this.r = 2;
  var i2 = 192;
  t2.forEach(function(t3) {
    if (void 0 !== k.perm)
      throw new Error("Invalid permission: " + t3);
    i2 += k[t3];
  }), this.padding = "(\xBFN^Nu\x8AAd\0NV\xFF\xFA\b..\0\xB6\xD0h>\x80/\f\xA9\xFEdSiz";
  var a2 = (e + this.padding).substr(0, 32), o2 = (r + this.padding).substr(0, 32);
  this.O = this.processOwnerPassword(a2, o2), this.P = -(1 + (255 ^ i2)), this.encryptionKey = x(a2 + this.O + this.lsbFirstWord(this.P) + this.hexToBytes(n2)).substr(0, 5), this.U = P(this.encryptionKey, this.padding);
}
function F(t2) {
  if (/[^\u0000-\u00ff]/.test(t2))
    throw new Error("Invalid PDF Name Object: " + t2 + ", Only accept ASCII characters.");
  for (var e = "", r = t2.length, n2 = 0; n2 < r; n2++) {
    var i2 = t2.charCodeAt(n2);
    if (i2 < 33 || 35 === i2 || 37 === i2 || 40 === i2 || 41 === i2 || 47 === i2 || 60 === i2 || 62 === i2 || 91 === i2 || 93 === i2 || 123 === i2 || 125 === i2 || i2 > 126)
      e += "#" + ("0" + i2.toString(16)).slice(-2);
    else
      e += t2[n2];
  }
  return e;
}
function C(e) {
  if ("object" !== _typeof(e))
    throw new Error("Invalid Context passed to initialize PubSub (jsPDF-module)");
  var r = {};
  this.subscribe = function(t2, e2, n2) {
    if (n2 = n2 || false, "string" != typeof t2 || "function" != typeof e2 || "boolean" != typeof n2)
      throw new Error("Invalid arguments passed to PubSub.subscribe (jsPDF-module)");
    r.hasOwnProperty(t2) || (r[t2] = {});
    var i2 = Math.random().toString(35);
    return r[t2][i2] = [e2, !!n2], i2;
  }, this.unsubscribe = function(t2) {
    for (var e2 in r)
      if (r[e2][t2])
        return delete r[e2][t2], 0 === Object.keys(r[e2]).length && delete r[e2], true;
    return false;
  }, this.publish = function(t2) {
    if (r.hasOwnProperty(t2)) {
      var i2 = Array.prototype.slice.call(arguments, 1), o2 = [];
      for (var s2 in r[t2]) {
        var c2 = r[t2][s2];
        try {
          c2[0].apply(e, i2);
        } catch (t3) {
          n.console && a.error("jsPDF PubSub Error", t3.message, t3);
        }
        c2[1] && o2.push(s2);
      }
      o2.length && o2.forEach(this.unsubscribe);
    }
  }, this.getTopics = function() {
    return r;
  };
}
function j(t2) {
  if (!(this instanceof j))
    return new j(t2);
  var e = "opacity,stroke-opacity".split(",");
  for (var r in t2)
    t2.hasOwnProperty(r) && e.indexOf(r) >= 0 && (this[r] = t2[r]);
  this.id = "", this.objectNumber = -1;
}
function O(t2, e) {
  this.gState = t2, this.matrix = e, this.id = "", this.objectNumber = -1;
}
function B(t2, e, r, n2, i2) {
  if (!(this instanceof B))
    return new B(t2, e, r, n2, i2);
  this.type = "axial" === t2 ? 2 : 3, this.coords = e, this.colors = r, O.call(this, n2, i2);
}
function M(t2, e, r, n2, i2) {
  if (!(this instanceof M))
    return new M(t2, e, r, n2, i2);
  this.boundingBox = t2, this.xStep = e, this.yStep = r, this.stream = "", this.cloneIndex = 0, O.call(this, n2, i2);
}
function E(e) {
  var r, i2 = "string" == typeof arguments[0] ? arguments[0] : "p", o2 = arguments[1], s2 = arguments[2], c2 = arguments[3], u2 = [], d2 = 1, p2 = 16, g2 = "S", m2 = null;
  "object" === _typeof(e = e || {}) && (i2 = e.orientation, o2 = e.unit || o2, s2 = e.format || s2, c2 = e.compress || e.compressPdf || c2, null !== (m2 = e.encryption || null) && (m2.userPassword = m2.userPassword || "", m2.ownerPassword = m2.ownerPassword || "", m2.userPermissions = m2.userPermissions || []), d2 = "number" == typeof e.userUnit ? Math.abs(e.userUnit) : 1, void 0 !== e.precision && (r = e.precision), void 0 !== e.floatPrecision && (p2 = e.floatPrecision), g2 = e.defaultPathOperation || "S"), u2 = e.filters || (true === c2 ? ["FlateEncode"] : u2), o2 = o2 || "mm", i2 = ("" + (i2 || "P")).toLowerCase();
  var v2 = e.putOnlyUsedFonts || false, b2 = {}, y2 = { internal: {}, __private__: {} };
  y2.__private__.PubSub = C;
  var w2 = "1.3", N2 = y2.__private__.getPdfVersion = function() {
    return w2;
  };
  y2.__private__.setPdfVersion = function(t2) {
    w2 = t2;
  };
  var L2 = { a0: [2383.94, 3370.39], a1: [1683.78, 2383.94], a2: [1190.55, 1683.78], a3: [841.89, 1190.55], a4: [595.28, 841.89], a5: [419.53, 595.28], a6: [297.64, 419.53], a7: [209.76, 297.64], a8: [147.4, 209.76], a9: [104.88, 147.4], a10: [73.7, 104.88], b0: [2834.65, 4008.19], b1: [2004.09, 2834.65], b2: [1417.32, 2004.09], b3: [1000.63, 1417.32], b4: [708.66, 1000.63], b5: [498.9, 708.66], b6: [354.33, 498.9], b7: [249.45, 354.33], b8: [175.75, 249.45], b9: [124.72, 175.75], b10: [87.87, 124.72], c0: [2599.37, 3676.54], c1: [1836.85, 2599.37], c2: [1298.27, 1836.85], c3: [918.43, 1298.27], c4: [649.13, 918.43], c5: [459.21, 649.13], c6: [323.15, 459.21], c7: [229.61, 323.15], c8: [161.57, 229.61], c9: [113.39, 161.57], c10: [79.37, 113.39], dl: [311.81, 623.62], letter: [612, 792], "government-letter": [576, 756], legal: [612, 1008], "junior-legal": [576, 360], ledger: [1224, 792], tabloid: [792, 1224], "credit-card": [153, 243] };
  y2.__private__.getPageFormats = function() {
    return L2;
  };
  var A2 = y2.__private__.getPageFormat = function(t2) {
    return L2[t2];
  };
  s2 = s2 || "a4";
  var x2 = { COMPAT: "compat", ADVANCED: "advanced" }, S2 = x2.COMPAT;
  function _2() {
    this.saveGraphicsState(), lt2(new Vt2(_t2, 0, 0, -_t2, 0, Rr() * _t2).toString() + " cm"), this.setFontSize(this.getFontSize() / _t2), g2 = "n", S2 = x2.ADVANCED;
  }
  function P2() {
    this.restoreGraphicsState(), g2 = "S", S2 = x2.COMPAT;
  }
  var k2 = y2.__private__.combineFontStyleAndFontWeight = function(t2, e2) {
    if ("bold" == t2 && "normal" == e2 || "bold" == t2 && 400 == e2 || "normal" == t2 && "italic" == e2 || "bold" == t2 && "italic" == e2)
      throw new Error("Invalid Combination of fontweight and fontstyle");
    return e2 && (t2 = 400 == e2 || "normal" === e2 ? "italic" === t2 ? "italic" : "normal" : 700 != e2 && "bold" !== e2 || "normal" !== t2 ? (700 == e2 ? "bold" : e2) + "" + t2 : "bold"), t2;
  };
  y2.advancedAPI = function(t2) {
    var e2 = S2 === x2.COMPAT;
    return e2 && _2.call(this), "function" != typeof t2 || (t2(this), e2 && P2.call(this)), this;
  }, y2.compatAPI = function(t2) {
    var e2 = S2 === x2.ADVANCED;
    return e2 && P2.call(this), "function" != typeof t2 || (t2(this), e2 && _2.call(this)), this;
  }, y2.isAdvancedAPI = function() {
    return S2 === x2.ADVANCED;
  };
  var O2, q2 = function(t2) {
    if (S2 !== x2.ADVANCED)
      throw new Error(t2 + " is only available in 'advanced' API mode. You need to call advancedAPI() first.");
  }, D2 = y2.roundToPrecision = y2.__private__.roundToPrecision = function(t2, e2) {
    var n2 = r || e2;
    if (isNaN(t2) || isNaN(n2))
      throw new Error("Invalid argument passed to jsPDF.roundToPrecision");
    return t2.toFixed(n2).replace(/0+$/, "");
  };
  O2 = y2.hpf = y2.__private__.hpf = "number" == typeof p2 ? function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.hpf");
    return D2(t2, p2);
  } : "smart" === p2 ? function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.hpf");
    return D2(t2, t2 > -1 && t2 < 1 ? 16 : 5);
  } : function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.hpf");
    return D2(t2, 16);
  };
  var R2 = y2.f2 = y2.__private__.f2 = function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.f2");
    return D2(t2, 2);
  }, T2 = y2.__private__.f3 = function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.f3");
    return D2(t2, 3);
  }, U2 = y2.scale = y2.__private__.scale = function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.scale");
    return S2 === x2.COMPAT ? t2 * _t2 : S2 === x2.ADVANCED ? t2 : void 0;
  }, z2 = function(t2) {
    return S2 === x2.COMPAT ? Rr() - t2 : S2 === x2.ADVANCED ? t2 : void 0;
  }, H2 = function(t2) {
    return U2(z2(t2));
  };
  y2.__private__.setPrecision = y2.setPrecision = function(t2) {
    "number" == typeof parseInt(t2, 10) && (r = parseInt(t2, 10));
  };
  var W2, V2 = "00000000000000000000000000000000", G2 = y2.__private__.getFileId = function() {
    return V2;
  }, Y2 = y2.__private__.setFileId = function(t2) {
    return V2 = void 0 !== t2 && /^[a-fA-F0-9]{32}$/.test(t2) ? t2.toUpperCase() : V2.split("").map(function() {
      return "ABCDEF0123456789".charAt(Math.floor(16 * Math.random()));
    }).join(""), null !== m2 && (Ye = new I(m2.userPermissions, m2.userPassword, m2.ownerPassword, V2)), V2;
  };
  y2.setFileId = function(t2) {
    return Y2(t2), this;
  }, y2.getFileId = function() {
    return G2();
  };
  var J2 = y2.__private__.convertDateToPDFDate = function(t2) {
    var e2 = t2.getTimezoneOffset(), r2 = e2 < 0 ? "+" : "-", n2 = Math.floor(Math.abs(e2 / 60)), i3 = Math.abs(e2 % 60), a2 = [r2, Q2(n2), "'", Q2(i3), "'"].join("");
    return ["D:", t2.getFullYear(), Q2(t2.getMonth() + 1), Q2(t2.getDate()), Q2(t2.getHours()), Q2(t2.getMinutes()), Q2(t2.getSeconds()), a2].join("");
  }, X2 = y2.__private__.convertPDFDateToDate = function(t2) {
    var e2 = parseInt(t2.substr(2, 4), 10), r2 = parseInt(t2.substr(6, 2), 10) - 1, n2 = parseInt(t2.substr(8, 2), 10), i3 = parseInt(t2.substr(10, 2), 10), a2 = parseInt(t2.substr(12, 2), 10), o3 = parseInt(t2.substr(14, 2), 10);
    return new Date(e2, r2, n2, i3, a2, o3, 0);
  }, K2 = y2.__private__.setCreationDate = function(t2) {
    var e2;
    if (void 0 === t2 && (t2 = /* @__PURE__ */ new Date()), t2 instanceof Date)
      e2 = J2(t2);
    else {
      if (!/^D:(20[0-2][0-9]|203[0-7]|19[7-9][0-9])(0[0-9]|1[0-2])([0-2][0-9]|3[0-1])(0[0-9]|1[0-9]|2[0-3])(0[0-9]|[1-5][0-9])(0[0-9]|[1-5][0-9])(\+0[0-9]|\+1[0-4]|-0[0-9]|-1[0-1])'(0[0-9]|[1-5][0-9])'?$/.test(t2))
        throw new Error("Invalid argument passed to jsPDF.setCreationDate");
      e2 = t2;
    }
    return W2 = e2;
  }, Z2 = y2.__private__.getCreationDate = function(t2) {
    var e2 = W2;
    return "jsDate" === t2 && (e2 = X2(W2)), e2;
  };
  y2.setCreationDate = function(t2) {
    return K2(t2), this;
  }, y2.getCreationDate = function(t2) {
    return Z2(t2);
  };
  var $3, Q2 = y2.__private__.padd2 = function(t2) {
    return ("0" + parseInt(t2)).slice(-2);
  }, tt2 = y2.__private__.padd2Hex = function(t2) {
    return ("00" + (t2 = t2.toString())).substr(t2.length);
  }, et3 = 0, rt2 = [], nt2 = [], it2 = 0, at2 = [], ot2 = [], st2 = false, ct2 = nt2, ut2 = function() {
    et3 = 0, it2 = 0, nt2 = [], rt2 = [], at2 = [], Qt2 = Kt2(), te2 = Kt2();
  };
  y2.__private__.setCustomOutputDestination = function(t2) {
    st2 = true, ct2 = t2;
  };
  var ht2 = function(t2) {
    st2 || (ct2 = t2);
  };
  y2.__private__.resetCustomOutputDestination = function() {
    st2 = false, ct2 = nt2;
  };
  var lt2 = y2.__private__.out = function(t2) {
    return t2 = t2.toString(), it2 += t2.length + 1, ct2.push(t2), ct2;
  }, ft2 = y2.__private__.write = function(t2) {
    return lt2(1 === arguments.length ? t2.toString() : Array.prototype.join.call(arguments, " "));
  }, dt2 = y2.__private__.getArrayBuffer = function(t2) {
    for (var e2 = t2.length, r2 = new ArrayBuffer(e2), n2 = new Uint8Array(r2); e2--; )
      n2[e2] = t2.charCodeAt(e2);
    return r2;
  }, pt2 = [["Helvetica", "helvetica", "normal", "WinAnsiEncoding"], ["Helvetica-Bold", "helvetica", "bold", "WinAnsiEncoding"], ["Helvetica-Oblique", "helvetica", "italic", "WinAnsiEncoding"], ["Helvetica-BoldOblique", "helvetica", "bolditalic", "WinAnsiEncoding"], ["Courier", "courier", "normal", "WinAnsiEncoding"], ["Courier-Bold", "courier", "bold", "WinAnsiEncoding"], ["Courier-Oblique", "courier", "italic", "WinAnsiEncoding"], ["Courier-BoldOblique", "courier", "bolditalic", "WinAnsiEncoding"], ["Times-Roman", "times", "normal", "WinAnsiEncoding"], ["Times-Bold", "times", "bold", "WinAnsiEncoding"], ["Times-Italic", "times", "italic", "WinAnsiEncoding"], ["Times-BoldItalic", "times", "bolditalic", "WinAnsiEncoding"], ["ZapfDingbats", "zapfdingbats", "normal", null], ["Symbol", "symbol", "normal", null]];
  y2.__private__.getStandardFonts = function() {
    return pt2;
  };
  var gt2 = e.fontSize || 16;
  y2.__private__.setFontSize = y2.setFontSize = function(t2) {
    return gt2 = S2 === x2.ADVANCED ? t2 / _t2 : t2, this;
  };
  var mt2, vt2 = y2.__private__.getFontSize = y2.getFontSize = function() {
    return S2 === x2.COMPAT ? gt2 : gt2 * _t2;
  }, bt2 = e.R2L || false;
  y2.__private__.setR2L = y2.setR2L = function(t2) {
    return bt2 = t2, this;
  }, y2.__private__.getR2L = y2.getR2L = function() {
    return bt2;
  };
  var yt2, wt2 = y2.__private__.setZoomMode = function(t2) {
    var e2 = [void 0, null, "fullwidth", "fullheight", "fullpage", "original"];
    if (/^(?:\d+\.\d*|\d*\.\d+|\d+)%$/.test(t2))
      mt2 = t2;
    else if (isNaN(t2)) {
      if (-1 === e2.indexOf(t2))
        throw new Error('zoom must be Integer (e.g. 2), a percentage Value (e.g. 300%) or fullwidth, fullheight, fullpage, original. "' + t2 + '" is not recognized.');
      mt2 = t2;
    } else
      mt2 = parseInt(t2, 10);
  };
  y2.__private__.getZoomMode = function() {
    return mt2;
  };
  var Nt2, Lt2 = y2.__private__.setPageMode = function(t2) {
    if (-1 == [void 0, null, "UseNone", "UseOutlines", "UseThumbs", "FullScreen"].indexOf(t2))
      throw new Error('Page mode must be one of UseNone, UseOutlines, UseThumbs, or FullScreen. "' + t2 + '" is not recognized.');
    yt2 = t2;
  };
  y2.__private__.getPageMode = function() {
    return yt2;
  };
  var At2 = y2.__private__.setLayoutMode = function(t2) {
    if (-1 == [void 0, null, "continuous", "single", "twoleft", "tworight", "two"].indexOf(t2))
      throw new Error('Layout mode must be one of continuous, single, twoleft, tworight. "' + t2 + '" is not recognized.');
    Nt2 = t2;
  };
  y2.__private__.getLayoutMode = function() {
    return Nt2;
  }, y2.__private__.setDisplayMode = y2.setDisplayMode = function(t2, e2, r2) {
    return wt2(t2), At2(e2), Lt2(r2), this;
  };
  var xt2 = { title: "", subject: "", author: "", keywords: "", creator: "" };
  y2.__private__.getDocumentProperty = function(t2) {
    if (-1 === Object.keys(xt2).indexOf(t2))
      throw new Error("Invalid argument passed to jsPDF.getDocumentProperty");
    return xt2[t2];
  }, y2.__private__.getDocumentProperties = function() {
    return xt2;
  }, y2.__private__.setDocumentProperties = y2.setProperties = y2.setDocumentProperties = function(t2) {
    for (var e2 in xt2)
      xt2.hasOwnProperty(e2) && t2[e2] && (xt2[e2] = t2[e2]);
    return this;
  }, y2.__private__.setDocumentProperty = function(t2, e2) {
    if (-1 === Object.keys(xt2).indexOf(t2))
      throw new Error("Invalid arguments passed to jsPDF.setDocumentProperty");
    return xt2[t2] = e2;
  };
  var St2, _t2, Pt2, kt2, It2, Ft2 = {}, Ct2 = {}, jt2 = [], Ot2 = {}, Bt2 = {}, Mt2 = {}, Et2 = {}, qt2 = null, Dt2 = 0, Rt2 = [], Tt2 = new C(y2), Ut2 = e.hotfixes || [], zt2 = {}, Ht2 = {}, Wt2 = [], Vt2 = function t2(e2, r2, n2, i3, a2, o3) {
    if (!(this instanceof t2))
      return new t2(e2, r2, n2, i3, a2, o3);
    isNaN(e2) && (e2 = 1), isNaN(r2) && (r2 = 0), isNaN(n2) && (n2 = 0), isNaN(i3) && (i3 = 1), isNaN(a2) && (a2 = 0), isNaN(o3) && (o3 = 0), this._matrix = [e2, r2, n2, i3, a2, o3];
  };
  Object.defineProperty(Vt2.prototype, "sx", { get: function() {
    return this._matrix[0];
  }, set: function(t2) {
    this._matrix[0] = t2;
  } }), Object.defineProperty(Vt2.prototype, "shy", { get: function() {
    return this._matrix[1];
  }, set: function(t2) {
    this._matrix[1] = t2;
  } }), Object.defineProperty(Vt2.prototype, "shx", { get: function() {
    return this._matrix[2];
  }, set: function(t2) {
    this._matrix[2] = t2;
  } }), Object.defineProperty(Vt2.prototype, "sy", { get: function() {
    return this._matrix[3];
  }, set: function(t2) {
    this._matrix[3] = t2;
  } }), Object.defineProperty(Vt2.prototype, "tx", { get: function() {
    return this._matrix[4];
  }, set: function(t2) {
    this._matrix[4] = t2;
  } }), Object.defineProperty(Vt2.prototype, "ty", { get: function() {
    return this._matrix[5];
  }, set: function(t2) {
    this._matrix[5] = t2;
  } }), Object.defineProperty(Vt2.prototype, "a", { get: function() {
    return this._matrix[0];
  }, set: function(t2) {
    this._matrix[0] = t2;
  } }), Object.defineProperty(Vt2.prototype, "b", { get: function() {
    return this._matrix[1];
  }, set: function(t2) {
    this._matrix[1] = t2;
  } }), Object.defineProperty(Vt2.prototype, "c", { get: function() {
    return this._matrix[2];
  }, set: function(t2) {
    this._matrix[2] = t2;
  } }), Object.defineProperty(Vt2.prototype, "d", { get: function() {
    return this._matrix[3];
  }, set: function(t2) {
    this._matrix[3] = t2;
  } }), Object.defineProperty(Vt2.prototype, "e", { get: function() {
    return this._matrix[4];
  }, set: function(t2) {
    this._matrix[4] = t2;
  } }), Object.defineProperty(Vt2.prototype, "f", { get: function() {
    return this._matrix[5];
  }, set: function(t2) {
    this._matrix[5] = t2;
  } }), Object.defineProperty(Vt2.prototype, "rotation", { get: function() {
    return Math.atan2(this.shx, this.sx);
  } }), Object.defineProperty(Vt2.prototype, "scaleX", { get: function() {
    return this.decompose().scale.sx;
  } }), Object.defineProperty(Vt2.prototype, "scaleY", { get: function() {
    return this.decompose().scale.sy;
  } }), Object.defineProperty(Vt2.prototype, "isIdentity", { get: function() {
    return 1 === this.sx && (0 === this.shy && (0 === this.shx && (1 === this.sy && (0 === this.tx && 0 === this.ty))));
  } }), Vt2.prototype.join = function(t2) {
    return [this.sx, this.shy, this.shx, this.sy, this.tx, this.ty].map(O2).join(t2);
  }, Vt2.prototype.multiply = function(t2) {
    var e2 = t2.sx * this.sx + t2.shy * this.shx, r2 = t2.sx * this.shy + t2.shy * this.sy, n2 = t2.shx * this.sx + t2.sy * this.shx, i3 = t2.shx * this.shy + t2.sy * this.sy, a2 = t2.tx * this.sx + t2.ty * this.shx + this.tx, o3 = t2.tx * this.shy + t2.ty * this.sy + this.ty;
    return new Vt2(e2, r2, n2, i3, a2, o3);
  }, Vt2.prototype.decompose = function() {
    var t2 = this.sx, e2 = this.shy, r2 = this.shx, n2 = this.sy, i3 = this.tx, a2 = this.ty, o3 = Math.sqrt(t2 * t2 + e2 * e2), s3 = (t2 /= o3) * r2 + (e2 /= o3) * n2;
    r2 -= t2 * s3, n2 -= e2 * s3;
    var c3 = Math.sqrt(r2 * r2 + n2 * n2);
    return s3 /= c3, t2 * (n2 /= c3) < e2 * (r2 /= c3) && (t2 = -t2, e2 = -e2, s3 = -s3, o3 = -o3), { scale: new Vt2(o3, 0, 0, c3, 0, 0), translate: new Vt2(1, 0, 0, 1, i3, a2), rotate: new Vt2(t2, e2, -e2, t2, 0, 0), skew: new Vt2(1, 0, s3, 1, 0, 0) };
  }, Vt2.prototype.toString = function(t2) {
    return this.join(" ");
  }, Vt2.prototype.inversed = function() {
    var t2 = this.sx, e2 = this.shy, r2 = this.shx, n2 = this.sy, i3 = this.tx, a2 = this.ty, o3 = 1 / (t2 * n2 - e2 * r2), s3 = n2 * o3, c3 = -e2 * o3, u3 = -r2 * o3, h2 = t2 * o3;
    return new Vt2(s3, c3, u3, h2, -s3 * i3 - u3 * a2, -c3 * i3 - h2 * a2);
  }, Vt2.prototype.applyToPoint = function(t2) {
    var e2 = t2.x * this.sx + t2.y * this.shx + this.tx, r2 = t2.x * this.shy + t2.y * this.sy + this.ty;
    return new Cr(e2, r2);
  }, Vt2.prototype.applyToRectangle = function(t2) {
    var e2 = this.applyToPoint(t2), r2 = this.applyToPoint(new Cr(t2.x + t2.w, t2.y + t2.h));
    return new jr(e2.x, e2.y, r2.x - e2.x, r2.y - e2.y);
  }, Vt2.prototype.clone = function() {
    var t2 = this.sx, e2 = this.shy, r2 = this.shx, n2 = this.sy, i3 = this.tx, a2 = this.ty;
    return new Vt2(t2, e2, r2, n2, i3, a2);
  }, y2.Matrix = Vt2;
  var Gt2 = y2.matrixMult = function(t2, e2) {
    return e2.multiply(t2);
  }, Yt2 = new Vt2(1, 0, 0, 1, 0, 0);
  y2.unitMatrix = y2.identityMatrix = Yt2;
  var Jt2 = function(t2, e2) {
    if (!Bt2[t2]) {
      var r2 = (e2 instanceof B ? "Sh" : "P") + (Object.keys(Ot2).length + 1).toString(10);
      e2.id = r2, Bt2[t2] = r2, Ot2[r2] = e2, Tt2.publish("addPattern", e2);
    }
  };
  y2.ShadingPattern = B, y2.TilingPattern = M, y2.addShadingPattern = function(t2, e2) {
    return q2("addShadingPattern()"), Jt2(t2, e2), this;
  }, y2.beginTilingPattern = function(t2) {
    q2("beginTilingPattern()"), Br(t2.boundingBox[0], t2.boundingBox[1], t2.boundingBox[2] - t2.boundingBox[0], t2.boundingBox[3] - t2.boundingBox[1], t2.matrix);
  }, y2.endTilingPattern = function(t2, e2) {
    q2("endTilingPattern()"), e2.stream = ot2[$3].join("\n"), Jt2(t2, e2), Tt2.publish("endTilingPattern", e2), Wt2.pop().restore();
  };
  var Xt2 = y2.__private__.newObject = function() {
    var t2 = Kt2();
    return Zt2(t2, true), t2;
  }, Kt2 = y2.__private__.newObjectDeferred = function() {
    return et3++, rt2[et3] = function() {
      return it2;
    }, et3;
  }, Zt2 = function(t2, e2) {
    return e2 = "boolean" == typeof e2 && e2, rt2[t2] = it2, e2 && lt2(t2 + " 0 obj"), t2;
  }, $t2 = y2.__private__.newAdditionalObject = function() {
    var t2 = { objId: Kt2(), content: "" };
    return at2.push(t2), t2;
  }, Qt2 = Kt2(), te2 = Kt2(), ee2 = y2.__private__.decodeColorString = function(t2) {
    var e2 = t2.split(" ");
    if (2 !== e2.length || "g" !== e2[1] && "G" !== e2[1]) {
      if (5 === e2.length && ("k" === e2[4] || "K" === e2[4])) {
        e2 = [(1 - e2[0]) * (1 - e2[3]), (1 - e2[1]) * (1 - e2[3]), (1 - e2[2]) * (1 - e2[3]), "r"];
      }
    } else {
      var r2 = parseFloat(e2[0]);
      e2 = [r2, r2, r2, "r"];
    }
    for (var n2 = "#", i3 = 0; i3 < 3; i3++)
      n2 += ("0" + Math.floor(255 * parseFloat(e2[i3])).toString(16)).slice(-2);
    return n2;
  }, re2 = y2.__private__.encodeColorString = function(e2) {
    var r2;
    "string" == typeof e2 && (e2 = { ch1: e2 });
    var n2 = e2.ch1, i3 = e2.ch2, a2 = e2.ch3, o3 = e2.ch4, s3 = "draw" === e2.pdfColorType ? ["G", "RG", "K"] : ["g", "rg", "k"];
    if ("string" == typeof n2 && "#" !== n2.charAt(0)) {
      var c3 = new f(n2);
      if (c3.ok)
        n2 = c3.toHex();
      else if (!/^\d*\.?\d*$/.test(n2))
        throw new Error('Invalid color "' + n2 + '" passed to jsPDF.encodeColorString.');
    }
    if ("string" == typeof n2 && /^#[0-9A-Fa-f]{3}$/.test(n2) && (n2 = "#" + n2[1] + n2[1] + n2[2] + n2[2] + n2[3] + n2[3]), "string" == typeof n2 && /^#[0-9A-Fa-f]{6}$/.test(n2)) {
      var u3 = parseInt(n2.substr(1), 16);
      n2 = u3 >> 16 & 255, i3 = u3 >> 8 & 255, a2 = 255 & u3;
    }
    if (void 0 === i3 || void 0 === o3 && n2 === i3 && i3 === a2)
      if ("string" == typeof n2)
        r2 = n2 + " " + s3[0];
      else
        switch (e2.precision) {
          case 2:
            r2 = R2(n2 / 255) + " " + s3[0];
            break;
          case 3:
          default:
            r2 = T2(n2 / 255) + " " + s3[0];
        }
    else if (void 0 === o3 || "object" === _typeof(o3)) {
      if (o3 && !isNaN(o3.a) && 0 === o3.a)
        return r2 = ["1.", "1.", "1.", s3[1]].join(" ");
      if ("string" == typeof n2)
        r2 = [n2, i3, a2, s3[1]].join(" ");
      else
        switch (e2.precision) {
          case 2:
            r2 = [R2(n2 / 255), R2(i3 / 255), R2(a2 / 255), s3[1]].join(" ");
            break;
          default:
          case 3:
            r2 = [T2(n2 / 255), T2(i3 / 255), T2(a2 / 255), s3[1]].join(" ");
        }
    } else if ("string" == typeof n2)
      r2 = [n2, i3, a2, o3, s3[2]].join(" ");
    else
      switch (e2.precision) {
        case 2:
          r2 = [R2(n2), R2(i3), R2(a2), R2(o3), s3[2]].join(" ");
          break;
        case 3:
        default:
          r2 = [T2(n2), T2(i3), T2(a2), T2(o3), s3[2]].join(" ");
      }
    return r2;
  }, ne2 = y2.__private__.getFilters = function() {
    return u2;
  }, ie2 = y2.__private__.putStream = function(t2) {
    var e2 = (t2 = t2 || {}).data || "", r2 = t2.filters || ne2(), n2 = t2.alreadyAppliedFilters || [], i3 = t2.addLength1 || false, a2 = e2.length, o3 = t2.objectId, s3 = function(t3) {
      return t3;
    };
    if (null !== m2 && void 0 === o3)
      throw new Error("ObjectId must be passed to putStream for file encryption");
    null !== m2 && (s3 = Ye.encryptor(o3, 0));
    var c3 = {};
    true === r2 && (r2 = ["FlateEncode"]);
    var u3 = t2.additionalKeyValues || [], h2 = (c3 = void 0 !== E.API.processDataByFilters ? E.API.processDataByFilters(e2, r2) : { data: e2, reverseChain: [] }).reverseChain + (Array.isArray(n2) ? n2.join(" ") : n2.toString());
    if (0 !== c3.data.length && (u3.push({ key: "Length", value: c3.data.length }), true === i3 && u3.push({ key: "Length1", value: a2 })), 0 != h2.length)
      if (h2.split("/").length - 1 == 1)
        u3.push({ key: "Filter", value: h2 });
      else {
        u3.push({ key: "Filter", value: "[" + h2 + "]" });
        for (var l2 = 0; l2 < u3.length; l2 += 1)
          if ("DecodeParms" === u3[l2].key) {
            for (var f2 = [], d3 = 0; d3 < c3.reverseChain.split("/").length - 1; d3 += 1)
              f2.push("null");
            f2.push(u3[l2].value), u3[l2].value = "[" + f2.join(" ") + "]";
          }
      }
    lt2("<<");
    for (var p3 = 0; p3 < u3.length; p3++)
      lt2("/" + u3[p3].key + " " + u3[p3].value);
    lt2(">>"), 0 !== c3.data.length && (lt2("stream"), lt2(s3(c3.data)), lt2("endstream"));
  }, ae2 = y2.__private__.putPage = function(t2) {
    var e2 = t2.number, r2 = t2.data, n2 = t2.objId, i3 = t2.contentsObjId;
    Zt2(n2, true), lt2("<</Type /Page"), lt2("/Parent " + t2.rootDictionaryObjId + " 0 R"), lt2("/Resources " + t2.resourceDictionaryObjId + " 0 R"), lt2("/MediaBox [" + parseFloat(O2(t2.mediaBox.bottomLeftX)) + " " + parseFloat(O2(t2.mediaBox.bottomLeftY)) + " " + O2(t2.mediaBox.topRightX) + " " + O2(t2.mediaBox.topRightY) + "]"), null !== t2.cropBox && lt2("/CropBox [" + O2(t2.cropBox.bottomLeftX) + " " + O2(t2.cropBox.bottomLeftY) + " " + O2(t2.cropBox.topRightX) + " " + O2(t2.cropBox.topRightY) + "]"), null !== t2.bleedBox && lt2("/BleedBox [" + O2(t2.bleedBox.bottomLeftX) + " " + O2(t2.bleedBox.bottomLeftY) + " " + O2(t2.bleedBox.topRightX) + " " + O2(t2.bleedBox.topRightY) + "]"), null !== t2.trimBox && lt2("/TrimBox [" + O2(t2.trimBox.bottomLeftX) + " " + O2(t2.trimBox.bottomLeftY) + " " + O2(t2.trimBox.topRightX) + " " + O2(t2.trimBox.topRightY) + "]"), null !== t2.artBox && lt2("/ArtBox [" + O2(t2.artBox.bottomLeftX) + " " + O2(t2.artBox.bottomLeftY) + " " + O2(t2.artBox.topRightX) + " " + O2(t2.artBox.topRightY) + "]"), "number" == typeof t2.userUnit && 1 !== t2.userUnit && lt2("/UserUnit " + t2.userUnit), Tt2.publish("putPage", { objId: n2, pageContext: Rt2[e2], pageNumber: e2, page: r2 }), lt2("/Contents " + i3 + " 0 R"), lt2(">>"), lt2("endobj");
    var a2 = r2.join("\n");
    return S2 === x2.ADVANCED && (a2 += "\nQ"), Zt2(i3, true), ie2({ data: a2, filters: ne2(), objectId: i3 }), lt2("endobj"), n2;
  }, oe2 = y2.__private__.putPages = function() {
    var t2, e2, r2 = [];
    for (t2 = 1; t2 <= Dt2; t2++)
      Rt2[t2].objId = Kt2(), Rt2[t2].contentsObjId = Kt2();
    for (t2 = 1; t2 <= Dt2; t2++)
      r2.push(ae2({ number: t2, data: ot2[t2], objId: Rt2[t2].objId, contentsObjId: Rt2[t2].contentsObjId, mediaBox: Rt2[t2].mediaBox, cropBox: Rt2[t2].cropBox, bleedBox: Rt2[t2].bleedBox, trimBox: Rt2[t2].trimBox, artBox: Rt2[t2].artBox, userUnit: Rt2[t2].userUnit, rootDictionaryObjId: Qt2, resourceDictionaryObjId: te2 }));
    Zt2(Qt2, true), lt2("<</Type /Pages");
    var n2 = "/Kids [";
    for (e2 = 0; e2 < Dt2; e2++)
      n2 += r2[e2] + " 0 R ";
    lt2(n2 + "]"), lt2("/Count " + Dt2), lt2(">>"), lt2("endobj"), Tt2.publish("postPutPages");
  }, se2 = function(t2) {
    Tt2.publish("putFont", { font: t2, out: lt2, newObject: Xt2, putStream: ie2 }), true !== t2.isAlreadyPutted && (t2.objectNumber = Xt2(), lt2("<<"), lt2("/Type /Font"), lt2("/BaseFont /" + F(t2.postScriptName)), lt2("/Subtype /Type1"), "string" == typeof t2.encoding && lt2("/Encoding /" + t2.encoding), lt2("/FirstChar 32"), lt2("/LastChar 255"), lt2(">>"), lt2("endobj"));
  }, ce2 = function() {
    for (var t2 in Ft2)
      Ft2.hasOwnProperty(t2) && (false === v2 || true === v2 && b2.hasOwnProperty(t2)) && se2(Ft2[t2]);
  }, ue2 = function(t2) {
    t2.objectNumber = Xt2();
    var e2 = [];
    e2.push({ key: "Type", value: "/XObject" }), e2.push({ key: "Subtype", value: "/Form" }), e2.push({ key: "BBox", value: "[" + [O2(t2.x), O2(t2.y), O2(t2.x + t2.width), O2(t2.y + t2.height)].join(" ") + "]" }), e2.push({ key: "Matrix", value: "[" + t2.matrix.toString() + "]" });
    var r2 = t2.pages[1].join("\n");
    ie2({ data: r2, additionalKeyValues: e2, objectId: t2.objectNumber }), lt2("endobj");
  }, he2 = function() {
    for (var t2 in zt2)
      zt2.hasOwnProperty(t2) && ue2(zt2[t2]);
  }, le2 = function(t2, e2) {
    var r2, n2 = [], i3 = 1 / (e2 - 1);
    for (r2 = 0; r2 < 1; r2 += i3)
      n2.push(r2);
    if (n2.push(1), 0 != t2[0].offset) {
      var a2 = { offset: 0, color: t2[0].color };
      t2.unshift(a2);
    }
    if (1 != t2[t2.length - 1].offset) {
      var o3 = { offset: 1, color: t2[t2.length - 1].color };
      t2.push(o3);
    }
    for (var s3 = "", c3 = 0, u3 = 0; u3 < n2.length; u3++) {
      for (r2 = n2[u3]; r2 > t2[c3 + 1].offset; )
        c3++;
      var h2 = t2[c3].offset, l2 = (r2 - h2) / (t2[c3 + 1].offset - h2), f2 = t2[c3].color, d3 = t2[c3 + 1].color;
      s3 += tt2(Math.round((1 - l2) * f2[0] + l2 * d3[0]).toString(16)) + tt2(Math.round((1 - l2) * f2[1] + l2 * d3[1]).toString(16)) + tt2(Math.round((1 - l2) * f2[2] + l2 * d3[2]).toString(16));
    }
    return s3.trim();
  }, fe2 = function(t2, e2) {
    e2 || (e2 = 21);
    var r2 = Xt2(), n2 = le2(t2.colors, e2), i3 = [];
    i3.push({ key: "FunctionType", value: "0" }), i3.push({ key: "Domain", value: "[0.0 1.0]" }), i3.push({ key: "Size", value: "[" + e2 + "]" }), i3.push({ key: "BitsPerSample", value: "8" }), i3.push({ key: "Range", value: "[0.0 1.0 0.0 1.0 0.0 1.0]" }), i3.push({ key: "Decode", value: "[0.0 1.0 0.0 1.0 0.0 1.0]" }), ie2({ data: n2, additionalKeyValues: i3, alreadyAppliedFilters: ["/ASCIIHexDecode"], objectId: r2 }), lt2("endobj"), t2.objectNumber = Xt2(), lt2("<< /ShadingType " + t2.type), lt2("/ColorSpace /DeviceRGB");
    var a2 = "/Coords [" + O2(parseFloat(t2.coords[0])) + " " + O2(parseFloat(t2.coords[1])) + " ";
    2 === t2.type ? a2 += O2(parseFloat(t2.coords[2])) + " " + O2(parseFloat(t2.coords[3])) : a2 += O2(parseFloat(t2.coords[2])) + " " + O2(parseFloat(t2.coords[3])) + " " + O2(parseFloat(t2.coords[4])) + " " + O2(parseFloat(t2.coords[5])), lt2(a2 += "]"), t2.matrix && lt2("/Matrix [" + t2.matrix.toString() + "]"), lt2("/Function " + r2 + " 0 R"), lt2("/Extend [true true]"), lt2(">>"), lt2("endobj");
  }, de2 = function(t2, e2) {
    var r2 = Kt2(), n2 = Xt2();
    e2.push({ resourcesOid: r2, objectOid: n2 }), t2.objectNumber = n2;
    var i3 = [];
    i3.push({ key: "Type", value: "/Pattern" }), i3.push({ key: "PatternType", value: "1" }), i3.push({ key: "PaintType", value: "1" }), i3.push({ key: "TilingType", value: "1" }), i3.push({ key: "BBox", value: "[" + t2.boundingBox.map(O2).join(" ") + "]" }), i3.push({ key: "XStep", value: O2(t2.xStep) }), i3.push({ key: "YStep", value: O2(t2.yStep) }), i3.push({ key: "Resources", value: r2 + " 0 R" }), t2.matrix && i3.push({ key: "Matrix", value: "[" + t2.matrix.toString() + "]" }), ie2({ data: t2.stream, additionalKeyValues: i3, objectId: t2.objectNumber }), lt2("endobj");
  }, pe2 = function(t2) {
    var e2;
    for (e2 in Ot2)
      Ot2.hasOwnProperty(e2) && (Ot2[e2] instanceof B ? fe2(Ot2[e2]) : Ot2[e2] instanceof M && de2(Ot2[e2], t2));
  }, ge2 = function(t2) {
    for (var e2 in t2.objectNumber = Xt2(), lt2("<<"), t2)
      switch (e2) {
        case "opacity":
          lt2("/ca " + R2(t2[e2]));
          break;
        case "stroke-opacity":
          lt2("/CA " + R2(t2[e2]));
      }
    lt2(">>"), lt2("endobj");
  }, me2 = function() {
    var t2;
    for (t2 in Mt2)
      Mt2.hasOwnProperty(t2) && ge2(Mt2[t2]);
  }, ve2 = function() {
    for (var t2 in lt2("/XObject <<"), zt2)
      zt2.hasOwnProperty(t2) && zt2[t2].objectNumber >= 0 && lt2("/" + t2 + " " + zt2[t2].objectNumber + " 0 R");
    Tt2.publish("putXobjectDict"), lt2(">>");
  }, be2 = function() {
    Ye.oid = Xt2(), lt2("<<"), lt2("/Filter /Standard"), lt2("/V " + Ye.v), lt2("/R " + Ye.r), lt2("/U <" + Ye.toHexString(Ye.U) + ">"), lt2("/O <" + Ye.toHexString(Ye.O) + ">"), lt2("/P " + Ye.P), lt2(">>"), lt2("endobj");
  }, ye2 = function() {
    for (var t2 in lt2("/Font <<"), Ft2)
      Ft2.hasOwnProperty(t2) && (false === v2 || true === v2 && b2.hasOwnProperty(t2)) && lt2("/" + t2 + " " + Ft2[t2].objectNumber + " 0 R");
    lt2(">>");
  }, we2 = function() {
    if (Object.keys(Ot2).length > 0) {
      for (var t2 in lt2("/Shading <<"), Ot2)
        Ot2.hasOwnProperty(t2) && Ot2[t2] instanceof B && Ot2[t2].objectNumber >= 0 && lt2("/" + t2 + " " + Ot2[t2].objectNumber + " 0 R");
      Tt2.publish("putShadingPatternDict"), lt2(">>");
    }
  }, Ne2 = function(t2) {
    if (Object.keys(Ot2).length > 0) {
      for (var e2 in lt2("/Pattern <<"), Ot2)
        Ot2.hasOwnProperty(e2) && Ot2[e2] instanceof y2.TilingPattern && Ot2[e2].objectNumber >= 0 && Ot2[e2].objectNumber < t2 && lt2("/" + e2 + " " + Ot2[e2].objectNumber + " 0 R");
      Tt2.publish("putTilingPatternDict"), lt2(">>");
    }
  }, Le2 = function() {
    if (Object.keys(Mt2).length > 0) {
      var t2;
      for (t2 in lt2("/ExtGState <<"), Mt2)
        Mt2.hasOwnProperty(t2) && Mt2[t2].objectNumber >= 0 && lt2("/" + t2 + " " + Mt2[t2].objectNumber + " 0 R");
      Tt2.publish("putGStateDict"), lt2(">>");
    }
  }, Ae = function(t2) {
    Zt2(t2.resourcesOid, true), lt2("<<"), lt2("/ProcSet [/PDF /Text /ImageB /ImageC /ImageI]"), ye2(), we2(), Ne2(t2.objectOid), Le2(), ve2(), lt2(">>"), lt2("endobj");
  }, xe = function() {
    var t2 = [];
    ce2(), me2(), he2(), pe2(t2), Tt2.publish("putResources"), t2.forEach(Ae), Ae({ resourcesOid: te2, objectOid: Number.MAX_SAFE_INTEGER }), Tt2.publish("postPutResources");
  }, Se = function() {
    Tt2.publish("putAdditionalObjects");
    for (var t2 = 0; t2 < at2.length; t2++) {
      var e2 = at2[t2];
      Zt2(e2.objId, true), lt2(e2.content), lt2("endobj");
    }
    Tt2.publish("postPutAdditionalObjects");
  }, _e = function(t2) {
    Ct2[t2.fontName] = Ct2[t2.fontName] || {}, Ct2[t2.fontName][t2.fontStyle] = t2.id;
  }, Pe = function(t2, e2, r2, n2, i3) {
    var a2 = { id: "F" + (Object.keys(Ft2).length + 1).toString(10), postScriptName: t2, fontName: e2, fontStyle: r2, encoding: n2, isStandardFont: i3 || false, metadata: {} };
    return Tt2.publish("addFont", { font: a2, instance: this }), Ft2[a2.id] = a2, _e(a2), a2.id;
  }, ke = function(t2) {
    for (var e2 = 0, r2 = pt2.length; e2 < r2; e2++) {
      var n2 = Pe.call(this, t2[e2][0], t2[e2][1], t2[e2][2], pt2[e2][3], true);
      false === v2 && (b2[n2] = true);
      var i3 = t2[e2][0].split("-");
      _e({ id: n2, fontName: i3[0], fontStyle: i3[1] || "" });
    }
    Tt2.publish("addFonts", { fonts: Ft2, dictionary: Ct2 });
  }, Ie = function(t2) {
    return t2.foo = function() {
      try {
        return t2.apply(this, arguments);
      } catch (t3) {
        var e2 = t3.stack || "";
        ~e2.indexOf(" at ") && (e2 = e2.split(" at ")[1]);
        var r2 = "Error in function " + e2.split("\n")[0].split("<")[0] + ": " + t3.message;
        if (!n.console)
          throw new Error(r2);
        n.console.error(r2, t3), n.alert && alert(r2);
      }
    }, t2.foo.bar = t2, t2.foo;
  }, Fe = function(t2, e2) {
    var r2, n2, i3, a2, o3, s3, c3, u3, h2;
    if (i3 = (e2 = e2 || {}).sourceEncoding || "Unicode", o3 = e2.outputEncoding, (e2.autoencode || o3) && Ft2[St2].metadata && Ft2[St2].metadata[i3] && Ft2[St2].metadata[i3].encoding && (a2 = Ft2[St2].metadata[i3].encoding, !o3 && Ft2[St2].encoding && (o3 = Ft2[St2].encoding), !o3 && a2.codePages && (o3 = a2.codePages[0]), "string" == typeof o3 && (o3 = a2[o3]), o3)) {
      for (c3 = false, s3 = [], r2 = 0, n2 = t2.length; r2 < n2; r2++)
        (u3 = o3[t2.charCodeAt(r2)]) ? s3.push(String.fromCharCode(u3)) : s3.push(t2[r2]), s3[r2].charCodeAt(0) >> 8 && (c3 = true);
      t2 = s3.join("");
    }
    for (r2 = t2.length; void 0 === c3 && 0 !== r2; )
      t2.charCodeAt(r2 - 1) >> 8 && (c3 = true), r2--;
    if (!c3)
      return t2;
    for (s3 = e2.noBOM ? [] : [254, 255], r2 = 0, n2 = t2.length; r2 < n2; r2++) {
      if ((h2 = (u3 = t2.charCodeAt(r2)) >> 8) >> 8)
        throw new Error("Character at position " + r2 + " of string '" + t2 + "' exceeds 16bits. Cannot be encoded into UCS-2 BE");
      s3.push(h2), s3.push(u3 - (h2 << 8));
    }
    return String.fromCharCode.apply(void 0, s3);
  }, Ce = y2.__private__.pdfEscape = y2.pdfEscape = function(t2, e2) {
    return Fe(t2, e2).replace(/\\/g, "\\\\").replace(/\(/g, "\\(").replace(/\)/g, "\\)");
  }, je = y2.__private__.beginPage = function(t2) {
    ot2[++Dt2] = [], Rt2[Dt2] = { objId: 0, contentsObjId: 0, userUnit: Number(d2), artBox: null, bleedBox: null, cropBox: null, trimBox: null, mediaBox: { bottomLeftX: 0, bottomLeftY: 0, topRightX: Number(t2[0]), topRightY: Number(t2[1]) } }, Me(Dt2), ht2(ot2[$3]);
  }, Oe = function(t2, e2) {
    var r2, n2, o3;
    switch (i2 = e2 || i2, "string" == typeof t2 && (r2 = A2(t2.toLowerCase()), Array.isArray(r2) && (n2 = r2[0], o3 = r2[1])), Array.isArray(t2) && (n2 = t2[0] * _t2, o3 = t2[1] * _t2), isNaN(n2) && (n2 = s2[0], o3 = s2[1]), (n2 > 14400 || o3 > 14400) && (a.warn("A page in a PDF can not be wider or taller than 14400 userUnit. jsPDF limits the width/height to 14400"), n2 = Math.min(14400, n2), o3 = Math.min(14400, o3)), s2 = [n2, o3], i2.substr(0, 1)) {
      case "l":
        o3 > n2 && (s2 = [o3, n2]);
        break;
      case "p":
        n2 > o3 && (s2 = [o3, n2]);
    }
    je(s2), pr(fr), lt2(Lr), 0 !== kr && lt2(kr + " J"), 0 !== Ir && lt2(Ir + " j"), Tt2.publish("addPage", { pageNumber: Dt2 });
  }, Be = function(t2) {
    t2 > 0 && t2 <= Dt2 && (ot2.splice(t2, 1), Rt2.splice(t2, 1), Dt2--, $3 > Dt2 && ($3 = Dt2), this.setPage($3));
  }, Me = function(t2) {
    t2 > 0 && t2 <= Dt2 && ($3 = t2);
  }, Ee = y2.__private__.getNumberOfPages = y2.getNumberOfPages = function() {
    return ot2.length - 1;
  }, qe = function(t2, e2, r2) {
    var n2, i3 = void 0;
    return r2 = r2 || {}, t2 = void 0 !== t2 ? t2 : Ft2[St2].fontName, e2 = void 0 !== e2 ? e2 : Ft2[St2].fontStyle, n2 = t2.toLowerCase(), void 0 !== Ct2[n2] && void 0 !== Ct2[n2][e2] ? i3 = Ct2[n2][e2] : void 0 !== Ct2[t2] && void 0 !== Ct2[t2][e2] ? i3 = Ct2[t2][e2] : false === r2.disableWarning && a.warn("Unable to look up font label for font '" + t2 + "', '" + e2 + "'. Refer to getFontList() for available fonts."), i3 || r2.noFallback || null == (i3 = Ct2.times[e2]) && (i3 = Ct2.times.normal), i3;
  }, De = y2.__private__.putInfo = function() {
    var t2 = Xt2(), e2 = function(t3) {
      return t3;
    };
    for (var r2 in null !== m2 && (e2 = Ye.encryptor(t2, 0)), lt2("<<"), lt2("/Producer (" + Ce(e2("jsPDF " + E.version)) + ")"), xt2)
      xt2.hasOwnProperty(r2) && xt2[r2] && lt2("/" + r2.substr(0, 1).toUpperCase() + r2.substr(1) + " (" + Ce(e2(xt2[r2])) + ")");
    lt2("/CreationDate (" + Ce(e2(W2)) + ")"), lt2(">>"), lt2("endobj");
  }, Re = y2.__private__.putCatalog = function(t2) {
    var e2 = (t2 = t2 || {}).rootDictionaryObjId || Qt2;
    switch (Xt2(), lt2("<<"), lt2("/Type /Catalog"), lt2("/Pages " + e2 + " 0 R"), mt2 || (mt2 = "fullwidth"), mt2) {
      case "fullwidth":
        lt2("/OpenAction [3 0 R /FitH null]");
        break;
      case "fullheight":
        lt2("/OpenAction [3 0 R /FitV null]");
        break;
      case "fullpage":
        lt2("/OpenAction [3 0 R /Fit]");
        break;
      case "original":
        lt2("/OpenAction [3 0 R /XYZ null null 1]");
        break;
      default:
        var r2 = "" + mt2;
        "%" === r2.substr(r2.length - 1) && (mt2 = parseInt(mt2) / 100), "number" == typeof mt2 && lt2("/OpenAction [3 0 R /XYZ null null " + R2(mt2) + "]");
    }
    switch (Nt2 || (Nt2 = "continuous"), Nt2) {
      case "continuous":
        lt2("/PageLayout /OneColumn");
        break;
      case "single":
        lt2("/PageLayout /SinglePage");
        break;
      case "two":
      case "twoleft":
        lt2("/PageLayout /TwoColumnLeft");
        break;
      case "tworight":
        lt2("/PageLayout /TwoColumnRight");
    }
    yt2 && lt2("/PageMode /" + yt2), Tt2.publish("putCatalog"), lt2(">>"), lt2("endobj");
  }, Te = y2.__private__.putTrailer = function() {
    lt2("trailer"), lt2("<<"), lt2("/Size " + (et3 + 1)), lt2("/Root " + et3 + " 0 R"), lt2("/Info " + (et3 - 1) + " 0 R"), null !== m2 && lt2("/Encrypt " + Ye.oid + " 0 R"), lt2("/ID [ <" + V2 + "> <" + V2 + "> ]"), lt2(">>");
  }, Ue = y2.__private__.putHeader = function() {
    lt2("%PDF-" + w2), lt2("%\xBA\xDF\xAC\xE0");
  }, ze = y2.__private__.putXRef = function() {
    var t2 = "0000000000";
    lt2("xref"), lt2("0 " + (et3 + 1)), lt2("0000000000 65535 f ");
    for (var e2 = 1; e2 <= et3; e2++) {
      "function" == typeof rt2[e2] ? lt2((t2 + rt2[e2]()).slice(-10) + " 00000 n ") : void 0 !== rt2[e2] ? lt2((t2 + rt2[e2]).slice(-10) + " 00000 n ") : lt2("0000000000 00000 n ");
    }
  }, He = y2.__private__.buildDocument = function() {
    ut2(), ht2(nt2), Tt2.publish("buildDocument"), Ue(), oe2(), Se(), xe(), null !== m2 && be2(), De(), Re();
    var t2 = it2;
    return ze(), Te(), lt2("startxref"), lt2("" + t2), lt2("%%EOF"), ht2(ot2[$3]), nt2.join("\n");
  }, We = y2.__private__.getBlob = function(t2) {
    return new Blob([dt2(t2)], { type: "application/pdf" });
  }, Ve = y2.output = y2.__private__.output = Ie(function(t2, e2) {
    switch ("string" == typeof (e2 = e2 || {}) ? e2 = { filename: e2 } : e2.filename = e2.filename || "generated.pdf", t2) {
      case void 0:
        return He();
      case "save":
        y2.save(e2.filename);
        break;
      case "arraybuffer":
        return dt2(He());
      case "blob":
        return We(He());
      case "bloburi":
      case "bloburl":
        if (void 0 !== n.URL && "function" == typeof n.URL.createObjectURL)
          return n.URL && n.URL.createObjectURL(We(He())) || void 0;
        a.warn("bloburl is not supported by your system, because URL.createObjectURL is not supported by your browser.");
        break;
      case "datauristring":
      case "dataurlstring":
        var r2 = "", i3 = He();
        try {
          r2 = h(i3);
        } catch (t3) {
          r2 = h(unescape(encodeURIComponent(i3)));
        }
        return "data:application/pdf;filename=" + e2.filename + ";base64," + r2;
      case "pdfobjectnewwindow":
        if ("[object Window]" === Object.prototype.toString.call(n)) {
          var o3 = "https://cdnjs.cloudflare.com/ajax/libs/pdfobject/2.1.1/pdfobject.min.js", s3 = ' integrity="sha512-4ze/a9/4jqu+tX9dfOqJYSvyYd5M6qum/3HpCLr+/Jqf0whc37VUbkpNGHR7/8pSnCFw47T1fmIpwBV7UySh3g==" crossorigin="anonymous"';
          e2.pdfObjectUrl && (o3 = e2.pdfObjectUrl, s3 = "");
          var c3 = '<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><script src="' + o3 + '"' + s3 + '><\/script><script >PDFObject.embed("' + this.output("dataurlstring") + '", ' + JSON.stringify(e2) + ");<\/script></body></html>", u3 = n.open();
          return null !== u3 && u3.document.write(c3), u3;
        }
        throw new Error("The option pdfobjectnewwindow just works in a browser-environment.");
      case "pdfjsnewwindow":
        if ("[object Window]" === Object.prototype.toString.call(n)) {
          var l2 = '<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe id="pdfViewer" src="' + (e2.pdfJsUrl || "examples/PDF.js/web/viewer.html") + "?file=&downloadName=" + e2.filename + '" width="500px" height="400px" /></body></html>', f2 = n.open();
          if (null !== f2) {
            f2.document.write(l2);
            var d3 = this;
            f2.document.documentElement.querySelector("#pdfViewer").onload = function() {
              f2.document.title = e2.filename, f2.document.documentElement.querySelector("#pdfViewer").contentWindow.PDFViewerApplication.open(d3.output("bloburl"));
            };
          }
          return f2;
        }
        throw new Error("The option pdfjsnewwindow just works in a browser-environment.");
      case "dataurlnewwindow":
        if ("[object Window]" !== Object.prototype.toString.call(n))
          throw new Error("The option dataurlnewwindow just works in a browser-environment.");
        var p3 = '<html><style>html, body { padding: 0; margin: 0; } iframe { width: 100%; height: 100%; border: 0;}  </style><body><iframe src="' + this.output("datauristring", e2) + '"></iframe></body></html>', g3 = n.open();
        if (null !== g3 && (g3.document.write(p3), g3.document.title = e2.filename), g3 || "undefined" == typeof safari)
          return g3;
        break;
      case "datauri":
      case "dataurl":
        return n.document.location.href = this.output("datauristring", e2);
      default:
        return null;
    }
  }), Ge = function(t2) {
    return true === Array.isArray(Ut2) && Ut2.indexOf(t2) > -1;
  };
  switch (o2) {
    case "pt":
      _t2 = 1;
      break;
    case "mm":
      _t2 = 72 / 25.4;
      break;
    case "cm":
      _t2 = 72 / 2.54;
      break;
    case "in":
      _t2 = 72;
      break;
    case "px":
      _t2 = 1 == Ge("px_scaling") ? 0.75 : 96 / 72;
      break;
    case "pc":
    case "em":
      _t2 = 12;
      break;
    case "ex":
      _t2 = 6;
      break;
    default:
      if ("number" != typeof o2)
        throw new Error("Invalid unit: " + o2);
      _t2 = o2;
  }
  var Ye = null;
  K2(), Y2();
  var Je = function(t2) {
    return null !== m2 ? Ye.encryptor(t2, 0) : function(t3) {
      return t3;
    };
  }, Xe = y2.__private__.getPageInfo = y2.getPageInfo = function(t2) {
    if (isNaN(t2) || t2 % 1 != 0)
      throw new Error("Invalid argument passed to jsPDF.getPageInfo");
    return { objId: Rt2[t2].objId, pageNumber: t2, pageContext: Rt2[t2] };
  }, Ke = y2.__private__.getPageInfoByObjId = function(t2) {
    if (isNaN(t2) || t2 % 1 != 0)
      throw new Error("Invalid argument passed to jsPDF.getPageInfoByObjId");
    for (var e2 in Rt2)
      if (Rt2[e2].objId === t2)
        break;
    return Xe(e2);
  }, Ze = y2.__private__.getCurrentPageInfo = y2.getCurrentPageInfo = function() {
    return { objId: Rt2[$3].objId, pageNumber: $3, pageContext: Rt2[$3] };
  };
  y2.addPage = function() {
    return Oe.apply(this, arguments), this;
  }, y2.setPage = function() {
    return Me.apply(this, arguments), ht2.call(this, ot2[$3]), this;
  }, y2.insertPage = function(t2) {
    return this.addPage(), this.movePage($3, t2), this;
  }, y2.movePage = function(t2, e2) {
    var r2, n2;
    if (t2 > e2) {
      r2 = ot2[t2], n2 = Rt2[t2];
      for (var i3 = t2; i3 > e2; i3--)
        ot2[i3] = ot2[i3 - 1], Rt2[i3] = Rt2[i3 - 1];
      ot2[e2] = r2, Rt2[e2] = n2, this.setPage(e2);
    } else if (t2 < e2) {
      r2 = ot2[t2], n2 = Rt2[t2];
      for (var a2 = t2; a2 < e2; a2++)
        ot2[a2] = ot2[a2 + 1], Rt2[a2] = Rt2[a2 + 1];
      ot2[e2] = r2, Rt2[e2] = n2, this.setPage(e2);
    }
    return this;
  }, y2.deletePage = function() {
    return Be.apply(this, arguments), this;
  }, y2.__private__.text = y2.text = function(e2, r2, n2, i3, a2) {
    var o3, s3, c3, u3, h2, l2, f2, d3, p3, g3 = (i3 = i3 || {}).scope || this;
    if ("number" == typeof e2 && "number" == typeof r2 && ("string" == typeof n2 || Array.isArray(n2))) {
      var m3 = n2;
      n2 = r2, r2 = e2, e2 = m3;
    }
    if (arguments[3] instanceof Vt2 == false ? (c3 = arguments[4], u3 = arguments[5], "object" === _typeof(f2 = arguments[3]) && null !== f2 || ("string" == typeof c3 && (u3 = c3, c3 = null), "string" == typeof f2 && (u3 = f2, f2 = null), "number" == typeof f2 && (c3 = f2, f2 = null), i3 = { flags: f2, angle: c3, align: u3 })) : (q2("The transform parameter of text() with a Matrix value"), p3 = a2), isNaN(r2) || isNaN(n2) || null == e2)
      throw new Error("Invalid arguments passed to jsPDF.text");
    if (0 === e2.length)
      return g3;
    var v3 = "", y3 = false, w3 = "number" == typeof i3.lineHeightFactor ? i3.lineHeightFactor : lr, N3 = g3.internal.scaleFactor;
    function L3(t2) {
      return t2 = t2.split("	").join(Array(i3.TabLen || 9).join(" ")), Ce(t2, f2);
    }
    function A3(t2) {
      for (var e3, r3 = t2.concat(), n3 = [], i4 = r3.length; i4--; )
        "string" == typeof (e3 = r3.shift()) ? n3.push(e3) : Array.isArray(t2) && (1 === e3.length || void 0 === e3[1] && void 0 === e3[2]) ? n3.push(e3[0]) : n3.push([e3[0], e3[1], e3[2]]);
      return n3;
    }
    function _3(t2, e3) {
      var r3;
      if ("string" == typeof t2)
        r3 = e3(t2)[0];
      else if (Array.isArray(t2)) {
        for (var n3, i4, a3 = t2.concat(), o4 = [], s4 = a3.length; s4--; )
          "string" == typeof (n3 = a3.shift()) ? o4.push(e3(n3)[0]) : Array.isArray(n3) && "string" == typeof n3[0] && (i4 = e3(n3[0], n3[1], n3[2]), o4.push([i4[0], i4[1], i4[2]]));
        r3 = o4;
      }
      return r3;
    }
    var P3 = false, k3 = true;
    if ("string" == typeof e2)
      P3 = true;
    else if (Array.isArray(e2)) {
      var I2 = e2.concat();
      s3 = [];
      for (var F2, C2 = I2.length; C2--; )
        ("string" != typeof (F2 = I2.shift()) || Array.isArray(F2) && "string" != typeof F2[0]) && (k3 = false);
      P3 = k3;
    }
    if (false === P3)
      throw new Error('Type of text must be string or Array. "' + e2 + '" is not recognized.');
    "string" == typeof e2 && (e2 = e2.match(/[\r?\n]/) ? e2.split(/\r\n|\r|\n/g) : [e2]);
    var j2 = gt2 / g3.internal.scaleFactor, B2 = j2 * (w3 - 1);
    switch (i3.baseline) {
      case "bottom":
        n2 -= B2;
        break;
      case "top":
        n2 += j2 - B2;
        break;
      case "hanging":
        n2 += j2 - 2 * B2;
        break;
      case "middle":
        n2 += j2 / 2 - B2;
    }
    if ((l2 = i3.maxWidth || 0) > 0 && ("string" == typeof e2 ? e2 = g3.splitTextToSize(e2, l2) : "[object Array]" === Object.prototype.toString.call(e2) && (e2 = e2.reduce(function(t2, e3) {
      return t2.concat(g3.splitTextToSize(e3, l2));
    }, []))), o3 = { text: e2, x: r2, y: n2, options: i3, mutex: { pdfEscape: Ce, activeFontKey: St2, fonts: Ft2, activeFontSize: gt2 } }, Tt2.publish("preProcessText", o3), e2 = o3.text, c3 = (i3 = o3.options).angle, p3 instanceof Vt2 == false && c3 && "number" == typeof c3) {
      c3 *= Math.PI / 180, 0 === i3.rotationDirection && (c3 = -c3), S2 === x2.ADVANCED && (c3 = -c3);
      var M2 = Math.cos(c3), E2 = Math.sin(c3);
      p3 = new Vt2(M2, E2, -E2, M2, 0, 0);
    } else
      c3 && c3 instanceof Vt2 && (p3 = c3);
    S2 !== x2.ADVANCED || p3 || (p3 = Yt2), void 0 !== (h2 = i3.charSpace || _r) && (v3 += O2(U2(h2)) + " Tc\n", this.setCharSpace(this.getCharSpace() || 0)), void 0 !== (d3 = i3.horizontalScale) && (v3 += O2(100 * d3) + " Tz\n");
    i3.lang;
    var D3 = -1, R3 = void 0 !== i3.renderingMode ? i3.renderingMode : i3.stroke, T3 = g3.internal.getCurrentPageInfo().pageContext;
    switch (R3) {
      case 0:
      case false:
      case "fill":
        D3 = 0;
        break;
      case 1:
      case true:
      case "stroke":
        D3 = 1;
        break;
      case 2:
      case "fillThenStroke":
        D3 = 2;
        break;
      case 3:
      case "invisible":
        D3 = 3;
        break;
      case 4:
      case "fillAndAddForClipping":
        D3 = 4;
        break;
      case 5:
      case "strokeAndAddPathForClipping":
        D3 = 5;
        break;
      case 6:
      case "fillThenStrokeAndAddToPathForClipping":
        D3 = 6;
        break;
      case 7:
      case "addToPathForClipping":
        D3 = 7;
    }
    var z3 = void 0 !== T3.usedRenderingMode ? T3.usedRenderingMode : -1;
    -1 !== D3 ? v3 += D3 + " Tr\n" : -1 !== z3 && (v3 += "0 Tr\n"), -1 !== D3 && (T3.usedRenderingMode = D3), u3 = i3.align || "left";
    var H3, W3 = gt2 * w3, V3 = g3.internal.pageSize.getWidth(), G3 = Ft2[St2];
    h2 = i3.charSpace || _r, l2 = i3.maxWidth || 0, f2 = Object.assign({ autoencode: true, noBOM: true }, i3.flags);
    var Y3 = [], J3 = function(t2) {
      return g3.getStringUnitWidth(t2, { font: G3, charSpace: h2, fontSize: gt2, doKerning: false }) * gt2 / N3;
    };
    if ("[object Array]" === Object.prototype.toString.call(e2)) {
      var X3;
      s3 = A3(e2), "left" !== u3 && (H3 = s3.map(J3));
      var K3, Z3 = 0;
      if ("right" === u3) {
        r2 -= H3[0], e2 = [], C2 = s3.length;
        for (var $4 = 0; $4 < C2; $4++)
          0 === $4 ? (K3 = br(r2), X3 = yr(n2)) : (K3 = U2(Z3 - H3[$4]), X3 = -W3), e2.push([s3[$4], K3, X3]), Z3 = H3[$4];
      } else if ("center" === u3) {
        r2 -= H3[0] / 2, e2 = [], C2 = s3.length;
        for (var Q3 = 0; Q3 < C2; Q3++)
          0 === Q3 ? (K3 = br(r2), X3 = yr(n2)) : (K3 = U2((Z3 - H3[Q3]) / 2), X3 = -W3), e2.push([s3[Q3], K3, X3]), Z3 = H3[Q3];
      } else if ("left" === u3) {
        e2 = [], C2 = s3.length;
        for (var tt3 = 0; tt3 < C2; tt3++)
          e2.push(s3[tt3]);
      } else if ("justify" === u3 && "Identity-H" === G3.encoding) {
        e2 = [], C2 = s3.length, l2 = 0 !== l2 ? l2 : V3;
        for (var et4 = 0, rt3 = 0; rt3 < C2; rt3++)
          if (X3 = 0 === rt3 ? yr(n2) : -W3, K3 = 0 === rt3 ? br(r2) : et4, rt3 < C2 - 1) {
            var nt3 = U2((l2 - H3[rt3]) / (s3[rt3].split(" ").length - 1)), it3 = s3[rt3].split(" ");
            e2.push([it3[0] + " ", K3, X3]), et4 = 0;
            for (var at3 = 1; at3 < it3.length; at3++) {
              var ot3 = (J3(it3[at3 - 1] + " " + it3[at3]) - J3(it3[at3])) * N3 + nt3;
              at3 == it3.length - 1 ? e2.push([it3[at3], ot3, 0]) : e2.push([it3[at3] + " ", ot3, 0]), et4 -= ot3;
            }
          } else
            e2.push([s3[rt3], K3, X3]);
        e2.push(["", et4, 0]);
      } else {
        if ("justify" !== u3)
          throw new Error('Unrecognized alignment option, use "left", "center", "right" or "justify".');
        e2 = [], C2 = s3.length, l2 = 0 !== l2 ? l2 : V3;
        for (rt3 = 0; rt3 < C2; rt3++)
          X3 = 0 === rt3 ? yr(n2) : -W3, K3 = 0 === rt3 ? br(r2) : 0, rt3 < C2 - 1 ? Y3.push(O2(U2((l2 - H3[rt3]) / (s3[rt3].split(" ").length - 1)))) : Y3.push(0), e2.push([s3[rt3], K3, X3]);
      }
    }
    var st3 = "boolean" == typeof i3.R2L ? i3.R2L : bt2;
    true === st3 && (e2 = _3(e2, function(t2, e3, r3) {
      return [t2.split("").reverse().join(""), e3, r3];
    })), o3 = { text: e2, x: r2, y: n2, options: i3, mutex: { pdfEscape: Ce, activeFontKey: St2, fonts: Ft2, activeFontSize: gt2 } }, Tt2.publish("postProcessText", o3), e2 = o3.text, y3 = o3.mutex.isHex || false;
    var ct3 = Ft2[St2].encoding;
    "WinAnsiEncoding" !== ct3 && "StandardEncoding" !== ct3 || (e2 = _3(e2, function(t2, e3, r3) {
      return [L3(t2), e3, r3];
    })), s3 = A3(e2), e2 = [];
    for (var ut3, ht3, ft3, dt3 = 0, pt3 = 1, mt3 = Array.isArray(s3[0]) ? pt3 : dt3, vt3 = "", yt3 = function(t2, e3, r3) {
      var n3 = "";
      return r3 instanceof Vt2 ? (r3 = "number" == typeof i3.angle ? Gt2(r3, new Vt2(1, 0, 0, 1, t2, e3)) : Gt2(new Vt2(1, 0, 0, 1, t2, e3), r3), S2 === x2.ADVANCED && (r3 = Gt2(new Vt2(1, 0, 0, -1, 0, 0), r3)), n3 = r3.join(" ") + " Tm\n") : n3 = O2(t2) + " " + O2(e3) + " Td\n", n3;
    }, wt3 = 0; wt3 < s3.length; wt3++) {
      switch (vt3 = "", mt3) {
        case pt3:
          ft3 = (y3 ? "<" : "(") + s3[wt3][0] + (y3 ? ">" : ")"), ut3 = parseFloat(s3[wt3][1]), ht3 = parseFloat(s3[wt3][2]);
          break;
        case dt3:
          ft3 = (y3 ? "<" : "(") + s3[wt3] + (y3 ? ">" : ")"), ut3 = br(r2), ht3 = yr(n2);
      }
      void 0 !== Y3 && void 0 !== Y3[wt3] && (vt3 = Y3[wt3] + " Tw\n"), 0 === wt3 ? e2.push(vt3 + yt3(ut3, ht3, p3) + ft3) : mt3 === dt3 ? e2.push(vt3 + ft3) : mt3 === pt3 && e2.push(vt3 + yt3(ut3, ht3, p3) + ft3);
    }
    e2 = mt3 === dt3 ? e2.join(" Tj\nT* ") : e2.join(" Tj\n"), e2 += " Tj\n";
    var Nt3 = "BT\n/";
    return Nt3 += St2 + " " + gt2 + " Tf\n", Nt3 += O2(gt2 * w3) + " TL\n", Nt3 += xr + "\n", Nt3 += v3, Nt3 += e2, lt2(Nt3 += "ET"), b2[St2] = true, g3;
  };
  var $e = y2.__private__.clip = y2.clip = function(t2) {
    return lt2("evenodd" === t2 ? "W*" : "W"), this;
  };
  y2.clipEvenOdd = function() {
    return $e("evenodd");
  }, y2.__private__.discardPath = y2.discardPath = function() {
    return lt2("n"), this;
  };
  var Qe = y2.__private__.isValidStyle = function(t2) {
    var e2 = false;
    return -1 !== [void 0, null, "S", "D", "F", "DF", "FD", "f", "f*", "B", "B*", "n"].indexOf(t2) && (e2 = true), e2;
  };
  y2.__private__.setDefaultPathOperation = y2.setDefaultPathOperation = function(t2) {
    return Qe(t2) && (g2 = t2), this;
  };
  var tr = y2.__private__.getStyle = y2.getStyle = function(t2) {
    var e2 = g2;
    switch (t2) {
      case "D":
      case "S":
        e2 = "S";
        break;
      case "F":
        e2 = "f";
        break;
      case "FD":
      case "DF":
        e2 = "B";
        break;
      case "f":
      case "f*":
      case "B":
      case "B*":
        e2 = t2;
    }
    return e2;
  }, er = y2.close = function() {
    return lt2("h"), this;
  };
  y2.stroke = function() {
    return lt2("S"), this;
  }, y2.fill = function(t2) {
    return rr("f", t2), this;
  }, y2.fillEvenOdd = function(t2) {
    return rr("f*", t2), this;
  }, y2.fillStroke = function(t2) {
    return rr("B", t2), this;
  }, y2.fillStrokeEvenOdd = function(t2) {
    return rr("B*", t2), this;
  };
  var rr = function(e2, r2) {
    "object" === _typeof(r2) ? ar(r2, e2) : lt2(e2);
  }, nr = function(t2) {
    null === t2 || S2 === x2.ADVANCED && void 0 === t2 || (t2 = tr(t2), lt2(t2));
  };
  function ir(t2, e2, r2, n2, i3) {
    var a2 = new M(e2 || this.boundingBox, r2 || this.xStep, n2 || this.yStep, this.gState, i3 || this.matrix);
    a2.stream = this.stream;
    var o3 = t2 + "$$" + this.cloneIndex++ + "$$";
    return Jt2(o3, a2), a2;
  }
  var ar = function(t2, e2) {
    var r2 = Bt2[t2.key], n2 = Ot2[r2];
    if (n2 instanceof B)
      lt2("q"), lt2(or(e2)), n2.gState && y2.setGState(n2.gState), lt2(t2.matrix.toString() + " cm"), lt2("/" + r2 + " sh"), lt2("Q");
    else if (n2 instanceof M) {
      var i3 = new Vt2(1, 0, 0, -1, 0, Rr());
      t2.matrix && (i3 = i3.multiply(t2.matrix || Yt2), r2 = ir.call(n2, t2.key, t2.boundingBox, t2.xStep, t2.yStep, i3).id), lt2("q"), lt2("/Pattern cs"), lt2("/" + r2 + " scn"), n2.gState && y2.setGState(n2.gState), lt2(e2), lt2("Q");
    }
  }, or = function(t2) {
    switch (t2) {
      case "f":
      case "F":
        return "W n";
      case "f*":
        return "W* n";
      case "B":
        return "W S";
      case "B*":
        return "W* S";
      case "S":
        return "W S";
      case "n":
        return "W n";
    }
  }, sr = y2.moveTo = function(t2, e2) {
    return lt2(O2(U2(t2)) + " " + O2(H2(e2)) + " m"), this;
  }, cr = y2.lineTo = function(t2, e2) {
    return lt2(O2(U2(t2)) + " " + O2(H2(e2)) + " l"), this;
  }, ur = y2.curveTo = function(t2, e2, r2, n2, i3, a2) {
    return lt2([O2(U2(t2)), O2(H2(e2)), O2(U2(r2)), O2(H2(n2)), O2(U2(i3)), O2(H2(a2)), "c"].join(" ")), this;
  };
  y2.__private__.line = y2.line = function(t2, e2, r2, n2, i3) {
    if (isNaN(t2) || isNaN(e2) || isNaN(r2) || isNaN(n2) || !Qe(i3))
      throw new Error("Invalid arguments passed to jsPDF.line");
    return S2 === x2.COMPAT ? this.lines([[r2 - t2, n2 - e2]], t2, e2, [1, 1], i3 || "S") : this.lines([[r2 - t2, n2 - e2]], t2, e2, [1, 1]).stroke();
  }, y2.__private__.lines = y2.lines = function(t2, e2, r2, n2, i3, a2) {
    var o3, s3, c3, u3, h2, l2, f2, d3, p3, g3, m3, v3;
    if ("number" == typeof t2 && (v3 = r2, r2 = e2, e2 = t2, t2 = v3), n2 = n2 || [1, 1], a2 = a2 || false, isNaN(e2) || isNaN(r2) || !Array.isArray(t2) || !Array.isArray(n2) || !Qe(i3) || "boolean" != typeof a2)
      throw new Error("Invalid arguments passed to jsPDF.lines");
    for (sr(e2, r2), o3 = n2[0], s3 = n2[1], u3 = t2.length, g3 = e2, m3 = r2, c3 = 0; c3 < u3; c3++)
      2 === (h2 = t2[c3]).length ? (g3 = h2[0] * o3 + g3, m3 = h2[1] * s3 + m3, cr(g3, m3)) : (l2 = h2[0] * o3 + g3, f2 = h2[1] * s3 + m3, d3 = h2[2] * o3 + g3, p3 = h2[3] * s3 + m3, g3 = h2[4] * o3 + g3, m3 = h2[5] * s3 + m3, ur(l2, f2, d3, p3, g3, m3));
    return a2 && er(), nr(i3), this;
  }, y2.path = function(t2) {
    for (var e2 = 0; e2 < t2.length; e2++) {
      var r2 = t2[e2], n2 = r2.c;
      switch (r2.op) {
        case "m":
          sr(n2[0], n2[1]);
          break;
        case "l":
          cr(n2[0], n2[1]);
          break;
        case "c":
          ur.apply(this, n2);
          break;
        case "h":
          er();
      }
    }
    return this;
  }, y2.__private__.rect = y2.rect = function(t2, e2, r2, n2, i3) {
    if (isNaN(t2) || isNaN(e2) || isNaN(r2) || isNaN(n2) || !Qe(i3))
      throw new Error("Invalid arguments passed to jsPDF.rect");
    return S2 === x2.COMPAT && (n2 = -n2), lt2([O2(U2(t2)), O2(H2(e2)), O2(U2(r2)), O2(U2(n2)), "re"].join(" ")), nr(i3), this;
  }, y2.__private__.triangle = y2.triangle = function(t2, e2, r2, n2, i3, a2, o3) {
    if (isNaN(t2) || isNaN(e2) || isNaN(r2) || isNaN(n2) || isNaN(i3) || isNaN(a2) || !Qe(o3))
      throw new Error("Invalid arguments passed to jsPDF.triangle");
    return this.lines([[r2 - t2, n2 - e2], [i3 - r2, a2 - n2], [t2 - i3, e2 - a2]], t2, e2, [1, 1], o3, true), this;
  }, y2.__private__.roundedRect = y2.roundedRect = function(t2, e2, r2, n2, i3, a2, o3) {
    if (isNaN(t2) || isNaN(e2) || isNaN(r2) || isNaN(n2) || isNaN(i3) || isNaN(a2) || !Qe(o3))
      throw new Error("Invalid arguments passed to jsPDF.roundedRect");
    var s3 = 4 / 3 * (Math.SQRT2 - 1);
    return i3 = Math.min(i3, 0.5 * r2), a2 = Math.min(a2, 0.5 * n2), this.lines([[r2 - 2 * i3, 0], [i3 * s3, 0, i3, a2 - a2 * s3, i3, a2], [0, n2 - 2 * a2], [0, a2 * s3, -i3 * s3, a2, -i3, a2], [2 * i3 - r2, 0], [-i3 * s3, 0, -i3, -a2 * s3, -i3, -a2], [0, 2 * a2 - n2], [0, -a2 * s3, i3 * s3, -a2, i3, -a2]], t2 + i3, e2, [1, 1], o3, true), this;
  }, y2.__private__.ellipse = y2.ellipse = function(t2, e2, r2, n2, i3) {
    if (isNaN(t2) || isNaN(e2) || isNaN(r2) || isNaN(n2) || !Qe(i3))
      throw new Error("Invalid arguments passed to jsPDF.ellipse");
    var a2 = 4 / 3 * (Math.SQRT2 - 1) * r2, o3 = 4 / 3 * (Math.SQRT2 - 1) * n2;
    return sr(t2 + r2, e2), ur(t2 + r2, e2 - o3, t2 + a2, e2 - n2, t2, e2 - n2), ur(t2 - a2, e2 - n2, t2 - r2, e2 - o3, t2 - r2, e2), ur(t2 - r2, e2 + o3, t2 - a2, e2 + n2, t2, e2 + n2), ur(t2 + a2, e2 + n2, t2 + r2, e2 + o3, t2 + r2, e2), nr(i3), this;
  }, y2.__private__.circle = y2.circle = function(t2, e2, r2, n2) {
    if (isNaN(t2) || isNaN(e2) || isNaN(r2) || !Qe(n2))
      throw new Error("Invalid arguments passed to jsPDF.circle");
    return this.ellipse(t2, e2, r2, r2, n2);
  }, y2.setFont = function(t2, e2, r2) {
    return r2 && (e2 = k2(e2, r2)), St2 = qe(t2, e2, { disableWarning: false }), this;
  };
  var hr = y2.__private__.getFont = y2.getFont = function() {
    return Ft2[qe.apply(y2, arguments)];
  };
  y2.__private__.getFontList = y2.getFontList = function() {
    var t2, e2, r2 = {};
    for (t2 in Ct2)
      if (Ct2.hasOwnProperty(t2))
        for (e2 in r2[t2] = [], Ct2[t2])
          Ct2[t2].hasOwnProperty(e2) && r2[t2].push(e2);
    return r2;
  }, y2.addFont = function(t2, e2, r2, n2, i3) {
    var a2 = ["StandardEncoding", "MacRomanEncoding", "Identity-H", "WinAnsiEncoding"];
    return arguments[3] && -1 !== a2.indexOf(arguments[3]) ? i3 = arguments[3] : arguments[3] && -1 == a2.indexOf(arguments[3]) && (r2 = k2(r2, n2)), i3 = i3 || "Identity-H", Pe.call(this, t2, e2, r2, i3);
  };
  var lr, fr = e.lineWidth || 0.200025, dr = y2.__private__.getLineWidth = y2.getLineWidth = function() {
    return fr;
  }, pr = y2.__private__.setLineWidth = y2.setLineWidth = function(t2) {
    return fr = t2, lt2(O2(U2(t2)) + " w"), this;
  };
  y2.__private__.setLineDash = E.API.setLineDash = E.API.setLineDashPattern = function(t2, e2) {
    if (t2 = t2 || [], e2 = e2 || 0, isNaN(e2) || !Array.isArray(t2))
      throw new Error("Invalid arguments passed to jsPDF.setLineDash");
    return t2 = t2.map(function(t3) {
      return O2(U2(t3));
    }).join(" "), e2 = O2(U2(e2)), lt2("[" + t2 + "] " + e2 + " d"), this;
  };
  var gr = y2.__private__.getLineHeight = y2.getLineHeight = function() {
    return gt2 * lr;
  };
  y2.__private__.getLineHeight = y2.getLineHeight = function() {
    return gt2 * lr;
  };
  var mr = y2.__private__.setLineHeightFactor = y2.setLineHeightFactor = function(t2) {
    return "number" == typeof (t2 = t2 || 1.15) && (lr = t2), this;
  }, vr = y2.__private__.getLineHeightFactor = y2.getLineHeightFactor = function() {
    return lr;
  };
  mr(e.lineHeight);
  var br = y2.__private__.getHorizontalCoordinate = function(t2) {
    return U2(t2);
  }, yr = y2.__private__.getVerticalCoordinate = function(t2) {
    return S2 === x2.ADVANCED ? t2 : Rt2[$3].mediaBox.topRightY - Rt2[$3].mediaBox.bottomLeftY - U2(t2);
  }, wr = y2.__private__.getHorizontalCoordinateString = y2.getHorizontalCoordinateString = function(t2) {
    return O2(br(t2));
  }, Nr = y2.__private__.getVerticalCoordinateString = y2.getVerticalCoordinateString = function(t2) {
    return O2(yr(t2));
  }, Lr = e.strokeColor || "0 G";
  y2.__private__.getStrokeColor = y2.getDrawColor = function() {
    return ee2(Lr);
  }, y2.__private__.setStrokeColor = y2.setDrawColor = function(t2, e2, r2, n2) {
    return Lr = re2({ ch1: t2, ch2: e2, ch3: r2, ch4: n2, pdfColorType: "draw", precision: 2 }), lt2(Lr), this;
  };
  var Ar = e.fillColor || "0 g";
  y2.__private__.getFillColor = y2.getFillColor = function() {
    return ee2(Ar);
  }, y2.__private__.setFillColor = y2.setFillColor = function(t2, e2, r2, n2) {
    return Ar = re2({ ch1: t2, ch2: e2, ch3: r2, ch4: n2, pdfColorType: "fill", precision: 2 }), lt2(Ar), this;
  };
  var xr = e.textColor || "0 g", Sr = y2.__private__.getTextColor = y2.getTextColor = function() {
    return ee2(xr);
  };
  y2.__private__.setTextColor = y2.setTextColor = function(t2, e2, r2, n2) {
    return xr = re2({ ch1: t2, ch2: e2, ch3: r2, ch4: n2, pdfColorType: "text", precision: 3 }), this;
  };
  var _r = e.charSpace, Pr = y2.__private__.getCharSpace = y2.getCharSpace = function() {
    return parseFloat(_r || 0);
  };
  y2.__private__.setCharSpace = y2.setCharSpace = function(t2) {
    if (isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.setCharSpace");
    return _r = t2, this;
  };
  var kr = 0;
  y2.CapJoinStyles = { 0: 0, butt: 0, but: 0, miter: 0, 1: 1, round: 1, rounded: 1, circle: 1, 2: 2, projecting: 2, project: 2, square: 2, bevel: 2 }, y2.__private__.setLineCap = y2.setLineCap = function(t2) {
    var e2 = y2.CapJoinStyles[t2];
    if (void 0 === e2)
      throw new Error("Line cap style of '" + t2 + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
    return kr = e2, lt2(e2 + " J"), this;
  };
  var Ir = 0;
  y2.__private__.setLineJoin = y2.setLineJoin = function(t2) {
    var e2 = y2.CapJoinStyles[t2];
    if (void 0 === e2)
      throw new Error("Line join style of '" + t2 + "' is not recognized. See or extend .CapJoinStyles property for valid styles");
    return Ir = e2, lt2(e2 + " j"), this;
  }, y2.__private__.setLineMiterLimit = y2.__private__.setMiterLimit = y2.setLineMiterLimit = y2.setMiterLimit = function(t2) {
    if (t2 = t2 || 0, isNaN(t2))
      throw new Error("Invalid argument passed to jsPDF.setLineMiterLimit");
    return lt2(O2(U2(t2)) + " M"), this;
  }, y2.GState = j, y2.setGState = function(t2) {
    (t2 = "string" == typeof t2 ? Mt2[Et2[t2]] : Fr(null, t2)).equals(qt2) || (lt2("/" + t2.id + " gs"), qt2 = t2);
  };
  var Fr = function(t2, e2) {
    if (!t2 || !Et2[t2]) {
      var r2 = false;
      for (var n2 in Mt2)
        if (Mt2.hasOwnProperty(n2) && Mt2[n2].equals(e2)) {
          r2 = true;
          break;
        }
      if (r2)
        e2 = Mt2[n2];
      else {
        var i3 = "GS" + (Object.keys(Mt2).length + 1).toString(10);
        Mt2[i3] = e2, e2.id = i3;
      }
      return t2 && (Et2[t2] = e2.id), Tt2.publish("addGState", e2), e2;
    }
  };
  y2.addGState = function(t2, e2) {
    return Fr(t2, e2), this;
  }, y2.saveGraphicsState = function() {
    return lt2("q"), jt2.push({ key: St2, size: gt2, color: xr }), this;
  }, y2.restoreGraphicsState = function() {
    lt2("Q");
    var t2 = jt2.pop();
    return St2 = t2.key, gt2 = t2.size, xr = t2.color, qt2 = null, this;
  }, y2.setCurrentTransformationMatrix = function(t2) {
    return lt2(t2.toString() + " cm"), this;
  }, y2.comment = function(t2) {
    return lt2("#" + t2), this;
  };
  var Cr = function(t2, e2) {
    var r2 = t2 || 0;
    Object.defineProperty(this, "x", { enumerable: true, get: function() {
      return r2;
    }, set: function(t3) {
      isNaN(t3) || (r2 = parseFloat(t3));
    } });
    var n2 = e2 || 0;
    Object.defineProperty(this, "y", { enumerable: true, get: function() {
      return n2;
    }, set: function(t3) {
      isNaN(t3) || (n2 = parseFloat(t3));
    } });
    var i3 = "pt";
    return Object.defineProperty(this, "type", { enumerable: true, get: function() {
      return i3;
    }, set: function(t3) {
      i3 = t3.toString();
    } }), this;
  }, jr = function(t2, e2, r2, n2) {
    Cr.call(this, t2, e2), this.type = "rect";
    var i3 = r2 || 0;
    Object.defineProperty(this, "w", { enumerable: true, get: function() {
      return i3;
    }, set: function(t3) {
      isNaN(t3) || (i3 = parseFloat(t3));
    } });
    var a2 = n2 || 0;
    return Object.defineProperty(this, "h", { enumerable: true, get: function() {
      return a2;
    }, set: function(t3) {
      isNaN(t3) || (a2 = parseFloat(t3));
    } }), this;
  }, Or = function() {
    this.page = Dt2, this.currentPage = $3, this.pages = ot2.slice(0), this.pagesContext = Rt2.slice(0), this.x = Pt2, this.y = kt2, this.matrix = It2, this.width = qr($3), this.height = Rr($3), this.outputDestination = ct2, this.id = "", this.objectNumber = -1;
  };
  Or.prototype.restore = function() {
    Dt2 = this.page, $3 = this.currentPage, Rt2 = this.pagesContext, ot2 = this.pages, Pt2 = this.x, kt2 = this.y, It2 = this.matrix, Dr($3, this.width), Tr($3, this.height), ct2 = this.outputDestination;
  };
  var Br = function(t2, e2, r2, n2, i3) {
    Wt2.push(new Or()), Dt2 = $3 = 0, ot2 = [], Pt2 = t2, kt2 = e2, It2 = i3, je([r2, n2]);
  }, Mr = function(t2) {
    if (Ht2[t2])
      Wt2.pop().restore();
    else {
      var e2 = new Or(), r2 = "Xo" + (Object.keys(zt2).length + 1).toString(10);
      e2.id = r2, Ht2[t2] = r2, zt2[r2] = e2, Tt2.publish("addFormObject", e2), Wt2.pop().restore();
    }
  };
  for (var Er in y2.beginFormObject = function(t2, e2, r2, n2, i3) {
    return Br(t2, e2, r2, n2, i3), this;
  }, y2.endFormObject = function(t2) {
    return Mr(t2), this;
  }, y2.doFormObject = function(t2, e2) {
    var r2 = zt2[Ht2[t2]];
    return lt2("q"), lt2(e2.toString() + " cm"), lt2("/" + r2.id + " Do"), lt2("Q"), this;
  }, y2.getFormObject = function(t2) {
    var e2 = zt2[Ht2[t2]];
    return { x: e2.x, y: e2.y, width: e2.width, height: e2.height, matrix: e2.matrix };
  }, y2.save = function(t2, e2) {
    return t2 = t2 || "generated.pdf", (e2 = e2 || {}).returnPromise = e2.returnPromise || false, false === e2.returnPromise ? (l(We(He()), t2), "function" == typeof l.unload && n.setTimeout && setTimeout(l.unload, 911), this) : new Promise(function(e3, r2) {
      try {
        var i3 = l(We(He()), t2);
        "function" == typeof l.unload && n.setTimeout && setTimeout(l.unload, 911), e3(i3);
      } catch (t3) {
        r2(t3.message);
      }
    });
  }, E.API)
    E.API.hasOwnProperty(Er) && ("events" === Er && E.API.events.length ? function(t2, e2) {
      var r2, n2, i3;
      for (i3 = e2.length - 1; -1 !== i3; i3--)
        r2 = e2[i3][0], n2 = e2[i3][1], t2.subscribe.apply(t2, [r2].concat("function" == typeof n2 ? [n2] : n2));
    }(Tt2, E.API.events) : y2[Er] = E.API[Er]);
  var qr = y2.getPageWidth = function(t2) {
    return (Rt2[t2 = t2 || $3].mediaBox.topRightX - Rt2[t2].mediaBox.bottomLeftX) / _t2;
  }, Dr = y2.setPageWidth = function(t2, e2) {
    Rt2[t2].mediaBox.topRightX = e2 * _t2 + Rt2[t2].mediaBox.bottomLeftX;
  }, Rr = y2.getPageHeight = function(t2) {
    return (Rt2[t2 = t2 || $3].mediaBox.topRightY - Rt2[t2].mediaBox.bottomLeftY) / _t2;
  }, Tr = y2.setPageHeight = function(t2, e2) {
    Rt2[t2].mediaBox.topRightY = e2 * _t2 + Rt2[t2].mediaBox.bottomLeftY;
  };
  return y2.internal = { pdfEscape: Ce, getStyle: tr, getFont: hr, getFontSize: vt2, getCharSpace: Pr, getTextColor: Sr, getLineHeight: gr, getLineHeightFactor: vr, getLineWidth: dr, write: ft2, getHorizontalCoordinate: br, getVerticalCoordinate: yr, getCoordinateString: wr, getVerticalCoordinateString: Nr, collections: {}, newObject: Xt2, newAdditionalObject: $t2, newObjectDeferred: Kt2, newObjectDeferredBegin: Zt2, getFilters: ne2, putStream: ie2, events: Tt2, scaleFactor: _t2, pageSize: { getWidth: function() {
    return qr($3);
  }, setWidth: function(t2) {
    Dr($3, t2);
  }, getHeight: function() {
    return Rr($3);
  }, setHeight: function(t2) {
    Tr($3, t2);
  } }, encryptionOptions: m2, encryption: Ye, getEncryptor: Je, output: Ve, getNumberOfPages: Ee, pages: ot2, out: lt2, f2: R2, f3: T2, getPageInfo: Xe, getPageInfoByObjId: Ke, getCurrentPageInfo: Ze, getPDFVersion: N2, Point: Cr, Rectangle: jr, Matrix: Vt2, hasHotfix: Ge }, Object.defineProperty(y2.internal.pageSize, "width", { get: function() {
    return qr($3);
  }, set: function(t2) {
    Dr($3, t2);
  }, enumerable: true, configurable: true }), Object.defineProperty(y2.internal.pageSize, "height", { get: function() {
    return Rr($3);
  }, set: function(t2) {
    Tr($3, t2);
  }, enumerable: true, configurable: true }), ke.call(y2, pt2), St2 = "F1", Oe(s2, i2), Tt2.publish("initialized"), y2;
}
I.prototype.lsbFirstWord = function(t2) {
  return String.fromCharCode(t2 >> 0 & 255, t2 >> 8 & 255, t2 >> 16 & 255, t2 >> 24 & 255);
}, I.prototype.toHexString = function(t2) {
  return t2.split("").map(function(t3) {
    return ("0" + (255 & t3.charCodeAt(0)).toString(16)).slice(-2);
  }).join("");
}, I.prototype.hexToBytes = function(t2) {
  for (var e = [], r = 0; r < t2.length; r += 2)
    e.push(String.fromCharCode(parseInt(t2.substr(r, 2), 16)));
  return e.join("");
}, I.prototype.processOwnerPassword = function(t2, e) {
  return P(x(e).substr(0, 5), t2);
}, I.prototype.encryptor = function(t2, e) {
  var r = x(this.encryptionKey + String.fromCharCode(255 & t2, t2 >> 8 & 255, t2 >> 16 & 255, 255 & e, e >> 8 & 255)).substr(0, 10);
  return function(t3) {
    return P(r, t3);
  };
}, j.prototype.equals = function(e) {
  var r, n2 = "id,objectNumber,equals";
  if (!e || _typeof(e) !== _typeof(this))
    return false;
  var i2 = 0;
  for (r in this)
    if (!(n2.indexOf(r) >= 0)) {
      if (this.hasOwnProperty(r) && !e.hasOwnProperty(r))
        return false;
      if (this[r] !== e[r])
        return false;
      i2++;
    }
  for (r in e)
    e.hasOwnProperty(r) && n2.indexOf(r) < 0 && i2--;
  return 0 === i2;
}, E.API = { events: [] }, E.version = "2.5.2";
var q = E.API;
var D = 1;
var R = function(t2) {
  return t2.replace(/\\/g, "\\\\").replace(/\(/g, "\\(").replace(/\)/g, "\\)");
};
var T = function(t2) {
  return t2.replace(/\\\\/g, "\\").replace(/\\\(/g, "(").replace(/\\\)/g, ")");
};
var U = function(t2) {
  return t2.toFixed(2);
};
var z = function(t2) {
  return t2.toFixed(5);
};
q.__acroform__ = {};
var H = function(t2, e) {
  t2.prototype = Object.create(e.prototype), t2.prototype.constructor = t2;
};
var W = function(t2) {
  return t2 * D;
};
var V = function(t2) {
  var e = new ut(), r = At.internal.getHeight(t2) || 0, n2 = At.internal.getWidth(t2) || 0;
  return e.BBox = [0, 0, Number(U(n2)), Number(U(r))], e;
};
var G = q.__acroform__.setBit = function(t2, e) {
  if (t2 = t2 || 0, e = e || 0, isNaN(t2) || isNaN(e))
    throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.setBit");
  return t2 |= 1 << e;
};
var Y = q.__acroform__.clearBit = function(t2, e) {
  if (t2 = t2 || 0, e = e || 0, isNaN(t2) || isNaN(e))
    throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.clearBit");
  return t2 &= ~(1 << e);
};
var J = q.__acroform__.getBit = function(t2, e) {
  if (isNaN(t2) || isNaN(e))
    throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.getBit");
  return 0 == (t2 & 1 << e) ? 0 : 1;
};
var X = q.__acroform__.getBitForPdf = function(t2, e) {
  if (isNaN(t2) || isNaN(e))
    throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.getBitForPdf");
  return J(t2, e - 1);
};
var K = q.__acroform__.setBitForPdf = function(t2, e) {
  if (isNaN(t2) || isNaN(e))
    throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.setBitForPdf");
  return G(t2, e - 1);
};
var Z = q.__acroform__.clearBitForPdf = function(t2, e) {
  if (isNaN(t2) || isNaN(e))
    throw new Error("Invalid arguments passed to jsPDF.API.__acroform__.clearBitForPdf");
  return Y(t2, e - 1);
};
var $2 = q.__acroform__.calculateCoordinates = function(t2, e) {
  var r = e.internal.getHorizontalCoordinate, n2 = e.internal.getVerticalCoordinate, i2 = t2[0], a2 = t2[1], o2 = t2[2], s2 = t2[3], c2 = {};
  return c2.lowerLeft_X = r(i2) || 0, c2.lowerLeft_Y = n2(a2 + s2) || 0, c2.upperRight_X = r(i2 + o2) || 0, c2.upperRight_Y = n2(a2) || 0, [Number(U(c2.lowerLeft_X)), Number(U(c2.lowerLeft_Y)), Number(U(c2.upperRight_X)), Number(U(c2.upperRight_Y))];
};
var Q = function(t2) {
  if (t2.appearanceStreamContent)
    return t2.appearanceStreamContent;
  if (t2.V || t2.DV) {
    var e = [], r = t2._V || t2.DV, n2 = tt(t2, r), i2 = t2.scope.internal.getFont(t2.fontName, t2.fontStyle).id;
    e.push("/Tx BMC"), e.push("q"), e.push("BT"), e.push(t2.scope.__private__.encodeColorString(t2.color)), e.push("/" + i2 + " " + U(n2.fontSize) + " Tf"), e.push("1 0 0 1 0 0 Tm"), e.push(n2.text), e.push("ET"), e.push("Q"), e.push("EMC");
    var a2 = V(t2);
    return a2.scope = t2.scope, a2.stream = e.join("\n"), a2;
  }
};
var tt = function(t2, e) {
  var r = 0 === t2.fontSize ? t2.maxFontSize : t2.fontSize, n2 = { text: "", fontSize: "" }, i2 = (e = ")" == (e = "(" == e.substr(0, 1) ? e.substr(1) : e).substr(e.length - 1) ? e.substr(0, e.length - 1) : e).split(" ");
  i2 = t2.multiline ? i2.map(function(t3) {
    return t3.split("\n");
  }) : i2.map(function(t3) {
    return [t3];
  });
  var a2 = r, o2 = At.internal.getHeight(t2) || 0;
  o2 = o2 < 0 ? -o2 : o2;
  var s2 = At.internal.getWidth(t2) || 0;
  s2 = s2 < 0 ? -s2 : s2;
  var c2 = function(e2, r2, n3) {
    if (e2 + 1 < i2.length) {
      var a3 = r2 + " " + i2[e2 + 1][0];
      return et2(a3, t2, n3).width <= s2 - 4;
    }
    return false;
  };
  a2++;
  t:
    for (; a2 > 0; ) {
      e = "", a2--;
      var u2, h2, l2 = et2("3", t2, a2).height, f2 = t2.multiline ? o2 - a2 : (o2 - l2) / 2, d2 = f2 += 2, p2 = 0, g2 = 0, m2 = 0;
      if (a2 <= 0) {
        e = "(...) Tj\n", e += "% Width of Text: " + et2(e, t2, a2 = 12).width + ", FieldWidth:" + s2 + "\n";
        break;
      }
      for (var v2 = "", b2 = 0, y2 = 0; y2 < i2.length; y2++)
        if (i2.hasOwnProperty(y2)) {
          var w2 = false;
          if (1 !== i2[y2].length && m2 !== i2[y2].length - 1) {
            if ((l2 + 2) * (b2 + 2) + 2 > o2)
              continue t;
            v2 += i2[y2][m2], w2 = true, g2 = y2, y2--;
          } else {
            v2 = " " == (v2 += i2[y2][m2] + " ").substr(v2.length - 1) ? v2.substr(0, v2.length - 1) : v2;
            var N2 = parseInt(y2), L2 = c2(N2, v2, a2), A2 = y2 >= i2.length - 1;
            if (L2 && !A2) {
              v2 += " ", m2 = 0;
              continue;
            }
            if (L2 || A2) {
              if (A2)
                g2 = N2;
              else if (t2.multiline && (l2 + 2) * (b2 + 2) + 2 > o2)
                continue t;
            } else {
              if (!t2.multiline)
                continue t;
              if ((l2 + 2) * (b2 + 2) + 2 > o2)
                continue t;
              g2 = N2;
            }
          }
          for (var x2 = "", S2 = p2; S2 <= g2; S2++) {
            var _2 = i2[S2];
            if (t2.multiline) {
              if (S2 === g2) {
                x2 += _2[m2] + " ", m2 = (m2 + 1) % _2.length;
                continue;
              }
              if (S2 === p2) {
                x2 += _2[_2.length - 1] + " ";
                continue;
              }
            }
            x2 += _2[0] + " ";
          }
          switch (x2 = " " == x2.substr(x2.length - 1) ? x2.substr(0, x2.length - 1) : x2, h2 = et2(x2, t2, a2).width, t2.textAlign) {
            case "right":
              u2 = s2 - h2 - 2;
              break;
            case "center":
              u2 = (s2 - h2) / 2;
              break;
            case "left":
            default:
              u2 = 2;
          }
          e += U(u2) + " " + U(d2) + " Td\n", e += "(" + R(x2) + ") Tj\n", e += -U(u2) + " 0 Td\n", d2 = -(a2 + 2), h2 = 0, p2 = w2 ? g2 : g2 + 1, b2++, v2 = "";
        } else
          ;
      break;
    }
  return n2.text = e, n2.fontSize = a2, n2;
};
var et2 = function(t2, e, r) {
  var n2 = e.scope.internal.getFont(e.fontName, e.fontStyle), i2 = e.scope.getStringUnitWidth(t2, { font: n2, fontSize: parseFloat(r), charSpace: 0 }) * parseFloat(r);
  return { height: e.scope.getStringUnitWidth("3", { font: n2, fontSize: parseFloat(r), charSpace: 0 }) * parseFloat(r) * 1.5, width: i2 };
};
var rt = { fields: [], xForms: [], acroFormDictionaryRoot: null, printedOut: false, internal: null, isInitialized: false };
var nt = function(t2, e) {
  var r = { type: "reference", object: t2 };
  void 0 === e.internal.getPageInfo(t2.page).pageContext.annotations.find(function(t3) {
    return t3.type === r.type && t3.object === r.object;
  }) && e.internal.getPageInfo(t2.page).pageContext.annotations.push(r);
};
var it = function(e, r) {
  for (var n2 in e)
    if (e.hasOwnProperty(n2)) {
      var i2 = n2, a2 = e[n2];
      r.internal.newObjectDeferredBegin(a2.objId, true), "object" === _typeof(a2) && "function" == typeof a2.putStream && a2.putStream(), delete e[i2];
    }
};
var at = function(e, r) {
  if (r.scope = e, void 0 !== e.internal && (void 0 === e.internal.acroformPlugin || false === e.internal.acroformPlugin.isInitialized)) {
    if (lt.FieldNum = 0, e.internal.acroformPlugin = JSON.parse(JSON.stringify(rt)), e.internal.acroformPlugin.acroFormDictionaryRoot)
      throw new Error("Exception while creating AcroformDictionary");
    D = e.internal.scaleFactor, e.internal.acroformPlugin.acroFormDictionaryRoot = new ht(), e.internal.acroformPlugin.acroFormDictionaryRoot.scope = e, e.internal.acroformPlugin.acroFormDictionaryRoot._eventID = e.internal.events.subscribe("postPutResources", function() {
      !function(t2) {
        t2.internal.events.unsubscribe(t2.internal.acroformPlugin.acroFormDictionaryRoot._eventID), delete t2.internal.acroformPlugin.acroFormDictionaryRoot._eventID, t2.internal.acroformPlugin.printedOut = true;
      }(e);
    }), e.internal.events.subscribe("buildDocument", function() {
      !function(t2) {
        t2.internal.acroformPlugin.acroFormDictionaryRoot.objId = void 0;
        var e2 = t2.internal.acroformPlugin.acroFormDictionaryRoot.Fields;
        for (var r2 in e2)
          if (e2.hasOwnProperty(r2)) {
            var n2 = e2[r2];
            n2.objId = void 0, n2.hasAnnotation && nt(n2, t2);
          }
      }(e);
    }), e.internal.events.subscribe("putCatalog", function() {
      !function(t2) {
        if (void 0 === t2.internal.acroformPlugin.acroFormDictionaryRoot)
          throw new Error("putCatalogCallback: Root missing.");
        t2.internal.write("/AcroForm " + t2.internal.acroformPlugin.acroFormDictionaryRoot.objId + " 0 R");
      }(e);
    }), e.internal.events.subscribe("postPutPages", function(r2) {
      !function(e2, r3) {
        var n2 = !e2;
        for (var i2 in e2 || (r3.internal.newObjectDeferredBegin(r3.internal.acroformPlugin.acroFormDictionaryRoot.objId, true), r3.internal.acroformPlugin.acroFormDictionaryRoot.putStream()), e2 = e2 || r3.internal.acroformPlugin.acroFormDictionaryRoot.Kids)
          if (e2.hasOwnProperty(i2)) {
            var a2 = e2[i2], o2 = [], s2 = a2.Rect;
            if (a2.Rect && (a2.Rect = $2(a2.Rect, r3)), r3.internal.newObjectDeferredBegin(a2.objId, true), a2.DA 