import "./chunk-N43HULMD.js";
import "./chunk-SKZXPA6D.js";
import "./chunk-GA4FZ3DX.js";
import "./chunk-5IIA45LM.js";
import "./chunk-MPJFGFS5.js";
import {
  ClientDatatableComponent
} from "./chunk-3RTU34A3.js";
import {
  require_FileSaver_min
} from "./chunk-TN2NHK56.js";
import {
  readSync,
  utils
} from "./chunk-YWQICJL7.js";
import "./chunk-BP5JJWGC.js";
import {
  MonacoEditorModule
} from "./chunk-62OL73TD.js";
import "./chunk-IGGXREIH.js";
import {
  ToastrService
} from "./chunk-2YLAF7RI.js";
import {
  CommonSharedModule,
  DynamicFontSizeDirective,
  Store
} from "./chunk-7NQGM4EA.js";
import {
  CheckboxControlValueAccessor,
  DefaultValueAccessor,
  FormBuilder,
  FormControlName,
  FormGroupDirective,
  NgControlStatus,
  NgControlStatusGroup,
  NgSelectOption,
  NumberValueAccessor,
  RadioControlValueAccessor,
  ReactiveFormsModule,
  SelectControlValueAccessor,
  TranslatePipe,
  TranslateService,
  Validators,
  ɵNgNoValidate,
  ɵNgSelectMultipleOption
} from "./chunk-NLYGDKUR.js";
import {
  animate,
  style,
  transition,
  trigger
} from "./chunk-ZEL7H2AL.js";
import {
  ActivatedRoute,
  GridApiService,
  LocalStorageService,
  Router,
  commonConfig,
  environment
} from "./chunk-P7K2QEDI.js";
import {
  HttpClient,
  Location,
  NgClass,
  NgForOf,
  NgIf,
  Title,
  ɵsetClassDebugInfo,
  ɵɵStandaloneFeature,
  ɵɵadvance,
  ɵɵclassProp,
  ɵɵdefineComponent,
  ɵɵdirectiveInject,
  ɵɵelement,
  ɵɵelementEnd,
  ɵɵelementStart,
  ɵɵgetCurrentView,
  ɵɵlistener,
  ɵɵloadQuery,
  ɵɵnamespaceHTML,
  ɵɵnamespaceSVG,
  ɵɵnextContext,
  ɵɵpipe,
  ɵɵpipeBind1,
  ɵɵproperty,
  ɵɵpropertyInterpolate,
  ɵɵpureFunction1,
  ɵɵqueryRefresh,
  ɵɵresetView,
  ɵɵrestoreView,
  ɵɵtemplate,
  ɵɵtext,
  ɵɵtextInterpolate,
  ɵɵtextInterpolate1,
  ɵɵviewQuery
} from "./chunk-GKZIWABI.js";
import {
  __async,
  __spreadProps,
  __spreadValues,
  __toESM
} from "./chunk-CVWHNZRK.js";

// src/app/@lcp-framework/pages/export-template/export-template.component.ts
var import_file_saver = __toESM(require_FileSaver_min());
var _c0 = ["monacoEditor"];
var _c1 = (a0) => ({ "is-invalid": a0 });
var _c2 = (a0) => ({ "border-red-500": a0 });
function ExportTemplateComponent_div_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("name"), " ");
  }
}
function ExportTemplateComponent_div_30_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("slug"), " ");
  }
}
function ExportTemplateComponent_div_37_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("description"), " ");
  }
}
function ExportTemplateComponent_div_53_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("status_id"), " ");
  }
}
function ExportTemplateComponent_div_60_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("max_row_count"), " ");
  }
}
function ExportTemplateComponent_div_67_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("header_row"), " ");
  }
}
function ExportTemplateComponent_div_74_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("data_start_row"), " ");
  }
}
function ExportTemplateComponent_div_81_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 42);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getErrorMessage("data_end_row"), " ");
  }
}
function ExportTemplateComponent_div_88_Template(rf, ctx) {
  if (rf & 1) {
    const _r2 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 43)(1, "label", 44)(2, "div", 45);
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(3, "svg", 46);
    \u0275\u0275element(4, "path", 47);
    \u0275\u0275elementEnd();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(5, "p", 48)(6, "span", 49);
    \u0275\u0275text(7, "Click to upload");
    \u0275\u0275elementEnd();
    \u0275\u0275text(8, " or drag and drop");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(9, "p", 50);
    \u0275\u0275text(10, "Excel files only (.xlsx, .xls, .csv)");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(11, "input", 51);
    \u0275\u0275listener("change", function ExportTemplateComponent_div_88_Template_input_change_11_listener($event) {
      \u0275\u0275restoreView(_r2);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.handleFileInput($event));
    });
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    let tmp_1_0;
    let tmp_2_0;
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance();
    \u0275\u0275classProp("opacity-50", !((tmp_1_0 = ctx_r0.form.get("header_row")) == null ? null : tmp_1_0.value));
    \u0275\u0275advance(10);
    \u0275\u0275property("disabled", !((tmp_2_0 = ctx_r0.form.get("header_row")) == null ? null : tmp_2_0.value));
  }
}
function ExportTemplateComponent_div_89_p_5_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 50);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1("", (ctx_r0.selectedFile.size / 1024).toFixed(2), " KB");
  }
}
function ExportTemplateComponent_div_89_p_6_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "p", 50);
    \u0275\u0275text(1, "Existing file");
    \u0275\u0275elementEnd();
  }
}
function ExportTemplateComponent_div_89_Template(rf, ctx) {
  if (rf & 1) {
    const _r3 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 52)(1, "div", 53)(2, "div", 54)(3, "p", 55);
    \u0275\u0275text(4);
    \u0275\u0275elementEnd();
    \u0275\u0275template(5, ExportTemplateComponent_div_89_p_5_Template, 2, 1, "p", 56)(6, ExportTemplateComponent_div_89_p_6_Template, 2, 0, "p", 56);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(7, "button", 57);
    \u0275\u0275listener("click", function ExportTemplateComponent_div_89_Template_button_click_7_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.removeFile());
    });
    \u0275\u0275namespaceSVG();
    \u0275\u0275elementStart(8, "svg", 58);
    \u0275\u0275element(9, "path", 59);
    \u0275\u0275elementEnd()();
    \u0275\u0275namespaceHTML();
    \u0275\u0275elementStart(10, "div", 60);
    \u0275\u0275listener("click", function ExportTemplateComponent_div_89_Template_div_click_10_listener() {
      \u0275\u0275restoreView(_r3);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.downloadExcel());
    });
    \u0275\u0275element(11, "i", 61);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", ctx_r0.selectedFile.name, " ");
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.selectedFile.size);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", !ctx_r0.selectedFile.size);
  }
}
function ExportTemplateComponent_div_90_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 62);
    \u0275\u0275element(1, "div", 63);
    \u0275\u0275elementEnd();
  }
}
function ExportTemplateComponent_div_91_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 64)(1, "p", 65);
    \u0275\u0275text(2);
    \u0275\u0275elementEnd()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(ctx_r0.fileError);
  }
}
function ExportTemplateComponent_div_96_div_23_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 104);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getLineItemErrorMessage("field_name"), " ");
  }
}
function ExportTemplateComponent_div_96_option_44_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 105);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const table_r5 = ctx.$implicit;
    \u0275\u0275property("value", table_r5);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(table_r5);
  }
}
function ExportTemplateComponent_div_96_option_53_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 105);
    \u0275\u0275text(1);
    \u0275\u0275pipe(2, "translate");
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const type_r6 = ctx.$implicit;
    \u0275\u0275property("value", type_r6.value);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(2, 2, type_r6.label));
  }
}
function ExportTemplateComponent_div_96_option_69_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "option", 105);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const header_r7 = ctx.$implicit;
    \u0275\u0275property("value", header_r7);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", header_r7, " ");
  }
}
function ExportTemplateComponent_div_96_div_70_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 104);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getLineItemErrorMessage("column_name"), " ");
  }
}
function ExportTemplateComponent_div_96_div_79_div_7_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 104);
    \u0275\u0275text(1);
    \u0275\u0275elementEnd();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(3);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.getLineItemErrorMessage("individual_column"), " ");
  }
}
function ExportTemplateComponent_div_96_div_79_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 79)(1, "div", 96)(2, "label", 97);
    \u0275\u0275text(3);
    \u0275\u0275pipe(4, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(5, "div", 81);
    \u0275\u0275element(6, "input", 106);
    \u0275\u0275template(7, ExportTemplateComponent_div_96_div_79_div_7_Template, 2, 1, "div", 83);
    \u0275\u0275elementEnd()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext(2);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(4, 2, "form_label_individual_column"));
    \u0275\u0275advance(4);
    \u0275\u0275property("ngIf", ctx_r0.isLineItemFieldInvalid("individual_column"));
  }
}
function ExportTemplateComponent_div_96_Template(rf, ctx) {
  if (rf & 1) {
    const _r4 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 66);
    \u0275\u0275element(1, "div", 67);
    \u0275\u0275elementStart(2, "div", 68)(3, "div", 69)(4, "div", 70)(5, "div", 71)(6, "h3", 72);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275pipe(9, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "button", 73);
    \u0275\u0275listener("click", function ExportTemplateComponent_div_96_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.cancelLineItemEdit());
    });
    \u0275\u0275elementStart(11, "span", 74);
    \u0275\u0275text(12, "Close");
    \u0275\u0275elementEnd();
    \u0275\u0275element(13, "i", 75);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "div", 76)(15, "form", 77);
    \u0275\u0275listener("ngSubmit", function ExportTemplateComponent_div_96_Template_form_ngSubmit_15_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.onLineItemSubmit());
    });
    \u0275\u0275elementStart(16, "div", 78)(17, "div", 79)(18, "label", 80);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(21, "div", 81);
    \u0275\u0275element(22, "input", 82);
    \u0275\u0275template(23, ExportTemplateComponent_div_96_div_23_Template, 2, 1, "div", 83);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(24, "div", 79)(25, "label", 84);
    \u0275\u0275text(26);
    \u0275\u0275pipe(27, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(28, "div", 81);
    \u0275\u0275element(29, "input", 85);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(30, "div", 79)(31, "label", 86);
    \u0275\u0275text(32);
    \u0275\u0275pipe(33, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(34, "div", 81);
    \u0275\u0275element(35, "input", 87);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(36, "div", 79)(37, "label", 88);
    \u0275\u0275text(38);
    \u0275\u0275pipe(39, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(40, "div", 81)(41, "select", 89)(42, "option", 90);
    \u0275\u0275text(43, "Select Table");
    \u0275\u0275elementEnd();
    \u0275\u0275template(44, ExportTemplateComponent_div_96_option_44_Template, 2, 2, "option", 91);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(45, "div", 79)(46, "label", 92);
    \u0275\u0275text(47);
    \u0275\u0275pipe(48, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(49, "div", 81)(50, "select", 93)(51, "option", 90);
    \u0275\u0275text(52, "Select Field Type");
    \u0275\u0275elementEnd();
    \u0275\u0275template(53, ExportTemplateComponent_div_96_option_53_Template, 3, 4, "option", 91);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(54, "div", 79)(55, "label", 94);
    \u0275\u0275text(56);
    \u0275\u0275pipe(57, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(58, "div", 81);
    \u0275\u0275element(59, "input", 95);
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(60, "div", 79)(61, "div", 96)(62, "label", 97);
    \u0275\u0275text(63);
    \u0275\u0275pipe(64, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(65, "div", 81)(66, "select", 98)(67, "option", 90);
    \u0275\u0275text(68, "Select Excel Column");
    \u0275\u0275elementEnd();
    \u0275\u0275template(69, ExportTemplateComponent_div_96_option_69_Template, 2, 2, "option", 91);
    \u0275\u0275elementEnd();
    \u0275\u0275template(70, ExportTemplateComponent_div_96_div_70_Template, 2, 1, "div", 83);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(71, "div", 79)(72, "div", 96)(73, "label", 97);
    \u0275\u0275text(74);
    \u0275\u0275pipe(75, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(76, "div", 81)(77, "div", 53);
    \u0275\u0275element(78, "input", 99);
    \u0275\u0275elementEnd()()()();
    \u0275\u0275template(79, ExportTemplateComponent_div_96_div_79_Template, 8, 4, "div", 100);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(80, "div", 101)(81, "button", 102);
    \u0275\u0275listener("click", function ExportTemplateComponent_div_96_Template_button_click_81_listener() {
      \u0275\u0275restoreView(_r4);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.cancelLineItemEdit());
    });
    \u0275\u0275text(82);
    \u0275\u0275pipe(83, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(84, "button", 103);
    \u0275\u0275text(85);
    \u0275\u0275pipe(86, "translate");
    \u0275\u0275pipe(87, "translate");
    \u0275\u0275elementEnd()()()()()()();
  }
  if (rf & 2) {
    let tmp_17_0;
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", ctx_r0.editingItemIndex !== -1 ? \u0275\u0275pipeBind1(8, 20, "title_edit_export_template_line_item") : \u0275\u0275pipeBind1(9, 22, "title_add_export_template_line_item"), " ");
    \u0275\u0275advance(8);
    \u0275\u0275property("formGroup", ctx_r0.lineItemForm);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(20, 24, "form_label_field_name"), " ");
    \u0275\u0275advance(3);
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(46, _c2, ctx_r0.isLineItemFieldInvalid("field_name")));
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.isLineItemFieldInvalid("field_name"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(27, 26, "form_label_display_name"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(33, 28, "form_label_order_no"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(39, 30, "form_label_field_table"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275property("ngForOf", ctx_r0.tables_list);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(48, 32, "form_label_field_type"), " ");
    \u0275\u0275advance(6);
    \u0275\u0275property("ngForOf", ctx_r0.field_types);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(57, 34, "form_label_default_value"), " ");
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(64, 36, "form_label_column_name"));
    \u0275\u0275advance(6);
    \u0275\u0275property("ngForOf", ctx_r0.excelHeaders);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx_r0.isLineItemFieldInvalid("column_name"));
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(75, 38, "form_label_is_individual"));
    \u0275\u0275advance(5);
    \u0275\u0275property("ngIf", (tmp_17_0 = ctx_r0.lineItemForm.get("is_individual")) == null ? null : tmp_17_0.value);
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(83, 40, "cancel"), " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx_r0.lineItemForm.invalid);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.editingItemIndex !== -1 ? \u0275\u0275pipeBind1(86, 42, "update") : \u0275\u0275pipeBind1(87, 44, "add"), " ");
  }
}
function ExportTemplateComponent_div_97_Template(rf, ctx) {
  if (rf & 1) {
    const _r8 = \u0275\u0275getCurrentView();
    \u0275\u0275elementStart(0, "div", 66);
    \u0275\u0275element(1, "div", 67);
    \u0275\u0275elementStart(2, "div", 68)(3, "div", 69)(4, "div", 70)(5, "div", 71)(6, "h3", 72);
    \u0275\u0275text(7);
    \u0275\u0275pipe(8, "translate");
    \u0275\u0275pipe(9, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "button", 73);
    \u0275\u0275listener("click", function ExportTemplateComponent_div_97_Template_button_click_10_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.cancelLineQueryEdit());
    });
    \u0275\u0275elementStart(11, "span", 74);
    \u0275\u0275text(12, "Close");
    \u0275\u0275elementEnd();
    \u0275\u0275element(13, "i", 75);
    \u0275\u0275elementEnd()()();
    \u0275\u0275elementStart(14, "div", 107)(15, "form", 108);
    \u0275\u0275listener("ngSubmit", function ExportTemplateComponent_div_97_Template_form_ngSubmit_15_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.onLineQuerySubmit());
    });
    \u0275\u0275elementStart(16, "div", 109)(17, "div", 110)(18, "label", 111);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(21, "input", 112);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(22, "div", 110)(23, "label", 86);
    \u0275\u0275text(24);
    \u0275\u0275pipe(25, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(26, "input", 87);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(27, "div", 110)(28, "label", 113);
    \u0275\u0275text(29);
    \u0275\u0275pipe(30, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(31, "select", 114)(32, "option", 115);
    \u0275\u0275text(33, "Select Any");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(34, "option", 116);
    \u0275\u0275text(35);
    \u0275\u0275pipe(36, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(37, "option", 117);
    \u0275\u0275text(38);
    \u0275\u0275pipe(39, "translate");
    \u0275\u0275elementEnd()()()();
    \u0275\u0275elementStart(40, "div", 110)(41, "label", 118);
    \u0275\u0275text(42);
    \u0275\u0275pipe(43, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(44, "textarea", 119);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(45, "div", 101)(46, "button", 102);
    \u0275\u0275listener("click", function ExportTemplateComponent_div_97_Template_button_click_46_listener() {
      \u0275\u0275restoreView(_r8);
      const ctx_r0 = \u0275\u0275nextContext();
      return \u0275\u0275resetView(ctx_r0.cancelLineQueryEdit());
    });
    \u0275\u0275text(47);
    \u0275\u0275pipe(48, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(49, "button", 103);
    \u0275\u0275text(50);
    \u0275\u0275pipe(51, "translate");
    \u0275\u0275pipe(52, "translate");
    \u0275\u0275elementEnd()()()()()()();
  }
  if (rf & 2) {
    const ctx_r0 = \u0275\u0275nextContext();
    \u0275\u0275advance(7);
    \u0275\u0275textInterpolate1(" ", ctx_r0.editingQueryIndex !== -1 ? \u0275\u0275pipeBind1(8, 11, "title_edit_export_template_line_query") : \u0275\u0275pipeBind1(9, 13, "title_add_export_template_line_query"), " ");
    \u0275\u0275advance(8);
    \u0275\u0275property("formGroup", ctx_r0.lineQueryForm);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(20, 15, "form_label_query_name"), " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(25, 17, "form_label_order_no"), " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(30, 19, "form_label_query_procedure"));
    \u0275\u0275advance(6);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(36, 21, "query"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(39, 23, "procedure"));
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(43, 25, "form_label_query_string"), " ");
    \u0275\u0275advance(5);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(48, 27, "cancel"), " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx_r0.lineQueryForm.invalid);
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", ctx_r0.editingQueryIndex !== -1 ? \u0275\u0275pipeBind1(51, 29, "update") : \u0275\u0275pipeBind1(52, 31, "add"), " ");
  }
}
function viewMandatoryValidator() {
  return (control) => {
    const selectedOptions = control.value;
    if (Array.isArray(selectedOptions) && selectedOptions.includes("view")) {
      return null;
    }
    return { viewMandatory: true };
  };
}
var _ExportTemplateComponent = class _ExportTemplateComponent {
  constructor(fb, gridApiService, toastr, route, router, localStorageService, storeData, location, translate, titleService, http) {
    this.fb = fb;
    this.gridApiService = gridApiService;
    this.toastr = toastr;
    this.route = route;
    this.router = router;
    this.localStorageService = localStorageService;
    this.storeData = storeData;
    this.location = location;
    this.translate = translate;
    this.titleService = titleService;
    this.http = http;
    this.items = [];
    this.queries = [];
    this.action_types = [];
    this.field_types = [];
    this.tables_list = [];
    this.wizard_type_list = [];
    this.id = null;
    this.editTitle = false;
    this.submitted = false;
    this.commonConfig = commonConfig;
    this.existing_actions = [];
    this.redirect_url = "export_template";
    this.rowsLength = 26;
    this.selectedItem = null;
    this.editingItemIndex = -1;
    this.selectedQuery = null;
    this.editingQueryIndex = -1;
    this.editorOptions = { theme: "vs-dark", language: "json", tabSize: 1, insertSpaces: true };
    this.htmlEditorOptions = __spreadProps(__spreadValues({}, this.editorOptions), { language: "html" });
    this.isDarkTheme = true;
    this._originalItems = [];
    this._originalQueries = [];
    this.selectedFile = null;
    this.isProcessingFile = false;
    this.fileError = "";
    this.excelHeaders = [];
    this.insert_json_schema = {
      // it will be removed
      action: ["insert", "insert", "insert"],
      table: ["export_templates", "export_template_line_items", "export_template_queries"],
      table_mapping: ["table1", "table2", "table3"],
      data: {
        table1: [],
        table2: [],
        table3: []
      }
    };
    this.update_json_schema = {
      // it will be removed
      action: ["update", "hard_delete", "insert", "hard_delete", "insert"],
      table: ["export_templates", "export_template_line_items", "export_template_line_items", "export_template_queries", "export_template_queries"],
      table_mapping: ["table1", "table2", "table3", "table4", "table5"],
      data: {
        table1: [],
        table3: [],
        table5: []
      },
      conditions: {
        table1: [],
        table2: [],
        table4: []
      }
    };
    this.isItemModalOpen = false;
    this.isQueryModalOpen = false;
    this.itemsTableConfig = {
      columns: [
        { key: "field_name", label: "Field Name", sortable: true, searchable: true },
        { key: "display_name", label: "Display Name", sortable: true, searchable: true },
        { key: "field_table", label: "Field Table", sortable: true, searchable: true },
        { key: "order_no", label: "Order No", sortable: true, searchable: true },
        { key: "field_type_id", label: "Field Type", sortable: true, searchable: true },
        {
          key: "actions",
          label: "Actions",
          type: "button",
          actions: [
            {
              icon: "fa-solid fa-edit",
              onClick: (item) => this.editLineItem(item),
              class: "   mr-4",
              tooltip: "Edit Item"
            },
            {
              icon: "fa-solid fa-trash",
              onClick: (item) => this.removeItem(item),
              class: "  ",
              tooltip: "Delete Item"
            }
          ]
        }
      ],
      pageSizes: [5, 10, 25, 50],
      defaultPageSize: 5,
      searchable: true,
      headerConfig: {
        title: "Export Template Line Items",
        showHeader: true,
        addButton: {
          show: true,
          label: "Add New",
          icon: "fa-solid fa-plus",
          onClick: () => this.initNewLineItem(),
          disabled: false,
          class: "btn-primary flex items-center rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold dark:border-[#253b5c] dark:bg-[#1b2e4b] dark:text-white-dark"
        },
        enableFilter: true,
        enableColumnSelector: true,
        enableExport: true
      }
    };
    this.queriesTableConfig = {
      columns: [
        { key: "query_name", label: "Query Name", sortable: true, searchable: true },
        { key: "order_no", label: "Order No", sortable: true, searchable: true },
        { key: "query_procedure", label: "Query Procedure", sortable: true, searchable: true },
        { key: "query_string", label: "Query String", sortable: true, searchable: true },
        {
          key: "actions",
          label: "Actions",
          type: "button",
          actions: [
            {
              icon: "fa-solid fa-edit",
              onClick: (item) => this.editQueryItem(item),
              class: "   mr-4",
              tooltip: "Edit Query"
            },
            {
              icon: "fa-solid fa-trash",
              onClick: (item) => this.removeQuery(item),
              class: "  ",
              tooltip: "Delete Query"
            }
          ]
        }
      ],
      pageSizes: [5, 10, 25, 50],
      defaultPageSize: 5,
      searchable: true,
      headerConfig: {
        title: "Export Template Line Queries",
        showHeader: true,
        addButton: {
          show: true,
          label: "Add New",
          icon: "fa-solid fa-plus",
          onClick: () => this.initNewLineQuery(),
          disabled: false,
          class: "btn-primary flex items-center rounded-md border border-[#e0e6ed] px-4 py-2 font-semibold dark:border-[#253b5c] dark:bg-[#1b2e4b] dark:text-white-dark"
        },
        enableFilter: true,
        enableColumnSelector: true,
        enableExport: true
      }
    };
    this.initStore();
  }
  ngOnInit() {
    this.id = this.route.snapshot.params["id"] || null;
    this.initForm();
    this.field_types = this.commonConfig.field_types;
    this.action_types = this.commonConfig.action_types;
    this.wizard_type_list = this.commonConfig.wizard_type;
    this.fetchAllTables();
    if (!this.id) {
      this.editTitle = false;
    } else {
      this.editTitle = true;
      this.loadData(this.id);
    }
    this.titleChange();
  }
  initStore() {
    return __async(this, null, function* () {
      this.storeData.select((d) => d.index).subscribe((d) => {
        this.store = d;
      });
    });
  }
  downloadExcel() {
    const fileUrl = `${environment.apiUrl}/${this.commonFile}`;
    this.http.get(fileUrl, { responseType: "blob" }).subscribe({
      next: (blob) => {
        (0, import_file_saver.saveAs)(blob, "downloaded_file.xlsx");
      },
      error: (err) => {
        console.error("Error downloading the file", err);
      }
    });
  }
  handleFileInput(event) {
    const input = event.target;
    const file = input?.files?.[0];
    this.fileError = "";
    if (!file)
      return;
    if (!this.isExcelFile(file)) {
      this.fileError = "Please upload only Excel files (.xlsx, .xls, .csv)";
      return;
    }
    const headerRow = this.form.get("header_row")?.value;
    if (!headerRow) {
      this.fileError = "Please specify the header row number first";
      return;
    }
    this.isProcessingFile = true;
    this.gridApiService.uploadExcelFile(file).subscribe((response) => {
      if (response.body && response.body.status) {
        const filePath = response.body.data;
        this.commonFile = filePath;
        this.form.patchValue({ data_filepath: filePath });
        this.selectedFile = file;
        this.loadExcelHeaders(filePath, headerRow);
      }
      this.isProcessingFile = false;
    }, (error) => {
      this.fileError = "Error uploading file. Please try again.";
      this.isProcessingFile = false;
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  removeFile() {
    this.selectedFile = null;
    this.fileError = "";
    this.excelHeaders = [];
    this.form.patchValue({ data_filepath: "" });
    const items = this.form.get("items");
    while (items.length > 0) {
      items.removeAt(0);
    }
    this._originalItems = [];
    items.controls.forEach((control) => {
      const columnNameControl = control.get("column_name");
      if (columnNameControl) {
        columnNameControl.setValue("");
      }
    });
    this.isItemModalOpen = false;
    this.selectedItem = null;
    this.editingItemIndex = -1;
    this.toastr.info("File and associated line items have been removed");
  }
  isExcelFile(file) {
    return /\.(xlsx|xls|csv)$/.test(file.name.toLowerCase());
  }
  processExcelFile(file, headerRow) {
    this.isProcessingFile = true;
    this.fileError = "";
    const reader = new FileReader();
    reader.onload = (e) => {
      try {
        if (!e.target?.result) {
          throw new Error("Failed to read file");
        }
        const data = new Uint8Array(e.target.result);
        const workbook = readSync(data, { type: "array" });
        const firstSheetName = workbook.SheetNames[0];
        const worksheet = workbook.Sheets[firstSheetName];
        const range = utils.decode_range(worksheet["!ref"] || "A1");
        const headers = [];
        for (let C = range.s.c; C <= range.e.c; ++C) {
          const cellRef = utils.encode_cell({ r: headerRow - 1, c: C });
          const cell = worksheet[cellRef];
          if (cell && cell.v) {
            headers.push(String(cell.v).trim());
          }
        }
        if (headers.length === 0) {
          this.fileError = `No headers found in row ${headerRow} (${utils.encode_col(0)}${headerRow})`;
          this.isProcessingFile = false;
          return;
        }
        this.excelHeaders = headers;
        const items = this.form.get("items");
        items.controls.forEach((control) => {
          const columnNameControl = control.get("column_name");
          if (columnNameControl) {
            columnNameControl.enable();
          }
        });
      } catch (error) {
        console.error("Excel processing error:", error);
        this.fileError = "Error processing Excel file. Please try again.";
      } finally {
        this.isProcessingFile = false;
      }
    };
    reader.onerror = () => {
      this.fileError = "Error reading file. Please try again.";
      this.isProcessingFile = false;
    };
    reader.readAsArrayBuffer(file);
  }
  // Helper method to validate header row input
  validateHeaderRowInput(input) {
    const row = Number(input);
    return row > 0 && row <= 1048576;
  }
  // Update the header row validation
  validateHeaderRow(event) {
    const input = event.target;
    const value = parseInt(input.value);
    if (!this.validateHeaderRowInput(value)) {
      this.fileError = "Please enter a valid row number (1-1048576)";
      return;
    }
    const filePath = this.form.get("data_filepath")?.value;
    if (filePath) {
      this.loadExcelHeaders(filePath, value);
    }
  }
  loadExcelHeaders(filePath, headerRow) {
    if (!filePath || !headerRow) {
      this.excelHeaders = [];
      return;
    }
    const params = {
      file_path: filePath,
      header_row: headerRow
    };
    this.gridApiService.getExcelHeaders(params).subscribe((response) => {
      if (response.status && response.code === 200) {
        this.excelHeaders = response.data;
      }
    }, (error) => {
      console.error("Error loading Excel headers:", error);
      const errorMessage = this.translate.instant("error_loading_excel_headers");
      this.toastr.error(errorMessage, "Error");
    });
  }
  initLineItemForm() {
    this.lineItemForm = this.fb.group({
      field_name: ["", [Validators.required, Validators.maxLength(100)]],
      display_name: ["", [Validators.required, Validators.maxLength(100)]],
      order_no: ["", [Validators.required, Validators.min(0)]],
      field_table: ["", Validators.required],
      default_value: [""],
      column_name: [""],
      is_individual: [false],
      individual_column: [""],
      field_type_id: ["", Validators.required]
    });
    this.addFormArraySubscriptions();
    this.form.get("header_row")?.valueChanges.subscribe(() => {
      if (this.selectedFile) {
        this.removeFile();
      }
    });
  }
  initLineQueryForm() {
    this.lineQueryForm = this.fb.group({
      query_string: ["", [Validators.required]],
      order_no: ["", [Validators.required, Validators.min(0)]],
      query_name: ["", [Validators.required, Validators.min(0)]],
      query_procedure: ["", [Validators.required]]
    });
  }
  addFormArraySubscriptions() {
    this.lineItemForm.get("is_foreign")?.valueChanges.subscribe((value) => {
      const foreignControls = ["foreign_table", "foreign_column", "foreign_can_create"];
      foreignControls.forEach((control) => {
        const formControl = this.lineItemForm.get(control);
        if (value) {
          formControl?.enable();
        } else {
          formControl?.disable();
        }
      });
    });
    this.lineItemForm.get("is_enum")?.valueChanges.subscribe((value) => {
      const enumControl = this.lineItemForm.get("enum_values");
      if (value) {
        enumControl?.enable();
      } else {
        enumControl?.disable();
      }
    });
    this.lineItemForm.get("is_individual")?.valueChanges.subscribe((value) => {
      const individualColumn = this.lineItemForm.get("individual_column");
      if (value) {
        individualColumn?.enable();
      } else {
        individualColumn?.disable();
      }
    });
  }
  initNewLineItem() {
    this.editingItemIndex = -1;
    this.selectedItem = {};
    this.lineItemForm.reset({
      is_individual: false
    });
    this.isItemModalOpen = true;
  }
  initNewLineQuery() {
    this.editingQueryIndex = -1;
    this.selectedQuery = {};
    this.lineQueryForm.reset({
      query_string: "",
      order_no: "",
      query_name: "",
      query_procedure: ""
    });
    this.isQueryModalOpen = true;
  }
  editQueryItem(index) {
    this.selectedQuery = index;
    this.editingQueryIndex = this.queriesData.findIndex((q) => q === index);
    this.lineQueryForm.patchValue(index);
    this.isQueryModalOpen = true;
  }
  editLineItem(index) {
    this.selectedItem = index;
    this.editingItemIndex = this.itemsData.findIndex((i) => i === index);
    const filePath = this.form.get("data_filepath")?.value;
    const headerRow = this.form.get("header_row")?.value;
    if (filePath && headerRow) {
      this.loadExcelHeaders(filePath, headerRow);
    }
    this.lineItemForm.patchValue(index);
    this.isItemModalOpen = true;
  }
  cancelLineItemEdit() {
    this.selectedItem = null;
    this.editingItemIndex = -1;
    this.lineItemForm.reset();
    this.isItemModalOpen = false;
  }
  cancelLineQueryEdit() {
    this.selectedQuery = null;
    this.editingQueryIndex = -1;
    this.lineQueryForm.reset();
    this.isQueryModalOpen = false;
  }
  onLineItemSubmit() {
    if (this.lineItemForm.valid) {
      const itemsArray = this.form.get("items");
      const formValue = this.lineItemForm.value;
      if (this.editingItemIndex !== -1) {
        itemsArray.at(this.editingItemIndex).patchValue(formValue);
        this._originalItems[this.editingItemIndex] = __spreadValues(__spreadValues({}, this._originalItems[this.editingItemIndex]), formValue);
      } else {
        itemsArray.push(this.fb.group(formValue));
        this._originalItems.push(__spreadValues({}, formValue));
      }
      this.isItemModalOpen = false;
      this.cancelLineItemEdit();
    }
  }
  onLineQuerySubmit() {
    if (this.lineQueryForm.valid) {
      const queriesArray = this.form.get("queries");
      const formValue = this.lineQueryForm.value;
      if (this.editingQueryIndex !== -1) {
        queriesArray.at(this.editingQueryIndex).patchValue(formValue);
        this._originalQueries[this.editingQueryIndex] = __spreadValues(__spreadValues({}, this._originalQueries[this.editingQueryIndex]), formValue);
      } else {
        queriesArray.push(this.fb.group(formValue));
        this._originalQueries.push(__spreadValues({}, formValue));
      }
      this.isQueryModalOpen = false;
      this.cancelLineQueryEdit();
    }
  }
  getFieldTypeName(typeId) {
    const fieldType = this.field_types.find((type) => type.value === typeId);
    return fieldType ? fieldType.label : "";
  }
  isLineItemFieldInvalid(fieldName) {
    const field = this.lineItemForm?.get(fieldName);
    return field ? field.invalid && (field.touched || this.submitted) : false;
  }
  isLineQueryFieldInvalid(fieldName) {
    const field = this.lineQueryForm?.get(fieldName);
    return field ? field.invalid && (field.touched || this.submitted) : false;
  }
  titleChange() {
    const title = this.editTitle ? "title_edit_entity" : "title_add_entity";
    const translateTitle = this.translate.instant(title);
    this.titleService.setTitle(translateTitle);
  }
  decimalValidator(control) {
    const value = control.value;
    if (value !== null && value !== void 0 && !/^\d+(\.\d{1,2})?$/.test(value)) {
      return { decimalInvalid: true };
    }
    return null;
  }
  initForm() {
    this.form = this.fb.group({
      name: ["", [Validators.required, Validators.maxLength(100)]],
      slug: [""],
      description: ["", Validators.required],
      max_row_count: ["", Validators.required],
      data_filepath: ["", Validators.required],
      header_row: ["", Validators.required],
      data_start_row: ["", Validators.required],
      data_end_row: ["", Validators.required],
      status_id: [1],
      items: this.fb.array([]),
      queries: this.fb.array([])
    });
    this.initLineItemForm();
    this.initLineQueryForm();
  }
  updateFormValidation(entityType) {
    this.form.clearValidators();
    const itemsControl = this.form.get("items");
    const queriesControl = this.form.get("queries");
    this.form.updateValueAndValidity();
  }
  constructRedirectUrl() {
    const currentUrl = this.router.url;
    let updatedUrl = currentUrl.replace(/\/edit\/\d+$/, "");
    this.redirect_url = updatedUrl.replace(/\/add$/, "");
  }
  toggleTheme() {
    this.isDarkTheme = !this.isDarkTheme;
    this.editorOptions = __spreadProps(__spreadValues({}, this.editorOptions), {
      theme: this.isDarkTheme ? "vs-dark" : "vs-light"
    });
  }
  fetchAllTables() {
    this.gridApiService.getAllTables().subscribe((response) => {
      if (response.status && response.code === 200) {
        this.tables_list = response.data;
      }
    }, (error) => {
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  removeItem(item) {
    const items = this.form.get("items");
    const index = items.controls.findIndex((control) => control.value.field_name === item.field_name);
    if (index !== -1) {
      items.removeAt(index);
      if (this._originalItems && this._originalItems[index]) {
        this._originalItems.splice(index, 1);
      }
      console.log(`Item with field_name: ${item.field_name} removed at index: ${index}`);
    } else {
      this.toastr.warning(`Item with field_name: ${item.field_name} not found.`);
    }
  }
  removeQuery(query) {
    const queries = this.form.get("queries");
    const index = queries.controls.findIndex((control) => control.value.query_name === query.query_name);
    if (index !== -1) {
      queries.removeAt(index);
      if (this._originalQueries && this._originalQueries[index]) {
        this._originalQueries.splice(index, 1);
      }
      console.log(`Query with query_name: ${query.query_name} removed at index: ${index}`);
    } else {
      this.toastr.warning(`Query with query_name: ${query.query_name} not found.`);
    }
  }
  get itemsControls() {
    return this.form.get("items").controls;
  }
  get queriesControls() {
    return this.form.get("queries").controls;
  }
  loadData(id) {
    const params = {
      company_id: 1,
      print_query: true,
      primary_table: "export_templates",
      start_index: 0,
      limit_range: 1,
      sort_columns: [["export_templates.id", "desc"]],
      search_all: [
        {
          column_name: "export_templates.uuid",
          value: id,
          operator: "="
        }
      ],
      select_columns: [
        ["export_templates.*"],
        [
          "CASE WHEN COUNT(export_template_line_items.id) = 0 THEN null ELSE COALESCE(Json_agg(DISTINCT jsonb_build_object('field_name', export_template_line_items.field_name, 'display_name', export_template_line_items.display_name, 'field_table', export_template_line_items.field_table, 'order_no', export_template_line_items.order_no, 'default_value', export_template_line_items.default_value, 'column_name', export_template_line_items.column_name, 'is_individual', export_template_line_items.is_individual, 'individual_column', export_template_line_items.individual_column,  'field_type_id', export_template_line_items.field_type_id))) END",
          "items"
        ],
        [
          "CASE WHEN COUNT(export_template_queries.id) = 0 THEN null ELSE COALESCE(Json_agg(DISTINCT jsonb_build_object('query_string', export_template_queries.query_string,'query_name', export_template_queries.query_name,'query_procedure', export_template_queries.query_procedure, 'order_no', export_template_queries.order_no))) END",
          "queries"
        ]
      ],
      includes: [
        {
          table_name: "export_template_line_items",
          join_type: "LEFT",
          join_condition: `export_templates.id = export_template_line_items.export_template_id`
        },
        {
          table_name: "export_template_queries",
          join_type: "LEFT",
          join_condition: `export_templates.id = export_template_queries.export_template_id`
        }
      ],
      group_by: ["export_templates.id"]
    };
    this.gridApiService.getAllList(params).subscribe((response) => {
      if (response.status && response.code === 200) {
        const entity = response.data.records[0];
        this.form.patchValue({
          name: entity.name,
          slug: entity.slug,
          description: entity.description,
          max_row_count: entity.max_row_count,
          data_filepath: entity.data_filepath,
          header_row: entity.header_row,
          data_start_row: entity.data_start_row,
          data_end_row: entity.data_end_row,
          status_id: entity.status_id
        });
        if (entity.data_filepath) {
          this.commonFile = entity.data_filepath;
          const fileName = entity.data_filepath.split("/").pop() || "";
          this.selectedFile = {
            name: fileName,
            size: 0,
            // We don't have the actual file size
            type: fileName.split(".").pop() || ""
          };
          if (entity.header_row) {
            this.loadExcelHeaders(entity.data_filepath, entity.header_row);
          }
        }
        const items = this.form.get("items");
        if (entity.items && entity.items.length > 0) {
          this._originalItems = [...entity.items];
          entity.items.forEach((item) => {
            items.push(this.fb.group({
              field_name: [item.field_name, Validators.required],
              display_name: [item.display_name, Validators.required],
              order_no: [item.order_no, [Validators.required, Validators.min(0)]],
              field_table: [item.field_table, Validators.required],
              default_value: [item.default_value],
              column_name: [item.column_name],
              is_individual: [item.is_individual],
              individual_column: [item.individual_column],
              field_type_id: [item.field_type_id, Validators.required]
            }));
          });
        }
        const queries = this.form.get("queries");
        if (entity.queries && entity.queries.length > 0) {
          this._originalQueries = [...entity.queries];
          entity.queries.forEach((query) => {
            queries.push(this.fb.group({
              query_string: [query.query_string, Validators.required],
              order_no: [query.order_no, [Validators.required, Validators.min(0)]],
              query_name: [query.query_name, Validators.required],
              query_procedure: [query.query_procedure, Validators.required]
            }));
          });
        }
      }
    }, (error) => {
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  getAddParams(formData) {
    const master = [
      {
        name: formData.name,
        status_id: formData.status_id,
        slug: formData.slug,
        description: formData.description,
        max_row_count: formData.max_row_count,
        data_filepath: formData.data_filepath,
        header_row: formData.header_row,
        data_start_row: formData.data_start_row,
        data_end_row: formData.data_end_row
      }
    ];
    if (formData.items && formData.items.length > 0) {
      const items = formData.items.map((item) => ({
        export_template_id: "@table1.id",
        field_name: item.field_name,
        display_name: item.display_name,
        order_no: item.order_no,
        field_table: item.field_table,
        default_value: item.default_value,
        column_name: item.column_name,
        is_individual: item.is_individual,
        individual_column: item.is_individual ? item.individual_column ? item.individual_column : null : null,
        field_type_id: item.field_type_id
      }));
      this.insert_json_schema.data["table2"] = items;
    }
    if (formData.queries && formData.queries.length > 0) {
      const queries = formData.queries.map((query) => ({
        export_template_id: "@table1.id",
        query_string: query.query_string,
        order_no: query.order_no,
        query_name: query.query_name,
        query_procedure: query.query_procedure
      }));
      this.insert_json_schema.data["table3"] = queries;
    }
    this.insert_json_schema.data["table1"] = master;
    return this.insert_json_schema;
  }
  getEditParams(formData, id) {
    const master = [
      {
        name: formData.name,
        status_id: formData.status_id,
        slug: formData.slug,
        description: formData.description,
        max_row_count: formData.max_row_count,
        data_filepath: formData.data_filepath,
        header_row: formData.header_row,
        data_start_row: formData.data_start_row,
        data_end_row: formData.data_end_row
      }
    ];
    this.update_json_schema.data["table1"] = master;
    this.update_json_schema.conditions["table1"] = [{ uuid: id }];
    this.update_json_schema.conditions["table2"] = [{ export_template_id: "@table1.id" }];
    this.update_json_schema.conditions["table4"] = [{ export_template_id: "@table1.id" }];
    if (formData.items && formData.items.length > 0) {
      const items = formData.items.map((item) => ({
        export_template_id: "@table1.id",
        field_name: item.field_name,
        display_name: item.display_name,
        order_no: item.order_no,
        field_table: item.field_table,
        default_value: item.default_value,
        column_name: item.column_name,
        is_individual: item.is_individual,
        individual_column: item.is_individual ? item.individual_column ? item.individual_column : null : null,
        field_type_id: item.field_type_id
      }));
      this.update_json_schema.data["table3"] = items;
    }
    if (formData.queries && formData.queries.length > 0) {
      const queries = formData.queries.map((query) => ({
        export_template_id: "@table1.id",
        query_string: query.query_string,
        order_no: query.order_no,
        query_name: query.query_name,
        query_procedure: query.query_procedure
      }));
      this.update_json_schema.data["table5"] = queries;
    }
    return this.update_json_schema;
  }
  prepareJSON(data) {
    return JSON.stringify(JSON.parse(data));
  }
  prettyJSON(data) {
    return JSON.stringify(JSON.parse(JSON.stringify(data).replace(/@table(\w+)/g, "##table$1")), null, 2);
  }
  onSubmit() {
    this.submitted = true;
    const formData = this.form.value;
    const payload = this.id ? this.getEditParams(formData, this.id) : this.getAddParams(formData);
    this.gridApiService.executeRecords(payload).subscribe((response) => {
      if (response.status && response.code === 200) {
        let key;
        if (this.id) {
          key = "record_updated_successfully";
        } else {
          key = "record_inserted_successfully";
        }
        const successMessage = this.translate.instant(key);
        this.toastr.success(successMessage);
        this.router.navigate([this.redirect_url]);
      } else {
        const key = response.message;
        const errorMessage = this.translate.instant(key);
        this.toastr.error(errorMessage, "Error");
      }
    }, (error) => {
      const key = "error";
      const errorMessage = this.translate.instant(key);
      this.toastr.error(errorMessage, "Error");
    });
  }
  isFieldInvalid(fieldName) {
    const field = this.form.get(fieldName);
    return field ? field.invalid && (field.touched || this.submitted) : false;
  }
  isFormInvalid() {
    return this.form.invalid || this.itemsControls.length === 0 || this.queriesControls.length === 0;
  }
  logFormStatus() {
    Object.keys(this.form.controls).forEach((field) => {
      const control = this.form.get(field);
      if (control) {
        console.log(`Field: ${field}, Status: ${control.status}, Errors: ${JSON.stringify(control.errors)}`);
      }
    });
  }
  getErrorMessage(fieldName) {
    const field = this.form.get(fieldName);
    if (field) {
      if (field.hasError("required")) {
        return "required_message";
      }
      if (field.hasError("maxlength")) {
        return `Maximum length exceeded (${field.errors?.["maxlength"].requiredLength} characters allowed)`;
      }
      if (field.hasError("min")) {
        return `Minimum value is ${field.errors?.["min"].min}`;
      }
      if (field.hasError("viewMandatory")) {
        return '"view" option is mandatory';
      }
    }
    return "";
  }
  isItemFieldInvalid(index, fieldName) {
    const items = this.form.get("items");
    const field = items.at(index).get(fieldName);
    return field ? field.invalid && (field.touched || this.submitted) : false;
  }
  isQueryFieldInvalid(index, fieldName) {
    const queries = this.form.get("queries");
    const field = queries.at(index).get(fieldName);
    return field ? field.invalid && (field.touched || this.submitted) : false;
  }
  getItemErrorMessage(index, fieldName) {
    const items = this.form.get("items");
    const field = items.at(index).get(fieldName);
    if (field) {
      if (field.hasError("required")) {
        return "required_message";
      }
      if (field.hasError("maxlength")) {
        return `Maximum length exceeded (${field.errors?.["maxlength"].requiredLength} characters allowed)`;
      }
      if (field.hasError("min")) {
        return `Minimum value is ${field.errors?.["min"].min}`;
      }
    }
    return "";
  }
  getQueryErrorMessage(index, fieldName) {
    const queries = this.form.get("queries");
    const field = queries.at(index).get(fieldName);
    if (field) {
      if (field.hasError("required")) {
        return "required_message";
      }
      if (field.hasError("maxlength")) {
        return `Maximum length exceeded (${field.errors?.["maxlength"].requiredLength} characters allowed)`;
      }
      if (field.hasError("min")) {
        return `Minimum value is ${field.errors?.["min"].min}`;
      }
    }
    return "";
  }
  getLineItemErrorMessage(fieldName) {
    const field = this.lineItemForm.get(fieldName);
    if (field) {
      if (field.hasError("required")) {
        return "required_message";
      }
      if (field.hasError("maxlength")) {
        return `Maximum length exceeded (${field.errors?.["maxlength"].requiredLength} characters allowed)`;
      }
      if (field.hasError("min")) {
        return `Minimum value is ${field.errors?.["min"].min}`;
      }
    }
    return "";
  }
  getQueryItemErrorMessage(fieldName) {
    const field = this.lineQueryForm.get(fieldName);
    if (field) {
      if (field.hasError("required")) {
        return "required_message";
      }
      if (field.hasError("maxlength")) {
        return `Maximum length exceeded (${field.errors?.["maxlength"].requiredLength} characters allowed)`;
      }
      if (field.hasError("min")) {
        return `Minimum value is ${field.errors?.["min"].min}`;
      }
    }
    return "";
  }
  // Items Table Methods
  get itemsData() {
    return this.form.get("items").controls.map((control) => control.value);
  }
  get queriesData() {
    return this.form.get("queries").controls.map((control) => control.value);
  }
  createItemFormGroup(item) {
    return this.fb.group({
      field_name: [item.field_name, Validators.required],
      display_name: [item.display_name, Validators.required],
      order_no: [item.order_no, [Validators.required, Validators.min(0)]],
      field_table: [item.field_table, Validators.required],
      default_value: [item.default_value],
      column_name: [item.column_name],
      is_individual: [item.is_individual],
      individual_column: [item.individual_column],
      field_type_id: [item.field_type_id, Validators.required]
    });
  }
  createQueryFormGroup(query) {
    return this.fb.group({
      query_string: [query.query_string, Validators.required],
      order_no: [query.order_no, [Validators.required, Validators.min(0)]],
      query_name: [query.query_name, Validators.required],
      query_procedure: [query.query_procedure]
    });
  }
  onItemsDataChange(data) {
    const items = this.form.get("items");
    items.clear();
    const itemsToUse = !data || data.length === 0 ? this._originalItems : data;
    itemsToUse.forEach((item) => {
      items.push(this.createItemFormGroup(item));
    });
  }
  onQueriesDataChange(data) {
    const queries = this.form.get("queries");
    queries.clear();
    const queriesToUse = !data || data.length === 0 ? this._originalQueries : data;
    queriesToUse.forEach((query) => {
      queries.push(this.createQueryFormGroup(query));
    });
  }
  onItemsSortChange(sort) {
    const items = [...this.itemsData];
    items.sort((a, b) => {
      const aVal = a[sort.column];
      const bVal = b[sort.column];
      return sort.direction === "asc" ? aVal > bVal ? 1 : -1 : aVal < bVal ? 1 : -1;
    });
    this.onItemsDataChange(items);
  }
  onQueriesSortChange(sort) {
    const queries = [...this.queriesData];
    queries.sort((a, b) => {
      const aVal = a[sort.column];
      const bVal = b[sort.column];
      return sort.direction === "asc" ? aVal > bVal ? 1 : -1 : aVal < bVal ? 1 : -1;
    });
    this.onQueriesDataChange(queries);
  }
};
_ExportTemplateComponent.\u0275fac = function ExportTemplateComponent_Factory(t) {
  return new (t || _ExportTemplateComponent)(\u0275\u0275directiveInject(FormBuilder), \u0275\u0275directiveInject(GridApiService), \u0275\u0275directiveInject(ToastrService), \u0275\u0275directiveInject(ActivatedRoute), \u0275\u0275directiveInject(Router), \u0275\u0275directiveInject(LocalStorageService), \u0275\u0275directiveInject(Store), \u0275\u0275directiveInject(Location), \u0275\u0275directiveInject(TranslateService), \u0275\u0275directiveInject(Title), \u0275\u0275directiveInject(HttpClient));
};
_ExportTemplateComponent.\u0275cmp = /* @__PURE__ */ \u0275\u0275defineComponent({ type: _ExportTemplateComponent, selectors: [["app-export-template"]], viewQuery: function ExportTemplateComponent_Query(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275viewQuery(_c0, 5);
  }
  if (rf & 2) {
    let _t;
    \u0275\u0275queryRefresh(_t = \u0275\u0275loadQuery()) && (ctx.monacoEditor = _t.first);
  }
}, standalone: true, features: [\u0275\u0275StandaloneFeature], decls: 98, vars: 106, consts: [[3, "formGroup"], [1, "panel"], [1, "flex", "flex-wrap", "justify-between"], [1, "text-md", "font-bold", "uppercase"], [1, "relative", "inline-flex", "align-middle"], ["appDynamicFontSize", "body", "type", "button", 1, "btn", "btn-danger", "mr-5", "ltr:rounded-r", "rtl:rounded-l", 3, "click"], ["appDynamicFontSize", "body", "type", "button", 1, "btn", "btn-outline-secondary", "ltr:rounded-r", "rtl:rounded-l", 3, "click", "disabled"], [1, "my-3", "border-[#e0e6ed]", "dark:border-[#1b2e4b]"], [1, "mt-2"], [1, "flex", "flex-col", "justify-between"], [1, "grid", "grid-cols-1", "gap-2", "md:grid-cols-4"], [1, "mt-0"], ["for", "name", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "name", "type", "text", "formControlName", "name", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "placeholder", "ngClass"], ["class", "invalid-feedback mt-1 text-danger", 4, "ngIf"], ["for", "slug", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "slug", "type", "text", "formControlName", "slug", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "placeholder", "ngClass"], ["for", "description", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "description", "type", "text", "formControlName", "description", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "placeholder", "ngClass"], ["for", "status_id", 1, "required-mark", "mb-2", "block", "font-medium"], [1, "flex", "items-center", "space-x-4"], [1, "flex", "cursor-pointer", "items-center"], ["type", "radio", "formControlName", "status_id", "appDynamicFontSize", "body", 1, "form-radio", 3, "value"], [1, "ml-2", "text-white-dark"], ["for", "max_row_count", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "max_row_count", "type", "number", "formControlName", "max_row_count", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "placeholder", "ngClass"], ["for", "header_row", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "header_row", "type", "number", "formControlName", "header_row", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "change", "placeholder", "ngClass"], ["for", "data_start_row", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "data_start_row", "type", "number", "formControlName", "data_start_row", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "placeholder", "ngClass"], ["for", "data_end_row", 1, "required-mark", "mb-2", "block", "font-medium"], ["id", "data_end_row", "type", "number", "formControlName", "data_end_row", "appDynamicFontSize", "body", 1, "form-input", "w-full", 3, "placeholder", "ngClass"], [1, "mt-4"], [1, "text-md", "required-mark", "font-medium"], [1, "flex", "flex-col", "gap-4"], ["class", "flex w-full items-center justify-center", 4, "ngIf"], ["class", "flex items-center justify-between rounded-lg border bg-gray-50 p-4 dark:bg-gray-700", 4, "ngIf"], ["class", "flex items-center justify-center p-4", 4, "ngIf"], ["class", "rounded border border-red-400 bg-red-100 px-4 py-3 text-red-700", 4, "ngIf"], [1, "panel", "mt-5"], [3, "dataChange", "sortChange", "data", "config"], ["class", "fixed inset-0 z-50 overflow-y-auto", 4, "ngIf"], [1, "invalid-feedback", "mt-1", "text-danger"], [1, "flex", "w-full", "items-center", "justify-center"], [1, "flex", "h-32", "w-full", "cursor-pointer", "flex-col", "items-center", "justify-center", "rounded-lg", "border-2", "border-dashed", "border-gray-300", "bg-gray-50", "hover:bg-gray-100", "dark:border-gray-600", "dark:bg-gray-700", "dark:hover:bg-gray-800"], [1, "flex", "flex-col", "items-center", "justify-center", "pb-6", "pt-5"], ["fill", "none", "stroke", "currentColor", "viewBox", "0 0 24 24", 1, "mb-3", "h-8", "w-8", "text-gray-400"], ["stroke-linecap", "round", "stroke-linejoin", "round", "stroke-width", "2", "d", "M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"], [1, "mb-2", "text-sm", "text-gray-500", "dark:text-gray-400"], [1, "font-semibold"], [1, "text-xs", "text-gray-500", "dark:text-gray-400"], ["type", "file", "accept", ".xlsx,.xls,.csv", 1, "hidden", 3, "change", "disabled"], [1, "flex", "items-center", "justify-between", "rounded-lg", "border", "bg-gray-50", "p-4", "dark:bg-gray-700"], [1, "flex", "items-center"], [1, "ml-3"], [1, "text-sm", "font-medium", "text-gray-900", "dark:text-white"], ["class", "text-xs text-gray-500 dark:text-gray-400", 4, "ngIf"], [1, "rounded-full", "p-1", "hover:bg-gray-200", "dark:hover:bg-gray-600", 3, "click"], ["fill", "none", "stroke", "currentColor", "viewBox", "0 0 24 24", 1, "h-5", "w-5"], ["stroke-linecap", "round", "stroke-linejoin", "round", "stroke-width", "2", "d", "M6 18L18 6M6 6l12 12"], [1, "cursor-pointer", "items-center", "justify-between", "rounded-lg", "border", "bg-gray-50", "p-4", "dark:bg-gray-700", 3, "click"], [1, "fa-solid", "fa-download"], [1, "flex", "items-center", "justify-center", "p-4"], [1, "h-6", "w-6", "animate-spin", "rounded-full", "border-b-2", "border-gray-900", "dark:border-white"], [1, "rounded", "border", "border-red-400", "bg-red-100", "px-4", "py-3", "text-red-700"], [1, "text-sm"], [1, "fixed", "inset-0", "z-50", "overflow-y-auto"], [1, "fixed", "inset-0", "bg-black/50", "transition-opacity", "dark:bg-black/70"], [1, "flex", "min-h-screen", "items-center", "justify-center", "p-2", "sm:p-4"], [1, "relative", "w-full", "max-w-4xl", "transform", "overflow-hidden", "rounded-lg", "bg-white", "shadow-xl", "transition-all", "dark:border", "dark:border-gray-700", "dark:bg-gray-800"], [1, "border-b", "bg-gray-50", "px-4", "py-3", "dark:border-gray-700", "dark:bg-gray-900", "sm:px-6"], [1, "flex", "items-center", "justify-between"], [1, "text-base", "font-medium", "text-gray-900", "dark:text-gray-100", "sm:text-lg"], ["type", "button", 1, "rounded-md", "p-2", "text-gray-400", "hover:text-gray-900", "focus:outline-none", "focus:ring-2", "focus:ring-blue-500", "dark:hover:text-gray-100", 3, "click"], [1, "sr-only"], [1, "fa-solid", "fa-xmark"], [1, "px-4", "py-4", "sm:px-6"], [1, "space-y-6", 3, "ngSubmit", "formGroup"], [1, "grid", "grid-cols-1", "gap-x-4", "gap-y-6", "sm:grid-cols-2", "lg:grid-cols-3"], [1, "col-span-1"], ["for", "field_name", 1, "required-mark", "form-label"], [1, "mt-1"], ["id", "field_name", "type", "text", "formControlName", "field_name", 1, "form-input", "w-full", 3, "ngClass"], ["class", "mt-1 text-sm text-red-600 dark:text-red-400", 4, "ngIf"], ["for", "display_name", 1, "required-mark", "form-label"], ["id", "display_name", "type", "text", "formControlName", "display_name", 1, "form-input", "w-full"], ["for", "order_no", 1, "required-mark", "form-label"], ["id", "order_no", "type", "number", "formControlName", "order_no", 1, "form-input", "w-full"], ["for", "field_table", 1, "required-mark", "form-label"], ["id", "field_table", "formControlName", "field_table", 1, "form-select"], ["value", ""], [3, "value", 4, "ngFor", "ngForOf"], ["for", "field_type_id", 1, "required-mark", "form-label"], ["id", "field_type_id", "formControlName", "field_type_id", 1, "form-select"], ["for", "default_value", 1, "form-label"], ["id", "default_value", "type", "text", "formControlName", "default_value", 1, "form-input", "w-full"], [1, "form-group"], [1, "form-label"], ["formControlName", "column_name", 1, "w-full", "rounded-md", "border", "px-3", "py-2", "dark:border-gray-600", "dark:bg-gray-700"], ["type", "checkbox", "id", "is_individual", "formControlName", "is_individual", 1, "form-checkbox", "h-4", "w-4", "rounded", "border-gray-300", "text-blue-600", "focus:ring-blue-500", "dark:border-gray-600", "dark:bg-gray-700"], ["class", "col-span-1", 4, "ngIf"], [1, "sticky", "bottom-0", "flex", "justify-end", "space-x-4", "border-t", "border-gray-200", "bg-white", "px-4", "py-3", "dark:border-gray-700", "dark:bg-gray-800"], ["type", "button", 1, "btn", "rounded-md", "border", "border-gray-300", "bg-white", "px-4", "py-2", "text-sm", "font-medium", "text-gray-700", "shadow-sm", "hover:bg-gray-50", "focus:outline-none", "focus:ring-2", "focus:ring-blue-500", "dark:border-gray-600", "dark:bg-gray-700", "dark:text-gray-300", "dark:hover:bg-gray-600", 3, "click"], ["type", "submit", 1, "btn", "rounded-md", "bg-blue-600", "px-4", "py-2", "text-sm", "font-medium", "text-white", "shadow-sm", "hover:bg-blue-700", "focus:outline-none", "focus:ring-2", "focus:ring-blue-500", "dark:bg-blue-700", "dark:hover:bg-blue-600", 3, "disabled"], [1, "mt-1", "text-sm", "text-red-600", "dark:text-red-400"], [3, "value"], ["id", "individual_column", "type", "text", "formControlName", "individual_column", 1, "w-full", "rounded-md", "border", "px-3", "py-2", "dark:border-gray-600", "dark:bg-gray-700"], [1, "max-h-[calc(90vh-10rem)]", "overflow-y-auto", "px-4", "py-4", "sm:px-6"], [1, "space-y-4", 3, "ngSubmit", "formGroup"], [1, "grid", "grid-cols-1", "gap-4", "sm:grid-cols-2", "lg:grid-cols-3"], [1, "space-y-2"], ["for", "query_name", 1, "required-mark", "form-label"], ["id", "query_name", "type", "text", "formControlName", "query_name", 1, "form-input", "w-full"], ["for", "query_procedure", 1, "required-mark", "form-label"], ["id", "query_procedure", "formControlName", "query_procedure", 1, "form-select"], ["value", "", "disabled", ""], ["value", "query"], ["value", "procedure"], ["for", "query_string", 1, "required-mark", "form-label"], ["id", "query_string", "formControlName", "query_string", "rows", "17", 1, "form-textarea"]], template: function ExportTemplateComponent_Template(rf, ctx) {
  if (rf & 1) {
    \u0275\u0275elementStart(0, "div", 0)(1, "div", 1)(2, "div", 2)(3, "div", 3);
    \u0275\u0275text(4);
    \u0275\u0275pipe(5, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(6, "div", 4)(7, "button", 5);
    \u0275\u0275listener("click", function ExportTemplateComponent_Template_button_click_7_listener() {
      return ctx.location.back();
    });
    \u0275\u0275text(8);
    \u0275\u0275pipe(9, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(10, "button", 6);
    \u0275\u0275listener("click", function ExportTemplateComponent_Template_button_click_10_listener() {
      return ctx.onSubmit();
    });
    \u0275\u0275text(11);
    \u0275\u0275pipe(12, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275element(13, "hr", 7);
    \u0275\u0275elementStart(14, "div", 8)(15, "div", 9)(16, "div", 10)(17, "div", 11)(18, "label", 12);
    \u0275\u0275text(19);
    \u0275\u0275pipe(20, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(21, "input", 13);
    \u0275\u0275pipe(22, "translate");
    \u0275\u0275template(23, ExportTemplateComponent_div_23_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(24, "div", 11)(25, "label", 15);
    \u0275\u0275text(26);
    \u0275\u0275pipe(27, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(28, "input", 16);
    \u0275\u0275pipe(29, "translate");
    \u0275\u0275template(30, ExportTemplateComponent_div_30_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(31, "div", 11)(32, "label", 17);
    \u0275\u0275text(33);
    \u0275\u0275pipe(34, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(35, "input", 18);
    \u0275\u0275pipe(36, "translate");
    \u0275\u0275template(37, ExportTemplateComponent_div_37_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(38, "div", 11)(39, "label", 19);
    \u0275\u0275text(40);
    \u0275\u0275pipe(41, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(42, "div", 20)(43, "label", 21);
    \u0275\u0275element(44, "input", 22);
    \u0275\u0275elementStart(45, "span", 23);
    \u0275\u0275text(46);
    \u0275\u0275pipe(47, "translate");
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(48, "label", 21);
    \u0275\u0275element(49, "input", 22);
    \u0275\u0275elementStart(50, "span", 23);
    \u0275\u0275text(51);
    \u0275\u0275pipe(52, "translate");
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(53, ExportTemplateComponent_div_53_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(54, "div", 11)(55, "label", 24);
    \u0275\u0275text(56);
    \u0275\u0275pipe(57, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(58, "input", 25);
    \u0275\u0275pipe(59, "translate");
    \u0275\u0275template(60, ExportTemplateComponent_div_60_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(61, "div", 11)(62, "label", 26);
    \u0275\u0275text(63);
    \u0275\u0275pipe(64, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(65, "input", 27);
    \u0275\u0275pipe(66, "translate");
    \u0275\u0275listener("change", function ExportTemplateComponent_Template_input_change_65_listener($event) {
      return ctx.validateHeaderRow($event);
    });
    \u0275\u0275elementEnd();
    \u0275\u0275template(67, ExportTemplateComponent_div_67_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(68, "div", 11)(69, "label", 28);
    \u0275\u0275text(70);
    \u0275\u0275pipe(71, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(72, "input", 29);
    \u0275\u0275pipe(73, "translate");
    \u0275\u0275template(74, ExportTemplateComponent_div_74_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(75, "div", 11)(76, "label", 30);
    \u0275\u0275text(77);
    \u0275\u0275pipe(78, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275element(79, "input", 31);
    \u0275\u0275pipe(80, "translate");
    \u0275\u0275template(81, ExportTemplateComponent_div_81_Template, 2, 1, "div", 14);
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(82, "div", 32)(83, "div", 33);
    \u0275\u0275text(84);
    \u0275\u0275pipe(85, "translate");
    \u0275\u0275elementEnd();
    \u0275\u0275elementStart(86, "div", 8)(87, "div", 34);
    \u0275\u0275template(88, ExportTemplateComponent_div_88_Template, 12, 3, "div", 35)(89, ExportTemplateComponent_div_89_Template, 12, 3, "div", 36)(90, ExportTemplateComponent_div_90_Template, 2, 0, "div", 37)(91, ExportTemplateComponent_div_91_Template, 3, 1, "div", 38);
    \u0275\u0275elementEnd()()()()()()();
    \u0275\u0275elementStart(92, "div", 39)(93, "app-client-datatable", 40);
    \u0275\u0275listener("dataChange", function ExportTemplateComponent_Template_app_client_datatable_dataChange_93_listener($event) {
      return ctx.onItemsDataChange($event);
    })("sortChange", function ExportTemplateComponent_Template_app_client_datatable_sortChange_93_listener($event) {
      return ctx.onItemsSortChange($event);
    });
    \u0275\u0275elementEnd()();
    \u0275\u0275elementStart(94, "div", 39)(95, "app-client-datatable", 40);
    \u0275\u0275listener("dataChange", function ExportTemplateComponent_Template_app_client_datatable_dataChange_95_listener($event) {
      return ctx.onQueriesDataChange($event);
    })("sortChange", function ExportTemplateComponent_Template_app_client_datatable_sortChange_95_listener($event) {
      return ctx.onQueriesSortChange($event);
    });
    \u0275\u0275elementEnd()()();
    \u0275\u0275template(96, ExportTemplateComponent_div_96_Template, 88, 48, "div", 41)(97, ExportTemplateComponent_div_97_Template, 53, 33, "div", 41);
  }
  if (rf & 2) {
    \u0275\u0275property("formGroup", ctx.form);
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate(ctx.editTitle ? "title_edit_export_template" : \u0275\u0275pipeBind1(5, 50, "title_add_export_template"));
    \u0275\u0275advance(4);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(9, 52, "back"), " ");
    \u0275\u0275advance(2);
    \u0275\u0275property("disabled", ctx.isFormInvalid());
    \u0275\u0275advance();
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(12, 54, "submit"), " ");
    \u0275\u0275advance(8);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(20, 56, "form_label_name"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(22, 58, "form_label_name_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(92, _c1, ctx.isFieldInvalid("name")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("name"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(27, 60, "form_label_slug"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(29, 62, "form_label_slug_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(94, _c1, ctx.isFieldInvalid("slug")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("slug"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(34, 64, "form_label_description"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(36, 66, "form_label_description_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(96, _c1, ctx.isFieldInvalid("description")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("description"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(41, 68, "form_label_status"));
    \u0275\u0275advance(4);
    \u0275\u0275property("value", 1);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(47, 70, "table_status_val_0"));
    \u0275\u0275advance(3);
    \u0275\u0275property("value", 2);
    \u0275\u0275advance(2);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(52, 72, "table_status_val_1"));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("status_id"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(57, 74, "form_label_max_row_count"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(59, 76, "form_label_max_row_count_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(98, _c1, ctx.isFieldInvalid("max_row_count")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("max_row_count"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(64, 78, "form_label_header_row"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(66, 80, "form_label_header_row_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(100, _c1, ctx.isFieldInvalid("header_row")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("header_row"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(71, 82, "form_label_data_start_row"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(73, 84, "form_label_data_start_row_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(102, _c1, ctx.isFieldInvalid("data_start_row")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("data_start_row"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate(\u0275\u0275pipeBind1(78, 86, "form_label_data_end_row"));
    \u0275\u0275advance(2);
    \u0275\u0275propertyInterpolate("placeholder", \u0275\u0275pipeBind1(80, 88, "form_label_data_end_row_placeholder"));
    \u0275\u0275property("ngClass", \u0275\u0275pureFunction1(104, _c1, ctx.isFieldInvalid("data_end_row")));
    \u0275\u0275advance(2);
    \u0275\u0275property("ngIf", ctx.isFieldInvalid("data_end_row"));
    \u0275\u0275advance(3);
    \u0275\u0275textInterpolate1(" ", \u0275\u0275pipeBind1(85, 90, "Excel File Upload"), " ");
    \u0275\u0275advance(4);
    \u0275\u0275property("ngIf", !ctx.selectedFile);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.selectedFile);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isProcessingFile);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.fileError);
    \u0275\u0275advance(2);
    \u0275\u0275property("data", ctx.itemsData)("config", ctx.itemsTableConfig);
    \u0275\u0275advance(2);
    \u0275\u0275property("data", ctx.queriesData)("config", ctx.queriesTableConfig);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isItemModalOpen);
    \u0275\u0275advance();
    \u0275\u0275property("ngIf", ctx.isQueryModalOpen);
  }
}, dependencies: [
  CommonSharedModule,
  NgClass,
  NgForOf,
  NgIf,
  \u0275NgNoValidate,
  NgSelectOption,
  \u0275NgSelectMultipleOption,
  DefaultValueAccessor,
  NumberValueAccessor,
  CheckboxControlValueAccessor,
  SelectControlValueAccessor,
  RadioControlValueAccessor,
  NgControlStatus,
  NgControlStatusGroup,
  DynamicFontSizeDirective,
  TranslatePipe,
  MonacoEditorModule,
  ReactiveFormsModule,
  FormGroupDirective,
  FormControlName,
  ClientDatatableComponent
], styles: ["\n\n.monaco-editor-container[_ngcontent-%COMP%] {\n  display: flex;\n  flex-direction: column;\n  height: 50vh;\n  resize: vertical;\n  overflow: auto;\n  min-height: 60vh;\n  max-height: 100vh;\n}\n.monaco-editor[_ngcontent-%COMP%] {\n  flex: 1;\n  width: 100%;\n}\n/*# sourceMappingURL=export-template.component.css.map */"], data: { animation: [
  trigger("toggleAnimation", [
    transition(":enter", [style({ opacity: 0, transform: "scale(0.95)" }), animate("100ms ease-out", style({ opacity: 1, transform: "scale(1)" }))]),
    transition(":leave", [animate("75ms", style({ opacity: 0, transform: "scale(0.95)" }))])
  ])
] } });
var ExportTemplateComponent = _ExportTemplateComponent;
(() => {
  (typeof ngDevMode === "undefined" || ngDevMode) && \u0275setClassDebugInfo(ExportTemplateComponent, { className: "ExportTemplateComponent", filePath: "src\\app\\@lcp-framework\\pages\\export-template\\export-template.component.ts", lineNumber: 92 });
})();
export {
  ExportTemplateComponent,
  viewMandatoryValidator
};
//# sourceMappingURL=chunk-YV5WAKLG.js.map
