import { PrismaClient} from '@prisma/sql/client'
import fs from 'fs';
import path from 'path';

const prisma = new PrismaClient();

export async function fieldTypesSeeder(company_id: number) {
  try {
    console.log("🚀 Starting FieldTypes Seeder...");

    const fieldTypes = JSON.parse(
      fs.readFileSync(path.join(__dirname, 'json/field-types.json'), 'utf-8')
    );

    await prisma.$transaction(async (tx) => {
      for (const fieldType of fieldTypes) {
        const id = fieldType.id + ((company_id - 1) * fieldTypes.length);

        const existingRecord = await tx.fieldType.findFirst({
          where: { id: id },
        });

        if (existingRecord) {
          // ✅ Update existing record
          await tx.$executeRawUnsafe(`
            UPDATE field_types 
            SET field_type = '${fieldType.field_type}',
                company_id = ${company_id},
                created_at = GETUTCDATE()
            WHERE id = ${id};
          `);
          console.log(`🔄 Updated FieldType ID ${id}`);
        } else {
          // ✅ Insert new record
          await tx.$executeRawUnsafe(`
            SET IDENTITY_INSERT field_types ON;
            INSERT INTO field_types (id, field_type, company_id, created_at) 
            VALUES (${id}, '${fieldType.field_type}', ${company_id}, GETUTCDATE());
            SET IDENTITY_INSERT field_types OFF;
          `);
          console.log(`✅ Created FieldType ID ${id}`);
        }
      }
    });

    console.log("✅ FieldTypes Seeder completed successfully.");
  } catch (error) {
    console.error(`❌ FieldType Seeder Failed: ${error}`);
    throw error;
  } finally {
    await prisma.$disconnect();
  }
}
