
/**
 * Client
**/

import * as runtime from './runtime/library.js';
import $Types = runtime.Types // general types
import $Public = runtime.Types.Public
import $Utils = runtime.Types.Utils
import $Extensions = runtime.Types.Extensions
import $Result = runtime.Types.Result

export type PrismaPromise<T> = $Public.PrismaPromise<T>


/**
 * Model Status
 * 
 */
export type Status = $Result.DefaultSelection<Prisma.$StatusPayload>
/**
 * Model FieldType
 * 
 */
export type FieldType = $Result.DefaultSelection<Prisma.$FieldTypePayload>
/**
 * Model Role
 * 
 */
export type Role = $Result.DefaultSelection<Prisma.$RolePayload>
/**
 * Model Department
 * 
 */
export type Department = $Result.DefaultSelection<Prisma.$DepartmentPayload>
/**
 * Model Designation
 * 
 */
export type Designation = $Result.DefaultSelection<Prisma.$DesignationPayload>
/**
 * Model User
 * 
 */
export type User = $Result.DefaultSelection<Prisma.$UserPayload>
/**
 * Model UserDetail
 * 
 */
export type UserDetail = $Result.DefaultSelection<Prisma.$UserDetailPayload>
/**
 * Model UserRoles
 * 
 */
export type UserRoles = $Result.DefaultSelection<Prisma.$UserRolesPayload>
/**
 * Model CategoryTypes
 * 
 */
export type CategoryTypes = $Result.DefaultSelection<Prisma.$CategoryTypesPayload>
/**
 * Model Categories
 * 
 */
export type Categories = $Result.DefaultSelection<Prisma.$CategoriesPayload>
/**
 * Model Configurations
 * 
 */
export type Configurations = $Result.DefaultSelection<Prisma.$ConfigurationsPayload>
/**
 * Model menuType
 * 
 */
export type menuType = $Result.DefaultSelection<Prisma.$menuTypePayload>
/**
 * Model Menus
 * 
 */
export type Menus = $Result.DefaultSelection<Prisma.$MenusPayload>
/**
 * Model WizardGroup
 * 
 */
export type WizardGroup = $Result.DefaultSelection<Prisma.$WizardGroupPayload>
/**
 * Model WizardType
 * 
 */
export type WizardType = $Result.DefaultSelection<Prisma.$WizardTypePayload>
/**
 * Model MasterEntity
 * 
 */
export type MasterEntity = $Result.DefaultSelection<Prisma.$MasterEntityPayload>
/**
 * Model MasterEntityLineItem
 * 
 */
export type MasterEntityLineItem = $Result.DefaultSelection<Prisma.$MasterEntityLineItemPayload>
/**
 * Model Permissions
 * 
 */
export type Permissions = $Result.DefaultSelection<Prisma.$PermissionsPayload>
/**
 * Model MenuItems
 * 
 */
export type MenuItems = $Result.DefaultSelection<Prisma.$MenuItemsPayload>
/**
 * Model UserPermissions
 * 
 */
export type UserPermissions = $Result.DefaultSelection<Prisma.$UserPermissionsPayload>
/**
 * Model RolePermissions
 * 
 */
export type RolePermissions = $Result.DefaultSelection<Prisma.$RolePermissionsPayload>
/**
 * Model Language
 * 
 */
export type Language = $Result.DefaultSelection<Prisma.$LanguagePayload>
/**
 * Model LanguageContent
 * 
 */
export type LanguageContent = $Result.DefaultSelection<Prisma.$LanguageContentPayload>

/**
 * ##  Prisma Client ʲˢ
 * 
 * Type-safe database client for TypeScript & Node.js
 * @example
 * ```
 * const prisma = new PrismaClient()
 * // Fetch zero or more Statuses
 * const statuses = await prisma.status.findMany()
 * ```
 *
 * 
 * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
 */
export class PrismaClient<
  T extends Prisma.PrismaClientOptions = Prisma.PrismaClientOptions,
  U = 'log' extends keyof T ? T['log'] extends Array<Prisma.LogLevel | Prisma.LogDefinition> ? Prisma.GetEvents<T['log']> : never : never,
  ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs
> {
  [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['other'] }

    /**
   * ##  Prisma Client ʲˢ
   * 
   * Type-safe database client for TypeScript & Node.js
   * @example
   * ```
   * const prisma = new PrismaClient()
   * // Fetch zero or more Statuses
   * const statuses = await prisma.status.findMany()
   * ```
   *
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client).
   */

  constructor(optionsArg ?: Prisma.Subset<T, Prisma.PrismaClientOptions>);
  $on<V extends U>(eventType: V, callback: (event: V extends 'query' ? Prisma.QueryEvent : Prisma.LogEvent) => void): void;

  /**
   * Connect with the database
   */
  $connect(): $Utils.JsPromise<void>;

  /**
   * Disconnect from the database
   */
  $disconnect(): $Utils.JsPromise<void>;

  /**
   * Add a middleware
   * @deprecated since 4.16.0. For new code, prefer client extensions instead.
   * @see https://pris.ly/d/extensions
   */
  $use(cb: Prisma.Middleware): void

/**
   * Executes a prepared raw query and returns the number of affected rows.
   * @example
   * ```
   * const result = await prisma.$executeRaw`UPDATE User SET cool = ${true} WHERE email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Executes a raw query and returns the number of affected rows.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$executeRawUnsafe('UPDATE User SET cool = $1 WHERE email = $2 ;', true, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $executeRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<number>;

  /**
   * Performs a prepared raw query and returns the `SELECT` data.
   * @example
   * ```
   * const result = await prisma.$queryRaw`SELECT * FROM User WHERE id = ${1} OR email = ${'user@email.com'};`
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRaw<T = unknown>(query: TemplateStringsArray | Prisma.Sql, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Performs a raw query and returns the `SELECT` data.
   * Susceptible to SQL injections, see documentation.
   * @example
   * ```
   * const result = await prisma.$queryRawUnsafe('SELECT * FROM User WHERE id = $1 OR email = $2;', 1, 'user@email.com')
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/raw-database-access).
   */
  $queryRawUnsafe<T = unknown>(query: string, ...values: any[]): Prisma.PrismaPromise<T>;

  /**
   * Allows the running of a sequence of read/write operations that are guaranteed to either succeed or fail as a whole.
   * @example
   * ```
   * const [george, bob, alice] = await prisma.$transaction([
   *   prisma.user.create({ data: { name: 'George' } }),
   *   prisma.user.create({ data: { name: 'Bob' } }),
   *   prisma.user.create({ data: { name: 'Alice' } }),
   * ])
   * ```
   * 
   * Read more in our [docs](https://www.prisma.io/docs/concepts/components/prisma-client/transactions).
   */
  $transaction<P extends Prisma.PrismaPromise<any>[]>(arg: [...P], options?: { isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<runtime.Types.Utils.UnwrapTuple<P>>

  $transaction<R>(fn: (prisma: Omit<PrismaClient, runtime.ITXClientDenyList>) => $Utils.JsPromise<R>, options?: { maxWait?: number, timeout?: number, isolationLevel?: Prisma.TransactionIsolationLevel }): $Utils.JsPromise<R>


  $extends: $Extensions.ExtendsHook<'extends', Prisma.TypeMapCb, ExtArgs>

      /**
   * `prisma.status`: Exposes CRUD operations for the **Status** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Statuses
    * const statuses = await prisma.status.findMany()
    * ```
    */
  get status(): Prisma.StatusDelegate<ExtArgs>;

  /**
   * `prisma.fieldType`: Exposes CRUD operations for the **FieldType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more FieldTypes
    * const fieldTypes = await prisma.fieldType.findMany()
    * ```
    */
  get fieldType(): Prisma.FieldTypeDelegate<ExtArgs>;

  /**
   * `prisma.role`: Exposes CRUD operations for the **Role** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Roles
    * const roles = await prisma.role.findMany()
    * ```
    */
  get role(): Prisma.RoleDelegate<ExtArgs>;

  /**
   * `prisma.department`: Exposes CRUD operations for the **Department** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Departments
    * const departments = await prisma.department.findMany()
    * ```
    */
  get department(): Prisma.DepartmentDelegate<ExtArgs>;

  /**
   * `prisma.designation`: Exposes CRUD operations for the **Designation** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Designations
    * const designations = await prisma.designation.findMany()
    * ```
    */
  get designation(): Prisma.DesignationDelegate<ExtArgs>;

  /**
   * `prisma.user`: Exposes CRUD operations for the **User** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Users
    * const users = await prisma.user.findMany()
    * ```
    */
  get user(): Prisma.UserDelegate<ExtArgs>;

  /**
   * `prisma.userDetail`: Exposes CRUD operations for the **UserDetail** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserDetails
    * const userDetails = await prisma.userDetail.findMany()
    * ```
    */
  get userDetail(): Prisma.UserDetailDelegate<ExtArgs>;

  /**
   * `prisma.userRoles`: Exposes CRUD operations for the **UserRoles** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserRoles
    * const userRoles = await prisma.userRoles.findMany()
    * ```
    */
  get userRoles(): Prisma.UserRolesDelegate<ExtArgs>;

  /**
   * `prisma.categoryTypes`: Exposes CRUD operations for the **CategoryTypes** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more CategoryTypes
    * const categoryTypes = await prisma.categoryTypes.findMany()
    * ```
    */
  get categoryTypes(): Prisma.CategoryTypesDelegate<ExtArgs>;

  /**
   * `prisma.categories`: Exposes CRUD operations for the **Categories** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Categories
    * const categories = await prisma.categories.findMany()
    * ```
    */
  get categories(): Prisma.CategoriesDelegate<ExtArgs>;

  /**
   * `prisma.configurations`: Exposes CRUD operations for the **Configurations** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Configurations
    * const configurations = await prisma.configurations.findMany()
    * ```
    */
  get configurations(): Prisma.ConfigurationsDelegate<ExtArgs>;

  /**
   * `prisma.menuType`: Exposes CRUD operations for the **menuType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MenuTypes
    * const menuTypes = await prisma.menuType.findMany()
    * ```
    */
  get menuType(): Prisma.menuTypeDelegate<ExtArgs>;

  /**
   * `prisma.menus`: Exposes CRUD operations for the **Menus** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Menus
    * const menus = await prisma.menus.findMany()
    * ```
    */
  get menus(): Prisma.MenusDelegate<ExtArgs>;

  /**
   * `prisma.wizardGroup`: Exposes CRUD operations for the **WizardGroup** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WizardGroups
    * const wizardGroups = await prisma.wizardGroup.findMany()
    * ```
    */
  get wizardGroup(): Prisma.WizardGroupDelegate<ExtArgs>;

  /**
   * `prisma.wizardType`: Exposes CRUD operations for the **WizardType** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more WizardTypes
    * const wizardTypes = await prisma.wizardType.findMany()
    * ```
    */
  get wizardType(): Prisma.WizardTypeDelegate<ExtArgs>;

  /**
   * `prisma.masterEntity`: Exposes CRUD operations for the **MasterEntity** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MasterEntities
    * const masterEntities = await prisma.masterEntity.findMany()
    * ```
    */
  get masterEntity(): Prisma.MasterEntityDelegate<ExtArgs>;

  /**
   * `prisma.masterEntityLineItem`: Exposes CRUD operations for the **MasterEntityLineItem** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MasterEntityLineItems
    * const masterEntityLineItems = await prisma.masterEntityLineItem.findMany()
    * ```
    */
  get masterEntityLineItem(): Prisma.MasterEntityLineItemDelegate<ExtArgs>;

  /**
   * `prisma.permissions`: Exposes CRUD operations for the **Permissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Permissions
    * const permissions = await prisma.permissions.findMany()
    * ```
    */
  get permissions(): Prisma.PermissionsDelegate<ExtArgs>;

  /**
   * `prisma.menuItems`: Exposes CRUD operations for the **MenuItems** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more MenuItems
    * const menuItems = await prisma.menuItems.findMany()
    * ```
    */
  get menuItems(): Prisma.MenuItemsDelegate<ExtArgs>;

  /**
   * `prisma.userPermissions`: Exposes CRUD operations for the **UserPermissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more UserPermissions
    * const userPermissions = await prisma.userPermissions.findMany()
    * ```
    */
  get userPermissions(): Prisma.UserPermissionsDelegate<ExtArgs>;

  /**
   * `prisma.rolePermissions`: Exposes CRUD operations for the **RolePermissions** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more RolePermissions
    * const rolePermissions = await prisma.rolePermissions.findMany()
    * ```
    */
  get rolePermissions(): Prisma.RolePermissionsDelegate<ExtArgs>;

  /**
   * `prisma.language`: Exposes CRUD operations for the **Language** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more Languages
    * const languages = await prisma.language.findMany()
    * ```
    */
  get language(): Prisma.LanguageDelegate<ExtArgs>;

  /**
   * `prisma.languageContent`: Exposes CRUD operations for the **LanguageContent** model.
    * Example usage:
    * ```ts
    * // Fetch zero or more LanguageContents
    * const languageContents = await prisma.languageContent.findMany()
    * ```
    */
  get languageContent(): Prisma.LanguageContentDelegate<ExtArgs>;
}

export namespace Prisma {
  export import DMMF = runtime.DMMF

  export type PrismaPromise<T> = $Public.PrismaPromise<T>

  /**
   * Validator
   */
  export import validator = runtime.Public.validator

  /**
   * Prisma Errors
   */
  export import PrismaClientKnownRequestError = runtime.PrismaClientKnownRequestError
  export import PrismaClientUnknownRequestError = runtime.PrismaClientUnknownRequestError
  export import PrismaClientRustPanicError = runtime.PrismaClientRustPanicError
  export import PrismaClientInitializationError = runtime.PrismaClientInitializationError
  export import PrismaClientValidationError = runtime.PrismaClientValidationError
  export import NotFoundError = runtime.NotFoundError

  /**
   * Re-export of sql-template-tag
   */
  export import sql = runtime.sqltag
  export import empty = runtime.empty
  export import join = runtime.join
  export import raw = runtime.raw
  export import Sql = runtime.Sql

  /**
   * Decimal.js
   */
  export import Decimal = runtime.Decimal

  export type DecimalJsLike = runtime.DecimalJsLike

  /**
   * Metrics 
   */
  export type Metrics = runtime.Metrics
  export type Metric<T> = runtime.Metric<T>
  export type MetricHistogram = runtime.MetricHistogram
  export type MetricHistogramBucket = runtime.MetricHistogramBucket

  /**
  * Extensions
  */
  export import Extension = $Extensions.UserArgs
  export import getExtensionContext = runtime.Extensions.getExtensionContext
  export import Args = $Public.Args
  export import Payload = $Public.Payload
  export import Result = $Public.Result
  export import Exact = $Public.Exact

  /**
   * Prisma Client JS version: 5.14.0
   * Query Engine version: e9771e62de70f79a5e1c604a2d7c8e2a0a874b48
   */
  export type PrismaVersion = {
    client: string
  }

  export const prismaVersion: PrismaVersion 

  /**
   * Utility Types
   */

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON object.
   * This type can be useful to enforce some input to be JSON-compatible or as a super-type to be extended from. 
   */
  export type JsonObject = {[Key in string]?: JsonValue}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches a JSON array.
   */
  export interface JsonArray extends Array<JsonValue> {}

  /**
   * From https://github.com/sindresorhus/type-fest/
   * Matches any valid JSON value.
   */
  export type JsonValue = string | number | boolean | JsonObject | JsonArray | null

  /**
   * Matches a JSON object.
   * Unlike `JsonObject`, this type allows undefined and read-only properties.
   */
  export type InputJsonObject = {readonly [Key in string]?: InputJsonValue | null}

  /**
   * Matches a JSON array.
   * Unlike `JsonArray`, readonly arrays are assignable to this type.
   */
  export interface InputJsonArray extends ReadonlyArray<InputJsonValue | null> {}

  /**
   * Matches any valid value that can be used as an input for operations like
   * create and update as the value of a JSON field. Unlike `JsonValue`, this
   * type allows read-only arrays and read-only object properties and disallows
   * `null` at the top level.
   *
   * `null` cannot be used as the value of a JSON field because its meaning
   * would be ambiguous. Use `Prisma.JsonNull` to store the JSON null value or
   * `Prisma.DbNull` to clear the JSON value and set the field to the database
   * NULL value instead.
   *
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-by-null-values
   */
  export type InputJsonValue = string | number | boolean | InputJsonObject | InputJsonArray | { toJSON(): unknown }

  /**
   * Types of the values used to represent different kinds of `null` values when working with JSON fields.
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  namespace NullTypes {
    /**
    * Type of `Prisma.DbNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.DbNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class DbNull {
      private DbNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.JsonNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.JsonNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class JsonNull {
      private JsonNull: never
      private constructor()
    }

    /**
    * Type of `Prisma.AnyNull`.
    * 
    * You cannot use other instances of this class. Please use the `Prisma.AnyNull` value.
    * 
    * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
    */
    class AnyNull {
      private AnyNull: never
      private constructor()
    }
  }

  /**
   * Helper for filtering JSON entries that have `null` on the database (empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const DbNull: NullTypes.DbNull

  /**
   * Helper for filtering JSON entries that have JSON `null` values (not empty on the db)
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const JsonNull: NullTypes.JsonNull

  /**
   * Helper for filtering JSON entries that are `Prisma.DbNull` or `Prisma.JsonNull`
   * 
   * @see https://www.prisma.io/docs/concepts/components/prisma-client/working-with-fields/working-with-json-fields#filtering-on-a-json-field
   */
  export const AnyNull: NullTypes.AnyNull

  type SelectAndInclude = {
    select: any
    include: any
  }

  type SelectAndOmit = {
    select: any
    omit: any
  }

  /**
   * Get the type of the value, that the Promise holds.
   */
  export type PromiseType<T extends PromiseLike<any>> = T extends PromiseLike<infer U> ? U : T;

  /**
   * Get the return type of a function which returns a Promise.
   */
  export type PromiseReturnType<T extends (...args: any) => $Utils.JsPromise<any>> = PromiseType<ReturnType<T>>

  /**
   * From T, pick a set of properties whose keys are in the union K
   */
  type Prisma__Pick<T, K extends keyof T> = {
      [P in K]: T[P];
  };


  export type Enumerable<T> = T | Array<T>;

  export type RequiredKeys<T> = {
    [K in keyof T]-?: {} extends Prisma__Pick<T, K> ? never : K
  }[keyof T]

  export type TruthyKeys<T> = keyof {
    [K in keyof T as T[K] extends false | undefined | null ? never : K]: K
  }

  export type TrueKeys<T> = TruthyKeys<Prisma__Pick<T, RequiredKeys<T>>>

  /**
   * Subset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection
   */
  export type Subset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never;
  };

  /**
   * SelectSubset
   * @desc From `T` pick properties that exist in `U`. Simple version of Intersection.
   * Additionally, it validates, if both select and include are present. If the case, it errors.
   */
  export type SelectSubset<T, U> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    (T extends SelectAndInclude
      ? 'Please either choose `select` or `include`.'
      : T extends SelectAndOmit
        ? 'Please either choose `select` or `omit`.'
        : {})

  /**
   * Subset + Intersection
   * @desc From `T` pick properties that exist in `U` and intersect `K`
   */
  export type SubsetIntersection<T, U, K> = {
    [key in keyof T]: key extends keyof U ? T[key] : never
  } &
    K

  type Without<T, U> = { [P in Exclude<keyof T, keyof U>]?: never };

  /**
   * XOR is needed to have a real mutually exclusive union type
   * https://stackoverflow.com/questions/42123407/does-typescript-support-mutually-exclusive-types
   */
  type XOR<T, U> =
    T extends object ?
    U extends object ?
      (Without<T, U> & U) | (Without<U, T> & T)
    : U : T


  /**
   * Is T a Record?
   */
  type IsObject<T extends any> = T extends Array<any>
  ? False
  : T extends Date
  ? False
  : T extends Uint8Array
  ? False
  : T extends BigInt
  ? False
  : T extends object
  ? True
  : False


  /**
   * If it's T[], return T
   */
  export type UnEnumerate<T extends unknown> = T extends Array<infer U> ? U : T

  /**
   * From ts-toolbelt
   */

  type __Either<O extends object, K extends Key> = Omit<O, K> &
    {
      // Merge all but K
      [P in K]: Prisma__Pick<O, P & keyof O> // With K possibilities
    }[K]

  type EitherStrict<O extends object, K extends Key> = Strict<__Either<O, K>>

  type EitherLoose<O extends object, K extends Key> = ComputeRaw<__Either<O, K>>

  type _Either<
    O extends object,
    K extends Key,
    strict extends Boolean
  > = {
    1: EitherStrict<O, K>
    0: EitherLoose<O, K>
  }[strict]

  type Either<
    O extends object,
    K extends Key,
    strict extends Boolean = 1
  > = O extends unknown ? _Either<O, K, strict> : never

  export type Union = any

  type PatchUndefined<O extends object, O1 extends object> = {
    [K in keyof O]: O[K] extends undefined ? At<O1, K> : O[K]
  } & {}

  /** Helper Types for "Merge" **/
  export type IntersectOf<U extends Union> = (
    U extends unknown ? (k: U) => void : never
  ) extends (k: infer I) => void
    ? I
    : never

  export type Overwrite<O extends object, O1 extends object> = {
      [K in keyof O]: K extends keyof O1 ? O1[K] : O[K];
  } & {};

  type _Merge<U extends object> = IntersectOf<Overwrite<U, {
      [K in keyof U]-?: At<U, K>;
  }>>;

  type Key = string | number | symbol;
  type AtBasic<O extends object, K extends Key> = K extends keyof O ? O[K] : never;
  type AtStrict<O extends object, K extends Key> = O[K & keyof O];
  type AtLoose<O extends object, K extends Key> = O extends unknown ? AtStrict<O, K> : never;
  export type At<O extends object, K extends Key, strict extends Boolean = 1> = {
      1: AtStrict<O, K>;
      0: AtLoose<O, K>;
  }[strict];

  export type ComputeRaw<A extends any> = A extends Function ? A : {
    [K in keyof A]: A[K];
  } & {};

  export type OptionalFlat<O> = {
    [K in keyof O]?: O[K];
  } & {};

  type _Record<K extends keyof any, T> = {
    [P in K]: T;
  };

  // cause typescript not to expand types and preserve names
  type NoExpand<T> = T extends unknown ? T : never;

  // this type assumes the passed object is entirely optional
  type AtLeast<O extends object, K extends string> = NoExpand<
    O extends unknown
    ? | (K extends keyof O ? { [P in K]: O[P] } & O : O)
      | {[P in keyof O as P extends K ? K : never]-?: O[P]} & O
    : never>;

  type _Strict<U, _U = U> = U extends unknown ? U & OptionalFlat<_Record<Exclude<Keys<_U>, keyof U>, never>> : never;

  export type Strict<U extends object> = ComputeRaw<_Strict<U>>;
  /** End Helper Types for "Merge" **/

  export type Merge<U extends object> = ComputeRaw<_Merge<Strict<U>>>;

  /**
  A [[Boolean]]
  */
  export type Boolean = True | False

  // /**
  // 1
  // */
  export type True = 1

  /**
  0
  */
  export type False = 0

  export type Not<B extends Boolean> = {
    0: 1
    1: 0
  }[B]

  export type Extends<A1 extends any, A2 extends any> = [A1] extends [never]
    ? 0 // anything `never` is false
    : A1 extends A2
    ? 1
    : 0

  export type Has<U extends Union, U1 extends Union> = Not<
    Extends<Exclude<U1, U>, U1>
  >

  export type Or<B1 extends Boolean, B2 extends Boolean> = {
    0: {
      0: 0
      1: 1
    }
    1: {
      0: 1
      1: 1
    }
  }[B1][B2]

  export type Keys<U extends Union> = U extends unknown ? keyof U : never

  type Cast<A, B> = A extends B ? A : B;

  export const type: unique symbol;



  /**
   * Used by group by
   */

  export type GetScalarType<T, O> = O extends object ? {
    [P in keyof T]: P extends keyof O
      ? O[P]
      : never
  } : never

  type FieldPaths<
    T,
    U = Omit<T, '_avg' | '_sum' | '_count' | '_min' | '_max'>
  > = IsObject<T> extends True ? U : T

  type GetHavingFields<T> = {
    [K in keyof T]: Or<
      Or<Extends<'OR', K>, Extends<'AND', K>>,
      Extends<'NOT', K>
    > extends True
      ? // infer is only needed to not hit TS limit
        // based on the brilliant idea of Pierre-Antoine Mills
        // https://github.com/microsoft/TypeScript/issues/30188#issuecomment-478938437
        T[K] extends infer TK
        ? GetHavingFields<UnEnumerate<TK> extends object ? Merge<UnEnumerate<TK>> : never>
        : never
      : {} extends FieldPaths<T[K]>
      ? never
      : K
  }[keyof T]

  /**
   * Convert tuple to union
   */
  type _TupleToUnion<T> = T extends (infer E)[] ? E : never
  type TupleToUnion<K extends readonly any[]> = _TupleToUnion<K>
  type MaybeTupleToUnion<T> = T extends any[] ? TupleToUnion<T> : T

  /**
   * Like `Pick`, but additionally can also accept an array of keys
   */
  type PickEnumerable<T, K extends Enumerable<keyof T> | keyof T> = Prisma__Pick<T, MaybeTupleToUnion<K>>

  /**
   * Exclude all keys with underscores
   */
  type ExcludeUnderscoreKeys<T extends string> = T extends `_${string}` ? never : T


  export type FieldRef<Model, FieldType> = runtime.FieldRef<Model, FieldType>

  type FieldRefInputType<Model, FieldType> = Model extends never ? never : FieldRef<Model, FieldType>


  export const ModelName: {
    Status: 'Status',
    FieldType: 'FieldType',
    Role: 'Role',
    Department: 'Department',
    Designation: 'Designation',
    User: 'User',
    UserDetail: 'UserDetail',
    UserRoles: 'UserRoles',
    CategoryTypes: 'CategoryTypes',
    Categories: 'Categories',
    Configurations: 'Configurations',
    menuType: 'menuType',
    Menus: 'Menus',
    WizardGroup: 'WizardGroup',
    WizardType: 'WizardType',
    MasterEntity: 'MasterEntity',
    MasterEntityLineItem: 'MasterEntityLineItem',
    Permissions: 'Permissions',
    MenuItems: 'MenuItems',
    UserPermissions: 'UserPermissions',
    RolePermissions: 'RolePermissions',
    Language: 'Language',
    LanguageContent: 'LanguageContent'
  };

  export type ModelName = (typeof ModelName)[keyof typeof ModelName]


  export type Datasources = {
    db?: Datasource
  }


  interface TypeMapCb extends $Utils.Fn<{extArgs: $Extensions.InternalArgs}, $Utils.Record<string, any>> {
    returns: Prisma.TypeMap<this['params']['extArgs']>
  }

  export type TypeMap<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    meta: {
      modelProps: 'status' | 'fieldType' | 'role' | 'department' | 'designation' | 'user' | 'userDetail' | 'userRoles' | 'categoryTypes' | 'categories' | 'configurations' | 'menuType' | 'menus' | 'wizardGroup' | 'wizardType' | 'masterEntity' | 'masterEntityLineItem' | 'permissions' | 'menuItems' | 'userPermissions' | 'rolePermissions' | 'language' | 'languageContent'
      txIsolationLevel: Prisma.TransactionIsolationLevel
    },
    model: {
      Status: {
        payload: Prisma.$StatusPayload<ExtArgs>
        fields: Prisma.StatusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.StatusFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.StatusFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          findFirst: {
            args: Prisma.StatusFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.StatusFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          findMany: {
            args: Prisma.StatusFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>[]
          }
          create: {
            args: Prisma.StatusCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          createMany: {
            args: Prisma.StatusCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.StatusCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>[]
          }
          delete: {
            args: Prisma.StatusDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          update: {
            args: Prisma.StatusUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          deleteMany: {
            args: Prisma.StatusDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.StatusUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.StatusUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$StatusPayload>
          }
          aggregate: {
            args: Prisma.StatusAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateStatus>
          }
          groupBy: {
            args: Prisma.StatusGroupByArgs<ExtArgs>,
            result: $Utils.Optional<StatusGroupByOutputType>[]
          }
          count: {
            args: Prisma.StatusCountArgs<ExtArgs>,
            result: $Utils.Optional<StatusCountAggregateOutputType> | number
          }
        }
      }
      FieldType: {
        payload: Prisma.$FieldTypePayload<ExtArgs>
        fields: Prisma.FieldTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.FieldTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.FieldTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          findFirst: {
            args: Prisma.FieldTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.FieldTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          findMany: {
            args: Prisma.FieldTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>[]
          }
          create: {
            args: Prisma.FieldTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          createMany: {
            args: Prisma.FieldTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.FieldTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>[]
          }
          delete: {
            args: Prisma.FieldTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          update: {
            args: Prisma.FieldTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          deleteMany: {
            args: Prisma.FieldTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.FieldTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.FieldTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$FieldTypePayload>
          }
          aggregate: {
            args: Prisma.FieldTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateFieldType>
          }
          groupBy: {
            args: Prisma.FieldTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<FieldTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.FieldTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<FieldTypeCountAggregateOutputType> | number
          }
        }
      }
      Role: {
        payload: Prisma.$RolePayload<ExtArgs>
        fields: Prisma.RoleFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RoleFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RoleFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          findFirst: {
            args: Prisma.RoleFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RoleFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          findMany: {
            args: Prisma.RoleFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          create: {
            args: Prisma.RoleCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          createMany: {
            args: Prisma.RoleCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RoleCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>[]
          }
          delete: {
            args: Prisma.RoleDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          update: {
            args: Prisma.RoleUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          deleteMany: {
            args: Prisma.RoleDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.RoleUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.RoleUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePayload>
          }
          aggregate: {
            args: Prisma.RoleAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateRole>
          }
          groupBy: {
            args: Prisma.RoleGroupByArgs<ExtArgs>,
            result: $Utils.Optional<RoleGroupByOutputType>[]
          }
          count: {
            args: Prisma.RoleCountArgs<ExtArgs>,
            result: $Utils.Optional<RoleCountAggregateOutputType> | number
          }
        }
      }
      Department: {
        payload: Prisma.$DepartmentPayload<ExtArgs>
        fields: Prisma.DepartmentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DepartmentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DepartmentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          findFirst: {
            args: Prisma.DepartmentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DepartmentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          findMany: {
            args: Prisma.DepartmentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>[]
          }
          create: {
            args: Prisma.DepartmentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          createMany: {
            args: Prisma.DepartmentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DepartmentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>[]
          }
          delete: {
            args: Prisma.DepartmentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          update: {
            args: Prisma.DepartmentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          deleteMany: {
            args: Prisma.DepartmentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DepartmentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DepartmentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DepartmentPayload>
          }
          aggregate: {
            args: Prisma.DepartmentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDepartment>
          }
          groupBy: {
            args: Prisma.DepartmentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DepartmentGroupByOutputType>[]
          }
          count: {
            args: Prisma.DepartmentCountArgs<ExtArgs>,
            result: $Utils.Optional<DepartmentCountAggregateOutputType> | number
          }
        }
      }
      Designation: {
        payload: Prisma.$DesignationPayload<ExtArgs>
        fields: Prisma.DesignationFieldRefs
        operations: {
          findUnique: {
            args: Prisma.DesignationFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.DesignationFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          findFirst: {
            args: Prisma.DesignationFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.DesignationFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          findMany: {
            args: Prisma.DesignationFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>[]
          }
          create: {
            args: Prisma.DesignationCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          createMany: {
            args: Prisma.DesignationCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.DesignationCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>[]
          }
          delete: {
            args: Prisma.DesignationDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          update: {
            args: Prisma.DesignationUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          deleteMany: {
            args: Prisma.DesignationDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.DesignationUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.DesignationUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$DesignationPayload>
          }
          aggregate: {
            args: Prisma.DesignationAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateDesignation>
          }
          groupBy: {
            args: Prisma.DesignationGroupByArgs<ExtArgs>,
            result: $Utils.Optional<DesignationGroupByOutputType>[]
          }
          count: {
            args: Prisma.DesignationCountArgs<ExtArgs>,
            result: $Utils.Optional<DesignationCountAggregateOutputType> | number
          }
        }
      }
      User: {
        payload: Prisma.$UserPayload<ExtArgs>
        fields: Prisma.UserFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findFirst: {
            args: Prisma.UserFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          findMany: {
            args: Prisma.UserFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          create: {
            args: Prisma.UserCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          createMany: {
            args: Prisma.UserCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>[]
          }
          delete: {
            args: Prisma.UserDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          update: {
            args: Prisma.UserUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          deleteMany: {
            args: Prisma.UserDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPayload>
          }
          aggregate: {
            args: Prisma.UserAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUser>
          }
          groupBy: {
            args: Prisma.UserGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserCountArgs<ExtArgs>,
            result: $Utils.Optional<UserCountAggregateOutputType> | number
          }
        }
      }
      UserDetail: {
        payload: Prisma.$UserDetailPayload<ExtArgs>
        fields: Prisma.UserDetailFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserDetailFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserDetailFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          findFirst: {
            args: Prisma.UserDetailFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserDetailFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          findMany: {
            args: Prisma.UserDetailFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>[]
          }
          create: {
            args: Prisma.UserDetailCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          createMany: {
            args: Prisma.UserDetailCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserDetailCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>[]
          }
          delete: {
            args: Prisma.UserDetailDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          update: {
            args: Prisma.UserDetailUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          deleteMany: {
            args: Prisma.UserDetailDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserDetailUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserDetailUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserDetailPayload>
          }
          aggregate: {
            args: Prisma.UserDetailAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserDetail>
          }
          groupBy: {
            args: Prisma.UserDetailGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserDetailGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserDetailCountArgs<ExtArgs>,
            result: $Utils.Optional<UserDetailCountAggregateOutputType> | number
          }
        }
      }
      UserRoles: {
        payload: Prisma.$UserRolesPayload<ExtArgs>
        fields: Prisma.UserRolesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserRolesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserRolesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          findFirst: {
            args: Prisma.UserRolesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserRolesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          findMany: {
            args: Prisma.UserRolesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>[]
          }
          create: {
            args: Prisma.UserRolesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          createMany: {
            args: Prisma.UserRolesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserRolesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>[]
          }
          delete: {
            args: Prisma.UserRolesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          update: {
            args: Prisma.UserRolesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          deleteMany: {
            args: Prisma.UserRolesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserRolesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserRolesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserRolesPayload>
          }
          aggregate: {
            args: Prisma.UserRolesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserRoles>
          }
          groupBy: {
            args: Prisma.UserRolesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserRolesGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserRolesCountArgs<ExtArgs>,
            result: $Utils.Optional<UserRolesCountAggregateOutputType> | number
          }
        }
      }
      CategoryTypes: {
        payload: Prisma.$CategoryTypesPayload<ExtArgs>
        fields: Prisma.CategoryTypesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoryTypesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoryTypesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          findFirst: {
            args: Prisma.CategoryTypesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoryTypesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          findMany: {
            args: Prisma.CategoryTypesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>[]
          }
          create: {
            args: Prisma.CategoryTypesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          createMany: {
            args: Prisma.CategoryTypesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CategoryTypesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>[]
          }
          delete: {
            args: Prisma.CategoryTypesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          update: {
            args: Prisma.CategoryTypesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          deleteMany: {
            args: Prisma.CategoryTypesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.CategoryTypesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.CategoryTypesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoryTypesPayload>
          }
          aggregate: {
            args: Prisma.CategoryTypesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateCategoryTypes>
          }
          groupBy: {
            args: Prisma.CategoryTypesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<CategoryTypesGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoryTypesCountArgs<ExtArgs>,
            result: $Utils.Optional<CategoryTypesCountAggregateOutputType> | number
          }
        }
      }
      Categories: {
        payload: Prisma.$CategoriesPayload<ExtArgs>
        fields: Prisma.CategoriesFieldRefs
        operations: {
          findUnique: {
            args: Prisma.CategoriesFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.CategoriesFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          findFirst: {
            args: Prisma.CategoriesFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.CategoriesFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          findMany: {
            args: Prisma.CategoriesFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>[]
          }
          create: {
            args: Prisma.CategoriesCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          createMany: {
            args: Prisma.CategoriesCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.CategoriesCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>[]
          }
          delete: {
            args: Prisma.CategoriesDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          update: {
            args: Prisma.CategoriesUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          deleteMany: {
            args: Prisma.CategoriesDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.CategoriesUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.CategoriesUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$CategoriesPayload>
          }
          aggregate: {
            args: Prisma.CategoriesAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateCategories>
          }
          groupBy: {
            args: Prisma.CategoriesGroupByArgs<ExtArgs>,
            result: $Utils.Optional<CategoriesGroupByOutputType>[]
          }
          count: {
            args: Prisma.CategoriesCountArgs<ExtArgs>,
            result: $Utils.Optional<CategoriesCountAggregateOutputType> | number
          }
        }
      }
      Configurations: {
        payload: Prisma.$ConfigurationsPayload<ExtArgs>
        fields: Prisma.ConfigurationsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.ConfigurationsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.ConfigurationsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          findFirst: {
            args: Prisma.ConfigurationsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.ConfigurationsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          findMany: {
            args: Prisma.ConfigurationsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>[]
          }
          create: {
            args: Prisma.ConfigurationsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          createMany: {
            args: Prisma.ConfigurationsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.ConfigurationsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>[]
          }
          delete: {
            args: Prisma.ConfigurationsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          update: {
            args: Prisma.ConfigurationsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          deleteMany: {
            args: Prisma.ConfigurationsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.ConfigurationsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.ConfigurationsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$ConfigurationsPayload>
          }
          aggregate: {
            args: Prisma.ConfigurationsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateConfigurations>
          }
          groupBy: {
            args: Prisma.ConfigurationsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<ConfigurationsGroupByOutputType>[]
          }
          count: {
            args: Prisma.ConfigurationsCountArgs<ExtArgs>,
            result: $Utils.Optional<ConfigurationsCountAggregateOutputType> | number
          }
        }
      }
      menuType: {
        payload: Prisma.$menuTypePayload<ExtArgs>
        fields: Prisma.menuTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.menuTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.menuTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          findFirst: {
            args: Prisma.menuTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.menuTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          findMany: {
            args: Prisma.menuTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>[]
          }
          create: {
            args: Prisma.menuTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          createMany: {
            args: Prisma.menuTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.menuTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>[]
          }
          delete: {
            args: Prisma.menuTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          update: {
            args: Prisma.menuTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          deleteMany: {
            args: Prisma.menuTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.menuTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.menuTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$menuTypePayload>
          }
          aggregate: {
            args: Prisma.MenuTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMenuType>
          }
          groupBy: {
            args: Prisma.menuTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MenuTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.menuTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<MenuTypeCountAggregateOutputType> | number
          }
        }
      }
      Menus: {
        payload: Prisma.$MenusPayload<ExtArgs>
        fields: Prisma.MenusFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MenusFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MenusFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          findFirst: {
            args: Prisma.MenusFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MenusFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          findMany: {
            args: Prisma.MenusFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>[]
          }
          create: {
            args: Prisma.MenusCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          createMany: {
            args: Prisma.MenusCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MenusCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>[]
          }
          delete: {
            args: Prisma.MenusDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          update: {
            args: Prisma.MenusUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          deleteMany: {
            args: Prisma.MenusDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MenusUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MenusUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenusPayload>
          }
          aggregate: {
            args: Prisma.MenusAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMenus>
          }
          groupBy: {
            args: Prisma.MenusGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MenusGroupByOutputType>[]
          }
          count: {
            args: Prisma.MenusCountArgs<ExtArgs>,
            result: $Utils.Optional<MenusCountAggregateOutputType> | number
          }
        }
      }
      WizardGroup: {
        payload: Prisma.$WizardGroupPayload<ExtArgs>
        fields: Prisma.WizardGroupFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WizardGroupFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WizardGroupFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          findFirst: {
            args: Prisma.WizardGroupFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WizardGroupFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          findMany: {
            args: Prisma.WizardGroupFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>[]
          }
          create: {
            args: Prisma.WizardGroupCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          createMany: {
            args: Prisma.WizardGroupCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WizardGroupCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>[]
          }
          delete: {
            args: Prisma.WizardGroupDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          update: {
            args: Prisma.WizardGroupUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          deleteMany: {
            args: Prisma.WizardGroupDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WizardGroupUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WizardGroupUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardGroupPayload>
          }
          aggregate: {
            args: Prisma.WizardGroupAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWizardGroup>
          }
          groupBy: {
            args: Prisma.WizardGroupGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WizardGroupGroupByOutputType>[]
          }
          count: {
            args: Prisma.WizardGroupCountArgs<ExtArgs>,
            result: $Utils.Optional<WizardGroupCountAggregateOutputType> | number
          }
        }
      }
      WizardType: {
        payload: Prisma.$WizardTypePayload<ExtArgs>
        fields: Prisma.WizardTypeFieldRefs
        operations: {
          findUnique: {
            args: Prisma.WizardTypeFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.WizardTypeFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          findFirst: {
            args: Prisma.WizardTypeFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.WizardTypeFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          findMany: {
            args: Prisma.WizardTypeFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>[]
          }
          create: {
            args: Prisma.WizardTypeCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          createMany: {
            args: Prisma.WizardTypeCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.WizardTypeCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>[]
          }
          delete: {
            args: Prisma.WizardTypeDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          update: {
            args: Prisma.WizardTypeUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          deleteMany: {
            args: Prisma.WizardTypeDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.WizardTypeUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.WizardTypeUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$WizardTypePayload>
          }
          aggregate: {
            args: Prisma.WizardTypeAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateWizardType>
          }
          groupBy: {
            args: Prisma.WizardTypeGroupByArgs<ExtArgs>,
            result: $Utils.Optional<WizardTypeGroupByOutputType>[]
          }
          count: {
            args: Prisma.WizardTypeCountArgs<ExtArgs>,
            result: $Utils.Optional<WizardTypeCountAggregateOutputType> | number
          }
        }
      }
      MasterEntity: {
        payload: Prisma.$MasterEntityPayload<ExtArgs>
        fields: Prisma.MasterEntityFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MasterEntityFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MasterEntityFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          findFirst: {
            args: Prisma.MasterEntityFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MasterEntityFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          findMany: {
            args: Prisma.MasterEntityFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>[]
          }
          create: {
            args: Prisma.MasterEntityCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          createMany: {
            args: Prisma.MasterEntityCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MasterEntityCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>[]
          }
          delete: {
            args: Prisma.MasterEntityDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          update: {
            args: Prisma.MasterEntityUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          deleteMany: {
            args: Prisma.MasterEntityDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MasterEntityUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MasterEntityUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityPayload>
          }
          aggregate: {
            args: Prisma.MasterEntityAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMasterEntity>
          }
          groupBy: {
            args: Prisma.MasterEntityGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityGroupByOutputType>[]
          }
          count: {
            args: Prisma.MasterEntityCountArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityCountAggregateOutputType> | number
          }
        }
      }
      MasterEntityLineItem: {
        payload: Prisma.$MasterEntityLineItemPayload<ExtArgs>
        fields: Prisma.MasterEntityLineItemFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MasterEntityLineItemFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MasterEntityLineItemFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          findFirst: {
            args: Prisma.MasterEntityLineItemFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MasterEntityLineItemFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          findMany: {
            args: Prisma.MasterEntityLineItemFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>[]
          }
          create: {
            args: Prisma.MasterEntityLineItemCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          createMany: {
            args: Prisma.MasterEntityLineItemCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MasterEntityLineItemCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>[]
          }
          delete: {
            args: Prisma.MasterEntityLineItemDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          update: {
            args: Prisma.MasterEntityLineItemUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          deleteMany: {
            args: Prisma.MasterEntityLineItemDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MasterEntityLineItemUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MasterEntityLineItemUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MasterEntityLineItemPayload>
          }
          aggregate: {
            args: Prisma.MasterEntityLineItemAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMasterEntityLineItem>
          }
          groupBy: {
            args: Prisma.MasterEntityLineItemGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityLineItemGroupByOutputType>[]
          }
          count: {
            args: Prisma.MasterEntityLineItemCountArgs<ExtArgs>,
            result: $Utils.Optional<MasterEntityLineItemCountAggregateOutputType> | number
          }
        }
      }
      Permissions: {
        payload: Prisma.$PermissionsPayload<ExtArgs>
        fields: Prisma.PermissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.PermissionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.PermissionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          findFirst: {
            args: Prisma.PermissionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.PermissionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          findMany: {
            args: Prisma.PermissionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>[]
          }
          create: {
            args: Prisma.PermissionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          createMany: {
            args: Prisma.PermissionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.PermissionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>[]
          }
          delete: {
            args: Prisma.PermissionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          update: {
            args: Prisma.PermissionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          deleteMany: {
            args: Prisma.PermissionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.PermissionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.PermissionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$PermissionsPayload>
          }
          aggregate: {
            args: Prisma.PermissionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregatePermissions>
          }
          groupBy: {
            args: Prisma.PermissionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<PermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.PermissionsCountArgs<ExtArgs>,
            result: $Utils.Optional<PermissionsCountAggregateOutputType> | number
          }
        }
      }
      MenuItems: {
        payload: Prisma.$MenuItemsPayload<ExtArgs>
        fields: Prisma.MenuItemsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.MenuItemsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.MenuItemsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          findFirst: {
            args: Prisma.MenuItemsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.MenuItemsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          findMany: {
            args: Prisma.MenuItemsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>[]
          }
          create: {
            args: Prisma.MenuItemsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          createMany: {
            args: Prisma.MenuItemsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.MenuItemsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>[]
          }
          delete: {
            args: Prisma.MenuItemsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          update: {
            args: Prisma.MenuItemsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          deleteMany: {
            args: Prisma.MenuItemsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.MenuItemsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.MenuItemsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$MenuItemsPayload>
          }
          aggregate: {
            args: Prisma.MenuItemsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateMenuItems>
          }
          groupBy: {
            args: Prisma.MenuItemsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<MenuItemsGroupByOutputType>[]
          }
          count: {
            args: Prisma.MenuItemsCountArgs<ExtArgs>,
            result: $Utils.Optional<MenuItemsCountAggregateOutputType> | number
          }
        }
      }
      UserPermissions: {
        payload: Prisma.$UserPermissionsPayload<ExtArgs>
        fields: Prisma.UserPermissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.UserPermissionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.UserPermissionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          findFirst: {
            args: Prisma.UserPermissionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.UserPermissionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          findMany: {
            args: Prisma.UserPermissionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>[]
          }
          create: {
            args: Prisma.UserPermissionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          createMany: {
            args: Prisma.UserPermissionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.UserPermissionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>[]
          }
          delete: {
            args: Prisma.UserPermissionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          update: {
            args: Prisma.UserPermissionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          deleteMany: {
            args: Prisma.UserPermissionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.UserPermissionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.UserPermissionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$UserPermissionsPayload>
          }
          aggregate: {
            args: Prisma.UserPermissionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateUserPermissions>
          }
          groupBy: {
            args: Prisma.UserPermissionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<UserPermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.UserPermissionsCountArgs<ExtArgs>,
            result: $Utils.Optional<UserPermissionsCountAggregateOutputType> | number
          }
        }
      }
      RolePermissions: {
        payload: Prisma.$RolePermissionsPayload<ExtArgs>
        fields: Prisma.RolePermissionsFieldRefs
        operations: {
          findUnique: {
            args: Prisma.RolePermissionsFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.RolePermissionsFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          findFirst: {
            args: Prisma.RolePermissionsFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.RolePermissionsFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          findMany: {
            args: Prisma.RolePermissionsFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>[]
          }
          create: {
            args: Prisma.RolePermissionsCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          createMany: {
            args: Prisma.RolePermissionsCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.RolePermissionsCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>[]
          }
          delete: {
            args: Prisma.RolePermissionsDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          update: {
            args: Prisma.RolePermissionsUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          deleteMany: {
            args: Prisma.RolePermissionsDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.RolePermissionsUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.RolePermissionsUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$RolePermissionsPayload>
          }
          aggregate: {
            args: Prisma.RolePermissionsAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateRolePermissions>
          }
          groupBy: {
            args: Prisma.RolePermissionsGroupByArgs<ExtArgs>,
            result: $Utils.Optional<RolePermissionsGroupByOutputType>[]
          }
          count: {
            args: Prisma.RolePermissionsCountArgs<ExtArgs>,
            result: $Utils.Optional<RolePermissionsCountAggregateOutputType> | number
          }
        }
      }
      Language: {
        payload: Prisma.$LanguagePayload<ExtArgs>
        fields: Prisma.LanguageFieldRefs
        operations: {
          findUnique: {
            args: Prisma.LanguageFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.LanguageFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          findFirst: {
            args: Prisma.LanguageFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.LanguageFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          findMany: {
            args: Prisma.LanguageFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>[]
          }
          create: {
            args: Prisma.LanguageCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          createMany: {
            args: Prisma.LanguageCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.LanguageCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>[]
          }
          delete: {
            args: Prisma.LanguageDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          update: {
            args: Prisma.LanguageUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          deleteMany: {
            args: Prisma.LanguageDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.LanguageUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.LanguageUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguagePayload>
          }
          aggregate: {
            args: Prisma.LanguageAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateLanguage>
          }
          groupBy: {
            args: Prisma.LanguageGroupByArgs<ExtArgs>,
            result: $Utils.Optional<LanguageGroupByOutputType>[]
          }
          count: {
            args: Prisma.LanguageCountArgs<ExtArgs>,
            result: $Utils.Optional<LanguageCountAggregateOutputType> | number
          }
        }
      }
      LanguageContent: {
        payload: Prisma.$LanguageContentPayload<ExtArgs>
        fields: Prisma.LanguageContentFieldRefs
        operations: {
          findUnique: {
            args: Prisma.LanguageContentFindUniqueArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload> | null
          }
          findUniqueOrThrow: {
            args: Prisma.LanguageContentFindUniqueOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          findFirst: {
            args: Prisma.LanguageContentFindFirstArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload> | null
          }
          findFirstOrThrow: {
            args: Prisma.LanguageContentFindFirstOrThrowArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          findMany: {
            args: Prisma.LanguageContentFindManyArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>[]
          }
          create: {
            args: Prisma.LanguageContentCreateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          createMany: {
            args: Prisma.LanguageContentCreateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          createManyAndReturn: {
            args: Prisma.LanguageContentCreateManyAndReturnArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>[]
          }
          delete: {
            args: Prisma.LanguageContentDeleteArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          update: {
            args: Prisma.LanguageContentUpdateArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          deleteMany: {
            args: Prisma.LanguageContentDeleteManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          updateMany: {
            args: Prisma.LanguageContentUpdateManyArgs<ExtArgs>,
            result: Prisma.BatchPayload
          }
          upsert: {
            args: Prisma.LanguageContentUpsertArgs<ExtArgs>,
            result: $Utils.PayloadToResult<Prisma.$LanguageContentPayload>
          }
          aggregate: {
            args: Prisma.LanguageContentAggregateArgs<ExtArgs>,
            result: $Utils.Optional<AggregateLanguageContent>
          }
          groupBy: {
            args: Prisma.LanguageContentGroupByArgs<ExtArgs>,
            result: $Utils.Optional<LanguageContentGroupByOutputType>[]
          }
          count: {
            args: Prisma.LanguageContentCountArgs<ExtArgs>,
            result: $Utils.Optional<LanguageContentCountAggregateOutputType> | number
          }
        }
      }
    }
  } & {
    other: {
      payload: any
      operations: {
        $executeRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $executeRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
        $queryRawUnsafe: {
          args: [query: string, ...values: any[]],
          result: any
        }
        $queryRaw: {
          args: [query: TemplateStringsArray | Prisma.Sql, ...values: any[]],
          result: any
        }
      }
    }
  }
  export const defineExtension: $Extensions.ExtendsHook<'define', Prisma.TypeMapCb, $Extensions.DefaultArgs>
  export type DefaultPrismaClient = PrismaClient
  export type ErrorFormat = 'pretty' | 'colorless' | 'minimal'
  export interface PrismaClientOptions {
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasources?: Datasources
    /**
     * Overwrites the datasource url from your schema.prisma file
     */
    datasourceUrl?: string
    /**
     * @default "colorless"
     */
    errorFormat?: ErrorFormat
    /**
     * @example
     * ```
     * // Defaults to stdout
     * log: ['query', 'info', 'warn', 'error']
     * 
     * // Emit as events
     * log: [
     *   { emit: 'stdout', level: 'query' },
     *   { emit: 'stdout', level: 'info' },
     *   { emit: 'stdout', level: 'warn' }
     *   { emit: 'stdout', level: 'error' }
     * ]
     * ```
     * Read more in our [docs](https://www.prisma.io/docs/reference/tools-and-interfaces/prisma-client/logging#the-log-option).
     */
    log?: (LogLevel | LogDefinition)[]
    /**
     * The default values for transactionOptions
     * maxWait ?= 2000
     * timeout ?= 5000
     */
    transactionOptions?: {
      maxWait?: number
      timeout?: number
      isolationLevel?: Prisma.TransactionIsolationLevel
    }
  }

  /* Types for Logging */
  export type LogLevel = 'info' | 'query' | 'warn' | 'error'
  export type LogDefinition = {
    level: LogLevel
    emit: 'stdout' | 'event'
  }

  export type GetLogType<T extends LogLevel | LogDefinition> = T extends LogDefinition ? T['emit'] extends 'event' ? T['level'] : never : never
  export type GetEvents<T extends any> = T extends Array<LogLevel | LogDefinition> ?
    GetLogType<T[0]> | GetLogType<T[1]> | GetLogType<T[2]> | GetLogType<T[3]>
    : never

  export type QueryEvent = {
    timestamp: Date
    query: string
    params: string
    duration: number
    target: string
  }

  export type LogEvent = {
    timestamp: Date
    message: string
    target: string
  }
  /* End Types for Logging */


  export type PrismaAction =
    | 'findUnique'
    | 'findUniqueOrThrow'
    | 'findMany'
    | 'findFirst'
    | 'findFirstOrThrow'
    | 'create'
    | 'createMany'
    | 'createManyAndReturn'
    | 'update'
    | 'updateMany'
    | 'upsert'
    | 'delete'
    | 'deleteMany'
    | 'executeRaw'
    | 'queryRaw'
    | 'aggregate'
    | 'count'
    | 'runCommandRaw'
    | 'findRaw'
    | 'groupBy'

  /**
   * These options are being passed into the middleware as "params"
   */
  export type MiddlewareParams = {
    model?: ModelName
    action: PrismaAction
    args: any
    dataPath: string[]
    runInTransaction: boolean
  }

  /**
   * The `T` type makes sure, that the `return proceed` is not forgotten in the middleware implementation
   */
  export type Middleware<T = any> = (
    params: MiddlewareParams,
    next: (params: MiddlewareParams) => $Utils.JsPromise<T>,
  ) => $Utils.JsPromise<T>

  // tested in getLogLevel.test.ts
  export function getLogLevel(log: Array<LogLevel | LogDefinition>): LogLevel | undefined;

  /**
   * `PrismaClient` proxy available in interactive transactions.
   */
  export type TransactionClient = Omit<Prisma.DefaultPrismaClient, runtime.ITXClientDenyList>

  export type Datasource = {
    url?: string
  }

  /**
   * Count Types
   */


  /**
   * Count Type StatusCountOutputType
   */

  export type StatusCountOutputType = {
    users: number
    permissions: number
    roles: number
    menus: number
    menuitems: number
    master_entities: number
    master_entity_line_items: number
    field_types: number
    Designation: number
    Department: number
    MenuType: number
    languages: number
    language_contents: number
  }

  export type StatusCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | StatusCountOutputTypeCountUsersArgs
    permissions?: boolean | StatusCountOutputTypeCountPermissionsArgs
    roles?: boolean | StatusCountOutputTypeCountRolesArgs
    menus?: boolean | StatusCountOutputTypeCountMenusArgs
    menuitems?: boolean | StatusCountOutputTypeCountMenuitemsArgs
    master_entities?: boolean | StatusCountOutputTypeCountMaster_entitiesArgs
    master_entity_line_items?: boolean | StatusCountOutputTypeCountMaster_entity_line_itemsArgs
    field_types?: boolean | StatusCountOutputTypeCountField_typesArgs
    Designation?: boolean | StatusCountOutputTypeCountDesignationArgs
    Department?: boolean | StatusCountOutputTypeCountDepartmentArgs
    MenuType?: boolean | StatusCountOutputTypeCountMenuTypeArgs
    languages?: boolean | StatusCountOutputTypeCountLanguagesArgs
    language_contents?: boolean | StatusCountOutputTypeCountLanguage_contentsArgs
  }

  // Custom InputTypes
  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the StatusCountOutputType
     */
    select?: StatusCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PermissionsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMenusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenusWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMenuitemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMaster_entitiesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMaster_entity_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountField_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FieldTypeWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDesignationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountDepartmentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountMenuTypeArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: menuTypeWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountLanguagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * StatusCountOutputType without action
   */
  export type StatusCountOutputTypeCountLanguage_contentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageContentWhereInput
  }


  /**
   * Count Type FieldTypeCountOutputType
   */

  export type FieldTypeCountOutputType = {
    master_grid_lineitem: number
  }

  export type FieldTypeCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    master_grid_lineitem?: boolean | FieldTypeCountOutputTypeCountMaster_grid_lineitemArgs
  }

  // Custom InputTypes
  /**
   * FieldTypeCountOutputType without action
   */
  export type FieldTypeCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldTypeCountOutputType
     */
    select?: FieldTypeCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * FieldTypeCountOutputType without action
   */
  export type FieldTypeCountOutputTypeCountMaster_grid_lineitemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
  }


  /**
   * Count Type RoleCountOutputType
   */

  export type RoleCountOutputType = {
    permissions: number
    users: number
  }

  export type RoleCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permissions?: boolean | RoleCountOutputTypeCountPermissionsArgs
    users?: boolean | RoleCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RoleCountOutputType
     */
    select?: RoleCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePermissionsWhereInput
  }

  /**
   * RoleCountOutputType without action
   */
  export type RoleCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRolesWhereInput
  }


  /**
   * Count Type DepartmentCountOutputType
   */

  export type DepartmentCountOutputType = {
    users: number
  }

  export type DepartmentCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | DepartmentCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * DepartmentCountOutputType without action
   */
  export type DepartmentCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DepartmentCountOutputType
     */
    select?: DepartmentCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * DepartmentCountOutputType without action
   */
  export type DepartmentCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }


  /**
   * Count Type DesignationCountOutputType
   */

  export type DesignationCountOutputType = {
    users: number
  }

  export type DesignationCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | DesignationCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * DesignationCountOutputType without action
   */
  export type DesignationCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the DesignationCountOutputType
     */
    select?: DesignationCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * DesignationCountOutputType without action
   */
  export type DesignationCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }


  /**
   * Count Type UserCountOutputType
   */

  export type UserCountOutputType = {
    permissions: number
    roles: number
    created_users: number
    updated_users: number
    deleted_users: number
    created_user_details: number
    updated_user_details: number
    deleted_user_details: number
    created_languages: number
    updated_languages: number
    deleted_languages: number
  }

  export type UserCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permissions?: boolean | UserCountOutputTypeCountPermissionsArgs
    roles?: boolean | UserCountOutputTypeCountRolesArgs
    created_users?: boolean | UserCountOutputTypeCountCreated_usersArgs
    updated_users?: boolean | UserCountOutputTypeCountUpdated_usersArgs
    deleted_users?: boolean | UserCountOutputTypeCountDeleted_usersArgs
    created_user_details?: boolean | UserCountOutputTypeCountCreated_user_detailsArgs
    updated_user_details?: boolean | UserCountOutputTypeCountUpdated_user_detailsArgs
    deleted_user_details?: boolean | UserCountOutputTypeCountDeleted_user_detailsArgs
    created_languages?: boolean | UserCountOutputTypeCountCreated_languagesArgs
    updated_languages?: boolean | UserCountOutputTypeCountUpdated_languagesArgs
    deleted_languages?: boolean | UserCountOutputTypeCountDeleted_languagesArgs
  }

  // Custom InputTypes
  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserCountOutputType
     */
    select?: UserCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPermissionsWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRolesWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountCreated_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountUpdated_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }

  /**
   * UserCountOutputType without action
   */
  export type UserCountOutputTypeCountDeleted_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
  }


  /**
   * Count Type CategoryTypesCountOutputType
   */

  export type CategoryTypesCountOutputType = {
    categories: number
  }

  export type CategoryTypesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    categories?: boolean | CategoryTypesCountOutputTypeCountCategoriesArgs
  }

  // Custom InputTypes
  /**
   * CategoryTypesCountOutputType without action
   */
  export type CategoryTypesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypesCountOutputType
     */
    select?: CategoryTypesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoryTypesCountOutputType without action
   */
  export type CategoryTypesCountOutputTypeCountCategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }


  /**
   * Count Type CategoriesCountOutputType
   */

  export type CategoriesCountOutputType = {
    subcategories: number
    configurations: number
  }

  export type CategoriesCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    subcategories?: boolean | CategoriesCountOutputTypeCountSubcategoriesArgs
    configurations?: boolean | CategoriesCountOutputTypeCountConfigurationsArgs
  }

  // Custom InputTypes
  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoriesCountOutputType
     */
    select?: CategoriesCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeCountSubcategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
  }

  /**
   * CategoriesCountOutputType without action
   */
  export type CategoriesCountOutputTypeCountConfigurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ConfigurationsWhereInput
  }


  /**
   * Count Type MasterEntityCountOutputType
   */

  export type MasterEntityCountOutputType = {
    permissions: number
    line_items: number
  }

  export type MasterEntityCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    permissions?: boolean | MasterEntityCountOutputTypeCountPermissionsArgs
    line_items?: boolean | MasterEntityCountOutputTypeCountLine_itemsArgs
  }

  // Custom InputTypes
  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityCountOutputType
     */
    select?: MasterEntityCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeCountPermissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PermissionsWhereInput
  }

  /**
   * MasterEntityCountOutputType without action
   */
  export type MasterEntityCountOutputTypeCountLine_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
  }


  /**
   * Count Type PermissionsCountOutputType
   */

  export type PermissionsCountOutputType = {
    roles: number
    users: number
  }

  export type PermissionsCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    roles?: boolean | PermissionsCountOutputTypeCountRolesArgs
    users?: boolean | PermissionsCountOutputTypeCountUsersArgs
  }

  // Custom InputTypes
  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the PermissionsCountOutputType
     */
    select?: PermissionsCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeCountRolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePermissionsWhereInput
  }

  /**
   * PermissionsCountOutputType without action
   */
  export type PermissionsCountOutputTypeCountUsersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPermissionsWhereInput
  }


  /**
   * Count Type LanguageCountOutputType
   */

  export type LanguageCountOutputType = {
    translations: number
  }

  export type LanguageCountOutputTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    translations?: boolean | LanguageCountOutputTypeCountTranslationsArgs
  }

  // Custom InputTypes
  /**
   * LanguageCountOutputType without action
   */
  export type LanguageCountOutputTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageCountOutputType
     */
    select?: LanguageCountOutputTypeSelect<ExtArgs> | null
  }

  /**
   * LanguageCountOutputType without action
   */
  export type LanguageCountOutputTypeCountTranslationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageContentWhereInput
  }


  /**
   * Models
   */

  /**
   * Model Status
   */

  export type AggregateStatus = {
    _count: StatusCountAggregateOutputType | null
    _avg: StatusAvgAggregateOutputType | null
    _sum: StatusSumAggregateOutputType | null
    _min: StatusMinAggregateOutputType | null
    _max: StatusMaxAggregateOutputType | null
  }

  export type StatusAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    transfer_status: number | null
  }

  export type StatusSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    transfer_status: number | null
  }

  export type StatusMinAggregateOutputType = {
    id: number | null
    name: string | null
    slug: string | null
    description: string | null
    status_id: number | null
    transfer_status: number | null
  }

  export type StatusMaxAggregateOutputType = {
    id: number | null
    name: string | null
    slug: string | null
    description: string | null
    status_id: number | null
    transfer_status: number | null
  }

  export type StatusCountAggregateOutputType = {
    id: number
    name: number
    slug: number
    description: number
    status_id: number
    transfer_status: number
    _all: number
  }


  export type StatusAvgAggregateInputType = {
    id?: true
    status_id?: true
    transfer_status?: true
  }

  export type StatusSumAggregateInputType = {
    id?: true
    status_id?: true
    transfer_status?: true
  }

  export type StatusMinAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    description?: true
    status_id?: true
    transfer_status?: true
  }

  export type StatusMaxAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    description?: true
    status_id?: true
    transfer_status?: true
  }

  export type StatusCountAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    description?: true
    status_id?: true
    transfer_status?: true
    _all?: true
  }

  export type StatusAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Status to aggregate.
     */
    where?: StatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Statuses to fetch.
     */
    orderBy?: StatusOrderByWithRelationInput | StatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: StatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Statuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Statuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Statuses
    **/
    _count?: true | StatusCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: StatusAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: StatusSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: StatusMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: StatusMaxAggregateInputType
  }

  export type GetStatusAggregateType<T extends StatusAggregateArgs> = {
        [P in keyof T & keyof AggregateStatus]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateStatus[P]>
      : GetScalarType<T[P], AggregateStatus[P]>
  }




  export type StatusGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: StatusWhereInput
    orderBy?: StatusOrderByWithAggregationInput | StatusOrderByWithAggregationInput[]
    by: StatusScalarFieldEnum[] | StatusScalarFieldEnum
    having?: StatusScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: StatusCountAggregateInputType | true
    _avg?: StatusAvgAggregateInputType
    _sum?: StatusSumAggregateInputType
    _min?: StatusMinAggregateInputType
    _max?: StatusMaxAggregateInputType
  }

  export type StatusGroupByOutputType = {
    id: number
    name: string
    slug: string
    description: string | null
    status_id: number | null
    transfer_status: number | null
    _count: StatusCountAggregateOutputType | null
    _avg: StatusAvgAggregateOutputType | null
    _sum: StatusSumAggregateOutputType | null
    _min: StatusMinAggregateOutputType | null
    _max: StatusMaxAggregateOutputType | null
  }

  type GetStatusGroupByPayload<T extends StatusGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<StatusGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof StatusGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], StatusGroupByOutputType[P]>
            : GetScalarType<T[P], StatusGroupByOutputType[P]>
        }
      >
    >


  export type StatusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    slug?: boolean
    description?: boolean
    status_id?: boolean
    transfer_status?: boolean
    users?: boolean | Status$usersArgs<ExtArgs>
    permissions?: boolean | Status$permissionsArgs<ExtArgs>
    roles?: boolean | Status$rolesArgs<ExtArgs>
    menus?: boolean | Status$menusArgs<ExtArgs>
    menuitems?: boolean | Status$menuitemsArgs<ExtArgs>
    master_entities?: boolean | Status$master_entitiesArgs<ExtArgs>
    master_entity_line_items?: boolean | Status$master_entity_line_itemsArgs<ExtArgs>
    field_types?: boolean | Status$field_typesArgs<ExtArgs>
    Designation?: boolean | Status$DesignationArgs<ExtArgs>
    Department?: boolean | Status$DepartmentArgs<ExtArgs>
    MenuType?: boolean | Status$MenuTypeArgs<ExtArgs>
    languages?: boolean | Status$languagesArgs<ExtArgs>
    language_contents?: boolean | Status$language_contentsArgs<ExtArgs>
    _count?: boolean | StatusCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["status"]>

  export type StatusSelectScalar = {
    id?: boolean
    name?: boolean
    slug?: boolean
    description?: boolean
    status_id?: boolean
    transfer_status?: boolean
  }


  export type StatusInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    users?: boolean | Status$usersArgs<ExtArgs>
    permissions?: boolean | Status$permissionsArgs<ExtArgs>
    roles?: boolean | Status$rolesArgs<ExtArgs>
    menus?: boolean | Status$menusArgs<ExtArgs>
    menuitems?: boolean | Status$menuitemsArgs<ExtArgs>
    master_entities?: boolean | Status$master_entitiesArgs<ExtArgs>
    master_entity_line_items?: boolean | Status$master_entity_line_itemsArgs<ExtArgs>
    field_types?: boolean | Status$field_typesArgs<ExtArgs>
    Designation?: boolean | Status$DesignationArgs<ExtArgs>
    Department?: boolean | Status$DepartmentArgs<ExtArgs>
    MenuType?: boolean | Status$MenuTypeArgs<ExtArgs>
    languages?: boolean | Status$languagesArgs<ExtArgs>
    language_contents?: boolean | Status$language_contentsArgs<ExtArgs>
    _count?: boolean | StatusCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $StatusPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Status"
    objects: {
      users: Prisma.$UserPayload<ExtArgs>[]
      permissions: Prisma.$PermissionsPayload<ExtArgs>[]
      roles: Prisma.$RolePayload<ExtArgs>[]
      menus: Prisma.$MenusPayload<ExtArgs>[]
      menuitems: Prisma.$MenuItemsPayload<ExtArgs>[]
      master_entities: Prisma.$MasterEntityPayload<ExtArgs>[]
      master_entity_line_items: Prisma.$MasterEntityLineItemPayload<ExtArgs>[]
      field_types: Prisma.$FieldTypePayload<ExtArgs>[]
      Designation: Prisma.$DesignationPayload<ExtArgs>[]
      Department: Prisma.$DepartmentPayload<ExtArgs>[]
      MenuType: Prisma.$menuTypePayload<ExtArgs>[]
      languages: Prisma.$LanguagePayload<ExtArgs>[]
      language_contents: Prisma.$LanguageContentPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      slug: string
      description: string | null
      status_id: number | null
      transfer_status: number | null
    }, ExtArgs["result"]["status"]>
    composites: {}
  }


  type StatusGetPayload<S extends boolean | null | undefined | StatusDefaultArgs> = $Result.GetResult<Prisma.$StatusPayload, S>

  type StatusCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<StatusFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: StatusCountAggregateInputType | true
    }

  export interface StatusDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Status'], meta: { name: 'Status' } }
    /**
     * Find zero or one Status that matches the filter.
     * @param {StatusFindUniqueArgs} args - Arguments to find a Status
     * @example
     * // Get one Status
     * const status = await prisma.status.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends StatusFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, StatusFindUniqueArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Status that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {StatusFindUniqueOrThrowArgs} args - Arguments to find a Status
     * @example
     * // Get one Status
     * const status = await prisma.status.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends StatusFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Status that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusFindFirstArgs} args - Arguments to find a Status
     * @example
     * // Get one Status
     * const status = await prisma.status.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends StatusFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusFindFirstArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Status that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusFindFirstOrThrowArgs} args - Arguments to find a Status
     * @example
     * // Get one Status
     * const status = await prisma.status.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends StatusFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Statuses that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Statuses
     * const statuses = await prisma.status.findMany()
     * 
     * // Get first 10 Statuses
     * const statuses = await prisma.status.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const statusWithIdOnly = await prisma.status.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends StatusFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Status.
     * @param {StatusCreateArgs} args - Arguments to create a Status.
     * @example
     * // Create one Status
     * const Status = await prisma.status.create({
     *   data: {
     *     // ... data to create a Status
     *   }
     * })
     * 
    **/
    create<T extends StatusCreateArgs<ExtArgs>>(
      args: SelectSubset<T, StatusCreateArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Statuses.
     * @param {StatusCreateManyArgs} args - Arguments to create many Statuses.
     * @example
     * // Create many Statuses
     * const status = await prisma.status.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends StatusCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Statuses and returns the data saved in the database.
     * @param {StatusCreateManyAndReturnArgs} args - Arguments to create many Statuses.
     * @example
     * // Create many Statuses
     * const status = await prisma.status.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Statuses and only return the `id`
     * const statusWithIdOnly = await prisma.status.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends StatusCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Status.
     * @param {StatusDeleteArgs} args - Arguments to delete one Status.
     * @example
     * // Delete one Status
     * const Status = await prisma.status.delete({
     *   where: {
     *     // ... filter to delete one Status
     *   }
     * })
     * 
    **/
    delete<T extends StatusDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, StatusDeleteArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Status.
     * @param {StatusUpdateArgs} args - Arguments to update one Status.
     * @example
     * // Update one Status
     * const status = await prisma.status.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends StatusUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, StatusUpdateArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Statuses.
     * @param {StatusDeleteManyArgs} args - Arguments to filter Statuses to delete.
     * @example
     * // Delete a few Statuses
     * const { count } = await prisma.status.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends StatusDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, StatusDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Statuses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Statuses
     * const status = await prisma.status.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends StatusUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, StatusUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Status.
     * @param {StatusUpsertArgs} args - Arguments to update or create a Status.
     * @example
     * // Update or create a Status
     * const status = await prisma.status.upsert({
     *   create: {
     *     // ... data to create a Status
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Status we want to update
     *   }
     * })
    **/
    upsert<T extends StatusUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, StatusUpsertArgs<ExtArgs>>
    ): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Statuses.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusCountArgs} args - Arguments to filter Statuses to count.
     * @example
     * // Count the number of Statuses
     * const count = await prisma.status.count({
     *   where: {
     *     // ... the filter for the Statuses we want to count
     *   }
     * })
    **/
    count<T extends StatusCountArgs>(
      args?: Subset<T, StatusCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], StatusCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Status.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends StatusAggregateArgs>(args: Subset<T, StatusAggregateArgs>): Prisma.PrismaPromise<GetStatusAggregateType<T>>

    /**
     * Group by Status.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {StatusGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends StatusGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: StatusGroupByArgs['orderBy'] }
        : { orderBy?: StatusGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, StatusGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetStatusGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Status model
   */
  readonly fields: StatusFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Status.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__StatusClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    users<T extends Status$usersArgs<ExtArgs> = {}>(args?: Subset<T, Status$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    permissions<T extends Status$permissionsArgs<ExtArgs> = {}>(args?: Subset<T, Status$permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    roles<T extends Status$rolesArgs<ExtArgs> = {}>(args?: Subset<T, Status$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findMany'> | Null>;

    menus<T extends Status$menusArgs<ExtArgs> = {}>(args?: Subset<T, Status$menusArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findMany'> | Null>;

    menuitems<T extends Status$menuitemsArgs<ExtArgs> = {}>(args?: Subset<T, Status$menuitemsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findMany'> | Null>;

    master_entities<T extends Status$master_entitiesArgs<ExtArgs> = {}>(args?: Subset<T, Status$master_entitiesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findMany'> | Null>;

    master_entity_line_items<T extends Status$master_entity_line_itemsArgs<ExtArgs> = {}>(args?: Subset<T, Status$master_entity_line_itemsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findMany'> | Null>;

    field_types<T extends Status$field_typesArgs<ExtArgs> = {}>(args?: Subset<T, Status$field_typesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findMany'> | Null>;

    Designation<T extends Status$DesignationArgs<ExtArgs> = {}>(args?: Subset<T, Status$DesignationArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findMany'> | Null>;

    Department<T extends Status$DepartmentArgs<ExtArgs> = {}>(args?: Subset<T, Status$DepartmentArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'> | Null>;

    MenuType<T extends Status$MenuTypeArgs<ExtArgs> = {}>(args?: Subset<T, Status$MenuTypeArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'findMany'> | Null>;

    languages<T extends Status$languagesArgs<ExtArgs> = {}>(args?: Subset<T, Status$languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    language_contents<T extends Status$language_contentsArgs<ExtArgs> = {}>(args?: Subset<T, Status$language_contentsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Status model
   */ 
  interface StatusFieldRefs {
    readonly id: FieldRef<"Status", 'Int'>
    readonly name: FieldRef<"Status", 'String'>
    readonly slug: FieldRef<"Status", 'String'>
    readonly description: FieldRef<"Status", 'String'>
    readonly status_id: FieldRef<"Status", 'Int'>
    readonly transfer_status: FieldRef<"Status", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Status findUnique
   */
  export type StatusFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * Filter, which Status to fetch.
     */
    where: StatusWhereUniqueInput
  }

  /**
   * Status findUniqueOrThrow
   */
  export type StatusFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * Filter, which Status to fetch.
     */
    where: StatusWhereUniqueInput
  }

  /**
   * Status findFirst
   */
  export type StatusFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * Filter, which Status to fetch.
     */
    where?: StatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Statuses to fetch.
     */
    orderBy?: StatusOrderByWithRelationInput | StatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Statuses.
     */
    cursor?: StatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Statuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Statuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Statuses.
     */
    distinct?: StatusScalarFieldEnum | StatusScalarFieldEnum[]
  }

  /**
   * Status findFirstOrThrow
   */
  export type StatusFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * Filter, which Status to fetch.
     */
    where?: StatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Statuses to fetch.
     */
    orderBy?: StatusOrderByWithRelationInput | StatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Statuses.
     */
    cursor?: StatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Statuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Statuses.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Statuses.
     */
    distinct?: StatusScalarFieldEnum | StatusScalarFieldEnum[]
  }

  /**
   * Status findMany
   */
  export type StatusFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * Filter, which Statuses to fetch.
     */
    where?: StatusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Statuses to fetch.
     */
    orderBy?: StatusOrderByWithRelationInput | StatusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Statuses.
     */
    cursor?: StatusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Statuses from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Statuses.
     */
    skip?: number
    distinct?: StatusScalarFieldEnum | StatusScalarFieldEnum[]
  }

  /**
   * Status create
   */
  export type StatusCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * The data needed to create a Status.
     */
    data: XOR<StatusCreateInput, StatusUncheckedCreateInput>
  }

  /**
   * Status createMany
   */
  export type StatusCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Statuses.
     */
    data: StatusCreateManyInput | StatusCreateManyInput[]
  }

  /**
   * Status createManyAndReturn
   */
  export type StatusCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * The data used to create many Statuses.
     */
    data: StatusCreateManyInput | StatusCreateManyInput[]
  }

  /**
   * Status update
   */
  export type StatusUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * The data needed to update a Status.
     */
    data: XOR<StatusUpdateInput, StatusUncheckedUpdateInput>
    /**
     * Choose, which Status to update.
     */
    where: StatusWhereUniqueInput
  }

  /**
   * Status updateMany
   */
  export type StatusUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Statuses.
     */
    data: XOR<StatusUpdateManyMutationInput, StatusUncheckedUpdateManyInput>
    /**
     * Filter which Statuses to update
     */
    where?: StatusWhereInput
  }

  /**
   * Status upsert
   */
  export type StatusUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * The filter to search for the Status to update in case it exists.
     */
    where: StatusWhereUniqueInput
    /**
     * In case the Status found by the `where` argument doesn't exist, create a new Status with this data.
     */
    create: XOR<StatusCreateInput, StatusUncheckedCreateInput>
    /**
     * In case the Status was found with the provided `where` argument, update it with this data.
     */
    update: XOR<StatusUpdateInput, StatusUncheckedUpdateInput>
  }

  /**
   * Status delete
   */
  export type StatusDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
    /**
     * Filter which Status to delete.
     */
    where: StatusWhereUniqueInput
  }

  /**
   * Status deleteMany
   */
  export type StatusDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Statuses to delete
     */
    where?: StatusWhereInput
  }

  /**
   * Status.users
   */
  export type Status$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * Status.permissions
   */
  export type Status$permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    where?: PermissionsWhereInput
    orderBy?: PermissionsOrderByWithRelationInput | PermissionsOrderByWithRelationInput[]
    cursor?: PermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Status.roles
   */
  export type Status$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    cursor?: RoleWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Status.menus
   */
  export type Status$menusArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    where?: MenusWhereInput
    orderBy?: MenusOrderByWithRelationInput | MenusOrderByWithRelationInput[]
    cursor?: MenusWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * Status.menuitems
   */
  export type Status$menuitemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    where?: MenuItemsWhereInput
    orderBy?: MenuItemsOrderByWithRelationInput | MenuItemsOrderByWithRelationInput[]
    cursor?: MenuItemsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * Status.master_entities
   */
  export type Status$master_entitiesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    where?: MasterEntityWhereInput
    orderBy?: MasterEntityOrderByWithRelationInput | MasterEntityOrderByWithRelationInput[]
    cursor?: MasterEntityWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MasterEntityScalarFieldEnum | MasterEntityScalarFieldEnum[]
  }

  /**
   * Status.master_entity_line_items
   */
  export type Status$master_entity_line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    where?: MasterEntityLineItemWhereInput
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    cursor?: MasterEntityLineItemWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MasterEntityLineItemScalarFieldEnum | MasterEntityLineItemScalarFieldEnum[]
  }

  /**
   * Status.field_types
   */
  export type Status$field_typesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    where?: FieldTypeWhereInput
    orderBy?: FieldTypeOrderByWithRelationInput | FieldTypeOrderByWithRelationInput[]
    cursor?: FieldTypeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: FieldTypeScalarFieldEnum | FieldTypeScalarFieldEnum[]
  }

  /**
   * Status.Designation
   */
  export type Status$DesignationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    where?: DesignationWhereInput
    orderBy?: DesignationOrderByWithRelationInput | DesignationOrderByWithRelationInput[]
    cursor?: DesignationWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Status.Department
   */
  export type Status$DepartmentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    cursor?: DepartmentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Status.MenuType
   */
  export type Status$MenuTypeArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    where?: menuTypeWhereInput
    orderBy?: menuTypeOrderByWithRelationInput | menuTypeOrderByWithRelationInput[]
    cursor?: menuTypeWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MenuTypeScalarFieldEnum | MenuTypeScalarFieldEnum[]
  }

  /**
   * Status.languages
   */
  export type Status$languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * Status.language_contents
   */
  export type Status$language_contentsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageContent
     */
    select?: LanguageContentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageContentInclude<ExtArgs> | null
    where?: LanguageContentWhereInput
    orderBy?: LanguageContentOrderByWithRelationInput | LanguageContentOrderByWithRelationInput[]
    cursor?: LanguageContentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageContentScalarFieldEnum | LanguageContentScalarFieldEnum[]
  }

  /**
   * Status without action
   */
  export type StatusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Status
     */
    select?: StatusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: StatusInclude<ExtArgs> | null
  }


  /**
   * Model FieldType
   */

  export type AggregateFieldType = {
    _count: FieldTypeCountAggregateOutputType | null
    _avg: FieldTypeAvgAggregateOutputType | null
    _sum: FieldTypeSumAggregateOutputType | null
    _min: FieldTypeMinAggregateOutputType | null
    _max: FieldTypeMaxAggregateOutputType | null
  }

  export type FieldTypeAvgAggregateOutputType = {
    id: number | null
    company_id: number | null
    status_id: number | null
    transfer_status: number | null
  }

  export type FieldTypeSumAggregateOutputType = {
    id: number | null
    company_id: number | null
    status_id: number | null
    transfer_status: number | null
  }

  export type FieldTypeMinAggregateOutputType = {
    id: number | null
    field_type: string | null
    company_id: number | null
    status_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type FieldTypeMaxAggregateOutputType = {
    id: number | null
    field_type: string | null
    company_id: number | null
    status_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type FieldTypeCountAggregateOutputType = {
    id: number
    field_type: number
    company_id: number
    status_id: number
    created_at: number
    transfer_status: number
    _all: number
  }


  export type FieldTypeAvgAggregateInputType = {
    id?: true
    company_id?: true
    status_id?: true
    transfer_status?: true
  }

  export type FieldTypeSumAggregateInputType = {
    id?: true
    company_id?: true
    status_id?: true
    transfer_status?: true
  }

  export type FieldTypeMinAggregateInputType = {
    id?: true
    field_type?: true
    company_id?: true
    status_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type FieldTypeMaxAggregateInputType = {
    id?: true
    field_type?: true
    company_id?: true
    status_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type FieldTypeCountAggregateInputType = {
    id?: true
    field_type?: true
    company_id?: true
    status_id?: true
    created_at?: true
    transfer_status?: true
    _all?: true
  }

  export type FieldTypeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FieldType to aggregate.
     */
    where?: FieldTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FieldTypes to fetch.
     */
    orderBy?: FieldTypeOrderByWithRelationInput | FieldTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: FieldTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FieldTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FieldTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned FieldTypes
    **/
    _count?: true | FieldTypeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: FieldTypeAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: FieldTypeSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: FieldTypeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: FieldTypeMaxAggregateInputType
  }

  export type GetFieldTypeAggregateType<T extends FieldTypeAggregateArgs> = {
        [P in keyof T & keyof AggregateFieldType]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateFieldType[P]>
      : GetScalarType<T[P], AggregateFieldType[P]>
  }




  export type FieldTypeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: FieldTypeWhereInput
    orderBy?: FieldTypeOrderByWithAggregationInput | FieldTypeOrderByWithAggregationInput[]
    by: FieldTypeScalarFieldEnum[] | FieldTypeScalarFieldEnum
    having?: FieldTypeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: FieldTypeCountAggregateInputType | true
    _avg?: FieldTypeAvgAggregateInputType
    _sum?: FieldTypeSumAggregateInputType
    _min?: FieldTypeMinAggregateInputType
    _max?: FieldTypeMaxAggregateInputType
  }

  export type FieldTypeGroupByOutputType = {
    id: number
    field_type: string
    company_id: number
    status_id: number
    created_at: string
    transfer_status: number | null
    _count: FieldTypeCountAggregateOutputType | null
    _avg: FieldTypeAvgAggregateOutputType | null
    _sum: FieldTypeSumAggregateOutputType | null
    _min: FieldTypeMinAggregateOutputType | null
    _max: FieldTypeMaxAggregateOutputType | null
  }

  type GetFieldTypeGroupByPayload<T extends FieldTypeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<FieldTypeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof FieldTypeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], FieldTypeGroupByOutputType[P]>
            : GetScalarType<T[P], FieldTypeGroupByOutputType[P]>
        }
      >
    >


  export type FieldTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    field_type?: boolean
    company_id?: boolean
    status_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    master_grid_lineitem?: boolean | FieldType$master_grid_lineitemArgs<ExtArgs>
    _count?: boolean | FieldTypeCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["fieldType"]>

  export type FieldTypeSelectScalar = {
    id?: boolean
    field_type?: boolean
    company_id?: boolean
    status_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
  }


  export type FieldTypeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    master_grid_lineitem?: boolean | FieldType$master_grid_lineitemArgs<ExtArgs>
    _count?: boolean | FieldTypeCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $FieldTypePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "FieldType"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      master_grid_lineitem: Prisma.$MasterEntityLineItemPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      field_type: string
      company_id: number
      status_id: number
      created_at: string
      transfer_status: number | null
    }, ExtArgs["result"]["fieldType"]>
    composites: {}
  }


  type FieldTypeGetPayload<S extends boolean | null | undefined | FieldTypeDefaultArgs> = $Result.GetResult<Prisma.$FieldTypePayload, S>

  type FieldTypeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<FieldTypeFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: FieldTypeCountAggregateInputType | true
    }

  export interface FieldTypeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['FieldType'], meta: { name: 'FieldType' } }
    /**
     * Find zero or one FieldType that matches the filter.
     * @param {FieldTypeFindUniqueArgs} args - Arguments to find a FieldType
     * @example
     * // Get one FieldType
     * const fieldType = await prisma.fieldType.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends FieldTypeFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, FieldTypeFindUniqueArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one FieldType that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {FieldTypeFindUniqueOrThrowArgs} args - Arguments to find a FieldType
     * @example
     * // Get one FieldType
     * const fieldType = await prisma.fieldType.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends FieldTypeFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first FieldType that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeFindFirstArgs} args - Arguments to find a FieldType
     * @example
     * // Get one FieldType
     * const fieldType = await prisma.fieldType.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends FieldTypeFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeFindFirstArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first FieldType that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeFindFirstOrThrowArgs} args - Arguments to find a FieldType
     * @example
     * // Get one FieldType
     * const fieldType = await prisma.fieldType.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends FieldTypeFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more FieldTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all FieldTypes
     * const fieldTypes = await prisma.fieldType.findMany()
     * 
     * // Get first 10 FieldTypes
     * const fieldTypes = await prisma.fieldType.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const fieldTypeWithIdOnly = await prisma.fieldType.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends FieldTypeFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a FieldType.
     * @param {FieldTypeCreateArgs} args - Arguments to create a FieldType.
     * @example
     * // Create one FieldType
     * const FieldType = await prisma.fieldType.create({
     *   data: {
     *     // ... data to create a FieldType
     *   }
     * })
     * 
    **/
    create<T extends FieldTypeCreateArgs<ExtArgs>>(
      args: SelectSubset<T, FieldTypeCreateArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many FieldTypes.
     * @param {FieldTypeCreateManyArgs} args - Arguments to create many FieldTypes.
     * @example
     * // Create many FieldTypes
     * const fieldType = await prisma.fieldType.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends FieldTypeCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many FieldTypes and returns the data saved in the database.
     * @param {FieldTypeCreateManyAndReturnArgs} args - Arguments to create many FieldTypes.
     * @example
     * // Create many FieldTypes
     * const fieldType = await prisma.fieldType.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many FieldTypes and only return the `id`
     * const fieldTypeWithIdOnly = await prisma.fieldType.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends FieldTypeCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a FieldType.
     * @param {FieldTypeDeleteArgs} args - Arguments to delete one FieldType.
     * @example
     * // Delete one FieldType
     * const FieldType = await prisma.fieldType.delete({
     *   where: {
     *     // ... filter to delete one FieldType
     *   }
     * })
     * 
    **/
    delete<T extends FieldTypeDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, FieldTypeDeleteArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one FieldType.
     * @param {FieldTypeUpdateArgs} args - Arguments to update one FieldType.
     * @example
     * // Update one FieldType
     * const fieldType = await prisma.fieldType.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends FieldTypeUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, FieldTypeUpdateArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more FieldTypes.
     * @param {FieldTypeDeleteManyArgs} args - Arguments to filter FieldTypes to delete.
     * @example
     * // Delete a few FieldTypes
     * const { count } = await prisma.fieldType.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends FieldTypeDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, FieldTypeDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more FieldTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many FieldTypes
     * const fieldType = await prisma.fieldType.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends FieldTypeUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, FieldTypeUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one FieldType.
     * @param {FieldTypeUpsertArgs} args - Arguments to update or create a FieldType.
     * @example
     * // Update or create a FieldType
     * const fieldType = await prisma.fieldType.upsert({
     *   create: {
     *     // ... data to create a FieldType
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the FieldType we want to update
     *   }
     * })
    **/
    upsert<T extends FieldTypeUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, FieldTypeUpsertArgs<ExtArgs>>
    ): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of FieldTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeCountArgs} args - Arguments to filter FieldTypes to count.
     * @example
     * // Count the number of FieldTypes
     * const count = await prisma.fieldType.count({
     *   where: {
     *     // ... the filter for the FieldTypes we want to count
     *   }
     * })
    **/
    count<T extends FieldTypeCountArgs>(
      args?: Subset<T, FieldTypeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], FieldTypeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a FieldType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends FieldTypeAggregateArgs>(args: Subset<T, FieldTypeAggregateArgs>): Prisma.PrismaPromise<GetFieldTypeAggregateType<T>>

    /**
     * Group by FieldType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {FieldTypeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends FieldTypeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: FieldTypeGroupByArgs['orderBy'] }
        : { orderBy?: FieldTypeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, FieldTypeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetFieldTypeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the FieldType model
   */
  readonly fields: FieldTypeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for FieldType.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__FieldTypeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    master_grid_lineitem<T extends FieldType$master_grid_lineitemArgs<ExtArgs> = {}>(args?: Subset<T, FieldType$master_grid_lineitemArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the FieldType model
   */ 
  interface FieldTypeFieldRefs {
    readonly id: FieldRef<"FieldType", 'Int'>
    readonly field_type: FieldRef<"FieldType", 'String'>
    readonly company_id: FieldRef<"FieldType", 'Int'>
    readonly status_id: FieldRef<"FieldType", 'Int'>
    readonly created_at: FieldRef<"FieldType", 'String'>
    readonly transfer_status: FieldRef<"FieldType", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * FieldType findUnique
   */
  export type FieldTypeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * Filter, which FieldType to fetch.
     */
    where: FieldTypeWhereUniqueInput
  }

  /**
   * FieldType findUniqueOrThrow
   */
  export type FieldTypeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * Filter, which FieldType to fetch.
     */
    where: FieldTypeWhereUniqueInput
  }

  /**
   * FieldType findFirst
   */
  export type FieldTypeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * Filter, which FieldType to fetch.
     */
    where?: FieldTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FieldTypes to fetch.
     */
    orderBy?: FieldTypeOrderByWithRelationInput | FieldTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for FieldTypes.
     */
    cursor?: FieldTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FieldTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FieldTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of FieldTypes.
     */
    distinct?: FieldTypeScalarFieldEnum | FieldTypeScalarFieldEnum[]
  }

  /**
   * FieldType findFirstOrThrow
   */
  export type FieldTypeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * Filter, which FieldType to fetch.
     */
    where?: FieldTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FieldTypes to fetch.
     */
    orderBy?: FieldTypeOrderByWithRelationInput | FieldTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for FieldTypes.
     */
    cursor?: FieldTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FieldTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FieldTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of FieldTypes.
     */
    distinct?: FieldTypeScalarFieldEnum | FieldTypeScalarFieldEnum[]
  }

  /**
   * FieldType findMany
   */
  export type FieldTypeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * Filter, which FieldTypes to fetch.
     */
    where?: FieldTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of FieldTypes to fetch.
     */
    orderBy?: FieldTypeOrderByWithRelationInput | FieldTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing FieldTypes.
     */
    cursor?: FieldTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` FieldTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` FieldTypes.
     */
    skip?: number
    distinct?: FieldTypeScalarFieldEnum | FieldTypeScalarFieldEnum[]
  }

  /**
   * FieldType create
   */
  export type FieldTypeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * The data needed to create a FieldType.
     */
    data: XOR<FieldTypeCreateInput, FieldTypeUncheckedCreateInput>
  }

  /**
   * FieldType createMany
   */
  export type FieldTypeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many FieldTypes.
     */
    data: FieldTypeCreateManyInput | FieldTypeCreateManyInput[]
  }

  /**
   * FieldType createManyAndReturn
   */
  export type FieldTypeCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * The data used to create many FieldTypes.
     */
    data: FieldTypeCreateManyInput | FieldTypeCreateManyInput[]
  }

  /**
   * FieldType update
   */
  export type FieldTypeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * The data needed to update a FieldType.
     */
    data: XOR<FieldTypeUpdateInput, FieldTypeUncheckedUpdateInput>
    /**
     * Choose, which FieldType to update.
     */
    where: FieldTypeWhereUniqueInput
  }

  /**
   * FieldType updateMany
   */
  export type FieldTypeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update FieldTypes.
     */
    data: XOR<FieldTypeUpdateManyMutationInput, FieldTypeUncheckedUpdateManyInput>
    /**
     * Filter which FieldTypes to update
     */
    where?: FieldTypeWhereInput
  }

  /**
   * FieldType upsert
   */
  export type FieldTypeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * The filter to search for the FieldType to update in case it exists.
     */
    where: FieldTypeWhereUniqueInput
    /**
     * In case the FieldType found by the `where` argument doesn't exist, create a new FieldType with this data.
     */
    create: XOR<FieldTypeCreateInput, FieldTypeUncheckedCreateInput>
    /**
     * In case the FieldType was found with the provided `where` argument, update it with this data.
     */
    update: XOR<FieldTypeUpdateInput, FieldTypeUncheckedUpdateInput>
  }

  /**
   * FieldType delete
   */
  export type FieldTypeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
    /**
     * Filter which FieldType to delete.
     */
    where: FieldTypeWhereUniqueInput
  }

  /**
   * FieldType deleteMany
   */
  export type FieldTypeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which FieldTypes to delete
     */
    where?: FieldTypeWhereInput
  }

  /**
   * FieldType.master_grid_lineitem
   */
  export type FieldType$master_grid_lineitemArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    where?: MasterEntityLineItemWhereInput
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    cursor?: MasterEntityLineItemWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MasterEntityLineItemScalarFieldEnum | MasterEntityLineItemScalarFieldEnum[]
  }

  /**
   * FieldType without action
   */
  export type FieldTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the FieldType
     */
    select?: FieldTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: FieldTypeInclude<ExtArgs> | null
  }


  /**
   * Model Role
   */

  export type AggregateRole = {
    _count: RoleCountAggregateOutputType | null
    _avg: RoleAvgAggregateOutputType | null
    _sum: RoleSumAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  export type RoleAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type RoleSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type RoleMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type RoleMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type RoleCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    description: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    transfer_status: number
    _all: number
  }


  export type RoleAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type RoleSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type RoleMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type RoleMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type RoleCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
    _all?: true
  }

  export type RoleAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Role to aggregate.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Roles
    **/
    _count?: true | RoleCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RoleAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RoleSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RoleMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RoleMaxAggregateInputType
  }

  export type GetRoleAggregateType<T extends RoleAggregateArgs> = {
        [P in keyof T & keyof AggregateRole]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRole[P]>
      : GetScalarType<T[P], AggregateRole[P]>
  }




  export type RoleGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RoleWhereInput
    orderBy?: RoleOrderByWithAggregationInput | RoleOrderByWithAggregationInput[]
    by: RoleScalarFieldEnum[] | RoleScalarFieldEnum
    having?: RoleScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RoleCountAggregateInputType | true
    _avg?: RoleAvgAggregateInputType
    _sum?: RoleSumAggregateInputType
    _min?: RoleMinAggregateInputType
    _max?: RoleMaxAggregateInputType
  }

  export type RoleGroupByOutputType = {
    id: number
    uuid: string
    name: string
    description: string | null
    status_id: number
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
    _count: RoleCountAggregateOutputType | null
    _avg: RoleAvgAggregateOutputType | null
    _sum: RoleSumAggregateOutputType | null
    _min: RoleMinAggregateOutputType | null
    _max: RoleMaxAggregateOutputType | null
  }

  type GetRoleGroupByPayload<T extends RoleGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RoleGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RoleGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RoleGroupByOutputType[P]>
            : GetScalarType<T[P], RoleGroupByOutputType[P]>
        }
      >
    >


  export type RoleSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | Role$permissionsArgs<ExtArgs>
    users?: boolean | Role$usersArgs<ExtArgs>
    _count?: boolean | RoleCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["role"]>

  export type RoleSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
  }


  export type RoleInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | Role$permissionsArgs<ExtArgs>
    users?: boolean | Role$usersArgs<ExtArgs>
    _count?: boolean | RoleCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $RolePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Role"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      permissions: Prisma.$RolePermissionsPayload<ExtArgs>[]
      users: Prisma.$UserRolesPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      description: string | null
      status_id: number
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: string
      updated_at: Date | null
      deleted_at: Date | null
      transfer_status: number | null
    }, ExtArgs["result"]["role"]>
    composites: {}
  }


  type RoleGetPayload<S extends boolean | null | undefined | RoleDefaultArgs> = $Result.GetResult<Prisma.$RolePayload, S>

  type RoleCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<RoleFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: RoleCountAggregateInputType | true
    }

  export interface RoleDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Role'], meta: { name: 'Role' } }
    /**
     * Find zero or one Role that matches the filter.
     * @param {RoleFindUniqueArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends RoleFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, RoleFindUniqueArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Role that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {RoleFindUniqueOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends RoleFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Role that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends RoleFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindFirstArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Role that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindFirstOrThrowArgs} args - Arguments to find a Role
     * @example
     * // Get one Role
     * const role = await prisma.role.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends RoleFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Roles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Roles
     * const roles = await prisma.role.findMany()
     * 
     * // Get first 10 Roles
     * const roles = await prisma.role.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const roleWithIdOnly = await prisma.role.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends RoleFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Role.
     * @param {RoleCreateArgs} args - Arguments to create a Role.
     * @example
     * // Create one Role
     * const Role = await prisma.role.create({
     *   data: {
     *     // ... data to create a Role
     *   }
     * })
     * 
    **/
    create<T extends RoleCreateArgs<ExtArgs>>(
      args: SelectSubset<T, RoleCreateArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Roles.
     * @param {RoleCreateManyArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const role = await prisma.role.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends RoleCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Roles and returns the data saved in the database.
     * @param {RoleCreateManyAndReturnArgs} args - Arguments to create many Roles.
     * @example
     * // Create many Roles
     * const role = await prisma.role.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Roles and only return the `id`
     * const roleWithIdOnly = await prisma.role.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends RoleCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Role.
     * @param {RoleDeleteArgs} args - Arguments to delete one Role.
     * @example
     * // Delete one Role
     * const Role = await prisma.role.delete({
     *   where: {
     *     // ... filter to delete one Role
     *   }
     * })
     * 
    **/
    delete<T extends RoleDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, RoleDeleteArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Role.
     * @param {RoleUpdateArgs} args - Arguments to update one Role.
     * @example
     * // Update one Role
     * const role = await prisma.role.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends RoleUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, RoleUpdateArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Roles.
     * @param {RoleDeleteManyArgs} args - Arguments to filter Roles to delete.
     * @example
     * // Delete a few Roles
     * const { count } = await prisma.role.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends RoleDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RoleDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Roles
     * const role = await prisma.role.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends RoleUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, RoleUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Role.
     * @param {RoleUpsertArgs} args - Arguments to update or create a Role.
     * @example
     * // Update or create a Role
     * const role = await prisma.role.upsert({
     *   create: {
     *     // ... data to create a Role
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Role we want to update
     *   }
     * })
    **/
    upsert<T extends RoleUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, RoleUpsertArgs<ExtArgs>>
    ): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Roles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleCountArgs} args - Arguments to filter Roles to count.
     * @example
     * // Count the number of Roles
     * const count = await prisma.role.count({
     *   where: {
     *     // ... the filter for the Roles we want to count
     *   }
     * })
    **/
    count<T extends RoleCountArgs>(
      args?: Subset<T, RoleCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RoleCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RoleAggregateArgs>(args: Subset<T, RoleAggregateArgs>): Prisma.PrismaPromise<GetRoleAggregateType<T>>

    /**
     * Group by Role.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RoleGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RoleGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RoleGroupByArgs['orderBy'] }
        : { orderBy?: RoleGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RoleGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRoleGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Role model
   */
  readonly fields: RoleFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Role.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RoleClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permissions<T extends Role$permissionsArgs<ExtArgs> = {}>(args?: Subset<T, Role$permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    users<T extends Role$usersArgs<ExtArgs> = {}>(args?: Subset<T, Role$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Role model
   */ 
  interface RoleFieldRefs {
    readonly id: FieldRef<"Role", 'Int'>
    readonly uuid: FieldRef<"Role", 'String'>
    readonly name: FieldRef<"Role", 'String'>
    readonly description: FieldRef<"Role", 'String'>
    readonly status_id: FieldRef<"Role", 'Int'>
    readonly company_id: FieldRef<"Role", 'Int'>
    readonly created_by: FieldRef<"Role", 'Int'>
    readonly updated_by: FieldRef<"Role", 'Int'>
    readonly deleted_by: FieldRef<"Role", 'Int'>
    readonly created_at: FieldRef<"Role", 'String'>
    readonly updated_at: FieldRef<"Role", 'DateTime'>
    readonly deleted_at: FieldRef<"Role", 'DateTime'>
    readonly transfer_status: FieldRef<"Role", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Role findUnique
   */
  export type RoleFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findUniqueOrThrow
   */
  export type RoleFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role findFirst
   */
  export type RoleFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role findFirstOrThrow
   */
  export type RoleFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Role to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Roles.
     */
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role findMany
   */
  export type RoleFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter, which Roles to fetch.
     */
    where?: RoleWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Roles to fetch.
     */
    orderBy?: RoleOrderByWithRelationInput | RoleOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Roles.
     */
    cursor?: RoleWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Roles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Roles.
     */
    skip?: number
    distinct?: RoleScalarFieldEnum | RoleScalarFieldEnum[]
  }

  /**
   * Role create
   */
  export type RoleCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data needed to create a Role.
     */
    data: XOR<RoleCreateInput, RoleUncheckedCreateInput>
  }

  /**
   * Role createMany
   */
  export type RoleCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Roles.
     */
    data: RoleCreateManyInput | RoleCreateManyInput[]
  }

  /**
   * Role createManyAndReturn
   */
  export type RoleCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data used to create many Roles.
     */
    data: RoleCreateManyInput | RoleCreateManyInput[]
  }

  /**
   * Role update
   */
  export type RoleUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The data needed to update a Role.
     */
    data: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
    /**
     * Choose, which Role to update.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role updateMany
   */
  export type RoleUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Roles.
     */
    data: XOR<RoleUpdateManyMutationInput, RoleUncheckedUpdateManyInput>
    /**
     * Filter which Roles to update
     */
    where?: RoleWhereInput
  }

  /**
   * Role upsert
   */
  export type RoleUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * The filter to search for the Role to update in case it exists.
     */
    where: RoleWhereUniqueInput
    /**
     * In case the Role found by the `where` argument doesn't exist, create a new Role with this data.
     */
    create: XOR<RoleCreateInput, RoleUncheckedCreateInput>
    /**
     * In case the Role was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RoleUpdateInput, RoleUncheckedUpdateInput>
  }

  /**
   * Role delete
   */
  export type RoleDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
    /**
     * Filter which Role to delete.
     */
    where: RoleWhereUniqueInput
  }

  /**
   * Role deleteMany
   */
  export type RoleDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Roles to delete
     */
    where?: RoleWhereInput
  }

  /**
   * Role.permissions
   */
  export type Role$permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    where?: RolePermissionsWhereInput
    orderBy?: RolePermissionsOrderByWithRelationInput | RolePermissionsOrderByWithRelationInput[]
    cursor?: RolePermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * Role.users
   */
  export type Role$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    where?: UserRolesWhereInput
    orderBy?: UserRolesOrderByWithRelationInput | UserRolesOrderByWithRelationInput[]
    cursor?: UserRolesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * Role without action
   */
  export type RoleDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Role
     */
    select?: RoleSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RoleInclude<ExtArgs> | null
  }


  /**
   * Model Department
   */

  export type AggregateDepartment = {
    _count: DepartmentCountAggregateOutputType | null
    _avg: DepartmentAvgAggregateOutputType | null
    _sum: DepartmentSumAggregateOutputType | null
    _min: DepartmentMinAggregateOutputType | null
    _max: DepartmentMaxAggregateOutputType | null
  }

  export type DepartmentAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DepartmentSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DepartmentMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DepartmentMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    department_head_id: number | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DepartmentCountAggregateOutputType = {
    id: number
    uuid: number
    code: number
    name: number
    description: number
    status_id: number
    department_head_id: number
    company_id: number
    created_at: number
    created_by: number
    updated_at: number
    updated_by: number
    deleted_at: number
    deleted_by: number
    transfer_status: number
    _all: number
  }


  export type DepartmentAvgAggregateInputType = {
    id?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DepartmentSumAggregateInputType = {
    id?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DepartmentMinAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DepartmentMaxAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DepartmentCountAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    department_head_id?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
    _all?: true
  }

  export type DepartmentAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Department to aggregate.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Departments
    **/
    _count?: true | DepartmentCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DepartmentAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DepartmentSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DepartmentMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DepartmentMaxAggregateInputType
  }

  export type GetDepartmentAggregateType<T extends DepartmentAggregateArgs> = {
        [P in keyof T & keyof AggregateDepartment]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDepartment[P]>
      : GetScalarType<T[P], AggregateDepartment[P]>
  }




  export type DepartmentGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DepartmentWhereInput
    orderBy?: DepartmentOrderByWithAggregationInput | DepartmentOrderByWithAggregationInput[]
    by: DepartmentScalarFieldEnum[] | DepartmentScalarFieldEnum
    having?: DepartmentScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DepartmentCountAggregateInputType | true
    _avg?: DepartmentAvgAggregateInputType
    _sum?: DepartmentSumAggregateInputType
    _min?: DepartmentMinAggregateInputType
    _max?: DepartmentMaxAggregateInputType
  }

  export type DepartmentGroupByOutputType = {
    id: number
    uuid: string
    code: string
    name: string
    description: string | null
    status_id: number
    department_head_id: number | null
    company_id: number
    created_at: string
    created_by: number
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
    _count: DepartmentCountAggregateOutputType | null
    _avg: DepartmentAvgAggregateOutputType | null
    _sum: DepartmentSumAggregateOutputType | null
    _min: DepartmentMinAggregateOutputType | null
    _max: DepartmentMaxAggregateOutputType | null
  }

  type GetDepartmentGroupByPayload<T extends DepartmentGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DepartmentGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DepartmentGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DepartmentGroupByOutputType[P]>
            : GetScalarType<T[P], DepartmentGroupByOutputType[P]>
        }
      >
    >


  export type DepartmentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    department_head_id?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Department$usersArgs<ExtArgs>
    _count?: boolean | DepartmentCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["department"]>

  export type DepartmentSelectScalar = {
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    department_head_id?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
  }


  export type DepartmentInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Department$usersArgs<ExtArgs>
    _count?: boolean | DepartmentCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $DepartmentPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Department"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      users: Prisma.$UserDetailPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      code: string
      name: string
      description: string | null
      status_id: number
      department_head_id: number | null
      company_id: number
      created_at: string
      created_by: number
      updated_at: Date | null
      updated_by: number | null
      deleted_at: Date | null
      deleted_by: number | null
      transfer_status: number | null
    }, ExtArgs["result"]["department"]>
    composites: {}
  }


  type DepartmentGetPayload<S extends boolean | null | undefined | DepartmentDefaultArgs> = $Result.GetResult<Prisma.$DepartmentPayload, S>

  type DepartmentCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<DepartmentFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: DepartmentCountAggregateInputType | true
    }

  export interface DepartmentDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Department'], meta: { name: 'Department' } }
    /**
     * Find zero or one Department that matches the filter.
     * @param {DepartmentFindUniqueArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends DepartmentFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentFindUniqueArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Department that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {DepartmentFindUniqueOrThrowArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends DepartmentFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Department that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindFirstArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends DepartmentFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindFirstArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Department that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindFirstOrThrowArgs} args - Arguments to find a Department
     * @example
     * // Get one Department
     * const department = await prisma.department.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends DepartmentFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Departments that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Departments
     * const departments = await prisma.department.findMany()
     * 
     * // Get first 10 Departments
     * const departments = await prisma.department.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const departmentWithIdOnly = await prisma.department.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends DepartmentFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Department.
     * @param {DepartmentCreateArgs} args - Arguments to create a Department.
     * @example
     * // Create one Department
     * const Department = await prisma.department.create({
     *   data: {
     *     // ... data to create a Department
     *   }
     * })
     * 
    **/
    create<T extends DepartmentCreateArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentCreateArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Departments.
     * @param {DepartmentCreateManyArgs} args - Arguments to create many Departments.
     * @example
     * // Create many Departments
     * const department = await prisma.department.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends DepartmentCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Departments and returns the data saved in the database.
     * @param {DepartmentCreateManyAndReturnArgs} args - Arguments to create many Departments.
     * @example
     * // Create many Departments
     * const department = await prisma.department.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Departments and only return the `id`
     * const departmentWithIdOnly = await prisma.department.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends DepartmentCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Department.
     * @param {DepartmentDeleteArgs} args - Arguments to delete one Department.
     * @example
     * // Delete one Department
     * const Department = await prisma.department.delete({
     *   where: {
     *     // ... filter to delete one Department
     *   }
     * })
     * 
    **/
    delete<T extends DepartmentDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentDeleteArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Department.
     * @param {DepartmentUpdateArgs} args - Arguments to update one Department.
     * @example
     * // Update one Department
     * const department = await prisma.department.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends DepartmentUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentUpdateArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Departments.
     * @param {DepartmentDeleteManyArgs} args - Arguments to filter Departments to delete.
     * @example
     * // Delete a few Departments
     * const { count } = await prisma.department.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends DepartmentDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DepartmentDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Departments.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Departments
     * const department = await prisma.department.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends DepartmentUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Department.
     * @param {DepartmentUpsertArgs} args - Arguments to update or create a Department.
     * @example
     * // Update or create a Department
     * const department = await prisma.department.upsert({
     *   create: {
     *     // ... data to create a Department
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Department we want to update
     *   }
     * })
    **/
    upsert<T extends DepartmentUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, DepartmentUpsertArgs<ExtArgs>>
    ): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Departments.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentCountArgs} args - Arguments to filter Departments to count.
     * @example
     * // Count the number of Departments
     * const count = await prisma.department.count({
     *   where: {
     *     // ... the filter for the Departments we want to count
     *   }
     * })
    **/
    count<T extends DepartmentCountArgs>(
      args?: Subset<T, DepartmentCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DepartmentCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Department.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DepartmentAggregateArgs>(args: Subset<T, DepartmentAggregateArgs>): Prisma.PrismaPromise<GetDepartmentAggregateType<T>>

    /**
     * Group by Department.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DepartmentGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DepartmentGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DepartmentGroupByArgs['orderBy'] }
        : { orderBy?: DepartmentGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DepartmentGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDepartmentGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Department model
   */
  readonly fields: DepartmentFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Department.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DepartmentClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    users<T extends Department$usersArgs<ExtArgs> = {}>(args?: Subset<T, Department$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Department model
   */ 
  interface DepartmentFieldRefs {
    readonly id: FieldRef<"Department", 'Int'>
    readonly uuid: FieldRef<"Department", 'String'>
    readonly code: FieldRef<"Department", 'String'>
    readonly name: FieldRef<"Department", 'String'>
    readonly description: FieldRef<"Department", 'String'>
    readonly status_id: FieldRef<"Department", 'Int'>
    readonly department_head_id: FieldRef<"Department", 'Int'>
    readonly company_id: FieldRef<"Department", 'Int'>
    readonly created_at: FieldRef<"Department", 'String'>
    readonly created_by: FieldRef<"Department", 'Int'>
    readonly updated_at: FieldRef<"Department", 'DateTime'>
    readonly updated_by: FieldRef<"Department", 'Int'>
    readonly deleted_at: FieldRef<"Department", 'DateTime'>
    readonly deleted_by: FieldRef<"Department", 'Int'>
    readonly transfer_status: FieldRef<"Department", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Department findUnique
   */
  export type DepartmentFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department findUniqueOrThrow
   */
  export type DepartmentFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department findFirst
   */
  export type DepartmentFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Departments.
     */
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department findFirstOrThrow
   */
  export type DepartmentFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Department to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Departments.
     */
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department findMany
   */
  export type DepartmentFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter, which Departments to fetch.
     */
    where?: DepartmentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Departments to fetch.
     */
    orderBy?: DepartmentOrderByWithRelationInput | DepartmentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Departments.
     */
    cursor?: DepartmentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Departments from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Departments.
     */
    skip?: number
    distinct?: DepartmentScalarFieldEnum | DepartmentScalarFieldEnum[]
  }

  /**
   * Department create
   */
  export type DepartmentCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data needed to create a Department.
     */
    data: XOR<DepartmentCreateInput, DepartmentUncheckedCreateInput>
  }

  /**
   * Department createMany
   */
  export type DepartmentCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Departments.
     */
    data: DepartmentCreateManyInput | DepartmentCreateManyInput[]
  }

  /**
   * Department createManyAndReturn
   */
  export type DepartmentCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data used to create many Departments.
     */
    data: DepartmentCreateManyInput | DepartmentCreateManyInput[]
  }

  /**
   * Department update
   */
  export type DepartmentUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The data needed to update a Department.
     */
    data: XOR<DepartmentUpdateInput, DepartmentUncheckedUpdateInput>
    /**
     * Choose, which Department to update.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department updateMany
   */
  export type DepartmentUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Departments.
     */
    data: XOR<DepartmentUpdateManyMutationInput, DepartmentUncheckedUpdateManyInput>
    /**
     * Filter which Departments to update
     */
    where?: DepartmentWhereInput
  }

  /**
   * Department upsert
   */
  export type DepartmentUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * The filter to search for the Department to update in case it exists.
     */
    where: DepartmentWhereUniqueInput
    /**
     * In case the Department found by the `where` argument doesn't exist, create a new Department with this data.
     */
    create: XOR<DepartmentCreateInput, DepartmentUncheckedCreateInput>
    /**
     * In case the Department was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DepartmentUpdateInput, DepartmentUncheckedUpdateInput>
  }

  /**
   * Department delete
   */
  export type DepartmentDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    /**
     * Filter which Department to delete.
     */
    where: DepartmentWhereUniqueInput
  }

  /**
   * Department deleteMany
   */
  export type DepartmentDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Departments to delete
     */
    where?: DepartmentWhereInput
  }

  /**
   * Department.users
   */
  export type Department$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * Department without action
   */
  export type DepartmentDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
  }


  /**
   * Model Designation
   */

  export type AggregateDesignation = {
    _count: DesignationCountAggregateOutputType | null
    _avg: DesignationAvgAggregateOutputType | null
    _sum: DesignationSumAggregateOutputType | null
    _min: DesignationMinAggregateOutputType | null
    _max: DesignationMaxAggregateOutputType | null
  }

  export type DesignationAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DesignationSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DesignationMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DesignationMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    code: string | null
    name: string | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type DesignationCountAggregateOutputType = {
    id: number
    uuid: number
    code: number
    name: number
    description: number
    status_id: number
    company_id: number
    created_at: number
    created_by: number
    updated_at: number
    updated_by: number
    deleted_at: number
    deleted_by: number
    transfer_status: number
    _all: number
  }


  export type DesignationAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DesignationSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DesignationMinAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DesignationMaxAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type DesignationCountAggregateInputType = {
    id?: true
    uuid?: true
    code?: true
    name?: true
    description?: true
    status_id?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
    _all?: true
  }

  export type DesignationAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Designation to aggregate.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationInput | DesignationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Designations
    **/
    _count?: true | DesignationCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: DesignationAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: DesignationSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: DesignationMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: DesignationMaxAggregateInputType
  }

  export type GetDesignationAggregateType<T extends DesignationAggregateArgs> = {
        [P in keyof T & keyof AggregateDesignation]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateDesignation[P]>
      : GetScalarType<T[P], AggregateDesignation[P]>
  }




  export type DesignationGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: DesignationWhereInput
    orderBy?: DesignationOrderByWithAggregationInput | DesignationOrderByWithAggregationInput[]
    by: DesignationScalarFieldEnum[] | DesignationScalarFieldEnum
    having?: DesignationScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: DesignationCountAggregateInputType | true
    _avg?: DesignationAvgAggregateInputType
    _sum?: DesignationSumAggregateInputType
    _min?: DesignationMinAggregateInputType
    _max?: DesignationMaxAggregateInputType
  }

  export type DesignationGroupByOutputType = {
    id: number
    uuid: string
    code: string
    name: string
    description: string | null
    status_id: number
    company_id: number
    created_at: string
    created_by: number
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
    _count: DesignationCountAggregateOutputType | null
    _avg: DesignationAvgAggregateOutputType | null
    _sum: DesignationSumAggregateOutputType | null
    _min: DesignationMinAggregateOutputType | null
    _max: DesignationMaxAggregateOutputType | null
  }

  type GetDesignationGroupByPayload<T extends DesignationGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<DesignationGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof DesignationGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], DesignationGroupByOutputType[P]>
            : GetScalarType<T[P], DesignationGroupByOutputType[P]>
        }
      >
    >


  export type DesignationSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Designation$usersArgs<ExtArgs>
    _count?: boolean | DesignationCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["designation"]>

  export type DesignationSelectScalar = {
    id?: boolean
    uuid?: boolean
    code?: boolean
    name?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
  }


  export type DesignationInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    users?: boolean | Designation$usersArgs<ExtArgs>
    _count?: boolean | DesignationCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $DesignationPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Designation"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      users: Prisma.$UserDetailPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      code: string
      name: string
      description: string | null
      status_id: number
      company_id: number
      created_at: string
      created_by: number
      updated_at: Date | null
      updated_by: number | null
      deleted_at: Date | null
      deleted_by: number | null
      transfer_status: number | null
    }, ExtArgs["result"]["designation"]>
    composites: {}
  }


  type DesignationGetPayload<S extends boolean | null | undefined | DesignationDefaultArgs> = $Result.GetResult<Prisma.$DesignationPayload, S>

  type DesignationCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<DesignationFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: DesignationCountAggregateInputType | true
    }

  export interface DesignationDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Designation'], meta: { name: 'Designation' } }
    /**
     * Find zero or one Designation that matches the filter.
     * @param {DesignationFindUniqueArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends DesignationFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationFindUniqueArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Designation that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {DesignationFindUniqueOrThrowArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends DesignationFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Designation that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationFindFirstArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends DesignationFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindFirstArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Designation that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationFindFirstOrThrowArgs} args - Arguments to find a Designation
     * @example
     * // Get one Designation
     * const designation = await prisma.designation.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends DesignationFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Designations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Designations
     * const designations = await prisma.designation.findMany()
     * 
     * // Get first 10 Designations
     * const designations = await prisma.designation.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const designationWithIdOnly = await prisma.designation.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends DesignationFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Designation.
     * @param {DesignationCreateArgs} args - Arguments to create a Designation.
     * @example
     * // Create one Designation
     * const Designation = await prisma.designation.create({
     *   data: {
     *     // ... data to create a Designation
     *   }
     * })
     * 
    **/
    create<T extends DesignationCreateArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationCreateArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Designations.
     * @param {DesignationCreateManyArgs} args - Arguments to create many Designations.
     * @example
     * // Create many Designations
     * const designation = await prisma.designation.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends DesignationCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Designations and returns the data saved in the database.
     * @param {DesignationCreateManyAndReturnArgs} args - Arguments to create many Designations.
     * @example
     * // Create many Designations
     * const designation = await prisma.designation.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Designations and only return the `id`
     * const designationWithIdOnly = await prisma.designation.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends DesignationCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Designation.
     * @param {DesignationDeleteArgs} args - Arguments to delete one Designation.
     * @example
     * // Delete one Designation
     * const Designation = await prisma.designation.delete({
     *   where: {
     *     // ... filter to delete one Designation
     *   }
     * })
     * 
    **/
    delete<T extends DesignationDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationDeleteArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Designation.
     * @param {DesignationUpdateArgs} args - Arguments to update one Designation.
     * @example
     * // Update one Designation
     * const designation = await prisma.designation.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends DesignationUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationUpdateArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Designations.
     * @param {DesignationDeleteManyArgs} args - Arguments to filter Designations to delete.
     * @example
     * // Delete a few Designations
     * const { count } = await prisma.designation.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends DesignationDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, DesignationDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Designations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Designations
     * const designation = await prisma.designation.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends DesignationUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Designation.
     * @param {DesignationUpsertArgs} args - Arguments to update or create a Designation.
     * @example
     * // Update or create a Designation
     * const designation = await prisma.designation.upsert({
     *   create: {
     *     // ... data to create a Designation
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Designation we want to update
     *   }
     * })
    **/
    upsert<T extends DesignationUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, DesignationUpsertArgs<ExtArgs>>
    ): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Designations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationCountArgs} args - Arguments to filter Designations to count.
     * @example
     * // Count the number of Designations
     * const count = await prisma.designation.count({
     *   where: {
     *     // ... the filter for the Designations we want to count
     *   }
     * })
    **/
    count<T extends DesignationCountArgs>(
      args?: Subset<T, DesignationCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], DesignationCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Designation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends DesignationAggregateArgs>(args: Subset<T, DesignationAggregateArgs>): Prisma.PrismaPromise<GetDesignationAggregateType<T>>

    /**
     * Group by Designation.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {DesignationGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends DesignationGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: DesignationGroupByArgs['orderBy'] }
        : { orderBy?: DesignationGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, DesignationGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetDesignationGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Designation model
   */
  readonly fields: DesignationFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Designation.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__DesignationClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    users<T extends Designation$usersArgs<ExtArgs> = {}>(args?: Subset<T, Designation$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Designation model
   */ 
  interface DesignationFieldRefs {
    readonly id: FieldRef<"Designation", 'Int'>
    readonly uuid: FieldRef<"Designation", 'String'>
    readonly code: FieldRef<"Designation", 'String'>
    readonly name: FieldRef<"Designation", 'String'>
    readonly description: FieldRef<"Designation", 'String'>
    readonly status_id: FieldRef<"Designation", 'Int'>
    readonly company_id: FieldRef<"Designation", 'Int'>
    readonly created_at: FieldRef<"Designation", 'String'>
    readonly created_by: FieldRef<"Designation", 'Int'>
    readonly updated_at: FieldRef<"Designation", 'DateTime'>
    readonly updated_by: FieldRef<"Designation", 'Int'>
    readonly deleted_at: FieldRef<"Designation", 'DateTime'>
    readonly deleted_by: FieldRef<"Designation", 'Int'>
    readonly transfer_status: FieldRef<"Designation", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Designation findUnique
   */
  export type DesignationFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation findUniqueOrThrow
   */
  export type DesignationFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation findFirst
   */
  export type DesignationFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationInput | DesignationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Designations.
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Designations.
     */
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Designation findFirstOrThrow
   */
  export type DesignationFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designation to fetch.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationInput | DesignationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Designations.
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Designations.
     */
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Designation findMany
   */
  export type DesignationFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter, which Designations to fetch.
     */
    where?: DesignationWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Designations to fetch.
     */
    orderBy?: DesignationOrderByWithRelationInput | DesignationOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Designations.
     */
    cursor?: DesignationWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Designations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Designations.
     */
    skip?: number
    distinct?: DesignationScalarFieldEnum | DesignationScalarFieldEnum[]
  }

  /**
   * Designation create
   */
  export type DesignationCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The data needed to create a Designation.
     */
    data: XOR<DesignationCreateInput, DesignationUncheckedCreateInput>
  }

  /**
   * Designation createMany
   */
  export type DesignationCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Designations.
     */
    data: DesignationCreateManyInput | DesignationCreateManyInput[]
  }

  /**
   * Designation createManyAndReturn
   */
  export type DesignationCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The data used to create many Designations.
     */
    data: DesignationCreateManyInput | DesignationCreateManyInput[]
  }

  /**
   * Designation update
   */
  export type DesignationUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The data needed to update a Designation.
     */
    data: XOR<DesignationUpdateInput, DesignationUncheckedUpdateInput>
    /**
     * Choose, which Designation to update.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation updateMany
   */
  export type DesignationUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Designations.
     */
    data: XOR<DesignationUpdateManyMutationInput, DesignationUncheckedUpdateManyInput>
    /**
     * Filter which Designations to update
     */
    where?: DesignationWhereInput
  }

  /**
   * Designation upsert
   */
  export type DesignationUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * The filter to search for the Designation to update in case it exists.
     */
    where: DesignationWhereUniqueInput
    /**
     * In case the Designation found by the `where` argument doesn't exist, create a new Designation with this data.
     */
    create: XOR<DesignationCreateInput, DesignationUncheckedCreateInput>
    /**
     * In case the Designation was found with the provided `where` argument, update it with this data.
     */
    update: XOR<DesignationUpdateInput, DesignationUncheckedUpdateInput>
  }

  /**
   * Designation delete
   */
  export type DesignationDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    /**
     * Filter which Designation to delete.
     */
    where: DesignationWhereUniqueInput
  }

  /**
   * Designation deleteMany
   */
  export type DesignationDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Designations to delete
     */
    where?: DesignationWhereInput
  }

  /**
   * Designation.users
   */
  export type Designation$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * Designation without action
   */
  export type DesignationDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
  }


  /**
   * Model User
   */

  export type AggregateUser = {
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  export type UserAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type UserSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type UserMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    username: string | null
    email: string | null
    email_verified: boolean | null
    password: string | null
    status_id: number | null
    role: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    last_login: Date | null
    last_login_device: string | null
    transfer_status: number | null
  }

  export type UserMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    username: string | null
    email: string | null
    email_verified: boolean | null
    password: string | null
    status_id: number | null
    role: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    last_login: Date | null
    last_login_device: string | null
    transfer_status: number | null
  }

  export type UserCountAggregateOutputType = {
    id: number
    uuid: number
    username: number
    email: number
    email_verified: number
    password: number
    status_id: number
    role: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    last_login: number
    last_login_device: number
    transfer_status: number
    _all: number
  }


  export type UserAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type UserSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type UserMinAggregateInputType = {
    id?: true
    uuid?: true
    username?: true
    email?: true
    email_verified?: true
    password?: true
    status_id?: true
    role?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    last_login?: true
    last_login_device?: true
    transfer_status?: true
  }

  export type UserMaxAggregateInputType = {
    id?: true
    uuid?: true
    username?: true
    email?: true
    email_verified?: true
    password?: true
    status_id?: true
    role?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    last_login?: true
    last_login_device?: true
    transfer_status?: true
  }

  export type UserCountAggregateInputType = {
    id?: true
    uuid?: true
    username?: true
    email?: true
    email_verified?: true
    password?: true
    status_id?: true
    role?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    last_login?: true
    last_login_device?: true
    transfer_status?: true
    _all?: true
  }

  export type UserAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which User to aggregate.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Users
    **/
    _count?: true | UserCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserMaxAggregateInputType
  }

  export type GetUserAggregateType<T extends UserAggregateArgs> = {
        [P in keyof T & keyof AggregateUser]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUser[P]>
      : GetScalarType<T[P], AggregateUser[P]>
  }




  export type UserGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserWhereInput
    orderBy?: UserOrderByWithAggregationInput | UserOrderByWithAggregationInput[]
    by: UserScalarFieldEnum[] | UserScalarFieldEnum
    having?: UserScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserCountAggregateInputType | true
    _avg?: UserAvgAggregateInputType
    _sum?: UserSumAggregateInputType
    _min?: UserMinAggregateInputType
    _max?: UserMaxAggregateInputType
  }

  export type UserGroupByOutputType = {
    id: number
    uuid: string
    username: string
    email: string
    email_verified: boolean
    password: string | null
    status_id: number
    role: string
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string
    updated_at: Date | null
    deleted_at: Date | null
    last_login: Date | null
    last_login_device: string | null
    transfer_status: number | null
    _count: UserCountAggregateOutputType | null
    _avg: UserAvgAggregateOutputType | null
    _sum: UserSumAggregateOutputType | null
    _min: UserMinAggregateOutputType | null
    _max: UserMaxAggregateOutputType | null
  }

  type GetUserGroupByPayload<T extends UserGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserGroupByOutputType[P]>
            : GetScalarType<T[P], UserGroupByOutputType[P]>
        }
      >
    >


  export type UserSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    username?: boolean
    email?: boolean
    email_verified?: boolean
    password?: boolean
    status_id?: boolean
    role?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    last_login?: boolean
    last_login_device?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | User$permissionsArgs<ExtArgs>
    roles?: boolean | User$rolesArgs<ExtArgs>
    user_detail?: boolean | User$user_detailArgs<ExtArgs>
    created?: boolean | User$createdArgs<ExtArgs>
    updated?: boolean | User$updatedArgs<ExtArgs>
    deleted?: boolean | User$deletedArgs<ExtArgs>
    created_users?: boolean | User$created_usersArgs<ExtArgs>
    updated_users?: boolean | User$updated_usersArgs<ExtArgs>
    deleted_users?: boolean | User$deleted_usersArgs<ExtArgs>
    created_user_details?: boolean | User$created_user_detailsArgs<ExtArgs>
    updated_user_details?: boolean | User$updated_user_detailsArgs<ExtArgs>
    deleted_user_details?: boolean | User$deleted_user_detailsArgs<ExtArgs>
    created_languages?: boolean | User$created_languagesArgs<ExtArgs>
    updated_languages?: boolean | User$updated_languagesArgs<ExtArgs>
    deleted_languages?: boolean | User$deleted_languagesArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["user"]>

  export type UserSelectScalar = {
    id?: boolean
    uuid?: boolean
    username?: boolean
    email?: boolean
    email_verified?: boolean
    password?: boolean
    status_id?: boolean
    role?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    last_login?: boolean
    last_login_device?: boolean
    transfer_status?: boolean
  }


  export type UserInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | User$permissionsArgs<ExtArgs>
    roles?: boolean | User$rolesArgs<ExtArgs>
    user_detail?: boolean | User$user_detailArgs<ExtArgs>
    created?: boolean | User$createdArgs<ExtArgs>
    updated?: boolean | User$updatedArgs<ExtArgs>
    deleted?: boolean | User$deletedArgs<ExtArgs>
    created_users?: boolean | User$created_usersArgs<ExtArgs>
    updated_users?: boolean | User$updated_usersArgs<ExtArgs>
    deleted_users?: boolean | User$deleted_usersArgs<ExtArgs>
    created_user_details?: boolean | User$created_user_detailsArgs<ExtArgs>
    updated_user_details?: boolean | User$updated_user_detailsArgs<ExtArgs>
    deleted_user_details?: boolean | User$deleted_user_detailsArgs<ExtArgs>
    created_languages?: boolean | User$created_languagesArgs<ExtArgs>
    updated_languages?: boolean | User$updated_languagesArgs<ExtArgs>
    deleted_languages?: boolean | User$deleted_languagesArgs<ExtArgs>
    _count?: boolean | UserCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $UserPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "User"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      permissions: Prisma.$UserPermissionsPayload<ExtArgs>[]
      roles: Prisma.$UserRolesPayload<ExtArgs>[]
      user_detail: Prisma.$UserDetailPayload<ExtArgs> | null
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
      created_users: Prisma.$UserPayload<ExtArgs>[]
      updated_users: Prisma.$UserPayload<ExtArgs>[]
      deleted_users: Prisma.$UserPayload<ExtArgs>[]
      created_user_details: Prisma.$UserDetailPayload<ExtArgs>[]
      updated_user_details: Prisma.$UserDetailPayload<ExtArgs>[]
      deleted_user_details: Prisma.$UserDetailPayload<ExtArgs>[]
      created_languages: Prisma.$LanguagePayload<ExtArgs>[]
      updated_languages: Prisma.$LanguagePayload<ExtArgs>[]
      deleted_languages: Prisma.$LanguagePayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      username: string
      email: string
      email_verified: boolean
      password: string | null
      status_id: number
      role: string
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: string
      updated_at: Date | null
      deleted_at: Date | null
      last_login: Date | null
      last_login_device: string | null
      transfer_status: number | null
    }, ExtArgs["result"]["user"]>
    composites: {}
  }


  type UserGetPayload<S extends boolean | null | undefined | UserDefaultArgs> = $Result.GetResult<Prisma.$UserPayload, S>

  type UserCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserCountAggregateInputType | true
    }

  export interface UserDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['User'], meta: { name: 'User' } }
    /**
     * Find zero or one User that matches the filter.
     * @param {UserFindUniqueArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserFindUniqueArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one User that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserFindUniqueOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first User that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindFirstArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first User that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindFirstOrThrowArgs} args - Arguments to find a User
     * @example
     * // Get one User
     * const user = await prisma.user.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Users that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Users
     * const users = await prisma.user.findMany()
     * 
     * // Get first 10 Users
     * const users = await prisma.user.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userWithIdOnly = await prisma.user.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends UserFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a User.
     * @param {UserCreateArgs} args - Arguments to create a User.
     * @example
     * // Create one User
     * const User = await prisma.user.create({
     *   data: {
     *     // ... data to create a User
     *   }
     * })
     * 
    **/
    create<T extends UserCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserCreateArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Users.
     * @param {UserCreateManyArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Users and returns the data saved in the database.
     * @param {UserCreateManyAndReturnArgs} args - Arguments to create many Users.
     * @example
     * // Create many Users
     * const user = await prisma.user.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Users and only return the `id`
     * const userWithIdOnly = await prisma.user.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a User.
     * @param {UserDeleteArgs} args - Arguments to delete one User.
     * @example
     * // Delete one User
     * const User = await prisma.user.delete({
     *   where: {
     *     // ... filter to delete one User
     *   }
     * })
     * 
    **/
    delete<T extends UserDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserDeleteArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one User.
     * @param {UserUpdateArgs} args - Arguments to update one User.
     * @example
     * // Update one User
     * const user = await prisma.user.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpdateArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Users.
     * @param {UserDeleteManyArgs} args - Arguments to filter Users to delete.
     * @example
     * // Delete a few Users
     * const { count } = await prisma.user.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Users
     * const user = await prisma.user.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one User.
     * @param {UserUpsertArgs} args - Arguments to update or create a User.
     * @example
     * // Update or create a User
     * const user = await prisma.user.upsert({
     *   create: {
     *     // ... data to create a User
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the User we want to update
     *   }
     * })
    **/
    upsert<T extends UserUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserUpsertArgs<ExtArgs>>
    ): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Users.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserCountArgs} args - Arguments to filter Users to count.
     * @example
     * // Count the number of Users
     * const count = await prisma.user.count({
     *   where: {
     *     // ... the filter for the Users we want to count
     *   }
     * })
    **/
    count<T extends UserCountArgs>(
      args?: Subset<T, UserCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserAggregateArgs>(args: Subset<T, UserAggregateArgs>): Prisma.PrismaPromise<GetUserAggregateType<T>>

    /**
     * Group by User.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserGroupByArgs['orderBy'] }
        : { orderBy?: UserGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the User model
   */
  readonly fields: UserFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for User.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permissions<T extends User$permissionsArgs<ExtArgs> = {}>(args?: Subset<T, User$permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    roles<T extends User$rolesArgs<ExtArgs> = {}>(args?: Subset<T, User$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findMany'> | Null>;

    user_detail<T extends User$user_detailArgs<ExtArgs> = {}>(args?: Subset<T, User$user_detailArgs<ExtArgs>>): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    created<T extends User$createdArgs<ExtArgs> = {}>(args?: Subset<T, User$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends User$updatedArgs<ExtArgs> = {}>(args?: Subset<T, User$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends User$deletedArgs<ExtArgs> = {}>(args?: Subset<T, User$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    created_users<T extends User$created_usersArgs<ExtArgs> = {}>(args?: Subset<T, User$created_usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_users<T extends User$updated_usersArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_users<T extends User$deleted_usersArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_user_details<T extends User$created_user_detailsArgs<ExtArgs> = {}>(args?: Subset<T, User$created_user_detailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_user_details<T extends User$updated_user_detailsArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_user_detailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_user_details<T extends User$deleted_user_detailsArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_user_detailsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'> | Null>;

    created_languages<T extends User$created_languagesArgs<ExtArgs> = {}>(args?: Subset<T, User$created_languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    updated_languages<T extends User$updated_languagesArgs<ExtArgs> = {}>(args?: Subset<T, User$updated_languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    deleted_languages<T extends User$deleted_languagesArgs<ExtArgs> = {}>(args?: Subset<T, User$deleted_languagesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the User model
   */ 
  interface UserFieldRefs {
    readonly id: FieldRef<"User", 'Int'>
    readonly uuid: FieldRef<"User", 'String'>
    readonly username: FieldRef<"User", 'String'>
    readonly email: FieldRef<"User", 'String'>
    readonly email_verified: FieldRef<"User", 'Boolean'>
    readonly password: FieldRef<"User", 'String'>
    readonly status_id: FieldRef<"User", 'Int'>
    readonly role: FieldRef<"User", 'String'>
    readonly company_id: FieldRef<"User", 'Int'>
    readonly created_by: FieldRef<"User", 'Int'>
    readonly updated_by: FieldRef<"User", 'Int'>
    readonly deleted_by: FieldRef<"User", 'Int'>
    readonly created_at: FieldRef<"User", 'String'>
    readonly updated_at: FieldRef<"User", 'DateTime'>
    readonly deleted_at: FieldRef<"User", 'DateTime'>
    readonly last_login: FieldRef<"User", 'DateTime'>
    readonly last_login_device: FieldRef<"User", 'String'>
    readonly transfer_status: FieldRef<"User", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * User findUnique
   */
  export type UserFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findUniqueOrThrow
   */
  export type UserFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User findFirst
   */
  export type UserFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findFirstOrThrow
   */
  export type UserFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which User to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Users.
     */
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User findMany
   */
  export type UserFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter, which Users to fetch.
     */
    where?: UserWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Users to fetch.
     */
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Users.
     */
    cursor?: UserWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Users from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Users.
     */
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User create
   */
  export type UserCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to create a User.
     */
    data: XOR<UserCreateInput, UserUncheckedCreateInput>
  }

  /**
   * User createMany
   */
  export type UserCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
  }

  /**
   * User createManyAndReturn
   */
  export type UserCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data used to create many Users.
     */
    data: UserCreateManyInput | UserCreateManyInput[]
  }

  /**
   * User update
   */
  export type UserUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The data needed to update a User.
     */
    data: XOR<UserUpdateInput, UserUncheckedUpdateInput>
    /**
     * Choose, which User to update.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User updateMany
   */
  export type UserUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Users.
     */
    data: XOR<UserUpdateManyMutationInput, UserUncheckedUpdateManyInput>
    /**
     * Filter which Users to update
     */
    where?: UserWhereInput
  }

  /**
   * User upsert
   */
  export type UserUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * The filter to search for the User to update in case it exists.
     */
    where: UserWhereUniqueInput
    /**
     * In case the User found by the `where` argument doesn't exist, create a new User with this data.
     */
    create: XOR<UserCreateInput, UserUncheckedCreateInput>
    /**
     * In case the User was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserUpdateInput, UserUncheckedUpdateInput>
  }

  /**
   * User delete
   */
  export type UserDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    /**
     * Filter which User to delete.
     */
    where: UserWhereUniqueInput
  }

  /**
   * User deleteMany
   */
  export type UserDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Users to delete
     */
    where?: UserWhereInput
  }

  /**
   * User.permissions
   */
  export type User$permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    where?: UserPermissionsWhereInput
    orderBy?: UserPermissionsOrderByWithRelationInput | UserPermissionsOrderByWithRelationInput[]
    cursor?: UserPermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * User.roles
   */
  export type User$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    where?: UserRolesWhereInput
    orderBy?: UserRolesOrderByWithRelationInput | UserRolesOrderByWithRelationInput[]
    cursor?: UserRolesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * User.user_detail
   */
  export type User$user_detailArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
  }

  /**
   * User.created
   */
  export type User$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * User.updated
   */
  export type User$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * User.deleted
   */
  export type User$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * User.created_users
   */
  export type User$created_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User.updated_users
   */
  export type User$updated_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User.deleted_users
   */
  export type User$deleted_usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
    orderBy?: UserOrderByWithRelationInput | UserOrderByWithRelationInput[]
    cursor?: UserWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserScalarFieldEnum | UserScalarFieldEnum[]
  }

  /**
   * User.created_user_details
   */
  export type User$created_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * User.updated_user_details
   */
  export type User$updated_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * User.deleted_user_details
   */
  export type User$deleted_user_detailsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    cursor?: UserDetailWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * User.created_languages
   */
  export type User$created_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * User.updated_languages
   */
  export type User$updated_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * User.deleted_languages
   */
  export type User$deleted_languagesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    cursor?: LanguageWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * User without action
   */
  export type UserDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
  }


  /**
   * Model UserDetail
   */

  export type AggregateUserDetail = {
    _count: UserDetailCountAggregateOutputType | null
    _avg: UserDetailAvgAggregateOutputType | null
    _sum: UserDetailSumAggregateOutputType | null
    _min: UserDetailMinAggregateOutputType | null
    _max: UserDetailMaxAggregateOutputType | null
  }

  export type UserDetailAvgAggregateOutputType = {
    id: number | null
    user_id: number | null
    designation_id: number | null
    department_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type UserDetailSumAggregateOutputType = {
    id: number | null
    user_id: number | null
    designation_id: number | null
    department_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type UserDetailMinAggregateOutputType = {
    id: number | null
    user_id: number | null
    code: string | null
    first_name: string | null
    last_name: string | null
    designation_id: number | null
    department_id: number | null
    profile_pic: string | null
    dob: Date | null
    country_code: string | null
    phone_number: string | null
    gender: string | null
    user_time_zone: string | null
    address: string | null
    culture: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type UserDetailMaxAggregateOutputType = {
    id: number | null
    user_id: number | null
    code: string | null
    first_name: string | null
    last_name: string | null
    designation_id: number | null
    department_id: number | null
    profile_pic: string | null
    dob: Date | null
    country_code: string | null
    phone_number: string | null
    gender: string | null
    user_time_zone: string | null
    address: string | null
    culture: string | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type UserDetailCountAggregateOutputType = {
    id: number
    user_id: number
    code: number
    first_name: number
    last_name: number
    designation_id: number
    department_id: number
    profile_pic: number
    dob: number
    country_code: number
    phone_number: number
    gender: number
    user_time_zone: number
    address: number
    culture: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    transfer_status: number
    _all: number
  }


  export type UserDetailAvgAggregateInputType = {
    id?: true
    user_id?: true
    designation_id?: true
    department_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type UserDetailSumAggregateInputType = {
    id?: true
    user_id?: true
    designation_id?: true
    department_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type UserDetailMinAggregateInputType = {
    id?: true
    user_id?: true
    code?: true
    first_name?: true
    last_name?: true
    designation_id?: true
    department_id?: true
    profile_pic?: true
    dob?: true
    country_code?: true
    phone_number?: true
    gender?: true
    user_time_zone?: true
    address?: true
    culture?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type UserDetailMaxAggregateInputType = {
    id?: true
    user_id?: true
    code?: true
    first_name?: true
    last_name?: true
    designation_id?: true
    department_id?: true
    profile_pic?: true
    dob?: true
    country_code?: true
    phone_number?: true
    gender?: true
    user_time_zone?: true
    address?: true
    culture?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type UserDetailCountAggregateInputType = {
    id?: true
    user_id?: true
    code?: true
    first_name?: true
    last_name?: true
    designation_id?: true
    department_id?: true
    profile_pic?: true
    dob?: true
    country_code?: true
    phone_number?: true
    gender?: true
    user_time_zone?: true
    address?: true
    culture?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
    _all?: true
  }

  export type UserDetailAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserDetail to aggregate.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserDetails
    **/
    _count?: true | UserDetailCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserDetailAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserDetailSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserDetailMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserDetailMaxAggregateInputType
  }

  export type GetUserDetailAggregateType<T extends UserDetailAggregateArgs> = {
        [P in keyof T & keyof AggregateUserDetail]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserDetail[P]>
      : GetScalarType<T[P], AggregateUserDetail[P]>
  }




  export type UserDetailGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserDetailWhereInput
    orderBy?: UserDetailOrderByWithAggregationInput | UserDetailOrderByWithAggregationInput[]
    by: UserDetailScalarFieldEnum[] | UserDetailScalarFieldEnum
    having?: UserDetailScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserDetailCountAggregateInputType | true
    _avg?: UserDetailAvgAggregateInputType
    _sum?: UserDetailSumAggregateInputType
    _min?: UserDetailMinAggregateInputType
    _max?: UserDetailMaxAggregateInputType
  }

  export type UserDetailGroupByOutputType = {
    id: number
    user_id: number
    code: string
    first_name: string
    last_name: string | null
    designation_id: number | null
    department_id: number | null
    profile_pic: string | null
    dob: Date | null
    country_code: string | null
    phone_number: string | null
    gender: string | null
    user_time_zone: string | null
    address: string | null
    culture: string | null
    company_id: number
    created_by: number
    updated_by: number | null
    deleted_by: number | null
    created_at: string
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
    _count: UserDetailCountAggregateOutputType | null
    _avg: UserDetailAvgAggregateOutputType | null
    _sum: UserDetailSumAggregateOutputType | null
    _min: UserDetailMinAggregateOutputType | null
    _max: UserDetailMaxAggregateOutputType | null
  }

  type GetUserDetailGroupByPayload<T extends UserDetailGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserDetailGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserDetailGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserDetailGroupByOutputType[P]>
            : GetScalarType<T[P], UserDetailGroupByOutputType[P]>
        }
      >
    >


  export type UserDetailSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    user_id?: boolean
    code?: boolean
    first_name?: boolean
    last_name?: boolean
    designation_id?: boolean
    department_id?: boolean
    profile_pic?: boolean
    dob?: boolean
    country_code?: boolean
    phone_number?: boolean
    gender?: boolean
    user_time_zone?: boolean
    address?: boolean
    culture?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    designation?: boolean | UserDetail$designationArgs<ExtArgs>
    department?: boolean | UserDetail$departmentArgs<ExtArgs>
    created?: boolean | UserDetail$createdArgs<ExtArgs>
    updated?: boolean | UserDetail$updatedArgs<ExtArgs>
    deleted?: boolean | UserDetail$deletedArgs<ExtArgs>
  }, ExtArgs["result"]["userDetail"]>

  export type UserDetailSelectScalar = {
    id?: boolean
    user_id?: boolean
    code?: boolean
    first_name?: boolean
    last_name?: boolean
    designation_id?: boolean
    department_id?: boolean
    profile_pic?: boolean
    dob?: boolean
    country_code?: boolean
    phone_number?: boolean
    gender?: boolean
    user_time_zone?: boolean
    address?: boolean
    culture?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
  }


  export type UserDetailInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    designation?: boolean | UserDetail$designationArgs<ExtArgs>
    department?: boolean | UserDetail$departmentArgs<ExtArgs>
    created?: boolean | UserDetail$createdArgs<ExtArgs>
    updated?: boolean | UserDetail$updatedArgs<ExtArgs>
    deleted?: boolean | UserDetail$deletedArgs<ExtArgs>
  }


  export type $UserDetailPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserDetail"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      designation: Prisma.$DesignationPayload<ExtArgs> | null
      department: Prisma.$DepartmentPayload<ExtArgs> | null
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      user_id: number
      code: string
      first_name: string
      last_name: string | null
      designation_id: number | null
      department_id: number | null
      profile_pic: string | null
      dob: Date | null
      country_code: string | null
      phone_number: string | null
      gender: string | null
      user_time_zone: string | null
      address: string | null
      culture: string | null
      company_id: number
      created_by: number
      updated_by: number | null
      deleted_by: number | null
      created_at: string
      updated_at: Date | null
      deleted_at: Date | null
      transfer_status: number | null
    }, ExtArgs["result"]["userDetail"]>
    composites: {}
  }


  type UserDetailGetPayload<S extends boolean | null | undefined | UserDetailDefaultArgs> = $Result.GetResult<Prisma.$UserDetailPayload, S>

  type UserDetailCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserDetailFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserDetailCountAggregateInputType | true
    }

  export interface UserDetailDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserDetail'], meta: { name: 'UserDetail' } }
    /**
     * Find zero or one UserDetail that matches the filter.
     * @param {UserDetailFindUniqueArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserDetailFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailFindUniqueArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one UserDetail that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserDetailFindUniqueOrThrowArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserDetailFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first UserDetail that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindFirstArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserDetailFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindFirstArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first UserDetail that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindFirstOrThrowArgs} args - Arguments to find a UserDetail
     * @example
     * // Get one UserDetail
     * const userDetail = await prisma.userDetail.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserDetailFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more UserDetails that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserDetails
     * const userDetails = await prisma.userDetail.findMany()
     * 
     * // Get first 10 UserDetails
     * const userDetails = await prisma.userDetail.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const userDetailWithIdOnly = await prisma.userDetail.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends UserDetailFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a UserDetail.
     * @param {UserDetailCreateArgs} args - Arguments to create a UserDetail.
     * @example
     * // Create one UserDetail
     * const UserDetail = await prisma.userDetail.create({
     *   data: {
     *     // ... data to create a UserDetail
     *   }
     * })
     * 
    **/
    create<T extends UserDetailCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailCreateArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many UserDetails.
     * @param {UserDetailCreateManyArgs} args - Arguments to create many UserDetails.
     * @example
     * // Create many UserDetails
     * const userDetail = await prisma.userDetail.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserDetailCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserDetails and returns the data saved in the database.
     * @param {UserDetailCreateManyAndReturnArgs} args - Arguments to create many UserDetails.
     * @example
     * // Create many UserDetails
     * const userDetail = await prisma.userDetail.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserDetails and only return the `id`
     * const userDetailWithIdOnly = await prisma.userDetail.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserDetailCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a UserDetail.
     * @param {UserDetailDeleteArgs} args - Arguments to delete one UserDetail.
     * @example
     * // Delete one UserDetail
     * const UserDetail = await prisma.userDetail.delete({
     *   where: {
     *     // ... filter to delete one UserDetail
     *   }
     * })
     * 
    **/
    delete<T extends UserDetailDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailDeleteArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one UserDetail.
     * @param {UserDetailUpdateArgs} args - Arguments to update one UserDetail.
     * @example
     * // Update one UserDetail
     * const userDetail = await prisma.userDetail.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserDetailUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailUpdateArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more UserDetails.
     * @param {UserDetailDeleteManyArgs} args - Arguments to filter UserDetails to delete.
     * @example
     * // Delete a few UserDetails
     * const { count } = await prisma.userDetail.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserDetailDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserDetailDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserDetails
     * const userDetail = await prisma.userDetail.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserDetailUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserDetail.
     * @param {UserDetailUpsertArgs} args - Arguments to update or create a UserDetail.
     * @example
     * // Update or create a UserDetail
     * const userDetail = await prisma.userDetail.upsert({
     *   create: {
     *     // ... data to create a UserDetail
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserDetail we want to update
     *   }
     * })
    **/
    upsert<T extends UserDetailUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserDetailUpsertArgs<ExtArgs>>
    ): Prisma__UserDetailClient<$Result.GetResult<Prisma.$UserDetailPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of UserDetails.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailCountArgs} args - Arguments to filter UserDetails to count.
     * @example
     * // Count the number of UserDetails
     * const count = await prisma.userDetail.count({
     *   where: {
     *     // ... the filter for the UserDetails we want to count
     *   }
     * })
    **/
    count<T extends UserDetailCountArgs>(
      args?: Subset<T, UserDetailCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserDetailCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserDetailAggregateArgs>(args: Subset<T, UserDetailAggregateArgs>): Prisma.PrismaPromise<GetUserDetailAggregateType<T>>

    /**
     * Group by UserDetail.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserDetailGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserDetailGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserDetailGroupByArgs['orderBy'] }
        : { orderBy?: UserDetailGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserDetailGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserDetailGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserDetail model
   */
  readonly fields: UserDetailFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserDetail.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserDetailClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    designation<T extends UserDetail$designationArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$designationArgs<ExtArgs>>): Prisma__DesignationClient<$Result.GetResult<Prisma.$DesignationPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    department<T extends UserDetail$departmentArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$departmentArgs<ExtArgs>>): Prisma__DepartmentClient<$Result.GetResult<Prisma.$DepartmentPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    created<T extends UserDetail$createdArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends UserDetail$updatedArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends UserDetail$deletedArgs<ExtArgs> = {}>(args?: Subset<T, UserDetail$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the UserDetail model
   */ 
  interface UserDetailFieldRefs {
    readonly id: FieldRef<"UserDetail", 'Int'>
    readonly user_id: FieldRef<"UserDetail", 'Int'>
    readonly code: FieldRef<"UserDetail", 'String'>
    readonly first_name: FieldRef<"UserDetail", 'String'>
    readonly last_name: FieldRef<"UserDetail", 'String'>
    readonly designation_id: FieldRef<"UserDetail", 'Int'>
    readonly department_id: FieldRef<"UserDetail", 'Int'>
    readonly profile_pic: FieldRef<"UserDetail", 'String'>
    readonly dob: FieldRef<"UserDetail", 'DateTime'>
    readonly country_code: FieldRef<"UserDetail", 'String'>
    readonly phone_number: FieldRef<"UserDetail", 'String'>
    readonly gender: FieldRef<"UserDetail", 'String'>
    readonly user_time_zone: FieldRef<"UserDetail", 'String'>
    readonly address: FieldRef<"UserDetail", 'String'>
    readonly culture: FieldRef<"UserDetail", 'String'>
    readonly company_id: FieldRef<"UserDetail", 'Int'>
    readonly created_by: FieldRef<"UserDetail", 'Int'>
    readonly updated_by: FieldRef<"UserDetail", 'Int'>
    readonly deleted_by: FieldRef<"UserDetail", 'Int'>
    readonly created_at: FieldRef<"UserDetail", 'String'>
    readonly updated_at: FieldRef<"UserDetail", 'DateTime'>
    readonly deleted_at: FieldRef<"UserDetail", 'DateTime'>
    readonly transfer_status: FieldRef<"UserDetail", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserDetail findUnique
   */
  export type UserDetailFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail findUniqueOrThrow
   */
  export type UserDetailFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail findFirst
   */
  export type UserDetailFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * UserDetail findFirstOrThrow
   */
  export type UserDetailFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetail to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserDetails.
     */
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * UserDetail findMany
   */
  export type UserDetailFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter, which UserDetails to fetch.
     */
    where?: UserDetailWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserDetails to fetch.
     */
    orderBy?: UserDetailOrderByWithRelationInput | UserDetailOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserDetails.
     */
    cursor?: UserDetailWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserDetails from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserDetails.
     */
    skip?: number
    distinct?: UserDetailScalarFieldEnum | UserDetailScalarFieldEnum[]
  }

  /**
   * UserDetail create
   */
  export type UserDetailCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The data needed to create a UserDetail.
     */
    data: XOR<UserDetailCreateInput, UserDetailUncheckedCreateInput>
  }

  /**
   * UserDetail createMany
   */
  export type UserDetailCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserDetails.
     */
    data: UserDetailCreateManyInput | UserDetailCreateManyInput[]
  }

  /**
   * UserDetail createManyAndReturn
   */
  export type UserDetailCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The data used to create many UserDetails.
     */
    data: UserDetailCreateManyInput | UserDetailCreateManyInput[]
  }

  /**
   * UserDetail update
   */
  export type UserDetailUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The data needed to update a UserDetail.
     */
    data: XOR<UserDetailUpdateInput, UserDetailUncheckedUpdateInput>
    /**
     * Choose, which UserDetail to update.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail updateMany
   */
  export type UserDetailUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserDetails.
     */
    data: XOR<UserDetailUpdateManyMutationInput, UserDetailUncheckedUpdateManyInput>
    /**
     * Filter which UserDetails to update
     */
    where?: UserDetailWhereInput
  }

  /**
   * UserDetail upsert
   */
  export type UserDetailUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * The filter to search for the UserDetail to update in case it exists.
     */
    where: UserDetailWhereUniqueInput
    /**
     * In case the UserDetail found by the `where` argument doesn't exist, create a new UserDetail with this data.
     */
    create: XOR<UserDetailCreateInput, UserDetailUncheckedCreateInput>
    /**
     * In case the UserDetail was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserDetailUpdateInput, UserDetailUncheckedUpdateInput>
  }

  /**
   * UserDetail delete
   */
  export type UserDetailDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
    /**
     * Filter which UserDetail to delete.
     */
    where: UserDetailWhereUniqueInput
  }

  /**
   * UserDetail deleteMany
   */
  export type UserDetailDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserDetails to delete
     */
    where?: UserDetailWhereInput
  }

  /**
   * UserDetail.designation
   */
  export type UserDetail$designationArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Designation
     */
    select?: DesignationSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DesignationInclude<ExtArgs> | null
    where?: DesignationWhereInput
  }

  /**
   * UserDetail.department
   */
  export type UserDetail$departmentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Department
     */
    select?: DepartmentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: DepartmentInclude<ExtArgs> | null
    where?: DepartmentWhereInput
  }

  /**
   * UserDetail.created
   */
  export type UserDetail$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * UserDetail.updated
   */
  export type UserDetail$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * UserDetail.deleted
   */
  export type UserDetail$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * UserDetail without action
   */
  export type UserDetailDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserDetail
     */
    select?: UserDetailSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserDetailInclude<ExtArgs> | null
  }


  /**
   * Model UserRoles
   */

  export type AggregateUserRoles = {
    _count: UserRolesCountAggregateOutputType | null
    _avg: UserRolesAvgAggregateOutputType | null
    _sum: UserRolesSumAggregateOutputType | null
    _min: UserRolesMinAggregateOutputType | null
    _max: UserRolesMaxAggregateOutputType | null
  }

  export type UserRolesAvgAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserRolesSumAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserRolesMinAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserRolesMaxAggregateOutputType = {
    user_id: number | null
    role_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserRolesCountAggregateOutputType = {
    user_id: number
    role_id: number
    company_id: number
    transfer_status: number
    _all: number
  }


  export type UserRolesAvgAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserRolesSumAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserRolesMinAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserRolesMaxAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserRolesCountAggregateInputType = {
    user_id?: true
    role_id?: true
    company_id?: true
    transfer_status?: true
    _all?: true
  }

  export type UserRolesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserRoles to aggregate.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationInput | UserRolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserRoles
    **/
    _count?: true | UserRolesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserRolesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserRolesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserRolesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserRolesMaxAggregateInputType
  }

  export type GetUserRolesAggregateType<T extends UserRolesAggregateArgs> = {
        [P in keyof T & keyof AggregateUserRoles]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserRoles[P]>
      : GetScalarType<T[P], AggregateUserRoles[P]>
  }




  export type UserRolesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserRolesWhereInput
    orderBy?: UserRolesOrderByWithAggregationInput | UserRolesOrderByWithAggregationInput[]
    by: UserRolesScalarFieldEnum[] | UserRolesScalarFieldEnum
    having?: UserRolesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserRolesCountAggregateInputType | true
    _avg?: UserRolesAvgAggregateInputType
    _sum?: UserRolesSumAggregateInputType
    _min?: UserRolesMinAggregateInputType
    _max?: UserRolesMaxAggregateInputType
  }

  export type UserRolesGroupByOutputType = {
    user_id: number
    role_id: number
    company_id: number
    transfer_status: number | null
    _count: UserRolesCountAggregateOutputType | null
    _avg: UserRolesAvgAggregateOutputType | null
    _sum: UserRolesSumAggregateOutputType | null
    _min: UserRolesMinAggregateOutputType | null
    _max: UserRolesMaxAggregateOutputType | null
  }

  type GetUserRolesGroupByPayload<T extends UserRolesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserRolesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserRolesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserRolesGroupByOutputType[P]>
            : GetScalarType<T[P], UserRolesGroupByOutputType[P]>
        }
      >
    >


  export type UserRolesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    role_id?: boolean
    company_id?: boolean
    transfer_status?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userRoles"]>

  export type UserRolesSelectScalar = {
    user_id?: boolean
    role_id?: boolean
    company_id?: boolean
    transfer_status?: boolean
  }


  export type UserRolesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    role?: boolean | RoleDefaultArgs<ExtArgs>
  }


  export type $UserRolesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserRoles"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      role: Prisma.$RolePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      user_id: number
      role_id: number
      company_id: number
      transfer_status: number | null
    }, ExtArgs["result"]["userRoles"]>
    composites: {}
  }


  type UserRolesGetPayload<S extends boolean | null | undefined | UserRolesDefaultArgs> = $Result.GetResult<Prisma.$UserRolesPayload, S>

  type UserRolesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserRolesFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserRolesCountAggregateInputType | true
    }

  export interface UserRolesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserRoles'], meta: { name: 'UserRoles' } }
    /**
     * Find zero or one UserRoles that matches the filter.
     * @param {UserRolesFindUniqueArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserRolesFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesFindUniqueArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one UserRoles that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserRolesFindUniqueOrThrowArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserRolesFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first UserRoles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesFindFirstArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserRolesFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindFirstArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first UserRoles that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesFindFirstOrThrowArgs} args - Arguments to find a UserRoles
     * @example
     * // Get one UserRoles
     * const userRoles = await prisma.userRoles.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserRolesFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more UserRoles that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserRoles
     * const userRoles = await prisma.userRoles.findMany()
     * 
     * // Get first 10 UserRoles
     * const userRoles = await prisma.userRoles.findMany({ take: 10 })
     * 
     * // Only select the `user_id`
     * const userRolesWithUser_idOnly = await prisma.userRoles.findMany({ select: { user_id: true } })
     * 
    **/
    findMany<T extends UserRolesFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a UserRoles.
     * @param {UserRolesCreateArgs} args - Arguments to create a UserRoles.
     * @example
     * // Create one UserRoles
     * const UserRoles = await prisma.userRoles.create({
     *   data: {
     *     // ... data to create a UserRoles
     *   }
     * })
     * 
    **/
    create<T extends UserRolesCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesCreateArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many UserRoles.
     * @param {UserRolesCreateManyArgs} args - Arguments to create many UserRoles.
     * @example
     * // Create many UserRoles
     * const userRoles = await prisma.userRoles.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserRolesCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserRoles and returns the data saved in the database.
     * @param {UserRolesCreateManyAndReturnArgs} args - Arguments to create many UserRoles.
     * @example
     * // Create many UserRoles
     * const userRoles = await prisma.userRoles.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserRoles and only return the `user_id`
     * const userRolesWithUser_idOnly = await prisma.userRoles.createManyAndReturn({ 
     *   select: { user_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserRolesCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a UserRoles.
     * @param {UserRolesDeleteArgs} args - Arguments to delete one UserRoles.
     * @example
     * // Delete one UserRoles
     * const UserRoles = await prisma.userRoles.delete({
     *   where: {
     *     // ... filter to delete one UserRoles
     *   }
     * })
     * 
    **/
    delete<T extends UserRolesDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesDeleteArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one UserRoles.
     * @param {UserRolesUpdateArgs} args - Arguments to update one UserRoles.
     * @example
     * // Update one UserRoles
     * const userRoles = await prisma.userRoles.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserRolesUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesUpdateArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more UserRoles.
     * @param {UserRolesDeleteManyArgs} args - Arguments to filter UserRoles to delete.
     * @example
     * // Delete a few UserRoles
     * const { count } = await prisma.userRoles.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserRolesDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserRolesDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserRoles
     * const userRoles = await prisma.userRoles.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserRolesUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserRoles.
     * @param {UserRolesUpsertArgs} args - Arguments to update or create a UserRoles.
     * @example
     * // Update or create a UserRoles
     * const userRoles = await prisma.userRoles.upsert({
     *   create: {
     *     // ... data to create a UserRoles
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserRoles we want to update
     *   }
     * })
    **/
    upsert<T extends UserRolesUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserRolesUpsertArgs<ExtArgs>>
    ): Prisma__UserRolesClient<$Result.GetResult<Prisma.$UserRolesPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesCountArgs} args - Arguments to filter UserRoles to count.
     * @example
     * // Count the number of UserRoles
     * const count = await prisma.userRoles.count({
     *   where: {
     *     // ... the filter for the UserRoles we want to count
     *   }
     * })
    **/
    count<T extends UserRolesCountArgs>(
      args?: Subset<T, UserRolesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserRolesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserRolesAggregateArgs>(args: Subset<T, UserRolesAggregateArgs>): Prisma.PrismaPromise<GetUserRolesAggregateType<T>>

    /**
     * Group by UserRoles.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserRolesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserRolesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserRolesGroupByArgs['orderBy'] }
        : { orderBy?: UserRolesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserRolesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserRolesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserRoles model
   */
  readonly fields: UserRolesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserRoles.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserRolesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    role<T extends RoleDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RoleDefaultArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the UserRoles model
   */ 
  interface UserRolesFieldRefs {
    readonly user_id: FieldRef<"UserRoles", 'Int'>
    readonly role_id: FieldRef<"UserRoles", 'Int'>
    readonly company_id: FieldRef<"UserRoles", 'Int'>
    readonly transfer_status: FieldRef<"UserRoles", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserRoles findUnique
   */
  export type UserRolesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles findUniqueOrThrow
   */
  export type UserRolesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles findFirst
   */
  export type UserRolesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationInput | UserRolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserRoles.
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserRoles.
     */
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * UserRoles findFirstOrThrow
   */
  export type UserRolesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationInput | UserRolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserRoles.
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserRoles.
     */
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * UserRoles findMany
   */
  export type UserRolesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter, which UserRoles to fetch.
     */
    where?: UserRolesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserRoles to fetch.
     */
    orderBy?: UserRolesOrderByWithRelationInput | UserRolesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserRoles.
     */
    cursor?: UserRolesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserRoles from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserRoles.
     */
    skip?: number
    distinct?: UserRolesScalarFieldEnum | UserRolesScalarFieldEnum[]
  }

  /**
   * UserRoles create
   */
  export type UserRolesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The data needed to create a UserRoles.
     */
    data: XOR<UserRolesCreateInput, UserRolesUncheckedCreateInput>
  }

  /**
   * UserRoles createMany
   */
  export type UserRolesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserRoles.
     */
    data: UserRolesCreateManyInput | UserRolesCreateManyInput[]
  }

  /**
   * UserRoles createManyAndReturn
   */
  export type UserRolesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The data used to create many UserRoles.
     */
    data: UserRolesCreateManyInput | UserRolesCreateManyInput[]
  }

  /**
   * UserRoles update
   */
  export type UserRolesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The data needed to update a UserRoles.
     */
    data: XOR<UserRolesUpdateInput, UserRolesUncheckedUpdateInput>
    /**
     * Choose, which UserRoles to update.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles updateMany
   */
  export type UserRolesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserRoles.
     */
    data: XOR<UserRolesUpdateManyMutationInput, UserRolesUncheckedUpdateManyInput>
    /**
     * Filter which UserRoles to update
     */
    where?: UserRolesWhereInput
  }

  /**
   * UserRoles upsert
   */
  export type UserRolesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * The filter to search for the UserRoles to update in case it exists.
     */
    where: UserRolesWhereUniqueInput
    /**
     * In case the UserRoles found by the `where` argument doesn't exist, create a new UserRoles with this data.
     */
    create: XOR<UserRolesCreateInput, UserRolesUncheckedCreateInput>
    /**
     * In case the UserRoles was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserRolesUpdateInput, UserRolesUncheckedUpdateInput>
  }

  /**
   * UserRoles delete
   */
  export type UserRolesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
    /**
     * Filter which UserRoles to delete.
     */
    where: UserRolesWhereUniqueInput
  }

  /**
   * UserRoles deleteMany
   */
  export type UserRolesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserRoles to delete
     */
    where?: UserRolesWhereInput
  }

  /**
   * UserRoles without action
   */
  export type UserRolesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserRoles
     */
    select?: UserRolesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserRolesInclude<ExtArgs> | null
  }


  /**
   * Model CategoryTypes
   */

  export type AggregateCategoryTypes = {
    _count: CategoryTypesCountAggregateOutputType | null
    _avg: CategoryTypesAvgAggregateOutputType | null
    _sum: CategoryTypesSumAggregateOutputType | null
    _min: CategoryTypesMinAggregateOutputType | null
    _max: CategoryTypesMaxAggregateOutputType | null
  }

  export type CategoryTypesAvgAggregateOutputType = {
    id: number | null
    transfer_status: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type CategoryTypesSumAggregateOutputType = {
    id: number | null
    transfer_status: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
  }

  export type CategoryTypesMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    category_type_id: string | null
    name: string | null
    description: string | null
    transfer_status: number | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
  }

  export type CategoryTypesMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    category_type_id: string | null
    name: string | null
    description: string | null
    transfer_status: number | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
  }

  export type CategoryTypesCountAggregateOutputType = {
    id: number
    uuid: number
    category_type_id: number
    name: number
    description: number
    transfer_status: number
    company_id: number
    created_at: number
    created_by: number
    updated_at: number
    updated_by: number
    deleted_at: number
    deleted_by: number
    _all: number
  }


  export type CategoryTypesAvgAggregateInputType = {
    id?: true
    transfer_status?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type CategoryTypesSumAggregateInputType = {
    id?: true
    transfer_status?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
  }

  export type CategoryTypesMinAggregateInputType = {
    id?: true
    uuid?: true
    category_type_id?: true
    name?: true
    description?: true
    transfer_status?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
  }

  export type CategoryTypesMaxAggregateInputType = {
    id?: true
    uuid?: true
    category_type_id?: true
    name?: true
    description?: true
    transfer_status?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
  }

  export type CategoryTypesCountAggregateInputType = {
    id?: true
    uuid?: true
    category_type_id?: true
    name?: true
    description?: true
    transfer_status?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    _all?: true
  }

  export type CategoryTypesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which CategoryTypes to aggregate.
     */
    where?: CategoryTypesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CategoryTypes to fetch.
     */
    orderBy?: CategoryTypesOrderByWithRelationInput | CategoryTypesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CategoryTypesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CategoryTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CategoryTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned CategoryTypes
    **/
    _count?: true | CategoryTypesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CategoryTypesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CategoryTypesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CategoryTypesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CategoryTypesMaxAggregateInputType
  }

  export type GetCategoryTypesAggregateType<T extends CategoryTypesAggregateArgs> = {
        [P in keyof T & keyof AggregateCategoryTypes]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCategoryTypes[P]>
      : GetScalarType<T[P], AggregateCategoryTypes[P]>
  }




  export type CategoryTypesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoryTypesWhereInput
    orderBy?: CategoryTypesOrderByWithAggregationInput | CategoryTypesOrderByWithAggregationInput[]
    by: CategoryTypesScalarFieldEnum[] | CategoryTypesScalarFieldEnum
    having?: CategoryTypesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CategoryTypesCountAggregateInputType | true
    _avg?: CategoryTypesAvgAggregateInputType
    _sum?: CategoryTypesSumAggregateInputType
    _min?: CategoryTypesMinAggregateInputType
    _max?: CategoryTypesMaxAggregateInputType
  }

  export type CategoryTypesGroupByOutputType = {
    id: number
    uuid: string
    category_type_id: string
    name: string
    description: string | null
    transfer_status: number | null
    company_id: number
    created_at: string
    created_by: number
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    _count: CategoryTypesCountAggregateOutputType | null
    _avg: CategoryTypesAvgAggregateOutputType | null
    _sum: CategoryTypesSumAggregateOutputType | null
    _min: CategoryTypesMinAggregateOutputType | null
    _max: CategoryTypesMaxAggregateOutputType | null
  }

  type GetCategoryTypesGroupByPayload<T extends CategoryTypesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CategoryTypesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CategoryTypesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CategoryTypesGroupByOutputType[P]>
            : GetScalarType<T[P], CategoryTypesGroupByOutputType[P]>
        }
      >
    >


  export type CategoryTypesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    category_type_id?: boolean
    name?: boolean
    description?: boolean
    transfer_status?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    categories?: boolean | CategoryTypes$categoriesArgs<ExtArgs>
    _count?: boolean | CategoryTypesCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["categoryTypes"]>

  export type CategoryTypesSelectScalar = {
    id?: boolean
    uuid?: boolean
    category_type_id?: boolean
    name?: boolean
    description?: boolean
    transfer_status?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
  }


  export type CategoryTypesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    categories?: boolean | CategoryTypes$categoriesArgs<ExtArgs>
    _count?: boolean | CategoryTypesCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $CategoryTypesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "CategoryTypes"
    objects: {
      categories: Prisma.$CategoriesPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      category_type_id: string
      name: string
      description: string | null
      transfer_status: number | null
      company_id: number
      created_at: string
      created_by: number
      updated_at: Date | null
      updated_by: number | null
      deleted_at: Date | null
      deleted_by: number | null
    }, ExtArgs["result"]["categoryTypes"]>
    composites: {}
  }


  type CategoryTypesGetPayload<S extends boolean | null | undefined | CategoryTypesDefaultArgs> = $Result.GetResult<Prisma.$CategoryTypesPayload, S>

  type CategoryTypesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<CategoryTypesFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: CategoryTypesCountAggregateInputType | true
    }

  export interface CategoryTypesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['CategoryTypes'], meta: { name: 'CategoryTypes' } }
    /**
     * Find zero or one CategoryTypes that matches the filter.
     * @param {CategoryTypesFindUniqueArgs} args - Arguments to find a CategoryTypes
     * @example
     * // Get one CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends CategoryTypesFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, CategoryTypesFindUniqueArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one CategoryTypes that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {CategoryTypesFindUniqueOrThrowArgs} args - Arguments to find a CategoryTypes
     * @example
     * // Get one CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends CategoryTypesFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first CategoryTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesFindFirstArgs} args - Arguments to find a CategoryTypes
     * @example
     * // Get one CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends CategoryTypesFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesFindFirstArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first CategoryTypes that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesFindFirstOrThrowArgs} args - Arguments to find a CategoryTypes
     * @example
     * // Get one CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends CategoryTypesFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more CategoryTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.findMany()
     * 
     * // Get first 10 CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const categoryTypesWithIdOnly = await prisma.categoryTypes.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends CategoryTypesFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a CategoryTypes.
     * @param {CategoryTypesCreateArgs} args - Arguments to create a CategoryTypes.
     * @example
     * // Create one CategoryTypes
     * const CategoryTypes = await prisma.categoryTypes.create({
     *   data: {
     *     // ... data to create a CategoryTypes
     *   }
     * })
     * 
    **/
    create<T extends CategoryTypesCreateArgs<ExtArgs>>(
      args: SelectSubset<T, CategoryTypesCreateArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many CategoryTypes.
     * @param {CategoryTypesCreateManyArgs} args - Arguments to create many CategoryTypes.
     * @example
     * // Create many CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends CategoryTypesCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many CategoryTypes and returns the data saved in the database.
     * @param {CategoryTypesCreateManyAndReturnArgs} args - Arguments to create many CategoryTypes.
     * @example
     * // Create many CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many CategoryTypes and only return the `id`
     * const categoryTypesWithIdOnly = await prisma.categoryTypes.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends CategoryTypesCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a CategoryTypes.
     * @param {CategoryTypesDeleteArgs} args - Arguments to delete one CategoryTypes.
     * @example
     * // Delete one CategoryTypes
     * const CategoryTypes = await prisma.categoryTypes.delete({
     *   where: {
     *     // ... filter to delete one CategoryTypes
     *   }
     * })
     * 
    **/
    delete<T extends CategoryTypesDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, CategoryTypesDeleteArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one CategoryTypes.
     * @param {CategoryTypesUpdateArgs} args - Arguments to update one CategoryTypes.
     * @example
     * // Update one CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends CategoryTypesUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, CategoryTypesUpdateArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more CategoryTypes.
     * @param {CategoryTypesDeleteManyArgs} args - Arguments to filter CategoryTypes to delete.
     * @example
     * // Delete a few CategoryTypes
     * const { count } = await prisma.categoryTypes.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends CategoryTypesDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoryTypesDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more CategoryTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends CategoryTypesUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, CategoryTypesUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one CategoryTypes.
     * @param {CategoryTypesUpsertArgs} args - Arguments to update or create a CategoryTypes.
     * @example
     * // Update or create a CategoryTypes
     * const categoryTypes = await prisma.categoryTypes.upsert({
     *   create: {
     *     // ... data to create a CategoryTypes
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the CategoryTypes we want to update
     *   }
     * })
    **/
    upsert<T extends CategoryTypesUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, CategoryTypesUpsertArgs<ExtArgs>>
    ): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of CategoryTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesCountArgs} args - Arguments to filter CategoryTypes to count.
     * @example
     * // Count the number of CategoryTypes
     * const count = await prisma.categoryTypes.count({
     *   where: {
     *     // ... the filter for the CategoryTypes we want to count
     *   }
     * })
    **/
    count<T extends CategoryTypesCountArgs>(
      args?: Subset<T, CategoryTypesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CategoryTypesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a CategoryTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CategoryTypesAggregateArgs>(args: Subset<T, CategoryTypesAggregateArgs>): Prisma.PrismaPromise<GetCategoryTypesAggregateType<T>>

    /**
     * Group by CategoryTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoryTypesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CategoryTypesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CategoryTypesGroupByArgs['orderBy'] }
        : { orderBy?: CategoryTypesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CategoryTypesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCategoryTypesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the CategoryTypes model
   */
  readonly fields: CategoryTypesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for CategoryTypes.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CategoryTypesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    categories<T extends CategoryTypes$categoriesArgs<ExtArgs> = {}>(args?: Subset<T, CategoryTypes$categoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the CategoryTypes model
   */ 
  interface CategoryTypesFieldRefs {
    readonly id: FieldRef<"CategoryTypes", 'Int'>
    readonly uuid: FieldRef<"CategoryTypes", 'String'>
    readonly category_type_id: FieldRef<"CategoryTypes", 'String'>
    readonly name: FieldRef<"CategoryTypes", 'String'>
    readonly description: FieldRef<"CategoryTypes", 'String'>
    readonly transfer_status: FieldRef<"CategoryTypes", 'Int'>
    readonly company_id: FieldRef<"CategoryTypes", 'Int'>
    readonly created_at: FieldRef<"CategoryTypes", 'String'>
    readonly created_by: FieldRef<"CategoryTypes", 'Int'>
    readonly updated_at: FieldRef<"CategoryTypes", 'DateTime'>
    readonly updated_by: FieldRef<"CategoryTypes", 'Int'>
    readonly deleted_at: FieldRef<"CategoryTypes", 'DateTime'>
    readonly deleted_by: FieldRef<"CategoryTypes", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * CategoryTypes findUnique
   */
  export type CategoryTypesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * Filter, which CategoryTypes to fetch.
     */
    where: CategoryTypesWhereUniqueInput
  }

  /**
   * CategoryTypes findUniqueOrThrow
   */
  export type CategoryTypesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * Filter, which CategoryTypes to fetch.
     */
    where: CategoryTypesWhereUniqueInput
  }

  /**
   * CategoryTypes findFirst
   */
  export type CategoryTypesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * Filter, which CategoryTypes to fetch.
     */
    where?: CategoryTypesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CategoryTypes to fetch.
     */
    orderBy?: CategoryTypesOrderByWithRelationInput | CategoryTypesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for CategoryTypes.
     */
    cursor?: CategoryTypesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CategoryTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CategoryTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of CategoryTypes.
     */
    distinct?: CategoryTypesScalarFieldEnum | CategoryTypesScalarFieldEnum[]
  }

  /**
   * CategoryTypes findFirstOrThrow
   */
  export type CategoryTypesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * Filter, which CategoryTypes to fetch.
     */
    where?: CategoryTypesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CategoryTypes to fetch.
     */
    orderBy?: CategoryTypesOrderByWithRelationInput | CategoryTypesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for CategoryTypes.
     */
    cursor?: CategoryTypesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CategoryTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CategoryTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of CategoryTypes.
     */
    distinct?: CategoryTypesScalarFieldEnum | CategoryTypesScalarFieldEnum[]
  }

  /**
   * CategoryTypes findMany
   */
  export type CategoryTypesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * Filter, which CategoryTypes to fetch.
     */
    where?: CategoryTypesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of CategoryTypes to fetch.
     */
    orderBy?: CategoryTypesOrderByWithRelationInput | CategoryTypesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing CategoryTypes.
     */
    cursor?: CategoryTypesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` CategoryTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` CategoryTypes.
     */
    skip?: number
    distinct?: CategoryTypesScalarFieldEnum | CategoryTypesScalarFieldEnum[]
  }

  /**
   * CategoryTypes create
   */
  export type CategoryTypesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * The data needed to create a CategoryTypes.
     */
    data: XOR<CategoryTypesCreateInput, CategoryTypesUncheckedCreateInput>
  }

  /**
   * CategoryTypes createMany
   */
  export type CategoryTypesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many CategoryTypes.
     */
    data: CategoryTypesCreateManyInput | CategoryTypesCreateManyInput[]
  }

  /**
   * CategoryTypes createManyAndReturn
   */
  export type CategoryTypesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * The data used to create many CategoryTypes.
     */
    data: CategoryTypesCreateManyInput | CategoryTypesCreateManyInput[]
  }

  /**
   * CategoryTypes update
   */
  export type CategoryTypesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * The data needed to update a CategoryTypes.
     */
    data: XOR<CategoryTypesUpdateInput, CategoryTypesUncheckedUpdateInput>
    /**
     * Choose, which CategoryTypes to update.
     */
    where: CategoryTypesWhereUniqueInput
  }

  /**
   * CategoryTypes updateMany
   */
  export type CategoryTypesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update CategoryTypes.
     */
    data: XOR<CategoryTypesUpdateManyMutationInput, CategoryTypesUncheckedUpdateManyInput>
    /**
     * Filter which CategoryTypes to update
     */
    where?: CategoryTypesWhereInput
  }

  /**
   * CategoryTypes upsert
   */
  export type CategoryTypesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * The filter to search for the CategoryTypes to update in case it exists.
     */
    where: CategoryTypesWhereUniqueInput
    /**
     * In case the CategoryTypes found by the `where` argument doesn't exist, create a new CategoryTypes with this data.
     */
    create: XOR<CategoryTypesCreateInput, CategoryTypesUncheckedCreateInput>
    /**
     * In case the CategoryTypes was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CategoryTypesUpdateInput, CategoryTypesUncheckedUpdateInput>
  }

  /**
   * CategoryTypes delete
   */
  export type CategoryTypesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
    /**
     * Filter which CategoryTypes to delete.
     */
    where: CategoryTypesWhereUniqueInput
  }

  /**
   * CategoryTypes deleteMany
   */
  export type CategoryTypesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which CategoryTypes to delete
     */
    where?: CategoryTypesWhereInput
  }

  /**
   * CategoryTypes.categories
   */
  export type CategoryTypes$categoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    where?: CategoriesWhereInput
    orderBy?: CategoriesOrderByWithRelationInput | CategoriesOrderByWithRelationInput[]
    cursor?: CategoriesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * CategoryTypes without action
   */
  export type CategoryTypesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the CategoryTypes
     */
    select?: CategoryTypesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoryTypesInclude<ExtArgs> | null
  }


  /**
   * Model Categories
   */

  export type AggregateCategories = {
    _count: CategoriesCountAggregateOutputType | null
    _avg: CategoriesAvgAggregateOutputType | null
    _sum: CategoriesSumAggregateOutputType | null
    _min: CategoriesMinAggregateOutputType | null
    _max: CategoriesMaxAggregateOutputType | null
  }

  export type CategoriesAvgAggregateOutputType = {
    id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type CategoriesSumAggregateOutputType = {
    id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type CategoriesMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    category_type_id: string | null
    category_id: string | null
    parent_id: string | null
    name: string | null
    description: string | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type CategoriesMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    category_type_id: string | null
    category_id: string | null
    parent_id: string | null
    name: string | null
    description: string | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type CategoriesCountAggregateOutputType = {
    id: number
    uuid: number
    category_type_id: number
    category_id: number
    parent_id: number
    name: number
    description: number
    company_id: number
    created_at: number
    created_by: number
    updated_at: number
    updated_by: number
    deleted_at: number
    deleted_by: number
    transfer_status: number
    _all: number
  }


  export type CategoriesAvgAggregateInputType = {
    id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type CategoriesSumAggregateInputType = {
    id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type CategoriesMinAggregateInputType = {
    id?: true
    uuid?: true
    category_type_id?: true
    category_id?: true
    parent_id?: true
    name?: true
    description?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type CategoriesMaxAggregateInputType = {
    id?: true
    uuid?: true
    category_type_id?: true
    category_id?: true
    parent_id?: true
    name?: true
    description?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type CategoriesCountAggregateInputType = {
    id?: true
    uuid?: true
    category_type_id?: true
    category_id?: true
    parent_id?: true
    name?: true
    description?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
    _all?: true
  }

  export type CategoriesAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Categories to aggregate.
     */
    where?: CategoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoriesOrderByWithRelationInput | CategoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: CategoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Categories
    **/
    _count?: true | CategoriesCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: CategoriesAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: CategoriesSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: CategoriesMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: CategoriesMaxAggregateInputType
  }

  export type GetCategoriesAggregateType<T extends CategoriesAggregateArgs> = {
        [P in keyof T & keyof AggregateCategories]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateCategories[P]>
      : GetScalarType<T[P], AggregateCategories[P]>
  }




  export type CategoriesGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: CategoriesWhereInput
    orderBy?: CategoriesOrderByWithAggregationInput | CategoriesOrderByWithAggregationInput[]
    by: CategoriesScalarFieldEnum[] | CategoriesScalarFieldEnum
    having?: CategoriesScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: CategoriesCountAggregateInputType | true
    _avg?: CategoriesAvgAggregateInputType
    _sum?: CategoriesSumAggregateInputType
    _min?: CategoriesMinAggregateInputType
    _max?: CategoriesMaxAggregateInputType
  }

  export type CategoriesGroupByOutputType = {
    id: number
    uuid: string
    category_type_id: string
    category_id: string
    parent_id: string | null
    name: string
    description: string | null
    company_id: number
    created_at: string
    created_by: number
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
    _count: CategoriesCountAggregateOutputType | null
    _avg: CategoriesAvgAggregateOutputType | null
    _sum: CategoriesSumAggregateOutputType | null
    _min: CategoriesMinAggregateOutputType | null
    _max: CategoriesMaxAggregateOutputType | null
  }

  type GetCategoriesGroupByPayload<T extends CategoriesGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<CategoriesGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof CategoriesGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], CategoriesGroupByOutputType[P]>
            : GetScalarType<T[P], CategoriesGroupByOutputType[P]>
        }
      >
    >


  export type CategoriesSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    category_type_id?: boolean
    category_id?: boolean
    parent_id?: boolean
    name?: boolean
    description?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
    parent?: boolean | Categories$parentArgs<ExtArgs>
    subcategories?: boolean | Categories$subcategoriesArgs<ExtArgs>
    category_type?: boolean | CategoryTypesDefaultArgs<ExtArgs>
    configurations?: boolean | Categories$configurationsArgs<ExtArgs>
    _count?: boolean | CategoriesCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["categories"]>

  export type CategoriesSelectScalar = {
    id?: boolean
    uuid?: boolean
    category_type_id?: boolean
    category_id?: boolean
    parent_id?: boolean
    name?: boolean
    description?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
  }


  export type CategoriesInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    parent?: boolean | Categories$parentArgs<ExtArgs>
    subcategories?: boolean | Categories$subcategoriesArgs<ExtArgs>
    category_type?: boolean | CategoryTypesDefaultArgs<ExtArgs>
    configurations?: boolean | Categories$configurationsArgs<ExtArgs>
    _count?: boolean | CategoriesCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $CategoriesPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Categories"
    objects: {
      parent: Prisma.$CategoriesPayload<ExtArgs> | null
      subcategories: Prisma.$CategoriesPayload<ExtArgs>[]
      category_type: Prisma.$CategoryTypesPayload<ExtArgs>
      configurations: Prisma.$ConfigurationsPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      category_type_id: string
      category_id: string
      parent_id: string | null
      name: string
      description: string | null
      company_id: number
      created_at: string
      created_by: number
      updated_at: Date | null
      updated_by: number | null
      deleted_at: Date | null
      deleted_by: number | null
      transfer_status: number | null
    }, ExtArgs["result"]["categories"]>
    composites: {}
  }


  type CategoriesGetPayload<S extends boolean | null | undefined | CategoriesDefaultArgs> = $Result.GetResult<Prisma.$CategoriesPayload, S>

  type CategoriesCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<CategoriesFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: CategoriesCountAggregateInputType | true
    }

  export interface CategoriesDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Categories'], meta: { name: 'Categories' } }
    /**
     * Find zero or one Categories that matches the filter.
     * @param {CategoriesFindUniqueArgs} args - Arguments to find a Categories
     * @example
     * // Get one Categories
     * const categories = await prisma.categories.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends CategoriesFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, CategoriesFindUniqueArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Categories that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {CategoriesFindUniqueOrThrowArgs} args - Arguments to find a Categories
     * @example
     * // Get one Categories
     * const categories = await prisma.categories.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends CategoriesFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Categories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesFindFirstArgs} args - Arguments to find a Categories
     * @example
     * // Get one Categories
     * const categories = await prisma.categories.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends CategoriesFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesFindFirstArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Categories that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesFindFirstOrThrowArgs} args - Arguments to find a Categories
     * @example
     * // Get one Categories
     * const categories = await prisma.categories.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends CategoriesFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Categories that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Categories
     * const categories = await prisma.categories.findMany()
     * 
     * // Get first 10 Categories
     * const categories = await prisma.categories.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const categoriesWithIdOnly = await prisma.categories.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends CategoriesFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Categories.
     * @param {CategoriesCreateArgs} args - Arguments to create a Categories.
     * @example
     * // Create one Categories
     * const Categories = await prisma.categories.create({
     *   data: {
     *     // ... data to create a Categories
     *   }
     * })
     * 
    **/
    create<T extends CategoriesCreateArgs<ExtArgs>>(
      args: SelectSubset<T, CategoriesCreateArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Categories.
     * @param {CategoriesCreateManyArgs} args - Arguments to create many Categories.
     * @example
     * // Create many Categories
     * const categories = await prisma.categories.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends CategoriesCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Categories and returns the data saved in the database.
     * @param {CategoriesCreateManyAndReturnArgs} args - Arguments to create many Categories.
     * @example
     * // Create many Categories
     * const categories = await prisma.categories.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Categories and only return the `id`
     * const categoriesWithIdOnly = await prisma.categories.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends CategoriesCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Categories.
     * @param {CategoriesDeleteArgs} args - Arguments to delete one Categories.
     * @example
     * // Delete one Categories
     * const Categories = await prisma.categories.delete({
     *   where: {
     *     // ... filter to delete one Categories
     *   }
     * })
     * 
    **/
    delete<T extends CategoriesDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, CategoriesDeleteArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Categories.
     * @param {CategoriesUpdateArgs} args - Arguments to update one Categories.
     * @example
     * // Update one Categories
     * const categories = await prisma.categories.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends CategoriesUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, CategoriesUpdateArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Categories.
     * @param {CategoriesDeleteManyArgs} args - Arguments to filter Categories to delete.
     * @example
     * // Delete a few Categories
     * const { count } = await prisma.categories.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends CategoriesDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, CategoriesDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Categories
     * const categories = await prisma.categories.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends CategoriesUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, CategoriesUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Categories.
     * @param {CategoriesUpsertArgs} args - Arguments to update or create a Categories.
     * @example
     * // Update or create a Categories
     * const categories = await prisma.categories.upsert({
     *   create: {
     *     // ... data to create a Categories
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Categories we want to update
     *   }
     * })
    **/
    upsert<T extends CategoriesUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, CategoriesUpsertArgs<ExtArgs>>
    ): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesCountArgs} args - Arguments to filter Categories to count.
     * @example
     * // Count the number of Categories
     * const count = await prisma.categories.count({
     *   where: {
     *     // ... the filter for the Categories we want to count
     *   }
     * })
    **/
    count<T extends CategoriesCountArgs>(
      args?: Subset<T, CategoriesCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], CategoriesCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends CategoriesAggregateArgs>(args: Subset<T, CategoriesAggregateArgs>): Prisma.PrismaPromise<GetCategoriesAggregateType<T>>

    /**
     * Group by Categories.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {CategoriesGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends CategoriesGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: CategoriesGroupByArgs['orderBy'] }
        : { orderBy?: CategoriesGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, CategoriesGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetCategoriesGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Categories model
   */
  readonly fields: CategoriesFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Categories.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__CategoriesClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    parent<T extends Categories$parentArgs<ExtArgs> = {}>(args?: Subset<T, Categories$parentArgs<ExtArgs>>): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    subcategories<T extends Categories$subcategoriesArgs<ExtArgs> = {}>(args?: Subset<T, Categories$subcategoriesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findMany'> | Null>;

    category_type<T extends CategoryTypesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CategoryTypesDefaultArgs<ExtArgs>>): Prisma__CategoryTypesClient<$Result.GetResult<Prisma.$CategoryTypesPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    configurations<T extends Categories$configurationsArgs<ExtArgs> = {}>(args?: Subset<T, Categories$configurationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Categories model
   */ 
  interface CategoriesFieldRefs {
    readonly id: FieldRef<"Categories", 'Int'>
    readonly uuid: FieldRef<"Categories", 'String'>
    readonly category_type_id: FieldRef<"Categories", 'String'>
    readonly category_id: FieldRef<"Categories", 'String'>
    readonly parent_id: FieldRef<"Categories", 'String'>
    readonly name: FieldRef<"Categories", 'String'>
    readonly description: FieldRef<"Categories", 'String'>
    readonly company_id: FieldRef<"Categories", 'Int'>
    readonly created_at: FieldRef<"Categories", 'String'>
    readonly created_by: FieldRef<"Categories", 'Int'>
    readonly updated_at: FieldRef<"Categories", 'DateTime'>
    readonly updated_by: FieldRef<"Categories", 'Int'>
    readonly deleted_at: FieldRef<"Categories", 'DateTime'>
    readonly deleted_by: FieldRef<"Categories", 'Int'>
    readonly transfer_status: FieldRef<"Categories", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Categories findUnique
   */
  export type CategoriesFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where: CategoriesWhereUniqueInput
  }

  /**
   * Categories findUniqueOrThrow
   */
  export type CategoriesFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where: CategoriesWhereUniqueInput
  }

  /**
   * Categories findFirst
   */
  export type CategoriesFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where?: CategoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoriesOrderByWithRelationInput | CategoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categories.
     */
    cursor?: CategoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categories.
     */
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * Categories findFirstOrThrow
   */
  export type CategoriesFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where?: CategoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoriesOrderByWithRelationInput | CategoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Categories.
     */
    cursor?: CategoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Categories.
     */
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * Categories findMany
   */
  export type CategoriesFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * Filter, which Categories to fetch.
     */
    where?: CategoriesWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Categories to fetch.
     */
    orderBy?: CategoriesOrderByWithRelationInput | CategoriesOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Categories.
     */
    cursor?: CategoriesWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Categories from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Categories.
     */
    skip?: number
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * Categories create
   */
  export type CategoriesCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * The data needed to create a Categories.
     */
    data: XOR<CategoriesCreateInput, CategoriesUncheckedCreateInput>
  }

  /**
   * Categories createMany
   */
  export type CategoriesCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Categories.
     */
    data: CategoriesCreateManyInput | CategoriesCreateManyInput[]
  }

  /**
   * Categories createManyAndReturn
   */
  export type CategoriesCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * The data used to create many Categories.
     */
    data: CategoriesCreateManyInput | CategoriesCreateManyInput[]
  }

  /**
   * Categories update
   */
  export type CategoriesUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * The data needed to update a Categories.
     */
    data: XOR<CategoriesUpdateInput, CategoriesUncheckedUpdateInput>
    /**
     * Choose, which Categories to update.
     */
    where: CategoriesWhereUniqueInput
  }

  /**
   * Categories updateMany
   */
  export type CategoriesUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Categories.
     */
    data: XOR<CategoriesUpdateManyMutationInput, CategoriesUncheckedUpdateManyInput>
    /**
     * Filter which Categories to update
     */
    where?: CategoriesWhereInput
  }

  /**
   * Categories upsert
   */
  export type CategoriesUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * The filter to search for the Categories to update in case it exists.
     */
    where: CategoriesWhereUniqueInput
    /**
     * In case the Categories found by the `where` argument doesn't exist, create a new Categories with this data.
     */
    create: XOR<CategoriesCreateInput, CategoriesUncheckedCreateInput>
    /**
     * In case the Categories was found with the provided `where` argument, update it with this data.
     */
    update: XOR<CategoriesUpdateInput, CategoriesUncheckedUpdateInput>
  }

  /**
   * Categories delete
   */
  export type CategoriesDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    /**
     * Filter which Categories to delete.
     */
    where: CategoriesWhereUniqueInput
  }

  /**
   * Categories deleteMany
   */
  export type CategoriesDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Categories to delete
     */
    where?: CategoriesWhereInput
  }

  /**
   * Categories.parent
   */
  export type Categories$parentArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    where?: CategoriesWhereInput
  }

  /**
   * Categories.subcategories
   */
  export type Categories$subcategoriesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
    where?: CategoriesWhereInput
    orderBy?: CategoriesOrderByWithRelationInput | CategoriesOrderByWithRelationInput[]
    cursor?: CategoriesWhereUniqueInput
    take?: number
    skip?: number
    distinct?: CategoriesScalarFieldEnum | CategoriesScalarFieldEnum[]
  }

  /**
   * Categories.configurations
   */
  export type Categories$configurationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    where?: ConfigurationsWhereInput
    orderBy?: ConfigurationsOrderByWithRelationInput | ConfigurationsOrderByWithRelationInput[]
    cursor?: ConfigurationsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * Categories without action
   */
  export type CategoriesDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Categories
     */
    select?: CategoriesSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: CategoriesInclude<ExtArgs> | null
  }


  /**
   * Model Configurations
   */

  export type AggregateConfigurations = {
    _count: ConfigurationsCountAggregateOutputType | null
    _avg: ConfigurationsAvgAggregateOutputType | null
    _sum: ConfigurationsSumAggregateOutputType | null
    _min: ConfigurationsMinAggregateOutputType | null
    _max: ConfigurationsMaxAggregateOutputType | null
  }

  export type ConfigurationsAvgAggregateOutputType = {
    id: number | null
    order_no: Decimal | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type ConfigurationsSumAggregateOutputType = {
    id: number | null
    order_no: Decimal | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type ConfigurationsMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    order_no: Decimal | null
    config_key: string | null
    category_id: string | null
    config_value: string | null
    config_file_value: string | null
    config_value_type: string | null
    config_field_type: string | null
    display_config: boolean | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type ConfigurationsMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    order_no: Decimal | null
    config_key: string | null
    category_id: string | null
    config_value: string | null
    config_file_value: string | null
    config_value_type: string | null
    config_field_type: string | null
    display_config: boolean | null
    company_id: number | null
    created_at: string | null
    created_by: number | null
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type ConfigurationsCountAggregateOutputType = {
    id: number
    uuid: number
    order_no: number
    config_key: number
    category_id: number
    config_value: number
    config_file_value: number
    config_value_type: number
    config_field_type: number
    display_config: number
    company_id: number
    created_at: number
    created_by: number
    updated_at: number
    updated_by: number
    deleted_at: number
    deleted_by: number
    transfer_status: number
    _all: number
  }


  export type ConfigurationsAvgAggregateInputType = {
    id?: true
    order_no?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type ConfigurationsSumAggregateInputType = {
    id?: true
    order_no?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type ConfigurationsMinAggregateInputType = {
    id?: true
    uuid?: true
    order_no?: true
    config_key?: true
    category_id?: true
    config_value?: true
    config_file_value?: true
    config_value_type?: true
    config_field_type?: true
    display_config?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type ConfigurationsMaxAggregateInputType = {
    id?: true
    uuid?: true
    order_no?: true
    config_key?: true
    category_id?: true
    config_value?: true
    config_file_value?: true
    config_value_type?: true
    config_field_type?: true
    display_config?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type ConfigurationsCountAggregateInputType = {
    id?: true
    uuid?: true
    order_no?: true
    config_key?: true
    category_id?: true
    config_value?: true
    config_file_value?: true
    config_value_type?: true
    config_field_type?: true
    display_config?: true
    company_id?: true
    created_at?: true
    created_by?: true
    updated_at?: true
    updated_by?: true
    deleted_at?: true
    deleted_by?: true
    transfer_status?: true
    _all?: true
  }

  export type ConfigurationsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Configurations to aggregate.
     */
    where?: ConfigurationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Configurations to fetch.
     */
    orderBy?: ConfigurationsOrderByWithRelationInput | ConfigurationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: ConfigurationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Configurations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Configurations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Configurations
    **/
    _count?: true | ConfigurationsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: ConfigurationsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: ConfigurationsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: ConfigurationsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: ConfigurationsMaxAggregateInputType
  }

  export type GetConfigurationsAggregateType<T extends ConfigurationsAggregateArgs> = {
        [P in keyof T & keyof AggregateConfigurations]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateConfigurations[P]>
      : GetScalarType<T[P], AggregateConfigurations[P]>
  }




  export type ConfigurationsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: ConfigurationsWhereInput
    orderBy?: ConfigurationsOrderByWithAggregationInput | ConfigurationsOrderByWithAggregationInput[]
    by: ConfigurationsScalarFieldEnum[] | ConfigurationsScalarFieldEnum
    having?: ConfigurationsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: ConfigurationsCountAggregateInputType | true
    _avg?: ConfigurationsAvgAggregateInputType
    _sum?: ConfigurationsSumAggregateInputType
    _min?: ConfigurationsMinAggregateInputType
    _max?: ConfigurationsMaxAggregateInputType
  }

  export type ConfigurationsGroupByOutputType = {
    id: number
    uuid: string
    order_no: Decimal
    config_key: string
    category_id: string
    config_value: string | null
    config_file_value: string | null
    config_value_type: string
    config_field_type: string
    display_config: boolean
    company_id: number
    created_at: string
    created_by: number
    updated_at: Date | null
    updated_by: number | null
    deleted_at: Date | null
    deleted_by: number | null
    transfer_status: number | null
    _count: ConfigurationsCountAggregateOutputType | null
    _avg: ConfigurationsAvgAggregateOutputType | null
    _sum: ConfigurationsSumAggregateOutputType | null
    _min: ConfigurationsMinAggregateOutputType | null
    _max: ConfigurationsMaxAggregateOutputType | null
  }

  type GetConfigurationsGroupByPayload<T extends ConfigurationsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<ConfigurationsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof ConfigurationsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], ConfigurationsGroupByOutputType[P]>
            : GetScalarType<T[P], ConfigurationsGroupByOutputType[P]>
        }
      >
    >


  export type ConfigurationsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    order_no?: boolean
    config_key?: boolean
    category_id?: boolean
    config_value?: boolean
    config_file_value?: boolean
    config_value_type?: boolean
    config_field_type?: boolean
    display_config?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
    category?: boolean | CategoriesDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["configurations"]>

  export type ConfigurationsSelectScalar = {
    id?: boolean
    uuid?: boolean
    order_no?: boolean
    config_key?: boolean
    category_id?: boolean
    config_value?: boolean
    config_file_value?: boolean
    config_value_type?: boolean
    config_field_type?: boolean
    display_config?: boolean
    company_id?: boolean
    created_at?: boolean
    created_by?: boolean
    updated_at?: boolean
    updated_by?: boolean
    deleted_at?: boolean
    deleted_by?: boolean
    transfer_status?: boolean
  }


  export type ConfigurationsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    category?: boolean | CategoriesDefaultArgs<ExtArgs>
  }


  export type $ConfigurationsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Configurations"
    objects: {
      category: Prisma.$CategoriesPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      order_no: Prisma.Decimal
      config_key: string
      category_id: string
      config_value: string | null
      config_file_value: string | null
      config_value_type: string
      config_field_type: string
      display_config: boolean
      company_id: number
      created_at: string
      created_by: number
      updated_at: Date | null
      updated_by: number | null
      deleted_at: Date | null
      deleted_by: number | null
      transfer_status: number | null
    }, ExtArgs["result"]["configurations"]>
    composites: {}
  }


  type ConfigurationsGetPayload<S extends boolean | null | undefined | ConfigurationsDefaultArgs> = $Result.GetResult<Prisma.$ConfigurationsPayload, S>

  type ConfigurationsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<ConfigurationsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: ConfigurationsCountAggregateInputType | true
    }

  export interface ConfigurationsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Configurations'], meta: { name: 'Configurations' } }
    /**
     * Find zero or one Configurations that matches the filter.
     * @param {ConfigurationsFindUniqueArgs} args - Arguments to find a Configurations
     * @example
     * // Get one Configurations
     * const configurations = await prisma.configurations.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends ConfigurationsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, ConfigurationsFindUniqueArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Configurations that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {ConfigurationsFindUniqueOrThrowArgs} args - Arguments to find a Configurations
     * @example
     * // Get one Configurations
     * const configurations = await prisma.configurations.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends ConfigurationsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Configurations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsFindFirstArgs} args - Arguments to find a Configurations
     * @example
     * // Get one Configurations
     * const configurations = await prisma.configurations.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends ConfigurationsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsFindFirstArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Configurations that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsFindFirstOrThrowArgs} args - Arguments to find a Configurations
     * @example
     * // Get one Configurations
     * const configurations = await prisma.configurations.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends ConfigurationsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Configurations that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Configurations
     * const configurations = await prisma.configurations.findMany()
     * 
     * // Get first 10 Configurations
     * const configurations = await prisma.configurations.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const configurationsWithIdOnly = await prisma.configurations.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends ConfigurationsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Configurations.
     * @param {ConfigurationsCreateArgs} args - Arguments to create a Configurations.
     * @example
     * // Create one Configurations
     * const Configurations = await prisma.configurations.create({
     *   data: {
     *     // ... data to create a Configurations
     *   }
     * })
     * 
    **/
    create<T extends ConfigurationsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, ConfigurationsCreateArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Configurations.
     * @param {ConfigurationsCreateManyArgs} args - Arguments to create many Configurations.
     * @example
     * // Create many Configurations
     * const configurations = await prisma.configurations.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends ConfigurationsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Configurations and returns the data saved in the database.
     * @param {ConfigurationsCreateManyAndReturnArgs} args - Arguments to create many Configurations.
     * @example
     * // Create many Configurations
     * const configurations = await prisma.configurations.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Configurations and only return the `id`
     * const configurationsWithIdOnly = await prisma.configurations.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends ConfigurationsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Configurations.
     * @param {ConfigurationsDeleteArgs} args - Arguments to delete one Configurations.
     * @example
     * // Delete one Configurations
     * const Configurations = await prisma.configurations.delete({
     *   where: {
     *     // ... filter to delete one Configurations
     *   }
     * })
     * 
    **/
    delete<T extends ConfigurationsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, ConfigurationsDeleteArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Configurations.
     * @param {ConfigurationsUpdateArgs} args - Arguments to update one Configurations.
     * @example
     * // Update one Configurations
     * const configurations = await prisma.configurations.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends ConfigurationsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, ConfigurationsUpdateArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Configurations.
     * @param {ConfigurationsDeleteManyArgs} args - Arguments to filter Configurations to delete.
     * @example
     * // Delete a few Configurations
     * const { count } = await prisma.configurations.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends ConfigurationsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, ConfigurationsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Configurations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Configurations
     * const configurations = await prisma.configurations.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends ConfigurationsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, ConfigurationsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Configurations.
     * @param {ConfigurationsUpsertArgs} args - Arguments to update or create a Configurations.
     * @example
     * // Update or create a Configurations
     * const configurations = await prisma.configurations.upsert({
     *   create: {
     *     // ... data to create a Configurations
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Configurations we want to update
     *   }
     * })
    **/
    upsert<T extends ConfigurationsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, ConfigurationsUpsertArgs<ExtArgs>>
    ): Prisma__ConfigurationsClient<$Result.GetResult<Prisma.$ConfigurationsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Configurations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsCountArgs} args - Arguments to filter Configurations to count.
     * @example
     * // Count the number of Configurations
     * const count = await prisma.configurations.count({
     *   where: {
     *     // ... the filter for the Configurations we want to count
     *   }
     * })
    **/
    count<T extends ConfigurationsCountArgs>(
      args?: Subset<T, ConfigurationsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], ConfigurationsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Configurations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends ConfigurationsAggregateArgs>(args: Subset<T, ConfigurationsAggregateArgs>): Prisma.PrismaPromise<GetConfigurationsAggregateType<T>>

    /**
     * Group by Configurations.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {ConfigurationsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends ConfigurationsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: ConfigurationsGroupByArgs['orderBy'] }
        : { orderBy?: ConfigurationsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, ConfigurationsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetConfigurationsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Configurations model
   */
  readonly fields: ConfigurationsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Configurations.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__ConfigurationsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    category<T extends CategoriesDefaultArgs<ExtArgs> = {}>(args?: Subset<T, CategoriesDefaultArgs<ExtArgs>>): Prisma__CategoriesClient<$Result.GetResult<Prisma.$CategoriesPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Configurations model
   */ 
  interface ConfigurationsFieldRefs {
    readonly id: FieldRef<"Configurations", 'Int'>
    readonly uuid: FieldRef<"Configurations", 'String'>
    readonly order_no: FieldRef<"Configurations", 'Decimal'>
    readonly config_key: FieldRef<"Configurations", 'String'>
    readonly category_id: FieldRef<"Configurations", 'String'>
    readonly config_value: FieldRef<"Configurations", 'String'>
    readonly config_file_value: FieldRef<"Configurations", 'String'>
    readonly config_value_type: FieldRef<"Configurations", 'String'>
    readonly config_field_type: FieldRef<"Configurations", 'String'>
    readonly display_config: FieldRef<"Configurations", 'Boolean'>
    readonly company_id: FieldRef<"Configurations", 'Int'>
    readonly created_at: FieldRef<"Configurations", 'String'>
    readonly created_by: FieldRef<"Configurations", 'Int'>
    readonly updated_at: FieldRef<"Configurations", 'DateTime'>
    readonly updated_by: FieldRef<"Configurations", 'Int'>
    readonly deleted_at: FieldRef<"Configurations", 'DateTime'>
    readonly deleted_by: FieldRef<"Configurations", 'Int'>
    readonly transfer_status: FieldRef<"Configurations", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Configurations findUnique
   */
  export type ConfigurationsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * Filter, which Configurations to fetch.
     */
    where: ConfigurationsWhereUniqueInput
  }

  /**
   * Configurations findUniqueOrThrow
   */
  export type ConfigurationsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * Filter, which Configurations to fetch.
     */
    where: ConfigurationsWhereUniqueInput
  }

  /**
   * Configurations findFirst
   */
  export type ConfigurationsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * Filter, which Configurations to fetch.
     */
    where?: ConfigurationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Configurations to fetch.
     */
    orderBy?: ConfigurationsOrderByWithRelationInput | ConfigurationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Configurations.
     */
    cursor?: ConfigurationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Configurations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Configurations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Configurations.
     */
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * Configurations findFirstOrThrow
   */
  export type ConfigurationsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * Filter, which Configurations to fetch.
     */
    where?: ConfigurationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Configurations to fetch.
     */
    orderBy?: ConfigurationsOrderByWithRelationInput | ConfigurationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Configurations.
     */
    cursor?: ConfigurationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Configurations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Configurations.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Configurations.
     */
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * Configurations findMany
   */
  export type ConfigurationsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * Filter, which Configurations to fetch.
     */
    where?: ConfigurationsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Configurations to fetch.
     */
    orderBy?: ConfigurationsOrderByWithRelationInput | ConfigurationsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Configurations.
     */
    cursor?: ConfigurationsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Configurations from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Configurations.
     */
    skip?: number
    distinct?: ConfigurationsScalarFieldEnum | ConfigurationsScalarFieldEnum[]
  }

  /**
   * Configurations create
   */
  export type ConfigurationsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * The data needed to create a Configurations.
     */
    data: XOR<ConfigurationsCreateInput, ConfigurationsUncheckedCreateInput>
  }

  /**
   * Configurations createMany
   */
  export type ConfigurationsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Configurations.
     */
    data: ConfigurationsCreateManyInput | ConfigurationsCreateManyInput[]
  }

  /**
   * Configurations createManyAndReturn
   */
  export type ConfigurationsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * The data used to create many Configurations.
     */
    data: ConfigurationsCreateManyInput | ConfigurationsCreateManyInput[]
  }

  /**
   * Configurations update
   */
  export type ConfigurationsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * The data needed to update a Configurations.
     */
    data: XOR<ConfigurationsUpdateInput, ConfigurationsUncheckedUpdateInput>
    /**
     * Choose, which Configurations to update.
     */
    where: ConfigurationsWhereUniqueInput
  }

  /**
   * Configurations updateMany
   */
  export type ConfigurationsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Configurations.
     */
    data: XOR<ConfigurationsUpdateManyMutationInput, ConfigurationsUncheckedUpdateManyInput>
    /**
     * Filter which Configurations to update
     */
    where?: ConfigurationsWhereInput
  }

  /**
   * Configurations upsert
   */
  export type ConfigurationsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * The filter to search for the Configurations to update in case it exists.
     */
    where: ConfigurationsWhereUniqueInput
    /**
     * In case the Configurations found by the `where` argument doesn't exist, create a new Configurations with this data.
     */
    create: XOR<ConfigurationsCreateInput, ConfigurationsUncheckedCreateInput>
    /**
     * In case the Configurations was found with the provided `where` argument, update it with this data.
     */
    update: XOR<ConfigurationsUpdateInput, ConfigurationsUncheckedUpdateInput>
  }

  /**
   * Configurations delete
   */
  export type ConfigurationsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
    /**
     * Filter which Configurations to delete.
     */
    where: ConfigurationsWhereUniqueInput
  }

  /**
   * Configurations deleteMany
   */
  export type ConfigurationsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Configurations to delete
     */
    where?: ConfigurationsWhereInput
  }

  /**
   * Configurations without action
   */
  export type ConfigurationsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Configurations
     */
    select?: ConfigurationsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: ConfigurationsInclude<ExtArgs> | null
  }


  /**
   * Model menuType
   */

  export type AggregateMenuType = {
    _count: MenuTypeCountAggregateOutputType | null
    _avg: MenuTypeAvgAggregateOutputType | null
    _sum: MenuTypeSumAggregateOutputType | null
    _min: MenuTypeMinAggregateOutputType | null
    _max: MenuTypeMaxAggregateOutputType | null
  }

  export type MenuTypeAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type MenuTypeSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type MenuTypeMinAggregateOutputType = {
    id: number | null
    name: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type MenuTypeMaxAggregateOutputType = {
    id: number | null
    name: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type MenuTypeCountAggregateOutputType = {
    id: number
    name: number
    status_id: number
    company_id: number
    created_at: number
    transfer_status: number
    _all: number
  }


  export type MenuTypeAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type MenuTypeSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type MenuTypeMinAggregateInputType = {
    id?: true
    name?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type MenuTypeMaxAggregateInputType = {
    id?: true
    name?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type MenuTypeCountAggregateInputType = {
    id?: true
    name?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
    _all?: true
  }

  export type MenuTypeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which menuType to aggregate.
     */
    where?: menuTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of menuTypes to fetch.
     */
    orderBy?: menuTypeOrderByWithRelationInput | menuTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: menuTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` menuTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` menuTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned menuTypes
    **/
    _count?: true | MenuTypeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MenuTypeAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MenuTypeSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MenuTypeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MenuTypeMaxAggregateInputType
  }

  export type GetMenuTypeAggregateType<T extends MenuTypeAggregateArgs> = {
        [P in keyof T & keyof AggregateMenuType]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMenuType[P]>
      : GetScalarType<T[P], AggregateMenuType[P]>
  }




  export type menuTypeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: menuTypeWhereInput
    orderBy?: menuTypeOrderByWithAggregationInput | menuTypeOrderByWithAggregationInput[]
    by: MenuTypeScalarFieldEnum[] | MenuTypeScalarFieldEnum
    having?: menuTypeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MenuTypeCountAggregateInputType | true
    _avg?: MenuTypeAvgAggregateInputType
    _sum?: MenuTypeSumAggregateInputType
    _min?: MenuTypeMinAggregateInputType
    _max?: MenuTypeMaxAggregateInputType
  }

  export type MenuTypeGroupByOutputType = {
    id: number
    name: string | null
    status_id: number
    company_id: number
    created_at: string
    transfer_status: number | null
    _count: MenuTypeCountAggregateOutputType | null
    _avg: MenuTypeAvgAggregateOutputType | null
    _sum: MenuTypeSumAggregateOutputType | null
    _min: MenuTypeMinAggregateOutputType | null
    _max: MenuTypeMaxAggregateOutputType | null
  }

  type GetMenuTypeGroupByPayload<T extends menuTypeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MenuTypeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MenuTypeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MenuTypeGroupByOutputType[P]>
            : GetScalarType<T[P], MenuTypeGroupByOutputType[P]>
        }
      >
    >


  export type menuTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["menuType"]>

  export type menuTypeSelectScalar = {
    id?: boolean
    name?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
  }


  export type menuTypeInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
  }


  export type $menuTypePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "menuType"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string | null
      status_id: number
      company_id: number
      created_at: string
      transfer_status: number | null
    }, ExtArgs["result"]["menuType"]>
    composites: {}
  }


  type menuTypeGetPayload<S extends boolean | null | undefined | menuTypeDefaultArgs> = $Result.GetResult<Prisma.$menuTypePayload, S>

  type menuTypeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<menuTypeFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MenuTypeCountAggregateInputType | true
    }

  export interface menuTypeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['menuType'], meta: { name: 'menuType' } }
    /**
     * Find zero or one MenuType that matches the filter.
     * @param {menuTypeFindUniqueArgs} args - Arguments to find a MenuType
     * @example
     * // Get one MenuType
     * const menuType = await prisma.menuType.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends menuTypeFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, menuTypeFindUniqueArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one MenuType that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {menuTypeFindUniqueOrThrowArgs} args - Arguments to find a MenuType
     * @example
     * // Get one MenuType
     * const menuType = await prisma.menuType.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends menuTypeFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first MenuType that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {menuTypeFindFirstArgs} args - Arguments to find a MenuType
     * @example
     * // Get one MenuType
     * const menuType = await prisma.menuType.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends menuTypeFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeFindFirstArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first MenuType that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {menuTypeFindFirstOrThrowArgs} args - Arguments to find a MenuType
     * @example
     * // Get one MenuType
     * const menuType = await prisma.menuType.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends menuTypeFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more MenuTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {menuTypeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all MenuTypes
     * const menuTypes = await prisma.menuType.findMany()
     * 
     * // Get first 10 MenuTypes
     * const menuTypes = await prisma.menuType.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const menuTypeWithIdOnly = await prisma.menuType.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends menuTypeFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a MenuType.
     * @param {menuTypeCreateArgs} args - Arguments to create a MenuType.
     * @example
     * // Create one MenuType
     * const MenuType = await prisma.menuType.create({
     *   data: {
     *     // ... data to create a MenuType
     *   }
     * })
     * 
    **/
    create<T extends menuTypeCreateArgs<ExtArgs>>(
      args: SelectSubset<T, menuTypeCreateArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many MenuTypes.
     * @param {menuTypeCreateManyArgs} args - Arguments to create many MenuTypes.
     * @example
     * // Create many MenuTypes
     * const menuType = await prisma.menuType.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends menuTypeCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many MenuTypes and returns the data saved in the database.
     * @param {menuTypeCreateManyAndReturnArgs} args - Arguments to create many MenuTypes.
     * @example
     * // Create many MenuTypes
     * const menuType = await prisma.menuType.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many MenuTypes and only return the `id`
     * const menuTypeWithIdOnly = await prisma.menuType.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends menuTypeCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a MenuType.
     * @param {menuTypeDeleteArgs} args - Arguments to delete one MenuType.
     * @example
     * // Delete one MenuType
     * const MenuType = await prisma.menuType.delete({
     *   where: {
     *     // ... filter to delete one MenuType
     *   }
     * })
     * 
    **/
    delete<T extends menuTypeDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, menuTypeDeleteArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one MenuType.
     * @param {menuTypeUpdateArgs} args - Arguments to update one MenuType.
     * @example
     * // Update one MenuType
     * const menuType = await prisma.menuType.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends menuTypeUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, menuTypeUpdateArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more MenuTypes.
     * @param {menuTypeDeleteManyArgs} args - Arguments to filter MenuTypes to delete.
     * @example
     * // Delete a few MenuTypes
     * const { count } = await prisma.menuType.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends menuTypeDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, menuTypeDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more MenuTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {menuTypeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many MenuTypes
     * const menuType = await prisma.menuType.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends menuTypeUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, menuTypeUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one MenuType.
     * @param {menuTypeUpsertArgs} args - Arguments to update or create a MenuType.
     * @example
     * // Update or create a MenuType
     * const menuType = await prisma.menuType.upsert({
     *   create: {
     *     // ... data to create a MenuType
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the MenuType we want to update
     *   }
     * })
    **/
    upsert<T extends menuTypeUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, menuTypeUpsertArgs<ExtArgs>>
    ): Prisma__menuTypeClient<$Result.GetResult<Prisma.$menuTypePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of MenuTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {menuTypeCountArgs} args - Arguments to filter MenuTypes to count.
     * @example
     * // Count the number of MenuTypes
     * const count = await prisma.menuType.count({
     *   where: {
     *     // ... the filter for the MenuTypes we want to count
     *   }
     * })
    **/
    count<T extends menuTypeCountArgs>(
      args?: Subset<T, menuTypeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MenuTypeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a MenuType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuTypeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MenuTypeAggregateArgs>(args: Subset<T, MenuTypeAggregateArgs>): Prisma.PrismaPromise<GetMenuTypeAggregateType<T>>

    /**
     * Group by MenuType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {menuTypeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends menuTypeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: menuTypeGroupByArgs['orderBy'] }
        : { orderBy?: menuTypeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, menuTypeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMenuTypeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the menuType model
   */
  readonly fields: menuTypeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for menuType.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__menuTypeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the menuType model
   */ 
  interface menuTypeFieldRefs {
    readonly id: FieldRef<"menuType", 'Int'>
    readonly name: FieldRef<"menuType", 'String'>
    readonly status_id: FieldRef<"menuType", 'Int'>
    readonly company_id: FieldRef<"menuType", 'Int'>
    readonly created_at: FieldRef<"menuType", 'String'>
    readonly transfer_status: FieldRef<"menuType", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * menuType findUnique
   */
  export type menuTypeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * Filter, which menuType to fetch.
     */
    where: menuTypeWhereUniqueInput
  }

  /**
   * menuType findUniqueOrThrow
   */
  export type menuTypeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * Filter, which menuType to fetch.
     */
    where: menuTypeWhereUniqueInput
  }

  /**
   * menuType findFirst
   */
  export type menuTypeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * Filter, which menuType to fetch.
     */
    where?: menuTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of menuTypes to fetch.
     */
    orderBy?: menuTypeOrderByWithRelationInput | menuTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for menuTypes.
     */
    cursor?: menuTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` menuTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` menuTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of menuTypes.
     */
    distinct?: MenuTypeScalarFieldEnum | MenuTypeScalarFieldEnum[]
  }

  /**
   * menuType findFirstOrThrow
   */
  export type menuTypeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * Filter, which menuType to fetch.
     */
    where?: menuTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of menuTypes to fetch.
     */
    orderBy?: menuTypeOrderByWithRelationInput | menuTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for menuTypes.
     */
    cursor?: menuTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` menuTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` menuTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of menuTypes.
     */
    distinct?: MenuTypeScalarFieldEnum | MenuTypeScalarFieldEnum[]
  }

  /**
   * menuType findMany
   */
  export type menuTypeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * Filter, which menuTypes to fetch.
     */
    where?: menuTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of menuTypes to fetch.
     */
    orderBy?: menuTypeOrderByWithRelationInput | menuTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing menuTypes.
     */
    cursor?: menuTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` menuTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` menuTypes.
     */
    skip?: number
    distinct?: MenuTypeScalarFieldEnum | MenuTypeScalarFieldEnum[]
  }

  /**
   * menuType create
   */
  export type menuTypeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * The data needed to create a menuType.
     */
    data: XOR<menuTypeCreateInput, menuTypeUncheckedCreateInput>
  }

  /**
   * menuType createMany
   */
  export type menuTypeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many menuTypes.
     */
    data: menuTypeCreateManyInput | menuTypeCreateManyInput[]
  }

  /**
   * menuType createManyAndReturn
   */
  export type menuTypeCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * The data used to create many menuTypes.
     */
    data: menuTypeCreateManyInput | menuTypeCreateManyInput[]
  }

  /**
   * menuType update
   */
  export type menuTypeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * The data needed to update a menuType.
     */
    data: XOR<menuTypeUpdateInput, menuTypeUncheckedUpdateInput>
    /**
     * Choose, which menuType to update.
     */
    where: menuTypeWhereUniqueInput
  }

  /**
   * menuType updateMany
   */
  export type menuTypeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update menuTypes.
     */
    data: XOR<menuTypeUpdateManyMutationInput, menuTypeUncheckedUpdateManyInput>
    /**
     * Filter which menuTypes to update
     */
    where?: menuTypeWhereInput
  }

  /**
   * menuType upsert
   */
  export type menuTypeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * The filter to search for the menuType to update in case it exists.
     */
    where: menuTypeWhereUniqueInput
    /**
     * In case the menuType found by the `where` argument doesn't exist, create a new menuType with this data.
     */
    create: XOR<menuTypeCreateInput, menuTypeUncheckedCreateInput>
    /**
     * In case the menuType was found with the provided `where` argument, update it with this data.
     */
    update: XOR<menuTypeUpdateInput, menuTypeUncheckedUpdateInput>
  }

  /**
   * menuType delete
   */
  export type menuTypeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
    /**
     * Filter which menuType to delete.
     */
    where: menuTypeWhereUniqueInput
  }

  /**
   * menuType deleteMany
   */
  export type menuTypeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which menuTypes to delete
     */
    where?: menuTypeWhereInput
  }

  /**
   * menuType without action
   */
  export type menuTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the menuType
     */
    select?: menuTypeSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: menuTypeInclude<ExtArgs> | null
  }


  /**
   * Model Menus
   */

  export type AggregateMenus = {
    _count: MenusCountAggregateOutputType | null
    _avg: MenusAvgAggregateOutputType | null
    _sum: MenusSumAggregateOutputType | null
    _min: MenusMinAggregateOutputType | null
    _max: MenusMaxAggregateOutputType | null
  }

  export type MenusAvgAggregateOutputType = {
    id: number | null
    menu_type: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type MenusSumAggregateOutputType = {
    id: number | null
    menu_type: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type MenusMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    slug: string | null
    description: string | null
    menu_type: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type MenusMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    slug: string | null
    description: string | null
    menu_type: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type MenusCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    slug: number
    description: number
    menu_type: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    transfer_status: number
    _all: number
  }


  export type MenusAvgAggregateInputType = {
    id?: true
    menu_type?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type MenusSumAggregateInputType = {
    id?: true
    menu_type?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type MenusMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    slug?: true
    description?: true
    menu_type?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type MenusMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    slug?: true
    description?: true
    menu_type?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type MenusCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    slug?: true
    description?: true
    menu_type?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
    _all?: true
  }

  export type MenusAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Menus to aggregate.
     */
    where?: MenusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Menus to fetch.
     */
    orderBy?: MenusOrderByWithRelationInput | MenusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MenusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Menus from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Menus.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Menus
    **/
    _count?: true | MenusCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MenusAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MenusSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MenusMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MenusMaxAggregateInputType
  }

  export type GetMenusAggregateType<T extends MenusAggregateArgs> = {
        [P in keyof T & keyof AggregateMenus]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMenus[P]>
      : GetScalarType<T[P], AggregateMenus[P]>
  }




  export type MenusGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenusWhereInput
    orderBy?: MenusOrderByWithAggregationInput | MenusOrderByWithAggregationInput[]
    by: MenusScalarFieldEnum[] | MenusScalarFieldEnum
    having?: MenusScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MenusCountAggregateInputType | true
    _avg?: MenusAvgAggregateInputType
    _sum?: MenusSumAggregateInputType
    _min?: MenusMinAggregateInputType
    _max?: MenusMaxAggregateInputType
  }

  export type MenusGroupByOutputType = {
    id: number
    uuid: string
    name: string
    slug: string | null
    description: string | null
    menu_type: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number | null
    deleted_by: number | null
    created_at: string
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
    _count: MenusCountAggregateOutputType | null
    _avg: MenusAvgAggregateOutputType | null
    _sum: MenusSumAggregateOutputType | null
    _min: MenusMinAggregateOutputType | null
    _max: MenusMaxAggregateOutputType | null
  }

  type GetMenusGroupByPayload<T extends MenusGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MenusGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MenusGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MenusGroupByOutputType[P]>
            : GetScalarType<T[P], MenusGroupByOutputType[P]>
        }
      >
    >


  export type MenusSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    slug?: boolean
    description?: boolean
    menu_type?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["menus"]>

  export type MenusSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    slug?: boolean
    description?: boolean
    menu_type?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
  }


  export type MenusInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
  }


  export type $MenusPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Menus"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      slug: string | null
      description: string | null
      menu_type: number
      status_id: number
      company_id: number
      created_by: number
      updated_by: number | null
      deleted_by: number | null
      created_at: string
      updated_at: Date | null
      deleted_at: Date | null
      transfer_status: number | null
    }, ExtArgs["result"]["menus"]>
    composites: {}
  }


  type MenusGetPayload<S extends boolean | null | undefined | MenusDefaultArgs> = $Result.GetResult<Prisma.$MenusPayload, S>

  type MenusCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<MenusFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MenusCountAggregateInputType | true
    }

  export interface MenusDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Menus'], meta: { name: 'Menus' } }
    /**
     * Find zero or one Menus that matches the filter.
     * @param {MenusFindUniqueArgs} args - Arguments to find a Menus
     * @example
     * // Get one Menus
     * const menus = await prisma.menus.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends MenusFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, MenusFindUniqueArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Menus that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {MenusFindUniqueOrThrowArgs} args - Arguments to find a Menus
     * @example
     * // Get one Menus
     * const menus = await prisma.menus.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends MenusFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Menus that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusFindFirstArgs} args - Arguments to find a Menus
     * @example
     * // Get one Menus
     * const menus = await prisma.menus.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends MenusFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusFindFirstArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Menus that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusFindFirstOrThrowArgs} args - Arguments to find a Menus
     * @example
     * // Get one Menus
     * const menus = await prisma.menus.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends MenusFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Menus that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Menus
     * const menus = await prisma.menus.findMany()
     * 
     * // Get first 10 Menus
     * const menus = await prisma.menus.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const menusWithIdOnly = await prisma.menus.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends MenusFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Menus.
     * @param {MenusCreateArgs} args - Arguments to create a Menus.
     * @example
     * // Create one Menus
     * const Menus = await prisma.menus.create({
     *   data: {
     *     // ... data to create a Menus
     *   }
     * })
     * 
    **/
    create<T extends MenusCreateArgs<ExtArgs>>(
      args: SelectSubset<T, MenusCreateArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Menus.
     * @param {MenusCreateManyArgs} args - Arguments to create many Menus.
     * @example
     * // Create many Menus
     * const menus = await prisma.menus.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends MenusCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Menus and returns the data saved in the database.
     * @param {MenusCreateManyAndReturnArgs} args - Arguments to create many Menus.
     * @example
     * // Create many Menus
     * const menus = await prisma.menus.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Menus and only return the `id`
     * const menusWithIdOnly = await prisma.menus.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends MenusCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Menus.
     * @param {MenusDeleteArgs} args - Arguments to delete one Menus.
     * @example
     * // Delete one Menus
     * const Menus = await prisma.menus.delete({
     *   where: {
     *     // ... filter to delete one Menus
     *   }
     * })
     * 
    **/
    delete<T extends MenusDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, MenusDeleteArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Menus.
     * @param {MenusUpdateArgs} args - Arguments to update one Menus.
     * @example
     * // Update one Menus
     * const menus = await prisma.menus.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends MenusUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, MenusUpdateArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Menus.
     * @param {MenusDeleteManyArgs} args - Arguments to filter Menus to delete.
     * @example
     * // Delete a few Menus
     * const { count } = await prisma.menus.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends MenusDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MenusDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Menus.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Menus
     * const menus = await prisma.menus.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends MenusUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, MenusUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Menus.
     * @param {MenusUpsertArgs} args - Arguments to update or create a Menus.
     * @example
     * // Update or create a Menus
     * const menus = await prisma.menus.upsert({
     *   create: {
     *     // ... data to create a Menus
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Menus we want to update
     *   }
     * })
    **/
    upsert<T extends MenusUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, MenusUpsertArgs<ExtArgs>>
    ): Prisma__MenusClient<$Result.GetResult<Prisma.$MenusPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Menus.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusCountArgs} args - Arguments to filter Menus to count.
     * @example
     * // Count the number of Menus
     * const count = await prisma.menus.count({
     *   where: {
     *     // ... the filter for the Menus we want to count
     *   }
     * })
    **/
    count<T extends MenusCountArgs>(
      args?: Subset<T, MenusCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MenusCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Menus.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MenusAggregateArgs>(args: Subset<T, MenusAggregateArgs>): Prisma.PrismaPromise<GetMenusAggregateType<T>>

    /**
     * Group by Menus.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenusGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MenusGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MenusGroupByArgs['orderBy'] }
        : { orderBy?: MenusGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MenusGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMenusGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Menus model
   */
  readonly fields: MenusFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Menus.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MenusClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Menus model
   */ 
  interface MenusFieldRefs {
    readonly id: FieldRef<"Menus", 'Int'>
    readonly uuid: FieldRef<"Menus", 'String'>
    readonly name: FieldRef<"Menus", 'String'>
    readonly slug: FieldRef<"Menus", 'String'>
    readonly description: FieldRef<"Menus", 'String'>
    readonly menu_type: FieldRef<"Menus", 'Int'>
    readonly status_id: FieldRef<"Menus", 'Int'>
    readonly company_id: FieldRef<"Menus", 'Int'>
    readonly created_by: FieldRef<"Menus", 'Int'>
    readonly updated_by: FieldRef<"Menus", 'Int'>
    readonly deleted_by: FieldRef<"Menus", 'Int'>
    readonly created_at: FieldRef<"Menus", 'String'>
    readonly updated_at: FieldRef<"Menus", 'DateTime'>
    readonly deleted_at: FieldRef<"Menus", 'DateTime'>
    readonly transfer_status: FieldRef<"Menus", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Menus findUnique
   */
  export type MenusFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * Filter, which Menus to fetch.
     */
    where: MenusWhereUniqueInput
  }

  /**
   * Menus findUniqueOrThrow
   */
  export type MenusFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * Filter, which Menus to fetch.
     */
    where: MenusWhereUniqueInput
  }

  /**
   * Menus findFirst
   */
  export type MenusFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * Filter, which Menus to fetch.
     */
    where?: MenusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Menus to fetch.
     */
    orderBy?: MenusOrderByWithRelationInput | MenusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Menus.
     */
    cursor?: MenusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Menus from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Menus.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Menus.
     */
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * Menus findFirstOrThrow
   */
  export type MenusFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * Filter, which Menus to fetch.
     */
    where?: MenusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Menus to fetch.
     */
    orderBy?: MenusOrderByWithRelationInput | MenusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Menus.
     */
    cursor?: MenusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Menus from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Menus.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Menus.
     */
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * Menus findMany
   */
  export type MenusFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * Filter, which Menus to fetch.
     */
    where?: MenusWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Menus to fetch.
     */
    orderBy?: MenusOrderByWithRelationInput | MenusOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Menus.
     */
    cursor?: MenusWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Menus from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Menus.
     */
    skip?: number
    distinct?: MenusScalarFieldEnum | MenusScalarFieldEnum[]
  }

  /**
   * Menus create
   */
  export type MenusCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * The data needed to create a Menus.
     */
    data: XOR<MenusCreateInput, MenusUncheckedCreateInput>
  }

  /**
   * Menus createMany
   */
  export type MenusCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Menus.
     */
    data: MenusCreateManyInput | MenusCreateManyInput[]
  }

  /**
   * Menus createManyAndReturn
   */
  export type MenusCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * The data used to create many Menus.
     */
    data: MenusCreateManyInput | MenusCreateManyInput[]
  }

  /**
   * Menus update
   */
  export type MenusUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * The data needed to update a Menus.
     */
    data: XOR<MenusUpdateInput, MenusUncheckedUpdateInput>
    /**
     * Choose, which Menus to update.
     */
    where: MenusWhereUniqueInput
  }

  /**
   * Menus updateMany
   */
  export type MenusUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Menus.
     */
    data: XOR<MenusUpdateManyMutationInput, MenusUncheckedUpdateManyInput>
    /**
     * Filter which Menus to update
     */
    where?: MenusWhereInput
  }

  /**
   * Menus upsert
   */
  export type MenusUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * The filter to search for the Menus to update in case it exists.
     */
    where: MenusWhereUniqueInput
    /**
     * In case the Menus found by the `where` argument doesn't exist, create a new Menus with this data.
     */
    create: XOR<MenusCreateInput, MenusUncheckedCreateInput>
    /**
     * In case the Menus was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MenusUpdateInput, MenusUncheckedUpdateInput>
  }

  /**
   * Menus delete
   */
  export type MenusDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
    /**
     * Filter which Menus to delete.
     */
    where: MenusWhereUniqueInput
  }

  /**
   * Menus deleteMany
   */
  export type MenusDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Menus to delete
     */
    where?: MenusWhereInput
  }

  /**
   * Menus without action
   */
  export type MenusDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Menus
     */
    select?: MenusSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenusInclude<ExtArgs> | null
  }


  /**
   * Model WizardGroup
   */

  export type AggregateWizardGroup = {
    _count: WizardGroupCountAggregateOutputType | null
    _avg: WizardGroupAvgAggregateOutputType | null
    _sum: WizardGroupSumAggregateOutputType | null
    _min: WizardGroupMinAggregateOutputType | null
    _max: WizardGroupMaxAggregateOutputType | null
  }

  export type WizardGroupAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardGroupSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardGroupMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    slug: string | null
    description: string | null
    status_id: number | null
    created_at: string | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardGroupMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    slug: string | null
    description: string | null
    status_id: number | null
    created_at: string | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardGroupCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    slug: number
    description: number
    status_id: number
    created_at: number
    company_id: number
    transfer_status: number
    _all: number
  }


  export type WizardGroupAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardGroupSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardGroupMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    slug?: true
    description?: true
    status_id?: true
    created_at?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardGroupMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    slug?: true
    description?: true
    status_id?: true
    created_at?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardGroupCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    slug?: true
    description?: true
    status_id?: true
    created_at?: true
    company_id?: true
    transfer_status?: true
    _all?: true
  }

  export type WizardGroupAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which WizardGroup to aggregate.
     */
    where?: WizardGroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardGroups to fetch.
     */
    orderBy?: WizardGroupOrderByWithRelationInput | WizardGroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: WizardGroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardGroups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardGroups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned WizardGroups
    **/
    _count?: true | WizardGroupCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: WizardGroupAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: WizardGroupSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: WizardGroupMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: WizardGroupMaxAggregateInputType
  }

  export type GetWizardGroupAggregateType<T extends WizardGroupAggregateArgs> = {
        [P in keyof T & keyof AggregateWizardGroup]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateWizardGroup[P]>
      : GetScalarType<T[P], AggregateWizardGroup[P]>
  }




  export type WizardGroupGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WizardGroupWhereInput
    orderBy?: WizardGroupOrderByWithAggregationInput | WizardGroupOrderByWithAggregationInput[]
    by: WizardGroupScalarFieldEnum[] | WizardGroupScalarFieldEnum
    having?: WizardGroupScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: WizardGroupCountAggregateInputType | true
    _avg?: WizardGroupAvgAggregateInputType
    _sum?: WizardGroupSumAggregateInputType
    _min?: WizardGroupMinAggregateInputType
    _max?: WizardGroupMaxAggregateInputType
  }

  export type WizardGroupGroupByOutputType = {
    id: number
    uuid: string
    name: string
    slug: string
    description: string | null
    status_id: number
    created_at: string
    company_id: number
    transfer_status: number | null
    _count: WizardGroupCountAggregateOutputType | null
    _avg: WizardGroupAvgAggregateOutputType | null
    _sum: WizardGroupSumAggregateOutputType | null
    _min: WizardGroupMinAggregateOutputType | null
    _max: WizardGroupMaxAggregateOutputType | null
  }

  type GetWizardGroupGroupByPayload<T extends WizardGroupGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<WizardGroupGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof WizardGroupGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], WizardGroupGroupByOutputType[P]>
            : GetScalarType<T[P], WizardGroupGroupByOutputType[P]>
        }
      >
    >


  export type WizardGroupSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    slug?: boolean
    description?: boolean
    status_id?: boolean
    created_at?: boolean
    company_id?: boolean
    transfer_status?: boolean
  }, ExtArgs["result"]["wizardGroup"]>

  export type WizardGroupSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    slug?: boolean
    description?: boolean
    status_id?: boolean
    created_at?: boolean
    company_id?: boolean
    transfer_status?: boolean
  }



  export type $WizardGroupPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "WizardGroup"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      slug: string
      description: string | null
      status_id: number
      created_at: string
      company_id: number
      transfer_status: number | null
    }, ExtArgs["result"]["wizardGroup"]>
    composites: {}
  }


  type WizardGroupGetPayload<S extends boolean | null | undefined | WizardGroupDefaultArgs> = $Result.GetResult<Prisma.$WizardGroupPayload, S>

  type WizardGroupCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<WizardGroupFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: WizardGroupCountAggregateInputType | true
    }

  export interface WizardGroupDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['WizardGroup'], meta: { name: 'WizardGroup' } }
    /**
     * Find zero or one WizardGroup that matches the filter.
     * @param {WizardGroupFindUniqueArgs} args - Arguments to find a WizardGroup
     * @example
     * // Get one WizardGroup
     * const wizardGroup = await prisma.wizardGroup.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends WizardGroupFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, WizardGroupFindUniqueArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one WizardGroup that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {WizardGroupFindUniqueOrThrowArgs} args - Arguments to find a WizardGroup
     * @example
     * // Get one WizardGroup
     * const wizardGroup = await prisma.wizardGroup.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends WizardGroupFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first WizardGroup that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupFindFirstArgs} args - Arguments to find a WizardGroup
     * @example
     * // Get one WizardGroup
     * const wizardGroup = await prisma.wizardGroup.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends WizardGroupFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupFindFirstArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first WizardGroup that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupFindFirstOrThrowArgs} args - Arguments to find a WizardGroup
     * @example
     * // Get one WizardGroup
     * const wizardGroup = await prisma.wizardGroup.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends WizardGroupFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more WizardGroups that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all WizardGroups
     * const wizardGroups = await prisma.wizardGroup.findMany()
     * 
     * // Get first 10 WizardGroups
     * const wizardGroups = await prisma.wizardGroup.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const wizardGroupWithIdOnly = await prisma.wizardGroup.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends WizardGroupFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a WizardGroup.
     * @param {WizardGroupCreateArgs} args - Arguments to create a WizardGroup.
     * @example
     * // Create one WizardGroup
     * const WizardGroup = await prisma.wizardGroup.create({
     *   data: {
     *     // ... data to create a WizardGroup
     *   }
     * })
     * 
    **/
    create<T extends WizardGroupCreateArgs<ExtArgs>>(
      args: SelectSubset<T, WizardGroupCreateArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many WizardGroups.
     * @param {WizardGroupCreateManyArgs} args - Arguments to create many WizardGroups.
     * @example
     * // Create many WizardGroups
     * const wizardGroup = await prisma.wizardGroup.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends WizardGroupCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many WizardGroups and returns the data saved in the database.
     * @param {WizardGroupCreateManyAndReturnArgs} args - Arguments to create many WizardGroups.
     * @example
     * // Create many WizardGroups
     * const wizardGroup = await prisma.wizardGroup.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many WizardGroups and only return the `id`
     * const wizardGroupWithIdOnly = await prisma.wizardGroup.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends WizardGroupCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a WizardGroup.
     * @param {WizardGroupDeleteArgs} args - Arguments to delete one WizardGroup.
     * @example
     * // Delete one WizardGroup
     * const WizardGroup = await prisma.wizardGroup.delete({
     *   where: {
     *     // ... filter to delete one WizardGroup
     *   }
     * })
     * 
    **/
    delete<T extends WizardGroupDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, WizardGroupDeleteArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one WizardGroup.
     * @param {WizardGroupUpdateArgs} args - Arguments to update one WizardGroup.
     * @example
     * // Update one WizardGroup
     * const wizardGroup = await prisma.wizardGroup.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends WizardGroupUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, WizardGroupUpdateArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more WizardGroups.
     * @param {WizardGroupDeleteManyArgs} args - Arguments to filter WizardGroups to delete.
     * @example
     * // Delete a few WizardGroups
     * const { count } = await prisma.wizardGroup.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends WizardGroupDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardGroupDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more WizardGroups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many WizardGroups
     * const wizardGroup = await prisma.wizardGroup.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends WizardGroupUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, WizardGroupUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one WizardGroup.
     * @param {WizardGroupUpsertArgs} args - Arguments to update or create a WizardGroup.
     * @example
     * // Update or create a WizardGroup
     * const wizardGroup = await prisma.wizardGroup.upsert({
     *   create: {
     *     // ... data to create a WizardGroup
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the WizardGroup we want to update
     *   }
     * })
    **/
    upsert<T extends WizardGroupUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, WizardGroupUpsertArgs<ExtArgs>>
    ): Prisma__WizardGroupClient<$Result.GetResult<Prisma.$WizardGroupPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of WizardGroups.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupCountArgs} args - Arguments to filter WizardGroups to count.
     * @example
     * // Count the number of WizardGroups
     * const count = await prisma.wizardGroup.count({
     *   where: {
     *     // ... the filter for the WizardGroups we want to count
     *   }
     * })
    **/
    count<T extends WizardGroupCountArgs>(
      args?: Subset<T, WizardGroupCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], WizardGroupCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a WizardGroup.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends WizardGroupAggregateArgs>(args: Subset<T, WizardGroupAggregateArgs>): Prisma.PrismaPromise<GetWizardGroupAggregateType<T>>

    /**
     * Group by WizardGroup.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardGroupGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends WizardGroupGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: WizardGroupGroupByArgs['orderBy'] }
        : { orderBy?: WizardGroupGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, WizardGroupGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetWizardGroupGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the WizardGroup model
   */
  readonly fields: WizardGroupFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for WizardGroup.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__WizardGroupClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';


    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the WizardGroup model
   */ 
  interface WizardGroupFieldRefs {
    readonly id: FieldRef<"WizardGroup", 'Int'>
    readonly uuid: FieldRef<"WizardGroup", 'String'>
    readonly name: FieldRef<"WizardGroup", 'String'>
    readonly slug: FieldRef<"WizardGroup", 'String'>
    readonly description: FieldRef<"WizardGroup", 'String'>
    readonly status_id: FieldRef<"WizardGroup", 'Int'>
    readonly created_at: FieldRef<"WizardGroup", 'String'>
    readonly company_id: FieldRef<"WizardGroup", 'Int'>
    readonly transfer_status: FieldRef<"WizardGroup", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * WizardGroup findUnique
   */
  export type WizardGroupFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * Filter, which WizardGroup to fetch.
     */
    where: WizardGroupWhereUniqueInput
  }

  /**
   * WizardGroup findUniqueOrThrow
   */
  export type WizardGroupFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * Filter, which WizardGroup to fetch.
     */
    where: WizardGroupWhereUniqueInput
  }

  /**
   * WizardGroup findFirst
   */
  export type WizardGroupFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * Filter, which WizardGroup to fetch.
     */
    where?: WizardGroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardGroups to fetch.
     */
    orderBy?: WizardGroupOrderByWithRelationInput | WizardGroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for WizardGroups.
     */
    cursor?: WizardGroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardGroups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardGroups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of WizardGroups.
     */
    distinct?: WizardGroupScalarFieldEnum | WizardGroupScalarFieldEnum[]
  }

  /**
   * WizardGroup findFirstOrThrow
   */
  export type WizardGroupFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * Filter, which WizardGroup to fetch.
     */
    where?: WizardGroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardGroups to fetch.
     */
    orderBy?: WizardGroupOrderByWithRelationInput | WizardGroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for WizardGroups.
     */
    cursor?: WizardGroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardGroups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardGroups.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of WizardGroups.
     */
    distinct?: WizardGroupScalarFieldEnum | WizardGroupScalarFieldEnum[]
  }

  /**
   * WizardGroup findMany
   */
  export type WizardGroupFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * Filter, which WizardGroups to fetch.
     */
    where?: WizardGroupWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardGroups to fetch.
     */
    orderBy?: WizardGroupOrderByWithRelationInput | WizardGroupOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing WizardGroups.
     */
    cursor?: WizardGroupWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardGroups from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardGroups.
     */
    skip?: number
    distinct?: WizardGroupScalarFieldEnum | WizardGroupScalarFieldEnum[]
  }

  /**
   * WizardGroup create
   */
  export type WizardGroupCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * The data needed to create a WizardGroup.
     */
    data: XOR<WizardGroupCreateInput, WizardGroupUncheckedCreateInput>
  }

  /**
   * WizardGroup createMany
   */
  export type WizardGroupCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many WizardGroups.
     */
    data: WizardGroupCreateManyInput | WizardGroupCreateManyInput[]
  }

  /**
   * WizardGroup createManyAndReturn
   */
  export type WizardGroupCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * The data used to create many WizardGroups.
     */
    data: WizardGroupCreateManyInput | WizardGroupCreateManyInput[]
  }

  /**
   * WizardGroup update
   */
  export type WizardGroupUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * The data needed to update a WizardGroup.
     */
    data: XOR<WizardGroupUpdateInput, WizardGroupUncheckedUpdateInput>
    /**
     * Choose, which WizardGroup to update.
     */
    where: WizardGroupWhereUniqueInput
  }

  /**
   * WizardGroup updateMany
   */
  export type WizardGroupUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update WizardGroups.
     */
    data: XOR<WizardGroupUpdateManyMutationInput, WizardGroupUncheckedUpdateManyInput>
    /**
     * Filter which WizardGroups to update
     */
    where?: WizardGroupWhereInput
  }

  /**
   * WizardGroup upsert
   */
  export type WizardGroupUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * The filter to search for the WizardGroup to update in case it exists.
     */
    where: WizardGroupWhereUniqueInput
    /**
     * In case the WizardGroup found by the `where` argument doesn't exist, create a new WizardGroup with this data.
     */
    create: XOR<WizardGroupCreateInput, WizardGroupUncheckedCreateInput>
    /**
     * In case the WizardGroup was found with the provided `where` argument, update it with this data.
     */
    update: XOR<WizardGroupUpdateInput, WizardGroupUncheckedUpdateInput>
  }

  /**
   * WizardGroup delete
   */
  export type WizardGroupDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
    /**
     * Filter which WizardGroup to delete.
     */
    where: WizardGroupWhereUniqueInput
  }

  /**
   * WizardGroup deleteMany
   */
  export type WizardGroupDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which WizardGroups to delete
     */
    where?: WizardGroupWhereInput
  }

  /**
   * WizardGroup without action
   */
  export type WizardGroupDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardGroup
     */
    select?: WizardGroupSelect<ExtArgs> | null
  }


  /**
   * Model WizardType
   */

  export type AggregateWizardType = {
    _count: WizardTypeCountAggregateOutputType | null
    _avg: WizardTypeAvgAggregateOutputType | null
    _sum: WizardTypeSumAggregateOutputType | null
    _min: WizardTypeMinAggregateOutputType | null
    _max: WizardTypeMaxAggregateOutputType | null
  }

  export type WizardTypeAvgAggregateOutputType = {
    id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardTypeSumAggregateOutputType = {
    id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardTypeMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    description: string | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardTypeMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    description: string | null
    company_id: number | null
    transfer_status: number | null
  }

  export type WizardTypeCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    description: number
    company_id: number
    transfer_status: number
    _all: number
  }


  export type WizardTypeAvgAggregateInputType = {
    id?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardTypeSumAggregateInputType = {
    id?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardTypeMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardTypeMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    company_id?: true
    transfer_status?: true
  }

  export type WizardTypeCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    description?: true
    company_id?: true
    transfer_status?: true
    _all?: true
  }

  export type WizardTypeAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which WizardType to aggregate.
     */
    where?: WizardTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardTypes to fetch.
     */
    orderBy?: WizardTypeOrderByWithRelationInput | WizardTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: WizardTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned WizardTypes
    **/
    _count?: true | WizardTypeCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: WizardTypeAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: WizardTypeSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: WizardTypeMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: WizardTypeMaxAggregateInputType
  }

  export type GetWizardTypeAggregateType<T extends WizardTypeAggregateArgs> = {
        [P in keyof T & keyof AggregateWizardType]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateWizardType[P]>
      : GetScalarType<T[P], AggregateWizardType[P]>
  }




  export type WizardTypeGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: WizardTypeWhereInput
    orderBy?: WizardTypeOrderByWithAggregationInput | WizardTypeOrderByWithAggregationInput[]
    by: WizardTypeScalarFieldEnum[] | WizardTypeScalarFieldEnum
    having?: WizardTypeScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: WizardTypeCountAggregateInputType | true
    _avg?: WizardTypeAvgAggregateInputType
    _sum?: WizardTypeSumAggregateInputType
    _min?: WizardTypeMinAggregateInputType
    _max?: WizardTypeMaxAggregateInputType
  }

  export type WizardTypeGroupByOutputType = {
    id: number
    uuid: string
    name: string
    description: string
    company_id: number
    transfer_status: number | null
    _count: WizardTypeCountAggregateOutputType | null
    _avg: WizardTypeAvgAggregateOutputType | null
    _sum: WizardTypeSumAggregateOutputType | null
    _min: WizardTypeMinAggregateOutputType | null
    _max: WizardTypeMaxAggregateOutputType | null
  }

  type GetWizardTypeGroupByPayload<T extends WizardTypeGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<WizardTypeGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof WizardTypeGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], WizardTypeGroupByOutputType[P]>
            : GetScalarType<T[P], WizardTypeGroupByOutputType[P]>
        }
      >
    >


  export type WizardTypeSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    description?: boolean
    company_id?: boolean
    transfer_status?: boolean
  }, ExtArgs["result"]["wizardType"]>

  export type WizardTypeSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    description?: boolean
    company_id?: boolean
    transfer_status?: boolean
  }



  export type $WizardTypePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "WizardType"
    objects: {}
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      description: string
      company_id: number
      transfer_status: number | null
    }, ExtArgs["result"]["wizardType"]>
    composites: {}
  }


  type WizardTypeGetPayload<S extends boolean | null | undefined | WizardTypeDefaultArgs> = $Result.GetResult<Prisma.$WizardTypePayload, S>

  type WizardTypeCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<WizardTypeFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: WizardTypeCountAggregateInputType | true
    }

  export interface WizardTypeDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['WizardType'], meta: { name: 'WizardType' } }
    /**
     * Find zero or one WizardType that matches the filter.
     * @param {WizardTypeFindUniqueArgs} args - Arguments to find a WizardType
     * @example
     * // Get one WizardType
     * const wizardType = await prisma.wizardType.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends WizardTypeFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, WizardTypeFindUniqueArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one WizardType that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {WizardTypeFindUniqueOrThrowArgs} args - Arguments to find a WizardType
     * @example
     * // Get one WizardType
     * const wizardType = await prisma.wizardType.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends WizardTypeFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first WizardType that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeFindFirstArgs} args - Arguments to find a WizardType
     * @example
     * // Get one WizardType
     * const wizardType = await prisma.wizardType.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends WizardTypeFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeFindFirstArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first WizardType that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeFindFirstOrThrowArgs} args - Arguments to find a WizardType
     * @example
     * // Get one WizardType
     * const wizardType = await prisma.wizardType.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends WizardTypeFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more WizardTypes that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all WizardTypes
     * const wizardTypes = await prisma.wizardType.findMany()
     * 
     * // Get first 10 WizardTypes
     * const wizardTypes = await prisma.wizardType.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const wizardTypeWithIdOnly = await prisma.wizardType.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends WizardTypeFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a WizardType.
     * @param {WizardTypeCreateArgs} args - Arguments to create a WizardType.
     * @example
     * // Create one WizardType
     * const WizardType = await prisma.wizardType.create({
     *   data: {
     *     // ... data to create a WizardType
     *   }
     * })
     * 
    **/
    create<T extends WizardTypeCreateArgs<ExtArgs>>(
      args: SelectSubset<T, WizardTypeCreateArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many WizardTypes.
     * @param {WizardTypeCreateManyArgs} args - Arguments to create many WizardTypes.
     * @example
     * // Create many WizardTypes
     * const wizardType = await prisma.wizardType.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends WizardTypeCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many WizardTypes and returns the data saved in the database.
     * @param {WizardTypeCreateManyAndReturnArgs} args - Arguments to create many WizardTypes.
     * @example
     * // Create many WizardTypes
     * const wizardType = await prisma.wizardType.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many WizardTypes and only return the `id`
     * const wizardTypeWithIdOnly = await prisma.wizardType.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends WizardTypeCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a WizardType.
     * @param {WizardTypeDeleteArgs} args - Arguments to delete one WizardType.
     * @example
     * // Delete one WizardType
     * const WizardType = await prisma.wizardType.delete({
     *   where: {
     *     // ... filter to delete one WizardType
     *   }
     * })
     * 
    **/
    delete<T extends WizardTypeDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, WizardTypeDeleteArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one WizardType.
     * @param {WizardTypeUpdateArgs} args - Arguments to update one WizardType.
     * @example
     * // Update one WizardType
     * const wizardType = await prisma.wizardType.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends WizardTypeUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, WizardTypeUpdateArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more WizardTypes.
     * @param {WizardTypeDeleteManyArgs} args - Arguments to filter WizardTypes to delete.
     * @example
     * // Delete a few WizardTypes
     * const { count } = await prisma.wizardType.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends WizardTypeDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, WizardTypeDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more WizardTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many WizardTypes
     * const wizardType = await prisma.wizardType.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends WizardTypeUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, WizardTypeUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one WizardType.
     * @param {WizardTypeUpsertArgs} args - Arguments to update or create a WizardType.
     * @example
     * // Update or create a WizardType
     * const wizardType = await prisma.wizardType.upsert({
     *   create: {
     *     // ... data to create a WizardType
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the WizardType we want to update
     *   }
     * })
    **/
    upsert<T extends WizardTypeUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, WizardTypeUpsertArgs<ExtArgs>>
    ): Prisma__WizardTypeClient<$Result.GetResult<Prisma.$WizardTypePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of WizardTypes.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeCountArgs} args - Arguments to filter WizardTypes to count.
     * @example
     * // Count the number of WizardTypes
     * const count = await prisma.wizardType.count({
     *   where: {
     *     // ... the filter for the WizardTypes we want to count
     *   }
     * })
    **/
    count<T extends WizardTypeCountArgs>(
      args?: Subset<T, WizardTypeCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], WizardTypeCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a WizardType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends WizardTypeAggregateArgs>(args: Subset<T, WizardTypeAggregateArgs>): Prisma.PrismaPromise<GetWizardTypeAggregateType<T>>

    /**
     * Group by WizardType.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {WizardTypeGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends WizardTypeGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: WizardTypeGroupByArgs['orderBy'] }
        : { orderBy?: WizardTypeGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, WizardTypeGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetWizardTypeGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the WizardType model
   */
  readonly fields: WizardTypeFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for WizardType.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__WizardTypeClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';


    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the WizardType model
   */ 
  interface WizardTypeFieldRefs {
    readonly id: FieldRef<"WizardType", 'Int'>
    readonly uuid: FieldRef<"WizardType", 'String'>
    readonly name: FieldRef<"WizardType", 'String'>
    readonly description: FieldRef<"WizardType", 'String'>
    readonly company_id: FieldRef<"WizardType", 'Int'>
    readonly transfer_status: FieldRef<"WizardType", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * WizardType findUnique
   */
  export type WizardTypeFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * Filter, which WizardType to fetch.
     */
    where: WizardTypeWhereUniqueInput
  }

  /**
   * WizardType findUniqueOrThrow
   */
  export type WizardTypeFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * Filter, which WizardType to fetch.
     */
    where: WizardTypeWhereUniqueInput
  }

  /**
   * WizardType findFirst
   */
  export type WizardTypeFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * Filter, which WizardType to fetch.
     */
    where?: WizardTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardTypes to fetch.
     */
    orderBy?: WizardTypeOrderByWithRelationInput | WizardTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for WizardTypes.
     */
    cursor?: WizardTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of WizardTypes.
     */
    distinct?: WizardTypeScalarFieldEnum | WizardTypeScalarFieldEnum[]
  }

  /**
   * WizardType findFirstOrThrow
   */
  export type WizardTypeFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * Filter, which WizardType to fetch.
     */
    where?: WizardTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardTypes to fetch.
     */
    orderBy?: WizardTypeOrderByWithRelationInput | WizardTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for WizardTypes.
     */
    cursor?: WizardTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardTypes.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of WizardTypes.
     */
    distinct?: WizardTypeScalarFieldEnum | WizardTypeScalarFieldEnum[]
  }

  /**
   * WizardType findMany
   */
  export type WizardTypeFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * Filter, which WizardTypes to fetch.
     */
    where?: WizardTypeWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of WizardTypes to fetch.
     */
    orderBy?: WizardTypeOrderByWithRelationInput | WizardTypeOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing WizardTypes.
     */
    cursor?: WizardTypeWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` WizardTypes from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` WizardTypes.
     */
    skip?: number
    distinct?: WizardTypeScalarFieldEnum | WizardTypeScalarFieldEnum[]
  }

  /**
   * WizardType create
   */
  export type WizardTypeCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * The data needed to create a WizardType.
     */
    data: XOR<WizardTypeCreateInput, WizardTypeUncheckedCreateInput>
  }

  /**
   * WizardType createMany
   */
  export type WizardTypeCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many WizardTypes.
     */
    data: WizardTypeCreateManyInput | WizardTypeCreateManyInput[]
  }

  /**
   * WizardType createManyAndReturn
   */
  export type WizardTypeCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * The data used to create many WizardTypes.
     */
    data: WizardTypeCreateManyInput | WizardTypeCreateManyInput[]
  }

  /**
   * WizardType update
   */
  export type WizardTypeUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * The data needed to update a WizardType.
     */
    data: XOR<WizardTypeUpdateInput, WizardTypeUncheckedUpdateInput>
    /**
     * Choose, which WizardType to update.
     */
    where: WizardTypeWhereUniqueInput
  }

  /**
   * WizardType updateMany
   */
  export type WizardTypeUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update WizardTypes.
     */
    data: XOR<WizardTypeUpdateManyMutationInput, WizardTypeUncheckedUpdateManyInput>
    /**
     * Filter which WizardTypes to update
     */
    where?: WizardTypeWhereInput
  }

  /**
   * WizardType upsert
   */
  export type WizardTypeUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * The filter to search for the WizardType to update in case it exists.
     */
    where: WizardTypeWhereUniqueInput
    /**
     * In case the WizardType found by the `where` argument doesn't exist, create a new WizardType with this data.
     */
    create: XOR<WizardTypeCreateInput, WizardTypeUncheckedCreateInput>
    /**
     * In case the WizardType was found with the provided `where` argument, update it with this data.
     */
    update: XOR<WizardTypeUpdateInput, WizardTypeUncheckedUpdateInput>
  }

  /**
   * WizardType delete
   */
  export type WizardTypeDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
    /**
     * Filter which WizardType to delete.
     */
    where: WizardTypeWhereUniqueInput
  }

  /**
   * WizardType deleteMany
   */
  export type WizardTypeDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which WizardTypes to delete
     */
    where?: WizardTypeWhereInput
  }

  /**
   * WizardType without action
   */
  export type WizardTypeDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the WizardType
     */
    select?: WizardTypeSelect<ExtArgs> | null
  }


  /**
   * Model MasterEntity
   */

  export type AggregateMasterEntity = {
    _count: MasterEntityCountAggregateOutputType | null
    _avg: MasterEntityAvgAggregateOutputType | null
    _sum: MasterEntitySumAggregateOutputType | null
    _min: MasterEntityMinAggregateOutputType | null
    _max: MasterEntityMaxAggregateOutputType | null
  }

  export type MasterEntityAvgAggregateOutputType = {
    id: number | null
    dashboard_wizard_group_id: number | null
    dashboard_wizard_rows: number | null
    dashboard_wizard_columns: number | null
    dashboard_wizard_order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type MasterEntitySumAggregateOutputType = {
    id: number | null
    dashboard_wizard_group_id: number | null
    dashboard_wizard_rows: number | null
    dashboard_wizard_columns: number | null
    dashboard_wizard_order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type MasterEntityMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    entity_name: string | null
    entity_type: string | null
    primary_table: string | null
    associated_tables: string | null
    query_information: string | null
    form_information: string | null
    add_query_information: string | null
    edit_query_information: string | null
    preset_query_information: string | null
    static_page_content: string | null
    dashboard_wizard_group_id: number | null
    dashboard_wizard_type: string | null
    dashboard_wizard_rows: number | null
    dashboard_wizard_columns: number | null
    dashboard_wizard_order_no: Decimal | null
    dashboard_wizard_options: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type MasterEntityMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    entity_name: string | null
    entity_type: string | null
    primary_table: string | null
    associated_tables: string | null
    query_information: string | null
    form_information: string | null
    add_query_information: string | null
    edit_query_information: string | null
    preset_query_information: string | null
    static_page_content: string | null
    dashboard_wizard_group_id: number | null
    dashboard_wizard_type: string | null
    dashboard_wizard_rows: number | null
    dashboard_wizard_columns: number | null
    dashboard_wizard_order_no: Decimal | null
    dashboard_wizard_options: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type MasterEntityCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    entity_name: number
    entity_type: number
    primary_table: number
    associated_tables: number
    query_information: number
    form_information: number
    add_query_information: number
    edit_query_information: number
    preset_query_information: number
    static_page_content: number
    dashboard_wizard_group_id: number
    dashboard_wizard_type: number
    dashboard_wizard_rows: number
    dashboard_wizard_columns: number
    dashboard_wizard_order_no: number
    dashboard_wizard_options: number
    status_id: number
    company_id: number
    created_at: number
    deleted_at: number
    transfer_status: number
    _all: number
  }


  export type MasterEntityAvgAggregateInputType = {
    id?: true
    dashboard_wizard_group_id?: true
    dashboard_wizard_rows?: true
    dashboard_wizard_columns?: true
    dashboard_wizard_order_no?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type MasterEntitySumAggregateInputType = {
    id?: true
    dashboard_wizard_group_id?: true
    dashboard_wizard_rows?: true
    dashboard_wizard_columns?: true
    dashboard_wizard_order_no?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type MasterEntityMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    entity_name?: true
    entity_type?: true
    primary_table?: true
    associated_tables?: true
    query_information?: true
    form_information?: true
    add_query_information?: true
    edit_query_information?: true
    preset_query_information?: true
    static_page_content?: true
    dashboard_wizard_group_id?: true
    dashboard_wizard_type?: true
    dashboard_wizard_rows?: true
    dashboard_wizard_columns?: true
    dashboard_wizard_order_no?: true
    dashboard_wizard_options?: true
    status_id?: true
    company_id?: true
    created_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type MasterEntityMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    entity_name?: true
    entity_type?: true
    primary_table?: true
    associated_tables?: true
    query_information?: true
    form_information?: true
    add_query_information?: true
    edit_query_information?: true
    preset_query_information?: true
    static_page_content?: true
    dashboard_wizard_group_id?: true
    dashboard_wizard_type?: true
    dashboard_wizard_rows?: true
    dashboard_wizard_columns?: true
    dashboard_wizard_order_no?: true
    dashboard_wizard_options?: true
    status_id?: true
    company_id?: true
    created_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type MasterEntityCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    entity_name?: true
    entity_type?: true
    primary_table?: true
    associated_tables?: true
    query_information?: true
    form_information?: true
    add_query_information?: true
    edit_query_information?: true
    preset_query_information?: true
    static_page_content?: true
    dashboard_wizard_group_id?: true
    dashboard_wizard_type?: true
    dashboard_wizard_rows?: true
    dashboard_wizard_columns?: true
    dashboard_wizard_order_no?: true
    dashboard_wizard_options?: true
    status_id?: true
    company_id?: true
    created_at?: true
    deleted_at?: true
    transfer_status?: true
    _all?: true
  }

  export type MasterEntityAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MasterEntity to aggregate.
     */
    where?: MasterEntityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntities to fetch.
     */
    orderBy?: MasterEntityOrderByWithRelationInput | MasterEntityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MasterEntityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntities.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned MasterEntities
    **/
    _count?: true | MasterEntityCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MasterEntityAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MasterEntitySumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MasterEntityMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MasterEntityMaxAggregateInputType
  }

  export type GetMasterEntityAggregateType<T extends MasterEntityAggregateArgs> = {
        [P in keyof T & keyof AggregateMasterEntity]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMasterEntity[P]>
      : GetScalarType<T[P], AggregateMasterEntity[P]>
  }




  export type MasterEntityGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityWhereInput
    orderBy?: MasterEntityOrderByWithAggregationInput | MasterEntityOrderByWithAggregationInput[]
    by: MasterEntityScalarFieldEnum[] | MasterEntityScalarFieldEnum
    having?: MasterEntityScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MasterEntityCountAggregateInputType | true
    _avg?: MasterEntityAvgAggregateInputType
    _sum?: MasterEntitySumAggregateInputType
    _min?: MasterEntityMinAggregateInputType
    _max?: MasterEntityMaxAggregateInputType
  }

  export type MasterEntityGroupByOutputType = {
    id: number
    uuid: string
    name: string
    entity_name: string
    entity_type: string
    primary_table: string | null
    associated_tables: string | null
    query_information: string | null
    form_information: string | null
    add_query_information: string | null
    edit_query_information: string | null
    preset_query_information: string | null
    static_page_content: string | null
    dashboard_wizard_group_id: number | null
    dashboard_wizard_type: string | null
    dashboard_wizard_rows: number | null
    dashboard_wizard_columns: number | null
    dashboard_wizard_order_no: Decimal | null
    dashboard_wizard_options: string | null
    status_id: number
    company_id: number
    created_at: string
    deleted_at: Date | null
    transfer_status: number | null
    _count: MasterEntityCountAggregateOutputType | null
    _avg: MasterEntityAvgAggregateOutputType | null
    _sum: MasterEntitySumAggregateOutputType | null
    _min: MasterEntityMinAggregateOutputType | null
    _max: MasterEntityMaxAggregateOutputType | null
  }

  type GetMasterEntityGroupByPayload<T extends MasterEntityGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MasterEntityGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MasterEntityGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MasterEntityGroupByOutputType[P]>
            : GetScalarType<T[P], MasterEntityGroupByOutputType[P]>
        }
      >
    >


  export type MasterEntitySelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    entity_name?: boolean
    entity_type?: boolean
    primary_table?: boolean
    associated_tables?: boolean
    query_information?: boolean
    form_information?: boolean
    add_query_information?: boolean
    edit_query_information?: boolean
    preset_query_information?: boolean
    static_page_content?: boolean
    dashboard_wizard_group_id?: boolean
    dashboard_wizard_type?: boolean
    dashboard_wizard_rows?: boolean
    dashboard_wizard_columns?: boolean
    dashboard_wizard_order_no?: boolean
    dashboard_wizard_options?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | MasterEntity$permissionsArgs<ExtArgs>
    line_items?: boolean | MasterEntity$line_itemsArgs<ExtArgs>
    _count?: boolean | MasterEntityCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["masterEntity"]>

  export type MasterEntitySelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    entity_name?: boolean
    entity_type?: boolean
    primary_table?: boolean
    associated_tables?: boolean
    query_information?: boolean
    form_information?: boolean
    add_query_information?: boolean
    edit_query_information?: boolean
    preset_query_information?: boolean
    static_page_content?: boolean
    dashboard_wizard_group_id?: boolean
    dashboard_wizard_type?: boolean
    dashboard_wizard_rows?: boolean
    dashboard_wizard_columns?: boolean
    dashboard_wizard_order_no?: boolean
    dashboard_wizard_options?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
  }


  export type MasterEntityInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    permissions?: boolean | MasterEntity$permissionsArgs<ExtArgs>
    line_items?: boolean | MasterEntity$line_itemsArgs<ExtArgs>
    _count?: boolean | MasterEntityCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $MasterEntityPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "MasterEntity"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      permissions: Prisma.$PermissionsPayload<ExtArgs>[]
      line_items: Prisma.$MasterEntityLineItemPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      entity_name: string
      entity_type: string
      primary_table: string | null
      associated_tables: string | null
      query_information: string | null
      form_information: string | null
      add_query_information: string | null
      edit_query_information: string | null
      preset_query_information: string | null
      static_page_content: string | null
      dashboard_wizard_group_id: number | null
      dashboard_wizard_type: string | null
      dashboard_wizard_rows: number | null
      dashboard_wizard_columns: number | null
      dashboard_wizard_order_no: Prisma.Decimal | null
      dashboard_wizard_options: string | null
      status_id: number
      company_id: number
      created_at: string
      deleted_at: Date | null
      transfer_status: number | null
    }, ExtArgs["result"]["masterEntity"]>
    composites: {}
  }


  type MasterEntityGetPayload<S extends boolean | null | undefined | MasterEntityDefaultArgs> = $Result.GetResult<Prisma.$MasterEntityPayload, S>

  type MasterEntityCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<MasterEntityFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MasterEntityCountAggregateInputType | true
    }

  export interface MasterEntityDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['MasterEntity'], meta: { name: 'MasterEntity' } }
    /**
     * Find zero or one MasterEntity that matches the filter.
     * @param {MasterEntityFindUniqueArgs} args - Arguments to find a MasterEntity
     * @example
     * // Get one MasterEntity
     * const masterEntity = await prisma.masterEntity.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends MasterEntityFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityFindUniqueArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one MasterEntity that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {MasterEntityFindUniqueOrThrowArgs} args - Arguments to find a MasterEntity
     * @example
     * // Get one MasterEntity
     * const masterEntity = await prisma.masterEntity.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends MasterEntityFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first MasterEntity that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityFindFirstArgs} args - Arguments to find a MasterEntity
     * @example
     * // Get one MasterEntity
     * const masterEntity = await prisma.masterEntity.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends MasterEntityFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityFindFirstArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first MasterEntity that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityFindFirstOrThrowArgs} args - Arguments to find a MasterEntity
     * @example
     * // Get one MasterEntity
     * const masterEntity = await prisma.masterEntity.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends MasterEntityFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more MasterEntities that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all MasterEntities
     * const masterEntities = await prisma.masterEntity.findMany()
     * 
     * // Get first 10 MasterEntities
     * const masterEntities = await prisma.masterEntity.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const masterEntityWithIdOnly = await prisma.masterEntity.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends MasterEntityFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a MasterEntity.
     * @param {MasterEntityCreateArgs} args - Arguments to create a MasterEntity.
     * @example
     * // Create one MasterEntity
     * const MasterEntity = await prisma.masterEntity.create({
     *   data: {
     *     // ... data to create a MasterEntity
     *   }
     * })
     * 
    **/
    create<T extends MasterEntityCreateArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityCreateArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many MasterEntities.
     * @param {MasterEntityCreateManyArgs} args - Arguments to create many MasterEntities.
     * @example
     * // Create many MasterEntities
     * const masterEntity = await prisma.masterEntity.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends MasterEntityCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many MasterEntities and returns the data saved in the database.
     * @param {MasterEntityCreateManyAndReturnArgs} args - Arguments to create many MasterEntities.
     * @example
     * // Create many MasterEntities
     * const masterEntity = await prisma.masterEntity.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many MasterEntities and only return the `id`
     * const masterEntityWithIdOnly = await prisma.masterEntity.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends MasterEntityCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a MasterEntity.
     * @param {MasterEntityDeleteArgs} args - Arguments to delete one MasterEntity.
     * @example
     * // Delete one MasterEntity
     * const MasterEntity = await prisma.masterEntity.delete({
     *   where: {
     *     // ... filter to delete one MasterEntity
     *   }
     * })
     * 
    **/
    delete<T extends MasterEntityDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityDeleteArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one MasterEntity.
     * @param {MasterEntityUpdateArgs} args - Arguments to update one MasterEntity.
     * @example
     * // Update one MasterEntity
     * const masterEntity = await prisma.masterEntity.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends MasterEntityUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityUpdateArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more MasterEntities.
     * @param {MasterEntityDeleteManyArgs} args - Arguments to filter MasterEntities to delete.
     * @example
     * // Delete a few MasterEntities
     * const { count } = await prisma.masterEntity.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends MasterEntityDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more MasterEntities.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many MasterEntities
     * const masterEntity = await prisma.masterEntity.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends MasterEntityUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one MasterEntity.
     * @param {MasterEntityUpsertArgs} args - Arguments to update or create a MasterEntity.
     * @example
     * // Update or create a MasterEntity
     * const masterEntity = await prisma.masterEntity.upsert({
     *   create: {
     *     // ... data to create a MasterEntity
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the MasterEntity we want to update
     *   }
     * })
    **/
    upsert<T extends MasterEntityUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityUpsertArgs<ExtArgs>>
    ): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of MasterEntities.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityCountArgs} args - Arguments to filter MasterEntities to count.
     * @example
     * // Count the number of MasterEntities
     * const count = await prisma.masterEntity.count({
     *   where: {
     *     // ... the filter for the MasterEntities we want to count
     *   }
     * })
    **/
    count<T extends MasterEntityCountArgs>(
      args?: Subset<T, MasterEntityCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MasterEntityCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a MasterEntity.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MasterEntityAggregateArgs>(args: Subset<T, MasterEntityAggregateArgs>): Prisma.PrismaPromise<GetMasterEntityAggregateType<T>>

    /**
     * Group by MasterEntity.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MasterEntityGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MasterEntityGroupByArgs['orderBy'] }
        : { orderBy?: MasterEntityGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MasterEntityGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMasterEntityGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the MasterEntity model
   */
  readonly fields: MasterEntityFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for MasterEntity.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MasterEntityClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permissions<T extends MasterEntity$permissionsArgs<ExtArgs> = {}>(args?: Subset<T, MasterEntity$permissionsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    line_items<T extends MasterEntity$line_itemsArgs<ExtArgs> = {}>(args?: Subset<T, MasterEntity$line_itemsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the MasterEntity model
   */ 
  interface MasterEntityFieldRefs {
    readonly id: FieldRef<"MasterEntity", 'Int'>
    readonly uuid: FieldRef<"MasterEntity", 'String'>
    readonly name: FieldRef<"MasterEntity", 'String'>
    readonly entity_name: FieldRef<"MasterEntity", 'String'>
    readonly entity_type: FieldRef<"MasterEntity", 'String'>
    readonly primary_table: FieldRef<"MasterEntity", 'String'>
    readonly associated_tables: FieldRef<"MasterEntity", 'String'>
    readonly query_information: FieldRef<"MasterEntity", 'String'>
    readonly form_information: FieldRef<"MasterEntity", 'String'>
    readonly add_query_information: FieldRef<"MasterEntity", 'String'>
    readonly edit_query_information: FieldRef<"MasterEntity", 'String'>
    readonly preset_query_information: FieldRef<"MasterEntity", 'String'>
    readonly static_page_content: FieldRef<"MasterEntity", 'String'>
    readonly dashboard_wizard_group_id: FieldRef<"MasterEntity", 'Int'>
    readonly dashboard_wizard_type: FieldRef<"MasterEntity", 'String'>
    readonly dashboard_wizard_rows: FieldRef<"MasterEntity", 'Int'>
    readonly dashboard_wizard_columns: FieldRef<"MasterEntity", 'Int'>
    readonly dashboard_wizard_order_no: FieldRef<"MasterEntity", 'Decimal'>
    readonly dashboard_wizard_options: FieldRef<"MasterEntity", 'String'>
    readonly status_id: FieldRef<"MasterEntity", 'Int'>
    readonly company_id: FieldRef<"MasterEntity", 'Int'>
    readonly created_at: FieldRef<"MasterEntity", 'String'>
    readonly deleted_at: FieldRef<"MasterEntity", 'DateTime'>
    readonly transfer_status: FieldRef<"MasterEntity", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * MasterEntity findUnique
   */
  export type MasterEntityFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntity to fetch.
     */
    where: MasterEntityWhereUniqueInput
  }

  /**
   * MasterEntity findUniqueOrThrow
   */
  export type MasterEntityFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntity to fetch.
     */
    where: MasterEntityWhereUniqueInput
  }

  /**
   * MasterEntity findFirst
   */
  export type MasterEntityFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntity to fetch.
     */
    where?: MasterEntityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntities to fetch.
     */
    orderBy?: MasterEntityOrderByWithRelationInput | MasterEntityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MasterEntities.
     */
    cursor?: MasterEntityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntities.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MasterEntities.
     */
    distinct?: MasterEntityScalarFieldEnum | MasterEntityScalarFieldEnum[]
  }

  /**
   * MasterEntity findFirstOrThrow
   */
  export type MasterEntityFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntity to fetch.
     */
    where?: MasterEntityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntities to fetch.
     */
    orderBy?: MasterEntityOrderByWithRelationInput | MasterEntityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MasterEntities.
     */
    cursor?: MasterEntityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntities.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MasterEntities.
     */
    distinct?: MasterEntityScalarFieldEnum | MasterEntityScalarFieldEnum[]
  }

  /**
   * MasterEntity findMany
   */
  export type MasterEntityFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntities to fetch.
     */
    where?: MasterEntityWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntities to fetch.
     */
    orderBy?: MasterEntityOrderByWithRelationInput | MasterEntityOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing MasterEntities.
     */
    cursor?: MasterEntityWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntities from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntities.
     */
    skip?: number
    distinct?: MasterEntityScalarFieldEnum | MasterEntityScalarFieldEnum[]
  }

  /**
   * MasterEntity create
   */
  export type MasterEntityCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * The data needed to create a MasterEntity.
     */
    data: XOR<MasterEntityCreateInput, MasterEntityUncheckedCreateInput>
  }

  /**
   * MasterEntity createMany
   */
  export type MasterEntityCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many MasterEntities.
     */
    data: MasterEntityCreateManyInput | MasterEntityCreateManyInput[]
  }

  /**
   * MasterEntity createManyAndReturn
   */
  export type MasterEntityCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * The data used to create many MasterEntities.
     */
    data: MasterEntityCreateManyInput | MasterEntityCreateManyInput[]
  }

  /**
   * MasterEntity update
   */
  export type MasterEntityUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * The data needed to update a MasterEntity.
     */
    data: XOR<MasterEntityUpdateInput, MasterEntityUncheckedUpdateInput>
    /**
     * Choose, which MasterEntity to update.
     */
    where: MasterEntityWhereUniqueInput
  }

  /**
   * MasterEntity updateMany
   */
  export type MasterEntityUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update MasterEntities.
     */
    data: XOR<MasterEntityUpdateManyMutationInput, MasterEntityUncheckedUpdateManyInput>
    /**
     * Filter which MasterEntities to update
     */
    where?: MasterEntityWhereInput
  }

  /**
   * MasterEntity upsert
   */
  export type MasterEntityUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * The filter to search for the MasterEntity to update in case it exists.
     */
    where: MasterEntityWhereUniqueInput
    /**
     * In case the MasterEntity found by the `where` argument doesn't exist, create a new MasterEntity with this data.
     */
    create: XOR<MasterEntityCreateInput, MasterEntityUncheckedCreateInput>
    /**
     * In case the MasterEntity was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MasterEntityUpdateInput, MasterEntityUncheckedUpdateInput>
  }

  /**
   * MasterEntity delete
   */
  export type MasterEntityDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    /**
     * Filter which MasterEntity to delete.
     */
    where: MasterEntityWhereUniqueInput
  }

  /**
   * MasterEntity deleteMany
   */
  export type MasterEntityDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MasterEntities to delete
     */
    where?: MasterEntityWhereInput
  }

  /**
   * MasterEntity.permissions
   */
  export type MasterEntity$permissionsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    where?: PermissionsWhereInput
    orderBy?: PermissionsOrderByWithRelationInput | PermissionsOrderByWithRelationInput[]
    cursor?: PermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * MasterEntity.line_items
   */
  export type MasterEntity$line_itemsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    where?: MasterEntityLineItemWhereInput
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    cursor?: MasterEntityLineItemWhereUniqueInput
    take?: number
    skip?: number
    distinct?: MasterEntityLineItemScalarFieldEnum | MasterEntityLineItemScalarFieldEnum[]
  }

  /**
   * MasterEntity without action
   */
  export type MasterEntityDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
  }


  /**
   * Model MasterEntityLineItem
   */

  export type AggregateMasterEntityLineItem = {
    _count: MasterEntityLineItemCountAggregateOutputType | null
    _avg: MasterEntityLineItemAvgAggregateOutputType | null
    _sum: MasterEntityLineItemSumAggregateOutputType | null
    _min: MasterEntityLineItemMinAggregateOutputType | null
    _max: MasterEntityLineItemMaxAggregateOutputType | null
  }

  export type MasterEntityLineItemAvgAggregateOutputType = {
    id: number | null
    master_grid_id: number | null
    width: number | null
    order_no: Decimal | null
    field_type_id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type MasterEntityLineItemSumAggregateOutputType = {
    id: number | null
    master_grid_id: number | null
    width: number | null
    order_no: Decimal | null
    field_type_id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type MasterEntityLineItemMinAggregateOutputType = {
    id: number | null
    master_grid_id: number | null
    field_name: string | null
    display_name: string | null
    width: number | null
    format: string | null
    is_default: boolean | null
    order_no: Decimal | null
    is_grid_column: boolean | null
    is_searchable: boolean | null
    clause_type: string | null
    is_sortable: boolean | null
    field_type_id: number | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type MasterEntityLineItemMaxAggregateOutputType = {
    id: number | null
    master_grid_id: number | null
    field_name: string | null
    display_name: string | null
    width: number | null
    format: string | null
    is_default: boolean | null
    order_no: Decimal | null
    is_grid_column: boolean | null
    is_searchable: boolean | null
    clause_type: string | null
    is_sortable: boolean | null
    field_type_id: number | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type MasterEntityLineItemCountAggregateOutputType = {
    id: number
    master_grid_id: number
    field_name: number
    display_name: number
    width: number
    format: number
    is_default: number
    order_no: number
    is_grid_column: number
    is_searchable: number
    clause_type: number
    is_sortable: number
    field_type_id: number
    status_id: number
    company_id: number
    created_at: number
    transfer_status: number
    _all: number
  }


  export type MasterEntityLineItemAvgAggregateInputType = {
    id?: true
    master_grid_id?: true
    width?: true
    order_no?: true
    field_type_id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type MasterEntityLineItemSumAggregateInputType = {
    id?: true
    master_grid_id?: true
    width?: true
    order_no?: true
    field_type_id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type MasterEntityLineItemMinAggregateInputType = {
    id?: true
    master_grid_id?: true
    field_name?: true
    display_name?: true
    width?: true
    format?: true
    is_default?: true
    order_no?: true
    is_grid_column?: true
    is_searchable?: true
    clause_type?: true
    is_sortable?: true
    field_type_id?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type MasterEntityLineItemMaxAggregateInputType = {
    id?: true
    master_grid_id?: true
    field_name?: true
    display_name?: true
    width?: true
    format?: true
    is_default?: true
    order_no?: true
    is_grid_column?: true
    is_searchable?: true
    clause_type?: true
    is_sortable?: true
    field_type_id?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type MasterEntityLineItemCountAggregateInputType = {
    id?: true
    master_grid_id?: true
    field_name?: true
    display_name?: true
    width?: true
    format?: true
    is_default?: true
    order_no?: true
    is_grid_column?: true
    is_searchable?: true
    clause_type?: true
    is_sortable?: true
    field_type_id?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
    _all?: true
  }

  export type MasterEntityLineItemAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MasterEntityLineItem to aggregate.
     */
    where?: MasterEntityLineItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntityLineItems to fetch.
     */
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MasterEntityLineItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntityLineItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntityLineItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned MasterEntityLineItems
    **/
    _count?: true | MasterEntityLineItemCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MasterEntityLineItemAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MasterEntityLineItemSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MasterEntityLineItemMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MasterEntityLineItemMaxAggregateInputType
  }

  export type GetMasterEntityLineItemAggregateType<T extends MasterEntityLineItemAggregateArgs> = {
        [P in keyof T & keyof AggregateMasterEntityLineItem]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMasterEntityLineItem[P]>
      : GetScalarType<T[P], AggregateMasterEntityLineItem[P]>
  }




  export type MasterEntityLineItemGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MasterEntityLineItemWhereInput
    orderBy?: MasterEntityLineItemOrderByWithAggregationInput | MasterEntityLineItemOrderByWithAggregationInput[]
    by: MasterEntityLineItemScalarFieldEnum[] | MasterEntityLineItemScalarFieldEnum
    having?: MasterEntityLineItemScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MasterEntityLineItemCountAggregateInputType | true
    _avg?: MasterEntityLineItemAvgAggregateInputType
    _sum?: MasterEntityLineItemSumAggregateInputType
    _min?: MasterEntityLineItemMinAggregateInputType
    _max?: MasterEntityLineItemMaxAggregateInputType
  }

  export type MasterEntityLineItemGroupByOutputType = {
    id: number
    master_grid_id: number
    field_name: string
    display_name: string
    width: number | null
    format: string | null
    is_default: boolean
    order_no: Decimal
    is_grid_column: boolean
    is_searchable: boolean
    clause_type: string | null
    is_sortable: boolean
    field_type_id: number
    status_id: number
    company_id: number
    created_at: string
    transfer_status: number | null
    _count: MasterEntityLineItemCountAggregateOutputType | null
    _avg: MasterEntityLineItemAvgAggregateOutputType | null
    _sum: MasterEntityLineItemSumAggregateOutputType | null
    _min: MasterEntityLineItemMinAggregateOutputType | null
    _max: MasterEntityLineItemMaxAggregateOutputType | null
  }

  type GetMasterEntityLineItemGroupByPayload<T extends MasterEntityLineItemGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MasterEntityLineItemGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MasterEntityLineItemGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MasterEntityLineItemGroupByOutputType[P]>
            : GetScalarType<T[P], MasterEntityLineItemGroupByOutputType[P]>
        }
      >
    >


  export type MasterEntityLineItemSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    master_grid_id?: boolean
    field_name?: boolean
    display_name?: boolean
    width?: boolean
    format?: boolean
    is_default?: boolean
    order_no?: boolean
    is_grid_column?: boolean
    is_searchable?: boolean
    clause_type?: boolean
    is_sortable?: boolean
    field_type_id?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    master_grid?: boolean | MasterEntityDefaultArgs<ExtArgs>
    field_type?: boolean | FieldTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["masterEntityLineItem"]>

  export type MasterEntityLineItemSelectScalar = {
    id?: boolean
    master_grid_id?: boolean
    field_name?: boolean
    display_name?: boolean
    width?: boolean
    format?: boolean
    is_default?: boolean
    order_no?: boolean
    is_grid_column?: boolean
    is_searchable?: boolean
    clause_type?: boolean
    is_sortable?: boolean
    field_type_id?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
  }


  export type MasterEntityLineItemInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    master_grid?: boolean | MasterEntityDefaultArgs<ExtArgs>
    field_type?: boolean | FieldTypeDefaultArgs<ExtArgs>
  }


  export type $MasterEntityLineItemPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "MasterEntityLineItem"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      master_grid: Prisma.$MasterEntityPayload<ExtArgs>
      field_type: Prisma.$FieldTypePayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      master_grid_id: number
      field_name: string
      display_name: string
      width: number | null
      format: string | null
      is_default: boolean
      order_no: Prisma.Decimal
      is_grid_column: boolean
      is_searchable: boolean
      clause_type: string | null
      is_sortable: boolean
      field_type_id: number
      status_id: number
      company_id: number
      created_at: string
      transfer_status: number | null
    }, ExtArgs["result"]["masterEntityLineItem"]>
    composites: {}
  }


  type MasterEntityLineItemGetPayload<S extends boolean | null | undefined | MasterEntityLineItemDefaultArgs> = $Result.GetResult<Prisma.$MasterEntityLineItemPayload, S>

  type MasterEntityLineItemCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<MasterEntityLineItemFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MasterEntityLineItemCountAggregateInputType | true
    }

  export interface MasterEntityLineItemDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['MasterEntityLineItem'], meta: { name: 'MasterEntityLineItem' } }
    /**
     * Find zero or one MasterEntityLineItem that matches the filter.
     * @param {MasterEntityLineItemFindUniqueArgs} args - Arguments to find a MasterEntityLineItem
     * @example
     * // Get one MasterEntityLineItem
     * const masterEntityLineItem = await prisma.masterEntityLineItem.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends MasterEntityLineItemFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityLineItemFindUniqueArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one MasterEntityLineItem that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {MasterEntityLineItemFindUniqueOrThrowArgs} args - Arguments to find a MasterEntityLineItem
     * @example
     * // Get one MasterEntityLineItem
     * const masterEntityLineItem = await prisma.masterEntityLineItem.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends MasterEntityLineItemFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first MasterEntityLineItem that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemFindFirstArgs} args - Arguments to find a MasterEntityLineItem
     * @example
     * // Get one MasterEntityLineItem
     * const masterEntityLineItem = await prisma.masterEntityLineItem.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends MasterEntityLineItemFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemFindFirstArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first MasterEntityLineItem that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemFindFirstOrThrowArgs} args - Arguments to find a MasterEntityLineItem
     * @example
     * // Get one MasterEntityLineItem
     * const masterEntityLineItem = await prisma.masterEntityLineItem.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends MasterEntityLineItemFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more MasterEntityLineItems that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all MasterEntityLineItems
     * const masterEntityLineItems = await prisma.masterEntityLineItem.findMany()
     * 
     * // Get first 10 MasterEntityLineItems
     * const masterEntityLineItems = await prisma.masterEntityLineItem.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const masterEntityLineItemWithIdOnly = await prisma.masterEntityLineItem.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends MasterEntityLineItemFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a MasterEntityLineItem.
     * @param {MasterEntityLineItemCreateArgs} args - Arguments to create a MasterEntityLineItem.
     * @example
     * // Create one MasterEntityLineItem
     * const MasterEntityLineItem = await prisma.masterEntityLineItem.create({
     *   data: {
     *     // ... data to create a MasterEntityLineItem
     *   }
     * })
     * 
    **/
    create<T extends MasterEntityLineItemCreateArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityLineItemCreateArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many MasterEntityLineItems.
     * @param {MasterEntityLineItemCreateManyArgs} args - Arguments to create many MasterEntityLineItems.
     * @example
     * // Create many MasterEntityLineItems
     * const masterEntityLineItem = await prisma.masterEntityLineItem.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends MasterEntityLineItemCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many MasterEntityLineItems and returns the data saved in the database.
     * @param {MasterEntityLineItemCreateManyAndReturnArgs} args - Arguments to create many MasterEntityLineItems.
     * @example
     * // Create many MasterEntityLineItems
     * const masterEntityLineItem = await prisma.masterEntityLineItem.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many MasterEntityLineItems and only return the `id`
     * const masterEntityLineItemWithIdOnly = await prisma.masterEntityLineItem.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends MasterEntityLineItemCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a MasterEntityLineItem.
     * @param {MasterEntityLineItemDeleteArgs} args - Arguments to delete one MasterEntityLineItem.
     * @example
     * // Delete one MasterEntityLineItem
     * const MasterEntityLineItem = await prisma.masterEntityLineItem.delete({
     *   where: {
     *     // ... filter to delete one MasterEntityLineItem
     *   }
     * })
     * 
    **/
    delete<T extends MasterEntityLineItemDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityLineItemDeleteArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one MasterEntityLineItem.
     * @param {MasterEntityLineItemUpdateArgs} args - Arguments to update one MasterEntityLineItem.
     * @example
     * // Update one MasterEntityLineItem
     * const masterEntityLineItem = await prisma.masterEntityLineItem.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends MasterEntityLineItemUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityLineItemUpdateArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more MasterEntityLineItems.
     * @param {MasterEntityLineItemDeleteManyArgs} args - Arguments to filter MasterEntityLineItems to delete.
     * @example
     * // Delete a few MasterEntityLineItems
     * const { count } = await prisma.masterEntityLineItem.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends MasterEntityLineItemDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MasterEntityLineItemDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more MasterEntityLineItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many MasterEntityLineItems
     * const masterEntityLineItem = await prisma.masterEntityLineItem.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends MasterEntityLineItemUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityLineItemUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one MasterEntityLineItem.
     * @param {MasterEntityLineItemUpsertArgs} args - Arguments to update or create a MasterEntityLineItem.
     * @example
     * // Update or create a MasterEntityLineItem
     * const masterEntityLineItem = await prisma.masterEntityLineItem.upsert({
     *   create: {
     *     // ... data to create a MasterEntityLineItem
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the MasterEntityLineItem we want to update
     *   }
     * })
    **/
    upsert<T extends MasterEntityLineItemUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, MasterEntityLineItemUpsertArgs<ExtArgs>>
    ): Prisma__MasterEntityLineItemClient<$Result.GetResult<Prisma.$MasterEntityLineItemPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of MasterEntityLineItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemCountArgs} args - Arguments to filter MasterEntityLineItems to count.
     * @example
     * // Count the number of MasterEntityLineItems
     * const count = await prisma.masterEntityLineItem.count({
     *   where: {
     *     // ... the filter for the MasterEntityLineItems we want to count
     *   }
     * })
    **/
    count<T extends MasterEntityLineItemCountArgs>(
      args?: Subset<T, MasterEntityLineItemCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MasterEntityLineItemCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a MasterEntityLineItem.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MasterEntityLineItemAggregateArgs>(args: Subset<T, MasterEntityLineItemAggregateArgs>): Prisma.PrismaPromise<GetMasterEntityLineItemAggregateType<T>>

    /**
     * Group by MasterEntityLineItem.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MasterEntityLineItemGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MasterEntityLineItemGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MasterEntityLineItemGroupByArgs['orderBy'] }
        : { orderBy?: MasterEntityLineItemGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MasterEntityLineItemGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMasterEntityLineItemGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the MasterEntityLineItem model
   */
  readonly fields: MasterEntityLineItemFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for MasterEntityLineItem.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MasterEntityLineItemClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    master_grid<T extends MasterEntityDefaultArgs<ExtArgs> = {}>(args?: Subset<T, MasterEntityDefaultArgs<ExtArgs>>): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    field_type<T extends FieldTypeDefaultArgs<ExtArgs> = {}>(args?: Subset<T, FieldTypeDefaultArgs<ExtArgs>>): Prisma__FieldTypeClient<$Result.GetResult<Prisma.$FieldTypePayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the MasterEntityLineItem model
   */ 
  interface MasterEntityLineItemFieldRefs {
    readonly id: FieldRef<"MasterEntityLineItem", 'Int'>
    readonly master_grid_id: FieldRef<"MasterEntityLineItem", 'Int'>
    readonly field_name: FieldRef<"MasterEntityLineItem", 'String'>
    readonly display_name: FieldRef<"MasterEntityLineItem", 'String'>
    readonly width: FieldRef<"MasterEntityLineItem", 'Int'>
    readonly format: FieldRef<"MasterEntityLineItem", 'String'>
    readonly is_default: FieldRef<"MasterEntityLineItem", 'Boolean'>
    readonly order_no: FieldRef<"MasterEntityLineItem", 'Decimal'>
    readonly is_grid_column: FieldRef<"MasterEntityLineItem", 'Boolean'>
    readonly is_searchable: FieldRef<"MasterEntityLineItem", 'Boolean'>
    readonly clause_type: FieldRef<"MasterEntityLineItem", 'String'>
    readonly is_sortable: FieldRef<"MasterEntityLineItem", 'Boolean'>
    readonly field_type_id: FieldRef<"MasterEntityLineItem", 'Int'>
    readonly status_id: FieldRef<"MasterEntityLineItem", 'Int'>
    readonly company_id: FieldRef<"MasterEntityLineItem", 'Int'>
    readonly created_at: FieldRef<"MasterEntityLineItem", 'String'>
    readonly transfer_status: FieldRef<"MasterEntityLineItem", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * MasterEntityLineItem findUnique
   */
  export type MasterEntityLineItemFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntityLineItem to fetch.
     */
    where: MasterEntityLineItemWhereUniqueInput
  }

  /**
   * MasterEntityLineItem findUniqueOrThrow
   */
  export type MasterEntityLineItemFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntityLineItem to fetch.
     */
    where: MasterEntityLineItemWhereUniqueInput
  }

  /**
   * MasterEntityLineItem findFirst
   */
  export type MasterEntityLineItemFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntityLineItem to fetch.
     */
    where?: MasterEntityLineItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntityLineItems to fetch.
     */
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MasterEntityLineItems.
     */
    cursor?: MasterEntityLineItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntityLineItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntityLineItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MasterEntityLineItems.
     */
    distinct?: MasterEntityLineItemScalarFieldEnum | MasterEntityLineItemScalarFieldEnum[]
  }

  /**
   * MasterEntityLineItem findFirstOrThrow
   */
  export type MasterEntityLineItemFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntityLineItem to fetch.
     */
    where?: MasterEntityLineItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntityLineItems to fetch.
     */
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MasterEntityLineItems.
     */
    cursor?: MasterEntityLineItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntityLineItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntityLineItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MasterEntityLineItems.
     */
    distinct?: MasterEntityLineItemScalarFieldEnum | MasterEntityLineItemScalarFieldEnum[]
  }

  /**
   * MasterEntityLineItem findMany
   */
  export type MasterEntityLineItemFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * Filter, which MasterEntityLineItems to fetch.
     */
    where?: MasterEntityLineItemWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MasterEntityLineItems to fetch.
     */
    orderBy?: MasterEntityLineItemOrderByWithRelationInput | MasterEntityLineItemOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing MasterEntityLineItems.
     */
    cursor?: MasterEntityLineItemWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MasterEntityLineItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MasterEntityLineItems.
     */
    skip?: number
    distinct?: MasterEntityLineItemScalarFieldEnum | MasterEntityLineItemScalarFieldEnum[]
  }

  /**
   * MasterEntityLineItem create
   */
  export type MasterEntityLineItemCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * The data needed to create a MasterEntityLineItem.
     */
    data: XOR<MasterEntityLineItemCreateInput, MasterEntityLineItemUncheckedCreateInput>
  }

  /**
   * MasterEntityLineItem createMany
   */
  export type MasterEntityLineItemCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many MasterEntityLineItems.
     */
    data: MasterEntityLineItemCreateManyInput | MasterEntityLineItemCreateManyInput[]
  }

  /**
   * MasterEntityLineItem createManyAndReturn
   */
  export type MasterEntityLineItemCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * The data used to create many MasterEntityLineItems.
     */
    data: MasterEntityLineItemCreateManyInput | MasterEntityLineItemCreateManyInput[]
  }

  /**
   * MasterEntityLineItem update
   */
  export type MasterEntityLineItemUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * The data needed to update a MasterEntityLineItem.
     */
    data: XOR<MasterEntityLineItemUpdateInput, MasterEntityLineItemUncheckedUpdateInput>
    /**
     * Choose, which MasterEntityLineItem to update.
     */
    where: MasterEntityLineItemWhereUniqueInput
  }

  /**
   * MasterEntityLineItem updateMany
   */
  export type MasterEntityLineItemUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update MasterEntityLineItems.
     */
    data: XOR<MasterEntityLineItemUpdateManyMutationInput, MasterEntityLineItemUncheckedUpdateManyInput>
    /**
     * Filter which MasterEntityLineItems to update
     */
    where?: MasterEntityLineItemWhereInput
  }

  /**
   * MasterEntityLineItem upsert
   */
  export type MasterEntityLineItemUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * The filter to search for the MasterEntityLineItem to update in case it exists.
     */
    where: MasterEntityLineItemWhereUniqueInput
    /**
     * In case the MasterEntityLineItem found by the `where` argument doesn't exist, create a new MasterEntityLineItem with this data.
     */
    create: XOR<MasterEntityLineItemCreateInput, MasterEntityLineItemUncheckedCreateInput>
    /**
     * In case the MasterEntityLineItem was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MasterEntityLineItemUpdateInput, MasterEntityLineItemUncheckedUpdateInput>
  }

  /**
   * MasterEntityLineItem delete
   */
  export type MasterEntityLineItemDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
    /**
     * Filter which MasterEntityLineItem to delete.
     */
    where: MasterEntityLineItemWhereUniqueInput
  }

  /**
   * MasterEntityLineItem deleteMany
   */
  export type MasterEntityLineItemDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MasterEntityLineItems to delete
     */
    where?: MasterEntityLineItemWhereInput
  }

  /**
   * MasterEntityLineItem without action
   */
  export type MasterEntityLineItemDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntityLineItem
     */
    select?: MasterEntityLineItemSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityLineItemInclude<ExtArgs> | null
  }


  /**
   * Model Permissions
   */

  export type AggregatePermissions = {
    _count: PermissionsCountAggregateOutputType | null
    _avg: PermissionsAvgAggregateOutputType | null
    _sum: PermissionsSumAggregateOutputType | null
    _min: PermissionsMinAggregateOutputType | null
    _max: PermissionsMaxAggregateOutputType | null
  }

  export type PermissionsAvgAggregateOutputType = {
    id: number | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type PermissionsSumAggregateOutputType = {
    id: number | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type PermissionsMinAggregateOutputType = {
    id: number | null
    name: string | null
    slug: string | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type PermissionsMaxAggregateOutputType = {
    id: number | null
    name: string | null
    slug: string | null
    entity_id: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type PermissionsCountAggregateOutputType = {
    id: number
    name: number
    slug: number
    entity_id: number
    order_no: number
    status_id: number
    company_id: number
    created_at: number
    transfer_status: number
    _all: number
  }


  export type PermissionsAvgAggregateInputType = {
    id?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type PermissionsSumAggregateInputType = {
    id?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type PermissionsMinAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type PermissionsMaxAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type PermissionsCountAggregateInputType = {
    id?: true
    name?: true
    slug?: true
    entity_id?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
    _all?: true
  }

  export type PermissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Permissions to aggregate.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationInput | PermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Permissions
    **/
    _count?: true | PermissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: PermissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: PermissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: PermissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: PermissionsMaxAggregateInputType
  }

  export type GetPermissionsAggregateType<T extends PermissionsAggregateArgs> = {
        [P in keyof T & keyof AggregatePermissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregatePermissions[P]>
      : GetScalarType<T[P], AggregatePermissions[P]>
  }




  export type PermissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: PermissionsWhereInput
    orderBy?: PermissionsOrderByWithAggregationInput | PermissionsOrderByWithAggregationInput[]
    by: PermissionsScalarFieldEnum[] | PermissionsScalarFieldEnum
    having?: PermissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: PermissionsCountAggregateInputType | true
    _avg?: PermissionsAvgAggregateInputType
    _sum?: PermissionsSumAggregateInputType
    _min?: PermissionsMinAggregateInputType
    _max?: PermissionsMaxAggregateInputType
  }

  export type PermissionsGroupByOutputType = {
    id: number
    name: string
    slug: string
    entity_id: number | null
    order_no: Decimal
    status_id: number
    company_id: number
    created_at: string
    transfer_status: number | null
    _count: PermissionsCountAggregateOutputType | null
    _avg: PermissionsAvgAggregateOutputType | null
    _sum: PermissionsSumAggregateOutputType | null
    _min: PermissionsMinAggregateOutputType | null
    _max: PermissionsMaxAggregateOutputType | null
  }

  type GetPermissionsGroupByPayload<T extends PermissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<PermissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof PermissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], PermissionsGroupByOutputType[P]>
            : GetScalarType<T[P], PermissionsGroupByOutputType[P]>
        }
      >
    >


  export type PermissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    name?: boolean
    slug?: boolean
    entity_id?: boolean
    order_no?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    entity?: boolean | Permissions$entityArgs<ExtArgs>
    roles?: boolean | Permissions$rolesArgs<ExtArgs>
    users?: boolean | Permissions$usersArgs<ExtArgs>
    _count?: boolean | PermissionsCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["permissions"]>

  export type PermissionsSelectScalar = {
    id?: boolean
    name?: boolean
    slug?: boolean
    entity_id?: boolean
    order_no?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
  }


  export type PermissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    entity?: boolean | Permissions$entityArgs<ExtArgs>
    roles?: boolean | Permissions$rolesArgs<ExtArgs>
    users?: boolean | Permissions$usersArgs<ExtArgs>
    _count?: boolean | PermissionsCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $PermissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Permissions"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      entity: Prisma.$MasterEntityPayload<ExtArgs> | null
      roles: Prisma.$RolePermissionsPayload<ExtArgs>[]
      users: Prisma.$UserPermissionsPayload<ExtArgs>[]
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      name: string
      slug: string
      entity_id: number | null
      order_no: Prisma.Decimal
      status_id: number
      company_id: number
      created_at: string
      transfer_status: number | null
    }, ExtArgs["result"]["permissions"]>
    composites: {}
  }


  type PermissionsGetPayload<S extends boolean | null | undefined | PermissionsDefaultArgs> = $Result.GetResult<Prisma.$PermissionsPayload, S>

  type PermissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<PermissionsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: PermissionsCountAggregateInputType | true
    }

  export interface PermissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Permissions'], meta: { name: 'Permissions' } }
    /**
     * Find zero or one Permissions that matches the filter.
     * @param {PermissionsFindUniqueArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends PermissionsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsFindUniqueArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Permissions that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {PermissionsFindUniqueOrThrowArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends PermissionsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsFindFirstArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends PermissionsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindFirstArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Permissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsFindFirstOrThrowArgs} args - Arguments to find a Permissions
     * @example
     * // Get one Permissions
     * const permissions = await prisma.permissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends PermissionsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Permissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Permissions
     * const permissions = await prisma.permissions.findMany()
     * 
     * // Get first 10 Permissions
     * const permissions = await prisma.permissions.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const permissionsWithIdOnly = await prisma.permissions.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends PermissionsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Permissions.
     * @param {PermissionsCreateArgs} args - Arguments to create a Permissions.
     * @example
     * // Create one Permissions
     * const Permissions = await prisma.permissions.create({
     *   data: {
     *     // ... data to create a Permissions
     *   }
     * })
     * 
    **/
    create<T extends PermissionsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsCreateArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Permissions.
     * @param {PermissionsCreateManyArgs} args - Arguments to create many Permissions.
     * @example
     * // Create many Permissions
     * const permissions = await prisma.permissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends PermissionsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Permissions and returns the data saved in the database.
     * @param {PermissionsCreateManyAndReturnArgs} args - Arguments to create many Permissions.
     * @example
     * // Create many Permissions
     * const permissions = await prisma.permissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Permissions and only return the `id`
     * const permissionsWithIdOnly = await prisma.permissions.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends PermissionsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Permissions.
     * @param {PermissionsDeleteArgs} args - Arguments to delete one Permissions.
     * @example
     * // Delete one Permissions
     * const Permissions = await prisma.permissions.delete({
     *   where: {
     *     // ... filter to delete one Permissions
     *   }
     * })
     * 
    **/
    delete<T extends PermissionsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsDeleteArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Permissions.
     * @param {PermissionsUpdateArgs} args - Arguments to update one Permissions.
     * @example
     * // Update one Permissions
     * const permissions = await prisma.permissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends PermissionsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsUpdateArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Permissions.
     * @param {PermissionsDeleteManyArgs} args - Arguments to filter Permissions to delete.
     * @example
     * // Delete a few Permissions
     * const { count } = await prisma.permissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends PermissionsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, PermissionsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Permissions
     * const permissions = await prisma.permissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends PermissionsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Permissions.
     * @param {PermissionsUpsertArgs} args - Arguments to update or create a Permissions.
     * @example
     * // Update or create a Permissions
     * const permissions = await prisma.permissions.upsert({
     *   create: {
     *     // ... data to create a Permissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Permissions we want to update
     *   }
     * })
    **/
    upsert<T extends PermissionsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, PermissionsUpsertArgs<ExtArgs>>
    ): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsCountArgs} args - Arguments to filter Permissions to count.
     * @example
     * // Count the number of Permissions
     * const count = await prisma.permissions.count({
     *   where: {
     *     // ... the filter for the Permissions we want to count
     *   }
     * })
    **/
    count<T extends PermissionsCountArgs>(
      args?: Subset<T, PermissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], PermissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends PermissionsAggregateArgs>(args: Subset<T, PermissionsAggregateArgs>): Prisma.PrismaPromise<GetPermissionsAggregateType<T>>

    /**
     * Group by Permissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {PermissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends PermissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: PermissionsGroupByArgs['orderBy'] }
        : { orderBy?: PermissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, PermissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetPermissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Permissions model
   */
  readonly fields: PermissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Permissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__PermissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    entity<T extends Permissions$entityArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$entityArgs<ExtArgs>>): Prisma__MasterEntityClient<$Result.GetResult<Prisma.$MasterEntityPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    roles<T extends Permissions$rolesArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$rolesArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    users<T extends Permissions$usersArgs<ExtArgs> = {}>(args?: Subset<T, Permissions$usersArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findMany'> | Null>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Permissions model
   */ 
  interface PermissionsFieldRefs {
    readonly id: FieldRef<"Permissions", 'Int'>
    readonly name: FieldRef<"Permissions", 'String'>
    readonly slug: FieldRef<"Permissions", 'String'>
    readonly entity_id: FieldRef<"Permissions", 'Int'>
    readonly order_no: FieldRef<"Permissions", 'Decimal'>
    readonly status_id: FieldRef<"Permissions", 'Int'>
    readonly company_id: FieldRef<"Permissions", 'Int'>
    readonly created_at: FieldRef<"Permissions", 'String'>
    readonly transfer_status: FieldRef<"Permissions", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Permissions findUnique
   */
  export type PermissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions findUniqueOrThrow
   */
  export type PermissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions findFirst
   */
  export type PermissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationInput | PermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Permissions.
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Permissions.
     */
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Permissions findFirstOrThrow
   */
  export type PermissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationInput | PermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Permissions.
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Permissions.
     */
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Permissions findMany
   */
  export type PermissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter, which Permissions to fetch.
     */
    where?: PermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Permissions to fetch.
     */
    orderBy?: PermissionsOrderByWithRelationInput | PermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Permissions.
     */
    cursor?: PermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Permissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Permissions.
     */
    skip?: number
    distinct?: PermissionsScalarFieldEnum | PermissionsScalarFieldEnum[]
  }

  /**
   * Permissions create
   */
  export type PermissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a Permissions.
     */
    data: XOR<PermissionsCreateInput, PermissionsUncheckedCreateInput>
  }

  /**
   * Permissions createMany
   */
  export type PermissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Permissions.
     */
    data: PermissionsCreateManyInput | PermissionsCreateManyInput[]
  }

  /**
   * Permissions createManyAndReturn
   */
  export type PermissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The data used to create many Permissions.
     */
    data: PermissionsCreateManyInput | PermissionsCreateManyInput[]
  }

  /**
   * Permissions update
   */
  export type PermissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The data needed to update a Permissions.
     */
    data: XOR<PermissionsUpdateInput, PermissionsUncheckedUpdateInput>
    /**
     * Choose, which Permissions to update.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions updateMany
   */
  export type PermissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Permissions.
     */
    data: XOR<PermissionsUpdateManyMutationInput, PermissionsUncheckedUpdateManyInput>
    /**
     * Filter which Permissions to update
     */
    where?: PermissionsWhereInput
  }

  /**
   * Permissions upsert
   */
  export type PermissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * The filter to search for the Permissions to update in case it exists.
     */
    where: PermissionsWhereUniqueInput
    /**
     * In case the Permissions found by the `where` argument doesn't exist, create a new Permissions with this data.
     */
    create: XOR<PermissionsCreateInput, PermissionsUncheckedCreateInput>
    /**
     * In case the Permissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<PermissionsUpdateInput, PermissionsUncheckedUpdateInput>
  }

  /**
   * Permissions delete
   */
  export type PermissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
    /**
     * Filter which Permissions to delete.
     */
    where: PermissionsWhereUniqueInput
  }

  /**
   * Permissions deleteMany
   */
  export type PermissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Permissions to delete
     */
    where?: PermissionsWhereInput
  }

  /**
   * Permissions.entity
   */
  export type Permissions$entityArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MasterEntity
     */
    select?: MasterEntitySelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MasterEntityInclude<ExtArgs> | null
    where?: MasterEntityWhereInput
  }

  /**
   * Permissions.roles
   */
  export type Permissions$rolesArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    where?: RolePermissionsWhereInput
    orderBy?: RolePermissionsOrderByWithRelationInput | RolePermissionsOrderByWithRelationInput[]
    cursor?: RolePermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * Permissions.users
   */
  export type Permissions$usersArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    where?: UserPermissionsWhereInput
    orderBy?: UserPermissionsOrderByWithRelationInput | UserPermissionsOrderByWithRelationInput[]
    cursor?: UserPermissionsWhereUniqueInput
    take?: number
    skip?: number
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * Permissions without action
   */
  export type PermissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Permissions
     */
    select?: PermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: PermissionsInclude<ExtArgs> | null
  }


  /**
   * Model MenuItems
   */

  export type AggregateMenuItems = {
    _count: MenuItemsCountAggregateOutputType | null
    _avg: MenuItemsAvgAggregateOutputType | null
    _sum: MenuItemsSumAggregateOutputType | null
    _min: MenuItemsMinAggregateOutputType | null
    _max: MenuItemsMaxAggregateOutputType | null
  }

  export type MenuItemsAvgAggregateOutputType = {
    id: number | null
    menu_id: number | null
    parent_id: number | null
    permission_id: number | null
    entity_id: number | null
    link_type: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type MenuItemsSumAggregateOutputType = {
    id: number | null
    menu_id: number | null
    parent_id: number | null
    permission_id: number | null
    entity_id: number | null
    link_type: number | null
    order_no: Decimal | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type MenuItemsMinAggregateOutputType = {
    id: number | null
    menu_id: number | null
    name: string | null
    target: string | null
    parent_id: number | null
    permission_id: number | null
    entity_id: number | null
    link_type: number | null
    order_no: Decimal | null
    menu_img: string | null
    short_cut_keys: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type MenuItemsMaxAggregateOutputType = {
    id: number | null
    menu_id: number | null
    name: string | null
    target: string | null
    parent_id: number | null
    permission_id: number | null
    entity_id: number | null
    link_type: number | null
    order_no: Decimal | null
    menu_img: string | null
    short_cut_keys: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type MenuItemsCountAggregateOutputType = {
    id: number
    menu_id: number
    name: number
    target: number
    parent_id: number
    permission_id: number
    entity_id: number
    link_type: number
    order_no: number
    menu_img: number
    short_cut_keys: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    transfer_status: number
    _all: number
  }


  export type MenuItemsAvgAggregateInputType = {
    id?: true
    menu_id?: true
    parent_id?: true
    permission_id?: true
    entity_id?: true
    link_type?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type MenuItemsSumAggregateInputType = {
    id?: true
    menu_id?: true
    parent_id?: true
    permission_id?: true
    entity_id?: true
    link_type?: true
    order_no?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type MenuItemsMinAggregateInputType = {
    id?: true
    menu_id?: true
    name?: true
    target?: true
    parent_id?: true
    permission_id?: true
    entity_id?: true
    link_type?: true
    order_no?: true
    menu_img?: true
    short_cut_keys?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type MenuItemsMaxAggregateInputType = {
    id?: true
    menu_id?: true
    name?: true
    target?: true
    parent_id?: true
    permission_id?: true
    entity_id?: true
    link_type?: true
    order_no?: true
    menu_img?: true
    short_cut_keys?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type MenuItemsCountAggregateInputType = {
    id?: true
    menu_id?: true
    name?: true
    target?: true
    parent_id?: true
    permission_id?: true
    entity_id?: true
    link_type?: true
    order_no?: true
    menu_img?: true
    short_cut_keys?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
    _all?: true
  }

  export type MenuItemsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MenuItems to aggregate.
     */
    where?: MenuItemsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MenuItems to fetch.
     */
    orderBy?: MenuItemsOrderByWithRelationInput | MenuItemsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: MenuItemsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MenuItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MenuItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned MenuItems
    **/
    _count?: true | MenuItemsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: MenuItemsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: MenuItemsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: MenuItemsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: MenuItemsMaxAggregateInputType
  }

  export type GetMenuItemsAggregateType<T extends MenuItemsAggregateArgs> = {
        [P in keyof T & keyof AggregateMenuItems]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateMenuItems[P]>
      : GetScalarType<T[P], AggregateMenuItems[P]>
  }




  export type MenuItemsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: MenuItemsWhereInput
    orderBy?: MenuItemsOrderByWithAggregationInput | MenuItemsOrderByWithAggregationInput[]
    by: MenuItemsScalarFieldEnum[] | MenuItemsScalarFieldEnum
    having?: MenuItemsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: MenuItemsCountAggregateInputType | true
    _avg?: MenuItemsAvgAggregateInputType
    _sum?: MenuItemsSumAggregateInputType
    _min?: MenuItemsMinAggregateInputType
    _max?: MenuItemsMaxAggregateInputType
  }

  export type MenuItemsGroupByOutputType = {
    id: number
    menu_id: number
    name: string
    target: string | null
    parent_id: number | null
    permission_id: number | null
    entity_id: number | null
    link_type: number | null
    order_no: Decimal
    menu_img: string | null
    short_cut_keys: string | null
    status_id: number
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
    _count: MenuItemsCountAggregateOutputType | null
    _avg: MenuItemsAvgAggregateOutputType | null
    _sum: MenuItemsSumAggregateOutputType | null
    _min: MenuItemsMinAggregateOutputType | null
    _max: MenuItemsMaxAggregateOutputType | null
  }

  type GetMenuItemsGroupByPayload<T extends MenuItemsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<MenuItemsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof MenuItemsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], MenuItemsGroupByOutputType[P]>
            : GetScalarType<T[P], MenuItemsGroupByOutputType[P]>
        }
      >
    >


  export type MenuItemsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    menu_id?: boolean
    name?: boolean
    target?: boolean
    parent_id?: boolean
    permission_id?: boolean
    entity_id?: boolean
    link_type?: boolean
    order_no?: boolean
    menu_img?: boolean
    short_cut_keys?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["menuItems"]>

  export type MenuItemsSelectScalar = {
    id?: boolean
    menu_id?: boolean
    name?: boolean
    target?: boolean
    parent_id?: boolean
    permission_id?: boolean
    entity_id?: boolean
    link_type?: boolean
    order_no?: boolean
    menu_img?: boolean
    short_cut_keys?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
  }


  export type MenuItemsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
  }


  export type $MenuItemsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "MenuItems"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      menu_id: number
      name: string
      target: string | null
      parent_id: number | null
      permission_id: number | null
      entity_id: number | null
      link_type: number | null
      order_no: Prisma.Decimal
      menu_img: string | null
      short_cut_keys: string | null
      status_id: number
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: string | null
      updated_at: Date | null
      deleted_at: Date | null
      transfer_status: number | null
    }, ExtArgs["result"]["menuItems"]>
    composites: {}
  }


  type MenuItemsGetPayload<S extends boolean | null | undefined | MenuItemsDefaultArgs> = $Result.GetResult<Prisma.$MenuItemsPayload, S>

  type MenuItemsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<MenuItemsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: MenuItemsCountAggregateInputType | true
    }

  export interface MenuItemsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['MenuItems'], meta: { name: 'MenuItems' } }
    /**
     * Find zero or one MenuItems that matches the filter.
     * @param {MenuItemsFindUniqueArgs} args - Arguments to find a MenuItems
     * @example
     * // Get one MenuItems
     * const menuItems = await prisma.menuItems.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends MenuItemsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, MenuItemsFindUniqueArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one MenuItems that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {MenuItemsFindUniqueOrThrowArgs} args - Arguments to find a MenuItems
     * @example
     * // Get one MenuItems
     * const menuItems = await prisma.menuItems.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends MenuItemsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first MenuItems that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsFindFirstArgs} args - Arguments to find a MenuItems
     * @example
     * // Get one MenuItems
     * const menuItems = await prisma.menuItems.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends MenuItemsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsFindFirstArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first MenuItems that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsFindFirstOrThrowArgs} args - Arguments to find a MenuItems
     * @example
     * // Get one MenuItems
     * const menuItems = await prisma.menuItems.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends MenuItemsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more MenuItems that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all MenuItems
     * const menuItems = await prisma.menuItems.findMany()
     * 
     * // Get first 10 MenuItems
     * const menuItems = await prisma.menuItems.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const menuItemsWithIdOnly = await prisma.menuItems.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends MenuItemsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a MenuItems.
     * @param {MenuItemsCreateArgs} args - Arguments to create a MenuItems.
     * @example
     * // Create one MenuItems
     * const MenuItems = await prisma.menuItems.create({
     *   data: {
     *     // ... data to create a MenuItems
     *   }
     * })
     * 
    **/
    create<T extends MenuItemsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, MenuItemsCreateArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many MenuItems.
     * @param {MenuItemsCreateManyArgs} args - Arguments to create many MenuItems.
     * @example
     * // Create many MenuItems
     * const menuItems = await prisma.menuItems.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends MenuItemsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many MenuItems and returns the data saved in the database.
     * @param {MenuItemsCreateManyAndReturnArgs} args - Arguments to create many MenuItems.
     * @example
     * // Create many MenuItems
     * const menuItems = await prisma.menuItems.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many MenuItems and only return the `id`
     * const menuItemsWithIdOnly = await prisma.menuItems.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends MenuItemsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a MenuItems.
     * @param {MenuItemsDeleteArgs} args - Arguments to delete one MenuItems.
     * @example
     * // Delete one MenuItems
     * const MenuItems = await prisma.menuItems.delete({
     *   where: {
     *     // ... filter to delete one MenuItems
     *   }
     * })
     * 
    **/
    delete<T extends MenuItemsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, MenuItemsDeleteArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one MenuItems.
     * @param {MenuItemsUpdateArgs} args - Arguments to update one MenuItems.
     * @example
     * // Update one MenuItems
     * const menuItems = await prisma.menuItems.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends MenuItemsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, MenuItemsUpdateArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more MenuItems.
     * @param {MenuItemsDeleteManyArgs} args - Arguments to filter MenuItems to delete.
     * @example
     * // Delete a few MenuItems
     * const { count } = await prisma.menuItems.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends MenuItemsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, MenuItemsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more MenuItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many MenuItems
     * const menuItems = await prisma.menuItems.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends MenuItemsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, MenuItemsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one MenuItems.
     * @param {MenuItemsUpsertArgs} args - Arguments to update or create a MenuItems.
     * @example
     * // Update or create a MenuItems
     * const menuItems = await prisma.menuItems.upsert({
     *   create: {
     *     // ... data to create a MenuItems
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the MenuItems we want to update
     *   }
     * })
    **/
    upsert<T extends MenuItemsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, MenuItemsUpsertArgs<ExtArgs>>
    ): Prisma__MenuItemsClient<$Result.GetResult<Prisma.$MenuItemsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of MenuItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsCountArgs} args - Arguments to filter MenuItems to count.
     * @example
     * // Count the number of MenuItems
     * const count = await prisma.menuItems.count({
     *   where: {
     *     // ... the filter for the MenuItems we want to count
     *   }
     * })
    **/
    count<T extends MenuItemsCountArgs>(
      args?: Subset<T, MenuItemsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], MenuItemsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a MenuItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends MenuItemsAggregateArgs>(args: Subset<T, MenuItemsAggregateArgs>): Prisma.PrismaPromise<GetMenuItemsAggregateType<T>>

    /**
     * Group by MenuItems.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {MenuItemsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends MenuItemsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: MenuItemsGroupByArgs['orderBy'] }
        : { orderBy?: MenuItemsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, MenuItemsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetMenuItemsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the MenuItems model
   */
  readonly fields: MenuItemsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for MenuItems.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__MenuItemsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the MenuItems model
   */ 
  interface MenuItemsFieldRefs {
    readonly id: FieldRef<"MenuItems", 'Int'>
    readonly menu_id: FieldRef<"MenuItems", 'Int'>
    readonly name: FieldRef<"MenuItems", 'String'>
    readonly target: FieldRef<"MenuItems", 'String'>
    readonly parent_id: FieldRef<"MenuItems", 'Int'>
    readonly permission_id: FieldRef<"MenuItems", 'Int'>
    readonly entity_id: FieldRef<"MenuItems", 'Int'>
    readonly link_type: FieldRef<"MenuItems", 'Int'>
    readonly order_no: FieldRef<"MenuItems", 'Decimal'>
    readonly menu_img: FieldRef<"MenuItems", 'String'>
    readonly short_cut_keys: FieldRef<"MenuItems", 'String'>
    readonly status_id: FieldRef<"MenuItems", 'Int'>
    readonly company_id: FieldRef<"MenuItems", 'Int'>
    readonly created_by: FieldRef<"MenuItems", 'Int'>
    readonly updated_by: FieldRef<"MenuItems", 'Int'>
    readonly deleted_by: FieldRef<"MenuItems", 'Int'>
    readonly created_at: FieldRef<"MenuItems", 'String'>
    readonly updated_at: FieldRef<"MenuItems", 'DateTime'>
    readonly deleted_at: FieldRef<"MenuItems", 'DateTime'>
    readonly transfer_status: FieldRef<"MenuItems", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * MenuItems findUnique
   */
  export type MenuItemsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * Filter, which MenuItems to fetch.
     */
    where: MenuItemsWhereUniqueInput
  }

  /**
   * MenuItems findUniqueOrThrow
   */
  export type MenuItemsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * Filter, which MenuItems to fetch.
     */
    where: MenuItemsWhereUniqueInput
  }

  /**
   * MenuItems findFirst
   */
  export type MenuItemsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * Filter, which MenuItems to fetch.
     */
    where?: MenuItemsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MenuItems to fetch.
     */
    orderBy?: MenuItemsOrderByWithRelationInput | MenuItemsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MenuItems.
     */
    cursor?: MenuItemsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MenuItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MenuItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MenuItems.
     */
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * MenuItems findFirstOrThrow
   */
  export type MenuItemsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * Filter, which MenuItems to fetch.
     */
    where?: MenuItemsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MenuItems to fetch.
     */
    orderBy?: MenuItemsOrderByWithRelationInput | MenuItemsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for MenuItems.
     */
    cursor?: MenuItemsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MenuItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MenuItems.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of MenuItems.
     */
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * MenuItems findMany
   */
  export type MenuItemsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * Filter, which MenuItems to fetch.
     */
    where?: MenuItemsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of MenuItems to fetch.
     */
    orderBy?: MenuItemsOrderByWithRelationInput | MenuItemsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing MenuItems.
     */
    cursor?: MenuItemsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` MenuItems from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` MenuItems.
     */
    skip?: number
    distinct?: MenuItemsScalarFieldEnum | MenuItemsScalarFieldEnum[]
  }

  /**
   * MenuItems create
   */
  export type MenuItemsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * The data needed to create a MenuItems.
     */
    data: XOR<MenuItemsCreateInput, MenuItemsUncheckedCreateInput>
  }

  /**
   * MenuItems createMany
   */
  export type MenuItemsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many MenuItems.
     */
    data: MenuItemsCreateManyInput | MenuItemsCreateManyInput[]
  }

  /**
   * MenuItems createManyAndReturn
   */
  export type MenuItemsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * The data used to create many MenuItems.
     */
    data: MenuItemsCreateManyInput | MenuItemsCreateManyInput[]
  }

  /**
   * MenuItems update
   */
  export type MenuItemsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * The data needed to update a MenuItems.
     */
    data: XOR<MenuItemsUpdateInput, MenuItemsUncheckedUpdateInput>
    /**
     * Choose, which MenuItems to update.
     */
    where: MenuItemsWhereUniqueInput
  }

  /**
   * MenuItems updateMany
   */
  export type MenuItemsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update MenuItems.
     */
    data: XOR<MenuItemsUpdateManyMutationInput, MenuItemsUncheckedUpdateManyInput>
    /**
     * Filter which MenuItems to update
     */
    where?: MenuItemsWhereInput
  }

  /**
   * MenuItems upsert
   */
  export type MenuItemsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * The filter to search for the MenuItems to update in case it exists.
     */
    where: MenuItemsWhereUniqueInput
    /**
     * In case the MenuItems found by the `where` argument doesn't exist, create a new MenuItems with this data.
     */
    create: XOR<MenuItemsCreateInput, MenuItemsUncheckedCreateInput>
    /**
     * In case the MenuItems was found with the provided `where` argument, update it with this data.
     */
    update: XOR<MenuItemsUpdateInput, MenuItemsUncheckedUpdateInput>
  }

  /**
   * MenuItems delete
   */
  export type MenuItemsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
    /**
     * Filter which MenuItems to delete.
     */
    where: MenuItemsWhereUniqueInput
  }

  /**
   * MenuItems deleteMany
   */
  export type MenuItemsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which MenuItems to delete
     */
    where?: MenuItemsWhereInput
  }

  /**
   * MenuItems without action
   */
  export type MenuItemsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the MenuItems
     */
    select?: MenuItemsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: MenuItemsInclude<ExtArgs> | null
  }


  /**
   * Model UserPermissions
   */

  export type AggregateUserPermissions = {
    _count: UserPermissionsCountAggregateOutputType | null
    _avg: UserPermissionsAvgAggregateOutputType | null
    _sum: UserPermissionsSumAggregateOutputType | null
    _min: UserPermissionsMinAggregateOutputType | null
    _max: UserPermissionsMaxAggregateOutputType | null
  }

  export type UserPermissionsAvgAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserPermissionsSumAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserPermissionsMinAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserPermissionsMaxAggregateOutputType = {
    user_id: number | null
    permission_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type UserPermissionsCountAggregateOutputType = {
    user_id: number
    permission_id: number
    company_id: number
    transfer_status: number
    _all: number
  }


  export type UserPermissionsAvgAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserPermissionsSumAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserPermissionsMinAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserPermissionsMaxAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type UserPermissionsCountAggregateInputType = {
    user_id?: true
    permission_id?: true
    company_id?: true
    transfer_status?: true
    _all?: true
  }

  export type UserPermissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPermissions to aggregate.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationInput | UserPermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned UserPermissions
    **/
    _count?: true | UserPermissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: UserPermissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: UserPermissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: UserPermissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: UserPermissionsMaxAggregateInputType
  }

  export type GetUserPermissionsAggregateType<T extends UserPermissionsAggregateArgs> = {
        [P in keyof T & keyof AggregateUserPermissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateUserPermissions[P]>
      : GetScalarType<T[P], AggregateUserPermissions[P]>
  }




  export type UserPermissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: UserPermissionsWhereInput
    orderBy?: UserPermissionsOrderByWithAggregationInput | UserPermissionsOrderByWithAggregationInput[]
    by: UserPermissionsScalarFieldEnum[] | UserPermissionsScalarFieldEnum
    having?: UserPermissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: UserPermissionsCountAggregateInputType | true
    _avg?: UserPermissionsAvgAggregateInputType
    _sum?: UserPermissionsSumAggregateInputType
    _min?: UserPermissionsMinAggregateInputType
    _max?: UserPermissionsMaxAggregateInputType
  }

  export type UserPermissionsGroupByOutputType = {
    user_id: number
    permission_id: number
    company_id: number
    transfer_status: number | null
    _count: UserPermissionsCountAggregateOutputType | null
    _avg: UserPermissionsAvgAggregateOutputType | null
    _sum: UserPermissionsSumAggregateOutputType | null
    _min: UserPermissionsMinAggregateOutputType | null
    _max: UserPermissionsMaxAggregateOutputType | null
  }

  type GetUserPermissionsGroupByPayload<T extends UserPermissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<UserPermissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof UserPermissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], UserPermissionsGroupByOutputType[P]>
            : GetScalarType<T[P], UserPermissionsGroupByOutputType[P]>
        }
      >
    >


  export type UserPermissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    user_id?: boolean
    permission_id?: boolean
    company_id?: boolean
    transfer_status?: boolean
    user?: boolean | UserDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["userPermissions"]>

  export type UserPermissionsSelectScalar = {
    user_id?: boolean
    permission_id?: boolean
    company_id?: boolean
    transfer_status?: boolean
  }


  export type UserPermissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    user?: boolean | UserDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }


  export type $UserPermissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "UserPermissions"
    objects: {
      user: Prisma.$UserPayload<ExtArgs>
      permission: Prisma.$PermissionsPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      user_id: number
      permission_id: number
      company_id: number
      transfer_status: number | null
    }, ExtArgs["result"]["userPermissions"]>
    composites: {}
  }


  type UserPermissionsGetPayload<S extends boolean | null | undefined | UserPermissionsDefaultArgs> = $Result.GetResult<Prisma.$UserPermissionsPayload, S>

  type UserPermissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<UserPermissionsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: UserPermissionsCountAggregateInputType | true
    }

  export interface UserPermissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['UserPermissions'], meta: { name: 'UserPermissions' } }
    /**
     * Find zero or one UserPermissions that matches the filter.
     * @param {UserPermissionsFindUniqueArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends UserPermissionsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsFindUniqueArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one UserPermissions that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {UserPermissionsFindUniqueOrThrowArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends UserPermissionsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first UserPermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsFindFirstArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends UserPermissionsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindFirstArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first UserPermissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsFindFirstOrThrowArgs} args - Arguments to find a UserPermissions
     * @example
     * // Get one UserPermissions
     * const userPermissions = await prisma.userPermissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends UserPermissionsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more UserPermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all UserPermissions
     * const userPermissions = await prisma.userPermissions.findMany()
     * 
     * // Get first 10 UserPermissions
     * const userPermissions = await prisma.userPermissions.findMany({ take: 10 })
     * 
     * // Only select the `user_id`
     * const userPermissionsWithUser_idOnly = await prisma.userPermissions.findMany({ select: { user_id: true } })
     * 
    **/
    findMany<T extends UserPermissionsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a UserPermissions.
     * @param {UserPermissionsCreateArgs} args - Arguments to create a UserPermissions.
     * @example
     * // Create one UserPermissions
     * const UserPermissions = await prisma.userPermissions.create({
     *   data: {
     *     // ... data to create a UserPermissions
     *   }
     * })
     * 
    **/
    create<T extends UserPermissionsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsCreateArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many UserPermissions.
     * @param {UserPermissionsCreateManyArgs} args - Arguments to create many UserPermissions.
     * @example
     * // Create many UserPermissions
     * const userPermissions = await prisma.userPermissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends UserPermissionsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many UserPermissions and returns the data saved in the database.
     * @param {UserPermissionsCreateManyAndReturnArgs} args - Arguments to create many UserPermissions.
     * @example
     * // Create many UserPermissions
     * const userPermissions = await prisma.userPermissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many UserPermissions and only return the `user_id`
     * const userPermissionsWithUser_idOnly = await prisma.userPermissions.createManyAndReturn({ 
     *   select: { user_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends UserPermissionsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a UserPermissions.
     * @param {UserPermissionsDeleteArgs} args - Arguments to delete one UserPermissions.
     * @example
     * // Delete one UserPermissions
     * const UserPermissions = await prisma.userPermissions.delete({
     *   where: {
     *     // ... filter to delete one UserPermissions
     *   }
     * })
     * 
    **/
    delete<T extends UserPermissionsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsDeleteArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one UserPermissions.
     * @param {UserPermissionsUpdateArgs} args - Arguments to update one UserPermissions.
     * @example
     * // Update one UserPermissions
     * const userPermissions = await prisma.userPermissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends UserPermissionsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsUpdateArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more UserPermissions.
     * @param {UserPermissionsDeleteManyArgs} args - Arguments to filter UserPermissions to delete.
     * @example
     * // Delete a few UserPermissions
     * const { count } = await prisma.userPermissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends UserPermissionsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, UserPermissionsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many UserPermissions
     * const userPermissions = await prisma.userPermissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends UserPermissionsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one UserPermissions.
     * @param {UserPermissionsUpsertArgs} args - Arguments to update or create a UserPermissions.
     * @example
     * // Update or create a UserPermissions
     * const userPermissions = await prisma.userPermissions.upsert({
     *   create: {
     *     // ... data to create a UserPermissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the UserPermissions we want to update
     *   }
     * })
    **/
    upsert<T extends UserPermissionsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, UserPermissionsUpsertArgs<ExtArgs>>
    ): Prisma__UserPermissionsClient<$Result.GetResult<Prisma.$UserPermissionsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsCountArgs} args - Arguments to filter UserPermissions to count.
     * @example
     * // Count the number of UserPermissions
     * const count = await prisma.userPermissions.count({
     *   where: {
     *     // ... the filter for the UserPermissions we want to count
     *   }
     * })
    **/
    count<T extends UserPermissionsCountArgs>(
      args?: Subset<T, UserPermissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], UserPermissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends UserPermissionsAggregateArgs>(args: Subset<T, UserPermissionsAggregateArgs>): Prisma.PrismaPromise<GetUserPermissionsAggregateType<T>>

    /**
     * Group by UserPermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {UserPermissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends UserPermissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: UserPermissionsGroupByArgs['orderBy'] }
        : { orderBy?: UserPermissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, UserPermissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetUserPermissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the UserPermissions model
   */
  readonly fields: UserPermissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for UserPermissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__UserPermissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    user<T extends UserDefaultArgs<ExtArgs> = {}>(args?: Subset<T, UserDefaultArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permission<T extends PermissionsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, PermissionsDefaultArgs<ExtArgs>>): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the UserPermissions model
   */ 
  interface UserPermissionsFieldRefs {
    readonly user_id: FieldRef<"UserPermissions", 'Int'>
    readonly permission_id: FieldRef<"UserPermissions", 'Int'>
    readonly company_id: FieldRef<"UserPermissions", 'Int'>
    readonly transfer_status: FieldRef<"UserPermissions", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * UserPermissions findUnique
   */
  export type UserPermissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where: UserPermissionsWhereUniqueInput
  }

  /**
   * UserPermissions findUniqueOrThrow
   */
  export type UserPermissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where: UserPermissionsWhereUniqueInput
  }

  /**
   * UserPermissions findFirst
   */
  export type UserPermissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationInput | UserPermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPermissions.
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPermissions.
     */
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * UserPermissions findFirstOrThrow
   */
  export type UserPermissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationInput | UserPermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for UserPermissions.
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of UserPermissions.
     */
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * UserPermissions findMany
   */
  export type UserPermissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter, which UserPermissions to fetch.
     */
    where?: UserPermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of UserPermissions to fetch.
     */
    orderBy?: UserPermissionsOrderByWithRelationInput | UserPermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing UserPermissions.
     */
    cursor?: UserPermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` UserPermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` UserPermissions.
     */
    skip?: number
    distinct?: UserPermissionsScalarFieldEnum | UserPermissionsScalarFieldEnum[]
  }

  /**
   * UserPermissions create
   */
  export type UserPermissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a UserPermissions.
     */
    data: XOR<UserPermissionsCreateInput, UserPermissionsUncheckedCreateInput>
  }

  /**
   * UserPermissions createMany
   */
  export type UserPermissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many UserPermissions.
     */
    data: UserPermissionsCreateManyInput | UserPermissionsCreateManyInput[]
  }

  /**
   * UserPermissions createManyAndReturn
   */
  export type UserPermissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * The data used to create many UserPermissions.
     */
    data: UserPermissionsCreateManyInput | UserPermissionsCreateManyInput[]
  }

  /**
   * UserPermissions update
   */
  export type UserPermissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * The data needed to update a UserPermissions.
     */
    data: XOR<UserPermissionsUpdateInput, UserPermissionsUncheckedUpdateInput>
    /**
     * Choose, which UserPermissions to update.
     */
    where: UserPermissionsWhereUniqueInput
  }

  /**
   * UserPermissions updateMany
   */
  export type UserPermissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update UserPermissions.
     */
    data: XOR<UserPermissionsUpdateManyMutationInput, UserPermissionsUncheckedUpdateManyInput>
    /**
     * Filter which UserPermissions to update
     */
    where?: UserPermissionsWhereInput
  }

  /**
   * UserPermissions upsert
   */
  export type UserPermissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * The filter to search for the UserPermissions to update in case it exists.
     */
    where: UserPermissionsWhereUniqueInput
    /**
     * In case the UserPermissions found by the `where` argument doesn't exist, create a new UserPermissions with this data.
     */
    create: XOR<UserPermissionsCreateInput, UserPermissionsUncheckedCreateInput>
    /**
     * In case the UserPermissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<UserPermissionsUpdateInput, UserPermissionsUncheckedUpdateInput>
  }

  /**
   * UserPermissions delete
   */
  export type UserPermissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
    /**
     * Filter which UserPermissions to delete.
     */
    where: UserPermissionsWhereUniqueInput
  }

  /**
   * UserPermissions deleteMany
   */
  export type UserPermissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which UserPermissions to delete
     */
    where?: UserPermissionsWhereInput
  }

  /**
   * UserPermissions without action
   */
  export type UserPermissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the UserPermissions
     */
    select?: UserPermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserPermissionsInclude<ExtArgs> | null
  }


  /**
   * Model RolePermissions
   */

  export type AggregateRolePermissions = {
    _count: RolePermissionsCountAggregateOutputType | null
    _avg: RolePermissionsAvgAggregateOutputType | null
    _sum: RolePermissionsSumAggregateOutputType | null
    _min: RolePermissionsMinAggregateOutputType | null
    _max: RolePermissionsMaxAggregateOutputType | null
  }

  export type RolePermissionsAvgAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsSumAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsMinAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsMaxAggregateOutputType = {
    role_id: number | null
    permission_id: number | null
    company_id: number | null
  }

  export type RolePermissionsCountAggregateOutputType = {
    role_id: number
    permission_id: number
    company_id: number
    _all: number
  }


  export type RolePermissionsAvgAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsSumAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsMinAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsMaxAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
  }

  export type RolePermissionsCountAggregateInputType = {
    role_id?: true
    permission_id?: true
    company_id?: true
    _all?: true
  }

  export type RolePermissionsAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RolePermissions to aggregate.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationInput | RolePermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned RolePermissions
    **/
    _count?: true | RolePermissionsCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: RolePermissionsAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: RolePermissionsSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: RolePermissionsMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: RolePermissionsMaxAggregateInputType
  }

  export type GetRolePermissionsAggregateType<T extends RolePermissionsAggregateArgs> = {
        [P in keyof T & keyof AggregateRolePermissions]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateRolePermissions[P]>
      : GetScalarType<T[P], AggregateRolePermissions[P]>
  }




  export type RolePermissionsGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: RolePermissionsWhereInput
    orderBy?: RolePermissionsOrderByWithAggregationInput | RolePermissionsOrderByWithAggregationInput[]
    by: RolePermissionsScalarFieldEnum[] | RolePermissionsScalarFieldEnum
    having?: RolePermissionsScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: RolePermissionsCountAggregateInputType | true
    _avg?: RolePermissionsAvgAggregateInputType
    _sum?: RolePermissionsSumAggregateInputType
    _min?: RolePermissionsMinAggregateInputType
    _max?: RolePermissionsMaxAggregateInputType
  }

  export type RolePermissionsGroupByOutputType = {
    role_id: number
    permission_id: number
    company_id: number
    _count: RolePermissionsCountAggregateOutputType | null
    _avg: RolePermissionsAvgAggregateOutputType | null
    _sum: RolePermissionsSumAggregateOutputType | null
    _min: RolePermissionsMinAggregateOutputType | null
    _max: RolePermissionsMaxAggregateOutputType | null
  }

  type GetRolePermissionsGroupByPayload<T extends RolePermissionsGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<RolePermissionsGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof RolePermissionsGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], RolePermissionsGroupByOutputType[P]>
            : GetScalarType<T[P], RolePermissionsGroupByOutputType[P]>
        }
      >
    >


  export type RolePermissionsSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    role_id?: boolean
    permission_id?: boolean
    company_id?: boolean
    role?: boolean | RoleDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["rolePermissions"]>

  export type RolePermissionsSelectScalar = {
    role_id?: boolean
    permission_id?: boolean
    company_id?: boolean
  }


  export type RolePermissionsInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    role?: boolean | RoleDefaultArgs<ExtArgs>
    permission?: boolean | PermissionsDefaultArgs<ExtArgs>
  }


  export type $RolePermissionsPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "RolePermissions"
    objects: {
      role: Prisma.$RolePayload<ExtArgs>
      permission: Prisma.$PermissionsPayload<ExtArgs>
    }
    scalars: $Extensions.GetPayloadResult<{
      role_id: number
      permission_id: number
      company_id: number
    }, ExtArgs["result"]["rolePermissions"]>
    composites: {}
  }


  type RolePermissionsGetPayload<S extends boolean | null | undefined | RolePermissionsDefaultArgs> = $Result.GetResult<Prisma.$RolePermissionsPayload, S>

  type RolePermissionsCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<RolePermissionsFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: RolePermissionsCountAggregateInputType | true
    }

  export interface RolePermissionsDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['RolePermissions'], meta: { name: 'RolePermissions' } }
    /**
     * Find zero or one RolePermissions that matches the filter.
     * @param {RolePermissionsFindUniqueArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends RolePermissionsFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsFindUniqueArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one RolePermissions that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {RolePermissionsFindUniqueOrThrowArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends RolePermissionsFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first RolePermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsFindFirstArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends RolePermissionsFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindFirstArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first RolePermissions that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsFindFirstOrThrowArgs} args - Arguments to find a RolePermissions
     * @example
     * // Get one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends RolePermissionsFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more RolePermissions that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findMany()
     * 
     * // Get first 10 RolePermissions
     * const rolePermissions = await prisma.rolePermissions.findMany({ take: 10 })
     * 
     * // Only select the `role_id`
     * const rolePermissionsWithRole_idOnly = await prisma.rolePermissions.findMany({ select: { role_id: true } })
     * 
    **/
    findMany<T extends RolePermissionsFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a RolePermissions.
     * @param {RolePermissionsCreateArgs} args - Arguments to create a RolePermissions.
     * @example
     * // Create one RolePermissions
     * const RolePermissions = await prisma.rolePermissions.create({
     *   data: {
     *     // ... data to create a RolePermissions
     *   }
     * })
     * 
    **/
    create<T extends RolePermissionsCreateArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsCreateArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many RolePermissions.
     * @param {RolePermissionsCreateManyArgs} args - Arguments to create many RolePermissions.
     * @example
     * // Create many RolePermissions
     * const rolePermissions = await prisma.rolePermissions.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends RolePermissionsCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many RolePermissions and returns the data saved in the database.
     * @param {RolePermissionsCreateManyAndReturnArgs} args - Arguments to create many RolePermissions.
     * @example
     * // Create many RolePermissions
     * const rolePermissions = await prisma.rolePermissions.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many RolePermissions and only return the `role_id`
     * const rolePermissionsWithRole_idOnly = await prisma.rolePermissions.createManyAndReturn({ 
     *   select: { role_id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends RolePermissionsCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a RolePermissions.
     * @param {RolePermissionsDeleteArgs} args - Arguments to delete one RolePermissions.
     * @example
     * // Delete one RolePermissions
     * const RolePermissions = await prisma.rolePermissions.delete({
     *   where: {
     *     // ... filter to delete one RolePermissions
     *   }
     * })
     * 
    **/
    delete<T extends RolePermissionsDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsDeleteArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one RolePermissions.
     * @param {RolePermissionsUpdateArgs} args - Arguments to update one RolePermissions.
     * @example
     * // Update one RolePermissions
     * const rolePermissions = await prisma.rolePermissions.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends RolePermissionsUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsUpdateArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more RolePermissions.
     * @param {RolePermissionsDeleteManyArgs} args - Arguments to filter RolePermissions to delete.
     * @example
     * // Delete a few RolePermissions
     * const { count } = await prisma.rolePermissions.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends RolePermissionsDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, RolePermissionsDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many RolePermissions
     * const rolePermissions = await prisma.rolePermissions.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends RolePermissionsUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one RolePermissions.
     * @param {RolePermissionsUpsertArgs} args - Arguments to update or create a RolePermissions.
     * @example
     * // Update or create a RolePermissions
     * const rolePermissions = await prisma.rolePermissions.upsert({
     *   create: {
     *     // ... data to create a RolePermissions
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the RolePermissions we want to update
     *   }
     * })
    **/
    upsert<T extends RolePermissionsUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, RolePermissionsUpsertArgs<ExtArgs>>
    ): Prisma__RolePermissionsClient<$Result.GetResult<Prisma.$RolePermissionsPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsCountArgs} args - Arguments to filter RolePermissions to count.
     * @example
     * // Count the number of RolePermissions
     * const count = await prisma.rolePermissions.count({
     *   where: {
     *     // ... the filter for the RolePermissions we want to count
     *   }
     * })
    **/
    count<T extends RolePermissionsCountArgs>(
      args?: Subset<T, RolePermissionsCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], RolePermissionsCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends RolePermissionsAggregateArgs>(args: Subset<T, RolePermissionsAggregateArgs>): Prisma.PrismaPromise<GetRolePermissionsAggregateType<T>>

    /**
     * Group by RolePermissions.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {RolePermissionsGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends RolePermissionsGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: RolePermissionsGroupByArgs['orderBy'] }
        : { orderBy?: RolePermissionsGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, RolePermissionsGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetRolePermissionsGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the RolePermissions model
   */
  readonly fields: RolePermissionsFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for RolePermissions.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__RolePermissionsClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    role<T extends RoleDefaultArgs<ExtArgs> = {}>(args?: Subset<T, RoleDefaultArgs<ExtArgs>>): Prisma__RoleClient<$Result.GetResult<Prisma.$RolePayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    permission<T extends PermissionsDefaultArgs<ExtArgs> = {}>(args?: Subset<T, PermissionsDefaultArgs<ExtArgs>>): Prisma__PermissionsClient<$Result.GetResult<Prisma.$PermissionsPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the RolePermissions model
   */ 
  interface RolePermissionsFieldRefs {
    readonly role_id: FieldRef<"RolePermissions", 'Int'>
    readonly permission_id: FieldRef<"RolePermissions", 'Int'>
    readonly company_id: FieldRef<"RolePermissions", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * RolePermissions findUnique
   */
  export type RolePermissionsFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions findUniqueOrThrow
   */
  export type RolePermissionsFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions findFirst
   */
  export type RolePermissionsFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationInput | RolePermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RolePermissions.
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RolePermissions.
     */
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * RolePermissions findFirstOrThrow
   */
  export type RolePermissionsFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationInput | RolePermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for RolePermissions.
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of RolePermissions.
     */
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * RolePermissions findMany
   */
  export type RolePermissionsFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter, which RolePermissions to fetch.
     */
    where?: RolePermissionsWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of RolePermissions to fetch.
     */
    orderBy?: RolePermissionsOrderByWithRelationInput | RolePermissionsOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing RolePermissions.
     */
    cursor?: RolePermissionsWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` RolePermissions from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` RolePermissions.
     */
    skip?: number
    distinct?: RolePermissionsScalarFieldEnum | RolePermissionsScalarFieldEnum[]
  }

  /**
   * RolePermissions create
   */
  export type RolePermissionsCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The data needed to create a RolePermissions.
     */
    data: XOR<RolePermissionsCreateInput, RolePermissionsUncheckedCreateInput>
  }

  /**
   * RolePermissions createMany
   */
  export type RolePermissionsCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many RolePermissions.
     */
    data: RolePermissionsCreateManyInput | RolePermissionsCreateManyInput[]
  }

  /**
   * RolePermissions createManyAndReturn
   */
  export type RolePermissionsCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The data used to create many RolePermissions.
     */
    data: RolePermissionsCreateManyInput | RolePermissionsCreateManyInput[]
  }

  /**
   * RolePermissions update
   */
  export type RolePermissionsUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The data needed to update a RolePermissions.
     */
    data: XOR<RolePermissionsUpdateInput, RolePermissionsUncheckedUpdateInput>
    /**
     * Choose, which RolePermissions to update.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions updateMany
   */
  export type RolePermissionsUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update RolePermissions.
     */
    data: XOR<RolePermissionsUpdateManyMutationInput, RolePermissionsUncheckedUpdateManyInput>
    /**
     * Filter which RolePermissions to update
     */
    where?: RolePermissionsWhereInput
  }

  /**
   * RolePermissions upsert
   */
  export type RolePermissionsUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * The filter to search for the RolePermissions to update in case it exists.
     */
    where: RolePermissionsWhereUniqueInput
    /**
     * In case the RolePermissions found by the `where` argument doesn't exist, create a new RolePermissions with this data.
     */
    create: XOR<RolePermissionsCreateInput, RolePermissionsUncheckedCreateInput>
    /**
     * In case the RolePermissions was found with the provided `where` argument, update it with this data.
     */
    update: XOR<RolePermissionsUpdateInput, RolePermissionsUncheckedUpdateInput>
  }

  /**
   * RolePermissions delete
   */
  export type RolePermissionsDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
    /**
     * Filter which RolePermissions to delete.
     */
    where: RolePermissionsWhereUniqueInput
  }

  /**
   * RolePermissions deleteMany
   */
  export type RolePermissionsDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which RolePermissions to delete
     */
    where?: RolePermissionsWhereInput
  }

  /**
   * RolePermissions without action
   */
  export type RolePermissionsDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the RolePermissions
     */
    select?: RolePermissionsSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: RolePermissionsInclude<ExtArgs> | null
  }


  /**
   * Model Language
   */

  export type AggregateLanguage = {
    _count: LanguageCountAggregateOutputType | null
    _avg: LanguageAvgAggregateOutputType | null
    _sum: LanguageSumAggregateOutputType | null
    _min: LanguageMinAggregateOutputType | null
    _max: LanguageMaxAggregateOutputType | null
  }

  export type LanguageAvgAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type LanguageSumAggregateOutputType = {
    id: number | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    transfer_status: number | null
  }

  export type LanguageMinAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    name_in_english: string | null
    flag: string | null
    code: string | null
    rtl: boolean | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type LanguageMaxAggregateOutputType = {
    id: number | null
    uuid: string | null
    name: string | null
    name_in_english: string | null
    flag: string | null
    code: string | null
    rtl: boolean | null
    description: string | null
    status_id: number | null
    company_id: number | null
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string | null
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
  }

  export type LanguageCountAggregateOutputType = {
    id: number
    uuid: number
    name: number
    name_in_english: number
    flag: number
    code: number
    rtl: number
    description: number
    status_id: number
    company_id: number
    created_by: number
    updated_by: number
    deleted_by: number
    created_at: number
    updated_at: number
    deleted_at: number
    transfer_status: number
    _all: number
  }


  export type LanguageAvgAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type LanguageSumAggregateInputType = {
    id?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    transfer_status?: true
  }

  export type LanguageMinAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    name_in_english?: true
    flag?: true
    code?: true
    rtl?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type LanguageMaxAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    name_in_english?: true
    flag?: true
    code?: true
    rtl?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
  }

  export type LanguageCountAggregateInputType = {
    id?: true
    uuid?: true
    name?: true
    name_in_english?: true
    flag?: true
    code?: true
    rtl?: true
    description?: true
    status_id?: true
    company_id?: true
    created_by?: true
    updated_by?: true
    deleted_by?: true
    created_at?: true
    updated_at?: true
    deleted_at?: true
    transfer_status?: true
    _all?: true
  }

  export type LanguageAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Language to aggregate.
     */
    where?: LanguageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Languages to fetch.
     */
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: LanguageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Languages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned Languages
    **/
    _count?: true | LanguageCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: LanguageAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: LanguageSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: LanguageMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: LanguageMaxAggregateInputType
  }

  export type GetLanguageAggregateType<T extends LanguageAggregateArgs> = {
        [P in keyof T & keyof AggregateLanguage]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateLanguage[P]>
      : GetScalarType<T[P], AggregateLanguage[P]>
  }




  export type LanguageGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageWhereInput
    orderBy?: LanguageOrderByWithAggregationInput | LanguageOrderByWithAggregationInput[]
    by: LanguageScalarFieldEnum[] | LanguageScalarFieldEnum
    having?: LanguageScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: LanguageCountAggregateInputType | true
    _avg?: LanguageAvgAggregateInputType
    _sum?: LanguageSumAggregateInputType
    _min?: LanguageMinAggregateInputType
    _max?: LanguageMaxAggregateInputType
  }

  export type LanguageGroupByOutputType = {
    id: number
    uuid: string
    name: string
    name_in_english: string | null
    flag: string | null
    code: string | null
    rtl: boolean
    description: string
    status_id: number
    company_id: number
    created_by: number | null
    updated_by: number | null
    deleted_by: number | null
    created_at: string
    updated_at: Date | null
    deleted_at: Date | null
    transfer_status: number | null
    _count: LanguageCountAggregateOutputType | null
    _avg: LanguageAvgAggregateOutputType | null
    _sum: LanguageSumAggregateOutputType | null
    _min: LanguageMinAggregateOutputType | null
    _max: LanguageMaxAggregateOutputType | null
  }

  type GetLanguageGroupByPayload<T extends LanguageGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<LanguageGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof LanguageGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], LanguageGroupByOutputType[P]>
            : GetScalarType<T[P], LanguageGroupByOutputType[P]>
        }
      >
    >


  export type LanguageSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    uuid?: boolean
    name?: boolean
    name_in_english?: boolean
    flag?: boolean
    code?: boolean
    rtl?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    translations?: boolean | Language$translationsArgs<ExtArgs>
    created?: boolean | Language$createdArgs<ExtArgs>
    updated?: boolean | Language$updatedArgs<ExtArgs>
    deleted?: boolean | Language$deletedArgs<ExtArgs>
    _count?: boolean | LanguageCountOutputTypeDefaultArgs<ExtArgs>
  }, ExtArgs["result"]["language"]>

  export type LanguageSelectScalar = {
    id?: boolean
    uuid?: boolean
    name?: boolean
    name_in_english?: boolean
    flag?: boolean
    code?: boolean
    rtl?: boolean
    description?: boolean
    status_id?: boolean
    company_id?: boolean
    created_by?: boolean
    updated_by?: boolean
    deleted_by?: boolean
    created_at?: boolean
    updated_at?: boolean
    deleted_at?: boolean
    transfer_status?: boolean
  }


  export type LanguageInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    translations?: boolean | Language$translationsArgs<ExtArgs>
    created?: boolean | Language$createdArgs<ExtArgs>
    updated?: boolean | Language$updatedArgs<ExtArgs>
    deleted?: boolean | Language$deletedArgs<ExtArgs>
    _count?: boolean | LanguageCountOutputTypeDefaultArgs<ExtArgs>
  }


  export type $LanguagePayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "Language"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      translations: Prisma.$LanguageContentPayload<ExtArgs>[]
      created: Prisma.$UserPayload<ExtArgs> | null
      updated: Prisma.$UserPayload<ExtArgs> | null
      deleted: Prisma.$UserPayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      uuid: string
      name: string
      name_in_english: string | null
      flag: string | null
      code: string | null
      rtl: boolean
      description: string
      status_id: number
      company_id: number
      created_by: number | null
      updated_by: number | null
      deleted_by: number | null
      created_at: string
      updated_at: Date | null
      deleted_at: Date | null
      transfer_status: number | null
    }, ExtArgs["result"]["language"]>
    composites: {}
  }


  type LanguageGetPayload<S extends boolean | null | undefined | LanguageDefaultArgs> = $Result.GetResult<Prisma.$LanguagePayload, S>

  type LanguageCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<LanguageFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: LanguageCountAggregateInputType | true
    }

  export interface LanguageDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['Language'], meta: { name: 'Language' } }
    /**
     * Find zero or one Language that matches the filter.
     * @param {LanguageFindUniqueArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends LanguageFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageFindUniqueArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one Language that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {LanguageFindUniqueOrThrowArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends LanguageFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first Language that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageFindFirstArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends LanguageFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageFindFirstArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first Language that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageFindFirstOrThrowArgs} args - Arguments to find a Language
     * @example
     * // Get one Language
     * const language = await prisma.language.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends LanguageFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more Languages that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all Languages
     * const languages = await prisma.language.findMany()
     * 
     * // Get first 10 Languages
     * const languages = await prisma.language.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const languageWithIdOnly = await prisma.language.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends LanguageFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a Language.
     * @param {LanguageCreateArgs} args - Arguments to create a Language.
     * @example
     * // Create one Language
     * const Language = await prisma.language.create({
     *   data: {
     *     // ... data to create a Language
     *   }
     * })
     * 
    **/
    create<T extends LanguageCreateArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageCreateArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many Languages.
     * @param {LanguageCreateManyArgs} args - Arguments to create many Languages.
     * @example
     * // Create many Languages
     * const language = await prisma.language.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends LanguageCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many Languages and returns the data saved in the database.
     * @param {LanguageCreateManyAndReturnArgs} args - Arguments to create many Languages.
     * @example
     * // Create many Languages
     * const language = await prisma.language.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many Languages and only return the `id`
     * const languageWithIdOnly = await prisma.language.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends LanguageCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a Language.
     * @param {LanguageDeleteArgs} args - Arguments to delete one Language.
     * @example
     * // Delete one Language
     * const Language = await prisma.language.delete({
     *   where: {
     *     // ... filter to delete one Language
     *   }
     * })
     * 
    **/
    delete<T extends LanguageDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageDeleteArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one Language.
     * @param {LanguageUpdateArgs} args - Arguments to update one Language.
     * @example
     * // Update one Language
     * const language = await prisma.language.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends LanguageUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageUpdateArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more Languages.
     * @param {LanguageDeleteManyArgs} args - Arguments to filter Languages to delete.
     * @example
     * // Delete a few Languages
     * const { count } = await prisma.language.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends LanguageDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more Languages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many Languages
     * const language = await prisma.language.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends LanguageUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one Language.
     * @param {LanguageUpsertArgs} args - Arguments to update or create a Language.
     * @example
     * // Update or create a Language
     * const language = await prisma.language.upsert({
     *   create: {
     *     // ... data to create a Language
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the Language we want to update
     *   }
     * })
    **/
    upsert<T extends LanguageUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageUpsertArgs<ExtArgs>>
    ): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of Languages.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageCountArgs} args - Arguments to filter Languages to count.
     * @example
     * // Count the number of Languages
     * const count = await prisma.language.count({
     *   where: {
     *     // ... the filter for the Languages we want to count
     *   }
     * })
    **/
    count<T extends LanguageCountArgs>(
      args?: Subset<T, LanguageCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], LanguageCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a Language.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends LanguageAggregateArgs>(args: Subset<T, LanguageAggregateArgs>): Prisma.PrismaPromise<GetLanguageAggregateType<T>>

    /**
     * Group by Language.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends LanguageGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: LanguageGroupByArgs['orderBy'] }
        : { orderBy?: LanguageGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, LanguageGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetLanguageGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the Language model
   */
  readonly fields: LanguageFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for Language.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__LanguageClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    translations<T extends Language$translationsArgs<ExtArgs> = {}>(args?: Subset<T, Language$translationsArgs<ExtArgs>>): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findMany'> | Null>;

    created<T extends Language$createdArgs<ExtArgs> = {}>(args?: Subset<T, Language$createdArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    updated<T extends Language$updatedArgs<ExtArgs> = {}>(args?: Subset<T, Language$updatedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    deleted<T extends Language$deletedArgs<ExtArgs> = {}>(args?: Subset<T, Language$deletedArgs<ExtArgs>>): Prisma__UserClient<$Result.GetResult<Prisma.$UserPayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the Language model
   */ 
  interface LanguageFieldRefs {
    readonly id: FieldRef<"Language", 'Int'>
    readonly uuid: FieldRef<"Language", 'String'>
    readonly name: FieldRef<"Language", 'String'>
    readonly name_in_english: FieldRef<"Language", 'String'>
    readonly flag: FieldRef<"Language", 'String'>
    readonly code: FieldRef<"Language", 'String'>
    readonly rtl: FieldRef<"Language", 'Boolean'>
    readonly description: FieldRef<"Language", 'String'>
    readonly status_id: FieldRef<"Language", 'Int'>
    readonly company_id: FieldRef<"Language", 'Int'>
    readonly created_by: FieldRef<"Language", 'Int'>
    readonly updated_by: FieldRef<"Language", 'Int'>
    readonly deleted_by: FieldRef<"Language", 'Int'>
    readonly created_at: FieldRef<"Language", 'String'>
    readonly updated_at: FieldRef<"Language", 'DateTime'>
    readonly deleted_at: FieldRef<"Language", 'DateTime'>
    readonly transfer_status: FieldRef<"Language", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * Language findUnique
   */
  export type LanguageFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * Filter, which Language to fetch.
     */
    where: LanguageWhereUniqueInput
  }

  /**
   * Language findUniqueOrThrow
   */
  export type LanguageFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * Filter, which Language to fetch.
     */
    where: LanguageWhereUniqueInput
  }

  /**
   * Language findFirst
   */
  export type LanguageFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * Filter, which Language to fetch.
     */
    where?: LanguageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Languages to fetch.
     */
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Languages.
     */
    cursor?: LanguageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Languages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Languages.
     */
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * Language findFirstOrThrow
   */
  export type LanguageFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * Filter, which Language to fetch.
     */
    where?: LanguageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Languages to fetch.
     */
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for Languages.
     */
    cursor?: LanguageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Languages.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of Languages.
     */
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * Language findMany
   */
  export type LanguageFindManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * Filter, which Languages to fetch.
     */
    where?: LanguageWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of Languages to fetch.
     */
    orderBy?: LanguageOrderByWithRelationInput | LanguageOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for listing Languages.
     */
    cursor?: LanguageWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` Languages from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` Languages.
     */
    skip?: number
    distinct?: LanguageScalarFieldEnum | LanguageScalarFieldEnum[]
  }

  /**
   * Language create
   */
  export type LanguageCreateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * The data needed to create a Language.
     */
    data: XOR<LanguageCreateInput, LanguageUncheckedCreateInput>
  }

  /**
   * Language createMany
   */
  export type LanguageCreateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to create many Languages.
     */
    data: LanguageCreateManyInput | LanguageCreateManyInput[]
  }

  /**
   * Language createManyAndReturn
   */
  export type LanguageCreateManyAndReturnArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * The data used to create many Languages.
     */
    data: LanguageCreateManyInput | LanguageCreateManyInput[]
  }

  /**
   * Language update
   */
  export type LanguageUpdateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * The data needed to update a Language.
     */
    data: XOR<LanguageUpdateInput, LanguageUncheckedUpdateInput>
    /**
     * Choose, which Language to update.
     */
    where: LanguageWhereUniqueInput
  }

  /**
   * Language updateMany
   */
  export type LanguageUpdateManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * The data used to update Languages.
     */
    data: XOR<LanguageUpdateManyMutationInput, LanguageUncheckedUpdateManyInput>
    /**
     * Filter which Languages to update
     */
    where?: LanguageWhereInput
  }

  /**
   * Language upsert
   */
  export type LanguageUpsertArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * The filter to search for the Language to update in case it exists.
     */
    where: LanguageWhereUniqueInput
    /**
     * In case the Language found by the `where` argument doesn't exist, create a new Language with this data.
     */
    create: XOR<LanguageCreateInput, LanguageUncheckedCreateInput>
    /**
     * In case the Language was found with the provided `where` argument, update it with this data.
     */
    update: XOR<LanguageUpdateInput, LanguageUncheckedUpdateInput>
  }

  /**
   * Language delete
   */
  export type LanguageDeleteArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
    /**
     * Filter which Language to delete.
     */
    where: LanguageWhereUniqueInput
  }

  /**
   * Language deleteMany
   */
  export type LanguageDeleteManyArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which Languages to delete
     */
    where?: LanguageWhereInput
  }

  /**
   * Language.translations
   */
  export type Language$translationsArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageContent
     */
    select?: LanguageContentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageContentInclude<ExtArgs> | null
    where?: LanguageContentWhereInput
    orderBy?: LanguageContentOrderByWithRelationInput | LanguageContentOrderByWithRelationInput[]
    cursor?: LanguageContentWhereUniqueInput
    take?: number
    skip?: number
    distinct?: LanguageContentScalarFieldEnum | LanguageContentScalarFieldEnum[]
  }

  /**
   * Language.created
   */
  export type Language$createdArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Language.updated
   */
  export type Language$updatedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Language.deleted
   */
  export type Language$deletedArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the User
     */
    select?: UserSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: UserInclude<ExtArgs> | null
    where?: UserWhereInput
  }

  /**
   * Language without action
   */
  export type LanguageDefaultArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the Language
     */
    select?: LanguageSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageInclude<ExtArgs> | null
  }


  /**
   * Model LanguageContent
   */

  export type AggregateLanguageContent = {
    _count: LanguageContentCountAggregateOutputType | null
    _avg: LanguageContentAvgAggregateOutputType | null
    _sum: LanguageContentSumAggregateOutputType | null
    _min: LanguageContentMinAggregateOutputType | null
    _max: LanguageContentMaxAggregateOutputType | null
  }

  export type LanguageContentAvgAggregateOutputType = {
    id: number | null
    language_id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type LanguageContentSumAggregateOutputType = {
    id: number | null
    language_id: number | null
    status_id: number | null
    company_id: number | null
    transfer_status: number | null
  }

  export type LanguageContentMinAggregateOutputType = {
    id: number | null
    language_id: number | null
    key_content: string | null
    values: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type LanguageContentMaxAggregateOutputType = {
    id: number | null
    language_id: number | null
    key_content: string | null
    values: string | null
    status_id: number | null
    company_id: number | null
    created_at: string | null
    transfer_status: number | null
  }

  export type LanguageContentCountAggregateOutputType = {
    id: number
    language_id: number
    key_content: number
    values: number
    status_id: number
    company_id: number
    created_at: number
    transfer_status: number
    _all: number
  }


  export type LanguageContentAvgAggregateInputType = {
    id?: true
    language_id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type LanguageContentSumAggregateInputType = {
    id?: true
    language_id?: true
    status_id?: true
    company_id?: true
    transfer_status?: true
  }

  export type LanguageContentMinAggregateInputType = {
    id?: true
    language_id?: true
    key_content?: true
    values?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type LanguageContentMaxAggregateInputType = {
    id?: true
    language_id?: true
    key_content?: true
    values?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
  }

  export type LanguageContentCountAggregateInputType = {
    id?: true
    language_id?: true
    key_content?: true
    values?: true
    status_id?: true
    company_id?: true
    created_at?: true
    transfer_status?: true
    _all?: true
  }

  export type LanguageContentAggregateArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Filter which LanguageContent to aggregate.
     */
    where?: LanguageContentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of LanguageContents to fetch.
     */
    orderBy?: LanguageContentOrderByWithRelationInput | LanguageContentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the start position
     */
    cursor?: LanguageContentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` LanguageContents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` LanguageContents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Count returned LanguageContents
    **/
    _count?: true | LanguageContentCountAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to average
    **/
    _avg?: LanguageContentAvgAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to sum
    **/
    _sum?: LanguageContentSumAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the minimum value
    **/
    _min?: LanguageContentMinAggregateInputType
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/aggregations Aggregation Docs}
     * 
     * Select which fields to find the maximum value
    **/
    _max?: LanguageContentMaxAggregateInputType
  }

  export type GetLanguageContentAggregateType<T extends LanguageContentAggregateArgs> = {
        [P in keyof T & keyof AggregateLanguageContent]: P extends '_count' | 'count'
      ? T[P] extends true
        ? number
        : GetScalarType<T[P], AggregateLanguageContent[P]>
      : GetScalarType<T[P], AggregateLanguageContent[P]>
  }




  export type LanguageContentGroupByArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    where?: LanguageContentWhereInput
    orderBy?: LanguageContentOrderByWithAggregationInput | LanguageContentOrderByWithAggregationInput[]
    by: LanguageContentScalarFieldEnum[] | LanguageContentScalarFieldEnum
    having?: LanguageContentScalarWhereWithAggregatesInput
    take?: number
    skip?: number
    _count?: LanguageContentCountAggregateInputType | true
    _avg?: LanguageContentAvgAggregateInputType
    _sum?: LanguageContentSumAggregateInputType
    _min?: LanguageContentMinAggregateInputType
    _max?: LanguageContentMaxAggregateInputType
  }

  export type LanguageContentGroupByOutputType = {
    id: number
    language_id: number
    key_content: string
    values: string
    status_id: number
    company_id: number
    created_at: string
    transfer_status: number | null
    _count: LanguageContentCountAggregateOutputType | null
    _avg: LanguageContentAvgAggregateOutputType | null
    _sum: LanguageContentSumAggregateOutputType | null
    _min: LanguageContentMinAggregateOutputType | null
    _max: LanguageContentMaxAggregateOutputType | null
  }

  type GetLanguageContentGroupByPayload<T extends LanguageContentGroupByArgs> = Prisma.PrismaPromise<
    Array<
      PickEnumerable<LanguageContentGroupByOutputType, T['by']> &
        {
          [P in ((keyof T) & (keyof LanguageContentGroupByOutputType))]: P extends '_count'
            ? T[P] extends boolean
              ? number
              : GetScalarType<T[P], LanguageContentGroupByOutputType[P]>
            : GetScalarType<T[P], LanguageContentGroupByOutputType[P]>
        }
      >
    >


  export type LanguageContentSelect<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = $Extensions.GetSelect<{
    id?: boolean
    language_id?: boolean
    key_content?: boolean
    values?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
    status?: boolean | StatusDefaultArgs<ExtArgs>
    language?: boolean | LanguageContent$languageArgs<ExtArgs>
  }, ExtArgs["result"]["languageContent"]>

  export type LanguageContentSelectScalar = {
    id?: boolean
    language_id?: boolean
    key_content?: boolean
    values?: boolean
    status_id?: boolean
    company_id?: boolean
    created_at?: boolean
    transfer_status?: boolean
  }


  export type LanguageContentInclude<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    status?: boolean | StatusDefaultArgs<ExtArgs>
    language?: boolean | LanguageContent$languageArgs<ExtArgs>
  }


  export type $LanguageContentPayload<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    name: "LanguageContent"
    objects: {
      status: Prisma.$StatusPayload<ExtArgs>
      language: Prisma.$LanguagePayload<ExtArgs> | null
    }
    scalars: $Extensions.GetPayloadResult<{
      id: number
      language_id: number
      key_content: string
      values: string
      status_id: number
      company_id: number
      created_at: string
      transfer_status: number | null
    }, ExtArgs["result"]["languageContent"]>
    composites: {}
  }


  type LanguageContentGetPayload<S extends boolean | null | undefined | LanguageContentDefaultArgs> = $Result.GetResult<Prisma.$LanguageContentPayload, S>

  type LanguageContentCountArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = 
    Omit<LanguageContentFindManyArgs, 'select' | 'include' | 'distinct'> & {
      select?: LanguageContentCountAggregateInputType | true
    }

  export interface LanguageContentDelegate<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> {
    [K: symbol]: { types: Prisma.TypeMap<ExtArgs>['model']['LanguageContent'], meta: { name: 'LanguageContent' } }
    /**
     * Find zero or one LanguageContent that matches the filter.
     * @param {LanguageContentFindUniqueArgs} args - Arguments to find a LanguageContent
     * @example
     * // Get one LanguageContent
     * const languageContent = await prisma.languageContent.findUnique({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUnique<T extends LanguageContentFindUniqueArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageContentFindUniqueArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findUnique'> | null, null, ExtArgs>

    /**
     * Find one LanguageContent that matches the filter or throw an error with `error.code='P2025'` 
     * if no matches were found.
     * @param {LanguageContentFindUniqueOrThrowArgs} args - Arguments to find a LanguageContent
     * @example
     * // Get one LanguageContent
     * const languageContent = await prisma.languageContent.findUniqueOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findUniqueOrThrow<T extends LanguageContentFindUniqueOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentFindUniqueOrThrowArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findUniqueOrThrow'>, never, ExtArgs>

    /**
     * Find the first LanguageContent that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentFindFirstArgs} args - Arguments to find a LanguageContent
     * @example
     * // Get one LanguageContent
     * const languageContent = await prisma.languageContent.findFirst({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirst<T extends LanguageContentFindFirstArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentFindFirstArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findFirst'> | null, null, ExtArgs>

    /**
     * Find the first LanguageContent that matches the filter or
     * throw `PrismaKnownClientError` with `P2025` code if no matches were found.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentFindFirstOrThrowArgs} args - Arguments to find a LanguageContent
     * @example
     * // Get one LanguageContent
     * const languageContent = await prisma.languageContent.findFirstOrThrow({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
    **/
    findFirstOrThrow<T extends LanguageContentFindFirstOrThrowArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentFindFirstOrThrowArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findFirstOrThrow'>, never, ExtArgs>

    /**
     * Find zero or more LanguageContents that matches the filter.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentFindManyArgs} args - Arguments to filter and select certain fields only.
     * @example
     * // Get all LanguageContents
     * const languageContents = await prisma.languageContent.findMany()
     * 
     * // Get first 10 LanguageContents
     * const languageContents = await prisma.languageContent.findMany({ take: 10 })
     * 
     * // Only select the `id`
     * const languageContentWithIdOnly = await prisma.languageContent.findMany({ select: { id: true } })
     * 
    **/
    findMany<T extends LanguageContentFindManyArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentFindManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'findMany'>>

    /**
     * Create a LanguageContent.
     * @param {LanguageContentCreateArgs} args - Arguments to create a LanguageContent.
     * @example
     * // Create one LanguageContent
     * const LanguageContent = await prisma.languageContent.create({
     *   data: {
     *     // ... data to create a LanguageContent
     *   }
     * })
     * 
    **/
    create<T extends LanguageContentCreateArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageContentCreateArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'create'>, never, ExtArgs>

    /**
     * Create many LanguageContents.
     * @param {LanguageContentCreateManyArgs} args - Arguments to create many LanguageContents.
     * @example
     * // Create many LanguageContents
     * const languageContent = await prisma.languageContent.createMany({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     *     
    **/
    createMany<T extends LanguageContentCreateManyArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentCreateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create many LanguageContents and returns the data saved in the database.
     * @param {LanguageContentCreateManyAndReturnArgs} args - Arguments to create many LanguageContents.
     * @example
     * // Create many LanguageContents
     * const languageContent = await prisma.languageContent.createManyAndReturn({
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * 
     * // Create many LanguageContents and only return the `id`
     * const languageContentWithIdOnly = await prisma.languageContent.createManyAndReturn({ 
     *   select: { id: true },
     *   data: [
     *     // ... provide data here
     *   ]
     * })
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * 
    **/
    createManyAndReturn<T extends LanguageContentCreateManyAndReturnArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentCreateManyAndReturnArgs<ExtArgs>>
    ): Prisma.PrismaPromise<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'createManyAndReturn'>>

    /**
     * Delete a LanguageContent.
     * @param {LanguageContentDeleteArgs} args - Arguments to delete one LanguageContent.
     * @example
     * // Delete one LanguageContent
     * const LanguageContent = await prisma.languageContent.delete({
     *   where: {
     *     // ... filter to delete one LanguageContent
     *   }
     * })
     * 
    **/
    delete<T extends LanguageContentDeleteArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageContentDeleteArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'delete'>, never, ExtArgs>

    /**
     * Update one LanguageContent.
     * @param {LanguageContentUpdateArgs} args - Arguments to update one LanguageContent.
     * @example
     * // Update one LanguageContent
     * const languageContent = await prisma.languageContent.update({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    update<T extends LanguageContentUpdateArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageContentUpdateArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'update'>, never, ExtArgs>

    /**
     * Delete zero or more LanguageContents.
     * @param {LanguageContentDeleteManyArgs} args - Arguments to filter LanguageContents to delete.
     * @example
     * // Delete a few LanguageContents
     * const { count } = await prisma.languageContent.deleteMany({
     *   where: {
     *     // ... provide filter here
     *   }
     * })
     * 
    **/
    deleteMany<T extends LanguageContentDeleteManyArgs<ExtArgs>>(
      args?: SelectSubset<T, LanguageContentDeleteManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Update zero or more LanguageContents.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentUpdateManyArgs} args - Arguments to update one or more rows.
     * @example
     * // Update many LanguageContents
     * const languageContent = await prisma.languageContent.updateMany({
     *   where: {
     *     // ... provide filter here
     *   },
     *   data: {
     *     // ... provide data here
     *   }
     * })
     * 
    **/
    updateMany<T extends LanguageContentUpdateManyArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageContentUpdateManyArgs<ExtArgs>>
    ): Prisma.PrismaPromise<BatchPayload>

    /**
     * Create or update one LanguageContent.
     * @param {LanguageContentUpsertArgs} args - Arguments to update or create a LanguageContent.
     * @example
     * // Update or create a LanguageContent
     * const languageContent = await prisma.languageContent.upsert({
     *   create: {
     *     // ... data to create a LanguageContent
     *   },
     *   update: {
     *     // ... in case it already exists, update
     *   },
     *   where: {
     *     // ... the filter for the LanguageContent we want to update
     *   }
     * })
    **/
    upsert<T extends LanguageContentUpsertArgs<ExtArgs>>(
      args: SelectSubset<T, LanguageContentUpsertArgs<ExtArgs>>
    ): Prisma__LanguageContentClient<$Result.GetResult<Prisma.$LanguageContentPayload<ExtArgs>, T, 'upsert'>, never, ExtArgs>

    /**
     * Count the number of LanguageContents.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentCountArgs} args - Arguments to filter LanguageContents to count.
     * @example
     * // Count the number of LanguageContents
     * const count = await prisma.languageContent.count({
     *   where: {
     *     // ... the filter for the LanguageContents we want to count
     *   }
     * })
    **/
    count<T extends LanguageContentCountArgs>(
      args?: Subset<T, LanguageContentCountArgs>,
    ): Prisma.PrismaPromise<
      T extends $Utils.Record<'select', any>
        ? T['select'] extends true
          ? number
          : GetScalarType<T['select'], LanguageContentCountAggregateOutputType>
        : number
    >

    /**
     * Allows you to perform aggregations operations on a LanguageContent.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentAggregateArgs} args - Select which aggregations you would like to apply and on what fields.
     * @example
     * // Ordered by age ascending
     * // Where email contains prisma.io
     * // Limited to the 10 users
     * const aggregations = await prisma.user.aggregate({
     *   _avg: {
     *     age: true,
     *   },
     *   where: {
     *     email: {
     *       contains: "prisma.io",
     *     },
     *   },
     *   orderBy: {
     *     age: "asc",
     *   },
     *   take: 10,
     * })
    **/
    aggregate<T extends LanguageContentAggregateArgs>(args: Subset<T, LanguageContentAggregateArgs>): Prisma.PrismaPromise<GetLanguageContentAggregateType<T>>

    /**
     * Group by LanguageContent.
     * Note, that providing `undefined` is treated as the value not being there.
     * Read more here: https://pris.ly/d/null-undefined
     * @param {LanguageContentGroupByArgs} args - Group by arguments.
     * @example
     * // Group by city, order by createdAt, get count
     * const result = await prisma.user.groupBy({
     *   by: ['city', 'createdAt'],
     *   orderBy: {
     *     createdAt: true
     *   },
     *   _count: {
     *     _all: true
     *   },
     * })
     * 
    **/
    groupBy<
      T extends LanguageContentGroupByArgs,
      HasSelectOrTake extends Or<
        Extends<'skip', Keys<T>>,
        Extends<'take', Keys<T>>
      >,
      OrderByArg extends True extends HasSelectOrTake
        ? { orderBy: LanguageContentGroupByArgs['orderBy'] }
        : { orderBy?: LanguageContentGroupByArgs['orderBy'] },
      OrderFields extends ExcludeUnderscoreKeys<Keys<MaybeTupleToUnion<T['orderBy']>>>,
      ByFields extends MaybeTupleToUnion<T['by']>,
      ByValid extends Has<ByFields, OrderFields>,
      HavingFields extends GetHavingFields<T['having']>,
      HavingValid extends Has<ByFields, HavingFields>,
      ByEmpty extends T['by'] extends never[] ? True : False,
      InputErrors extends ByEmpty extends True
      ? `Error: "by" must not be empty.`
      : HavingValid extends False
      ? {
          [P in HavingFields]: P extends ByFields
            ? never
            : P extends string
            ? `Error: Field "${P}" used in "having" needs to be provided in "by".`
            : [
                Error,
                'Field ',
                P,
                ` in "having" needs to be provided in "by"`,
              ]
        }[HavingFields]
      : 'take' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "take", you also need to provide "orderBy"'
      : 'skip' extends Keys<T>
      ? 'orderBy' extends Keys<T>
        ? ByValid extends True
          ? {}
          : {
              [P in OrderFields]: P extends ByFields
                ? never
                : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
            }[OrderFields]
        : 'Error: If you provide "skip", you also need to provide "orderBy"'
      : ByValid extends True
      ? {}
      : {
          [P in OrderFields]: P extends ByFields
            ? never
            : `Error: Field "${P}" in "orderBy" needs to be provided in "by"`
        }[OrderFields]
    >(args: SubsetIntersection<T, LanguageContentGroupByArgs, OrderByArg> & InputErrors): {} extends InputErrors ? GetLanguageContentGroupByPayload<T> : Prisma.PrismaPromise<InputErrors>
  /**
   * Fields of the LanguageContent model
   */
  readonly fields: LanguageContentFieldRefs;
  }

  /**
   * The delegate class that acts as a "Promise-like" for LanguageContent.
   * Why is this prefixed with `Prisma__`?
   * Because we want to prevent naming conflicts as mentioned in
   * https://github.com/prisma/prisma-client-js/issues/707
   */
  export interface Prisma__LanguageContentClient<T, Null = never, ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> extends Prisma.PrismaPromise<T> {
    readonly [Symbol.toStringTag]: 'PrismaPromise';

    status<T extends StatusDefaultArgs<ExtArgs> = {}>(args?: Subset<T, StatusDefaultArgs<ExtArgs>>): Prisma__StatusClient<$Result.GetResult<Prisma.$StatusPayload<ExtArgs>, T, 'findUniqueOrThrow'> | Null, Null, ExtArgs>;

    language<T extends LanguageContent$languageArgs<ExtArgs> = {}>(args?: Subset<T, LanguageContent$languageArgs<ExtArgs>>): Prisma__LanguageClient<$Result.GetResult<Prisma.$LanguagePayload<ExtArgs>, T, 'findUniqueOrThrow'> | null, null, ExtArgs>;

    /**
     * Attaches callbacks for the resolution and/or rejection of the Promise.
     * @param onfulfilled The callback to execute when the Promise is resolved.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of which ever callback is executed.
     */
    then<TResult1 = T, TResult2 = never>(onfulfilled?: ((value: T) => TResult1 | PromiseLike<TResult1>) | undefined | null, onrejected?: ((reason: any) => TResult2 | PromiseLike<TResult2>) | undefined | null): $Utils.JsPromise<TResult1 | TResult2>;
    /**
     * Attaches a callback for only the rejection of the Promise.
     * @param onrejected The callback to execute when the Promise is rejected.
     * @returns A Promise for the completion of the callback.
     */
    catch<TResult = never>(onrejected?: ((reason: any) => TResult | PromiseLike<TResult>) | undefined | null): $Utils.JsPromise<T | TResult>;
    /**
     * Attaches a callback that is invoked when the Promise is settled (fulfilled or rejected). The
     * resolved value cannot be modified from the callback.
     * @param onfinally The callback to execute when the Promise is settled (fulfilled or rejected).
     * @returns A Promise for the completion of the callback.
     */
    finally(onfinally?: (() => void) | undefined | null): $Utils.JsPromise<T>;
  }



  /**
   * Fields of the LanguageContent model
   */ 
  interface LanguageContentFieldRefs {
    readonly id: FieldRef<"LanguageContent", 'Int'>
    readonly language_id: FieldRef<"LanguageContent", 'Int'>
    readonly key_content: FieldRef<"LanguageContent", 'String'>
    readonly values: FieldRef<"LanguageContent", 'String'>
    readonly status_id: FieldRef<"LanguageContent", 'Int'>
    readonly company_id: FieldRef<"LanguageContent", 'Int'>
    readonly created_at: FieldRef<"LanguageContent", 'String'>
    readonly transfer_status: FieldRef<"LanguageContent", 'Int'>
  }
    

  // Custom InputTypes
  /**
   * LanguageContent findUnique
   */
  export type LanguageContentFindUniqueArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageContent
     */
    select?: LanguageContentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageContentInclude<ExtArgs> | null
    /**
     * Filter, which LanguageContent to fetch.
     */
    where: LanguageContentWhereUniqueInput
  }

  /**
   * LanguageContent findUniqueOrThrow
   */
  export type LanguageContentFindUniqueOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageContent
     */
    select?: LanguageContentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageContentInclude<ExtArgs> | null
    /**
     * Filter, which LanguageContent to fetch.
     */
    where: LanguageContentWhereUniqueInput
  }

  /**
   * LanguageContent findFirst
   */
  export type LanguageContentFindFirstArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageContent
     */
    select?: LanguageContentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageContentInclude<ExtArgs> | null
    /**
     * Filter, which LanguageContent to fetch.
     */
    where?: LanguageContentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of LanguageContents to fetch.
     */
    orderBy?: LanguageContentOrderByWithRelationInput | LanguageContentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for LanguageContents.
     */
    cursor?: LanguageContentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` LanguageContents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` LanguageContents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/distinct Distinct Docs}
     * 
     * Filter by unique combinations of LanguageContents.
     */
    distinct?: LanguageContentScalarFieldEnum | LanguageContentScalarFieldEnum[]
  }

  /**
   * LanguageContent findFirstOrThrow
   */
  export type LanguageContentFindFirstOrThrowArgs<ExtArgs extends $Extensions.InternalArgs = $Extensions.DefaultArgs> = {
    /**
     * Select specific fields to fetch from the LanguageContent
     */
    select?: LanguageContentSelect<ExtArgs> | null
    /**
     * Choose, which related nodes to fetch as well
     */
    include?: LanguageContentInclude<ExtArgs> | null
    /**
     * Filter, which LanguageContent to fetch.
     */
    where?: LanguageContentWhereInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/sorting Sorting Docs}
     * 
     * Determine the order of LanguageContents to fetch.
     */
    orderBy?: LanguageContentOrderByWithRelationInput | LanguageContentOrderByWithRelationInput[]
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination#cursor-based-pagination Cursor Docs}
     * 
     * Sets the position for searching for LanguageContents.
     */
    cursor?: LanguageContentWhereUniqueInput
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Take `±n` LanguageContents from the position of the cursor.
     */
    take?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/components/prisma-client/pagination Pagination Docs}
     * 
     * Skip the first `n` LanguageContents.
     */
    skip?: number
    /**
     * {@link https://www.prisma.io/docs/concepts/co